const core = require('@sentry/core');
const node = require('@sentry/node');
const electron = require('electron');
const electronNormalize = require('../electron-normalize.js');

/**
 * Starts a worker thread to detect App Not Responding (ANR) events
 *
 * @deprecated The ANR integration has been deprecated. Use `eventLoopBlockIntegration` from `@sentry/electron/native`
 * instead. You will need to install `@sentry/node-native` as a dependency.
 */
const anrIntegration = core.defineIntegration((options = {}) => {
    if (electronNormalize.ELECTRON_MAJOR_VERSION < 22) {
        throw new Error('Main process ANR detection requires Electron v22+');
    }
    // eslint-disable-next-line deprecation/deprecation
    const integration = node.anrIntegration({
        ...options,
        staticTags: {
            'event.environment': 'javascript',
            'event.origin': 'electron',
            'event.process': 'browser',
            ...options.staticTags,
        },
        appRootPath: electron.app.getAppPath(),
    });
    electron.powerMonitor.on('suspend', () => {
        integration.stopWorker();
    });
    electron.powerMonitor.on('lock-screen', () => {
        integration.stopWorker();
    });
    electron.powerMonitor.on('resume', () => {
        integration.startWorker();
    });
    electron.powerMonitor.on('unlock-screen', () => {
        integration.startWorker();
    });
    return integration;
});

exports.anrIntegration = anrIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/0aab11a4598c8cf51c251d5df1cf581ee65f9d20/node_modules/@sentry/electron/main/integrations/anr.js.map
