"use strict";
exports.id = 8657;
exports.ids = [8657];
exports.modules = {

/***/ "../../node_modules/.pnpm/@zed-industries+agent-client-protocol@0.4.5/node_modules/@zed-industries/agent-client-protocol/dist/acp.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  Bi: () => (/* binding */ AgentSideConnection),
  WP: () => (/* reexport */ PROTOCOL_VERSION),
  GI: () => (/* binding */ RequestError),
  Z2: () => (/* reexport */ ndJsonStream)
});

// UNUSED EXPORTS: AGENT_METHODS, CLIENT_METHODS, ClientSideConnection, TerminalHandle, agentCapabilitiesSchema, agentClientProtocolSchema, agentNotificationSchema, agentRequestSchema, agentResponseSchema, annotationsSchema, authMethodSchema, authenticateRequestSchema, authenticateResponseSchema, availableCommandInputSchema, availableCommandSchema, blobResourceContentsSchema, cancelNotificationSchema, clientCapabilitiesSchema, clientNotificationSchema, clientRequestSchema, clientResponseSchema, contentBlockSchema, createTerminalRequestSchema, createTerminalResponseSchema, embeddedResourceResourceSchema, envVariableSchema, extMethodRequest1Schema, extMethodRequestSchema, extMethodResponse1Schema, extMethodResponseSchema, extNotification1Schema, extNotificationSchema, fileSystemCapabilitySchema, httpHeaderSchema, initializeRequestSchema, initializeResponseSchema, killTerminalCommandRequestSchema, killTerminalResponseSchema, loadSessionRequestSchema, loadSessionResponseSchema, mcpCapabilitiesSchema, mcpServerSchema, modelInfoSchema, newSessionRequestSchema, newSessionResponseSchema, permissionOptionSchema, planEntrySchema, promptCapabilitiesSchema, promptRequestSchema, promptResponseSchema, readTextFileRequestSchema, readTextFileResponseSchema, releaseTerminalRequestSchema, releaseTerminalResponseSchema, requestPermissionRequestSchema, requestPermissionResponseSchema, roleSchema, sessionModeIdSchema, sessionModeSchema, sessionModeStateSchema, sessionModelStateSchema, sessionNotificationSchema, setSessionModeRequestSchema, setSessionModeResponseSchema, setSessionModelRequestSchema, setSessionModelResponseSchema, stdioSchema, terminalExitStatusSchema, terminalOutputRequestSchema, terminalOutputResponseSchema, textResourceContentsSchema, toolCallContentSchema, toolCallLocationSchema, toolCallStatusSchema, toolCallUpdateSchema, toolKindSchema, unstructuredCommandInputSchema, waitForTerminalExitRequestSchema, waitForTerminalExitResponseSchema, writeTextFileRequestSchema, writeTextFileResponseSchema

// EXTERNAL MODULE: ../../node_modules/.pnpm/zod@3.24.2/node_modules/zod/lib/index.mjs
var lib = __webpack_require__("../../node_modules/.pnpm/zod@3.24.2/node_modules/zod/lib/index.mjs");
;// ../../node_modules/.pnpm/@zed-industries+agent-client-protocol@0.4.5/node_modules/@zed-industries/agent-client-protocol/dist/schema.js
const AGENT_METHODS = {
    authenticate: "authenticate",
    initialize: "initialize",
    session_cancel: "session/cancel",
    session_load: "session/load",
    session_new: "session/new",
    session_prompt: "session/prompt",
    session_set_mode: "session/set_mode",
    session_set_model: "session/set_model",
};
const CLIENT_METHODS = {
    fs_read_text_file: "fs/read_text_file",
    fs_write_text_file: "fs/write_text_file",
    session_request_permission: "session/request_permission",
    session_update: "session/update",
    terminal_create: "terminal/create",
    terminal_kill: "terminal/kill",
    terminal_output: "terminal/output",
    terminal_release: "terminal/release",
    terminal_wait_for_exit: "terminal/wait_for_exit",
};
const PROTOCOL_VERSION = 1;

/** @internal */
const writeTextFileRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    content: lib.z.string(),
    path: lib.z.string(),
    sessionId: lib.z.string(),
});
/** @internal */
const readTextFileRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    limit: lib.z.number().optional().nullable(),
    line: lib.z.number().optional().nullable(),
    path: lib.z.string(),
    sessionId: lib.z.string(),
});
/** @internal */
const terminalOutputRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    sessionId: lib.z.string(),
    terminalId: lib.z.string(),
});
/** @internal */
const releaseTerminalRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    sessionId: lib.z.string(),
    terminalId: lib.z.string(),
});
/** @internal */
const waitForTerminalExitRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    sessionId: lib.z.string(),
    terminalId: lib.z.string(),
});
/** @internal */
const killTerminalCommandRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    sessionId: lib.z.string(),
    terminalId: lib.z.string(),
});
/** @internal */
const extMethodRequestSchema = lib.z.record(lib.z.unknown());
/** @internal */
const roleSchema = lib.z.union([lib.z.literal("assistant"), lib.z.literal("user")]);
/** @internal */
const textResourceContentsSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    mimeType: lib.z.string().optional().nullable(),
    text: lib.z.string(),
    uri: lib.z.string(),
});
/** @internal */
const blobResourceContentsSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    blob: lib.z.string(),
    mimeType: lib.z.string().optional().nullable(),
    uri: lib.z.string(),
});
/** @internal */
const toolKindSchema = lib.z.union([
    lib.z.literal("read"),
    lib.z.literal("edit"),
    lib.z.literal("delete"),
    lib.z.literal("move"),
    lib.z.literal("search"),
    lib.z.literal("execute"),
    lib.z.literal("think"),
    lib.z.literal("fetch"),
    lib.z.literal("switch_mode"),
    lib.z.literal("other"),
]);
/** @internal */
const toolCallStatusSchema = lib.z.union([
    lib.z.literal("pending"),
    lib.z.literal("in_progress"),
    lib.z.literal("completed"),
    lib.z.literal("failed"),
]);
/** @internal */
const writeTextFileResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
});
/** @internal */
const readTextFileResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    content: lib.z.string(),
});
/** @internal */
const requestPermissionResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    outcome: lib.z.union([
        lib.z.object({
            outcome: lib.z.literal("cancelled"),
        }),
        lib.z.object({
            optionId: lib.z.string(),
            outcome: lib.z.literal("selected"),
        }),
    ]),
});
/** @internal */
const createTerminalResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    terminalId: lib.z.string(),
});
/** @internal */
const releaseTerminalResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
});
/** @internal */
const waitForTerminalExitResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    exitCode: lib.z.number().optional().nullable(),
    signal: lib.z.string().optional().nullable(),
});
/** @internal */
const killTerminalResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
});
/** @internal */
const extMethodResponseSchema = lib.z.record(lib.z.unknown());
/** @internal */
const cancelNotificationSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    sessionId: lib.z.string(),
});
/** @internal */
const extNotificationSchema = lib.z.record(lib.z.unknown());
/** @internal */
const authenticateRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    methodId: lib.z.string(),
});
/** @internal */
const setSessionModeRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    modeId: lib.z.string(),
    sessionId: lib.z.string(),
});
/** @internal */
const setSessionModelRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    modelId: lib.z.string(),
    sessionId: lib.z.string(),
});
/** @internal */
const extMethodRequest1Schema = lib.z.record(lib.z.unknown());
/** @internal */
const httpHeaderSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    name: lib.z.string(),
    value: lib.z.string(),
});
/** @internal */
const annotationsSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    audience: lib.z.array(roleSchema).optional().nullable(),
    lastModified: lib.z.string().optional().nullable(),
    priority: lib.z.number().optional().nullable(),
});
/** @internal */
const embeddedResourceResourceSchema = lib.z.union([
    textResourceContentsSchema,
    blobResourceContentsSchema,
]);
/** @internal */
const authenticateResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
});
/** @internal */
const setSessionModeResponseSchema = lib.z.object({
    meta: lib.z.unknown().optional(),
});
/** @internal */
const promptResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    stopReason: lib.z.union([
        lib.z.literal("end_turn"),
        lib.z.literal("max_tokens"),
        lib.z.literal("max_turn_requests"),
        lib.z.literal("refusal"),
        lib.z.literal("cancelled"),
    ]),
});
/** @internal */
const setSessionModelResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
});
/** @internal */
const extMethodResponse1Schema = lib.z.record(lib.z.unknown());
/** @internal */
const sessionModeIdSchema = lib.z.string();
/** @internal */
const extNotification1Schema = lib.z.record(lib.z.unknown());
/** @internal */
const unstructuredCommandInputSchema = lib.z.object({
    hint: lib.z.string(),
});
/** @internal */
const permissionOptionSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    kind: lib.z.union([
        lib.z.literal("allow_once"),
        lib.z.literal("allow_always"),
        lib.z.literal("reject_once"),
        lib.z.literal("reject_always"),
    ]),
    name: lib.z.string(),
    optionId: lib.z.string(),
});
/** @internal */
const toolCallContentSchema = lib.z.union([
    lib.z.object({
        content: lib.z.union([
            lib.z.object({
                _meta: lib.z.record(lib.z.unknown()).optional(),
                annotations: annotationsSchema.optional().nullable(),
                text: lib.z.string(),
                type: lib.z.literal("text"),
            }),
            lib.z.object({
                _meta: lib.z.record(lib.z.unknown()).optional(),
                annotations: annotationsSchema.optional().nullable(),
                data: lib.z.string(),
                mimeType: lib.z.string(),
                type: lib.z.literal("image"),
                uri: lib.z.string().optional().nullable(),
            }),
            lib.z.object({
                _meta: lib.z.record(lib.z.unknown()).optional(),
                annotations: annotationsSchema.optional().nullable(),
                data: lib.z.string(),
                mimeType: lib.z.string(),
                type: lib.z.literal("audio"),
            }),
            lib.z.object({
                _meta: lib.z.record(lib.z.unknown()).optional(),
                annotations: annotationsSchema.optional().nullable(),
                description: lib.z.string().optional().nullable(),
                mimeType: lib.z.string().optional().nullable(),
                name: lib.z.string(),
                size: lib.z.number().optional().nullable(),
                title: lib.z.string().optional().nullable(),
                type: lib.z.literal("resource_link"),
                uri: lib.z.string(),
            }),
            lib.z.object({
                _meta: lib.z.record(lib.z.unknown()).optional(),
                annotations: annotationsSchema.optional().nullable(),
                resource: embeddedResourceResourceSchema,
                type: lib.z.literal("resource"),
            }),
        ]),
        type: lib.z.literal("content"),
    }),
    lib.z.object({
        _meta: lib.z.record(lib.z.unknown()).optional(),
        newText: lib.z.string(),
        oldText: lib.z.string().optional().nullable(),
        path: lib.z.string(),
        type: lib.z.literal("diff"),
    }),
    lib.z.object({
        terminalId: lib.z.string(),
        type: lib.z.literal("terminal"),
    }),
]);
/** @internal */
const toolCallLocationSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    line: lib.z.number().optional().nullable(),
    path: lib.z.string(),
});
/** @internal */
const envVariableSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    name: lib.z.string(),
    value: lib.z.string(),
});
/** @internal */
const terminalExitStatusSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    exitCode: lib.z.number().optional().nullable(),
    signal: lib.z.string().optional().nullable(),
});
/** @internal */
const fileSystemCapabilitySchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    readTextFile: lib.z.boolean().optional(),
    writeTextFile: lib.z.boolean().optional(),
});
/** @internal */
const stdioSchema = lib.z.object({
    args: lib.z.array(lib.z.string()),
    command: lib.z.string(),
    env: lib.z.array(envVariableSchema),
    name: lib.z.string(),
});
/** @internal */
const mcpServerSchema = lib.z.union([
    lib.z.object({
        headers: lib.z.array(httpHeaderSchema),
        name: lib.z.string(),
        type: lib.z.literal("http"),
        url: lib.z.string(),
    }),
    lib.z.object({
        headers: lib.z.array(httpHeaderSchema),
        name: lib.z.string(),
        type: lib.z.literal("sse"),
        url: lib.z.string(),
    }),
    stdioSchema,
]);
/** @internal */
const contentBlockSchema = lib.z.union([
    lib.z.object({
        _meta: lib.z.record(lib.z.unknown()).optional(),
        annotations: annotationsSchema.optional().nullable(),
        text: lib.z.string(),
        type: lib.z.literal("text"),
    }),
    lib.z.object({
        _meta: lib.z.record(lib.z.unknown()).optional(),
        annotations: annotationsSchema.optional().nullable(),
        data: lib.z.string(),
        mimeType: lib.z.string(),
        type: lib.z.literal("image"),
        uri: lib.z.string().optional().nullable(),
    }),
    lib.z.object({
        _meta: lib.z.record(lib.z.unknown()).optional(),
        annotations: annotationsSchema.optional().nullable(),
        data: lib.z.string(),
        mimeType: lib.z.string(),
        type: lib.z.literal("audio"),
    }),
    lib.z.object({
        _meta: lib.z.record(lib.z.unknown()).optional(),
        annotations: annotationsSchema.optional().nullable(),
        description: lib.z.string().optional().nullable(),
        mimeType: lib.z.string().optional().nullable(),
        name: lib.z.string(),
        size: lib.z.number().optional().nullable(),
        title: lib.z.string().optional().nullable(),
        type: lib.z.literal("resource_link"),
        uri: lib.z.string(),
    }),
    lib.z.object({
        _meta: lib.z.record(lib.z.unknown()).optional(),
        annotations: annotationsSchema.optional().nullable(),
        resource: embeddedResourceResourceSchema,
        type: lib.z.literal("resource"),
    }),
]);
/** @internal */
const authMethodSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    description: lib.z.string().optional().nullable(),
    id: lib.z.string(),
    name: lib.z.string(),
});
/** @internal */
const mcpCapabilitiesSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    http: lib.z.boolean().optional(),
    sse: lib.z.boolean().optional(),
});
/** @internal */
const promptCapabilitiesSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    audio: lib.z.boolean().optional(),
    embeddedContext: lib.z.boolean().optional(),
    image: lib.z.boolean().optional(),
});
/** @internal */
const modelInfoSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    description: lib.z.string().optional().nullable(),
    modelId: lib.z.string(),
    name: lib.z.string(),
});
/** @internal */
const sessionModeSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    description: lib.z.string().optional().nullable(),
    id: sessionModeIdSchema,
    name: lib.z.string(),
});
/** @internal */
const sessionModelStateSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    availableModels: lib.z.array(modelInfoSchema),
    currentModelId: lib.z.string(),
});
/** @internal */
const sessionModeStateSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    availableModes: lib.z.array(sessionModeSchema),
    currentModeId: lib.z.string(),
});
/** @internal */
const planEntrySchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    content: lib.z.string(),
    priority: lib.z.union([lib.z.literal("high"), lib.z.literal("medium"), lib.z.literal("low")]),
    status: lib.z.union([
        lib.z.literal("pending"),
        lib.z.literal("in_progress"),
        lib.z.literal("completed"),
    ]),
});
/** @internal */
const availableCommandInputSchema = unstructuredCommandInputSchema;
/** @internal */
const clientNotificationSchema = lib.z.union([
    cancelNotificationSchema,
    extNotificationSchema,
]);
/** @internal */
const createTerminalRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    args: lib.z.array(lib.z.string()).optional(),
    command: lib.z.string(),
    cwd: lib.z.string().optional().nullable(),
    env: lib.z.array(envVariableSchema).optional(),
    outputByteLimit: lib.z.number().optional().nullable(),
    sessionId: lib.z.string(),
});
/** @internal */
const terminalOutputResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    exitStatus: terminalExitStatusSchema.optional().nullable(),
    output: lib.z.string(),
    truncated: lib.z.boolean(),
});
/** @internal */
const newSessionRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    cwd: lib.z.string(),
    mcpServers: lib.z.array(mcpServerSchema),
});
/** @internal */
const loadSessionRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    cwd: lib.z.string(),
    mcpServers: lib.z.array(mcpServerSchema),
    sessionId: lib.z.string(),
});
/** @internal */
const promptRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    prompt: lib.z.array(contentBlockSchema),
    sessionId: lib.z.string(),
});
/** @internal */
const newSessionResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    models: sessionModelStateSchema.optional().nullable(),
    modes: sessionModeStateSchema.optional().nullable(),
    sessionId: lib.z.string(),
});
/** @internal */
const loadSessionResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    models: sessionModelStateSchema.optional().nullable(),
    modes: sessionModeStateSchema.optional().nullable(),
});
/** @internal */
const toolCallUpdateSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    content: lib.z.array(toolCallContentSchema).optional().nullable(),
    kind: toolKindSchema.optional().nullable(),
    locations: lib.z.array(toolCallLocationSchema).optional().nullable(),
    rawInput: lib.z.record(lib.z.unknown()).optional(),
    rawOutput: lib.z.record(lib.z.unknown()).optional(),
    status: toolCallStatusSchema.optional().nullable(),
    title: lib.z.string().optional().nullable(),
    toolCallId: lib.z.string(),
});
/** @internal */
const clientCapabilitiesSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    fs: fileSystemCapabilitySchema.optional(),
    terminal: lib.z.boolean().optional(),
});
/** @internal */
const agentCapabilitiesSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    loadSession: lib.z.boolean().optional(),
    mcpCapabilities: mcpCapabilitiesSchema.optional(),
    promptCapabilities: promptCapabilitiesSchema.optional(),
});
/** @internal */
const availableCommandSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    description: lib.z.string(),
    input: availableCommandInputSchema.optional().nullable(),
    name: lib.z.string(),
});
/** @internal */
const clientResponseSchema = lib.z.union([
    writeTextFileResponseSchema,
    readTextFileResponseSchema,
    requestPermissionResponseSchema,
    createTerminalResponseSchema,
    terminalOutputResponseSchema,
    releaseTerminalResponseSchema,
    waitForTerminalExitResponseSchema,
    killTerminalResponseSchema,
    extMethodResponseSchema,
]);
/** @internal */
const requestPermissionRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    options: lib.z.array(permissionOptionSchema),
    sessionId: lib.z.string(),
    toolCall: toolCallUpdateSchema,
});
/** @internal */
const initializeRequestSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    clientCapabilities: clientCapabilitiesSchema.optional(),
    protocolVersion: lib.z.number(),
});
/** @internal */
const initializeResponseSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    agentCapabilities: agentCapabilitiesSchema.optional(),
    authMethods: lib.z.array(authMethodSchema).optional(),
    protocolVersion: lib.z.number(),
});
/** @internal */
const sessionNotificationSchema = lib.z.object({
    _meta: lib.z.record(lib.z.unknown()).optional(),
    sessionId: lib.z.string(),
    update: lib.z.union([
        lib.z.object({
            content: contentBlockSchema,
            sessionUpdate: lib.z.literal("user_message_chunk"),
        }),
        lib.z.object({
            content: contentBlockSchema,
            sessionUpdate: lib.z.literal("agent_message_chunk"),
        }),
        lib.z.object({
            content: contentBlockSchema,
            sessionUpdate: lib.z.literal("agent_thought_chunk"),
        }),
        lib.z.object({
            _meta: lib.z.record(lib.z.unknown()).optional(),
            content: lib.z.array(toolCallContentSchema).optional(),
            kind: lib.z
                .union([
                lib.z.literal("read"),
                lib.z.literal("edit"),
                lib.z.literal("delete"),
                lib.z.literal("move"),
                lib.z.literal("search"),
                lib.z.literal("execute"),
                lib.z.literal("think"),
                lib.z.literal("fetch"),
                lib.z.literal("switch_mode"),
                lib.z.literal("other"),
            ])
                .optional(),
            locations: lib.z.array(toolCallLocationSchema).optional(),
            rawInput: lib.z.record(lib.z.unknown()).optional(),
            rawOutput: lib.z.record(lib.z.unknown()).optional(),
            sessionUpdate: lib.z.literal("tool_call"),
            status: lib.z
                .union([
                lib.z.literal("pending"),
                lib.z.literal("in_progress"),
                lib.z.literal("completed"),
                lib.z.literal("failed"),
            ])
                .optional(),
            title: lib.z.string(),
            toolCallId: lib.z.string(),
        }),
        lib.z.object({
            _meta: lib.z.record(lib.z.unknown()).optional(),
            content: lib.z.array(toolCallContentSchema).optional().nullable(),
            kind: toolKindSchema.optional().nullable(),
            locations: lib.z.array(toolCallLocationSchema).optional().nullable(),
            rawInput: lib.z.record(lib.z.unknown()).optional(),
            rawOutput: lib.z.record(lib.z.unknown()).optional(),
            sessionUpdate: lib.z.literal("tool_call_update"),
            status: toolCallStatusSchema.optional().nullable(),
            title: lib.z.string().optional().nullable(),
            toolCallId: lib.z.string(),
        }),
        lib.z.object({
            _meta: lib.z.record(lib.z.unknown()).optional(),
            entries: lib.z.array(planEntrySchema),
            sessionUpdate: lib.z.literal("plan"),
        }),
        lib.z.object({
            availableCommands: lib.z.array(availableCommandSchema),
            sessionUpdate: lib.z.literal("available_commands_update"),
        }),
        lib.z.object({
            currentModeId: sessionModeIdSchema,
            sessionUpdate: lib.z.literal("current_mode_update"),
        }),
    ]),
});
/** @internal */
const clientRequestSchema = lib.z.union([
    writeTextFileRequestSchema,
    readTextFileRequestSchema,
    requestPermissionRequestSchema,
    createTerminalRequestSchema,
    terminalOutputRequestSchema,
    releaseTerminalRequestSchema,
    waitForTerminalExitRequestSchema,
    killTerminalCommandRequestSchema,
    extMethodRequestSchema,
]);
/** @internal */
const agentRequestSchema = lib.z.union([
    initializeRequestSchema,
    authenticateRequestSchema,
    newSessionRequestSchema,
    loadSessionRequestSchema,
    setSessionModeRequestSchema,
    promptRequestSchema,
    setSessionModelRequestSchema,
    extMethodRequest1Schema,
]);
/** @internal */
const agentResponseSchema = lib.z.union([
    initializeResponseSchema,
    authenticateResponseSchema,
    newSessionResponseSchema,
    loadSessionResponseSchema,
    setSessionModeResponseSchema,
    promptResponseSchema,
    setSessionModelResponseSchema,
    extMethodResponse1Schema,
]);
/** @internal */
const agentNotificationSchema = lib.z.union([
    sessionNotificationSchema,
    extNotification1Schema,
]);
/** @internal */
const agentClientProtocolSchema = lib.z.union([
    clientRequestSchema,
    clientResponseSchema,
    clientNotificationSchema,
    agentRequestSchema,
    agentResponseSchema,
    agentNotificationSchema,
]);
//# sourceMappingURL=schema.js.map
;// ../../node_modules/.pnpm/@zed-industries+agent-client-protocol@0.4.5/node_modules/@zed-industries/agent-client-protocol/dist/stream.js
/**
 * Creates an ACP Stream from a pair of newline-delimited JSON streams.
 *
 * This is the typical way to handle ACP connections over stdio, converting
 * between AnyMessage objects and newline-delimited JSON.
 *
 * @param output - The writable stream to send encoded messages to
 * @param input - The readable stream to receive encoded messages from
 * @returns A Stream for bidirectional ACP communication
 */
function ndJsonStream(output, input) {
    const textEncoder = new TextEncoder();
    const textDecoder = new TextDecoder();
    const readable = new ReadableStream({
        async start(controller) {
            let content = "";
            const reader = input.getReader();
            try {
                while (true) {
                    const { value, done } = await reader.read();
                    if (done) {
                        break;
                    }
                    if (!value) {
                        continue;
                    }
                    content += textDecoder.decode(value, { stream: true });
                    const lines = content.split("\n");
                    content = lines.pop() || "";
                    for (const line of lines) {
                        const trimmedLine = line.trim();
                        if (trimmedLine) {
                            try {
                                const message = JSON.parse(trimmedLine);
                                controller.enqueue(message);
                            }
                            catch (err) {
                                console.error("Failed to parse JSON message:", trimmedLine, err);
                            }
                        }
                    }
                }
            }
            finally {
                reader.releaseLock();
                controller.close();
            }
        },
    });
    const writable = new WritableStream({
        async write(message) {
            const content = JSON.stringify(message) + "\n";
            const writer = output.getWriter();
            try {
                await writer.write(textEncoder.encode(content));
            }
            finally {
                writer.releaseLock();
            }
        },
    });
    return { readable, writable };
}
//# sourceMappingURL=stream.js.map
;// ../../node_modules/.pnpm/@zed-industries+agent-client-protocol@0.4.5/node_modules/@zed-industries/agent-client-protocol/dist/acp.js




/**
 * An agent-side connection to a client.
 *
 * This class provides the agent's view of an ACP connection, allowing
 * agents to communicate with clients. It implements the {@link Client} interface
 * to provide methods for requesting permissions, accessing the file system,
 * and sending session updates.
 *
 * See protocol docs: [Agent](https://agentclientprotocol.com/protocol/overview#agent)
 */
class AgentSideConnection {
    #connection;
    /**
     * Creates a new agent-side connection to a client.
     *
     * This establishes the communication channel from the agent's perspective
     * following the ACP specification.
     *
     * @param toAgent - A function that creates an Agent handler to process incoming client requests
     * @param stream - The bidirectional message stream for communication. Typically created using
     *                 {@link ndJsonStream} for stdio-based connections.
     *
     * See protocol docs: [Communication Model](https://agentclientprotocol.com/protocol/overview#communication-model)
     */
    constructor(toAgent, stream) {
        const agent = toAgent(this);
        const requestHandler = async (method, params) => {
            switch (method) {
                case AGENT_METHODS.initialize: {
                    const validatedParams = initializeRequestSchema.parse(params);
                    return agent.initialize(validatedParams);
                }
                case AGENT_METHODS.session_new: {
                    const validatedParams = newSessionRequestSchema.parse(params);
                    return agent.newSession(validatedParams);
                }
                case AGENT_METHODS.session_load: {
                    if (!agent.loadSession) {
                        throw RequestError.methodNotFound(method);
                    }
                    const validatedParams = loadSessionRequestSchema.parse(params);
                    return agent.loadSession(validatedParams);
                }
                case AGENT_METHODS.session_set_mode: {
                    if (!agent.setSessionMode) {
                        throw RequestError.methodNotFound(method);
                    }
                    const validatedParams = setSessionModeRequestSchema.parse(params);
                    const result = await agent.setSessionMode(validatedParams);
                    return result ?? {};
                }
                case AGENT_METHODS.authenticate: {
                    const validatedParams = authenticateRequestSchema.parse(params);
                    const result = await agent.authenticate(validatedParams);
                    return result ?? {};
                }
                case AGENT_METHODS.session_prompt: {
                    const validatedParams = promptRequestSchema.parse(params);
                    return agent.prompt(validatedParams);
                }
                case AGENT_METHODS.session_set_model: {
                    if (!agent.setSessionModel) {
                        throw RequestError.methodNotFound(method);
                    }
                    const validatedParams = setSessionModelRequestSchema.parse(params);
                    return agent.setSessionModel(validatedParams);
                }
                default:
                    if (method.startsWith("_")) {
                        if (!agent.extMethod) {
                            throw RequestError.methodNotFound(method);
                        }
                        return agent.extMethod(method.substring(1), params);
                    }
                    throw RequestError.methodNotFound(method);
            }
        };
        const notificationHandler = async (method, params) => {
            switch (method) {
                case AGENT_METHODS.session_cancel: {
                    const validatedParams = cancelNotificationSchema.parse(params);
                    return agent.cancel(validatedParams);
                }
                default:
                    if (method.startsWith("_")) {
                        if (!agent.extNotification) {
                            return;
                        }
                        return agent.extNotification(method.substring(1), params);
                    }
                    throw RequestError.methodNotFound(method);
            }
        };
        this.#connection = new Connection(requestHandler, notificationHandler, stream);
    }
    /**
     * Handles session update notifications from the agent.
     *
     * This is a notification endpoint (no response expected) that sends
     * real-time updates about session progress, including message chunks,
     * tool calls, and execution plans.
     *
     * Note: Clients SHOULD continue accepting tool call updates even after
     * sending a `session/cancel` notification, as the agent may send final
     * updates before responding with the cancelled stop reason.
     *
     * See protocol docs: [Agent Reports Output](https://agentclientprotocol.com/protocol/prompt-turn#3-agent-reports-output)
     */
    async sessionUpdate(params) {
        return await this.#connection.sendNotification(CLIENT_METHODS.session_update, params);
    }
    /**
     * Requests permission from the user for a tool call operation.
     *
     * Called by the agent when it needs user authorization before executing
     * a potentially sensitive operation. The client should present the options
     * to the user and return their decision.
     *
     * If the client cancels the prompt turn via `session/cancel`, it MUST
     * respond to this request with `RequestPermissionOutcome::Cancelled`.
     *
     * See protocol docs: [Requesting Permission](https://agentclientprotocol.com/protocol/tool-calls#requesting-permission)
     */
    async requestPermission(params) {
        return await this.#connection.sendRequest(CLIENT_METHODS.session_request_permission, params);
    }
    /**
     * Reads content from a text file in the client's file system.
     *
     * Only available if the client advertises the `fs.readTextFile` capability.
     * Allows the agent to access file contents within the client's environment.
     *
     * See protocol docs: [Client](https://agentclientprotocol.com/protocol/overview#client)
     */
    async readTextFile(params) {
        return await this.#connection.sendRequest(CLIENT_METHODS.fs_read_text_file, params);
    }
    /**
     * Writes content to a text file in the client's file system.
     *
     * Only available if the client advertises the `fs.writeTextFile` capability.
     * Allows the agent to create or modify files within the client's environment.
     *
     * See protocol docs: [Client](https://agentclientprotocol.com/protocol/overview#client)
     */
    async writeTextFile(params) {
        return ((await this.#connection.sendRequest(CLIENT_METHODS.fs_write_text_file, params)) ?? {});
    }
    /**
     * Executes a command in a new terminal.
     *
     * Returns a `TerminalHandle` that can be used to get output, wait for exit,
     * kill the command, or release the terminal.
     *
     * The terminal can also be embedded in tool calls by using its ID in
     * `ToolCallContent` with type "terminal".
     *
     * @param params - The terminal creation parameters
     * @returns A handle to control and monitor the terminal
     */
    async createTerminal(params) {
        const response = await this.#connection.sendRequest(CLIENT_METHODS.terminal_create, params);
        return new TerminalHandle(response.terminalId, params.sessionId, this.#connection);
    }
    /**
     * Extension method
     *
     * Allows the Agent to send an arbitrary request that is not part of the ACP spec.
     */
    async extMethod(method, params) {
        return await this.#connection.sendRequest(`_${method}`, params);
    }
    /**
     * Extension notification
     *
     * Allows the Agent to send an arbitrary notification that is not part of the ACP spec.
     */
    async extNotification(method, params) {
        return await this.#connection.sendNotification(`_${method}`, params);
    }
}
/**
 * Handle for controlling and monitoring a terminal created via `createTerminal`.
 *
 * Provides methods to:
 * - Get current output without waiting
 * - Wait for command completion
 * - Kill the running command
 * - Release terminal resources
 *
 * **Important:** Always call `release()` when done with the terminal to free resources.

 * The terminal supports async disposal via `Symbol.asyncDispose` for automatic cleanup.

 * You can use `await using` to ensure the terminal is automatically released when it
 * goes out of scope.
 */
class TerminalHandle {
    id;
    #sessionId;
    #connection;
    constructor(id, sessionId, conn) {
        this.id = id;
        this.#sessionId = sessionId;
        this.#connection = conn;
    }
    /**
     * Gets the current terminal output without waiting for the command to exit.
     */
    async currentOutput() {
        return await this.#connection.sendRequest(CLIENT_METHODS.terminal_output, {
            sessionId: this.#sessionId,
            terminalId: this.id,
        });
    }
    /**
     * Waits for the terminal command to complete and returns its exit status.
     */
    async waitForExit() {
        return await this.#connection.sendRequest(CLIENT_METHODS.terminal_wait_for_exit, {
            sessionId: this.#sessionId,
            terminalId: this.id,
        });
    }
    /**
     * Kills the terminal command without releasing the terminal.
     *
     * The terminal remains valid after killing, allowing you to:
     * - Get the final output with `currentOutput()`
     * - Check the exit status
     * - Release the terminal when done
     *
     * Useful for implementing timeouts or cancellation.
     */
    async kill() {
        return ((await this.#connection.sendRequest(CLIENT_METHODS.terminal_kill, {
            sessionId: this.#sessionId,
            terminalId: this.id,
        })) ?? {});
    }
    /**
     * Releases the terminal and frees all associated resources.
     *
     * If the command is still running, it will be killed.
     * After release, the terminal ID becomes invalid and cannot be used
     * with other terminal methods.
     *
     * Tool calls that already reference this terminal will continue to
     * display its output.
     *
     * **Important:** Always call this method when done with the terminal.
     */
    async release() {
        return ((await this.#connection.sendRequest(CLIENT_METHODS.terminal_release, {
            sessionId: this.#sessionId,
            terminalId: this.id,
        })) ?? {});
    }
    async [Symbol.asyncDispose]() {
        await this.release();
    }
}
/**
 * A client-side connection to an agent.
 *
 * This class provides the client's view of an ACP connection, allowing
 * clients (such as code editors) to communicate with agents. It implements
 * the {@link Agent} interface to provide methods for initializing sessions, sending
 * prompts, and managing the agent lifecycle.
 *
 * See protocol docs: [Client](https://agentclientprotocol.com/protocol/overview#client)
 */
class ClientSideConnection {
    #connection;
    /**
     * Creates a new client-side connection to an agent.
     *
     * This establishes the communication channel between a client and agent
     * following the ACP specification.
     *
     * @param toClient - A function that creates a Client handler to process incoming agent requests
     * @param stream - The bidirectional message stream for communication. Typically created using
     *                 {@link ndJsonStream} for stdio-based connections.
     *
     * See protocol docs: [Communication Model](https://agentclientprotocol.com/protocol/overview#communication-model)
     */
    constructor(toClient, stream) {
        const client = toClient(this);
        const requestHandler = async (method, params) => {
            switch (method) {
                case schema.CLIENT_METHODS.fs_write_text_file: {
                    const validatedParams = schema.writeTextFileRequestSchema.parse(params);
                    return client.writeTextFile?.(validatedParams);
                }
                case schema.CLIENT_METHODS.fs_read_text_file: {
                    const validatedParams = schema.readTextFileRequestSchema.parse(params);
                    return client.readTextFile?.(validatedParams);
                }
                case schema.CLIENT_METHODS.session_request_permission: {
                    const validatedParams = schema.requestPermissionRequestSchema.parse(params);
                    return client.requestPermission(validatedParams);
                }
                case schema.CLIENT_METHODS.terminal_create: {
                    const validatedParams = schema.createTerminalRequestSchema.parse(params);
                    return client.createTerminal?.(validatedParams);
                }
                case schema.CLIENT_METHODS.terminal_output: {
                    const validatedParams = schema.terminalOutputRequestSchema.parse(params);
                    return client.terminalOutput?.(validatedParams);
                }
                case schema.CLIENT_METHODS.terminal_release: {
                    const validatedParams = schema.releaseTerminalRequestSchema.parse(params);
                    const result = await client.releaseTerminal?.(validatedParams);
                    return result ?? {};
                }
                case schema.CLIENT_METHODS.terminal_wait_for_exit: {
                    const validatedParams = schema.waitForTerminalExitRequestSchema.parse(params);
                    return client.waitForTerminalExit?.(validatedParams);
                }
                case schema.CLIENT_METHODS.terminal_kill: {
                    const validatedParams = schema.killTerminalCommandRequestSchema.parse(params);
                    const result = await client.killTerminal?.(validatedParams);
                    return result ?? {};
                }
                default:
                    // Handle extension methods (any method starting with '_')
                    if (method.startsWith("_")) {
                        const customMethod = method.substring(1);
                        if (!client.extMethod) {
                            throw RequestError.methodNotFound(method);
                        }
                        return client.extMethod(customMethod, params);
                    }
                    throw RequestError.methodNotFound(method);
            }
        };
        const notificationHandler = async (method, params) => {
            switch (method) {
                case schema.CLIENT_METHODS.session_update: {
                    const validatedParams = schema.sessionNotificationSchema.parse(params);
                    return client.sessionUpdate(validatedParams);
                }
                default:
                    // Handle extension notifications (any method starting with '_')
                    if (method.startsWith("_")) {
                        const customMethod = method.substring(1);
                        if (!client.extNotification) {
                            return;
                        }
                        return client.extNotification(customMethod, params);
                    }
                    throw RequestError.methodNotFound(method);
            }
        };
        this.#connection = new Connection(requestHandler, notificationHandler, stream);
    }
    /**
     * Establishes the connection with a client and negotiates protocol capabilities.
     *
     * This method is called once at the beginning of the connection to:
     * - Negotiate the protocol version to use
     * - Exchange capability information between client and agent
     * - Determine available authentication methods
     *
     * The agent should respond with its supported protocol version and capabilities.
     *
     * See protocol docs: [Initialization](https://agentclientprotocol.com/protocol/initialization)
     */
    async initialize(params) {
        return await this.#connection.sendRequest(schema.AGENT_METHODS.initialize, params);
    }
    /**
     * Creates a new conversation session with the agent.
     *
     * Sessions represent independent conversation contexts with their own history and state.
     *
     * The agent should:
     * - Create a new session context
     * - Connect to any specified MCP servers
     * - Return a unique session ID for future requests
     *
     * May return an `auth_required` error if the agent requires authentication.
     *
     * See protocol docs: [Session Setup](https://agentclientprotocol.com/protocol/session-setup)
     */
    async newSession(params) {
        return await this.#connection.sendRequest(schema.AGENT_METHODS.session_new, params);
    }
    /**
     * Loads an existing session to resume a previous conversation.
     *
     * This method is only available if the agent advertises the `loadSession` capability.
     *
     * The agent should:
     * - Restore the session context and conversation history
     * - Connect to the specified MCP servers
     * - Stream the entire conversation history back to the client via notifications
     *
     * See protocol docs: [Loading Sessions](https://agentclientprotocol.com/protocol/session-setup#loading-sessions)
     */
    async loadSession(params) {
        return ((await this.#connection.sendRequest(schema.AGENT_METHODS.session_load, params)) ?? {});
    }
    /**
     * Sets the operational mode for a session.
     *
     * Allows switching between different agent modes (e.g., "ask", "architect", "code")
     * that affect system prompts, tool availability, and permission behaviors.
     *
     * The mode must be one of the modes advertised in `availableModes` during session
     * creation or loading. Agents may also change modes autonomously and notify the
     * client via `current_mode_update` notifications.
     *
     * This method can be called at any time during a session, whether the Agent is
     * idle or actively generating a turn.
     *
     * See protocol docs: [Session Modes](https://agentclientprotocol.com/protocol/session-modes)
     */
    async setSessionMode(params) {
        return ((await this.#connection.sendRequest(schema.AGENT_METHODS.session_set_mode, params)) ?? {});
    }
    /**
     * **UNSTABLE**
     *
     * This capability is not part of the spec yet, and may be removed or changed at any point.
     *
     * Select a model for a given session.
     */
    async setSessionModel(params) {
        return ((await this.#connection.sendRequest(schema.AGENT_METHODS.session_set_mode, params)) ?? {});
    }
    /**
     * Authenticates the client using the specified authentication method.
     *
     * Called when the agent requires authentication before allowing session creation.
     * The client provides the authentication method ID that was advertised during initialization.
     *
     * After successful authentication, the client can proceed to create sessions with
     * `newSession` without receiving an `auth_required` error.
     *
     * See protocol docs: [Initialization](https://agentclientprotocol.com/protocol/initialization)
     */
    async authenticate(params) {
        return ((await this.#connection.sendRequest(schema.AGENT_METHODS.authenticate, params)) ?? {});
    }
    /**
     * Processes a user prompt within a session.
     *
     * This method handles the whole lifecycle of a prompt:
     * - Receives user messages with optional context (files, images, etc.)
     * - Processes the prompt using language models
     * - Reports language model content and tool calls to the Clients
     * - Requests permission to run tools
     * - Executes any requested tool calls
     * - Returns when the turn is complete with a stop reason
     *
     * See protocol docs: [Prompt Turn](https://agentclientprotocol.com/protocol/prompt-turn)
     */
    async prompt(params) {
        return await this.#connection.sendRequest(schema.AGENT_METHODS.session_prompt, params);
    }
    /**
     * Cancels ongoing operations for a session.
     *
     * This is a notification sent by the client to cancel an ongoing prompt turn.
     *
     * Upon receiving this notification, the Agent SHOULD:
     * - Stop all language model requests as soon as possible
     * - Abort all tool call invocations in progress
     * - Send any pending `session/update` notifications
     * - Respond to the original `session/prompt` request with `StopReason::Cancelled`
     *
     * See protocol docs: [Cancellation](https://agentclientprotocol.com/protocol/prompt-turn#cancellation)
     */
    async cancel(params) {
        return await this.#connection.sendNotification(schema.AGENT_METHODS.session_cancel, params);
    }
    /**
     * Extension method
     *
     * Allows the Client to send an arbitrary request that is not part of the ACP spec.
     */
    async extMethod(method, params) {
        return await this.#connection.sendRequest(`_${method}`, params);
    }
    /**
     * Extension notification
     *
     * Allows the Client to send an arbitrary notification that is not part of the ACP spec.
     */
    async extNotification(method, params) {
        return await this.#connection.sendNotification(`_${method}`, params);
    }
}
class Connection {
    #pendingResponses = new Map();
    #nextRequestId = 0;
    #requestHandler;
    #notificationHandler;
    #stream;
    #writeQueue = Promise.resolve();
    constructor(requestHandler, notificationHandler, stream) {
        this.#requestHandler = requestHandler;
        this.#notificationHandler = notificationHandler;
        this.#stream = stream;
        this.#receive();
    }
    async #receive() {
        const reader = this.#stream.readable.getReader();
        try {
            while (true) {
                const { value: message, done } = await reader.read();
                if (done) {
                    break;
                }
                if (!message) {
                    continue;
                }
                try {
                    this.#processMessage(message);
                }
                catch (err) {
                    console.error("Unexpected error during message processing:", message, err);
                    // Only send error response if the message had an id (was a request)
                    if ("id" in message && message.id !== undefined) {
                        this.#sendMessage({
                            jsonrpc: "2.0",
                            id: message.id,
                            error: {
                                code: -32700,
                                message: "Parse error",
                            },
                        });
                    }
                }
            }
        }
        finally {
            reader.releaseLock();
        }
    }
    async #processMessage(message) {
        if ("method" in message && "id" in message) {
            // It's a request
            const response = await this.#tryCallRequestHandler(message.method, message.params);
            if ("error" in response) {
                console.error("Error handling request", message, response.error);
            }
            await this.#sendMessage({
                jsonrpc: "2.0",
                id: message.id,
                ...response,
            });
        }
        else if ("method" in message) {
            // It's a notification
            const response = await this.#tryCallNotificationHandler(message.method, message.params);
            if ("error" in response) {
                console.error("Error handling notification", message, response.error);
            }
        }
        else if ("id" in message) {
            // It's a response
            this.#handleResponse(message);
        }
        else {
            console.error("Invalid message", { message });
        }
    }
    async #tryCallRequestHandler(method, params) {
        try {
            const result = await this.#requestHandler(method, params);
            return { result: result ?? null };
        }
        catch (error) {
            if (error instanceof RequestError) {
                return error.toResult();
            }
            if (error instanceof lib.z.ZodError) {
                return RequestError.invalidParams(error.format()).toResult();
            }
            let details;
            if (error instanceof Error) {
                details = error.message;
            }
            else if (typeof error === "object" &&
                error != null &&
                "message" in error &&
                typeof error.message === "string") {
                details = error.message;
            }
            try {
                return RequestError.internalError(details ? JSON.parse(details) : {}).toResult();
            }
            catch (_err) {
                return RequestError.internalError({ details }).toResult();
            }
        }
    }
    async #tryCallNotificationHandler(method, params) {
        try {
            await this.#notificationHandler(method, params);
            return { result: null };
        }
        catch (error) {
            if (error instanceof RequestError) {
                return error.toResult();
            }
            if (error instanceof lib.z.ZodError) {
                return RequestError.invalidParams(error.format()).toResult();
            }
            let details;
            if (error instanceof Error) {
                details = error.message;
            }
            else if (typeof error === "object" &&
                error != null &&
                "message" in error &&
                typeof error.message === "string") {
                details = error.message;
            }
            try {
                return RequestError.internalError(details ? JSON.parse(details) : {}).toResult();
            }
            catch (_err) {
                return RequestError.internalError({ details }).toResult();
            }
        }
    }
    #handleResponse(response) {
        const pendingResponse = this.#pendingResponses.get(response.id);
        if (pendingResponse) {
            if ("result" in response) {
                pendingResponse.resolve(response.result);
            }
            else if ("error" in response) {
                pendingResponse.reject(response.error);
            }
            this.#pendingResponses.delete(response.id);
        }
        else {
            console.error("Got response to unknown request", response.id);
        }
    }
    async sendRequest(method, params) {
        const id = this.#nextRequestId++;
        const responsePromise = new Promise((resolve, reject) => {
            this.#pendingResponses.set(id, { resolve, reject });
        });
        await this.#sendMessage({ jsonrpc: "2.0", id, method, params });
        return responsePromise;
    }
    async sendNotification(method, params) {
        await this.#sendMessage({ jsonrpc: "2.0", method, params });
    }
    async #sendMessage(message) {
        this.#writeQueue = this.#writeQueue
            .then(async () => {
            const writer = this.#stream.writable.getWriter();
            try {
                await writer.write(message);
            }
            finally {
                writer.releaseLock();
            }
        })
            .catch((error) => {
            // Continue processing writes on error
            console.error("ACP write error:", error);
        });
        return this.#writeQueue;
    }
}
/**
 * JSON-RPC error object.
 *
 * Represents an error that occurred during method execution, following the
 * JSON-RPC 2.0 error object specification with optional additional data.
 *
 * See protocol docs: [JSON-RPC Error Object](https://www.jsonrpc.org/specification#error_object)
 */
class RequestError extends Error {
    code;
    data;
    constructor(code, message, data) {
        super(message);
        this.code = code;
        this.name = "RequestError";
        this.data = data;
    }
    /**
     * Invalid JSON was received by the server. An error occurred on the server while parsing the JSON text.
     */
    static parseError(data) {
        return new RequestError(-32700, "Parse error", data);
    }
    /**
     * The JSON sent is not a valid Request object.
     */
    static invalidRequest(data) {
        return new RequestError(-32600, "Invalid request", data);
    }
    /**
     * The method does not exist / is not available.
     */
    static methodNotFound(method) {
        return new RequestError(-32601, "Method not found", { method });
    }
    /**
     * Invalid method parameter(s).
     */
    static invalidParams(data) {
        return new RequestError(-32602, "Invalid params", data);
    }
    /**
     * Internal JSON-RPC error.
     */
    static internalError(data) {
        return new RequestError(-32603, "Internal error", data);
    }
    /**
     * Authentication required.
     */
    static authRequired(data) {
        return new RequestError(-32000, "Authentication required", data);
    }
    /**
     * Resource, such as a file, was not found
     */
    static resourceNotFound(uri) {
        return new RequestError(-32002, "Resource not found", uri && { uri });
    }
    toResult() {
        return {
            error: {
                code: this.code,
                message: this.message,
                data: this.data,
            },
        };
    }
    toErrorResponse() {
        return {
            code: this.code,
            message: this.message,
            data: this.data,
        };
    }
}
//# sourceMappingURL=acp.js.map

/***/ })

};
;