exports.id = 8453;
exports.ids = [8453];
exports.modules = {

/***/ "../../node_modules/.pnpm/node-ansiparser@2.2.1/node_modules/node-ansiparser/dist/ansiparser.js":
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function () {
    'use strict';

    /**
     * range function for numbers [a, .., b-1]
     *
     * @param {number} a
     * @param {number} b
     * @return {Array}
     */
    function r(a, b) {
        var c = b - a;
        var arr = new Array(c);
        while (c--)
            arr[c] = --b;
        return arr;
    }

    /**
     * Add a transition to the transition table.
     *
     * @param table - table to add transition
     * @param {number} inp - input character code
     * @param {number} state - current state
     * @param {number=} action - action to be taken
     * @param {number=} next - next state
     */
    function add(table, inp, state, action, next) {
        table[state<<8|inp] = ((action | 0) << 4) | ((next === undefined) ? state : next);
    }

    /**
     * Add multiple transitions to the transition table.
     *
     * @param table - table to add transition
     * @param {Array} inps - array of input character codes
     * @param {number} state - current state
     * @param {number=} action - action to be taken
     * @param {number=} next - next state
     */
    function add_list(table, inps, state, action, next) {
        for (var i=0; i<inps.length; i++)
            add(table, inps[i], state, action, next);
    }

    /** global definition of printables and executables */
    var PRINTABLES = r(0x20, 0x7f);
    var EXECUTABLES = r(0x00, 0x18);
    EXECUTABLES.push(0x19);
    EXECUTABLES = EXECUTABLES.concat(r(0x1c, 0x20));

    /* meaning of state and action indices
        var STATES = [
            'GROUND',
            'ESCAPE',
            'ESCAPE_INTERMEDIATE',
            'CSI_ENTRY',
            'CSI_PARAM',
            'CSI_INTERMEDIATE',
            'CSI_IGNORE',
            'SOS_PM_APC_STRING',
            'OSC_STRING',
            'DCS_ENTRY',
            'DCS_PARAM',
            'DCS_IGNORE',
            'DCS_INTERMEDIATE',
            'DCS_PASSTHROUGH'
        ];
        var ACTIONS = [
            'ignore',
            'error',
            'print',
            'execute',
            'osc_start',
            'osc_put',
            'osc_end',
            'csi_dispatch',
            'param',
            'collect',
            'esc_dispatch',
            'clear',
            'dcs_hook',
            'dcs_put',
            'dcs_unhook'
        ];
     */

    /**
     * create the standard transition table - used by all parser instances
     *
     *     table[state << 8 | character code] = action << 4 | next state
     *
     *     - states are indices of STATES (0 to 13)
     *     - control character codes defined from 0 to 159 (C0 and C1)
     *     - actions are indices of ACTIONS (0 to 14)
     *     - any higher character than 159 is handled by the 'error' action
     */
    var TRANSITION_TABLE = (function() {
        var t = new Uint8Array(4095);

        // table with default transition [any] --> [error, GROUND]
        for (var state=0; state<14; ++state) {
            for (var code=0; code<160; ++code) {
                t[state<<8|code] = 16;
            }
        }

        // apply transitions
        // printables
        add_list(t, PRINTABLES, 0, 2);
        // global anywhere rules
        for (state=0; state<14; ++state) {
            add_list(t, [0x18, 0x1a, 0x99, 0x9a], state, 3, 0);
            add_list(t, r(0x80, 0x90), state, 3, 0);
            add_list(t, r(0x90, 0x98), state, 3, 0);
            add(t, 0x9c, state, 0, 0);   // ST as terminator
            add(t, 0x1b, state, 11, 1);  // ESC
            add(t, 0x9d, state, 4, 8);   // OSC
            add_list(t, [0x98, 0x9e, 0x9f], state, 0, 7);
            add(t, 0x9b, state, 11, 3);  // CSI
            add(t, 0x90, state, 11, 9);  // DCS
        }
        // rules for executables and 7f
        add_list(t, EXECUTABLES, 0, 3);
        add_list(t, EXECUTABLES, 1, 3);
        add(t, 0x7f, 1);
        add_list(t, EXECUTABLES, 8);
        add_list(t, EXECUTABLES, 3, 3);
        add(t, 0x7f, 3);
        add_list(t, EXECUTABLES, 4, 3);
        add(t, 0x7f, 4);
        add_list(t, EXECUTABLES, 6, 3);
        add_list(t, EXECUTABLES, 5, 3);
        add(t, 0x7f, 5);
        add_list(t, EXECUTABLES, 2, 3);
        add(t, 0x7f, 2);
        // osc
        add(t, 0x5d, 1, 4, 8);
        add_list(t, PRINTABLES, 8, 5);
        add(t, 0x7f, 8, 5);
        add_list(t, [0x9c, 0x1b, 0x18, 0x1a, 0x07], 8, 6, 0);
        add_list(t, r(0x1c, 0x20), 8, 0);
        // sos/pm/apc does nothing
        add_list(t, [0x58, 0x5e, 0x5f], 1, 0, 7);
        add_list(t, PRINTABLES, 7);
        add_list(t, EXECUTABLES, 7);
        add(t, 0x7f, 7);
        add(t, 0x9c, 7, 0, 0);
        // csi entries
        add(t, 0x5b, 1, 11, 3);
        add_list(t, r(0x40, 0x7f), 3, 7, 0);
        add_list(t, r(0x30, 0x3a), 3, 8, 4);
        add(t, 0x3b, 3, 8, 4);
        add_list(t, [0x3c, 0x3d, 0x3e, 0x3f], 3, 9, 4);
        add_list(t, r(0x30, 0x3a), 4, 8);
        add(t, 0x3b, 4, 8);
        add_list(t, r(0x40, 0x7f), 4, 7, 0);
        add_list(t, [0x3a, 0x3c, 0x3d, 0x3e, 0x3f], 4, 0, 6);
        add_list(t, r(0x20, 0x40), 6);
        add(t, 0x7f, 6);
        add_list(t, r(0x40, 0x7f), 6, 0, 0);
        add(t, 0x3a, 3, 0, 6);
        add_list(t, r(0x20, 0x30), 3, 9, 5);
        add_list(t, r(0x20, 0x30), 5, 9);
        add_list(t, r(0x30, 0x40), 5, 0, 6);
        add_list(t, r(0x40, 0x7f), 5, 7, 0);
        add_list(t, r(0x20, 0x30), 4, 9, 5);
        // esc_intermediate
        add_list(t, r(0x20, 0x30), 1, 9, 2);
        add_list(t, r(0x20, 0x30), 2, 9);
        add_list(t, r(0x30, 0x7f), 2, 10, 0);
        add_list(t, r(0x30, 0x50), 1, 10, 0);
        add_list(t, [0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x59, 0x5a, 0x5c], 1, 10, 0);
        add_list(t, r(0x60, 0x7f), 1, 10, 0);
        // dcs entry
        add(t, 0x50, 1, 11, 9);
        add_list(t, EXECUTABLES, 9);
        add(t, 0x7f, 9);
        add_list(t, r(0x1c, 0x20), 9);
        add_list(t, r(0x20, 0x30), 9, 9, 12);
        add(t, 0x3a, 9, 0, 11);
        add_list(t, r(0x30, 0x3a), 9, 8, 10);
        add(t, 0x3b, 9, 8, 10);
        add_list(t, [0x3c, 0x3d, 0x3e, 0x3f], 9, 9, 10);
        add_list(t, EXECUTABLES, 11);
        add_list(t, r(0x20, 0x80), 11);
        add_list(t, r(0x1c, 0x20), 11);
        add_list(t, EXECUTABLES, 10);
        add(t, 0x7f, 10);
        add_list(t, r(0x1c, 0x20), 10);
        add_list(t, r(0x30, 0x3a), 10, 8);
        add(t, 0x3b, 10, 8);
        add_list(t, [0x3a, 0x3c, 0x3d, 0x3e, 0x3f], 10, 0, 11);
        add_list(t, r(0x20, 0x30), 10, 9, 12);
        add_list(t, EXECUTABLES, 12);
        add(t, 0x7f, 12);
        add_list(t, r(0x1c, 0x20), 12);
        add_list(t, r(0x20, 0x30), 12, 9);
        add_list(t, r(0x30, 0x40), 12, 0, 11);
        add_list(t, r(0x40, 0x7f), 12, 12, 13);
        add_list(t, r(0x40, 0x7f), 10, 12, 13);
        add_list(t, r(0x40, 0x7f), 9, 12, 13);
        add_list(t, EXECUTABLES, 13, 13);
        add_list(t, PRINTABLES, 13, 13);
        add(t, 0x7f, 13);
        add_list(t, [0x1b, 0x9c], 13, 14, 0);

        return t;
    })();


    /**
     *  AnsiParser - Parser for ANSI terminal escape sequences.
     *
     * @param {Object=} terminal emulation object
     * @constructor
     */
    function AnsiParser(terminal) {
        this.initial_state = 0;  // 'GROUND' is default
        this.current_state = this.initial_state|0;

        // clone global transition table
        this.transitions = new Uint8Array(4095);
        this.transitions.set(TRANSITION_TABLE);

        // global non pushable buffers for multiple parse invocations
        this.osc = '';
        this.params = [0];
        this.collected = '';

        // back reference to terminal
        this.term = terminal || {};
        var instructions = ['inst_p', 'inst_o', 'inst_x', 'inst_c',
            'inst_e', 'inst_H', 'inst_P', 'inst_U', 'inst_E'];
        for (var i=0; i<instructions.length; ++i)
            if (!(instructions[i] in this.term))
                this.term[instructions[i]] = function() {};
    }

    /**
     * Reset the parser.
     */
    AnsiParser.prototype.reset = function() {
        this.current_state = this.initial_state|0;
        this.osc = '';
        this.params = [0];
        this.collected = '';
    };

    /**
     * Parse string s.
     * @param {string} s
     */
    AnsiParser.prototype.parse = function(s) {
        var code = 0,
            transition = 0,
            error = false,
            current_state = this.current_state|0;

        // local buffers
        var printed = -1;
        var dcs = -1;
        var osc = this.osc;
        var collected = this.collected;
        var params = this.params;

        // process input string
        for (var i=0, l=s.length|0; i<l; ++i) {
            code = s.charCodeAt(i)|0;
            // shortcut for most chars (print action)
            if (current_state===0 && code>0x1f && code<0x80) {
                printed = (printed + 1) ? printed|0: i|0;
                continue;
            }
            transition = ((code < 0xa0) ? (this.transitions[(current_state<<8|code)|0])|0 : 16)|0;
            switch ((transition >> 4)|0) {
                case 2: // print
                    printed = (printed + 1) ? printed|0: i|0;
                    break;
                case 3: // execute
                    if (printed + 1) {
                        this.term.inst_p(s.substring(printed, i));
                        printed = -1;
                    }
                    this.term.inst_x(String.fromCharCode(code));
                    break;
                case 0: // ignore
                    // handle leftover print and dcs chars
                    if (printed + 1) {
                        this.term.inst_p(s.substring(printed, i));
                        printed = -1;
                    } else if (dcs + 1) {
                        this.term.inst_P(s.substring(dcs, i));
                        dcs = -1;
                    }
                    break;
                case 1: // error
                    // handle unicode chars in write buffers w'o state change
                    if (code > 0x9f) {
                        switch (current_state) {
                            case 0: // GROUND -> add char to print string
                                printed = (!(printed+1)) ? i|0 : printed|0;
                                break;
                            case 8: // OSC_STRING -> add char to osc string
                                osc += String.fromCharCode(code);
                                transition = (transition | 8)|0;
                                break;
                            case 6: // CSI_IGNORE -> ignore char
                                transition = (transition | 6)|0;
                                break;
                            case 11: // DCS_IGNORE -> ignore char
                                transition = (transition | 11)|0;
                                break;
                            case 13: // DCS_PASSTHROUGH -> add char to dcs
                                if (!(dcs + 1))
                                    dcs = i|0;
                                transition = (transition | 13)|0;
                                break;
                            default: // real error
                                error = true;
                        }
                    } else { // real error
                        error = true;
                    }
                    if (error) {
                        if (this.term.inst_E(
                                {
                                    pos: i,                 // position in parse string
                                    character: String.fromCharCode(code), // wrong character
                                    state: current_state,   // in state
                                    print: printed,         // print buffer
                                    dcs: dcs,               // dcs buffer
                                    osc: osc,               // osc buffer
                                    collect: collected,     // collect buffer
                                    params: params          // params buffer
                                })) {
                            return;
                        }
                        error = false;
                    }
                    break;
                case 7: // csi_dispatch
                    this.term.inst_c(collected, params, String.fromCharCode(code));
                    break;
                case 8: // param
                    if (code === 0x3b)
                        params.push(0);
                    else
                        params[params.length-1] = (params[params.length-1] * 10 + code - 48)|0;
                    break;
                case 9: // collect
                    collected += String.fromCharCode(code);
                    break;
                case 10: // esc_dispatch
                    this.term.inst_e(collected, String.fromCharCode(code));
                    break;
                case 11: // clear
                    if (printed + 1) {
                        this.term.inst_p(s.substring(printed, i));
                        printed = -1;
                    }
                    osc = '';
                    params = [0];
                    collected = '';
                    dcs = -1;
                    break;
                case 12: // dcs_hook
                    this.term.inst_H(collected, params, String.fromCharCode(code));
                    break;
                case 13: // dcs_put
                    if (!(dcs + 1))
                        dcs = i|0;
                    break;
                case 14: // dcs_unhook
                    if (dcs + 1) {
                        this.term.inst_P(s.substring(dcs, i));
                    }
                    this.term.inst_U();
                    if (code === 0x1b)
                        transition = (transition | 1)|0;
                    osc = '';
                    params = [0];
                    collected = '';
                    dcs = -1;
                    break;
                case 4: // osc_start
                    if (~printed) {
                        this.term.inst_p(s.substring(printed, i));
                        printed = -1;
                    }
                    osc = '';
                    break;
                case 5: // osc_put
                    osc += s.charAt(i);
                    break;
                case 6: // osc_end
                    if (osc && code !== 0x18 && code !== 0x1a)
                        this.term.inst_o(osc);
                    if (code === 0x1b)
                        transition = (transition | 1)|0;
                    osc = '';
                    params = [0];
                    collected = '';
                    dcs = -1;
                    break;
            }
            current_state = (transition & 15)|0;
        }

        // push leftover pushable buffers to terminal
        if (!current_state && (printed + 1)) {
            this.term.inst_p(s.substring(printed));
        } else if (current_state===13 && (dcs + 1)) {
            this.term.inst_P(s.substring(dcs));
        }

        // save non pushable buffers
        this.osc = osc;
        this.collected = collected;
        this.params = params;

        // save state
        this.current_state = current_state|0;
    };

    /* istanbul ignore next */
    if ( true
        && typeof module.exports !== 'undefined') {
        module.exports = AnsiParser;
    } else {
        if (true) {
            !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {return AnsiParser;}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
        } else // removed by dead control flow
{}
    }
})();

/***/ }),

/***/ "./src/commands/record.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleRecord: () => (/* binding */ handleRecord)
/* harmony export */ });
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:fs");
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_fs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:os");
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_os__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lydell_node_pty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../node_modules/.pnpm/@lydell+node-pty@1.1.0_patch_hash=8cc7c6b3b59e47c0436b0f2bbb89cec1ced0f8ac0beadc41a2d07016bef0ea46/node_modules/@lydell/node-pty/index.js");
/* harmony import */ var node_ansiparser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../node_modules/.pnpm/node-ansiparser@2.2.1/node_modules/node-ansiparser/dist/ansiparser.js");
/* harmony import */ var node_ansiparser__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(node_ansiparser__WEBPACK_IMPORTED_MODULE_4__);






// Initial config - paths will be set after temp directory creation
const CONFIG = {
    shell: "/bin/zsh",
    pendingFile: "",
    completedFile: "",
    tempDir: "",
};
// Command capture state
class CommandCapture {
    constructor(pendingFile, completedFile) {
        this.pendingFile = pendingFile;
        this.completedFile = completedFile;
        this.state = {
            currentCommand: null,
            isCapturingOutput: false,
            pendingStream: null,
            commandExitCode: null,
            waitingForExitCode: false,
        };
    }
    startCapture(command) {
        this.state.currentCommand = command;
        this.state.isCapturingOutput = true;
        // Start writing to pending file with command as first line
        this.state.pendingStream = node_fs__WEBPACK_IMPORTED_MODULE_0__.createWriteStream(this.pendingFile);
        this.state.pendingStream.write(`${command}\n`);
    }
    writeToCapture(data) {
        if (this.state.isCapturingOutput && this.state.pendingStream) {
            this.state.pendingStream.write(data);
        }
    }
    setExitCode(exitCode) {
        this.state.commandExitCode = exitCode;
        if (this.state.isCapturingOutput &&
            this.state.currentCommand &&
            this.state.pendingStream) {
            this.state.waitingForExitCode = true;
        }
    }
    finishCommand() {
        if (this.state.pendingStream && this.state.commandExitCode !== null) {
            // Write the exit code as the last line
            this.state.pendingStream.write(`\n${this.state.commandExitCode}`);
            this.state.pendingStream.end();
            this.state.pendingStream = null;
            // Move pending.bin to completed.bin
            try {
                if (node_fs__WEBPACK_IMPORTED_MODULE_0__.existsSync(this.pendingFile)) {
                    node_fs__WEBPACK_IMPORTED_MODULE_0__.renameSync(this.pendingFile, this.completedFile);
                }
            }
            catch (err) {
                void err;
            }
            // Reset state
            this.state.commandExitCode = null;
            this.state.waitingForExitCode = false;
        }
    }
    resetForNextCommand() {
        // Default to exit code 0 if we don't have one yet
        if (this.state.isCapturingOutput && this.state.currentCommand) {
            if (this.state.commandExitCode === null) {
                this.state.commandExitCode = "0";
            }
            this.finishCommand();
            // Reset for next command
            this.state.currentCommand = null;
        }
        this.state.isCapturingOutput = false;
    }
    get isCapturing() {
        return this.state.isCapturingOutput;
    }
    get hasCommand() {
        return this.state.currentCommand !== null;
    }
    get isWaitingForExitCode() {
        return this.state.waitingForExitCode;
    }
    get currentCommand() {
        return this.state.currentCommand;
    }
    handleProcessExit(exitCode) {
        if (this.state.isCapturingOutput && this.state.currentCommand) {
            if (this.state.commandExitCode === null) {
                this.state.commandExitCode = exitCode.toString();
            }
            this.finishCommand();
        }
    }
    closePendingStream() {
        if (this.state.pendingStream) {
            this.state.pendingStream.end();
            this.state.pendingStream = null;
        }
    }
}
// OSC (Operating System Command) parser
class OscParser {
    constructor(commandCapture) {
        this.commandCapture = commandCapture;
    }
    parse(oscSequence) {
        const semicolonIndex = oscSequence.indexOf(";");
        if (semicolonIndex === -1)
            return;
        const oscType = oscSequence.substring(0, semicolonIndex);
        const oscData = oscSequence.substring(semicolonIndex + 1);
        switch (oscType) {
            case "1":
                this.handleWindowTitle(oscData);
                break;
            case "2":
                this.handleTerminalTitle(oscData);
                break;
            case "7":
                // OSC 7: Current working directory as file:// URL
                // Ignored for now since we're not tracking CWD
                break;
            case "133":
                this.handleShellIntegration(oscSequence);
                break;
            case "9999":
                // Custom OSC sequence for Cursor Agent terminal capture
                this.handleCursorAgentSequence(oscData);
                break;
        }
    }
    handleWindowTitle(_oscData) {
        // OSC 1: Window title - disabled in favor of custom OSC 9999
        // We don't process window titles to avoid conflicts with other tools
    }
    handleTerminalTitle(_oscData) {
        // OSC 2: Terminal title - disabled in favor of custom OSC 9999
        // We don't process terminal titles to avoid conflicts with other tools
    }
    handleShellIntegration(_oscSequence) {
        // OSC 133: Shell integration sequences - disabled in favor of custom OSC 9999
        // We don't process OSC 133 to avoid conflicts with other tools
    }
    handleCursorAgentSequence(data) {
        // Custom OSC 9999 sequence format:
        // OSC 9999;type;data ST
        // Types:
        // - prompt: New prompt is about to be shown
        // - preexec: Command is about to execute (data contains command)
        // - precmd: Command finished (data contains exit code)
        const parts = data.split(";");
        if (parts.length < 1)
            return;
        const type = parts[0];
        const payload = parts.slice(1).join(";");
        switch (type) {
            case "prompt":
                // New prompt - reset for next command
                this.commandCapture.resetForNextCommand();
                break;
            case "preexec":
                // Command is about to execute
                if (payload && !this.commandCapture.hasCommand) {
                    this.commandCapture.startCapture(payload);
                }
                break;
            case "precmd":
                // Command finished with exit code
                if (payload) {
                    this.commandCapture.setExitCode(payload);
                    this.commandCapture.finishCommand();
                }
                break;
        }
    }
}
// ANSI terminal handler
class AnsiTerminalHandler {
    constructor(commandCapture) {
        this.commandCapture = commandCapture;
        this.oscParser = new OscParser(commandCapture);
    }
    // Print regular text
    inst_p(s) {
        // Write to pending file if we're capturing output
        this.commandCapture.writeToCapture(s);
    }
    // OSC (Operating System Command) sequences
    inst_o(s) {
        this.oscParser.parse(s);
    }
    // Execute single character commands (C0 control codes)
    inst_x(flag) {
        // Write control characters to pending file if capturing
        this.commandCapture.writeToCapture(flag);
    }
    // CSI (Control Sequence Introducer) sequences
    inst_c(_collected, _params, _flag) { }
    // ESC sequences
    inst_e(_collected, _flag) { }
    // DCS (Device Control String) sequences - Start
    inst_H(_collected, _params, _flag) { }
    // DCS data
    inst_P(_data) { }
    // End of DCS sequence
    inst_U() { }
    // Error handler
    inst_E(error) {
        void error;
    }
}
// Main terminal capture class
class TerminalCapture {
    constructor() {
        // Create temporary directory for this execution
        this.createTempDirectory();
        this.commandCapture = new CommandCapture(CONFIG.pendingFile, CONFIG.completedFile);
        // Create terminal handler
        const terminal = new AnsiTerminalHandler(this.commandCapture);
        // Create parser instance
        this.parser = new (node_ansiparser__WEBPACK_IMPORTED_MODULE_4___default())(terminal);
        // Initialize PTY
        this.ptyProcess = this.initializePty();
        // Clean up any existing files on start
        this.cleanupFiles();
    }
    createTempDirectory() {
        // Create a unique temporary directory
        const tempDirPrefix = "termcapture-";
        CONFIG.tempDir = node_fs__WEBPACK_IMPORTED_MODULE_0__.mkdtempSync(node_path__WEBPACK_IMPORTED_MODULE_2__.join(node_os__WEBPACK_IMPORTED_MODULE_1__.tmpdir(), tempDirPrefix));
        // Set the file paths within the temp directory
        CONFIG.pendingFile = node_path__WEBPACK_IMPORTED_MODULE_2__.join(CONFIG.tempDir, "pending.bin");
        CONFIG.completedFile = node_path__WEBPACK_IMPORTED_MODULE_2__.join(CONFIG.tempDir, "completed.bin");
        // Set the environment variable for completed.bin path
        process.env.CURSOR_AGENT_COMPLETED_PATH = CONFIG.completedFile;
    }
    initializePty() {
        try {
            const require = /* createRequire() */ undefined;
            const spawnHelperPath =  false
                ? 0
                : node_path__WEBPACK_IMPORTED_MODULE_2__.join(process.argv[1], "..", "spawn-helper");
            const ptyProcess = _lydell_node_pty__WEBPACK_IMPORTED_MODULE_3__/* .spawn */ .cH("zsh", ["-il"], {
                ["helperPath"]: spawnHelperPath,
                name: "xterm-256color",
                cols: process.stdout.columns || 80,
                rows: process.stdout.rows || 24,
                cwd: process.cwd(),
                env: Object.assign(Object.assign({}, process.env), { CURSOR_AGENT_COMPLETED_PATH: CONFIG.completedFile }),
            });
            // Parse PTY output through ANSI parser before displaying
            ptyProcess.onData((data) => {
                this.parser.parse(data);
                process.stdout.write(data);
            });
            // Handle PTY exit
            ptyProcess.onExit((exitCode) => {
                this.commandCapture.handleProcessExit(exitCode.exitCode);
                this.cleanup();
                process.exit(exitCode.exitCode);
            });
            return ptyProcess;
        }
        catch (err) {
            process.stderr.write("Error initializing PTY:");
            if (err instanceof Error) {
                process.stderr.write(err.message);
                process.stderr.write(err.stack || "");
            }
            else {
                process.stderr.write(String(err));
            }
            process.exit(1);
        }
    }
    cleanupFiles() {
        try {
            if (node_fs__WEBPACK_IMPORTED_MODULE_0__.existsSync(CONFIG.pendingFile)) {
                node_fs__WEBPACK_IMPORTED_MODULE_0__.unlinkSync(CONFIG.pendingFile);
            }
            if (node_fs__WEBPACK_IMPORTED_MODULE_0__.existsSync(CONFIG.completedFile)) {
                node_fs__WEBPACK_IMPORTED_MODULE_0__.unlinkSync(CONFIG.completedFile);
            }
        }
        catch (err) {
            // Ignore errors during cleanup
            void err;
        }
    }
    setupStdin() {
        // Set raw mode for stdin to capture all input
        if (process.stdin.isTTY) {
            process.stdin.setRawMode(true);
        }
        process.stdin.resume();
        process.stdin.setEncoding("utf8");
        // Pipe stdin to the PTY
        process.stdin.on("data", (data) => {
            this.ptyProcess.write(data);
        });
    }
    setupResize() {
        // Handle terminal resize
        process.stdout.on("resize", () => {
            if (process.stdout.columns && process.stdout.rows) {
                this.ptyProcess.resize(process.stdout.columns, process.stdout.rows);
            }
        });
        // Initial resize to match current terminal size
        if (process.stdout.columns && process.stdout.rows) {
            this.ptyProcess.resize(process.stdout.columns, process.stdout.rows);
        }
    }
    setupSignalHandlers() {
        // Handle process signals for graceful shutdown
        const handleSignal = (signal) => {
            this.ptyProcess.kill(signal);
        };
        process.on("SIGINT", () => handleSignal("SIGINT"));
        process.on("SIGTERM", () => handleSignal("SIGTERM"));
        //     process.on("uncaughtException", (err: Error) => {
        //       console.error("Uncaught exception:", err);
        //       this.commandCapture.closePendingStream();
        //       this.cleanup();
        //       process.exit(1);
        //     });
    }
    cleanup() {
        // Restore terminal state
        if (process.stdin.isTTY) {
            process.stdin.setRawMode(false);
        }
        // Remove the temporary directory and all its contents
        if (CONFIG.tempDir && node_fs__WEBPACK_IMPORTED_MODULE_0__.existsSync(CONFIG.tempDir)) {
            try {
                node_fs__WEBPACK_IMPORTED_MODULE_0__.rmSync(CONFIG.tempDir, { recursive: true, force: true });
            }
            catch (_err) { }
        }
    }
    start() {
        this.setupStdin();
        this.setupResize();
        this.setupSignalHandlers();
    }
}
function handleRecord() {
    // Check if running on Windows
    if (false) // removed by dead control flow
{}
    // Entry point
    const terminalCapture = new TerminalCapture();
    terminalCapture.start();
    process.title = "cursor-shell";
}


/***/ })

};
;