"use strict";
exports.id = 7414;
exports.ids = [7414];
exports.modules = {

/***/ "./src/acp/agent-session.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: () => (/* binding */ AgentSession)
/* harmony export */ });
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:child_process");
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_child_process__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:os");
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_os__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _anysphere_agent_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../agent-core/dist/index.js");
/* harmony import */ var _anysphere_proto_agent_v1_agent_pb_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../proto/dist/generated/agent/v1/agent_pb.js");
/* harmony import */ var _anysphere_proto_agent_v1_selected_context_pb_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../proto/dist/generated/agent/v1/selected_context_pb.js");
/* harmony import */ var _debug_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/debug.ts");
/* harmony import */ var _state_session_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/state/session.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








class AgentSession {
    constructor(connection, sessionId, sharedServices, ctx, agentStore, resources, currentModel) {
        this.connection = connection;
        this.sessionId = sessionId;
        this.pendingPromptCancel = null;
        this.sharedServices = sharedServices;
        this.ctx = ctx;
        this.agentStore = agentStore;
        this.resources = resources;
        this.currentModel = currentModel;
    }
    setCurrentModel(model) {
        this.currentModel = model;
    }
    getCurrentModel() {
        return this.currentModel;
    }
    sendSessionUpdate(update) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.connection.sessionUpdate({
                sessionId: this.sessionId,
                update,
            });
        });
    }
    /**
     * Send available slash commands to the client per ACP spec.
     * https://agentclientprotocol.com/protocol/slash-commands
     */
    sendAvailableCommands() {
        return __awaiter(this, void 0, void 0, function* () {
            const update = {
                sessionUpdate: "available_commands_update",
                availableCommands: [
                    {
                        name: "copy-request-id",
                        description: "Copy the last request ID to clipboard",
                    },
                ],
            };
            (0,_debug_js__WEBPACK_IMPORTED_MODULE_6__.debugLog)("Sending available commands:", update);
            yield this.sendSessionUpdate(update);
            (0,_debug_js__WEBPACK_IMPORTED_MODULE_6__.debugLog)("Available commands sent successfully");
        });
    }
    sendAgentMessageChunk(text) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sendSessionUpdate({
                sessionUpdate: "agent_message_chunk",
                content: {
                    type: "text",
                    text,
                },
            });
        });
    }
    sendToolCall(toolCallId, title, kind, rawInput) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sendSessionUpdate({
                sessionUpdate: "tool_call",
                toolCallId,
                title,
                kind,
                status: "pending",
                rawInput,
            });
        });
    }
    sendToolCallUpdate(toolCallId, status, content, rawOutput) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.sendSessionUpdate({
                sessionUpdate: "tool_call_update",
                toolCallId,
                status,
                content,
                rawOutput,
            });
        });
    }
    handlePrompt(params) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a;
            // Cancel any existing prompt
            (_a = this.pendingPromptCancel) === null || _a === void 0 ? void 0 : _a.call(this);
            // Create a cancellable context for this prompt
            const [cancelCtx, cancel] = this.ctx.withCancel();
            // this.pendingPromptCancel = cancel;
            try {
                yield this.processPrompt(params, cancelCtx);
            }
            catch (err) {
                if (cancelCtx.canceled) {
                    return { stopReason: "cancelled" };
                }
                throw err;
            }
            finally {
                this.pendingPromptCancel = null;
            }
            return { stopReason: "end_turn" };
        });
    }
    processPrompt(params, cancelCtx) {
        return __awaiter(this, void 0, void 0, function* () {
            const promptParts = params.prompt || [];
            const promptText = promptParts
                .filter((c) => c.type === "text")
                .map(c => c.text)
                .join("\n") || "";
            // Extract image content blocks
            const imageBlocks = promptParts.filter((c) => c.type === "image");
            if (!promptText.trim() && imageBlocks.length === 0) {
                yield this.sendAgentMessageChunk("No prompt content provided.");
                return;
            }
            // Handle slash commands
            const slashCommandResult = yield this.handleSlashCommand(promptText.trim());
            if (slashCommandResult.handled) {
                return;
            }
            const interactionListener = {
                sendUpdate: (_ctx, update) => __awaiter(this, void 0, void 0, function* () {
                    var _a;
                    switch (update.type) {
                        case "text-delta": {
                            yield this.sendAgentMessageChunk(update.text);
                            break;
                        }
                        case "tool-call-started": {
                            const summary = this.summarizeToolCall(update.toolCall);
                            if (summary) {
                                const kind = this.getToolKind((_a = update.toolCall.tool.case) !== null && _a !== void 0 ? _a : "");
                                yield this.sendToolCall(update.callId, summary, kind, this.extractToolCallInput(update.toolCall));
                            }
                            break;
                        }
                        case "tool-call-completed": {
                            const summary = this.summarizeToolCall(update.toolCall);
                            if (summary) {
                                const content = this.extractToolCallContent(update.toolCall);
                                const rawOutput = this.extractToolCallOutput(update.toolCall);
                                yield this.sendToolCallUpdate(update.callId, "completed", content, rawOutput);
                            }
                            break;
                        }
                        case "thinking-delta":
                        case "thinking-completed":
                            break;
                        default:
                            break;
                    }
                }),
                query: (_ctx, query) => __awaiter(this, void 0, void 0, function* () {
                    switch (query.type) {
                        case "web-search-request":
                            return {
                                approved: true,
                            };
                        default: {
                            throw new Error(`Unhandled interaction query type: ${query.type}`);
                        }
                    }
                }),
            };
            try {
                // Convert ACP image content blocks to SelectedImage protos
                const selectedImages = imageBlocks.map(imageBlock => {
                    // ACP image data is base64-encoded, convert to bytes
                    const imageData = Buffer.from(imageBlock.data, "base64");
                    return new _anysphere_proto_agent_v1_selected_context_pb_js__WEBPACK_IMPORTED_MODULE_5__/* .SelectedImage */ .d({
                        dataOrBlobId: {
                            case: "data",
                            value: imageData,
                        },
                        uuid: crypto.randomUUID(),
                        mimeType: imageBlock.mimeType,
                    });
                });
                const selectedCtx = new _anysphere_proto_agent_v1_selected_context_pb_js__WEBPACK_IMPORTED_MODULE_5__/* .SelectedContext */ .xv({
                    selectedImages,
                });
                const action = new _anysphere_proto_agent_v1_agent_pb_js__WEBPACK_IMPORTED_MODULE_4__/* .UserMessageAction */ .Vt({
                    userMessage: new _anysphere_proto_agent_v1_agent_pb_js__WEBPACK_IMPORTED_MODULE_4__/* .UserMessage */ .RG({
                        text: promptText,
                        selectedContext: selectedCtx,
                        messageId: crypto.randomUUID(),
                    }),
                });
                const conversationActionManager = new _anysphere_agent_core__WEBPACK_IMPORTED_MODULE_3__/* .ControlledConversationActionManager */ .hg();
                yield this.sharedServices.agentClient.run(cancelCtx, this.agentStore.getConversationStateStructure(), new _anysphere_proto_agent_v1_agent_pb_js__WEBPACK_IMPORTED_MODULE_4__/* .ConversationAction */ .QF({
                    action: {
                        case: "userMessageAction",
                        value: action,
                    },
                }), this.currentModel, interactionListener, this.resources, this.agentStore.getBlobStore(), conversationActionManager, this.agentStore, [], {
                    conversationId: this.agentStore.getId(),
                });
            }
            catch (error) {
                if (cancelCtx.canceled) {
                    return;
                }
                else {
                    yield this.sendAgentMessageChunk(`\n\nError: ${String(error)}`);
                }
            }
        });
    }
    handleSlashCommand(promptText) {
        return __awaiter(this, void 0, void 0, function* () {
            const lowerText = promptText.toLowerCase().trim();
            // Handle copy-request-id with or without slash prefix
            // (Client may intercept /copy-request-id before it reaches us)
            if (lowerText === "/copy-request-id") {
                yield this.handleCopyRequestId();
                return { handled: true };
            }
            // Check for other slash commands
            if (!promptText.startsWith("/")) {
                return { handled: false };
            }
            const commandMatch = promptText.match(/^\/(\S+)(?:\s+(.*))?$/);
            if (!commandMatch) {
                return { handled: false };
            }
            // Unknown slash command - let it pass through to the agent
            return { handled: false };
        });
    }
    handleCopyRequestId() {
        return __awaiter(this, void 0, void 0, function* () {
            const reqId = _state_session_js__WEBPACK_IMPORTED_MODULE_7__/* .session */ .d.getLastRequestId();
            if (!reqId) {
                yield this.sendAgentMessageChunk("No request ID found. Submit a prompt first, then retry /copy-request-id.");
                return;
            }
            let copied = false;
            if ((0,node_os__WEBPACK_IMPORTED_MODULE_1__.platform)() === "darwin") {
                try {
                    const cp = (0,node_child_process__WEBPACK_IMPORTED_MODULE_0__.spawn)("pbcopy");
                    cp.stdin.write(reqId);
                    cp.stdin.end();
                    yield new Promise(resolve => cp.on("close", () => resolve()));
                    copied = true;
                }
                catch (_a) {
                    copied = false;
                }
            }
            else if ((0,node_os__WEBPACK_IMPORTED_MODULE_1__.platform)() === "linux") {
                // Try xclip or xsel on Linux
                try {
                    const cp = (0,node_child_process__WEBPACK_IMPORTED_MODULE_0__.spawn)("xclip", ["-selection", "clipboard"]);
                    cp.stdin.write(reqId);
                    cp.stdin.end();
                    yield new Promise(resolve => cp.on("close", () => resolve()));
                    copied = true;
                }
                catch (_b) {
                    copied = false;
                }
            }
            if (copied) {
                yield this.sendAgentMessageChunk(`Copied request ID: ${reqId}`);
            }
            else {
                yield this.sendAgentMessageChunk(`Request ID: ${reqId}`);
            }
        });
    }
    makePathRelativeIfPossible(path) {
        if (!(0,node_path__WEBPACK_IMPORTED_MODULE_2__.isAbsolute)(path)) {
            return path;
        }
        const cwd = process.cwd();
        const absolutePath = (0,node_path__WEBPACK_IMPORTED_MODULE_2__.resolve)(path);
        const relativePath = (0,node_path__WEBPACK_IMPORTED_MODULE_2__.relative)(cwd, absolutePath);
        // Only use relative path if it doesn't start with '..' (i.e., it's under cwd)
        if (!relativePath.startsWith("..") && !(0,node_path__WEBPACK_IMPORTED_MODULE_2__.isAbsolute)(relativePath)) {
            return relativePath;
        }
        return path;
    }
    getToolKind(toolCase) {
        switch (toolCase) {
            case "shellToolCall":
                return "execute";
            case "readToolCall":
                return "read";
            case "editToolCall":
                return "edit";
            case "lsToolCall":
            case "globToolCall":
            case "grepToolCall":
            case "semSearchToolCall":
                return "search";
            case "updateTodosToolCall":
            case "readTodosToolCall":
                return "think";
            case "deleteToolCall":
                return "edit";
            default:
                return "other";
        }
    }
    summarizeToolCall(toolCall) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        const t = toolCall.tool;
        switch (t.case) {
            case "shellToolCall": {
                const command = (_b = (_a = t.value.args) === null || _a === void 0 ? void 0 : _a.command) !== null && _b !== void 0 ? _b : "";
                if (command) {
                    // Escape backticks in command for display
                    const displayCommand = command.replaceAll("`", "\\`");
                    return `\`${displayCommand}\``;
                }
                return "Terminal";
            }
            case "grepToolCall": {
                const args = t.value.args;
                if (!args)
                    return "grep";
                let label = "grep";
                if (args.i)
                    label += " -i";
                if (args.n)
                    label += " -n";
                if (args.A !== undefined)
                    label += ` -A ${args.A}`;
                if (args.B !== undefined)
                    label += ` -B ${args.B}`;
                if (args.C !== undefined)
                    label += ` -C ${args.C}`;
                if (args.outputMode) {
                    switch (args.outputMode) {
                        case "files_with_matches":
                            label += " -l";
                            break;
                        case "count":
                            label += " -c";
                            break;
                    }
                }
                if (args.headLimit !== undefined) {
                    label += ` | head -${args.headLimit}`;
                }
                if (args.glob) {
                    label += ` --include="${args.glob}"`;
                }
                if (args.type) {
                    label += ` --type=${args.type}`;
                }
                if (args.multiline) {
                    label += " -P";
                }
                if (args.pattern) {
                    label += ` "${args.pattern}"`;
                }
                return label;
            }
            case "semSearchToolCall": {
                const query = (_c = t.value.args) === null || _c === void 0 ? void 0 : _c.query;
                return query ? `Search: "${query}"` : "Codebase Search";
            }
            case "editToolCall": {
                const path = (_d = t.value.args) === null || _d === void 0 ? void 0 : _d.path;
                return path ? `Edit \`${path}\`` : "Edit File";
            }
            case "readToolCall": {
                const args = t.value.args;
                if (!(args === null || args === void 0 ? void 0 : args.path))
                    return "Read File";
                const displayPath = this.makePathRelativeIfPossible(args.path);
                let limitInfo = "";
                if (args.limit) {
                    const start = ((_e = args.offset) !== null && _e !== void 0 ? _e : 0) + 1;
                    const end = ((_f = args.offset) !== null && _f !== void 0 ? _f : 0) + args.limit;
                    limitInfo = ` (${start} - ${end})`;
                }
                else if (args.offset) {
                    limitInfo = ` (from line ${args.offset + 1})`;
                }
                return `Read ${displayPath}${limitInfo}`;
            }
            case "deleteToolCall": {
                const path = (_g = t.value.args) === null || _g === void 0 ? void 0 : _g.path;
                return path ? `Delete \`${path}\`` : "Delete File";
            }
            case "lsToolCall": {
                const path = (_h = t.value.args) === null || _h === void 0 ? void 0 : _h.path;
                if (!path) {
                    return "List the current directory's contents";
                }
                const displayPath = this.makePathRelativeIfPossible(path);
                return `List the \`${displayPath}\` directory's contents`;
            }
            case "globToolCall": {
                const args = t.value.args;
                const pattern = (_j = args === null || args === void 0 ? void 0 : args.pattern) !== null && _j !== void 0 ? _j : args === null || args === void 0 ? void 0 : args.globPattern;
                let label = "Find";
                if (args === null || args === void 0 ? void 0 : args.path) {
                    label += ` \`${args.path}\``;
                }
                if (pattern) {
                    label += ` \`${pattern}\``;
                }
                return label;
            }
            case "updateTodosToolCall": {
                const args = t.value.args;
                if (Array.isArray(args === null || args === void 0 ? void 0 : args.todos) && args.todos.length > 0) {
                    const todoContents = args.todos
                        .map(todo => todo.content)
                        .filter(Boolean)
                        .join(", ");
                    return todoContents
                        ? `Update TODOs: ${todoContents}`
                        : "Update TODOs";
                }
                return "Update TODOs";
            }
            case "readTodosToolCall": {
                return "Read TODOs";
            }
            default:
                return null;
        }
    }
    extractToolCallInput(toolCall) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        const t = toolCall.tool;
        switch (t.case) {
            case "shellToolCall":
                return { command: (_a = t.value.args) === null || _a === void 0 ? void 0 : _a.command };
            case "grepToolCall":
                return { pattern: (_b = t.value.args) === null || _b === void 0 ? void 0 : _b.pattern, path: (_c = t.value.args) === null || _c === void 0 ? void 0 : _c.path };
            case "semSearchToolCall":
                return { query: (_d = t.value.args) === null || _d === void 0 ? void 0 : _d.query };
            case "editToolCall":
                return { path: (_e = t.value.args) === null || _e === void 0 ? void 0 : _e.path };
            case "readToolCall":
                return { path: (_f = t.value.args) === null || _f === void 0 ? void 0 : _f.path };
            case "deleteToolCall":
                return { path: (_g = t.value.args) === null || _g === void 0 ? void 0 : _g.path };
            case "lsToolCall":
                return { path: (_h = t.value.args) === null || _h === void 0 ? void 0 : _h.path };
            case "globToolCall": {
                const args = t.value.args;
                return { pattern: (_j = args === null || args === void 0 ? void 0 : args.pattern) !== null && _j !== void 0 ? _j : args === null || args === void 0 ? void 0 : args.globPattern };
            }
            default:
                return undefined;
        }
    }
    extractToolCallContent(toolCall) {
        var _a, _b, _c;
        const t = toolCall.tool;
        switch (t.case) {
            case "editToolCall": {
                const result = (_a = t.value.result) === null || _a === void 0 ? void 0 : _a.result;
                if ((result === null || result === void 0 ? void 0 : result.case) === "success") {
                    const path = result.value.path;
                    const oldText = (_b = result.value.beforeFullFileContent) !== null && _b !== void 0 ? _b : null;
                    const newText = result.value.afterFullFileContent;
                    return [
                        {
                            type: "diff",
                            path,
                            oldText,
                            newText,
                        },
                    ];
                }
                break;
            }
            case "deleteToolCall": {
                const result = (_c = t.value.result) === null || _c === void 0 ? void 0 : _c.result;
                if ((result === null || result === void 0 ? void 0 : result.case) === "success") {
                    const path = result.value.path;
                    const oldText = result.value.deletedFile;
                    const newText = "";
                    return [
                        {
                            type: "diff",
                            path,
                            oldText,
                            newText,
                        },
                    ];
                }
                break;
            }
            default:
                return undefined;
        }
        return undefined;
    }
    extractToolCallOutput(toolCall) {
        var _a, _b;
        const t = toolCall.tool;
        switch (t.case) {
            case "shellToolCall": {
                const result = (_a = t.value.result) === null || _a === void 0 ? void 0 : _a.result;
                if ((result === null || result === void 0 ? void 0 : result.case) === "success") {
                    return {
                        exitCode: result.value.exitCode,
                        stdout: result.value.stdout,
                        stderr: result.value.stderr,
                    };
                }
                else if ((result === null || result === void 0 ? void 0 : result.case) === "failure") {
                    return {
                        exitCode: result.value.exitCode,
                        stdout: result.value.stdout,
                        stderr: result.value.stderr,
                    };
                }
                break;
            }
            case "readToolCall": {
                const result = (_b = t.value.result) === null || _b === void 0 ? void 0 : _b.result;
                if ((result === null || result === void 0 ? void 0 : result.case) === "success") {
                    const output = result.value.output;
                    if (output.case === "content") {
                        return { content: output.value };
                    }
                }
                break;
            }
            default:
                return undefined;
        }
        return undefined;
    }
}


/***/ }),

/***/ "./src/acp/agent-store.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   i: () => (/* binding */ createAgentStoreForSession)
/* harmony export */ });
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../agent-kv/dist/index.js");
/* harmony import */ var _console_io_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/console-io.ts");
/* harmony import */ var _state_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/state/index.ts");
/* harmony import */ var _state_sqlite_blob_store_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/state/sqlite-blob-store.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





function createAgentStoreForSession(ctx, sessionId, options, deps, modelManager) {
    return __awaiter(this, void 0, void 0, function* () {
        const { resumeChatId, force = false } = options;
        const chatsRoot = (0,_state_index_js__WEBPACK_IMPORTED_MODULE_2__/* .getChatsRootDir */ .r)();
        const resumeId = resumeChatId;
        const agentId = resumeId || sessionId;
        const agentDir = (0,node_path__WEBPACK_IMPORTED_MODULE_0__.join)(chatsRoot, agentId);
        const dbPath = (0,node_path__WEBPACK_IMPORTED_MODULE_0__.join)(agentDir, "store.db");
        let sqliteStore;
        if (resumeId) {
            sqliteStore = yield _state_sqlite_blob_store_js__WEBPACK_IMPORTED_MODULE_3__/* .SQLiteBlobStoreWithMetadata */ .M.initAndLoad(dbPath);
        }
        else {
            sqliteStore = new _state_sqlite_blob_store_js__WEBPACK_IMPORTED_MODULE_3__/* .SQLiteBlobStoreWithMetadata */ .M(dbPath);
        }
        const agentStore = new _anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_1__/* .AgentStore */ .pH(sqliteStore, sqliteStore);
        if (resumeId) {
            try {
                yield agentStore.resetFromDb(ctx);
                const lastUsedModel = agentStore.getMetadata("lastUsedModel");
                yield modelManager.setModelFromStoredId(lastUsedModel, deps.configProvider);
            }
            catch (e) {
                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_4__/* .exitWithMessage */ .uQ)(1, `Failed to resume chat "${resumeId}": ${e instanceof Error ? e.message : String(e)}`);
            }
        }
        if (force) {
            agentStore.setMetadata("mode", "auto-run");
        }
        return agentStore;
    });
}


/***/ }),

/***/ "./src/acp/cursor-acp-agent.ts":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   o: () => (/* binding */ CursorACPAgent)
/* harmony export */ });
/* harmony import */ var _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../cursor-config/dist/index.js");
/* harmony import */ var _zed_industries_agent_client_protocol__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/@zed-industries+agent-client-protocol@0.4.5/node_modules/@zed-industries/agent-client-protocol/dist/acp.js");
/* harmony import */ var _debug_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/debug.ts");
/* harmony import */ var _onboarding_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/onboarding.tsx");
/* harmony import */ var _utils_open_browser_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/utils/open-browser.ts");
/* harmony import */ var _agent_session_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/acp/agent-session.ts");
/* harmony import */ var _agent_store_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/acp/agent-store.ts");
/* harmony import */ var _session_resources_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/acp/session-resources.ts");
/* harmony import */ var _types_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/acp/types.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_onboarding_js__WEBPACK_IMPORTED_MODULE_3__]);
_onboarding_js__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};









/**
 * CursorACPAgent implements the Agent protocol interface, managing agent sessions
 * and handling communication with the agent client protocol connection.
 */
class CursorACPAgent {
    constructor(connection, deps, ctx, options, authConfig, sharedServices) {
        this.connection = connection;
        this.sessions = new Map();
        this.deps = deps;
        this.ctx = ctx;
        this.options = options;
        this.sharedServices = sharedServices;
        this.authConfig = authConfig;
        this.isAuthenticated = authConfig.isAuthenticated;
    }
    initialize(_params) {
        return __awaiter(this, void 0, void 0, function* () {
            (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("ACP initialize called, isAuthenticated:", this.isAuthenticated);
            // Advertise supported auth methods per ACP spec.
            const authMethods = [
                {
                    id: _types_js__WEBPACK_IMPORTED_MODULE_8__/* .ACP_AUTH_METHODS */ .f.CURSOR_LOGIN,
                    name: "Cursor Login",
                    description: "Authenticate using existing Cursor login credentials. Run 'cursor-agent login' first if not logged in.",
                },
            ];
            return {
                protocolVersion: _zed_industries_agent_client_protocol__WEBPACK_IMPORTED_MODULE_1__/* .PROTOCOL_VERSION */ .WP,
                agentCapabilities: {
                    loadSession: false,
                    promptCapabilities: {
                        image: true,
                    },
                },
                authMethods,
            };
        });
    }
    newSession(_params) {
        return __awaiter(this, void 0, void 0, function* () {
            // Gate session creation on authentication
            if (!this.isAuthenticated || !this.sharedServices) {
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("Session creation rejected: not authenticated");
                throw _zed_industries_agent_client_protocol__WEBPACK_IMPORTED_MODULE_1__/* .RequestError */ .GI.authRequired({
                    message: "Authentication required. Please run 'cursor-agent login' first, then call authenticate() with methodId 'cursor_login'.",
                });
            }
            const sessionId = crypto.randomUUID();
            const agentStore = yield (0,_agent_store_js__WEBPACK_IMPORTED_MODULE_6__/* .createAgentStoreForSession */ .i)(this.ctx, sessionId, this.options, this.deps, this.sharedServices.modelManager);
            const resources = yield (0,_session_resources_js__WEBPACK_IMPORTED_MODULE_7__/* .createSessionResources */ .Y)(this.connection, sessionId, this.sharedServices, agentStore, this.options);
            const currentModel = yield this.sharedServices.modelManager.awaitCurrentModel();
            const availableModels = yield this.sharedServices.modelManager.awaitAvailableModels();
            const agentSession = new _agent_session_js__WEBPACK_IMPORTED_MODULE_5__/* .AgentSession */ .m(this.connection, sessionId, this.sharedServices, this.ctx, agentStore, resources, currentModel);
            this.sessions.set(sessionId, agentSession);
            // Advertise available slash commands per ACP spec
            // https://agentclientprotocol.com/protocol/slash-commands
            // Must happen AFTER returning the sessionId (use setTimeout)
            setTimeout(() => {
                agentSession.sendAvailableCommands().catch(err => {
                    // Log if client doesn't support available_commands_update
                    console.error("Failed to send available commands:", err);
                });
            }, 0);
            return {
                sessionId,
                modes: this.buildModesState(currentModel, availableModels),
            };
        });
    }
    setSessionMode(params) {
        return __awaiter(this, void 0, void 0, function* () {
            const session = this.sessions.get(params.sessionId);
            if (!session) {
                throw new Error(`Session ${params.sessionId} not found`);
            }
            if (!this.sharedServices) {
                throw new Error("Not authenticated");
            }
            const model = this.sharedServices.modelManager.normalizeModelId(params.modeId);
            if (!model) {
                throw new Error(`Invalid model ID: ${params.modeId}`);
            }
            yield this.sharedServices.modelManager.setCurrentModel(model, this.deps.configProvider);
            session.setCurrentModel(model);
            return {};
        });
    }
    buildModesState(currentModel, availableModels) {
        return {
            currentModeId: currentModel.modelId,
            availableModes: availableModels.map(model => ({
                id: model.modelId,
                name: model.displayModelId,
            })),
        };
    }
    authenticate(params) {
        return __awaiter(this, void 0, void 0, function* () {
            (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("ACP authenticate called with methodId:", params.methodId);
            if (params.methodId !== _types_js__WEBPACK_IMPORTED_MODULE_8__/* .ACP_AUTH_METHODS */ .f.CURSOR_LOGIN) {
                throw _zed_industries_agent_client_protocol__WEBPACK_IMPORTED_MODULE_1__/* .RequestError */ .GI.invalidParams({
                    message: `Unknown authentication method: ${params.methodId}. Supported method: ${_types_js__WEBPACK_IMPORTED_MODULE_8__/* .ACP_AUTH_METHODS */ .f.CURSOR_LOGIN}`,
                });
            }
            // Check if user is logged in via Cursor
            const { credentialManager } = this.authConfig;
            // Check if user is already logged in via Cursor
            const isLoggedIn = yield (0,_onboarding_js__WEBPACK_IMPORTED_MODULE_3__/* .checkAuthenticationStatus */ .h4)(credentialManager, _onboarding_js__WEBPACK_IMPORTED_MODULE_3__/* .AuthType */ .hT.LOGIN);
            (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("Cursor login check result:", isLoggedIn);
            if (!isLoggedIn) {
                // Start the OAuth login flow
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("Starting browser login flow");
                const loginManager = new _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_0__/* .LoginManager */ .Pl();
                const { metadata, loginUrl } = loginManager.startLogin();
                // Open browser for login
                try {
                    yield (0,_utils_open_browser_js__WEBPACK_IMPORTED_MODULE_4__/* .openBrowser */ .p)(loginUrl);
                    (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("Browser opened for login:", loginUrl);
                }
                catch (err) {
                    (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("Failed to open browser:", err);
                    throw _zed_industries_agent_client_protocol__WEBPACK_IMPORTED_MODULE_1__/* .RequestError */ .GI.invalidParams({
                        message: `Failed to open browser for login. Please visit: ${loginUrl}`,
                    });
                }
                // Wait for the OAuth callback
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("Waiting for login result...");
                const authResult = yield loginManager.waitForResult(metadata);
                if (!(authResult === null || authResult === void 0 ? void 0 : authResult.accessToken)) {
                    throw _zed_industries_agent_client_protocol__WEBPACK_IMPORTED_MODULE_1__/* .RequestError */ .GI.invalidParams({
                        message: "Login failed or timed out. Please try again.",
                    });
                }
                // Store the credentials
                yield credentialManager.setAuthentication(authResult.accessToken, authResult.refreshToken);
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("Credentials stored successfully");
            }
            // Initialize shared services if not already done
            if (!this.sharedServices) {
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("Initializing shared services after authentication");
                this.sharedServices = yield this.authConfig.initSharedServices();
            }
            this.isAuthenticated = true;
            (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("Authentication successful");
        });
    }
    prompt(params) {
        return __awaiter(this, void 0, void 0, function* () {
            const session = this.sessions.get(params.sessionId);
            if (!session) {
                throw new Error(`Session ${params.sessionId} not found`);
            }
            return yield session.handlePrompt(params);
        });
    }
    cancel(params) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a;
            const session = this.sessions.get(params.sessionId);
            (_a = session === null || session === void 0 ? void 0 : session.pendingPromptCancel) === null || _a === void 0 ? void 0 : _a.call(session);
            return;
        });
    }
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/acp/run.ts":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   w: () => (/* binding */ runAcp)
/* harmony export */ });
/* harmony import */ var _zed_industries_agent_client_protocol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/@zed-industries+agent-client-protocol@0.4.5/node_modules/@zed-industries/agent-client-protocol/dist/acp.js");
/* harmony import */ var _analytics_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/analytics.ts");
/* harmony import */ var _api_key_auth_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/api-key-auth.ts");
/* harmony import */ var _client_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/client.ts");
/* harmony import */ var _debug_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/debug.ts");
/* harmony import */ var _onboarding_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/onboarding.tsx");
/* harmony import */ var _tracing_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/tracing.ts");
/* harmony import */ var _utils_api_endpoint_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("./src/utils/api-endpoint.ts");
/* harmony import */ var _cursor_acp_agent_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/acp/cursor-acp-agent.ts");
/* harmony import */ var _shared_services_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/acp/shared-services.ts");
/* harmony import */ var _streams_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("./src/acp/streams.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_onboarding_js__WEBPACK_IMPORTED_MODULE_5__, _cursor_acp_agent_js__WEBPACK_IMPORTED_MODULE_7__]);
([_onboarding_js__WEBPACK_IMPORTED_MODULE_5__, _cursor_acp_agent_js__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











function runAcp(ctx, options, deps) {
    return __awaiter(this, void 0, void 0, function* () {
        const backendUrl = (0,_utils_api_endpoint_js__WEBPACK_IMPORTED_MODULE_10__/* .getApiEndpoint */ .G6)(options.endpoint);
        yield (0,_tracing_js__WEBPACK_IMPORTED_MODULE_6__/* .initTracing */ .H)({
            backendUrl,
            credentialManager: deps.credentialManager,
            configProvider: deps.configProvider,
        });
        try {
            (0,_client_js__WEBPACK_IMPORTED_MODULE_3__/* .initAnalytics */ .Bu)(deps.credentialManager, {
                endpoint: backendUrl,
                insecure: options.insecure,
            });
        }
        catch (_a) {
            // don't block on analytics init errors
        }
        // Check if already authenticated via CLI options or existing login
        const { isAuthenticated: isAuthTokenAuthenticated } = yield (0,_api_key_auth_js__WEBPACK_IMPORTED_MODULE_2__/* .tryAuthTokenAuth */ .D)(deps.credentialManager, {
            authToken: options.authToken,
        });
        const { isAuthenticated: isApiKeyAuthenticated } = isAuthTokenAuthenticated
            ? { isAuthenticated: false }
            : yield (0,_api_key_auth_js__WEBPACK_IMPORTED_MODULE_2__/* .tryApiKeyAuth */ .T)(deps.credentialManager, {
                apiKey: options.apiKey,
                endpoint: backendUrl,
            });
        const isExistingLogin = yield (0,_onboarding_js__WEBPACK_IMPORTED_MODULE_5__/* .checkAuthenticationStatus */ .h4)(deps.credentialManager, _onboarding_js__WEBPACK_IMPORTED_MODULE_5__/* .AuthType */ .hT.LOGIN);
        const isPreAuthenticated = isAuthTokenAuthenticated || isApiKeyAuthenticated || isExistingLogin;
        (0,_debug_js__WEBPACK_IMPORTED_MODULE_4__.debugLog)("ACP pre-authentication check:", {
            isAuthTokenAuthenticated,
            isApiKeyAuthenticated,
            isExistingLogin,
            isPreAuthenticated,
        });
        // If pre-authenticated, initialize shared services now.
        // Otherwise, they will be initialized lazily after authentication.
        let sharedServices = null;
        if (isPreAuthenticated) {
            try {
                (0,_analytics_js__WEBPACK_IMPORTED_MODULE_1__/* .trackEvent */ .sx)("cli.launch");
            }
            catch (_b) {
                // ignore analytics errors
            }
            sharedServices = yield (0,_shared_services_js__WEBPACK_IMPORTED_MODULE_8__/* .initializeAcpSharedServices */ .Q)(ctx, options, deps, backendUrl);
        }
        // Factory function to initialize shared services after authentication
        const initSharedServices = () => __awaiter(this, void 0, void 0, function* () {
            if (sharedServices) {
                return sharedServices;
            }
            try {
                (0,_analytics_js__WEBPACK_IMPORTED_MODULE_1__/* .trackEvent */ .sx)("cli.launch");
            }
            catch (_a) {
                // ignore analytics errors
            }
            sharedServices = yield (0,_shared_services_js__WEBPACK_IMPORTED_MODULE_8__/* .initializeAcpSharedServices */ .Q)(ctx, options, deps, backendUrl);
            return sharedServices;
        });
        // Build auth config to pass to the agent
        const authConfig = {
            credentialManager: deps.credentialManager,
            backendUrl,
            isAuthenticated: isPreAuthenticated,
            initSharedServices,
        };
        process.on("unhandledRejection", (_reason, _promise) => {
            // noop
        });
        const output = (0,_streams_js__WEBPACK_IMPORTED_MODULE_9__/* .nodeToWebWritable */ .W)(process.stdout);
        const input = (0,_streams_js__WEBPACK_IMPORTED_MODULE_9__/* .nodeToWebReadable */ .G)(process.stdin);
        // Cast Node.js stream/web types to global Web Streams API types
        const stream = (0,_zed_industries_agent_client_protocol__WEBPACK_IMPORTED_MODULE_0__/* .ndJsonStream */ .Z2)(output, input);
        new _zed_industries_agent_client_protocol__WEBPACK_IMPORTED_MODULE_0__/* .AgentSideConnection */ .Bi(conn => new _cursor_acp_agent_js__WEBPACK_IMPORTED_MODULE_7__/* .CursorACPAgent */ .o(conn, deps, ctx, options, authConfig, sharedServices), stream);
        process.stdin.resume();
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/acp/session-resources.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  Y: () => (/* binding */ createSessionResources)
});

// EXTERNAL MODULE: external "node:os"
var external_node_os_ = __webpack_require__("node:os");
// EXTERNAL MODULE: external "node:path"
var external_node_path_ = __webpack_require__("node:path");
var external_node_path_default = /*#__PURE__*/__webpack_require__.n(external_node_path_);
// EXTERNAL MODULE: ../cursor-config/dist/index.js + 11 modules
var dist = __webpack_require__("../cursor-config/dist/index.js");
// EXTERNAL MODULE: ../hooks-exec/dist/index.js + 25 modules
var hooks_exec_dist = __webpack_require__("../hooks-exec/dist/index.js");
// EXTERNAL MODULE: ../local-exec/dist/index.js + 77 modules
var local_exec_dist = __webpack_require__("../local-exec/dist/index.js");
// EXTERNAL MODULE: ../shell-exec/dist/index.js + 19 modules
var shell_exec_dist = __webpack_require__("../shell-exec/dist/index.js");
// EXTERNAL MODULE: ./src/always-approve-decision-provider.ts
var always_approve_decision_provider = __webpack_require__("./src/always-approve-decision-provider.ts");
;// ./src/acp/acp-decision-provider.ts
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class AcpDecisionProvider {
    constructor(connection, sessionId, addToAllowList) {
        this.connection = connection;
        this.sessionId = sessionId;
        this.addToAllowList = addToAllowList;
    }
    requestApproval(operation) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a;
            if (!operation.toolCallId) {
                return { approved: true };
            }
            const { title, kind, content } = this.formatOperation(operation);
            const request = {
                sessionId: this.sessionId,
                toolCall: {
                    toolCallId: (_a = operation.toolCallId) !== null && _a !== void 0 ? _a : `decision_${Date.now()}`,
                    title: title,
                    kind,
                    status: "pending",
                    content,
                },
                options: [
                    {
                        optionId: "allow-once",
                        name: "Allow once",
                        kind: "allow_once",
                    },
                    {
                        optionId: "allow-always",
                        name: "Allow always",
                        kind: "allow_always",
                    },
                    {
                        optionId: "reject-once",
                        name: "Reject",
                        kind: "reject_once",
                    },
                ],
            };
            try {
                const response = yield this.connection.requestPermission(request);
                if (response.outcome.outcome === "cancelled") {
                    return { approved: false, reason: "Cancelled" };
                }
                if (response.outcome.outcome === "selected") {
                    const optionId = response.outcome.optionId;
                    const approved = optionId === "allow-once" || optionId === "allow-always";
                    if (optionId === "allow-always") {
                        yield this.persistAllowlistEntry(operation);
                    }
                    return approved
                        ? { approved: true }
                        : { approved: false, reason: "User rejected" };
                }
                return { approved: false, reason: "Unknown response" };
            }
            catch (error) {
                return {
                    approved: false,
                    reason: error instanceof Error ? error.message : "Request failed",
                };
            }
        });
    }
    formatOperation(operation) {
        var _a, _b;
        switch (operation.type) {
            case local_exec_dist/* OperationType */.S5.Write: {
                const path = operation.details.path;
                const isNew = operation.details.isNewFile;
                return {
                    title: isNew ? `Write ${path}` : `Edit \`${path}\``,
                    kind: "edit",
                    content: [
                        {
                            type: "diff",
                            path,
                            oldText: (_a = operation.details.before) !== null && _a !== void 0 ? _a : null,
                            newText: (_b = operation.details.after) !== null && _b !== void 0 ? _b : "",
                        },
                    ],
                };
            }
            case local_exec_dist/* OperationType */.S5.Shell: {
                const command = operation.details.command;
                const displayCommand = command.replaceAll("`", "\\`");
                return {
                    title: `\`${displayCommand}\``,
                    kind: "execute",
                    content: operation.details.reason
                        ? [
                            {
                                type: "content",
                                content: {
                                    type: "text",
                                    text: operation.details.reason,
                                },
                            },
                        ]
                        : undefined,
                };
            }
            case local_exec_dist/* OperationType */.S5.Delete: {
                const path = operation.details.path;
                return {
                    title: `Delete \`${path}\``,
                    kind: "edit",
                    content: undefined,
                };
            }
            case local_exec_dist/* OperationType */.S5.Mcp: {
                const toolName = operation.details.toolName;
                const providerName = operation.details.name;
                return {
                    title: `${providerName}: ${toolName}`,
                    kind: "other",
                    content: [
                        {
                            type: "content",
                            content: {
                                type: "text",
                                text: `\`\`\`json\n${JSON.stringify(operation.details.args, null, 2)}\n\`\`\``,
                            },
                        },
                    ],
                };
            }
            default:
                return {
                    title: "Unknown operation",
                    kind: "other",
                    content: undefined,
                };
        }
    }
    persistAllowlistEntry(operation) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a;
            switch (operation.type) {
                case local_exec_dist/* OperationType */.S5.Shell: {
                    // Use the patterns from notAllowedCommands if available, otherwise use the command
                    const patterns = (_a = operation.details.notAllowedCommands) !== null && _a !== void 0 ? _a : [
                        operation.details.command,
                    ];
                    for (const pattern of patterns) {
                        yield this.addToAllowList("Shell", pattern);
                    }
                    break;
                }
                case local_exec_dist/* OperationType */.S5.Write: {
                    const path = operation.details.path;
                    yield this.addToAllowList("Write", path);
                    break;
                }
                case local_exec_dist/* OperationType */.S5.Delete: {
                    // Delete operations don't have a separate allowlist category
                    // They fall under Write permissions
                    const path = operation.details.path;
                    yield this.addToAllowList("Write", path);
                    break;
                }
                case local_exec_dist/* OperationType */.S5.Mcp: {
                    // For MCP, use the provider identifier and tool name
                    const identifier = `${operation.details.providerIdentifier}:${operation.details.toolName}`;
                    yield this.addToAllowList("Mcp", identifier);
                    break;
                }
            }
        });
    }
}

;// ./src/acp/session-resources.ts
var session_resources_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








function createSessionResources(connection, sessionId, sharedServices, _agentStore, options) {
    return session_resources_awaiter(this, void 0, void 0, function* () {
        const { force = false } = options;
        // Create addToAllowList function using the permissions provider
        const addToAllowList = (kind, value) => session_resources_awaiter(this, void 0, void 0, function* () {
            const entry = `${kind}(${value})`;
            yield sharedServices.permissionsProvider.updatePermissions(perms => {
                const allow = perms.allow.includes(entry)
                    ? perms.allow
                    : [...perms.allow, entry];
                return Object.assign(Object.assign({}, perms), { allow });
            });
        });
        const decisionProvider = force
            ? new always_approve_decision_provider/* AlwaysApproveDecisionProvider */.I()
            : new AcpDecisionProvider(connection, sessionId, addToAllowList);
        const permissionsService = new local_exec_dist/* InteractivePermissionsService */.kh(sharedServices.ignoreService, decisionProvider, sharedServices.permissionsProvider, sharedServices.teamSettingsService);
        const workspacePath = process.cwd();
        const gitExecutor = new local_exec_dist/* LocalGitExecutor */.xK();
        const projectDir = (0,dist/* getProjectDir */.Xq)(workspacePath);
        const baseResources = new local_exec_dist/* LocalResourceProvider */.Dv({
            pendingDecisionStore: decisionProvider,
            fileChangeTracker: sharedServices.fileChangeTracker,
            gitExecutor,
            ignoreService: sharedServices.ignoreService,
            grepProvider: sharedServices.grepProvider,
            permissionsService,
            workspacePaths: [workspacePath],
            diagnosticsProvider: sharedServices.diagnosticsProvider,
            mcpLease: sharedServices.mcpLease,
            cursorRulesService: sharedServices.cursorRulesService,
            subagentsService: sharedServices.subagentsService,
            repositoryProvider: sharedServices.codebaseReferenceProvider,
            projectDir,
        });
        // Load hooks configuration
        const hooksConfigPaths = {
            userConfigPath: external_node_path_default().join((0,external_node_os_.homedir)(), ".cursor", "hooks.json"),
            projectConfigPath: external_node_path_default().join(projectDir, ".cursor", "hooks.json"),
        };
        const fileReader = new hooks_exec_dist/* NodeFileReader */.IF();
        const configLoader = new hooks_exec_dist/* HooksConfigLoader */.gY(fileReader, hooksConfigPaths);
        const hooksConfig = yield configLoader.load();
        // Wrap with hooks support if any hooks are configured
        if (hooksConfig.userHooks || hooksConfig.projectHooks) {
            const globalContext = {
                cursor_version: "1.0.0", // TODO: Get actual version
                user_email: null, // TODO: Get user email if available
            };
            const terminalExecutor = (0,shell_exec_dist/* createDefaultTerminalExecutor */.Fn)();
            const hookExecutor = new hooks_exec_dist/* CliHooksExecutor */.WL(hooksConfig, projectDir, globalContext, terminalExecutor);
            return new hooks_exec_dist/* ListableHooksResourceAccessor */.ae(baseResources, hookExecutor, () => ({
                conversation_id: sessionId,
                generation_id: sessionId, // Use sessionId as generation_id for ACP
                model: "unknown",
            }));
        }
        return baseResources;
    });
}


/***/ }),

/***/ "./src/acp/shared-services.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: () => (/* binding */ initializeAcpSharedServices)
/* harmony export */ });
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:os");
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_os__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../cursor-config/dist/index.js");
/* harmony import */ var _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../local-exec/dist/index.js");
/* harmony import */ var _client_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/client.ts");
/* harmony import */ var _models_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/models/index.ts");
/* harmony import */ var _state_session_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/state/session.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







function initializeAcpSharedServices(ctx, options, deps, backendUrl) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c;
        const { rgPath } = deps;
        const { withDiffs = false, model } = options;
        const cwd = process.cwd();
        const fileChangeTracker = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_3__/* .FileChangeTracker */ .$1(cwd);
        if (withDiffs) {
            const { buildFileChanges, collectGitStatuses } = yield __webpack_require__.e(/* import() */ 9156).then(__webpack_require__.bind(__webpack_require__, "./src/utils/git-diffs.ts"));
            const fileChanges = buildFileChanges(collectGitStatuses());
            for (const file of fileChanges) {
                fileChangeTracker.trackChange(file.path, file.before, file.after);
            }
        }
        const aiServerClient = (0,_client_js__WEBPACK_IMPORTED_MODULE_4__/* .createAiServerClient */ .t9)(deps.credentialManager, {
            backendUrl,
            insecure: options.insecure,
            configProvider: deps.configProvider,
        });
        const dashboardClient = (0,_anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_2__/* .createDashboardClient */ .Vi)({
            credentialManager: deps.credentialManager,
            endpoint: backendUrl,
            configProvider: deps.configProvider,
        });
        // Fetch server config to get feature flags
        const serverConfigServiceClient = (0,_client_js__WEBPACK_IMPORTED_MODULE_4__/* .createServerConfigServiceClient */ .ms)(deps.credentialManager, backendUrl, (_a = options.insecure) !== null && _a !== void 0 ? _a : false, deps.configProvider);
        const serverConfigService = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_3__/* .ConnectServerConfigService */ .J1(serverConfigServiceClient);
        const serverConfig = yield serverConfigService.fetchServerConfig();
        const useNlbForNal = (_b = serverConfig.useNlbForNal) !== null && _b !== void 0 ? _b : false;
        const middleware = (req, next) => {
            _state_session_js__WEBPACK_IMPORTED_MODULE_6__/* .session */ .d.recordLastRequest(req.requestId, { path: req.inner.url });
            return next(req);
        };
        const agentClient = (0,_client_js__WEBPACK_IMPORTED_MODULE_4__/* .createAgentClient */ .hO)(deps.credentialManager, {
            backendUrl,
            insecure: options.insecure,
            requestMiddleware: middleware,
            configProvider: deps.configProvider,
            useNlbForNal,
        });
        const gitExecutor = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_3__/* .LocalGitExecutor */ .xK();
        const projectDir = (_c = (yield (0,_anysphere_local_exec__WEBPACK_IMPORTED_MODULE_3__/* .findGitRoot */ .ky)(ctx, gitExecutor, cwd))) !== null && _c !== void 0 ? _c : cwd;
        // Load CLAUDE.md files by default for agent-cli
        const getClaudeMdEnabled = () => true;
        const cursorRulesService = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_3__/* .LocalCursorRulesService */ .KO(ctx, gitExecutor, cwd, rgPath, false, getClaudeMdEnabled, undefined);
        const subagentsService = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_3__/* .MergedSubagentsService */ .o_([
            new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_3__/* .LocalSubagentsService */ .Vz(cwd),
            new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_3__/* .CursorRulesSubagentsService */ .di(cursorRulesService),
        ]);
        const teamSettingsService = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_3__/* .ConnectTeamSettingsService */ ._u(dashboardClient);
        const mcpLoader = _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_2__/* .CursorConfigMcpLoader */ .aK.init(teamSettingsService, cwd, projectDir);
        const ignoreService = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_3__/* .LazyIgnoreService */ .E1(gitExecutor, rgPath, teamSettingsService);
        const modelManager = yield _models_index_js__WEBPACK_IMPORTED_MODULE_5__/* .ModelManager */ .P3.init(aiServerClient, {
            configProvider: deps.configProvider,
            initialModel: model,
        });
        const mcpManager = yield mcpLoader.load(ctx);
        const mcpLease = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_3__/* .ManagerMcpLease */ .uz(mcpManager);
        const permissionsProviders = [];
        const localPermissionsProvider = new _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_2__/* .ConfigPermissionsAdapter */ .QX(deps.configProvider);
        permissionsProviders.push(localPermissionsProvider);
        const claudeProjectPermissionsProvider = yield _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_2__/* .ReadOnlyFileBasedPermissionsProvider */ .N2.loadFromPath(node_path__WEBPACK_IMPORTED_MODULE_1___default().join(projectDir, ".claude", "settings.json"));
        if (claudeProjectPermissionsProvider) {
            permissionsProviders.push(claudeProjectPermissionsProvider);
        }
        const claudeGlobalPermissionsProvider = yield _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_2__/* .ReadOnlyFileBasedPermissionsProvider */ .N2.loadFromPath(node_path__WEBPACK_IMPORTED_MODULE_1___default().join((0,node_os__WEBPACK_IMPORTED_MODULE_0__.homedir)(), ".claude", "settings.json"));
        if (claudeGlobalPermissionsProvider) {
            permissionsProviders.push(claudeGlobalPermissionsProvider);
        }
        const permissionsProvider = new _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_2__/* .MergedPermissionsProvider */ .Ol(permissionsProviders);
        const grepProvider = {
            rgPath,
            // TODO: indexedGrep is not available in agent-cli yet because we don't run the cursor-retrieval extension here
            executeIndexedGrep: undefined,
        };
        return {
            modelManager,
            agentClient,
            mcpLease,
            fileChangeTracker,
            ignoreService,
            permissionsProvider,
            teamSettingsService,
            cursorRulesService,
            subagentsService,
            diagnosticsProvider: deps.diagnosticsProvider,
            codebaseReferenceProvider: deps.codebaseReferenceProvider,
            grepProvider,
        };
    });
}


/***/ }),

/***/ "./src/acp/streams.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   G: () => (/* binding */ nodeToWebReadable),
/* harmony export */   W: () => (/* binding */ nodeToWebWritable)
/* harmony export */ });
/* harmony import */ var node_stream_web__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:stream/web");
/* harmony import */ var node_stream_web__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_stream_web__WEBPACK_IMPORTED_MODULE_0__);

function nodeToWebWritable(nodeStream) {
    return new node_stream_web__WEBPACK_IMPORTED_MODULE_0__.WritableStream({
        write(chunk) {
            return new Promise((resolve, reject) => {
                nodeStream.write(Buffer.from(chunk), err => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            });
        },
    });
}
function nodeToWebReadable(nodeStream) {
    return new node_stream_web__WEBPACK_IMPORTED_MODULE_0__.ReadableStream({
        start(controller) {
            nodeStream.on("data", (chunk) => {
                controller.enqueue(new Uint8Array(chunk));
            });
            nodeStream.on("end", () => controller.close());
            nodeStream.on("error", err => controller.error(err));
        },
    });
}


/***/ }),

/***/ "./src/acp/types.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   f: () => (/* binding */ ACP_AUTH_METHODS)
/* harmony export */ });
/**
 * Authentication method IDs for ACP.
 * These are advertised to clients during initialization and used
 * in authenticate() calls.
 */
const ACP_AUTH_METHODS = {
    /** Authenticate using existing Cursor login credentials stored on this machine */
    CURSOR_LOGIN: "cursor_login",
};


/***/ }),

/***/ "./src/commands/acp.ts":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   runAcp: () => (/* reexport safe */ _acp_run_js__WEBPACK_IMPORTED_MODULE_0__.w)
/* harmony export */ });
/* harmony import */ var _acp_run_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/acp/run.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_acp_run_js__WEBPACK_IMPORTED_MODULE_0__]);
_acp_run_js__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;