"use strict";
exports.id = 4467;
exports.ids = [4467,9156];
exports.modules = {

/***/ "./src/always-deny-decision-provider.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   N: () => (/* binding */ AlwaysDenyDecisionProvider)
/* harmony export */ });
class AlwaysDenyDecisionProvider {
    requestApproval(_operation) {
        return Promise.resolve({ approved: false });
    }
}


/***/ }),

/***/ "./src/commands/sandbox-debug.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleSandboxDebug: () => (/* binding */ handleSandboxDebug)
/* harmony export */ });
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:child_process");
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_child_process__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_fs_promises__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:fs/promises");
/* harmony import */ var node_fs_promises__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_fs_promises__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("node:os");
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(node_os__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _anysphere_context__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../context/dist/index.js");
/* harmony import */ var _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../cursor-config/dist/index.js");
/* harmony import */ var _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../local-exec/dist/index.js");
/* harmony import */ var _anysphere_shell_exec__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../shell-exec/dist/index.js");
/* harmony import */ var _always_deny_decision_provider_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("./src/always-deny-decision-provider.ts");
/* harmony import */ var _console_io_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("./src/console-io.ts");
/* harmony import */ var _shared_resources_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/shared/resources.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __addDisposableResource = (undefined && undefined.__addDisposableResource) || function (env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose, inner;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
            if (async) inner = dispose;
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;
};
var __disposeResources = (undefined && undefined.__disposeResources) || (function (SuppressedError) {
    return function (env) {
        function fail(e) {
            env.error = env.hasError ? new SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
            env.hasError = true;
        }
        var r, s = 0;
        function next() {
            while (r = env.stack.pop()) {
                try {
                    if (!r.async && s === 1) return s = 0, env.stack.push(r), Promise.resolve().then(next);
                    if (r.dispose) {
                        var result = r.dispose.call(r.value);
                        if (r.async) return s |= 2, Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
                    }
                    else s |= 1;
                }
                catch (e) {
                    fail(e);
                }
            }
            if (s === 1) return env.hasError ? Promise.reject(env.error) : Promise.resolve();
            if (env.hasError) throw env.error;
        }
        return next();
    };
})(typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
});
var __asyncValues = (undefined && undefined.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};











function getWorkspaceIgnoreMapping(workspaceRoot, rgPath) {
    return __awaiter(this, void 0, void 0, function* () {
        // Create a LazyIgnoreService to build mapping with ripgrep; no team settings in CLI
        const gitExecutor = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .LocalGitExecutor */ .xK();
        const ignoreService = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .LazyIgnoreService */ .E1(gitExecutor, rgPath, undefined, [
            workspaceRoot,
        ]);
        const cursorMapping = yield ignoreService.getCursorIgnoreMapping();
        return Object.assign({}, cursorMapping);
    });
}
function handleSandboxDebug(ctx, cmd, args, options) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, e_1, _b, _c;
        const env_1 = { stack: [], error: void 0, hasError: false };
        try {
            const span = __addDisposableResource(env_1, (0,_anysphere_context__WEBPACK_IMPORTED_MODULE_4__/* .createSpan */ .VI)(ctx.withName("handleSandboxDebug")), false);
            const allowRw = String(options.allowPaths || "")
                .split(",")
                .map((s) => s.trim())
                .filter((s) => s.length > 0);
            const allowRo = String(options.readonlyPaths || "")
                .split(",")
                .map((s) => s.trim())
                .filter((s) => s.length > 0);
            const blockedPatterns = String(options.blockedPatterns || "")
                .split(",")
                .map((s) => s.trim())
                .filter((s) => s.length > 0);
            // Load file-based ignore patterns across the entire workspace
            const cwd = process.cwd();
            const resolveWorkspaceRoot = (dir) => {
                try {
                    const out = (0,node_child_process__WEBPACK_IMPORTED_MODULE_0__.execFileSync)("git", ["rev-parse", "--show-toplevel"], {
                        cwd: dir,
                        stdio: ["ignore", "pipe", "ignore"],
                    });
                    const root = out.toString("utf8").trim();
                    if (root && root.length > 0)
                        return root;
                }
                catch (_a) {
                    // ignore
                }
                return (0,_anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_5__/* .getProjectDir */ .Xq)(dir);
            };
            const projectRoot = resolveWorkspaceRoot(cwd);
            // Fetch workspace ignore mapping from LocalIgnoreService and union CLI-provided blocklist at root
            const baseMapping = yield getWorkspaceIgnoreMapping(projectRoot, options.rgPath);
            const extra = (0,_anysphere_shell_exec__WEBPACK_IMPORTED_MODULE_7__/* .createIgnoreMapping */ .nq)(blockedPatterns, projectRoot);
            const ignoreMapping = Object.assign(Object.assign({}, baseMapping), extra);
            const debugDir = options.sbDebug
                ? `${node_os__WEBPACK_IMPORTED_MODULE_2__.tmpdir()}/cursor-sandbox-${Date.now()}`
                : undefined;
            if (debugDir && debugDir.length > 0) {
                try {
                    yield node_fs_promises__WEBPACK_IMPORTED_MODULE_1__.mkdir(debugDir, { recursive: true });
                }
                catch (_d) {
                    (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Error creating debug directory: ${debugDir}`);
                }
            }
            // Reconstruct the command string for analysis
            const command = args && args.length > 0 ? `${cmd} ${args.join(" ")}` : cmd;
            try {
                // Use shared builder to mirror CLI setup (for dry-run only)
                const configProvider = yield _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_5__/* .FileBasedConfigProvider */ .FO.loadFromDefaults(ctx);
                const dryRunDecisionProvider = new _always_deny_decision_provider_js__WEBPACK_IMPORTED_MODULE_10__/* .AlwaysDenyDecisionProvider */ .N();
                yield (0,_shared_resources_js__WEBPACK_IMPORTED_MODULE_8__/* .buildCliResources */ ._)(span.ctx, {
                    configProvider,
                    decisionProvider: dryRunDecisionProvider,
                    workingDirectory: process.cwd(),
                    getIsAutoRun: () => false,
                    rgPath: options.rgPath,
                });
                // Now execute the command using the same path as the CLI (local-exec)
                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Executing command: ${command}`);
                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Working directory: ${process.cwd()}`);
                const policy = options.sandbox
                    ? {
                        type: "workspace_readwrite",
                        network_access: !!options.network,
                        additional_readwrite_paths: allowRw,
                        additional_readonly_paths: allowRo,
                        debugOutputDir: debugDir,
                        ignore_mapping: ignoreMapping,
                        block_git_writes: true,
                    }
                    : { type: "insecure_none", debugOutputDir: debugDir };
                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Sandbox policy: ${JSON.stringify(policy, null, 2)}\n`);
                const terminalExecutor = (0,_anysphere_shell_exec__WEBPACK_IMPORTED_MODULE_7__/* .createDefaultTerminalExecutor */ .Fn)();
                const core = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .BaseShellCoreExecutor */ .MX(terminalExecutor);
                let stdout = "";
                let stderr = "";
                let exitCode = null;
                let denyEventsCaptured = [];
                try {
                    for (var _e = true, _f = __asyncValues(core.execute(span.ctx, {
                        command,
                        workingDirectory: process.cwd(),
                        sandboxPolicy: policy,
                        captureSandboxDenies: true,
                    })), _g; _g = yield _f.next(), _a = _g.done, !_a; _e = true) {
                        _c = _g.value;
                        _e = false;
                        const event = _c;
                        if (event.type === "stdout")
                            stdout += event.data;
                        else if (event.type === "stderr")
                            stderr += event.data;
                        else if (event.type === "exit")
                            exitCode = event.code;
                        else if (event.type === "sandbox_denies")
                            denyEventsCaptured = event.events;
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (!_e && !_a && (_b = _f.return)) yield _b.call(_f);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                // Save full outputs to debug dir if available
                let savedStdoutPath = "";
                let savedStderrPath = "";
                if (debugDir) {
                    const ts = new Date().toISOString().replace(/[:.]/g, "-");
                    savedStdoutPath = node_path__WEBPACK_IMPORTED_MODULE_3___default().join(debugDir, `stdout-${ts}.log`);
                    savedStderrPath = node_path__WEBPACK_IMPORTED_MODULE_3___default().join(debugDir, `stderr-${ts}.log`);
                    try {
                        yield node_fs_promises__WEBPACK_IMPORTED_MODULE_1__.writeFile(savedStdoutPath, stdout !== null && stdout !== void 0 ? stdout : "");
                        yield node_fs_promises__WEBPACK_IMPORTED_MODULE_1__.writeFile(savedStderrPath, stderr !== null && stderr !== void 0 ? stderr : "");
                    }
                    catch (_h) {
                        // ignore
                    }
                }
                const tail = (text, n) => {
                    const lines = (text || "").split(/\r?\n/);
                    const last = lines.slice(-n).join("\n");
                    return last;
                };
                if (exitCode === 0) {
                    (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`\n=== COMMAND SUCCESS ===`);
                    (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Exit code: 0`);
                    if (stdout) {
                        const t = tail(stdout, 500);
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`\nSTDOUT (last 500 lines):\n${t}`);
                        if (debugDir && savedStdoutPath)
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Full STDOUT saved to: ${savedStdoutPath}`);
                    }
                    if (stderr) {
                        const t = tail(stderr, 500);
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`\nSTDERR (last 500 lines):\n${t}`);
                        if (debugDir && savedStderrPath)
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Full STDERR saved to: ${savedStderrPath}`);
                    }
                }
                else {
                    (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`\n=== COMMAND FAILURE ===`);
                    (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Exit code: ${exitCode !== null && exitCode !== void 0 ? exitCode : -1}`);
                    if (stdout) {
                        const t = tail(stdout, 500);
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`\nSTDOUT (last 500 lines):\n${t}`);
                        if (debugDir && savedStdoutPath)
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Full STDOUT saved to: ${savedStdoutPath}`);
                    }
                    if (stderr) {
                        const t = tail(stderr, 500);
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`\nSTDERR (last 500 lines):\n${t}`);
                        if (debugDir && savedStderrPath)
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Full STDERR saved to: ${savedStderrPath}`);
                    }
                }
                // Display sandbox denies if any were captured
                if (denyEventsCaptured.length > 0) {
                    try {
                        const grouped = new Map();
                        for (const ev of denyEventsCaptured) {
                            const { processName, operation, target, timestamp, relationship } = ev;
                            if (!processName || !operation || !target || !timestamp)
                                continue;
                            const key = `${processName}|||${operation}|||${target}`;
                            const existing = grouped.get(key);
                            if (!existing) {
                                grouped.set(key, {
                                    processName,
                                    timestamp,
                                    operation,
                                    target,
                                    relationship,
                                });
                            }
                            else {
                                // Keep earliest timestamp
                                if (new Date(timestamp).getTime() <
                                    new Date(existing.timestamp).getTime()) {
                                    grouped.set(key, {
                                        processName,
                                        timestamp,
                                        operation,
                                        target,
                                        relationship,
                                    });
                                }
                            }
                        }
                        // Sort events by relationship into three sections
                        const rows = Array.from(grouped.values());
                        const relatedEvents = rows.filter(r => r.relationship === "related");
                        const maybeRelatedEvents = rows.filter(r => r.relationship === "maybe_related");
                        const probablyUnrelatedEvents = rows.filter(r => r.relationship === "probably_unrelated");
                        // Sort each section
                        const sortEvents = (events) => events.sort((a, b) => a.processName.localeCompare(b.processName) ||
                            a.operation.localeCompare(b.operation) ||
                            a.target.localeCompare(b.target) ||
                            a.timestamp.localeCompare(b.timestamp));
                        const sortedRelated = sortEvents(relatedEvents);
                        const sortedMaybeRelated = sortEvents(maybeRelatedEvents);
                        const sortedProbablyUnrelated = sortEvents(probablyUnrelatedEvents);
                        const headers = ["process", "timestamp", "action", "target"];
                        // Calculate global column widths based on all data
                        const allData = [
                            ...sortedRelated.map(r => [
                                r.processName,
                                r.timestamp,
                                r.operation,
                                r.target,
                            ]),
                            ...sortedMaybeRelated.map(r => [
                                r.processName,
                                r.timestamp,
                                r.operation,
                                r.target,
                            ]),
                            ...sortedProbablyUnrelated.map(r => [
                                r.processName,
                                r.timestamp,
                                r.operation,
                                r.target,
                            ]),
                        ];
                        const widths = headers.map((h, i) => Math.max(h.length, ...allData.map(row => { var _a, _b; return (_b = (_a = row[i]) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0; })));
                        const fmt = (vals) => vals.map((v, i) => (v !== null && v !== void 0 ? v : "").padEnd(widths[i])).join("  ");
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`\n=== SANDBOX DENIES ===`);
                        // Display Related Events
                        if (sortedRelated.length > 0) {
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`\n🔴 RELATED EVENTS (${sortedRelated.length}):`);
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(fmt(headers));
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(widths.map(w => "-".repeat(w)).join("  "));
                            for (const row of sortedRelated) {
                                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(fmt([row.processName, row.timestamp, row.operation, row.target]));
                            }
                        }
                        // Display Maybe Related Events
                        if (sortedMaybeRelated.length > 0) {
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`\n🟡 MAYBE RELATED EVENTS (${sortedMaybeRelated.length}):`);
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(fmt(headers));
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(widths.map(w => "-".repeat(w)).join("  "));
                            for (const row of sortedMaybeRelated) {
                                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(fmt([row.processName, row.timestamp, row.operation, row.target]));
                            }
                        }
                        // Display Probably Unrelated Events
                        if (sortedProbablyUnrelated.length > 0) {
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`\n🟢 PROBABLY UNRELATED EVENTS (${sortedProbablyUnrelated.length}):`);
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(fmt(headers));
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(widths.map(w => "-".repeat(w)).join("  "));
                            for (const row of sortedProbablyUnrelated) {
                                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(fmt([row.processName, row.timestamp, row.operation, row.target]));
                            }
                        }
                        if (rows.length === 0) {
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`No denies captured`);
                        }
                    }
                    catch (e) {
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Failed to display sandbox denies: ${e}`);
                    }
                }
                // List debug files if debug directory was created
                if (debugDir) {
                    try {
                        const files = yield node_fs_promises__WEBPACK_IMPORTED_MODULE_1__.readdir(debugDir);
                        if (files.length > 0) {
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`\n=== DEBUG FILES CREATED ===`);
                            for (const file of files) {
                                const fullPath = node_path__WEBPACK_IMPORTED_MODULE_3___default().join(debugDir, file);
                                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`  ${fullPath}`);
                            }
                        }
                        else {
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`\nNo debug files created in: ${debugDir}`);
                        }
                    }
                    catch (err) {
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Error reading debug directory: ${err}`);
                    }
                }
            }
            catch (err) {
                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_9__/* .intentionallyWriteToStdout */ .OT)(`Failed to execute command: ${err}`);
                process.exit(1);
            }
        }
        catch (e_2) {
            env_1.error = e_2;
            env_1.hasError = true;
        }
        finally {
            __disposeResources(env_1);
        }
    });
}


/***/ }),

/***/ "./src/shared/resources.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: () => (/* binding */ buildCliResources)
/* harmony export */ });
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:os");
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_os__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _anysphere_agent_exec__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../agent-exec/dist/index.js");
/* harmony import */ var _anysphere_cli_credentials__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../cli-credentials/dist/index.js");
/* harmony import */ var _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../cursor-config/dist/index.js");
/* harmony import */ var _anysphere_hooks_exec__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../hooks-exec/dist/index.js");
/* harmony import */ var _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../local-exec/dist/index.js");
/* harmony import */ var _anysphere_playwright_exec__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../playwright-exec/dist/index.js");
/* harmony import */ var _anysphere_shell_exec__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../shell-exec/dist/index.js");
/* harmony import */ var _utils_api_endpoint_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("./src/utils/api-endpoint.ts");
/* harmony import */ var _utils_git_diffs_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("./src/utils/git-diffs.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











function buildCliResources(ctx, params) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        const cwd = (_a = params.workingDirectory) !== null && _a !== void 0 ? _a : process.cwd();
        // Discover rg path or fall back to "rg"
        let rgPath = (_b = params.rgPath) !== null && _b !== void 0 ? _b : "rg";
        if (!params.rgPath) {
            try {
                const { execSync } = yield Promise.resolve(/* import() */).then(__webpack_require__.t.bind(__webpack_require__, "node:child_process", 23));
                rgPath = execSync("which rg", { encoding: "utf8" }).trim();
            }
            catch (_j) {
                // best-effort; keep default "rg"
            }
        }
        // Dashboard client + team settings
        const credentialManager = (0,_anysphere_cli_credentials__WEBPACK_IMPORTED_MODULE_3__/* .createCredentialManager */ .jo)((_c = "cursor") !== null && _c !== void 0 ? _c : "cursor-dev");
        const dashboardClient = (0,_anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_4__/* .createDashboardClient */ .Vi)({
            credentialManager,
            endpoint: (0,_utils_api_endpoint_js__WEBPACK_IMPORTED_MODULE_10__/* .getApiEndpoint */ .G6)(),
            configProvider: params.configProvider,
        });
        const teamSettingsService = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .ConnectTeamSettingsService */ ._u(dashboardClient);
        // File tracking, rules, ignores
        const fileChangeTracker = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .FileChangeTracker */ .$1(cwd);
        if (params.withDiffs) {
            const fileChanges = (0,_utils_git_diffs_js__WEBPACK_IMPORTED_MODULE_9__.buildFileChanges)((0,_utils_git_diffs_js__WEBPACK_IMPORTED_MODULE_9__.collectGitStatuses)());
            for (const file of fileChanges) {
                fileChangeTracker.trackChange(file.path, file.before, file.after);
            }
        }
        // Load CLAUDE.md files by default for agent-cli
        const getClaudeMdEnabled = () => true;
        const gitExecutor = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .LocalGitExecutor */ .xK();
        const cursorRulesService = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .LocalCursorRulesService */ .KO(ctx, gitExecutor, cwd, rgPath, false, getClaudeMdEnabled, undefined);
        const subagentsService = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .MergedSubagentsService */ .o_([
            new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .LocalSubagentsService */ .Vz(cwd),
            new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .CursorRulesSubagentsService */ .di(cursorRulesService),
        ]);
        const ignoreService = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .LazyIgnoreService */ .E1(gitExecutor, rgPath, teamSettingsService);
        // Permissions providers: config + optional Claude files
        const permissionsProviders = [];
        // Wrap ConfigPermissionsAdapter to override approvalMode based on getIsAutoRun
        class AutoRunAwarePermissionsProvider {
            constructor(configProvider, getIsAutoRun) {
                this.configProvider = configProvider;
                this.getIsAutoRun = getIsAutoRun;
                this.baseProvider = new _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_4__/* .ConfigPermissionsAdapter */ .QX(configProvider);
            }
            setGetIsAutoRun(getIsAutoRun) {
                this.getIsAutoRun = getIsAutoRun;
            }
            getPermissions() {
                return __awaiter(this, void 0, void 0, function* () {
                    var _a, _b, _c;
                    const perms = yield this.baseProvider.getPermissions();
                    // Override approvalMode based on getIsAutoRun
                    const approvalMode = this.getIsAutoRun() ? "unrestricted" : "allowlist";
                    // Determine sandbox policy from config
                    const cfg = this.configProvider.get();
                    const mode = (_b = (_a = cfg.sandbox) === null || _a === void 0 ? void 0 : _a.mode) !== null && _b !== void 0 ? _b : "disabled";
                    const userConfiguredPolicy = mode === "disabled"
                        ? { type: "insecure_none" }
                        : {
                            type: "workspace_readwrite",
                            network_access: ((_c = cfg.sandbox) === null || _c === void 0 ? void 0 : _c.networkAccess) === "enabled",
                        };
                    return Object.assign(Object.assign({}, perms), { approvalMode,
                        userConfiguredPolicy });
                });
            }
            updatePermissions(transformer) {
                return __awaiter(this, void 0, void 0, function* () {
                    return this.baseProvider.updatePermissions(transformer);
                });
            }
        }
        const localPermissionsProvider = new AutoRunAwarePermissionsProvider(params.configProvider, params.getIsAutoRun);
        permissionsProviders.push(localPermissionsProvider);
        const gitRoot = yield (0,_anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .findGitRoot */ .ky)(ctx, gitExecutor, cwd);
        const isRepository = !!gitRoot;
        const projectDir = gitRoot !== null && gitRoot !== void 0 ? gitRoot : cwd;
        const claudeProject = yield _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_4__/* .ReadOnlyFileBasedPermissionsProvider */ .N2.loadFromPath(node_path__WEBPACK_IMPORTED_MODULE_1___default().join(projectDir, ".claude", "settings.json"));
        if (claudeProject)
            permissionsProviders.push(claudeProject);
        const claudeGlobal = yield _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_4__/* .ReadOnlyFileBasedPermissionsProvider */ .N2.loadFromPath(node_path__WEBPACK_IMPORTED_MODULE_1___default().join((0,node_os__WEBPACK_IMPORTED_MODULE_0__.homedir)(), ".claude", "settings.json"));
        if (claudeGlobal)
            permissionsProviders.push(claudeGlobal);
        const mergedPermissionsProvider = new _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_4__/* .MergedPermissionsProvider */ .Ol(permissionsProviders);
        const projectPath = (0,_anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_4__/* .getProjectDir */ .Xq)(cwd);
        // Create MCP loader using CursorConfigMcpLoader
        const baseMcpLoader = _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_4__/* .CursorConfigMcpLoader */ .aK.init(teamSettingsService, cwd, projectPath, (_d = params.ignoreApproveMcps) !== null && _d !== void 0 ? _d : false);
        const mcpLoader = params.isBrowserUserEnabled
            ? new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .McpLoaderWithCustomClients */ .$p(baseMcpLoader, {
                [_anysphere_agent_exec__WEBPACK_IMPORTED_MODULE_2__/* .CURSOR_PLAYWRIGHT_PROVIDER_ID */ .HI]: new _anysphere_playwright_exec__WEBPACK_IMPORTED_MODULE_7__/* .PlaywrightMcpClient */ .T(),
            })
            : baseMcpLoader;
        // Permissions service wiring to new config model
        const config = params.configProvider.get();
        // Use sandboxOverride if provided, otherwise fall back to config
        const sandboxMode = (_g = (_e = params.sandboxOverride) !== null && _e !== void 0 ? _e : (_f = config.sandbox) === null || _f === void 0 ? void 0 : _f.mode) !== null && _g !== void 0 ? _g : "disabled";
        const sandboxNetwork = (_h = config.sandbox) === null || _h === void 0 ? void 0 : _h.networkAccess; // "allowlist" | "enabled"
        const permissionsService = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .InteractivePermissionsService */ .kh(ignoreService, params.decisionProvider, 
        // Always use merged provider so "Always" approvals persist to config allowlists
        mergedPermissionsProvider, teamSettingsService);
        const grepProvider = {
            rgPath,
            executeIndexedGrep: undefined,
        };
        // Load hooks configuration
        const hooksConfigPaths = {
            userConfigPath: node_path__WEBPACK_IMPORTED_MODULE_1___default().join((0,node_os__WEBPACK_IMPORTED_MODULE_0__.homedir)(), ".cursor", "hooks.json"),
            projectConfigPath: node_path__WEBPACK_IMPORTED_MODULE_1___default().join(projectDir, ".cursor", "hooks.json"),
        };
        const fileReader = new _anysphere_hooks_exec__WEBPACK_IMPORTED_MODULE_5__/* .NodeFileReader */ .IF();
        const configLoader = new _anysphere_hooks_exec__WEBPACK_IMPORTED_MODULE_5__/* .HooksConfigLoader */ .gY(fileReader, hooksConfigPaths);
        const hooksConfig = yield configLoader.load();
        const hooksConfigLease = new _anysphere_hooks_exec__WEBPACK_IMPORTED_MODULE_5__/* .StaticHooksConfigLease */ .HG(hooksConfig);
        return {
            permissionsService,
            grepProvider,
            fileChangeTracker,
            dashboardClient,
            teamSettingsService,
            mcpLoader,
            isRepository,
            hooksConfigLease,
            createLocalResourceProvider: ({ diagnosticsProvider, mcpLease, codebaseReferenceProvider, shellManager, pendingDecisionProviderOverride, conversationId = "", generationId = "", model = "unknown", }) => {
                // Determine if sandbox should be enabled: check environment support and user preference
                const getSandboxEnabled = () => {
                    // Check if environment supports sandboxing
                    const envSupportsSandbox = (0,_anysphere_shell_exec__WEBPACK_IMPORTED_MODULE_8__/* .isSandboxSupported */ .K3)();
                    // Check if user has enabled sandboxing in config
                    const userEnabledSandbox = sandboxMode === "enabled";
                    // Both conditions must be true
                    return envSupportsSandbox && userEnabledSandbox;
                };
                const baseResources = new _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_6__/* .LocalResourceProvider */ .Dv({
                    pendingDecisionStore: pendingDecisionProviderOverride !== null && pendingDecisionProviderOverride !== void 0 ? pendingDecisionProviderOverride : params.decisionProvider,
                    fileChangeTracker,
                    gitExecutor,
                    ignoreService,
                    grepProvider,
                    permissionsService,
                    workspacePaths: [cwd],
                    diagnosticsProvider,
                    mcpLease,
                    cursorRulesService,
                    subagentsService,
                    repositoryProvider: codebaseReferenceProvider,
                    projectDir: projectPath,
                    shellManager,
                    _sandboxPolicyResolver: undefined,
                    _defaultSandboxPolicy: sandboxMode === "enabled"
                        ? {
                            type: "workspace_readwrite",
                            network_access: sandboxNetwork === "enabled",
                        }
                        : { type: "insecure_none" },
                    getSandboxEnabled,
                });
                // Wrap with hooks support if any hooks are configured
                if (hooksConfig.userHooks || hooksConfig.projectHooks) {
                    const globalContext = {
                        cursor_version: "1.0.0", // TODO: Get actual version
                        user_email: null, // TODO: Get user email if available
                    };
                    const terminalExecutor = (0,_anysphere_shell_exec__WEBPACK_IMPORTED_MODULE_8__/* .createDefaultTerminalExecutor */ .Fn)();
                    const hookExecutor = new _anysphere_hooks_exec__WEBPACK_IMPORTED_MODULE_5__/* .CliHooksExecutor */ .WL(hooksConfig, projectDir, globalContext, terminalExecutor);
                    return new _anysphere_hooks_exec__WEBPACK_IMPORTED_MODULE_5__/* .ListableHooksResourceAccessor */ .ae(baseResources, hookExecutor, () => ({
                        conversation_id: conversationId,
                        generation_id: generationId,
                        model,
                    }));
                }
                return baseResources;
            },
            setGetIsAutoRun: (getIsAutoRun) => {
                // Update the wrapper's getIsAutoRun function
                localPermissionsProvider.setGetIsAutoRun(getIsAutoRun);
            },
        };
    });
}


/***/ }),

/***/ "./src/utils/git-diffs.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   buildFileChanges: () => (/* binding */ buildFileChanges),
/* harmony export */   buildUnifiedDiff: () => (/* binding */ buildUnifiedDiff),
/* harmony export */   collectGitStatuses: () => (/* binding */ collectGitStatuses)
/* harmony export */ });
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:child_process");
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_child_process__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:fs");
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_fs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("node:os");
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(node_os__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_3__);




const buildUnifiedDiff = (changes) => {
    const tmpRoot = node_fs__WEBPACK_IMPORTED_MODULE_1___default().mkdtempSync(node_path__WEBPACK_IMPORTED_MODULE_3___default().join(node_os__WEBPACK_IMPORTED_MODULE_2___default().tmpdir(), "delta-full-"));
    const beforeRoot = node_path__WEBPACK_IMPORTED_MODULE_3___default().join(tmpRoot, "before");
    const afterRoot = node_path__WEBPACK_IMPORTED_MODULE_3___default().join(tmpRoot, "after");
    node_fs__WEBPACK_IMPORTED_MODULE_1___default().mkdirSync(beforeRoot, { recursive: true });
    node_fs__WEBPACK_IMPORTED_MODULE_1___default().mkdirSync(afterRoot, { recursive: true });
    const writeOut = (base, rel, content) => {
        const dest = node_path__WEBPACK_IMPORTED_MODULE_3___default().join(base, rel);
        node_fs__WEBPACK_IMPORTED_MODULE_1___default().mkdirSync(node_path__WEBPACK_IMPORTED_MODULE_3___default().dirname(dest), { recursive: true });
        node_fs__WEBPACK_IMPORTED_MODULE_1___default().writeFileSync(dest, content);
    };
    for (const ch of changes) {
        const rel = node_path__WEBPACK_IMPORTED_MODULE_3___default().isAbsolute(ch.path)
            ? node_path__WEBPACK_IMPORTED_MODULE_3___default().relative(process.cwd(), ch.path)
            : ch.path;
        if (ch.before !== undefined)
            writeOut(beforeRoot, rel, ch.before);
        if (ch.after !== undefined)
            writeOut(afterRoot, rel, ch.after);
    }
    const args = [
        "diff",
        "--no-index",
        "--no-prefix",
        "--diff-algorithm=patience",
        "--unified=3",
        "--",
        "before",
        "after",
    ];
    let diffOutput = "";
    try {
        diffOutput = (0,node_child_process__WEBPACK_IMPORTED_MODULE_0__.execFileSync)("git", args, { encoding: "utf8", cwd: tmpRoot });
    }
    catch (err) {
        const anyErr = err;
        if (anyErr === null || anyErr === void 0 ? void 0 : anyErr.stdout)
            diffOutput = anyErr.stdout;
        else
            throw err;
    }
    const sanitizePaths = (text) => {
        const beforeAbs = node_path__WEBPACK_IMPORTED_MODULE_3___default().join(beforeRoot, "");
        const afterAbs = node_path__WEBPACK_IMPORTED_MODULE_3___default().join(afterRoot, "");
        // Absolute tmp paths
        let out = text.split(beforeAbs).join("").split(afterAbs).join("");
        // Relative dir names (when using cwd) - use path.sep for cross-platform compatibility
        const beforeRel = node_path__WEBPACK_IMPORTED_MODULE_3___default().join("before", "");
        const afterRel = node_path__WEBPACK_IMPORTED_MODULE_3___default().join("after", "");
        out = out.split(beforeRel).join("").split(afterRel).join("");
        return out;
    };
    const cleaned = sanitizePaths(diffOutput);
    node_fs__WEBPACK_IMPORTED_MODULE_1___default().rmSync(tmpRoot, { recursive: true, force: true });
    return cleaned;
};
function execGit(args) {
    return (0,node_child_process__WEBPACK_IMPORTED_MODULE_0__.execFileSync)("git", args, { encoding: "utf8" }).trim();
}
function readHeadFile(filePath) {
    try {
        return (0,node_child_process__WEBPACK_IMPORTED_MODULE_0__.execFileSync)("git", ["show", `HEAD:${filePath}`], {
            encoding: "utf8",
        });
    }
    catch (_a) {
        return undefined;
    }
}
let repoRootCache = null;
function getRepoRoot() {
    if (repoRootCache)
        return repoRootCache;
    repoRootCache = execGit(["rev-parse", "--show-toplevel"]);
    return repoRootCache;
}
function readWorkingFile(filePath) {
    const root = getRepoRoot();
    const absPath = node_path__WEBPACK_IMPORTED_MODULE_3___default().isAbsolute(filePath)
        ? filePath
        : node_path__WEBPACK_IMPORTED_MODULE_3___default().join(root, filePath);
    try {
        return (0,node_fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(absPath, "utf8");
    }
    catch (_a) {
        return "";
    }
}
function collectGitStatuses() {
    const diffOut = execGit(["diff", "--name-status", "HEAD"]);
    const lines = diffOut === "" ? [] : diffOut.split("\n");
    const parsed = lines.filter(Boolean).map(line => {
        var _a, _b, _c, _d, _e;
        const parts = line.split("\t");
        const raw = (_a = parts[0]) !== null && _a !== void 0 ? _a : "";
        const code = raw[0];
        if (code === "R" || code === "C") {
            const oldPath = (_b = parts[1]) !== null && _b !== void 0 ? _b : "";
            const newPath = (_c = parts[2]) !== null && _c !== void 0 ? _c : oldPath;
            return { code, path: newPath, oldPath };
        }
        return { code, path: (_e = (_d = parts[1]) !== null && _d !== void 0 ? _d : parts[0]) !== null && _e !== void 0 ? _e : "" };
    });
    // Add untracked files as added
    const untrackedOut = execGit([
        "ls-files",
        "--others",
        "--exclude-standard",
    ]);
    const untracked = untrackedOut === "" ? [] : untrackedOut.split("\n");
    for (const p of untracked) {
        if (p)
            parsed.push({ code: "A", path: p });
    }
    return parsed;
}
function buildFileChanges(statuses) {
    var _a, _b, _c;
    const changes = [];
    for (const s of statuses) {
        if (!s.path)
            continue;
        switch (s.code) {
            case "A": {
                const after = readWorkingFile(s.path);
                changes.push({ path: s.path, before: undefined, after });
                break;
            }
            case "M": {
                const before = (_a = readHeadFile(s.path)) !== null && _a !== void 0 ? _a : "";
                const after = readWorkingFile(s.path);
                changes.push({ path: s.path, before, after });
                break;
            }
            case "D": {
                const before = (_b = readHeadFile(s.path)) !== null && _b !== void 0 ? _b : "";
                changes.push({ path: s.path, before, after: undefined });
                break;
            }
            case "R": {
                const before = s.oldPath ? ((_c = readHeadFile(s.oldPath)) !== null && _c !== void 0 ? _c : "") : "";
                const after = readWorkingFile(s.path);
                changes.push({ path: s.path, before, after });
                break;
            }
            default: {
                // ignore other statuses for now
                break;
            }
        }
    }
    return changes;
}
function _createDebugFileChangeTracker(changes) {
    const accepted = new Set();
    const rejected = new Set();
    const tracker = {
        accept(path) {
            accepted.add(path);
            rejected.delete(path);
        },
        reject(path) {
            rejected.add(path);
            accepted.delete(path);
        },
        acceptAll() {
            for (const c of changes) {
                accepted.add(c.path);
                rejected.delete(c.path);
            }
        },
        rejectAll() {
            for (const c of changes) {
                rejected.add(c.path);
                accepted.delete(c.path);
            }
        },
    };
    return tracker;
}


/***/ })

};
;