exports.id = 1248;
exports.ids = [1248];
exports.modules = {

/***/ "../../node_modules/.pnpm/@opentelemetry+instrumentation@0.203.0_@opentelemetry+api@1.9.0/node_modules/@opentelemetry/instrumentation/build/esm/platform/node sync recursive":
/***/ ((module) => {

function webpackEmptyContext(req) {
	var e = new Error("Cannot find module '" + req + "'");
	e.code = 'MODULE_NOT_FOUND';
	throw e;
}
webpackEmptyContext.keys = () => ([]);
webpackEmptyContext.resolve = webpackEmptyContext;
webpackEmptyContext.id = "../../node_modules/.pnpm/@opentelemetry+instrumentation@0.203.0_@opentelemetry+api@1.9.0/node_modules/@opentelemetry/instrumentation/build/esm/platform/node sync recursive";
module.exports = webpackEmptyContext;

/***/ }),

/***/ "./src/always-approve-decision-provider.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: () => (/* binding */ AlwaysApproveDecisionProvider)
/* harmony export */ });
class AlwaysApproveDecisionProvider {
    requestApproval(_operation) {
        return Promise.resolve({ approved: true });
    }
}


/***/ }),

/***/ "./src/models/index.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  P3: () => (/* reexport */ ModelManager)
});

// UNUSED EXPORTS: fetchDefaultModel, fetchModelData, fetchUsableModels

// EXTERNAL MODULE: ./src/console-io.ts
var console_io = __webpack_require__("./src/console-io.ts");
// EXTERNAL MODULE: ./src/debug.ts + 1 modules
var debug = __webpack_require__("./src/debug.ts");
// EXTERNAL MODULE: ../proto/dist/generated/agent/v1/agent_service_pb.js
var agent_service_pb = __webpack_require__("../proto/dist/generated/agent/v1/agent_service_pb.js");
// EXTERNAL MODULE: ./src/utils/error-info.ts
var error_info = __webpack_require__("./src/utils/error-info.ts");
;// ./src/models/model-service.ts
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



function fetchModelData(aiServerClient) {
    return __awaiter(this, void 0, void 0, function* () {
        const [modelsResult, defaultResult] = yield Promise.allSettled([
            fetchUsableModels(aiServerClient),
            fetchDefaultModel(aiServerClient),
        ]);
        const result = {};
        if (modelsResult.status === "fulfilled" && modelsResult.value) {
            result.availableModels = modelsResult.value;
        }
        else if (modelsResult.status === "rejected") {
            (0,debug.debugLogJSON)("models.fetchUsableModels.error", (0,error_info/* extractErrorInfo */.q)(modelsResult.reason), "ERROR");
        }
        if (defaultResult.status === "fulfilled" && defaultResult.value) {
            result.defaultModel = defaultResult.value;
        }
        else if (defaultResult.status === "rejected") {
            (0,debug.debugLogJSON)("models.fetchDefaultModel.error", (0,error_info/* extractErrorInfo */.q)(defaultResult.reason), "ERROR");
        }
        return result;
    });
}
function fetchUsableModels(aiServerClient) {
    return __awaiter(this, void 0, void 0, function* () {
        const { models } = yield aiServerClient.getUsableModels(new agent_service_pb/* GetUsableModelsRequest */.KD({}));
        return models.length > 0 ? models : undefined;
    });
}
function fetchDefaultModel(aiServerClient) {
    return __awaiter(this, void 0, void 0, function* () {
        const { model } = yield aiServerClient.getDefaultModelForCli(new agent_service_pb/* GetDefaultModelForCliRequest */.Tu({}));
        return model;
    });
}

;// ./src/models/model-manager.ts
var model_manager_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class ModelManager {
    constructor() {
        this.availableModels = [];
        this.aliasMap = new Map();
        this.listeners = new Set();
        // Model will be set asynchronously
    }
    static init(aiServerClient, options) {
        return model_manager_awaiter(this, void 0, void 0, function* () {
            const manager = new ModelManager();
            manager.models = manager.initializeModels(aiServerClient, options);
            // If user explicitly provided a model, block until it's initialized, since we want to throw if invalid name.
            if (options.initialModel) {
                yield manager.models;
            }
            return manager;
        });
    }
    initializeModels(aiServerClient, options) {
        return model_manager_awaiter(this, void 0, void 0, function* () {
            const { availableModels, defaultModel } = yield fetchModelData(aiServerClient);
            if (availableModels) {
                this.availableModels = availableModels;
                this.buildAliasMap(availableModels);
            }
            const selectedModel = yield this.selectModel({
                options,
                defaultModel,
                availableModels: this.availableModels,
            });
            if (!selectedModel) {
                throw new Error("No model found. Please check your model settings.");
            }
            this.currentModel = selectedModel;
            this.notifyListeners();
            return selectedModel;
        });
    }
    selectModel(params) {
        return model_manager_awaiter(this, void 0, void 0, function* () {
            var _a;
            const { options, defaultModel, availableModels } = params;
            const config = options.configProvider.get();
            if (options.initialModel) {
                return this.handleInitialModel(options.initialModel, options.configProvider);
            }
            if (!defaultModel) {
                return config.model;
            }
            // User has never changed the default or their model matches default, jic some info has changed
            if (!config.hasChangedDefaultModel ||
                ((_a = config.model) === null || _a === void 0 ? void 0 : _a.modelId) === defaultModel.modelId) {
                yield this.updateConfig(options.configProvider, defaultModel, false);
                return defaultModel;
            }
            const isCurrentModelValid = availableModels.some(m => { var _a; return m.modelId === ((_a = config.model) === null || _a === void 0 ? void 0 : _a.modelId); });
            if (isCurrentModelValid) {
                return config.model;
            }
            // User's previous choice is no longer valid, fall back to default
            yield this.updateConfig(options.configProvider, defaultModel, false);
            return defaultModel;
        });
    }
    handleInitialModel(initialModel, configProvider) {
        return model_manager_awaiter(this, void 0, void 0, function* () {
            const userModel = this.normalizeModelId(initialModel);
            if (!userModel) {
                (0,console_io/* exitWithMessage */.uQ)(1, `Cannot use this model: ${initialModel}. Available models: ${this.availableModels.map(m => m.displayModelId).join(", ")}`);
            }
            yield this.updateConfig(configProvider, userModel, true);
            return userModel;
        });
    }
    updateConfig(configProvider, model, hasChangedDefaultModel) {
        return model_manager_awaiter(this, void 0, void 0, function* () {
            yield configProvider.transform(cfg => (Object.assign(Object.assign({}, cfg), { model,
                hasChangedDefaultModel })));
        });
    }
    setCurrentModel(model, configProvider) {
        return model_manager_awaiter(this, void 0, void 0, function* () {
            yield this.awaitCurrentModel();
            if (!this.availableModels.some(m => m.modelId === model.modelId)) {
                return;
            }
            yield configProvider.transform(config => (Object.assign(Object.assign({}, config), { model, hasChangedDefaultModel: true })));
            this.currentModel = model;
            this.notifyListeners();
        });
    }
    getCurrentModel() {
        return this.currentModel;
    }
    awaitCurrentModel() {
        return model_manager_awaiter(this, void 0, void 0, function* () {
            if (this.models) {
                yield this.models;
            }
            if (!this.currentModel) {
                throw new Error("We had an issue initializing the model. Please try again.");
            }
            return this.currentModel;
        });
    }
    getAvailableModels() {
        return [...this.availableModels];
    }
    awaitAvailableModels() {
        return model_manager_awaiter(this, void 0, void 0, function* () {
            yield this.awaitCurrentModel();
            return [...this.availableModels];
        });
    }
    normalizeModelId(raw) {
        return this.aliasMap.get(raw.toLowerCase());
    }
    // Simple setter for testing/UI
    setCurrentModelWithoutPersistence(model) {
        this.currentModel = model;
        this.notifyListeners();
    }
    // Set model from a stored model ID (e.g., when resuming)
    setModelFromStoredId(modelId, configProvider) {
        return model_manager_awaiter(this, void 0, void 0, function* () {
            if (!modelId || typeof modelId !== "string") {
                (0,debug.debugLog)("No stored model ID to restore");
                return false;
            }
            const availableModels = yield this.awaitAvailableModels();
            const matchingModel = availableModels.find(m => m.modelId === modelId);
            if (matchingModel) {
                yield this.setCurrentModel(matchingModel, configProvider);
                return true;
            }
            (0,debug.debugLog)(`Could not find model with ID: ${modelId} in available models`);
            return false;
        });
    }
    buildAliasMap(models) {
        var _a;
        const modelMap = new Map();
        for (const model of models) {
            if (!model.modelId)
                continue;
            modelMap.set(model.modelId.toLowerCase(), model);
            modelMap.set(model.displayModelId.toLowerCase(), model);
            for (const alias of (_a = model.aliases) !== null && _a !== void 0 ? _a : []) {
                modelMap.set(alias.toLowerCase(), model);
            }
        }
        this.aliasMap = modelMap;
    }
    // Listeners
    subscribe(listener) {
        this.listeners.add(listener);
        listener(this.currentModel);
        return () => {
            this.listeners.delete(listener);
        };
    }
    notifyListeners() {
        for (const listener of this.listeners) {
            listener(this.currentModel);
        }
    }
    static createForTesting() {
        const manager = new ModelManager();
        manager.models = Promise.resolve(undefined);
        return manager;
    }
}

;// ./src/models/index.ts




/***/ }),

/***/ "./src/state/index.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   r: () => (/* binding */ getChatsRootDir)
/* harmony export */ });
/* harmony import */ var node_crypto__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:crypto");
/* harmony import */ var node_crypto__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_crypto__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../cursor-config/dist/index.js");



function getChatsRootDir() {
    const cwdHash = (0,node_crypto__WEBPACK_IMPORTED_MODULE_0__.createHash)("md5").update(process.cwd()).digest("hex");
    return (0,node_path__WEBPACK_IMPORTED_MODULE_1__.join)((0,_anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_2__/* .getConfigDir */ .WI)(), "chats", cwdHash);
}


/***/ }),

/***/ "./src/state/session.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: () => (/* binding */ session)
/* harmony export */ });
const globalSessionState = Object.seal({
    lastRequest: null,
});
const session = Object.seal({
    get lastRequest() {
        return globalSessionState.lastRequest;
    },
    recordLastRequest(id, meta) {
        const info = {
            id,
            timestamp: Date.now(),
            path: meta === null || meta === void 0 ? void 0 : meta.path,
        };
        globalSessionState.lastRequest = info;
    },
    getLastRequestId() {
        var _a, _b;
        return (_b = (_a = globalSessionState.lastRequest) === null || _a === void 0 ? void 0 : _a.id) !== null && _b !== void 0 ? _b : null;
    },
    getLastRequest() {
        return globalSessionState.lastRequest;
    },
});


/***/ }),

/***/ "./src/state/sqlite-blob-store.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   M: () => (/* binding */ SQLiteBlobStoreWithMetadata)
/* harmony export */ });
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:fs");
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_fs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../agent-kv/dist/index.js");
/* harmony import */ var _anysphere_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../utils/dist/index.js");
/* harmony import */ var sqlite3__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../node_modules/.pnpm/sqlite3@5.1.7_patch_hash=aee4b045019cd42c3fc35610736c4496fa74db4d4a28d55c814724e29047da6a/node_modules/sqlite3/lib/sqlite3.js");
/* harmony import */ var sqlite3__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(sqlite3__WEBPACK_IMPORTED_MODULE_4__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





const agentMetadataSerde = new _anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_2__/* .AgentMetadataSerde */ .aY();
class SqliteDatabase extends (sqlite3__WEBPACK_IMPORTED_MODULE_4___default().Database) {
}
class SQLiteBlobStoreWithMetadata extends _anysphere_utils__WEBPACK_IMPORTED_MODULE_3__/* .Disposable */ .jG {
    static initAndLoad(dbPath) {
        return __awaiter(this, void 0, void 0, function* () {
            const store = new SQLiteBlobStoreWithMetadata(dbPath);
            yield store.getDb();
            return store;
        });
    }
    constructor(dbPath) {
        super();
        this.dbPath = dbPath;
        this.listeners = {
            agentId: new Set(),
            latestRootBlobId: new Set(),
            name: new Set(),
            createdAt: new Set(),
            mode: new Set(),
            lastUsedModel: new Set(),
        };
        // Serialize persistence to avoid re-entrant stacks
        this.isPersisting = false;
        this.persistQueued = false;
        const agentId = (0,node_path__WEBPACK_IMPORTED_MODULE_1__.basename)((0,node_path__WEBPACK_IMPORTED_MODULE_1__.dirname)(this.dbPath));
        this.metadata = (0,_anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_2__/* .getDefaultAgentMetadata */ .sh)(agentId);
    }
    getDb() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.dbPromise) {
                return this.dbPromise;
            }
            this.dbPromise = new Promise((resolve, reject) => {
                const dir = (0,node_path__WEBPACK_IMPORTED_MODULE_1__.dirname)(this.dbPath);
                if (!(0,node_fs__WEBPACK_IMPORTED_MODULE_0__.existsSync)(dir)) {
                    (0,node_fs__WEBPACK_IMPORTED_MODULE_0__.mkdirSync)(dir, { recursive: true });
                }
                const db = new SqliteDatabase(this.dbPath, err => {
                    if (err) {
                        reject(err);
                        return;
                    }
                    // Set up the database with proper configuration
                    db.serialize(() => {
                        db.run("PRAGMA journal_mode = WAL");
                        db.run("PRAGMA synchronous = NORMAL");
                        db.run("PRAGMA user_version = 1");
                        db.run("CREATE TABLE IF NOT EXISTS blobs (id TEXT PRIMARY KEY, data BLOB)");
                        db.run("CREATE TABLE IF NOT EXISTS meta (key TEXT PRIMARY KEY, value TEXT)", err => {
                            if (err) {
                                reject(err);
                                return;
                            }
                            // Load metadata
                            db.get("SELECT value FROM meta WHERE key = ?", "0", (err, row) => {
                                if (err) {
                                    reject(err);
                                    return;
                                }
                                if (row === null || row === void 0 ? void 0 : row.value) {
                                    const id = (0,_anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_2__/* .fromHex */ .aD)(row.value);
                                    this.metadata = agentMetadataSerde.deserialize(id);
                                }
                                else {
                                    // Save initial metadata
                                    const serialized = agentMetadataSerde.serialize(this.metadata);
                                    const id = (0,_anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_2__/* .toHex */ .nj)(serialized);
                                    db.run("INSERT OR REPLACE INTO meta (key, value) VALUES (?, ?)", "0", id);
                                }
                                resolve(db);
                            });
                        });
                    });
                });
            });
            return this.dbPromise;
        });
    }
    getBlob(_ctx, blobId) {
        return __awaiter(this, void 0, void 0, function* () {
            const db = yield this.getDb();
            const id = (0,_anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_2__/* .toHex */ .nj)(blobId);
            return new Promise((resolve, reject) => {
                db.get("SELECT data FROM blobs WHERE id = ?", id, (err, row) => {
                    if (err) {
                        reject(err);
                        return;
                    }
                    if (!row || row.data == null) {
                        resolve(undefined);
                        return;
                    }
                    // sqlite3 returns Buffer objects for BLOB columns
                    resolve(new Uint8Array(row.data));
                });
            });
        });
    }
    setBlob(_ctx, blobId, blobData) {
        return __awaiter(this, void 0, void 0, function* () {
            const db = yield this.getDb();
            const id = (0,_anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_2__/* .toHex */ .nj)(blobId);
            return new Promise((resolve, reject) => {
                db.run("INSERT OR REPLACE INTO blobs (id, data) VALUES (?, ?)", id, Buffer.from(blobData), (err) => {
                    if (err) {
                        reject(err);
                        return;
                    }
                    resolve();
                });
            });
        });
    }
    setBlobLocallyOnly(_ctx, _blobId, _blobData) {
        return __awaiter(this, void 0, void 0, function* () {
            // SQLiteBlobStoreWithMetadata writes to SQLite which is the source of truth
            // setBlobLocallyOnly is a no-op since the blob is assumed to already be stored
            return Promise.resolve();
        });
    }
    flush(_ctx) {
        return __awaiter(this, void 0, void 0, function* () {
            return Promise.resolve();
        });
    }
    get(key) {
        return this.metadata[key];
    }
    valuesEqual(key, a, b) {
        if (key === "latestRootBlobId") {
            const ua = a;
            const ub = b;
            if (ua === ub)
                return true;
            if (!ua || !ub)
                return false;
            if (ua.length !== ub.length)
                return false;
            for (let i = 0; i < ua.length; i++) {
                if (ua[i] !== ub[i])
                    return false;
            }
            return true;
        }
        return a === b;
    }
    schedulePersist() {
        if (!this.dbPromise)
            return;
        if (this.isPersisting) {
            this.persistQueued = true;
            return;
        }
        this.isPersisting = true;
        void this.persistMetadata().finally(() => {
            this.isPersisting = false;
            if (this.persistQueued) {
                this.persistQueued = false;
                this.schedulePersist();
            }
        });
    }
    set(key, value) {
        const current = this.metadata[key];
        if (this.valuesEqual(key, current, value)) {
            // No-op on identical values to avoid redundant notifications/persistence
            return;
        }
        this.metadata = Object.assign(Object.assign({}, this.metadata), { [key]: value });
        // if we already have a db, lets persist our metadata (fire and forget, serialized)
        if (this.dbPromise) {
            this.schedulePersist();
        }
        // notify listeners of the specific key (defer to break synchronous recursion)
        const listenerSet = this.listeners[key];
        if (listenerSet && listenerSet.size > 0) {
            queueMicrotask(() => {
                listenerSet.forEach(l => {
                    l();
                });
            });
        }
    }
    persistMetadata() {
        return __awaiter(this, void 0, void 0, function* () {
            const db = yield this.getDb();
            const serialized = agentMetadataSerde.serialize(this.metadata);
            const id = (0,_anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_2__/* .toHex */ .nj)(serialized);
            return new Promise((resolve, reject) => {
                db.run("INSERT OR REPLACE INTO meta (key, value) VALUES (?, ?)", "0", id, (err) => {
                    if (err) {
                        reject(err);
                        return;
                    }
                    resolve();
                });
            });
        });
    }
    subscribe(key, listener) {
        const set = this.listeners[key];
        if (set) {
            set.add(listener);
            return () => set.delete(listener);
        }
        return () => { };
    }
    dispose() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.dbPromise) {
                return;
            }
            yield this.cleanup();
            this.dbPromise = undefined;
        });
    }
    cleanup() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.dbPromise) {
                return;
            }
            const db = yield this.dbPromise;
            const row = yield new Promise((resolve, reject) => {
                db.get("SELECT value FROM meta WHERE key = ?", "0", (err, r) => {
                    if (err) {
                        reject(err);
                        return;
                    }
                    resolve(r);
                });
            });
            let latestLen = 0;
            if (row === null || row === void 0 ? void 0 : row.value) {
                const id = (0,_anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_2__/* .fromHex */ .aD)(row.value);
                const md = agentMetadataSerde.deserialize(id);
                latestLen = md.latestRootBlobId.length;
            }
            yield new Promise(resolve => {
                db.close(() => resolve());
            });
            if (latestLen === 0) {
                this.dbPromise = undefined;
                const dir = (0,node_path__WEBPACK_IMPORTED_MODULE_1__.dirname)(this.dbPath);
                try {
                    (0,node_fs__WEBPACK_IMPORTED_MODULE_0__.rmSync)(dir, { recursive: true, force: true });
                }
                catch (_a) {
                    // ignore
                }
                return;
            }
        });
    }
}


/***/ }),

/***/ "./src/tracing.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   H: () => (/* binding */ initTracing)
/* harmony export */ });
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:os");
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_os__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _opentelemetry_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/@opentelemetry+api@1.9.0/node_modules/@opentelemetry/api/build/esm/diag-api.js");
/* harmony import */ var _opentelemetry_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../node_modules/.pnpm/@opentelemetry+api@1.9.0/node_modules/@opentelemetry/api/build/esm/diag/types.js");
/* harmony import */ var _opentelemetry_exporter_trace_otlp_proto__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../node_modules/.pnpm/@opentelemetry+exporter-trace-otlp-proto@0.203.0_@opentelemetry+api@1.9.0/node_modules/@opentelemetry/exporter-trace-otlp-proto/build/esm/platform/node/OTLPTraceExporter.js");
/* harmony import */ var _opentelemetry_resources__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../node_modules/.pnpm/@opentelemetry+resources@2.0.1_@opentelemetry+api@1.9.0/node_modules/@opentelemetry/resources/build/esm/ResourceImpl.js");
/* harmony import */ var _opentelemetry_sdk_node__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../node_modules/.pnpm/@opentelemetry+sdk-node@0.203.0_@opentelemetry+api@1.9.0/node_modules/@opentelemetry/sdk-node/build/src/index.js");
/* harmony import */ var _debug_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/debug.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






// Avoid re-initialising if some caller imported this twice.
let initialized = false;
function initTracing(options) {
    return __awaiter(this, void 0, void 0, function* () {
        if (initialized)
            return;
        // Route OpenTelemetry diagnostics to debugLog, never to console
        const otelDiagLogger = {
            verbose: (...args) => {
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_1__.debugLog)("otel.verbose", ...args);
            },
            debug: (...args) => {
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_1__.debugLog)("otel.debug", ...args);
            },
            info: (...args) => {
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_1__.debugLog)("otel.info", ...args);
            },
            warn: (...args) => {
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_1__.debugLog)("otel.warn", ...args);
            },
            error: (...args) => {
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_1__.debugLog)("otel.error", ...args);
            },
        };
        _opentelemetry_api__WEBPACK_IMPORTED_MODULE_2__/* .diag */ .s.setLogger(otelDiagLogger, _opentelemetry_api__WEBPACK_IMPORTED_MODULE_3__/* .DiagLogLevel */ .u.ERROR);
        // Build exporter only when options are provided (so we can attach auth metadata)
        let exporter;
        try {
            exporter = options ? yield createExporter(options) : undefined;
        }
        catch (e) {
            (0,_debug_js__WEBPACK_IMPORTED_MODULE_1__.debugLog)("Failed to create OpenTelemetry exporter", e);
            return;
        }
        // Build a resource with client and environment attributes that apply to all spans
        const resource = options ? buildResource(options) : undefined;
        const sdk = new _opentelemetry_sdk_node__WEBPACK_IMPORTED_MODULE_4__/* .NodeSDK */ .P({
            autoDetectResources: false,
            traceExporter: exporter,
            resource,
        });
        try {
            sdk.start();
        }
        catch (err) {
            (0,_debug_js__WEBPACK_IMPORTED_MODULE_1__.debugLog)("Failed to start OpenTelemetry SDK", err);
        }
        // Ensure we flush/shutdown on process exit
        const gracefulShutdown = () => {
            void sdk.shutdown().catch((err) => {
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_1__.debugLog)("Error shutting down OpenTelemetry SDK", err);
            });
        };
        process.once("beforeExit", gracefulShutdown);
        process.once("SIGTERM", gracefulShutdown);
        process.once("SIGINT", gracefulShutdown);
        initialized = true;
    });
}
function buildResource(options) {
    var _a, _b, _c;
    const platform = node_os__WEBPACK_IMPORTED_MODULE_0___default().platform();
    const arch = node_os__WEBPACK_IMPORTED_MODULE_0___default().arch();
    const osRelease = node_os__WEBPACK_IMPORTED_MODULE_0___default().release();
    const nodeVersion = process.version;
    const cliVersion = (_a = "2026.01.02-80e4d9b") !== null && _a !== void 0 ? _a : "unknown";
    const hostname = node_os__WEBPACK_IMPORTED_MODULE_0___default().hostname();
    // Build semantic resource attributes plus custom client.* ones
    const resource = (0,_opentelemetry_resources__WEBPACK_IMPORTED_MODULE_5__/* .resourceFromAttributes */ .QZ)({
        "service.name": (_b = options.serviceName) !== null && _b !== void 0 ? _b : "cursor-agent-cli",
        "service.version": (_c = options.serviceVersion) !== null && _c !== void 0 ? _c : cliVersion,
        "host.name": hostname,
        "os.type": platform,
        "os.version": osRelease,
        "process.runtime.name": "node",
        "process.runtime.version": nodeVersion,
        "client.os.platform": platform,
        "client.os.release": osRelease,
        "client.arch": arch,
        "client.node.version": nodeVersion,
        "client.cli.version": cliVersion,
    });
    return resource;
}
function createExporter(options) {
    return __awaiter(this, void 0, void 0, function* () {
        const backendUrl = options.backendUrl;
        const tokenMaybe = yield options.credentialManager.getAccessToken();
        if (!tokenMaybe) {
            throw new Error("No access token found for tracing exporter");
        }
        const token = tokenMaybe;
        const ghostMode = (() => {
            var _a, _b;
            try {
                const value = (_b = (_a = options.configProvider) === null || _a === void 0 ? void 0 : _a.get().privacyCache) === null || _b === void 0 ? void 0 : _b.ghostMode;
                if (typeof value === "boolean")
                    return value;
                return true;
            }
            catch (_c) {
                return true;
            }
        })();
        // Build HTTP headers for authentication and content type
        const headers = {
            authorization: `Bearer ${token}`,
            "x-ghost-mode": ghostMode ? "true" : "false",
            "x-cursor-client-version": "agent-cli",
        };
        // Construct the complete URL with /v1/traces path for OTLP HTTP
        const traceUrl = `${backendUrl}/v1/traces`;
        return new _opentelemetry_exporter_trace_otlp_proto__WEBPACK_IMPORTED_MODULE_6__/* .OTLPTraceExporter */ .Q({
            url: traceUrl,
            headers,
        });
    });
}


/***/ })

};
;