"use strict";
exports.id = 7434;
exports.ids = [5302,7434];
exports.modules = {

/***/ "../agent-ui-state/dist/index.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  VX: () => (/* reexport */ MergeError),
  RN: () => (/* reexport */ abortConversationState),
  b: () => (/* reexport */ computeLatestEditIndex),
  Du: () => (/* reexport */ createNewConversationState),
  II: () => (/* reexport */ getPlanDecisionIndex),
  OE: () => (/* reexport */ isSuggestingPlan),
  N1: () => (/* reexport */ loadConversationState),
  HG: () => (/* reexport */ mergeCreateNewAgentTurn),
  Yb: () => (/* reexport */ mergeCreateNewShellTurn),
  cp: () => (/* reexport */ mergeDiscardPlan),
  ti: () => (/* reexport */ mergeExecutePlan),
  as: () => (/* reexport */ mergeInteractionUpdate),
  k4: () => (/* reexport */ mergePlanDecisionIndexChange),
  bE: () => (/* reexport */ mergeRejectPlan),
  Gv: () => (/* reexport */ mergeTurnCompletion),
  HE: () => (/* reexport */ partitionConversationState),
  P4: () => (/* reexport */ truncateUIConversationState)
});

// UNUSED EXPORTS: abortAgentTurn, abortSegmentToolCall, abortShellTurn, canMergeToolCallIntoGroup, completePendingAgentTurnState, completeTurn, createNewPendingAgentTurn, createNewPendingShellTurn, createToolCallSegmentFromStartToolCallUpdate, mergeAgentTurnTextDelta, mergeAgentTurnThinkingCompleted, mergeAgentTurnThinkingDelta, mergeAgentTurnToolCallCompleted, mergeAgentTurnToolCallStarted, mergeSegmentStartToolCallUpdate, mergeSegmentToolCallCompletedUpdate, mergeShellOutputDelta, mergeShellOutputDeltaUpdate, mergeSummarizeCompletedUpdate, mergeSummarizeStartedUpdate, mergeTextDeltaUpdate, mergeThinkingCompletedUpdate, mergeThinkingDeltaUpdate, mergeToolCallCompletedUpdate, mergeToolCallStartedUpdate, mergeUserMessageAppendedUpdate

;// ../agent-ui-state/dist/common.js
class MergeError extends Error {
    constructor(message) {
        super(message);
        this.name = "MergeError";
    }
}
//# sourceMappingURL=common.js.map
// EXTERNAL MODULE: ../proto/dist/generated/agent/v1/agent_pb.js + 9 modules
var agent_pb = __webpack_require__("../proto/dist/generated/agent/v1/agent_pb.js");
// EXTERNAL MODULE: ../proto/dist/generated/agent/v1/shell_exec_pb.js
var shell_exec_pb = __webpack_require__("../proto/dist/generated/agent/v1/shell_exec_pb.js");
// EXTERNAL MODULE: ../proto/dist/generated/agent/v1/shell_tool_pb.js
var shell_tool_pb = __webpack_require__("../proto/dist/generated/agent/v1/shell_tool_pb.js");
;// ../agent-ui-state/dist/tool-call-merge.js



/**
 * Determines if a tool call is a "read" tool that can be grouped with other read tools.
 * Read tools are those that only read/query information without modifying state.
 */
function isReadToolCall(toolCall) {
    const call = toolCall.call;
    // Check if the tool call is one of the read-like tools
    return !!(call.tool.case === "readToolCall" ||
        call.tool.case === "lsToolCall" ||
        call.tool.case === "globToolCall" ||
        call.tool.case === "grepToolCall" ||
        call.tool.case === "readLintsToolCall" ||
        call.tool.case === "semSearchToolCall");
}
/**
 * Determines if all tool calls in a group are read tools.
 */
function isReadToolGroup(group) {
    return group.calls.every(isReadToolCall);
}
/**
 * Predicate function that determines if a new tool call can be merged into an existing group.
 * Currently merges read tool calls into groups that only contain other read tool calls.
 */
function canMergeToolCallIntoGroup(group, newToolCall) {
    // Only merge read tools into read-only groups
    if (isReadToolCall(newToolCall) && isReadToolGroup(group)) {
        return true;
    }
    // Future: Add other merge criteria here (e.g., same file operations, etc.)
    return false;
}
function mergeSegmentStartToolCallUpdate(segment, update) {
    const lastGroup = segment.groups[segment.groups.length - 1];
    const newToolCall = {
        id: update.callId,
        call: update.toolCall,
        completed: false,
        aborted: false,
    };
    // If no existing group, create a new one
    if (lastGroup === undefined) {
        return {
            type: "tool-call-segment",
            groups: [
                {
                    type: "tool-call-group",
                    calls: [newToolCall],
                },
            ],
        };
    }
    // Check if the new tool call can be merged into the last group
    if (canMergeToolCallIntoGroup(lastGroup, newToolCall)) {
        return Object.assign(Object.assign({}, segment), { groups: [
                ...segment.groups.slice(0, -1),
                Object.assign(Object.assign({}, lastGroup), { calls: [...lastGroup.calls, newToolCall] }),
            ] });
    }
    // If it can't be merged, create a new group
    return Object.assign(Object.assign({}, segment), { groups: [
            ...segment.groups,
            {
                type: "tool-call-group",
                calls: [newToolCall],
            },
        ] });
}
function createToolCallSegmentFromStartToolCallUpdate(update) {
    return {
        type: "tool-call-segment",
        groups: [
            {
                type: "tool-call-group",
                calls: [
                    {
                        id: update.callId,
                        call: update.toolCall,
                        completed: false,
                        aborted: false,
                    },
                ],
            },
        ],
    };
}
function mergeSegmentToolCallCompletedUpdate(segment, update) {
    const newGroups = segment.groups.map(group => {
        return Object.assign(Object.assign({}, group), { calls: group.calls.map(call => {
                if (call.id === update.callId) {
                    return Object.assign(Object.assign({}, call), { call: update.toolCall, completed: true, aborted: false });
                }
                return call;
            }) });
    });
    return {
        type: "tool-call-segment",
        groups: newGroups,
    };
}
function mergeSegmentToolCallDeltaUpdate(segment, update) {
    const newGroups = segment.groups.map(group => {
        return Object.assign(Object.assign({}, group), { calls: group.calls.map(call => {
                var _a, _b;
                if (call.id === update.callId) {
                    // Only handle shell tool call deltas
                    if (update.toolCallDelta.delta.case === "shellToolCallDelta" &&
                        call.call.tool.case === "shellToolCall") {
                        const shellDelta = update.toolCallDelta.delta.value;
                        const shellToolCall = call.call.tool.value;
                        // Get current accumulated output from partial result, or start fresh
                        const currentResult = (_a = shellToolCall.result) === null || _a === void 0 ? void 0 : _a.result;
                        let currentStdout = "";
                        let currentStderr = "";
                        if ((currentResult === null || currentResult === void 0 ? void 0 : currentResult.case) === "success") {
                            // If there's already a partial result, get its accumulated output
                            currentStdout = currentResult.value.stdout || "";
                            currentStderr = currentResult.value.stderr || "";
                        }
                        // Append the new delta
                        if (shellDelta.delta.case === "stdout") {
                            currentStdout += shellDelta.delta.value.content;
                        }
                        else if (shellDelta.delta.case === "stderr") {
                            currentStderr += shellDelta.delta.value.content;
                        }
                        // Create updated tool call with accumulated output in partialResult
                        const updatedShellToolCall = new shell_tool_pb/* ShellToolCall */.$M({
                            args: shellToolCall.args,
                            result: new shell_exec_pb/* ShellResult */.W4({
                                result: {
                                    case: "success",
                                    value: new shell_exec_pb/* ShellSuccess */.QR({
                                        stdout: currentStdout,
                                        stderr: currentStderr,
                                    }),
                                },
                                sandboxPolicy: (_b = shellToolCall.result) === null || _b === void 0 ? void 0 : _b.sandboxPolicy,
                            }),
                        });
                        return Object.assign(Object.assign({}, call), { call: new agent_pb/* ToolCall */.Dm({
                                tool: {
                                    case: "shellToolCall",
                                    value: updatedShellToolCall,
                                },
                            }) });
                    }
                }
                return call;
            }) });
    });
    return {
        type: "tool-call-segment",
        groups: newGroups,
    };
}
function abortSegmentToolCall(segment) {
    const newGroups = segment.groups.map(group => {
        return Object.assign(Object.assign({}, group), { calls: group.calls.map(call => {
                return Object.assign(Object.assign({}, call), { completed: false, aborted: true });
            }) });
    });
    return {
        type: "tool-call-segment",
        groups: newGroups,
    };
}
//# sourceMappingURL=tool-call-merge.js.map
;// ../agent-ui-state/dist/agent.js


function completePendingAgentTurnState(pendingState) {
    if (pendingState === undefined) {
        return [];
    }
    if (pendingState.type === "text") {
        return [
            {
                type: "text",
                content: pendingState.content,
                completed: true,
            },
        ];
    }
    if (pendingState.type === "plan") {
        return [
            {
                type: "plan",
                tool: pendingState.tool,
                status: pendingState.status,
            },
        ];
    }
    if (pendingState.type === "tool-call-segment") {
        return pendingState.groups;
    }
    return [];
}
function mergeAgentTurnToolCallCompleted(prevAgentTurn, update) {
    var _a;
    if (update.toolCall.tool.case === "createPlanToolCall") {
        return Object.assign({}, prevAgentTurn);
    }
    switch ((_a = prevAgentTurn.pendingState) === null || _a === void 0 ? void 0 : _a.type) {
        case "tool-call-segment":
            return Object.assign(Object.assign({}, prevAgentTurn), { pendingState: mergeSegmentToolCallCompletedUpdate(prevAgentTurn.pendingState, update) });
        default:
            throw new MergeError("No pending state");
    }
}
function mergeAgentTurnToolCallStarted(prevAgentTurn, update) {
    var _a;
    if (update.toolCall.tool.case === "createPlanToolCall") {
        return Object.assign(Object.assign({}, prevAgentTurn), { pendingState: {
                type: "plan",
                tool: update.toolCall,
                status: "accepted",
            } });
    }
    switch ((_a = prevAgentTurn.pendingState) === null || _a === void 0 ? void 0 : _a.type) {
        case "tool-call-segment":
            return Object.assign(Object.assign({}, prevAgentTurn), { pendingState: mergeSegmentStartToolCallUpdate(prevAgentTurn.pendingState, update) });
        case "text":
        case "plan":
        case undefined:
            return Object.assign(Object.assign({}, prevAgentTurn), { completedSteps: [
                    ...prevAgentTurn.completedSteps,
                    ...completePendingAgentTurnState(prevAgentTurn.pendingState),
                ], pendingState: createToolCallSegmentFromStartToolCallUpdate(update) });
    }
}
function mergeAgentTurnTextDelta(prevAgentTurn, update) {
    var _a;
    switch ((_a = prevAgentTurn.pendingState) === null || _a === void 0 ? void 0 : _a.type) {
        case "text":
            return Object.assign(Object.assign({}, prevAgentTurn), { pendingState: {
                    type: "text",
                    content: prevAgentTurn.pendingState.content + update.text,
                    completed: false,
                } });
        case "plan":
            return Object.assign({}, prevAgentTurn);
        case "tool-call-segment":
        case undefined:
            return Object.assign(Object.assign({}, prevAgentTurn), { completedSteps: [
                    ...prevAgentTurn.completedSteps,
                    ...completePendingAgentTurnState(prevAgentTurn.pendingState),
                ], pendingState: {
                    type: "text",
                    content: update.text,
                    completed: false,
                } });
    }
    return prevAgentTurn;
}
function createNewPendingAgentTurn(userMessage) {
    return {
        type: "agent",
        userMessage: userMessage,
        completedSteps: [],
        pendingState: undefined,
        thinkingContent: undefined,
    };
}
function mergeAgentTurnToolCallDelta(prevAgentTurn, update) {
    var _a;
    switch ((_a = prevAgentTurn.pendingState) === null || _a === void 0 ? void 0 : _a.type) {
        case "tool-call-segment":
            return Object.assign(Object.assign({}, prevAgentTurn), { pendingState: mergeSegmentToolCallDeltaUpdate(prevAgentTurn.pendingState, update) });
        default:
            // Ignore deltas if we're not in a tool-call-segment state
            return prevAgentTurn;
    }
}
function abortAgentTurn(agentTurn) {
    var _a;
    if (((_a = agentTurn.pendingState) === null || _a === void 0 ? void 0 : _a.type) === "tool-call-segment") {
        return Object.assign(Object.assign({}, agentTurn), { pendingState: abortSegmentToolCall(agentTurn.pendingState) });
    }
    return agentTurn;
}
//# sourceMappingURL=agent.js.map
;// ../agent-ui-state/dist/edits.js
/**
 * Computes the latest edit index based on UIConversationState.
 * Similar to computeLatestEditIndex but works with UIConversationState instead of UITurn[].
 *
 * @param conversationState - The current UI conversation state
 * @param changedFiles - Array of file changes to find the index in
 * @param fallbackIndex - Fallback index to return if no edit is found (default: 0)
 * @returns The index of the latest edited file in changedFiles, or fallbackIndex if not found
 */
function computeLatestEditIndex(conversationState, changedFiles, fallbackIndex = 0) {
    var _a;
    let lastPath;
    // Helper function to check if a tool call is an edit tool call and extract the path
    const extractEditPath = (toolCall) => {
        var _a;
        const tool = toolCall.call.tool;
        if (tool.case === "editToolCall") {
            return (_a = tool.value.args) === null || _a === void 0 ? void 0 : _a.path;
        }
        return undefined;
    };
    // Helper function to search through tool call group for edit tool calls
    const searchToolCallGroup = (group) => {
        // Check calls in reverse order within the group
        for (let c = group.calls.length - 1; c >= 0; c--) {
            const path = extractEditPath(group.calls[c]);
            if (path) {
                return path;
            }
        }
        return undefined;
    };
    // Helper function to search through steps for edit tool calls
    const searchStepsForEditPath = (steps) => {
        for (let s = steps.length - 1; s >= 0; s--) {
            const step = steps[s];
            if (step.type === "tool-call-group") {
                const path = searchToolCallGroup(step);
                if (path) {
                    return path;
                }
            }
        }
        return undefined;
    };
    // Helper function to search through pending state for edit tool calls
    const searchPendingState = (pendingState) => {
        if (pendingState.type === "tool-call-segment") {
            // Search through groups in reverse order
            for (let g = pendingState.groups.length - 1; g >= 0; g--) {
                const path = searchToolCallGroup(pendingState.groups[g]);
                if (path) {
                    return path;
                }
            }
        }
        return undefined;
    };
    // First check pending turn (most recent activity)
    if (((_a = conversationState.pendingTurn) === null || _a === void 0 ? void 0 : _a.type) === "agent") {
        const pendingTurn = conversationState.pendingTurn;
        // Check pending state first (most recent)
        if (pendingTurn.pendingState) {
            const pathFromPending = searchPendingState(pendingTurn.pendingState);
            if (pathFromPending) {
                lastPath = pathFromPending;
            }
        }
        // If no path found in pending state, check completed steps in pending turn
        if (!lastPath) {
            const pathFromCompleted = searchStepsForEditPath(pendingTurn.completedSteps);
            if (pathFromCompleted) {
                lastPath = pathFromCompleted;
            }
        }
    }
    // If no path found in pending turn, search through completed turns (in reverse order)
    if (!lastPath) {
        for (let t = conversationState.completedTurns.length - 1; t >= 0; t--) {
            const turn = conversationState.completedTurns[t];
            if (turn.type === "shell")
                continue;
            const path = searchStepsForEditPath(turn.steps);
            if (path) {
                lastPath = path;
                break;
            }
        }
    }
    // Find the index of the last edited file in changedFiles
    const idx = lastPath ? changedFiles.findIndex(c => c.path === lastPath) : -1;
    return idx >= 0 ? idx : fallbackIndex;
}
//# sourceMappingURL=edits.js.map
;// ../agent-ui-state/dist/loader.js

/**
 * Converts a single agent conversation turn to a completed agent turn
 */
function loadAgentTurn(agentTurn, turnIndex) {
    var _a, _b;
    const userMessage = (_b = (_a = agentTurn.userMessage) === null || _a === void 0 ? void 0 : _a.text) !== null && _b !== void 0 ? _b : "";
    const steps = [];
    let currentToolCallGroup;
    // Process steps and group tool calls using merge logic
    for (let stepIndex = 0; stepIndex < agentTurn.steps.length; stepIndex++) {
        const step = agentTurn.steps[stepIndex];
        switch (step.message.case) {
            case "assistantMessage":
                // If we have a pending tool call group, add it as a step first
                if (currentToolCallGroup) {
                    steps.push(currentToolCallGroup);
                    currentToolCallGroup = undefined;
                }
                // Add text step
                steps.push({
                    type: "text",
                    content: step.message.value.text,
                    completed: true,
                });
                break;
            case "toolCall": {
                const newToolCall = {
                    id: `loaded-${turnIndex}-${stepIndex}`,
                    call: step.message.value,
                    completed: true,
                    aborted: false,
                };
                // Try to merge into the current group, or create a new one
                if (currentToolCallGroup &&
                    canMergeToolCallIntoGroup(currentToolCallGroup, newToolCall)) {
                    // Merge into existing group
                    currentToolCallGroup.calls.push(newToolCall);
                }
                else {
                    // Finalize the previous group if it exists
                    if (currentToolCallGroup) {
                        steps.push(currentToolCallGroup);
                    }
                    // Create new group
                    currentToolCallGroup = {
                        type: "tool-call-group",
                        calls: [newToolCall],
                    };
                }
                break;
            }
        }
    }
    // Add any remaining tool call group as final step
    if (currentToolCallGroup) {
        steps.push(currentToolCallGroup);
    }
    return {
        type: "agent",
        userMessage,
        steps,
    };
}
/**
 * Converts a single shell conversation turn to a completed shell turn
 */
function loadShellTurn(shellTurn) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    return {
        type: "shell",
        shellCommand: (_b = (_a = shellTurn.shellCommand) === null || _a === void 0 ? void 0 : _a.command) !== null && _b !== void 0 ? _b : "",
        stdout: (_d = (_c = shellTurn.shellOutput) === null || _c === void 0 ? void 0 : _c.stdout) !== null && _d !== void 0 ? _d : "",
        stderr: (_f = (_e = shellTurn.shellOutput) === null || _e === void 0 ? void 0 : _e.stderr) !== null && _f !== void 0 ? _f : "",
        exitCode: (_h = (_g = shellTurn.shellOutput) === null || _g === void 0 ? void 0 : _g.exitCode) !== null && _h !== void 0 ? _h : 0,
    };
}
/**
 * Converts a single conversation turn to a completed UI turn
 */
function loadTurn(turn, turnIndex) {
    switch (turn.turn.case) {
        case "agentConversationTurn":
            return loadAgentTurn(turn.turn.value, turnIndex);
        case "shellConversationTurn":
            return loadShellTurn(turn.turn.value);
        default:
            throw new Error(`Unknown turn type: ${turn.turn.case}`);
    }
}
/**
 * Converts all conversation turns to completed UI turns
 */
function loadCompletedTurns(conversationState) {
    return conversationState.turns.map((turn, index) => loadTurn(turn, index));
}
/**
 * Creates initial UI conversation state with default values
 */
function createInitialUIConversationState() {
    return {
        summary: undefined,
        completedTurns: [],
        pendingTurn: undefined,
        summarizing: false,
        liveTokens: 0,
        rejectedPlan: false,
    };
}
/**
 * Main loader function that converts ConversationState to UIConversationState
 */
function loadConversationState(conversationState) {
    var _a, _b;
    const initialState = createInitialUIConversationState();
    const completedTurns = loadCompletedTurns(conversationState);
    return Object.assign(Object.assign({}, initialState), { summary: (_b = (_a = conversationState.summary) === null || _a === void 0 ? void 0 : _a.summary) !== null && _b !== void 0 ? _b : undefined, completedTurns });
}
//# sourceMappingURL=loader.js.map
;// ../agent-ui-state/dist/shell.js

function mergeShellOutputDelta(prevShellTurn, update) {
    if (update.event.case === "stdout") {
        return Object.assign(Object.assign({}, prevShellTurn), { stdout: prevShellTurn.stdout + update.event.value.data });
    }
    if (update.event.case === "stderr") {
        return Object.assign(Object.assign({}, prevShellTurn), { stderr: prevShellTurn.stderr + update.event.value.data });
    }
    if (update.event.case === "exit") {
        return Object.assign(Object.assign({}, prevShellTurn), { exitCode: update.event.value.code });
    }
    throw new MergeError("Invalid shell output delta update");
}
function createNewPendingShellTurn(shellCommand) {
    return {
        type: "shell",
        shellCommand: shellCommand,
        stdout: "",
        stderr: "",
        exitCode: undefined,
    };
}
function abortShellTurn(shellTurn) {
    return Object.assign(Object.assign({}, shellTurn), { exitCode: 130 });
}
//# sourceMappingURL=shell.js.map
;// ../agent-ui-state/dist/merge.js



function mergeTextDeltaUpdate(prevState, update) {
    if (!prevState.pendingTurn) {
        throw new MergeError("No pending turn");
    }
    if (prevState.pendingTurn.type !== "agent") {
        throw new MergeError("Pending turn is not an agent turn");
    }
    return Object.assign(Object.assign({}, prevState), { pendingTurn: mergeAgentTurnTextDelta(prevState.pendingTurn, update) });
}
function mergeToolCallStartedUpdate(prevState, update) {
    if (!prevState.pendingTurn) {
        throw new MergeError("No pending turn");
    }
    if (prevState.pendingTurn.type !== "agent") {
        throw new MergeError("Pending turn is not an agent turn");
    }
    return Object.assign(Object.assign({}, prevState), { pendingTurn: mergeAgentTurnToolCallStarted(prevState.pendingTurn, update) });
}
function mergeToolCallCompletedUpdate(prevState, update) {
    if (!prevState.pendingTurn) {
        throw new MergeError("No pending turn");
    }
    if (prevState.pendingTurn.type !== "agent") {
        throw new MergeError("Pending turn is not an agent turn");
    }
    if (update.toolCall.tool.case === "createPlanToolCall") {
        return Object.assign(Object.assign({}, prevState), { pendingTurn: Object.assign(Object.assign({}, prevState.pendingTurn), { pendingState: {
                    type: "plan",
                    tool: update.toolCall,
                    status: "accepted",
                } }) });
    }
    return Object.assign(Object.assign({}, prevState), { pendingTurn: mergeAgentTurnToolCallCompleted(prevState.pendingTurn, update) });
}
function mergeUserMessageAppendedUpdate(prevState, update) {
    if (!prevState.pendingTurn) {
        throw new MergeError("No pending turn");
    }
    if (prevState.pendingTurn.type !== "agent") {
        throw new MergeError("Pending turn is not an agent turn");
    }
    const newTurn = createNewPendingAgentTurn(update.userMessage.text);
    return Object.assign(Object.assign({}, prevState), { completedTurns: [
            ...prevState.completedTurns,
            completeTurn(prevState.pendingTurn),
        ], pendingTurn: newTurn, liveTokens: 0 });
}
function completeTurn(turn) {
    if (turn.type === "agent") {
        return {
            type: "agent",
            userMessage: turn.userMessage,
            steps: [
                ...turn.completedSteps,
                ...completePendingAgentTurnState(turn.pendingState),
            ],
        };
    }
    if (turn.type === "shell") {
        return {
            type: "shell",
            shellCommand: turn.shellCommand,
            stdout: turn.stdout,
            stderr: turn.stderr,
            exitCode: turn.exitCode,
        };
    }
    throw new MergeError("Turn is not an agent turn");
}
function mergeAgentTurnThinkingDelta(prevAgentTurn, update) {
    var _a;
    return Object.assign(Object.assign({}, prevAgentTurn), { thinkingContent: ((_a = prevAgentTurn.thinkingContent) !== null && _a !== void 0 ? _a : "") + update.text });
}
function mergeThinkingDeltaUpdate(prevState, update) {
    if (!prevState.pendingTurn) {
        throw new MergeError("No pending turn");
    }
    if (prevState.pendingTurn.type !== "agent") {
        throw new MergeError("Pending turn is not an agent turn");
    }
    return Object.assign(Object.assign({}, prevState), { pendingTurn: mergeAgentTurnThinkingDelta(prevState.pendingTurn, update) });
}
function mergeAgentTurnThinkingCompleted(prevAgentTurn, _update) {
    return Object.assign(Object.assign({}, prevAgentTurn), { thinkingContent: "" });
}
function mergeThinkingCompletedUpdate(prevState, update) {
    if (!prevState.pendingTurn) {
        throw new MergeError("No pending turn");
    }
    if (prevState.pendingTurn.type !== "agent") {
        throw new MergeError("Pending turn is not an agent turn");
    }
    return Object.assign(Object.assign({}, prevState), { pendingTurn: mergeAgentTurnThinkingCompleted(prevState.pendingTurn, update) });
}
function mergeShellOutputDeltaUpdate(prevState, update) {
    if (!prevState.pendingTurn) {
        throw new MergeError("No pending turn");
    }
    if (prevState.pendingTurn.type !== "shell") {
        throw new MergeError("Pending turn is not a shell turn");
    }
    return Object.assign(Object.assign({}, prevState), { pendingTurn: mergeShellOutputDelta(prevState.pendingTurn, update) });
}
function mergeInteractionUpdate(prevState, update) {
    if (update.type === "summary") {
        return {
            summary: update.summary,
            completedTurns: [],
            pendingTurn: undefined,
            summarizing: false,
            liveTokens: 0,
            rejectedPlan: false,
        };
    }
    if (update.type === "summary-started") {
        return Object.assign(Object.assign({}, prevState), { summarizing: true });
    }
    if (update.type === "summary-completed") {
        return Object.assign(Object.assign({}, prevState), { summarizing: false });
    }
    if (update.type === "token-delta") {
        return Object.assign(Object.assign({}, prevState), { liveTokens: prevState.liveTokens + update.tokens });
    }
    if (update.type === "text-delta") {
        return mergeTextDeltaUpdate(prevState, update);
    }
    if (update.type === "tool-call-started") {
        return mergeToolCallStartedUpdate(prevState, update);
    }
    if (update.type === "tool-call-completed") {
        return mergeToolCallCompletedUpdate(prevState, update);
    }
    if (update.type === "tool-call-delta") {
        if (!prevState.pendingTurn) {
            throw new MergeError("No pending turn");
        }
        if (prevState.pendingTurn.type !== "agent") {
            throw new MergeError("Pending turn is not an agent turn");
        }
        // Merge streaming deltas (e.g., shell stdout/stderr) into the tool call
        return Object.assign(Object.assign({}, prevState), { pendingTurn: mergeAgentTurnToolCallDelta(prevState.pendingTurn, update) });
    }
    if (update.type === "user-message-appended") {
        return mergeUserMessageAppendedUpdate(prevState, update);
    }
    if (update.type === "thinking-delta") {
        return mergeThinkingDeltaUpdate(prevState, update);
    }
    if (update.type === "thinking-completed") {
        return mergeThinkingCompletedUpdate(prevState, update);
    }
    if (update.type === "shell-output-delta") {
        return mergeShellOutputDeltaUpdate(prevState, update);
    }
    return prevState;
}
function mergeTurnCompletion(prevState) {
    var _a;
    const pendingTurn = prevState.pendingTurn;
    if ((pendingTurn === null || pendingTurn === void 0 ? void 0 : pendingTurn.type) === "agent") {
        if (((_a = pendingTurn.pendingState) === null || _a === void 0 ? void 0 : _a.type) === "plan") {
            return prevState;
        }
    }
    return Object.assign(Object.assign({}, prevState), { completedTurns: [
            ...prevState.completedTurns,
            ...(prevState.pendingTurn ? [completeTurn(prevState.pendingTurn)] : []),
        ], pendingTurn: undefined });
}
function mergeCreateNewAgentTurn(prevState, userMessage) {
    return Object.assign(Object.assign({}, prevState), { completedTurns: [
            ...prevState.completedTurns,
            ...(prevState.pendingTurn ? [completeTurn(prevState.pendingTurn)] : []),
        ], pendingTurn: createNewPendingAgentTurn(userMessage), liveTokens: 0, rejectedPlan: false });
}
function mergeCreateNewShellTurn(prevState, shellCommand) {
    return Object.assign(Object.assign({}, prevState), { completedTurns: [
            ...prevState.completedTurns,
            ...(prevState.pendingTurn ? [completeTurn(prevState.pendingTurn)] : []),
        ], pendingTurn: createNewPendingShellTurn(shellCommand), liveTokens: 0, rejectedPlan: false });
}
function mergeSummarizeStartedUpdate(prevState) {
    return Object.assign(Object.assign({}, prevState), { summarizing: true });
}
function mergeSummarizeCompletedUpdate(prevState) {
    return Object.assign(Object.assign({}, prevState), { summarizing: false });
}
function abortConversationState(prevState) {
    if (!prevState.pendingTurn) {
        return prevState;
    }
    if (prevState.pendingTurn.type === "agent") {
        return Object.assign(Object.assign({}, prevState), { pendingTurn: abortAgentTurn(prevState.pendingTurn), liveTokens: 0 });
    }
    if (prevState.pendingTurn.type === "shell") {
        return Object.assign(Object.assign({}, prevState), { pendingTurn: abortShellTurn(prevState.pendingTurn), liveTokens: 0 });
    }
    return prevState;
}
function createNewConversationState() {
    return {
        completedTurns: [],
        pendingTurn: undefined,
        liveTokens: 0,
        summarizing: false,
        summary: undefined,
        rejectedPlan: false,
    };
}
//# sourceMappingURL=merge.js.map
;// ../agent-ui-state/dist/plan.js

function isSuggestingPlan(state) {
    var _a;
    const pendingTurn = state.pendingTurn;
    if ((pendingTurn === null || pendingTurn === void 0 ? void 0 : pendingTurn.type) === "agent") {
        return ((_a = pendingTurn.pendingState) === null || _a === void 0 ? void 0 : _a.type) === "plan";
    }
    return false;
}
function getPlanDecisionIndex(state) {
    var _a;
    const pendingTurn = state.pendingTurn;
    if ((pendingTurn === null || pendingTurn === void 0 ? void 0 : pendingTurn.type) === "agent") {
        if (((_a = pendingTurn.pendingState) === null || _a === void 0 ? void 0 : _a.type) === "plan") {
            return pendingTurn.pendingState.status === "accepted" ? 0 : 1;
        }
    }
    return 0;
}
function mergePlanDecisionIndexChange(prevState, decisionIndex) {
    var _a, _b;
    if (((_a = prevState.pendingTurn) === null || _a === void 0 ? void 0 : _a.type) === "agent") {
        if (((_b = prevState.pendingTurn.pendingState) === null || _b === void 0 ? void 0 : _b.type) === "plan") {
            return Object.assign(Object.assign({}, prevState), { pendingTurn: Object.assign(Object.assign({}, prevState.pendingTurn), { pendingState: Object.assign(Object.assign({}, prevState.pendingTurn.pendingState), { status: decisionIndex === 0 ? "accepted" : "rejected" }) }) });
        }
    }
    return prevState;
}
function mergeRejectPlan(prevState) {
    var _a, _b;
    if (((_a = prevState.pendingTurn) === null || _a === void 0 ? void 0 : _a.type) === "agent") {
        if (((_b = prevState.pendingTurn.pendingState) === null || _b === void 0 ? void 0 : _b.type) === "plan") {
            return Object.assign(Object.assign({}, prevState), { completedTurns: [
                    ...prevState.completedTurns,
                    completeTurn({
                        type: "agent",
                        userMessage: prevState.pendingTurn.userMessage,
                        completedSteps: [
                            ...prevState.pendingTurn.completedSteps,
                            {
                                type: "plan",
                                tool: prevState.pendingTurn.pendingState.tool,
                                status: "rejected",
                            },
                        ],
                        pendingState: undefined,
                        thinkingContent: undefined,
                    }),
                ], pendingTurn: undefined, rejectedPlan: true });
        }
    }
    return prevState;
}
function mergeExecutePlan(prevState) {
    var _a, _b;
    if (((_a = prevState.pendingTurn) === null || _a === void 0 ? void 0 : _a.type) === "agent") {
        if (((_b = prevState.pendingTurn.pendingState) === null || _b === void 0 ? void 0 : _b.type) === "plan") {
            return Object.assign(Object.assign({}, prevState), { pendingTurn: Object.assign(Object.assign({}, prevState.pendingTurn), { completedSteps: [
                        ...prevState.pendingTurn.completedSteps,
                        {
                            type: "plan",
                            tool: prevState.pendingTurn.pendingState.tool,
                            status: "accepted",
                        },
                    ], pendingState: undefined, thinkingContent: undefined }) });
        }
    }
    return prevState;
}
function mergeDiscardPlan(prevState) {
    return Object.assign(Object.assign({}, prevState), { rejectedPlan: false });
}
//# sourceMappingURL=plan.js.map
;// ../agent-ui-state/dist/static.js
function renderCompletedStep(key, step, isLastTurn) {
    if (step.type === "text") {
        return [
            {
                type: "agent-text",
                text: step.content,
                key,
            },
        ];
    }
    else if (step.type === "plan") {
        return [
            {
                type: "plan",
                call: step.tool,
                decisionIndex: step.status === "accepted" ? 0 : 1,
                key,
            },
        ];
    }
    else {
        return [
            {
                type: "agent-tool-calls",
                calls: step.calls,
                key,
                isLastTurn,
            },
        ];
    }
}
function renderCompletedTurn(key, turn, isLastTurn) {
    if (turn.type === "agent") {
        return [
            {
                type: "user-message",
                message: turn.userMessage,
                key,
            },
            ...turn.steps.flatMap(step => {
                return renderCompletedStep(key, step, isLastTurn);
            }),
        ];
    }
    if (turn.type === "shell") {
        return [
            {
                type: "shell-turn",
                command: turn.shellCommand,
                key,
                stdout: turn.stdout,
                stderr: turn.stderr,
                exitCode: turn.exitCode,
            },
        ];
    }
    return [];
}
function renderAgentPendingState(key, state) {
    if (state.type === "text") {
        return [
            {
                type: "agent-text",
                text: state.content,
                completed: state.completed,
                key,
            },
        ];
    }
    if (state.type === "plan") {
        return [
            {
                type: "plan",
                call: state.tool,
                decisionIndex: state.status === "accepted" ? 0 : 1,
                key,
            },
        ];
    }
    return state.groups.flatMap((group, index) => {
        return {
            type: "agent-tool-calls",
            calls: group.calls,
            isLastStepOfTurn: true,
            key: `${key}-pending-state-${index}`,
            isLastTurn: true, // Pending states are always part of the last turn
        };
    });
}
function renderPendingAgentTurn(key, turn) {
    var _a;
    if (turn.pendingState === undefined && turn.completedSteps.length === 0) {
        return {
            static: [],
            dynamic: [
                {
                    type: "user-message",
                    message: turn.userMessage,
                    key: `${key}-user-message`,
                },
            ],
        };
    }
    if (((_a = turn.pendingState) === null || _a === void 0 ? void 0 : _a.type) === "text" && turn.completedSteps.length === 0) {
        return {
            static: [],
            dynamic: [
                {
                    type: "user-message",
                    message: turn.userMessage,
                    key: `${key}-user-message`,
                },
                ...(turn.pendingState !== undefined
                    ? renderAgentPendingState(key, turn.pendingState)
                    : []),
            ],
        };
    }
    return {
        static: [
            {
                type: "user-message",
                message: turn.userMessage,
                key: `${key}-user-message`,
            },
            ...turn.completedSteps.flatMap(step => {
                return renderCompletedStep(key, step, true); // Pending turns are always the last turn
            }),
        ],
        dynamic: turn.pendingState !== undefined
            ? renderAgentPendingState(key, turn.pendingState)
            : [],
    };
}
function renderPendingShellTurn(key, turn) {
    return {
        static: [],
        dynamic: [
            {
                type: "shell-turn",
                command: turn.shellCommand,
                key: `${key}-shell-turn`,
                stdout: turn.stdout,
                stderr: turn.stderr,
                exitCode: turn.exitCode,
            },
        ],
    };
}
function renderPendingTurn(key, turn) {
    if (turn.type === "agent") {
        return renderPendingAgentTurn(key, turn);
    }
    if (turn.type === "shell") {
        return renderPendingShellTurn(key, turn);
    }
    return {
        static: [],
        dynamic: [],
    };
}
function partitionConversationState(conversationState, debugInfo, headerProps) {
    var _a, _b;
    const staticItems = [
        {
            type: "header",
            key: "header",
            isRepository: (_a = headerProps === null || headerProps === void 0 ? void 0 : headerProps.isRepository) !== null && _a !== void 0 ? _a : false,
            folderMode: (_b = headerProps === null || headerProps === void 0 ? void 0 : headerProps.folderMode) !== null && _b !== void 0 ? _b : "cwd",
        },
    ];
    if (debugInfo) {
        staticItems.push({
            type: "debug-info",
            serverUrl: debugInfo.serverUrl,
            key: "debug-info",
        });
    }
    if (conversationState.summary) {
        staticItems.push({
            type: "summary",
            summary: conversationState.summary,
            key: "summary",
        });
    }
    const dynamicItems = [];
    let index = 0;
    for (const turn of conversationState.completedTurns) {
        // A completed turn is the last turn only if there's no pending turn and it's the last completed turn
        const isLastTurn = !conversationState.pendingTurn &&
            index === conversationState.completedTurns.length - 1;
        staticItems.push(...renderCompletedTurn(`turn-${index}`, turn, isLastTurn));
        index++;
    }
    if (conversationState.pendingTurn) {
        const { static: pendingStatic, dynamic: pendingDynamic } = renderPendingTurn(`turn-${index}`, conversationState.pendingTurn);
        staticItems.push(...pendingStatic);
        dynamicItems.push(...pendingDynamic);
    }
    return { staticItems, dynamicItems };
}
//# sourceMappingURL=static.js.map
;// ../agent-ui-state/dist/truncate.js
/**
 * Truncates the UIConversationState to keep only the last n completed turns.
 * If there's a pending turn, it's preserved.
 *
 * @param state - The current conversation state
 * @param maxTurns - Maximum number of completed turns to keep
 * @returns Truncated conversation state
 */
function truncateUIConversationState(state, maxTurns) {
    if (maxTurns < 0) {
        throw new Error("maxTurns must be non-negative");
    }
    if (maxTurns === 0) {
        return Object.assign(Object.assign({}, state), { completedTurns: [], pendingTurn: undefined });
    }
    if (maxTurns > state.completedTurns.length + (state.pendingTurn ? 1 : 0)) {
        return state;
    }
    const truncatedCompletedTurns = state.completedTurns.slice(-maxTurns);
    return Object.assign(Object.assign({}, state), { completedTurns: truncatedCompletedTurns, pendingTurn: undefined });
}
//# sourceMappingURL=truncate.js.map
;// ../agent-ui-state/dist/index.js
// Core types
// Agent turn management

// Common utilities

// Edit utilities

// Loader functions

// Main merge functions

// Plan management

// Shell turn management

// Static/dynamic rendering

// Tool call merging

// Truncation

//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./src/background.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   y: () => (/* binding */ BackgroundApp)
/* harmony export */ });
/* unused harmony export runBackground */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_proto_aiserver_v1_background_composer_pb_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../proto/dist/generated/aiserver/v1/background_composer_pb.js");
/* harmony import */ var _anysphere_proto_aiserver_v1_tools_pb_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../proto/dist/generated/aiserver/v1/tools_pb.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _components_animated_dots_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/animated-dots.tsx");
/* harmony import */ var _components_app_header_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/components/app-header.tsx");
/* harmony import */ var _components_background_edit_tool_ui_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/components/background-edit-tool-ui.tsx");
/* harmony import */ var _components_background_prompt_bar_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/components/background-prompt-bar.tsx");
/* harmony import */ var _components_background_shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("./src/components/background-shell-tool-ui.tsx");
/* harmony import */ var _components_background_tool_group_ui_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("./src/components/background-tool-group-ui.tsx");
/* harmony import */ var _components_hexagon_loader_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("./src/components/hexagon-loader.tsx");
/* harmony import */ var _components_markdown_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("./src/components/markdown.tsx");
/* harmony import */ var _components_prompt_ephemeral_lines_view_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("./src/components/prompt/ephemeral-lines-view.tsx");
/* harmony import */ var _components_step_container_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("./src/components/step-container.tsx");
/* harmony import */ var _components_user_message_ui_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("./src/components/user-message-ui.tsx");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _debug_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__("./src/debug.ts");
/* harmony import */ var _hooks_prompt_use_ephemeral_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__("./src/hooks/prompt/use-ephemeral.ts");
/* harmony import */ var _hooks_use_send_to_background_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__("./src/hooks/use-send-to-background.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _components_animated_dots_js__WEBPACK_IMPORTED_MODULE_5__, _components_app_header_js__WEBPACK_IMPORTED_MODULE_6__, _components_background_edit_tool_ui_js__WEBPACK_IMPORTED_MODULE_7__, _components_background_prompt_bar_js__WEBPACK_IMPORTED_MODULE_8__, _components_background_shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_9__, _components_background_tool_group_ui_js__WEBPACK_IMPORTED_MODULE_10__, _components_hexagon_loader_js__WEBPACK_IMPORTED_MODULE_11__, _components_markdown_js__WEBPACK_IMPORTED_MODULE_12__, _components_prompt_ephemeral_lines_view_js__WEBPACK_IMPORTED_MODULE_13__, _components_step_container_js__WEBPACK_IMPORTED_MODULE_14__, _components_user_message_ui_js__WEBPACK_IMPORTED_MODULE_15__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _components_animated_dots_js__WEBPACK_IMPORTED_MODULE_5__, _components_app_header_js__WEBPACK_IMPORTED_MODULE_6__, _components_background_edit_tool_ui_js__WEBPACK_IMPORTED_MODULE_7__, _components_background_prompt_bar_js__WEBPACK_IMPORTED_MODULE_8__, _components_background_shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_9__, _components_background_tool_group_ui_js__WEBPACK_IMPORTED_MODULE_10__, _components_hexagon_loader_js__WEBPACK_IMPORTED_MODULE_11__, _components_markdown_js__WEBPACK_IMPORTED_MODULE_12__, _components_prompt_ephemeral_lines_view_js__WEBPACK_IMPORTED_MODULE_13__, _components_step_container_js__WEBPACK_IMPORTED_MODULE_14__, _components_user_message_ui_js__WEBPACK_IMPORTED_MODULE_15__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




















// import { estimateBufferedTokens, formatTokenCount } from "./utils/tokens.js";
const mergeBackgroundItems = (bubbles) => {
    const computed = [];
    const toolsToIsolate = new Set([
        _anysphere_proto_aiserver_v1_tools_pb_js__WEBPACK_IMPORTED_MODULE_3__/* .ClientSideToolV2 */ .XaY.EDIT_FILE,
        _anysphere_proto_aiserver_v1_tools_pb_js__WEBPACK_IMPORTED_MODULE_3__/* .ClientSideToolV2 */ .XaY.EDIT_FILE_V2,
    ]);
    const accumulatedToolCalls = [];
    const flushAccumulatedToolCalls = () => {
        if (accumulatedToolCalls.length === 0)
            return;
        computed.push({
            type: "tool-group",
            // Clone to avoid later mutations clearing previously pushed groups
            toolCalls: [...accumulatedToolCalls],
            index: computed.length,
        });
        accumulatedToolCalls.length = 0;
    };
    for (let c = 0; c < bubbles.length; c++) {
        const bubble = bubbles[c];
        if (bubble.type === "text") {
            // we do not want to include streaming-in text
            if (!bubble.isDone)
                continue;
            flushAccumulatedToolCalls();
            computed.push({ type: "markdown", text: bubble.text, index: c });
        }
        else if (bubble.type === "tool") {
            if (toolsToIsolate.has(bubble.toolCall.tool)) {
                if (accumulatedToolCalls.length > 0) {
                    flushAccumulatedToolCalls();
                }
                computed.push({
                    type: "individual-tool",
                    call: bubble.toolCall,
                    result: bubble.toolResult,
                    index: c,
                });
            }
            else {
                accumulatedToolCalls.push({
                    call: bubble.toolCall,
                    result: bubble.toolResult,
                });
            }
        }
        else if (bubble.type === "user") {
            flushAccumulatedToolCalls();
            computed.push({
                type: "user-message",
                content: bubble.text,
                index: c,
            });
        }
    }
    flushAccumulatedToolCalls();
    return computed;
};
const BackgroundApp = ({ bcId, isAttached, backgroundComposerClient, isRepository, debugInfo, modelManager, modelDetails, responses, status, isLoadingConversation, addOptimisticFollowup, removeOptimisticFollowup, repoUrl, branchName, onRequestReview, onOpenComposerPicker, onSwitchComposer, changes: reviewChanges, isLoadingDiffs, }) => {
    const { sendFollowupToBackground, isSubmittingFollowup } = (0,_hooks_use_send_to_background_js__WEBPACK_IMPORTED_MODULE_19__/* .useSendToBackground */ .$)(backgroundComposerClient);
    // TODO: potentially model wouldn't exist in cli but exists outside
    const normalizedModelLabel = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => {
        var _a, _b;
        if (!modelDetails || !modelDetails.modelName)
            return undefined;
        return ((_b = (_a = modelManager.normalizeModelId(modelDetails.modelName)) === null || _a === void 0 ? void 0 : _a.displayName) !== null && _b !== void 0 ? _b : modelDetails.modelName);
    }, [modelDetails, modelManager]);
    const [inputValue, setInputValue] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)("");
    const ephemeral = (0,_hooks_prompt_use_ephemeral_js__WEBPACK_IMPORTED_MODULE_18__/* .useEphemeral */ .N)();
    // Nudge server to wake any hibernating background agent session for this bcId
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
        if (!bcId)
            return;
        try {
            void backgroundComposerClient
                .notifyBackgroundComposerShown({ bcId }, { timeoutMs: 10000 })
                .catch(() => { });
        }
        catch (_a) {
            // ignore
        }
    }, [bcId, backgroundComposerClient]);
    // Minimal slash commands for background mode (temporary)
    const slashCommands = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => {
        const cmds = [];
        cmds.push({
            id: "list",
            title: "List Sessions",
            description: "Open the picker or switch by id with '/list <id>'",
            args: [{ id: "id", required: false }],
            run: (_ctx, args) => {
                const targetId = (args[0] || "").trim();
                if (targetId) {
                    onSwitchComposer === null || onSwitchComposer === void 0 ? void 0 : onSwitchComposer(targetId);
                }
                else {
                    onOpenComposerPicker === null || onOpenComposerPicker === void 0 ? void 0 : onOpenComposerPicker();
                }
                setInputValue("");
            },
        });
        cmds.push({
            id: "switch",
            title: "Switch Background",
            description: "Switch to a background agent by id",
            args: [{ id: "id", required: true }],
            run: (_ctx, args) => {
                const targetId = (args[0] || "").trim();
                if (!targetId)
                    return;
                onSwitchComposer === null || onSwitchComposer === void 0 ? void 0 : onSwitchComposer(targetId);
                setInputValue("");
            },
        });
        return cmds;
    }, [onOpenComposerPicker, onSwitchComposer]);
    const { itemsToDisplay, firstLiveStepIndex } = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => {
        const merged = mergeBackgroundItems(responses.bubbles);
        const computed = [
            {
                type: "header",
                debugInfo: debugInfo,
                index: 1,
            },
        ];
        for (let i = 0; i < merged.length; i++) {
            computed.push(Object.assign(Object.assign({}, merged[i]), { index: computed.length }));
        }
        (0,_debug_js__WEBPACK_IMPORTED_MODULE_17__.debugLogJSON)("computed", computed);
        (0,_debug_js__WEBPACK_IMPORTED_MODULE_17__.debugLogJSON)("responses", responses);
        // Avoid printing any static content before attachment; otherwise when
        // attachment flips and we freeze items, previously printed static items
        // (like the banner) will be duplicated by Ink's Static.
        let firstIdx = 0;
        if (isAttached) {
            for (let i = 0; i < computed.length; i++) {
                const item = computed[i];
                switch (item.type) {
                    case "header":
                    case "markdown":
                    case "user-message":
                    case "individual-tool":
                        break;
                    case "tool-group":
                        // we don't want to include this if we're the last item
                        if (i === computed.length - 1) {
                            firstIdx = i;
                            break;
                        }
                        break;
                    default:
                        throw new Error(`Unhandled UIBackgroundItem`);
                }
                if (firstIdx !== -1) {
                    break;
                }
            }
            // If nothing requires live rendering, freeze the entire list
            firstIdx = computed.length;
        }
        return { itemsToDisplay: computed, firstLiveStepIndex: firstIdx };
    }, [responses, debugInfo, isAttached]);
    const renderBackgroundItem = (item) => {
        var _a, _b, _c, _d, _e, _f, _g;
        const shouldPadTop = item.index > 0 &&
            (((_a = itemsToDisplay[item.index - 1]) === null || _a === void 0 ? void 0 : _a.type) === "individual-tool" ||
                ((_b = itemsToDisplay[item.index - 1]) === null || _b === void 0 ? void 0 : _b.type) === "tool-group" ||
                ((_c = itemsToDisplay[item.index - 1]) === null || _c === void 0 ? void 0 : _c.type) === "markdown");
        switch (item.type) {
            case "header":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_app_header_js__WEBPACK_IMPORTED_MODULE_6__/* .AppHeader */ .j, { isBackground: true, debugInfo: item.debugInfo || undefined, isRepository: isRepository, folderMode: "git", locationDisplayOverride: repoUrl, branchDisplayOverride: branchName }));
            case "markdown":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_step_container_js__WEBPACK_IMPORTED_MODULE_14__/* .StepContainer */ .C, { shouldPadTop: shouldPadTop, paddingRight: 4, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_markdown_js__WEBPACK_IMPORTED_MODULE_12__/* .Markdown */ .oz, { content: item.text }) }));
            case "user-message":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: _constants_js__WEBPACK_IMPORTED_MODULE_16__/* .AGENT_CONVERSATION_MARGIN_LEFT */ .rd, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_user_message_ui_js__WEBPACK_IMPORTED_MODULE_15__/* .UserMessageUI */ .H, { content: item.content }) }));
            case "individual-tool": {
                const tool = item.call.tool;
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_17__.debugLog)("tool", _anysphere_proto_aiserver_v1_tools_pb_js__WEBPACK_IMPORTED_MODULE_3__/* .ClientSideToolV2 */ .XaY[tool]);
                if (tool === _anysphere_proto_aiserver_v1_tools_pb_js__WEBPACK_IMPORTED_MODULE_3__/* .ClientSideToolV2 */ .XaY.EDIT_FILE ||
                    tool === _anysphere_proto_aiserver_v1_tools_pb_js__WEBPACK_IMPORTED_MODULE_3__/* .ClientSideToolV2 */ .XaY.EDIT_FILE_V2) {
                    let result;
                    if (((_d = item.result) === null || _d === void 0 ? void 0 : _d.result.case) === "editFileResult") {
                        result = item.result.result.value;
                    }
                    const itemParams = item.call.params;
                    let rawPath;
                    if (itemParams.case === "editFileParams") {
                        rawPath = itemParams.value.relativeWorkspacePath;
                    }
                    else {
                        rawPath = itemParams.value
                            .relativeWorkspacePath;
                    }
                    const stripWorkspacePath = rawPath.startsWith("/workspace/")
                        ? rawPath.slice("/workspace/".length)
                        : rawPath;
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: _constants_js__WEBPACK_IMPORTED_MODULE_16__/* .AGENT_CONVERSATION_MARGIN_LEFT */ .rd, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_step_container_js__WEBPACK_IMPORTED_MODULE_14__/* .StepContainer */ .C, { shouldPadTop: shouldPadTop, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_background_edit_tool_ui_js__WEBPACK_IMPORTED_MODULE_7__/* .BackgroundEditToolUI */ .l, { path: stripWorkspacePath, result: result }) }) }));
                }
                if (tool === _anysphere_proto_aiserver_v1_tools_pb_js__WEBPACK_IMPORTED_MODULE_3__/* .ClientSideToolV2 */ .XaY.RUN_TERMINAL_COMMAND_V2) {
                    const paramsOneof = item.call.params;
                    const callParams = paramsOneof.case === "runTerminalCommandV2Params"
                        ? paramsOneof.value
                        : undefined;
                    const cmd = (_e = callParams === null || callParams === void 0 ? void 0 : callParams.command) !== null && _e !== void 0 ? _e : "";
                    const cwd = (_f = callParams === null || callParams === void 0 ? void 0 : callParams.cwd) !== null && _f !== void 0 ? _f : undefined;
                    let runResult;
                    if (((_g = item.result) === null || _g === void 0 ? void 0 : _g.result.case) === "runTerminalCommandV2Result") {
                        runResult = item.result.result.value;
                    }
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: _constants_js__WEBPACK_IMPORTED_MODULE_16__/* .AGENT_CONVERSATION_MARGIN_LEFT */ .rd, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_step_container_js__WEBPACK_IMPORTED_MODULE_14__/* .StepContainer */ .C, { shouldPadTop: shouldPadTop, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_background_shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_9__/* .BackgroundShellToolUI */ .d, { command: cmd, cwd: cwd, result: runResult }) }) }));
                }
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: _constants_js__WEBPACK_IMPORTED_MODULE_16__/* .AGENT_CONVERSATION_MARGIN_LEFT */ .rd, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_step_container_js__WEBPACK_IMPORTED_MODULE_14__/* .StepContainer */ .C, { shouldPadTop: shouldPadTop, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: ["Tool: ", item.call.tool] }) }) }));
            }
            case "tool-group": {
                const isLastItem = item.index === itemsToDisplay.length - 1;
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: _constants_js__WEBPACK_IMPORTED_MODULE_16__/* .AGENT_CONVERSATION_MARGIN_LEFT */ .rd, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_step_container_js__WEBPACK_IMPORTED_MODULE_14__/* .StepContainer */ .C, { shouldPadTop: shouldPadTop, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_background_tool_group_ui_js__WEBPACK_IMPORTED_MODULE_10__/* .BackgroundToolGroupUI */ .i, { toolCalls: item.toolCalls, forceCompleted: !isLastItem }) }) }));
            }
            default:
                throw new Error(`Unhandled UIBackgroundItem`);
        }
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Static */ .jC, { items: itemsToDisplay.slice(0, firstLiveStepIndex), children: (item) => {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: renderBackgroundItem(item) }, `static-bg-item-${item.index}`));
                } }), firstLiveStepIndex < itemsToDisplay.length && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: itemsToDisplay.slice(firstLiveStepIndex).map(item => {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: renderBackgroundItem(item) }, `live-bg-item-${item.index}`));
                }) })), (isLoadingConversation ||
                (isLoadingDiffs && status !== _anysphere_proto_aiserver_v1_background_composer_pb_js__WEBPACK_IMPORTED_MODULE_2__/* .BackgroundComposerStatus */ .R6.CREATING)) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", gap: 1, paddingTop: isLoadingConversation ? 2 : 0, paddingLeft: 2, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_hexagon_loader_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A, { customInterval: 210, activeColor: "cyan" }, "bg-load-hex") }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { bold: true, children: isLoadingConversation
                                    ? "Loading conversation"
                                    : "Loading diffs" }) })] }) })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_background_prompt_bar_js__WEBPACK_IMPORTED_MODULE_8__/* .BackgroundPromptBar */ .m, { prompt: inputValue, setPrompt: setInputValue, onSubmit: value => {
                        const raw = value.trim();
                        if (!raw)
                            return;
                        if (!bcId)
                            return;
                        const toSend = raw;
                        const optimisticId = addOptimisticFollowup(toSend);
                        void sendFollowupToBackground(bcId, toSend, {
                            synchronous: true,
                            bubbleId: optimisticId,
                        })
                            .then(result => {
                            if (result.type === "error") {
                                removeOptimisticFollowup(optimisticId);
                            }
                        })
                            .catch(() => {
                            removeOptimisticFollowup(optimisticId);
                        });
                        setInputValue("");
                    }, isDisabled: !bcId, isProcessing: false, topStatusMarginTop: itemsToDisplay.length > 0 ? 3 : 1, topStatus: (() => {
                        const hasActiveThinking = (() => {
                            const b = responses.bubbles;
                            for (let i = b.length - 1; i >= 0; i--) {
                                const bb = b[i];
                                if (bb.type === "thinking")
                                    return !bb.isDone;
                            }
                            return false;
                        })();
                        const isGeneratingLike = hasActiveThinking ||
                            status === _anysphere_proto_aiserver_v1_background_composer_pb_js__WEBPACK_IMPORTED_MODULE_2__/* .BackgroundComposerStatus */ .R6.RUNNING ||
                            status === _anysphere_proto_aiserver_v1_background_composer_pb_js__WEBPACK_IMPORTED_MODULE_2__/* .BackgroundComposerStatus */ .R6.CREATING;
                        if (isSubmittingFollowup || isGeneratingLike) {
                            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", gap: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_hexagon_loader_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A, { customInterval: 210, activeColor: "green" }, "bg-gen-hex") }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { bold: true, children: isSubmittingFollowup
                                                    ? "Pending"
                                                    : hasActiveThinking
                                                        ? "Thinking"
                                                        : status === _anysphere_proto_aiserver_v1_background_composer_pb_js__WEBPACK_IMPORTED_MODULE_2__/* .BackgroundComposerStatus */ .R6.RUNNING
                                                            ? "Generating"
                                                            : "Starting VM" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { bold: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_animated_dots_js__WEBPACK_IMPORTED_MODULE_5__/* .AnimatedDots */ .U, {}) })] })] }));
                        }
                        return null;
                    })(), modelLabel: normalizedModelLabel, branchName: branchName, repoUrl: repoUrl, onRequestReview: onRequestReview, bcId: bcId, changes: reviewChanges, isLoadingDiffs: isLoadingDiffs, slashCommands: slashCommands, backgroundComposerClient: backgroundComposerClient, printEphemeral: (lines, options) => ephemeral.set(lines, options) }) }, "prompt"), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_prompt_ephemeral_lines_view_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A, { lines: ephemeral.lines })] }));
};
function runBackground(_opts) {
    return __awaiter(this, void 0, void 0, function* () {
        const { waitUntilExit } = render(_jsx(Box, { children: _jsx(Text, { children: "Hello" }) }));
        yield waitUntilExit();
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/commands/chat.ts":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   runChat: () => (/* binding */ runChat)
/* harmony export */ });
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:fs");
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_fs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../cursor-config/dist/index.js");
/* harmony import */ var _anysphere_shell_exec__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../shell-exec/dist/index.js");
/* harmony import */ var _analytics_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/analytics.ts");
/* harmony import */ var _api_key_auth_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/api-key-auth.ts");
/* harmony import */ var _client_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/client.ts");
/* harmony import */ var _console_io_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("./src/console-io.ts");
/* harmony import */ var _execution_mode_approval_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/execution-mode/approval.tsx");
/* harmony import */ var _mcp_approval_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/mcp/approval.tsx");
/* harmony import */ var _onboarding_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("./src/onboarding.tsx");
/* harmony import */ var _run_agent_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("./src/run-agent.tsx");
/* harmony import */ var _tracing_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("./src/tracing.ts");
/* harmony import */ var _utils_api_endpoint_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("./src/utils/api-endpoint.ts");
/* harmony import */ var _utils_output_format_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("./src/utils/output-format.ts");
/* harmony import */ var _workspace_approval_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("./src/workspace/approval.tsx");
/* harmony import */ var _resume_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("./src/commands/resume.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_execution_mode_approval_js__WEBPACK_IMPORTED_MODULE_7__, _mcp_approval_js__WEBPACK_IMPORTED_MODULE_8__, _onboarding_js__WEBPACK_IMPORTED_MODULE_9__, _run_agent_js__WEBPACK_IMPORTED_MODULE_10__, _workspace_approval_js__WEBPACK_IMPORTED_MODULE_12__, _resume_js__WEBPACK_IMPORTED_MODULE_13__]);
([_execution_mode_approval_js__WEBPACK_IMPORTED_MODULE_7__, _mcp_approval_js__WEBPACK_IMPORTED_MODULE_8__, _onboarding_js__WEBPACK_IMPORTED_MODULE_9__, _run_agent_js__WEBPACK_IMPORTED_MODULE_10__, _workspace_approval_js__WEBPACK_IMPORTED_MODULE_12__, _resume_js__WEBPACK_IMPORTED_MODULE_13__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

















/**
 * Parse curl-style headers from CLI arguments.
 * Accepts headers in the format "Header-Name: Header-Value"
 * Can be a single string or an array of strings.
 */
function parseHeaders(headerOption) {
    if (!headerOption) {
        return undefined;
    }
    const headers = {};
    const headerArray = Array.isArray(headerOption)
        ? headerOption
        : [headerOption];
    for (const header of headerArray) {
        const colonIndex = header.indexOf(":");
        if (colonIndex === -1) {
            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, `Error: Invalid header format "${header}". Expected format: "Header-Name: Header-Value"`);
        }
        const name = header.substring(0, colonIndex).trim();
        const value = header.substring(colonIndex + 1).trim();
        if (!name) {
            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, `Error: Invalid header format "${header}". Header name cannot be empty.`);
        }
        headers[name] = value;
    }
    return Object.keys(headers).length > 0 ? headers : undefined;
}
function runChat(ctx_1, promptArgs_1, options_1, _a) {
    return __awaiter(this, arguments, void 0, function* (ctx, promptArgs, options, { rgPath, diagnosticsProvider, codebaseReferenceProvider, configProvider, credentialManager, }) {
        var _b, _c, _d;
        yield (0,_tracing_js__WEBPACK_IMPORTED_MODULE_11__/* .initTracing */ .H)({
            backendUrl: (0,_utils_api_endpoint_js__WEBPACK_IMPORTED_MODULE_15__/* .getApiEndpoint */ .G6)(options.endpoint),
            credentialManager,
            configProvider,
        });
        const backendUrl = (0,_utils_api_endpoint_js__WEBPACK_IMPORTED_MODULE_15__/* .getApiEndpoint */ .G6)(options.endpoint);
        // Initialize analytics.
        try {
            (0,_client_js__WEBPACK_IMPORTED_MODULE_6__/* .initAnalytics */ .Bu)(credentialManager, {
                endpoint: backendUrl,
                insecure: options.insecure,
            });
        }
        catch (_f) {
            // don't block anything on analytics init errors
        }
        const printEnvRequested = options.printenv === true;
        let resumeChatId;
        let resumeBackgroundId;
        if (options.resume !== false) {
            if (options.resume === true) {
                const backgroundClient = (0,_client_js__WEBPACK_IMPORTED_MODULE_6__/* .createBackgroundComposerClient */ .c3)(credentialManager, backendUrl, configProvider);
                const selection = yield (0,_resume_js__WEBPACK_IMPORTED_MODULE_13__/* .handleResume */ .oh)(backgroundClient);
                if (!selection) {
                    process.exit(0);
                }
                if (selection.kind === "chat") {
                    resumeChatId = selection.id;
                }
                else if (selection.kind === "background") {
                    resumeBackgroundId = selection.id;
                }
            }
            else if (typeof options.resume === "string") {
                // Support --resume=-n where n is a positive integer (1 = latest)
                const m = options.resume.match(/^-(\d+)$/);
                if (m) {
                    const nRaw = Number(m[1]);
                    const n = Number.isFinite(nRaw) && nRaw > 0 ? nRaw : 1;
                    const id = yield (0,_resume_js__WEBPACK_IMPORTED_MODULE_13__/* .getNthRecentChatId */ .xT)(n);
                    if (!id) {
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, "No previous chats found.");
                    }
                    resumeChatId = id || undefined;
                }
                else if (options.resume === "-1") {
                    // Back-compat: treat -1 as latest
                    const latestChat = yield (0,_resume_js__WEBPACK_IMPORTED_MODULE_13__/* .getLatestChatId */ .$0)();
                    if (!latestChat) {
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, "No previous chats found.");
                    }
                    resumeChatId = latestChat;
                }
                else {
                    resumeChatId = options.resume;
                }
            }
        }
        // Detect redirected stdin/stdout early to determine if we're in headless mode
        const stdinIsPiped = !process.stdin.isTTY;
        const stdoutIsTTY = Boolean(process.stdout.isTTY);
        // Determine if we should run in print mode (auto when redirected)
        // Note: Commander sets boolean options to false by default, which would
        // make `??` pick false even when stdin is piped. We want piping or
        // non-TTY stdout to force print mode regardless of the default value.
        const inferredPrint = options.print === true || !stdoutIsTTY || stdinIsPiped;
        if (printEnvRequested && !inferredPrint) {
            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, "Error: --printenv can only be used with --print/headless mode");
        }
        // If the user provided an auth token, use it directly
        const { isAuthenticated: isAuthTokenAuthenticated, usingAuthTokenFromEnv } = yield (0,_api_key_auth_js__WEBPACK_IMPORTED_MODULE_5__/* .tryAuthTokenAuth */ .D)(credentialManager, {
            authToken: options.authToken,
        });
        // If the user provided an API key or has an env var, we will exit and show the user a warning if it cannot be used.
        const { isAuthenticated: isApiKeyAuthenticated, usingApiKeyFromEnv } = isAuthTokenAuthenticated
            ? { isAuthenticated: false, usingApiKeyFromEnv: false }
            : yield (0,_api_key_auth_js__WEBPACK_IMPORTED_MODULE_5__/* .tryApiKeyAuth */ .T)(credentialManager, {
                apiKey: options.apiKey,
                endpoint: backendUrl,
            });
        const isAuthenticated = isAuthTokenAuthenticated ||
            isApiKeyAuthenticated ||
            (yield (0,_onboarding_js__WEBPACK_IMPORTED_MODULE_9__/* .checkAuthenticationStatus */ .h4)(credentialManager, _onboarding_js__WEBPACK_IMPORTED_MODULE_9__/* .AuthType */ .hT.LOGIN));
        if (!isAuthenticated) {
            // In headless mode, exit immediately with a clear error instead of prompting
            if (inferredPrint) {
                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, "Error: Authentication required. Please run 'cursor-agent login' first, or set CURSOR_API_KEY environment variable.");
            }
            // In interactive mode, run onboarding flow
            const dashboardClient = (0,_anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_2__/* .createDashboardClient */ .Vi)({
                credentialManager,
                endpoint: backendUrl,
                configProvider,
            });
            const onboardingSuccess = yield (0,_onboarding_js__WEBPACK_IMPORTED_MODULE_9__/* .runOnboarding */ .f4)(credentialManager, configProvider, dashboardClient);
            if (!onboardingSuccess) {
                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, "Authentication required to use Cursor Agent. Please run 'cursor-agent login' to authenticate.");
            }
        }
        // Prefer stdin when piped; fall back to args
        let prompt = promptArgs.join(" ");
        if (stdinIsPiped) {
            const stdinData = yield new Promise(resolve => {
                let buf = "";
                try {
                    process.stdin.setEncoding("utf8");
                }
                catch (_a) {
                    /* ignore */
                }
                process.stdin.on("data", chunk => {
                    buf += String(chunk);
                });
                process.stdin.on("end", () => resolve(buf));
                process.stdin.on("error", () => resolve(buf));
            });
            const fromStdin = stdinData.trim();
            if (fromStdin.length > 0) {
                prompt = fromStdin;
            }
        }
        if (options.toolGallery) {
            const { runToolGallery } = yield __webpack_require__.e(/* import() */ 9722).then(__webpack_require__.bind(__webpack_require__, "./src/tool-gallery.tsx"));
            yield runToolGallery();
            return;
        }
        if (options.ianDev) {
            const { runIanDev } = yield __webpack_require__.e(/* import() */ 3743).then(__webpack_require__.bind(__webpack_require__, "./src/ian-dev.tsx"));
            if (options.debug) {
                const { initDebug } = yield Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, "./src/debug.ts"));
                yield initDebug();
            }
            yield runIanDev();
            return;
        }
        if (options.markdownTest) {
            const { runMarkdownTest } = yield __webpack_require__.e(/* import() */ 6309).then(__webpack_require__.bind(__webpack_require__, "./src/markdown-test.tsx"));
            yield runMarkdownTest();
            return;
        }
        if (options.colorGallery) {
            const { runColorGallery } = yield __webpack_require__.e(/* import() */ 6549).then(__webpack_require__.bind(__webpack_require__, "./src/color-gallery.tsx"));
            yield runColorGallery();
            return;
        }
        // Determine apiKeySource for stream init message
        const apiKeySource = usingApiKeyFromEnv || usingAuthTokenFromEnv // pragma: allowlist secret
            ? "env"
            : options.apiKey || options.authToken
                ? "flag"
                : "login";
        // Validate that --output-format is only used with --print
        // Note: text is the default, so we only error if user explicitly set a different format
        const isExplicitOutputFormat = process.argv.some(arg => arg.startsWith("--output-format"));
        if (isExplicitOutputFormat && !inferredPrint) {
            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, "Error: --output-format can only be used with --print");
        }
        // Validate that --stream-partial-output is only used with --print and stream-json
        const isExplicitStreamPartialOutput = process.argv.some(arg => arg.startsWith("--stream-partial-output"));
        if (isExplicitStreamPartialOutput && !inferredPrint) {
            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, "Error: --stream-partial-output can only be used with --print");
        }
        // Validate output format eagerly so invalid flags fail fast
        let validatedOutputFormat;
        try {
            validatedOutputFormat = inferredPrint
                ? (0,_utils_output_format_js__WEBPACK_IMPORTED_MODULE_16__/* .validateOutputFormat */ .nt)(options.outputFormat)
                : undefined;
        }
        catch (e) {
            const msg = e instanceof Error ? e.message : String(e);
            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, msg);
        }
        // Validate that --stream-partial-output is only used with stream-json format
        if (options.streamPartialOutput && validatedOutputFormat !== "stream-json") {
            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, "Error: --stream-partial-output requires --output-format stream-json");
        }
        // Track run mode/flags for analytics
        try {
            (0,_analytics_js__WEBPACK_IMPORTED_MODULE_4__/* .trackEvent */ .sx)("cli.run.mode", {
                headless: inferredPrint || !stdoutIsTTY || stdinIsPiped,
                print_flag: options.print === true,
                output_text: validatedOutputFormat === "text",
                output_json: validatedOutputFormat === "json",
                output_stream_json: validatedOutputFormat === "stream-json",
                stream_partial_output: options.streamPartialOutput === true,
                api_key_env: usingApiKeyFromEnv,
            });
        }
        catch (_g) { }
        if (!inferredPrint) {
            // Resolve workspace path if provided
            const workspacePath = options.workspace
                ? (0,node_path__WEBPACK_IMPORTED_MODULE_1__.resolve)(options.workspace)
                : process.cwd();
            // Has the user trusted this workspace (or a parent that is not too close to root)?
            const workspaceApprovalResult = yield (0,_workspace_approval_js__WEBPACK_IMPORTED_MODULE_12__/* .runWorkspaceApproval */ .c)(workspacePath);
            if (workspaceApprovalResult === "quit") {
                process.exit(0);
            }
            // Has the user trusted all MCPs that are used in this workspace?
            // If we've just approved the workspace, it means we've already confirmed MCPs
            if (workspaceApprovalResult === "already_approved") {
                const mcpApprovalResult = yield (0,_mcp_approval_js__WEBPACK_IMPORTED_MODULE_8__/* .runMcpApproval */ .Ny)(workspacePath);
                if (mcpApprovalResult === "quit") {
                    process.exit(0);
                }
            }
            // Check execution mode configuration
            const shouldQuit = yield (0,_execution_mode_approval_js__WEBPACK_IMPORTED_MODULE_7__/* .runExecutionModeApproval */ .K)(configProvider);
            if (shouldQuit) {
                // User quit during execution mode approval
                process.exit(0);
            }
            // Show TUI banner if sandbox configured but unsupported on this OS
            const cfg = configProvider.get();
            const sandboxMode = (_c = (_b = cfg.sandbox) === null || _b === void 0 ? void 0 : _b.mode) !== null && _c !== void 0 ? _c : "disabled";
            if (sandboxMode === "enabled") {
                const supported = _anysphere_shell_exec__WEBPACK_IMPORTED_MODULE_3__/* .SandboxInternal.isSandboxSupported */ .pe.isSandboxSupported();
                if (!supported) {
                    process.env.AGENT_CLI_SESSION_WARNING_SANDBOX_UNSUPPORTED = "1";
                }
            }
        }
        yield (0,_run_agent_js__WEBPACK_IMPORTED_MODULE_10__/* .runAgent */ .J)(ctx, prompt, {
            backendUrl,
            endpoint: options.endpoint,
            insecure: (_d = options.insecure) !== null && _d !== void 0 ? _d : false,
            print: inferredPrint,
            outputFormat: validatedOutputFormat,
            streamPartialOutput: options.streamPartialOutput,
            debug: Boolean(options.debug),
            withDiffs: Boolean(options.withDiffs),
            resumeChatId,
            resumeBcId: resumeBackgroundId,
            rgPath,
            configProvider,
            diagnosticsProvider,
            codebaseReferenceProvider,
            model: options.model,
            usingApiKeyFromEnv,
            apiKeySource,
            isBrowserUseEnabled: Boolean(options.browser),
            force: Boolean(options.force),
            approveMcps: inferredPrint && Boolean(options.approveMcps),
            mode: options.cloud || options.background ? "background" : options.mode,
            workspace: options.workspace,
            headers: parseHeaders(options.header),
            systemPromptPathEnvVar: (() => {
                const p = options.systemPrompt;
                if (typeof p === "string" && p.trim().length > 0) {
                    const abs = (0,node_path__WEBPACK_IMPORTED_MODULE_1__.resolve)(p);
                    if (!(0,node_fs__WEBPACK_IMPORTED_MODULE_0__.existsSync)(abs)) {
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, `Error: --system-prompt file not found: ${abs}`);
                    }
                    try {
                        // Quick sanity check read; actual content is read in transport
                        const content = (0,node_fs__WEBPACK_IMPORTED_MODULE_0__.readFileSync)(abs, "utf8");
                        if (!content || content.trim().length === 0) {
                            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, `Error: --system-prompt file is empty: ${abs}`);
                        }
                    }
                    catch (_e) {
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_14__/* .exitWithMessage */ .uQ)(1, `Error: failed to read --system-prompt file: ${abs}`);
                    }
                    return abs;
                }
                return undefined;
            })(),
            printEnv: printEnvRequested,
        }, credentialManager);
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/commands/custom-commands.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: () => (/* binding */ CustomCommandsLoader)
/* harmony export */ });
/* harmony import */ var node_fs_promises__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:fs/promises");
/* harmony import */ var node_fs_promises__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_fs_promises__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:os");
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_os__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _anysphere_proto_aiserver_v1_dashboard_pb_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../proto/dist/generated/aiserver/v1/dashboard_pb.js");
/* harmony import */ var _debug_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/debug.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





/**
 * This loader is responsible for loading and storing custom Cursor slash commands from:
 * 1. Personal commands in ~/.cursor/commands and ~/.claude/commands
 * 2. Workspace-specific commands in .cursor/commands and .claude/commands directories
 * 3. Team-specific commands from the backend
 * It follows the same priority order as the VSCode CursorCommandsService.
 */
class CustomCommandsLoader {
    constructor(dashboardClient) {
        this.commands = new Map();
        this.dashboardClient = dashboardClient;
    }
    loadCommands(projectRoot) {
        return __awaiter(this, void 0, void 0, function* () {
            this.commands.clear();
            // Load commands in priority order (later sources override earlier ones)
            // 1. Load team commands (lowest priority)
            yield this.loadTeamCommands();
            // 2. Load workspace claude commands
            yield this.loadCommandsFromDirectory((0,node_path__WEBPACK_IMPORTED_MODULE_2__.join)(projectRoot, ".claude", "commands"), "claude-workspace");
            // 3. Load workspace cursor commands (override claude commands if same name)
            yield this.loadCommandsFromDirectory((0,node_path__WEBPACK_IMPORTED_MODULE_2__.join)(projectRoot, ".cursor", "commands"), "workspace");
            // 4. Load personal claude commands (override workspace commands)
            yield this.loadCommandsFromDirectory((0,node_path__WEBPACK_IMPORTED_MODULE_2__.join)((0,node_os__WEBPACK_IMPORTED_MODULE_1__.homedir)(), ".claude", "commands"), "claude-user");
            // 5. Load personal cursor commands last (highest priority, override claude commands if same name)
            yield this.loadCommandsFromDirectory((0,node_path__WEBPACK_IMPORTED_MODULE_2__.join)((0,node_os__WEBPACK_IMPORTED_MODULE_1__.homedir)(), ".cursor", "commands"), "user");
            // Convert to SlashCommand format
            return Array.from(this.commands.values()).map(command => this.convertToSlashCommand(command));
        });
    }
    loadCommandsFromDirectory(dirPath, source) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!(yield this.exists(dirPath))) {
                return;
            }
            const files = yield this.readDirectory(dirPath);
            const markdownFiles = files.filter(file => !file.isDirectory && file.name.endsWith(".md"));
            for (const file of markdownFiles) {
                const content = yield this.readTextFile(file.path);
                if (!content)
                    continue;
                const command = this.parseMarkdownCommand(file.name, content, source);
                if (command) {
                    this.commands.set(command.id, command);
                }
            }
        });
    }
    parseMarkdownCommand(filename, content, source) {
        const id = filename.replace(/\.md$/, "");
        if (!id.trim())
            return null;
        const lines = content.split("\n");
        const title = this.extractTitle(lines[0]) || id;
        return {
            id,
            title,
            description: title,
            content: content.trim(),
            source,
            filename,
        };
    }
    extractTitle(firstLine) {
        if (!firstLine)
            return null;
        // Extract title from markdown heading
        const match = firstLine.match(/^#+\s*(.+)$/);
        if (match) {
            return match[1].trim();
        }
        // If no heading, use the first line if it's not empty
        const trimmed = firstLine.trim();
        return trimmed ? trimmed : null;
    }
    convertToSlashCommand(command) {
        // Add scope indicator to the title
        const scopeIndicator = this.getScopeIndicator(command.source);
        return {
            id: command.id,
            title: command.title,
            description: `${command.description} ${scopeIndicator}`,
            run: (_ctx, _args, slashCommandCtx) => {
                var _a, _b;
                // Submit the command content directly
                if (slashCommandCtx.submitMessage) {
                    (_a = slashCommandCtx.clearInput) === null || _a === void 0 ? void 0 : _a.call(slashCommandCtx);
                    slashCommandCtx.submitMessage(command.content, {
                        display: `/${command.id}`,
                    });
                }
                else {
                    // Fallback: clear input and insert the content for user to review and submit
                    (_b = slashCommandCtx.clearInput) === null || _b === void 0 ? void 0 : _b.call(slashCommandCtx);
                    slashCommandCtx.insertText(command.content);
                }
            },
        };
    }
    getScopeIndicator(source) {
        switch (source) {
            case "team":
                return "(team)";
            case "workspace":
                return "(workspace)";
            case "user":
                return "(user)";
            case "claude-workspace":
                return "(workspace)";
            case "claude-user":
                return "(user)";
            default:
                return "";
        }
    }
    // File system utilities (inlined to avoid creating separate file)
    exists(path) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield (0,node_fs_promises__WEBPACK_IMPORTED_MODULE_0__.stat)(path);
                return true;
            }
            catch (_a) {
                return false;
            }
        });
    }
    readDirectory(dirPath) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const entries = yield (0,node_fs_promises__WEBPACK_IMPORTED_MODULE_0__.readdir)(dirPath, { withFileTypes: true });
                return entries.map(entry => ({
                    path: (0,node_path__WEBPACK_IMPORTED_MODULE_2__.join)(dirPath, entry.name),
                    name: entry.name,
                    isDirectory: entry.isDirectory(),
                }));
            }
            catch (_a) {
                return [];
            }
        });
    }
    readTextFile(filePath) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const content = yield (0,node_fs_promises__WEBPACK_IMPORTED_MODULE_0__.readFile)(filePath, "utf-8");
                return content;
            }
            catch (_a) {
                return null;
            }
        });
    }
    getLoadedCommands() {
        return Array.from(this.commands.values());
    }
    getCommandById(id) {
        return this.commands.get(id);
    }
    slugify(text) {
        return text
            .toLowerCase()
            .trim()
            .replace(/\s+/g, "-")
            .replace(/[^\w-]+/g, "")
            .replace(/--+/g, "-")
            .replace(/^-+/, "")
            .replace(/-+$/, "");
    }
    loadTeamCommands() {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                // First check if user belongs to a team
                const userResponse = yield this.dashboardClient.getMe(new _anysphere_proto_aiserver_v1_dashboard_pb_js__WEBPACK_IMPORTED_MODULE_3__/* .GetMeRequest */ .Ewt({}));
                // Only load team commands if user has a teamId
                if (!userResponse.teamId) {
                    (0,_debug_js__WEBPACK_IMPORTED_MODULE_4__.debugLog)("User does not belong to a team, skipping team commands");
                    return;
                }
                // Fetch active team commands from backend
                const response = yield this.dashboardClient.getTeamCommands(new _anysphere_proto_aiserver_v1_dashboard_pb_js__WEBPACK_IMPORTED_MODULE_3__/* .GetTeamCommandsRequest */ .XDt({
                    activeOnly: true,
                }));
                // Convert protobuf response to our command format
                for (const cmd of response.commands) {
                    if (!cmd.isActive)
                        continue; // Skip inactive commands
                    const command = {
                        id: this.slugify(cmd.name),
                        title: cmd.name,
                        description: cmd.description || cmd.content.trim(),
                        content: cmd.content,
                        source: "team",
                        filename: cmd.name,
                    };
                    // Only add if not already present (allows overriding by local commands)
                    if (!this.commands.has(command.id)) {
                        this.commands.set(command.id, command);
                    }
                }
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_4__.debugLog)("Loaded team commands:", response.commands.length);
            }
            catch (error) {
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_4__.debugLog)("Failed to load team commands:", error);
                // Don't throw - team commands are optional
            }
        });
    }
}


/***/ }),

/***/ "./src/commands/install-core-posix.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BV: () => (/* binding */ installCursorAgent)
/* harmony export */ });
/* unused harmony exports detectSystemInfo, updateSymlink, updateCursorShim, updateAgentShim */
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:child_process");
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_child_process__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:fs");
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_fs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("node:os");
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(node_os__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_3__);
/** biome-ignore-all lint/suspicious/noTemplateCurlyInString: we're bashin' here */
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




function detectSystemInfo() {
    const platform = node_os__WEBPACK_IMPORTED_MODULE_2__.platform();
    const arch = node_os__WEBPACK_IMPORTED_MODULE_2__.arch();
    // Map platform
    let osName;
    switch (platform) {
        case "linux":
            osName = "linux";
            break;
        case "darwin":
            osName = "darwin";
            break;
        default:
            throw new Error(`Unsupported operating system: ${platform}`);
    }
    // Map architecture
    let archName;
    switch (arch) {
        case "x64":
            archName = "x64";
            break;
        case "arm64":
            archName = "arm64";
            break;
        default:
            throw new Error(`Unsupported architecture: ${arch}`);
    }
    return { os: osName, arch: archName };
}
function updateSymlink(installDir) {
    const binDir = node_path__WEBPACK_IMPORTED_MODULE_3__.join(node_os__WEBPACK_IMPORTED_MODULE_2__.homedir(), ".local", "bin");
    node_fs__WEBPACK_IMPORTED_MODULE_1__.mkdirSync(binDir, { recursive: true });
    const sourcePath = node_path__WEBPACK_IMPORTED_MODULE_3__.join(installDir, "cursor-agent");
    const symlinkPath = node_path__WEBPACK_IMPORTED_MODULE_3__.join(binDir, "cursor-agent");
    // Remove existing symlink if it exists
    try {
        node_fs__WEBPACK_IMPORTED_MODULE_1__.unlinkSync(symlinkPath);
    }
    catch (_a) {
        // Ignore error if file doesn't exist
    }
    // Create symlink
    node_fs__WEBPACK_IMPORTED_MODULE_1__.symlinkSync(sourcePath, symlinkPath);
}
function updateCursorShim() {
    const binDir = node_path__WEBPACK_IMPORTED_MODULE_3__.join(node_os__WEBPACK_IMPORTED_MODULE_2__.homedir(), ".local", "bin");
    node_fs__WEBPACK_IMPORTED_MODULE_1__.mkdirSync(binDir, { recursive: true });
    const shimPath = node_path__WEBPACK_IMPORTED_MODULE_3__.join(binDir, "cursor");
    const script = [
        "#!/bin/sh",
        "set -eu",
        "",
        "# Find cursor executable in PATH, excluding the current shim",
        "find_cursor() {",
        '  old_IFS="$IFS"',
        "  IFS=:",
        "  for dir in $PATH; do",
        '    [ -n "$dir" ] || continue',
        '    cursor_path="$dir/cursor"',
        '    if [ "$cursor_path" != "$HOME/.local/bin/cursor" ] && [ -x "$cursor_path" ]; then',
        '      IFS="$old_IFS"',
        '      echo "$cursor_path"',
        "      return 0",
        "    fi",
        "  done",
        '  IFS="$old_IFS"',
        "  return 1",
        "}",
        "",
        "OTHER_CURSOR=$(find_cursor || true)",
        "",
        'if [ -n "${OTHER_CURSOR:-}" ]; then',
        '  exec "$OTHER_CURSOR" "$@"',
        "else",
        '  if [ "$1" != "agent" ]; then',
        "    echo \"Error: No Cursor IDE installation found. Use 'cursor agent' or 'agent' to run the agent.\" 1>&2",
        '    echo "Or, install Cursor at https://cursor.com/download" 1>&2',
        "    exit 1",
        "  fi",
        '  exec "$HOME/.local/bin/cursor-agent" "$@"',
        "fi",
        "",
    ].join("\n");
    // Install `cursor` keyword shortcut for `cursor-agent`
    node_fs__WEBPACK_IMPORTED_MODULE_1__.writeFileSync(shimPath, script, { mode: 0o755 });
    try {
        node_fs__WEBPACK_IMPORTED_MODULE_1__.chmodSync(shimPath, 0o755);
    }
    catch (_a) {
        /* ignore */
    }
}
function updateAgentShim() {
    const binDir = node_path__WEBPACK_IMPORTED_MODULE_3__.join(node_os__WEBPACK_IMPORTED_MODULE_2__.homedir(), ".local", "bin");
    node_fs__WEBPACK_IMPORTED_MODULE_1__.mkdirSync(binDir, { recursive: true });
    const shimPath = node_path__WEBPACK_IMPORTED_MODULE_3__.join(binDir, "agent");
    const script = [
        "#!/bin/sh",
        "set -eu",
        "",
        "# agent alias just calls cursor-agent",
        'exec "$HOME/.local/bin/cursor-agent" "$@"',
        "",
    ].join("\n");
    // Install `agent` alias for `cursor-agent`
    node_fs__WEBPACK_IMPORTED_MODULE_1__.writeFileSync(shimPath, script, { mode: 0o755 });
    try {
        node_fs__WEBPACK_IMPORTED_MODULE_1__.chmodSync(shimPath, 0o755);
    }
    catch (_a) {
        /* ignore */
    }
}
function installCursorAgent(options) {
    return __awaiter(this, void 0, void 0, function* () {
        const { version, urlPrefix, showProgress = false } = options;
        // Detect system
        const { os: osName, arch: archName } = detectSystemInfo();
        // Create installation paths
        const versionsDir = node_path__WEBPACK_IMPORTED_MODULE_3__.join(node_os__WEBPACK_IMPORTED_MODULE_2__.homedir(), ".local", "share", "cursor-agent", "versions");
        const finalInstallDir = node_path__WEBPACK_IMPORTED_MODULE_3__.join(versionsDir, version);
        const tempInstallDir = node_path__WEBPACK_IMPORTED_MODULE_3__.join(versionsDir, `.${version}`);
        // Check if the target directory already exists
        if (node_fs__WEBPACK_IMPORTED_MODULE_1__.existsSync(finalInstallDir)) {
            // Directory already exists, just update the symlink
            updateSymlink(finalInstallDir);
            updateCursorShim();
            updateAgentShim();
            return;
        }
        // Clean up any existing temp directory
        try {
            node_fs__WEBPACK_IMPORTED_MODULE_1__.rmSync(tempInstallDir, { recursive: true, force: true });
        }
        catch (_a) {
            /* ignore */
        }
        // Create temp directory
        node_fs__WEBPACK_IMPORTED_MODULE_1__.mkdirSync(tempInstallDir, { recursive: true });
        // Download and extract package
        const urlPrefixWithSlash = urlPrefix.endsWith("/")
            ? urlPrefix
            : `${urlPrefix}/`;
        const downloadUrl = `${urlPrefixWithSlash}${osName}/${archName}/agent-cli-package.tar.gz`;
        try {
            const curlArgs = showProgress
                ? ["-fSL", "--progress-bar", downloadUrl]
                : ["-fSL", "-s", downloadUrl];
            yield new Promise((resolve, reject) => {
                const stderrMode = options.showProgress ? "inherit" : "ignore";
                // Start tar first so we can pipe into its stdin
                const tarProc = (0,node_child_process__WEBPACK_IMPORTED_MODULE_0__.spawn)("tar", ["--strip-components=1", "-xzf", "-", "-C", tempInstallDir], {
                    stdio: ["pipe", "ignore", stderrMode],
                });
                const curlProc = (0,node_child_process__WEBPACK_IMPORTED_MODULE_0__.spawn)("curl", curlArgs, {
                    stdio: ["ignore", "pipe", stderrMode],
                });
                curlProc.stdout.pipe(tarProc.stdin);
                let curlExitCode = null;
                let tarExitCode = null;
                let settled = false;
                const trySettle = () => {
                    if (curlExitCode === null || tarExitCode === null || settled)
                        return;
                    settled = true;
                    if (curlExitCode !== 0) {
                        reject(new Error(`Download failed (curl exit ${curlExitCode})`));
                        return;
                    }
                    if (tarExitCode !== 0) {
                        reject(new Error(`Extraction failed (tar exit ${tarExitCode})`));
                        return;
                    }
                    resolve();
                };
                curlProc.on("error", err => {
                    if (settled)
                        return;
                    settled = true;
                    // Ensure tar is not left hanging
                    try {
                        tarProc.kill("SIGTERM");
                    }
                    catch (_a) {
                        /* ignore */
                    }
                    reject(err);
                });
                tarProc.on("error", err => {
                    if (settled)
                        return;
                    settled = true;
                    try {
                        curlProc.kill("SIGTERM");
                    }
                    catch (_a) {
                        /* ignore */
                    }
                    reject(err);
                });
                curlProc.on("close", (code) => {
                    var _a;
                    curlExitCode = code !== null && code !== void 0 ? code : 1;
                    // Close tar stdin when curl finishes
                    try {
                        (_a = tarProc.stdin) === null || _a === void 0 ? void 0 : _a.end();
                    }
                    catch (_b) {
                        /* ignore */
                    }
                    if (curlExitCode !== 0) {
                        // If curl failed, terminate tar to unblock quickly
                        try {
                            tarProc.kill("SIGTERM");
                        }
                        catch (_c) {
                            /* ignore */
                        }
                    }
                    trySettle();
                });
                tarProc.on("close", (code) => {
                    tarExitCode = code !== null && code !== void 0 ? code : 1;
                    if (tarExitCode !== 0) {
                        // If extraction failed, stop curl
                        try {
                            curlProc.kill("SIGTERM");
                        }
                        catch (_a) {
                            /* ignore */
                        }
                    }
                    trySettle();
                });
            });
            // If final directory exists, remove it first
            try {
                node_fs__WEBPACK_IMPORTED_MODULE_1__.rmSync(finalInstallDir, { recursive: true, force: true });
            }
            catch (_b) {
                /* ignore */
            }
            // Atomically rename temp directory to final directory
            node_fs__WEBPACK_IMPORTED_MODULE_1__.renameSync(tempInstallDir, finalInstallDir);
        }
        catch (error) {
            // Clean up temp directory on failure
            try {
                node_fs__WEBPACK_IMPORTED_MODULE_1__.rmSync(tempInstallDir, { recursive: true, force: true });
            }
            catch (_c) {
                /* ignore */
            }
            throw new Error(`Download failed: ${error instanceof Error ? error.message : String(error)}`);
        }
        // Update symlink
        updateSymlink(finalInstallDir);
        updateCursorShim();
        updateAgentShim();
    });
}


/***/ }),

/***/ "./src/commands/logout.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleLogout: () => (/* binding */ handleLogout)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_keychain__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../keychain/dist/index.js");
/* harmony import */ var _components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/login-ui.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




function handleLogout(credentialManager, configProvider) {
    return __awaiter(this, void 0, void 0, function* () {
        // Render the status component
        const { rerender } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .render */ .XX)((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .LogoutStatus */ .L, { status: "starting" }));
        try {
            const accessToken = yield credentialManager.getAccessToken();
            if (!accessToken) {
                rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .LogoutStatus */ .L, { status: "success", message: "Authentication tokens removed." }));
                process.exit(0);
            }
        }
        catch (error) {
            if (error instanceof _anysphere_keychain__WEBPACK_IMPORTED_MODULE_2__/* .PasswordNotFoundError */ .fI) {
                rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .LogoutStatus */ .L, { status: "success", message: "Authentication tokens removed." }));
                process.exit(0);
            }
        }
        try {
            rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .LogoutStatus */ .L, { status: "in-progress" }));
            yield credentialManager.clearAuthentication();
            yield configProvider.transform((c) => (Object.assign(Object.assign({}, c), { privacyCache: undefined })));
            rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .LogoutStatus */ .L, { status: "success", message: "Authentication tokens removed." }));
        }
        catch (error) {
            rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .LogoutStatus */ .L, { status: "error", message: `Failed to remove authentication tokens: ${error}` }));
            process.exit(1);
        }
        process.exit(0);
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/commands/resume.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $0: () => (/* binding */ getLatestChatId),
/* harmony export */   oh: () => (/* binding */ handleResume),
/* harmony export */   xT: () => (/* binding */ getNthRecentChatId)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:fs");
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_fs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _components_unified_list_pager_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/unified-list-pager.tsx");
/* harmony import */ var _state_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/state/index.ts");
/* harmony import */ var _state_sqlite_blob_store_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/state/sqlite-blob-store.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__, _components_unified_list_pager_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__, _components_unified_list_pager_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




// import { ChatPicker } from "../components/ChatPicker.js";



function handleResume(client) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise(resolve => {
            const handleSelectChat = (chatName) => {
                app.unmount();
                resolve({ kind: "chat", id: chatName });
            };
            const handleSelectBackground = (bcId) => {
                app.unmount();
                resolve({ kind: "background", id: bcId });
            };
            const handleExit = () => {
                app.unmount();
                resolve(null);
            };
            const app = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .render */ .XX)((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_unified_list_pager_js__WEBPACK_IMPORTED_MODULE_4__/* .UnifiedListPager */ .W, { client: client, onClose: handleExit, onSelectChat: handleSelectChat, onSelectBackground: handleSelectBackground }));
        });
    });
}
function getLatestChatId() {
    return __awaiter(this, void 0, void 0, function* () {
        const id = yield getNthRecentChatId(1);
        return id;
    });
}
/**
 * Returns the nth most recent chat id (1 = latest), sorted by creation time.
 * Creation time is determined similarly to UnifiedListPager:
 * - Prefer DB metadata `createdAt` if present
 * - Otherwise fall back to the earliest of directory/db birthtime (or mtime if birthtime missing)
 */
function getNthRecentChatId(n) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b;
        try {
            if (!Number.isFinite(n) || n <= 0)
                return null;
            const root = (0,_state_index_js__WEBPACK_IMPORTED_MODULE_5__/* .getChatsRootDir */ .r)();
            const entries = (0,node_fs__WEBPACK_IMPORTED_MODULE_1__.readdirSync)(root, { withFileTypes: true });
            const infos = yield Promise.all(entries
                .filter(e => e.isDirectory())
                .map((e) => __awaiter(this, void 0, void 0, function* () {
                const chatPath = (0,node_path__WEBPACK_IMPORTED_MODULE_2__.join)(root, e.name);
                try {
                    const dbPath = (0,node_path__WEBPACK_IMPORTED_MODULE_2__.join)(chatPath, "store.db");
                    // Compute FS-based createdAt as the minimum of db file and dir birth/mod times
                    let createdAtFsMs = Number.MAX_SAFE_INTEGER;
                    try {
                        const dbStat = (0,node_fs__WEBPACK_IMPORTED_MODULE_1__.statSync)(dbPath);
                        const dbBirthOrMod = Math.floor(dbStat.birthtimeMs ||
                            dbStat.mtimeMs);
                        if (dbBirthOrMod > 0) {
                            createdAtFsMs = Math.min(createdAtFsMs, dbBirthOrMod);
                        }
                    }
                    catch (_a) {
                        /* ignore */
                    }
                    try {
                        const dirStat = (0,node_fs__WEBPACK_IMPORTED_MODULE_1__.statSync)(chatPath);
                        const dirBirthOrMod = Math.floor(dirStat.birthtimeMs ||
                            dirStat.mtimeMs);
                        if (dirBirthOrMod > 0) {
                            createdAtFsMs = Math.min(createdAtFsMs, dirBirthOrMod);
                        }
                    }
                    catch (_b) {
                        /* ignore */
                    }
                    if (createdAtFsMs === Number.MAX_SAFE_INTEGER)
                        createdAtFsMs = 0;
                    // Check DB metadata and validity (non-empty latestRootBlobId)
                    const sqlite = yield _state_sqlite_blob_store_js__WEBPACK_IMPORTED_MODULE_6__/* .SQLiteBlobStoreWithMetadata */ .M.initAndLoad(dbPath);
                    const latestRootBlobId = sqlite.get("latestRootBlobId");
                    if (!latestRootBlobId || latestRootBlobId.length === 0)
                        return null;
                    const createdAtMeta = sqlite.get("createdAt");
                    const createdAtMs = normalizeTimestampToMs(createdAtMeta && Number.isFinite(createdAtMeta)
                        ? createdAtMeta
                        : createdAtFsMs);
                    return { name: e.name, createdAtMs };
                }
                catch (_c) {
                    return null;
                }
            })));
            const valid = infos.filter((x) => x !== null);
            valid.sort((a, b) => (b.createdAtMs || 0) - (a.createdAtMs || 0));
            const idx = Math.max(0, Math.min(valid.length - 1, n - 1));
            return (_b = (_a = valid[idx]) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : null;
        }
        catch (_c) {
            return null;
        }
    });
}
const normalizeTimestampToMs = (n) => {
    const v = typeof n === "number" ? n : 0;
    if (!(v > 0) || !Number.isFinite(v))
        return 0;
    if (v < 1e11)
        return Math.floor(v * 1000); // seconds -> ms
    if (v >= 1e14 && v < 1e17)
        return Math.floor(v / 1000); // microseconds -> ms
    if (v >= 1e17)
        return Math.floor(v / 1000000); // nanoseconds -> ms
    return Math.floor(v); // milliseconds
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/commands/set-line-numbers.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   x: () => (/* binding */ handleToggleLineNumbers)
/* harmony export */ });
/* unused harmony export handleSetLineNumbers */
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
function handleSetLineNumbers(configProvider, showLineNumbers) {
    return __awaiter(this, void 0, void 0, function* () {
        yield configProvider.transform(config => (Object.assign(Object.assign({}, config), { display: Object.assign(Object.assign({}, config.display), { showLineNumbers }) })));
    });
}
function handleToggleLineNumbers(configProvider) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b;
        const currentConfig = configProvider.get();
        const currentValue = (_b = (_a = currentConfig.display) === null || _a === void 0 ? void 0 : _a.showLineNumbers) !== null && _b !== void 0 ? _b : true;
        const newValue = !currentValue;
        yield handleSetLineNumbers(configProvider, newValue);
        return newValue;
    });
}


/***/ }),

/***/ "./src/commands/update-core.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  N: () => (/* binding */ updateCursorAgent)
});

// UNUSED EXPORTS: checkForUpdate

// EXTERNAL MODULE: ./src/console-io.ts
var console_io = __webpack_require__("./src/console-io.ts");
// EXTERNAL MODULE: ./src/commands/install-core-posix.ts
var install_core_posix = __webpack_require__("./src/commands/install-core-posix.ts");
// EXTERNAL MODULE: external "node:child_process"
var external_node_child_process_ = __webpack_require__("node:child_process");
;// ./src/commands/install-core-win32.ts
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const prodUpdateUrl = "https://cursor.com";
function installCursorAgentWin32(currentVersion, channel, showProgress) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        // Build the PowerShell command to download and execute the installer script
        const ver = currentVersion ? `&version=${currentVersion}` : "";
        const base = (_a = process.env.AGENT_CLI_OVERRIDE_UPDATE_URL) !== null && _a !== void 0 ? _a : prodUpdateUrl;
        const url = `${base}/install?win32=true&update=true&channel=${channel}${ver}`;
        const command = `irm '${url}' | iex`;
        // Execute the PowerShell command
        yield new Promise((resolve, reject) => {
            const stdioMode = showProgress ? "inherit" : "ignore";
            const psProc = spawn("powershell.exe", ["-NoProfile", "-ExecutionPolicy", "Bypass", "-Command", command], {
                stdio: ["ignore", stdioMode, stdioMode],
                shell: false,
            });
            psProc.on("error", err => {
                reject(new Error(`Failed to execute PowerShell: ${err instanceof Error ? err.message : String(err)}`));
            });
            psProc.on("close", (code) => {
                if (code !== 0) {
                    reject(new Error(`Installation failed: PowerShell exited with code ${code !== null && code !== void 0 ? code : "unknown"}`));
                    return;
                }
                resolve();
            });
        });
    });
}

;// ./src/commands/update-core.ts
var update_core_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



function checkForUpdate(dashboardClient, channel) {
    return update_core_awaiter(this, void 0, void 0, function* () {
        // Map prod-stable-internal to prod for the API call (client-only concept)
        // prod-stable-internal is an internal alias for prod to avoid auto-update of devs to staging channel
        const apiChannel = channel === "prod-stable-internal" ? "prod" : channel;
        // Get the latest CLI download information from the server
        const response = yield dashboardClient.getCliDownloadUrl({
            channel: apiChannel,
        });
        if (!response.url || !response.version) {
            throw new Error("Invalid response from server: missing URL or version information");
        }
        return {
            version: response.version,
            url: response.url,
        };
    });
}
function updateCursorAgent(options) {
    return update_core_awaiter(this, void 0, void 0, function* () {
        var _a, _b;
        const { dashboardClient, showProgress = true } = options;
        if (showProgress) {
            (0,console_io/* intentionallyWriteToStderr */.p2)("Checking for updates...");
        }
        const updateInfo = yield checkForUpdate(dashboardClient, options.channel);
        if (updateInfo.version === "2025.11.25-e276529") {
            if (showProgress) {
                (0,console_io/* intentionallyWriteToStderr */.p2)("Already up to date");
            }
            return;
        }
        if (showProgress) {
            (0,console_io/* intentionallyWriteToStderr */.p2)(`Latest version available: ${updateInfo.version}`);
        }
        // Use the install command with the version and URL prefix from the server
        if (false) // removed by dead control flow
{}
        else {
            yield (0,install_core_posix/* installCursorAgent */.BV)({
                version: updateInfo.version,
                urlPrefix: updateInfo.url,
                showProgress,
            });
        }
        if (showProgress) {
            (0,console_io/* intentionallyWriteToStderr */.p2)("Done");
        }
    });
}


/***/ }),

/***/ "./src/components/Attach.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* unused harmony export Attach */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _background_composer_conversation_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/components/background-composer-conversation.tsx");
/* harmony import */ var _background_composer_selection_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/background-composer-selection.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_background_composer_conversation_js__WEBPACK_IMPORTED_MODULE_2__, _background_composer_selection_js__WEBPACK_IMPORTED_MODULE_3__]);
([_background_composer_conversation_js__WEBPACK_IMPORTED_MODULE_2__, _background_composer_selection_js__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




const Attach = ({ client }) => {
    const [status, setStatus] = useState("loading");
    const [composers, setComposers] = useState([]);
    const [error, setError] = useState();
    const [selectedComposerId, setSelectedComposerId] = useState();
    // Load composers on mount
    useEffect(() => {
        const loadComposers = () => __awaiter(void 0, void 0, void 0, function* () {
            try {
                const response = yield client.listBackgroundComposers({
                    n: 10,
                    includeStatus: true,
                });
                setComposers(response.composers);
                setStatus("success");
            }
            catch (err) {
                setError(`Failed to load composers: ${err}`);
                setStatus("error");
            }
        });
        loadComposers();
    }, [client]);
    const handleSelect = (composerId) => {
        setSelectedComposerId(composerId);
    };
    // If a composer is selected, show the conversation
    if (selectedComposerId) {
        return (_jsx(BackgroundComposerConversation, { client: client, composerId: selectedComposerId }));
    }
    return (_jsx(BackgroundComposerSelection, { status: status, composers: composers, error: error, selectedComposerId: selectedComposerId, onSelect: handleSelect }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/alt-screen.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: () => (/* binding */ AltScreen),
/* harmony export */   m: () => (/* binding */ clearScreen)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _context_terminal_state_context_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/context/terminal-state-context.tsx");
/* harmony import */ var _hooks_use_debounced_callback_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/hooks/use-debounced-callback.ts");
/* harmony import */ var _hooks_use_mounted_effect_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/hooks/use-mounted-effect.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _context_terminal_state_context_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _context_terminal_state_context_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







const clearScreen = (stdout) => {
    // Use full clear only once per cycle to avoid flicker on resize bursts.
    stdout.write("\x1b[H\x1b[2J\x1b[3J");
};
const AltScreen = ({ children, clearScreenTrigger, clearOnMount = true, }) => {
    const { stdout } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useStdout */ .t$)();
    // Only react to width changes to prevent unnecessary clears on vertical overflow
    const terminalEpoch = (0,_context_terminal_state_context_js__WEBPACK_IMPORTED_MODULE_4__/* .useWidthEpoch */ .PH)();
    const [isClearing, setIsClearing] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const debouncedClearScreenRerenderingChild = (0,_hooks_use_debounced_callback_js__WEBPACK_IMPORTED_MODULE_5__/* .useDebouncedCallback */ .Y)(() => {
        setIsClearing(true);
        clearScreen(stdout);
        setImmediate(() => {
            setIsClearing(false);
        });
    }, _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .CLEAR_SCREEN_ON_RESIZE_DEBOUNCE_MS */ .Zo, { leading: true, trailing: true });
    // Debounce all clearScreen calls (tail: only the last call in a burst is executed)
    const debouncedClearScreen = (0,_hooks_use_debounced_callback_js__WEBPACK_IMPORTED_MODULE_5__/* .useDebouncedCallback */ .Y)(() => {
        clearScreen(stdout);
    }, _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .CLEAR_SCREEN_ON_RESIZE_DEBOUNCE_MS */ .Zo, {
        leading: true,
        trailing: true,
    });
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        if (!clearOnMount)
            return;
        clearScreen(stdout);
    }, [clearOnMount, stdout]);
    (0,_hooks_use_mounted_effect_js__WEBPACK_IMPORTED_MODULE_6__/* .useMountedEffect */ .H)(() => {
        if (!stdout)
            return;
        // Only trigger when size actually changes, not every epoch cause
        debouncedClearScreenRerenderingChild();
    }, [stdout, terminalEpoch, debouncedClearScreenRerenderingChild]);
    (0,_hooks_use_mounted_effect_js__WEBPACK_IMPORTED_MODULE_6__/* .useMountedEffect */ .H)(() => {
        if (!stdout)
            return;
        debouncedClearScreen();
    }, [clearScreenTrigger, stdout, debouncedClearScreen]);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: isClearing ? null : children });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/animated-dots.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   U: () => (/* binding */ AnimatedDots)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const AnimatedDots = ({ interval = 160, }) => {
    const [dotCount, setDotCount] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(1);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        const timer = setInterval(() => {
            setDotCount(prev => {
                if (prev === 3)
                    return 0;
                return prev + 1;
            });
        }, interval);
        return () => clearInterval(timer);
    }, [interval]);
    const dots = ".".repeat(dotCount).padEnd(3, " ");
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: dots });
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/app-header.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   j: () => (/* binding */ AppHeader)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:os");
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_os__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _hooks_use_current_branch_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/hooks/use-current-branch.ts");
/* harmony import */ var _hooks_use_git_root_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/hooks/use-git-root.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/utils/path-utils.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];









const AppHeader = ({ debugInfo, isRepository, folderMode = "cwd", badge, locationDisplayOverride, branchDisplayOverride, isBackground, }) => {
    const baseFolderInfo = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => {
        const root = process.cwd();
        const home = node_os__WEBPACK_IMPORTED_MODULE_1___default().homedir();
        const displayPath = root.startsWith(home)
            ? `~${root.slice(home.length)}`
            : root;
        const name = node_path__WEBPACK_IMPORTED_MODULE_2___default().basename(root) || root;
        return { root, displayPath, name };
    }, []);
    const currentBranch = (0,_hooks_use_current_branch_js__WEBPACK_IMPORTED_MODULE_6__/* .useCurrentBranch */ .h)(baseFolderInfo);
    const gitRoot = (0,_hooks_use_git_root_js__WEBPACK_IMPORTED_MODULE_7__/* .useGitRoot */ ._)(baseFolderInfo);
    const gitDisplayPath = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => {
        if (!gitRoot)
            return "";
        const home = node_os__WEBPACK_IMPORTED_MODULE_1___default().homedir();
        return gitRoot.startsWith(home)
            ? `~${gitRoot.slice(home.length)}`
            : gitRoot;
    }, [gitRoot]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .Box */ .az, { flexDirection: "column", children: [debugInfo && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .Box */ .az, { marginX: 1, marginBottom: 1, paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .Box */ .az, { flexDirection: "row", alignItems: "center", gap: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .Text */ .EY, { color: "gray", bold: true, children: "DEBUG MODE" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .Text */ .EY, { color: "gray", children: "\u2022" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .Text */ .EY, { color: "yellow", children: debugInfo.serverUrl })] }) })), process.env.AGENT_CLI_HIDE_HEADER !== "true" && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .Box */ .az, { marginX: 1, paddingX: 1, flexDirection: "column", flexGrow: 1, marginTop: !debugInfo ? 1 : 0, borderLeft: true, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .Text */ .EY, { color: "foreground", children: [isBackground ? "Cursor Background Agent" : "Cursor Agent", badge ? (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [" ", badge] }) : null] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .Text */ .EY, { color: "foreground", dimColor: true, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .Text */ .EY, { wrap: "truncate-start", children: (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_8__/* .truncatePathMiddle */ .tk)(locationDisplayOverride !== null && locationDisplayOverride !== void 0 ? locationDisplayOverride : (folderMode === "cwd"
                                    ? baseFolderInfo.displayPath
                                    : gitDisplayPath), _constants_js__WEBPACK_IMPORTED_MODULE_5__/* .MAX_DIRECTORY_DISPLAY_LENGTH */ .DN) }), (branchDisplayOverride !== null && branchDisplayOverride !== void 0 ? branchDisplayOverride : currentBranch) ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .Text */ .EY, { children: [" \u00B7 ", branchDisplayOverride !== null && branchDisplayOverride !== void 0 ? branchDisplayOverride : currentBranch] })) : null] }), isRepository ? null : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .Text */ .EY, { color: "gray", children: "(cwd is not a git repository, cursor rules and ignore files don't apply)" }))] }))] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/approval-dialog.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b: () => (/* binding */ runApprovalDialog)
/* harmony export */ });
/* unused harmony export ApprovalDialog */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function ApprovalDialog({ title, description, content, options, selectedOption, variant = "warning", }) {
    const isInfo = variant === "info";
    const borderColor = isInfo ? "blue" : "yellow";
    const iconColor = isInfo ? "blue" : "yellow";
    const icon = isInfo ? "ℹ " : "⚠ ";
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", marginTop: 1, marginX: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", borderStyle: "round", borderColor: borderColor, paddingX: 2, paddingY: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: iconColor, bold: true, children: icon }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", bold: true, children: title })] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginTop: 1, flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", gap: 1, children: description.map(line => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: line }, line))) }), content && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginTop: 1, marginLeft: 2, flexDirection: "column", children: content }))] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginTop: 2, flexDirection: "column", children: options.map((option, index) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: selectedOption === index ? "green" : "gray", children: selectedOption === index ? "▶ " : "  " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: selectedOption === index ? "foreground" : "gray", bold: selectedOption === index, children: ["[", option.key, "] ", option.label] })] }, option.value))) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginTop: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", dimColor: true, children: "Use arrow keys to navigate, Enter to select, or press the key shown" }) })] }) }));
}
function runApprovalDialog(_a) {
    return __awaiter(this, arguments, void 0, function* ({ title, description, content, options, onAction, variant, }) {
        return new Promise(resolve => {
            let selectedOption = 0;
            const { rerender, waitUntilExit } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .render */ .XX)((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ApprovalDialog, { title: title, description: description, content: content, options: options, selectedOption: selectedOption, variant: variant }), {
                exitOnCtrlC: false,
            });
            const handleInput = (action) => __awaiter(this, void 0, void 0, function* () {
                yield onAction(action);
                resolve(action);
            });
            process.stdin.setRawMode(true);
            process.stdin.resume();
            const dataHandler = (data) => {
                const input = data.toString();
                const key = data[0];
                // Arrow key navigation
                if (data.length === 3 && data[0] === 0x1b && data[1] === 0x5b) {
                    if (data[2] === 0x42) {
                        // Down arrow
                        selectedOption = (selectedOption + 1) % options.length;
                        rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ApprovalDialog, { title: title, description: description, content: content, options: options, selectedOption: selectedOption, variant: variant }));
                        return;
                    }
                    if (data[2] === 0x41) {
                        // Up arrow
                        selectedOption =
                            (selectedOption - 1 + options.length) % options.length;
                        rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ApprovalDialog, { title: title, description: description, content: content, options: options, selectedOption: selectedOption, variant: variant }));
                        return;
                    }
                }
                // Enter key
                if (key === 0x0d) {
                    process.stdin.removeListener("data", dataHandler);
                    process.stdin.setRawMode(false);
                    process.stdin.pause();
                    void handleInput(options[selectedOption].value);
                    return;
                }
                // Direct key press
                const lowerInput = input.toLowerCase();
                const matchingOption = options.find(opt => opt.key.toLowerCase() === lowerInput);
                if (matchingOption) {
                    process.stdin.removeListener("data", dataHandler);
                    process.stdin.setRawMode(false);
                    process.stdin.pause();
                    void handleInput(matchingOption.value);
                    return;
                }
                // Escape or Ctrl+C - default to last option (usually "quit")
                if (key === 0x1b || key === 0x03) {
                    process.stdin.removeListener("data", dataHandler);
                    process.stdin.setRawMode(false);
                    process.stdin.pause();
                    void handleInput(options[options.length - 1].value);
                    return;
                }
            };
            process.stdin.on("data", dataHandler);
            // Handle UI exit
            void waitUntilExit()
                .then(() => {
                process.stdin.removeListener("data", dataHandler);
                process.stdin.setRawMode(false);
                process.stdin.pause();
                // Default to last option (usually "quit") on UI exit
                resolve(options[options.length - 1].value);
            })
                .catch(() => {
                process.stdin.removeListener("data", dataHandler);
                process.stdin.setRawMode(false);
                process.stdin.pause();
                resolve(options[options.length - 1].value);
            });
        });
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/background-composer-conversation.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* unused harmony export BackgroundComposerConversation */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_proto_aiserver_v1_background_composer_pb_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../proto/dist/generated/aiserver/v1/background_composer_pb.js");
/* harmony import */ var _anysphere_proto_aiserver_v1_chat_pb_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../proto/dist/generated/aiserver/v1/chat_pb.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _message_input_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/message-input.tsx");
/* harmony import */ var _user_message_ui_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/components/user-message-ui.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _message_input_js__WEBPACK_IMPORTED_MODULE_5__, _user_message_ui_js__WEBPACK_IMPORTED_MODULE_6__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _message_input_js__WEBPACK_IMPORTED_MODULE_5__, _user_message_ui_js__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __asyncValues = (undefined && undefined.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};







const BackgroundComposerConversation = ({ client, composerId }) => {
    const [conversation, setConversation] = useState([]);
    const [currentMessage, setCurrentMessage] = useState(null);
    const [messages, setMessages] = useState([]);
    const [lastProcessedIndex, setLastProcessedIndex] = useState(-1);
    const [isAttaching, setIsAttached] = useState(true);
    const [error, setError] = useState();
    const [inputValue, setInputValue] = useState("");
    const [isSendingMessage, setIsSendingMessage] = useState(false);
    // Attach to the composer when component mounts
    useEffect(() => {
        const abortController = new AbortController();
        const attachToComposer = () => __awaiter(void 0, void 0, void 0, function* () {
            var _a, e_1, _b, _c;
            try {
                const attachRequest = new AttachBackgroundComposerRequest({
                    bcId: composerId,
                });
                const attachResponse = client.attachBackgroundComposer(attachRequest, {
                    signal: abortController.signal,
                });
                try {
                    // Handle the streaming response
                    for (var _d = true, attachResponse_1 = __asyncValues(attachResponse), attachResponse_1_1; attachResponse_1_1 = yield attachResponse_1.next(), _a = attachResponse_1_1.done, !_a; _d = true) {
                        _c = attachResponse_1_1.value;
                        _d = false;
                        const message = _c;
                        setMessages(prev => [...prev, message]);
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (!_d && !_a && (_b = attachResponse_1.return)) yield _b.call(attachResponse_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                setIsAttached(false);
            }
            catch (attachError) {
                setError(`Failed to attach: ${attachError}`);
                setIsAttached(false);
            }
        });
        attachToComposer();
        return () => {
            abortController.abort();
        };
    }, [client, composerId]);
    const processHeadlessResponse = useCallback((response) => {
        setCurrentMessage(prevMessage => {
            // Start a new message if we don't have one
            let workingMessage = prevMessage;
            if (!workingMessage) {
                workingMessage = {
                    id: `msg-current`,
                    steps: [],
                };
            }
            // Process different types of responses
            if (response.text) {
                const lastStep = workingMessage.steps[workingMessage.steps.length - 1];
                if (lastStep && lastStep.type === "text") {
                    // Append to existing text step
                    lastStep.content += response.text;
                    workingMessage = Object.assign(Object.assign({}, workingMessage), { steps: [...workingMessage.steps.slice(0, -1), lastStep] });
                }
                else {
                    // Create new text step
                    workingMessage = Object.assign(Object.assign({}, workingMessage), { steps: [
                            ...workingMessage.steps,
                            { type: "text", content: response.text },
                        ] });
                }
            }
            if (response.toolCall) {
                workingMessage = Object.assign(Object.assign({}, workingMessage), { steps: [
                        ...workingMessage.steps,
                        {
                            type: "tool-call",
                            id: response.toolCall.toolCallId,
                            call: response.toolCall,
                            completed: false,
                        },
                    ] });
            }
            if (response.finalToolResult) {
                const updatedSteps = workingMessage.steps.map(step => {
                    if (step.type === "tool-call" &&
                        step.id === response.finalToolResult.toolCallId) {
                        return Object.assign(Object.assign({}, step), { result: response.finalToolResult.result, completed: true });
                    }
                    return step;
                });
                workingMessage = Object.assign(Object.assign({}, workingMessage), { steps: updatedSteps });
            }
            if (response.thinking) {
                workingMessage = Object.assign(Object.assign({}, workingMessage), { steps: [
                        ...workingMessage.steps,
                        {
                            type: "thinking",
                            content: response.thinking.text || "",
                        },
                    ] });
            }
            if (response.thinkingDurationMs && response.thinkingDurationMs > 0) {
                const lastStep = workingMessage.steps[workingMessage.steps.length - 1];
                if (lastStep && lastStep.type === "thinking") {
                    lastStep.durationMs = response.thinkingDurationMs;
                    workingMessage = Object.assign(Object.assign({}, workingMessage), { steps: [...workingMessage.steps.slice(0, -1), lastStep] });
                }
            }
            if (response.humanMessage) {
                workingMessage = Object.assign(Object.assign({}, workingMessage), { steps: [
                        ...workingMessage.steps,
                        {
                            type: "user",
                            content: response.humanMessage.text || "",
                            richContent: response.humanMessage.richText,
                        },
                    ] });
            }
            if (response.status) {
                workingMessage = Object.assign(Object.assign({}, workingMessage), { steps: [
                        ...workingMessage.steps,
                        {
                            type: "status",
                            message: response.status.message,
                            statusType: response.status.type.toString(),
                            isComplete: response.status.isComplete,
                        },
                    ] });
            }
            if (response.error) {
                workingMessage = Object.assign(Object.assign({}, workingMessage), { steps: [
                        ...workingMessage.steps,
                        {
                            type: "error",
                            message: response.error.message,
                        },
                    ] });
            }
            return workingMessage;
        });
        // If message is done, add it to conversation and reset current message
        if (response.isMessageDone) {
            setCurrentMessage(msg => {
                if (msg) {
                    setConversation(prev => [...prev, msg]);
                }
                return null;
            });
        }
    }, []);
    // Process incoming messages whenever they change
    useEffect(() => {
        // Only process one new message at a time to avoid state racing
        if (lastProcessedIndex + 1 < messages.length) {
            const message = messages[lastProcessedIndex + 1];
            const response = message.headlessAgenticComposerResponse;
            if (response) {
                processHeadlessResponse(response);
            }
            setLastProcessedIndex(lastProcessedIndex + 1);
        }
    }, [messages, lastProcessedIndex, processHeadlessResponse]);
    const _updateCurrentMessage = (updater) => {
        setCurrentMessage(prev => (prev ? updater(prev) : null));
    };
    const renderToolCall = (step) => {
        const _tool = step.call.tool;
        const _params = step.call.params;
        const _result = step.result;
        return null;
    };
    const renderStep = (step, index) => {
        switch (step.type) {
            case "text":
                return (_jsx(Box, { borderStyle: "single", borderColor: "gray", borderLeft: true, borderRight: false, borderTop: false, borderBottom: false, paddingLeft: 1, marginBottom: 1, children: _jsx(Text, { children: step.content }) }, index));
            case "tool-call":
                return renderToolCall(step);
            case "thinking":
                return null;
            case "user":
                return _jsx(UserMessageUI, { content: step.content }, index);
            case "status":
                return (_jsx(Box, { paddingLeft: 1, children: _jsxs(Text, { color: "blue", children: [step.message, step.isComplete && " ✓"] }) }, index));
            case "error":
                return (_jsx(Box, { paddingLeft: 1, children: _jsxs(Text, { color: "red", children: ["\u274C Error: ", step.message] }) }, index));
            default:
                return null;
        }
    };
    const renderMessage = (message, index) => {
        return (_jsx(Box, { flexDirection: "column", children: message.steps.map((step, stepIndex) => renderStep(step, stepIndex)) }, index));
    };
    const renderToolCallSummary = (toolCallCount) => {
        if (toolCallCount === 0)
            return null;
        return (_jsx(Box, { paddingLeft: 1, marginY: 1, children: _jsxs(Text, { color: "gray", dimColor: true, children: ["Called ", toolCallCount, " tool", toolCallCount === 1 ? "" : "s"] }) }));
    };
    const handleInputSubmit = (value) => __awaiter(void 0, void 0, void 0, function* () {
        if (value.trim() && !isSendingMessage) {
            setIsSendingMessage(true);
            setError(undefined);
            try {
                // Create a conversation message for the follow-up
                const followupMessage = new ConversationMessage({
                    text: value.trim(),
                });
                // Send synchronous follow-up
                const followupRequest = new AddAsyncFollowupBackgroundComposerRequest({
                    bcId: composerId,
                    followupMessage,
                    synchronous: true,
                    followupSource: BackgroundComposerSource.EDITOR,
                });
                yield client.addAsyncFollowupBackgroundComposer(followupRequest);
                setInputValue("");
            }
            catch (followupError) {
                setError(`Failed to send message: ${followupError}`);
            }
            finally {
                setIsSendingMessage(false);
            }
        }
    });
    if (error) {
        return (_jsx(Box, { paddingLeft: 1, children: _jsxs(Text, { color: "red", children: ["\u274C ", error] }) }));
    }
    if (isAttaching && messages.length === 0) {
        return (_jsx(Box, { paddingLeft: 1, children: _jsx(Text, { color: "yellow", children: "\uD83D\uDD04 Attaching to composer..." }) }));
    }
    return (_jsxs(Box, { flexDirection: "column", paddingY: 1, children: [conversation.map((message, index) => {
                const hasTextResponse = message.steps.some(step => step.type === "text");
                // Count tool calls since last user message
                let toolCallCount = 0;
                for (let i = index; i >= 0; i--) {
                    const msg = conversation[i];
                    const hasUserMessage = msg.steps.some(step => step.type === "user");
                    if (hasUserMessage && i < index)
                        break; // Stop at previous user message
                    toolCallCount += msg.steps.filter(step => step.type === "tool-call" || step.type === "thinking").length;
                }
                return (_jsxs(React.Fragment, { children: [hasTextResponse &&
                            toolCallCount > 0 &&
                            renderToolCallSummary(toolCallCount), renderMessage(message, index)] }, message.id));
            }), currentMessage && (_jsxs(_Fragment, { children: [(() => {
                        const hasTextResponse = currentMessage.steps.some(step => step.type === "text");
                        // Count tool calls since last user message (including current message)
                        let toolCallCount = 0;
                        // Count from current message
                        toolCallCount += currentMessage.steps.filter(step => step.type === "tool-call" || step.type === "thinking").length;
                        // Count from conversation messages back to last user message
                        for (let i = conversation.length - 1; i >= 0; i--) {
                            const msg = conversation[i];
                            const hasUserMessage = msg.steps.some(step => step.type === "user");
                            if (hasUserMessage)
                                break; // Stop at last user message
                            toolCallCount += msg.steps.filter(step => step.type === "tool-call" || step.type === "thinking").length;
                        }
                        return hasTextResponse && toolCallCount > 0
                            ? renderToolCallSummary(toolCallCount)
                            : null;
                    })(), renderMessage(currentMessage, conversation.length)] })), messages.length === 0 && (_jsx(Box, { paddingLeft: 1, children: _jsx(Text, { color: "gray", children: "No messages yet..." }) })), _jsx(MessageInput, { value: inputValue, onChange: setInputValue, onSubmit: handleInputSubmit, isDisabled: !!error || isSendingMessage })] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/background-composer-list.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* unused harmony export BackgroundComposerList */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _utils_background_composer_utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/utils/background-composer-utils.ts");
/* harmony import */ var _background_composer_status_displays_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/background-composer-status-displays.tsx");
/* harmony import */ var _base_composer_item_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/base-composer-item.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _background_composer_status_displays_js__WEBPACK_IMPORTED_MODULE_3__, _base_composer_item_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _background_composer_status_displays_js__WEBPACK_IMPORTED_MODULE_3__, _base_composer_item_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const ComposerGroup = ({ title, composers, count, selectedComposerId, onSelectComposer }) => {
    if (composers.length === 0)
        return null;
    return (_jsxs(Box, { flexDirection: "column", marginBottom: 1, children: [_jsxs(Box, { marginBottom: 1, children: [_jsxs(Text, { bold: true, color: "foreground", children: [title, " "] }), _jsx(Text, { color: "gray", children: count })] }), composers.map(composer => (_jsx(BaseComposerItem, { composer: composer, isSelected: selectedComposerId === composer.bcId, onSelect: onSelectComposer, variant: "list" }, composer.bcId)))] }));
};
const BackgroundComposerList = ({ status, composers, error, selectedComposerId, onSelectComposer, }) => {
    if (status === "error") {
        return _jsx(ErrorDisplay, { error: error });
    }
    if (composers.length === 0) {
        return _jsx(EmptyDisplay, {});
    }
    // Group composers by time
    const today = composers.filter(c => getTimeCategory(c.createdAtMs) === "Today");
    const thisWeek = composers.filter(c => getTimeCategory(c.createdAtMs) === "This Week");
    const older = composers.filter(c => getTimeCategory(c.createdAtMs) === "Older");
    return (_jsxs(Box, { flexDirection: "column", padding: 1, children: [today.length > 0 && (_jsx(ComposerGroup, { title: "Today", composers: today, count: today.length, selectedComposerId: selectedComposerId, onSelectComposer: onSelectComposer })), thisWeek.length > 0 && (_jsx(ComposerGroup, { title: "This Week", composers: thisWeek, count: thisWeek.length, selectedComposerId: selectedComposerId, onSelectComposer: onSelectComposer })), older.length > 0 && (_jsx(ComposerGroup, { title: "Older", composers: older, count: older.length, selectedComposerId: selectedComposerId, onSelectComposer: onSelectComposer })), onSelectComposer && (_jsx(Box, { children: _jsx(Text, { color: "gray", children: "Tip: Use 'cursor chat' to start an interactive session" }) }))] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/background-composer-selection.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* unused harmony export BackgroundComposerSelection */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _background_composer_status_displays_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/background-composer-status-displays.tsx");
/* harmony import */ var _base_composer_item_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/base-composer-item.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _background_composer_status_displays_js__WEBPACK_IMPORTED_MODULE_3__, _base_composer_item_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _background_composer_status_displays_js__WEBPACK_IMPORTED_MODULE_3__, _base_composer_item_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const BackgroundComposerSelection = ({ status, composers, error, onSelect }) => {
    const [selectedIndex, setSelectedIndex] = useState(0);
    // Handle keyboard input for navigation and selection
    useInput((input, key) => {
        if (status !== "success")
            return;
        if (key.upArrow && selectedIndex > 0) {
            setSelectedIndex(selectedIndex - 1);
        }
        else if (key.downArrow && selectedIndex < composers.length - 1) {
            setSelectedIndex(selectedIndex + 1);
        }
        else if (key.return && onSelect && composers[selectedIndex]) {
            onSelect(composers[selectedIndex].bcId);
        }
        else if (input >= "1" && input <= "9") {
            const index = parseInt(input, 10) - 1;
            if (index >= 0 && index < composers.length) {
                setSelectedIndex(index);
            }
        }
        else if (key.return &&
            selectedIndex >= 0 &&
            selectedIndex < composers.length &&
            onSelect) {
            onSelect(composers[selectedIndex].bcId);
        }
    });
    // Reset selection when composers change
    useEffect(() => {
        setSelectedIndex(0);
    }, []);
    if (status === "loading") {
        return _jsx(LoadingDisplay, {});
    }
    if (status === "error") {
        return _jsx(SimpleErrorDisplay, { error: error });
    }
    if (composers.length === 0) {
        return _jsx(EmptyDisplay, {});
    }
    return (_jsxs(Box, { flexDirection: "column", padding: 1, children: [_jsx(Box, { marginBottom: 1, children: _jsx(Text, { bold: true, color: "foreground", children: "Select a background composer to attach to:" }) }), composers.map((composer, index) => (_jsx(BaseComposerItem, { composer: composer, index: index, isSelected: index === selectedIndex, showIndex: true, variant: "selection" }, composer.bcId))), _jsx(Box, { marginTop: 1, children: _jsx(Text, { color: "gray", children: "Use \u2191/\u2193 arrow keys or numbers 1-9 to select, Enter to attach" }) })] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/background-composer-status-displays.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* unused harmony exports LoadingDisplay, ErrorDisplay, SimpleErrorDisplay, EmptyDisplay, AttachingDisplay, CompletedDisplay */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const LoadingDisplay = () => (_jsx(Box, { flexDirection: "column", padding: 1, children: _jsx(Text, { color: "blue", children: "Loading background composers..." }) }));
const ErrorDisplay = ({ error }) => (_jsxs(Box, { flexDirection: "column", padding: 1, children: [_jsx(Text, { color: "red", children: "Error loading background composers" }), error && (_jsx(Box, { marginTop: 1, children: _jsx(Text, { color: "red", children: error }) }))] }));
const SimpleErrorDisplay = ({ error }) => (_jsx(Box, { flexDirection: "column", padding: 1, children: _jsxs(Text, { color: "red", children: ["Error: ", error] }) }));
const EmptyDisplay = () => (_jsxs(Box, { flexDirection: "column", padding: 1, children: [_jsx(Text, { color: "gray", children: "No background composers found" }), _jsx(Box, { marginTop: 1, children: _jsx(Text, { color: "gray", children: "Use the Cursor editor to start a new background composer." }) })] }));
const AttachingDisplay = ({ composerName, composerId, streamingInfo }) => (_jsxs(Box, { flexDirection: "column", padding: 1, children: [_jsxs(Text, { color: "blue", children: ["Attaching to: ", composerName || composerId] }), _jsx(Text, { color: "gray", children: streamingInfo || "Connecting to background composer..." })] }));
const CompletedDisplay = ({ composerName, composerId, streamingInfo }) => (_jsxs(Box, { flexDirection: "column", padding: 1, children: [_jsxs(Text, { color: "green", children: ["\u2713 Successfully attached to: ", composerName || composerId] }), _jsx(Text, { color: "gray", children: streamingInfo || "Connection completed." })] }));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/background-edit-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: () => (/* binding */ BackgroundEditToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/highlighted-code.tsx");
/* harmony import */ var _inline_delta_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/inline-delta.tsx");
/* harmony import */ var _tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/components/tool-row-box.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__, _inline_delta_js__WEBPACK_IMPORTED_MODULE_5__, _tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__, _inline_delta_js__WEBPACK_IMPORTED_MODULE_5__, _tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







const BackgroundEditToolUI = ({ path, result, }) => {
    var _a;
    const diff = result === null || result === void 0 ? void 0 : result.diff;
    const linesAdded = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        if (!(diff === null || diff === void 0 ? void 0 : diff.chunks) || diff.chunks.length === 0)
            return 0;
        return diff.chunks.map(c => { var _a; return (_a = c.linesAdded) !== null && _a !== void 0 ? _a : 0; }).reduce((a, b) => a + b, 0);
    }, [diff === null || diff === void 0 ? void 0 : diff.chunks]);
    const linesRemoved = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        if (!(diff === null || diff === void 0 ? void 0 : diff.chunks) || diff.chunks.length === 0)
            return 0;
        return diff.chunks.map(c => { var _a; return (_a = c.linesRemoved) !== null && _a !== void 0 ? _a : 0; }).reduce((a, b) => a + b, 0);
    }, [diff === null || diff === void 0 ? void 0 : diff.chunks]);
    const diffString = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        var _a, _b, _c, _d, _e;
        const d = diff;
        if (!d || !d.chunks || d.chunks.length === 0)
            return undefined;
        let out = "";
        for (const chunk of d.chunks) {
            const oldStart = (_a = chunk.oldStart) !== null && _a !== void 0 ? _a : 0;
            const oldLines = (_b = chunk.oldLines) !== null && _b !== void 0 ? _b : 0;
            const newStart = (_c = chunk.newStart) !== null && _c !== void 0 ? _c : 0;
            const newLines = (_d = chunk.newLines) !== null && _d !== void 0 ? _d : 0;
            out += `@@ -${oldStart},${oldLines} +${newStart},${newLines} @@\n`;
            const content = (_e = chunk.diffString) !== null && _e !== void 0 ? _e : "";
            if (content) {
                for (const line of content.split("\n")) {
                    if (!line) {
                        out += "\n";
                        continue;
                    }
                    if (line.startsWith("@@"))
                        continue; // avoid duplicate headers inside chunk
                    out += `${line}\n`;
                }
            }
        }
        return out.trimEnd();
    }, [diff]);
    const note = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        var _a;
        if (!result)
            return undefined;
        if (result.rejected)
            return "Edit rejected";
        if ((_a = result.recoverableError) === null || _a === void 0 ? void 0 : _a.modelMessage)
            return result.recoverableError.modelMessage;
        if (linesAdded > 0 || linesRemoved > 0)
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_inline_delta_js__WEBPACK_IMPORTED_MODULE_5__/* .InlineDelta */ ._, { added: linesAdded, removed: linesRemoved });
        return undefined;
    }, [result, linesAdded, linesRemoved]);
    const noteColor = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        return (result === null || result === void 0 ? void 0 : result.rejected) ? "yellow" : "gray";
    }, [result === null || result === void 0 ? void 0 : result.rejected]);
    if (!path)
        return null;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__/* .ToolRowBox */ .Y, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", gap: 1, paddingX: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexShrink: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: path }) }), typeof note === "string" ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: noteColor, wrap: "truncate", children: note })) : note ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: note })) : null] }), diffString ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__/* .HighlightedCode */ .d, { content: diffString, language: (_a = (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .inferLanguageFromPath */ .Ak)(path)) !== null && _a !== void 0 ? _a : "diff", isDiff: true, showLineNumbers: false, maxLines: 12, truncationHint: _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .REVIEW_MODE_ENABLED */ .hD ? "ctrl+r to review" : undefined, paddingX: 1 })) : null] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/background-prompt-bar.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: () => (/* binding */ BackgroundPromptBar)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _console_io_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("./src/console-io.ts");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _context_vim_mode_context_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/context/vim-mode-context.tsx");
/* harmony import */ var _hooks_prompt_use_at_palette_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/hooks/prompt/use-at-palette.ts");
/* harmony import */ var _hooks_prompt_use_slash_palette_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/hooks/prompt/use-slash-palette.ts");
/* harmony import */ var _hooks_use_background_actions_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/hooks/use-background-actions.ts");
/* harmony import */ var _prompt_decision_dropdown_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/components/prompt/decision-dropdown.tsx");
/* harmony import */ var _prompt_palette_at_list_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("./src/components/prompt/palette-at-list.tsx");
/* harmony import */ var _prompt_palette_slash_list_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("./src/components/prompt/palette-slash-list.tsx");
/* harmony import */ var _prompt_prompt_footer_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("./src/components/prompt/prompt-footer.tsx");
/* harmony import */ var _text_input_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("./src/components/text-input.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _prompt_decision_dropdown_js__WEBPACK_IMPORTED_MODULE_8__, _prompt_palette_at_list_js__WEBPACK_IMPORTED_MODULE_9__, _prompt_palette_slash_list_js__WEBPACK_IMPORTED_MODULE_10__, _prompt_prompt_footer_js__WEBPACK_IMPORTED_MODULE_11__, _text_input_js__WEBPACK_IMPORTED_MODULE_12__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _prompt_decision_dropdown_js__WEBPACK_IMPORTED_MODULE_8__, _prompt_palette_at_list_js__WEBPACK_IMPORTED_MODULE_9__, _prompt_palette_slash_list_js__WEBPACK_IMPORTED_MODULE_10__, _prompt_prompt_footer_js__WEBPACK_IMPORTED_MODULE_11__, _text_input_js__WEBPACK_IMPORTED_MODULE_12__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














const BackgroundPromptBar = ({ prompt, setPrompt, onSubmit: onSubmitProp, topStatus, topStatusMarginTop, isDisabled = false, isProcessing = false, modelLabel = "Loading...", placeholder = "Add a follow-up", promptSymbol = "→", branchName, onRequestReview, bcId, changes, slashCommands = [], backgroundComposerClient, printEphemeral, }) => {
    var _a;
    const { exit } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useApp */ .nm)();
    const [exitMode, setExitMode] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const [shouldRender, setShouldRender] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(true);
    const { vimEnabled, mode: vimMode } = (0,_context_vim_mode_context_js__WEBPACK_IMPORTED_MODULE_4__/* .useVimMode */ .v)();
    const changedFilesCount = (_a = changes === null || changes === void 0 ? void 0 : changes.length) !== null && _a !== void 0 ? _a : 0;
    const [cursorToEndSignal, setCursorToEndSignal] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
    // Dynamic placeholder that surfaces useful slash commands when there are diffs
    const computedPlaceholder = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(() => {
        if (changedFilesCount > 0) {
            const hint = "Try /apply-changes-locally or /checkout-locally";
            return placeholder ? `${placeholder} — ${hint}` : hint;
        }
        return placeholder;
    }, [placeholder, changedFilesCount]);
    // Minimal confirm state & presenter (PromptBar-styled, blocking)
    const [confirmActive, setConfirmActive] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const [confirmTitle, setConfirmTitle] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)("");
    const [confirmDetail, setConfirmDetail] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(undefined);
    const [continueLabel, setContinueLabel] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)("Continue");
    const [cancelLabel, setCancelLabel] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)("Cancel");
    const confirmResolverRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const [confirmIndex, setConfirmIndex] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
    const askConfirm = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((opts) => {
        return new Promise(resolve => {
            var _a, _b;
            setConfirmTitle(opts.title);
            setConfirmDetail(opts.detail);
            setContinueLabel((_a = opts.continueLabel) !== null && _a !== void 0 ? _a : "Continue");
            setCancelLabel((_b = opts.cancelLabel) !== null && _b !== void 0 ? _b : "Cancel");
            confirmResolverRef.current = resolve;
            setConfirmIndex(0);
            setConfirmActive(true);
        });
    }, []);
    // Expose confirmation only internally; parent does not need to manage it.
    // @ palette support (files)
    const at = (0,_hooks_prompt_use_at_palette_js__WEBPACK_IMPORTED_MODULE_5__/* .useAtPalette */ .g)(prompt);
    // / palette support (slash commands) with built-in background actions
    const backgroundActions = (0,_hooks_use_background_actions_js__WEBPACK_IMPORTED_MODULE_7__/* .useBackgroundActions */ .V)(backgroundComposerClient);
    const builtinCommands = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(() => {
        const diffActions = changes && changes.length > 0
            ? [
                {
                    id: "checkout-locally",
                    title: "Checkout Locally",
                    description: "Check out the current background agent's branch",
                    run: () => __awaiter(void 0, void 0, void 0, function* () {
                        if (!bcId) {
                            printEphemeral === null || printEphemeral === void 0 ? void 0 : printEphemeral([
                                [
                                    { text: "error:", color: "red", bold: true },
                                    { text: " No active background agent" },
                                ],
                            ]);
                            return;
                        }
                        printEphemeral === null || printEphemeral === void 0 ? void 0 : printEphemeral([
                            [
                                { text: "⟲ ", color: "cyan" },
                                { text: "Preparing checkout…", dim: true },
                            ],
                        ]);
                        setPrompt("");
                        try {
                            yield backgroundActions.checkoutLocally(bcId, {
                                print: printEphemeral,
                                confirm: askConfirm,
                            });
                        }
                        catch (e) {
                            printEphemeral === null || printEphemeral === void 0 ? void 0 : printEphemeral([
                                [
                                    { text: "error:", color: "red", bold: true },
                                    {
                                        text: ` ${e instanceof Error ? e.message : String(e)}`,
                                    },
                                ],
                            ]);
                        }
                    }),
                },
                {
                    id: "apply-changes-locally",
                    title: "Apply Changes Locally",
                    description: "Apply this background agent's diffs into the working tree",
                    run: () => __awaiter(void 0, void 0, void 0, function* () {
                        if (!bcId) {
                            printEphemeral === null || printEphemeral === void 0 ? void 0 : printEphemeral([
                                [
                                    { text: "error:", color: "red", bold: true },
                                    { text: " No active background agent" },
                                ],
                            ]);
                            return;
                        }
                        printEphemeral === null || printEphemeral === void 0 ? void 0 : printEphemeral([
                            [
                                { text: "⟲ ", color: "cyan" },
                                {
                                    text: "Merging changes… (conflicts will be shown)",
                                    dim: true,
                                },
                            ],
                        ]);
                        setPrompt("");
                        try {
                            yield backgroundActions.applyChangesLocally(bcId, {
                                print: printEphemeral,
                                confirm: askConfirm,
                            });
                        }
                        catch (e) {
                            printEphemeral === null || printEphemeral === void 0 ? void 0 : printEphemeral([
                                [
                                    { text: "error:", color: "red", bold: true },
                                    {
                                        text: ` ${e instanceof Error ? e.message : String(e)}`,
                                    },
                                ],
                            ]);
                        }
                    }),
                },
            ]
            : [];
        return [...diffActions];
    }, [bcId, backgroundActions, askConfirm, printEphemeral, setPrompt, changes]);
    const allSlashCommands = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(() => [...slashCommands, ...builtinCommands], [slashCommands, builtinCommands]);
    const slash = (0,_hooks_prompt_use_slash_palette_js__WEBPACK_IMPORTED_MODULE_6__/* .useSlashPalette */ .e)(prompt, allSlashCommands, {
        insertText: setPrompt,
    });
    const paletteVisible = at.active || slash.active;
    const acceptAtExpansion = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((value) => {
        const rebuilt = at.acceptExpansion(value);
        if (rebuilt != null && rebuilt !== value) {
            setPrompt(rebuilt);
            setCursorToEndSignal(s => s + 1);
            return rebuilt;
        }
        return null;
    }, [at, setPrompt]);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        if (!exitMode)
            return;
        const t = setTimeout(() => setExitMode(false), 1500);
        return () => clearTimeout(t);
    }, [exitMode]);
    const handleExit = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((_isLogout = false) => {
        // Hide the prompt/footer before quitting so any exit hints are cleared
        setShouldRender(false);
        setTimeout(() => {
            // Print deep link when detaching; background continues running
            if (bcId) {
                const link = `https://cursor.com/agents?selectedBcId=${bcId}`;
                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_13__/* .intentionallyWriteToStderr */ .p2)(`\n  \x1b[90mOpen Background Agent in:\x1b[0m \x1b[1m\x1b[36m${link}\x1b[0m`);
            }
            // clean exit
            exit();
            process.exit(0);
        }, 100);
    }, [bcId, exit]);
    const handleCtrlC = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => {
        // Clear input first if there's any text; do not abort yet
        if (prompt.length > 0) {
            setPrompt("");
            return;
        }
        if (exitMode) {
            // Clear the input so we do not leave a partially typed command on screen, but retain exitMode so border stays gray.
            setPrompt("");
            handleExit();
        }
        else {
            setExitMode(true);
        }
    }, [prompt.length, exitMode, setPrompt, handleExit]);
    const handleCtrlR = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => {
        if (changedFilesCount > 0) {
            onRequestReview === null || onRequestReview === void 0 ? void 0 : onRequestReview();
        }
    }, [changedFilesCount, onRequestReview]);
    const handleCtrlD = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => {
        // Immediate detach/quit: clear input and exit
        setPrompt("");
        handleExit();
    }, [handleExit, setPrompt]);
    // Arrow navigation and dismiss for the @ palette, plus confirm handling
    (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useInput */ .Ge)((input, key) => {
        if (confirmActive) {
            // Decision UI: Up/Down to choose, Enter/"y" to continue, Esc/"n"/Ctrl+C to cancel
            if (key.downArrow || input === "j" || input === "J") {
                setConfirmIndex(i => Math.min(i + 1, 1));
                return;
            }
            if (key.upArrow || input === "k" || input === "K") {
                setConfirmIndex(i => Math.max(i - 1, 0));
                return;
            }
            if (key.escape ||
                (key.ctrl && input === "c") ||
                input === "n" ||
                input === "N") {
                const r = confirmResolverRef.current;
                confirmResolverRef.current = null;
                setConfirmActive(false);
                r === null || r === void 0 ? void 0 : r(false);
                return;
            }
            if (key.return) {
                const r = confirmResolverRef.current;
                const accept = confirmIndex === 0;
                confirmResolverRef.current = null;
                setConfirmActive(false);
                r === null || r === void 0 ? void 0 : r(accept);
                return;
            }
            if (input === "y" || input === "Y") {
                const r = confirmResolverRef.current;
                confirmResolverRef.current = null;
                setConfirmActive(false);
                r === null || r === void 0 ? void 0 : r(true);
                return;
            }
            // Consume other keys while active
            return;
        }
        // Slash palette navigation
        if (slash.active && slash.items.length > 0) {
            if (key.downArrow) {
                slash.next();
                return;
            }
            if (key.upArrow) {
                slash.prev();
                return;
            }
            if (key.escape) {
                slash.hide();
                return;
            }
        }
        // At palette navigation
        if (at.active && at.suggestions.length > 0) {
            if (key.downArrow) {
                at.next();
                return;
            }
            if (key.upArrow) {
                at.prev();
                return;
            }
            if (key.escape) {
                at.suppress();
                return;
            }
        }
    }, { isActive: confirmActive || at.active || slash.active });
    const parseSlashInput = (input) => {
        if (!input.startsWith("/"))
            return null;
        const term = input.slice(1);
        const parts = term.split(/\s+/).filter(Boolean);
        const cmdId = parts[0] || "";
        const args = parts.slice(1);
        const cmd = allSlashCommands.find(c => c.id.toLowerCase() === cmdId.toLowerCase());
        const required = ((cmd === null || cmd === void 0 ? void 0 : cmd.args) || []).filter(a => a.required !== false).length;
        return { cmdId, args, required, hasCmd: !!cmd };
    };
    const isSlashReady = (input) => {
        const parsed = parseSlashInput(input);
        return Boolean((parsed === null || parsed === void 0 ? void 0 : parsed.hasCmd) && parsed.args.length >= parsed.required);
    };
    if (!shouldRender) {
        return null;
    }
    if (isDisabled) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", borderColor: "foreground", borderTop: true, borderStyle: "single", paddingLeft: 1, marginX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: "Input disabled" }) }) }));
    }
    const shouldShowTopStatus = !confirmActive && topStatus;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginTop: topStatusMarginTop !== null && topStatusMarginTop !== void 0 ? topStatusMarginTop : 0, marginBottom: 0, marginX: 1, paddingLeft: 1, children: shouldShowTopStatus ? topStatus : null }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", borderColor: confirmActive ? "yellow" : "foreground", borderTop: true, borderStyle: "single", paddingLeft: 1, marginX: 1, children: [confirmActive && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginBottom: 0, flexDirection: "column", children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_prompt_decision_dropdown_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A, { title: confirmTitle, highlightColor: "yellow", options: [
                                { label: continueLabel, hint: "y" },
                                { label: cancelLabel, hint: "esc/n" },
                            ], selectedIndex: confirmIndex, subtitle: confirmDetail }) })), !confirmActive && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", dimColor: prompt.length === 0, children: [promptSymbol, " "] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexGrow: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_text_input_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A, { value: prompt, onChange: setPrompt, onSubmit: (value) => {
                                        if (confirmActive)
                                            return; // ignore submissions during confirm
                                        // Accept @ suggestion on enter if visible
                                        if (at.active) {
                                            const rebuilt = acceptAtExpansion(value);
                                            if (rebuilt != null)
                                                return;
                                        }
                                        // Handle slash commands
                                        if (value.startsWith("/")) {
                                            if (slash.active) {
                                                const expanded = slash.acceptExpansion(value);
                                                if (expanded != null && expanded !== value) {
                                                    setPrompt(expanded);
                                                    setCursorToEndSignal(s => s + 1);
                                                    return;
                                                }
                                            }
                                            void (() => __awaiter(void 0, void 0, void 0, function* () {
                                                const res = yield slash.runIfExecutable(value, allSlashCommands, {
                                                    insertText: (txt) => setPrompt(txt),
                                                    clearInput: () => setPrompt(""),
                                                });
                                                if (res !== "handled") {
                                                    onSubmitProp(value);
                                                }
                                            }))();
                                            // Hide palettes post submit attempt
                                            at.hide();
                                            slash.hide();
                                            return;
                                        }
                                        onSubmitProp(value);
                                        // Hide palettes after submission
                                        at.hide();
                                        slash.hide();
                                    }, placeholder: computedPlaceholder, rightPlaceholder: isProcessing
                                        ? "ctrl+c to stop"
                                        : prompt.length === 0 && vimEnabled
                                            ? vimMode === "insert"
                                                ? "INSERT"
                                                : "NORMAL"
                                            : undefined, onCtrlC: handleCtrlC, onCtrlD: handleCtrlD, onCtrlR: handleCtrlR, allowExplicitNewline: true, onTab: () => {
                                        // First try slash acceptance
                                        if (slash.active) {
                                            const rebuiltSlash = slash.acceptExpansion(prompt);
                                            if (rebuiltSlash != null) {
                                                setPrompt(rebuiltSlash);
                                                setCursorToEndSignal(s => s + 1);
                                                return;
                                            }
                                        }
                                        // Fallback to @ acceptance
                                        const rebuiltAt = acceptAtExpansion(prompt);
                                        if (rebuiltAt != null)
                                            return;
                                        // If '/cmd' without required args and no trailing space, add one to guide typing
                                        if (prompt.startsWith("/") &&
                                            !prompt.endsWith(" ") &&
                                            !isSlashReady(prompt)) {
                                            setPrompt(`${prompt} `);
                                            setCursorToEndSignal(s => s + 1);
                                            return;
                                        }
                                    }, showCursor: true, focus: true, cursorToEndSignal: cursorToEndSignal }) })] }))] }), !confirmActive && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { height: paletteVisible
                    ? Math.min(slash.active
                        ? Math.min(slash.items.length, _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .PALETTE_PAGE_SIZE */ .kQ)
                        : Math.min(at.suggestions.length, _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .PALETTE_PAGE_SIZE */ .kQ), _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .PALETTE_PAGE_SIZE */ .kQ)
                    : 0, flexDirection: "column", marginTop: 0, children: paletteVisible &&
                    (slash.active ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_prompt_palette_slash_list_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A, { items: slash.items, activeIndex: slash.index, windowStart: slash.windowStart, highlightColor: "foreground" })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_prompt_palette_at_list_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A, { suggestions: at.suggestions, activeIndex: at.index, windowStart: at.windowStart, highlightColor: "foreground" }))) })), !confirmActive && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_prompt_prompt_footer_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A, { show: !paletteVisible, hasText: prompt.length > 0, exitMode: exitMode, modelLabel: modelLabel, changedFilesCount: changedFilesCount, showReviewHint: changedFilesCount > 0, exitHintText: "Press Ctrl+C again to detach", 
                // rightStatusLabel={
                //   isLoadingDiffs && !changedFilesCount ? "Loading diffs…" : undefined
                // }
                headlineLabel: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "magenta", children: ["◎ Background Agent", branchName ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", dimColor: true, children: [" ", "\u00B7 ", branchName] })) : null] }), headlineColor: "magenta" }))] }));
};
/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = ((/* unused pure expression or super */ null && (BackgroundPromptBar)));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/background-shell-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: () => (/* binding */ BackgroundShellToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _utils_characters_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/utils/characters.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _highlighted_code_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/highlighted-code.tsx");
/* harmony import */ var _tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/components/tool-row-box.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_5__, _tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_5__, _tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const BackgroundShellToolUI = ({ command, cwd, result, expand, }) => {
    var _a;
    const cmd = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => (command || "").trim(), [command]);
    const workingDirDisplay = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        const wd = cwd || (result === null || result === void 0 ? void 0 : result.resultingWorkingDirectory) || undefined;
        if (!wd)
            return undefined;
        const rel = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_4__/* .toRelativePath */ .fw)(wd);
        const human = rel === "." ? "current dir" : rel;
        return (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_4__/* .truncatePathMiddle */ .tk)(human, _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .MAX_DIRECTORY_DISPLAY_LENGTH */ .DN);
    }, [cwd, result === null || result === void 0 ? void 0 : result.resultingWorkingDirectory]);
    const formatDuration = (ms) => {
        if (!ms && ms !== 0)
            return null;
        const n = ms;
        if (n < 1000)
            return `${n}ms`;
        const secs = n / 1000;
        const s = secs.toFixed(secs >= 10 ? 0 : 1);
        return `${s}s`;
    };
    const headerNote = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        var _a;
        if (!result)
            return undefined;
        if (result.rejected)
            return "Rejected";
        const exit = (_a = result.exitCodeV2) !== null && _a !== void 0 ? _a : result.exitCode;
        if (exit != null) {
            return `exit ${exit}`;
        }
        return undefined;
    }, [result]);
    const [startAtMs, setStartAtMs] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
    const [elapsedMs, setElapsedMs] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
    const isRunning = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => !result, [result]);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        if (isRunning) {
            if (startAtMs === null)
                setStartAtMs(Date.now());
        }
        else {
            if (startAtMs !== null)
                setStartAtMs(null);
            setElapsedMs(0);
        }
    }, [isRunning, startAtMs]);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        if (startAtMs === null)
            return;
        const id = setInterval(() => {
            setElapsedMs(Date.now() - startAtMs);
        }, 100);
        return () => clearInterval(id);
    }, [startAtMs]);
    const outputContent = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        if (!result)
            return null;
        const stripAnsi = (s) => (0,_utils_characters_js__WEBPACK_IMPORTED_MODULE_7__/* .stripAnsi */ .aJ)(s);
        const insertSoftWraps = (s) => s.replace(/(\S{80})(?=\S)/g, "$1\u200B");
        if (result.rejected) {
            return { text: "Request rejected", color: "yellow" };
        }
        const textRaw = result.outputRaw || result.output || "";
        return {
            text: insertSoftWraps(stripAnsi(textRaw)),
            color: undefined,
        };
    }, [result]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__/* .ToolRowBox */ .Y, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", alignItems: "flex-start", paddingX: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: 2, flexShrink: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: "$ " }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexGrow: 1, flexShrink: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "wrap", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: cmd }), headerNote ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: headerNote })] })) : null, isRunning ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: (_a = formatDuration(elapsedMs)) !== null && _a !== void 0 ? _a : undefined })] })) : null, workingDirDisplay ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["in ", workingDirDisplay] })] })) : null] }) })] }), result ? (outputContent ? (outputContent.color === "yellow" ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "yellow", wrap: "wrap", children: outputContent.text }) })) : outputContent.text ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_highlighted_code_js__WEBPACK_IMPORTED_MODULE_5__/* .HighlightedCode */ .d, { content: outputContent.text, language: "plaintext", showLineNumbers: false, maxLines: expand
                            ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .SHELL_OUTPUT_EXPANDED_MAX_LINES */ .U5
                            : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .SHELL_OUTPUT_PREVIEW_LINES */ .Ok, truncationHint: expand ? undefined : "ctrl+o to expand" }), expand ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", dimColor: true, children: "ctrl+o to collapse" }) })) : null] })) : null) : null) : null] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/background-tool-group-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   i: () => (/* binding */ BackgroundToolGroupUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_proto_aiserver_v1_tools_pb_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../proto/dist/generated/aiserver/v1/tools_pb.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _tool_call_header_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/tool-call-header.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_5__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






function enumName(tool) {
    if (tool === undefined || tool === null)
        return "UNKNOWN";
    // Enum has reverse mapping: number -> name
    const name = _anysphere_proto_aiserver_v1_tools_pb_js__WEBPACK_IMPORTED_MODULE_2__/* .ClientSideToolV2 */ .XaY[tool];
    return typeof name === "string" ? name : `TOOL_${String(tool)}`;
}
function classifyVerb(name, completed) {
    const upper = name.toUpperCase();
    // Try to map common tool names to our unified verb map
    if (upper.includes("SEMSEARCH") || upper.includes("SEMANTIC_SEARCH"))
        return ((0,_constants_js__WEBPACK_IMPORTED_MODULE_4__/* .resolveToolVerbByCase */ .F_)("semSearchToolCall", completed) ||
            (completed ? "Searched" : "Searching"));
    if (upper.includes("GREP"))
        return ((0,_constants_js__WEBPACK_IMPORTED_MODULE_4__/* .resolveToolVerbByCase */ .F_)("grepToolCall", completed) ||
            (completed ? "Grepped" : "Grepping"));
    if (upper.includes("READ"))
        return ((0,_constants_js__WEBPACK_IMPORTED_MODULE_4__/* .resolveToolVerbByCase */ .F_)("readToolCall", completed) ||
            (completed ? "Read" : "Reading"));
    if (upper.includes("GLOB"))
        return ((0,_constants_js__WEBPACK_IMPORTED_MODULE_4__/* .resolveToolVerbByCase */ .F_)("globToolCall", completed) ||
            (completed ? "Globbed" : "Globbing"));
    if (upper.includes("LIST"))
        return ((0,_constants_js__WEBPACK_IMPORTED_MODULE_4__/* .resolveToolVerbByCase */ .F_)("lsToolCall", completed) ||
            (completed ? "Listed" : "Listing"));
    if (upper.includes("EDIT"))
        return ((0,_constants_js__WEBPACK_IMPORTED_MODULE_4__/* .resolveToolVerbByCase */ .F_)("editToolCall", completed) ||
            (completed ? "Edited" : "Editing"));
    if (upper.includes("SHELL") || upper.includes("TERMINAL"))
        return ((0,_constants_js__WEBPACK_IMPORTED_MODULE_4__/* .resolveToolVerbByCase */ .F_)("shellToolCall", completed) ||
            (completed ? "Ran" : "Running"));
    // Fallback
    return completed ? name : `${name}…`;
}
const BackgroundToolGroupUI = ({ toolCalls, forceCompleted, }) => {
    const allCompleted = toolCalls.every(t => !!t.result);
    // Order of first appearance for type summary and name construction
    const typeOrder = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        const seen = new Set();
        const order = [];
        for (const t of toolCalls) {
            const ty = t.call.tool;
            if (!seen.has(ty)) {
                seen.add(ty);
                order.push(ty);
            }
        }
        return order;
    }, [toolCalls]);
    // Counts per type
    const countByType = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        var _a;
        const map = {};
        for (const t of toolCalls) {
            const ty = t.call.tool;
            map[ty] = ((_a = map[ty]) !== null && _a !== void 0 ? _a : 0) + 1;
        }
        return map;
    }, [toolCalls]);
    // Completion status per type (true if all calls of that type completed)
    const completedByType = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        const completionMap = {};
        for (const t of toolCalls) {
            const ty = t.call.tool;
            const isCompletedForCall = !!t.result;
            if (completionMap[ty] === undefined) {
                completionMap[ty] = isCompletedForCall;
            }
            else {
                completionMap[ty] = completionMap[ty] && isCompletedForCall;
            }
        }
        return completionMap;
    }, [toolCalls]);
    // Primary summary like: "2 edits, 1 shell"
    const primary = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        var _a;
        const parts = [];
        for (const ty of typeOrder) {
            const n = (_a = countByType[ty]) !== null && _a !== void 0 ? _a : 0;
            if (n <= 0)
                continue;
            const name = enumName(ty).toUpperCase();
            const label = (() => {
                if (name.includes("EDIT"))
                    return `${n} edit${n === 1 ? "" : "s"}`;
                if (name.includes("SHELL") || name.includes("TERMINAL"))
                    return `${n} shell${n === 1 ? "" : "s"}`;
                if (name.includes("SEMSEARCH") || name.includes("SEMANTIC_SEARCH"))
                    return `${n} search${n === 1 ? "" : "es"}`;
                if (name.includes("GREP"))
                    return `${n} grep${n === 1 ? "" : "s"}`;
                if (name.includes("READ"))
                    return `${n} file${n === 1 ? "" : "s"}`;
                if (name.includes("GLOB"))
                    return `${n} glob${n === 1 ? "" : "s"}`;
                if (name.includes("LIST"))
                    return `${n} director${n === 1 ? "y" : "ies"}`;
                return `${n} call${n === 1 ? "" : "s"}`;
            })();
            parts.push(label);
        }
        return parts.join(", ");
    }, [typeOrder, countByType]);
    // Name from verbs in chronological order: e.g. "Edited, Ran"
    const headerName = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        var _a;
        const parts = [];
        const seen = new Set();
        for (const t of toolCalls) {
            const ty = t.call.tool;
            if (seen.has(ty))
                continue;
            seen.add(ty);
            const n = enumName(ty);
            const completedForType = forceCompleted
                ? true
                : ((_a = completedByType[ty]) !== null && _a !== void 0 ? _a : false);
            parts.push(classifyVerb(n, completedForType));
        }
        const raw = parts.join(", ");
        return raw ? raw.charAt(0).toUpperCase() + raw.slice(1) : "Tools";
    }, [toolCalls, completedByType, forceCompleted]);
    const status = allCompleted || !!forceCompleted ? "success" : "pending";
    if (!toolCalls || toolCalls.length === 0)
        return null;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_5__/* .ToolCallHeader */ .C, { name: headerName, primary: primary, status: status }) }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/base-composer-item.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* unused harmony export BaseComposerItem */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _utils_background_composer_utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/utils/background-composer-utils.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const BaseComposerItem = ({ composer, isSelected = false, showIndex = false, index, variant = "list", }) => {
    const timeAgo = formatTimestamp(composer.createdAtMs);
    const statusIcon = getStatusIcon(composer.status);
    const statusColor = getStatusColor(composer.status);
    const repoName = extractRepoName(composer.repoUrl);
    const borderColor = isSelected
        ? "blue"
        : variant === "selection"
            ? "black"
            : undefined;
    const titleColor = isSelected && variant === "selection" ? "white" : undefined;
    return (_jsxs(Box, { flexDirection: "column", marginBottom: 1, borderLeft: variant === "list" ? isSelected : true, borderRight: false, borderTop: false, borderBottom: false, borderStyle: variant === "selection" ? "single" : undefined, borderColor: borderColor, paddingLeft: variant === "list" && isSelected ? 1 : variant === "selection" ? 1 : 0, children: [_jsx(Box, { flexDirection: "row", justifyContent: "space-between", children: _jsxs(Box, { flexDirection: "row", alignItems: "center", children: [showIndex && typeof index === "number" && (_jsxs(Text, { color: "gray", children: ["[", index + 1, "]"] })), _jsx(Box, { marginLeft: showIndex ? 1 : 0, children: _jsx(Text, { color: statusColor, children: statusIcon }) }), _jsx(Box, { marginLeft: 1, children: _jsx(Text, { bold: true, color: titleColor, children: truncateText(composer.name, variant === "selection" ? 40 : 45) }) }), composer.isUnread && (_jsxs(Text, { color: "blue", bold: true, children: [" ", "\u2022"] })), _jsx(Box, { marginLeft: 1, children: _jsxs(Text, { color: "gray", children: ["(", timeAgo, ")"] }) })] }) }), _jsxs(Box, { flexDirection: "row", marginLeft: showIndex ? 4 : 2, children: [variant === "list" && _jsxs(Text, { color: "gray", children: [timeAgo, " \u2022 "] }), _jsx(Text, { color: "cyan", children: truncateText(repoName, 32) }), _jsx(Text, { color: "gray", children: " \u2022 " }), _jsx(Text, { color: "cyan", children: truncateText(composer.branchName, 64) })] }), _jsx(Box, { flexDirection: "row", marginLeft: showIndex ? 4 : 2, children: _jsx(Text, { color: "gray", dimColor: true, children: composer.bcId }) })] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/create-plan-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   U: () => (/* binding */ CreatePlanToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _markdown_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/components/markdown.tsx");
/* harmony import */ var _prompt_decision_dropdown_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/prompt/decision-dropdown.tsx");
/* harmony import */ var _tool_row_box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/tool-row-box.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _markdown_js__WEBPACK_IMPORTED_MODULE_2__, _prompt_decision_dropdown_js__WEBPACK_IMPORTED_MODULE_3__, _tool_row_box_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _markdown_js__WEBPACK_IMPORTED_MODULE_2__, _prompt_decision_dropdown_js__WEBPACK_IMPORTED_MODULE_3__, _tool_row_box_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const CreatePlanToolUI = ({ tool: { args, result }, isSuggestingPlan = false, planDecisionIndex = 0, state, }) => {
    var _a;
    const isSuccess = ((_a = result === null || result === void 0 ? void 0 : result.result) === null || _a === void 0 ? void 0 : _a.case) === "success";
    // Only show if we have a plan
    if (!(args === null || args === void 0 ? void 0 : args.plan)) {
        return null;
    }
    const isRejected = state === "rejected";
    const isAccepted = state === "accepted";
    // Rejected plan - show dimmed static version
    if (isRejected) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_row_box_js__WEBPACK_IMPORTED_MODULE_4__/* .ToolRowBox */ .Y, { flexDirection: "column", borderColor: "gray", borderDimColor: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingX: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: "Plan (rejected)" }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { borderStyle: "single", borderColor: "gray", borderDimColor: true, paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_markdown_js__WEBPACK_IMPORTED_MODULE_2__/* .Markdown */ .oz, { content: args.plan }) })] }) }));
    }
    // Active suggestion mode
    if (isSuggestingPlan && isSuccess) {
        const options = [
            { label: "Accept and proceed", hint: "(y)" },
            { label: "Reject and propose changes", hint: "(n or esc)" },
        ];
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_row_box_js__WEBPACK_IMPORTED_MODULE_4__/* .ToolRowBox */ .Y, { flexDirection: "column", borderColor: "yellow", borderDimColor: false, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingX: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { bold: true, color: "yellow", children: "Suggested Plan" }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { borderStyle: "single", borderColor: "gray", borderDimColor: true, paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_markdown_js__WEBPACK_IMPORTED_MODULE_2__/* .Markdown */ .oz, { content: args.plan }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_prompt_decision_dropdown_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A, { title: "", highlightColor: "yellow", options: options, selectedIndex: planDecisionIndex })] }) }));
    }
    // Default display (not actively suggesting)
    const getTitle = () => {
        if (isRejected)
            return "Rejected Plan";
        if (isAccepted)
            return "Plan (accepted)";
        return "Suggested Plan";
    };
    const getTitleColor = () => {
        if (isRejected)
            return "gray";
        if (isAccepted)
            return "green";
        return "yellow";
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_row_box_js__WEBPACK_IMPORTED_MODULE_4__/* .ToolRowBox */ .Y, { flexDirection: "column", borderColor: "gray", borderDimColor: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingX: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: getTitleColor(), dimColor: isRejected, children: getTitle() }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { borderStyle: "single", borderColor: "gray", borderDimColor: true, paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_markdown_js__WEBPACK_IMPORTED_MODULE_2__/* .Markdown */ .oz, { content: args.plan }) })] }) }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/cube-overlay.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   a: () => (/* binding */ CubeOverlay)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _assets_ascii_json__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/assets/ascii.json");
/* harmony import */ var _ephemeral_bridge_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/ephemeral-bridge.ts");
/* harmony import */ var _onboarding_ui_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/onboarding-ui.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _onboarding_ui_js__WEBPACK_IMPORTED_MODULE_5__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _onboarding_ui_js__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const CubeOverlay = ({ onClose }) => {
    var _a, _b;
    const frames = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => _assets_ascii_json__WEBPACK_IMPORTED_MODULE_3__, []);
    const [verticalScale] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(0.6);
    const [horizontalScale] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(1);
    const [offsetColumns] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
    // Compute left trim once to stabilize horizontal position across frames
    const trimLeftColumns = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => (0,_onboarding_ui_js__WEBPACK_IMPORTED_MODULE_5__/* .computeLeftTrimColumns */ .Wv)(frames), [frames]);
    (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useInput */ .Ge)((input, key) => {
        if (key.escape ||
            key.return ||
            input === "q" ||
            input === "Q" ||
            (key.ctrl && input === "c")) {
            onClose();
        }
    });
    const { stdout } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useStdout */ .t$)();
    // Use consistent terminal dimensions from useStdout hook for proper resizing
    const width = Math.max(1, (_a = stdout === null || stdout === void 0 ? void 0 : stdout.columns) !== null && _a !== void 0 ? _a : 80);
    const height = Math.max(1, (_b = stdout === null || stdout === void 0 ? void 0 : stdout.rows) !== null && _b !== void 0 ? _b : 24);
    // Pre-compute a stable bounding box to prevent residual glyphs.
    const asciiW = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => (0,_onboarding_ui_js__WEBPACK_IMPORTED_MODULE_5__/* .computeAsciiWidth */ .vY)(frames, horizontalScale, offsetColumns, trimLeftColumns), [frames, horizontalScale, offsetColumns, trimLeftColumns]);
    const asciiH = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => (0,_onboarding_ui_js__WEBPACK_IMPORTED_MODULE_5__/* .computeAsciiHeight */ .W7)(frames, verticalScale), [frames, verticalScale]);
    // Suppress global ephemeral error printing while overlay is visible to
    // prevent raw stderr writes from corrupting the alt screen drawing.
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        const noop = () => { };
        (0,_ephemeral_bridge_js__WEBPACK_IMPORTED_MODULE_4__/* .setEphemeralListener */ .al)(noop);
        return () => (0,_ephemeral_bridge_js__WEBPACK_IMPORTED_MODULE_4__/* .setEphemeralListener */ .al)(null);
    }, []);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: width, height: height, flexDirection: "row", alignItems: "center", justifyContent: "center", children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: asciiW, height: asciiH, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_onboarding_ui_js__WEBPACK_IMPORTED_MODULE_5__/* .AnimatedAscii */ .Hk, { frames: frames, intervalMs: 50, verticalScale: verticalScale, horizontalScale: horizontalScale, offsetColumns: offsetColumns, trimLeftColumns: trimLeftColumns }) }) }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/delete-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: () => (/* binding */ DeleteToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/tool-call-header.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const DeleteToolUI = ({ tool: { args, result }, }) => {
    var _a, _b;
    if (!args) {
        return null;
    }
    const pathDisplay = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .getPathDisplay */ .Kr)(args.path);
    let status = "pending";
    let displayText;
    const rr = result === null || result === void 0 ? void 0 : result.result;
    const caseType = rr === null || rr === void 0 ? void 0 : rr.case;
    switch (caseType) {
        case undefined:
            status = "pending";
            break;
        case "success":
            status = "success";
            break;
        case "rejected":
            status = "rejected";
            break;
        case "permissionDenied": {
            status = "error";
            displayText =
                String((_b = (_a = rr === null || rr === void 0 ? void 0 : rr.value) === null || _a === void 0 ? void 0 : _a.clientVisibleError) !== null && _b !== void 0 ? _b : "") || "Permission denied";
            break;
        }
        case "fileNotFound":
        case "notFile":
        case "fileBusy":
        case "error":
            status = "error";
            break;
        default: {
            const _exhaustive = caseType;
            status = "pending";
            break;
        }
    }
    const headerName = (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__/* .resolveToolVerbByCase */ .F_)("deleteToolCall", status === "success") ||
        (status === "success" ? "Deleted" : "Deleting");
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__/* .ToolCallHeader */ .C, { name: headerName, primary: pathDisplay, status: status }), caseType === "fileNotFound" && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: "File not found" }) })), caseType === "notFile" && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: "Path is not a file" }) })), caseType === "permissionDenied" && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: displayText }) })), caseType === "fileBusy" && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: "File is busy" }) })), caseType === "error" && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: "Delete failed" }) })), caseType === "rejected" && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "yellow", children: "Request rejected" }) })), caseType === "success" && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: "Completed" }) }))] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/edit-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   N: () => (/* binding */ EditToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/highlighted-code.tsx");
/* harmony import */ var _inline_delta_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/inline-delta.tsx");
/* harmony import */ var _tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/components/tool-row-box.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__, _inline_delta_js__WEBPACK_IMPORTED_MODULE_5__, _tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__, _inline_delta_js__WEBPACK_IMPORTED_MODULE_5__, _tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







const EditToolUI = ({ tool, aborted }) => {
    var _a, _b, _c;
    const args = tool.args;
    const result = tool.result;
    if (!args || !args.path) {
        return null;
    }
    const pathDisplay = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .getPathDisplay */ .Kr)(args.path);
    if (!result || !result.result) {
        const headerName = (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__/* .resolveToolVerbByCase */ .F_)("editToolCall", false) || "Editing";
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__/* .ToolRowBox */ .Y, { flexDirection: "column", paddingRight: 2, paddingLeft: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { bold: true, children: headerName }), " ", pathDisplay, aborted ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: "Aborted" })] })) : null] }) }) }));
    }
    const rr = result.result;
    let note;
    let color = "gray";
    let diffString;
    if (aborted) {
        note = "Aborted";
        color = "gray";
    }
    else {
        switch (rr.case) {
            case "success": {
                const linesRemoved = (_a = rr.value.linesRemoved) !== null && _a !== void 0 ? _a : 0;
                const linesAdded = (_b = rr.value.linesAdded) !== null && _b !== void 0 ? _b : 0;
                note = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_inline_delta_js__WEBPACK_IMPORTED_MODULE_5__/* .InlineDelta */ ._, { removed: linesRemoved, added: linesAdded });
                diffString = rr.value.diffString;
                break;
            }
            case "fileNotFound":
                note = "File not found";
                color = "gray";
                break;
            case "readPermissionDenied":
                note = "Permission denied reading";
                color = "gray";
                break;
            case "writePermissionDenied":
                note = String(rr.value.error) || "Permission denied writing";
                color = "gray";
                break;
            case "rejected":
                note = "Edit rejected";
                color = "yellow";
                break;
            case "error":
                note = rr.value.error || "Edit error";
                color = "gray";
                break;
            default: {
                const _exhaustiveCheck = rr.case;
                void _exhaustiveCheck;
                note = "Unknown edit result";
                color = "gray";
                break;
            }
        }
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_tool_row_box_js__WEBPACK_IMPORTED_MODULE_6__/* .ToolRowBox */ .Y, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", gap: 1, paddingX: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexShrink: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: pathDisplay }) }), typeof note === "string" ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: color, wrap: "truncate", children: note })) : note ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: note })) : null] }), diffString ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__/* .HighlightedCode */ .d, { content: diffString, language: (_c = (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__/* .inferLanguageFromPath */ .Ak)(args.path)) !== null && _c !== void 0 ? _c : "diff", isDiff: true, showLineNumbers: false, maxLines: 12, truncationHint: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .REVIEW_MODE_ENABLED */ .hD ? "ctrl+r to review" : undefined, paddingX: 1 })) : null] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/file-change-review.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (/* binding */ FileChangeReview)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var chalk__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("../../node_modules/.pnpm/chalk@5.4.1/node_modules/chalk/source/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _context_agent_state_context_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/context/agent-state-context.tsx");
/* harmony import */ var _context_theme_context_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/context/theme-context.tsx");
/* harmony import */ var _context_vim_mode_context_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/context/vim-mode-context.tsx");
/* harmony import */ var _debug_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/debug.ts");
/* harmony import */ var _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/hooks/use-screen-size.ts");
/* harmony import */ var _hooks_use_shared_animation_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("./src/hooks/use-shared-animation.ts");
/* harmony import */ var _hooks_use_text_input_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("./src/hooks/use-text-input.ts");
/* harmony import */ var _utils_characters_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__("./src/utils/characters.ts");
/* harmony import */ var _utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("./src/utils/color-mixing.ts");
/* harmony import */ var _utils_diff_colors_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("./src/utils/diff-colors.ts");
/* harmony import */ var _utils_diff_sequences_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("./src/utils/diff-sequences.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _utils_prompt_utils_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("./src/utils/prompt-utils.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _context_theme_context_js__WEBPACK_IMPORTED_MODULE_5__, _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_8__, _hooks_use_text_input_js__WEBPACK_IMPORTED_MODULE_10__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _context_theme_context_js__WEBPACK_IMPORTED_MODULE_5__, _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_8__, _hooks_use_text_input_js__WEBPACK_IMPORTED_MODULE_10__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

/** biome-ignore-all lint/suspicious/noControlCharactersInRegex: used for diff sequences */

















const FileChangeReview = ({ 
// biome-ignore lint/correctness/noUnusedFunctionParameters: not used for now, but can use to accept/reject changes
fileChangeTracker, changes, onExit, onSubmitPrompt, initialSelectedIndex, wrapLines = true, isGenerating: isGeneratingProp, }) => {
    var _a, _b, _c;
    const { isGenerating: isGeneratingFromContext } = (0,_context_agent_state_context_js__WEBPACK_IMPORTED_MODULE_4__/* .useAgentState */ .C9)();
    const isGenerating = isGeneratingProp !== null && isGeneratingProp !== void 0 ? isGeneratingProp : isGeneratingFromContext;
    const gatePatterns = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => [
        /(^|\/)yarn\.lock$/,
        /(^|\/)pnpm-lock\.yaml$/,
        /(^|\/)package-lock\.json$/,
        /(^|\/)bun\.lockb$/,
        /(^|\/)Cargo\.lock$/,
        /(^|\/)Gemfile\.lock$/,
        /(^|\/)poetry\.lock$/,
        /(^|\/)Pipfile\.lock$/,
        /(^|\/)composer\.lock$/,
        /(^|\/)go\.sum$/,
        /(^|\/)Podfile\.lock$/,
        /(^|\/)gradle\.lockfile$/,
        /\.(png|jpe?g|gif|bmp|webp|ico|pdf|zip|tar|tgz|gz|rar|7z|jar|wasm|woff2?|ttf|otf)$/i,
        /\.min\.js$/,
    ], []);
    const gateForChange = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((c) => {
        var _a, _b, _c, _d;
        if (_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .TEST_FILE_REVIEW_FORCE_GATED_PATHS */ .ye.has(c.path))
            return { gated: true, reason: "Forced gated for testing" };
        const p = c.path;
        for (const re of gatePatterns)
            if (re.test(p))
                return { gated: true, reason: "Lock file diff hidden" };
        const bl = (_b = (_a = c.before) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0;
        const al = (_d = (_c = c.after) === null || _c === void 0 ? void 0 : _c.length) !== null && _d !== void 0 ? _d : 0;
        if ((c.before && c.before.indexOf("\x00") !== -1) ||
            (c.after && c.after.indexOf("\x00") !== -1))
            return { gated: true, reason: "Binary file diff hidden" };
        if (bl + al > _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .FILE_REVIEW_MAX_CHARS */ .Le ||
            bl > _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .FILE_REVIEW_MAX_CHARS */ .Le ||
            al > _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .FILE_REVIEW_MAX_CHARS */ .Le)
            return { gated: true, reason: "File too large to render diff" };
        return { gated: false, reason: "" };
    }, [gatePatterns]);
    const gatedMessageLines = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((reason) => {
        return [
            "",
            `   ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim(`${reason} — not shown`)}`,
            `   ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim("You can still keep or undo this change.")}`,
            "",
        ];
    }, []);
    const [selectedIndex, setSelectedIndex] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(initialSelectedIndex !== null && initialSelectedIndex !== void 0 ? initialSelectedIndex : 0);
    const [commandBuffer, setCommandBuffer] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(""); // kept for help toggle only at parent; actual scrolling handled in child
    const [showHelp, setShowHelp] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const [promptActive, setPromptActive] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const [promptValue, setPromptValue] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)("");
    const [staged, _setStaged] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)({});
    const { stdout } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useStdout */ .t$)();
    const screen = (0,_hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_8__/* .useScreenSize */ .l)();
    const { setReviewSelectedIndex, pendingDecisions, rejectPendingDecision } = (0,_context_agent_state_context_js__WEBPACK_IMPORTED_MODULE_4__/* .useAgentState */ .C9)();
    const { vimEnabled, mode, setMode } = (0,_context_vim_mode_context_js__WEBPACK_IMPORTED_MODULE_6__/* .useVimMode */ .v)();
    const shouldSpin = _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .TEST_FILE_REVIEW_GENERATING */ .Eo || isGenerating || pendingDecisions.length > 0;
    const hexTick = (0,_hooks_use_shared_animation_js__WEBPACK_IMPORTED_MODULE_9__/* .useSharedTick */ .e)(_hooks_use_shared_animation_js__WEBPACK_IMPORTED_MODULE_9__/* .DEFAULT_HEXAGON_INTERVAL_MS */ .q, !shouldSpin);
    const [feedback, setFeedback] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
    const feedbackTimerRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const perfEventsRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)([]);
    const perf = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((name, data) => {
        perfEventsRef.current.push({ name, data, ts: Date.now() });
    }, []);
    const shikiImportRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const getCodeToTokens = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => __awaiter(void 0, void 0, void 0, function* () {
        if (!shikiImportRef.current)
            shikiImportRef.current = __webpack_require__.e(/* import() */ 4541).then(__webpack_require__.bind(__webpack_require__, "../../node_modules/.pnpm/shiki@3.7.0/node_modules/shiki/dist/index.mjs"));
        const mod = yield shikiImportRef.current;
        return mod.codeToTokens;
    }), []);
    const highlightPendingRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(new Map());
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        const flush = () => {
            var _a, _b, _c;
            const evs = perfEventsRef.current.splice(0);
            if (evs.length === 0)
                return;
            const summary = {};
            for (const e of evs) {
                const d = (_a = e === null || e === void 0 ? void 0 : e.data) === null || _a === void 0 ? void 0 : _a.durMs;
                if (typeof d === "number" && Number.isFinite(d)) {
                    const k = (_b = e === null || e === void 0 ? void 0 : e.name) !== null && _b !== void 0 ? _b : "unknown";
                    summary[k] = ((_c = summary[k]) !== null && _c !== void 0 ? _c : 0) + d;
                }
            }
            if (Object.keys(summary).length > 0)
                (0,_debug_js__WEBPACK_IMPORTED_MODULE_7__.debugLogJSON)("perf.summary", summary);
        };
        const id = setTimeout(flush, 800);
        return () => {
            clearTimeout(id);
            flush();
        };
    }, []);
    const colorMode = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_11__/* .getColorMode */ .PT)(), []);
    const fg = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((hex) => {
        if (!hex)
            return "";
        const rgb = (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_11__/* .hexToRgb */ .E2)(hex);
        if (!rgb)
            return "";
        if (colorMode === "truecolor")
            return `\x1b[38;2;${rgb.r};${rgb.g};${rgb.b}m`;
        if (colorMode === "ansi256")
            return `\x1b[38;5;${(0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_11__/* .rgbToAnsi256 */ .LQ)(rgb.r, rgb.g, rgb.b)}m`;
        return "";
    }, [colorMode]);
    const bg = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((hex) => {
        if (!hex)
            return "";
        const rgb = (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_11__/* .hexToRgb */ .E2)(hex);
        if (!rgb)
            return "";
        if (colorMode === "truecolor")
            return `\x1b[48;2;${rgb.r};${rgb.g};${rgb.b}m`;
        if (colorMode === "ansi256")
            return `\x1b[48;5;${(0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_11__/* .rgbToAnsi256 */ .LQ)(rgb.r, rgb.g, rgb.b)}m`;
        return "";
    }, [colorMode]);
    // Diff sign (+/-) foreground sequences by color mode
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        if (!stdout)
            return;
        try {
            // Enter alt screen, disable line wrap, enable application cursor keys
            // Also hide cursor to reduce redraw flicker during manual rendering
            stdout.write("\x1b[?1049h\x1b[?7l\x1b[?1h\x1b=\x1b[?25l");
        }
        catch (_a) { }
        return () => {
            try {
                stdout.write("\x1b[?1l\x1b>\x1b[?7h\x1b[?1049l");
            }
            catch (_a) { }
        };
    }, [stdout]);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        if (initialSelectedIndex != null)
            setReviewSelectedIndex(initialSelectedIndex);
    }, [initialSelectedIndex, setReviewSelectedIndex]);
    // Exit review mode automatically if there are no changes
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        if (changes.length === 0)
            onExit();
    }, [changes.length, onExit]);
    const createDiffLines = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((beforeContent, afterContent) => {
        const beforeLines = beforeContent.split(/\r?\n/);
        const afterLines = afterContent.split(/\r?\n/);
        const diffLines = [];
        let beforeIndex = 0;
        let afterIndex = 0;
        const isCommon = (aIndex, bIndex) => beforeLines[aIndex] === afterLines[bIndex];
        const foundSubsequence = (nCommon, aCommon, bCommon) => {
            for (let i = beforeIndex; i < aCommon; i++)
                diffLines.push({
                    type: "removed",
                    content: beforeLines[i],
                    beforeLineNumber: i + 1,
                });
            for (let i = afterIndex; i < bCommon; i++)
                diffLines.push({
                    type: "added",
                    content: afterLines[i],
                    afterLineNumber: i + 1,
                });
            for (let i = 0; i < nCommon; i++)
                diffLines.push({
                    type: "common",
                    content: beforeLines[aCommon + i],
                    beforeLineNumber: aCommon + i + 1,
                    afterLineNumber: bCommon + i + 1,
                });
            beforeIndex = aCommon + nCommon;
            afterIndex = bCommon + nCommon;
        };
        try {
            const diffImpl = _utils_diff_sequences_js__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .A;
            diffImpl(beforeLines.length, afterLines.length, isCommon, foundSubsequence);
        }
        catch (_a) {
            // Fallback: if diff lib not available, treat entire after file as added
            return afterLines.map(l => ({ type: "added", content: l }));
        }
        for (let i = beforeIndex; i < beforeLines.length; i++)
            diffLines.push({
                type: "removed",
                content: beforeLines[i],
                beforeLineNumber: i + 1,
            });
        for (let i = afterIndex; i < afterLines.length; i++)
            diffLines.push({
                type: "added",
                content: afterLines[i],
                afterLineNumber: i + 1,
            });
        return diffLines;
    }, []);
    const filterDiffLinesWithContext = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((lines, contextLines) => {
        const changeIndices = [];
        lines.forEach((line, index) => {
            if (line.type !== "common")
                changeIndices.push(index);
        });
        if (changeIndices.length === 0)
            return [];
        const hunks = [];
        let currentHunk = null;
        changeIndices.forEach(index => {
            if (!currentHunk)
                currentHunk = { start: index, end: index };
            else if (index <= currentHunk.end + contextLines * 2 + 1)
                currentHunk.end = index;
            else {
                hunks.push(currentHunk);
                currentHunk = { start: index, end: index };
            }
        });
        if (currentHunk)
            hunks.push(currentHunk);
        const result = [];
        for (let hi = 0; hi < hunks.length; hi++) {
            const hunk = hunks[hi];
            const startIndex = Math.max(0, hunk.start - contextLines);
            const endIndex = Math.min(lines.length - 1, hunk.end + contextLines);
            for (let i = startIndex; i <= endIndex; i++)
                result.push(lines[i]);
            if (hi < hunks.length - 1) {
                const nextStartIndex = Math.max(0, hunks[hi + 1].start - contextLines);
                const omitted = Math.max(0, nextStartIndex - endIndex - 1);
                if (omitted > 0)
                    result.push({ type: "gap", content: "", gapCount: omitted });
            }
        }
        return result;
    }, []);
    // Dynamically increase context lines when diff is short/small.
    const computeContextLines = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((diffLines) => {
        const changeCount = diffLines.reduce((acc, l) => (l.type !== "common" ? acc + 1 : acc), 0);
        if (changeCount <= 10 && diffLines.length <= 400)
            return 10; // expanded context
        return _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .FILE_REVIEW_DEFAULT_CONTEXT_LINES */ .oy; // default compact context
    }, []);
    const [precomputed, setPrecomputed] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)({});
    const precomputeRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(new Set());
    const precomputedStateRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(precomputed);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        precomputedStateRef.current = precomputed;
    }, [precomputed]);
    const computePrecomputed = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((c) => {
        var _a;
        const t0 = Date.now();
        const gate = gateForChange(c);
        if (gate.gated) {
            const gl = gatedMessageLines(gate.reason);
            const res = {
                lines: gl,
                kinds: new Array(gl.length).fill("other"),
                total: 2,
                added: 0,
                removed: 0,
            };
            const dur = Date.now() - t0;
            perf("computePrecomputed", { path: c.path, gated: true, durMs: dur });
            return res;
        }
        if (c.after === undefined) {
            const beforeLines = ((_a = c.before) !== null && _a !== void 0 ? _a : "").split(/\r?\n/);
            const res = {
                lines: ["[deleted]"],
                kinds: ["removed"],
                total: 1,
                added: 0,
                removed: Math.max(0, beforeLines.length),
            };
            const dur = Date.now() - t0;
            perf("computePrecomputed", {
                path: c.path,
                type: "deleted",
                durMs: dur,
            });
            return res;
        }
        if (c.before === undefined) {
            const rawLines = c.after.split(/\r?\n/);
            const lines = rawLines.map((l, idx) => `${(idx + 1)
                .toString()
                .padStart(4, " ")} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}\x1b[2m \x1b[0m ${l}`);
            const kinds = new Array(lines.length).fill("added");
            const res = {
                lines,
                kinds,
                total: lines.length,
                added: rawLines.length,
                removed: 0,
            };
            const dur = Date.now() - t0;
            perf("computePrecomputed", {
                path: c.path,
                type: "created",
                lines: lines.length,
                durMs: dur,
            });
            return res;
        }
        let diffEntry = diffCacheRef.current.get(c.path);
        if (!diffEntry) {
            const diffLines = createDiffLines(c.before, c.after);
            const contextLines = computeContextLines(diffLines);
            const filtered = filterDiffLinesWithContext(diffLines, contextLines);
            diffEntry = { diffLines, filtered, contextLines };
            diffCacheRef.current.set(c.path, diffEntry);
        }
        const { diffLines, filtered } = diffEntry;
        let addedCount = 0;
        let removedCount = 0;
        for (const dl of diffLines) {
            if (dl.type === "added")
                addedCount++;
            else if (dl.type === "removed")
                removedCount++;
        }
        const kinds = new Array(filtered.length);
        const lines = filtered.map((l, idx) => {
            var _a;
            const beforeNum = l.beforeLineNumber
                ? l.beforeLineNumber.toString().padStart(4, " ")
                : "    ";
            const afterNum = l.afterLineNumber
                ? l.afterLineNumber.toString().padStart(4, " ")
                : "    ";
            switch (l.type) {
                case "added":
                    kinds[idx] = "added";
                    return `${beforeNum} ${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}\x1b[32m+\x1b[39m ${l.content}\x1b[0m`;
                case "removed":
                    kinds[idx] = "removed";
                    return `${beforeNum} ${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}\x1b[31m-\x1b[39m ${l.content}\x1b[0m`;
                case "gap":
                    kinds[idx] = "other";
                    return `${beforeNum} ${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}\x1b[2m⋯ ${(_a = l.gapCount) !== null && _a !== void 0 ? _a : 0} lines truncated ⋯\x1b[0m`;
                default:
                    kinds[idx] = "other";
                    return `${beforeNum} ${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}\x1b[2m \x1b[0m ${l.content}`;
            }
        });
        const res = {
            lines,
            kinds,
            total: lines.length,
            added: addedCount,
            removed: removedCount,
        };
        const dur = Date.now() - t0;
        perf("computePrecomputed", {
            path: c.path,
            type: "modified",
            total: lines.length,
            added: addedCount,
            removed: removedCount,
            durMs: dur,
        });
        return res;
    }, [
        gateForChange,
        gatedMessageLines,
        createDiffLines,
        computeContextLines,
        filterDiffLinesWithContext,
        perf,
    ]);
    const [highlightCache, setHighlightCache] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)({});
    const computingRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(new Set());
    const MAX_CACHE_ENTRIES = 60;
    const highlightOrderRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)([]);
    const precomputedOrderRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)([]);
    const diffCacheRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(new Map());
    const scheduleIdle = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((fn) => {
        const ric = globalThis.requestIdleCallback;
        if (ric)
            ric(fn);
        else
            setTimeout(fn, 0);
    }, []);
    const idle = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => new Promise(res => {
        const ric = globalThis.requestIdleCallback;
        if (ric)
            ric(() => res());
        else
            setTimeout(() => res(), 0);
    }), []);
    const ensurePrecomputed = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((c) => {
        const path = c.path;
        if (precomputedStateRef.current[path] || precomputeRef.current.has(path))
            return;
        precomputeRef.current.add(path);
        const t0 = Date.now();
        scheduleIdle(() => {
            const res = computePrecomputed(c);
            setPrecomputed(prev => (Object.assign(Object.assign({}, prev), { [path]: res })));
            precomputedOrderRef.current.push(path);
            if (precomputedOrderRef.current.length > MAX_CACHE_ENTRIES) {
                const victim = precomputedOrderRef.current.shift();
                if (victim)
                    setPrecomputed(prev => {
                        const next = Object.assign({}, prev);
                        delete next[victim];
                        return next;
                    });
            }
            precomputeRef.current.delete(path);
            const dur = Date.now() - t0;
            perf("ensurePrecomputed", { path, durMs: dur });
        });
    }, [computePrecomputed, perf, scheduleIdle]);
    // Type wrappers removed; theme is now provided by context
    // Defer expensive syntax highlighting until after first paint / interaction
    const [highlightReady, setHighlightReady] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const setHighlightEntry = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((path, entry) => {
        const safeEntry = (() => {
            const lineLen = entry.lines.length;
            const kindLen = entry.kinds.length;
            if (lineLen !== kindLen) {
                let fixedKinds = entry.kinds.slice(0, lineLen);
                if (fixedKinds.length < lineLen) {
                    fixedKinds = fixedKinds.concat(new Array(lineLen - fixedKinds.length).fill("other"));
                }
                fixedKinds = fixedKinds.map(k => k === "added" || k === "removed" || k === "other" ? k : "other");
                _debug_js__WEBPACK_IMPORTED_MODULE_7__.debugLogJSON === null || _debug_js__WEBPACK_IMPORTED_MODULE_7__.debugLogJSON === void 0 ? void 0 : (0,_debug_js__WEBPACK_IMPORTED_MODULE_7__.debugLogJSON)("highlight.kinds_mismatch", {
                    path,
                    lines: lineLen,
                    kinds: kindLen,
                });
                return { lines: entry.lines, kinds: fixedKinds, total: entry.total };
            }
            // Also coerce any unexpected values to a safe default
            const coercedKinds = entry.kinds.map(k => k === "added" || k === "removed" || k === "other" ? k : "other");
            return { lines: entry.lines, kinds: coercedKinds, total: entry.total };
        })();
        setHighlightCache(prev => {
            const next = Object.assign(Object.assign({}, prev), { [path]: safeEntry });
            highlightOrderRef.current.push(path);
            while (highlightOrderRef.current.length > MAX_CACHE_ENTRIES) {
                const victim = highlightOrderRef.current.shift();
                if (victim && victim in next)
                    delete next[victim];
            }
            return next;
        });
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        const t = setTimeout(() => setHighlightReady(true), 250);
        return () => clearTimeout(t);
    }, []);
    const isLightTheme = (0,_context_theme_context_js__WEBPACK_IMPORTED_MODULE_5__/* .useIsLightTheme */ .pW)();
    // Diff sign (+/-) foreground sequences by color mode
    const signFgAdd = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        if (colorMode === "truecolor") {
            const hex = (isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
                ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SIGN_TRUECOLOR_LIGHT */ .B0.addHex
                : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SIGN_TRUECOLOR_DARK */ .Fv.addHex;
            return fg(hex);
        }
        if (colorMode === "ansi256") {
            const idx = (isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
                ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SIGN_ANSI256_LIGHT */ .Kj.add
                : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SIGN_ANSI256_DARK */ .yp.add;
            return `\x1b[38;5;${idx}m`;
        }
        return _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_GREEN */ .ki;
    }, [colorMode, isLightTheme, fg]);
    const signFgRemove = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        if (colorMode === "truecolor") {
            const hex = (isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
                ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SIGN_TRUECOLOR_LIGHT */ .B0.removeHex
                : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SIGN_TRUECOLOR_DARK */ .Fv.removeHex;
            return fg(hex);
        }
        if (colorMode === "ansi256") {
            const idx = (isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
                ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SIGN_ANSI256_LIGHT */ .Kj.remove
                : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SIGN_ANSI256_DARK */ .yp.remove;
            return `\x1b[38;5;${idx}m`;
        }
        return _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RED */ .s0;
    }, [colorMode, isLightTheme, fg]);
    // When theme changes, invalidate syntax-highlight cache so lines redraw with new tints
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        setHighlightCache({});
        computingRef.current.clear();
    }, []);
    const formatFollowUpFeedback = (_full, vv) => {
        if (vv.length > 10) {
            return `Sent a new follow-up: ${vv.slice(0, 10)}...`;
        }
        return `Sent a new follow-up: ${vv}`;
    };
    // Row-wide background for added/removed lines
    // Use the same mixing as token backgrounds to avoid brighter non-token areas
    const rowBgAdd = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        if (colorMode === "basic")
            return "\x1b[42m"; // native green background
        if (colorMode === "ansi256") {
            const idx = (isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
                ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_ROW_ANSI256_LIGHT */ .Xh.add
                : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_ROW_ANSI256_DARK */ .XM.add;
            return `\x1b[48;5;${idx}m`;
        }
        const { addHex } = (0,_utils_diff_colors_js__WEBPACK_IMPORTED_MODULE_12__/* .computeDiffRowHexes */ .a)(isLightTheme);
        return bg(addHex);
    }, [colorMode, isLightTheme, bg]);
    const rowBgRemove = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        if (colorMode === "basic")
            return "\x1b[41m"; // native red background
        if (colorMode === "ansi256") {
            const idx = (isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
                ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_ROW_ANSI256_LIGHT */ .Xh.remove
                : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_ROW_ANSI256_DARK */ .XM.remove;
            return `\x1b[48;5;${idx}m`;
        }
        const { removeHex } = (0,_utils_diff_colors_js__WEBPACK_IMPORTED_MODULE_12__/* .computeDiffRowHexes */ .a)(isLightTheme);
        return bg(removeHex);
    }, [colorMode, isLightTheme, bg]);
    // Hexagon loader frames (outline/filled)
    const hexagonFrame = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => hexTick % 2 === 0
        ? "⬡"
        : pendingDecisions.length > 0
            ? chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow("⬢")
            : chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.green("⬢"), [hexTick, pendingDecisions.length]);
    const stripAnsi = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((s) => (0,_utils_characters_js__WEBPACK_IMPORTED_MODULE_17__/* .stripAnsi */ .aJ)(s), []);
    const helpModalLines = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        return [
            `${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.white.bold("↑/↓")} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim("scroll ·")} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.white.bold("←/→")} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim("switch file")}`,
            `${changes.length > 1 ? "←/→ switch file, " : ""}q exit`,
            "j/k scroll, Space/f page, b back",
            "Ctrl-d/u half, Ctrl-e/y line, g/G top/bot",
            "",
            chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim("Press q, Esc, Ctrl-C, or Ctrl-R to close"),
        ];
    }, [changes.length]);
    // Render all bodies in one pass for deterministic row-wide tinting
    const [deferBodies, setDeferBodies] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const [, startTransition] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useTransition)();
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        setDeferBodies(false);
    }, []);
    const [wrapReady, setWrapReady] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        setWrapReady(false);
        startTransition(() => setWrapReady(true));
    }, []);
    // Kick off precompute for current file immediately
    const currentChange = changes[selectedIndex];
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        if (!currentChange)
            return;
        ensurePrecomputed(currentChange);
    }, [currentChange, ensurePrecomputed]);
    // const currentPath: string | undefined = currentChange?.path; // unused
    const concat = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        var _a, _b, _c, _d, _e;
        const lines = [];
        const kinds = [];
        const sections = [];
        for (let i = 0; i < changes.length; i++) {
            const lazy = i !== selectedIndex && deferBodies;
            const c = changes[i];
            const start = lines.length;
            const width = Math.max(10, (_b = (_a = screen === null || screen === void 0 ? void 0 : screen.width) !== null && _a !== void 0 ? _a : stdout === null || stdout === void 0 ? void 0 : stdout.columns) !== null && _b !== void 0 ? _b : 80);
            const innerWidth = Math.max(0, width - 2);
            const rawRel = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_13__/* .toRelativePath */ .fw)(c.path);
            const isNew = c.before === undefined;
            const isDeleted = c.after === undefined;
            const d = precomputed[c.path] || {
                lines: [],
                total: 0,
                added: 0,
                removed: 0,
            };
            const headerChip = staged[c.path] === "reject"
                ? ` ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RED */ .s0}✖${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RESET */ .Sj}`
                : staged[c.path] === "accept"
                    ? ` ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_GREEN */ .ki}✔${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RESET */ .Sj}`
                    : "";
            const chipRightPad = headerChip ? " " : "";
            const delta = (() => {
                const segs = [];
                if (d.added > 0)
                    segs.push(`${signFgAdd}+${d.added}${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RESET */ .Sj}`);
                if (d.removed > 0)
                    segs.push(`${signFgRemove}-${d.removed}${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RESET */ .Sj}`);
                return segs.length ? `\x1b[2m${segs.join(" ")}\x1b[0m` : "";
            })();
            const leftPrefix = `${i + 1}/${changes.length} `;
            const leftSuffix = isNew ? ` ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_GREEN */ .ki}[new]${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RESET */ .Sj}` : "";
            const relStyledEmpty = staged[c.path] === "reject" ? `\x1b[9m\x1b[29m` : "";
            const headerMainWithoutRel = `\x1b[1m ${leftPrefix}${relStyledEmpty}${leftSuffix}${headerChip}${chipRightPad} \x1b[0m`;
            const headerLineWithoutRel = delta
                ? `${headerMainWithoutRel} ${delta}`
                : headerMainWithoutRel;
            const baseVisibleLen = stripAnsi(headerLineWithoutRel).length;
            const relMax = Math.max(0, innerWidth - baseVisibleLen);
            const relContent = rawRel.length <= relMax
                ? rawRel
                : (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_13__/* .truncatePathByFoldersLeft */ .RZ)(rawRel, Math.max(0, relMax));
            const relStyled = staged[c.path] === "reject"
                ? `\x1b[9m${relContent}\x1b[29m`
                : relContent;
            const left = `${leftPrefix}${relStyled}${leftSuffix}`;
            const headerMain = `\x1b[1m ${left}${headerChip}${chipRightPad} \x1b[0m`;
            const headerLine = delta ? `${headerMain} ${delta}` : headerMain;
            lines.push(headerLine);
            kinds.push("other");
            // Ensure a visual gap between header and body
            lines.push("");
            kinds.push("other");
            let body = [];
            let bodyKinds = [];
            if (!lazy)
                body = ((_c = (highlightCache[c.path] || precomputed[c.path])) === null || _c === void 0 ? void 0 : _c.lines) || [];
            if (!lazy)
                bodyKinds =
                    ((_d = (highlightCache[c.path] || precomputed[c.path])) === null || _d === void 0 ? void 0 : _d.kinds) ||
                        new Array(body.length).fill("other");
            if (!lazy && (!body || body.length === 0))
                ensurePrecomputed(c);
            if (staged[c.path] === "reject") {
                body = body.map(bl => chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim(bl));
            }
            for (let bi = 0; bi < body.length; bi++) {
                lines.push(body[bi]);
                kinds.push((_e = bodyKinds[bi]) !== null && _e !== void 0 ? _e : "other");
            }
            // single blank line after each section body for 1px margin
            lines.push("");
            kinds.push("other");
            const end = lines.length;
            sections.push({
                path: c.path,
                start,
                end,
                defaultKind: isNew ? "added" : isDeleted ? "removed" : "other",
                isNew,
            });
            if (i < changes.length - 1) {
                lines.push("");
                kinds.push("other");
            }
        }
        return { lines, kinds, sections };
    }, [
        changes,
        precomputed,
        highlightCache,
        screen === null || screen === void 0 ? void 0 : screen.width,
        stdout === null || stdout === void 0 ? void 0 : stdout.columns,
        staged,
        deferBodies,
        selectedIndex,
        ensurePrecomputed,
        signFgAdd,
        signFgRemove,
        stripAnsi,
    ]);
    const lastViewportTopRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(0);
    const currentTotalLines = concat.lines.length;
    const usingOverlayHelp = showHelp;
    const caretStyleFn = () => vimEnabled && mode === "normal" ? chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.bgGray : chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.inverse;
    const promptLineRightFn = () => {
        const caretStyle = caretStyleFn();
        if (promptActive) {
            if (promptValue.length > 0) {
                let rv = "";
                let i = 0;
                let col = 0;
                let usedFirst = false;
                const cursorActualWidth = 0; // highlightPastedText is false here
                const baseFirst = Math.max(0, innerWidthCells -
                    rightFixedPadCols -
                    arrowCols -
                    (showRightPlaceholder
                        ? rightPlaceholderLen + rightPlaceholderPad
                        : 0));
                const baseOther = Math.max(0, innerWidthCells - rightFixedPadCols - arrowCols);
                for (const ch of promptValue) {
                    const capNow = usedFirst ? baseOther : baseFirst;
                    const eolCursorOnLastChar = cursorActualWidth === 0 &&
                        promptCursorOffset === promptValue.length &&
                        capNow > 0 &&
                        col === capNow - 1 &&
                        i === promptValue.length - 1;
                    const isCursorRange = i >= promptCursorOffset - cursorActualWidth &&
                        i <= promptCursorOffset;
                    rv += eolCursorOnLastChar || isCursorRange ? caretStyle(ch) : ch;
                    i++;
                    col++;
                    if (capNow > 0 && col >= capNow) {
                        usedFirst = true;
                        col = 0;
                    }
                }
                if (promptCursorOffset === promptValue.length) {
                    // Always render a visible caret cell even when exactly at a wrapped
                    // boundary (col === 0). In that case, show the caret at the start of
                    // the next wrapped line so it doesn't disappear.
                    rv += caretStyle(" ");
                }
                return rv;
            }
            else {
                const fileLabel = (currentChange === null || currentChange === void 0 ? void 0 : currentChange.path)
                    ? currentChange.path.split("/").pop() || "this file"
                    : "this file";
                const escHint = !vimEnabled || mode === "normal" ? " (Esc cancel)" : "";
                const placeholderRaw = `For ${fileLabel}${escHint}`;
                const first = placeholderRaw.slice(0, 1);
                const rest = placeholderRaw.slice(1);
                return `${caretStyle(first)}${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.grey(rest)}`;
            }
        }
        else {
            return commandBuffer.length > 0
                ? commandBuffer
                : (() => {
                    return chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.grey("Add a follow-up");
                })();
        }
    };
    // Dynamically compute how many lines the bottom input box occupies
    const widthCells = Math.max(10, (_b = (_a = screen === null || screen === void 0 ? void 0 : screen.width) !== null && _a !== void 0 ? _a : stdout === null || stdout === void 0 ? void 0 : stdout.columns) !== null && _b !== void 0 ? _b : 80);
    const innerWidthCells = Math.max(0, widthCells - 2);
    const showRightPlaceholder = !promptActive && promptValue.length === 0;
    const rightPlaceholderLabel = chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.grey("i to insert");
    const rightPlaceholderLen = stripAnsi(rightPlaceholderLabel).length;
    const rightPlaceholderPad = 1;
    // Helper to count how many wrapped lines the current input would take inside the box
    const countWrappedInputLines = (text, firstLineAvail, otherAvail) => {
        const ESC = 0x1b;
        let i = 0;
        let col = 0;
        let usedFirst = false;
        let lines = 1; // at least one line
        const capacityForCurrent = () => usedFirst ? otherAvail : firstLineAvail;
        while (i < text.length) {
            const ch = text.charCodeAt(i);
            if (ch === ESC && text[i + 1] === "[") {
                let j = i + 2;
                while (j < text.length && text[j] !== "m")
                    j++;
                i = Math.min(text.length, j + 1);
                continue;
            }
            // treat everything (except ANSI) as width 1 for counting; good enough for input
            i++;
            col++;
            const cap = capacityForCurrent();
            if (cap <= 0) {
                // No room at all, spill entirely to next line
                lines++;
                usedFirst = true;
                col = 1; // current char consumed
                continue;
            }
            if (col > cap) {
                lines++;
                usedFirst = true;
                col = 1; // current char starts next line
            }
        }
        return Math.max(1, lines);
    };
    const _availFirst = showRightPlaceholder
        ? Math.max(0, innerWidthCells - rightPlaceholderLen - rightPlaceholderPad)
        : innerWidthCells;
    const measureExitLineRight = (() => {
        if (promptActive) {
            if (promptValue.length > 0)
                return `${promptValue} `; // caret occupies a cell
            const fileLabel = (currentChange === null || currentChange === void 0 ? void 0 : currentChange.path)
                ? currentChange.path.split("/").pop() || "this file"
                : "this file";
            const escHint = !vimEnabled || mode === "normal" ? " (Esc cancel)" : "";
            return `For ${fileLabel}${escHint}`;
        }
        return commandBuffer.length > 0 ? commandBuffer : "Add a follow-up";
    })();
    const measureLeftContent = measureExitLineRight;
    const rightFixedPadCols = 2;
    const arrowCols = 3; // " → "
    const contentAreaWidth = Math.max(0, innerWidthCells - rightFixedPadCols - arrowCols);
    const inputLineCount = countWrappedInputLines(measureLeftContent, 
    // First line may reserve space for right placeholder
    showRightPlaceholder
        ? Math.max(0, contentAreaWidth - rightPlaceholderLen - rightPlaceholderPad + 2)
        : contentAreaWidth, contentAreaWidth);
    // Reserve space for: input lines, top+bottom borders, footer info, and optional feedback line
    const bottomReservedLines = inputLineCount + 4 + (feedback ? 1 : 0);
    const topReservedLines = 1; // static header at the top
    const reservedLines = currentChange ? bottomReservedLines : 0;
    const contentHeightRaw = (((_c = screen === null || screen === void 0 ? void 0 : screen.height) !== null && _c !== void 0 ? _c : stdout === null || stdout === void 0 ? void 0 : stdout.rows) || 24) - reservedLines - topReservedLines;
    const contentHeight = Math.max(1, contentHeightRaw);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        const c = currentChange;
        if (!c)
            return;
        if (!highlightReady)
            return; // wait until after first paint/interaction
        const path = c.path;
        const lang = (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .inferLanguageFromPath */ .Ak)(path);
        const gate = gateForChange(c);
        if (gate.gated)
            return;
        const pendingKey = `${path}|${isLightTheme ? "L" : "D"}`;
        if (highlightCache[path] ||
            computingRef.current.has(path) ||
            highlightPendingRef.current.has(pendingKey))
            return;
        computingRef.current.add(path);
        const p = (() => __awaiter(void 0, void 0, void 0, function* () {
            try {
                const t0 = Date.now();
                // dynamic import shiki to avoid cost if not needed
                const codeToTokens = yield getCodeToTokens();
                perf("import.shiki", { durMs: Date.now() - t0 });
                if (c.after === undefined) {
                    setHighlightEntry(path, {
                        lines: ["[deleted]"],
                        kinds: ["removed"],
                        total: 1,
                    });
                    return;
                }
                if (c.before === undefined) {
                    const afterTokens = (yield codeToTokens(c.after, {
                        lang,
                        theme: isLightTheme ? "light-plus" : "github-dark-default",
                    }));
                    const lines = afterTokens.tokens.map((lineTokens, idx) => {
                        const afterNum = `\x1b[2m${(idx + 1)
                            .toString()
                            .padStart(4, " ")}\x1b[0m`;
                        const content = lineTokens
                            .map(t => `${fg(t.color)}${bg(t.bgColor)}${t.content}\x1b[0m`)
                            .join("");
                        return `${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}\x1b[2m \x1b[0m ${content}`;
                    });
                    const kinds = new Array(lines.length).fill("added");
                    setHighlightEntry(path, { lines, kinds, total: lines.length });
                    return;
                }
                // modified file diff
                const shikiTheme = isLightTheme ? "light-plus" : "github-dark-default";
                let diffEntry = diffCacheRef.current.get(path);
                if (!diffEntry) {
                    const diffLines = createDiffLines(c.before, c.after);
                    const contextLines = computeContextLines(diffLines);
                    const filtered = filterDiffLinesWithContext(diffLines, contextLines);
                    diffEntry = { diffLines, filtered, contextLines };
                    diffCacheRef.current.set(path, diffEntry);
                }
                const { filtered } = diffEntry;
                const afterIdxsRaw = [];
                const beforeIdxsRaw = [];
                for (const l of filtered) {
                    if (l.afterLineNumber != null)
                        afterIdxsRaw.push(l.afterLineNumber - 1);
                    if (l.beforeLineNumber != null)
                        beforeIdxsRaw.push(l.beforeLineNumber - 1);
                }
                const afterIdxs = [];
                const beforeIdxs = [];
                const seenA = new Set();
                const seenB = new Set();
                for (const i of afterIdxsRaw)
                    if (!seenA.has(i)) {
                        seenA.add(i);
                        afterIdxs.push(i);
                    }
                for (const i of beforeIdxsRaw)
                    if (!seenB.has(i)) {
                        seenB.add(i);
                        beforeIdxs.push(i);
                    }
                const afterLinesAll = c.after.split(/\r?\n/);
                const beforeLinesAll = c.before.split(/\r?\n/);
                const afterSlice = afterIdxs
                    .map(i => { var _a; return (_a = afterLinesAll[i]) !== null && _a !== void 0 ? _a : ""; })
                    .join("\n");
                const beforeSlice = beforeIdxs
                    .map(i => { var _a; return (_a = beforeLinesAll[i]) !== null && _a !== void 0 ? _a : ""; })
                    .join("\n");
                const mapAfter = new Map();
                const mapBefore = new Map();
                for (let i = 0; i < afterIdxs.length; i++)
                    mapAfter.set(afterIdxs[i] + 1, i + 1);
                for (let i = 0; i < beforeIdxs.length; i++)
                    mapBefore.set(beforeIdxs[i] + 1, i + 1);
                let beforeTokens = null;
                let afterTokens = null;
                let durTotal = 0;
                yield idle();
                if (afterIdxs.length > 0) {
                    const tA = Date.now();
                    afterTokens = (yield codeToTokens(afterSlice, {
                        lang,
                        theme: shikiTheme,
                    }));
                    durTotal += Date.now() - tA;
                }
                yield idle();
                if (beforeIdxs.length > 0) {
                    const tB = Date.now();
                    beforeTokens = (yield codeToTokens(beforeSlice, {
                        lang,
                        theme: shikiTheme,
                    }));
                    durTotal += Date.now() - tB;
                }
                perf("shiki.tokens", { path, durMs: durTotal });
                const kinds = new Array(filtered.length);
                const lines = filtered.map((l, idx) => {
                    var _a;
                    // Double line numbers (dim)
                    const beforeNumRaw = l.beforeLineNumber
                        ? l.beforeLineNumber.toString().padStart(4, " ")
                        : "    ";
                    const afterNumRaw = l.afterLineNumber
                        ? l.afterLineNumber.toString().padStart(4, " ")
                        : "    ";
                    const beforeNum = `\x1b[2m${beforeNumRaw}\x1b[0m`;
                    const afterNum = `\x1b[2m${afterNumRaw}\x1b[0m`;
                    let tokensToRender;
                    if (l.type === "common" && l.afterLineNumber && afterTokens) {
                        const mi = mapAfter.get(l.afterLineNumber);
                        if (mi && mi - 1 >= 0 && mi - 1 < afterTokens.tokens.length)
                            tokensToRender = afterTokens.tokens[mi - 1];
                    }
                    else if (l.type === "added" && l.afterLineNumber && afterTokens) {
                        const mi = mapAfter.get(l.afterLineNumber);
                        if (mi && mi - 1 >= 0 && mi - 1 < afterTokens.tokens.length)
                            tokensToRender = afterTokens.tokens[mi - 1];
                    }
                    else if (l.type === "removed" &&
                        l.beforeLineNumber &&
                        beforeTokens) {
                        const mi = mapBefore.get(l.beforeLineNumber);
                        if (mi && mi - 1 >= 0 && mi - 1 < beforeTokens.tokens.length)
                            tokensToRender = beforeTokens.tokens[mi - 1];
                    }
                    if (!tokensToRender)
                        tokensToRender = [{ content: l.content }];
                    const applyBgTint = (token) => {
                        // For added/removed rows, avoid per-token backgrounds entirely to
                        // keep the row background continuous.
                        if (l.type === "added" || l.type === "removed")
                            return "";
                        return bg(token.bgColor);
                    };
                    const rendered = tokensToRender
                        .map(t => `${fg(t.color)}${applyBgTint(t)}${t.content}\x1b[0m`)
                        .join("");
                    switch (l.type) {
                        case "added":
                            kinds[idx] = "added";
                            return `${beforeNum} ${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}${signFgAdd}+${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RESET */ .Sj} ${rendered}`;
                        case "removed":
                            kinds[idx] = "removed";
                            return `${beforeNum} ${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}${signFgRemove}-${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RESET */ .Sj} ${rendered}`;
                        case "gap":
                            kinds[idx] = "other";
                            return `${beforeNum} ${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}\x1b[2m⋯ ${(_a = l.gapCount) !== null && _a !== void 0 ? _a : 0} lines truncated ⋯\x1b[0m`;
                        default:
                            kinds[idx] = l.type === "common" ? "other" : "other";
                            return `${beforeNum} ${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}\x1b[2m \x1b[0m ${rendered}`;
                    }
                });
                const tSet = Date.now();
                setHighlightEntry(path, { lines, kinds, total: lines.length });
                perf("shiki.cacheSet", {
                    path,
                    durMs: Date.now() - tSet,
                    lines: lines.length,
                });
            }
            catch (_err) {
                // fallback to plain precomputed variant
                computingRef.current.delete(path);
            }
            finally {
                computingRef.current.delete(path);
            }
        }))();
        highlightPendingRef.current.set(pendingKey, p);
        p.finally(() => highlightPendingRef.current.delete(pendingKey)).catch(() => highlightPendingRef.current.delete(pendingKey));
    }, [
        currentChange,
        createDiffLines,
        isLightTheme,
        getCodeToTokens,
        highlightReady,
        highlightCache[currentChange === null || currentChange === void 0 ? void 0 : currentChange.path],
        bg,
        computeContextLines,
        fg,
        filterDiffLinesWithContext,
        gateForChange,
        idle,
        perf,
        setHighlightEntry,
        signFgAdd,
        signFgRemove,
    ]);
    const preloadHighlight = (c) => {
        if (!highlightReady)
            return;
        const path = c.path;
        const pendingKey = `${path}|${isLightTheme ? "L" : "D"}`;
        if (highlightCache[path] ||
            computingRef.current.has(path) ||
            highlightPendingRef.current.has(pendingKey))
            return;
        const gate = gateForChange(c);
        if (gate.gated)
            return;
        computingRef.current.add(path);
        void (() => __awaiter(void 0, void 0, void 0, function* () {
            try {
                const t0 = Date.now();
                const codeToTokens = yield getCodeToTokens();
                perf("import.shiki.preload", { durMs: Date.now() - t0 });
                const lang = (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .inferLanguageFromPath */ .Ak)(path);
                if (c.after === undefined) {
                    setHighlightEntry(path, {
                        lines: ["[deleted]"],
                        kinds: ["removed"],
                        total: 1,
                    });
                    return;
                }
                if (c.before === undefined) {
                    const tTok0 = Date.now();
                    const afterTokens = (yield codeToTokens(c.after, {
                        lang,
                        theme: isLightTheme ? "light-plus" : "github-dark-default",
                    }));
                    perf("shiki.tokens.preload", { path, durMs: Date.now() - tTok0 });
                    const lines = afterTokens.tokens.map((lineTokens, idx) => {
                        const afterNum = (idx + 1).toString().padStart(4, " ");
                        const content = lineTokens
                            .map((t) => `${fg(t.color)}${bg(t.bgColor)}${t.content}\x1b[0m`)
                            .join("");
                        return `${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}\x1b[2m \x1b[0m ${content}`;
                    });
                    const kinds = new Array(lines.length).fill("added");
                    const tSet = Date.now();
                    setHighlightEntry(path, { lines, kinds, total: lines.length });
                    perf("shiki.cacheSet.preload", {
                        path,
                        durMs: Date.now() - tSet,
                        lines: lines.length,
                    });
                    return;
                }
                const shikiTheme = isLightTheme ? "light-plus" : "github-dark-default";
                let diffEntry = diffCacheRef.current.get(path);
                if (!diffEntry) {
                    const diffLines = createDiffLines(c.before, c.after);
                    const contextLines = computeContextLines(diffLines);
                    const filtered = filterDiffLinesWithContext(diffLines, contextLines);
                    diffEntry = { diffLines, filtered, contextLines };
                    diffCacheRef.current.set(path, diffEntry);
                }
                const { filtered } = diffEntry;
                const afterIdxsRaw = [];
                const beforeIdxsRaw = [];
                for (const l of filtered) {
                    if (l.afterLineNumber != null)
                        afterIdxsRaw.push(l.afterLineNumber - 1);
                    if (l.beforeLineNumber != null)
                        beforeIdxsRaw.push(l.beforeLineNumber - 1);
                }
                const afterIdxs = [];
                const beforeIdxs = [];
                const seenA = new Set();
                const seenB = new Set();
                for (const i of afterIdxsRaw)
                    if (!seenA.has(i)) {
                        seenA.add(i);
                        afterIdxs.push(i);
                    }
                for (const i of beforeIdxsRaw)
                    if (!seenB.has(i)) {
                        seenB.add(i);
                        beforeIdxs.push(i);
                    }
                const afterLinesAll = c.after.split(/\r?\n/);
                const beforeLinesAll = c.before.split(/\r?\n/);
                const afterSlice = afterIdxs
                    .map(i => { var _a; return (_a = afterLinesAll[i]) !== null && _a !== void 0 ? _a : ""; })
                    .join("\n");
                const beforeSlice = beforeIdxs
                    .map(i => { var _a; return (_a = beforeLinesAll[i]) !== null && _a !== void 0 ? _a : ""; })
                    .join("\n");
                const mapAfter = new Map();
                const mapBefore = new Map();
                for (let i = 0; i < afterIdxs.length; i++)
                    mapAfter.set(afterIdxs[i] + 1, i + 1);
                for (let i = 0; i < beforeIdxs.length; i++)
                    mapBefore.set(beforeIdxs[i] + 1, i + 1);
                let beforeTokens = null;
                let afterTokens = null;
                let durTotal = 0;
                yield idle();
                if (afterIdxs.length > 0) {
                    const tA = Date.now();
                    afterTokens = (yield codeToTokens(afterSlice, {
                        lang,
                        theme: shikiTheme,
                    }));
                    durTotal += Date.now() - tA;
                }
                yield idle();
                if (beforeIdxs.length > 0) {
                    const tB = Date.now();
                    beforeTokens = (yield codeToTokens(beforeSlice, {
                        lang,
                        theme: shikiTheme,
                    }));
                    durTotal += Date.now() - tB;
                }
                perf("shiki.tokens.preload", { path, durMs: durTotal });
                const kinds = new Array(filtered.length);
                const lines = filtered.map((l, idx) => {
                    var _a;
                    const beforeNum = l.beforeLineNumber
                        ? l.beforeLineNumber.toString().padStart(4, " ")
                        : "    ";
                    const afterNum = l.afterLineNumber
                        ? l.afterLineNumber.toString().padStart(4, " ")
                        : "    ";
                    let tokensToRender;
                    if (l.type === "common" && l.afterLineNumber && afterTokens) {
                        const mi = mapAfter.get(l.afterLineNumber);
                        if (mi && mi - 1 >= 0 && mi - 1 < afterTokens.tokens.length)
                            tokensToRender = afterTokens.tokens[mi - 1];
                    }
                    else if (l.type === "added" && l.afterLineNumber && afterTokens) {
                        const mi = mapAfter.get(l.afterLineNumber);
                        if (mi && mi - 1 >= 0 && mi - 1 < afterTokens.tokens.length)
                            tokensToRender = afterTokens.tokens[mi - 1];
                    }
                    else if (l.type === "removed" &&
                        l.beforeLineNumber &&
                        beforeTokens) {
                        const mi = mapBefore.get(l.beforeLineNumber);
                        if (mi && mi - 1 >= 0 && mi - 1 < beforeTokens.tokens.length)
                            tokensToRender = beforeTokens.tokens[mi - 1];
                    }
                    if (!tokensToRender)
                        tokensToRender = [{ content: l.content }];
                    const applyBgTint = (token) => {
                        if (l.type === "added" || l.type === "removed")
                            return "";
                        return bg(token.bgColor);
                    };
                    const rendered = tokensToRender
                        .map(t => `${fg(t.color)}${applyBgTint(t)}${t.content}\x1b[0m`)
                        .join("");
                    switch (l.type) {
                        case "added":
                            kinds[idx] = "added";
                            return `${beforeNum} ${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_GREEN */ .ki}+${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RESET */ .Sj} ${rendered}`;
                        case "removed":
                            kinds[idx] = "removed";
                            return `${beforeNum} ${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RED */ .s0}-${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RESET */ .Sj} ${rendered}`;
                        case "gap":
                            kinds[idx] = "other";
                            return `${beforeNum} ${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}\x1b[2m⋯ ${(_a = l.gapCount) !== null && _a !== void 0 ? _a : 0} lines truncated ⋯\x1b[0m`;
                        default:
                            kinds[idx] = "other";
                            return `${beforeNum} ${afterNum} ${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW}\x1b[2m \x1b[0m ${rendered}`;
                    }
                });
                const tSet = Date.now();
                setHighlightEntry(path, { lines, kinds, total: lines.length });
                perf("shiki.cacheSet.preload", {
                    path,
                    durMs: Date.now() - tSet,
                    lines: lines.length,
                });
            }
            catch (_a) {
            }
            finally {
                computingRef.current.delete(path);
            }
        }))();
    };
    const { cursorOffset: promptCursorOffset } = (0,_hooks_use_text_input_js__WEBPACK_IMPORTED_MODULE_10__/* .useTextInput */ .t)(promptValue, setPromptValue, {
        focus: promptActive,
        showCursor: true,
        highlightPastedText: false,
        allowExplicitNewline: false,
        onSubmit: v => {
            const vv = v.trim();
            if (vv.length > 0 && currentChange) {
                const s = concat.sections[selectedIndex];
                const top = lastViewportTopRef.current;
                if (s) {
                    const visTop = Math.max(s.start, top);
                    const visBot = Math.min(s.end - 1, top + contentHeight - 1);
                    const startLine = Math.max(1, visTop - s.start + 1);
                    const endLine = Math.max(startLine, visBot - s.start + 1);
                    const msg = (0,_utils_prompt_utils_js__WEBPACK_IMPORTED_MODULE_14__/* .formatReviewPrompt */ .C)(currentChange.path, vv, {
                        startLine,
                        endLine,
                    });
                    if (pendingDecisions.length > 0) {
                        for (const d of pendingDecisions)
                            rejectPendingDecision(d.id, "auto-rejected before follow-up");
                    }
                    onSubmitPrompt(msg);
                    setFeedback(chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim(formatFollowUpFeedback(msg, vv)));
                    if (feedbackTimerRef.current)
                        clearTimeout(feedbackTimerRef.current);
                    feedbackTimerRef.current = setTimeout(() => setFeedback(null), 1800);
                    setPromptValue("");
                }
                else {
                    const msg = (0,_utils_prompt_utils_js__WEBPACK_IMPORTED_MODULE_14__/* .formatReviewPrompt */ .C)(currentChange.path, vv);
                    if (pendingDecisions.length > 0) {
                        for (const d of pendingDecisions)
                            rejectPendingDecision(d.id, "auto-rejected before follow-up");
                    }
                    onSubmitPrompt(msg);
                    setFeedback(chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim(formatFollowUpFeedback(msg, vv)));
                    if (feedbackTimerRef.current)
                        clearTimeout(feedbackTimerRef.current);
                    feedbackTimerRef.current = setTimeout(() => setFeedback(null), 1800);
                    setPromptValue("");
                }
            }
            else {
                return;
            }
        },
        onCtrlC: () => {
            setPromptValue("");
            setPromptActive(false);
        },
    });
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        return () => {
            if (feedbackTimerRef.current)
                clearTimeout(feedbackTimerRef.current);
        };
    }, []);
    // keep/undo modal flow removed
    const goToFile = (nextIndex) => {
        const n = changes.length;
        if (n === 0)
            return;
        const wrapped = ((nextIndex % n) + n) % n;
        setSelectedIndex(wrapped);
        setReviewSelectedIndex(wrapped);
    };
    const enableCtrlCQuit = "darwin" !== "win32"; // avoid clobbering copy on Windows
    (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useInput */ .Ge)((input, key) => {
        if (!highlightReady)
            setHighlightReady(true);
        if (promptActive) {
            // Ctrl+R exits review immediately even if prompt is active
            if ((key.ctrl && (input === "r" || input === "R")) ||
                input === "\u0012") {
                onExit();
                return;
            }
            if (key.escape) {
                if (vimEnabled) {
                    if (mode === "normal") {
                        setPromptValue("");
                        setPromptActive(false);
                    }
                }
                else {
                    setPromptValue("");
                    setPromptActive(false);
                }
                return;
            }
            if (key.return) {
                const vv = promptValue.trim();
                if (vv.length === 0)
                    return;
                return;
            }
            if (enableCtrlCQuit && key.ctrl && input === "c") {
                setPromptValue("");
                setPromptActive(false);
                return;
            }
            return;
        }
        // Ctrl+R exits review mode
        if ((key.ctrl && (input === "r" || input === "R")) || input === "\u0012") {
            onExit();
            return;
        }
        if (input === "i") {
            setCommandBuffer("");
            setPromptValue("");
            setPromptActive(true);
            setShowHelp(false);
            setMode("insert");
            return;
        }
        if (key.return) {
            setCommandBuffer("");
            setPromptValue("");
            setPromptActive(true);
            setShowHelp(false);
            setMode("insert");
            return;
        }
        if (showHelp &&
            (input === "q" ||
                (enableCtrlCQuit && key.ctrl && input === "c") ||
                key.escape ||
                key.backspace)) {
            setShowHelp(false);
            return;
        }
        if (key.escape ||
            input === "q" ||
            (enableCtrlCQuit && key.ctrl && input === "c")) {
            onExit();
            return;
        }
        if (input === "?") {
            setShowHelp(prev => !prev);
            return;
        }
        if ((key.tab || input === "\t") && !promptActive) {
            const next = (selectedIndex + 1) % changes.length;
            goToFile(next);
            return;
        }
        if (((key.shift && (key.tab || input === "\t")) || input === "\x1b[Z") &&
            !promptActive) {
            const prev = selectedIndex - 1 < 0 ? changes.length - 1 : selectedIndex - 1;
            goToFile(prev);
            return;
        }
        // Vim-style file navigation
        if ((input === "h" || input === "H") && !promptActive) {
            const prev = selectedIndex - 1 < 0 ? changes.length - 1 : selectedIndex - 1;
            goToFile(prev);
            return;
        }
        if ((input === "l" || input === "L") && !promptActive) {
            const next = (selectedIndex + 1) % changes.length;
            goToFile(next);
            return;
        }
        // Disable keep/undo staging via A/Z for now
        if (key.leftArrow) {
            const prev = selectedIndex - 1 < 0 ? changes.length - 1 : selectedIndex - 1;
            goToFile(prev);
            return;
        }
        if (key.rightArrow) {
            const next = (selectedIndex + 1) % changes.length;
            goToFile(next);
            return;
        }
    });
    // promptLineRight is computed on demand to avoid ordering issues
    const pagerRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    return currentChange ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(PagerFileView, { ref: pagerRef, contentHeight: contentHeight, totalLines: currentTotalLines, topHeaderLeft: `${changes.length} ${changes.length === 1 ? "file" : "files"} edited`, topHeaderRight: "esc when done", precomputedLines: concat.lines, precomputedKinds: concat.kinds, sections: concat.sections.map(s => ({
            start: s.start,
            end: s.end,
            defaultKind: s.defaultKind,
        })), activeSectionIndex: selectedIndex, commandBuffer: commandBuffer, onCommandBufferChange: setCommandBuffer, inputDisabled: false, wrapLines: wrapLines, wrapDeferRest: !wrapReady, overlayTitle: usingOverlayHelp ? "Help" : undefined, overlayLines: usingOverlayHelp ? helpModalLines : null, onViewportTopChange: top => {
            lastViewportTopRef.current = top;
            const bottom = top + contentHeight;
            for (let i = 0; i < concat.sections.length; i++) {
                const s = concat.sections[i];
                if (s.start < bottom + 5 && s.end > top - 5) {
                    const ch = changes[i];
                    const p = ch === null || ch === void 0 ? void 0 : ch.path;
                    if (p)
                        ensurePrecomputed(ch);
                    if (p &&
                        !highlightCache[p] &&
                        !computingRef.current.has(p) &&
                        !highlightPendingRef.current.has(`${p}|${isLightTheme ? "L" : "D"}`))
                        preloadHighlight(ch);
                }
            }
        }, onUserScroll: () => { }, onJumpApplied: () => {
            // no-op placeholder for now; could add analytics or feedback later
        }, bottomLines: (() => {
            var _a;
            // Middle header line is removed per design; hints move below input
            const baseHint = ` ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.white.bold("↑/↓")} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim("scroll ·")} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.white.bold("←/→")} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim("switch file")}`;
            const genHint = ` ${hexagonFrame} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.bold("Generating")}${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim("  — ")} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.white.bold("↑/↓")} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim("scroll")}`;
            const showGen = _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .TEST_FILE_REVIEW_GENERATING */ .Eo || isGenerating;
            const pendingCount = pendingDecisions.length;
            const pendingHint = pendingCount > 0
                ? ` ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow(hexagonFrame)} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow.bold("Pending decision")} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow(`(${pendingCount})`)}${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim("  — ")} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow("ctrl-r to respond")}`
                : null;
            const infoLine = `${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RESET */ .Sj}` +
                (pendingHint ? pendingHint : showGen ? genHint : baseHint) +
                `${_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .ANSI_RESET */ .Sj}`;
            const exitLineRight = promptLineRightFn();
            const symbol = "→";
            // Light theme parity with PromptBar: use dark borders on light backgrounds
            const borderActiveFn = isLightTheme ? chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.black : chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.white;
            const borderInactiveFn = chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.gray;
            // Match PromptBar prompt symbol color: use foreground, dimmed when empty
            const symbolDisplay = promptValue.length === 0
                ? borderActiveFn.dim(symbol)
                : borderActiveFn(symbol);
            const leftContent = `${exitLineRight}`;
            const strip = stripAnsi;
            const innerWidth = innerWidthCells;
            const borderFn = promptActive ? borderActiveFn : borderInactiveFn;
            const top = borderFn(`┌${"─".repeat(innerWidth)}┐`);
            const bar = borderFn("│");
            const lines = [];
            // Render feedback one line above the input box
            if (feedback) {
                lines.push(` ${feedback}`);
            }
            // Wrap the left content across available width. On the first line we may reserve space for the right placeholder.
            const wrapSegments = (() => {
                const text = leftContent;
                const segs = [];
                const ESC = 0x1b;
                let i = 0;
                let col = 0;
                let start = 0;
                let usedFirst = false;
                const capForCurrent = () => {
                    const rightPad = rightFixedPadCols; // fixed right padding
                    const arrow = arrowCols; // fixed left arrow area
                    const base = innerWidth - rightPad - arrow;
                    if (usedFirst)
                        return Math.max(0, base);
                    const firstBase = showRightPlaceholder
                        ? Math.max(0, base - rightPlaceholderLen - rightPlaceholderPad + 2)
                        : base;
                    return Math.max(0, firstBase);
                };
                while (i < text.length) {
                    const ch = text.charCodeAt(i);
                    if (ch === ESC && text[i + 1] === "[") {
                        let j = i + 2;
                        while (j < text.length && text[j] !== "m")
                            j++;
                        i = Math.min(text.length, j + 1);
                        continue;
                    }
                    i++;
                    col++;
                    const cap = capForCurrent();
                    if (cap <= 0) {
                        // No space for any left content on this line; push empty and continue
                        segs.push("");
                        usedFirst = true;
                        col = 0;
                        start = i; // drop previous content entirely
                        continue;
                    }
                    if (col > cap) {
                        segs.push(text.slice(start, i - 1));
                        usedFirst = true;
                        start = i - 1;
                        col = 1;
                    }
                }
                segs.push(text.slice(start));
                return segs;
            })();
            // Build the middle box rows
            lines.push(top);
            for (let idx = 0; idx < wrapSegments.length; idx++) {
                const seg = (_a = wrapSegments[idx]) !== null && _a !== void 0 ? _a : "";
                const segLen = strip(seg).length;
                const isFirst = idx === 0;
                const leftArrow = ` ${symbolDisplay} `; // 3 cols: leading space + arrow + space
                if (isFirst && showRightPlaceholder) {
                    const tailPad = Math.max(0, rightPlaceholderPad + rightFixedPadCols - 2);
                    const between = Math.max(0, innerWidth - arrowCols - segLen - rightPlaceholderLen - tailPad);
                    const mid = `${bar}${leftArrow}${seg}\x1b[0m${" ".repeat(between)}${rightPlaceholderLabel}${" ".repeat(tailPad)}${bar}`;
                    lines.push(mid);
                }
                else {
                    const leftPrefix = isFirst ? leftArrow : " ".repeat(arrowCols);
                    const padAfter = Math.max(0, innerWidth - arrowCols - segLen - rightFixedPadCols);
                    const mid = `${bar}${leftPrefix}${seg}\x1b[0m${" ".repeat(padAfter + rightFixedPadCols)}${bar}`;
                    lines.push(mid);
                }
            }
            const bot = borderFn(`└${"─".repeat(innerWidth)}┘`);
            const footer = infoLine;
            lines.push(bot, footer);
            return lines;
        })(), promptActive: promptActive, rowBgAdd: rowBgAdd, rowBgRemove: rowBgRemove })) : null;
};
const isCombining = (cp) => (cp >= 0x0300 && cp <= 0x036f) ||
    (cp >= 0xfe20 && cp <= 0xfe2f) ||
    cp === 0x200d ||
    (cp >= 0xfe0e && cp <= 0xfe0f);
const isFullWidth = (cp) => {
    if (cp >= 0x1100 &&
        (cp <= 0x115f ||
            cp === 0x2329 ||
            cp === 0x232a ||
            (cp >= 0x2e80 && cp <= 0xa4cf) ||
            (cp >= 0xac00 && cp <= 0xd7a3) ||
            (cp >= 0xf900 && cp <= 0xfaff) ||
            (cp >= 0xfe10 && cp <= 0xfe19) ||
            (cp >= 0xfe30 && cp <= 0xfe6f) ||
            (cp >= 0xff01 && cp <= 0xff60) ||
            (cp >= 0xffe0 && cp <= 0xffe6)))
        return true;
    return false;
};
const PagerFileView = react__WEBPACK_IMPORTED_MODULE_2__.forwardRef(({ contentHeight, totalLines, topHeaderLeft, topHeaderRight, precomputedLines, precomputedKinds, sections, activeSectionIndex, commandBuffer, onCommandBufferChange, inputDisabled, promptActive, bottomLines, wrapLines, wrapDeferRest, onViewportTopChange, onViewportStatsChange, onJumpApplied, onUserScroll, overlayTitle, overlayLines, rowBgAdd, rowBgRemove, }, ref) => {
    const [scroll, setScroll] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
    const wheelStepRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(3);
    const linesForRenderRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(precomputedLines);
    const kindsForRenderRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(precomputedKinds);
    // Compute display width accounting for ANSI, fullwidth, emojis, combining
    const stripAnsiRe = /\x1b\[[0-9;]*m/g;
    // Memoize the regex so its identity is stable across renders, preventing
    // downstream memo/effect churn that can trigger unnecessary redraws.
    const extendedPictographicRe = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(() => {
        try {
            return /\p{Extended_Pictographic}/u;
        }
        catch (_a) {
            return null;
        }
    }, []);
    const stringVisibleWidth = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((s) => {
        const stripped = s.replace(stripAnsiRe, "");
        let w = 0;
        for (const ch of stripped) {
            const cp = ch.codePointAt(0);
            if (isCombining(cp))
                continue;
            if (extendedPictographicRe === null || extendedPictographicRe === void 0 ? void 0 : extendedPictographicRe.test(ch)) {
                w += 2;
                continue;
            }
            w += isFullWidth(cp) ? 2 : 1;
        }
        return w;
    }, [extendedPictographicRe]);
    // biome-ignore lint/correctness/useExhaustiveDependencies: renderedMemo is assigned later
    const clampScroll = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((candidate) => {
        const effectiveTotal = wrapLines
            ? renderedMemo.lines.length || precomputedLines.length || totalLines
            : totalLines;
        const maxOffset = Math.max(0, effectiveTotal - contentHeight);
        return Math.min(Math.max(0, candidate), maxOffset);
    }, [wrapLines, precomputedLines.length, totalLines, contentHeight]);
    const scrollBy = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((delta) => {
        setScroll(prev => {
            const next = clampScroll(prev + delta);
            if (next !== prev) {
                onUserScroll === null || onUserScroll === void 0 ? void 0 : onUserScroll();
                return next;
            }
            return prev;
        });
    }, [clampScroll, onUserScroll]);
    // Update wheel step based on available content height
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        const step = Math.max(1, Math.floor(contentHeight / 10));
        wheelStepRef.current = step;
    }, [contentHeight]);
    (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useInput */ .Ge)((input, key) => {
        var _a, _b;
        if (inputDisabled) {
            return;
        }
        if (promptActive) {
            if (key.upArrow) {
                scrollBy(-1);
                return;
            }
            if (key.downArrow) {
                scrollBy(1);
                return;
            }
            if (key.ctrl && input === "f") {
                scrollBy(Math.max(1, contentHeight - 1));
                return;
            }
            if (key.ctrl && input === "b") {
                scrollBy(-Math.max(1, contentHeight - 1));
                return;
            }
            if (key.ctrl && input === "d") {
                scrollBy(Math.max(1, Math.floor(contentHeight / 2)));
                return;
            }
            if (key.ctrl && input === "u") {
                scrollBy(-Math.max(1, Math.floor(contentHeight / 2)));
                return;
            }
            return;
        }
        if (/^[0-9]$/.test(input)) {
            onCommandBufferChange(commandBuffer + input);
            return;
        }
        if (key.backspace || key.delete) {
            onCommandBufferChange(commandBuffer.slice(0, -1));
            return;
        }
        // Space / f / b page navigation (less-like)
        if (input === " ") {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(count * Math.max(1, contentHeight - 1));
            return;
        }
        if (input === "f") {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(count * Math.max(1, contentHeight - 1));
            return;
        }
        if (input === "b") {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(-count * Math.max(1, contentHeight - 1));
            return;
        }
        if (input === "j") {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(count);
            return;
        }
        if (input === "k") {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(-count);
            return;
        }
        if (key.upArrow) {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(-count);
            return;
        }
        if (key.downArrow) {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(count);
            return;
        }
        // Page / half-page scrolling (with optional count prefix)
        if (key.ctrl && input === "f") {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(count * Math.max(1, contentHeight - 1));
            return;
        }
        if (key.ctrl && input === "b") {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(-count * Math.max(1, contentHeight - 1));
            return;
        }
        if (key.ctrl && input === "d") {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(count * Math.max(1, Math.floor(contentHeight / 2)));
            return;
        }
        if (key.ctrl && input === "u") {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(-count * Math.max(1, Math.floor(contentHeight / 2)));
            return;
        }
        // Single line scroll with Ctrl-e / Ctrl-y
        if (key.ctrl && input === "e") {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(count);
            return;
        }
        if (key.ctrl && input === "y") {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(-count);
            return;
        }
        // PageUp/PageDown keys if available
        const kpd = key;
        if (kpd.pageDown) {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(count * Math.max(1, contentHeight - 1));
            return;
        }
        if (kpd.pageUp) {
            const count = parseInt(commandBuffer || "1", 10);
            onCommandBufferChange("");
            scrollBy(-count * Math.max(1, contentHeight - 1));
            return;
        }
        // Top / bottom navigation
        if (input === "g") {
            onCommandBufferChange("");
            setScroll(0);
            return;
        }
        if (input === "G") {
            const count = parseInt(commandBuffer || "0", 10);
            onCommandBufferChange("");
            if (count > 0) {
                const targetTop = count - 1;
                setScroll(clampScroll(targetTop));
            }
            else {
                const effectiveTotal = wrapLines
                    ? ((_b = (_a = linesForRenderRef.current) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : totalLines)
                    : totalLines;
                setScroll(clampScroll(effectiveTotal));
            }
            return;
        }
    });
    const { stdout } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useStdout */ .t$)();
    const screen = (0,_hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_8__/* .useScreenSize */ .l)();
    const mappingRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)({
        start: [],
        count: [],
    });
    // Cache of visible widths for each rendered line (wrapped or unwrapped)
    const visibleWidthsRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)([]);
    const renderedMemo = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        var _a, _b, _c, _d, _e, _f;
        if (!wrapLines) {
            const n = precomputedLines.length;
            const start = new Array(n);
            const count = new Array(n);
            for (let i = 0; i < n; i++) {
                start[i] = i;
                count[i] = 1;
            }
            return {
                lines: precomputedLines,
                kinds: precomputedKinds,
                start,
                count,
            };
        }
        const width = Math.max(1, ((_b = (_a = screen === null || screen === void 0 ? void 0 : screen.width) !== null && _a !== void 0 ? _a : stdout === null || stdout === void 0 ? void 0 : stdout.columns) !== null && _b !== void 0 ? _b : 80) - 4); // account for borders + inner margins
        const out = [];
        const outKinds = [];
        const start = new Array(precomputedLines.length);
        const count = new Array(precomputedLines.length);
        let renderedIndex = 0;
        const activeSection = sections[activeSectionIndex] || {
            start: 0,
            end: 0,
        };
        // Hoist helpers/regexes used inside the per-line loop
        const stripAnsiFn = (s) => s.replace(/\x1b\[[0-9;]*m/g, "");
        const gapCount = Math.max(1, _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DIFF_SPACER */ .rW.length);
        const reModified = new RegExp(`^\\s*\\d{4}\\s\\d{4}\\s{${gapCount}}(?:[+-]\\s)?`);
        const reCreated = new RegExp(`^\\s{5}\\d{4}\\s{${gapCount}}`);
        // We need index while iterating, so use classic for
        for (let li = 0; li < precomputedLines.length; li++) {
            const line = precomputedLines[li];
            start[li] = renderedIndex;
            let produced = 0;
            const inActive = li >= activeSection.start && li < activeSection.end;
            if (wrapDeferRest && !inActive) {
                out.push(line);
                outKinds.push((_c = precomputedKinds[li]) !== null && _c !== void 0 ? _c : "other");
                produced++;
                renderedIndex++;
                count[li] = produced;
                continue;
            }
            if (line.length === 0) {
                out.push("");
                outKinds.push((_d = precomputedKinds[li]) !== null && _d !== void 0 ? _d : "other");
                produced++;
                renderedIndex++;
                count[li] = produced;
                continue;
            }
            // Compute visible column where content starts, based on our line format:
            // "bbbb aaaa  [+/- ] content" or for created: "     aaaa  content"
            // Respect the DIFF_SPACER width instead of hard-coding gaps
            const visible = stripAnsiFn(line);
            let contentStartCol = null;
            const m1 = visible.match(reModified);
            if (m1)
                contentStartCol = m1[0].length;
            if (contentStartCol == null) {
                const m2 = visible.match(reCreated); // created file format
                if (m2)
                    contentStartCol = m2[0].length;
            }
            if (contentStartCol == null)
                contentStartCol = 12; // conservative fallback
            const extraWrapPad = 2; // additional padding for wrapped lines
            const indentPrefix = " ".repeat(contentStartCol + extraWrapPad);
            const indentWidth = contentStartCol + extraWrapPad;
            const contentWidthAfterIndent = Math.max(1, width - indentWidth);
            let i = 0;
            let segStart = 0;
            let col = 0;
            let active = "";
            let segPrefix = "";
            let usedIndent = false;
            let lastSpaceRaw = -1;
            let lastSpaceCol = -1;
            // Helper to compute width at code unit offset i while preserving raw indices
            const charWidthAt = (src, idx) => {
                const ch1 = src.charCodeAt(idx);
                if (Number.isNaN(ch1))
                    return { advance: 1, w: 0, isSpace: false };
                // ANSI CSI start
                if (ch1 === 0x1b && src.charCodeAt(idx + 1) === 0x5b) {
                    let j = idx + 2;
                    while (j < src.length && src[j] !== "m")
                        j++;
                    return {
                        advance: Math.min(src.length - idx, j - idx + 1),
                        w: 0,
                        isSpace: false,
                    };
                }
                // Surrogate pair
                const isHigh = ch1 >= 0xd800 && ch1 <= 0xdbff;
                let advance = 1;
                let cp = ch1;
                if (isHigh && idx + 1 < src.length) {
                    const low = src.charCodeAt(idx + 1);
                    if (low >= 0xdc00 && low <= 0xdfff) {
                        advance = 2;
                        cp = 0x10000 + ((ch1 - 0xd800) << 10) + (low - 0xdc00);
                    }
                }
                if (cp === 0x20)
                    return { advance, w: 1, isSpace: true };
                if (isCombining(cp) || cp === 0x200d)
                    return { advance, w: 0, isSpace: false };
                if (isFullWidth(cp))
                    return { advance, w: 2, isSpace: false };
                const charStr = src.slice(idx, idx + advance);
                if (extendedPictographicRe === null || extendedPictographicRe === void 0 ? void 0 : extendedPictographicRe.test(charStr))
                    return { advance, w: 2, isSpace: false };
                return { advance, w: 1, isSpace: false };
            };
            while (i < line.length) {
                if (line[i] === "\x1b" && line[i + 1] === "[") {
                    let j = i + 2;
                    while (j < line.length && line[j] !== "m")
                        j++;
                    if (j < line.length) {
                        const code = line.slice(i, j + 1);
                        if (code === "\x1b[0m")
                            active = "";
                        else
                            active += code;
                        i = j + 1;
                        continue;
                    }
                    else {
                        break;
                    }
                }
                const { advance, w: wch, isSpace } = charWidthAt(line, i);
                i += advance;
                col += wch;
                if (isSpace) {
                    lastSpaceRaw = i;
                    lastSpaceCol = col;
                }
                const currentWidth = usedIndent ? contentWidthAfterIndent : width;
                if (col >= currentWidth) {
                    const cutRaw = lastSpaceRaw > segStart ? lastSpaceRaw : i;
                    const consumed = lastSpaceRaw > segStart ? lastSpaceCol : currentWidth;
                    out.push(`${segPrefix + line.slice(segStart, cutRaw)}\x1b[0m`);
                    outKinds.push((_e = precomputedKinds[li]) !== null && _e !== void 0 ? _e : "other");
                    produced++;
                    segStart = cutRaw;
                    col -= consumed;
                    segPrefix = indentPrefix + active;
                    usedIndent = true;
                    lastSpaceRaw = -1;
                    lastSpaceCol = -1;
                    renderedIndex++;
                }
            }
            if (segStart < line.length) {
                out.push(`${segPrefix + line.slice(segStart)}\x1b[0m`);
                outKinds.push((_f = precomputedKinds[li]) !== null && _f !== void 0 ? _f : "other");
                produced++;
                renderedIndex++;
            }
            count[li] = produced;
        }
        return { lines: out, kinds: outKinds, start, count };
    }, [
        precomputedLines,
        precomputedKinds,
        wrapLines,
        wrapDeferRest,
        activeSectionIndex,
        sections,
        screen === null || screen === void 0 ? void 0 : screen.width,
        stdout === null || stdout === void 0 ? void 0 : stdout.columns,
        extendedPictographicRe,
    ]);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        mappingRef.current = {
            start: renderedMemo.start,
            count: renderedMemo.count,
        };
    }, [renderedMemo]);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        var _a;
        linesForRenderRef.current = wrapLines
            ? renderedMemo.lines
            : precomputedLines;
        kindsForRenderRef.current = wrapLines
            ? ((_a = renderedMemo.kinds) !== null && _a !== void 0 ? _a : [])
            : precomputedKinds;
        // Only clamp scroll if it's actually out of bounds to prevent jittering
        setScroll(s => {
            const clamped = clampScroll(s);
            return clamped !== s ? clamped : s;
        });
    }, [
        renderedMemo,
        precomputedLines,
        precomputedKinds,
        wrapLines,
        clampScroll,
    ]);
    // Precompute visible widths for all lines once per render-set so scroll doesn't recompute them
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        var _a;
        const lines = wrapLines ? renderedMemo.lines : precomputedLines;
        const widths = new Array(lines.length);
        for (let i = 0; i < lines.length; i++) {
            widths[i] = stringVisibleWidth((_a = lines[i]) !== null && _a !== void 0 ? _a : "");
        }
        visibleWidthsRef.current = widths;
    }, [renderedMemo, precomputedLines, wrapLines, stringVisibleWidth]);
    const sectionWrappedBounds = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        var _a, _b, _c;
        const start = new Array(sections.length);
        const end = new Array(sections.length);
        if (wrapLines) {
            for (let i = 0; i < sections.length; i++) {
                const s = sections[i];
                start[i] = (_a = renderedMemo.start[s.start]) !== null && _a !== void 0 ? _a : 0;
                end[i] =
                    ((_b = renderedMemo.start[s.end - 1]) !== null && _b !== void 0 ? _b : 0) +
                        ((_c = renderedMemo.count[s.end - 1]) !== null && _c !== void 0 ? _c : 1);
            }
        }
        else {
            for (let i = 0; i < sections.length; i++) {
                const s = sections[i];
                start[i] = s.start;
                end[i] = s.end;
            }
        }
        const total = wrapLines
            ? renderedMemo.lines.length
            : precomputedLines.length;
        return { start, end, total };
    }, [sections, wrapLines, renderedMemo, precomputedLines]);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        onViewportTopChange === null || onViewportTopChange === void 0 ? void 0 : onViewportTopChange(scroll);
        const total = sectionWrappedBounds.total;
        const startWrapped = sectionWrappedBounds.start;
        const endWrapped = sectionWrappedBounds.end;
        const top = scroll;
        const bottom = Math.min(top + contentHeight, total);
        const vis = new Array(sections.length).fill(0);
        for (let i = 0; i < sections.length; i++) {
            const ov = Math.max(0, Math.min(endWrapped[i], bottom) - Math.max(startWrapped[i], top));
            vis[i] = ov;
        }
        let dominantIndex = 0;
        let maxVal = -1;
        const center = top + contentHeight / 2;
        for (let i = 0; i < vis.length; i++) {
            const v = vis[i];
            if (v > maxVal) {
                maxVal = v;
                dominantIndex = i;
            }
            else if (v === maxVal && v > 0) {
                const ac = (startWrapped[i] + endWrapped[i]) / 2;
                const bc = (startWrapped[dominantIndex] + endWrapped[dominantIndex]) / 2;
                if (Math.abs(ac - center) < Math.abs(bc - center))
                    dominantIndex = i;
            }
        }
        onViewportStatsChange === null || onViewportStatsChange === void 0 ? void 0 : onViewportStatsChange({ top, vis, dominantIndex });
    }, [
        scroll,
        onViewportTopChange,
        onViewportStatsChange,
        sections,
        contentHeight,
        sectionWrappedBounds.end,
        sectionWrappedBounds.start,
        sectionWrappedBounds.total,
    ]);
    // Expose imperative scroll controls to the parent for precise navigation
    const scrollToSectionStart = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((idx) => {
        var _a;
        if (idx < 0 || idx >= sections.length)
            return;
        const sStart = (_a = sectionWrappedBounds.start[idx]) !== null && _a !== void 0 ? _a : 0;
        setScroll(clampScroll(sStart));
        onJumpApplied === null || onJumpApplied === void 0 ? void 0 : onJumpApplied();
    }, [sections, sectionWrappedBounds, clampScroll, onJumpApplied]);
    const scrollToSectionCenter = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((idx) => {
        var _a, _b;
        if (idx < 0 || idx >= sections.length)
            return;
        const sStart = (_a = sectionWrappedBounds.start[idx]) !== null && _a !== void 0 ? _a : 0;
        const sEnd = (_b = sectionWrappedBounds.end[idx]) !== null && _b !== void 0 ? _b : sStart;
        const sLen = Math.max(1, sEnd - sStart);
        const targetTop = Math.max(0, Math.floor(sStart + sLen / 2 - contentHeight / 2));
        setScroll(clampScroll(targetTop));
        onJumpApplied === null || onJumpApplied === void 0 ? void 0 : onJumpApplied();
    }, [
        sections,
        sectionWrappedBounds,
        contentHeight,
        clampScroll,
        onJumpApplied,
    ]);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useImperativeHandle)(ref, () => ({ scrollToSectionStart, scrollToSectionCenter }), [scrollToSectionStart, scrollToSectionCenter]);
    // Snap to newly active section after layout updates to avoid stale bounds
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        var _a;
        if (activeSectionIndex < 0 || activeSectionIndex >= sections.length)
            return;
        const sStart = (_a = sectionWrappedBounds.start[activeSectionIndex]) !== null && _a !== void 0 ? _a : 0;
        const effectiveTotal = wrapLines
            ? renderedMemo.lines.length || precomputedLines.length || totalLines
            : totalLines;
        const maxOffset = Math.max(0, effectiveTotal - contentHeight);
        const targetTop = Math.min(Math.max(0, sStart), maxOffset);
        setScroll(targetTop);
        onJumpApplied === null || onJumpApplied === void 0 ? void 0 : onJumpApplied();
    }, [
        activeSectionIndex,
        contentHeight,
        onJumpApplied,
        precomputedLines.length,
        renderedMemo.lines.length,
        sectionWrappedBounds.start[activeSectionIndex],
        sections.length,
        totalLines,
        wrapLines,
    ]);
    // Manual pager rendering (content only). Keep this effect free of frequently-changing
    // state (spinner, prompt input, bottom lines) to avoid flicker while scrolling.
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x;
        if (!stdout)
            return;
        const lines = wrapLines ? renderedMemo.lines : precomputedLines;
        const headerRows = topHeaderLeft ? 1 : 0;
        let out = "";
        // Start synchronized output block to reduce intermediate paints on slow terminals
        // Support: iTerm2, Apple Terminal, xterm (ignored if unsupported)
        out += "\x1b[?2026h"; // begin sync updates
        // Render static top header if requested
        if (headerRows === 1) {
            const width = Math.max(10, (_b = (_a = screen === null || screen === void 0 ? void 0 : screen.width) !== null && _a !== void 0 ? _a : stdout === null || stdout === void 0 ? void 0 : stdout.columns) !== null && _b !== void 0 ? _b : 80);
            const strip = (s) => s.replace(/\x1b\[[0-9;]*m/g, "");
            const left = topHeaderLeft !== null && topHeaderLeft !== void 0 ? topHeaderLeft : "";
            const right = topHeaderRight !== null && topHeaderRight !== void 0 ? topHeaderRight : "";
            const leftLen = strip(left).length;
            const rightLen = strip(right).length;
            const innerWidth = Math.max(0, width - 2);
            const padBetween = Math.max(0, innerWidth - leftLen - rightLen);
            const leftStyled = chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim(left);
            let rightStyled;
            if (/^esc(\s|$)/.test(right)) {
                const rest = right.slice(3);
                rightStyled = chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.white("esc") + chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim(rest);
            }
            else {
                rightStyled = chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.dim(right);
            }
            const line = ` ${leftStyled}${" ".repeat(padBetween)}${rightStyled} \x1b[0m`;
            out += `\x1b[1;1H\x1b[2K${line}`;
        }
        const start = scroll;
        const end = Math.min(lines.length, start + contentHeight);
        const slice = lines.slice(start, end);
        const sliceKinds = kindsForRenderRef.current.slice(start, end);
        // Hoist constant computations outside the per-row loop
        const termWidthRow = Math.max(10, (_d = (_c = screen === null || screen === void 0 ? void 0 : screen.width) !== null && _c !== void 0 ? _c : stdout === null || stdout === void 0 ? void 0 : stdout.columns) !== null && _d !== void 0 ? _d : 80);
        const stripBgRe = /\x1b\[(?:49|48;5;\d{1,3}|48;2;\d{1,3};\d{1,3};\d{1,3})m/g;
        const sgrRe = /\x1b\[[0-9;]*m/g;
        // Compute sticky header for the section currently at the top
        let stickyHeaderLine = null;
        let stickySectionIndex = null;
        for (let si = 0; si < sections.length; si++) {
            const sTop = (_e = sectionWrappedBounds.start[si]) !== null && _e !== void 0 ? _e : 0;
            const sBot = (_f = sectionWrappedBounds.end[si]) !== null && _f !== void 0 ? _f : 0; // exclusive
            if (start >= sTop && start < sBot) {
                const headerLogical = sections[si].start;
                const headerWrappedStart = (_g = mappingRef.current.start[headerLogical]) !== null && _g !== void 0 ? _g : headerLogical;
                const headerWrappedCount = (_h = mappingRef.current.count[headerLogical]) !== null && _h !== void 0 ? _h : 1;
                const _headerWrappedEndExclusive = headerWrappedStart + Math.max(1, headerWrappedCount);
                if (start > headerWrappedStart && start < sBot) {
                    stickyHeaderLine = (_j = lines[headerWrappedStart]) !== null && _j !== void 0 ? _j : null;
                    stickySectionIndex = si;
                }
                break;
            }
        }
        // Render content lines with simple 1px section margins (no borders)
        // Optimize section lookup by advancing a pointer as rows increase
        let curSectionPtr = (() => {
            var _a, _b, _c;
            // Find the first section that could contain the starting row
            let idx = 0;
            while (idx < sections.length &&
                !(start >= ((_a = sectionWrappedBounds.start[idx]) !== null && _a !== void 0 ? _a : 0) &&
                    start < ((_b = sectionWrappedBounds.end[idx]) !== null && _b !== void 0 ? _b : 0)) &&
                start >= ((_c = sectionWrappedBounds.end[idx]) !== null && _c !== void 0 ? _c : 0)) {
                idx++;
            }
            return idx;
        })();
        for (let i = 0; i < contentHeight; i++) {
            const absIndex = start + i;
            const row = headerRows + i + 1;
            // Advance pointer while current section ends before this row
            while (curSectionPtr < sections.length &&
                absIndex >= ((_k = sectionWrappedBounds.end[curSectionPtr]) !== null && _k !== void 0 ? _k : 0)) {
                curSectionPtr++;
            }
            const sectionIndex = curSectionPtr < sections.length &&
                absIndex >= ((_l = sectionWrappedBounds.start[curSectionPtr]) !== null && _l !== void 0 ? _l : 0) &&
                absIndex < ((_m = sectionWrappedBounds.end[curSectionPtr]) !== null && _m !== void 0 ? _m : 0)
                ? curSectionPtr
                : -1;
            out += `\x1b[${row};1H\x1b[2K`;
            const content = (_o = slice[i]) !== null && _o !== void 0 ? _o : "";
            let kind = (_p = sliceKinds[i]) !== null && _p !== void 0 ? _p : "other";
            // If sticky applies, render header at the very top row
            if (i === 0 &&
                stickyHeaderLine != null &&
                sectionIndex === stickySectionIndex) {
                out += stickyHeaderLine;
                out += `\x1b[${row + 1};1H\x1b[2K`;
                continue;
            }
            if (sectionIndex === -1) {
                out += content;
                continue;
            }
            // Determine if this wrapped row is part of the header block; if so, just render header
            const headerLogicalIndex = sections[sectionIndex].start;
            const hdrStartWrapped = (_q = mappingRef.current.start[headerLogicalIndex]) !== null && _q !== void 0 ? _q : headerLogicalIndex;
            const hdrCountWrapped = (_r = mappingRef.current.count[headerLogicalIndex]) !== null && _r !== void 0 ? _r : 1;
            const hdrEndWrappedExclusive = hdrStartWrapped + Math.max(1, hdrCountWrapped);
            const isHeaderRow = absIndex >= hdrStartWrapped && absIndex < hdrEndWrappedExclusive;
            if (isHeaderRow) {
                const relOffset = Math.max(0, absIndex - hdrStartWrapped);
                const headerLineContent = (_t = (_s = lines[hdrStartWrapped + relOffset]) !== null && _s !== void 0 ? _s : lines[hdrStartWrapped]) !== null && _t !== void 0 ? _t : content;
                out += headerLineContent;
                continue;
            }
            // Normal content row
            if ((kind === "other" || kind == null) && sectionIndex >= 0) {
                const sec = sections[sectionIndex];
                if ((sec === null || sec === void 0 ? void 0 : sec.defaultKind) === "added" || (sec === null || sec === void 0 ? void 0 : sec.defaultKind) === "removed") {
                    kind = sec.defaultKind;
                }
            }
            if ((kind === "added" || kind === "removed") &&
                !(((_u = sections[sectionIndex]) === null || _u === void 0 ? void 0 : _u.defaultKind) === "added")) {
                const bgSeq = kind === "added" ? rowBgAdd : rowBgRemove;
                if (!bgSeq) {
                    // Theme not resolved yet or no background available; render as-is to avoid flash
                    out += content;
                }
                else {
                    const visibleLen = (_v = visibleWidthsRef.current[absIndex]) !== null && _v !== void 0 ? _v : stringVisibleWidth(content);
                    const pad = Math.max(0, termWidthRow - visibleLen);
                    const sanitized = content.replace(stripBgRe, "");
                    const inner = sanitized.replace(sgrRe, (m) => `${m}${bgSeq}`);
                    const rendered = `${bgSeq}${inner}${" ".repeat(pad)}\x1b[0m`;
                    out += rendered;
                }
            }
            else {
                out += content;
            }
        }
        // End synchronized output block
        out += "\x1b[?2026l";
        // Use stream cork/uncork when available to minimize flushes
        try {
            (_w = stdout.cork) === null || _w === void 0 ? void 0 : _w.call(stdout);
        }
        catch (_y) { }
        stdout.write(out);
        try {
            (_x = stdout.uncork) === null || _x === void 0 ? void 0 : _x.call(stdout);
        }
        catch (_z) { }
    }, [
        stdout,
        renderedMemo,
        precomputedLines,
        scroll,
        contentHeight,
        screen,
        topHeaderLeft,
        topHeaderRight,
        rowBgAdd,
        rowBgRemove,
        sections,
        sectionWrappedBounds,
        stringVisibleWidth,
        wrapLines,
    ]);
    // Overlay and bottom UI rendering, updated frequently (spinner, prompt text, etc.).
    // This effect draws on top of the content without forcing a content redraw.
    const ovLines = overlayLines !== null && overlayLines !== void 0 ? overlayLines : [];
    const overlayVisible = ovLines.length > 0;
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        if (!stdout)
            return;
        const leftBorder = "";
        const headerRows = topHeaderLeft ? 1 : 0;
        let ovOut = "\x1b[?2026h"; // begin sync updates
        // Draw overlay if present
        if (overlayVisible) {
            const width = Math.max(10, (_b = (_a = screen === null || screen === void 0 ? void 0 : screen.width) !== null && _a !== void 0 ? _a : stdout === null || stdout === void 0 ? void 0 : stdout.columns) !== null && _b !== void 0 ? _b : 80);
            const strip = (s) => s.replace(/\x1b\[[0-9;]*m/g, "");
            const innerWidth = Math.max(24, Math.min(Math.floor(width * 0.6), 80));
            const boxHeight = ovLines.length + 3;
            const topRow = Math.max(1, Math.floor((contentHeight - boxHeight) / 2));
            const leftCol = Math.max(1, Math.floor((width - (innerWidth + 2)) / 2));
            const titleText = overlayTitle ? ` ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.bold(overlayTitle)} ` : "";
            const titleLen = strip(titleText).length;
            const titlePad = Math.max(0, innerWidth - titleLen);
            // Square corners and yellow border color
            const topBorder = `${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow("┌")}${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow(titleText)}${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow("─".repeat(titlePad))}${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow("┐")}`;
            const modalBottom = topRow + (ovLines.length + 3) - 1;
            for (let rr = topRow; rr <= modalBottom; rr++) {
                if (leftCol > 1)
                    ovOut += `\x1b[${headerRows + rr};${leftCol - 1}H `;
                const rightCol = leftCol + innerWidth + 2;
                const termWidth = (_d = (_c = screen === null || screen === void 0 ? void 0 : screen.width) !== null && _c !== void 0 ? _c : stdout === null || stdout === void 0 ? void 0 : stdout.columns) !== null && _d !== void 0 ? _d : 80;
                if (rightCol <= termWidth)
                    ovOut += `\x1b[${headerRows + rr};${rightCol}H `;
            }
            ovOut += `\x1b[${headerRows + topRow};${leftCol}H${topBorder}`;
            const emptyLine = `${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow("│")} ${" ".repeat(Math.max(0, innerWidth - 2))} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow("│")}`;
            ovOut += `\x1b[${headerRows + topRow + 1};${leftCol}H${emptyLine}`;
            let r = topRow + 2;
            for (const raw of ovLines) {
                const displayLen = strip(raw).length;
                const pad = Math.max(0, innerWidth - displayLen - 2);
                const line = `${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow("│")} ${raw}${" ".repeat(pad)} ${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow("│")}`;
                ovOut += `\x1b[${headerRows + r};${leftCol}H${line}`;
                r++;
            }
            const bot = `${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow("└")}${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay
                .yellow("─")
                .repeat(innerWidth)}${chalk__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Ay.yellow("┘")}`;
            ovOut += `\x1b[${headerRows + r};${leftCol}H${bot}`;
        }
        // Bottom lines (prompt area, hints, spinner, etc.)
        let cursorRow = headerRows + contentHeight + 1;
        for (const bl of bottomLines) {
            ovOut += `\x1b[${cursorRow};1H\x1b[2K${leftBorder}${bl}`;
            cursorRow++;
        }
        const termRows = (_f = (_e = screen === null || screen === void 0 ? void 0 : screen.height) !== null && _e !== void 0 ? _e : stdout.rows) !== null && _f !== void 0 ? _f : 24;
        for (let row = cursorRow; row <= termRows; row++) {
            ovOut += `\x1b[${row};1H\x1b[2K`;
        }
        const finalCursor = Math.min(cursorRow, termRows);
        ovOut += `\x1b[${finalCursor};1H`;
        ovOut += "\x1b[?2026l"; // end sync updates
        try {
            (_g = stdout.cork) === null || _g === void 0 ? void 0 : _g.call(stdout);
        }
        catch (_j) { }
        stdout.write(ovOut);
        try {
            (_h = stdout.uncork) === null || _h === void 0 ? void 0 : _h.call(stdout);
        }
        catch (_k) { }
    }, [
        stdout,
        // Frequently changing deps stay here to avoid touching the content area
        bottomLines,
        overlayTitle,
        screen,
        contentHeight,
        topHeaderLeft,
        overlayVisible,
        ovLines,
    ]);
    return null;
});

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/glob-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   P: () => (/* binding */ GlobToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/tool-call-header.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const GlobToolUI = ({ tool: { args, result }, }) => {
    var _a, _b;
    if (!args) {
        return null;
    }
    // Handle invalid args
    if (!args.globPattern) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: "Failed to search - Missing required parameters: globPattern" }) }));
    }
    const patternDisplay = ((_a = args.globPattern) === null || _a === void 0 ? void 0 : _a.length) > 40
        ? `...${args.globPattern.slice(-37)}`
        : args.globPattern || "";
    const pathDisplay = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .getPathDisplay */ .Kr)(args.targetDirectory || ".");
    let status = "pending";
    const caseType = (_b = result === null || result === void 0 ? void 0 : result.result) === null || _b === void 0 ? void 0 : _b.case;
    switch (caseType) {
        case undefined:
            status = "pending";
            break;
        case "error":
            status = "error";
            break;
        case "success":
            status = "success";
            break;
        default: {
            const _exhaustive = caseType;
            status = "pending";
            break;
        }
    }
    const headerName = (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__/* .resolveToolVerbByCase */ .F_)("globToolCall", status === "success") ||
        (status === "success" ? "Globbed" : "Globbing");
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__/* .ToolCallHeader */ .C, { name: headerName, primary: `"${patternDisplay}"`, status: status, note: `in ${pathDisplay}` }), (() => {
                const rr = result === null || result === void 0 ? void 0 : result.result;
                if ((rr === null || rr === void 0 ? void 0 : rr.case) === "error") {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["Error: ", rr.value.error] }) }));
                }
                return null;
            })(), (() => {
                const rr = result === null || result === void 0 ? void 0 : result.result;
                if ((rr === null || rr === void 0 ? void 0 : rr.case) === "success") {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["Found ", rr.value.totalFiles || 0, " file", (rr.value.totalFiles || 0) === 1 ? "" : "s", rr.value.clientTruncated && " (truncated)"] }) }));
                }
                return null;
            })()] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/grep-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: () => (/* binding */ GrepToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/tool-call-header.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const GrepToolUI = ({ tool: { args, result }, }) => {
    var _a, _b;
    if (!args || !args.pattern) {
        return null;
    }
    const patternDisplay = ((_a = args.pattern) === null || _a === void 0 ? void 0 : _a.length) > 40
        ? `...${args.pattern.slice(-37)}`
        : args.pattern || "";
    const pathDisplay = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .getPathDisplay */ .Kr)(args.path || "");
    let status = "pending";
    const caseType = (_b = result === null || result === void 0 ? void 0 : result.result) === null || _b === void 0 ? void 0 : _b.case;
    switch (caseType) {
        case undefined:
            status = "pending";
            break;
        case "error":
            status = "error";
            break;
        case "success":
            status = "success";
            break;
        default: {
            const _exhaustive = caseType;
            status = "pending";
            break;
        }
    }
    const headerName = (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__/* .resolveToolVerbByCase */ .F_)("grepToolCall", status === "success") ||
        (status === "success" ? "Grepped" : "Grepping");
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__/* .ToolCallHeader */ .C, { name: headerName, primary: `"${patternDisplay}"`, status: status, note: `in ${pathDisplay}` }), (() => {
                const rr = result === null || result === void 0 ? void 0 : result.result;
                if ((rr === null || rr === void 0 ? void 0 : rr.case) === "error") {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["Error: ", rr.value.error] }) }));
                }
                return null;
            })(), (() => {
                const rr = result === null || result === void 0 ? void 0 : result.result;
                if ((rr === null || rr === void 0 ? void 0 : rr.case) === "success") {
                    let totalMatches = 0;
                    const value = Object.values(rr.value.workspaceResults).at(0);
                    if (!value) {
                        return null;
                    }
                    const { result } = value;
                    if (!result.value) {
                        return null;
                    }
                    const truncated = result.value.ripgrepTruncated || result.value.clientTruncated;
                    switch (result.case) {
                        case "count":
                            totalMatches = result.value.totalMatches;
                            break;
                        case "files":
                            totalMatches = result.value.totalFiles;
                            break;
                        case "content":
                            totalMatches = result.value.totalMatchedLines;
                            break;
                    }
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["Found ", totalMatches, " matches ", truncated ? " (truncated)" : ""] }) }));
                }
                return null;
            })()] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/hexagon-loader.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _hooks_use_shared_animation_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/hooks/use-shared-animation.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




function HexagonLoader({ customInterval, activeColor = "white", inactiveColor = undefined, }) {
    const period = customInterval !== null && customInterval !== void 0 ? customInterval : _hooks_use_shared_animation_js__WEBPACK_IMPORTED_MODULE_3__/* .DEFAULT_HEXAGON_INTERVAL_MS */ .q;
    const tick = (0,_hooks_use_shared_animation_js__WEBPACK_IMPORTED_MODULE_3__/* .useSharedTick */ .e)(period);
    const frame = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => (tick % 2 === 0 ? "⬡" : "⬢"), [tick]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: tick % 2 === 1 ? activeColor : inactiveColor, children: frame }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_2__.memo)(HexagonLoader));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/highlighted-code.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   d: () => (/* binding */ HighlightedCode)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../utils/dist/index.js");
/* harmony import */ var _shikijs_langs_bash__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/shellscript.mjs");
/* harmony import */ var _shikijs_langs_c__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/c.mjs");
/* harmony import */ var _shikijs_langs_cpp__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/cpp.mjs");
/* harmony import */ var _shikijs_langs_csharp__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/csharp.mjs");
/* harmony import */ var _shikijs_langs_css__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/css.mjs");
/* harmony import */ var _shikijs_langs_dart__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/dart.mjs");
/* harmony import */ var _shikijs_langs_dockerfile__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/docker.mjs");
/* harmony import */ var _shikijs_langs_go__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/go.mjs");
/* harmony import */ var _shikijs_langs_html__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/html.mjs");
/* harmony import */ var _shikijs_langs_ini__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/ini.mjs");
/* harmony import */ var _shikijs_langs_java__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/java.mjs");
/* harmony import */ var _shikijs_langs_javascript__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/javascript.mjs");
/* harmony import */ var _shikijs_langs_json__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/json.mjs");
/* harmony import */ var _shikijs_langs_jsx__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/jsx.mjs");
/* harmony import */ var _shikijs_langs_kotlin__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/kotlin.mjs");
/* harmony import */ var _shikijs_langs_less__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/less.mjs");
/* harmony import */ var _shikijs_langs_lua__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/lua.mjs");
/* harmony import */ var _shikijs_langs_makefile__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/make.mjs");
/* harmony import */ var _shikijs_langs_markdown__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/markdown.mjs");
/* harmony import */ var _shikijs_langs_php__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/php.mjs");
/* harmony import */ var _shikijs_langs_powershell__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/powershell.mjs");
/* harmony import */ var _shikijs_langs_python__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/python.mjs");
/* harmony import */ var _shikijs_langs_r__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/r.mjs");
/* harmony import */ var _shikijs_langs_ruby__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/ruby.mjs");
/* harmony import */ var _shikijs_langs_rust__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/rust.mjs");
/* harmony import */ var _shikijs_langs_scss__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/scss.mjs");
/* harmony import */ var _shikijs_langs_sql__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/sql.mjs");
/* harmony import */ var _shikijs_langs_swift__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/swift.mjs");
/* harmony import */ var _shikijs_langs_toml__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/toml.mjs");
/* harmony import */ var _shikijs_langs_tsx__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/tsx.mjs");
/* harmony import */ var _shikijs_langs_typescript__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/typescript.mjs");
/* harmony import */ var _shikijs_langs_xml__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/xml.mjs");
/* harmony import */ var _shikijs_langs_yaml__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+langs@3.9.2/node_modules/@shikijs/langs/dist/yaml.mjs");
/* harmony import */ var _shikijs_themes_github_dark_default__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+themes@3.9.2/node_modules/@shikijs/themes/dist/github-dark-default.mjs");
/* harmony import */ var _shikijs_themes_light_plus__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+themes@3.9.2/node_modules/@shikijs/themes/dist/light-plus.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var shiki__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+core@3.7.0/node_modules/@shikijs/core/dist/index.mjs");
/* harmony import */ var shiki_engine_javascript__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__("../../node_modules/.pnpm/@shikijs+engine-javascript@3.7.0/node_modules/@shikijs/engine-javascript/dist/engine-compile.mjs");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _context_theme_context_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/context/theme-context.tsx");
/* harmony import */ var _utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/utils/color-mixing.ts");
/* harmony import */ var _utils_diff_colors_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/utils/diff-colors.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _context_theme_context_js__WEBPACK_IMPORTED_MODULE_5__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _context_theme_context_js__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};



// Popular languages











































const LineComponent = ({ lineNumber, showLineNumbers, lineNumberWidth, children, isDiff = false, rowBgHex, rowBgAnsi256Index, signChar, signColor, }) => {
    const bgStart = typeof rowBgAnsi256Index === "number"
        ? `\x1b[48;5;${rowBgAnsi256Index}m`
        : undefined;
    const bgEnd = typeof rowBgAnsi256Index === "number" ? "\x1b[49m" : undefined;
    const useTextBackground = Boolean(rowBgHex && !bgStart);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", backgroundColor: rowBgHex, flexGrow: 1, width: "100%", children: [showLineNumbers && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: lineNumberWidth + 2, borderRight: !isDiff, borderLeft: false, borderTop: false, borderBottom: false, borderColor: "gray", borderStyle: "single", justifyContent: "flex-end", flexShrink: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, backgroundColor: useTextBackground ? rowBgHex : undefined, children: [bgStart ? (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: bgStart }) : null, lineNumber.toString().padStart(lineNumberWidth, " "), " ", bgEnd ? (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: bgEnd }) : null] }) })), signChar ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: 2, flexShrink: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { backgroundColor: useTextBackground ? rowBgHex : undefined, children: [bgStart ? (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: bgStart }) : null, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: signColor, bold: true, children: signChar }), " ", bgEnd ? (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: bgEnd }) : null] }) })) : null, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: signChar ? 0 : isDiff ? 1 : 0, flexShrink: 1, flexGrow: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { backgroundColor: useTextBackground ? rowBgHex : undefined, children: [bgStart ? (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: bgStart }) : null, children, bgEnd ? (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: bgEnd }) : null] }) })] }));
};
const shiki = (0,shiki__WEBPACK_IMPORTED_MODULE_8__/* .createHighlighterCoreSync */ .gX)({
    themes: [_shikijs_themes_github_dark_default__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A, _shikijs_themes_light_plus__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A],
    langs: [
        _shikijs_langs_javascript__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A,
        _shikijs_langs_typescript__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A,
        _shikijs_langs_tsx__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A,
        _shikijs_langs_jsx__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .A,
        _shikijs_langs_json__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .A,
        _shikijs_langs_html__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .A,
        _shikijs_langs_css__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .A,
        _shikijs_langs_scss__WEBPACK_IMPORTED_MODULE_18__/* ["default"] */ .A,
        _shikijs_langs_less__WEBPACK_IMPORTED_MODULE_19__/* ["default"] */ .A,
        _shikijs_langs_bash__WEBPACK_IMPORTED_MODULE_20__/* ["default"] */ .A,
        _shikijs_langs_bash__WEBPACK_IMPORTED_MODULE_20__/* ["default"] */ .A,
        _shikijs_langs_yaml__WEBPACK_IMPORTED_MODULE_21__/* ["default"] */ .A,
        _shikijs_langs_toml__WEBPACK_IMPORTED_MODULE_22__/* ["default"] */ .A,
        _shikijs_langs_markdown__WEBPACK_IMPORTED_MODULE_23__/* ["default"] */ .A,
        _shikijs_langs_go__WEBPACK_IMPORTED_MODULE_24__/* ["default"] */ .A,
        _shikijs_langs_rust__WEBPACK_IMPORTED_MODULE_25__/* ["default"] */ .A,
        _shikijs_langs_java__WEBPACK_IMPORTED_MODULE_26__/* ["default"] */ .A,
        _shikijs_langs_c__WEBPACK_IMPORTED_MODULE_27__/* ["default"] */ .A,
        _shikijs_langs_cpp__WEBPACK_IMPORTED_MODULE_28__/* ["default"] */ .A,
        _shikijs_langs_csharp__WEBPACK_IMPORTED_MODULE_29__/* ["default"] */ .A,
        _shikijs_langs_php__WEBPACK_IMPORTED_MODULE_30__/* ["default"] */ .A,
        _shikijs_langs_ruby__WEBPACK_IMPORTED_MODULE_31__/* ["default"] */ .A,
        _shikijs_langs_swift__WEBPACK_IMPORTED_MODULE_32__/* ["default"] */ .A,
        _shikijs_langs_kotlin__WEBPACK_IMPORTED_MODULE_33__/* ["default"] */ .A,
        _shikijs_langs_sql__WEBPACK_IMPORTED_MODULE_34__/* ["default"] */ .A,
        _shikijs_langs_r__WEBPACK_IMPORTED_MODULE_35__/* ["default"] */ .A,
        _shikijs_langs_dart__WEBPACK_IMPORTED_MODULE_36__/* ["default"] */ .A,
        _shikijs_langs_lua__WEBPACK_IMPORTED_MODULE_37__/* ["default"] */ .A,
        _shikijs_langs_dockerfile__WEBPACK_IMPORTED_MODULE_38__/* ["default"] */ .A,
        _shikijs_langs_makefile__WEBPACK_IMPORTED_MODULE_39__/* ["default"] */ .A,
        _shikijs_langs_xml__WEBPACK_IMPORTED_MODULE_40__/* ["default"] */ .A,
        _shikijs_langs_ini__WEBPACK_IMPORTED_MODULE_41__/* ["default"] */ .A,
        _shikijs_langs_powershell__WEBPACK_IMPORTED_MODULE_42__/* ["default"] */ .A,
        _shikijs_langs_python__WEBPACK_IMPORTED_MODULE_43__/* ["default"] */ .A,
    ],
    engine: (0,shiki_engine_javascript__WEBPACK_IMPORTED_MODULE_44__/* .createJavaScriptRegexEngine */ .l)(),
});
// local cache for highlighted code blocks to avoid recomputation across remounts of Markdown
// this is because we don't want "Static" to retry to rerender the same code blocks
const markdownHighlightCache = new _anysphere_utils__WEBPACK_IMPORTED_MODULE_2__/* .LRUCache */ .qK({
    max: 300,
});
const cacheKeyFor = (language, theme, content) => `${theme}::${language}::${content}`;
/**
 * A syntax-highlighted code viewer component that displays code with optional line numbers.
 */
const HighlightedCode = (_a) => {
    var { content, language, showLineNumbers = true, lineNumberWidth = 4, startLineNumber = 1, maxLines, isDiff = false, truncationHint, tabSize = 4, dimmed = false } = _a, rest = __rest(_a, ["content", "language", "showLineNumbers", "lineNumberWidth", "startLineNumber", "maxLines", "isDiff", "truncationHint", "tabSize", "dimmed"]);
    // no need for stdout; flex layout handles right-side fill
    const lines = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => content.split("\n"), [content]);
    const isLightTheme = (0,_context_theme_context_js__WEBPACK_IMPORTED_MODULE_5__/* .useIsLightTheme */ .pW)();
    const colorMode = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_6__/* .getColorMode */ .PT)(), []);
    const theme = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        if (isLightTheme) {
            return "light-plus";
        }
        return "github-dark-default";
    }, [isLightTheme]);
    const diffRowHexes = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        if (colorMode === "truecolor") {
            return isLightTheme ? _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_ROW_TRUECOLOR_LIGHT */ .iP : _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_ROW_TRUECOLOR_DARK */ .eh;
        }
        const addIdx = isLightTheme
            ? _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_ROW_ANSI256_LIGHT */ .Xh.add
            : _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_ROW_ANSI256_DARK */ .XM.add;
        const removeIdx = isLightTheme
            ? _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_ROW_ANSI256_LIGHT */ .Xh.remove
            : _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_ROW_ANSI256_DARK */ .XM.remove;
        return {
            addHex: (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_6__/* .ansi256IndexToHex */ .LR)(addIdx),
            removeHex: (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_6__/* .ansi256IndexToHex */ .LR)(removeIdx),
        };
    }, [colorMode, isLightTheme]);
    const diffRowAnsiIdxes = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        if (colorMode !== "ansi256")
            return null;
        return isLightTheme
            ? {
                add: _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_ROW_ANSI256_LIGHT */ .Xh.add,
                remove: _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_ROW_ANSI256_LIGHT */ .Xh.remove,
            }
            : {
                add: _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_ROW_ANSI256_DARK */ .XM.add,
                remove: _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_ROW_ANSI256_DARK */ .XM.remove,
            };
    }, [colorMode, isLightTheme]);
    const diffSignHexes = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        if (colorMode === "truecolor") {
            const palette = isLightTheme
                ? _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_SIGN_TRUECOLOR_LIGHT */ .B0
                : _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_SIGN_TRUECOLOR_DARK */ .Fv;
            return palette;
        }
        const idxPalette = isLightTheme
            ? _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_SIGN_ANSI256_LIGHT */ .Kj
            : _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .DIFF_SIGN_ANSI256_DARK */ .yp;
        return {
            addHex: (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_6__/* .ansi256IndexToHex */ .LR)(idxPalette.add),
            removeHex: (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_6__/* .ansi256IndexToHex */ .LR)(idxPalette.remove),
        };
    }, [colorMode, isLightTheme]);
    const tokens = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        try {
            const cacheKey = cacheKeyFor(language, theme, content);
            const cachedTokens = markdownHighlightCache.get(cacheKey);
            if (cachedTokens) {
                return cachedTokens;
            }
            const newTokens = shiki.codeToTokens(content, { lang: language, theme });
            markdownHighlightCache.set(cacheKey, newTokens);
            return newTokens;
        }
        catch (_a) {
            // If language isn't supported/loaded, fall back to no-highlighting mode
            return null;
        }
    }, [content, language, theme]);
    // Helpers retained for potential future use; currently unused after flex-based padding
    // const stringWidth = (s: string): number => Array.from(s).length;
    // const tokensWidth = (toks: TokensResult["tokens"][0]): number =>
    //   toks.reduce((acc, t) => acc + stringWidth(t.content ?? ""), 0);
    const renderTokensForLine = (lineTokens, kind) => {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: lineTokens.map((token, tokenIndex) => {
                var _a, _b, _c, _d;
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: (_a = token.color) !== null && _a !== void 0 ? _a : undefined, backgroundColor: kind === "other" ? token.bgColor : undefined, italic: Boolean(((_b = token.fontStyle) !== null && _b !== void 0 ? _b : 0) & 1), bold: Boolean(((_c = token.fontStyle) !== null && _c !== void 0 ? _c : 0) & 2), underline: Boolean(((_d = token.fontStyle) !== null && _d !== void 0 ? _d : 0) & 4), children: token.content }, `${token.content}-${tokenIndex}`));
            }) }));
    };
    // Compute visible range and render once
    const totalLines = tokens ? tokens.tokens.length : lines.length;
    const shouldCap = typeof maxLines === "number" && maxLines > 0;
    const visibleCount = shouldCap
        ? Math.min(totalLines, maxLines)
        : totalLines;
    const remainingCount = totalLines - visibleCount;
    // Expand tabs to spaces honoring tab stops
    const expandTabsInText = (text, startColumn) => {
        if (!text || tabSize <= 0)
            return { text, endColumn: startColumn + Array.from(text).length };
        let column = startColumn;
        let out = "";
        for (const ch of Array.from(text)) {
            if (ch === "\t") {
                const spaces = tabSize - (column % tabSize);
                out += " ".repeat(spaces === 0 ? tabSize : spaces);
                column += spaces === 0 ? tabSize : spaces;
            }
            else {
                out += ch;
                column += 1;
            }
        }
        return { text: out, endColumn: column };
    };
    const expandTabsInTokenLine = (lineTokens) => {
        let column = 0;
        return lineTokens.map(t => {
            var _a;
            const original = (_a = t.content) !== null && _a !== void 0 ? _a : "";
            const { text, endColumn } = expandTabsInText(original, column);
            column = endColumn;
            return Object.assign(Object.assign({}, t), { content: text });
        });
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, Object.assign({ flexDirection: "column", width: "100%" }, rest, { children: [Array.from({ length: visibleCount }, (_, index) => {
                var _a, _b, _c, _d, _e;
                const rawLine = (_a = lines[index]) !== null && _a !== void 0 ? _a : "";
                const kind = isDiff
                    ? (0,_utils_diff_colors_js__WEBPACK_IMPORTED_MODULE_7__/* .classifyDiffLine */ .U)(rawLine)
                    : "other";
                const bgHex = colorMode === "ansi256"
                    ? undefined
                    : kind === "added"
                        ? diffRowHexes.addHex
                        : kind === "removed"
                            ? diffRowHexes.removeHex
                            : undefined;
                const bgAnsiIdx = colorMode === "ansi256"
                    ? kind === "added"
                        ? diffRowAnsiIdxes === null || diffRowAnsiIdxes === void 0 ? void 0 : diffRowAnsiIdxes.add
                        : kind === "removed"
                            ? diffRowAnsiIdxes === null || diffRowAnsiIdxes === void 0 ? void 0 : diffRowAnsiIdxes.remove
                            : undefined
                    : undefined;
                const tokenLine = tokens ? ((_b = tokens.tokens[index]) !== null && _b !== void 0 ? _b : []) : null;
                // If diff line, put the sign in its own fixed column and avoid per-token backgrounds
                let contentNode;
                let signChar;
                let signColor;
                // No need to compute precise visual width; layout is flex-based
                if (tokenLine) {
                    if (kind === "added" || kind === "removed") {
                        const toStrip = 1;
                        let remaining = toStrip;
                        const adjusted = [];
                        for (const t of tokenLine) {
                            if (remaining <= 0) {
                                adjusted.push(t);
                                continue;
                            }
                            const text = (_c = t.content) !== null && _c !== void 0 ? _c : "";
                            if (text.length <= remaining) {
                                remaining -= text.length;
                                // drop token entirely
                                continue;
                            }
                            adjusted.push(Object.assign(Object.assign({}, t), { content: text.slice(remaining) }));
                            remaining = 0;
                        }
                        signChar = (_d = rawLine[0]) !== null && _d !== void 0 ? _d : "";
                        signColor =
                            kind === "added" ? diffSignHexes.addHex : diffSignHexes.removeHex;
                        const expanded = expandTabsInTokenLine(adjusted);
                        contentNode = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "wrap", dimColor: dimmed, children: renderTokensForLine(expanded, kind) }));
                    }
                    else {
                        const expanded = expandTabsInTokenLine(tokenLine);
                        contentNode = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "wrap", dimColor: dimmed, children: renderTokensForLine(expanded, kind) }));
                    }
                }
                else {
                    if (kind === "added" || kind === "removed") {
                        signChar = (_e = rawLine[0]) !== null && _e !== void 0 ? _e : "";
                        const rest = rawLine.slice(1);
                        signColor =
                            kind === "added" ? diffSignHexes.addHex : diffSignHexes.removeHex;
                        contentNode = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "wrap", dimColor: dimmed, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: expandTabsInText(rest, 0).text }) }));
                    }
                    else {
                        contentNode = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "wrap", dimColor: dimmed, children: expandTabsInText(rawLine, 0).text }));
                    }
                }
                // Flex filler handles right-side extension; no explicit padding needed
                const lineNumber = startLineNumber + index;
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(LineComponent, { lineNumber: lineNumber, showLineNumbers: showLineNumbers, lineNumberWidth: lineNumberWidth, isDiff: isDiff, rowBgHex: bgHex, rowBgAnsi256Index: bgAnsiIdx, signChar: signChar, signColor: signColor, children: contentNode }, lineNumber));
            }), remainingCount > 0 && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(LineComponent, { lineNumber: startLineNumber + visibleCount, showLineNumbers: showLineNumbers, lineNumberWidth: lineNumberWidth, isDiff: isDiff, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: ["\u2026 truncated (", remainingCount, " more line", remainingCount === 1 ? "" : "s", ")", truncationHint ? (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [" \u00B7 ", truncationHint] }) : null] }) }))] })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HighlightedCode);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/highlighted-diff.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* unused harmony export HighlightedDiff */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





const hexToRgb = (hex) => {
    const cleanHex = hex.replace("#", "");
    const r = parseInt(cleanHex.slice(0, 2), 16);
    const g = parseInt(cleanHex.slice(2, 4), 16);
    const b = parseInt(cleanHex.slice(4, 6), 16);
    return { r, g, b };
};
const rgbToHex = (rgb) => {
    const toHex = (n) => Math.round(Math.max(0, Math.min(255, n)))
        .toString(16)
        .padStart(2, "0");
    return `#${toHex(rgb.r)}${toHex(rgb.g)}${toHex(rgb.b)}`;
};
const mixColors = (baseColor, tintColor, tintStrength) => {
    try {
        const base = hexToRgb(baseColor);
        const tint = hexToRgb(tintColor);
        const mixed = {
            r: base.r * (1 - tintStrength) + tint.r * tintStrength,
            g: base.g * (1 - tintStrength) + tint.g * tintStrength,
            b: base.b * (1 - tintStrength) + tint.b * tintStrength,
        };
        return rgbToHex(mixed);
    }
    catch (_a) {
        // Fallback to original color if mixing fails
        return baseColor;
    }
};
const DiffLineComponent = ({ children, showLineNumbers, lineNumberMode, type, beforeLineNumber, afterLineNumber, addedColor, removedColor, lineNumberWidth, }) => {
    const getLineColor = () => {
        switch (type) {
            case "added":
                return addedColor;
            case "removed":
                return removedColor;
            default:
                return "white";
        }
    };
    const getPrefix = () => {
        switch (type) {
            case "added":
                return "+";
            case "removed":
                return "-";
            default:
                return " ";
        }
    };
    const formatLineNumbers = () => {
        if (!showLineNumbers || lineNumberMode === "none")
            return null;
        switch (lineNumberMode) {
            case "after": {
                // Show only after line numbers
                const afterNum = afterLineNumber
                    ? afterLineNumber.toString().padStart(lineNumberWidth - 1, " ")
                    : " ".repeat(lineNumberWidth - 1);
                return afterNum;
            }
            default: {
                // Show both before and after line numbers (original behavior)
                const padWidth = Math.floor(lineNumberWidth / 2);
                const beforeNum = beforeLineNumber
                    ? beforeLineNumber.toString().padStart(padWidth, " ")
                    : " ".repeat(padWidth);
                const afterLineNumBoth = afterLineNumber
                    ? afterLineNumber.toString().padStart(padWidth, " ")
                    : " ".repeat(padWidth);
                return `${beforeNum} ${afterLineNumBoth}`;
            }
        }
    };
    const getLineNumberBoxWidth = () => {
        if (lineNumberMode === "after") {
            return lineNumberWidth + 1; // Narrower for single column
        }
        return lineNumberWidth + 2; // Original width for both columns
    };
    return (_jsxs(Box, { flexDirection: "row", children: [showLineNumbers && lineNumberMode !== "none" && (_jsx(Box, { width: getLineNumberBoxWidth(), flexShrink: 0, borderRight: true, borderLeft: false, borderTop: false, borderBottom: false, borderColor: "gray", borderStyle: "single", justifyContent: "flex-end", children: _jsx(Text, { dimColor: true, children: formatLineNumbers() }) })), _jsx(Box, { width: 1, flexShrink: 0, children: _jsx(Text, { color: getLineColor(), children: getPrefix() }) }), _jsx(Box, { paddingLeft: 1, children: children })] }));
};
const createDiffLines = (beforeContent, afterContent) => {
    const beforeLines = beforeContent.split("\n");
    const afterLines = afterContent.split("\n");
    const diffLines = [];
    let beforeIndex = 0;
    let afterIndex = 0;
    const isCommon = (aIndex, bIndex) => {
        return beforeLines[aIndex] === afterLines[bIndex];
    };
    const foundSubsequence = (nCommon, aCommon, bCommon) => {
        // Add removed lines
        for (let i = beforeIndex; i < aCommon; i++) {
            diffLines.push({
                type: "removed",
                content: beforeLines[i],
                lineNumber: null,
                beforeLineNumber: i + 1,
            });
        }
        // Add added lines
        for (let i = afterIndex; i < bCommon; i++) {
            diffLines.push({
                type: "added",
                content: afterLines[i],
                lineNumber: null,
                afterLineNumber: i + 1,
            });
        }
        // Add common lines
        for (let i = 0; i < nCommon; i++) {
            diffLines.push({
                type: "common",
                content: beforeLines[aCommon + i],
                lineNumber: aCommon + i + 1,
                beforeLineNumber: aCommon + i + 1,
                afterLineNumber: bCommon + i + 1,
            });
        }
        beforeIndex = aCommon + nCommon;
        afterIndex = bCommon + nCommon;
    };
    diffSequences(beforeLines.length, afterLines.length, isCommon, foundSubsequence);
    // Handle remaining lines
    for (let i = beforeIndex; i < beforeLines.length; i++) {
        diffLines.push({
            type: "removed",
            content: beforeLines[i],
            lineNumber: null,
            beforeLineNumber: i + 1,
        });
    }
    for (let i = afterIndex; i < afterLines.length; i++) {
        diffLines.push({
            type: "added",
            content: afterLines[i],
            lineNumber: null,
            afterLineNumber: i + 1,
        });
    }
    return diffLines;
};
/**
 * Filter diff lines to show only hunks with context
 */
const filterDiffLinesWithContext = (diffLines, contextLines) => {
    const result = [];
    const changeIndices = [];
    // Find all indices of changed lines
    diffLines.forEach((line, index) => {
        if (line.type !== "common") {
            changeIndices.push(index);
        }
    });
    if (changeIndices.length === 0) {
        return [];
    }
    // Group consecutive changes into hunks
    const hunks = [];
    let currentHunk = null;
    changeIndices.forEach(index => {
        if (!currentHunk) {
            currentHunk = { start: index, end: index };
        }
        else if (index <= currentHunk.end + contextLines * 2 + 1) {
            // Extend current hunk if the change is close enough
            currentHunk.end = index;
        }
        else {
            // Start a new hunk
            hunks.push(currentHunk);
            currentHunk = { start: index, end: index };
        }
    });
    if (currentHunk) {
        hunks.push(currentHunk);
    }
    // Add lines for each hunk with context
    let lastEndIndex = -1;
    hunks.forEach((hunk, hunkIndex) => {
        const startIndex = Math.max(0, hunk.start - contextLines);
        const endIndex = Math.min(diffLines.length - 1, hunk.end + contextLines);
        // Add separator between hunks with hidden line count
        if (hunkIndex > 0 && lastEndIndex !== -1) {
            const hiddenCount = startIndex - lastEndIndex - 1;
            if (hiddenCount > 0) {
                result.push({ type: "separator", hiddenLines: hiddenCount });
            }
        }
        // Add lines for this hunk
        for (let i = startIndex; i <= endIndex; i++) {
            result.push(diffLines[i]);
        }
        lastEndIndex = endIndex;
    });
    return result;
};
/**
 * A syntax-highlighted diff viewer component that shows differences between two pieces of code
 * with customizable colors and tinting options.
 */
const HighlightedDiff = ({ beforeContent, afterContent, language, showLineNumbers = true, lineNumberMode = "both", enableBackgroundTint = false, addedColor = "#22c55e", removedColor = "#ef4444", backgroundColorTintAmount = 0.2, colorTintAmount = 0.1, lineNumberWidth = 8, compactMode = false, contextLines = 3, }) => {
    const [diffLines, setDiffLines] = useState([]);
    const [beforeTokens, setBeforeTokens] = useState(null);
    const [afterTokens, setAfterTokens] = useState(null);
    const [loading, setLoading] = useState(true);
    const [error, setError] = useState(null);
    useEffect(() => {
        const generateDiff = () => __awaiter(void 0, void 0, void 0, function* () {
            try {
                setLoading(true);
                setError(null);
                // Generate syntax highlighted tokens for both files
                const [beforeResult, afterResult] = yield Promise.all([
                    codeToTokens(beforeContent, {
                        lang: language,
                        theme: "dark-plus",
                    }),
                    codeToTokens(afterContent, {
                        lang: language,
                        theme: "dark-plus",
                    }),
                ]);
                setBeforeTokens(beforeResult);
                setAfterTokens(afterResult);
                // Generate diff lines
                const lines = createDiffLines(beforeContent, afterContent);
                setDiffLines(lines);
            }
            catch (err) {
                setError(err instanceof Error ? err.message : "An error occurred");
            }
            finally {
                setLoading(false);
            }
        });
        generateDiff();
    }, [beforeContent, afterContent, language]);
    const getBackgroundTintColor = (lineType) => {
        if (!enableBackgroundTint)
            return undefined;
        switch (lineType) {
            case "added":
                return mixColors("#000000", addedColor, backgroundColorTintAmount);
            case "removed":
                return mixColors("#000000", removedColor, backgroundColorTintAmount);
            default:
                return undefined;
        }
    };
    const renderTokensForLine = (line) => {
        if (!beforeTokens || !afterTokens) {
            return _jsx(Text, { children: line.content });
        }
        let tokensToRender;
        if (line.type === "common" && line.afterLineNumber) {
            tokensToRender = afterTokens.tokens[line.afterLineNumber - 1];
        }
        else if (line.type === "removed" && line.beforeLineNumber) {
            tokensToRender = beforeTokens.tokens[line.beforeLineNumber - 1];
        }
        else if (line.type === "added" && line.afterLineNumber) {
            tokensToRender = afterTokens.tokens[line.afterLineNumber - 1];
        }
        if (!tokensToRender) {
            return _jsx(Text, { children: line.content });
        }
        const backgroundTint = getBackgroundTintColor(line.type);
        return (_jsx(_Fragment, { children: tokensToRender.map((token, tokenIndex) => {
                let tokenColor = token.color || "#ffffff";
                let backgroundColor = token.bgColor;
                // Apply color tinting for added/removed lines
                if (enableBackgroundTint && line.type !== "common") {
                    const tintColor = line.type === "added" ? addedColor : removedColor;
                    // Tint the token color
                    tokenColor = mixColors(tokenColor, tintColor, colorTintAmount);
                    // Use the background tint
                    backgroundColor = backgroundTint || backgroundColor;
                }
                return (_jsx(Text, { color: tokenColor, backgroundColor: backgroundColor, italic: token.fontStyle === 1, bold: token.fontStyle === 2, underline: token.fontStyle === 4, children: token.content }, `${token.content}-${tokenIndex}`));
            }) }));
    };
    if (loading) {
        return _jsx(Text, { children: "Loading diff..." });
    }
    if (error) {
        return _jsxs(Text, { color: "red", children: ["Error: ", error] });
    }
    // Filter lines if in compact mode
    const linesToRender = compactMode
        ? filterDiffLinesWithContext(diffLines, contextLines)
        : diffLines;
    return (_jsx(Box, { flexDirection: "column", children: linesToRender.map((item, index) => {
            var _a, _b, _c;
            // Handle separator
            if ("type" in item && item.type === "separator") {
                const hiddenText = item.hiddenLines
                    ? `··· ${item.hiddenLines} line${item.hiddenLines === 1 ? "" : "s"} hidden ···`
                    : "···";
                return (_jsx(Box, { paddingY: 0, paddingX: 3, justifyContent: "flex-start", children: _jsx(Text, { dimColor: true, children: hiddenText }) }, `separator-${(_a = item.hiddenLines) !== null && _a !== void 0 ? _a : 0}-${index}`));
            }
            // Handle regular diff line
            const line = item;
            return (_jsx(DiffLineComponent, { type: line.type, beforeLineNumber: line.beforeLineNumber, afterLineNumber: line.afterLineNumber, showLineNumbers: showLineNumbers, lineNumberMode: lineNumberMode, addedColor: addedColor, removedColor: removedColor, lineNumberWidth: lineNumberWidth, children: renderTokensForLine(line) }, `${(_b = line.beforeLineNumber) !== null && _b !== void 0 ? _b : "none"}-${(_c = line.afterLineNumber) !== null && _c !== void 0 ? _c : "none"}-${index}`));
        }) }));
};
/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = ((/* unused pure expression or super */ null && (HighlightedDiff)));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/index.ts":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Hw: () => (/* reexport safe */ _user_message_ui_js__WEBPACK_IMPORTED_MODULE_28__.H),
/* harmony export */   Yl: () => (/* reexport safe */ _overflow_text_js__WEBPACK_IMPORTED_MODULE_17__.Y)
/* harmony export */ });
/* harmony import */ var _Attach_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/components/Attach.tsx");
/* harmony import */ var _approval_dialog_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/components/approval-dialog.tsx");
/* harmony import */ var _background_composer_conversation_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/components/background-composer-conversation.tsx");
/* harmony import */ var _background_composer_list_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/background-composer-list.tsx");
/* harmony import */ var _background_composer_selection_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/background-composer-selection.tsx");
/* harmony import */ var _background_composer_status_displays_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/background-composer-status-displays.tsx");
/* harmony import */ var _background_edit_tool_ui_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/components/background-edit-tool-ui.tsx");
/* harmony import */ var _background_shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/components/background-shell-tool-ui.tsx");
/* harmony import */ var _background_tool_group_ui_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/components/background-tool-group-ui.tsx");
/* harmony import */ var _base_composer_item_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("./src/components/base-composer-item.tsx");
/* harmony import */ var _delete_tool_ui_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("./src/components/delete-tool-ui.tsx");
/* harmony import */ var _grep_tool_ui_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("./src/components/grep-tool-ui.tsx");
/* harmony import */ var _highlighted_diff_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("./src/components/highlighted-diff.tsx");
/* harmony import */ var _login_ui_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("./src/components/login-ui.tsx");
/* harmony import */ var _merged_read_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("./src/components/merged-read-search-tool-ui.tsx");
/* harmony import */ var _merged_str_replace_tool_ui_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("./src/components/merged-str-replace-tool-ui.tsx");
/* harmony import */ var _message_input_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("./src/components/message-input.tsx");
/* harmony import */ var _overflow_text_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__("./src/components/overflow-text.tsx");
/* harmony import */ var _path_display_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__("./src/components/path-display.tsx");
/* harmony import */ var _prompt_bar_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__("./src/components/prompt-bar.tsx");
/* harmony import */ var _read_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__("./src/components/read-todos-tool-ui.tsx");
/* harmony import */ var _read_tool_ui_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__("./src/components/read-tool-ui.tsx");
/* harmony import */ var _search_results_ui_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__("./src/components/search-results-ui.tsx");
/* harmony import */ var _sem_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__("./src/components/sem-search-tool-ui.tsx");
/* harmony import */ var _shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__("./src/components/shell-tool-ui.tsx");
/* harmony import */ var _todos_ui_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__("./src/components/todos-ui.tsx");
/* harmony import */ var _turn_file_changes_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__("./src/components/turn-file-changes.tsx");
/* harmony import */ var _update_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__("./src/components/update-todos-tool-ui.tsx");
/* harmony import */ var _user_message_ui_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__("./src/components/user-message-ui.tsx");
/* harmony import */ var _web_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__("./src/components/web-search-tool-ui.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_Attach_js__WEBPACK_IMPORTED_MODULE_0__, _approval_dialog_js__WEBPACK_IMPORTED_MODULE_1__, _background_composer_conversation_js__WEBPACK_IMPORTED_MODULE_2__, _background_composer_list_js__WEBPACK_IMPORTED_MODULE_3__, _background_composer_selection_js__WEBPACK_IMPORTED_MODULE_4__, _background_composer_status_displays_js__WEBPACK_IMPORTED_MODULE_5__, _background_edit_tool_ui_js__WEBPACK_IMPORTED_MODULE_6__, _background_shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_7__, _background_tool_group_ui_js__WEBPACK_IMPORTED_MODULE_8__, _base_composer_item_js__WEBPACK_IMPORTED_MODULE_9__, _delete_tool_ui_js__WEBPACK_IMPORTED_MODULE_10__, _grep_tool_ui_js__WEBPACK_IMPORTED_MODULE_11__, _highlighted_diff_js__WEBPACK_IMPORTED_MODULE_12__, _login_ui_js__WEBPACK_IMPORTED_MODULE_13__, _merged_read_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_14__, _merged_str_replace_tool_ui_js__WEBPACK_IMPORTED_MODULE_15__, _message_input_js__WEBPACK_IMPORTED_MODULE_16__, _overflow_text_js__WEBPACK_IMPORTED_MODULE_17__, _path_display_js__WEBPACK_IMPORTED_MODULE_18__, _prompt_bar_js__WEBPACK_IMPORTED_MODULE_19__, _read_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_20__, _read_tool_ui_js__WEBPACK_IMPORTED_MODULE_21__, _search_results_ui_js__WEBPACK_IMPORTED_MODULE_22__, _sem_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_23__, _shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_24__, _todos_ui_js__WEBPACK_IMPORTED_MODULE_25__, _turn_file_changes_js__WEBPACK_IMPORTED_MODULE_26__, _update_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_27__, _user_message_ui_js__WEBPACK_IMPORTED_MODULE_28__, _web_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_29__]);
([_Attach_js__WEBPACK_IMPORTED_MODULE_0__, _approval_dialog_js__WEBPACK_IMPORTED_MODULE_1__, _background_composer_conversation_js__WEBPACK_IMPORTED_MODULE_2__, _background_composer_list_js__WEBPACK_IMPORTED_MODULE_3__, _background_composer_selection_js__WEBPACK_IMPORTED_MODULE_4__, _background_composer_status_displays_js__WEBPACK_IMPORTED_MODULE_5__, _background_edit_tool_ui_js__WEBPACK_IMPORTED_MODULE_6__, _background_shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_7__, _background_tool_group_ui_js__WEBPACK_IMPORTED_MODULE_8__, _base_composer_item_js__WEBPACK_IMPORTED_MODULE_9__, _delete_tool_ui_js__WEBPACK_IMPORTED_MODULE_10__, _grep_tool_ui_js__WEBPACK_IMPORTED_MODULE_11__, _highlighted_diff_js__WEBPACK_IMPORTED_MODULE_12__, _login_ui_js__WEBPACK_IMPORTED_MODULE_13__, _merged_read_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_14__, _merged_str_replace_tool_ui_js__WEBPACK_IMPORTED_MODULE_15__, _message_input_js__WEBPACK_IMPORTED_MODULE_16__, _overflow_text_js__WEBPACK_IMPORTED_MODULE_17__, _path_display_js__WEBPACK_IMPORTED_MODULE_18__, _prompt_bar_js__WEBPACK_IMPORTED_MODULE_19__, _read_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_20__, _read_tool_ui_js__WEBPACK_IMPORTED_MODULE_21__, _search_results_ui_js__WEBPACK_IMPORTED_MODULE_22__, _sem_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_23__, _shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_24__, _todos_ui_js__WEBPACK_IMPORTED_MODULE_25__, _turn_file_changes_js__WEBPACK_IMPORTED_MODULE_26__, _update_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_27__, _user_message_ui_js__WEBPACK_IMPORTED_MODULE_28__, _web_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_29__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
// UI Components
























// Tool UI Components







__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/inline-delta.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: () => (/* binding */ InlineDelta)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const InlineDelta = ({ added = 0, removed = 0, }) => {
    const showAdded = (added !== null && added !== void 0 ? added : 0) > 0;
    const showRemoved = (removed !== null && removed !== void 0 ? removed : 0) > 0;
    if (!showAdded && !showRemoved)
        return null;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [showAdded ? (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "green", children: ["+", added] }) : null, showAdded && showRemoved ? (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }) : null, showRemoved ? (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: ["-", removed] }) : null] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/last-n-lines.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: () => (/* binding */ LastNLines)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const LastNLines = ({ content, maxLines, color = "white", }) => {
    const lines = content.split("\n");
    const visibleLines = lines.slice(-maxLines);
    const hiddenCount = Math.max(0, lines.length - maxLines);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [hiddenCount > 0 && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: ["... (", hiddenCount, " lines hidden)"] })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: color, children: visibleLines.join("\n") })] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/login-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: () => (/* binding */ LogoutStatus),
/* harmony export */   a: () => (/* binding */ LoginStatus)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const LoginStatus = ({ status, message, userInfo, loginUrl }) => {
    const getStatusContent = () => {
        switch (status) {
            case "starting":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Starting login process..." }) }));
            case "in-progress":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", gap: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Authenticating with Cursor..." }) }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: message }), loginUrl && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", wrap: "no-wrap", children: loginUrl }))] }));
            case "success":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "green", children: "\u2713 " }), (userInfo === null || userInfo === void 0 ? void 0 : userInfo.email) ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: ["Logged in as ", userInfo.email] })) : (userInfo === null || userInfo === void 0 ? void 0 : userInfo.userId) ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: ["Logged in as user id ", userInfo.userId] })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Login successful!" }))] }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: message })] }));
            case "error":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: message }) }));
        }
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", padding: 1, children: getStatusContent() }));
};
const LogoutStatus = ({ status, message }) => {
    const getStatusContent = () => {
        switch (status) {
            case "starting":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Preparing to log out..." }) }));
            case "in-progress":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Logging out..." }) }));
            case "success":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "green", children: "\u2713 Logout successful" }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: message })] }));
            case "error":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: "\u2717 Logout failed" }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: message })] }));
        }
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", padding: 1, children: getStatusContent() }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/ls-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   U: () => (/* binding */ LsToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/tool-call-header.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const LsToolUI = ({ tool: { args, result }, }) => {
    var _a, _b;
    if (!args) {
        return null;
    }
    const pathDisplay = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .getPathDisplay */ .Kr)(args.path || "");
    const ignoreDisplay = args.ignore && args.ignore.length > 0
        ? ` (ignoring: ${args.ignore.join(", ")})`
        : "";
    let status = "pending";
    let note;
    // Calculate stats from the tree if successful
    let totalFiles = 0;
    let totalDirs = 0;
    if (((_a = result === null || result === void 0 ? void 0 : result.result) === null || _a === void 0 ? void 0 : _a.case) === "success" &&
        result.result.value.directoryTreeRoot) {
        const countStats = (node) => {
            totalFiles += node.childrenFiles.length;
            totalDirs += node.childrenDirs.length;
            for (const dir of node.childrenDirs || []) {
                countStats(dir);
            }
        };
        countStats(result.result.value.directoryTreeRoot);
    }
    // Determine status and note based on result
    const caseType = (_b = result === null || result === void 0 ? void 0 : result.result) === null || _b === void 0 ? void 0 : _b.case;
    switch (caseType) {
        case undefined:
            status = "pending";
            break;
        case "error":
            status = "error";
            break;
        case "success":
            status = "success";
            note = `${totalFiles} file${totalFiles === 1 ? "" : "s"}, ${totalDirs} director${totalDirs === 1 ? "y" : "ies"}${ignoreDisplay}`;
            break;
        case "rejected":
            status = "rejected";
            note = (result === null || result === void 0 ? void 0 : result.result.value.reason) || undefined;
            break;
        default: {
            const _exhaustive = caseType;
            status = "pending";
            break;
        }
    }
    const headerName = (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__/* .resolveToolVerbByCase */ .F_)("lsToolCall", status === "success") ||
        (status === "success" ? "Listed" : "Listing");
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__/* .ToolCallHeader */ .C, { name: headerName, primary: pathDisplay, status: status, note: note }), (() => {
                const rr = result === null || result === void 0 ? void 0 : result.result;
                if ((rr === null || rr === void 0 ? void 0 : rr.case) === "error") {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["Error: ", rr.value.error] }) }));
                }
                return null;
            })()] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/markdown.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ay: () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   oz: () => (/* binding */ Markdown)
/* harmony export */ });
/* unused harmony exports parseMarkdown, tokenizeInline */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _context_config_context_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/context/config-context.tsx");
/* harmony import */ var _context_theme_context_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/context/theme-context.tsx");
/* harmony import */ var _debug_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/debug.ts");
/* harmony import */ var _utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/utils/color-mixing.ts");
/* harmony import */ var _highlighted_code_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/components/highlighted-code.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _context_theme_context_js__WEBPACK_IMPORTED_MODULE_5__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_8__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _context_theme_context_js__WEBPACK_IMPORTED_MODULE_5__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









/**
 * Simple markdown parser that extracts common elements
 */
function parseMarkdown(content) {
    var _a, _b;
    const lines = content.split(/\r?\n/);
    const elements = [];
    let i = 0;
    while (i < lines.length) {
        const line = lines[i];
        // Code blocks (```language) or (```start:end:path)
        if (line.trim().startsWith("```")) {
            const info = line.trim().slice(3).trim();
            let language = info || "text";
            let startLineNumber;
            let path;
            // Recognize code citation fences of the form: ```start:end:path
            // Example: ```1:10:fizzbuzz.py
            const citeMatch = info.match(/^(\d+):(\d+):(.+)$/);
            if (citeMatch) {
                startLineNumber = Number.parseInt(citeMatch[1], 10);
                path = citeMatch[3].trim();
                const inferred = inferLanguageFromPath(path);
                language = inferred !== null && inferred !== void 0 ? inferred : "text";
            }
            else if (info && /[/\\.]/.test(info) && !/\s/.test(info)) {
                // If info looks like a filename or path, infer language from its extension
                path = info;
                const inferred = inferLanguageFromPath(info);
                language = inferred !== null && inferred !== void 0 ? inferred : language;
            }
            const codeLines = [];
            i++;
            // Check if the first line contains a file path (e.g., "⬢ Read src/components/PromptBar.tsx")
            // and extract the path if no path was already found in the opening line
            if (!path && i < lines.length && !lines[i].trim().startsWith("```")) {
                const firstLine = lines[i].trim();
                // Match patterns like "⬢ Read path/to/file.ext" or "Read path/to/file.ext"
                const readMatch = firstLine.match(/^(?:⬢\s+)?Read\s+(.+)$/);
                if (readMatch) {
                    const extractedPath = readMatch[1].trim();
                    // Verify it looks like a file path
                    if (/[/\\.]/.test(extractedPath) && !/\s/.test(extractedPath)) {
                        path = extractedPath;
                        const inferred = inferLanguageFromPath(extractedPath);
                        language = inferred !== null && inferred !== void 0 ? inferred : language;
                        // Skip this line since it's not actual code content
                        i++;
                    }
                }
            }
            // Collect code block content
            while (i < lines.length && !lines[i].trim().startsWith("```")) {
                codeLines.push(lines[i]);
                i++;
            }
            elements.push({
                type: "code-block",
                content: codeLines.join("\n"),
                language,
                startLineNumber,
                path,
            });
            i++; // Skip closing ```
            continue;
        }
        // Headings
        const headingMatch = line.match(/^(#{1,6})\s+(.+)$/);
        if (headingMatch) {
            elements.push({
                type: "heading",
                content: headingMatch[2],
                level: headingMatch[1].length,
            });
            i++;
            continue;
        }
        // Ordered list items: e.g., "1. Item" or "1) Item" with indentation-derived nesting level
        const orderedListMatch = line.match(/^(\s*)(\d+)[.)]\s+/);
        if (orderedListMatch) {
            const rawIndent = (_a = orderedListMatch[1]) !== null && _a !== void 0 ? _a : "";
            let visualWidth = 0;
            for (const ch of rawIndent)
                visualWidth += ch === "\t" ? 2 : 1;
            const level = Math.max(0, Math.floor(visualWidth / 2));
            const indexNum = Number.parseInt(orderedListMatch[2], 10);
            elements.push({
                type: "list-item",
                content: line.replace(/^(\s*)(\d+)[.)]\s+/, ""),
                level,
                ordered: true,
                index: Number.isFinite(indexNum) ? indexNum : 1,
            });
            i++;
            continue;
        }
        // Unordered list items with indentation level derived from leading whitespace
        const unorderedListMatch = line.match(/^(\s*)[-*+]\s+/);
        if (unorderedListMatch) {
            const rawIndent = (_b = unorderedListMatch[1]) !== null && _b !== void 0 ? _b : "";
            let visualWidth = 0;
            for (const ch of rawIndent)
                visualWidth += ch === "\t" ? 2 : 1;
            const level = Math.max(0, Math.floor(visualWidth / 2));
            elements.push({
                type: "list-item",
                content: line.replace(/^(\s*)[-*+]\s+/, ""),
                level,
                ordered: false,
            });
            i++;
            continue;
        }
        // Blockquotes
        if (line.trim().startsWith("> ")) {
            elements.push({
                type: "blockquote",
                content: line.replace(/^\s*>\s?/, ""),
            });
            i++;
            continue;
        }
        // Regular text (handle inline formatting)
        if (line.trim()) {
            elements.push({
                type: "text",
                content: line,
            });
        }
        i++;
    }
    return elements;
}
function inferLanguageFromPath(p) {
    var _a;
    const filename = (_a = p.split(/[\\/]/).pop()) !== null && _a !== void 0 ? _a : p;
    const dotIdx = filename.lastIndexOf(".");
    if (dotIdx <= 0 || dotIdx === filename.length - 1)
        return null;
    const ext = filename.slice(dotIdx + 1).toLowerCase();
    switch (ext) {
        case "ts":
            return "typescript";
        case "tsx":
            return "tsx";
        case "js":
            return "javascript";
        case "jsx":
            return "jsx";
        case "py":
            return "python";
        case "java":
            return "java";
        case "c":
            return "c";
        case "cc":
        case "cpp":
        case "cxx":
            return "cpp";
        case "cs":
        case "csharp":
            return "csharp";
        case "go":
            return "go";
        case "rs":
            return "rust";
        case "php":
            return "php";
        case "rb":
            return "ruby";
        case "swift":
            return "swift";
        case "kt":
        case "kts":
            return "kotlin";
        case "scala":
            return "scala";
        case "html":
        case "htm":
            return "html";
        case "css":
            return "css";
        case "scss":
            return "scss";
        case "json":
            return "json";
        case "yml":
        case "yaml":
            return "yaml";
        case "xml":
            return "xml";
        case "md":
        case "markdown":
            return "markdown";
        case "sh":
        case "bash":
            return "bash";
        case "sql":
            return "sql";
        case "dockerfile":
        case "docker":
            return "dockerfile";
        case "vue":
            return "vue";
        case "svelte":
            return "svelte";
        case "txt":
        case "text":
            return "text";
        default:
            return null;
    }
}
function findNextItalicEnd(text, start) {
    let i = text.indexOf("*", start);
    while (i !== -1) {
        if (text[i + 1] === "*") {
            i = text.indexOf("*", i + 2);
            continue;
        }
        return i;
    }
    return -1;
}
/**
 * Tokenize inline markdown with precedence that respects earliest delimiter and favors bold over italic.
 */
function tokenizeInline(text) {
    const tokens = [];
    let i = 0;
    const pushText = (s) => {
        if (s.length > 0)
            tokens.push({ type: "text", content: s });
    };
    while (i < text.length) {
        const idxBack = text.indexOf("`", i);
        const idxStar = text.indexOf("*", i);
        let next = -1;
        let kind = null;
        if (idxBack !== -1) {
            next = idxBack;
            kind = "back";
        }
        if (idxStar !== -1 && (next === -1 || idxStar < next)) {
            if (text.startsWith("**", idxStar)) {
                next = idxStar;
                kind = "bold";
            }
            else {
                next = idxStar;
                kind = "italic";
            }
        }
        else if (idxStar !== -1 &&
            idxStar === next &&
            text.startsWith("**", idxStar)) {
            kind = "bold";
        }
        if (next === -1 || kind === null) {
            pushText(text.slice(i));
            break;
        }
        if (next > i)
            pushText(text.slice(i, next));
        if (kind === "back") {
            const end = text.indexOf("`", next + 1);
            if (end !== -1) {
                tokens.push({ type: "code", content: text.slice(next + 1, end) });
                i = end + 1;
                continue;
            }
            pushText("`");
            i = next + 1;
            continue;
        }
        if (kind === "bold") {
            const end = text.indexOf("**", next + 2);
            if (end !== -1) {
                const inner = text.slice(next + 2, end);
                if (inner.length > 0)
                    tokens.push({ type: "bold", content: inner });
                i = end + 2;
                continue;
            }
            pushText("*");
            i = next + 1;
            continue;
        }
        const end = findNextItalicEnd(text, next + 1);
        if (end !== -1) {
            const inner = text.slice(next + 1, end);
            const trimmed = inner.trim();
            if (trimmed.length > 0)
                tokens.push({ type: "italic", content: inner });
            else
                pushText(`*${inner}*`);
            i = end + 1;
            continue;
        }
        pushText("*");
        i = next + 1;
    }
    return tokens;
}
/**
 * Renders inline markdown formatting (bold, italic, inline code)
 */
function renderInlineFormatting(text, black, white) {
    const parts = [];
    let key = 0;
    const tokens = tokenizeInline(text);
    for (const t of tokens) {
        if (t.type === "text")
            parts.push((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: t.content }, key++));
        else if (t.type === "code")
            parts.push((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "wrap", color: white, backgroundColor: black, children: t.content }, key++));
        else if (t.type === "bold")
            parts.push((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { bold: true, wrap: "wrap", children: t.content }, key++));
        else if (t.type === "italic")
            parts.push((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { italic: true, wrap: "wrap", children: t.content }, key++));
    }
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: parts });
}
/**
 * A markdown renderer component that supports syntax highlighting for code blocks
 */
const MarkdownCodeBlock = react__WEBPACK_IMPORTED_MODULE_2__.memo(({ content, language, startLineNumber, path }) => {
    const showLineNumbers = (0,_context_config_context_js__WEBPACK_IMPORTED_MODULE_4__/* .useShowLineNumbers */ .$i)();
    const shouldShowLineNumbers = showLineNumbers && content.split("\n").length > 1;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [path && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginBottom: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { bold: true, children: [" ", path, " ", startLineNumber
                            ? `lines ${startLineNumber}-${startLineNumber + content.split("\n").length - 1}`
                            : ""] }) })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_highlighted_code_js__WEBPACK_IMPORTED_MODULE_8__/* .HighlightedCode */ .d, { content: content, language: language, startLineNumber: startLineNumber !== null && startLineNumber !== void 0 ? startLineNumber : 1, showLineNumbers: shouldShowLineNumbers })] }));
});
const Markdown = react__WEBPACK_IMPORTED_MODULE_2__.memo(({ content }) => {
    const elements = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => parseMarkdown(content), [content]);
    const isLightTheme = (0,_context_theme_context_js__WEBPACK_IMPORTED_MODULE_5__/* .useIsLightTheme */ .pW)();
    const colorMode = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_7__/* .getColorMode */ .PT)(), []);
    const black = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        (0,_debug_js__WEBPACK_IMPORTED_MODULE_6__.debugLog)("colorMode", colorMode);
        (0,_debug_js__WEBPACK_IMPORTED_MODULE_6__.debugLog)("isLightTheme", isLightTheme);
        if (colorMode === "truecolor") {
            return isLightTheme
                ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .INLINE_DIFF_TRUECOLOR_LIGHT */ .dU.backgroundHex
                : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .INLINE_DIFF_TRUECOLOR_DARK */ .F3.backgroundHex;
        }
        const background = isLightTheme
            ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .INLINE_DIFF_ANSI256_LIGHT */ .i1.background
            : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .INLINE_DIFF_ANSI256_DARK */ .sg.background;
        return (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_7__/* .ansi256IndexToHex */ .LR)(background);
    }, [isLightTheme, colorMode]);
    const white = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        if (colorMode === "truecolor") {
            return isLightTheme
                ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .INLINE_DIFF_TRUECOLOR_LIGHT */ .dU.foregroundHex
                : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .INLINE_DIFF_TRUECOLOR_DARK */ .F3.foregroundHex;
        }
        const foreground = isLightTheme
            ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .INLINE_DIFF_ANSI256_LIGHT */ .i1.foreground
            : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .INLINE_DIFF_ANSI256_DARK */ .sg.foreground;
        return (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_7__/* .ansi256IndexToHex */ .LR)(foreground);
    }, [isLightTheme, colorMode]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: elements.map((element, index) => {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j;
            switch (element.type) {
                case "code-block": {
                    const language = element.language;
                    const supportedLanguages = [
                        "javascript",
                        "typescript",
                        "python",
                        "java",
                        "c",
                        "cpp",
                        "csharp",
                        "go",
                        "rust",
                        "php",
                        "ruby",
                        "swift",
                        "kotlin",
                        "scala",
                        "html",
                        "css",
                        "scss",
                        "json",
                        "yaml",
                        "xml",
                        "markdown",
                        "bash",
                        "shell",
                        "sql",
                        "dockerfile",
                        "tsx",
                        "jsx",
                        "vue",
                        "svelte",
                        "text",
                    ];
                    const isSupported = supportedLanguages.includes(language);
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginY: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MarkdownCodeBlock, { content: element.content, language: isSupported ? language : "text", startLineNumber: element.startLineNumber, path: element.path }) }, `code-${(_a = element.path) !== null && _a !== void 0 ? _a : ""}-${(_b = element.startLineNumber) !== null && _b !== void 0 ? _b : 0}`));
                }
                case "heading": {
                    const isLight = isLightTheme;
                    const mode = colorMode;
                    const headingHex = (() => {
                        if (mode === "truecolor") {
                            if (element.level === 1)
                                return isLight
                                    ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .HEADING_TRUECOLOR_LIGHT */ .cM.h1Hex
                                    : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .HEADING_TRUECOLOR_DARK */ .CV.h1Hex;
                            if (element.level === 2)
                                return isLight
                                    ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .HEADING_TRUECOLOR_LIGHT */ .cM.h2Hex
                                    : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .HEADING_TRUECOLOR_DARK */ .CV.h2Hex;
                            return isLight
                                ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .HEADING_TRUECOLOR_LIGHT */ .cM.hnHex
                                : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .HEADING_TRUECOLOR_DARK */ .CV.hnHex;
                        }
                        return null;
                    })();
                    const headingAnsiHex = (() => {
                        if (mode !== "truecolor") {
                            const idx = element.level === 1
                                ? isLight
                                    ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .HEADING_ANSI256_LIGHT */ .bR.h1
                                    : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .HEADING_ANSI256_DARK */ .XQ.h1
                                : element.level === 2
                                    ? isLight
                                        ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .HEADING_ANSI256_LIGHT */ .bR.h2
                                        : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .HEADING_ANSI256_DARK */ .XQ.h2
                                    : isLight
                                        ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .HEADING_ANSI256_LIGHT */ .bR.hn
                                        : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .HEADING_ANSI256_DARK */ .XQ.hn;
                            return (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_7__/* .ansi256IndexToHex */ .LR)(idx);
                        }
                        return null;
                    })();
                    const headingColor = (_c = headingHex !== null && headingHex !== void 0 ? headingHex : headingAnsiHex) !== null && _c !== void 0 ? _c : undefined;
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginBottom: 1, marginTop: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, Object.assign({ bold: true }, (headingColor ? { color: headingColor } : {}), { wrap: "wrap", children: element.content })) }, `heading-${element.level}-${element.content}`));
                }
                case "list-item": {
                    const isEndOfList = ((_e = (_d = elements[index + 1]) === null || _d === void 0 ? void 0 : _d.type) !== null && _e !== void 0 ? _e : null) !== "list-item";
                    const indent = Math.max(0, (_f = element.level) !== null && _f !== void 0 ? _f : 0);
                    const indentWidth = indent * 2;
                    const isOrdered = element.ordered === true;
                    const marker = isOrdered
                        ? `${((_g = element.index) !== null && _g !== void 0 ? _g : 1).toString()}.`
                        : "•";
                    const markerColumnWidth = isOrdered
                        ? Math.max(marker.length + 1, 3)
                        : 2;
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", marginBottom: isEndOfList ? 1 : 0, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: indentWidth }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: markerColumnWidth, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: marker }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexGrow: 1, paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "wrap", children: renderInlineFormatting(element.content, black, white) }) })] }, `list-item-${(_h = element.index) !== null && _h !== void 0 ? _h : index}-${(_j = element.level) !== null && _j !== void 0 ? _j : 0}-${element.content}`));
                }
                case "blockquote":
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: 2, borderLeft: true, borderColor: "gray", children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", italic: true, wrap: "wrap", children: renderInlineFormatting(element.content, black, white) }) }, `blockquote-${element.content}`));
                default:
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "wrap", children: renderInlineFormatting(element.content, black, white) }) }, `${element.type}-${element.content}`));
            }
        }) }));
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Markdown);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/mcp-tool-decision-preview.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: () => (/* binding */ McpToolDecisionPreview)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _highlighted_code_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/components/highlighted-code.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_2__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const McpToolDecisionPreview = ({ providerIdentifier, toolName, args, }) => {
    const argEntries = Object.entries(args);
    const hasArgs = argEntries.length > 0;
    const isCompact = argEntries.length <= 3;
    if (!hasArgs) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "cyan", bold: true, children: [providerIdentifier, ":", " "] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: [toolName, "()"] })] }));
    }
    if (isCompact) {
        // Format inline for 3 or fewer params
        const inlineArgs = argEntries
            .map(([key, value]) => `${key}: ${JSON.stringify(value)}`)
            .join(", ");
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", alignItems: "center", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "cyan", bold: true, children: [providerIdentifier, ":", " "] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_highlighted_code_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A, { content: `${toolName}(${inlineArgs})`, language: "javascript", showLineNumbers: false })] }));
    }
    // Multi-line format for more than 3 params
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "cyan", bold: true, children: [providerIdentifier, ":", " "] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: [toolName, "("] })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_highlighted_code_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A, { content: JSON.stringify(args, null, 2), language: "json", showLineNumbers: false }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: ")" })] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/mcp-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   v: () => (/* binding */ McpToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _tool_call_header_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/tool-call-header.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_3__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




const McpToolUI = ({ tool: { args, result }, }) => {
    var _a, _b, _c;
    if (!args) {
        return null;
    }
    const providerIdentifier = (_a = args.providerIdentifier) !== null && _a !== void 0 ? _a : "MCP";
    // Extract the tool name from args
    const toolName = (_b = args.toolName) !== null && _b !== void 0 ? _b : "<Unknown Tool>";
    // Format the arguments for display
    const _argsDisplay = Object.entries(args.args || {}).length > 0
        ? JSON.stringify(args.args, null, 2)
        : undefined;
    let status = "pending";
    let note;
    let errorMessage;
    let _successResult;
    // Determine status and extract relevant information based on result
    const caseType = (_c = result === null || result === void 0 ? void 0 : result.result) === null || _c === void 0 ? void 0 : _c.case;
    switch (caseType) {
        case undefined:
            status = "pending";
            break;
        case "error":
            status = "error";
            errorMessage = (result === null || result === void 0 ? void 0 : result.result.value.error) || "Unknown error";
            break;
        case "success":
            status = "success";
            _successResult = "Success";
            break;
        case "rejected":
            status = "rejected";
            note = "MCP tool rejected";
            break;
        case "permissionDenied":
            status = "error";
            errorMessage = "Permission denied";
            break;
        default: {
            const _exhaustive = caseType;
            status = "pending";
            break;
        }
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_3__/* .ToolCallHeader */ .C, { name: providerIdentifier, primary: toolName, status: status, note: note }), errorMessage && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, marginTop: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: ["Error: ", errorMessage] }) }))] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/merged-read-search-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   r: () => (/* binding */ MergedReadSearchToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _tool_call_header_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/tool-call-header.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_5__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const MergedReadSearchToolUI = ({ tools, treatAsPending = false, }) => {
    var _a;
    const allCompleted = tools.every(tool => tool.completed);
    // Group tools by type for header counts
    const readTools = [];
    const grepTools = [];
    const semSearchTools = [];
    const globTools = [];
    const lsTools = [];
    tools.forEach(toolStep => {
        if (toolStep.call.tool.case === "readToolCall")
            readTools.push(toolStep.call.tool.value);
        else if (toolStep.call.tool.case === "grepToolCall")
            grepTools.push(toolStep.call.tool.value);
        else if (toolStep.call.tool.case === "semSearchToolCall")
            semSearchTools.push(toolStep.call.tool.value);
        else if (toolStep.call.tool.case === "globToolCall")
            globTools.push(toolStep.call.tool.value);
        else if (toolStep.call.tool.case === "lsToolCall")
            lsTools.push(toolStep.call.tool.value);
    });
    // Build descriptive text (ordered by first occurrence in chronological tools)
    const toolOrder = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        const seen = new Set();
        const order = [];
        for (const t of tools) {
            const k = t.call.tool.case;
            if (!k)
                continue;
            if (!seen.has(k)) {
                seen.add(k);
                order.push(k);
            }
        }
        return order;
    }, [tools]);
    const countByType = {
        readToolCall: readTools.length,
        grepToolCall: grepTools.length,
        semSearchToolCall: semSearchTools.length,
        globToolCall: globTools.length,
        lsToolCall: lsTools.length,
    };
    const typeToCountLabel = {
        readToolCall: n => `${n} file${n === 1 ? "" : "s"}`,
        grepToolCall: n => `${n} ${n === 1 ? "grep" : "greps"}`,
        semSearchToolCall: n => `${n} ${n === 1 ? "search" : "searches"}`,
        globToolCall: n => `${n} ${n === 1 ? "glob" : "globs"}`,
        lsToolCall: n => `${n} director${n === 1 ? "y" : "ies"}`,
    };
    const operationTextParts = [];
    for (const k of toolOrder) {
        const count = (_a = countByType[k]) !== null && _a !== void 0 ? _a : 0;
        const fmt = typeToCountLabel[k];
        if (count > 0 && fmt)
            operationTextParts.push(fmt(count));
    }
    const operationText = operationTextParts.join(", ");
    const status = allCompleted && !treatAsPending ? "success" : "pending";
    // Determine combined verb in requested phrasing, ordered by chronological tool appearance
    const nameParts = toolOrder
        .map(k => (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .resolveToolVerbByCase */ .F_)(k, allCompleted && !treatAsPending) || undefined)
        .filter((s) => Boolean(s));
    const rawName = nameParts.join(", ") || "Read";
    const toolName = rawName.charAt(0).toUpperCase() + rawName.slice(1).toLowerCase();
    const chronological = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        const items = tools
            .map(toolStep => {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j;
            const isCompleted = Boolean(toolStep.completed);
            const toolCase = toolStep.call.tool.case;
            if (toolCase === "readToolCall") {
                const args = toolStep.call.tool.value.args;
                const display = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_4__/* .getPathDisplay */ .Kr)((_a = args === null || args === void 0 ? void 0 : args.path) !== null && _a !== void 0 ? _a : "");
                const ln = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_4__/* .formatLineNote */ .me)(args === null || args === void 0 ? void 0 : args.offset, args === null || args === void 0 ? void 0 : args.limit);
                return {
                    verb: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .resolveToolVerbByCase */ .F_)(toolCase, isCompleted) ||
                        (isCompleted ? "Read" : "Reading"),
                    rest: `${display}${ln ? ` ${ln}` : ""}`,
                };
            }
            if (toolCase === "grepToolCall") {
                const args = toolStep.call.tool.value.args;
                const pattern = (_b = args === null || args === void 0 ? void 0 : args.pattern) !== null && _b !== void 0 ? _b : "";
                const patternDisplay = pattern.length > 40 ? `...${pattern.slice(-37)}` : pattern;
                const pathDisplay = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_4__/* .getPathDisplay */ .Kr)((_c = args === null || args === void 0 ? void 0 : args.path) !== null && _c !== void 0 ? _c : "");
                return {
                    verb: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .resolveToolVerbByCase */ .F_)(toolCase, isCompleted) ||
                        (isCompleted ? "Grepped" : "Grepping"),
                    rest: `"${patternDisplay}" in ${pathDisplay}`,
                };
            }
            if (toolCase === "semSearchToolCall") {
                const args = toolStep.call.tool.value.args;
                const query = (_d = args === null || args === void 0 ? void 0 : args.query) !== null && _d !== void 0 ? _d : "";
                const queryDisplay = query.length > 40 ? `...${query.slice(-37)}` : query;
                const dirs = (_e = args === null || args === void 0 ? void 0 : args.targetDirectories) !== null && _e !== void 0 ? _e : [];
                const pathDisplay = dirs.length > 0 ? (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_4__/* .getPathDisplay */ .Kr)(dirs[0] || ".") : "";
                const locationText = pathDisplay ? ` in ${pathDisplay}` : "";
                return {
                    verb: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .resolveToolVerbByCase */ .F_)(toolCase, isCompleted) ||
                        (isCompleted ? "Searched" : "Searching"),
                    rest: `"${queryDisplay}"${locationText}`,
                };
            }
            if (toolCase === "globToolCall") {
                const args = toolStep.call.tool.value.args;
                const pattern = (_f = args === null || args === void 0 ? void 0 : args.globPattern) !== null && _f !== void 0 ? _f : "";
                const patternDisplay = pattern.length > 40 ? `...${pattern.slice(-37)}` : pattern;
                const pathDisplay = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_4__/* .getPathDisplay */ .Kr)((_g = args === null || args === void 0 ? void 0 : args.targetDirectory) !== null && _g !== void 0 ? _g : "");
                return {
                    verb: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .resolveToolVerbByCase */ .F_)(toolCase, isCompleted) ||
                        (isCompleted ? "Globbed" : "Globbing"),
                    rest: `"${patternDisplay}" in ${pathDisplay}`,
                };
            }
            if (toolCase === "lsToolCall") {
                const p = (_j = (_h = toolStep.call.tool.value.args) === null || _h === void 0 ? void 0 : _h.path) !== null && _j !== void 0 ? _j : "";
                const display = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_4__/* .getPathDisplay */ .Kr)(p);
                return {
                    verb: (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .resolveToolVerbByCase */ .F_)(toolCase, isCompleted) ||
                        (isCompleted ? "Listed" : "Listing"),
                    rest: `${display}`,
                };
            }
            return null;
        })
            .filter(Boolean);
        const maxLines = 3;
        const total = items.length;
        // By default, show the last `maxLines` items.
        let startIndex = Math.max(0, total - maxLines);
        // If exactly one item would be hidden, show it instead of
        // rendering a "1 item hidden" label. This makes the UI less noisy.
        if (total - maxLines === 1) {
            startIndex = Math.max(0, startIndex - 1);
        }
        const visible = items.slice(startIndex);
        const collapsed = startIndex; // number of items before the start index
        const earlierHiddenLabel = collapsed > 0
            ? `${collapsed} earlier ${collapsed === 1 ? "item" : "items"} hidden`
            : "";
        return { visible, collapsed, earlierHiddenLabel };
    }, [tools]);
    const renderChronologicalDetails = () => {
        if (chronological.visible.length === 0)
            return null;
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: [chronological.collapsed > 0 ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", wrap: "truncate", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { bold: true, children: "\u2026" }), " ", chronological.earlierHiddenLabel] })) : null, chronological.visible.map((it, _i) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { bold: true, children: it.verb }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "truncate-start", children: it.rest })] }, `${it.verb}-${it.rest}`)))] }));
    };
    if (tools.length === 0) {
        return null;
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, paddingLeft: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_5__/* .ToolCallHeader */ .C, { name: toolName, primary: operationText, status: status }), renderChronologicalDetails()] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/merged-str-replace-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* unused harmony export MergedStrReplaceToolUI */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/utils/path-utils.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const MergedStrReplaceToolUI = ({ tools, }) => {
    if (tools.length === 0) {
        return null;
    }
    // Calculate combined statistics
    let totalLinesAdded = 0;
    let totalLinesRemoved = 0;
    let fileName = "";
    tools.forEach(tool => {
        var _a, _b, _c;
        if (((_a = tool.args) === null || _a === void 0 ? void 0 : _a.path) && ((_b = tool.args) === null || _b === void 0 ? void 0 : _b.oldText) && ((_c = tool.args) === null || _c === void 0 ? void 0 : _c.newText)) {
            fileName = tool.args.path;
            const oldLines = tool.args.oldText.split("\n").length;
            const newLines = tool.args.newText.split("\n").length;
            totalLinesRemoved += oldLines;
            totalLinesAdded += newLines;
        }
    });
    const allCompleted = tools.every(tool => !!tool.result);
    // Truncate long paths like in StrReplaceToolUI
    const pathDisplay = getPathDisplay(fileName);
    return (_jsx(Box, { flexDirection: "column", paddingRight: 2, children: _jsxs(Text, { color: "gray", children: ["Edited ", pathDisplay, " ", _jsxs(Text, { color: "red", children: ["-", totalLinesRemoved] }), " ", _jsxs(Text, { color: "green", children: ["+", totalLinesAdded] }), !allCompleted && _jsx(Text, { color: "gray", children: " (in progress...)" })] }) }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/message-input.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* unused harmony export MessageInput */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _text_input_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/components/text-input.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _text_input_js__WEBPACK_IMPORTED_MODULE_2__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _text_input_js__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const MessageInput = ({ value, onChange, onSubmit, inputMode = "message", isDisabled = false, }) => {
    const getPlaceholder = () => {
        switch (inputMode) {
            case "decision":
                return "Waiting for decision (y/n)...";
            case "rejection-reason":
                return "Enter reason for rejection and press Enter (or leave empty)...";
            default:
                return "Type your message and press Enter...";
        }
    };
    const getBorderColor = () => {
        switch (inputMode) {
            case "decision":
                return "yellow";
            case "rejection-reason":
                return "red";
            default:
                return "blue";
        }
    };
    return (_jsx(Box, { borderStyle: "single", borderColor: isDisabled ? "gray" : getBorderColor(), paddingX: 1, borderLeft: true, borderRight: false, borderTop: false, borderBottom: false, children: isDisabled ? (_jsx(Text, { color: "gray", children: "Input disabled" })) : (_jsx(TextInput, { value: value, onChange: onChange, onSubmit: onSubmit, placeholder: getPlaceholder() })) }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/overflow-text.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: () => (/* binding */ OverflowText)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


/**
 * Simple word wrapping function that respects word boundaries
 */
function wrapText(text, maxWidth) {
    const words = text.split(" ");
    const lines = [];
    let currentLine = "";
    for (const word of words) {
        // Handle words that are longer than maxWidth
        if (word.length > maxWidth) {
            if (currentLine) {
                lines.push(currentLine.trim());
                currentLine = "";
            }
            // Break long words at maxWidth
            let remainingWord = word;
            while (remainingWord.length > maxWidth) {
                lines.push(remainingWord.slice(0, maxWidth));
                remainingWord = remainingWord.slice(maxWidth);
            }
            currentLine = `${remainingWord} `;
            continue;
        }
        // Check if adding this word would exceed maxWidth
        if (currentLine.length + word.length + 1 > maxWidth) {
            if (currentLine) {
                lines.push(currentLine.trim());
                currentLine = `${word} `;
            }
            else {
                currentLine = `${word} `;
            }
        }
        else {
            currentLine += `${word} `;
        }
    }
    if (currentLine.trim()) {
        lines.push(currentLine.trim());
    }
    return lines.join("\n");
}
/**
 * OverflowText component that displays the last n display lines of text
 * with proper word-boundary respecting line wrapping.
 */
const OverflowText = ({ content, maxLines, color = "white", showHiddenIndicator = true, width, }) => {
    var _a;
    const { stdout } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useStdout */ .t$)();
    // Get terminal width or use provided width
    const terminalWidth = ((_a = width !== null && width !== void 0 ? width : stdout === null || stdout === void 0 ? void 0 : stdout.columns) !== null && _a !== void 0 ? _a : 80) - 4;
    // Handle existing newlines by processing each paragraph separately
    const paragraphs = content.split("\n");
    const wrappedParagraphs = paragraphs.map(paragraph => paragraph.trim() === "" ? "" : wrapText(paragraph, terminalWidth));
    const wrappedText = wrappedParagraphs.join("\n");
    // Split into display lines
    const displayLines = wrappedText.split("\n");
    // Get the last maxLines lines
    const hiddenCount = Math.max(0, displayLines.length - maxLines);
    // If only 1 line would be hidden, show it instead of the indicator
    const effectiveMaxLines = hiddenCount === 1 ? maxLines + 1 : maxLines;
    const visibleLines = displayLines.slice(-effectiveMaxLines);
    const adjustedHiddenCount = Math.max(0, displayLines.length - effectiveMaxLines);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [showHiddenIndicator && adjustedHiddenCount > 0 && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: ["... (", adjustedHiddenCount, " lines hidden)"] })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: color, children: visibleLines.join("\n") })] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/path-display.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   g: () => (/* binding */ PathDisplay)
/* harmony export */ });
/* unused harmony export formatPath */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



/**
 * Intelligently truncates a path to fit within maxLength while preserving
 * the most important parts (especially the filename)
 */
function truncatePath(path, maxLength) {
    // Detect the path separator used in this path
    const separator = path.includes("\\") ? "\\" : "/";
    if (path.length <= maxLength) {
        return { segments: path.split(separator), separator };
    }
    const segments = path.split(separator);
    const ellipsis = "...";
    const ellipsisLength = ellipsis.length;
    // Always try to keep the last segment (filename) intact
    const lastSegment = segments[segments.length - 1];
    // If even the filename alone is too long, truncate it
    if (lastSegment.length + ellipsisLength > maxLength) {
        const truncatedFilename = lastSegment.substring(0, maxLength - ellipsisLength);
        return {
            segments: [ellipsis, truncatedFilename],
            ellipsisIndex: 0,
            separator,
        };
    }
    // Calculate how much space we have for the path excluding the filename
    const separatorLength = separator.length;
    const availableSpace = maxLength - lastSegment.length - ellipsisLength;
    // Try to fit as much of the beginning path as possible
    let currentLength = 0;
    const keptSegments = [];
    let ellipsisPosition = -1;
    // Keep segments from the beginning
    for (let i = 0; i < segments.length - 1; i++) {
        const segmentLength = segments[i].length + (i > 0 ? separatorLength : 0);
        if (currentLength + segmentLength <= availableSpace) {
            keptSegments.push(segments[i]);
            currentLength += segmentLength;
        }
        else {
            // We need to truncate here
            ellipsisPosition = keptSegments.length;
            break;
        }
    }
    // If we truncated, insert ellipsis
    if (ellipsisPosition !== -1) {
        keptSegments.splice(ellipsisPosition, 0, ellipsis);
        keptSegments.push(lastSegment);
        return {
            segments: keptSegments,
            ellipsisIndex: ellipsisPosition,
            separator,
        };
    }
    return { segments, separator };
}
const PathDisplay = ({ path, maxLength = 50, separatorColor = "#aaaaaa", segmentColor, ellipsisColor = "#aaaaaa", dimSeparators = true, }) => {
    const { segments, ellipsisIndex, separator } = truncatePath(path, maxLength);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: segments.map((segment, index) => {
            const isEllipsis = index === ellipsisIndex;
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react__WEBPACK_IMPORTED_MODULE_2__.Fragment, { children: [index > 0 && !isEllipsis && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: separatorColor, dimColor: dimSeparators, children: separator })), isEllipsis ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: ellipsisColor, dimColor: true, children: segment })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: segmentColor, children: segment }))] }, segment));
        }) }));
};
// Export a convenience function for simple usage
const formatPath = (path, maxLength = 50) => {
    const { segments, separator } = truncatePath(path, maxLength);
    // Join segments and handle ellipsis properly
    let result = "";
    segments.forEach((segment, index) => {
        if (index > 0 && segment !== "...") {
            result += separator;
        }
        result += segment;
    });
    return result;
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/prompt-bar.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   q: () => (/* binding */ PromptBar)
/* harmony export */ });
/* unused harmony export buildDecisionOptions */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:fs");
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_fs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../agent-kv/dist/index.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../local-exec/dist/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _analytics_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/analytics.ts");
/* harmony import */ var _console_io_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__("./src/console-io.ts");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _context_agent_state_context_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("./src/context/agent-state-context.tsx");
/* harmony import */ var _context_vim_mode_context_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("./src/context/vim-mode-context.tsx");
/* harmony import */ var _debug_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("./src/debug.ts");
/* harmony import */ var _ephemeral_bridge_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("./src/ephemeral-bridge.ts");
/* harmony import */ var _hooks_prompt_use_at_palette_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("./src/hooks/prompt/use-at-palette.ts");
/* harmony import */ var _hooks_prompt_use_ephemeral_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("./src/hooks/prompt/use-ephemeral.ts");
/* harmony import */ var _hooks_prompt_use_prompt_history_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("./src/hooks/prompt/use-prompt-history.ts");
/* harmony import */ var _hooks_prompt_use_slash_palette_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("./src/hooks/prompt/use-slash-palette.ts");
/* harmony import */ var _utils_clipboard_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__("./src/utils/clipboard.ts");
/* harmony import */ var _utils_cursor_navigation_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__("./src/utils/cursor-navigation.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _prompt_decision_dropdown_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__("./src/components/prompt/decision-dropdown.tsx");
/* harmony import */ var _prompt_ephemeral_lines_view_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__("./src/components/prompt/ephemeral-lines-view.tsx");
/* harmony import */ var _prompt_palette_at_list_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__("./src/components/prompt/palette-at-list.tsx");
/* harmony import */ var _prompt_palette_slash_list_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__("./src/components/prompt/palette-slash-list.tsx");
/* harmony import */ var _prompt_pending_decisions_banner_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__("./src/components/prompt/pending-decisions-banner.tsx");
/* harmony import */ var _prompt_prompt_footer_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__("./src/components/prompt/prompt-footer.tsx");
/* harmony import */ var _text_input_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__("./src/components/text-input.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__, _prompt_decision_dropdown_js__WEBPACK_IMPORTED_MODULE_19__, _prompt_ephemeral_lines_view_js__WEBPACK_IMPORTED_MODULE_20__, _prompt_palette_at_list_js__WEBPACK_IMPORTED_MODULE_21__, _prompt_palette_slash_list_js__WEBPACK_IMPORTED_MODULE_22__, _prompt_pending_decisions_banner_js__WEBPACK_IMPORTED_MODULE_23__, _prompt_prompt_footer_js__WEBPACK_IMPORTED_MODULE_24__, _text_input_js__WEBPACK_IMPORTED_MODULE_25__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__, _prompt_decision_dropdown_js__WEBPACK_IMPORTED_MODULE_19__, _prompt_ephemeral_lines_view_js__WEBPACK_IMPORTED_MODULE_20__, _prompt_palette_at_list_js__WEBPACK_IMPORTED_MODULE_21__, _prompt_palette_slash_list_js__WEBPACK_IMPORTED_MODULE_22__, _prompt_pending_decisions_banner_js__WEBPACK_IMPORTED_MODULE_23__, _prompt_prompt_footer_js__WEBPACK_IMPORTED_MODULE_24__, _text_input_js__WEBPACK_IMPORTED_MODULE_25__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

/** biome-ignore-all lint/suspicious/noControlCharactersInRegex: we don't care about control characters in regex */



























const TAB_DEBOUNCE_MS = 200;
const maybeAddAllowlistAction = (options, kind, decision) => {
    var _a, _b, _c;
    const details = ((_b = (_a = decision === null || decision === void 0 ? void 0 : decision.operation) === null || _a === void 0 ? void 0 : _a.details) !== null && _b !== void 0 ? _b : {});
    const notAllowed = (_c = details.notAllowedCommands) !== null && _c !== void 0 ? _c : [];
    if (details.canAllowlist !== false && notAllowed.length > 0) {
        const label = `Add ${notAllowed.map(p => `${kind}(${p})`).join(", ")} to allowlist?`;
        options.push({ label, hint: "(tab)", action: "allowlistApprove" });
    }
};
const buildDecisionOptions = (decision) => {
    var _a, _b;
    const options = [];
    switch ((_a = decision === null || decision === void 0 ? void 0 : decision.operation) === null || _a === void 0 ? void 0 : _a.type) {
        case _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Shell: {
            const operation = decision.operation;
            if (operation.details.isSandboxAvailable) {
                options.push({
                    label: "Run outside sandbox (once)",
                    hint: "(y)",
                    action: "approve",
                });
            }
            else {
                options.push({ label: "Run (once)", hint: "(y)", action: "approve" });
            }
            maybeAddAllowlistAction(options, "Shell", decision);
            options.push({
                label: "Turn on auto-run",
                hint: "(shift+tab)",
                action: "autoRunApprove",
            });
            options.push({ label: "Skip", hint: "(esc or n)", action: "propose" });
            break;
        }
        case _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Mcp:
            options.push({ label: "Run (once)", hint: "(y)", action: "approve" });
            options.push({
                label: "Turn on auto-run",
                hint: "(shift+tab)",
                action: "autoRunApprove",
            });
            options.push({ label: "Skip", hint: "(esc or p)", action: "reject" });
            break;
        case _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Delete:
            options.push({ label: "Delete", hint: "(y)", action: "approve" });
            options.push({ label: "Keep", hint: "(n)", action: "reject" });
            break;
        case _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Write: {
            const details = (_b = decision === null || decision === void 0 ? void 0 : decision.operation) === null || _b === void 0 ? void 0 : _b.details;
            const pathStr = typeof (details === null || details === void 0 ? void 0 : details.path) === "string" ? details.path : undefined;
            options.push({ label: "Proceed", hint: "(y)", action: "approve" });
            options.push({
                label: "Reject & propose changes",
                hint: "(esc or n or p)",
                action: "propose",
            });
            if (typeof pathStr === "string" && pathStr.length > 0) {
                options.push({
                    label: `Add Write(${(0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_18__/* .truncatePathMiddle */ .tk)(pathStr, 30)}) to allowlist?`,
                    hint: "(tab)",
                    action: "allowlistApprove",
                });
            }
            else {
                options.push({
                    label: "Add to allowlist",
                    hint: "(tab)",
                    action: "allowlistApprove",
                });
            }
            options.push({
                label: "Turn on auto-run",
                hint: "(shift+tab)",
                action: "autoRunApprove",
            });
            break;
        }
    }
    return options;
};
const titleForOperation = {
    [_anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Shell]: "Run this command?",
    [_anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Mcp]: "Run this MCP tool?",
    [_anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Delete]: "Delete this file?",
    [_anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Write]: "Write to this file?",
};
const PromptInput = react__WEBPACK_IMPORTED_MODULE_6__.memo(function PromptInput({ prompt, setPrompt, placeholder, rightPlaceholder, isDisabled, onSubmit, onTab, onShiftTab, onCtrlC, onCtrlD, onCtrlR, cursorToEndSignal, onCursorInfoChange, onDownAtLastLine, onUpAtFirstLine, onPaste, focus = true, visualFocus = false, allowExplicitNewline, }) {
    // Not needed inside TextInput wrapper
    if (isDisabled) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_text_input_js__WEBPACK_IMPORTED_MODULE_25__/* ["default"] */ .A, { value: prompt, onChange: () => { }, onSubmit: () => { }, placeholder: placeholder, rightPlaceholder: rightPlaceholder, onTab: () => { }, onShiftTab: () => { }, onCtrlC: () => { }, onCtrlD: () => { }, onCtrlR: () => { }, showCursor: false, visualFocus: false, focus: false, cursorToEndSignal: cursorToEndSignal, onCursorInfoChange: () => { }, onUpAtFirstLine: () => { }, onDownAtLastLine: () => { }, allowExplicitNewline: false, dimmed: true }) }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_text_input_js__WEBPACK_IMPORTED_MODULE_25__/* ["default"] */ .A, { value: prompt, onChange: setPrompt, onSubmit: onSubmit, placeholder: placeholder, rightPlaceholder: rightPlaceholder, onTab: onTab, onShiftTab: onShiftTab, onCtrlC: onCtrlC, onCtrlD: onCtrlD, onCtrlR: onCtrlR, showCursor: true, visualFocus: visualFocus, cursorToEndSignal: cursorToEndSignal, onCursorInfoChange: onCursorInfoChange, onUpAtFirstLine: onUpAtFirstLine, onDownAtLastLine: onDownAtLastLine, focus: focus, onPaste: onPaste, allowExplicitNewline: allowExplicitNewline }) }));
});
// When a user pastes a large block (>800 chars), we insert a compact placeholder
// like `[Pasted text #3 +42 lines]` instead of the full content. On submit, these
// placeholders are expanded back into the original text via the regex below.
// Keep the label and regex in sync if you change the format.
const PASTED_TEXT_LABEL = "Pasted text";
const escapeRegExp = (s) => s.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
const LARGE_PASTE_PLACEHOLDER_RE = new RegExp(`\\[${escapeRegExp(PASTED_TEXT_LABEL)} #(\\d+)(?: \\+\\d+(?: lines)?)?\\]`, "g");
const countLines = (s) => { var _a, _b; return ((_b = (_a = s.match(/\n/g)) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0) + 1; };
const buildLargePastePlaceholder = (id, content) => `[${PASTED_TEXT_LABEL} #${id} +${countLines(content)} lines]`;
const PromptBar = ({ value, onChange, onSubmit, onSubmitShell, topStatus, topStatusMarginTop, inputMode = "message", isDisabled = false, isProcessing = false, isSendingToBackground = false, onCtrlC, borderColorFocused, borderColorBlurred, promptSymbol = "→", isEmptyChat = false, onRequestReview, onNoReviewAvailable, slashCommands, onBeginRejection, onResumeChat, getChatId, onSkipRejectionReason, onCancelRejectionReason, onAddToAllowList, onImagesUpdated, onLogout, onNewChat, onSummarize, rgPath, disableModeSwitch = false, isRepository = true, externalCursorToEndSignal, isSuggestingPlan = false, onExecutePlan, onRejectPlan, onDiscardPlan, planDecisionIndex = 0, onPlanDecisionIndexChange: setPlanDecisionIndex, }) => {
    const { currentModel, mode, pendingDecisions, setCurrentModel, changedFiles, rejectPendingDecision, approvePendingDecision, agentStore, modelManager, queuedMessage, setQueuedMessage, setIsCompact, conversationTokenPercent, } = (0,_context_agent_state_context_js__WEBPACK_IMPORTED_MODULE_9__/* .useAgentState */ .C9)();
    const { mode: vimMode, vimEnabled } = (0,_context_vim_mode_context_js__WEBPACK_IMPORTED_MODULE_10__/* .useVimMode */ .v)();
    // Background/foreground run modes removed
    const { isFocused } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .useFocus */ .iQ)({ autoFocus: true });
    const { exit } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .useApp */ .nm)();
    const [exitMode, setExitMode] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const [quitting, setQuitting] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const [shouldRender, setShouldRender] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(true);
    // Ephemeral bash mode triggered by leading '!'
    const [bashModeActive, setBashModeActive] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const cachedMessageRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(null);
    const wasInDecisionRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(false);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
        if (!exitMode)
            return;
        const t = setTimeout(() => setExitMode(false), 1500);
        return () => clearTimeout(t);
    }, [exitMode]);
    const handleExit = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((isLogout = false) => {
        setShouldRender(false);
        setTimeout(() => {
            (() => __awaiter(void 0, void 0, void 0, function* () {
                const chatId = agentStore.getId();
                const rootBlobId = agentStore.getMetadata("latestRootBlobId");
                yield agentStore.dispose();
                if (chatId && rootBlobId.length > 0) {
                    if (isLogout) {
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_26__/* .intentionallyWriteToStderr */ .p2)("\n  \x1b[32m✓ Logout successful\x1b[0m");
                        (0,_console_io_js__WEBPACK_IMPORTED_MODULE_26__/* .intentionallyWriteToStderr */ .p2)("\n  \x1b[90mAuthentication tokens removed.\x1b[0m");
                    }
                    (0,_console_io_js__WEBPACK_IMPORTED_MODULE_26__/* .intentionallyWriteToStderr */ .p2)(`\n  \x1b[90mTo resume this session:\x1b[0m \x1b[1m\x1b[36mcursor-agent --resume=${chatId}\x1b[0m`);
                }
                // clean exit
                exit();
                process.exit(0);
            }))();
        }, 100);
    }, [agentStore, exit]);
    const [cursorToEndSignal, setCursorToEndSignal] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(0);
    const [_cursorAtLastLine, setCursorAtLastLine] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(true);
    const [cursorOffset, setCursorOffset] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(0);
    const suppressNextReviewRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(false);
    const ephemeral = (0,_hooks_prompt_use_ephemeral_js__WEBPACK_IMPORTED_MODULE_14__/* .useEphemeral */ .N)();
    const history = (0,_hooks_prompt_use_prompt_history_js__WEBPACK_IMPORTED_MODULE_15__/* .usePromptHistory */ .a)();
    const lastChangeTimeRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(0);
    const lastValueRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(value);
    const ephemeralLinesCountRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(0);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
        const handler = (lines) => {
            ephemeral.set(lines);
        };
        (0,_ephemeral_bridge_js__WEBPACK_IMPORTED_MODULE_12__/* .setEphemeralListener */ .al)(handler);
        return () => (0,_ephemeral_bridge_js__WEBPACK_IMPORTED_MODULE_12__/* .setEphemeralListener */ .al)(null);
    }, [ephemeral]);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
        ephemeralLinesCountRef.current = ephemeral.lines.length;
    }, [ephemeral.lines.length]);
    const ensureTrailingSpace = (s) => s.length > 0 && !s.endsWith(" ") ? `${s} ` : s;
    let paletteMode = "none";
    const beginHistoryIfNeeded = () => {
        const next = history.begin(value);
        if (next == null)
            return false;
        const withSpace = ensureTrailingSpace(next);
        ephemeral.preserveNextClear();
        handleProgrammaticChange(withSpace);
        setCursorToEndSignal(s => s + 1);
        return true;
    };
    const handleHistoryUp = () => {
        if (paletteMode !== "none")
            return;
        if (queuedMessage) {
            const merged = value.length > 0 ? `${queuedMessage}\n${value}` : queuedMessage;
            setQueuedMessage("");
            handleProgrammaticChange(merged);
            setCursorToEndSignal(s => s + 1);
            return;
        }
        if (beginHistoryIfNeeded())
            return;
        const next = history.up();
        if (next != null) {
            const withSpace = ensureTrailingSpace(next);
            ephemeral.preserveNextClear();
            handleProgrammaticChange(withSpace);
            setCursorToEndSignal(s => s + 1);
        }
    };
    const handleHistoryDown = () => {
        if (paletteMode !== "none")
            return;
        const res = history.down(value);
        if (!res)
            return;
        const withSpace = ensureTrailingSpace(res.value);
        ephemeral.preserveNextClear();
        handleProgrammaticChange(withSpace);
        setCursorToEndSignal(s => s + 1);
        if (res.exited)
            suppressNextReviewRef.current = true;
    };
    const handleDownAction = () => {
        if (paletteMode !== "none")
            return;
        if (history.inHistory) {
            handleHistoryDown();
            return;
        }
    };
    const maybeRequestReview = () => {
        const hasChanges = changedFiles.length > 0;
        if (hasChanges)
            onRequestReview === null || onRequestReview === void 0 ? void 0 : onRequestReview();
        else {
            // Do not show any ephemeral message; silently ignore and notify via callback
            onNoReviewAvailable === null || onNoReviewAvailable === void 0 ? void 0 : onNoReviewAvailable();
        }
    };
    const handleCtrlR = () => {
        // Allow ctrl+r anywhere to request review (Message/Decision modes)
        if (_constants_js__WEBPACK_IMPORTED_MODULE_8__/* .REVIEW_MODE_ENABLED */ .hD) {
            maybeRequestReview();
        }
    };
    const at = (0,_hooks_prompt_use_at_palette_js__WEBPACK_IMPORTED_MODULE_13__/* .useAtPalette */ .g)(value, { rgPath });
    const syncImageRefsWithValueRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(() => { });
    const replaceImagePathsWithTokensRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)((input) => input);
    const convertAtImageMentionsInChangedSpanRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)((_prev, next) => next);
    const applyPromptChange = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((next) => {
        if (ephemeralLinesCountRef.current > 0 &&
            !next.startsWith("/") &&
            next.trim().length > 0) {
            ephemeral.clear();
        }
        onChange(next);
        syncImageRefsWithValueRef.current(next);
    }, [ephemeral.clear, onChange]);
    // Only convert image-like paths to @image-N when the change originated from a paste/drag event.
    const pendingPasteReplacementRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(false);
    const handleUserChange = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((next) => {
        // Enter bash mode when typing '!' as the very first input
        if (!value && next === "!") {
            setBashModeActive(true);
            // Do not insert the '!'; switch prompt symbol instead
            applyPromptChange("");
            setCursorToEndSignal(s => s + 1);
            return;
        }
        // Filter control characters like Unit Separator (\x1F) that some terminals send for Ctrl-/
        if (next.includes("\x1f")) {
            next = next.replace(/\x1f/g, "");
        }
        const now = Date.now();
        const prevVal = lastValueRef.current;
        // Only replace on explicit paste/drag signal captured by onPaste.
        const wantsAggressiveReplace = pendingPasteReplacementRef.current;
        // Compute caret-sensitive changed span between prev and next (indices in next)
        const computeChangedSpan = (a, b) => {
            if (a === b)
                return null;
            let i = 0;
            const minLen = Math.min(a.length, b.length);
            while (i < minLen && a[i] === b[i])
                i++;
            let ai = a.length - 1;
            let bi = b.length - 1;
            while (ai >= i && bi >= i && a[ai] === b[bi]) {
                ai--;
                bi--;
            }
            const start = i;
            const end = bi + 1;
            if (start > end)
                return null;
            return { start, end };
        };
        const changedSpan = computeChangedSpan(prevVal, next);
        const shouldReplace = wantsAggressiveReplace && changedSpan != null;
        const produced = shouldReplace
            ? replaceImagePathsWithTokensRef.current(next, changedSpan !== null && changedSpan !== void 0 ? changedSpan : undefined)
            : next;
        applyPromptChange(produced);
        // Reset the paste flag after the first change post-paste so we never
        // convert proactively during normal typing.
        if (wantsAggressiveReplace)
            pendingPasteReplacementRef.current = false;
        lastChangeTimeRef.current = now;
        lastValueRef.current = produced;
        if (history.inHistory) {
            history.down(next); // will exit on next if at -1; noop here
        }
        suppressNextReviewRef.current = false;
    }, [applyPromptChange, history, value]);
    const handleProgrammaticChange = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((next) => {
        applyPromptChange(next);
    }, [applyPromptChange]);
    const handleResumeChat = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((folder) => __awaiter(void 0, void 0, void 0, function* () {
        if (onResumeChat)
            yield onResumeChat(folder);
        else
            ephemeral.set([
                [{ text: `Resuming chat ${folder}...`, color: "cyan" }],
            ]);
    }), [onResumeChat, ephemeral]);
    const slashHelpers = (0,react__WEBPACK_IMPORTED_MODULE_6__.useMemo)(() => ({
        onModelChange: setCurrentModel,
        insertText: (txt) => handleProgrammaticChange(txt),
        print: (lines, options) => {
            ephemeral.set(lines, options);
        },
        onHistoryCleared: () => history.clearAllLocal(),
        exit: (isLogout) => handleExit(isLogout),
        onResumeChat: handleResumeChat,
        getChatId,
        logout: onLogout,
        onNewChat,
        onSummarize,
    }), [
        setCurrentModel,
        handleProgrammaticChange,
        ephemeral,
        history,
        handleExit,
        handleResumeChat,
        getChatId,
        onLogout,
        onNewChat,
        onSummarize,
    ]);
    const slash = (0,_hooks_prompt_use_slash_palette_js__WEBPACK_IMPORTED_MODULE_16__/* .useSlashPalette */ .e)(value, slashCommands, slashHelpers);
    const getPlaceholder = () => {
        var _a;
        switch (inputMode) {
            case "decision":
                return "Waiting for decision (y/n/p)...";
            case "rejection-reason":
                return "Reason for rejection: Enter to submit, Ctrl+C to skip";
            case "plan-revision":
                return "Describe how to revise the plan (Enter to submit)";
            default: {
                if (bashModeActive) {
                    const columns = typeof ((_a = process.stdout) === null || _a === void 0 ? void 0 : _a.columns) === "number"
                        ? process.stdout.columns
                        : 80;
                    const example = isRepository
                        ? "git status"
                        :  false
                            ? 0
                            : "ls";
                    if (columns >= 50)
                        return `Run a command — e.g., ${example}`;
                    return "Run a command";
                }
                return isEmptyChat ? "Plan, search, build anything" : "Add a follow-up";
            }
        }
    };
    const effectiveBorderColor = (() => {
        var _a;
        // Gray border only after quit is actually triggered (via state we set when executing /quit) or Ctrl+C exit confirmation, not merely typing /quit.
        if (exitMode || quitting) {
            return "gray";
        }
        // Bash mode uses a gold/yellow border
        if (bashModeActive) {
            return "yellow";
        }
        if (borderColorFocused || borderColorBlurred) {
            return (_a = borderColorFocused !== null && borderColorFocused !== void 0 ? borderColorFocused : borderColorBlurred) !== null && _a !== void 0 ? _a : "foreground";
        }
        switch (inputMode) {
            case "decision":
                return "yellow";
            case "rejection-reason":
                return "red";
            case "plan-revision":
                return "cyan";
            default:
                return "foreground";
        }
    })();
    const buildSlashEnv = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => ({
        onModelChange: setCurrentModel,
        insertText: (txt) => {
            if (txt === "")
                ephemeral.preserveNextClear();
            handleProgrammaticChange(txt);
        },
        enterShellMode: () => {
            setBashModeActive(true);
            // Ensure input is empty and caret ready
            handleProgrammaticChange("");
            setCursorToEndSignal(s => s + 1);
        },
        clearInput: () => {
            ephemeral.preserveNextClear();
            handleProgrammaticChange("");
        },
        print: (lines, options) => ephemeral.set(lines, options),
        exit: (isLogout) => handleExit(isLogout),
        onHistoryCleared: () => history.clearAllLocal(),
        onResumeChat: handleResumeChat,
        getChatId,
        logout: onLogout,
        onNewChat,
        onSummarize,
        submitMessage: (message, meta) => {
            // Clear the input and submit the message
            handleProgrammaticChange("");
            onSubmit(message, meta);
        },
    }), [
        handleProgrammaticChange,
        handleExit,
        handleResumeChat,
        onSubmit,
        ephemeral,
        history,
        setCurrentModel,
        onLogout,
        onNewChat,
        onSummarize,
        getChatId,
    ]);
    const handleUnknownCmd = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((unknown) => {
        setTimeout(() => {
            ephemeral.set([
                `Unknown command: /${unknown}`,
                "Type / and start typing to see suggestions.",
            ]);
        }, 0);
    }, [ephemeral]);
    const parseSlashInput = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((input) => {
        if (!input.startsWith("/"))
            return null;
        const term = input.slice(1);
        const parts = term.split(/\s+/).filter(Boolean);
        const cmdId = parts[0] || "";
        const args = parts.slice(1);
        const cmd = slashCommands.find(c => c.id.toLowerCase() === cmdId.toLowerCase());
        const required = ((cmd === null || cmd === void 0 ? void 0 : cmd.args) || []).filter(a => a.required !== false).length;
        return { cmdId, args, required, hasCmd: !!cmd };
    }, [slashCommands]);
    const isSlashReady = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((input) => {
        const parsed = parseSlashInput(input);
        return Boolean((parsed === null || parsed === void 0 ? void 0 : parsed.hasCmd) && parsed.args.length >= parsed.required);
    }, [parseSlashInput]);
    const runSlashInput = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((input) => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield slash.runIfExecutable(input, slashCommands, buildSlashEnv(), q => setQuitting(q), handleUnknownCmd);
        if (result === "unknown") {
            return true;
        }
        return result !== "not-a-command";
    }), [slash, slashCommands, buildSlashEnv, handleUnknownCmd]);
    const handleSubmit = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((inputValue) => __awaiter(void 0, void 0, void 0, function* () {
        var _a;
        // In Shell Mode, ignore empty submits (do nothing)
        if (bashModeActive && inputValue.trim().length === 0) {
            return;
        }
        const expandLargePastedPlaceholders = (text) => {
            if (largePastedTextRef.current.size === 0)
                return text;
            return text.replace(LARGE_PASTE_PLACEHOLDER_RE, (match, idStr) => {
                const id = Number(idStr);
                const replacement = largePastedTextRef.current.get(id);
                return replacement != null ? replacement : match;
            });
        };
        // AT palette acceptance
        if (at.active) {
            const expanded = at.acceptExpansion(inputValue);
            if (expanded != null) {
                const converted = convertAtImageMentionsInChangedSpanRef.current(inputValue, expanded);
                handleProgrammaticChange(converted);
                setCursorToEndSignal(s => s + 1);
                return;
            }
        }
        // Slash palette: try accepting current selection first (works for leading and inline)
        if (slash.active) {
            const expanded = slash.acceptExpansion(inputValue);
            if (expanded != null && expanded !== inputValue) {
                handleProgrammaticChange(expanded);
                setCursorToEndSignal(s => s + 1);
                return;
            }
        }
        // Slash palette expansion or execution (leading '/...')
        if (inputValue.startsWith("/")) {
            if (slash.active) {
                // already attempted generic accept above
            }
            if (isSlashReady(inputValue)) {
                const parsed = parseSlashInput(inputValue);
                const deferHelp = parsed &&
                    parsed.cmdId.toLowerCase() === "help" &&
                    parsed.args.length === 0;
                if (!deferHelp) {
                    // If the selection is visible and exactly matches the last token, prefer filling over immediate run.
                    const selectionMatches = slash.active &&
                        ((_a = slash.items[slash.index]) === null || _a === void 0 ? void 0 : _a.identifier) &&
                        inputValue
                            .trimEnd()
                            .endsWith(slash.items[slash.index].identifier);
                    if (!selectionMatches) {
                        if (yield runSlashInput(inputValue))
                            return;
                    }
                }
            }
            {
                const parsed = parseSlashInput(inputValue);
                const deferHelp = parsed &&
                    parsed.cmdId.toLowerCase() === "help" &&
                    parsed.args.length === 0;
                if (!deferHelp) {
                    if (yield runSlashInput(inputValue))
                        return;
                }
                if ((parsed === null || parsed === void 0 ? void 0 : parsed.hasCmd) &&
                    parsed.cmdId.toLowerCase() === "help" &&
                    parsed.args.length === 0 &&
                    !inputValue.endsWith(" ")) {
                    handleProgrammaticChange(`${inputValue} `);
                    setCursorToEndSignal(s => s + 1);
                    return;
                }
            }
            // If '/unknown', keep the text so user can edit after seeing ephemeral
            // For partial '/cmd' without required args, insert a trailing space to guide typing
            const parsed = parseSlashInput(inputValue);
            if ((parsed === null || parsed === void 0 ? void 0 : parsed.hasCmd) &&
                parsed.args.length < parsed.required &&
                !inputValue.endsWith(" ")) {
                handleProgrammaticChange(`${inputValue} `);
                setCursorToEndSignal(s => s + 1);
                return;
            }
        }
        // Inline trailing '/cmd' handling, e.g., "hello world /shell"
        {
            const inlineMatch = /^(.*?)(\s+)\/(\S.*)$/.exec(inputValue);
            if (inlineMatch) {
                // Try to execute inline command
                const result = yield runSlashInput(inputValue);
                if (result)
                    return;
            }
        }
        // Check for quit/exit as regular input (not just slash commands)
        const trimmedInput = inputValue.trim();
        if (trimmedInput === "quit" || trimmedInput === "exit") {
            handleExit(false);
            return;
        }
        const finalValue = expandLargePastedPlaceholders(inputValue);
        // Don't record plan revision in history
        if (inputMode !== "plan-revision") {
            yield history.record(finalValue);
        }
        let clearedEarly = false;
        if (bashModeActive) {
            if (!onSubmitShell) {
                // Shell mode active but no handler available – do not submit as a message.
                // Inform the user and keep shell mode/input intact.
                ephemeral.set([
                    "Shell mode isn't available in this context.",
                    "Press Esc to exit shell mode or submit a normal message.",
                ]);
                return;
            }
            // Clear input immediately on bash submit and exit bash mode
            setBashModeActive(false);
            handleProgrammaticChange("");
            setCursorToEndSignal(s => s + 1);
            clearedEarly = true;
            yield onSubmitShell(finalValue);
        }
        else {
            // Non-shell submissions: delegate clearing to the parent handler to avoid double-clear
            onSubmit(finalValue, { display: inputValue });
        }
        ephemeral.clear();
        // Defer palette/ephemeral cleanup
        setTimeout(() => {
            at.hide();
            slash.hide();
            // Clear image references only if we cleared input locally (shell path)
            if (clearedEarly && imageTokenMapRef.current.size > 0) {
                imageTokenMapRef.current.clear();
                tokenOrderRef.current = [];
                onImagesUpdated === null || onImagesUpdated === void 0 ? void 0 : onImagesUpdated([]);
            }
        }, 0);
        // For non-shell submissions, do not clear here (parent decides when to clear).
    }), [
        at,
        slash,
        ephemeral,
        onImagesUpdated,
        history,
        onSubmit,
        onSubmitShell,
        bashModeActive,
        handleExit,
        handleProgrammaticChange,
        inputMode,
        isSlashReady,
        parseSlashInput,
        runSlashInput,
    ]);
    const handleSubmitVoid = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((inputValue) => {
        void handleSubmit(inputValue);
    }, [handleSubmit]);
    // Debounce window to avoid double-accept during rapid Tab auto-repeat
    // when an expansion just applied
    const lastTabAcceptTs = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(0);
    const onTab = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
        const now = Date.now();
        // Palette acceptance takes precedence over mode toggle
        if (paletteMode === "at" && at.active) {
            // Drop extremely rapid repeated Tabs within 200ms of a previous accept
            // If we drop below this debounce threshold we can see weird behavior
            // with accepting @-mention suggestions.
            if (now - lastTabAcceptTs.current < TAB_DEBOUNCE_MS) {
                return;
            }
            const rebuilt = at.acceptExpansion(value);
            if (rebuilt != null) {
                const converted = convertAtImageMentionsInChangedSpanRef.current(value, rebuilt);
                handleProgrammaticChange(converted);
                setCursorToEndSignal(s => s + 1);
                lastTabAcceptTs.current = Date.now();
                return;
            }
        }
        if (paletteMode === "slash" && slash.active) {
            if (now - lastTabAcceptTs.current < TAB_DEBOUNCE_MS) {
                return;
            }
            const rebuilt = slash.acceptExpansion(value);
            if (rebuilt != null) {
                handleProgrammaticChange(rebuilt);
                setCursorToEndSignal(s => s + 1);
                lastTabAcceptTs.current = Date.now();
                return;
            }
        }
        // Fallbacks for '/': if lone '/', accept top suggestion; if '/cmd' and args pending, insert space
        if (value === "/" && slash.active && slash.items.length > 0) {
            const rebuilt = slash.acceptExpansion(value);
            if (rebuilt != null) {
                handleProgrammaticChange(rebuilt);
                setCursorToEndSignal(s => s + 1);
                return;
            }
        }
        if (value.startsWith("/") && !value.endsWith(" ") && !isSlashReady(value)) {
            handleProgrammaticChange(`${value} `);
            setCursorToEndSignal(s => s + 1);
            return;
        }
        // No-op: background toggle removed
    }, [at, value, slash, handleProgrammaticChange, isSlashReady, paletteMode]);
    const handleCtrlC = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
        if (exitMode) {
            // Clear the input so we do not leave a partially typed command on screen, but retain exitMode so border stays gray.
            handleProgrammaticChange("");
            onCtrlC === null || onCtrlC === void 0 ? void 0 : onCtrlC();
            handleExit();
            return;
        }
        (0,_debug_js__WEBPACK_IMPORTED_MODULE_11__.debugLog)("handleCtrlC", inputMode);
        // Decision mode Ctrl+C is handled exclusively in the decision-mode useInput below
        if (inputMode === "decision")
            return;
        // In plan decision/revision modes, return to normal message input
        if (inputMode === "plan-revision") {
            // Switch back to message mode and clear transient UI state
            onDiscardPlan === null || onDiscardPlan === void 0 ? void 0 : onDiscardPlan();
            onChange("");
            at.hide();
            slash.hide();
            history.reset();
            return;
        }
        // In plan suggestion mode, Ctrl+C rejects the plan and returns to normal input
        if (isSuggestingPlan) {
            onChange("");
            onRejectPlan === null || onRejectPlan === void 0 ? void 0 : onRejectPlan();
            // Abort the stream when rejecting
            onCtrlC === null || onCtrlC === void 0 ? void 0 : onCtrlC();
            return;
        }
        // If Shell Mode is active, exit Shell Mode instead of triggering exit flow
        if (bashModeActive) {
            setBashModeActive(false);
            // Clear any input and related UI state
            handleProgrammaticChange("");
            at.hide();
            slash.hide();
            history.reset();
            return;
        }
        // In rejection reason mode, Ctrl+C should skip providing a reason (no exit)
        if (inputMode === "rejection-reason") {
            onSkipRejectionReason === null || onSkipRejectionReason === void 0 ? void 0 : onSkipRejectionReason();
            onChange("");
            // Ensure any palette/history state is reset when clearing
            at.hide();
            slash.hide();
            history.reset();
            return;
        }
        // Clear input first if there's any text; do not abort yet
        if (value.length > 0) {
            ephemeral.preserveNextClear();
            handleProgrammaticChange("");
            // Also reset related UI state immediately
            at.hide();
            slash.hide();
            history.reset();
            // Set exit mode so the footer shows "Press Ctrl+C again to exit"
            setExitMode(true);
            (0,_analytics_js__WEBPACK_IMPORTED_MODULE_7__/* .trackCancelAndFlush */ .B5)();
            return;
        }
        (0,_debug_js__WEBPACK_IMPORTED_MODULE_11__.debugLog)("handleCtrlC isProcessing", isProcessing);
        (0,_debug_js__WEBPACK_IMPORTED_MODULE_11__.debugLog)("handleCtrlC exitMode", exitMode);
        // If we're processing (generating), abort the run
        if (isProcessing) {
            onCtrlC === null || onCtrlC === void 0 ? void 0 : onCtrlC();
            setExitMode(true);
            (0,_analytics_js__WEBPACK_IMPORTED_MODULE_7__/* .trackCancelAndFlush */ .B5)();
            return;
        }
        // If we reach here, prompt is empty and we're not processing or in special modes
        // Exit immediately instead of requiring a second Ctrl-C
        handleExit();
    }, [
        inputMode,
        isSuggestingPlan,
        bashModeActive,
        value.length,
        isProcessing,
        exitMode,
        onDiscardPlan,
        onRejectPlan,
        onChange,
        at,
        slash,
        history,
        onCtrlC,
        handleProgrammaticChange,
        onSkipRejectionReason,
        ephemeral,
        handleExit,
    ]);
    const handleCtrlD = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
        // Immediate quit, regardless of state
        // Clear any input and exit cleanly
        handleProgrammaticChange("");
        onCtrlC === null || onCtrlC === void 0 ? void 0 : onCtrlC(); // propagate any cancellation hooks (e.g., stop processing)
        handleExit();
    }, [handleExit, handleProgrammaticChange, onCtrlC]);
    paletteMode = at.active ? "at" : slash.active ? "slash" : "none";
    // When input is cleared, ensure palettes are not intercepting navigation
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
        if (value.length === 0) {
            at.hide();
            slash.hide();
            history.reset();
        }
    }, [value, at, slash, history]);
    const isPaletteTriggering = slash.active || (_hooks_prompt_use_at_palette_js__WEBPACK_IMPORTED_MODULE_13__/* .AT_REGEX */ .q.test(value) && at.active);
    const _canEnterReviewOnDown = inputMode === "message" && paletteMode === "none" && !isPaletteTriggering;
    const inDecision = inputMode === "decision" && pendingDecisions.length > 0;
    const [decisionIndex, setDecisionIndex] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(0);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
        if (inDecision && !wasInDecisionRef.current) {
            if (cachedMessageRef.current == null && value.length > 0) {
                cachedMessageRef.current = value;
                onChange("");
            }
        }
        if (!inDecision && wasInDecisionRef.current) {
            if (inputMode === "message" &&
                value.length === 0 &&
                cachedMessageRef.current != null) {
                onChange(cachedMessageRef.current);
                cachedMessageRef.current = null;
            }
        }
        wasInDecisionRef.current = inDecision;
    }, [inDecision, inputMode, value, onChange]);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
        if (inputMode === "message" &&
            !inDecision &&
            value.length === 0 &&
            cachedMessageRef.current != null) {
            onChange(cachedMessageRef.current);
            cachedMessageRef.current = null;
        }
    }, [inputMode, inDecision, value, onChange]);
    // --- Image paste / drag-and-drop handling ---
    const imageTokenMapRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(new Map()); // path -> token
    const tokenOrderRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)([]); // preserve order for stable numbering
    const _imageGlobalCounterRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(0); // global counter for stable, session-unique tokens
    // Local store for large pasted text blocks
    const largePastedTextRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(new Map());
    const nextLargePasteIdRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(1);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
        if (value.length === 0) {
            if (imageTokenMapRef.current.size > 0) {
                imageTokenMapRef.current.clear();
                tokenOrderRef.current = [];
                onImagesUpdated === null || onImagesUpdated === void 0 ? void 0 : onImagesUpdated([]);
            }
        }
    }, [value.length, onImagesUpdated]);
    const buildTokenForPath = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((p) => {
        const existing = imageTokenMapRef.current.get(p);
        if (existing)
            return existing;
        const rawBase = node_path__WEBPACK_IMPORTED_MODULE_2___default().basename(p);
        const safeBase = rawBase
            .replace(/\s+/g, "_")
            .replace(/[^A-Za-z0-9._-]/g, "");
        const token = `@image[${safeBase}]`;
        imageTokenMapRef.current.set(p, token);
        tokenOrderRef.current.push(p);
        onImagesUpdated === null || onImagesUpdated === void 0 ? void 0 : onImagesUpdated(tokenOrderRef.current.map(path => ({
            token: imageTokenMapRef.current.get(path),
            path,
        })));
        return token;
    }, [onImagesUpdated]);
    const syncImageRefsWithValue = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((input) => {
        // Build the set of tokens present in the current input
        const tokensInInput = new Set();
        for (const m of input.matchAll(/@image\[[^\]]+\]/g)) {
            tokensInInput.add(m[0]);
        }
        // Compute which paths remain based on tokens still present, preserving order
        const prevMap = imageTokenMapRef.current;
        const keptPaths = [];
        for (const p of tokenOrderRef.current) {
            const tok = prevMap.get(p);
            if (tok && tokensInInput.has(tok))
                keptPaths.push(p);
        }
        // Rebuild map from kept paths, preserving original tokens
        const nextMap = new Map();
        for (const p of keptPaths) {
            const tok = prevMap.get(p);
            nextMap.set(p, tok);
        }
        imageTokenMapRef.current = nextMap;
        tokenOrderRef.current = keptPaths.slice();
        // Publish update
        onImagesUpdated === null || onImagesUpdated === void 0 ? void 0 : onImagesUpdated(tokenOrderRef.current.map(path => ({
            token: imageTokenMapRef.current.get(path),
            path,
        })));
    }, [onImagesUpdated]);
    syncImageRefsWithValueRef.current = syncImageRefsWithValue;
    const replaceImagePathsWithTokens = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((input, changedSpan) => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        if (!hasLikelyImageExt(input))
            return input;
        let replacedCount = 0;
        const MAX_REPLACEMENTS = 64;
        const replaceOne = (rawPath) => {
            if (replacedCount >= MAX_REPLACEMENTS)
                return rawPath;
            const norm0 = normalizePotentialPath(rawPath);
            const candidatesSet = new Set([norm0]);
            candidatesSet.add(norm0.replace(/\u00A0/g, " "));
            candidatesSet.add(norm0.replace(/\u202F/g, " "));
            if (norm0.includes(" ")) {
                candidatesSet.add(norm0.replace(/ /g, "\u00A0"));
                candidatesSet.add(norm0.replace(/ /g, "\u202F"));
            }
            let existing = null;
            for (const cand of candidatesSet) {
                try {
                    if (node_fs__WEBPACK_IMPORTED_MODULE_1___default().existsSync(cand)) {
                        existing = cand;
                        break;
                    }
                }
                catch (_a) {
                    /* ignore */
                }
            }
            if (!existing) {
                if (isLikelyTempPath(norm0))
                    existing = norm0;
                else
                    return rawPath;
            }
            const token = buildTokenForPath(existing);
            replacedCount++;
            return token;
        };
        const matches = [];
        const overlapsChanged = (start, end) => {
            if (!changedSpan)
                return true;
            return end > changedSpan.start && start < changedSpan.end;
        };
        for (const m of input.matchAll(reUnquotedWithQuotedSpaces)) {
            const idx = (_a = m.index) !== null && _a !== void 0 ? _a : 0;
            const prefix = (_b = m[1]) !== null && _b !== void 0 ? _b : "";
            const joinedSeq = (_c = m[2]) !== null && _c !== void 0 ? _c : "";
            const pathStart = idx + prefix.length;
            const pathEnd = pathStart + joinedSeq.length;
            if (!overlapsChanged(pathStart, pathEnd))
                continue;
            matches.push({
                start: pathStart,
                end: pathEnd,
                path: joinedSeq.replace(/'\s'/g, " "),
            });
        }
        for (const m of input.matchAll(reQuotedDouble)) {
            const idx = (_d = m.index) !== null && _d !== void 0 ? _d : 0;
            const full = (_e = m[0]) !== null && _e !== void 0 ? _e : "";
            const p1 = (_f = m[1]) !== null && _f !== void 0 ? _f : "";
            const start = idx;
            const end = idx + full.length;
            if (!overlapsChanged(start, end))
                continue;
            matches.push({ start, end, path: p1 });
        }
        for (const m of input.matchAll(reQuotedSingle)) {
            const idx = (_g = m.index) !== null && _g !== void 0 ? _g : 0;
            const full = (_h = m[0]) !== null && _h !== void 0 ? _h : "";
            const p1 = (_j = m[1]) !== null && _j !== void 0 ? _j : "";
            const start = idx;
            const end = idx + full.length;
            if (!overlapsChanged(start, end))
                continue;
            matches.push({ start, end, path: p1 });
        }
        for (const m of input.matchAll(reUnquoted)) {
            const idx = (_k = m.index) !== null && _k !== void 0 ? _k : 0;
            const prefix = (_l = m[1]) !== null && _l !== void 0 ? _l : "";
            const p = (_m = m[2]) !== null && _m !== void 0 ? _m : "";
            const start = idx + prefix.length;
            const end = start + p.length;
            if (!overlapsChanged(start, end))
                continue;
            matches.push({ start, end, path: p });
        }
        for (const m of input.matchAll(reAbsWithSpaces)) {
            const idx = (_o = m.index) !== null && _o !== void 0 ? _o : 0;
            const prefix = (_p = m[1]) !== null && _p !== void 0 ? _p : "";
            const p = (_q = m[2]) !== null && _q !== void 0 ? _q : "";
            const start = idx + prefix.length;
            const end = start + p.length;
            if (!overlapsChanged(start, end))
                continue;
            matches.push({ start, end, path: p });
        }
        if (matches.length === 0)
            return input;
        matches.sort((a, b) => a.start - b.start || b.end - b.start - (a.end - a.start));
        const filtered = [];
        let lastEnd = -1;
        for (const m of matches) {
            if (m.start < lastEnd)
                continue;
            filtered.push(m);
            lastEnd = m.end;
        }
        let out = "";
        let cursor = 0;
        for (const m of filtered) {
            if (cursor < m.start)
                out += input.slice(cursor, m.start);
            const tokenOrPath = replaceOne(m.path);
            out += tokenOrPath;
            cursor = m.end;
        }
        out += input.slice(cursor);
        out = out.replace(/(@image\[[^\]]+\])(?!\s)/g, "$1 ");
        return out;
    }, [buildTokenForPath]);
    replaceImagePathsWithTokensRef.current = replaceImagePathsWithTokens;
    // Convert accepted @-mentions of image paths into @image-N tokens and update selection map
    const convertAtImageMentionsInChangedSpan = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((prevValue, nextValue) => {
        var _a, _b, _c;
        // Reuse the same changed span computation from handleUserChange
        const computeChangedSpan = (a, b) => {
            if (a === b)
                return null;
            let i = 0;
            const minLen = Math.min(a.length, b.length);
            while (i < minLen && a[i] === b[i])
                i++;
            let ai = a.length - 1;
            let bi = b.length - 1;
            while (ai >= i && bi >= i && a[ai] === b[bi]) {
                ai--;
                bi--;
            }
            const start = i;
            const end = bi + 1;
            if (start > end)
                return null;
            return { start, end };
        };
        const changed = computeChangedSpan(prevValue, nextValue);
        if (changed == null)
            return nextValue;
        // Match @<path> where <path> looks like an image file
        const reAtImage = new RegExp(String.raw `@((?:file://)?[^\s'"()]+?\.(${IMAGE_EXTS.join("|")}))`, "gi");
        const matches = [];
        for (const m of nextValue.matchAll(reAtImage)) {
            const idx = (_a = m.index) !== null && _a !== void 0 ? _a : 0;
            const full = (_b = m[0]) !== null && _b !== void 0 ? _b : ""; // includes leading '@'
            const p1 = (_c = m[1]) !== null && _c !== void 0 ? _c : ""; // path after '@'
            const start = idx;
            const end = idx + full.length;
            // Only transform if overlap with the changed span
            if (!(end > changed.start && start < changed.end))
                continue;
            matches.push({ start, end, path: p1 });
        }
        if (matches.length === 0)
            return nextValue;
        // Build output by replacing from left to right without overlapping
        matches.sort((a, b) => a.start - b.start || b.end - a.end);
        const filtered = [];
        let lastEnd = -1;
        for (const m of matches) {
            if (m.start < lastEnd)
                continue;
            filtered.push(m);
            lastEnd = m.end;
        }
        let out = "";
        let cursor = 0;
        for (const m of filtered) {
            if (cursor < m.start)
                out += nextValue.slice(cursor, m.start);
            // Normalize and verify path existence (or temp), then generate token
            const norm0 = normalizePotentialPath(m.path);
            let existing = null;
            const candidatesSet = new Set([norm0]);
            candidatesSet.add(norm0.replace(/\u00A0/g, " "));
            candidatesSet.add(norm0.replace(/\u202F/g, " "));
            try {
                for (const cand of candidatesSet) {
                    if (node_fs__WEBPACK_IMPORTED_MODULE_1___default().existsSync(cand)) {
                        existing = cand;
                        break;
                    }
                }
            }
            catch (_d) {
                /* ignore */
            }
            if (!existing && isLikelyTempPath(norm0))
                existing = norm0;
            if (existing) {
                const token = buildTokenForPath(existing);
                out += token;
            }
            else {
                // Fallback: keep original text if path is not valid
                out += nextValue.slice(m.start, m.end);
            }
            cursor = m.end;
        }
        out += nextValue.slice(cursor);
        // Ensure a space after tokens if missing
        out = out.replace(/(@image\[[^\]]+\])(?!\s)/g, "$1 ");
        return out;
    }, [buildTokenForPath]);
    convertAtImageMentionsInChangedSpanRef.current =
        convertAtImageMentionsInChangedSpan;
    const extractCandidateImagePaths = (content) => {
        if (!hasLikelyImageExt(content))
            return [];
        const candidates = [];
        // double-quoted
        for (const m of content.matchAll(reQuotedDouble)) {
            if (m[1])
                candidates.push(m[1]);
        }
        // single-quoted
        for (const m of content.matchAll(reQuotedSingle)) {
            if (m[1])
                candidates.push(m[1]);
        }
        // unquoted with prefix capture in group 1 and path in group 2
        for (const m of content.matchAll(reUnquoted)) {
            if (m[2])
                candidates.push(m[2]);
        }
        // absolute with spaces
        for (const m of content.matchAll(reAbsWithSpaces)) {
            if (m[2])
                candidates.push(m[2]);
        }
        // unquoted sequences split by "' '"
        for (const m of content.matchAll(reUnquotedWithQuotedSpaces)) {
            if (m[2])
                candidates.push(m[2].replace(/'\s'/g, " "));
        }
        return candidates;
    };
    // Single input handler for both decision and message modes
    (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .useInput */ .Ge)((inp, key) => {
        var _a, _b;
        // ========================================
        // PLAN SUGGESTION MODE HANDLING
        // ========================================
        if (isSuggestingPlan) {
            // Plan decision navigation (up/down arrows to select options)
            if (key.upArrow) {
                setPlanDecisionIndex === null || setPlanDecisionIndex === void 0 ? void 0 : setPlanDecisionIndex(Math.max(0, (planDecisionIndex !== null && planDecisionIndex !== void 0 ? planDecisionIndex : 0) - 1));
                return;
            }
            if (key.downArrow) {
                setPlanDecisionIndex === null || setPlanDecisionIndex === void 0 ? void 0 : setPlanDecisionIndex(Math.min(1, (planDecisionIndex !== null && planDecisionIndex !== void 0 ? planDecisionIndex : 0) + 1));
                return;
            }
            // Enter key: execute the selected option
            if (key.return) {
                if (planDecisionIndex === 0) {
                    // Accept and proceed
                    onChange("");
                    void (onExecutePlan === null || onExecutePlan === void 0 ? void 0 : onExecutePlan());
                }
                else {
                    // Reject and propose changes
                    onChange("");
                    onRejectPlan === null || onRejectPlan === void 0 ? void 0 : onRejectPlan();
                    // Abort the stream when rejecting
                    onCtrlC === null || onCtrlC === void 0 ? void 0 : onCtrlC();
                }
                return;
            }
            // Direct accept shortcuts (bypass selection)
            if (inp === "y" || inp === "Y") {
                onChange("");
                void (onExecutePlan === null || onExecutePlan === void 0 ? void 0 : onExecutePlan());
                return;
            }
            // Direct reject shortcuts (bypass selection)
            const isEscapeKey = key.escape || (key.ctrl && inp === "c") || (key.ctrl && inp === "C");
            if (inp === "n" || inp === "N" || isEscapeKey) {
                onChange("");
                onRejectPlan === null || onRejectPlan === void 0 ? void 0 : onRejectPlan();
                // Abort the stream when rejecting
                onCtrlC === null || onCtrlC === void 0 ? void 0 : onCtrlC();
                return;
            }
            // Ignore all other input while in plan mode
            return;
        }
        // Immediate quit on Ctrl+D while in decision mode
        const isCtrlD = (key.ctrl && (inp === "d" || inp === "D")) || inp === "\u0004";
        if (isCtrlD && inputMode === "decision") {
            handleExit();
            return;
        }
        // First-class action: Cmd+/ or Ctrl+/ cycles through available models
        // Note: Many terminals send Ctrl+/ as ASCII 0x1F (Unit Separator, '\x1f').
        // Cmd is typically not delivered to TTY apps; key.meta represents Alt/Meta.
        const isUnitSep = inp === "\x1f"; // common Ctrl-/ mapping
        const isCtrlSlash = key.ctrl && inp === "/";
        const isMetaSlash = key.meta && inp === "/"; // Alt/Meta, not true Command
        if (isUnitSep || isCtrlSlash || isMetaSlash) {
            // Prevent the control character from being inserted into the prompt
            if (value.includes("\x1f")) {
                handleProgrammaticChange(value.replace(/\x1f/g, ""));
            }
            void (() => __awaiter(void 0, void 0, void 0, function* () {
                try {
                    const list = yield modelManager.awaitAvailableModels();
                    const currentModel = yield modelManager.awaitCurrentModel();
                    if (list.length === 0)
                        return;
                    const curId = currentModel.modelId;
                    const idx = Math.max(0, list.findIndex((m) => m.modelId === curId));
                    const next = list[(idx + 1) % list.length];
                    if (!next || next.modelId === curId)
                        return;
                    setCurrentModel(next);
                }
                catch (_a) {
                    /* ignore */
                }
            }))();
            return;
        }
        // Global unified list picker: Ctrl+Y opens the same as '/list'
        // Handle both the control character (\u0019) and explicit ctrl-modified 'y'
        const isCtrlYChar = inp === "\u0019"; // ^Y
        if (isCtrlYChar || (key.ctrl && (inp === "y" || inp === "Y"))) {
            // Prevent the control character from being inserted into the prompt, if any
            if (value.includes("\u0019")) {
                handleProgrammaticChange(value.replace(/\u0019/g, ""));
            }
            void runSlashInput("/list");
            return;
        }
        // Global compact toggle: Ctrl+O
        const isCtrlOChar = inp === "\u000f"; // ^O control character
        if (isCtrlOChar || (key.ctrl && (inp === "o" || inp === "O"))) {
            // Prevent the control character from being inserted into the prompt
            if (value.includes("\u000f")) {
                handleProgrammaticChange(value.replace(/\u000f/g, ""));
            }
            setIsCompact(prev => !prev);
            return;
        }
        // ========================================
        // REGULAR DECISION MODE HANDLING
        // (for shell commands, file writes, etc.)
        // ========================================
        switch (inputMode) {
            case "decision": {
                if (pendingDecisions.length === 0)
                    return;
                const first = pendingDecisions[0];
                // ----------------------------------------
                // Decision dropdown navigation (j/k or arrows)
                // ----------------------------------------
                const isDownKey = inp === "j" ||
                    inp === "J" ||
                    inp.endsWith("j") ||
                    inp.endsWith("J");
                const isUpKey = inp === "k" ||
                    inp === "K" ||
                    inp.endsWith("k") ||
                    inp.endsWith("K");
                const optionsForSelection = buildDecisionOptions(first);
                const optionCount = optionsForSelection.length;
                if (key.downArrow || isDownKey) {
                    setDecisionIndex(i => Math.min(i + 1, optionCount - 1));
                    return;
                }
                if (key.upArrow || isUpKey) {
                    setDecisionIndex(i => Math.max(i - 1, 0));
                    return;
                }
                // ----------------------------------------
                // Decision action shortcuts
                // ----------------------------------------
                // Esc maps to propose changes
                if (key.escape) {
                    onBeginRejection === null || onBeginRejection === void 0 ? void 0 : onBeginRejection(first.id);
                    onChange("");
                    setDecisionIndex(0);
                    return;
                }
                // Review changed files shortcut (Ctrl+R only)
                if (_constants_js__WEBPACK_IMPORTED_MODULE_8__/* .REVIEW_MODE_ENABLED */ .hD &&
                    ((key.ctrl && (inp === "r" || inp === "R")) || inp === "\u0012") &&
                    changedFiles.length > 0) {
                    maybeRequestReview();
                    return;
                }
                // Handle Ctrl+C (both explicit and control character)
                const isCtrlCChar = inp === "\u0003"; // ^C control character
                if ((key.ctrl && inp === "c") || isCtrlCChar) {
                    rejectPendingDecision(first.id, undefined);
                    onChange("");
                    setDecisionIndex(0);
                    return;
                }
                if (inp === "q" || inp === "Q") {
                    rejectPendingDecision(first.id, undefined);
                    onChange("");
                    setDecisionIndex(0);
                    return;
                }
                if (inp === "y" || inp === "Y") {
                    approvePendingDecision(first.id);
                    onChange("");
                    setDecisionIndex(0);
                    return;
                }
                if (inp === "n" || inp === "N") {
                    onBeginRejection === null || onBeginRejection === void 0 ? void 0 : onBeginRejection(first.id);
                    onChange("");
                    setDecisionIndex(0);
                    return;
                }
                if (inp === "p" || inp === "P") {
                    // Explicit propose shortcut
                    onBeginRejection === null || onBeginRejection === void 0 ? void 0 : onBeginRejection(first.id);
                    onChange("");
                    setDecisionIndex(0);
                    return;
                }
                // Shift+Tab: enable auto-run and accept all pending decisions
                if (key.tab && key.shift) {
                    // Block cycling if mode switching is disabled
                    if (disableModeSwitch) {
                        return;
                    }
                    agentStore.setMetadata("mode", "auto-run");
                    // Approve all pending decisions
                    for (const decision of pendingDecisions) {
                        approvePendingDecision(decision.id);
                    }
                    onChange("");
                    setDecisionIndex(0);
                    return;
                }
                // ----------------------------------------
                // Allowlist and auto-run shortcuts
                // ----------------------------------------
                // Tab: add the first pending decision to the allowlist (if applicable) and approve only that one
                if (key.tab && !key.shift) {
                    const opType = first.operation.type;
                    if (opType === _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Shell) {
                        // Use the patterns already calculated by permissions-service
                        const details = first.operation.details;
                        const patterns = (_a = details.notAllowedCommands) !== null && _a !== void 0 ? _a : [];
                        for (const p of patterns) {
                            void (onAddToAllowList === null || onAddToAllowList === void 0 ? void 0 : onAddToAllowList("Shell", p));
                        }
                        (0,_debug_js__WEBPACK_IMPORTED_MODULE_11__.debugLog)("allowlist-requested", Object.assign(Object.assign({}, first.operation), { patterns }));
                    }
                    else if (opType === _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Write) {
                        const p = first.operation.details.path;
                        void (onAddToAllowList === null || onAddToAllowList === void 0 ? void 0 : onAddToAllowList("Write", p));
                        (0,_debug_js__WEBPACK_IMPORTED_MODULE_11__.debugLog)("allowlist-requested", first.operation);
                    }
                    approvePendingDecision(first.id);
                    onChange("");
                    setDecisionIndex(0);
                    return;
                }
                // ----------------------------------------
                // Enter key: execute selected option
                // ----------------------------------------
                if (key.return) {
                    const selected = optionsForSelection[decisionIndex];
                    if (!selected)
                        return;
                    switch (selected.action) {
                        case "approve": {
                            approvePendingDecision(first.id);
                            onChange("");
                            setDecisionIndex(0);
                            return;
                        }
                        case "reject": {
                            rejectPendingDecision(first.id, undefined);
                            onChange("");
                            setDecisionIndex(0);
                            return;
                        }
                        case "propose": {
                            onBeginRejection === null || onBeginRejection === void 0 ? void 0 : onBeginRejection(first.id);
                            onChange("");
                            setDecisionIndex(0);
                            return;
                        }
                        case "allowlistApprove": {
                            if (first.operation.type === _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Shell) {
                                // Use the patterns already calculated by permissions-service
                                const details = first.operation.details;
                                const patterns = (_b = details.notAllowedCommands) !== null && _b !== void 0 ? _b : [];
                                for (const p of patterns) {
                                    void (onAddToAllowList === null || onAddToAllowList === void 0 ? void 0 : onAddToAllowList("Shell", p));
                                }
                                (0,_debug_js__WEBPACK_IMPORTED_MODULE_11__.debugLog)("allowlist-requested", Object.assign(Object.assign({}, first.operation), { patterns }));
                            }
                            approvePendingDecision(first.id);
                            onChange("");
                            setDecisionIndex(0);
                            return;
                        }
                        case "autoRunApprove": {
                            agentStore.setMetadata("mode", "auto-run");
                            // Approve all pending decisions
                            for (const decision of pendingDecisions) {
                                approvePendingDecision(decision.id);
                            }
                            onChange("");
                            setDecisionIndex(0);
                            return;
                        }
                        default:
                            return;
                    }
                }
                return;
            }
            case "message": {
                // ESC: exit Shell Mode when active and input empty
                if (bashModeActive && value.length === 0 && key.escape) {
                    setBashModeActive(false);
                    return;
                }
                // Backspace/Delete on empty exits bash mode
                if (bashModeActive &&
                    value.length === 0 &&
                    (key.backspace || key.delete)) {
                    setBashModeActive(false);
                    return;
                }
                switch (paletteMode) {
                    case "slash": {
                        if (!slash.active || slash.items.length === 0)
                            return;
                        const isVimDown = vimEnabled && vimMode === "normal" && inp === "j";
                        const isVimUp = vimEnabled && vimMode === "normal" && inp === "k";
                        if (_constants_js__WEBPACK_IMPORTED_MODULE_8__/* .REVIEW_MODE_ENABLED */ .hD &&
                            ((key.ctrl && (inp === "r" || inp === "R")) || inp === "\u0012")) {
                            handleCtrlR();
                            return;
                        }
                        if (key.downArrow || isVimDown) {
                            slash.next();
                            return;
                        }
                        if (key.upArrow || isVimUp) {
                            slash.prev();
                            return;
                        }
                        if (key.escape) {
                            if (value === "/")
                                handleProgrammaticChange("");
                            slash.hide();
                            return;
                        }
                        return;
                    }
                    case "at": {
                        if (!at.active || at.suggestions.length === 0)
                            return;
                        const isVimDown = vimEnabled && vimMode === "normal" && inp === "j";
                        const isVimUp = vimEnabled && vimMode === "normal" && inp === "k";
                        if (_constants_js__WEBPACK_IMPORTED_MODULE_8__/* .REVIEW_MODE_ENABLED */ .hD &&
                            ((key.ctrl && (inp === "r" || inp === "R")) || inp === "\u0012")) {
                            handleCtrlR();
                            return;
                        }
                        if (key.downArrow || isVimDown) {
                            at.next();
                            return;
                        }
                        if (key.upArrow || isVimUp) {
                            at.prev();
                            return;
                        }
                        if (key.escape) {
                            at.suppress();
                            return;
                        }
                        return;
                    }
                    default:
                        break;
                }
                if (_constants_js__WEBPACK_IMPORTED_MODULE_8__/* .REVIEW_MODE_ENABLED */ .hD &&
                    ((key.ctrl && (inp === "r" || inp === "R")) || inp === "\u0012")) {
                    handleCtrlR();
                    return;
                }
                const isUpEquivalent = key.upArrow || (vimEnabled && vimMode === "normal" && inp === "k");
                if (isUpEquivalent && paletteMode === "none") {
                    const isAtFirstLine = (0,_utils_cursor_navigation_js__WEBPACK_IMPORTED_MODULE_27__/* .getLineStart */ .Jh)(value, cursorOffset) === 0;
                    if (isAtFirstLine) {
                        handleHistoryUp();
                    }
                    return;
                }
                const isDownEquivalent = key.downArrow ||
                    (vimEnabled && vimMode === "normal" && inp === "j");
                if (isDownEquivalent) {
                    handleDownAction();
                    return;
                }
                return;
            }
            case "rejection-reason":
                // Backspace/Delete on empty input returns to pending decision state (without rejecting)
                if ((key.backspace || key.delete) && value.length === 0) {
                    onCancelRejectionReason === null || onCancelRejectionReason === void 0 ? void 0 : onCancelRejectionReason();
                    onChange("");
                    return;
                }
                return;
            default:
                return;
        }
    }, {
        isActive: isFocused ||
            inputMode === "decision" ||
            paletteMode !== "none" ||
            !!isSuggestingPlan,
    });
    const paletteVisible = paletteMode !== "none";
    const deferredChangedFilesCount = (0,react__WEBPACK_IMPORTED_MODULE_6__.useDeferredValue)(changedFiles.length);
    // Defer token percent updates to reduce frequent re-renders/flicker
    const deferredTokenPercent = (0,react__WEBPACK_IMPORTED_MODULE_6__.useDeferredValue)(conversationTokenPercent);
    const tokenPercentLabel = (0,react__WEBPACK_IMPORTED_MODULE_6__.useMemo)(() => {
        if (deferredTokenPercent == null)
            return undefined;
        const asFixed = deferredTokenPercent.toFixed(1);
        return asFixed.endsWith(".0")
            ? `${Math.round(deferredTokenPercent)}%`
            : `${asFixed}%`;
    }, [deferredTokenPercent]);
    if (!shouldRender) {
        return null;
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .Box */ .az, { marginTop: topStatusMarginTop !== null && topStatusMarginTop !== void 0 ? topStatusMarginTop : 0, marginBottom: 0, marginX: 1, paddingLeft: 1, children: topStatus !== null && topStatus !== void 0 ? topStatus : (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .Text */ .EY, { children: " " }) }), pendingDecisions.length > 0 && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_prompt_pending_decisions_banner_js__WEBPACK_IMPORTED_MODULE_23__/* ["default"] */ .A, { decisions: pendingDecisions })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .Box */ .az, { display: (process.env.AGENT_CLI_HIDE_PROMPT_BAR === "true" &&
                    pendingDecisions.length === 0) ||
                    isSuggestingPlan
                    ? "none"
                    : "flex", flexDirection: "column", borderColor: effectiveBorderColor, borderTop: true, borderStyle: "single", paddingLeft: 1, marginX: 1, children: [inDecision
                        ? (() => {
                            var _a;
                            const d = pendingDecisions[0];
                            const decisionType = d.operation.type;
                            const optsForRender = buildDecisionOptions(d).map(o => ({
                                label: o.label,
                                hint: o.hint,
                                disabled: o.disabled,
                            }));
                            let title = (_a = titleForOperation[decisionType]) !== null && _a !== void 0 ? _a : "Proceed with this edit?";
                            if (d.operation.type === _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Shell) {
                                const operation = d.operation;
                                if (operation.details.isSandboxAvailable) {
                                    title = "Run this command outside the sandbox?";
                                }
                                else {
                                    title = "Run this command?";
                                }
                            }
                            const subtitle = d.operation.type === _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Shell
                                ? String(d.operation.details.reason)
                                : d.operation.type === _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_5__.OperationType.Write
                                    ? `in ${String(d.operation.details.path)}`
                                    : undefined;
                            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_prompt_decision_dropdown_js__WEBPACK_IMPORTED_MODULE_19__/* ["default"] */ .A, { title: title, highlightColor: effectiveBorderColor, options: optsForRender, selectedIndex: decisionIndex, subtitle: subtitle }));
                        })()
                        : null, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .Box */ .az, { flexDirection: "row", display: inDecision || isSuggestingPlan ? "none" : "flex", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .Text */ .EY, { color: bashModeActive ? "yellow" : "foreground", dimColor: !bashModeActive && value.length === 0, children: [bashModeActive ? "!" : promptSymbol, " "] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .Box */ .az, { flexGrow: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(PromptInput, { prompt: value, setPrompt: handleUserChange, placeholder: getPlaceholder(), rightPlaceholder: isProcessing
                                        ? "ctrl+c to stop"
                                        : vimEnabled
                                            ? vimMode === "insert"
                                                ? "INSERT"
                                                : "NORMAL"
                                            : undefined, isDisabled: isDisabled, onSubmit: handleSubmitVoid, onTab: onTab, onShiftTab: inputMode === "decision" || disableModeSwitch
                                        ? undefined
                                        : () => {
                                            const modes = _anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_3__/* .AgentModes */ .yj.slice();
                                            const isBackgroundEnabled = isEmptyChat && _constants_js__WEBPACK_IMPORTED_MODULE_8__/* .BACKGROUND_ENABLED */ .xZ && isRepository;
                                            if (!isBackgroundEnabled) {
                                                modes.splice(modes.indexOf("background"), 1);
                                            }
                                            if (!_constants_js__WEBPACK_IMPORTED_MODULE_8__/* .PLAN_ENABLED */ .S8) {
                                                modes.splice(modes.indexOf("plan"), 1);
                                            }
                                            // Cycle through execution modes: default -> auto-run -> background -> default
                                            const currentMode = agentStore.getMetadata("mode");
                                            const currentIndex = modes.indexOf(currentMode);
                                            const nextIndex = (currentIndex + 1) % modes.length;
                                            const nextMode = modes[nextIndex];
                                            agentStore.setMetadata("mode", nextMode);
                                        }, onCtrlC: handleCtrlC, onCtrlD: handleCtrlD, onCtrlR: handleCtrlR, visualFocus: inputMode === "decision" && pendingDecisions.length > 0, cursorToEndSignal: cursorToEndSignal + (externalCursorToEndSignal !== null && externalCursorToEndSignal !== void 0 ? externalCursorToEndSignal : 0), onCursorInfoChange: ({ offset, isAtLastLine }) => {
                                        setCursorOffset(offset);
                                        setCursorAtLastLine(isAtLastLine);
                                    }, onUpAtFirstLine: () => {
                                        // Avoid double-handling ArrowUp when palette is active; outer handler manages palette nav
                                        if (paletteMode !== "none")
                                            return;
                                        handleHistoryUp();
                                    }, onDownAtLastLine: handleDownAction, onPaste: ({ kind, content }) => {
                                        try {
                                            const original = content;
                                            // Tabs break our inputs. Spaces do not.
                                            const sanitized = original.includes("\t")
                                                ? original.replace(/\t/g, "  ")
                                                : original;
                                            const sample = sanitized.slice(0, 64);
                                            const hex = Array.from(sample)
                                                .map(c => c.charCodeAt(0).toString(16).padStart(2, "0"))
                                                .join(" ");
                                            (0,_debug_js__WEBPACK_IMPORTED_MODULE_11__.debugLog)("paste-event", {
                                                kind,
                                                length: sanitized.length,
                                                preview: sample,
                                                hexSample: hex,
                                            });
                                            // Intercept large text pastes: > 800 chars (same as CC)
                                            if (sanitized.length > 800) {
                                                const id = nextLargePasteIdRef.current++;
                                                largePastedTextRef.current.set(id, sanitized);
                                                const placeholder = buildLargePastePlaceholder(id, sanitized);
                                                // Return replacement to suppress original paste
                                                return placeholder;
                                            }
                                            if (sanitized.length === 0 && "darwin" === "darwin") {
                                                void (() => __awaiter(void 0, void 0, void 0, function* () {
                                                    const img = yield (0,_utils_clipboard_js__WEBPACK_IMPORTED_MODULE_17__/* .tryReadClipboardImageToTemp */ .w)();
                                                    if (img) {
                                                        (0,_debug_js__WEBPACK_IMPORTED_MODULE_11__.debugLog)("paste-event-macos-image", img);
                                                        const token = buildTokenForPath(img.path);
                                                        const base = value.length === 0
                                                            ? token
                                                            : `${value}${value.endsWith(" ") ? "" : " "}${token}`;
                                                        const next = ensureTrailingSpace(base);
                                                        handleProgrammaticChange(next);
                                                        setCursorToEndSignal(s => s + 1);
                                                    }
                                                    else {
                                                        (0,_debug_js__WEBPACK_IMPORTED_MODULE_11__.debugLog)("paste-event-macos-image-miss");
                                                    }
                                                }))();
                                            }
                                            // For bracketed or aggregated pastes that look like image paths,
                                            // set a flag so the subsequent onChange call performs path->token replacement.
                                            if (sanitized.length > 0) {
                                                const candidates = extractCandidateImagePaths(sanitized);
                                                if (candidates.length > 0) {
                                                    pendingPasteReplacementRef.current = true;
                                                }
                                            }
                                        }
                                        catch (e) {
                                            (0,_debug_js__WEBPACK_IMPORTED_MODULE_11__.debugLog)("paste-event-error", String(e));
                                        }
                                        // If tabs were present, return sanitized content to replace them with two spaces
                                        if (content.includes("\t"))
                                            return content.replace(/\t/g, "  ");
                                        return null;
                                    }, allowExplicitNewline: true, focus: inputMode !== "decision" && !isSuggestingPlan }) })] })] }), _constants_js__WEBPACK_IMPORTED_MODULE_8__/* .REVIEW_MODE_ENABLED */ .hD && inDecision && changedFiles.length > 0 ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .Box */ .az, { marginTop: 0, marginX: 2, justifyContent: "flex-end", children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .Text */ .EY, { color: "gray", dimColor: true, children: "ctrl+r to review changed files" }) })) : null, inputMode === "message" &&
                paletteMode === "none" &&
                !isSuggestingPlan &&
                process.env.AGENT_CLI_HIDE_PROMPT_BAR !== "true" && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_prompt_prompt_footer_js__WEBPACK_IMPORTED_MODULE_24__/* ["default"] */ .A, { show: true, hasText: value.length > 0, exitMode: exitMode, modelLabel: (currentModel === null || currentModel === void 0 ? void 0 : currentModel.displayName) || "Starting...", tokenPercentLabel: tokenPercentLabel, changedFilesCount: deferredChangedFilesCount, showReviewHint: !history.inHistory, headlineLabel: (() => {
                    // Keep concise to avoid wrapping; no Shell Mode hint here
                    if (isSendingToBackground) {
                        return "Sending to background";
                    }
                    if (mode === "auto-run") {
                        return isEmptyChat
                            ? "▶︎ Auto-run all commands (shift+tab to cycle)"
                            : "▶︎ Auto-run all commands (shift+tab to turn off)";
                    }
                    if (mode === "background") {
                        if (isRepository) {
                            return process.stdout.columns > 60
                                ? "◎ Send to background (shift+tab to cycle)"
                                : "◎ Background (shift+tab to cycle)";
                        }
                        return undefined;
                    }
                    if (mode === "plan") {
                        return "◎ Plan (shift+tab to cycle)";
                    }
                    return undefined;
                })(), headlineColor: (() => {
                    if (isSendingToBackground)
                        return "green";
                    if (mode === "background" && isRepository)
                        return "magenta";
                    if (mode === "auto-run")
                        return "yellow";
                    if (mode === "plan")
                        return "cyan";
                    return undefined;
                })() })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_4__/* .Box */ .az, { height: paletteVisible
                    ? Math.min(at.active
                        ? Math.min(at.suggestions.length, _constants_js__WEBPACK_IMPORTED_MODULE_8__/* .PALETTE_PAGE_SIZE */ .kQ)
                        : Math.min(slash.items.length, _constants_js__WEBPACK_IMPORTED_MODULE_8__/* .PALETTE_PAGE_SIZE */ .kQ), _constants_js__WEBPACK_IMPORTED_MODULE_8__/* .PALETTE_PAGE_SIZE */ .kQ)
                    : 0, flexDirection: "column", marginTop: 0, children: paletteVisible &&
                    (at.active ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_prompt_palette_at_list_js__WEBPACK_IMPORTED_MODULE_21__/* ["default"] */ .A, { suggestions: at.suggestions, activeIndex: at.index, windowStart: at.windowStart, highlightColor: effectiveBorderColor })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_prompt_palette_slash_list_js__WEBPACK_IMPORTED_MODULE_22__/* ["default"] */ .A, { items: slash.items, activeIndex: slash.index, windowStart: slash.windowStart, highlightColor: effectiveBorderColor }))) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_prompt_ephemeral_lines_view_js__WEBPACK_IMPORTED_MODULE_20__/* ["default"] */ .A, { lines: ephemeral.lines })] }));
};
// Precompiled image path detection helpers (perf-sensitive)
const IMAGE_EXTS = [
    "png",
    "jpg",
    "jpeg",
    "gif",
    "webp",
    "bmp",
    "tif",
    "tiff",
    "heic",
    "heif",
];
const hasLikelyImageExt = (s) => {
    const low = s.toLowerCase();
    for (const ext of IMAGE_EXTS) {
        if (low.includes(`.${ext}`))
            return true;
    }
    return low.includes("file://");
};
// "...path.ext" (double-quoted)
const reQuotedDouble = new RegExp(String.raw `"((?:file://)?[^"\n]+?\.(${IMAGE_EXTS.join("|")}))"`, "gi");
// '...path.ext' (single-quoted)
const reQuotedSingle = new RegExp(String.raw `'((?:file://)?[^'\n]+?\.(${IMAGE_EXTS.join("|")}))'`, "gi");
// Unquoted path with a simple left-boundary capture to avoid lookbehind
// Matches: (<start>|non-word and not @ or -) + (path.ext)
const reUnquoted = new RegExp(String.raw `(^|[^\w@-])((?:file://)?[^\s'"()]+?\.(${IMAGE_EXTS.join("|")}))`, "gi");
// Absolute POSIX path allowing spaces until newline (for drag/drop that yields a full path with spaces)
const reAbsWithSpaces = new RegExp(String.raw `(^|[^\w@-])((?:file://)?(?:/|~)[^\n]+?\.(${IMAGE_EXTS.join("|")}))`, "gi");
// Unquoted path split by repeated "' '" segments used by macOS Terminal drag-drop
// Example: /path/Screenshot' '2025-08-05' 'at' '6.47.38PM.png
const reUnquotedWithQuotedSpaces = /(^|[^\w@-])((?:file:\/\/)?[^\s'"()]+(?:'\s'[^\s'"()]+)+)/gi;
const isAbsolutePath = (p) => {
    // POSIX absolute or file:// root
    if (/^(?:file:\/\/)?\//.test(p))
        return true;
    // Windows drive letter or UNC
    if (/^[A-Za-z]:[\\/]/.test(p) || /^\\\\/.test(p))
        return true;
    // Home shortcuts like ~/
    if (/^~\//.test(p))
        return true;
    return false;
};
const getLikelyTempRoots = () => {
    const roots = [];
    const envCandidates = [process.env.TMPDIR, process.env.TEMP, process.env.TMP];
    for (const e of envCandidates)
        if (e && typeof e === "string")
            roots.push(e);
    // Common POSIX/mac temp roots
    roots.push("/tmp", "/var/tmp", "/private/tmp", "/var/folders", "/private/var/folders");
    // Windows temp patterns (approximate)
    if (false) // removed by dead control flow
{}
    // Normalize slashes for matching
    return Array.from(new Set(roots.map(r => r.replace(/\\/g, "/"))));
};
const isLikelyTempPath = (p) => {
    if (!isAbsolutePath(p))
        return false;
    const norm = p.replace(/\\/g, "/");
    for (const root of getLikelyTempRoots()) {
        if (norm.startsWith(root.endsWith("/") ? root : `${root}/`))
            return true;
    }
    return false;
};
const normalizePotentialPath = (raw) => {
    let s = raw.trim();
    if ((s.startsWith('"') && s.endsWith('"')) ||
        (s.startsWith("'") && s.endsWith("'"))) {
        s = s.slice(1, -1);
    }
    if (s.startsWith("file://")) {
        try {
            const u = new URL(s);
            s = decodeURI(u.pathname);
        }
        catch (_a) {
            s = s.replace(/^file:\/\//, "");
        }
    }
    const isWindowsPath = /^[A-Za-z]:[\\/]/.test(s) || /\\\\/.test(s);
    if (!isWindowsPath) {
        s = s.replace(/\\([\s()])/g, "$1");
        s = s.replace(/'\s'/g, " ");
    }
    // no-op debug removal
    return s;
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/prompt/decision-dropdown.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _context_theme_context_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/context/theme-context.tsx");
/* harmony import */ var _utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/utils/color-mixing.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _context_theme_context_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _context_theme_context_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const DecisionDropdown = ({ title, highlightColor, options, selectedIndex, subtitle, }) => {
    const isLightTheme = (0,_context_theme_context_js__WEBPACK_IMPORTED_MODULE_4__/* .useIsLightTheme */ .pW)();
    const colorMode = (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_5__/* .getColorMode */ .PT)();
    // Compute active background color per color mode
    const activeBgHex = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        var _a, _b;
        if (colorMode === "ansi256")
            return undefined; // will use SGR background instead
        // In truecolor or basic/none, prefer mixed tint for subtle background
        const base = (_a = (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_5__/* .hexToRgb */ .E2)((isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
            ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DECISION_DROPDOWN_MIX_BASE_LIGHT_HEX */ .bd
            : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DECISION_DROPDOWN_MIX_BASE_DARK_HEX */ .Ts)) !== null && _a !== void 0 ? _a : ((isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
            ? { r: 255, g: 255, b: 255 }
            : { r: 30, g: 30, b: 30 });
        const tint = (_b = (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_5__/* .hexToRgb */ .E2)((isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
            ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DECISION_DROPDOWN_TINT_LIGHT_HEX */ .Kp
            : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DECISION_DROPDOWN_TINT_DARK_HEX */ .Wn)) !== null && _b !== void 0 ? _b : ((isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
            ? { r: 255, g: 243, b: 223 }
            : { r: 245, g: 217, b: 159 });
        const ratio = (isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
            ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DECISION_DROPDOWN_MIX_RATIO_LIGHT */ .FL
            : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DECISION_DROPDOWN_MIX_RATIO_DARK */ .Rg;
        return (0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_5__/* .rgbToHex */ .Ob)((0,_utils_color_mixing_js__WEBPACK_IMPORTED_MODULE_5__/* .mixColors */ .Lh)(base, tint, ratio));
    }, [isLightTheme, colorMode]);
    const activeBgAnsiIdx = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        if (colorMode !== "ansi256")
            return undefined;
        return (isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
            ? _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DECISION_DROPDOWN_ANSI256_LIGHT */ .tg.activeBg
            : _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .DECISION_DROPDOWN_ANSI256_DARK */ .Lo.activeBg;
    }, [colorMode, isLightTheme]);
    // Choose a readable foreground over the active background without parsing ANSI/truecolor strings
    // Heuristic: on light themes, prefer black; on dark themes, prefer white.
    const activeFg = (isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false) ? "black" : "white";
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", marginTop: 0, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: highlightColor, children: title }) }), subtitle ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: subtitle }) })) : null, options.map((opt, idx) => {
                const active = idx === selectedIndex;
                const disabled = !!opt.disabled;
                const rowBg = active ? activeBgHex : undefined;
                const labelColor = active
                    ? activeFg
                    : disabled
                        ? "gray"
                        : "gray";
                const hintColor = active
                    ? isLightTheme
                        ? "black"
                        : "white"
                    : "gray";
                const finalHint = active && !disabled
                    ? opt.hint
                        ? `${opt.hint} (enter)`
                        : "(enter)"
                    : opt.hint;
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: "100%", flexDirection: "row", alignItems: "center", backgroundColor: rowBg, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: active ? 1 : 0, backgroundColor: active ? highlightColor : undefined }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: active ? 0 : 1, paddingY: 0, children: active && activeBgAnsiIdx != null ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [`\x1b[48;5;${activeBgAnsiIdx}m`, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: labelColor, children: "→ " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: labelColor, bold: true, children: opt.label }), finalHint ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: hintColor, children: [" ", finalHint] })) : null, "\x1b[49m"] })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: labelColor, children: active ? "→ " : "  " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: labelColor, bold: active, children: opt.label }), finalHint ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: hintColor, children: [" ", finalHint] })) : null] })) })] }, `${opt.label}-${idx}`));
            })] }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DecisionDropdown);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/prompt/ephemeral-lines-view.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const EphemeralLinesView = ({ lines }) => {
    const renderLine = (line, idx) => {
        if (typeof line !== "string") {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: line.map((seg, j) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: seg.color, bold: seg.bold, dimColor: seg.dim, children: seg.text }, `${seg.text}-${seg.color}-${j}`))) }, idx));
        }
        if (line.trim().length === 0)
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }, idx);
        const lower = line.toLowerCase();
        if (lower.startsWith("error:")) {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: line }, idx));
        }
        if (lower.startsWith("unknown command:")) {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "yellow", children: line }, idx));
        }
        if (/^available models:/i.test(line)) {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "cyan", children: line }, idx));
        }
        if (/^(commands:|examples:|usage:)/i.test(line)) {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "cyan", bold: true, children: line }, idx));
        }
        if (line.startsWith("/")) {
            const [cmdPart, ...rest] = line.split(" - ");
            if (rest.length > 0) {
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "cyan", children: cmdPart }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: [" - ", rest.join(" - ")] })] }, idx));
            }
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "cyan", children: line }, idx));
        }
        if (line.startsWith("  /")) {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "cyan", children: ["/", line.slice(3)] })] }, idx));
        }
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: line }, idx));
    };
    if (lines.length === 0)
        return null;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", marginTop: 1, paddingX: 2, children: lines.map(l => {
            const element = renderLine(l, 0);
            const key = typeof l === "string" ? l : JSON.stringify(l);
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_2__.Fragment, { children: element }, key);
        }) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (react__WEBPACK_IMPORTED_MODULE_2__.memo(EphemeralLinesView));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/prompt/palette-aligned-list.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/hooks/use-screen-size.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_3__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




const truncateDescriptionByWords = (text, maxCols) => {
    const sanitized = text.trim();
    if (sanitized.length === 0 || maxCols <= 0)
        return "";
    if (sanitized.length <= maxCols)
        return sanitized;
    const words = sanitized.split(/\s+/);
    let out = "";
    for (let i = 0; i < words.length; i++) {
        const word = words[i];
        const next = out.length === 0 ? word : `${out} ${word}`;
        const reserve = 1; // for ellipsis
        if (next.length + reserve > maxCols) {
            return out.length > 0
                ? `${out}…`
                : `${word.slice(0, Math.max(0, maxCols - reserve))}…`;
        }
        out = next;
    }
    return out;
};
const PaletteAlignedList = ({ items, activeIndex, windowStart, pageSize = _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .PALETTE_PAGE_SIZE */ .kQ, highlightColor, maxLabelCols = 40, }) => {
    const visible = items.slice(windowStart, windowStart + pageSize);
    const highlight = activeIndex - windowStart;
    const { width: terminalCols } = (0,_hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_3__/* .useScreenSize */ .l)();
    const labelColWidth = Math.min(visible.reduce((m, it) => Math.max(m, it.label.length), 0), maxLabelCols);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 2, flexDirection: "column", children: visible.map((it, idx) => {
            const active = idx === highlight;
            const arrowColor = active ? highlightColor : "gray";
            const labelColor = active ? "foreground" : "gray";
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: "100%", flexDirection: "row", alignItems: "center", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: 1, backgroundColor: active ? highlightColor : undefined }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: arrowColor, children: active ? "→ " : "  " }) }), labelColWidth > 0 && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: labelColWidth, marginRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: labelColor, bold: active, wrap: "truncate-end", children: it.label }) })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexGrow: 1, children: it.description ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: labelColor, bold: active, wrap: "truncate-end", children: (() => {
                                const padCols = 4; // root paddingX={2}
                                const fixedCols = 1 + 2 + (labelColWidth > 0 ? labelColWidth + 2 : 0);
                                const descMaxCols = Math.max(0, terminalCols - padCols - fixedCols);
                                const truncated = truncateDescriptionByWords(it.description, descMaxCols);
                                return truncated;
                            })() })) : null })] }, `${it.key}-${idx}`));
        }) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PaletteAlignedList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/prompt/palette-at-list.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _palette_aligned_list_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/components/prompt/palette-aligned-list.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_palette_aligned_list_js__WEBPACK_IMPORTED_MODULE_2__]);
_palette_aligned_list_js__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const MAX_LABEL_COLS = 40;
const splitPath = (p) => {
    const isDir = p.endsWith("/");
    const trimmed = isDir ? p.slice(0, -1) : p;
    const idx = trimmed.lastIndexOf("/");
    if (idx === -1)
        return { name: trimmed + (isDir ? "/" : ""), parent: "", isDir };
    const parent = idx === 0 ? "/" : trimmed.slice(0, idx);
    const name = trimmed.slice(idx + 1) + (isDir ? "/" : "");
    return { name, parent, isDir };
};
const PaletteAtList = ({ suggestions, activeIndex, windowStart, pageSize = _constants_js__WEBPACK_IMPORTED_MODULE_1__/* .PALETTE_PAGE_SIZE */ .kQ, highlightColor, }) => {
    const items = suggestions.map((p, idx) => {
        const { name, parent } = splitPath(p);
        return {
            key: `at-${p}-${idx}`,
            label: name,
            description: parent,
        };
    });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_palette_aligned_list_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A, { items: items, activeIndex: activeIndex, windowStart: windowStart, pageSize: pageSize, highlightColor: highlightColor, maxLabelCols: MAX_LABEL_COLS }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PaletteAtList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/prompt/palette-slash-list.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _palette_aligned_list_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/components/prompt/palette-aligned-list.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_palette_aligned_list_js__WEBPACK_IMPORTED_MODULE_2__]);
_palette_aligned_list_js__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const PaletteSlashList = ({ items, activeIndex, windowStart, pageSize = _constants_js__WEBPACK_IMPORTED_MODULE_1__/* .PALETTE_PAGE_SIZE */ .kQ, highlightColor, }) => {
    const buildLabel = (command) => {
        const isArg = command.isArgSuggestion && command.parentCommandId;
        const argsPart = command.args.length > 0
            ? " " +
                command.args
                    .map(a => a.required === false ? `[${a.identifier}]` : `<${a.identifier}>`)
                    .join(" ")
            : "";
        const base = isArg
            ? `${command.parentCommandId} ${command.identifier}`
            : command.identifier;
        return `/${base}${argsPart}`;
    };
    const listItems = items.map((command, idx) => {
        var _a;
        return ({
            key: `${command.identifier}-${command.parentCommandId || "root"}-${idx}`,
            label: buildLabel(command),
            description: (_a = command.description) !== null && _a !== void 0 ? _a : "",
        });
    });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_palette_aligned_list_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A, { items: listItems, activeIndex: activeIndex, windowStart: windowStart, pageSize: pageSize, highlightColor: highlightColor, maxLabelCols: 40 }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PaletteSlashList);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/prompt/pending-decisions-banner.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../local-exec/dist/index.js");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/highlighted-code.tsx");
/* harmony import */ var _inline_delta_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/inline-delta.tsx");
/* harmony import */ var _mcp_tool_decision_preview_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/components/mcp-tool-decision-preview.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__, _inline_delta_js__WEBPACK_IMPORTED_MODULE_5__, _mcp_tool_decision_preview_js__WEBPACK_IMPORTED_MODULE_6__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__, _inline_delta_js__WEBPACK_IMPORTED_MODULE_5__, _mcp_tool_decision_preview_js__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







function getShellString(operation) {
    const command = operation.details.command || "";
    const base = command.length > 80 ? `${command.slice(0, 77)}...` : command;
    const rawReason = operation.details.reason;
    const reason = typeof rawReason === "string" ? rawReason : undefined;
    return reason ? `${base}\nReason: ${reason}` : base;
}
function getDecisionDisplayString(decision) {
    switch (decision.operation.type) {
        case _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_2__.OperationType.Shell: {
            return getShellString(decision.operation);
        }
        case _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_2__.OperationType.Delete: {
            const rel = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .toRelativePath */ .fw)(decision.operation.details.path);
            return `Delete file: ${rel}`;
        }
        case _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_2__.OperationType.Write: {
            const rel = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .toRelativePath */ .fw)(decision.operation.details.path);
            return `Write file: ${rel}. Reason: ${decision.operation.details.reason}\n\n${decision.operation.details.diffString}`;
        }
        case _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_2__.OperationType.Mcp: {
            const details = decision.operation.details;
            const argsStr = Object.keys(details.args).length > 0
                ? `\nArgs: ${JSON.stringify(details.args, null, 2)}`
                : "";
            return `MCP Provider: ${details.providerIdentifier}. MCP tool: ${details.toolName}${argsStr}`;
        }
    }
}
const PendingDecisionsBanner = ({ decisions, }) => {
    if (decisions.length === 0)
        return null;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", borderColor: "gray", borderStyle: "single", borderDimColor: true, paddingX: 1, marginX: 1, children: decisions.map(decision => {
            const displayString = getDecisionDisplayString(decision);
            let displayNode;
            if (decision.operation.type === _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_2__.OperationType.Shell) {
                const prefix = decision.operation.details.isSandboxEnabled
                    ? "🔒 "
                    : "$ ";
                displayNode = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", alignItems: "flex-start", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: 3, flexShrink: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: prefix }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexGrow: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", wrap: "wrap", children: [decision.operation.details.command, " ", (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["in", " ", (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .truncatePathMiddle */ .tk)((0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .toRelativePath */ .fw)(decision.operation.details.workingDirectory), 50)] })] }) })] }));
            }
            else if (decision.operation.type === _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_2__.OperationType.Write) {
                let plus = 0;
                let minus = 0;
                for (const line of decision.operation.details.diffString.split("\n")) {
                    if (line.startsWith("+")) {
                        plus++;
                    }
                    else if (line.startsWith("-")) {
                        minus++;
                    }
                }
                const pathDisplay = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .getPathDisplay */ .Kr)((0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .toRelativePath */ .fw)(decision.operation.details.path));
                displayNode = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", alignItems: "center", gap: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: pathDisplay }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_inline_delta_js__WEBPACK_IMPORTED_MODULE_5__/* .InlineDelta */ ._, { added: plus, removed: minus })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { borderTop: true, borderLeft: false, borderRight: false, borderBottom: false, borderColor: "gray", borderStyle: "single", borderDimColor: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A, { content: decision.operation.details.diffString, language: "diff", showLineNumbers: false, maxLines: 40, isDiff: true }) })] }));
            }
            else if (decision.operation.type === _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_2__.OperationType.Mcp) {
                const details = decision.operation.details;
                displayNode = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mcp_tool_decision_preview_js__WEBPACK_IMPORTED_MODULE_6__/* .McpToolDecisionPreview */ .t, { providerIdentifier: details.providerIdentifier, toolName: details.toolName, args: details.args }));
            }
            else {
                displayNode = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", dimColor: true, children: displayString }));
            }
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: displayNode }, decision.id));
        }) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PendingDecisionsBanner);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/prompt/prompt-footer.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/constants.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const PromptFooter = ({ show, exitMode, modelLabel, tokenPercentLabel, changedFilesCount, showReviewHint, headlineLabel, headlineColor, exitHintText, rightStatusLabel, showSlashHint = true, }) => {
    if (!show)
        return null;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", marginX: 2, children: exitMode ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginTop: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: exitHintText !== null && exitHintText !== void 0 ? exitHintText : "Press Ctrl+C again to exit" }) })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginTop: headlineLabel ? 0 : 1, flexDirection: "column", children: [headlineLabel ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginBottom: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: headlineColor || "foreground", children: headlineLabel }) })) : null, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { gap: 2, justifyContent: "space-between", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", gap: 1, children: [rightStatusLabel ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: rightStatusLabel }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: "\u00B7" })] })) : null, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: modelLabel }), tokenPercentLabel ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: "\u00B7" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: tokenPercentLabel })] })) : null, changedFilesCount > 0 && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: "\u00B7" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: [changedFilesCount, " file", changedFilesCount === 1 ? "" : "s", " edited"] })] }))] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, {})] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: [(() => {
                                const hintSegments = [];
                                if (showSlashHint)
                                    hintSegments.push("/ commands");
                                if (_constants_js__WEBPACK_IMPORTED_MODULE_3__/* .AT_PALETTE_ENABLED */ .KD)
                                    hintSegments.push("@ files");
                                // Keep concise to avoid wrapping
                                hintSegments.push("! shell");
                                return hintSegments.join(" · ");
                            })(), _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .REVIEW_MODE_ENABLED */ .hD &&
                                showReviewHint &&
                                changedFilesCount > 0 && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: " \u00B7 " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: "ctrl+r to review edits" })] }))] }) })] })) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (react__WEBPACK_IMPORTED_MODULE_2__.memo(PromptFooter));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/read-lints-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export ReadLintsToolUI */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/tool-call-header.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const ReadLintsToolUI = ({ tool: { args, result }, }) => {
    var _a;
    const paths = (args === null || args === void 0 ? void 0 : args.paths) || [];
    const primary = paths.length === 0
        ? "workspace"
        : paths.length === 1
            ? (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .getPathDisplay */ .Kr)(paths[0])
            : `${(0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .getPathDisplay */ .Kr)(paths[0])} (+${paths.length - 1} more)`;
    let status = "pending";
    const caseType = (_a = result === null || result === void 0 ? void 0 : result.result) === null || _a === void 0 ? void 0 : _a.case;
    switch (caseType) {
        case undefined:
            status = "pending";
            break;
        case "error":
            status = "error";
            break;
        case "success":
            status = "success";
            break;
        default: {
            const _exhaustive = caseType;
            status = "pending";
            break;
        }
    }
    const headerName = (() => {
        const verb = (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__/* .resolveToolVerbByCase */ .F_)("readLintsToolCall", status === "success") ||
            (status === "success" ? "Read" : "Reading");
        return `${verb} Lints`;
    })();
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__/* .ToolCallHeader */ .C, { name: headerName, primary: primary, status: status }), (() => {
                const rr = result === null || result === void 0 ? void 0 : result.result;
                if ((rr === null || rr === void 0 ? void 0 : rr.case) === "error") {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["Error: ", rr.value.errorMessage] }) }));
                }
                return null;
            })(), (() => {
                const rr = result === null || result === void 0 ? void 0 : result.result;
                if ((rr === null || rr === void 0 ? void 0 : rr.case) === "success") {
                    const totalDiagnostics = rr.value.totalDiagnostics || 0;
                    const totalFiles = rr.value.totalFiles || 0;
                    // Show a concise summary, consistent with other tools' summaries
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["Found ", totalDiagnostics, " issue", totalDiagnostics === 1 ? "" : "s", totalFiles > 0
                                    ? ` in ${totalFiles} file${totalFiles === 1 ? "" : "s"}`
                                    : ""] }) }));
                }
                return null;
            })()] }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ReadLintsToolUI);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/read-todos-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   w: () => (/* binding */ ReadTodosToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _todos_ui_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/components/todos-ui.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _todos_ui_js__WEBPACK_IMPORTED_MODULE_2__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _todos_ui_js__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const ReadTodosToolUI = ({ tool, aborted, }) => {
    const formatFilters = () => {
        var _a, _b, _c, _d;
        const filters = [];
        if (((_b = (_a = tool.args) === null || _a === void 0 ? void 0 : _a.statusFilter) === null || _b === void 0 ? void 0 : _b.length) && tool.args.statusFilter.length > 0) {
            const statusTexts = tool.args.statusFilter.map(status => {
                switch (status) {
                    case 1:
                        return "pending";
                    case 2:
                        return "in_progress";
                    case 3:
                        return "completed";
                    case 4:
                        return "cancelled";
                    default:
                        return "unknown";
                }
            });
            filters.push(`status: ${statusTexts.join(", ")}`);
        }
        if (((_d = (_c = tool.args) === null || _c === void 0 ? void 0 : _c.idFilter) === null || _d === void 0 ? void 0 : _d.length) && tool.args.idFilter.length > 0) {
            filters.push(`ids: ${tool.args.idFilter.join(", ")}`);
        }
        return filters.length > 0 ? ` (${filters.join("; ")})` : "";
    };
    if (aborted) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { bold: true, children: "Read to-dos" }), " ", (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: "Aborted" })] }) }) }));
    }
    if (!tool.result) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_todos_ui_js__WEBPACK_IMPORTED_MODULE_2__/* .TodosUI */ .S, { todos: [], mode: "read", loading: true, filters: formatFilters() }) }));
    }
    const result = tool.result.result;
    const successTotal = (result === null || result === void 0 ? void 0 : result.case) === "success" ? result.value.totalCount : undefined;
    const _buildNote = () => {
        const filters = formatFilters();
        if (successTotal !== undefined) {
            return filters
                ? `${filters} (Total: ${successTotal})`
                : `(Total: ${successTotal})`;
        }
        return filters;
    };
    switch (result === null || result === void 0 ? void 0 : result.case) {
        case "success":
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_todos_ui_js__WEBPACK_IMPORTED_MODULE_2__/* .TodosUI */ .S, { todos: result.value.todos, totalCount: result.value.totalCount, mode: "read", filters: formatFilters(), showHeader: true }) }));
        case "error":
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: result.value.error }) }));
        default:
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_todos_ui_js__WEBPACK_IMPORTED_MODULE_2__/* .TodosUI */ .S, { todos: [], mode: "read" }) }));
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/read-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   B: () => (/* binding */ ReadToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/tool-call-header.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const ReadToolUI = ({ tool: { args, result }, }) => {
    var _a;
    if (!args) {
        return null;
    }
    const pathDisplay = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .getPathDisplay */ .Kr)(args.path);
    const lineNote = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .formatLineNote */ .me)(args.offset, args.limit);
    let status = "pending";
    const caseType = (_a = result === null || result === void 0 ? void 0 : result.result) === null || _a === void 0 ? void 0 : _a.case;
    switch (caseType) {
        case undefined:
            status = "pending";
            break;
        case "error":
            status = "error";
            break;
        case "success":
            status = "success";
            break;
        default: {
            const _exhaustive = caseType;
            status = "pending";
            break;
        }
    }
    const headerName = (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__/* .resolveToolVerbByCase */ .F_)("readToolCall", status === "success") ||
        (status === "success" ? "Read" : "Reading");
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__/* .ToolCallHeader */ .C, { name: headerName, primary: pathDisplay, status: status, note: lineNote }), (() => {
                const rr = result === null || result === void 0 ? void 0 : result.result;
                if ((rr === null || rr === void 0 ? void 0 : rr.case) === "error") {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["Error: ", rr.value.errorMessage] }) }));
                }
                return null;
            })()] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/search-results-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: () => (/* binding */ renderSearchResults)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _path_display_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/components/path-display.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _path_display_js__WEBPACK_IMPORTED_MODULE_2__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _path_display_js__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const SearchResultItem = ({ result, index, }) => {
    var _a, _b, _c, _d;
    const codeBlock = result.codeBlock;
    if (!codeBlock) {
        return null;
    }
    const fileName = codeBlock.relativeWorkspacePath;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", gap: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "cyan", bold: true, children: [(index + 1).toString().padStart(3, " "), "."] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_path_display_js__WEBPACK_IMPORTED_MODULE_2__/* .PathDisplay */ .g, { path: fileName }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["(L", (_b = (_a = codeBlock.range) === null || _a === void 0 ? void 0 : _a.startPosition) === null || _b === void 0 ? void 0 : _b.line, " - L", (_d = (_c = codeBlock.range) === null || _c === void 0 ? void 0 : _c.endPosition) === null || _d === void 0 ? void 0 : _d.line, ")"] })] }) }));
};
const SearchResultsView = ({ query, results, }) => {
    if (results.length === 0) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "yellow", children: ["No results found for \"", query, "\""] }) }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "green", bold: true, children: ["Found ", results.length, " result", results.length !== 1 ? "s" : "", " for \"", query, "\""] }), results.map((result, index) => {
                var _a, _b, _c;
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SearchResultItem, { result: result, index: index }, `${(_b = (_a = result.codeBlock) === null || _a === void 0 ? void 0 : _a.relativeWorkspacePath) !== null && _b !== void 0 ? _b : ""}-${(_c = result.score) !== null && _c !== void 0 ? _c : 0}-${index}`));
            })] }));
};
function renderSearchResults(query, results) {
    (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .render */ .XX)((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SearchResultsView, { query: query, results: results }));
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/sem-search-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   S: () => (/* binding */ SemSearchToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/tool-call-header.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const SemSearchToolUI = ({ tool: { args, result }, }) => {
    var _a;
    if (!args || !args.query)
        return null;
    const queryDisplay = args.query.length > 40 ? `...${args.query.slice(-37)}` : args.query;
    let status = "pending";
    const caseType = (_a = result === null || result === void 0 ? void 0 : result.result) === null || _a === void 0 ? void 0 : _a.case;
    switch (caseType) {
        case undefined:
            status = "pending";
            break;
        case "error":
            status = "error";
            break;
        case "success":
            status = "success";
            break;
        default: {
            const _exhaustive = caseType;
            void _exhaustive;
            status = "pending";
            break;
        }
    }
    const note = (() => {
        var _a;
        const dirs = (_a = args.targetDirectories) !== null && _a !== void 0 ? _a : [];
        if (!dirs || dirs.length === 0)
            return undefined;
        // Show up to 3 paths if the total display length stays modest; else collapse.
        const MAX_DISPLAYED = 3;
        const MAX_TOTAL_LENGTH = 100; // heuristic to avoid wrapping too much
        const displays = [];
        let totalLen = 0;
        for (let i = 0; i < Math.min(dirs.length, MAX_DISPLAYED); i++) {
            const disp = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_3__/* .getPathDisplay */ .Kr)(dirs[i] || ".");
            if (displays.length === 0 ||
                totalLen + 2 + disp.length <= MAX_TOTAL_LENGTH) {
                displays.push(disp);
                totalLen += disp.length + (displays.length > 1 ? 2 : 0); // account for ', '
            }
            else {
                break;
            }
        }
        const remaining = dirs.length - displays.length;
        const display = remaining > 0
            ? `${displays.join(", ")} (+${remaining} more)`
            : displays.join(", ");
        return `in ${display}`;
    })();
    const headerName = (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__/* .resolveToolVerbByCase */ .F_)("semSearchToolCall", status === "success") ||
        (status === "success" ? "Searched" : "Searching");
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__/* .ToolCallHeader */ .C, { name: headerName, primary: `"${queryDisplay}"`, status: status, note: note }), (() => {
                const rr = result === null || result === void 0 ? void 0 : result.result;
                if ((rr === null || rr === void 0 ? void 0 : rr.case) === "error") {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["Error: ", rr.value.errorMessage] }) }));
                }
                return null;
            })(), (() => {
                const rr = result === null || result === void 0 ? void 0 : result.result;
                if ((rr === null || rr === void 0 ? void 0 : rr.case) === "success") {
                    const results = rr.value.results || "";
                    const matches = results.match(/<search_result\b/g);
                    const total = matches ? matches.length : 0;
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["Found ", total, " results"] }) }));
                }
                return null;
            })()] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/shell-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   f: () => (/* binding */ ShellToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../local-exec/dist/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _context_agent_state_context_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/context/agent-state-context.tsx");
/* harmony import */ var _utils_characters_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/utils/characters.ts");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/utils/path-utils.ts");
/* harmony import */ var _highlighted_code_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/components/highlighted-code.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_7__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const formatDuration = (ms) => {
    if (!ms && ms !== 0)
        return null;
    const n = ms;
    if (n < 1000)
        return `${n}ms`;
    const secs = n / 1000;
    const s = secs.toFixed(secs >= 10 ? 0 : 1);
    return `${s}s`;
};
const ShellToolUI = ({ tool, expand, aborted, shellManager, }) => {
    var _a, _b;
    const { pendingDecisions } = (0,_context_agent_state_context_js__WEBPACK_IMPORTED_MODULE_5__/* .useAgentState */ .C9)();
    const isCompact = (0,_context_agent_state_context_js__WEBPACK_IMPORTED_MODULE_5__/* .useIsCompact */ .tO)();
    const args = tool.args;
    const result = tool.result;
    const cmd = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => ((args === null || args === void 0 ? void 0 : args.command) || "").trim(), [args === null || args === void 0 ? void 0 : args.command]);
    // Use the same expand logic as shell-turn-ui
    const shouldExpand = expand !== null && expand !== void 0 ? expand : !isCompact;
    const shellEmitter = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        if (!shellManager || !(args === null || args === void 0 ? void 0 : args.toolCallId)) {
            return null;
        }
        return shellManager.getOrCreateShellEmitter(args.toolCallId);
    }, [shellManager, args === null || args === void 0 ? void 0 : args.toolCallId]);
    const workingDirDisplay = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        const argWd = (args === null || args === void 0 ? void 0 : args.workingDirectory) || undefined;
        const r = result === null || result === void 0 ? void 0 : result.result;
        let wd = argWd;
        if (!wd && r) {
            switch (r.case) {
                case "success":
                case "failure":
                case "rejected":
                    wd = r.value.workingDirectory || undefined;
                    break;
                default:
                    wd = undefined;
            }
        }
        if (!wd)
            return undefined;
        const rel = (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_6__/* .toRelativePath */ .fw)(wd);
        const human = rel === "." ? "current dir" : rel;
        return (0,_utils_path_utils_js__WEBPACK_IMPORTED_MODULE_6__/* .truncatePathMiddle */ .tk)(human, _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .MAX_DIRECTORY_DISPLAY_LENGTH */ .DN);
    }, [args === null || args === void 0 ? void 0 : args.workingDirectory, result]);
    const isWaiting = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        return pendingDecisions.some(d => d.operation.type === _anysphere_local_exec__WEBPACK_IMPORTED_MODULE_2__.OperationType.Shell &&
            (d.operation.details.command || "").trim() === cmd);
    }, [pendingDecisions, cmd]);
    const isRunning = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => !(result === null || result === void 0 ? void 0 : result.result), [result]);
    // Optimistic shell result state
    const [optimisticResult, setOptimisticResult] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(undefined);
    const isSandboxed = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        // Recompute when optimisticResult changes so start events update the icon immediately
        return Boolean(shellEmitter === null || shellEmitter === void 0 ? void 0 : shellEmitter.getSandboxed());
    }, [shellEmitter]);
    const [startAtMs, setStartAtMs] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
    const [elapsedMs, setElapsedMs] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(0);
    // (moved optimisticResult state above for dependency ordering)
    // Subscribe to shell emitter for optimistic updates
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
        if (!shellEmitter) {
            setOptimisticResult(undefined);
            return;
        }
        // Get initial state
        setOptimisticResult(shellEmitter.getCurrentState());
        // Listen for updates
        const handleShellChange = (result) => {
            setOptimisticResult(result);
        };
        shellEmitter.addListener(handleShellChange);
        return () => {
            shellEmitter.removeListener(handleShellChange);
        };
    }, [shellEmitter]);
    // Header note similar to edits: brief status info
    const headerNote = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        var _a, _b;
        if (aborted)
            return "Aborted";
        const r = result === null || result === void 0 ? void 0 : result.result;
        // Use optimistic exit code if available and command is still running
        if (!r &&
            (optimisticResult === null || optimisticResult === void 0 ? void 0 : optimisticResult.exitCode) !== null &&
            (optimisticResult === null || optimisticResult === void 0 ? void 0 : optimisticResult.exitCode) !== undefined) {
            const exit = optimisticResult.exitCode;
            return `exit ${exit}`;
        }
        if (!r)
            return undefined;
        switch (r.case) {
            case "success":
                return (_a = formatDuration(r.value.executionTime)) !== null && _a !== void 0 ? _a : undefined;
            case "failure": {
                const exit = (_b = r.value.exitCode) !== null && _b !== void 0 ? _b : 1;
                const sig = r.value.signal || "";
                const time = formatDuration(r.value.executionTime);
                const parts = [];
                parts.push(`exit ${exit}${sig ? ` (${sig})` : ""}`);
                if (time)
                    parts.push(time);
                return parts.join(" • ");
            }
            case "rejected":
                return "Rejected";
            default:
                return undefined;
        }
    }, [aborted, result, optimisticResult]);
    // Manage the start timestamp so it reflects the moment execution actually begins
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
        if (isRunning && !isWaiting) {
            if (startAtMs === null) {
                setStartAtMs(Date.now());
            }
        }
        else {
            if (startAtMs !== null) {
                setStartAtMs(null);
            }
            setElapsedMs(0);
        }
    }, [isRunning, isWaiting, startAtMs]);
    // Tick the elapsed timer only while we have a valid start timestamp
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
        if (startAtMs === null)
            return;
        const id = setInterval(() => {
            setElapsedMs(Date.now() - startAtMs);
        }, 100);
        return () => clearInterval(id);
    }, [startAtMs]);
    const outputContent = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
        // If the tool execution was aborted, suppress body content entirely.
        if (aborted)
            return null;
        const stripAnsi = (s) => (0,_utils_characters_js__WEBPACK_IMPORTED_MODULE_8__/* .stripAnsi */ .aJ)(s);
        const insertSoftWraps = (s) => 
        // Insert a zero-width space after long non-space runs to enable wrapping
        s.replace(/(\S{80})(?=\S)/g, "$1\u200B");
        const r = result === null || result === void 0 ? void 0 : result.result;
        // Use optimistic output if available and command is still running
        if (!r && (optimisticResult === null || optimisticResult === void 0 ? void 0 : optimisticResult.output)) {
            const combined = insertSoftWraps(stripAnsi(optimisticResult.output));
            if (!combined)
                return null;
            // Truncate output if it exceeds MAX_SHELL_OUTPUT_SIZE
            const outputSize = Buffer.byteLength(combined, "utf8");
            const isTruncated = outputSize > _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .MAX_SHELL_OUTPUT_SIZE */ .qg;
            const displayOutput = isTruncated
                ? Buffer.from(combined, "utf8")
                    .subarray(0, _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .MAX_SHELL_OUTPUT_SIZE */ .qg)
                    .toString("utf8")
                : combined;
            return {
                text: displayOutput,
                color: undefined,
                isTruncated,
                originalSize: outputSize,
            };
        }
        if (!r)
            return null;
        switch (r.case) {
            case "success":
            case "failure": {
                // Always show both stdout and stderr if available
                const stdout = r.value.stdout || "";
                const stderr = r.value.stderr || "";
                const parts = [];
                if (stdout)
                    parts.push(insertSoftWraps(stripAnsi(stdout)));
                if (stderr)
                    parts.push(insertSoftWraps(stripAnsi(stderr)));
                const combined = parts.join("\n");
                if (!combined)
                    return null;
                // Truncate output if it exceeds MAX_SHELL_OUTPUT_SIZE
                const outputSize = Buffer.byteLength(combined, "utf8");
                const isTruncated = outputSize > _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .MAX_SHELL_OUTPUT_SIZE */ .qg;
                const displayOutput = isTruncated
                    ? Buffer.from(combined, "utf8")
                        .subarray(0, _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .MAX_SHELL_OUTPUT_SIZE */ .qg)
                        .toString("utf8")
                    : combined;
                return {
                    text: displayOutput,
                    color: undefined,
                    isTruncated,
                    originalSize: outputSize,
                };
            }
            case "rejected": {
                const reason = typeof r.value.reason === "string" ? r.value.reason.trim() : "";
                if (!reason)
                    return null; // do not show second row if no reason
                return {
                    text: reason,
                    color: "yellow",
                };
            }
            default:
                return null;
        }
    }, [result, aborted, optimisticResult]);
    if (!args)
        return null;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", alignItems: "flex-start", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: 2, flexShrink: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: [isSandboxed ? "🔒 $" : "$", " "] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexGrow: 1, flexShrink: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "wrap", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: cmd }), headerNote ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: headerNote })] })) : null, isRunning ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: isWaiting
                                                ? "Waiting for approval..."
                                                : ((_a = formatDuration(elapsedMs)) !== null && _a !== void 0 ? _a : undefined) })] })) : null, workingDirDisplay ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["in ", workingDirDisplay] })] })) : null] }) })] }), outputContent !== null ? (outputContent.color === "yellow" ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "yellow", wrap: "wrap", children: outputContent.text }) })) : outputContent.text ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: 2, flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_highlighted_code_js__WEBPACK_IMPORTED_MODULE_7__/* .HighlightedCode */ .d, { content: outputContent.text, language: "plaintext", showLineNumbers: false, maxLines: shouldExpand
                            ? _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .SHELL_OUTPUT_EXPANDED_MAX_LINES */ .U5
                            : _constants_js__WEBPACK_IMPORTED_MODULE_4__/* .SHELL_OUTPUT_PREVIEW_LINES */ .Ok, truncationHint: shouldExpand ? undefined : "ctrl+o to expand", dimmed: true }), outputContent.isTruncated && shouldExpand ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "yellow", dimColor: true, children: ["Output truncated at 1MiB limit (", Math.round(((_b = outputContent.originalSize) !== null && _b !== void 0 ? _b : 0) / 1024), " KB total)"] }) })) : null, shouldExpand ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", dimColor: true, children: "ctrl+o to collapse" }) })) : null] })) : null) : null] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/shell-turn-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   o: () => (/* binding */ ShellTurnUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _context_agent_state_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/context/agent-state-context.tsx");
/* harmony import */ var _highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/highlighted-code.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const ShellTurnUI = ({ command, output, exitCode, }) => {
    command = command.trim();
    const isCompleted = exitCode !== undefined;
    const isCompact = (0,_context_agent_state_context_js__WEBPACK_IMPORTED_MODULE_3__/* .useIsCompact */ .tO)();
    const expand = !isCompact; // Ctrl+O toggles compact globally
    // Truncate output if it exceeds MAX_SHELL_OUTPUT_SIZE
    const outputSize = Buffer.byteLength(output, "utf8");
    const isTruncated = outputSize > _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .MAX_SHELL_OUTPUT_SIZE */ .qg;
    const displayOutput = isTruncated
        ? Buffer.from(output, "utf8")
            .subarray(0, _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .MAX_SHELL_OUTPUT_SIZE */ .qg)
            .toString("utf8")
        : output;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", marginTop: 1, marginBottom: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", alignItems: "flex-start", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: 2, flexShrink: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: "$ " }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexGrow: 1, flexShrink: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "wrap", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: command }), !isCompleted ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: "Running\u2026" })] })) : exitCode != null ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["exit ", exitCode] })] })) : null] }) })] }), output ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: 1, flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_highlighted_code_js__WEBPACK_IMPORTED_MODULE_4__/* .HighlightedCode */ .d, { content: displayOutput, language: "plaintext", showLineNumbers: false, maxLines: expand
                            ? _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .SHELL_OUTPUT_EXPANDED_MAX_LINES */ .U5
                            : _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .SHELL_TURN_OUTPUT_PREVIEW_LINES */ .a6, truncationHint: expand ? undefined : "ctrl+o to expand", dimmed: true }), isTruncated && expand ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "yellow", dimColor: true, children: ["Output truncated at 1MiB limit (", Math.round(outputSize / 1024), " ", "KB total)"] }) })) : null, expand ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", dimColor: true, children: "ctrl+o to collapse" }) })) : null] })) : null] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/step-container.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: () => (/* binding */ StepContainer)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const StepContainer = ({ children, shouldPadTop = false, shouldMarginBottom = false, overrideBorderColor: _overrideBorderColor = "gray", paddingLeft = 2, paddingRight = 2, }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: paddingLeft, paddingRight: paddingRight, paddingTop: shouldPadTop ? 1 : 0, marginBottom: shouldMarginBottom ? 1 : 0, children: children }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/summary.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   B: () => (/* binding */ Summary)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/hooks/use-screen-size.ts");
/* harmony import */ var _markdown_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/markdown.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_2__, _markdown_js__WEBPACK_IMPORTED_MODULE_3__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_2__, _markdown_js__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




function Summary({ summary }) {
    const size = (0,_hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_2__/* .useScreenSize */ .l)();
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { borderStyle: "single", borderColor: "cyan", borderDimColor: true, paddingLeft: 1, paddingRight: 4, marginTop: 1, marginBottom: 1, marginX: 1, width: size.width - 2, flexDirection: "column", gap: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "cyan", bold: true, children: "Summary" }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_markdown_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Ay, { content: summary })] }));
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/text-input.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var chalk__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../node_modules/.pnpm/chalk@5.4.1/node_modules/chalk/source/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _context_theme_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/context/theme-context.tsx");
/* harmony import */ var _context_vim_mode_context_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/context/vim-mode-context.tsx");
/* harmony import */ var _hooks_use_text_input_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/hooks/use-text-input.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _context_theme_context_js__WEBPACK_IMPORTED_MODULE_3__, _hooks_use_text_input_js__WEBPACK_IMPORTED_MODULE_5__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _context_theme_context_js__WEBPACK_IMPORTED_MODULE_3__, _hooks_use_text_input_js__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







// Constants for pasted text placeholder styling
const PASTED_TEXT_LABEL = "Pasted text";
const escapeRegExp = (s) => s.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
const LARGE_PASTE_PLACEHOLDER_RE = new RegExp(`\\[${escapeRegExp(PASTED_TEXT_LABEL)} #(\\d+)(?: \\+\\d+(?: lines)?)?\\]`, "g");
// Function to apply styling to pasted text placeholders
const stylePastedTextPlaceholders = (text, isLightTheme) => {
    return text.replace(LARGE_PASTE_PLACEHOLDER_RE, match => {
        // Use a dimmed gray color to make it obvious it's not literal text
        return isLightTheme ? chalk__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Ay.dim.gray(match) : chalk__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Ay.dim.cyan(match);
    });
};
function TextInput({ value: originalValue, placeholder = "", rightPlaceholder, focus = true, visualFocus = false, mask, highlightPastedText = false, showCursor = true, dimmed = false, onChange, onSubmit, onTab, onCtrlC, onShiftTab, cursorToEndSignal, onCursorInfoChange, onUpAtFirstLine, onDownAtLastLine, onPaste, allowExplicitNewline, onCtrlR, onCtrlD, }) {
    var _a;
    const { mode, vimEnabled } = (0,_context_vim_mode_context_js__WEBPACK_IMPORTED_MODULE_4__/* .useVimMode */ .v)();
    const { stdout } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useStdout */ .t$)();
    const { cursorOffset, cursorWidth } = (0,_hooks_use_text_input_js__WEBPACK_IMPORTED_MODULE_5__/* .useTextInput */ .t)(originalValue, onChange, {
        focus,
        showCursor,
        highlightPastedText,
        onSubmit,
        onTab,
        onShiftTab,
        onCtrlC,
        onCtrlD,
        onCtrlR,
        cursorToEndSignal,
        onCursorInfoChange,
        onUpAtFirstLine,
        onDownAtLastLine,
        onPaste,
        allowExplicitNewline,
    });
    const cursorActualWidth = highlightPastedText ? cursorWidth : 0;
    const isLightTheme = (0,_context_theme_context_js__WEBPACK_IMPORTED_MODULE_3__/* .useIsLightTheme */ .pW)();
    const value = mask ? mask.repeat(originalValue.length) : originalValue;
    let renderedValue = value;
    let renderedPlaceholder = placeholder ? chalk__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Ay.grey(placeholder) : undefined;
    if (showCursor && (focus || visualFocus)) {
        const isNormalMode = vimEnabled && mode === "normal";
        const cursorStyle = isNormalMode ? chalk__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Ay.bgGray : chalk__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Ay.inverse;
        renderedPlaceholder =
            placeholder.length > 0
                ? cursorStyle(placeholder[0]) +
                    (isLightTheme
                        ? chalk__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Ay.dim(chalk__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Ay.grey(placeholder.slice(1)))
                        : chalk__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Ay.grey(placeholder.slice(1)))
                : cursorStyle(" ");
        renderedValue = value.length > 0 ? "" : cursorStyle(" ");
        let i = 0;
        let col = 0;
        const cols = (_a = stdout === null || stdout === void 0 ? void 0 : stdout.columns) !== null && _a !== void 0 ? _a : 0;
        let caretInserted = false;
        for (const char of value) {
            if (char === "\n") {
                const isCursorOnNewlineChar = i >= cursorOffset - cursorActualWidth && i < cursorOffset;
                const atEndOfLineBeforeNewline = cursorActualWidth === 0 &&
                    cursorOffset === i &&
                    // avoid double-caret on empty lines (previous char is a newline)
                    (i === 0 || value[i - 1] !== "\n");
                if (!caretInserted &&
                    (isCursorOnNewlineChar || atEndOfLineBeforeNewline)) {
                    if (!(cols > 0 && col === cols - 1))
                        renderedValue += cursorStyle(" ");
                    caretInserted = true;
                }
                renderedValue += "\n";
                i++;
                col = 0;
                const isCaretAtStartOfNextLine = cursorActualWidth === 0 && cursorOffset === i;
                if (!caretInserted && isCaretAtStartOfNextLine) {
                    const nextChar = value[i];
                    if (nextChar == null || nextChar === "\n") {
                        renderedValue += cursorStyle(" ");
                        caretInserted = true;
                    }
                }
                continue;
            }
            const hasSelection = cursorActualWidth > 0 &&
                i >= cursorOffset - cursorActualWidth &&
                i < cursorOffset;
            const caretOnThisChar = cursorActualWidth === 0 && i === cursorOffset;
            if (hasSelection || caretOnThisChar) {
                renderedValue += cursorStyle(char);
                if (caretOnThisChar)
                    caretInserted = true;
            }
            else {
                renderedValue += char;
            }
            i += char.length;
            col++;
            if (cols > 0 && col >= cols)
                col = 0;
        }
        if (!caretInserted && value.length > 0 && cursorOffset === value.length) {
            renderedValue += cursorStyle(" ");
            caretInserted = true;
        }
    }
    const { isRawModeSupported } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useStdin */ .mT)();
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        if (isRawModeSupported)
            process.stdin.setRawMode(true);
        return () => {
            if (isRawModeSupported)
                process.stdin.setRawMode(false);
        };
    }, [isRawModeSupported]);
    const text = placeholder
        ? value.length > 0
            ? renderedValue
            : renderedPlaceholder
        : renderedValue;
    // Apply styling to pasted text placeholders
    const styledText = typeof text === "string"
        ? stylePastedTextPlaceholders(text, isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false)
        : text;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", justifyContent: "space-between", width: "100%", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexGrow: 1, marginRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: dimmed, children: styledText }) }), rightPlaceholder && value.length === 0 && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexShrink: 0, marginLeft: 1, marginRight: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", dimColor: isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false, children: rightPlaceholder }) }))] }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (react__WEBPACK_IMPORTED_MODULE_2__.memo(TextInput));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/todos-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   S: () => (/* binding */ TodosUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_proto_agent_v1_todo_tool_pb_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../proto/dist/generated/agent/v1/todo_tool_pb.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/tool-call-header.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const TodosUI = ({ todos, totalCount: _totalCount, loading, error, mode, filters, showHeader = true, isCreating = false, }) => {
    const action = mode === "read" ? "Reading" : isCreating ? "Creating" : "Updating";
    if (loading) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__/* .ToolCallHeader */ .C, { name: "To-do", primary: `${action} to-dos${filters ? ` ${filters}` : ""}...`, status: "pending" }));
    }
    if (error) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: 1, paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: ["Error", " ", mode === "read" ? "reading" : isCreating ? "creating" : "updating", " ", "to-dos: ", error] }) }));
    }
    if (todos.length === 0) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: 1, paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: ["No to-dos found", filters ? ` ${filters}` : ""] }) }));
    }
    const completed = todos.filter(t => t.status === _anysphere_proto_agent_v1_todo_tool_pb_js__WEBPACK_IMPORTED_MODULE_2__/* .TodoStatus */ .Vj.COMPLETED);
    const inProgress = todos.filter(t => t.status === _anysphere_proto_agent_v1_todo_tool_pb_js__WEBPACK_IMPORTED_MODULE_2__/* .TodoStatus */ .Vj.IN_PROGRESS);
    const pending = todos.filter(t => t.status === _anysphere_proto_agent_v1_todo_tool_pb_js__WEBPACK_IMPORTED_MODULE_2__/* .TodoStatus */ .Vj.PENDING);
    const workingCount = inProgress.length + pending.length;
    const doneCount = completed.length;
    const lines = [];
    for (const t of completed)
        lines.push({ icon: "☒", text: t.content });
    for (const t of inProgress)
        lines.push({ icon: "☐", text: t.content });
    for (const t of pending)
        lines.push({ icon: "☐", text: t.content });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: [showHeader && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_4__/* .ToolCallHeader */ .C, { name: "To-do", primary: (() => {
                    const noun = workingCount === 1 ? "to-do" : "to-dos";
                    const donePart = workingCount > 0 && doneCount > 0 ? ` • ${doneCount} done` : "";
                    if (workingCount > 0)
                        return `Working on ${workingCount} ${noun}${donePart}`;
                    return "All done";
                })(), status: "success" })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_3__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, children: lines.map((l, i) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "row", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [l.icon, " "] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "wrap", children: l.text })] }, `${l.icon}-${l.text}-${i}`))) })] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/tool-call-header.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: () => (/* binding */ ToolCallHeader)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


function statusColor(status) {
    switch (status) {
        case "success":
            return "white";
        case "error":
            return "gray";
        case "rejected":
            return "yellow";
        case "pending":
            return "yellow";
        default:
            return "gray";
    }
}
const ToolCallHeader = ({ name, primary, status, note, }) => {
    const color = statusColor(status);
    const noteColor = "gray";
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { gap: 1, alignItems: "flex-start", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { width: 1, flexShrink: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: color, dimColor: status === "success", children: status === "success" ? "⬢" : "⬡" }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexGrow: 1, flexShrink: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { wrap: "wrap", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { bold: true, children: name }), primary ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: primary })] })) : null, note ? (typeof note === "string" ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: noteColor, wrap: "wrap", children: note })] })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: " " }), note] }))) : null] }) })] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/tool-row-box.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: () => (/* binding */ ToolRowBox)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/hooks/use-screen-size.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_2__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};



const ToolRowBox = (_a) => {
    var { fullWidth, width, children } = _a, rest = __rest(_a, ["fullWidth", "width", "children"]);
    const size = (0,_hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_2__/* .useScreenSize */ .l)();
    const computedWidth = fullWidth
        ? "100%"
        : (width !== null && width !== void 0 ? width : Math.max(0, size.width - 2));
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, Object.assign({ borderStyle: "single", borderColor: "gray", borderDimColor: true, gap: 1, width: computedWidth }, rest, { children: children })));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/turn-file-changes.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* unused harmony export TurnFileChanges */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _utils_path_utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/utils/path-utils.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const calculateLineChanges = (change) => {
    const before = change.before || "";
    const after = change.after || "";
    if (change.before === undefined) {
        // New file - all lines are added
        const afterLines = after.split("\n");
        // Don't count empty files as having 1 line
        const linesAdded = after.trim() === "" ? 0 : afterLines.length;
        return { added: linesAdded, removed: 0, total: linesAdded };
    }
    if (change.after === undefined) {
        // Deleted file - all lines are removed
        const beforeLines = before.split("\n");
        // Don't count empty files as having 1 line
        const linesRemoved = before.trim() === "" ? 0 : beforeLines.length;
        return { added: 0, removed: linesRemoved, total: linesRemoved };
    }
    // Modified file - use proper diff algorithm
    const beforeLines = before.split("\n");
    const afterLines = after.split("\n");
    let added = 0;
    let removed = 0;
    let beforeIndex = 0;
    let afterIndex = 0;
    const isCommon = (aIndex, bIndex) => {
        return beforeLines[aIndex] === afterLines[bIndex];
    };
    const foundSubsequence = (nCommon, aCommon, bCommon) => {
        // Count removed lines (lines that exist in before but not in after)
        for (let i = beforeIndex; i < aCommon; i++) {
            removed++;
        }
        // Count added lines (lines that exist in after but not in before)
        for (let i = afterIndex; i < bCommon; i++) {
            added++;
        }
        // Skip the common lines
        beforeIndex = aCommon + nCommon;
        afterIndex = bCommon + nCommon;
    };
    // Run the diff algorithm
    diffSequences(beforeLines.length, afterLines.length, isCommon, foundSubsequence);
    // Handle remaining lines at the end
    for (let i = beforeIndex; i < beforeLines.length; i++) {
        removed++;
    }
    for (let i = afterIndex; i < afterLines.length; i++) {
        added++;
    }
    return { added, removed, total: added + removed };
};
const TurnFileChanges = ({ fileChanges, compact = false, }) => {
    if (!fileChanges || fileChanges.length === 0) {
        return null;
    }
    const getChangeType = (change) => {
        if (change.before === undefined)
            return "created";
        if (change.after === undefined)
            return "deleted";
        return "modified";
    };
    const getChangeColor = (change) => {
        if (change.before === undefined)
            return "green";
        if (change.after === undefined)
            return "red";
        return "yellow";
    };
    const getChangeIcon = (change) => {
        if (change.before === undefined)
            return "+";
        if (change.after === undefined)
            return "-";
        return "~";
    };
    if (compact) {
        return (_jsx(Box, { flexDirection: "column", children: fileChanges.map(change => {
                const lineChanges = calculateLineChanges(change);
                const changeType = getChangeType(change);
                const relativePath = toRelativePath(change.path);
                const formatLineChanges = () => {
                    if (changeType === "created") {
                        return `+${lineChanges.added}`;
                    }
                    if (changeType === "deleted") {
                        return `-${lineChanges.removed}`;
                    }
                    // Modified file
                    if (lineChanges.added === 0 && lineChanges.removed === 0) {
                        return "0";
                    }
                    if (lineChanges.added === 0) {
                        return `-${lineChanges.removed}`;
                    }
                    if (lineChanges.removed === 0) {
                        return `+${lineChanges.added}`;
                    }
                    return `+${lineChanges.added}/-${lineChanges.removed}`;
                };
                return (_jsx(Box, { children: _jsxs(Text, { children: [_jsx(Text, { color: getChangeColor(change), dimColor: true, children: getChangeIcon(change) }), _jsxs(Text, { children: [" ", relativePath] }), _jsxs(Text, { dimColor: true, children: [" (", formatLineChanges(), ")"] })] }) }, change.path));
            }) }));
    }
    return (_jsxs(Box, { flexDirection: "column", marginTop: 1, children: [_jsxs(Text, { color: "gray", dimColor: true, children: ["Files changed (", fileChanges.length, "):"] }), fileChanges.map(change => {
                const relativePath = toRelativePath(change.path);
                return (_jsxs(Box, { marginLeft: 1, children: [_jsxs(Text, { color: getChangeColor(change), dimColor: true, children: [getChangeIcon(change), " [", getChangeType(change), "]"] }), _jsxs(Text, { children: [" ", relativePath] })] }, change.path));
            })] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/unified-list-pager.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   W: () => (/* binding */ UnifiedListPager)
/* harmony export */ });
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:fs");
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_fs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../agent-kv/dist/index.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_proto_aiserver_v1_background_composer_pb_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../proto/dist/generated/aiserver/v1/background_composer_pb.js");
/* harmony import */ var chalk__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("../../node_modules/.pnpm/chalk@5.4.1/node_modules/chalk/source/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/hooks/use-screen-size.ts");
/* harmony import */ var _state_index_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/state/index.ts");
/* harmony import */ var _state_sqlite_blob_store_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("./src/state/sqlite-blob-store.ts");
/* harmony import */ var _utils_characters_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("./src/utils/characters.ts");
/* harmony import */ var _utils_git_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("./src/utils/git.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__, _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_7__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__, _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};









// Note: avoid animation ticks here to prevent flicker
// and keep the UI static except for selection changes




const calculateDiffStatsFromOptimized = (detailed) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    if (!detailed)
        return undefined;
    let totalAdded = 0;
    let totalRemoved = 0;
    // Top-level diffs
    const topLevelDiffs = (_b = (_a = detailed.diff) === null || _a === void 0 ? void 0 : _a.diffs) !== null && _b !== void 0 ? _b : [];
    for (const fd of topLevelDiffs) {
        totalAdded += Math.max(0, (_c = fd.added) !== null && _c !== void 0 ? _c : 0);
        totalRemoved += Math.max(0, (_d = fd.removed) !== null && _d !== void 0 ? _d : 0);
    }
    // Submodule diffs
    const submoduleDiffs = (_e = detailed.submoduleDiffs) !== null && _e !== void 0 ? _e : [];
    for (const sm of submoduleDiffs) {
        if (sm.errored)
            continue;
        const sdiffs = (_g = (_f = sm.diff) === null || _f === void 0 ? void 0 : _f.diffs) !== null && _g !== void 0 ? _g : [];
        for (const fd of sdiffs) {
            totalAdded += Math.max(0, (_h = fd.added) !== null && _h !== void 0 ? _h : 0);
            totalRemoved += Math.max(0, (_j = fd.removed) !== null && _j !== void 0 ? _j : 0);
        }
    }
    return totalAdded > 0 || totalRemoved > 0
        ? { totalAdded, totalRemoved }
        : undefined;
};
const normalizeTimestampMs = (ts) => {
    const n = typeof ts === "number" ? ts : 0;
    if (n <= 0 || !Number.isFinite(n))
        return 0;
    // Heuristics:
    // < 1e11: seconds
    // 1e11..1e14: milliseconds
    // 1e14..1e17: microseconds
    // >= 1e17: nanoseconds
    if (n < 1e11)
        return Math.floor(n * 1000); // seconds -> ms
    if (n >= 1e14 && n < 1e17)
        return Math.floor(n / 1000); // microseconds -> ms
    if (n >= 1e17)
        return Math.floor(n / 1000000); // nanoseconds -> ms
    return Math.floor(n); // milliseconds already
};
const UnifiedListPager = ({ client, onClose, onSelectChat, onSelectBackground, }) => {
    var _a, _b, _c, _d;
    const DIFF_STATS_TIMEOUT_MS = 10000;
    // repo filters now provided by util
    const fetchDiffStatsWithTimeout = (0,react__WEBPACK_IMPORTED_MODULE_5__.useCallback)((bcId) => __awaiter(void 0, void 0, void 0, function* () {
        if (!client)
            return undefined;
        let timeoutId;
        const timeoutPromise = new Promise(resolve => {
            timeoutId = setTimeout(() => resolve(undefined), DIFF_STATS_TIMEOUT_MS);
        });
        const detailsPromise = (() => __awaiter(void 0, void 0, void 0, function* () {
            try {
                return yield client.getOptimizedDiffDetails({ bcId });
            }
            catch (_a) {
                return undefined;
            }
        }))();
        const winner = yield Promise.race([detailsPromise, timeoutPromise]);
        if (timeoutId)
            clearTimeout(timeoutId);
        if (!winner)
            return undefined;
        return calculateDiffStatsFromOptimized(winner);
    }), [client]);
    const [items, setItems] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)([]);
    const [active, setActive] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(0);
    const [scrollTop, setScrollTop] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(0);
    const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(true);
    // Numeric prefix buffer for motions (e.g., 5j / 10↓ / 2Ctrl-F)
    const [commandBuffer, setCommandBuffer] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)("");
    // Deletion confirmation state
    const [confirmActive, setConfirmActive] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
    const [confirmIndex, setConfirmIndex] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(0); // 0 = continue, 1 = cancel
    const [confirmTitle, setConfirmTitle] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)("");
    const [confirmDetail, setConfirmDetail] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(undefined);
    const [continueLabel, setContinueLabel] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)("Continue");
    const [cancelLabel, setCancelLabel] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)("Cancel");
    const [pendingDelete, setPendingDelete] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(null);
    const { stdout } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .useStdout */ .t$)();
    const screen = (0,_hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_7__/* .useScreenSize */ .l)();
    (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
        if (!stdout)
            return;
        try {
            stdout.write("\x1b[?1049h\x1b[?7l\x1b[?1h\x1b=");
        }
        catch (_a) {
            // ignore terminal control errors
        }
        return () => {
            try {
                stdout.write("\x1b[?1l\x1b>\x1b[?7h\x1b[?1049l");
            }
            catch (_a) {
                // ignore terminal control errors
            }
        };
    }, [stdout]);
    (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
        let cancelled = false;
        void (() => __awaiter(void 0, void 0, void 0, function* () {
            var _a;
            try {
                // Load background composers (feature gated)
                let backgrounds = [];
                if (client && _constants_js__WEBPACK_IMPORTED_MODULE_6__/* .BACKGROUND_ENABLED */ .xZ) {
                    try {
                        const filters = (0,_utils_git_js__WEBPACK_IMPORTED_MODULE_10__/* .getRepoUrlFilters */ .X)();
                        const resp = yield client.listBackgroundComposers({
                            n: 32,
                            includeStatus: true,
                            preferredRepoUrl: filters.preferredRepoUrl,
                            additionalRepoUrls: filters.additionalRepoUrls,
                        });
                        const rawBackgrounds = ((_a = resp.composers) !== null && _a !== void 0 ? _a : [])
                            .map(c => {
                            var _a, _b, _c, _d, _e, _f, _g;
                            return ({
                                kind: "background",
                                id: (_a = c.bcId) !== null && _a !== void 0 ? _a : "",
                                name: c.name || "Background Agent",
                                repoUrl: (_b = c.repoUrl) !== null && _b !== void 0 ? _b : "",
                                branch: (_c = c.branchName) !== null && _c !== void 0 ? _c : "",
                                status: (_d = c.status) !== null && _d !== void 0 ? _d : _anysphere_proto_aiserver_v1_background_composer_pb_js__WEBPACK_IMPORTED_MODULE_4__/* .BackgroundComposerStatus */ .R6.UNSPECIFIED,
                                // Prefer createdAt for background agents per request; fallback to updatedAt
                                updatedAtMs: normalizeTimestampMs((_f = (_e = c.createdAtMs) !== null && _e !== void 0 ? _e : c.updatedAtMs) !== null && _f !== void 0 ? _f : 0),
                                isArchived: (_g = c.isArchived) !== null && _g !== void 0 ? _g : false,
                            });
                        })
                            .filter(r => r.id.length > 0 && !r.isArchived);
                        // Do not block on diff stats; set base backgrounds first
                        backgrounds = rawBackgrounds;
                    }
                    catch (_b) {
                        backgrounds = [];
                    }
                }
                // Load chat sessions
                let chats = [];
                try {
                    const root = (0,_state_index_js__WEBPACK_IMPORTED_MODULE_8__/* .getChatsRootDir */ .r)();
                    const entries = (0,node_fs__WEBPACK_IMPORTED_MODULE_0__.readdirSync)(root, { withFileTypes: true });
                    const infos = yield Promise.all(entries
                        .filter(e => e.isDirectory())
                        .map((e) => __awaiter(void 0, void 0, void 0, function* () {
                        var _a, _b;
                        try {
                            const chatPath = (0,node_path__WEBPACK_IMPORTED_MODULE_1__.join)(root, e.name);
                            const dbPath = (0,node_path__WEBPACK_IMPORTED_MODULE_1__.join)(chatPath, "store.db");
                            // Determine createdAt for chats. Prefer metadata.createdAt; fall back to FS birth times.
                            let createdAtFsMs = Number.MAX_SAFE_INTEGER;
                            try {
                                const dbStat = (0,node_fs__WEBPACK_IMPORTED_MODULE_0__.statSync)(dbPath);
                                const dbBirthOrMod = Math.floor(dbStat.birthtimeMs || dbStat.mtimeMs);
                                if (dbBirthOrMod > 0) {
                                    createdAtFsMs = Math.min(createdAtFsMs, dbBirthOrMod);
                                }
                            }
                            catch (_c) {
                                void 0;
                            }
                            try {
                                const dirStat = (0,node_fs__WEBPACK_IMPORTED_MODULE_0__.statSync)(chatPath);
                                const dirBirthOrMod = Math.floor(dirStat.birthtimeMs || dirStat.mtimeMs);
                                if (dirBirthOrMod > 0) {
                                    createdAtFsMs = Math.min(createdAtFsMs, dirBirthOrMod);
                                }
                            }
                            catch (_d) {
                                void 0;
                            }
                            if (createdAtFsMs === Number.MAX_SAFE_INTEGER) {
                                createdAtFsMs = 0;
                            }
                            // Now open DB to get name/metadata
                            const sqlite = yield _state_sqlite_blob_store_js__WEBPACK_IMPORTED_MODULE_9__/* .SQLiteBlobStoreWithMetadata */ .M.initAndLoad(dbPath);
                            const name = (_a = sqlite.get("name")) !== null && _a !== void 0 ? _a : (0,_anysphere_agent_kv__WEBPACK_IMPORTED_MODULE_2__/* .getDefaultAgentMetadata */ .sh)().name;
                            const latestRootBlobId = sqlite.get("latestRootBlobId");
                            if (!latestRootBlobId || latestRootBlobId.length === 0) {
                                return null;
                            }
                            // Prefer DB metadata createdAt if present
                            let createdAtMs = normalizeTimestampMs((_b = sqlite.get("createdAt")) !== null && _b !== void 0 ? _b : 0);
                            if (!createdAtMs) {
                                createdAtMs = normalizeTimestampMs(createdAtFsMs);
                            }
                            const item = {
                                kind: "chat",
                                id: e.name,
                                name,
                                // We store createdAt in the unified timestamp field for sorting/display
                                updatedAtMs: createdAtMs,
                            };
                            return item;
                        }
                        catch (_e) {
                            return null;
                        }
                    })));
                    const nonNullInfos = infos.filter((x) => x !== null);
                    chats = nonNullInfos;
                }
                catch (_c) {
                    chats = [];
                }
                const combined = [...backgrounds, ...chats].sort((a, b) => (b.updatedAtMs || 0) - (a.updatedAtMs || 0));
                if (!cancelled) {
                    setItems(combined);
                }
                // Fetch diff stats asynchronously and merge results (feature gated)
                if (client && _constants_js__WEBPACK_IMPORTED_MODULE_6__/* .BACKGROUND_ENABLED */ .xZ) {
                    void (() => __awaiter(void 0, void 0, void 0, function* () {
                        try {
                            const bgItems = combined.filter((it) => it.kind === "background");
                            if (bgItems.length === 0)
                                return;
                            const results = yield Promise.allSettled(bgItems.map((bg) => __awaiter(void 0, void 0, void 0, function* () {
                                const stats = yield fetchDiffStatsWithTimeout(bg.id);
                                return { id: bg.id, stats };
                            })));
                            if (cancelled)
                                return;
                            const idToStats = new Map();
                            for (const r of results) {
                                if (r.status === "fulfilled") {
                                    idToStats.set(r.value.id, r.value.stats);
                                }
                            }
                            setItems(prev => prev.map(it => {
                                if (it.kind !== "background")
                                    return it;
                                const s = idToStats.get(it.id);
                                if (!s)
                                    return it;
                                return Object.assign(Object.assign({}, it), { totalAdded: s.totalAdded, totalRemoved: s.totalRemoved });
                            }));
                        }
                        catch (_a) {
                            // ignore
                        }
                    }))();
                }
            }
            finally {
                if (!cancelled)
                    setLoading(false);
            }
        }))();
        return () => {
            cancelled = true;
        };
    }, [client, fetchDiffStatsWithTimeout]);
    const termWidth = (_b = (_a = screen === null || screen === void 0 ? void 0 : screen.width) !== null && _a !== void 0 ? _a : stdout === null || stdout === void 0 ? void 0 : stdout.columns) !== null && _b !== void 0 ? _b : 80;
    const termHeight = (_d = (_c = screen === null || screen === void 0 ? void 0 : screen.height) !== null && _c !== void 0 ? _c : stdout === null || stdout === void 0 ? void 0 : stdout.rows) !== null && _d !== void 0 ? _d : 24;
    // Match ChatPicker layout: 3-line header + 2-line footer
    const listStartRow = 4;
    const contentHeight = Math.max(1, termHeight - 6);
    // Clamp selection/scroll when items load or screen size changes
    (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
        if (items.length === 0) {
            // Always reset to sane defaults when empty
            setActive(0);
            setScrollTop(0);
            return;
        }
        setActive(a => Math.max(0, Math.min(a, items.length - 1)));
        setScrollTop(s => {
            const maxTop = Math.max(0, items.length - contentHeight);
            return Math.max(0, Math.min(s, maxTop));
        });
    }, [items.length, contentHeight]);
    (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
        if (active < scrollTop)
            setScrollTop(active);
        else if (active >= scrollTop + contentHeight)
            setScrollTop(Math.max(0, active - contentHeight + 1));
    }, [active, contentHeight, scrollTop]);
    (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_3__/* .useInput */ .Ge)((input, key) => {
        // Handle confirmation modal interactions first
        if (confirmActive) {
            if (key.downArrow || input === "j" || input === "J") {
                setConfirmIndex(i => Math.min(1, i + 1));
                return;
            }
            if (key.upArrow || input === "k" || input === "K") {
                setConfirmIndex(i => Math.max(0, i - 1));
                return;
            }
            if (key.ctrl && input === "d") {
                onClose();
                return;
            }
            if (key.escape ||
                (key.ctrl && input === "c") ||
                input === "n" ||
                input === "N" ||
                input === "q" ||
                input === "Q") {
                setConfirmActive(false);
                setPendingDelete(null);
                setConfirmIndex(0);
                return;
            }
            if (key.return || input === "y" || input === "Y") {
                const accept = confirmIndex === 0 || input === "y" || input === "Y";
                const target = pendingDelete;
                setConfirmActive(false);
                setPendingDelete(null);
                setConfirmIndex(0);
                if (accept && target) {
                    const { index, item } = target;
                    if (item.kind === "chat") {
                        try {
                            const dir = (0,node_path__WEBPACK_IMPORTED_MODULE_1__.join)((0,_state_index_js__WEBPACK_IMPORTED_MODULE_8__/* .getChatsRootDir */ .r)(), item.id);
                            (0,node_fs__WEBPACK_IMPORTED_MODULE_0__.rmSync)(dir, { recursive: true, force: true });
                        }
                        catch (_a) {
                            // ignore deletion errors
                        }
                        setItems(prev => prev.filter((_, i) => i !== index));
                    }
                    else {
                        // background: optimistic remove, then archive via client
                        setItems(prev => prev.filter((_, i) => i !== index));
                        void (() => __awaiter(void 0, void 0, void 0, function* () {
                            var _a;
                            try {
                                yield ((_a = client === null || client === void 0 ? void 0 : client.archiveBackgroundComposer) === null || _a === void 0 ? void 0 : _a.call(client, { bcId: item.id }));
                            }
                            catch (_b) {
                                // ignore errors; item already removed optimistically
                            }
                        }))();
                    }
                }
                return;
            }
            // consume other keys while active
            return;
        }
        if ((key.ctrl && input === "d") ||
            (key.ctrl && input === "c") ||
            key.escape ||
            input === "q") {
            setCommandBuffer("");
            onClose();
            return;
        }
        // Build count from numeric prefix (default 1)
        if (/^[0-9]$/.test(input)) {
            setCommandBuffer(prev => (prev + input).replace(/^0+/, ""));
            return;
        }
        if (key.backspace || key.delete) {
            if (commandBuffer.length > 0) {
                setCommandBuffer(prev => prev.slice(0, -1));
                return;
            }
            // Initiate delete for selected item
            const listReady = items.length > 0 && !loading;
            if (!listReady)
                return;
            const target = items[active];
            if (!target)
                return;
            setConfirmIndex(0);
            if (target.kind === "chat") {
                setConfirmTitle("Delete session?");
                setConfirmDetail(`This will permanently remove the local session “${target.name}”.`);
                setContinueLabel("Delete");
                setCancelLabel("Cancel");
            }
            else {
                setConfirmTitle("Delete background agent?");
                setConfirmDetail(`This will remove “${target.name}” from the list.`);
                setContinueLabel("Delete");
                setCancelLabel("Cancel");
            }
            setPendingDelete({ index: active, item: target });
            setConfirmActive(true);
            return;
        }
        const getCount = () => {
            const n = parseInt(commandBuffer || "1", 10);
            return Number.isFinite(n) && n > 0 ? n : 1;
        };
        const clearCount = () => setCommandBuffer("");
        // If list isn't ready, ignore navigation keys to avoid invalid state
        const listReady = items.length > 0 && !loading;
        if (key.upArrow || input === "k") {
            if (!listReady)
                return;
            const count = getCount();
            clearCount();
            setActive(a => Math.max(0, a - count));
            return;
        }
        if (key.downArrow || input === "j") {
            if (!listReady)
                return;
            const count = getCount();
            clearCount();
            setActive(a => Math.min(items.length - 1, a + count));
            return;
        }
        // Page navigation (ctrl-f / ctrl-b)
        if (key.ctrl && input === "f") {
            if (!listReady)
                return;
            const count = getCount();
            clearCount();
            const delta = count * Math.max(1, contentHeight - 1);
            setActive(a => Math.min(items.length - 1, a + delta));
            setScrollTop(s => Math.min(Math.max(0, items.length - contentHeight), s + delta));
            return;
        }
        if (key.ctrl && input === "b") {
            if (!listReady)
                return;
            const count = getCount();
            clearCount();
            const delta = count * Math.max(1, contentHeight - 1);
            setActive(a => Math.max(0, a - delta));
            setScrollTop(s => Math.max(0, s - delta));
            return;
        }
        // Home / End (g / G)
        if (input === "g") {
            if (!listReady)
                return;
            clearCount();
            setActive(0);
            setScrollTop(0);
            return;
        }
        if (input === "G") {
            if (!listReady)
                return;
            const hadBuffer = commandBuffer.length > 0;
            const count = getCount();
            clearCount();
            if (hadBuffer) {
                const target = Math.max(0, Math.min(items.length - 1, count - 1));
                setActive(target);
                setScrollTop(_s => {
                    const maxTop = Math.max(0, items.length - contentHeight);
                    return Math.max(0, Math.min(maxTop, target - Math.floor(contentHeight / 2)));
                });
            }
            else {
                const lastIndex = Math.max(0, items.length - 1);
                setActive(lastIndex);
                setScrollTop(Math.max(0, items.length - contentHeight));
            }
            return;
        }
        // PageUp/PageDown with count if available
        const kpd = key;
        if (kpd.pageDown) {
            if (!listReady)
                return;
            const count = getCount();
            clearCount();
            const delta = count * Math.max(1, contentHeight - 1);
            setActive(a => Math.min(items.length - 1, a + delta));
            setScrollTop(s => Math.min(Math.max(0, items.length - contentHeight), s + delta));
            return;
        }
        if (kpd.pageUp) {
            if (!listReady)
                return;
            const count = getCount();
            clearCount();
            const delta = count * Math.max(1, contentHeight - 1);
            setActive(a => Math.max(0, a - delta));
            setScrollTop(s => Math.max(0, s - delta));
            return;
        }
        if (key.return) {
            clearCount();
            const picked = items[active];
            if (!picked)
                return;
            if (picked.kind === "chat")
                onSelectChat === null || onSelectChat === void 0 ? void 0 : onSelectChat(picked.id);
            else
                onSelectBackground === null || onSelectBackground === void 0 ? void 0 : onSelectBackground(picked.id);
            return;
        }
    });
    (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
        var _a, _b, _c, _d, _e, _f;
        if (!stdout)
            return;
        // Use chalk for color; it respects terminal capabilities
        const visibleLength = (text) => (0,_utils_characters_js__WEBPACK_IMPORTED_MODULE_11__/* .stripAnsi */ .aJ)(text).length;
        const truncateEndPlain = (text, width) => {
            const t = text.trim();
            if (width <= 0)
                return "";
            if (t.length <= width)
                return t;
            if (width <= 3)
                return t.slice(0, width);
            return `${t.slice(0, Math.max(0, width - 3))}...`;
        };
        const firstLine = (text) => {
            const s = typeof text === "string" ? text : "";
            const idx = s.indexOf("\n");
            if (idx === -1)
                return s.replace(/\r/g, "");
            return s.slice(0, idx).replace(/\r/g, "");
        };
        // If a confirmation modal is active, draw only the modal to reduce flicker and return
        if (confirmActive) {
            const title = confirmTitle;
            const detail = confirmDetail;
            const options = [
                { label: continueLabel, hint: "y" },
                { label: cancelLabel, hint: "esc/n" },
            ];
            const maxWidth = Math.max(28, Math.min(60, termWidth - 12));
            // inner content area excludes 2 borders + 2 side paddings
            const contentWidth = Math.max(8, maxWidth - 4);
            const trunc = (t) => {
                const s = (t !== null && t !== void 0 ? t : "").trim();
                if (visibleLength(s) <= contentWidth)
                    return s;
                return `${(0,_utils_characters_js__WEBPACK_IMPORTED_MODULE_11__/* .stripAnsi */ .aJ)(s).slice(0, Math.max(0, contentWidth - 3))}...`;
            };
            const titleLine = trunc(title);
            const detailLine = detail ? trunc(detail) : undefined;
            const optionLines = options.map((opt, idx) => {
                const isActiveRow = idx === confirmIndex;
                const arrowChar = isActiveRow ? chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white("→") : chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(" ");
                const availableTextCols = Math.max(0, contentWidth - 2); // arrow(1) + space(1)
                const raw = `${opt.label}${opt.hint ? ` ${opt.hint}` : ""}`;
                const plain = (0,_utils_characters_js__WEBPACK_IMPORTED_MODULE_11__/* .stripAnsi */ .aJ)(raw);
                const truncated = plain.length > availableTextCols
                    ? `${plain.slice(0, Math.max(0, availableTextCols - 3))}...`
                    : plain;
                const labelLen = opt.label.length;
                const truncLabel = truncated.slice(0, Math.min(labelLen, truncated.length));
                const truncHint = truncated.slice(truncLabel.length);
                const coloredLabel = isActiveRow
                    ? chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white.bold(truncLabel)
                    : chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(truncLabel);
                const coloredHint = truncHint.length > 0
                    ? isActiveRow
                        ? chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white.dim(truncHint)
                        : chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(truncHint)
                    : "";
                const content = `${arrowChar} ${coloredLabel}${coloredHint}`;
                return content;
            });
            const contentLines = [
                chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white.bold(titleLine),
                ...(detailLine ? [chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(detailLine)] : []),
                ...optionLines,
            ];
            const borderColor = chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray.dim;
            const overlayHeight = 2 + contentLines.length;
            const startRow = listStartRow +
                Math.max(0, Math.floor((contentHeight - overlayHeight) / 2));
            const colStart = Math.max(1, Math.floor((termWidth - maxWidth) / 2) + 1);
            // Borders (dimmed)
            const top = `${borderColor("┌")}${borderColor("─".repeat(maxWidth - 2))}${borderColor("┐")}`;
            stdout.write(`\x1b[${startRow};${colStart}H${top}`);
            for (let i = 0; i < contentLines.length; i++) {
                const row = startRow + 1 + i;
                const line = contentLines[i];
                // Left border
                stdout.write(`\x1b[${row};${colStart}H${borderColor("│")}`);
                // Left padding
                stdout.write(" ");
                // Write content padded to content width to avoid lingering artifacts
                const lineLen = visibleLength((0,_utils_characters_js__WEBPACK_IMPORTED_MODULE_11__/* .stripAnsi */ .aJ)(line));
                const pad = Math.max(0, contentWidth - lineLen);
                stdout.write(`${line}${" ".repeat(pad)}`);
                // Right padding
                stdout.write(" ");
                // Right border
                const rightCol = colStart + maxWidth - 1;
                stdout.write(`\x1b[${row};${rightCol}H${borderColor("│")}`);
            }
            const bottom = `${borderColor("└")}${borderColor("─".repeat(maxWidth - 2))}${borderColor("┘")}`;
            stdout.write(`\x1b[${startRow + overlayHeight - 1};${colStart}H${bottom}`);
            return; // do not redraw header/list/footer while modal is active
        }
        // Header (rows 1-3) — black & white only
        const headerText = "Sessions and Cloud Agents";
        const headerPadding = Math.max(0, Math.floor((termWidth - headerText.length) / 2));
        const headerLine = "─".repeat(termWidth);
        // Clear and render header
        stdout.write(`\x1b[1;1H\x1b[2K${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(headerLine)}`);
        stdout.write(`\x1b[2;1H\x1b[2K${" ".repeat(headerPadding)}${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.bold(headerText)}`);
        stdout.write(`\x1b[3;1H\x1b[2K${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(headerLine)}`);
        // When loading (initial)
        if (loading) {
            const centerRow = Math.floor(termHeight / 2);
            const loadingMsg1 = "Loading sessions and background agents...";
            const loadingMsg2 = "Press Ctrl-D, q or ESC to cancel";
            stdout.write(`\x1b[${centerRow};1H\x1b[2K${" ".repeat(Math.max(0, Math.floor((termWidth - loadingMsg1.length) / 2)))}${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(loadingMsg1)}`);
            stdout.write(`\x1b[${centerRow + 2};1H\x1b[2K${" ".repeat(Math.max(0, Math.floor((termWidth - loadingMsg2.length) / 2)))}${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(loadingMsg2)}`);
            // Clear remaining lines below header and above footer
            for (let row = listStartRow; row <= termHeight - 2; row++) {
                if (row !== centerRow && row !== centerRow + 2)
                    stdout.write(`\x1b[${row};1H\x1b[2K`);
            }
        }
        // When empty and not loading
        else if (items.length === 0) {
            const centerRow = Math.floor(termHeight / 2);
            const emptyMsg1 = "No sessions or background agents found.";
            const emptyMsg2 = "Press Ctrl-D, q or ESC to go back";
            stdout.write(`\x1b[${centerRow};1H\x1b[2K${" ".repeat(Math.max(0, Math.floor((termWidth - emptyMsg1.length) / 2)))}${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(emptyMsg1)}`);
            stdout.write(`\x1b[${centerRow + 2};1H\x1b[2K${" ".repeat(Math.max(0, Math.floor((termWidth - emptyMsg2.length) / 2)))}${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(emptyMsg2)}`);
            // Clear remaining lines below header and above footer
            for (let row = listStartRow; row <= termHeight - 2; row++) {
                if (row !== centerRow && row !== centerRow + 2)
                    stdout.write(`\x1b[${row};1H\x1b[2K`);
            }
        }
        else {
            // Render list
            const start = scrollTop;
            const end = Math.min(items.length, start + contentHeight);
            const slice = items.slice(start, end);
            // If a confirmation modal is active, compute its vertical span to avoid overwriting
            let modalStartRow = null;
            let modalEndRow = null;
            if (confirmActive) {
                const _maxWidth = Math.max(30, Math.min(72, termWidth - 8));
                const innerHeight = 2 + (confirmDetail ? 1 : 0) + 2; // top+bottom + optional detail + 2 options
                const overlayHeight = innerHeight;
                modalStartRow =
                    listStartRow +
                        Math.max(0, Math.floor((contentHeight - overlayHeight) / 2));
                modalEndRow = modalStartRow + overlayHeight - 1;
            }
            for (let i = 0; i < contentHeight; i++) {
                const row = i + listStartRow; // rows 4..(termHeight-2)
                // Skip drawing rows covered by the modal to reduce flicker
                if (confirmActive &&
                    modalStartRow !== null &&
                    modalEndRow !== null &&
                    row >= modalStartRow &&
                    row <= modalEndRow) {
                    continue;
                }
                const it = slice[i];
                if (!it) {
                    stdout.write(`\x1b[${row};1H\x1b[2K`);
                    continue;
                }
                const globalIndex = start + i;
                const isSelected = globalIndex === active;
                // Time string similar to ChatPicker
                const dt = new Date(Math.max(0, it.updatedAtMs || 0));
                const now = new Date();
                const daysAgo = Math.floor((Date.UTC(now.getFullYear(), now.getMonth(), now.getDate()) -
                    Date.UTC(dt.getFullYear(), dt.getMonth(), dt.getDate())) /
                    (1000 * 60 * 60 * 24));
                const timeStr = dt.toLocaleTimeString([], {
                    hour: "2-digit",
                    minute: "2-digit",
                });
                let dateStr;
                if (daysAgo <= 0)
                    dateStr = `Today ${timeStr}`;
                else if (daysAgo === 1)
                    dateStr = `Yesterday ${timeStr}`;
                else if (daysAgo < 7)
                    dateStr = `${daysAgo} days ago`;
                else
                    dateStr = `${dt.toLocaleDateString([], { month: "short", day: "numeric", year: "numeric" })} ${timeStr}`;
                // Compose left content with fixed icon slot for consistent alignment
                const prefix = isSelected ? "  ▶ " : "    ";
                const iconPlain = it.kind === "background" ? "⬢ " : "  ";
                const iconVisible = visibleLength(iconPlain);
                const statusIcon = (s) => {
                    switch (s) {
                        case _anysphere_proto_aiserver_v1_background_composer_pb_js__WEBPACK_IMPORTED_MODULE_4__/* .BackgroundComposerStatus */ .R6.ERROR:
                            return chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.red("⬢ ");
                        case _anysphere_proto_aiserver_v1_background_composer_pb_js__WEBPACK_IMPORTED_MODULE_4__/* .BackgroundComposerStatus */ .R6.FINISHED:
                            return chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.green("⬢ ");
                        case _anysphere_proto_aiserver_v1_background_composer_pb_js__WEBPACK_IMPORTED_MODULE_4__/* .BackgroundComposerStatus */ .R6.RUNNING:
                        case _anysphere_proto_aiserver_v1_background_composer_pb_js__WEBPACK_IMPORTED_MODULE_4__/* .BackgroundComposerStatus */ .R6.CREATING:
                            // In-progress states are yellow
                            return chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.yellow("⬢ ");
                        default:
                            return chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray("⬢ ");
                    }
                };
                const icon = it.kind === "background" ? statusIcon(it.status) : iconPlain;
                const dateStyled = isSelected
                    ? chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white(dateStr)
                    : chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(dateStr);
                // Source (for background only)
                const formatSource = (_repoUrl, branchName) => {
                    const b = (branchName || "").trim();
                    return b; // show branch only; empty string if none
                };
                const sourceText = it.kind === "background" ? formatSource(it.repoUrl, it.branch) : "";
                // Determine available width for the main text area (name + optional source)
                const rightPad = prefix.length;
                const leftVisible = prefix.length + iconVisible; // prefix arrow + icon slot
                const reserved = leftVisible + 1 + dateStr.length + rightPad; // +1 for space before date
                const maxMainWidth = Math.max(1, termWidth - reserved);
                const namePlain = firstLine(it.name).trim();
                if (it.kind === "background") {
                    // Split budget between name and source for stability
                    const sepPlain = sourceText ? " " : "";
                    const sepVisible = visibleLength(sepPlain);
                    const sepDecorated = sourceText
                        ? isSelected
                            ? chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white(sepPlain)
                            : chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(sepPlain)
                        : "";
                    // Prepare optional diff stats suffix like "  +12 -3"
                    const bg = it;
                    const hasStats = typeof bg.totalAdded === "number" &&
                        typeof bg.totalRemoved === "number" &&
                        (((_a = bg.totalAdded) !== null && _a !== void 0 ? _a : 0) > 0 || ((_b = bg.totalRemoved) !== null && _b !== void 0 ? _b : 0) > 0);
                    const diffSuffixPlain = hasStats
                        ? `  +${Math.max(0, (_c = bg.totalAdded) !== null && _c !== void 0 ? _c : 0)} -${Math.max(0, (_d = bg.totalRemoved) !== null && _d !== void 0 ? _d : 0)}`
                        : "";
                    const diffSuffixVisible = visibleLength(diffSuffixPlain);
                    const minName = Math.min(24, Math.max(10, Math.floor(maxMainWidth * 0.35)));
                    const minSource = Math.min(22, Math.max(8, Math.floor(maxMainWidth * 0.25)));
                    const availableForMain = Math.max(1, maxMainWidth - diffSuffixVisible);
                    let nameBudget = Math.floor(availableForMain * 0.6);
                    let sourceBudget = availableForMain - nameBudget - sepVisible;
                    if (sourceBudget < minSource) {
                        const deficit = minSource - sourceBudget;
                        nameBudget = Math.max(minName, nameBudget - deficit);
                        sourceBudget = availableForMain - nameBudget - sepVisible;
                    }
                    if (nameBudget < minName) {
                        const deficit = minName - nameBudget;
                        sourceBudget = Math.max(minSource, sourceBudget - deficit);
                        nameBudget = availableForMain - sourceBudget - sepVisible;
                    }
                    nameBudget = Math.max(1, nameBudget);
                    sourceBudget = Math.max(0, sourceBudget);
                    const nameTrunc = truncateEndPlain(namePlain, nameBudget);
                    const sourceTrunc = truncateEndPlain(sourceText, sourceBudget);
                    const nameDecorated = isSelected
                        ? chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.bold(chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white(nameTrunc))
                        : chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white(nameTrunc);
                    const sourceDecorated = isSelected
                        ? chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white(sourceTrunc)
                        : chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(sourceTrunc);
                    const mainDecorated = sourceTrunc
                        ? `${nameDecorated}${sepDecorated}${sourceDecorated}`
                        : `${nameDecorated}`;
                    const addedText = `+${Math.max(0, (_e = bg.totalAdded) !== null && _e !== void 0 ? _e : 0)}`;
                    const removedText = `-${Math.max(0, (_f = bg.totalRemoved) !== null && _f !== void 0 ? _f : 0)}`;
                    const coloredDiff = `  ${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.green(addedText)} ${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.red(removedText)}`;
                    const diffDecorated = hasStats
                        ? isSelected
                            ? coloredDiff
                            : chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.dim(coloredDiff)
                        : "";
                    const spaces = Math.max(0, termWidth -
                        rightPad -
                        leftVisible -
                        visibleLength(mainDecorated + diffSuffixPlain) -
                        1 -
                        dateStr.length);
                    const line = `${prefix}${icon}${mainDecorated}${diffDecorated}${" ".repeat(spaces)} ${dateStyled}${" ".repeat(rightPad)}`;
                    stdout.write(`\x1b[${row};1H\x1b[2K${line}`);
                }
                else {
                    // Chat items: no " - local" suffix
                    const nameBudget = maxMainWidth;
                    const nameTrunc = truncateEndPlain(namePlain, nameBudget);
                    const mainDecorated = isSelected
                        ? chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.bold(chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white(nameTrunc))
                        : chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white(nameTrunc);
                    const spaces = Math.max(0, termWidth -
                        rightPad -
                        leftVisible -
                        visibleLength(mainDecorated) -
                        1 -
                        dateStr.length);
                    const line = `${prefix}${icon}${mainDecorated}${" ".repeat(spaces)} ${dateStyled}${" ".repeat(rightPad)}`;
                    stdout.write(`\x1b[${row};1H\x1b[2K${line}`);
                }
            }
        }
        // Footer (last 2 rows)
        const footerRow1 = termHeight - 1;
        const footerRow2 = termHeight;
        const footerLine = "─".repeat(termWidth);
        stdout.write(`\x1b[${footerRow1};1H\x1b[2K${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(footerLine)}`);
        if (items.length > 0) {
            const navText = `${Math.min(active + 1, items.length)}/${items.length}`;
            const helpText = "↑↓/jk: navigate • Enter: select • Backspace: delete • Ctrl-D/q/ESC: back";
            const combined = `${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.bold(navText)} ${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray("•")} ${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(helpText)}`;
            const padding = Math.max(0, Math.floor((termWidth - (navText.length + 3 + helpText.length)) / 2));
            stdout.write(`\x1b[${footerRow2};1H\x1b[2K${" ".repeat(padding)}${combined}`);
        }
        else {
            const helpText = "Ctrl-D/q/ESC: back";
            const padding = Math.max(0, Math.floor((termWidth - helpText.length) / 2));
            stdout.write(`\x1b[${footerRow2};1H\x1b[2K${" ".repeat(padding)}${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(helpText)}`);
        }
        // Confirmation modal overlay (centered, yellow border, max width)
        if (confirmActive) {
            const title = confirmTitle;
            const detail = confirmDetail;
            const options = [
                { label: continueLabel, hint: "y" },
                { label: cancelLabel, hint: "esc/n" },
            ];
            const maxWidth = Math.max(30, Math.min(72, termWidth - 8));
            // Compute content lines (truncate to fit inner width)
            const innerWidth = Math.max(10, maxWidth - 2);
            const trunc = (t) => {
                const s = (t !== null && t !== void 0 ? t : "").trim();
                if (visibleLength(s) <= innerWidth - 2)
                    return s; // account for left padding
                return `${(0,_utils_characters_js__WEBPACK_IMPORTED_MODULE_11__/* .stripAnsi */ .aJ)(s).slice(0, Math.max(0, innerWidth - 5))}...`;
            };
            const titleLine = trunc(title);
            const detailLine = detail ? trunc(detail) : undefined;
            const optionLines = options.map((opt, idx) => {
                const isActiveRow = idx === confirmIndex;
                const arrow = isActiveRow ? "→ " : "  ";
                const hintText = opt.hint ? ` ${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(opt.hint)}` : "";
                const labelRaw = opt.label;
                const base = `${arrow}${labelRaw}${(0,_utils_characters_js__WEBPACK_IMPORTED_MODULE_11__/* .stripAnsi */ .aJ)(hintText) ? ` ${opt.hint}` : ""}`;
                const rawTrunc = (0,_utils_characters_js__WEBPACK_IMPORTED_MODULE_11__/* .stripAnsi */ .aJ)(base).length > innerWidth - 2
                    ? `${(0,_utils_characters_js__WEBPACK_IMPORTED_MODULE_11__/* .stripAnsi */ .aJ)(base).slice(0, Math.max(0, innerWidth - 5))}...`
                    : base;
                const styled = isActiveRow
                    ? `${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white("→ ")}${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.black.bgYellow(labelRaw)}` +
                        (opt.hint ? ` ${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(opt.hint)}` : "")
                    : `${"  "}${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white(labelRaw)}` +
                        (opt.hint ? ` ${chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(opt.hint)}` : "");
                // If styling may change width, fall back to plain when overflowing
                const final = visibleLength(styled) > innerWidth - 2 ? (0,_utils_characters_js__WEBPACK_IMPORTED_MODULE_11__/* .stripAnsi */ .aJ)(rawTrunc) : styled;
                return final;
            });
            const contentLines = [
                chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.white(titleLine),
                ...(detailLine ? [chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.gray(detailLine)] : []),
                ...optionLines,
            ];
            const borderColor = chalk__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Ay.yellow;
            const overlayHeight = 2 + contentLines.length; // top+bottom borders
            const startRow = listStartRow +
                Math.max(0, Math.floor((contentHeight - overlayHeight) / 2));
            const colStart = Math.max(1, Math.floor((termWidth - maxWidth) / 2) + 1);
            // Draw top border
            const top = `${borderColor("┌")}${borderColor("─".repeat(maxWidth - 2))}${borderColor("┐")}`;
            stdout.write(`\x1b[${startRow};${colStart}H${top}`);
            // Draw content rows with side borders and padding
            for (let i = 0; i < contentLines.length; i++) {
                const row = startRow + 1 + i;
                const line = contentLines[i];
                // Left border
                stdout.write(`\x1b[${row};${colStart}H${borderColor("│")}`);
                // Space + content (no right padding to preserve underlying text)
                stdout.write(` ${line}`);
                // Right border at fixed column
                const rightCol = colStart + maxWidth - 1;
                stdout.write(`\x1b[${row};${rightCol}H${borderColor("│")}`);
            }
            // Bottom border
            const bottom = `${borderColor("└")}${borderColor("─".repeat(maxWidth - 2))}${borderColor("┘")}`;
            stdout.write(`\x1b[${startRow + overlayHeight - 1};${colStart}H${bottom}`);
        }
    }, [
        stdout,
        items,
        active,
        scrollTop,
        contentHeight,
        termWidth,
        termHeight,
        loading,
        confirmActive,
        confirmIndex,
        confirmTitle,
        confirmDetail,
        continueLabel,
        cancelLabel,
    ]);
    return null;
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/update-todos-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   v: () => (/* binding */ UpdateTodosToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _todos_ui_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/components/todos-ui.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _todos_ui_js__WEBPACK_IMPORTED_MODULE_2__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _todos_ui_js__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const UpdateTodosToolUI = ({ tool, aborted, }) => {
    if (aborted) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingLeft: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { bold: true, children: "Update to-dos" }), " ", (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: "Aborted" })] }) }) }));
    }
    if (!tool.result) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_todos_ui_js__WEBPACK_IMPORTED_MODULE_2__/* .TodosUI */ .S, { todos: [], mode: "update", loading: true }) }));
    }
    const result = tool.result.result;
    switch (result === null || result === void 0 ? void 0 : result.case) {
        case "success":
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_todos_ui_js__WEBPACK_IMPORTED_MODULE_2__/* .TodosUI */ .S, { todos: result.value.todos, totalCount: result.value.totalCount, mode: "update", showHeader: true }) }));
        case "error":
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", children: result.value.error }) }));
        default:
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_todos_ui_js__WEBPACK_IMPORTED_MODULE_2__/* .TodosUI */ .S, { todos: [], mode: "update" }) }));
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/user-message-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   H: () => (/* binding */ UserMessageUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/hooks/use-screen-size.ts");
/* harmony import */ var _utils_text_wrapping_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/utils/text-wrapping.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_3__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const UserMessageUI = ({ content, overrideBorderColor, }) => {
    const size = (0,_hooks_use_screen_size_js__WEBPACK_IMPORTED_MODULE_3__/* .useScreenSize */ .l)();
    const innerWidth = Math.max(1, size.width - 10);
    const clampedContent = (0,_utils_text_wrapping_js__WEBPACK_IMPORTED_MODULE_4__/* .clampTextToLines */ .F)(content, _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .USER_MESSAGE_MAX_LINES */ .p9, innerWidth);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { borderStyle: "single", borderColor: overrideBorderColor !== null && overrideBorderColor !== void 0 ? overrideBorderColor : "foreground", borderDimColor: true, paddingLeft: 1, paddingRight: 5, marginX: 1, width: size.width - 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "foreground", wrap: "wrap", children: clampedContent }) }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/web-search-tool-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: () => (/* binding */ WebSearchToolUI)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _tool_call_header_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/tool-call-header.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_3__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _tool_call_header_js__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




const WebSearchToolUI = ({ tool: { args, result }, }) => {
    var _a, _b, _c, _d;
    if (!args) {
        return null;
    }
    const searchTerm = (_a = args.searchTerm) !== null && _a !== void 0 ? _a : "";
    let status = "pending";
    let note;
    let errorMessage;
    let referenceCount;
    // Determine status and extract relevant information based on result
    const caseType = (_b = result === null || result === void 0 ? void 0 : result.result) === null || _b === void 0 ? void 0 : _b.case;
    switch (caseType) {
        case undefined:
            status = "pending";
            break;
        case "error":
            status = "error";
            errorMessage = (result === null || result === void 0 ? void 0 : result.result.value.error) || "Unknown error";
            break;
        case "success":
            status = "success";
            referenceCount = (_d = (_c = result === null || result === void 0 ? void 0 : result.result.value.references) === null || _c === void 0 ? void 0 : _c.length) !== null && _d !== void 0 ? _d : 0;
            break;
        case "rejected":
            status = "rejected";
            note = (result === null || result === void 0 ? void 0 : result.result.value.reason) || "Web search rejected";
            break;
        default: {
            const _exhaustive = caseType;
            status = "pending";
            break;
        }
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", paddingRight: 2, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_header_js__WEBPACK_IMPORTED_MODULE_3__/* .ToolCallHeader */ .C, { name: "WebSearch", primary: searchTerm, status: status, note: note }), errorMessage && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, marginTop: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: ["Error: ", errorMessage] }) })), status === "success" && referenceCount !== undefined && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { marginLeft: _constants_js__WEBPACK_IMPORTED_MODULE_2__/* .TOOL_DETAIL_MARGIN_LEFT */ .SK, marginTop: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { dimColor: true, children: ["Found ", referenceCount, " reference", referenceCount !== 1 ? "s" : ""] }) }))] }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/context/agent-state-context.tsx":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C9: () => (/* binding */ useAgentState),
/* harmony export */   oG: () => (/* binding */ AgentStateProvider),
/* harmony export */   tO: () => (/* binding */ useIsCompact)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const AgentStateContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(null);
const AgentStateProvider = ({ children, fileChangeTracker, pendingDecisionStore, configProvider, initialViewMode = "chat", initialInputValue = "", initialIsCompact = true, initialAgentStore, modelManager, }) => {
    const [changedFiles, setChangedFiles] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(() => fileChangeTracker.getChanges());
    const [viewMode, setViewMode] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(initialViewMode);
    const [currentModel, setCurrentModelState] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(modelManager.getCurrentModel());
    const [inputValue, setInputValue] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(initialInputValue);
    const [pendingDecisions, setPendingDecisions] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(pendingDecisionStore.getPendingDecisions());
    const [queuedMessage, setQueuedMessage] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)("");
    const [reviewSelectedIndex, setReviewSelectedIndex] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(0);
    const [agentStore, setAgentStore] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(initialAgentStore);
    const [isGenerating, setIsGenerating] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [isSummarizing, setIsSummarizing] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [isCompact, setIsCompact] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(initialIsCompact);
    const [agentMetadataMode, setAgentMetadataMode] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(() => agentStore.getMetadata("mode"));
    const [conversationTokensUsed, setConversationTokensUsed] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const [conversationMaxTokens, setConversationMaxTokens] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const [conversationTokenPercent, setConversationTokenPercent] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const setCurrentModel = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((model) => __awaiter(void 0, void 0, void 0, function* () {
        if (configProvider) {
            yield modelManager.setCurrentModel(model, configProvider);
        }
        else {
            modelManager.setCurrentModelWithoutPersistence(model);
        }
    }), [configProvider, modelManager]);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        const unsubscribe = fileChangeTracker.subscribe(() => {
            setChangedFiles(fileChangeTracker.getChanges());
        });
        setChangedFiles(fileChangeTracker.getChanges());
        return unsubscribe;
    }, [fileChangeTracker]);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        const unsubscribe = pendingDecisionStore.subscribe(decisions => {
            setPendingDecisions(decisions);
        });
        setPendingDecisions(pendingDecisionStore.getPendingDecisions());
        return unsubscribe;
    }, [pendingDecisionStore]);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        const unsubscribe = agentStore.subscribeToMetadata("mode", mode => {
            setAgentMetadataMode(mode);
        });
        setAgentMetadataMode(agentStore.getMetadata("mode"));
        return unsubscribe;
    }, [agentStore]);
    // Subscribe to conversation checkpoints and compute token percent solely
    // from the conversation state's tokenDetails.
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        const computeFromConversation = () => {
            const struct = agentStore.getConversationStateStructure();
            const td = struct === null || struct === void 0 ? void 0 : struct.tokenDetails;
            const used = typeof (td === null || td === void 0 ? void 0 : td.usedTokens) === "number" && Number.isFinite(td.usedTokens)
                ? td.usedTokens
                : null;
            const max = typeof (td === null || td === void 0 ? void 0 : td.maxTokens) === "number" && Number.isFinite(td.maxTokens)
                ? td.maxTokens
                : null;
            setConversationTokensUsed(used);
            setConversationMaxTokens(max);
            if (used != null && max != null && max > 0) {
                const percentUsed = Math.max(0, Math.min(100, Math.round((used / max) * 100 * 10) / 10));
                setConversationTokenPercent(percentUsed);
            }
            else {
                setConversationTokenPercent(null);
            }
        };
        const unsubs = [];
        unsubs.push(agentStore.subscribeToMetadata("latestRootBlobId", () => {
            computeFromConversation();
        }));
        // Initial compute
        computeFromConversation();
        return () => {
            for (const u of unsubs) {
                try {
                    u();
                }
                catch (_a) { }
            }
        };
    }, [agentStore]);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        const unsubscribe = modelManager.subscribe((newModel) => {
            setCurrentModelState(newModel);
        });
        return unsubscribe;
    }, [modelManager]);
    const approvePendingDecision = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((id) => {
        pendingDecisionStore.approveDecision(id);
    }, [pendingDecisionStore]);
    const rejectPendingDecision = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((id, reason) => {
        pendingDecisionStore.rejectDecision(id, reason);
    }, [pendingDecisionStore]);
    const requestApproval = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((operation) => {
        return pendingDecisionStore.requestApproval(operation);
    }, [pendingDecisionStore]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(AgentStateContext.Provider, { value: {
            changedFiles,
            viewMode,
            setViewMode,
            mode: agentMetadataMode,
            currentModel,
            setCurrentModel,
            inputValue,
            setInputValue,
            pendingDecisions,
            approvePendingDecision,
            rejectPendingDecision,
            requestApproval,
            queuedMessage,
            setQueuedMessage,
            reviewSelectedIndex,
            setReviewSelectedIndex,
            agentStore,
            setAgentStore,
            modelManager,
            isGenerating,
            setIsGenerating,
            isSummarizing,
            setIsSummarizing,
            isCompact,
            setIsCompact,
            conversationTokensUsed,
            conversationMaxTokens,
            conversationTokenPercent,
        }, children: children }));
};
const useAgentState = () => {
    const ctx = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(AgentStateContext);
    if (!ctx) {
        throw new Error("useAgentState must be used within an AgentStateProvider");
    }
    return ctx;
};
const useIsCompact = () => {
    return useAgentState().isCompact;
};


/***/ }),

/***/ "./src/context/config-context.tsx":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $i: () => (/* binding */ useShowLineNumbers),
/* harmony export */   t1: () => (/* binding */ ConfigContextProvider)
/* harmony export */ });
/* unused harmony export useConfig */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");


const ConfigContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(undefined);
const ConfigContextProvider = ({ children, configProvider, }) => {
    const config = configProvider.get();
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ConfigContext.Provider, { value: { config, configProvider }, children: children }));
};
const useConfig = () => {
    const context = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(ConfigContext);
    if (context === undefined) {
        throw new Error("useConfig must be used within a ConfigContextProvider");
    }
    return context;
};
const useShowLineNumbers = () => {
    var _a, _b;
    const { config } = useConfig();
    return (_b = (_a = config.display) === null || _a === void 0 ? void 0 : _a.showLineNumbers) !== null && _b !== void 0 ? _b : true;
};


/***/ }),

/***/ "./src/context/slash-command-context.tsx":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: () => (/* binding */ SlashCommandProvider),
/* harmony export */   x: () => (/* binding */ useSlashCommandRegistry)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");


const SlashCommandContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(null);
const SlashCommandProvider = ({ children, }) => {
    const [dynamicCommands, setDynamicCommands] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
    const registerCommand = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((command) => {
        setDynamicCommands(prev => {
            const filtered = prev.filter(cmd => cmd.id !== command.id);
            return [...filtered, command];
        });
    }, []);
    const unregisterCommand = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((commandId) => {
        setDynamicCommands(prev => prev.filter(cmd => cmd.id !== commandId));
    }, []);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SlashCommandContext.Provider, { value: { dynamicCommands, registerCommand, unregisterCommand }, children: children }));
};
const useSlashCommandRegistry = () => {
    const context = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(SlashCommandContext);
    if (!context) {
        throw new Error("useSlashCommandRegistry must be used within SlashCommandProvider");
    }
    return context;
};


/***/ }),

/***/ "./src/context/terminal-state-context.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PH: () => (/* binding */ useWidthEpoch),
/* harmony export */   rs: () => (/* binding */ TerminalStateProvider)
/* harmony export */ });
/* unused harmony exports useTerminalState, useTerminalEpoch, useHeightEpoch */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const TerminalStateContext = (0,react__WEBPACK_IMPORTED_MODULE_2__.createContext)(null);
const TerminalStateProvider = ({ children, }) => {
    const [terminalEpoch, setTerminalEpoch] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
    const [widthEpoch, setWidthEpoch] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
    const [heightEpoch, setHeightEpoch] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
    const [lastReason, setLastReason] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
    const stdout = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .useStdout */ .t$)();
    const stream = stdout.stdout; // use stable stream, not the changing context object
    const lastWidthRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const lastHeightRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const bumpTerminalEpoch = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((reason) => {
        setTerminalEpoch((prev) => {
            const next = prev + 1;
            return next;
        });
        if (reason)
            setLastReason(reason);
    }, []);
    const bumpWidthEpoch = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((_reason) => {
        setWidthEpoch((prev) => prev + 1);
    }, []);
    const bumpHeightEpoch = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((_reason) => {
        setHeightEpoch((prev) => prev + 1);
    }, []);
    // Auto-bump on actual terminal resize
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        const s = stream; // stable dependency
        if (!s)
            return;
        const handleResize = () => {
            const currentWidth = s.columns;
            const currentHeight = s.rows;
            if (lastWidthRef.current === null) {
                lastWidthRef.current = currentWidth;
            }
            if (lastHeightRef.current === null) {
                lastHeightRef.current = currentHeight;
            }
            const didWidthChange = currentWidth !== lastWidthRef.current;
            const didHeightChange = currentHeight !== lastHeightRef.current;
            if (didWidthChange) {
                lastWidthRef.current = currentWidth;
                bumpWidthEpoch();
            }
            if (didHeightChange) {
                lastHeightRef.current = currentHeight;
                bumpHeightEpoch();
            }
            if (didWidthChange || didHeightChange) {
                bumpTerminalEpoch();
            }
        };
        s.on("resize", handleResize);
        // Fire once to establish baseline (does not bump unless changed)
        handleResize();
        return () => {
            s.off("resize", handleResize);
        };
    }, [stream, bumpWidthEpoch, bumpHeightEpoch, bumpTerminalEpoch]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TerminalStateContext.Provider, { value: {
            terminalEpoch,
            widthEpoch,
            heightEpoch,
            lastReason,
            bumpTerminalEpoch,
            bumpWidthEpoch,
            bumpHeightEpoch,
        }, children: children }));
};
const useTerminalState = () => {
    const ctx = (0,react__WEBPACK_IMPORTED_MODULE_2__.useContext)(TerminalStateContext);
    if (!ctx) {
        throw new Error("useTerminalState must be used within a TerminalStateProvider");
    }
    return ctx;
};
const useTerminalEpoch = () => {
    return useTerminalState().terminalEpoch;
};
const useWidthEpoch = () => {
    return useTerminalState().widthEpoch;
};
const useHeightEpoch = () => {
    return useTerminalState().heightEpoch;
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/context/theme-context.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NP: () => (/* binding */ ThemeProvider),
/* harmony export */   cb: () => (/* binding */ useSyncTheme),
/* harmony export */   pW: () => (/* binding */ useIsLightTheme)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _hooks_use_theme_detection_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/hooks/use-theme-detection.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_hooks_use_theme_detection_js__WEBPACK_IMPORTED_MODULE_2__]);
_hooks_use_theme_detection_js__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const ThemeContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({
    isLightTheme: false,
    syncTheme: () => __awaiter(void 0, void 0, void 0, function* () { }),
});
const ThemeProvider = ({ children, detection }) => {
    const { isLightTheme, sync } = (0,_hooks_use_theme_detection_js__WEBPACK_IMPORTED_MODULE_2__/* .useThemeDetection */ .A)(Object.assign({}, detection));
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ThemeContext.Provider, { value: { isLightTheme: isLightTheme !== null && isLightTheme !== void 0 ? isLightTheme : false, syncTheme: sync }, children: children }));
};
const useIsLightTheme = () => {
    const { isLightTheme } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(ThemeContext);
    return isLightTheme;
};
const useSyncTheme = () => {
    const { syncTheme } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(ThemeContext);
    return syncTheme;
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/context/vim-mode-context.tsx":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: () => (/* binding */ VimModeProvider),
/* harmony export */   v: () => (/* binding */ useVimMode)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");


const VimModeContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(undefined);
const VimModeProvider = ({ children, configProvider, }) => {
    const [mode, setMode] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)("insert");
    const [vimEnabled, setVimEnabled] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(configProvider.get().editor.vimMode);
    const toggleMode = () => {
        setMode(current => (current === "normal" ? "insert" : "normal"));
    };
    const toggleVimEnabled = () => {
        setVimEnabled(prev => {
            const next = !prev;
            try {
                configProvider
                    .transform(config => (Object.assign(Object.assign({}, config), { editor: Object.assign(Object.assign({}, config.editor), { vimMode: next }) })))
                    .catch(() => {
                    // ignore
                });
            }
            catch (_a) {
                /* ignore */
            }
            if (!next) {
                // Reset to insert mode when disabling vim to avoid stuck normal mode
                setMode("insert");
            }
            return next;
        });
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(VimModeContext.Provider, { value: { mode, setMode, toggleMode, vimEnabled, toggleVimEnabled }, children: children }));
};
const useVimMode = () => {
    const context = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(VimModeContext);
    if (context === undefined) {
        throw new Error("useVimMode must be used within a VimModeProvider");
    }
    return context;
};


/***/ }),

/***/ "./src/conversation/dynamic-item.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: () => (/* binding */ DynamicItemComponent)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _components_create_plan_tool_ui_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/create-plan-tool-ui.tsx");
/* harmony import */ var _components_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/index.ts");
/* harmony import */ var _components_markdown_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/markdown.tsx");
/* harmony import */ var _components_merged_read_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/components/merged-read-search-tool-ui.tsx");
/* harmony import */ var _components_shell_turn_ui_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/components/shell-turn-ui.tsx");
/* harmony import */ var _tool_call_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/conversation/tool-call.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _components_create_plan_tool_ui_js__WEBPACK_IMPORTED_MODULE_3__, _components_index_js__WEBPACK_IMPORTED_MODULE_4__, _components_markdown_js__WEBPACK_IMPORTED_MODULE_5__, _components_merged_read_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_6__, _components_shell_turn_ui_js__WEBPACK_IMPORTED_MODULE_7__, _tool_call_js__WEBPACK_IMPORTED_MODULE_8__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _components_create_plan_tool_ui_js__WEBPACK_IMPORTED_MODULE_3__, _components_index_js__WEBPACK_IMPORTED_MODULE_4__, _components_markdown_js__WEBPACK_IMPORTED_MODULE_5__, _components_merged_read_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_6__, _components_shell_turn_ui_js__WEBPACK_IMPORTED_MODULE_7__, _tool_call_js__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const THROTTLE_DELAY = 200;
/**
 * ThrottledMarkdown component that limits updates to a maximum of 1 update every 500ms
 * while ensuring the final content is always displayed correctly
 */
const ThrottledMarkdown = ({ content }) => {
    const [displayedContent, setDisplayedContent] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(content);
    const timeoutRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const lastUpdateRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(0);
    const isFirstRender = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(true);
    const displayParagraphs = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        return displayedContent.split("\n\n").length;
    }, [displayedContent]);
    const liveParagraphs = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        return content.split("\n\n").length;
    }, [content]);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        // Clear any existing timeout
        if (timeoutRef.current) {
            clearTimeout(timeoutRef.current);
        }
        // On first render, always update immediately
        if (isFirstRender.current || displayParagraphs < liveParagraphs) {
            setDisplayedContent(content);
            lastUpdateRef.current = performance.now();
            isFirstRender.current = false;
            return;
        }
        const now = performance.now();
        const timeSinceLastUpdate = now - lastUpdateRef.current;
        // If enough time has passed since the last update, update immediately
        if (timeSinceLastUpdate >= THROTTLE_DELAY) {
            setDisplayedContent(content);
            lastUpdateRef.current = now;
            return;
        }
        // Schedule an update for the remaining time
        const remainingTime = THROTTLE_DELAY - timeSinceLastUpdate;
        timeoutRef.current = setTimeout(() => {
            setDisplayedContent(content);
            lastUpdateRef.current = performance.now();
        }, remainingTime);
        // Cleanup function
        return () => {
            if (timeoutRef.current) {
                clearTimeout(timeoutRef.current);
            }
        };
    }, [content, displayParagraphs, liveParagraphs]);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_markdown_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Ay, { content: displayedContent });
};
const debug = false;
const DynamicItemComponent = ({ item, options, }) => {
    if (debug) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: JSON.stringify(item, null, 2) }) }));
    }
    if (item.type === "agent-text") {
        const text = item.completed
            ? item.text
            : item.text.slice(0, item.text.lastIndexOf("\n"));
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ThrottledMarkdown, { content: text }) }));
    }
    if (item.type === "user-message") {
        if (options.hideUserMessages) {
            return null;
        }
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_index_js__WEBPACK_IMPORTED_MODULE_4__/* .UserMessageUI */ .Hw, { content: item.message });
    }
    if (item.type === "agent-tool-calls") {
        if (item.calls.length > 1) {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_merged_read_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_6__/* .MergedReadSearchToolUI */ .r, { tools: item.calls }) }));
        }
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: item.calls.map((call, _index) => {
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_js__WEBPACK_IMPORTED_MODULE_8__/* .ToolCallComponent */ .S, { call: call, options: options, isLastStepOfTurn: item.isLastStepOfTurn, isLastTurn: item.isLastTurn }) }, call.id));
            }) }));
    }
    if (item.type === "plan") {
        if (item.call.tool.case !== "createPlanToolCall") {
            return null;
        }
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_create_plan_tool_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .CreatePlanToolUI */ .U, { tool: item.call.tool.value, isSuggestingPlan: true, planDecisionIndex: item.decisionIndex, state: "pending" }) }));
    }
    if (item.type === "shell-turn") {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_shell_turn_ui_js__WEBPACK_IMPORTED_MODULE_7__/* .ShellTurnUI */ .o, { command: item.command, output: item.stdout, exitCode: item.exitCode }) }));
    }
    return null;
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/conversation/static-item.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   j: () => (/* binding */ StaticItemComponent)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _components_app_header_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/components/app-header.tsx");
/* harmony import */ var _components_create_plan_tool_ui_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/create-plan-tool-ui.tsx");
/* harmony import */ var _components_markdown_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/markdown.tsx");
/* harmony import */ var _components_merged_read_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/merged-read-search-tool-ui.tsx");
/* harmony import */ var _components_shell_turn_ui_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/components/shell-turn-ui.tsx");
/* harmony import */ var _components_summary_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/components/summary.tsx");
/* harmony import */ var _components_user_message_ui_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/components/user-message-ui.tsx");
/* harmony import */ var _tool_call_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("./src/conversation/tool-call.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _components_app_header_js__WEBPACK_IMPORTED_MODULE_2__, _components_create_plan_tool_ui_js__WEBPACK_IMPORTED_MODULE_3__, _components_markdown_js__WEBPACK_IMPORTED_MODULE_4__, _components_merged_read_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_5__, _components_shell_turn_ui_js__WEBPACK_IMPORTED_MODULE_6__, _components_summary_js__WEBPACK_IMPORTED_MODULE_7__, _components_user_message_ui_js__WEBPACK_IMPORTED_MODULE_8__, _tool_call_js__WEBPACK_IMPORTED_MODULE_9__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _components_app_header_js__WEBPACK_IMPORTED_MODULE_2__, _components_create_plan_tool_ui_js__WEBPACK_IMPORTED_MODULE_3__, _components_markdown_js__WEBPACK_IMPORTED_MODULE_4__, _components_merged_read_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_5__, _components_shell_turn_ui_js__WEBPACK_IMPORTED_MODULE_6__, _components_summary_js__WEBPACK_IMPORTED_MODULE_7__, _components_user_message_ui_js__WEBPACK_IMPORTED_MODULE_8__, _tool_call_js__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










const debug = false;
const StaticItemComponent = ({ item, options, }) => {
    if (debug) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: JSON.stringify(item, null, 2) }) }));
    }
    if (item.type === "summary") {
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_summary_js__WEBPACK_IMPORTED_MODULE_7__/* .Summary */ .B, { summary: item.summary });
    }
    if (item.type === "agent-text") {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_markdown_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Ay, { content: item.text }) }));
    }
    if (item.type === "debug-info") {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: ["Debug info: ", item.serverUrl] }) }));
    }
    if (item.type === "header") {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_app_header_js__WEBPACK_IMPORTED_MODULE_2__/* .AppHeader */ .j, { isRepository: item.isRepository, folderMode: item.folderMode }));
    }
    if (item.type === "user-message") {
        if (options.hideUserMessages) {
            return null;
        }
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_user_message_ui_js__WEBPACK_IMPORTED_MODULE_8__/* .UserMessageUI */ .H, { content: item.message });
    }
    if (item.type === "agent-tool-calls") {
        if (item.calls.length > 1) {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_merged_read_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_5__/* .MergedReadSearchToolUI */ .r, { tools: item.calls }) }));
        }
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: item.calls.map((call, _index) => {
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_tool_call_js__WEBPACK_IMPORTED_MODULE_9__/* .ToolCallComponent */ .S, { call: call, options: options, isLastStepOfTurn: false, isLastTurn: item.isLastTurn }) }, call.id));
            }) }));
    }
    if (item.type === "plan") {
        if (item.call.tool.case !== "createPlanToolCall") {
            return null;
        }
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_create_plan_tool_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .CreatePlanToolUI */ .U, { tool: item.call.tool.value, isSuggestingPlan: false, planDecisionIndex: item.decisionIndex, state: item.decisionIndex === 0 ? "accepted" : "rejected" }) }));
    }
    if (item.type === "shell-turn") {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { paddingX: 2, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_shell_turn_ui_js__WEBPACK_IMPORTED_MODULE_6__/* .ShellTurnUI */ .o, { command: item.command, output: item.stdout, exitCode: item.exitCode }) }));
    }
    return null;
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/conversation/tool-call.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   S: () => (/* binding */ ToolCallComponent)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _components_create_plan_tool_ui_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/components/create-plan-tool-ui.tsx");
/* harmony import */ var _components_delete_tool_ui_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/delete-tool-ui.tsx");
/* harmony import */ var _components_edit_tool_ui_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/edit-tool-ui.tsx");
/* harmony import */ var _components_glob_tool_ui_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/components/glob-tool-ui.tsx");
/* harmony import */ var _components_grep_tool_ui_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/components/grep-tool-ui.tsx");
/* harmony import */ var _components_ls_tool_ui_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("./src/components/ls-tool-ui.tsx");
/* harmony import */ var _components_mcp_tool_ui_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("./src/components/mcp-tool-ui.tsx");
/* harmony import */ var _components_read_lints_tool_ui_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("./src/components/read-lints-tool-ui.tsx");
/* harmony import */ var _components_read_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("./src/components/read-todos-tool-ui.tsx");
/* harmony import */ var _components_read_tool_ui_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("./src/components/read-tool-ui.tsx");
/* harmony import */ var _components_sem_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("./src/components/sem-search-tool-ui.tsx");
/* harmony import */ var _components_shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("./src/components/shell-tool-ui.tsx");
/* harmony import */ var _components_update_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("./src/components/update-todos-tool-ui.tsx");
/* harmony import */ var _components_web_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("./src/components/web-search-tool-ui.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _components_create_plan_tool_ui_js__WEBPACK_IMPORTED_MODULE_2__, _components_delete_tool_ui_js__WEBPACK_IMPORTED_MODULE_3__, _components_edit_tool_ui_js__WEBPACK_IMPORTED_MODULE_4__, _components_glob_tool_ui_js__WEBPACK_IMPORTED_MODULE_5__, _components_grep_tool_ui_js__WEBPACK_IMPORTED_MODULE_6__, _components_ls_tool_ui_js__WEBPACK_IMPORTED_MODULE_7__, _components_mcp_tool_ui_js__WEBPACK_IMPORTED_MODULE_8__, _components_read_lints_tool_ui_js__WEBPACK_IMPORTED_MODULE_9__, _components_read_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_10__, _components_read_tool_ui_js__WEBPACK_IMPORTED_MODULE_11__, _components_sem_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_12__, _components_shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_13__, _components_update_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_14__, _components_web_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_15__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _components_create_plan_tool_ui_js__WEBPACK_IMPORTED_MODULE_2__, _components_delete_tool_ui_js__WEBPACK_IMPORTED_MODULE_3__, _components_edit_tool_ui_js__WEBPACK_IMPORTED_MODULE_4__, _components_glob_tool_ui_js__WEBPACK_IMPORTED_MODULE_5__, _components_grep_tool_ui_js__WEBPACK_IMPORTED_MODULE_6__, _components_ls_tool_ui_js__WEBPACK_IMPORTED_MODULE_7__, _components_mcp_tool_ui_js__WEBPACK_IMPORTED_MODULE_8__, _components_read_lints_tool_ui_js__WEBPACK_IMPORTED_MODULE_9__, _components_read_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_10__, _components_read_tool_ui_js__WEBPACK_IMPORTED_MODULE_11__, _components_sem_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_12__, _components_shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_13__, _components_update_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_14__, _components_web_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_15__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
















const ToolCallComponent = ({ call: { call, aborted }, isLastStepOfTurn, isLastTurn, options: { isCompact, isSuggestingPlan, isGenerating, planDecisionIndex, shellManager, }, }) => {
    switch (call.tool.case) {
        case "shellToolCall": {
            // Expand only for items belonging to the last (pending) turn when compact mode is off.
            const expandShell = !isCompact && !!isLastTurn;
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_shell_tool_ui_js__WEBPACK_IMPORTED_MODULE_13__/* .ShellToolUI */ .f, { tool: call.tool.value, expand: expandShell, aborted: aborted, shellManager: shellManager }));
        }
        case "deleteToolCall":
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_delete_tool_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .DeleteToolUI */ .Y, { tool: call.tool.value });
        case "grepToolCall":
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_grep_tool_ui_js__WEBPACK_IMPORTED_MODULE_6__/* .GrepToolUI */ .h, { tool: call.tool.value });
        case "semSearchToolCall":
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_sem_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_12__/* .SemSearchToolUI */ .S, { tool: call.tool.value });
        case "globToolCall":
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_glob_tool_ui_js__WEBPACK_IMPORTED_MODULE_5__/* .GlobToolUI */ .P, { tool: call.tool.value });
        case "editToolCall":
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_edit_tool_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .EditToolUI */ .N, { tool: call.tool.value, aborted: aborted });
        case "readToolCall":
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_read_tool_ui_js__WEBPACK_IMPORTED_MODULE_11__/* .ReadToolUI */ .B, { tool: call.tool.value });
        case "readLintsToolCall":
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_read_lints_tool_ui_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A, { tool: call.tool.value });
        case "updateTodosToolCall":
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_update_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_14__/* .UpdateTodosToolUI */ .v, { tool: call.tool.value, aborted: aborted });
        case "readTodosToolCall":
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_read_todos_tool_ui_js__WEBPACK_IMPORTED_MODULE_10__/* .ReadTodosToolUI */ .w, { tool: call.tool.value, aborted: aborted });
        case "lsToolCall":
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_ls_tool_ui_js__WEBPACK_IMPORTED_MODULE_7__/* .LsToolUI */ .U, { tool: call.tool.value });
        case "mcpToolCall":
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_mcp_tool_ui_js__WEBPACK_IMPORTED_MODULE_8__/* .McpToolUI */ .v, { tool: call.tool.value });
        case "webSearchToolCall":
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_web_search_tool_ui_js__WEBPACK_IMPORTED_MODULE_15__/* .WebSearchToolUI */ .F, { tool: call.tool.value });
        case "createPlanToolCall": {
            const state = isLastStepOfTurn && isLastTurn
                ? isSuggestingPlan
                    ? "pending"
                    : isGenerating
                        ? "accepted"
                        : "rejected"
                : isLastStepOfTurn
                    ? "rejected"
                    : "accepted";
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_create_plan_tool_ui_js__WEBPACK_IMPORTED_MODULE_2__/* .CreatePlanToolUI */ .U, { tool: call.tool.value, isSuggestingPlan: isSuggestingPlan, planDecisionIndex: planDecisionIndex, state: state }));
        }
        default:
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: ["Unknown tool type: ", JSON.stringify(call.tool.case)] }) }));
    }
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/execution-mode/approval.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   K: () => (/* binding */ runExecutionModeApproval)
/* harmony export */ });
/* harmony import */ var _components_approval_dialog_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/components/approval-dialog.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_approval_dialog_js__WEBPACK_IMPORTED_MODULE_0__]);
_components_approval_dialog_js__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// Returns true if the user quit, false if the user approved the execution mode
function runExecutionModeApproval(configProvider) {
    return __awaiter(this, void 0, void 0, function* () {
        const config = configProvider.get();
        const showSandboxIntro = config.showSandboxIntro === true;
        // Only show prompts if the intro flag is set
        if (!showSandboxIntro) {
            return false;
        }
        const allowlistForMode = {
            auto: "allowlist",
            manual: "allowlist",
            unrestricted: "unrestricted",
            quit: "allowlist",
        };
        const sandboxModeForMode = {
            auto: "enabled",
            manual: "disabled",
            unrestricted: "disabled",
            quit: "disabled",
        };
        const options = [
            {
                key: "a",
                label: "Auto - Commands run in sandbox automatically with configurable network access",
                value: "auto",
            },
            {
                key: "m",
                label: "Manual - All commands require approval (allowlist mode)",
                value: "manual",
            },
            {
                key: "u",
                label: "Unrestricted - All commands run unsandboxed without approval",
                value: "unrestricted",
            },
            {
                key: "q",
                label: "Quit",
                value: "quit",
            },
        ];
        const result = yield (0,_components_approval_dialog_js__WEBPACK_IMPORTED_MODULE_0__/* .runApprovalDialog */ .b)({
            title: "Command Execution",
            description: [
                "Cursor can execute commands safely in a sandbox. \nChoose how commands should be executed:",
            ],
            options,
            onAction: () => __awaiter(this, void 0, void 0, function* () {
                // This will be called after the user selects an option
            }),
            variant: "info",
        });
        if (!result || result === "quit") {
            return true;
        }
        // For auto mode, ask about network access
        // For unrestricted mode, skip network access prompt since we can't restrict network access without sandbox
        let networkResult;
        if (result === "auto") {
            const networkOptions = [
                {
                    key: "y",
                    label: "Yes - Enable network access in sandbox",
                    value: "yes",
                },
                {
                    key: "n",
                    label: "No - Disable network access in sandbox (allowlist only)",
                    value: "no",
                },
                {
                    key: "q",
                    label: "Quit",
                    value: "quit",
                },
            ];
            networkResult = yield (0,_components_approval_dialog_js__WEBPACK_IMPORTED_MODULE_0__/* .runApprovalDialog */ .b)({
                title: "Network Access Configuration",
                description: ["Choose network access policy:"],
                options: networkOptions,
                onAction: () => __awaiter(this, void 0, void 0, function* () {
                    // This will be called after the user selects an option
                }),
                variant: "info",
            });
            if (!networkResult || networkResult === "quit") {
                return true;
            }
        }
        const sandboxMode = sandboxModeForMode[result];
        const approvalMode = allowlistForMode[result];
        const networkAccess = networkResult === "yes" ? "enabled" : "allowlist";
        // Mark intro as shown and update config
        yield configProvider.transform(cfg => (Object.assign(Object.assign({}, cfg), { showSandboxIntro: false, approvalMode: approvalMode, sandbox: Object.assign(Object.assign({}, cfg.sandbox), { mode: sandboxMode, networkAccess: networkAccess }) })));
        return false;
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/headless.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: () => (/* binding */ runHeadless)
/* harmony export */ });
/* harmony import */ var _anysphere_agent_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../agent-core/dist/index.js");
/* harmony import */ var _anysphere_agent_exec__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../agent-exec/dist/index.js");
/* harmony import */ var _anysphere_proto_agent_v1_agent_pb_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../proto/dist/generated/agent/v1/agent_pb.js");
/* harmony import */ var _anysphere_proto_agent_v1_selected_context_pb_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../proto/dist/generated/agent/v1/selected_context_pb.js");
/* harmony import */ var _anysphere_proto_agent_v1_shell_exec_pb_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../proto/dist/generated/agent/v1/shell_exec_pb.js");
/* harmony import */ var _console_io_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/console-io.ts");
/* harmony import */ var _state_session_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/state/session.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







const PRINTENV_COMMAND = "printenv";
const PRINTENV_TIMEOUT_MS = 5000;
let hasLoggedPrintEnvError = false;
function isShellToolCall(toolCall) {
    return toolCall.tool.case === "shellToolCall";
}
function formatProcessEnv() {
    return Object.entries(process.env)
        .map(([key, value]) => `${key}=${value !== null && value !== void 0 ? value : ""}`)
        .join("\n");
}
function createPrintenvArgs() {
    return new _anysphere_proto_agent_v1_shell_exec_pb_js__WEBPACK_IMPORTED_MODULE_4__/* .ShellArgs */ .a({
        command: PRINTENV_COMMAND,
        timeout: PRINTENV_TIMEOUT_MS,
        simpleCommands: [PRINTENV_COMMAND],
        skipApproval: true,
        parsingResult: new _anysphere_proto_agent_v1_shell_exec_pb_js__WEBPACK_IMPORTED_MODULE_4__/* .ShellCommandParsingResult */ .HO({
            parsingFailed: false,
            executableCommands: [
                new _anysphere_proto_agent_v1_shell_exec_pb_js__WEBPACK_IMPORTED_MODULE_4__/* .ShellCommandParsingResult_ExecutableCommand */ .Pv({
                    name: PRINTENV_COMMAND,
                    args: [],
                    fullText: PRINTENV_COMMAND,
                }),
            ],
            hasRedirects: false,
            hasCommandSubstitution: false,
        }),
    });
}
function describeShellResult(result) {
    var _a;
    const caseName = result.result.case;
    if (!caseName) {
        return "unknown shell result";
    }
    switch (caseName) {
        case "failure": {
            const { exitCode, stderr } = result.result.value;
            const detail = stderr === null || stderr === void 0 ? void 0 : stderr.split("\n").find(Boolean);
            return `exit code ${exitCode}${detail ? ` (${detail.substring(0, 200)})` : ""}`;
        }
        case "timeout":
            return `timeout after ${result.result.value.timeoutMs}ms`;
        case "rejected":
            return `rejected: ${(_a = result.result.value.reason) !== null && _a !== void 0 ? _a : "unknown reason"}`;
        case "spawnError":
            return `spawn error: ${result.result.value.error}`;
        case "permissionDenied":
            return `permission denied: ${result.result.value.error}`;
        default:
            return caseName;
    }
}
function captureEnvironmentSnapshot(ctx, resources) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        try {
            const shellExecutor = resources.get(_anysphere_agent_exec__WEBPACK_IMPORTED_MODULE_1__/* .shellExecutorResource */ .qk);
            if (!shellExecutor) {
                throw new Error("shell executor unavailable");
            }
            const result = yield shellExecutor.execute(ctx, createPrintenvArgs());
            if (result.result.case === "success") {
                return (_a = result.result.value.stdout) !== null && _a !== void 0 ? _a : "";
            }
            if (result.result.case === "failure") {
                const stdout = result.result.value.stdout;
                if (stdout && stdout.length > 0) {
                    return stdout;
                }
            }
            throw new Error(describeShellResult(result));
        }
        catch (error) {
            if (!hasLoggedPrintEnvError) {
                const reason = error instanceof Error ? error.message : String(error);
                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_6__/* .intentionallyWriteToStderr */ .p2)(`Warning: Failed to capture environment snapshot; falling back to process.env snapshot (${reason})`);
                hasLoggedPrintEnvError = true;
            }
            return formatProcessEnv();
        }
    });
}
function runHeadless(ctx, prompt, modelManager, agentClient, resources, agentStore, forceApprove, opts) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        if (!prompt.trim()) {
            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_6__/* .exitWithMessage */ .uQ)(1, "Error: No prompt provided for print mode");
        }
        const abortController = new AbortController();
        const handleSigint = () => {
            (0,_console_io_js__WEBPACK_IMPORTED_MODULE_6__/* .intentionallyWriteToStderr */ .p2)("\nAborting operation...");
            abortController.abort();
        };
        process.on("SIGINT", handleSigint);
        const startedAt = Date.now();
        const isStreamPartialOutput = opts.streamPartialOutput === true;
        const isStreamJson = opts.outputFormat === "stream-json";
        const isJson = opts.outputFormat === "json";
        const isText = opts.outputFormat === "text";
        const shouldCaptureEnv = opts.captureEnv === true;
        let aggregatedText = "";
        let currentMessageText = "";
        let currentStreamJsonMessageText = "";
        const interactionListener = {
            sendUpdate(_ctx, update) {
                return __awaiter(this, void 0, void 0, function* () {
                    switch (update.type) {
                        case "text-delta": {
                            aggregatedText += update.text;
                            currentMessageText += update.text;
                            currentStreamJsonMessageText += update.text;
                            if (isStreamPartialOutput) {
                                const obj = {
                                    type: "assistant",
                                    message: {
                                        role: "assistant",
                                        content: [{ type: "text", text: update.text }],
                                    },
                                    session_id: opts.sessionId,
                                    timestamp_ms: Date.now(),
                                };
                                process.stdout.write(`${JSON.stringify(obj)}\n`);
                            }
                            break;
                        }
                        case "tool-call-started": {
                            // For stream-json, output the accumulated message text before tool call
                            if (isStreamJson && currentStreamJsonMessageText) {
                                const obj = {
                                    type: "assistant",
                                    message: {
                                        role: "assistant",
                                        content: [{ type: "text", text: currentStreamJsonMessageText }],
                                    },
                                    session_id: opts.sessionId,
                                    model_call_id: update.modelCallId,
                                    timestamp_ms: Date.now(),
                                };
                                process.stdout.write(`${JSON.stringify(obj)}\n`);
                                currentStreamJsonMessageText = "";
                            }
                            // Reset current message text when a tool call starts (new message segment begins after tool)
                            currentMessageText = "";
                            if (isStreamJson || isStreamPartialOutput) {
                                const obj = {
                                    type: "tool_call",
                                    subtype: "started",
                                    call_id: update.callId,
                                    tool_call: update.toolCall,
                                    model_call_id: update.modelCallId,
                                    session_id: opts.sessionId,
                                    timestamp_ms: Date.now(),
                                };
                                process.stdout.write(`${JSON.stringify(obj)}\n`);
                            }
                            break;
                        }
                        case "tool-call-completed": {
                            const shouldAttachEnv = shouldCaptureEnv &&
                                (isStreamJson || isStreamPartialOutput) &&
                                isShellToolCall(update.toolCall);
                            const envSnapshot = shouldAttachEnv
                                ? yield captureEnvironmentSnapshot(ctx, resources)
                                : undefined;
                            if (isStreamJson || isStreamPartialOutput) {
                                const obj = Object.assign({ type: "tool_call", subtype: "completed", call_id: update.callId, tool_call: update.toolCall, model_call_id: update.modelCallId, session_id: opts.sessionId, timestamp_ms: Date.now() }, (envSnapshot !== undefined ? { env: envSnapshot } : {}));
                                process.stdout.write(`${JSON.stringify(obj)}\n`);
                            }
                            break;
                        }
                        case "thinking-delta": {
                            // Emit thinking deltas in stream-json and stream-partial-output modes
                            if (isStreamJson || isStreamPartialOutput) {
                                const obj = {
                                    type: "thinking",
                                    subtype: "delta",
                                    text: update.text,
                                    session_id: opts.sessionId,
                                    timestamp_ms: Date.now(),
                                };
                                process.stdout.write(`${JSON.stringify(obj)}\n`);
                            }
                            break;
                        }
                        case "thinking-completed": {
                            // Emit thinking completion marker
                            if (isStreamJson || isStreamPartialOutput) {
                                const obj = {
                                    type: "thinking",
                                    subtype: "completed",
                                    session_id: opts.sessionId,
                                    timestamp_ms: Date.now(),
                                };
                                process.stdout.write(`${JSON.stringify(obj)}\n`);
                            }
                            break;
                        }
                    }
                });
            },
            query(_ctx, query) {
                return __awaiter(this, void 0, void 0, function* () {
                    switch (query.type) {
                        case "web-search-request":
                            if (forceApprove) {
                                return {
                                    approved: true,
                                };
                            }
                            return {
                                approved: false,
                                reason: "User Rejected",
                            };
                        default: {
                            // All other query types are not supported
                            const _exhaustiveCheck = query.type;
                            throw new Error(`Unhandled interaction query type: ${query.type}`);
                        }
                    }
                });
            },
        };
        try {
            const currentModel = yield modelManager.awaitCurrentModel();
            if (isStreamJson || isStreamPartialOutput) {
                const init = {
                    type: "system",
                    subtype: "init",
                    apiKeySource: (_a = opts.apiKeySource) !== null && _a !== void 0 ? _a : "login", // pragma: allowlist secret
                    cwd: process.cwd(),
                    session_id: opts.sessionId,
                    // tools: [], // TODO: add tools
                    // mcp_servers: [], // TODO: add mcp servers
                    model: currentModel.displayName,
                    permissionMode: "default",
                };
                process.stdout.write(`${JSON.stringify(init)}\n`);
                const userMsg = {
                    type: "user",
                    message: { role: "user", content: [{ type: "text", text: prompt }] },
                    session_id: opts.sessionId,
                };
                process.stdout.write(`${JSON.stringify(userMsg)}\n`);
            }
            const selectedCtx = new _anysphere_proto_agent_v1_selected_context_pb_js__WEBPACK_IMPORTED_MODULE_3__/* .SelectedContext */ .xv();
            const action = new _anysphere_proto_agent_v1_agent_pb_js__WEBPACK_IMPORTED_MODULE_2__/* .UserMessageAction */ .Vt({
                userMessage: new _anysphere_proto_agent_v1_agent_pb_js__WEBPACK_IMPORTED_MODULE_2__/* .UserMessage */ .RG({
                    text: prompt,
                    selectedContext: selectedCtx,
                    messageId: crypto.randomUUID(),
                }),
            });
            // Create the conversation action manager
            const conversationActionManager = new _anysphere_agent_core__WEBPACK_IMPORTED_MODULE_0__/* .ControlledConversationActionManager */ .hg();
            yield agentClient.run(ctx, agentStore.getConversationStateStructure(), new _anysphere_proto_agent_v1_agent_pb_js__WEBPACK_IMPORTED_MODULE_2__/* .ConversationAction */ .QF({
                action: {
                    case: "userMessageAction",
                    value: action,
                },
            }), currentModel, interactionListener, resources, agentStore.getBlobStore(), conversationActionManager, agentStore, [], // Empty - tools are now provided via request context
            {
                conversationId: agentStore.getId(),
                headers: opts.headers,
            });
            // Capture the last request id generated for the main agent run (if available)
            const requestId = _state_session_js__WEBPACK_IMPORTED_MODULE_5__/* .session */ .d.getLastRequestId();
            const durationMs = Date.now() - startedAt;
            if (isJson) {
                const result = Object.assign({ type: "result", subtype: "success", is_error: false, duration_ms: durationMs, duration_api_ms: durationMs, result: aggregatedText || "", session_id: opts.sessionId }, (requestId ? { request_id: requestId } : {}));
                process.stdout.write(`${JSON.stringify(result)}\n`);
            }
            else if (isStreamJson) {
                // Output any remaining accumulated message text before the final result
                if (currentStreamJsonMessageText) {
                    const obj = {
                        type: "assistant",
                        message: {
                            role: "assistant",
                            content: [{ type: "text", text: currentStreamJsonMessageText }],
                        },
                        session_id: opts.sessionId,
                    };
                    process.stdout.write(`${JSON.stringify(obj)}\n`);
                }
                const final = Object.assign({ type: "result", subtype: "success", duration_ms: durationMs, duration_api_ms: durationMs, is_error: false, result: aggregatedText || "", session_id: opts.sessionId }, (requestId ? { request_id: requestId } : {}));
                process.stdout.write(`${JSON.stringify(final)}\n`);
            }
            else if (isStreamPartialOutput) {
                const final = Object.assign({ type: "result", subtype: "success", duration_ms: durationMs, duration_api_ms: durationMs, is_error: false, result: aggregatedText || "", session_id: opts.sessionId }, (requestId ? { request_id: requestId } : {}));
                process.stdout.write(`${JSON.stringify(final)}\n`);
            }
            else if (isText) {
                // For text format, only output the final message (after last tool call)
                process.stdout.write(`${currentMessageText || ""}\n`);
            }
            // Added to solve hanging issue where process doesn't exit after runHeadless is done. Particularly reproducible when running cursor headless first time after installation
            process.exit(0);
        }
        catch (error) {
            if (error instanceof Error && error.name === "AbortError") {
                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_6__/* .exitWithMessage */ .uQ)(130, "Operation cancelled");
            }
            else {
                (0,_console_io_js__WEBPACK_IMPORTED_MODULE_6__/* .exitWithMessage */ .uQ)(1, String(error));
            }
        }
        finally {
            process.off("SIGINT", handleSigint);
        }
    });
}


/***/ }),

/***/ "./src/hooks/prompt/use-at-palette.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  q: () => (/* binding */ AT_REGEX),
  g: () => (/* binding */ useAtPalette)
});

// EXTERNAL MODULE: ../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js
var react = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
// EXTERNAL MODULE: ./src/constants.ts
var constants = __webpack_require__("./src/constants.ts");
// EXTERNAL MODULE: external "node:child_process"
var external_node_child_process_ = __webpack_require__("node:child_process");
// EXTERNAL MODULE: external "node:fs"
var external_node_fs_ = __webpack_require__("node:fs");
// EXTERNAL MODULE: external "node:os"
var external_node_os_ = __webpack_require__("node:os");
var external_node_os_default = /*#__PURE__*/__webpack_require__.n(external_node_os_);
// EXTERNAL MODULE: external "node:path"
var external_node_path_ = __webpack_require__("node:path");
// EXTERNAL MODULE: external "node:util"
var external_node_util_ = __webpack_require__("node:util");
// EXTERNAL MODULE: ../proto/dist/generated/agent/v1/agent_service_pb.js
var agent_service_pb = __webpack_require__("../proto/dist/generated/agent/v1/agent_service_pb.js");
// EXTERNAL MODULE: ./src/debug.ts + 1 modules
var debug = __webpack_require__("./src/debug.ts");
// EXTERNAL MODULE: ./src/utils/fuzzy.ts
var fuzzy = __webpack_require__("./src/utils/fuzzy.ts");
;// ./src/utils/at-file-suggestions.ts
/*
  At-file suggestions index for the @-palette

  Why
  - Provide sub-16ms, per-keystroke path suggestions without touching disk or spawning processes.
  - This is NOT a content index; we only cache file and directory paths for fast filtering.

  How
  - One-time, concurrent enumeration of candidates scoped to process.cwd() (or options.cwd):
    1) ripgrep: rg --files [--hidden] --follow --max-depth <N>
    2) git:    git ls-files -co --exclude-standard (honors .gitignore)
    3) node:   directory walk as a last-resort fallback
  - As results stream in we normalize to POSIX-style paths, represent directories with a trailing '/',
    publish periodic snapshots to listeners, and on finalize deduplicate + sort the union across strategies.

  Usage
  - ensureFileIndex() starts indexing once per session; subsequent calls no-op while building/ready.
  - getAtFileSuggestions(fragment) filters state.paths in-memory via fuzzyScore; keystrokes do zero I/O.
  - getDefaultSuggestions() uses the index when ready, otherwise a shallow cwd read + optional git check-ignore.

  Characteristics
  - Latency: keystrokes are in-memory; indexers stream and respect AT_FILE_INDEX_TIMEOUT_MS.
  - Memory: O(#paths). With maxFiles ≈ 20k (+dirs), expect single-digit MBs in typical repos.
  - Scope: strictly to cwd to avoid surfacing files outside the active folder.

  Out of scope
  - Content search/grep: execute ripgrep on demand; do not build a content index here.
  - Live watching: we currently build once; callers can request a rebuild if needed.

  Observability
  - debugLog('atFileSuggestions.index.*'), getAtFileIndexStatus(), onAtFileIndexUpdate().
*/
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








const execFileAsync = (0,external_node_util_.promisify)(external_node_child_process_.execFile);
// Ratio of default suggestions to reserve for recent files
const RECENT_FILES_RATIO = 0.3;
const RECENT_FILES_SCORE_OFFSET = 100000;
// Helper to execute a command and return stdout
function execCommand(command_1, args_1, cwd_1) {
    return __awaiter(this, arguments, void 0, function* (command, args, cwd, timeout = 2000) {
        try {
            const { stdout } = yield execFileAsync(command, args, {
                cwd,
                timeout,
                encoding: "utf8",
                maxBuffer: 10 * 1024 * 1024, // 10MB buffer for large outputs
            });
            return stdout;
        }
        catch (error) {
            const message = error instanceof Error ? error.message : String(error);
            throw new Error(`Command failed: ${message}`);
        }
    });
}
// Helper to execute a command and return success status
function execCommandStatus(command_1, args_1, cwd_1) {
    return __awaiter(this, arguments, void 0, function* (command, args, cwd, timeout = 2000) {
        try {
            yield execFileAsync(command, args, {
                cwd,
                timeout,
                encoding: "utf8",
                maxBuffer: 10 * 1024 * 1024, // 10MB buffer for large outputs
            });
            return true;
        }
        catch (_a) {
            return false;
        }
    });
}
// Session-scoped ripgrep path set by ensureFileIndex; default to system 'rg'
let sessionRgPath = "rg";
const state = {
    ready: false,
    paths: [],
    building: false,
    startedAt: null,
    baseDir: null,
    strategies: new Set(),
    lastReason: null,
    lastDurationMs: null,
    sessionId: null,
};
let _sessionCounter = 0;
const listeners = new Set();
function onAtFileIndexUpdate(listener) {
    listeners.add(listener);
    return () => listeners.delete(listener);
}
function notifyIndexUpdate() {
    for (const l of Array.from(listeners)) {
        try {
            l();
        }
        catch (_a) {
            /* noop */
        }
    }
}
function getAtFileIndexStatus() {
    const totalPaths = state.paths.length;
    let totalFiles = 0;
    for (const p of state.paths)
        if (!p.endsWith("/"))
            totalFiles++;
    const elapsedMs = state.startedAt && state.building ? Date.now() - state.startedAt : null;
    return {
        building: state.building,
        ready: state.ready,
        totalPaths,
        totalFiles,
        strategies: Array.from(state.strategies),
        baseDir: state.baseDir,
        elapsedMs,
        lastReason: state.lastReason,
        lastDurationMs: state.lastDurationMs,
    };
}
function resolveBaseDir(preferred) {
    // Scope indexing strictly to the caller's current working directory
    // to avoid surfacing files outside the active folder.
    return preferred !== null && preferred !== void 0 ? preferred : process.cwd();
}
function ensureFileIndex() {
    return __awaiter(this, arguments, void 0, function* (options = {}) {
        var _a, _b, _c, _d;
        if (state.ready || state.building)
            return;
        state.building = true;
        state.startedAt = Date.now();
        const cwd = resolveBaseDir(options.cwd);
        state.baseDir = cwd;
        const maxFiles = (_a = options.maxFiles) !== null && _a !== void 0 ? _a : 20000;
        const maxDepth = (_b = options.maxDepth) !== null && _b !== void 0 ? _b : 16;
        const includeHidden = (_c = options.includeHidden) !== null && _c !== void 0 ? _c : false;
        // Capture rgPath for this indexing session if provided
        if (options.rgPath && options.rgPath.length > 0) {
            sessionRgPath = options.rgPath;
        }
        const timeoutMs = Number((_d = process.env.AT_FILE_INDEX_TIMEOUT_MS) !== null && _d !== void 0 ? _d : "8000");
        (0,debug.debugLog)("atFileSuggestions.index.start", {
            cwd,
            maxFiles,
            maxDepth,
            includeHidden,
            timeoutMs,
        });
        // Session-scoped aggregation to avoid races and overwrites.
        const sessionId = ++_sessionCounter;
        state.sessionId = sessionId;
        const aggFiles = new Set();
        const aggDirs = new Set();
        const childProcs = [];
        const timers = [];
        const sessionDeadline = Date.now() + timeoutMs;
        let finalized = false;
        let lastPublishCount = 0;
        const registerProc = (p) => {
            childProcs.push(p);
        };
        const publishAggregator = () => {
            if (finalized || state.sessionId !== sessionId)
                return;
            const count = aggFiles.size + aggDirs.size;
            if (count <= 64 || count - lastPublishCount >= 256) {
                state.paths = Array.from(aggFiles).concat(Array.from(aggDirs));
                lastPublishCount = count;
                notifyIndexUpdate();
            }
        };
        const addToAggregator = (files, dirs) => {
            if (finalized || state.sessionId !== sessionId)
                return;
            for (const f of files)
                aggFiles.add(f);
            for (const d of dirs)
                aggDirs.add(d);
            publishAggregator();
        };
        const finalize = (reason) => {
            if (finalized)
                return;
            finalized = true;
            for (const t of timers)
                clearTimeout(t);
            for (const p of childProcs) {
                try {
                    p.kill();
                }
                catch (_a) {
                    /* ignore */
                }
            }
            // Recompute directory hierarchy from files to ensure all parent folders exist
            const allFiles = Array.from(aggFiles);
            const dirSet = new Set();
            for (const file of allFiles) {
                let dir = (0,external_node_path_.dirname)(file);
                while (dir && dir !== ".") {
                    dirSet.add(`${dir}/`);
                    dir = (0,external_node_path_.dirname)(dir);
                }
            }
            const existing = new Set(state.paths);
            for (const p of allFiles)
                existing.add(p);
            for (const d of dirSet)
                existing.add(d);
            const allPaths = Array.from(existing);
            state.paths = allPaths.sort((a, b) => {
                const aDir = a.endsWith("/");
                const bDir = b.endsWith("/");
                if (aDir !== bDir) {
                    const aBase = aDir ? a.slice(0, -1) : a;
                    const bBase = bDir ? b.slice(0, -1) : b;
                    if (aBase === bBase ||
                        aBase.startsWith(`${bBase}/`) ||
                        bBase.startsWith(`${aBase}/`)) {
                        return aDir ? -1 : 1;
                    }
                }
                return a.localeCompare(b, undefined, { sensitivity: "base" });
            });
            state.ready = true;
            state.building = false;
            const duration = state.startedAt ? Date.now() - state.startedAt : undefined;
            state.lastReason = reason;
            state.lastDurationMs = duration !== null && duration !== void 0 ? duration : null;
            state.strategies.clear();
            (0,debug.debugLog)("atFileSuggestions.index.done", {
                reason,
                durationMs: duration,
                total: state.paths.length,
            });
            notifyIndexUpdate();
        };
        const isGitRepo = () => __awaiter(this, void 0, void 0, function* () {
            try {
                return yield execCommandStatus("git", ["rev-parse", "--is-inside-work-tree"], cwd);
            }
            catch (_a) {
                return false;
            }
        });
        let rgStarted = false;
        let gitStarted = false;
        let nodeStarted = false;
        const maybeFinalize = (reason) => {
            if (finalized)
                return;
            if (state.strategies.size === 0)
                finalize(reason);
        };
        const startRgIndexer = () => {
            if (rgStarted)
                return;
            rgStarted = true;
            state.strategies.add("rg");
            notifyIndexUpdate();
            const args = [
                "--files",
                "--follow",
                "--max-depth",
                String(maxDepth),
                "--no-messages",
            ];
            if (includeHidden)
                args.push("--hidden");
            const rg = (0,external_node_child_process_.spawn)(sessionRgPath, args, { cwd });
            registerProc(rg);
            const files = [];
            const dirSet = new Set();
            let buf = "";
            let done = false;
            const publish = () => {
                addToAggregator(files, dirSet);
            };
            const onDone = (why) => {
                if (done)
                    return;
                done = true;
                try {
                    rg.kill();
                }
                catch (_a) {
                    /* ignore */
                }
                // Ensure latest batch is merged
                addToAggregator(files, dirSet);
                state.strategies.delete("rg");
                maybeFinalize(`rg:${why}`);
            };
            const timer = setTimeout(() => onDone("timeout"), timeoutMs);
            timers.push(timer);
            rg.stdout.setEncoding("utf8");
            rg.stdout.on("data", (chunk) => {
                if (finalized || state.sessionId !== sessionId)
                    return;
                buf += chunk;
                let idx;
                // biome-ignore lint/suspicious/noAssignInExpressions: common pattern for parsing buffers
                while ((idx = buf.indexOf("\n")) !== -1) {
                    const line = buf.slice(0, idx).trim();
                    buf = buf.slice(idx + 1);
                    if (!line)
                        continue;
                    const rel = line.split(external_node_path_.sep).join("/");
                    files.push(rel);
                    let d = (0,external_node_path_.dirname)(rel);
                    while (d && d !== ".") {
                        dirSet.add(`${d}/`);
                        d = (0,external_node_path_.dirname)(d);
                    }
                    if (files.length <= 64 || files.length % 256 === 0)
                        publish();
                    if (files.length >= maxFiles || Date.now() > sessionDeadline) {
                        clearTimeout(timer);
                        onDone(files.length >= maxFiles ? "limit" : "timeout");
                        return;
                    }
                }
            });
            rg.on("error", err => {
                void (() => __awaiter(this, void 0, void 0, function* () {
                    clearTimeout(timer);
                    if (done || finalized)
                        return;
                    (0,debug.debugLog)("atFileSuggestions.rg.error", String(err));
                    state.strategies.delete("rg");
                    if ((yield isGitRepo()) && !gitStarted)
                        yield startGitIndexer(true);
                    else if (!nodeStarted)
                        startNodeIndexer(true);
                    maybeFinalize("rg:error");
                }))();
            });
            rg.on("close", code => {
                void (() => __awaiter(this, void 0, void 0, function* () {
                    clearTimeout(timer);
                    if (done || finalized)
                        return;
                    if (code === 0 || files.length > 0) {
                        onDone("complete");
                    }
                    else {
                        // Fallback only if not already running
                        state.strategies.delete("rg");
                        if ((yield isGitRepo()) && !gitStarted)
                            yield startGitIndexer(true);
                        else if (!nodeStarted)
                            startNodeIndexer(true);
                        maybeFinalize("rg:empty");
                    }
                }))();
            });
        };
        const startGitIndexer = (...args_1) => __awaiter(this, [...args_1], void 0, function* (afterRg = false) {
            if (gitStarted)
                return;
            gitStarted = true;
            state.strategies.add("git");
            notifyIndexUpdate();
            // Restrict listing to current directory only by passing a pathspec '.'
            const args = ["ls-files", "-co", "--exclude-standard", "-z", "--", "."];
            const git = (0,external_node_child_process_.spawn)("git", args, { cwd });
            registerProc(git);
            const files = [];
            const dirSet = new Set();
            let buf = "";
            let done = false;
            const publish = () => {
                addToAggregator(files, dirSet);
            };
            const onDone = (why) => {
                if (done)
                    return;
                done = true;
                try {
                    git.kill();
                }
                catch (_a) {
                    /* ignore */
                }
                addToAggregator(files, dirSet);
                state.strategies.delete("git");
                maybeFinalize(`git:${why}${afterRg ? ":fallback" : ""}`);
            };
            const timer = setTimeout(() => onDone("timeout"), timeoutMs);
            timers.push(timer);
            // Compute the path prefix from repository root to cwd so we can
            // rebase git outputs (which are repo-root relative) to cwd-relative.
            let gitPrefix = "";
            try {
                const pfx = yield execCommand("git", ["rev-parse", "--show-prefix"], cwd);
                gitPrefix = pfx.trim().split(external_node_path_.sep).join("/");
            }
            catch (_a) {
                /* ignore */
            }
            git.stdout.setEncoding("utf8");
            git.stdout.on("data", (chunk) => {
                if (finalized || state.sessionId !== sessionId)
                    return;
                buf += chunk;
                let idx;
                // biome-ignore lint/suspicious/noAssignInExpressions: common pattern for parsing buffers
                while ((idx = buf.indexOf("\u0000")) !== -1) {
                    const line = buf.slice(0, idx);
                    buf = buf.slice(idx + 1);
                    if (!line)
                        continue;
                    let rel = line.split(external_node_path_.sep).join("/");
                    if (gitPrefix && rel.startsWith(gitPrefix)) {
                        rel = rel.slice(gitPrefix.length);
                    }
                    // Guard against paths escaping the cwd scope
                    if (rel.startsWith("../"))
                        continue;
                    files.push(rel);
                    let d = (0,external_node_path_.dirname)(rel);
                    while (d && d !== ".") {
                        dirSet.add(`${d}/`);
                        d = (0,external_node_path_.dirname)(d);
                    }
                    if (files.length <= 64 || files.length % 256 === 0)
                        publish();
                    if (files.length >= maxFiles || Date.now() > sessionDeadline) {
                        clearTimeout(timer);
                        onDone(files.length >= maxFiles ? "limit" : "timeout");
                        return;
                    }
                }
            });
            git.on("error", err => {
                clearTimeout(timer);
                if (done || finalized)
                    return;
                done = true;
                (0,debug.debugLog)("atFileSuggestions.git.error", String(err));
                state.strategies.delete("git");
                if (!nodeStarted)
                    startNodeIndexer(afterRg);
                maybeFinalize("git:error");
            });
            git.on("close", code => {
                clearTimeout(timer);
                if (done || finalized)
                    return;
                if (code === 0 || files.length > 0) {
                    onDone("complete");
                }
                else {
                    state.strategies.delete("git");
                    if (!nodeStarted)
                        startNodeIndexer(afterRg);
                    maybeFinalize("git:empty");
                }
            });
        });
        const startNodeIndexer = (afterPrev = false) => {
            if (nodeStarted)
                return;
            nodeStarted = true;
            state.strategies.add("node");
            notifyIndexUpdate();
            const ignore = new Set([
                ".git",
                "node_modules",
                "out",
                "dist",
                "build",
                "target",
                ".next",
                ".cache",
                "venv",
                ".venv",
            ]);
            const queue = [""];
            let aborted = false;
            const maxConcurrent = 8;
            const worker = () => __awaiter(this, void 0, void 0, function* () {
                while (!finalized) {
                    const relDir = queue.shift();
                    if (relDir === undefined)
                        break;
                    const depth = relDir ? relDir.split("/").filter(Boolean).length : 0;
                    if (depth > maxDepth)
                        continue;
                    const abs = relDir ? (0,external_node_path_.join)(cwd, relDir) : cwd;
                    let entries;
                    try {
                        entries = yield external_node_fs_.promises.readdir(abs, { withFileTypes: true });
                    }
                    catch (_a) {
                        continue;
                    }
                    const batch = [];
                    const dirSet = new Set();
                    for (const entry of entries) {
                        if (finalized) {
                            aborted = true;
                            break;
                        }
                        const name = entry.name;
                        if (!includeHidden && name.startsWith("."))
                            continue;
                        if (ignore.has(name))
                            continue;
                        const pathRel = relDir ? (0,external_node_path_.join)(relDir, name) : name;
                        if (entry.isDirectory()) {
                            queue.push(pathRel + external_node_path_.sep);
                        }
                        else {
                            batch.push(pathRel);
                            let d = (0,external_node_path_.dirname)(pathRel);
                            while (d && d !== ".") {
                                dirSet.add(`${d}/`);
                                d = (0,external_node_path_.dirname)(d);
                            }
                            if (aggFiles.size + batch.length >= maxFiles) {
                                aborted = true;
                                break;
                            }
                        }
                    }
                    if (batch.length > 0)
                        addToAggregator(batch, dirSet);
                    if (Date.now() > sessionDeadline || aggFiles.size >= maxFiles) {
                        aborted = true;
                        break;
                    }
                }
            });
            Promise.all(Array.from({ length: maxConcurrent }, () => worker()))
                .then(() => {
                state.strategies.delete("node");
                maybeFinalize(`node:${aborted ? "timeout" : "complete"}${afterPrev ? ":fallback" : ""}`);
            })
                .catch(() => {
                state.strategies.delete("node");
                maybeFinalize(`node:error${afterPrev ? ":fallback" : ""}`);
            });
        };
        try {
            // Run rg for broad coverage (includes nested repos), and git for speed/honor .gitignore
            startRgIndexer();
            if (yield isGitRepo()) {
                yield startGitIndexer(true);
            }
        }
        catch (err) {
            (0,debug.debugLog)("atFileSuggestions.index.start.error", String(err));
            startNodeIndexer();
        }
    });
}
function score(candidate, needle) {
    // Directories have trailing '/'; strip for matching but bias them slightly (+5) so they appear before sibling files when equal.
    const isDir = candidate.endsWith("/");
    const base = isDir ? candidate.slice(0, -1) : candidate;
    if (!needle)
        return 1 + (isDir ? 5 : 0); // neutral base score
    // Fuzzy score using shared util
    const s = (0,fuzzy/* fuzzyScore */.dt)(base, needle);
    if (s <= 0)
        return 0;
    return s + (isDir ? 5 : 0);
}
// Load recent files from ~/.cursor/ide_state.json and promote matching ones that exist under current cwd
function getRecentFiles() {
    try {
        const home = external_node_os_default().homedir();
        const filePath = (0,external_node_path_.join)(home, ".cursor", "ide_state.json");
        const raw = (0,external_node_fs_.readFileSync)(filePath, "utf8");
        const ideState = agent_service_pb/* IdeEditorsStateLite */.m_.fromJsonString(raw);
        return ideState.recentlyViewedFiles
            .filter(f => f.relativePath &&
            f.absolutePath &&
            f.absolutePath.startsWith(process.cwd()))
            .map(f => f.relativePath);
    }
    catch (_a) {
        return [];
    }
}
function getAtFileSuggestions(fragment_1) {
    return __awaiter(this, arguments, void 0, function* (fragment, limit = 50) {
        const clean = fragment.trim().replace(/^[.[/\\]+/, "");
        if (!clean)
            return getDefaultSuggestions(limit);
        yield ensureFileIndex();
        const suggestions = [];
        const paths = state.paths.length > 0 ? state.paths : [];
        // Track all paths we've added to avoid duplicates (case-insensitive)
        const seenPaths = new Set();
        try {
            const recent = [];
            for (const f of getRecentFiles()) {
                const s = score(f, clean);
                if (s > 0)
                    recent.push(f);
                if (recent.length >= limit)
                    break;
            }
            // Add recent files first (with deduplication)
            for (const r of recent) {
                const lowerPath = r.toLowerCase();
                if (seenPaths.has(lowerPath))
                    continue;
                seenPaths.add(lowerPath);
                suggestions.push({
                    path: r,
                    score: score(r, clean) + RECENT_FILES_SCORE_OFFSET,
                });
            }
        }
        catch (_a) {
            /* ignore missing or invalid file */
        }
        // Add index files (with deduplication against recent files)
        for (const f of paths) {
            const lowerPath = f.toLowerCase();
            if (seenPaths.has(lowerPath))
                continue;
            const s = score(f, clean);
            if (s > 0) {
                seenPaths.add(lowerPath);
                suggestions.push({ path: f, score: s });
            }
        }
        // Add extra files from focused search (with deduplication against all previous)
        if (suggestions.length < limit && clean.length >= 3) {
            try {
                const extra = yield focusedFileNameSearch(clean, limit * 4);
                for (const p of extra) {
                    const lowerPath = p.toLowerCase();
                    if (seenPaths.has(lowerPath))
                        continue;
                    const s = score(p, clean);
                    if (s > 0) {
                        seenPaths.add(lowerPath);
                        suggestions.push({ path: p, score: s });
                    }
                }
            }
            catch (_b) {
                /* ignore */
            }
        }
        suggestions.sort((a, b) => b.score - a.score ||
            a.path.localeCompare(b.path, undefined, { sensitivity: "base" }));
        return suggestions.slice(0, limit);
    });
}
function toRelativeFromCwd(absPath) {
    return relative(process.cwd(), absPath).split(sep).join("/");
}
function getDefaultSuggestions(limit) {
    // Get recent files first
    const recentFiles = getRecentFiles();
    const suggestions = [];
    // Track all paths we've added to avoid duplicates (case-insensitive)
    const seenPaths = new Set();
    // Add recent files with higher priority
    const recentLimit = Math.floor(limit * RECENT_FILES_RATIO); // Reserve portion of limit for recent files
    for (const file of recentFiles.slice(0, recentLimit)) {
        const lowerPath = file.toLowerCase();
        if (!seenPaths.has(lowerPath)) {
            seenPaths.add(lowerPath);
            suggestions.push({
                path: file,
                score: RECENT_FILES_SCORE_OFFSET + score(file, ""), // Higher base score for recent files
            });
        }
    }
    // Prefer using existing index if available to avoid I/O
    if (state.ready && state.paths.length > 0) {
        const top = [];
        for (const p of state.paths) {
            if (p.endsWith("/")) {
                const segs = p.split("/").filter(Boolean);
                const topDir = segs.length > 0 ? `${segs[0]}/` : p;
                const lowerTopDir = topDir.toLowerCase();
                if (!seenPaths.has(lowerTopDir)) {
                    seenPaths.add(lowerTopDir);
                    top.push(topDir);
                }
            }
            else {
                const idx = p.indexOf("/");
                if (idx === -1) {
                    const lowerP = p.toLowerCase();
                    if (!seenPaths.has(lowerP)) {
                        seenPaths.add(lowerP);
                        top.push(p);
                    }
                }
                else {
                    const topDir = `${p.slice(0, idx)}/`;
                    const lowerTopDir = topDir.toLowerCase();
                    if (!seenPaths.has(lowerTopDir)) {
                        seenPaths.add(lowerTopDir);
                        top.push(topDir);
                    }
                }
            }
            if (top.length >= limit * 2)
                break;
        }
        // Add top-level items to suggestions
        for (const path of top) {
            suggestions.push({ path, score: score(path, "") });
        }
        const out = suggestions
            .sort((a, b) => b.score - a.score ||
            a.path.localeCompare(b.path, undefined, { sensitivity: "base" }))
            .slice(0, limit);
        (0,debug.debugLog)("atFileSuggestions.default.index", {
            count: out.length,
            recentCount: recentFiles.length,
        });
        return out;
    }
    // Fallback: read immediate entries in root and filter via .gitignore when available
    try {
        const cwd = process.cwd();
        const entries = (0,external_node_fs_.readdirSync)(cwd, { withFileTypes: true });
        // Filter hidden by default for signal clarity; allow showing hidden if users type '.' later
        const includeHidden = false;
        const candidates = entries
            .filter(e => includeHidden || !e.name.startsWith("."))
            .map(e => ({
            name: e.name,
            path: e.isDirectory() ? `${e.name}${external_node_path_.sep}` : e.name,
            isDir: e.isDirectory(),
        }));
        // If inside a git repo, filter out ignored entries using git check-ignore
        let filtered = candidates;
        try {
            const res = (0,external_node_child_process_.spawnSync)("git", ["rev-parse", "--is-inside-work-tree"], {
                cwd,
                stdio: "ignore",
            });
            const insideRepo = res.status === 0;
            if (insideRepo && candidates.length > 0) {
                const input = candidates.map(c => c.path).join("\u0000");
                const out = (0,external_node_child_process_.spawnSync)("git", ["check-ignore", "-z", "--stdin"], {
                    cwd,
                    encoding: "utf8",
                    input,
                });
                const ignoredSet = new Set((out.stdout || "").split("\u0000").filter(Boolean));
                filtered = candidates.filter(c => !ignoredSet.has(c.path));
                (0,debug.debugLog)("atFileSuggestions.default.gitFilter", {
                    total: candidates.length,
                    ignored: candidates.length - filtered.length,
                });
            }
        }
        catch (_a) {
            // ignore git failures
        }
        // Add filtered entries to existing suggestions (with deduplication)
        for (const { path } of filtered) {
            const lowerPath = path.toLowerCase();
            if (!seenPaths.has(lowerPath)) {
                seenPaths.add(lowerPath);
                suggestions.push({ path, score: score(path, "") });
            }
        }
        const finalSuggestions = suggestions
            .sort((a, b) => b.score - a.score ||
            a.path.localeCompare(b.path, undefined, { sensitivity: "base" }))
            .slice(0, limit);
        (0,debug.debugLog)("atFileSuggestions.default.readdir", {
            count: finalSuggestions.length,
            recentCount: recentFiles.length,
        });
        return finalSuggestions;
    }
    catch (_b) {
        return [];
    }
}
function buildNeedleGlob(needle) {
    // Convert to fuzzy-like glob: *u*n*i*f*i*e*d*d*r*o*p*d*o*w*n*
    // Only allow alphanumerics, dot, underscore, and hyphen (hyphen does not need to be escaped outside of a character class range)
    const safe = needle.replace(/[^A-Za-z0-9._-]/g, "");
    const parts = safe.split("").map((c) => `*${c}`);
    return `${parts.join("")}*`;
}
function focusedFileNameSearch(needle, max) {
    return __awaiter(this, void 0, void 0, function* () {
        const cwd = state.baseDir || process.cwd();
        const outPaths = new Set();
        // Prefer git pathspec search when available; honors .gitignore and is fast
        try {
            // Restrict search to current directory by prefixing the repo-relative
            // path of cwd in the pathspec.
            let prefix = "";
            try {
                const prefixOutput = yield execCommand("git", ["rev-parse", "--show-prefix"], cwd);
                prefix = prefixOutput.trim().split(external_node_path_.sep).join("/");
            }
            catch (_a) {
                /* ignore */
            }
            // Always enable glob semantics and search across subdirectories
            // to keep behavior consistent whether at repo root or a subdirectory.
            const spec = `:(icase,glob)${prefix}**/${buildNeedleGlob(needle)}`;
            const stdout = yield execCommand("git", ["ls-files", "-co", "--exclude-standard", "-z", "--", spec], cwd);
            const arr = stdout
                .split("\u0000")
                .filter(Boolean)
                .map(p => p.split(external_node_path_.sep).join("/"))
                .map(p => (prefix && p.startsWith(prefix) ? p.slice(prefix.length) : p))
                .filter(p => !p.startsWith("../"));
            for (const p of arr) {
                outPaths.add(p);
                if (outPaths.size >= max)
                    break;
            }
        }
        catch (_b) {
            /* ignore */
        }
        if (outPaths.size < Math.max(8, Math.floor(max / 4))) {
            // Fallback to ripgrep filename glob if available
            try {
                // Limit ripgrep file listing to current directory by running in cwd
                // with a glob anchored under cwd.
                const glob = `**/${buildNeedleGlob(needle)}`;
                const stdout = yield execCommand(sessionRgPath, ["--files", "--iglob", glob], cwd);
                const arr = stdout
                    .split("\n")
                    .filter(Boolean)
                    .map(p => p.split(external_node_path_.sep).join("/"));
                for (const p of arr) {
                    outPaths.add(p);
                    if (outPaths.size >= max)
                        break;
                }
            }
            catch (_c) {
                /* ignore */
            }
        }
        return Array.from(outPaths);
    });
}

// EXTERNAL MODULE: ./src/hooks/prompt/use-windowed-nav.ts
var use_windowed_nav = __webpack_require__("./src/hooks/prompt/use-windowed-nav.ts");
;// ./src/hooks/prompt/use-at-palette.ts
/** biome-ignore-all lint/correctness/useHookAtTopLevel: We disable based on a constant but Biome can't see that */
var use_at_palette_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




// Trigger when '@' is at start-of-line or preceded by a non-path character.
// "Non-path" excludes characters that are allowed inside the path fragment
// after '@' (letters, digits, '.', '_', '-', '/'). This lets patterns like
// "(@" or '"@' trigger, while avoiding mid-token cases like 'foo@bar'.
// Group 1 captures the optional preceding delimiter (or empty at start),
// Group 2 captures the fragment after '@'.
const AT_REGEX = /(^|[^A-Za-z0-9._\-/])@([A-Za-z0-9._\-/]*)$/;
const DEBOUNCE_MS = 200;
function useAtPaletteDisabled() {
    return {
        active: false,
        suggestions: [],
        index: 0,
        windowStart: 0,
        next: () => { },
        prev: () => { },
        reset: () => { },
        acceptExpansion: () => null,
        hide: () => { },
        suppress: () => { },
    };
}
function useAtPaletteEnabled(value, opts) {
    const [suggestions, setSuggestions] = (0,react.useState)([]);
    const [active, setActive] = (0,react.useState)(false);
    const [suppressed, setSuppressed] = (0,react.useState)(false);
    const lastValueRef = (0,react.useRef)(value);
    // Track the latest computation request to prevent race conditions
    const computationIdRef = (0,react.useRef)(0);
    const nav = (0,use_windowed_nav/* useWindowedNav */.m)(6);
    (0,react.useEffect)(() => {
        const changed = value !== lastValueRef.current;
        lastValueRef.current = value;
        // Reset suppression when pattern disappears or user starts a slash command
        if (!AT_REGEX.test(value) || value.startsWith("/")) {
            if (suppressed)
                setSuppressed(false);
        }
        const match = value.match(AT_REGEX);
        if (!match) {
            setActive(prev => (prev ? false : prev));
            if (suggestions.length !== 0)
                setSuggestions([]);
            nav.setLength(0);
            return;
        }
        if (suppressed) {
            setActive(prev => (prev ? false : prev));
            if (suggestions.length !== 0)
                setSuggestions([]);
            nav.setLength(0);
            return;
        }
        const fragment = match[2];
        // Compute suggestions immediately on first activation; debounce while active
        const compute = () => use_at_palette_awaiter(this, void 0, void 0, function* () {
            // Increment computation ID to track this request
            const currentComputationId = ++computationIdRef.current;
            // Ensure index uses the provided rgPath if supplied
            if (opts === null || opts === void 0 ? void 0 : opts.rgPath) {
                yield ensureFileIndex({ rgPath: opts.rgPath });
            }
            else {
                yield ensureFileIndex();
            }
            // Check if this computation is still the latest one before proceeding
            if (currentComputationId !== computationIdRef.current) {
                // A newer computation has started, discard these results
                return;
            }
            const res = (yield getAtFileSuggestions(fragment)).map(s => s.path);
            // Final staleness check before applying state updates
            if (currentComputationId !== computationIdRef.current) {
                // A newer computation has started, discard these results
                return;
            }
            if (res.length !== suggestions.length ||
                res.some((p, i) => p !== suggestions[i])) {
                setSuggestions(res);
            }
            nav.setLength(res.length);
            const visible = res.length > 0;
            setActive(prev => (prev !== visible ? visible : prev));
            if (visible && changed) {
                nav.reset();
            }
        });
        if (!active) {
            void compute().catch(() => {
                /* ignore errors */
            });
            return;
        }
        const t = setTimeout(() => void compute().catch(() => {
            /* ignore errors */
        }), DEBOUNCE_MS);
        return () => clearTimeout(t);
    }, [
        value,
        suppressed,
        active,
        nav.reset,
        nav.setLength,
        opts === null || opts === void 0 ? void 0 : opts.rgPath,
        suggestions,
    ]);
    const acceptExpansion = (0,react.useCallback)((input) => {
        if (!active || suggestions.length === 0)
            return null;
        const chosen = suggestions[nav.index];
        if (!chosen)
            return null;
        const append = chosen.endsWith("/") ? `@${chosen}` : `@${chosen} `;
        const rebuilt = input.replace(AT_REGEX, (_m, g1) => `${g1}${append}`);
        return rebuilt;
    }, [active, suggestions, nav.index]);
    const hide = (0,react.useCallback)(() => {
        setActive(false);
    }, []);
    const suppress = (0,react.useCallback)(() => {
        setSuppressed(true);
        setActive(false);
    }, []);
    return (0,react.useMemo)(() => ({
        active,
        suggestions,
        index: nav.index,
        windowStart: nav.windowStart,
        next: nav.next,
        prev: nav.prev,
        reset: nav.reset,
        acceptExpansion,
        hide,
        suppress,
    }), [
        active,
        suggestions,
        nav.index,
        nav.windowStart,
        nav.next,
        nav.prev,
        nav.reset,
        acceptExpansion,
        hide,
        suppress,
    ]);
}
function useAtPalette(value, opts) {
    if (!constants/* AT_PALETTE_ENABLED */.KD) {
        return useAtPaletteDisabled();
    }
    return useAtPaletteEnabled(value, opts);
}


/***/ }),

/***/ "./src/hooks/prompt/use-ephemeral.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   N: () => (/* binding */ useEphemeral)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/constants.ts");
/* harmony import */ var _debug_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/debug.ts");



function useEphemeral() {
    const [lines, setLines] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    const timeoutRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    const preserveRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
    const holdUntilInputRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
    const normalize = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((input) => {
        if (Array.isArray(input)) {
            const first = input[0];
            if (first &&
                typeof first === "object" &&
                !Array.isArray(first) &&
                "text" in first) {
                return [input];
            }
            return input;
        }
        return [input];
    }, []);
    const clearTimeoutIfAny = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        if (timeoutRef.current) {
            clearTimeout(timeoutRef.current);
            timeoutRef.current = null;
        }
    }, []);
    const clear = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        clearTimeoutIfAny();
        setLines([]);
    }, [clearTimeoutIfAny]);
    const set = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((input, options) => {
        const normalized = normalize(input);
        clearTimeoutIfAny();
        setLines(normalized);
        if ((options === null || options === void 0 ? void 0 : options.persistUntilInput) === true) {
            holdUntilInputRef.current = true; // persist across subsequent sets until user input
        }
        const requestedLinger = options === null || options === void 0 ? void 0 : options.minLingerMs;
        if (normalized.length > 0) {
            const duration = requestedLinger !== null && requestedLinger !== void 0 ? requestedLinger : (holdUntilInputRef.current
                ? undefined
                : _constants_js__WEBPACK_IMPORTED_MODULE_1__/* .EPHEMERAL_MESSAGE_TIMEOUT_MS */ .fj);
            if (duration !== undefined) {
                timeoutRef.current = setTimeout(() => {
                    setLines([]);
                    timeoutRef.current = null;
                    _debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog === null || _debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog === void 0 ? void 0 : (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("ephemeral.timeout.clear");
                }, duration);
            }
        }
    }, [clearTimeoutIfAny, normalize]);
    const preserveNextClear = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        preserveRef.current = true;
    }, []);
    // On unmount ensure timeout is cleared
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        return () => {
            clearTimeoutIfAny();
        };
    }, [clearTimeoutIfAny]);
    const onUserInput = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        if (holdUntilInputRef.current) {
            holdUntilInputRef.current = false;
            clearTimeoutIfAny();
            setLines([]);
        }
    }, [clearTimeoutIfAny]);
    const linger = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((ms) => {
        clearTimeoutIfAny();
        if (lines.length === 0)
            return;
        timeoutRef.current = setTimeout(() => {
            setLines([]);
            timeoutRef.current = null;
            _debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog === null || _debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog === void 0 ? void 0 : (0,_debug_js__WEBPACK_IMPORTED_MODULE_2__.debugLog)("ephemeral.linger.clear");
        }, Math.max(0, ms | 0));
    }, [clearTimeoutIfAny, lines.length]);
    // Public API aligns with orchestrator semantics
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({
        lines,
        set,
        clear,
        preserveNextClear,
        normalize,
        onUserInput,
        linger,
    }), [lines, set, clear, preserveNextClear, normalize, onUserInput, linger]);
}


/***/ }),

/***/ "./src/hooks/prompt/use-prompt-history.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  a: () => (/* binding */ usePromptHistory)
});

// EXTERNAL MODULE: ../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js
var react = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
// EXTERNAL MODULE: ./src/debug.ts + 1 modules
var debug = __webpack_require__("./src/debug.ts");
// EXTERNAL MODULE: external "node:fs"
var external_node_fs_ = __webpack_require__("node:fs");
// EXTERNAL MODULE: external "node:os"
var external_node_os_ = __webpack_require__("node:os");
// EXTERNAL MODULE: external "node:path"
var external_node_path_ = __webpack_require__("node:path");
// EXTERNAL MODULE: ./src/utils/characters.ts
var characters = __webpack_require__("./src/utils/characters.ts");
;// ./src/history/prompt-history.ts
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




const MAX_HISTORY_LENGTH = 500;
// Sanitization helpers are shared from ../utils/characters.ts
function getHistoryFilePath() {
    const currentPlatform = (0,external_node_os_.platform)();
    switch (currentPlatform) {
        case "win32": {
            const appData = process.env.APPDATA || (0,external_node_path_.join)((0,external_node_os_.homedir)(), "AppData", "Roaming");
            return (0,external_node_path_.join)(appData, "Cursor", "prompt_history.json");
        }
        case "darwin":
            return (0,external_node_path_.join)((0,external_node_os_.homedir)(), ".cursor", "prompt_history.json");
        default: {
            const configDir = process.env.XDG_CONFIG_HOME || (0,external_node_path_.join)((0,external_node_os_.homedir)(), ".config");
            return (0,external_node_path_.join)(configDir, "cursor", "prompt_history.json");
        }
    }
}
function ensureDirExists(filePath) {
    return __awaiter(this, void 0, void 0, function* () {
        const dir = (0,external_node_path_.dirname)(filePath);
        try {
            yield external_node_fs_.promises.mkdir(dir, { recursive: true });
        }
        catch (_err) {
            // ignore
        }
    });
}
function loadHistory() {
    return __awaiter(this, void 0, void 0, function* () {
        const path = getHistoryFilePath();
        try {
            const data = yield external_node_fs_.promises.readFile(path, "utf8");
            const parsed = JSON.parse(data);
            if (Array.isArray(parsed)) {
                const listRaw = parsed.filter(v => typeof v === "string");
                const seen = new Set();
                const sanitized = [];
                for (const item of listRaw) {
                    const clean = (0,characters/* sanitizeForHistory */.p3)(item);
                    if (clean.length === 0)
                        continue;
                    if (seen.has(clean))
                        continue;
                    seen.add(clean);
                    sanitized.push(clean);
                }
                return sanitized.slice(0, MAX_HISTORY_LENGTH);
            }
            return [];
        }
        catch (_err) {
            return [];
        }
    });
}
function saveHistory(items) {
    return __awaiter(this, void 0, void 0, function* () {
        const path = getHistoryFilePath();
        yield ensureDirExists(path);
        // Ensure all items are sanitized before persisting
        const seen = new Set();
        const list = [];
        for (const item of items) {
            const clean = (0,characters/* sanitizeForHistory */.p3)(item);
            if (clean.length === 0)
                continue;
            if (seen.has(clean))
                continue;
            seen.add(clean);
            list.push(clean);
            if (list.length >= MAX_HISTORY_LENGTH)
                break;
        }
        const payload = JSON.stringify(list, null, 2);
        yield external_node_fs_.promises.writeFile(path, payload, "utf8");
    });
}
function addToHistory(entryRaw) {
    return __awaiter(this, void 0, void 0, function* () {
        const entry = (0,characters/* sanitizeForHistory */.p3)(entryRaw);
        if (entry.length === 0)
            return yield loadHistory();
        let items = yield loadHistory();
        // Remove existing occurrences (dedup), then unshift to front (MRU order)
        items = items.filter(e => e !== entry);
        items.unshift(entry);
        if (items.length > MAX_HISTORY_LENGTH)
            items = items.slice(0, MAX_HISTORY_LENGTH);
        yield saveHistory(items);
        return items;
    });
}
function clearHistory() {
    return __awaiter(this, void 0, void 0, function* () {
        const before = yield loadHistory();
        yield saveHistory([]);
        return before.length;
    });
}

;// ./src/hooks/prompt/use-prompt-history.ts
var use_prompt_history_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



function usePromptHistory() {
    const [items, setItems] = (0,react.useState)([]);
    const [index, setIndex] = (0,react.useState)(null);
    const draftRef = (0,react.useRef)("");
    (0,react.useEffect)(() => {
        (() => use_prompt_history_awaiter(this, void 0, void 0, function* () {
            try {
                const loaded = yield loadHistory();
                setItems(loaded);
            }
            catch (err) {
                debug.debugLog === null || debug.debugLog === void 0 ? void 0 : (0,debug.debugLog)("history.init.error", String(err));
            }
        }))();
    }, []);
    const begin = (0,react.useCallback)((currentValue) => {
        if (items.length === 0)
            return null;
        if (index != null)
            return null;
        draftRef.current = currentValue;
        setIndex(0);
        const selected = items[0];
        return selected !== null && selected !== void 0 ? selected : null;
    }, [items, index]);
    const up = (0,react.useCallback)(() => {
        var _a;
        if (items.length === 0)
            return null;
        const next = Math.min(items.length - 1, (index !== null && index !== void 0 ? index : 0) + 1);
        setIndex(next);
        return (_a = items[next]) !== null && _a !== void 0 ? _a : null;
    }, [items, index]);
    const down = (0,react.useCallback)((currentValue) => {
        var _a;
        if (index == null)
            return null;
        const next = index - 1;
        if (next >= 0) {
            setIndex(next);
            return { value: (_a = items[next]) !== null && _a !== void 0 ? _a : currentValue, exited: false };
        }
        setIndex(null);
        return { value: draftRef.current, exited: true };
    }, [index, items]);
    const record = (0,react.useCallback)((submitted) => use_prompt_history_awaiter(this, void 0, void 0, function* () {
        try {
            const newItems = yield addToHistory(submitted);
            setItems(newItems);
            setIndex(null);
            draftRef.current = "";
        }
        catch (err) {
            debug.debugLog === null || debug.debugLog === void 0 ? void 0 : (0,debug.debugLog)("history.add.error", String(err));
        }
    }), []);
    const reset = (0,react.useCallback)(() => {
        setIndex(null);
        draftRef.current = "";
    }, []);
    const resetForSlash = (0,react.useCallback)(() => {
        setIndex(null);
        draftRef.current = "";
    }, []);
    const clearAllLocal = (0,react.useCallback)(() => {
        setItems([]);
        setIndex(null);
        draftRef.current = "";
    }, []);
    return (0,react.useMemo)(() => ({
        items,
        index,
        inHistory: index != null,
        draftBeforeHistory: draftRef.current,
        begin,
        up,
        down,
        record,
        reset,
        resetForSlash,
        clearAllLocal,
    }), [items, index, begin, up, down, record, reset, resetForSlash, clearAllLocal]);
}


/***/ }),

/***/ "./src/hooks/prompt/use-slash-palette.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   e: () => (/* binding */ useSlashPalette)
/* harmony export */ });
/* harmony import */ var _anysphere_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../context/dist/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _utils_error_info_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/utils/error-info.ts");
/* harmony import */ var _utils_fuzzy_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/utils/fuzzy.ts");
/* harmony import */ var _use_windowed_nav_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/hooks/prompt/use-windowed-nav.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





function useSlashPalette(value, slashCommands, helpers) {
    const [items, setItems] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
    const [active, setActive] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [suppressed, setSuppressed] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const nav = (0,_use_windowed_nav_js__WEBPACK_IMPORTED_MODULE_2__/* .useWindowedNav */ .m)(6);
    const abortRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    const lastValueRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(value);
    const [inlineMode, setInlineMode] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)({ kind: "none" });
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        var _a, _b, _c, _d;
        const changed = value !== lastValueRef.current;
        lastValueRef.current = value;
        const ctx = (0,_anysphere_context__WEBPACK_IMPORTED_MODULE_0__/* .createContext */ .q6)();
        // Detect inline trailing "/..." after normal text, e.g., "hello /shell"
        const inlineMatch = /^(.*?)(\s+)\/(\S*)$/.exec(value);
        if (inlineMatch) {
            const prefix = (_a = inlineMatch[1]) !== null && _a !== void 0 ? _a : "";
            const fragment = (_b = inlineMatch[3]) !== null && _b !== void 0 ? _b : "";
            setInlineMode({ kind: "trailing", promptPrefix: prefix, fragment });
        }
        else {
            setInlineMode({ kind: "none" });
        }
        const isInline = inlineMatch != null;
        if (!value.startsWith("/") && !isInline) {
            if (items.length !== 0)
                setItems([]);
            nav.setLength(0);
            setActive(prev => (prev ? false : prev));
            if (suppressed)
                setSuppressed(false);
            return;
        }
        // If palette was suppressed (hidden), re-enable it once the input changes again
        if (suppressed) {
            if (changed) {
                setSuppressed(false);
            }
            else {
                if (items.length !== 0)
                    setItems([]);
                nav.setLength(0);
                setActive(prev => (prev ? false : prev));
                return;
            }
        }
        const term = isInline ? inlineMatch[3] : value.slice(1);
        const partsRaw = term.split(/\s+/);
        const parts = term.length === 0
            ? []
            : partsRaw.filter((p, i) => !(p === "" && i === partsRaw.length - 1 && !term.endsWith(" ")));
        const commandFragment = (_c = parts[0]) !== null && _c !== void 0 ? _c : "";
        const makeItemsForCommandList = () => __awaiter(this, void 0, void 0, function* () {
            const fragment = commandFragment;
            // If exact command, prefetch args suggestions
            const fragmentLower = fragment.toLowerCase();
            const exact = fragment
                ? slashCommands.find(c => c.id.toLowerCase() === fragmentLower)
                : undefined;
            if (exact === null || exact === void 0 ? void 0 : exact.getArgSuggestions) {
                const argSuggestions = yield exact.getArgSuggestions(ctx, [], helpers);
                if (argSuggestions && argSuggestions.length > 0) {
                    return argSuggestions.map(s => ({
                        identifier: s.value,
                        label: s.value,
                        description: s.description || "",
                        args: [],
                        parentCommandId: exact.id,
                        isArgSuggestion: true,
                    }));
                }
            }
            const pool = isInline
                ? slashCommands.filter(c => c.inline)
                : slashCommands;
            const scored = pool
                .map((c, index) => {
                const text = `${c.id} ${c.title} ${c.description || ""}`;
                let score = fragment ? (0,_utils_fuzzy_js__WEBPACK_IMPORTED_MODULE_3__/* .fuzzyScore */ .dt)(text, fragment) : 1;
                // Heavily prioritize commands that start with the fragment
                if (fragment &&
                    c.id.toLowerCase().startsWith(fragment.toLowerCase())) {
                    score += 1000; // Large bonus for prefix match
                }
                // Boost commands when users type any of their alternative names (boostedAlts)
                if (fragment && c.boostedAlts) {
                    const fragmentLower = fragment.toLowerCase();
                    const matchesAlt = c.boostedAlts.some(alt => fragmentLower === alt.toLowerCase() ||
                        fragmentLower.startsWith(alt.toLowerCase()) ||
                        alt.toLowerCase().includes(fragmentLower));
                    if (matchesAlt) {
                        score += 1500; // Higher than prefix match to ensure it appears at top
                    }
                }
                return { c, score, originalIndex: index };
            })
                .filter(x => (fragment ? x.score > 0 : true))
                .sort((a, b) => {
                if (fragment) {
                    // When searching, sort by score then alphabetically
                    return b.score - a.score || a.c.id.localeCompare(b.c.id);
                }
                else {
                    // When no search query, preserve original order
                    return a.originalIndex - b.originalIndex;
                }
            });
            return scored.map(({ c }) => ({
                identifier: c.id,
                label: c.title,
                description: c.description || "",
                args: (c.args || []).map(a => ({
                    identifier: a.id,
                    required: a.required,
                })),
                inline: c.inline,
            }));
        });
        const makeItemsForArgs = () => __awaiter(this, void 0, void 0, function* () {
            const target = slashCommands.find(c => c.id.toLowerCase() === commandFragment.toLowerCase());
            if (!target)
                return [];
            const argInput = parts.slice(1);
            if (target.getArgSuggestions) {
                const suggestions = yield target.getArgSuggestions(ctx, argInput, helpers);
                if (suggestions && suggestions.length > 0) {
                    return suggestions.map(s => ({
                        identifier: s.value,
                        label: s.value,
                        description: s.description || "",
                        args: [],
                        parentCommandId: target.id,
                        isArgSuggestion: true,
                    }));
                }
            }
            // Fallback: show required/optional arg placeholders when no dynamic suggestions
            const placeholders = (target.args || []).slice(argInput.length);
            return placeholders.map(a => ({
                identifier: a.id,
                label: a.id,
                description: a.required === false ? "optional" : "required",
                args: [],
                parentCommandId: target.id,
                isArgSuggestion: true,
            }));
        });
        // Abort previous async operations
        (_d = abortRef.current) === null || _d === void 0 ? void 0 : _d.abort();
        const controller = new AbortController();
        abortRef.current = controller;
        const updateItems = () => __awaiter(this, void 0, void 0, function* () {
            let nextItems = [];
            if (parts.length <= 1 || (parts.length === 1 && !term.endsWith(" "))) {
                nextItems = yield makeItemsForCommandList();
            }
            else {
                nextItems = yield makeItemsForArgs();
            }
            // Check if the operation was aborted
            if (controller.signal.aborted)
                return;
            if (nextItems.length !== items.length ||
                nextItems.some((it, i) => {
                    var _a, _b;
                    return it.identifier !== ((_a = items[i]) === null || _a === void 0 ? void 0 : _a.identifier) ||
                        it.parentCommandId !== ((_b = items[i]) === null || _b === void 0 ? void 0 : _b.parentCommandId);
                })) {
                setItems(nextItems);
            }
            nav.setLength(nextItems.length);
            const visible = nextItems.length > 0;
            setActive(prev => (prev !== visible ? visible : prev));
            if (visible && changed)
                nav.reset();
        });
        updateItems();
    }, [
        value,
        slashCommands,
        suppressed,
        helpers,
        items,
        nav.reset,
        nav.setLength,
    ]);
    const acceptExpansion = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((input) => {
        var _a, _b;
        if (!active || items.length === 0)
            return null;
        // Accept both inline and leading slash modes
        const trailing = inlineMode.kind === "trailing";
        const afterSlash = trailing
            ? inlineMode.fragment
            : input.startsWith("/")
                ? input.slice(1)
                : "";
        if (!trailing && !input.startsWith("/"))
            return null;
        const hasSpace = afterSlash.includes(" ");
        const endsWithSpace = (trailing ? input : input).endsWith(" ");
        const chosen = items[nav.index];
        if (!chosen)
            return null;
        if (!hasSpace) {
            if (chosen.isArgSuggestion && chosen.parentCommandId) {
                if (trailing) {
                    return `${inlineMode.promptPrefix} /${chosen.parentCommandId} ${chosen.identifier} `;
                }
                return `/${chosen.parentCommandId} ${chosen.identifier} `;
            }
            const expandedCore = `/${chosen.identifier}${chosen.args.length > 0 ? " " : ""}`;
            const expanded = trailing
                ? `${inlineMode.promptPrefix} ${expandedCore}`
                : expandedCore;
            return expanded !== input ? expanded : null;
        }
        const parts = afterSlash.split(/\s+/);
        if (parts.length >= 2) {
            const nonEmptyParts = afterSlash.split(/\s+/).filter(Boolean);
            const lastNonEmpty = (_a = nonEmptyParts[nonEmptyParts.length - 1]) !== null && _a !== void 0 ? _a : "";
            const chosenId = chosen.identifier;
            if (endsWithSpace) {
                // Determine target command and whether more args are expected
                const cmdId = (_b = parts[0]) !== null && _b !== void 0 ? _b : "";
                const target = slashCommands.find(c => c.id.toLowerCase() === cmdId.toLowerCase());
                const definedArgsCount = (target === null || target === void 0 ? void 0 : target.args)
                    ? target.args.length
                    : undefined;
                const typedArgsCount = Math.max(0, nonEmptyParts.length - 1);
                const shouldReplace = !target ||
                    definedArgsCount == null ||
                    typedArgsCount >= definedArgsCount;
                if (shouldReplace) {
                    if (trailing) {
                        return `${inlineMode.promptPrefix} /${chosenId} `;
                    }
                    const trimmed = input.trimEnd();
                    const lastSpace = trimmed.lastIndexOf(" ");
                    const prefix = lastSpace >= 0 ? trimmed.slice(0, lastSpace + 1) : "";
                    return `${prefix}${chosenId} `;
                }
                else {
                    if (lastNonEmpty === chosenId)
                        return null;
                    if (trailing) {
                        return `${input}${chosenId} `;
                    }
                    return `${input}${chosenId} `;
                }
            }
            // Replace the last token
            const lastSpace = input.lastIndexOf(" ");
            const currentLast = lastSpace >= 0 ? input.slice(lastSpace + 1) : input;
            if (currentLast === chosenId) {
                // Already selected; just ensure trailing space
                return input.endsWith(" ") ? null : `${input} `;
            }
            const prefix = lastSpace >= 0 ? input.slice(0, lastSpace + 1) : "";
            return `${prefix}${chosenId} `;
        }
        return null;
    }, [active, items, nav.index, slashCommands, inlineMode]);
    const runIfExecutable = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((input, commands, env, setQuitting, setUnknown) => __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e;
        // Support both pure slash and inline trailing slash
        let promptPrefix = "";
        let term;
        if (input.startsWith("/")) {
            term = input.slice(1);
        }
        else {
            const m = /^(.*?)(\s+)\/(\S.*)$/.exec(input);
            if (!m)
                return "not-a-command";
            promptPrefix = ((_a = m[1]) !== null && _a !== void 0 ? _a : "").trimEnd();
            term = (_b = m[3]) !== null && _b !== void 0 ? _b : "";
        }
        const parts = term.split(/\s+/).filter(Boolean);
        const cmdId = parts[0] || "";
        if (!cmdId)
            return "not-a-command";
        const args = parts.slice(1);
        // If inline, limit to inline-capable commands
        const pool = promptPrefix ? commands.filter(c => c.inline) : commands;
        const cmd = pool.find(c => c.id.toLowerCase() === cmdId.toLowerCase());
        if (!cmd) {
            if (promptPrefix) {
                // For inline trailing commands, let the normal message submission proceed
                return "not-a-command";
            }
            setUnknown === null || setUnknown === void 0 ? void 0 : setUnknown(cmdId);
            return "unknown";
        }
        if (!cmd.run)
            return "handled"; // nothing to do
        const requiredArgs = (cmd.args || []).filter(a => a.required !== false);
        if (args.length < requiredArgs.length)
            return "handled"; // wait for more args
        if (cmdId.toLowerCase() === "quit")
            setQuitting === null || setQuitting === void 0 ? void 0 : setQuitting(true);
        (_c = abortRef.current) === null || _c === void 0 ? void 0 : _c.abort();
        const controller = new AbortController();
        abortRef.current = controller;
        const [ctx, cancel] = (0,_anysphere_context__WEBPACK_IMPORTED_MODULE_0__/* .createContext */ .q6)().withCancel();
        controller.signal.addEventListener("abort", cancel);
        try {
            yield cmd.run(ctx, args, {
                onModelChange: env.onModelChange,
                insertText: txt => {
                    if (controller.signal.aborted)
                        return;
                    if (promptPrefix) {
                        // For inline commands, decide what to insert:
                        // - If the command provided text (e.g., /shell <cmd>), use that
                        // - Otherwise, use the original prefix before the inline slash
                        const content = txt && txt.length > 0 ? txt : promptPrefix;
                        env.insertText(content);
                    }
                    else {
                        env.insertText(txt);
                    }
                },
                clearInput: () => {
                    var _a;
                    if (controller.signal.aborted)
                        return;
                    (_a = env.clearInput) === null || _a === void 0 ? void 0 : _a.call(env);
                },
                enterShellMode: () => { var _a; return (_a = env.enterShellMode) === null || _a === void 0 ? void 0 : _a.call(env); },
                print: (lines, options) => {
                    var _a;
                    if (controller.signal.aborted)
                        return;
                    (_a = env.print) === null || _a === void 0 ? void 0 : _a.call(env, lines, options);
                },
                exit: (isLogout) => { var _a; return (_a = env.exit) === null || _a === void 0 ? void 0 : _a.call(env, isLogout); },
                onHistoryCleared: () => { var _a; return (_a = env.onHistoryCleared) === null || _a === void 0 ? void 0 : _a.call(env); },
                onResumeChat: env.onResumeChat,
                getChatId: env.getChatId,
                logout: env.logout,
                onNewChat: env.onNewChat,
                onSummarize: env.onSummarize,
                submitMessage: env.submitMessage,
            });
        }
        catch (err) {
            // Render a friendly, single-line error in the palette instead of letting
            // the rejection bubble to the global handler, which would show a stack.
            if (!controller.signal.aborted) {
                const { message } = (0,_utils_error_info_js__WEBPACK_IMPORTED_MODULE_4__/* .extractErrorInfo */ .q)(err);
                (_d = env.print) === null || _d === void 0 ? void 0 : _d.call(env, [[{ text: `Error: ${message}`, color: "red" }]]);
                (_e = env.clearInput) === null || _e === void 0 ? void 0 : _e.call(env);
            }
        }
        finally {
            if (abortRef.current === controller)
                abortRef.current = null;
        }
        return "handled";
    }), []);
    const hide = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
        setSuppressed(true);
        setActive(false);
    }, []);
    // cleanup
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        return () => {
            var _a;
            (_a = abortRef.current) === null || _a === void 0 ? void 0 : _a.abort();
        };
    }, []);
    return (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => ({
        active,
        items,
        index: nav.index,
        windowStart: nav.windowStart,
        next: nav.next,
        prev: nav.prev,
        reset: nav.reset,
        acceptExpansion,
        runIfExecutable,
        hide,
    }), [
        active,
        items,
        nav.index,
        nav.windowStart,
        nav.next,
        nav.prev,
        nav.reset,
        acceptExpansion,
        runIfExecutable,
        hide,
    ]);
}


/***/ }),

/***/ "./src/hooks/prompt/use-windowed-nav.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: () => (/* binding */ useWindowedNav)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");

function useWindowedNav(windowSize = 6) {
    const [index, setIndex] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
    const [windowStart, setWindowStart] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
    const [length, setLengthState] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
    const clampWindowStart = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((start, len) => {
        const maxStart = Math.max(0, len - windowSize);
        if (start > maxStart)
            return maxStart;
        if (start < 0)
            return 0;
        return start;
    }, [windowSize]);
    const setLength = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((len) => {
        setLengthState(prevLen => {
            if (len === prevLen)
                return prevLen;
            setIndex(prev => (len === 0 ? 0 : Math.min(prev, len - 1)));
            setWindowStart(prev => clampWindowStart(prev, len));
            return len;
        });
    }, [clampWindowStart]);
    const next = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        if (length === 0)
            return;
        setIndex(prev => {
            const nextIdx = (prev + 1) % length;
            setWindowStart(start => {
                if (length <= windowSize)
                    return 0;
                let s = start;
                if (nextIdx < prev) {
                    s = 0; // wrap to top
                }
                else if (nextIdx - s >= windowSize - 1) {
                    s = nextIdx - (windowSize - 2);
                }
                return clampWindowStart(s, length);
            });
            return nextIdx;
        });
    }, [length, windowSize, clampWindowStart]);
    const prev = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        if (length === 0)
            return;
        setIndex(prevIdx => {
            const nextIdx = (prevIdx - 1 + length) % length;
            setWindowStart(start => {
                if (length <= windowSize)
                    return 0;
                let s = start;
                if (nextIdx > prevIdx) {
                    s = Math.max(0, length - windowSize); // wrap to bottom
                }
                else if (nextIdx - s <= 0) {
                    s = Math.max(0, nextIdx - 1);
                }
                return clampWindowStart(s, length);
            });
            return nextIdx;
        });
    }, [length, windowSize, clampWindowStart]);
    const reset = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
        setIndex(0);
        setWindowStart(0);
    }, []);
    const page = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((_pageSize = windowSize) => {
        return { visibleStart: windowStart, highlight: index - windowStart };
    }, [index, windowStart, windowSize]);
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ index, windowStart, setLength, next, prev, reset, page }), [index, windowStart, setLength, next, prev, reset, page]);
}


/***/ }),

/***/ "./src/hooks/use-attach-background-composer.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  n: () => (/* binding */ useAttachBackgroundComposer)
});

// EXTERNAL MODULE: external "node:crypto"
var external_node_crypto_ = __webpack_require__("node:crypto");
// EXTERNAL MODULE: ../proto/dist/generated/aiserver/v1/background_composer_pb.js + 5 modules
var background_composer_pb = __webpack_require__("../proto/dist/generated/aiserver/v1/background_composer_pb.js");
// EXTERNAL MODULE: ../proto/dist/generated/aiserver/v1/tools_pb.js
var tools_pb = __webpack_require__("../proto/dist/generated/aiserver/v1/tools_pb.js");
// EXTERNAL MODULE: ../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js
var react = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
// EXTERNAL MODULE: ./src/constants.ts
var constants = __webpack_require__("./src/constants.ts");
// EXTERNAL MODULE: ./src/debug.ts + 1 modules
var debug = __webpack_require__("./src/debug.ts");
;// ./src/utils/background-diffs.ts
function isRecord(value) {
    return typeof value === "object" && value !== null;
}
function _getStringField(obj, key) {
    const v = obj[key];
    return typeof v === "string" ? v : undefined;
}
function _getFirstArray(obj, keys) {
    for (const k of keys) {
        const v = obj[k];
        if (Array.isArray(v))
            return v;
    }
    return [];
}
/**
 * Convert Background Composer optimized diffs into the UI's FileChange[] shape.
 *
 * Notes (assumptions):
 * - Prefer a canonical shape of: { files: [{ path, before, after }] }
 * - Gracefully tolerate alternate field names that may appear in older/newer versions
 *   without guessing or coercing non-strings.
 */
function mapBackgroundDiffsToFileChanges(resp) {
    var _a, _b, _c, _d, _e;
    if (!isRecord(resp))
        return [];
    // Collect top-level diffs (not in submodules)
    const topLevelDiffs = (_c = (_b = (_a = resp.diff) === null || _a === void 0 ? void 0 : _a.diffs) === null || _b === void 0 ? void 0 : _b.map((d) => {
        var _a, _b, _c, _d;
        return ({
            path: (_b = (_a = d.to) !== null && _a !== void 0 ? _a : d.from) !== null && _b !== void 0 ? _b : "",
            before: (_c = d.beforeFileContents) !== null && _c !== void 0 ? _c : undefined,
            after: (_d = d.afterFileContents) !== null && _d !== void 0 ? _d : undefined,
        });
    })) !== null && _c !== void 0 ? _c : [];
    // Collect submodule diffs, prefixing with submodule relative path
    const submoduleDiffs = (_e = (_d = resp.submoduleDiffs) === null || _d === void 0 ? void 0 : _d.flatMap(submod => {
        var _a;
        if (!((_a = submod.diff) === null || _a === void 0 ? void 0 : _a.diffs) ||
            typeof submod.relativePath !== "string" ||
            submod.relativePath.length === 0) {
            return [];
        }
        return submod.diff.diffs.map((d) => {
            var _a, _b, _c, _d;
            // Ensure no double slash, handle leading/trailing slashes
            const subPath = (_b = (_a = d.to) !== null && _a !== void 0 ? _a : d.from) !== null && _b !== void 0 ? _b : "";
            const prefix = submod.relativePath.replace(/\/+$/, "");
            const filePath = subPath.startsWith("/")
                ? `${prefix}${subPath}`
                : `${prefix}/${subPath}`;
            return {
                path: filePath,
                before: (_c = d.beforeFileContents) !== null && _c !== void 0 ? _c : undefined,
                after: (_d = d.afterFileContents) !== null && _d !== void 0 ? _d : undefined,
            };
        });
    })) !== null && _e !== void 0 ? _e : [];
    return [...topLevelDiffs, ...submoduleDiffs];
}

;// ./src/hooks/use-attach-background-composer.ts
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __asyncValues = (undefined && undefined.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};







function useAttachBackgroundComposer(client, bcId) {
    const [responses, setResponses] = (0,react.useState)({
        bubbles: [],
    });
    const [status, setStatus] = (0,react.useState)(background_composer_pb/* BackgroundComposerStatus */.R6.UNSPECIFIED);
    const [isAttached, setIsAttached] = (0,react.useState)(false);
    const [isLoadingConversation, setIsLoadingConversation] = (0,react.useState)(false);
    const [error, setError] = (0,react.useState)(undefined);
    const [modelDetails, setModelDetails] = (0,react.useState)(undefined);
    const [branchName, setBranchName] = (0,react.useState)(undefined);
    const [repoUrl, setRepoUrl] = (0,react.useState)(undefined);
    const currentHash = (0,react.useRef)(undefined);
    const [diffs, setDiffs] = (0,react.useState)(undefined);
    // Start with loading=false; only show when we actually fetch diffs
    const [isLoadingDiffs, setIsLoadingDiffs] = (0,react.useState)(false);
    const hasLoadedDiffsRef = (0,react.useRef)(false);
    // Only begin fetching diffs after we observe an edit tool
    const shouldFetchDiffsRef = (0,react.useRef)(false);
    const abortControllerRef = (0,react.useRef)(null);
    const isRunningRef = (0,react.useRef)(false);
    // Track current status and polling state for periodic status pulls
    const statusRef = (0,react.useRef)(background_composer_pb/* BackgroundComposerStatus */.R6.UNSPECIFIED);
    const isPollingRef = (0,react.useRef)(false);
    const isPollingDiffsRef = (0,react.useRef)(false);
    const fetchDiffs = (0,react.useCallback)(() => __awaiter(this, void 0, void 0, function* () {
        if (!bcId) {
            // Ensure loading state is not stuck when bcId is missing
            return;
        }
        try {
            if (!hasLoadedDiffsRef.current)
                setIsLoadingDiffs(true);
            const resp = yield client.getOptimizedDiffDetails({ bcId });
            const mappedDiffs = mapBackgroundDiffsToFileChanges(resp);
            setDiffs(mappedDiffs);
            hasLoadedDiffsRef.current = true;
        }
        catch (e) {
            (0,debug.debugLog)("Error fetching diffs", e);
        }
        finally {
            // We attempted a fetch; turn off loading indicator regardless of result
            setIsLoadingDiffs(false);
        }
    }), [client, bcId]);
    const fetchHashAndMaybeUpdateDiffs = (0,react.useCallback)(() => __awaiter(this, void 0, void 0, function* () {
        if (!bcId) {
            // Ensure loading state is not stuck when bcId is missing
            return;
        }
        // Do not fetch diffs until we have seen an edit operation
        if (!shouldFetchDiffsRef.current) {
            setIsLoadingDiffs(false);
            return;
        }
        try {
            const newHash = yield client.getBackgroundComposerChangesHash({ bcId });
            if (newHash.hash !== currentHash.current) {
                currentHash.current = newHash.hash;
                yield fetchDiffs();
            }
        }
        finally {
            // First hash poll counts as an attempt; disable loading spinner
            setIsLoadingDiffs(false);
        }
    }), [client, bcId, fetchDiffs]);
    (0,react.useEffect)(() => {
        if (!bcId)
            return;
        const id = setInterval(() => {
            if (isPollingDiffsRef.current)
                return;
            isPollingDiffsRef.current = true;
            void fetchHashAndMaybeUpdateDiffs().finally(() => {
                isPollingDiffsRef.current = false;
            });
        }, constants/* BACKGROUND_COMPOSER_DIFFS_POLL_INTERVAL_MS */.Ep);
        return () => clearInterval(id);
    }, [fetchHashAndMaybeUpdateDiffs, bcId]);
    const attach = (0,react.useCallback)((bcId) => __awaiter(this, void 0, void 0, function* () {
        var _a, e_1, _b, _c;
        var _d, _e, _f, _g, _h, _j, _k, _l, _m;
        if (isRunningRef.current)
            return;
        isRunningRef.current = true;
        setError(undefined);
        const abortController = new AbortController();
        abortControllerRef.current = abortController;
        try {
            let startIndex = 0;
            // Fetch existing conversation and details in parallel
            try {
                setIsLoadingConversation(true);
                const [fetchedRes, detailedRes] = yield Promise.allSettled([
                    client.fetchBackgroundComposer({ bcId }),
                    client.listDetailedBackgroundComposers({ bcId, n: 1 }),
                ]);
                const fetched = fetchedRes.status === "fulfilled" ? fetchedRes.value : undefined;
                const detailed = detailedRes.status === "fulfilled" ? detailedRes.value : undefined;
                if (detailedRes.status === "rejected") {
                    (0,debug.debugLog)("Failed to fetch detailed background composers", bcId);
                }
                else {
                    (0,debug.debugLogJSON)("detailed", detailed);
                    const first = (_d = detailed === null || detailed === void 0 ? void 0 : detailed.composers) === null || _d === void 0 ? void 0 : _d[0];
                    if (first) {
                        setModelDetails(first.modelDetails);
                        setBranchName((_e = first.composer) === null || _e === void 0 ? void 0 : _e.branchName);
                        setRepoUrl((_f = first.composer) === null || _f === void 0 ? void 0 : _f.repoUrl);
                    }
                }
                setResponses({ bubbles: [] });
                if (((_h = (_g = detailed === null || detailed === void 0 ? void 0 : detailed.composers) === null || _g === void 0 ? void 0 : _g[0]) === null || _h === void 0 ? void 0 : _h.prompt) &&
                    fetched &&
                    !((_k = (_j = fetched.responses) === null || _j === void 0 ? void 0 : _j[0]) === null || _k === void 0 ? void 0 : _k.humanMessage)) {
                    setResponses({
                        bubbles: [
                            {
                                type: "user",
                                isDone: true,
                                text: detailed.composers[0].prompt.text,
                                richText: detailed.composers[0].prompt.richText,
                                isOptimistic: false,
                            },
                        ],
                    });
                }
                if ((fetched === null || fetched === void 0 ? void 0 : fetched.responses) && fetched.responses.length > 0) {
                    // Process sequentially to preserve chunk semantics
                    for (const r of fetched.responses) {
                        // refetch diffs if tool = edit
                        const tool = (_l = r.toolCall) === null || _l === void 0 ? void 0 : _l.tool;
                        if (tool === tools_pb/* ClientSideToolV2 */.XaY.EDIT_FILE ||
                            tool === tools_pb/* ClientSideToolV2 */.XaY.EDIT_FILE_V2) {
                            // Enable diff fetching only after we observe an edit
                            shouldFetchDiffsRef.current = true;
                            void fetchHashAndMaybeUpdateDiffs();
                        }
                        handleChunk(r, setResponses);
                    }
                    startIndex = fetched.responses.length;
                }
            }
            catch (_o) {
                // Non-fatal; proceed to attach
                (0,debug.debugLog)("Failed to fetch background composer", bcId);
            }
            finally {
                setIsLoadingConversation(false);
            }
            setIsAttached(true);
            const request = new background_composer_pb/* AttachBackgroundComposerRequest */.R3({
                bcId,
                startingIndex: startIndex,
            });
            const stream = client.attachBackgroundComposer(request, {
                signal: abortController.signal,
            });
            try {
                for (var _p = true, stream_1 = __asyncValues(stream), stream_1_1; stream_1_1 = yield stream_1.next(), _a = stream_1_1.done, !_a; _p = true) {
                    _c = stream_1_1.value;
                    _p = false;
                    const message = _c;
                    if (message.statusUpdate !== undefined &&
                        message.statusUpdate !== background_composer_pb/* BackgroundComposerStatus */.R6.UNSPECIFIED) {
                        setStatus(message.statusUpdate);
                    }
                    if (message.headlessAgenticComposerResponse) {
                        const tool = (_m = message.headlessAgenticComposerResponse.toolCall) === null || _m === void 0 ? void 0 : _m.tool;
                        if (tool === tools_pb/* ClientSideToolV2 */.XaY.EDIT_FILE ||
                            tool === tools_pb/* ClientSideToolV2 */.XaY.EDIT_FILE_V2) {
                            // Enable diff fetching only after we observe an edit
                            shouldFetchDiffsRef.current = true;
                            void fetchHashAndMaybeUpdateDiffs();
                        }
                        handleChunk(message.headlessAgenticComposerResponse, setResponses);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (!_p && !_a && (_b = stream_1.return)) yield _b.call(stream_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        catch (e) {
            const message = e instanceof Error
                ? e.message
                : typeof e === "string"
                    ? e
                    : JSON.stringify(e);
            (0,debug.debugLog)("Error attaching background composer", bcId, message);
            setError(message);
        }
        finally {
            setIsAttached(false);
            isRunningRef.current = false;
        }
    }), [client, fetchHashAndMaybeUpdateDiffs]);
    // Auto attach on mount and bcId changes
    (0,react.useEffect)(() => {
        // Reset state when bcId changes (including clearing to null)
        setResponses({ bubbles: [] });
        setStatus(background_composer_pb/* BackgroundComposerStatus */.R6.UNSPECIFIED);
        setIsAttached(false);
        setError(undefined);
        setDiffs(undefined);
        hasLoadedDiffsRef.current = false;
        currentHash.current = undefined;
        // Reset diff loading state; do not show a spinner by default
        setIsLoadingDiffs(false);
        // Do not fetch diffs until we observe an edit operation
        shouldFetchDiffsRef.current = false;
        if (!bcId)
            return;
        void attach(bcId);
        // Defer diff fetching until an edit is observed
        return () => {
            var _a;
            (_a = abortControllerRef.current) === null || _a === void 0 ? void 0 : _a.abort();
            isRunningRef.current = false;
        };
    }, [attach, bcId]);
    const reconnect = (0,react.useCallback)(() => {
        var _a;
        if (!bcId)
            return;
        (_a = abortControllerRef.current) === null || _a === void 0 ? void 0 : _a.abort();
        isRunningRef.current = false;
        void attach(bcId);
    }, [attach, bcId]);
    // Keep statusRef in sync with state
    (0,react.useEffect)(() => {
        statusRef.current = status;
    }, [status]);
    // Periodically poll background composer status (best-effort) in addition to stream updates
    (0,react.useEffect)(() => {
        if (!bcId)
            return;
        let cancelled = false;
        const pollOnce = () => __awaiter(this, void 0, void 0, function* () {
            if (isPollingRef.current || cancelled)
                return;
            // Avoid polling when in terminal state
            if (statusRef.current === background_composer_pb/* BackgroundComposerStatus */.R6.FINISHED ||
                statusRef.current === background_composer_pb/* BackgroundComposerStatus */.R6.ERROR ||
                statusRef.current === background_composer_pb/* BackgroundComposerStatus */.R6.EXPIRED) {
                return;
            }
            isPollingRef.current = true;
            try {
                const resp = yield client.getBackgroundComposerStatus({ bcId });
                if (!cancelled && resp && resp.status !== undefined) {
                    setStatus(resp.status);
                }
            }
            catch (_a) {
                // ignore polling errors
            }
            finally {
                isPollingRef.current = false;
            }
        });
        // Initial poll shortly after mount/attach
        void pollOnce();
        const id = setInterval(() => {
            void pollOnce();
        }, constants/* BACKGROUND_COMPOSER_STATUS_POLL_INTERVAL_MS */.kh);
        return () => {
            cancelled = true;
            clearInterval(id);
        };
    }, [client, bcId]);
    const addOptimisticFollowup = (0,react.useCallback)((text, richText) => {
        const bubbleId = (0,external_node_crypto_.randomUUID)();
        setResponses(prev => ({
            bubbles: [
                ...prev.bubbles,
                {
                    type: "user",
                    text,
                    richText: richText !== null && richText !== void 0 ? richText : text,
                    isDone: false,
                    isOptimistic: true,
                    bubbleId,
                },
            ],
        }));
        return bubbleId;
    }, []);
    const removeOptimisticFollowup = (0,react.useCallback)((bubbleId) => {
        setResponses(prev => {
            const bubbles = prev.bubbles;
            if (bubbleId) {
                const idx = bubbles.findIndex(b => b.type === "user" && b.isOptimistic && b.bubbleId === bubbleId);
                if (idx !== -1) {
                    return {
                        bubbles: [...bubbles.slice(0, idx), ...bubbles.slice(idx + 1)],
                    };
                }
                return prev;
            }
            // Fallback: remove the last trailing optimistic user bubble
            for (let i = bubbles.length - 1; i >= 0; i--) {
                const b = bubbles[i];
                if (b.type === "user" && b.isOptimistic) {
                    return { bubbles: [...bubbles.slice(0, i), ...bubbles.slice(i + 1)] };
                }
            }
            return prev;
        });
    }, []);
    return (0,react.useMemo)(() => ({
        responses,
        status,
        isAttached,
        isLoadingConversation,
        isLoadingDiffs,
        error,
        reconnect,
        addOptimisticFollowup,
        removeOptimisticFollowup,
        modelDetails,
        branchName,
        repoUrl,
        diffs,
    }), [
        responses,
        status,
        isAttached,
        isLoadingConversation,
        isLoadingDiffs,
        error,
        reconnect,
        addOptimisticFollowup,
        removeOptimisticFollowup,
        modelDetails,
        branchName,
        repoUrl,
        diffs,
    ]);
}
function getEffectiveLength(bubbles) {
    // Ignore trailing optimistic user bubbles when inserting server updates
    let effectiveLength = bubbles.length;
    for (let i = bubbles.length - 1; i >= 0; i--) {
        const b = bubbles[i];
        if (b.type === "user" && b.isOptimistic) {
            effectiveLength = i;
        }
        else {
            break;
        }
    }
    return effectiveLength;
}
function handleChunk(chunk, setResponses) {
    var _a, _b;
    // Helper to compute effective end excluding optimistic user bubbles
    const computeEffective = (b) => getEffectiveLength(b);
    // Append or insert a new bubble at effective end
    const addNewBubble = (newBubble) => {
        setResponses(prev => {
            const effectiveLength = computeEffective(prev.bubbles);
            if (effectiveLength === prev.bubbles.length) {
                return { bubbles: [...prev.bubbles, newBubble] };
            }
            return {
                bubbles: [
                    ...prev.bubbles.slice(0, effectiveLength),
                    newBubble,
                    ...prev.bubbles.slice(effectiveLength),
                ],
            };
        });
    };
    // Thinking stream
    if (chunk.thinking) {
        setResponses(prev => {
            var _a, _b, _c, _d;
            const effectiveLength = computeEffective(prev.bubbles);
            const last = effectiveLength > 0 ? prev.bubbles[effectiveLength - 1] : undefined;
            if (last && last.type === "thinking" && !last.isDone) {
                const updated = Object.assign(Object.assign({}, last), { text: last.text + ((_b = (_a = chunk.thinking) === null || _a === void 0 ? void 0 : _a.text) !== null && _b !== void 0 ? _b : "") });
                return {
                    bubbles: [
                        ...prev.bubbles.slice(0, effectiveLength - 1),
                        updated,
                        ...prev.bubbles.slice(effectiveLength),
                    ],
                };
            }
            // create new thinking bubble
            const newBubble = {
                type: "thinking",
                text: (_d = (_c = chunk.thinking) === null || _c === void 0 ? void 0 : _c.text) !== null && _d !== void 0 ? _d : "",
                isDone: false,
                thinkingDurationMs: 0,
            };
            if (effectiveLength === prev.bubbles.length) {
                return { bubbles: [...prev.bubbles, newBubble] };
            }
            return {
                bubbles: [
                    ...prev.bubbles.slice(0, effectiveLength),
                    newBubble,
                    ...prev.bubbles.slice(effectiveLength),
                ],
            };
        });
    }
    // Thinking duration close-out
    if (chunk.thinkingDurationMs !== undefined) {
        setResponses(prev => {
            var _a;
            const effectiveLength = computeEffective(prev.bubbles);
            let lastThinkingIndex = -1;
            for (let i = effectiveLength - 1; i >= 0; i--) {
                if (((_a = prev.bubbles[i]) === null || _a === void 0 ? void 0 : _a.type) === "thinking") {
                    lastThinkingIndex = i;
                    break;
                }
            }
            if (lastThinkingIndex === -1)
                return prev;
            const updated = Object.assign(Object.assign({}, prev.bubbles[lastThinkingIndex]), { thinkingDurationMs: Number(chunk.thinkingDurationMs), isDone: true });
            return {
                bubbles: [
                    ...prev.bubbles.slice(0, lastThinkingIndex),
                    updated,
                    ...prev.bubbles.slice(lastThinkingIndex + 1),
                ],
            };
        });
    }
    // If we had an unfinished thinking and now see non-thinking, mark it done
    if (!chunk.thinking && chunk.thinkingDurationMs === undefined) {
        setResponses(prev => {
            const effectiveLength = computeEffective(prev.bubbles);
            if (effectiveLength === 0)
                return prev;
            const last = prev.bubbles[effectiveLength - 1];
            if (!(last && last.type === "thinking" && !last.isDone))
                return prev;
            const updated = Object.assign(Object.assign({}, last), { isDone: true });
            return {
                bubbles: [
                    ...prev.bubbles.slice(0, effectiveLength - 1),
                    updated,
                    ...prev.bubbles.slice(effectiveLength),
                ],
            };
        });
    }
    // Status messages
    if (chunk.status) {
        setResponses(prev => {
            const effectiveLength = computeEffective(prev.bubbles);
            const last = effectiveLength > 0 ? prev.bubbles[effectiveLength - 1] : undefined;
            const cs = chunk.status;
            if (!cs)
                return prev;
            if (!cs.isComplete && (last === null || last === void 0 ? void 0 : last.type) !== "status") {
                const newBubble = {
                    type: "status",
                    statusType: cs.type,
                    message: cs.message,
                    isDone: cs.isComplete,
                    isVisible: true,
                };
                if (effectiveLength === prev.bubbles.length) {
                    return { bubbles: [...prev.bubbles, newBubble] };
                }
                return {
                    bubbles: [
                        ...prev.bubbles.slice(0, effectiveLength),
                        newBubble,
                        ...prev.bubbles.slice(effectiveLength),
                    ],
                };
            }
            else if ((last === null || last === void 0 ? void 0 : last.type) === "status") {
                // Update status completion and potential visibility
                const updated = Object.assign(Object.assign({}, last), { isDone: cs.isComplete });
                const bubblesAfterDone = [
                    ...prev.bubbles.slice(0, effectiveLength - 1),
                    updated,
                    ...prev.bubbles.slice(effectiveLength),
                ];
                // For INDEX_SYNC, hide when done
                if (cs.type ===
                    background_composer_pb/* HeadlessAgenticComposerResponse_Status_StatusType */.yw.INDEX_SYNC) {
                    const hidden = Object.assign(Object.assign({}, updated), { isVisible: false });
                    return {
                        bubbles: [
                            ...prev.bubbles.slice(0, effectiveLength - 1),
                            hidden,
                            ...prev.bubbles.slice(effectiveLength),
                        ],
                    };
                }
                // For GENERIC complete, also add an explicit completed status bubble (as per Solid behavior)
                if (cs.isComplete &&
                    cs.type === background_composer_pb/* HeadlessAgenticComposerResponse_Status_StatusType */.yw.GENERIC) {
                    return {
                        bubbles: [
                            ...bubblesAfterDone,
                            {
                                type: "status",
                                statusType: cs.type,
                                message: cs.message,
                                isDone: true,
                                isVisible: true,
                            },
                        ],
                    };
                }
                return { bubbles: bubblesAfterDone };
            }
            return prev;
        });
    }
    // Auto-hide transient status when a subsequent non-status chunk arrives
    if (!chunk.status) {
        setResponses(prev => {
            const effectiveLength = computeEffective(prev.bubbles);
            if (effectiveLength === 0)
                return prev;
            const last = prev.bubbles[effectiveLength - 1];
            if (!last || last.type !== "status")
                return prev;
            if (last.statusType !==
                background_composer_pb/* HeadlessAgenticComposerResponse_Status_StatusType */.yw.INDEX_SYNC)
                return prev;
            const updated = Object.assign(Object.assign({}, last), { isDone: true, isVisible: false });
            return {
                bubbles: [
                    ...prev.bubbles.slice(0, effectiveLength - 1),
                    updated,
                    ...prev.bubbles.slice(effectiveLength),
                ],
            };
        });
    }
    // Text stream
    if (chunk.text) {
        setResponses(prev => {
            const effectiveLength = computeEffective(prev.bubbles);
            const last = effectiveLength > 0 ? prev.bubbles[effectiveLength - 1] : undefined;
            if (last && last.type === "text" && !last.isDone) {
                const updated = Object.assign(Object.assign({}, last), { text: last.text + chunk.text });
                return {
                    bubbles: [
                        ...prev.bubbles.slice(0, effectiveLength - 1),
                        updated,
                        ...prev.bubbles.slice(effectiveLength),
                    ],
                };
            }
            const newBubble = {
                type: "text",
                text: chunk.text,
                isDone: !!chunk.isMessageDone,
            };
            if (effectiveLength === prev.bubbles.length)
                return { bubbles: [...prev.bubbles, newBubble] };
            return {
                bubbles: [
                    ...prev.bubbles.slice(0, effectiveLength),
                    newBubble,
                    ...prev.bubbles.slice(effectiveLength),
                ],
            };
        });
    }
    // Tool call streaming
    if (chunk.toolCall) {
        const toolCall = chunk.toolCall;
        setResponses(prev => {
            const index = prev.bubbles.findIndex(b => b.type === "tool" && b.toolCall.toolCallId === toolCall.toolCallId);
            if (index === -1) {
                return {
                    bubbles: [
                        ...prev.bubbles,
                        { type: "tool", toolCall, toolResult: undefined },
                    ],
                };
            }
            const prevTool = prev.bubbles[index];
            const updated = Object.assign(Object.assign({}, prevTool), { toolCall });
            return {
                bubbles: [
                    ...prev.bubbles.slice(0, index),
                    updated,
                    ...prev.bubbles.slice(index + 1),
                ],
            };
        });
    }
    // Tool result finalization
    if (chunk.finalToolResult) {
        setResponses(prev => {
            const ftr = chunk.finalToolResult;
            if (!ftr)
                return prev;
            const index = prev.bubbles.findIndex(b => b.type === "tool" && b.toolCall.toolCallId === ftr.toolCallId);
            if (index === -1)
                return prev;
            const prevTool = prev.bubbles[index];
            const updated = Object.assign(Object.assign({}, prevTool), { toolResult: ftr.result });
            return {
                bubbles: [
                    ...prev.bubbles.slice(0, index),
                    updated,
                    ...prev.bubbles.slice(index + 1),
                ],
            };
        });
    }
    // Human message
    if (chunk.humanMessage) {
        const hm = chunk.humanMessage;
        const bubbleId = hm.bubbleId;
        // First update existing optimistic bubble by bubbleId if present; otherwise append
        setResponses(prev => {
            var _a, _b;
            const existingIndex = bubbleId
                ? prev.bubbles.findIndex(b => b.type === "user" && b.bubbleId === bubbleId)
                : -1;
            if (existingIndex !== -1) {
                const prevUser = prev.bubbles[existingIndex];
                const updated = Object.assign(Object.assign({}, prevUser), { text: hm.text, richText: (_a = hm.richText) !== null && _a !== void 0 ? _a : "", isOptimistic: false });
                return {
                    bubbles: [
                        ...prev.bubbles.slice(0, existingIndex),
                        updated,
                        ...prev.bubbles.slice(existingIndex + 1),
                    ],
                };
            }
            else {
                // Append at the end
                const newBubble = {
                    type: "user",
                    text: hm.text,
                    richText: (_b = hm.richText) !== null && _b !== void 0 ? _b : "",
                    isDone: !!chunk.isMessageDone,
                    isOptimistic: false,
                    bubbleId,
                };
                return { bubbles: [...prev.bubbles, newBubble] };
            }
        });
        // After incorporating server message, drop one trailing optimistic placeholder if any
        setResponses(prev => {
            const bubbles = prev.bubbles;
            for (let i = bubbles.length - 1; i >= 0; i--) {
                const b = bubbles[i];
                if (b.type === "user" && b.isOptimistic) {
                    return { bubbles: [...bubbles.slice(0, i), ...bubbles.slice(i + 1)] };
                }
            }
            return prev;
        });
    }
    // Close out the message
    if (chunk.isMessageDone) {
        setResponses(prev => {
            const effectiveLength = computeEffective(prev.bubbles);
            if (effectiveLength === 0)
                return prev;
            const last = prev.bubbles[effectiveLength - 1];
            if (!last ||
                (last.type !== "text" &&
                    last.type !== "user" &&
                    last.type !== "thinking"))
                return prev;
            const updated = Object.assign(Object.assign({}, last), { isDone: true });
            return {
                bubbles: [
                    ...prev.bubbles.slice(0, effectiveLength - 1),
                    updated,
                    ...prev.bubbles.slice(effectiveLength),
                ],
            };
        });
    }
    // Error bubble
    if (chunk.error) {
        addNewBubble({
            type: "error",
            message: ((_a = chunk.error) === null || _a === void 0 ? void 0 : _a.message) || "An unknown error occurred",
            errorDetails: (_b = chunk.error) === null || _b === void 0 ? void 0 : _b.errorDetails,
        });
    }
}


/***/ }),

/***/ "./src/hooks/use-background-actions.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: () => (/* binding */ useBackgroundActions)
/* harmony export */ });
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:child_process");
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_child_process__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:fs");
/* harmony import */ var node_fs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(node_fs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("node:os");
/* harmony import */ var node_os__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(node_os__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("node:path");
/* harmony import */ var node_path__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(node_path__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_git_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/utils/git.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





function printLines(print, lines) {
    try {
        print === null || print === void 0 ? void 0 : print(lines);
    }
    catch (_a) {
        // ignore UI failures
    }
}
function runGit(args, cwd) {
    const out = (0,node_child_process__WEBPACK_IMPORTED_MODULE_0__.execFileSync)("git", args, {
        cwd,
        encoding: "utf8",
        stdio: ["ignore", "pipe", "pipe"],
        maxBuffer: 2 * 1024 * 1024,
    });
    return out.trim();
}
function tryRunGit(args, cwd) {
    try {
        return runGit(args, cwd);
    }
    catch (_a) {
        return undefined;
    }
}
function getCurrentBranch(cwd) {
    return tryRunGit(["rev-parse", "--abbrev-ref", "HEAD"], cwd);
}
function ensureFetch(cwd, branch) {
    if (branch) {
        tryRunGit(["fetch", "--prune", "--tags", "origin", branch], cwd);
    }
    else {
        tryRunGit(["fetch", "--all", "--prune", "--tags"], cwd);
    }
}
function checkoutAndPull(cwd, branch) {
    const hasLocal = tryRunGit(["show-ref", "--verify", `refs/heads/${branch}`], cwd) !==
        undefined;
    if (!hasLocal) {
        // Create local branch tracking origin/branch if it exists; otherwise just checkout a new branch
        const hasRemote = tryRunGit(["ls-remote", "--exit-code", "--heads", "origin", branch], cwd) !== undefined;
        if (hasRemote) {
            runGit(["checkout", "-b", branch, "--track", `origin/${branch}`], cwd);
        }
        else {
            runGit(["checkout", "-b", branch], cwd);
        }
    }
    else {
        runGit(["checkout", branch], cwd);
    }
    // Fast-forward if possible
    tryRunGit(["pull", "--ff-only"], cwd);
}
function stripWorkspacePrefix(pathOrUri) {
    const prefixes = ["/workspace/", "file:///workspace/"];
    for (const prefix of prefixes) {
        if (pathOrUri.startsWith(prefix)) {
            const rel = pathOrUri.slice(prefix.length);
            return rel.startsWith("/") ? rel.slice(1) : rel;
        }
    }
    return pathOrUri;
}
function safeWriteFile(absPath, contents) {
    (0,node_fs__WEBPACK_IMPORTED_MODULE_1__.mkdirSync)((0,node_path__WEBPACK_IMPORTED_MODULE_3__.dirname)(absPath), { recursive: true });
    (0,node_fs__WEBPACK_IMPORTED_MODULE_1__.writeFileSync)(absPath, contents, "utf8");
}
function detectEol(text) {
    const crlf = (text.match(/\r\n/g) || []).length;
    const lf = (text.match(/(?<!\r)\n/g) || []).length;
    return crlf > lf ? "\r\n" : "\n";
}
function mergeThreeWay(original, target, current) {
    const tmpRoot = (0,node_path__WEBPACK_IMPORTED_MODULE_3__.join)(node_os__WEBPACK_IMPORTED_MODULE_2___default().tmpdir(), `bg-merge-${Date.now()}-${Math.random().toString(36).slice(2)}`);
    (0,node_fs__WEBPACK_IMPORTED_MODULE_1__.mkdirSync)(tmpRoot, { recursive: true });
    const basePath = (0,node_path__WEBPACK_IMPORTED_MODULE_3__.join)(tmpRoot, "base.txt");
    const oursPath = (0,node_path__WEBPACK_IMPORTED_MODULE_3__.join)(tmpRoot, "ours.txt");
    const theirsPath = (0,node_path__WEBPACK_IMPORTED_MODULE_3__.join)(tmpRoot, "theirs.txt");
    // Normalize inputs to LF for git merge-file stability
    const normalize = (s) => s.replace(/\r\n/g, "\n").replace(/\r/g, "\n");
    (0,node_fs__WEBPACK_IMPORTED_MODULE_1__.writeFileSync)(basePath, normalize(original), "utf8");
    (0,node_fs__WEBPACK_IMPORTED_MODULE_1__.writeFileSync)(oursPath, normalize(current), "utf8");
    (0,node_fs__WEBPACK_IMPORTED_MODULE_1__.writeFileSync)(theirsPath, normalize(target), "utf8");
    const args = [
        "merge-file",
        "-p",
        "-L",
        "Current (Your changes)",
        "-L",
        "Base (Original)",
        "-L",
        "Incoming (Background Agent changes)",
        oursPath,
        basePath,
        theirsPath,
    ];
    let out = "";
    let hasConflicts = false;
    try {
        try {
            out = (0,node_child_process__WEBPACK_IMPORTED_MODULE_0__.execFileSync)("git", args, {
                encoding: "utf8",
                maxBuffer: 10 * 1024 * 1024,
            });
        }
        catch (e) {
            const err = e;
            if (err && err.status === 1 && typeof err.stdout === "string") {
                // Conflicts present; stdout still contains merged result with markers
                out = err.stdout;
                hasConflicts = true;
            }
            else {
                throw e;
            }
        }
    }
    finally {
        // Always attempt to clean up temporary files
        try {
            (0,node_fs__WEBPACK_IMPORTED_MODULE_1__.rmSync)(tmpRoot, { recursive: true, force: true });
        }
        catch (_a) {
            // ignore cleanup failures
        }
    }
    // Restore original EOL style of current
    const eol = detectEol(current);
    if (eol === "\r\n") {
        out = out.replace(/\n/g, "\r\n");
    }
    return { merged: out, hasConflicts };
}
function useBackgroundActions(backgroundComposerClient) {
    function checkoutLocally(bcId, opts) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a, _b, _c;
            const print = opts === null || opts === void 0 ? void 0 : opts.print;
            const confirm = opts === null || opts === void 0 ? void 0 : opts.confirm;
            const repoRoot = (0,_utils_git_js__WEBPACK_IMPORTED_MODULE_4__/* .findGitRoot */ .k)(process.cwd());
            printLines(print, [