"use strict";
exports.id = 6624;
exports.ids = [6624];
exports.modules = {

/***/ "../../node_modules/.pnpm/@zed-industries+agent-client-protocol@0.1.2/node_modules/@zed-industries/agent-client-protocol/dist/acp.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  Bi: () => (/* binding */ AgentSideConnection),
  WP: () => (/* reexport */ PROTOCOL_VERSION)
});

// UNUSED EXPORTS: AGENT_METHODS, CLIENT_METHODS, ClientSideConnection, RequestError, agentCapabilitiesSchema, agentClientProtocolSchema, agentNotificationSchema, agentRequestSchema, agentResponseSchema, annotationsSchema, authMethodSchema, authenticateRequestSchema, authenticateResponseSchema, blobResourceContentsSchema, cancelNotificationSchema, clientCapabilitiesSchema, clientNotificationSchema, clientRequestSchema, clientResponseSchema, contentBlockSchema, embeddedResourceResourceSchema, envVariableSchema, fileSystemCapabilitySchema, initializeRequestSchema, initializeResponseSchema, loadSessionRequestSchema, loadSessionResponseSchema, mcpServerSchema, newSessionRequestSchema, newSessionResponseSchema, permissionOptionSchema, planEntrySchema, promptCapabilitiesSchema, promptRequestSchema, promptResponseSchema, readTextFileRequestSchema, readTextFileResponseSchema, requestPermissionRequestSchema, requestPermissionResponseSchema, roleSchema, sessionNotificationSchema, textResourceContentsSchema, toolCallContentSchema, toolCallLocationSchema, toolCallStatusSchema, toolCallUpdateSchema, toolKindSchema, writeTextFileRequestSchema, writeTextFileResponseSchema

// EXTERNAL MODULE: ../../node_modules/.pnpm/zod@3.24.2/node_modules/zod/lib/index.mjs
var lib = __webpack_require__("../../node_modules/.pnpm/zod@3.24.2/node_modules/zod/lib/index.mjs");
;// ../../node_modules/.pnpm/@zed-industries+agent-client-protocol@0.1.2/node_modules/@zed-industries/agent-client-protocol/dist/schema.js
const AGENT_METHODS = {
    authenticate: "authenticate",
    initialize: "initialize",
    session_cancel: "session/cancel",
    session_load: "session/load",
    session_new: "session/new",
    session_prompt: "session/prompt",
};
const CLIENT_METHODS = {
    fs_read_text_file: "fs/read_text_file",
    fs_write_text_file: "fs/write_text_file",
    session_request_permission: "session/request_permission",
    session_update: "session/update",
};
const PROTOCOL_VERSION = 1;

/**
 * Request to write content to a text file.
 *
 * Only available if the client supports the `fs.writeTextFile` capability.
 */
const writeTextFileRequestSchema = lib.z.object({
    /**
     * The text content to write to the file.
     */
    content: lib.z.string(),
    /**
     * Absolute path to the file to write.
     */
    path: lib.z.string(),
    /**
     * The session ID for this request.
     */
    sessionId: lib.z.string(),
});
/**
 * Request to read content from a text file.
 *
 * Only available if the client supports the `fs.readTextFile` capability.
 */
const readTextFileRequestSchema = lib.z.object({
    /**
     * Optional maximum number of lines to read.
     */
    limit: lib.z.number().optional().nullable(),
    /**
     * Optional line number to start reading from (1-based).
     */
    line: lib.z.number().optional().nullable(),
    /**
     * Absolute path to the file to read.
     */
    path: lib.z.string(),
    /**
     * The session ID for this request.
     */
    sessionId: lib.z.string(),
});
/**
 * The sender or recipient of messages and data in a conversation.
 */
const roleSchema = lib.z.union([lib.z.literal("assistant"), lib.z.literal("user")]);
/**
 * Text-based resource contents.
 */
const textResourceContentsSchema = lib.z.object({
    mimeType: lib.z.string().optional().nullable(),
    text: lib.z.string(),
    uri: lib.z.string(),
});
/**
 * Binary resource contents.
 */
const blobResourceContentsSchema = lib.z.object({
    blob: lib.z.string(),
    mimeType: lib.z.string().optional().nullable(),
    uri: lib.z.string(),
});
/**
 * Categories of tools that can be invoked.
 *
 * Tool kinds help clients choose appropriate icons and optimize how they
 * display tool execution progress.
 *
 * See protocol docs: [Creating](https://agentclientprotocol.com/protocol/tool-calls#creating)
 */
const toolKindSchema = lib.z.union([
    lib.z.literal("read"),
    lib.z.literal("edit"),
    lib.z.literal("delete"),
    lib.z.literal("move"),
    lib.z.literal("search"),
    lib.z.literal("execute"),
    lib.z.literal("think"),
    lib.z.literal("fetch"),
    lib.z.literal("other"),
]);
/**
 * Execution status of a tool call.
 *
 * Tool calls progress through different statuses during their lifecycle.
 *
 * See protocol docs: [Status](https://agentclientprotocol.com/protocol/tool-calls#status)
 */
const toolCallStatusSchema = lib.z.union([
    lib.z.literal("pending"),
    lib.z.literal("in_progress"),
    lib.z.literal("completed"),
    lib.z.literal("failed"),
]);
const writeTextFileResponseSchema = lib.z.null();
/**
 * Response containing the contents of a text file.
 */
const readTextFileResponseSchema = lib.z.object({
    content: lib.z.string(),
});
/**
 * Response to a permission request.
 */
const requestPermissionResponseSchema = lib.z.object({
    /**
     * The user's decision on the permission request.
     */
    outcome: lib.z.union([
        lib.z.object({
            outcome: lib.z.literal("cancelled"),
        }),
        lib.z.object({
            /**
             * The ID of the option the user selected.
             */
            optionId: lib.z.string(),
            outcome: lib.z.literal("selected"),
        }),
    ]),
});
/**
 * Notification to cancel ongoing operations for a session.
 *
 * See protocol docs: [Cancellation](https://agentclientprotocol.com/protocol/prompt-turn#cancellation)
 */
const cancelNotificationSchema = lib.z.object({
    /**
     * The ID of the session to cancel operations for.
     */
    sessionId: lib.z.string(),
});
/**
 * Request parameters for the authenticate method.
 *
 * Specifies which authentication method to use.
 */
const authenticateRequestSchema = lib.z.object({
    /**
     * The ID of the authentication method to use.
     * Must be one of the methods advertised in the initialize response.
     */
    methodId: lib.z.string(),
});
/**
 * Optional annotations for the client. The client can use annotations to inform how objects are used or displayed
 */
const annotationsSchema = lib.z.object({
    audience: lib.z.array(roleSchema).optional().nullable(),
    lastModified: lib.z.string().optional().nullable(),
    priority: lib.z.number().optional().nullable(),
});
/**
 * Resource content that can be embedded in a message.
 */
const embeddedResourceResourceSchema = lib.z.union([
    textResourceContentsSchema,
    blobResourceContentsSchema,
]);
const authenticateResponseSchema = lib.z.null();
/**
 * Response from creating a new session.
 *
 * See protocol docs: [Creating a Session](https://agentclientprotocol.com/protocol/session-setup#creating-a-session)
 */
const newSessionResponseSchema = lib.z.object({
    /**
     * Unique identifier for the created session.
     *
     * Used in all subsequent requests for this conversation.
     */
    sessionId: lib.z.string(),
});
const loadSessionResponseSchema = lib.z.null();
/**
 * Response from processing a user prompt.
 *
 * See protocol docs: [Check for Completion](https://agentclientprotocol.com/protocol/prompt-turn#4-check-for-completion)
 */
const promptResponseSchema = lib.z.object({
    /**
     * Indicates why the agent stopped processing the turn.
     */
    stopReason: lib.z.union([
        lib.z.literal("end_turn"),
        lib.z.literal("max_tokens"),
        lib.z.literal("max_turn_requests"),
        lib.z.literal("refusal"),
        lib.z.literal("cancelled"),
    ]),
});
/**
 * An option presented to the user when requesting permission.
 */
const permissionOptionSchema = lib.z.object({
    /**
     * Hint about the nature of this permission option.
     */
    kind: lib.z.union([
        lib.z.literal("allow_once"),
        lib.z.literal("allow_always"),
        lib.z.literal("reject_once"),
        lib.z.literal("reject_always"),
    ]),
    /**
     * Human-readable label to display to the user.
     */
    name: lib.z.string(),
    /**
     * Unique identifier for this permission option.
     */
    optionId: lib.z.string(),
});
/**
 * Content produced by a tool call.
 *
 * Tool calls can produce different types of content including
 * standard content blocks (text, images) or file diffs.
 *
 * See protocol docs: [Content](https://agentclientprotocol.com/protocol/tool-calls#content)
 */
const toolCallContentSchema = lib.z.union([
    lib.z.object({
        /**
         * Content blocks represent displayable information in the Agent Client Protocol.
         *
         * They provide a structured way to handle various types of user-facing content—whether
         * it's text from language models, images for analysis, or embedded resources for context.
         *
         * Content blocks appear in:
         * - User prompts sent via `session/prompt`
         * - Language model output streamed through `session/update` notifications
         * - Progress updates and results from tool calls
         *
         * This structure is compatible with the Model Context Protocol (MCP), enabling
         * agents to seamlessly forward content from MCP tool outputs without transformation.
         *
         * See protocol docs: [Content](https://agentclientprotocol.com/protocol/content)
         */
        content: lib.z.union([
            lib.z.object({
                annotations: annotationsSchema.optional().nullable(),
                text: lib.z.string(),
                type: lib.z.literal("text"),
            }),
            lib.z.object({
                annotations: annotationsSchema.optional().nullable(),
                data: lib.z.string(),
                mimeType: lib.z.string(),
                type: lib.z.literal("image"),
                uri: lib.z.string().optional().nullable(),
            }),
            lib.z.object({
                annotations: annotationsSchema.optional().nullable(),
                data: lib.z.string(),
                mimeType: lib.z.string(),
                type: lib.z.literal("audio"),
            }),
            lib.z.object({
                annotations: annotationsSchema.optional().nullable(),
                description: lib.z.string().optional().nullable(),
                mimeType: lib.z.string().optional().nullable(),
                name: lib.z.string(),
                size: lib.z.number().optional().nullable(),
                title: lib.z.string().optional().nullable(),
                type: lib.z.literal("resource_link"),
                uri: lib.z.string(),
            }),
            lib.z.object({
                annotations: annotationsSchema.optional().nullable(),
                resource: embeddedResourceResourceSchema,
                type: lib.z.literal("resource"),
            }),
        ]),
        type: lib.z.literal("content"),
    }),
    lib.z.object({
        /**
         * The new content after modification.
         */
        newText: lib.z.string(),
        /**
         * The original content (None for new files).
         */
        oldText: lib.z.string().optional().nullable(),
        /**
         * The file path being modified.
         */
        path: lib.z.string(),
        type: lib.z.literal("diff"),
    }),
]);
/**
 * A file location being accessed or modified by a tool.
 *
 * Enables clients to implement "follow-along" features that track
 * which files the agent is working with in real-time.
 *
 * See protocol docs: [Following the Agent](https://agentclientprotocol.com/protocol/tool-calls#following-the-agent)
 */
const toolCallLocationSchema = lib.z.object({
    /**
     * Optional line number within the file.
     */
    line: lib.z.number().optional().nullable(),
    /**
     * The file path being accessed or modified.
     */
    path: lib.z.string(),
});
/**
 * File system capabilities supported by the client.
 * Determines which file operations the agent can request.
 */
const fileSystemCapabilitySchema = lib.z.object({
    /**
     * Whether the Client supports `fs/read_text_file` requests.
     */
    readTextFile: lib.z.boolean().optional(),
    /**
     * Whether the Client supports `fs/write_text_file` requests.
     */
    writeTextFile: lib.z.boolean().optional(),
});
/**
 * An environment variable to set when launching an MCP server.
 */
const envVariableSchema = lib.z.object({
    /**
     * The name of the environment variable.
     */
    name: lib.z.string(),
    /**
     * The value to set for the environment variable.
     */
    value: lib.z.string(),
});
/**
 * Configuration for connecting to an MCP (Model Context Protocol) server.
 *
 * MCP servers provide tools and context that the agent can use when
 * processing prompts.
 *
 * See protocol docs: [MCP Servers](https://agentclientprotocol.com/protocol/session-setup#mcp-servers)
 */
const mcpServerSchema = lib.z.object({
    /**
     * Command-line arguments to pass to the MCP server.
     */
    args: lib.z.array(lib.z.string()),
    /**
     * Path to the MCP server executable.
     */
    command: lib.z.string(),
    /**
     * Environment variables to set when launching the MCP server.
     */
    env: lib.z.array(envVariableSchema),
    /**
     * Human-readable name identifying this MCP server.
     */
    name: lib.z.string(),
});
/**
 * Content blocks represent displayable information in the Agent Client Protocol.
 *
 * They provide a structured way to handle various types of user-facing content—whether
 * it's text from language models, images for analysis, or embedded resources for context.
 *
 * Content blocks appear in:
 * - User prompts sent via `session/prompt`
 * - Language model output streamed through `session/update` notifications
 * - Progress updates and results from tool calls
 *
 * This structure is compatible with the Model Context Protocol (MCP), enabling
 * agents to seamlessly forward content from MCP tool outputs without transformation.
 *
 * See protocol docs: [Content](https://agentclientprotocol.com/protocol/content)
 */
const contentBlockSchema = lib.z.union([
    lib.z.object({
        annotations: annotationsSchema.optional().nullable(),
        text: lib.z.string(),
        type: lib.z.literal("text"),
    }),
    lib.z.object({
        annotations: annotationsSchema.optional().nullable(),
        data: lib.z.string(),
        mimeType: lib.z.string(),
        type: lib.z.literal("image"),
        uri: lib.z.string().optional().nullable(),
    }),
    lib.z.object({
        annotations: annotationsSchema.optional().nullable(),
        data: lib.z.string(),
        mimeType: lib.z.string(),
        type: lib.z.literal("audio"),
    }),
    lib.z.object({
        annotations: annotationsSchema.optional().nullable(),
        description: lib.z.string().optional().nullable(),
        mimeType: lib.z.string().optional().nullable(),
        name: lib.z.string(),
        size: lib.z.number().optional().nullable(),
        title: lib.z.string().optional().nullable(),
        type: lib.z.literal("resource_link"),
        uri: lib.z.string(),
    }),
    lib.z.object({
        annotations: annotationsSchema.optional().nullable(),
        resource: embeddedResourceResourceSchema,
        type: lib.z.literal("resource"),
    }),
]);
/**
 * Describes an available authentication method.
 */
const authMethodSchema = lib.z.object({
    /**
     * Optional description providing more details about this authentication method.
     */
    description: lib.z.string().optional().nullable(),
    /**
     * Unique identifier for this authentication method.
     */
    id: lib.z.string(),
    /**
     * Human-readable name of the authentication method.
     */
    name: lib.z.string(),
});
/**
 * Prompt capabilities supported by the agent.
 */
const promptCapabilitiesSchema = lib.z.object({
    /**
     * Agent supports [`ContentBlock::Audio`].
     */
    audio: lib.z.boolean().optional(),
    /**
     * Agent supports embedded context in `session/prompt` requests.
     *
     * When enabled, the Client is allowed to include [`ContentBlock::Resource`]
     * in prompt requests for pieces of context that are referenced in the message.
     */
    embeddedContext: lib.z.boolean().optional(),
    /**
     * Agent supports [`ContentBlock::Image`].
     */
    image: lib.z.boolean().optional(),
});
/**
 * A single entry in the execution plan.
 *
 * Represents a task or goal that the assistant intends to accomplish
 * as part of fulfilling the user's request.
 * See protocol docs: [Plan Entries](https://agentclientprotocol.com/protocol/agent-plan#plan-entries)
 */
const planEntrySchema = lib.z.object({
    /**
     * Human-readable description of what this task aims to accomplish.
     */
    content: lib.z.string(),
    /**
     * The relative importance of this task.
     * Used to indicate which tasks are most critical to the overall goal.
     */
    priority: lib.z.union([lib.z.literal("high"), lib.z.literal("medium"), lib.z.literal("low")]),
    /**
     * Current execution status of this task.
     */
    status: lib.z.union([
        lib.z.literal("pending"),
        lib.z.literal("in_progress"),
        lib.z.literal("completed"),
    ]),
});
/**
 * All possible responses that a client can send to an agent.
 *
 * This enum is used internally for routing RPC responses. You typically won't need
 * to use this directly - the responses are handled automatically by the connection.
 *
 * These are responses to the corresponding AgentRequest variants.
 */
const clientResponseSchema = lib.z.union([
    writeTextFileResponseSchema,
    readTextFileResponseSchema,
    requestPermissionResponseSchema,
]);
/**
 * All possible notifications that a client can send to an agent.
 *
 * This enum is used internally for routing RPC notifications. You typically won't need
 * to use this directly - use the notification methods on the [`Agent`] trait instead.
 *
 * Notifications do not expect a response.
 */
const clientNotificationSchema = cancelNotificationSchema;
/**
 * Request parameters for creating a new session.
 *
 * See protocol docs: [Creating a Session](https://agentclientprotocol.com/protocol/session-setup#creating-a-session)
 */
const newSessionRequestSchema = lib.z.object({
    /**
     * The working directory for this session. Must be an absolute path.
     */
    cwd: lib.z.string(),
    /**
     * List of MCP (Model Context Protocol) servers the agent should connect to.
     */
    mcpServers: lib.z.array(mcpServerSchema),
});
/**
 * Request parameters for loading an existing session.
 *
 * Only available if the agent supports the `loadSession` capability.
 *
 * See protocol docs: [Loading Sessions](https://agentclientprotocol.com/protocol/session-setup#loading-sessions)
 */
const loadSessionRequestSchema = lib.z.object({
    /**
     * The working directory for this session.
     */
    cwd: lib.z.string(),
    /**
     * List of MCP servers to connect to for this session.
     */
    mcpServers: lib.z.array(mcpServerSchema),
    /**
     * The ID of the session to load.
     */
    sessionId: lib.z.string(),
});
/**
 * Request parameters for sending a user prompt to the agent.
 *
 * Contains the user's message and any additional context.
 *
 * See protocol docs: [User Message](https://agentclientprotocol.com/protocol/prompt-turn#1-user-message)
 */
const promptRequestSchema = lib.z.object({
    /**
     * The blocks of content that compose the user's message.
     *
     * As a baseline, the Agent MUST support [`ContentBlock::Text`] and [`ContentBlock::ResourceLink`],
     * while other variants are optionally enabled via [`PromptCapabilities`].
     *
     * The Client MUST adapt its interface according to [`PromptCapabilities`].
     *
     * The client MAY include referenced pieces of context as either
     * [`ContentBlock::Resource`] or [`ContentBlock::ResourceLink`].
     *
     * When available, [`ContentBlock::Resource`] is preferred
     * as it avoids extra round-trips and allows the message to include
     * pieces of context from sources the agent may not have access to.
     */
    prompt: lib.z.array(contentBlockSchema),
    /**
     * The ID of the session to send this user message to
     */
    sessionId: lib.z.string(),
});
/**
 * Notification containing a session update from the agent.
 *
 * Used to stream real-time progress and results during prompt processing.
 *
 * See protocol docs: [Agent Reports Output](https://agentclientprotocol.com/protocol/prompt-turn#3-agent-reports-output)
 */
const sessionNotificationSchema = lib.z.object({
    /**
     * The ID of the session this update pertains to.
     */
    sessionId: lib.z.string(),
    /**
     * The actual update content.
     */
    update: lib.z.union([
        lib.z.object({
            content: contentBlockSchema,
            sessionUpdate: lib.z.literal("user_message_chunk"),
        }),
        lib.z.object({
            content: contentBlockSchema,
            sessionUpdate: lib.z.literal("agent_message_chunk"),
        }),
        lib.z.object({
            content: contentBlockSchema,
            sessionUpdate: lib.z.literal("agent_thought_chunk"),
        }),
        lib.z.object({
            /**
             * Content produced by the tool call.
             */
            content: lib.z.array(toolCallContentSchema).optional(),
            /**
             * The category of tool being invoked.
             * Helps clients choose appropriate icons and UI treatment.
             */
            kind: lib.z
                .union([
                lib.z.literal("read"),
                lib.z.literal("edit"),
                lib.z.literal("delete"),
                lib.z.literal("move"),
                lib.z.literal("search"),
                lib.z.literal("execute"),
                lib.z.literal("think"),
                lib.z.literal("fetch"),
                lib.z.literal("other"),
            ])
                .optional(),
            /**
             * File locations affected by this tool call.
             * Enables "follow-along" features in clients.
             */
            locations: lib.z.array(toolCallLocationSchema).optional(),
            /**
             * Raw input parameters sent to the tool.
             */
            rawInput: lib.z.record(lib.z.unknown()).optional(),
            /**
             * Raw output returned by the tool.
             */
            rawOutput: lib.z.record(lib.z.unknown()).optional(),
            sessionUpdate: lib.z.literal("tool_call"),
            /**
             * Current execution status of the tool call.
             */
            status: lib.z
                .union([
                lib.z.literal("pending"),
                lib.z.literal("in_progress"),
                lib.z.literal("completed"),
                lib.z.literal("failed"),
            ])
                .optional(),
            /**
             * Human-readable title describing what the tool is doing.
             */
            title: lib.z.string(),
            /**
             * Unique identifier for this tool call within the session.
             */
            toolCallId: lib.z.string(),
        }),
        lib.z.object({
            /**
             * Replace the content collection.
             */
            content: lib.z.array(toolCallContentSchema).optional().nullable(),
            /**
             * Update the tool kind.
             */
            kind: toolKindSchema.optional().nullable(),
            /**
             * Replace the locations collection.
             */
            locations: lib.z.array(toolCallLocationSchema).optional().nullable(),
            /**
             * Update the raw input.
             */
            rawInput: lib.z.record(lib.z.unknown()).optional(),
            /**
             * Update the raw output.
             */
            rawOutput: lib.z.record(lib.z.unknown()).optional(),
            sessionUpdate: lib.z.literal("tool_call_update"),
            /**
             * Update the execution status.
             */
            status: toolCallStatusSchema.optional().nullable(),
            /**
             * Update the human-readable title.
             */
            title: lib.z.string().optional().nullable(),
            /**
             * The ID of the tool call being updated.
             */
            toolCallId: lib.z.string(),
        }),
        lib.z.object({
            /**
             * The list of tasks to be accomplished.
             *
             * When updating a plan, the agent must send a complete list of all entries
             * with their current status. The client replaces the entire plan with each update.
             */
            entries: lib.z.array(planEntrySchema),
            sessionUpdate: lib.z.literal("plan"),
        }),
    ]),
});
/**
 * Details about the tool call requiring permission.
 */
const toolCallUpdateSchema = lib.z.object({
    /**
     * Replace the content collection.
     */
    content: lib.z.array(toolCallContentSchema).optional().nullable(),
    /**
     * Update the tool kind.
     */
    kind: toolKindSchema.optional().nullable(),
    /**
     * Replace the locations collection.
     */
    locations: lib.z.array(toolCallLocationSchema).optional().nullable(),
    /**
     * Update the raw input.
     */
    rawInput: lib.z.record(lib.z.unknown()).optional(),
    /**
     * Update the raw output.
     */
    rawOutput: lib.z.record(lib.z.unknown()).optional(),
    /**
     * Update the execution status.
     */
    status: toolCallStatusSchema.optional().nullable(),
    /**
     * Update the human-readable title.
     */
    title: lib.z.string().optional().nullable(),
    /**
     * The ID of the tool call being updated.
     */
    toolCallId: lib.z.string(),
});
/**
 * Capabilities supported by the client.
 */
const clientCapabilitiesSchema = lib.z.object({
    fs: fileSystemCapabilitySchema.optional(),
});
/**
 * Capabilities supported by the agent.
 */
const agentCapabilitiesSchema = lib.z.object({
    /**
     * Whether the agent supports `session/load`.
     */
    loadSession: lib.z.boolean().optional(),
    promptCapabilities: promptCapabilitiesSchema.optional(),
});
/**
 * All possible notifications that an agent can send to a client.
 *
 * This enum is used internally for routing RPC notifications. You typically won't need
 * to use this directly - use the notification methods on the [`Client`] trait instead.
 *
 * Notifications do not expect a response.
 */
const agentNotificationSchema = sessionNotificationSchema;
/**
 * Request for user permission to execute a tool call.
 *
 * Sent when the agent needs authorization before performing a sensitive operation.
 *
 * See protocol docs: [Requesting Permission](https://agentclientprotocol.com/protocol/tool-calls#requesting-permission)
 */
const requestPermissionRequestSchema = lib.z.object({
    /**
     * Available permission options for the user to choose from.
     */
    options: lib.z.array(permissionOptionSchema),
    /**
     * The session ID for this request.
     */
    sessionId: lib.z.string(),
    toolCall: toolCallUpdateSchema,
});
/**
 * Request parameters for the initialize method.
 *
 * Sent by the client to establish connection and negotiate capabilities.
 *
 * See protocol docs: [Initialization](https://agentclientprotocol.com/protocol/initialization)
 */
const initializeRequestSchema = lib.z.object({
    clientCapabilities: clientCapabilitiesSchema.optional(),
    /**
     * The latest protocol version supported by the client.
     */
    protocolVersion: lib.z.number(),
});
/**
 * Response from the initialize method.
 *
 * Contains the negotiated protocol version and agent capabilities.
 *
 * See protocol docs: [Initialization](https://agentclientprotocol.com/protocol/initialization)
 */
const initializeResponseSchema = lib.z.object({
    agentCapabilities: agentCapabilitiesSchema.optional(),
    /**
     * Authentication methods supported by the agent.
     */
    authMethods: lib.z.array(authMethodSchema).optional(),
    /**
     * The protocol version the client specified if supported by the agent,
     * or the latest protocol version supported by the agent.
     *
     * The client should disconnect, if it doesn't support this version.
     */
    protocolVersion: lib.z.number(),
});
/**
 * All possible requests that an agent can send to a client.
 *
 * This enum is used internally for routing RPC requests. You typically won't need
 * to use this directly - instead, use the methods on the [`Client`] trait.
 *
 * This enum encompasses all method calls from agent to client.
 */
const clientRequestSchema = lib.z.union([
    writeTextFileRequestSchema,
    readTextFileRequestSchema,
    requestPermissionRequestSchema,
]);
/**
 * All possible requests that a client can send to an agent.
 *
 * This enum is used internally for routing RPC requests. You typically won't need
 * to use this directly - instead, use the methods on the [`Agent`] trait.
 *
 * This enum encompasses all method calls from client to agent.
 */
const agentRequestSchema = lib.z.union([
    initializeRequestSchema,
    authenticateRequestSchema,
    newSessionRequestSchema,
    loadSessionRequestSchema,
    promptRequestSchema,
]);
/**
 * All possible responses that an agent can send to a client.
 *
 * This enum is used internally for routing RPC responses. You typically won't need
 * to use this directly - the responses are handled automatically by the connection.
 *
 * These are responses to the corresponding ClientRequest variants.
 */
const agentResponseSchema = lib.z.union([
    initializeResponseSchema,
    authenticateResponseSchema,
    newSessionResponseSchema,
    loadSessionResponseSchema,
    promptResponseSchema,
]);
const agentClientProtocolSchema = lib.z.union([
    clientRequestSchema,
    clientResponseSchema,
    clientNotificationSchema,
    agentRequestSchema,
    agentResponseSchema,
    agentNotificationSchema,
]);
//# sourceMappingURL=schema.js.map
;// ../../node_modules/.pnpm/@zed-industries+agent-client-protocol@0.1.2/node_modules/@zed-industries/agent-client-protocol/dist/acp.js



/**
 * An agent-side connection to a client.
 *
 * This class provides the agent's view of an ACP connection, allowing
 * agents to communicate with clients. It implements the {@link Client} interface
 * to provide methods for requesting permissions, accessing the file system,
 * and sending session updates.
 *
 * @see {@link https://agentclientprotocol.com/protocol/overview#agent}
 */
class AgentSideConnection {
    #connection;
    /**
     * Creates a new agent-side connection to a client.
     *
     * This establishes the communication channel from the agent's perspective
     * following the ACP specification.
     *
     * @param toAgent - A function that creates an Agent handler to process incoming client requests
     * @param input - The stream for sending data to the client (typically stdout)
     * @param output - The stream for receiving data from the client (typically stdin)
     *
     * @see {@link https://agentclientprotocol.com/protocol/overview#communication-model}
     */
    constructor(toAgent, input, output) {
        const agent = toAgent(this);
        const handler = async (method, params) => {
            switch (method) {
                case AGENT_METHODS.initialize: {
                    const validatedParams = initializeRequestSchema.parse(params);
                    return agent.initialize(validatedParams);
                }
                case AGENT_METHODS.session_new: {
                    const validatedParams = newSessionRequestSchema.parse(params);
                    return agent.newSession(validatedParams);
                }
                case AGENT_METHODS.session_load: {
                    if (!agent.loadSession) {
                        throw RequestError.methodNotFound();
                    }
                    const validatedParams = loadSessionRequestSchema.parse(params);
                    return agent.loadSession(validatedParams);
                }
                case AGENT_METHODS.authenticate: {
                    const validatedParams = authenticateRequestSchema.parse(params);
                    return agent.authenticate(validatedParams);
                }
                case AGENT_METHODS.session_prompt: {
                    const validatedParams = promptRequestSchema.parse(params);
                    return agent.prompt(validatedParams);
                }
                case AGENT_METHODS.session_cancel: {
                    const validatedParams = cancelNotificationSchema.parse(params);
                    return agent.cancel(validatedParams);
                }
                default:
                    throw RequestError.methodNotFound(method);
            }
        };
        this.#connection = new Connection(handler, input, output);
    }
    /**
     * Handles session update notifications from the agent.
     *
     * This is a notification endpoint (no response expected) that sends
     * real-time updates about session progress, including message chunks,
     * tool calls, and execution plans.
     *
     * Note: Clients SHOULD continue accepting tool call updates even after
     * sending a `session/cancel` notification, as the agent may send final
     * updates before responding with the cancelled stop reason.
     *
     * @see {@link https://agentclientprotocol.com/protocol/prompt-turn#3-agent-reports-output}
     */
    async sessionUpdate(params) {
        return await this.#connection.sendNotification(CLIENT_METHODS.session_update, params);
    }
    /**
     * Requests permission from the user for a tool call operation.
     *
     * Called by the agent when it needs user authorization before executing
     * a potentially sensitive operation. The client should present the options
     * to the user and return their decision.
     *
     * If the client cancels the prompt turn via `session/cancel`, it MUST
     * respond to this request with `RequestPermissionOutcome::Cancelled`.
     *
     * @see {@link https://agentclientprotocol.com/protocol/tool-calls#requesting-permission}
     */
    async requestPermission(params) {
        return await this.#connection.sendRequest(CLIENT_METHODS.session_request_permission, params);
    }
    /**
     * Reads content from a text file in the client's file system.
     *
     * Only available if the client advertises the `fs.readTextFile` capability.
     * Allows the agent to access file contents within the client's environment.
     *
     * @see {@link https://agentclientprotocol.com/protocol/overview#client}
     */
    async readTextFile(params) {
        return await this.#connection.sendRequest(CLIENT_METHODS.fs_read_text_file, params);
    }
    /**
     * Writes content to a text file in the client's file system.
     *
     * Only available if the client advertises the `fs.writeTextFile` capability.
     * Allows the agent to create or modify files within the client's environment.
     *
     * @see {@link https://agentclientprotocol.com/protocol/overview#client}
     */
    async writeTextFile(params) {
        return await this.#connection.sendRequest(CLIENT_METHODS.fs_write_text_file, params);
    }
}
/**
 * A client-side connection to an agent.
 *
 * This class provides the client's view of an ACP connection, allowing
 * clients (such as code editors) to communicate with agents. It implements
 * the {@link Agent} interface to provide methods for initializing sessions, sending
 * prompts, and managing the agent lifecycle.
 *
 * @see {@link https://agentclientprotocol.com/protocol/overview#client}
 */
class ClientSideConnection {
    #connection;
    /**
     * Creates a new client-side connection to an agent.
     *
     * This establishes the communication channel between a client and agent
     * following the ACP specification.
     *
     * @param toClient - A function that creates a Client handler to process incoming agent requests
     * @param input - The stream for sending data to the agent (typically stdout)
     * @param output - The stream for receiving data from the agent (typically stdin)
     *
     * @see {@link https://agentclientprotocol.com/protocol/overview#communication-model}
     */
    constructor(toClient, input, output) {
        const handler = async (method, params) => {
            const client = toClient(this);
            switch (method) {
                case schema.CLIENT_METHODS.fs_write_text_file: {
                    const validatedParams = schema.writeTextFileRequestSchema.parse(params);
                    return client.writeTextFile(validatedParams);
                }
                case schema.CLIENT_METHODS.fs_read_text_file: {
                    const validatedParams = schema.readTextFileRequestSchema.parse(params);
                    return client.readTextFile(validatedParams);
                }
                case schema.CLIENT_METHODS.session_request_permission: {
                    const validatedParams = schema.requestPermissionRequestSchema.parse(params);
                    return client.requestPermission(validatedParams);
                }
                case schema.CLIENT_METHODS.session_update: {
                    const validatedParams = schema.sessionNotificationSchema.parse(params);
                    return client.sessionUpdate(validatedParams);
                }
                default:
                    throw RequestError.methodNotFound(method);
            }
        };
        this.#connection = new Connection(handler, input, output);
    }
    /**
     * Establishes the connection with a client and negotiates protocol capabilities.
     *
     * This method is called once at the beginning of the connection to:
     * - Negotiate the protocol version to use
     * - Exchange capability information between client and agent
     * - Determine available authentication methods
     *
     * The agent should respond with its supported protocol version and capabilities.
     *
     * @see {@link https://agentclientprotocol.com/protocol/initialization}
     */
    async initialize(params) {
        return await this.#connection.sendRequest(schema.AGENT_METHODS.initialize, params);
    }
    /**
     * Creates a new conversation session with the agent.
     *
     * Sessions represent independent conversation contexts with their own history and state.
     *
     * The agent should:
     * - Create a new session context
     * - Connect to any specified MCP servers
     * - Return a unique session ID for future requests
     *
     * @throws May return an `auth_required` error if the agent requires authentication.
     *
     * @see {@link https://agentclientprotocol.com/protocol/session-setup}
     */
    async newSession(params) {
        return await this.#connection.sendRequest(schema.AGENT_METHODS.session_new, params);
    }
    /**
     * Loads an existing session to resume a previous conversation.
     *
     * This method is only available if the agent advertises the `loadSession` capability.
     *
     * The agent should:
     * - Restore the session context and conversation history
     * - Connect to the specified MCP servers
     * - Stream the entire conversation history back to the client via notifications
     *
     * @see {@link https://agentclientprotocol.com/protocol/session-setup#loading-sessions}
     */
    async loadSession(params) {
        return await this.#connection.sendRequest(schema.AGENT_METHODS.session_load, params);
    }
    /**
     * Authenticates the client using the specified authentication method.
     *
     * Called when the agent requires authentication before allowing session creation.
     * The client provides the authentication method ID that was advertised during initialization.
     *
     * After successful authentication, the client can proceed to create sessions with
     * `newSession` without receiving an `auth_required` error.
     *
     * @see {@link https://agentclientprotocol.com/protocol/initialization}
     */
    async authenticate(params) {
        return await this.#connection.sendRequest(schema.AGENT_METHODS.authenticate, params);
    }
    /**
     * Processes a user prompt within a session.
     *
     * This method handles the whole lifecycle of a prompt:
     * - Receives user messages with optional context (files, images, etc.)
     * - Processes the prompt using language models
     * - Reports language model content and tool calls to the Clients
     * - Requests permission to run tools
     * - Executes any requested tool calls
     * - Returns when the turn is complete with a stop reason
     *
     * @see {@link https://agentclientprotocol.com/protocol/prompt-turn}
     */
    async prompt(params) {
        return await this.#connection.sendRequest(schema.AGENT_METHODS.session_prompt, params);
    }
    /**
     * Cancels ongoing operations for a session.
     *
     * This is a notification sent by the client to cancel an ongoing prompt turn.
     *
     * Upon receiving this notification, the Agent SHOULD:
     * - Stop all language model requests as soon as possible
     * - Abort all tool call invocations in progress
     * - Send any pending `session/update` notifications
     * - Respond to the original `session/prompt` request with `StopReason::Cancelled`
     *
     * @see {@link https://agentclientprotocol.com/protocol/prompt-turn#cancellation}
     */
    async cancel(params) {
        return await this.#connection.sendNotification(schema.AGENT_METHODS.session_cancel, params);
    }
}
class Connection {
    #pendingResponses = new Map();
    #nextRequestId = 0;
    #handler;
    #peerInput;
    #writeQueue = Promise.resolve();
    #textEncoder;
    constructor(handler, peerInput, peerOutput) {
        this.#handler = handler;
        this.#peerInput = peerInput;
        this.#textEncoder = new TextEncoder();
        this.#receive(peerOutput);
    }
    async #receive(output) {
        let content = "";
        const decoder = new TextDecoder();
        for await (const chunk of output) {
            content += decoder.decode(chunk, { stream: true });
            const lines = content.split("\n");
            content = lines.pop() || "";
            for (const line of lines) {
                const trimmedLine = line.trim();
                if (trimmedLine) {
                    const message = JSON.parse(trimmedLine);
                    this.#processMessage(message);
                }
            }
        }
    }
    async #processMessage(message) {
        if ("method" in message && "id" in message) {
            // It's a request
            const response = await this.#tryCallHandler(message.method, message.params);
            await this.#sendMessage({
                jsonrpc: "2.0",
                id: message.id,
                ...response,
            });
        }
        else if ("method" in message) {
            // It's a notification
            await this.#tryCallHandler(message.method, message.params);
        }
        else if ("id" in message) {
            // It's a response
            this.#handleResponse(message);
        }
    }
    async #tryCallHandler(method, params) {
        try {
            const result = await this.#handler(method, params);
            return { result: result ?? null };
        }
        catch (error) {
            if (error instanceof RequestError) {
                return error.toResult();
            }
            if (error instanceof lib.z.ZodError) {
                return RequestError.invalidParams(JSON.stringify(error.format(), undefined, 2)).toResult();
            }
            let details;
            if (error instanceof Error) {
                details = error.message;
            }
            else if (typeof error === "object" &&
                error != null &&
                "message" in error &&
                typeof error.message === "string") {
                details = error.message;
            }
            return RequestError.internalError(details).toResult();
        }
    }
    #handleResponse(response) {
        const pendingResponse = this.#pendingResponses.get(response.id);
        if (pendingResponse) {
            if ("result" in response) {
                pendingResponse.resolve(response.result);
            }
            else if ("error" in response) {
                pendingResponse.reject(response.error);
            }
            this.#pendingResponses.delete(response.id);
        }
    }
    async sendRequest(method, params) {
        const id = this.#nextRequestId++;
        const responsePromise = new Promise((resolve, reject) => {
            this.#pendingResponses.set(id, { resolve, reject });
        });
        await this.#sendMessage({ jsonrpc: "2.0", id, method, params });
        return responsePromise;
    }
    async sendNotification(method, params) {
        await this.#sendMessage({ jsonrpc: "2.0", method, params });
    }
    async #sendMessage(json) {
        const content = JSON.stringify(json) + "\n";
        this.#writeQueue = this.#writeQueue
            .then(async () => {
            const writer = this.#peerInput.getWriter();
            try {
                await writer.write(this.#textEncoder.encode(content));
            }
            finally {
                writer.releaseLock();
            }
        })
            .catch((error) => {
            // Continue processing writes on error
            console.error("ACP write error:", error);
        });
        return this.#writeQueue;
    }
}
/**
 * JSON-RPC error object.
 *
 * Represents an error that occurred during method execution, following the
 * JSON-RPC 2.0 error object specification with optional additional data.
 *
 * @see {@link https://www.jsonrpc.org/specification#error_object}
 */
class RequestError extends Error {
    code;
    data;
    constructor(code, message, details) {
        super(message);
        this.code = code;
        this.name = "RequestError";
        if (details) {
            this.data = { details };
        }
    }
    /**
     * Invalid JSON was received by the server. An error occurred on the server while parsing the JSON text.
     */
    static parseError(details) {
        return new RequestError(-32700, "Parse error", details);
    }
    /**
     * The JSON sent is not a valid Request object.
     */
    static invalidRequest(details) {
        return new RequestError(-32600, "Invalid request", details);
    }
    /**
     * The method does not exist / is not available.
     */
    static methodNotFound(details) {
        return new RequestError(-32601, "Method not found", details);
    }
    /**
     * Invalid method parameter(s).
     */
    static invalidParams(details) {
        return new RequestError(-32602, "Invalid params", details);
    }
    /**
     * Internal JSON-RPC error.
     */
    static internalError(details) {
        return new RequestError(-32603, "Internal error", details);
    }
    /**
     * Authentication required.
     */
    static authRequired(details) {
        return new RequestError(-32000, "Authentication required", details);
    }
    toResult() {
        return {
            error: {
                code: this.code,
                message: this.message,
                data: this.data,
            },
        };
    }
}
//# sourceMappingURL=acp.js.map

/***/ })

};
;