"use strict";
exports.id = 5302;
exports.ids = [5302];
exports.modules = {

/***/ "./src/commands/logout.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleLogout: () => (/* binding */ handleLogout)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_keychain__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../keychain/dist/index.js");
/* harmony import */ var _components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/components/login-ui.tsx");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__, _components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




function handleLogout(credentialManager, configProvider) {
    return __awaiter(this, void 0, void 0, function* () {
        // Render the status component
        const { rerender } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .render */ .XX)((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .LogoutStatus */ .L, { status: "starting" }));
        try {
            const accessToken = yield credentialManager.getAccessToken();
            if (!accessToken) {
                rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .LogoutStatus */ .L, { status: "success", message: "Authentication tokens removed." }));
                process.exit(0);
            }
        }
        catch (error) {
            if (error instanceof _anysphere_keychain__WEBPACK_IMPORTED_MODULE_2__/* .PasswordNotFoundError */ .fI) {
                rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .LogoutStatus */ .L, { status: "success", message: "Authentication tokens removed." }));
                process.exit(0);
            }
        }
        try {
            rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .LogoutStatus */ .L, { status: "in-progress" }));
            yield credentialManager.clearAuthentication();
            yield configProvider.transform((c) => (Object.assign(Object.assign({}, c), { privacyCache: undefined })));
            rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .LogoutStatus */ .L, { status: "success", message: "Authentication tokens removed." }));
        }
        catch (error) {
            rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_3__/* .LogoutStatus */ .L, { status: "error", message: `Failed to remove authentication tokens: ${error}` }));
            process.exit(1);
        }
        process.exit(0);
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/login-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: () => (/* binding */ LogoutStatus),
/* harmony export */   a: () => (/* binding */ LoginStatus)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const LoginStatus = ({ status, message, userInfo, loginUrl }) => {
    const getStatusContent = () => {
        switch (status) {
            case "starting":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Starting login process..." }) }));
            case "in-progress":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", gap: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Authenticating with Cursor..." }) }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: message }), loginUrl && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", wrap: "no-wrap", children: loginUrl }))] }));
            case "success":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "green", children: "\u2713 " }), (userInfo === null || userInfo === void 0 ? void 0 : userInfo.email) ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: ["Logged in as ", userInfo.email] })) : (userInfo === null || userInfo === void 0 ? void 0 : userInfo.userId) ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: ["Logged in as user id ", userInfo.userId] })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Login successful!" }))] }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: message })] }));
            case "error":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: message }) }));
        }
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", padding: 1, children: getStatusContent() }));
};
const LogoutStatus = ({ status, message }) => {
    const getStatusContent = () => {
        switch (status) {
            case "starting":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Preparing to log out..." }) }));
            case "in-progress":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Logging out..." }) }));
            case "success":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "green", children: "\u2713 Logout successful" }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: message })] }));
            case "error":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: "\u2717 Logout failed" }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: message })] }));
        }
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", padding: 1, children: getStatusContent() }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;