exports.id = 9802;
exports.ids = [9802];
exports.modules = {

/***/ "../../node_modules/.pnpm/@playwright+mcp@0.0.40/node_modules/@playwright/mcp/index.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

//#!/usr/bin/env node
/**
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const { createConnection } = __webpack_require__("../../node_modules/.pnpm/playwright@1.56.0-alpha-1758750661000/node_modules/playwright/lib/mcp/index.js");
module.exports = { createConnection };


/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/BidiMapper.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2022 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OutgoingMessage = exports.EventEmitter = exports.BidiServer = void 0;
/**
 * @fileoverview The entry point to the BiDi Mapper namespace.
 * Other modules should only access exports defined in this file.
 * XXX: Add ESlint rule for this (https://github.com/import-js/eslint-plugin-import/blob/main/docs/rules/no-restricted-paths.md)
 */
var BidiServer_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/BidiServer.js");
Object.defineProperty(exports, "BidiServer", ({ enumerable: true, get: function () { return BidiServer_js_1.BidiServer; } }));
var EventEmitter_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/EventEmitter.js");
Object.defineProperty(exports, "EventEmitter", ({ enumerable: true, get: function () { return EventEmitter_js_1.EventEmitter; } }));
var OutgoingMessage_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/OutgoingMessage.js");
Object.defineProperty(exports, "OutgoingMessage", ({ enumerable: true, get: function () { return OutgoingMessage_js_1.OutgoingMessage; } }));
//# sourceMappingURL=BidiMapper.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/BidiNoOpParser.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BidiNoOpParser = void 0;
class BidiNoOpParser {
    // Bluetooth module
    // keep-sorted start block=yes
    parseHandleRequestDevicePromptParams(params) {
        return params;
    }
    parseSimulateAdapterParameters(params) {
        return params;
    }
    parseSimulateAdvertisementParameters(params) {
        return params;
    }
    parseSimulatePreconnectedPeripheralParameters(params) {
        return params;
    }
    // keep-sorted end
    // Browser module
    // keep-sorted start block=yes
    parseRemoveUserContextParams(params) {
        return params;
    }
    // keep-sorted end
    // Browsing Context module
    // keep-sorted start block=yes
    parseActivateParams(params) {
        return params;
    }
    parseCaptureScreenshotParams(params) {
        return params;
    }
    parseCloseParams(params) {
        return params;
    }
    parseCreateParams(params) {
        return params;
    }
    parseGetTreeParams(params) {
        return params;
    }
    parseHandleUserPromptParams(params) {
        return params;
    }
    parseLocateNodesParams(params) {
        return params;
    }
    parseNavigateParams(params) {
        return params;
    }
    parsePrintParams(params) {
        return params;
    }
    parseReloadParams(params) {
        return params;
    }
    parseSetViewportParams(params) {
        return params;
    }
    parseTraverseHistoryParams(params) {
        return params;
    }
    // keep-sorted end
    // CDP module
    // keep-sorted start block=yes
    parseGetSessionParams(params) {
        return params;
    }
    parseResolveRealmParams(params) {
        return params;
    }
    parseSendCommandParams(params) {
        return params;
    }
    // keep-sorted end
    // Script module
    // keep-sorted start block=yes
    parseAddPreloadScriptParams(params) {
        return params;
    }
    parseCallFunctionParams(params) {
        return params;
    }
    parseDisownParams(params) {
        return params;
    }
    parseEvaluateParams(params) {
        return params;
    }
    parseGetRealmsParams(params) {
        return params;
    }
    parseRemovePreloadScriptParams(params) {
        return params;
    }
    // keep-sorted end
    // Input module
    // keep-sorted start block=yes
    parsePerformActionsParams(params) {
        return params;
    }
    parseReleaseActionsParams(params) {
        return params;
    }
    parseSetFilesParams(params) {
        return params;
    }
    // keep-sorted end
    // Network module
    // keep-sorted start block=yes
    parseAddInterceptParams(params) {
        return params;
    }
    parseContinueRequestParams(params) {
        return params;
    }
    parseContinueResponseParams(params) {
        return params;
    }
    parseContinueWithAuthParams(params) {
        return params;
    }
    parseFailRequestParams(params) {
        return params;
    }
    parseProvideResponseParams(params) {
        return params;
    }
    parseRemoveInterceptParams(params) {
        return params;
    }
    parseSetCacheBehavior(params) {
        return params;
    }
    // keep-sorted end
    // Permissions module
    // keep-sorted start block=yes
    parseSetPermissionsParams(params) {
        return params;
    }
    // keep-sorted end
    // Session module
    // keep-sorted start block=yes
    parseSubscribeParams(params) {
        return params;
    }
    parseUnsubscribeParams(params) {
        return params;
    }
    // keep-sorted end
    // Storage module
    // keep-sorted start block=yes
    parseDeleteCookiesParams(params) {
        return params;
    }
    parseGetCookiesParams(params) {
        return params;
    }
    parseSetCookieParams(params) {
        return params;
    }
}
exports.BidiNoOpParser = BidiNoOpParser;
//# sourceMappingURL=BidiNoOpParser.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/BidiServer.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2021 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BidiServer = void 0;
const EventEmitter_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/EventEmitter.js");
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
const ProcessingQueue_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/ProcessingQueue.js");
const CommandProcessor_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/CommandProcessor.js");
const BluetoothProcessor_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/bluetooth/BluetoothProcessor.js");
const CdpTargetManager_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/cdp/CdpTargetManager.js");
const BrowsingContextStorage_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/context/BrowsingContextStorage.js");
const NetworkStorage_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/network/NetworkStorage.js");
const PreloadScriptStorage_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/PreloadScriptStorage.js");
const RealmStorage_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/RealmStorage.js");
const EventManager_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/session/EventManager.js");
class BidiServer extends EventEmitter_js_1.EventEmitter {
    #messageQueue;
    #transport;
    #commandProcessor;
    #eventManager;
    #browsingContextStorage = new BrowsingContextStorage_js_1.BrowsingContextStorage();
    #realmStorage = new RealmStorage_js_1.RealmStorage();
    #preloadScriptStorage = new PreloadScriptStorage_js_1.PreloadScriptStorage();
    #bluetoothProcessor;
    #logger;
    #handleIncomingMessage = (message) => {
        void this.#commandProcessor.processCommand(message).catch((error) => {
            this.#logger?.(log_js_1.LogType.debugError, error);
        });
    };
    #processOutgoingMessage = async (messageEntry) => {
        // Enrich message with channel data.
        const message = { ...messageEntry.message, ...messageEntry.channel };
        await this.#transport.sendMessage(message);
    };
    constructor(bidiTransport, cdpConnection, browserCdpClient, selfTargetId, defaultUserContextId, parser, logger) {
        super();
        this.#logger = logger;
        this.#messageQueue = new ProcessingQueue_js_1.ProcessingQueue(this.#processOutgoingMessage, this.#logger);
        this.#transport = bidiTransport;
        this.#transport.setOnMessage(this.#handleIncomingMessage);
        this.#eventManager = new EventManager_js_1.EventManager(this.#browsingContextStorage);
        const networkStorage = new NetworkStorage_js_1.NetworkStorage(this.#eventManager, this.#browsingContextStorage, browserCdpClient, logger);
        this.#bluetoothProcessor = new BluetoothProcessor_js_1.BluetoothProcessor(this.#eventManager, this.#browsingContextStorage);
        this.#commandProcessor = new CommandProcessor_js_1.CommandProcessor(cdpConnection, browserCdpClient, this.#eventManager, this.#browsingContextStorage, this.#realmStorage, this.#preloadScriptStorage, networkStorage, this.#bluetoothProcessor, parser, async (options) => {
            // This is required to ignore certificate errors when service worker is fetched.
            await browserCdpClient.sendCommand('Security.setIgnoreCertificateErrors', {
                ignore: options.acceptInsecureCerts ?? false,
            });
            new CdpTargetManager_js_1.CdpTargetManager(cdpConnection, browserCdpClient, selfTargetId, this.#eventManager, this.#browsingContextStorage, this.#realmStorage, networkStorage, this.#bluetoothProcessor, this.#preloadScriptStorage, defaultUserContextId, options?.['goog:prerenderingDisabled'] ?? false, options?.unhandledPromptBehavior, logger);
            // Needed to get events about new targets.
            await browserCdpClient.sendCommand('Target.setDiscoverTargets', {
                discover: true,
            });
            // Needed to automatically attach to new targets.
            await browserCdpClient.sendCommand('Target.setAutoAttach', {
                autoAttach: true,
                waitForDebuggerOnStart: true,
                flatten: true,
                // Browser session should attach to tab instead of the page, so that
                // prerendering is not blocked.
                filter: [
                    {
                        type: 'page',
                        exclude: true,
                    },
                    {},
                ],
            });
            await this.#topLevelContextsLoaded();
        }, this.#logger);
        this.#eventManager.on("event" /* EventManagerEvents.Event */, ({ message, event }) => {
            this.emitOutgoingMessage(message, event);
        });
        this.#commandProcessor.on("response" /* CommandProcessorEvents.Response */, ({ message, event }) => {
            this.emitOutgoingMessage(message, event);
        });
    }
    /**
     * Creates and starts BiDi Mapper instance.
     */
    static async createAndStart(bidiTransport, cdpConnection, browserCdpClient, selfTargetId, parser, logger) {
        // The default context is not exposed in Target.getBrowserContexts but can
        // be observed via Target.getTargets. To determine the default browser
        // context, we check which one is mentioned in Target.getTargets and not in
        // Target.getBrowserContexts.
        const [{ browserContextIds }, { targetInfos }] = await Promise.all([
            browserCdpClient.sendCommand('Target.getBrowserContexts'),
            browserCdpClient.sendCommand('Target.getTargets'),
        ]);
        let defaultUserContextId = 'default';
        for (const info of targetInfos) {
            if (info.browserContextId &&
                !browserContextIds.includes(info.browserContextId)) {
                defaultUserContextId = info.browserContextId;
                break;
            }
        }
        const server = new BidiServer(bidiTransport, cdpConnection, browserCdpClient, selfTargetId, defaultUserContextId, parser, logger);
        return server;
    }
    /**
     * Sends BiDi message.
     */
    emitOutgoingMessage(messageEntry, event) {
        this.#messageQueue.add(messageEntry, event);
    }
    close() {
        this.#transport.close();
    }
    async #topLevelContextsLoaded() {
        await Promise.all(this.#browsingContextStorage
            .getTopLevelContexts()
            .map((c) => c.lifecycleLoaded()));
    }
}
exports.BidiServer = BidiServer;
//# sourceMappingURL=BidiServer.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/CommandProcessor.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2021 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommandProcessor = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const EventEmitter_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/EventEmitter.js");
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
const BidiNoOpParser_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/BidiNoOpParser.js");
const BrowserProcessor_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/browser/BrowserProcessor.js");
const CdpProcessor_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/cdp/CdpProcessor.js");
const BrowsingContextProcessor_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/context/BrowsingContextProcessor.js");
const InputProcessor_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/InputProcessor.js");
const NetworkProcessor_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/network/NetworkProcessor.js");
const PermissionsProcessor_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/permissions/PermissionsProcessor.js");
const ScriptProcessor_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/ScriptProcessor.js");
const SessionProcessor_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/session/SessionProcessor.js");
const StorageProcessor_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/storage/StorageProcessor.js");
const OutgoingMessage_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/OutgoingMessage.js");
class CommandProcessor extends EventEmitter_js_1.EventEmitter {
    // keep-sorted start
    #bluetoothProcessor;
    #browserProcessor;
    #browsingContextProcessor;
    #cdpProcessor;
    #inputProcessor;
    #networkProcessor;
    #permissionsProcessor;
    #scriptProcessor;
    #sessionProcessor;
    #storageProcessor;
    // keep-sorted end
    #parser;
    #logger;
    constructor(cdpConnection, browserCdpClient, eventManager, browsingContextStorage, realmStorage, preloadScriptStorage, networkStorage, bluetoothProcessor, parser = new BidiNoOpParser_js_1.BidiNoOpParser(), initConnection, logger) {
        super();
        this.#parser = parser;
        this.#logger = logger;
        this.#bluetoothProcessor = bluetoothProcessor;
        // keep-sorted start block=yes
        this.#browserProcessor = new BrowserProcessor_js_1.BrowserProcessor(browserCdpClient, browsingContextStorage);
        this.#browsingContextProcessor = new BrowsingContextProcessor_js_1.BrowsingContextProcessor(browserCdpClient, browsingContextStorage, eventManager);
        this.#cdpProcessor = new CdpProcessor_js_1.CdpProcessor(browsingContextStorage, realmStorage, cdpConnection, browserCdpClient);
        this.#inputProcessor = new InputProcessor_js_1.InputProcessor(browsingContextStorage);
        this.#networkProcessor = new NetworkProcessor_js_1.NetworkProcessor(browsingContextStorage, networkStorage);
        this.#permissionsProcessor = new PermissionsProcessor_js_1.PermissionsProcessor(browserCdpClient);
        this.#scriptProcessor = new ScriptProcessor_js_1.ScriptProcessor(eventManager, browsingContextStorage, realmStorage, preloadScriptStorage, logger);
        this.#sessionProcessor = new SessionProcessor_js_1.SessionProcessor(eventManager, browserCdpClient, initConnection);
        this.#storageProcessor = new StorageProcessor_js_1.StorageProcessor(browserCdpClient, browsingContextStorage, logger);
        // keep-sorted end
    }
    async #processCommand(command) {
        switch (command.method) {
            // Bluetooth module
            // keep-sorted start block=yes
            case 'bluetooth.handleRequestDevicePrompt':
                return await this.#bluetoothProcessor.handleRequestDevicePrompt(this.#parser.parseHandleRequestDevicePromptParams(command.params));
            case 'bluetooth.simulateAdapter':
                return await this.#bluetoothProcessor.simulateAdapter(this.#parser.parseSimulateAdapterParameters(command.params));
            case 'bluetooth.simulateAdvertisement':
                return await this.#bluetoothProcessor.simulateAdvertisement(this.#parser.parseSimulateAdvertisementParameters(command.params));
            case 'bluetooth.simulatePreconnectedPeripheral':
                return await this.#bluetoothProcessor.simulatePreconnectedPeripheral(this.#parser.parseSimulatePreconnectedPeripheralParameters(command.params));
            // keep-sorted end
            // Browser module
            // keep-sorted start block=yes
            case 'browser.close':
                return this.#browserProcessor.close();
            case 'browser.createUserContext':
                return await this.#browserProcessor.createUserContext(command.params);
            case 'browser.getClientWindows':
                return await this.#browserProcessor.getClientWindows();
            case 'browser.getUserContexts':
                return await this.#browserProcessor.getUserContexts();
            case 'browser.removeUserContext':
                return await this.#browserProcessor.removeUserContext(this.#parser.parseRemoveUserContextParams(command.params));
            case 'browser.setClientWindowState':
                throw new protocol_js_1.UnknownErrorException(`Method ${command.method} is not implemented.`);
            // keep-sorted end
            // Browsing Context module
            // keep-sorted start block=yes
            case 'browsingContext.activate':
                return await this.#browsingContextProcessor.activate(this.#parser.parseActivateParams(command.params));
            case 'browsingContext.captureScreenshot':
                return await this.#browsingContextProcessor.captureScreenshot(this.#parser.parseCaptureScreenshotParams(command.params));
            case 'browsingContext.close':
                return await this.#browsingContextProcessor.close(this.#parser.parseCloseParams(command.params));
            case 'browsingContext.create':
                return await this.#browsingContextProcessor.create(this.#parser.parseCreateParams(command.params));
            case 'browsingContext.getTree':
                return this.#browsingContextProcessor.getTree(this.#parser.parseGetTreeParams(command.params));
            case 'browsingContext.handleUserPrompt':
                return await this.#browsingContextProcessor.handleUserPrompt(this.#parser.parseHandleUserPromptParams(command.params));
            case 'browsingContext.locateNodes':
                return await this.#browsingContextProcessor.locateNodes(this.#parser.parseLocateNodesParams(command.params));
            case 'browsingContext.navigate':
                return await this.#browsingContextProcessor.navigate(this.#parser.parseNavigateParams(command.params));
            case 'browsingContext.print':
                return await this.#browsingContextProcessor.print(this.#parser.parsePrintParams(command.params));
            case 'browsingContext.reload':
                return await this.#browsingContextProcessor.reload(this.#parser.parseReloadParams(command.params));
            case 'browsingContext.setViewport':
                return await this.#browsingContextProcessor.setViewport(this.#parser.parseSetViewportParams(command.params));
            case 'browsingContext.traverseHistory':
                return await this.#browsingContextProcessor.traverseHistory(this.#parser.parseTraverseHistoryParams(command.params));
            // keep-sorted end
            // CDP module
            // keep-sorted start block=yes
            case 'goog:cdp.getSession':
                return this.#cdpProcessor.getSession(this.#parser.parseGetSessionParams(command.params));
            case 'goog:cdp.resolveRealm':
                return this.#cdpProcessor.resolveRealm(this.#parser.parseResolveRealmParams(command.params));
            case 'goog:cdp.sendCommand':
                return await this.#cdpProcessor.sendCommand(this.#parser.parseSendCommandParams(command.params));
            // keep-sorted end
            // CDP deprecated domain.
            // https://github.com/GoogleChromeLabs/chromium-bidi/issues/2844
            // keep-sorted start block=yes
            case 'cdp.getSession':
                this.#logger?.(log_js_1.LogType.debugWarn, `Legacy '${command.method}' command is deprecated and will not supported soon. Use 'goog:${command.method}' instead.`);
                return this.#cdpProcessor.getSession(this.#parser.parseGetSessionParams(command.params));
            case 'cdp.resolveRealm':
                this.#logger?.(log_js_1.LogType.debugWarn, `Legacy '${command.method}' command is deprecated and will not supported soon. Use 'goog:${command.method}' instead.`);
                return this.#cdpProcessor.resolveRealm(this.#parser.parseResolveRealmParams(command.params));
            case 'cdp.sendCommand':
                this.#logger?.(log_js_1.LogType.debugWarn, `Legacy '${command.method}' command is deprecated and will not supported soon. Use 'goog:${command.method}' instead.`);
                return await this.#cdpProcessor.sendCommand(this.#parser.parseSendCommandParams(command.params));
            // keep-sorted end
            // Input module
            // keep-sorted start block=yes
            case 'input.performActions':
                return await this.#inputProcessor.performActions(this.#parser.parsePerformActionsParams(command.params));
            case 'input.releaseActions':
                return await this.#inputProcessor.releaseActions(this.#parser.parseReleaseActionsParams(command.params));
            case 'input.setFiles':
                return await this.#inputProcessor.setFiles(this.#parser.parseSetFilesParams(command.params));
            // keep-sorted end
            // Network module
            // keep-sorted start block=yes
            case 'network.addIntercept':
                return await this.#networkProcessor.addIntercept(this.#parser.parseAddInterceptParams(command.params));
            case 'network.continueRequest':
                return await this.#networkProcessor.continueRequest(this.#parser.parseContinueRequestParams(command.params));
            case 'network.continueResponse':
                return await this.#networkProcessor.continueResponse(this.#parser.parseContinueResponseParams(command.params));
            case 'network.continueWithAuth':
                return await this.#networkProcessor.continueWithAuth(this.#parser.parseContinueWithAuthParams(command.params));
            case 'network.failRequest':
                return await this.#networkProcessor.failRequest(this.#parser.parseFailRequestParams(command.params));
            case 'network.provideResponse':
                return await this.#networkProcessor.provideResponse(this.#parser.parseProvideResponseParams(command.params));
            case 'network.removeIntercept':
                return await this.#networkProcessor.removeIntercept(this.#parser.parseRemoveInterceptParams(command.params));
            case 'network.setCacheBehavior':
                return await this.#networkProcessor.setCacheBehavior(this.#parser.parseSetCacheBehavior(command.params));
            // keep-sorted end
            // Permissions module
            // keep-sorted start block=yes
            case 'permissions.setPermission':
                return await this.#permissionsProcessor.setPermissions(this.#parser.parseSetPermissionsParams(command.params));
            // keep-sorted end
            // Script module
            // keep-sorted start block=yes
            case 'script.addPreloadScript':
                return await this.#scriptProcessor.addPreloadScript(this.#parser.parseAddPreloadScriptParams(command.params));
            case 'script.callFunction':
                return await this.#scriptProcessor.callFunction(this.#parser.parseCallFunctionParams(this.#processTargetParams(command.params)));
            case 'script.disown':
                return await this.#scriptProcessor.disown(this.#parser.parseDisownParams(this.#processTargetParams(command.params)));
            case 'script.evaluate':
                return await this.#scriptProcessor.evaluate(this.#parser.parseEvaluateParams(this.#processTargetParams(command.params)));
            case 'script.getRealms':
                return this.#scriptProcessor.getRealms(this.#parser.parseGetRealmsParams(command.params));
            case 'script.removePreloadScript':
                return await this.#scriptProcessor.removePreloadScript(this.#parser.parseRemovePreloadScriptParams(command.params));
            // keep-sorted end
            // Session module
            // keep-sorted start block=yes
            case 'session.end':
                throw new protocol_js_1.UnknownErrorException(`Method ${command.method} is not implemented.`);
            case 'session.new':
                return await this.#sessionProcessor.new(command.params);
            case 'session.status':
                return this.#sessionProcessor.status();
            case 'session.subscribe':
                return await this.#sessionProcessor.subscribe(this.#parser.parseSubscribeParams(command.params), command.channel);
            case 'session.unsubscribe':
                return await this.#sessionProcessor.unsubscribe(this.#parser.parseUnsubscribeParams(command.params), command.channel);
            // keep-sorted end
            // Storage module
            // keep-sorted start block=yes
            case 'storage.deleteCookies':
                return await this.#storageProcessor.deleteCookies(this.#parser.parseDeleteCookiesParams(command.params));
            case 'storage.getCookies':
                return await this.#storageProcessor.getCookies(this.#parser.parseGetCookiesParams(command.params));
            case 'storage.setCookie':
                return await this.#storageProcessor.setCookie(this.#parser.parseSetCookieParams(command.params));
            // keep-sorted end
            // WebExtension module
            // keep-sorted start block=yes
            case 'webExtension.install':
                throw new protocol_js_1.UnknownErrorException(`Method ${command.method} is not implemented.`);
            case 'webExtension.uninstall':
                throw new protocol_js_1.UnknownErrorException(`Method ${command.method} is not implemented.`);
            // keep-sorted end
        }
        // Intentionally kept outside the switch statement to ensure that
        // ESLint @typescript-eslint/switch-exhaustiveness-check triggers if a new
        // command is added.
        throw new protocol_js_1.UnknownCommandException(`Unknown command '${command?.method}'.`);
    }
    // Workaround for as zod.union always take the first schema
    // https://github.com/w3c/webdriver-bidi/issues/635
    #processTargetParams(params) {
        if (typeof params === 'object' &&
            params &&
            'target' in params &&
            typeof params.target === 'object' &&
            params.target &&
            'context' in params.target) {
            delete params.target['realm'];
        }
        return params;
    }
    async processCommand(command) {
        try {
            const result = await this.#processCommand(command);
            const response = {
                type: 'success',
                id: command.id,
                result,
            };
            this.emit("response" /* CommandProcessorEvents.Response */, {
                message: OutgoingMessage_js_1.OutgoingMessage.createResolved(response, command.channel),
                event: command.method,
            });
        }
        catch (e) {
            if (e instanceof protocol_js_1.Exception) {
                this.emit("response" /* CommandProcessorEvents.Response */, {
                    message: OutgoingMessage_js_1.OutgoingMessage.createResolved(e.toErrorResponse(command.id), command.channel),
                    event: command.method,
                });
            }
            else {
                const error = e;
                this.#logger?.(log_js_1.LogType.bidi, error);
                this.emit("response" /* CommandProcessorEvents.Response */, {
                    message: OutgoingMessage_js_1.OutgoingMessage.createResolved(new protocol_js_1.UnknownErrorException(error.message, error.stack).toErrorResponse(command.id), command.channel),
                    event: command.method,
                });
            }
        }
    }
}
exports.CommandProcessor = CommandProcessor;
//# sourceMappingURL=CommandProcessor.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/OutgoingMessage.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2021 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OutgoingMessage = void 0;
class OutgoingMessage {
    #message;
    #channel;
    constructor(message, channel) {
        this.#message = message;
        this.#channel = channel;
    }
    static createFromPromise(messagePromise, channel) {
        return messagePromise.then((message) => {
            if (message.kind === 'success') {
                return {
                    kind: 'success',
                    value: new OutgoingMessage(message.value, channel),
                };
            }
            return message;
        });
    }
    static createResolved(message, channel) {
        return Promise.resolve({
            kind: 'success',
            value: new OutgoingMessage(message, channel),
        });
    }
    get message() {
        return this.#message;
    }
    get channel() {
        return this.#channel;
    }
}
exports.OutgoingMessage = OutgoingMessage;
//# sourceMappingURL=OutgoingMessage.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/bluetooth/BluetoothProcessor.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BluetoothProcessor = void 0;
class BluetoothProcessor {
    #eventManager;
    #browsingContextStorage;
    constructor(eventManager, browsingContextStorage) {
        this.#eventManager = eventManager;
        this.#browsingContextStorage = browsingContextStorage;
    }
    async simulateAdapter(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        // Bluetooth spec requires overriding the existing adapter (step 6). From the CDP
        // perspective, we need to disable the emulation first.
        // https://webbluetoothcg.github.io/web-bluetooth/#bluetooth-simulateAdapter-command
        await context.cdpTarget.browserCdpClient.sendCommand('BluetoothEmulation.disable');
        await context.cdpTarget.browserCdpClient.sendCommand('BluetoothEmulation.enable', {
            state: params.state,
        });
        return {};
    }
    async simulatePreconnectedPeripheral(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        await context.cdpTarget.browserCdpClient.sendCommand('BluetoothEmulation.simulatePreconnectedPeripheral', {
            address: params.address,
            name: params.name,
            knownServiceUuids: params.knownServiceUuids,
            manufacturerData: params.manufacturerData,
        });
        return {};
    }
    async simulateAdvertisement(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        await context.cdpTarget.browserCdpClient.sendCommand('BluetoothEmulation.simulateAdvertisement', {
            entry: params.scanEntry,
        });
        return {};
    }
    onCdpTargetCreated(cdpTarget) {
        cdpTarget.cdpClient.on('DeviceAccess.deviceRequestPrompted', (event) => {
            this.#eventManager.registerEvent({
                type: 'event',
                method: 'bluetooth.requestDevicePromptUpdated',
                params: {
                    context: cdpTarget.id,
                    prompt: event.id,
                    devices: event.devices,
                },
            }, cdpTarget.id);
        });
    }
    async handleRequestDevicePrompt(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        if (params.accept) {
            await context.cdpTarget.cdpClient.sendCommand('DeviceAccess.selectPrompt', {
                id: params.prompt,
                deviceId: params.device,
            });
        }
        else {
            await context.cdpTarget.cdpClient.sendCommand('DeviceAccess.cancelPrompt', {
                id: params.prompt,
            });
        }
        return {};
    }
}
exports.BluetoothProcessor = BluetoothProcessor;
//# sourceMappingURL=BluetoothProcessor.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/browser/BrowserProcessor.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BrowserProcessor = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
class BrowserProcessor {
    #browserCdpClient;
    #browsingContextStorage;
    constructor(browserCdpClient, browsingContextStorage) {
        this.#browserCdpClient = browserCdpClient;
        this.#browsingContextStorage = browsingContextStorage;
    }
    close() {
        // Ensure that it is put at the end of the event loop.
        // This way we send back the response before closing the tab.
        setTimeout(() => this.#browserCdpClient.sendCommand('Browser.close'), 0);
        return {};
    }
    async createUserContext(params) {
        const request = {
            proxyServer: params['goog:proxyServer'] ?? undefined,
        };
        const proxyBypassList = params['goog:proxyBypassList'] ?? undefined;
        if (proxyBypassList) {
            request.proxyBypassList = proxyBypassList.join(',');
        }
        const context = await this.#browserCdpClient.sendCommand('Target.createBrowserContext', request);
        return {
            userContext: context.browserContextId,
        };
    }
    async removeUserContext(params) {
        const userContext = params.userContext;
        if (userContext === 'default') {
            throw new protocol_js_1.InvalidArgumentException('`default` user context cannot be removed');
        }
        try {
            await this.#browserCdpClient.sendCommand('Target.disposeBrowserContext', {
                browserContextId: userContext,
            });
        }
        catch (err) {
            // https://source.chromium.org/chromium/chromium/src/+/main:content/browser/devtools/protocol/target_handler.cc;l=1424;drc=c686e8f4fd379312469fe018f5c390e9c8f20d0d
            if (err.message.startsWith('Failed to find context with id')) {
                throw new protocol_js_1.NoSuchUserContextException(err.message);
            }
            throw err;
        }
        return {};
    }
    async getUserContexts() {
        const result = await this.#browserCdpClient.sendCommand('Target.getBrowserContexts');
        return {
            userContexts: [
                {
                    userContext: 'default',
                },
                ...result.browserContextIds.map((id) => {
                    return {
                        userContext: id,
                    };
                }),
            ],
        };
    }
    async #getWindowInfo(targetId) {
        const windowInfo = await this.#browserCdpClient.sendCommand('Browser.getWindowForTarget', { targetId });
        return {
            // `active` is not supported in CDP yet.
            active: false,
            clientWindow: `${windowInfo.windowId}`,
            state: windowInfo.bounds.windowState ?? 'normal',
            height: windowInfo.bounds.height ?? 0,
            width: windowInfo.bounds.width ?? 0,
            x: windowInfo.bounds.left ?? 0,
            y: windowInfo.bounds.top ?? 0,
        };
    }
    async getClientWindows() {
        const topLevelTargetIds = this.#browsingContextStorage
            .getTopLevelContexts()
            .map((b) => b.cdpTarget.id);
        const clientWindows = await Promise.all(topLevelTargetIds.map(async (targetId) => await this.#getWindowInfo(targetId)));
        const uniqueClientWindowIds = new Set();
        const uniqueClientWindows = new Array();
        // Filter out duplicated client windows.
        for (const window of clientWindows) {
            if (!uniqueClientWindowIds.has(window.clientWindow)) {
                uniqueClientWindowIds.add(window.clientWindow);
                uniqueClientWindows.push(window);
            }
        }
        return { clientWindows: uniqueClientWindows };
    }
}
exports.BrowserProcessor = BrowserProcessor;
//# sourceMappingURL=BrowserProcessor.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/cdp/CdpProcessor.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CdpProcessor = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
class CdpProcessor {
    #browsingContextStorage;
    #realmStorage;
    #cdpConnection;
    #browserCdpClient;
    constructor(browsingContextStorage, realmStorage, cdpConnection, browserCdpClient) {
        this.#browsingContextStorage = browsingContextStorage;
        this.#realmStorage = realmStorage;
        this.#cdpConnection = cdpConnection;
        this.#browserCdpClient = browserCdpClient;
    }
    getSession(params) {
        const context = params.context;
        const sessionId = this.#browsingContextStorage.getContext(context).cdpTarget.cdpSessionId;
        if (sessionId === undefined) {
            return {};
        }
        return { session: sessionId };
    }
    resolveRealm(params) {
        const context = params.realm;
        const realm = this.#realmStorage.getRealm({ realmId: context });
        if (realm === undefined) {
            throw new protocol_js_1.UnknownErrorException(`Could not find realm ${params.realm}`);
        }
        return { executionContextId: realm.executionContextId };
    }
    async sendCommand(params) {
        const client = params.session
            ? this.#cdpConnection.getCdpClient(params.session)
            : this.#browserCdpClient;
        const result = await client.sendCommand(params.method, params.params);
        return {
            result,
            session: params.session,
        };
    }
}
exports.CdpProcessor = CdpProcessor;
//# sourceMappingURL=CdpProcessor.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/cdp/CdpTarget.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CdpTarget = void 0;
const chromium_bidi_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/chromium-bidi.js");
const Deferred_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/Deferred.js");
const EventEmitter_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/EventEmitter.js");
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
const BrowsingContextImpl_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/context/BrowsingContextImpl.js");
const LogManager_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/log/LogManager.js");
class CdpTarget extends EventEmitter_js_1.EventEmitter {
    #id;
    #cdpClient;
    #browserCdpClient;
    #parentCdpClient;
    #realmStorage;
    #eventManager;
    #preloadScriptStorage;
    #browsingContextStorage;
    #prerenderingDisabled;
    #networkStorage;
    #unblocked = new Deferred_js_1.Deferred();
    #unhandledPromptBehavior;
    #logger;
    #deviceAccessEnabled = false;
    #cacheDisableState = false;
    #fetchDomainStages = {
        request: false,
        response: false,
        auth: false,
    };
    static create(targetId, cdpClient, browserCdpClient, parentCdpClient, realmStorage, eventManager, preloadScriptStorage, browsingContextStorage, networkStorage, prerenderingDisabled, unhandledPromptBehavior, logger) {
        const cdpTarget = new CdpTarget(targetId, cdpClient, browserCdpClient, parentCdpClient, eventManager, realmStorage, preloadScriptStorage, browsingContextStorage, networkStorage, prerenderingDisabled, unhandledPromptBehavior, logger);
        LogManager_js_1.LogManager.create(cdpTarget, realmStorage, eventManager, logger);
        cdpTarget.#setEventListeners();
        // No need to await.
        // Deferred will be resolved when the target is unblocked.
        void cdpTarget.#unblock();
        return cdpTarget;
    }
    constructor(targetId, cdpClient, browserCdpClient, parentCdpClient, eventManager, realmStorage, preloadScriptStorage, browsingContextStorage, networkStorage, prerenderingDisabled, unhandledPromptBehavior, logger) {
        super();
        this.#id = targetId;
        this.#cdpClient = cdpClient;
        this.#browserCdpClient = browserCdpClient;
        this.#parentCdpClient = parentCdpClient;
        this.#eventManager = eventManager;
        this.#realmStorage = realmStorage;
        this.#preloadScriptStorage = preloadScriptStorage;
        this.#networkStorage = networkStorage;
        this.#browsingContextStorage = browsingContextStorage;
        this.#prerenderingDisabled = prerenderingDisabled;
        this.#unhandledPromptBehavior = unhandledPromptBehavior;
        this.#logger = logger;
    }
    /** Returns a deferred that resolves when the target is unblocked. */
    get unblocked() {
        return this.#unblocked;
    }
    get id() {
        return this.#id;
    }
    get cdpClient() {
        return this.#cdpClient;
    }
    get parentCdpClient() {
        return this.#parentCdpClient;
    }
    get browserCdpClient() {
        return this.#browserCdpClient;
    }
    /** Needed for CDP escape path. */
    get cdpSessionId() {
        // SAFETY we got the client by it's id for creating
        return this.#cdpClient.sessionId;
    }
    /**
     * Enables all the required CDP domains and unblocks the target.
     */
    async #unblock() {
        try {
            await Promise.all([
                this.#cdpClient.sendCommand('Page.enable'),
                // There can be some existing frames in the target, if reconnecting to an
                // existing browser instance, e.g. via Puppeteer. Need to restore the browsing
                // contexts for the frames to correctly handle further events, like
                // `Runtime.executionContextCreated`.
                // It's important to schedule this task together with enabling domains commands to
                // prepare the tree before the events (e.g. Runtime.executionContextCreated) start
                // coming.
                // https://github.com/GoogleChromeLabs/chromium-bidi/issues/2282
                this.#cdpClient
                    .sendCommand('Page.getFrameTree')
                    .then((frameTree) => this.#restoreFrameTreeState(frameTree.frameTree)),
                this.#cdpClient.sendCommand('Runtime.enable'),
                this.#cdpClient.sendCommand('Page.setLifecycleEventsEnabled', {
                    enabled: true,
                }),
                this.#cdpClient
                    .sendCommand('Page.setPrerenderingAllowed', {
                    isAllowed: !this.#prerenderingDisabled,
                })
                    .catch(() => {
                    // Ignore CDP errors, as the command is not supported by iframe targets or
                    // prerendered pages. Generic catch, as the error can vary between CdpClient
                    // implementations: Tab vs Puppeteer.
                }),
                // Enabling CDP Network domain is required for navigation detection:
                // https://github.com/GoogleChromeLabs/chromium-bidi/issues/2856.
                this.#cdpClient
                    .sendCommand('Network.enable')
                    .then(() => this.toggleNetworkIfNeeded()),
                this.#cdpClient.sendCommand('Target.setAutoAttach', {
                    autoAttach: true,
                    waitForDebuggerOnStart: true,
                    flatten: true,
                }),
                this.#initAndEvaluatePreloadScripts(),
                this.#cdpClient.sendCommand('Runtime.runIfWaitingForDebugger'),
                // Resume tab execution as well if it was paused by the debugger.
                this.#parentCdpClient.sendCommand('Runtime.runIfWaitingForDebugger'),
                this.toggleDeviceAccessIfNeeded(),
            ]);
        }
        catch (error) {
            this.#logger?.(log_js_1.LogType.debugError, 'Failed to unblock target', error);
            // The target might have been closed before the initialization finished.
            if (!this.#cdpClient.isCloseError(error)) {
                this.#unblocked.resolve({
                    kind: 'error',
                    error,
                });
                return;
            }
        }
        this.#unblocked.resolve({
            kind: 'success',
            value: undefined,
        });
    }
    #restoreFrameTreeState(frameTree) {
        const frame = frameTree.frame;
        const maybeContext = this.#browsingContextStorage.findContext(frame.id);
        if (maybeContext !== undefined) {
            // Restoring parent of already known browsing context. This means the target is
            // OOPiF and the BiDi session was connected to already existing browser instance.
            if (maybeContext.parentId === null &&
                frame.parentId !== null &&
                frame.parentId !== undefined) {
                maybeContext.parentId = frame.parentId;
            }
        }
        if (maybeContext === undefined && frame.parentId !== undefined) {
            // Restore not yet known nested frames. The top-level frame is created when the
            // target is attached.
            const parentBrowsingContext = this.#browsingContextStorage.getContext(frame.parentId);
            BrowsingContextImpl_js_1.BrowsingContextImpl.create(frame.id, frame.parentId, parentBrowsingContext.userContext, parentBrowsingContext.cdpTarget, this.#eventManager, this.#browsingContextStorage, this.#realmStorage, frame.url, undefined, this.#unhandledPromptBehavior, this.#logger);
        }
        frameTree.childFrames?.map((frameTree) => this.#restoreFrameTreeState(frameTree));
    }
    async toggleFetchIfNeeded() {
        const stages = this.#networkStorage.getInterceptionStages(this.topLevelId);
        if (this.#fetchDomainStages.request === stages.request &&
            this.#fetchDomainStages.response === stages.response &&
            this.#fetchDomainStages.auth === stages.auth) {
            return;
        }
        const patterns = [];
        this.#fetchDomainStages = stages;
        if (stages.request || stages.auth) {
            // CDP quirk we need request interception when we intercept auth
            patterns.push({
                urlPattern: '*',
                requestStage: 'Request',
            });
        }
        if (stages.response) {
            patterns.push({
                urlPattern: '*',
                requestStage: 'Response',
            });
        }
        if (patterns.length) {
            await this.#cdpClient.sendCommand('Fetch.enable', {
                patterns,
                handleAuthRequests: stages.auth,
            });
        }
        else {
            const blockedRequest = this.#networkStorage
                .getRequestsByTarget(this)
                .filter((request) => request.interceptPhase);
            void Promise.allSettled(blockedRequest.map((request) => request.waitNextPhase))
                .then(async () => {
                const blockedRequest = this.#networkStorage
                    .getRequestsByTarget(this)
                    .filter((request) => request.interceptPhase);
                if (blockedRequest.length) {
                    return await this.toggleFetchIfNeeded();
                }
                return await this.#cdpClient.sendCommand('Fetch.disable');
            })
                .catch((error) => {
                this.#logger?.(log_js_1.LogType.bidi, 'Disable failed', error);
            });
        }
    }
    /**
     * Toggles CDP "Fetch" domain and enable/disable network cache.
     */
    async toggleNetworkIfNeeded() {
        // Although the Network domain remains active, Fetch domain activation and caching
        // settings should be managed dynamically.
        try {
            await Promise.all([
                this.toggleSetCacheDisabled(),
                this.toggleFetchIfNeeded(),
            ]);
        }
        catch (err) {
            this.#logger?.(log_js_1.LogType.debugError, err);
            if (!this.#isExpectedError(err)) {
                throw err;
            }
        }
    }
    async toggleSetCacheDisabled(disable) {
        const defaultCacheDisabled = this.#networkStorage.defaultCacheBehavior === 'bypass';
        const cacheDisabled = disable ?? defaultCacheDisabled;
        if (this.#cacheDisableState === cacheDisabled) {
            return;
        }
        this.#cacheDisableState = cacheDisabled;
        try {
            await this.#cdpClient.sendCommand('Network.setCacheDisabled', {
                cacheDisabled,
            });
        }
        catch (err) {
            this.#logger?.(log_js_1.LogType.debugError, err);
            this.#cacheDisableState = !cacheDisabled;
            if (!this.#isExpectedError(err)) {
                throw err;
            }
        }
    }
    async toggleDeviceAccessIfNeeded() {
        const enabled = this.isSubscribedTo(chromium_bidi_js_1.Bluetooth.EventNames.RequestDevicePromptUpdated);
        if (this.#deviceAccessEnabled === enabled) {
            return;
        }
        this.#deviceAccessEnabled = enabled;
        try {
            await this.#cdpClient.sendCommand(enabled ? 'DeviceAccess.enable' : 'DeviceAccess.disable');
        }
        catch (err) {
            this.#logger?.(log_js_1.LogType.debugError, err);
            this.#deviceAccessEnabled = !enabled;
            if (!this.#isExpectedError(err)) {
                throw err;
            }
        }
    }
    /**
     * Heuristic checking if the error is due to the session being closed. If so, ignore the
     * error.
     */
    #isExpectedError(err) {
        const error = err;
        return ((error.code === -32001 &&
            error.message === 'Session with given id not found.') ||
            this.#cdpClient.isCloseError(err));
    }
    #setEventListeners() {
        this.#cdpClient.on('Network.requestWillBeSent', (eventParams) => {
            if (eventParams.loaderId === eventParams.requestId) {
                this.emit("frameStartedNavigating" /* TargetEvents.FrameStartedNavigating */, {
                    loaderId: eventParams.loaderId,
                    url: eventParams.request.url,
                    frameId: eventParams.frameId,
                });
            }
        });
        this.#cdpClient.on('*', (event, params) => {
            // We may encounter uses for EventEmitter other than CDP events,
            // which we want to skip.
            if (typeof event !== 'string') {
                return;
            }
            this.#eventManager.registerEvent({
                type: 'event',
                method: `goog:cdp.${event}`,
                params: {
                    event,
                    params,
                    session: this.cdpSessionId,
                },
            }, this.id);
            // Duplicate the event to the deprecated event name.
            // https://github.com/GoogleChromeLabs/chromium-bidi/issues/2844
            this.#eventManager.registerEvent({
                type: 'event',
                method: `cdp.${event}`,
                params: {
                    event,
                    params,
                    session: this.cdpSessionId,
                },
            }, this.id);
        });
    }
    async #enableFetch(stages) {
        const patterns = [];
        if (stages.request || stages.auth) {
            // CDP quirk we need request interception when we intercept auth
            patterns.push({
                urlPattern: '*',
                requestStage: 'Request',
            });
        }
        if (stages.response) {
            patterns.push({
                urlPattern: '*',
                requestStage: 'Response',
            });
        }
        if (patterns.length) {
            const oldStages = this.#fetchDomainStages;
            this.#fetchDomainStages = stages;
            try {
                await this.#cdpClient.sendCommand('Fetch.enable', {
                    patterns,
                    handleAuthRequests: stages.auth,
                });
            }
            catch {
                this.#fetchDomainStages = oldStages;
            }
        }
    }
    async #disableFetch() {
        const blockedRequest = this.#networkStorage
            .getRequestsByTarget(this)
            .filter((request) => request.interceptPhase);
        if (blockedRequest.length === 0) {
            this.#fetchDomainStages = {
                request: false,
                response: false,
                auth: false,
            };
            await this.#cdpClient.sendCommand('Fetch.disable');
        }
    }
    async toggleNetwork() {
        const stages = this.#networkStorage.getInterceptionStages(this.topLevelId);
        const fetchEnable = Object.values(stages).some((value) => value);
        const fetchChanged = this.#fetchDomainStages.request !== stages.request ||
            this.#fetchDomainStages.response !== stages.response ||
            this.#fetchDomainStages.auth !== stages.auth;
        this.#logger?.(log_js_1.LogType.debugInfo, 'Toggle Network', `Fetch (${fetchEnable}) ${fetchChanged}`);
        if (fetchEnable && fetchChanged) {
            await this.#enableFetch(stages);
        }
        if (!fetchEnable && fetchChanged) {
            await this.#disableFetch();
        }
    }
    /**
     * All the ProxyChannels from all the preload scripts of the given
     * BrowsingContext.
     */
    getChannels() {
        return this.#preloadScriptStorage
            .find()
            .flatMap((script) => script.channels);
    }
    /** Loads all top-level preload scripts. */
    async #initAndEvaluatePreloadScripts() {
        await Promise.all(this.#preloadScriptStorage
            .find({
            // Needed for OOPIF
            targetId: this.topLevelId,
            global: true,
        })
            .map((script) => {
            return script.initInTarget(this, true);
        }));
    }
    get topLevelId() {
        return (this.#browsingContextStorage.findTopLevelContextId(this.id) ?? this.id);
    }
    isSubscribedTo(moduleOrEvent) {
        return this.#eventManager.subscriptionManager.isSubscribedTo(moduleOrEvent, this.topLevelId);
    }
}
exports.CdpTarget = CdpTarget;
//# sourceMappingURL=CdpTarget.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/cdp/CdpTargetManager.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CdpTargetManager = void 0;
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
const BrowsingContextImpl_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/context/BrowsingContextImpl.js");
const WorkerRealm_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/WorkerRealm.js");
const CdpTarget_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/cdp/CdpTarget.js");
const cdpToBidiTargetTypes = {
    service_worker: 'service-worker',
    shared_worker: 'shared-worker',
    worker: 'dedicated-worker',
};
class CdpTargetManager {
    #browserCdpClient;
    #cdpConnection;
    #targetKeysToBeIgnoredByAutoAttach = new Set();
    #selfTargetId;
    #eventManager;
    #browsingContextStorage;
    #networkStorage;
    #bluetoothProcessor;
    #preloadScriptStorage;
    #realmStorage;
    #defaultUserContextId;
    #logger;
    #unhandledPromptBehavior;
    #prerenderingDisabled;
    constructor(cdpConnection, browserCdpClient, selfTargetId, eventManager, browsingContextStorage, realmStorage, networkStorage, bluetoothProcessor, preloadScriptStorage, defaultUserContextId, prerenderingDisabled, unhandledPromptBehavior, logger) {
        this.#cdpConnection = cdpConnection;
        this.#browserCdpClient = browserCdpClient;
        this.#targetKeysToBeIgnoredByAutoAttach.add(selfTargetId);
        this.#selfTargetId = selfTargetId;
        this.#eventManager = eventManager;
        this.#browsingContextStorage = browsingContextStorage;
        this.#preloadScriptStorage = preloadScriptStorage;
        this.#networkStorage = networkStorage;
        this.#bluetoothProcessor = bluetoothProcessor;
        this.#realmStorage = realmStorage;
        this.#defaultUserContextId = defaultUserContextId;
        this.#prerenderingDisabled = prerenderingDisabled;
        this.#unhandledPromptBehavior = unhandledPromptBehavior;
        this.#logger = logger;
        this.#setEventListeners(browserCdpClient);
    }
    /**
     * This method is called for each CDP session, since this class is responsible
     * for creating and destroying all targets and browsing contexts.
     */
    #setEventListeners(cdpClient) {
        cdpClient.on('Target.attachedToTarget', (params) => {
            this.#handleAttachedToTargetEvent(params, cdpClient);
        });
        cdpClient.on('Target.detachedFromTarget', this.#handleDetachedFromTargetEvent.bind(this));
        cdpClient.on('Target.targetInfoChanged', this.#handleTargetInfoChangedEvent.bind(this));
        cdpClient.on('Inspector.targetCrashed', () => {
            this.#handleTargetCrashedEvent(cdpClient);
        });
        cdpClient.on('Page.frameAttached', this.#handleFrameAttachedEvent.bind(this));
        cdpClient.on('Page.frameSubtreeWillBeDetached', this.#handleFrameSubtreeWillBeDetached.bind(this));
    }
    #handleFrameAttachedEvent(params) {
        const parentBrowsingContext = this.#browsingContextStorage.findContext(params.parentFrameId);
        if (parentBrowsingContext !== undefined) {
            BrowsingContextImpl_js_1.BrowsingContextImpl.create(params.frameId, params.parentFrameId, parentBrowsingContext.userContext, parentBrowsingContext.cdpTarget, this.#eventManager, this.#browsingContextStorage, this.#realmStorage, 
            // At this point, we don't know the URL of the frame yet, so it will be updated
            // later.
            'about:blank', undefined, this.#unhandledPromptBehavior, this.#logger);
        }
    }
    #handleFrameSubtreeWillBeDetached(params) {
        this.#browsingContextStorage.findContext(params.frameId)?.dispose(true);
    }
    #handleAttachedToTargetEvent(params, parentSessionCdpClient) {
        const { sessionId, targetInfo } = params;
        const targetCdpClient = this.#cdpConnection.getCdpClient(sessionId);
        const detach = async () => {
            // Detaches and resumes the target suppressing errors.
            await targetCdpClient
                .sendCommand('Runtime.runIfWaitingForDebugger')
                .then(() => parentSessionCdpClient.sendCommand('Target.detachFromTarget', params))
                .catch((error) => this.#logger?.(log_js_1.LogType.debugError, error));
        };
        // Do not attach to the Mapper target.
        if (this.#selfTargetId === targetInfo.targetId) {
            void detach();
            return;
        }
        // Service workers are special case because they attach to the
        // browser target and the page target (so twice per worker) during
        // the regular auto-attach and might hang if the CDP session on
        // the browser level is not detached. The logic to detach the
        // right session is handled in the switch below.
        const targetKey = targetInfo.type === 'service_worker'
            ? `${parentSessionCdpClient.sessionId}_${targetInfo.targetId}`
            : targetInfo.targetId;
        // Mapper generally only needs one session per target. If we
        // receive additional auto-attached sessions, that is very likely
        // coming from custom CDP sessions.
        if (this.#targetKeysToBeIgnoredByAutoAttach.has(targetKey)) {
            // Return to leave the session untouched.
            return;
        }
        this.#targetKeysToBeIgnoredByAutoAttach.add(targetKey);
        switch (targetInfo.type) {
            case 'tab':
                // Tab targets are required only to handle page targets beneath them.
                this.#setEventListeners(targetCdpClient);
                // Auto-attach to the page target. No need in resuming tab target debugger, as it
                // should preserve the page target debugger state, and will be resumed by the page
                // target.
                void (async () => {
                    await targetCdpClient.sendCommand('Target.setAutoAttach', {
                        autoAttach: true,
                        waitForDebuggerOnStart: true,
                        flatten: true,
                    });
                })();
                return;
            case 'page':
            case 'iframe': {
                const cdpTarget = this.#createCdpTarget(targetCdpClient, parentSessionCdpClient, targetInfo);
                const maybeContext = this.#browsingContextStorage.findContext(targetInfo.targetId);
                if (maybeContext && targetInfo.type === 'iframe') {
                    // OOPiF.
                    maybeContext.updateCdpTarget(cdpTarget);
                }
                else {
                    // If attaching to existing browser instance, there could be OOPiF targets. This
                    // case is handled by the `findFrameParentId` method.
                    const parentId = this.#findFrameParentId(targetInfo, parentSessionCdpClient.sessionId);
                    const userContext = targetInfo.browserContextId &&
                        targetInfo.browserContextId !== this.#defaultUserContextId
                        ? targetInfo.browserContextId
                        : 'default';
                    // New context.
                    BrowsingContextImpl_js_1.BrowsingContextImpl.create(targetInfo.targetId, parentId, userContext, cdpTarget, this.#eventManager, this.#browsingContextStorage, this.#realmStorage, 
                    // Hack: when a new target created, CDP emits targetInfoChanged with an empty
                    // url, and navigates it to about:blank later. When the event is emitted for
                    // an existing target (reconnect), the url is already known, and navigation
                    // events will not be emitted anymore. Replacing empty url with `about:blank`
                    // allows to handle both cases in the same way.
                    // "7.3.2.1 Creating browsing contexts".
                    // https://html.spec.whatwg.org/multipage/document-sequences.html#creating-browsing-contexts
                    // TODO: check who to deal with non-null creator and its `creatorOrigin`.
                    targetInfo.url === '' ? 'about:blank' : targetInfo.url, targetInfo.openerFrameId ?? targetInfo.openerId, this.#unhandledPromptBehavior, this.#logger);
                }
                return;
            }
            case 'service_worker':
            case 'worker': {
                const realm = this.#realmStorage.findRealm({
                    cdpSessionId: parentSessionCdpClient.sessionId,
                });
                // If there is no browsing context, this worker is already terminated.
                if (!realm) {
                    void detach();
                    return;
                }
                const cdpTarget = this.#createCdpTarget(targetCdpClient, parentSessionCdpClient, targetInfo);
                this.#handleWorkerTarget(cdpToBidiTargetTypes[targetInfo.type], cdpTarget, realm);
                return;
            }
            // In CDP, we only emit shared workers on the browser and not the set of
            // frames that use the shared worker. If we change this in the future to
            // behave like service workers (emits on both browser and frame targets),
            // we can remove this block and merge service workers with the above one.
            case 'shared_worker': {
                const cdpTarget = this.#createCdpTarget(targetCdpClient, parentSessionCdpClient, targetInfo);
                this.#handleWorkerTarget(cdpToBidiTargetTypes[targetInfo.type], cdpTarget);
                return;
            }
        }
        // DevTools or some other not supported by BiDi target. Just release
        // debugger and ignore them.
        void detach();
    }
    /** Try to find the parent browsing context ID for the given attached target. */
    #findFrameParentId(targetInfo, parentSessionId) {
        if (targetInfo.type !== 'iframe') {
            return null;
        }
        const parentId = targetInfo.openerFrameId ?? targetInfo.openerId;
        if (parentId !== undefined) {
            return parentId;
        }
        if (parentSessionId !== undefined) {
            return (this.#browsingContextStorage.findContextBySession(parentSessionId)
                ?.id ?? null);
        }
        return null;
    }
    #createCdpTarget(targetCdpClient, parentCdpClient, targetInfo) {
        this.#setEventListeners(targetCdpClient);
        const target = CdpTarget_js_1.CdpTarget.create(targetInfo.targetId, targetCdpClient, this.#browserCdpClient, parentCdpClient, this.#realmStorage, this.#eventManager, this.#preloadScriptStorage, this.#browsingContextStorage, this.#networkStorage, this.#prerenderingDisabled, this.#unhandledPromptBehavior, this.#logger);
        this.#networkStorage.onCdpTargetCreated(target);
        this.#bluetoothProcessor.onCdpTargetCreated(target);
        return target;
    }
    #workers = new Map();
    #handleWorkerTarget(realmType, cdpTarget, ownerRealm) {
        cdpTarget.cdpClient.on('Runtime.executionContextCreated', (params) => {
            const { uniqueId, id, origin } = params.context;
            const workerRealm = new WorkerRealm_js_1.WorkerRealm(cdpTarget.cdpClient, this.#eventManager, id, this.#logger, (0, BrowsingContextImpl_js_1.serializeOrigin)(origin), ownerRealm ? [ownerRealm] : [], uniqueId, this.#realmStorage, realmType);
            this.#workers.set(cdpTarget.cdpSessionId, workerRealm);
        });
    }
    #handleDetachedFromTargetEvent({ sessionId, targetId, }) {
        if (targetId) {
            this.#preloadScriptStorage.find({ targetId }).map((preloadScript) => {
                preloadScript.dispose(targetId);
            });
        }
        const context = this.#browsingContextStorage.findContextBySession(sessionId);
        if (context) {
            context.dispose(true);
            return;
        }
        const worker = this.#workers.get(sessionId);
        if (worker) {
            this.#realmStorage.deleteRealms({
                cdpSessionId: worker.cdpClient.sessionId,
            });
        }
    }
    #handleTargetInfoChangedEvent(params) {
        const context = this.#browsingContextStorage.findContext(params.targetInfo.targetId);
        if (context) {
            context.onTargetInfoChanged(params);
        }
    }
    #handleTargetCrashedEvent(cdpClient) {
        // This is primarily used for service and shared workers. CDP tends to not
        // signal they closed gracefully and instead says they crashed to signal
        // they are closed.
        const realms = this.#realmStorage.findRealms({
            cdpSessionId: cdpClient.sessionId,
        });
        for (const realm of realms) {
            realm.dispose();
        }
    }
}
exports.CdpTargetManager = CdpTargetManager;
//# sourceMappingURL=CdpTargetManager.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/context/BrowsingContextImpl.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2022 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BrowsingContextImpl = void 0;
exports.serializeOrigin = serializeOrigin;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const assert_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/assert.js");
const Deferred_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/Deferred.js");
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
const time_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/time.js");
const unitConversions_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/unitConversions.js");
const WindowRealm_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/WindowRealm.js");
const NavigationTracker_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/context/NavigationTracker.js");
class BrowsingContextImpl {
    static LOGGER_PREFIX = `${log_js_1.LogType.debug}:browsingContext`;
    /** Direct children browsing contexts. */
    #children = new Set();
    /** The ID of this browsing context. */
    #id;
    userContext;
    /**
     * The ID of the parent browsing context.
     * If null, this is a top-level context.
     */
    #loaderId;
    #parentId = null;
    // Keeps track of the previously set viewport.
    #previousViewport = { width: 0, height: 0 };
    #originalOpener;
    #lifecycle = {
        DOMContentLoaded: new Deferred_js_1.Deferred(),
        load: new Deferred_js_1.Deferred(),
    };
    #cdpTarget;
    #defaultRealmDeferred = new Deferred_js_1.Deferred();
    #browsingContextStorage;
    #eventManager;
    #logger;
    #navigationTracker;
    #realmStorage;
    // The deferred will be resolved when the default realm is created.
    #unhandledPromptBehavior;
    // Set when the user prompt is opened. Required to provide the type in closing event.
    #lastUserPromptType;
    constructor(id, parentId, userContext, cdpTarget, eventManager, browsingContextStorage, realmStorage, url, originalOpener, unhandledPromptBehavior, logger) {
        this.#cdpTarget = cdpTarget;
        this.#id = id;
        this.#parentId = parentId;
        this.userContext = userContext;
        this.#eventManager = eventManager;
        this.#browsingContextStorage = browsingContextStorage;
        this.#realmStorage = realmStorage;
        this.#unhandledPromptBehavior = unhandledPromptBehavior;
        this.#logger = logger;
        this.#originalOpener = originalOpener;
        this.#navigationTracker = new NavigationTracker_js_1.NavigationTracker(url, id, eventManager, logger);
    }
    static create(id, parentId, userContext, cdpTarget, eventManager, browsingContextStorage, realmStorage, url, originalOpener, unhandledPromptBehavior, logger) {
        const context = new _a(id, parentId, userContext, cdpTarget, eventManager, browsingContextStorage, realmStorage, url, originalOpener, unhandledPromptBehavior, logger);
        context.#initListeners();
        browsingContextStorage.addContext(context);
        if (!context.isTopLevelContext()) {
            context.parent.addChild(context.id);
        }
        // Hold on the `contextCreated` event until the target is unblocked. This is required,
        // as the parent of the context can be set later in case of reconnecting to an
        // existing browser instance + OOPiF.
        eventManager.registerPromiseEvent(context.targetUnblockedOrThrow().then(() => {
            return {
                kind: 'success',
                value: {
                    type: 'event',
                    method: protocol_js_1.ChromiumBidi.BrowsingContext.EventNames.ContextCreated,
                    params: {
                        ...context.serializeToBidiValue(),
                        // Hack to provide the initial URL of the context, as it can be changed
                        // between the page target is attached and unblocked, as the page is not
                        // fully paused in MPArch session (https://crbug.com/372842894).
                        // TODO: remove once https://crbug.com/372842894 is addressed.
                        url,
                    },
                },
            };
        }, (error) => {
            return {
                kind: 'error',
                error,
            };
        }), context.id, protocol_js_1.ChromiumBidi.BrowsingContext.EventNames.ContextCreated);
        return context;
    }
    /**
     * @see https://html.spec.whatwg.org/multipage/document-sequences.html#navigable
     */
    get navigableId() {
        return this.#loaderId;
    }
    get navigationId() {
        return this.#navigationTracker.currentNavigationId;
    }
    dispose(emitContextDestroyed) {
        this.#navigationTracker.dispose();
        this.#realmStorage.deleteRealms({
            browsingContextId: this.id,
        });
        // Delete context from the parent.
        if (!this.isTopLevelContext()) {
            this.parent.#children.delete(this.id);
        }
        // Fail all ongoing navigations.
        this.#failLifecycleIfNotFinished();
        if (emitContextDestroyed) {
            this.#eventManager.registerEvent({
                type: 'event',
                method: protocol_js_1.ChromiumBidi.BrowsingContext.EventNames.ContextDestroyed,
                params: this.serializeToBidiValue(null),
            }, this.id);
        }
        // Dispose children after the events are emitted.
        this.#deleteAllChildren();
        this.#eventManager.clearBufferedEvents(this.id);
        this.#browsingContextStorage.deleteContextById(this.id);
    }
    /** Returns the ID of this context. */
    get id() {
        return this.#id;
    }
    /** Returns the parent context ID. */
    get parentId() {
        return this.#parentId;
    }
    /** Sets the parent context ID and updates parent's children. */
    set parentId(parentId) {
        if (this.#parentId !== null) {
            this.#logger?.(log_js_1.LogType.debugError, 'Parent context already set');
            // Cannot do anything except logging, as throwing will stop event processing. So
            // just return,
            return;
        }
        this.#parentId = parentId;
        if (!this.isTopLevelContext()) {
            this.parent.addChild(this.id);
        }
    }
    /** Returns the parent context. */
    get parent() {
        if (this.parentId === null) {
            return null;
        }
        return this.#browsingContextStorage.getContext(this.parentId);
    }
    /** Returns all direct children contexts. */
    get directChildren() {
        return [...this.#children].map((id) => this.#browsingContextStorage.getContext(id));
    }
    /** Returns all children contexts, flattened. */
    get allChildren() {
        const children = this.directChildren;
        return children.concat(...children.map((child) => child.allChildren));
    }
    /**
     * Returns true if this is a top-level context.
     * This is the case whenever the parent context ID is null.
     */
    isTopLevelContext() {
        return this.#parentId === null;
    }
    get top() {
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        let topContext = this;
        let parent = topContext.parent;
        while (parent) {
            topContext = parent;
            parent = topContext.parent;
        }
        return topContext;
    }
    addChild(childId) {
        this.#children.add(childId);
    }
    #deleteAllChildren(emitContextDestroyed = false) {
        this.directChildren.map((child) => child.dispose(emitContextDestroyed));
    }
    get cdpTarget() {
        return this.#cdpTarget;
    }
    updateCdpTarget(cdpTarget) {
        this.#cdpTarget = cdpTarget;
        this.#initListeners();
    }
    get url() {
        return this.#navigationTracker.url;
    }
    async lifecycleLoaded() {
        await this.#lifecycle.load;
    }
    async targetUnblockedOrThrow() {
        const result = await this.#cdpTarget.unblocked;
        if (result.kind === 'error') {
            throw result.error;
        }
    }
    async getOrCreateSandbox(sandbox) {
        if (sandbox === undefined || sandbox === '') {
            // Default realm is not guaranteed to be created at this point, so return a deferred.
            return await this.#defaultRealmDeferred;
        }
        let maybeSandboxes = this.#realmStorage.findRealms({
            browsingContextId: this.id,
            sandbox,
        });
        if (maybeSandboxes.length === 0) {
            await this.#cdpTarget.cdpClient.sendCommand('Page.createIsolatedWorld', {
                frameId: this.id,
                worldName: sandbox,
            });
            // `Runtime.executionContextCreated` should be emitted by the time the
            // previous command is done.
            maybeSandboxes = this.#realmStorage.findRealms({
                browsingContextId: this.id,
                sandbox,
            });
            (0, assert_js_1.assert)(maybeSandboxes.length !== 0);
        }
        // It's possible for more than one sandbox to be created due to provisional
        // frames. In this case, it's always the first one (i.e. the oldest one)
        // that is more relevant since the user may have set that one up already
        // through evaluation.
        return maybeSandboxes[0];
    }
    /**
     * Implements https://w3c.github.io/webdriver-bidi/#get-the-navigable-info.
     */
    serializeToBidiValue(maxDepth = 0, addParentField = true) {
        return {
            context: this.#id,
            url: this.url,
            userContext: this.userContext,
            originalOpener: this.#originalOpener ?? null,
            // TODO(#2646): Implement Client Window correctly
            clientWindow: '',
            children: maxDepth === null || maxDepth > 0
                ? this.directChildren.map((c) => c.serializeToBidiValue(maxDepth === null ? maxDepth : maxDepth - 1, false))
                : null,
            ...(addParentField ? { parent: this.#parentId } : {}),
        };
    }
    onTargetInfoChanged(params) {
        this.#navigationTracker.onTargetInfoChanged(params.targetInfo.url);
    }
    #initListeners() {
        this.#cdpTarget.cdpClient.on('Network.loadingFailed', (params) => {
            // Detect navigation errors like `net::ERR_BLOCKED_BY_RESPONSE`.
            // Network related to navigation has request id equals to navigation's loader id.
            this.#navigationTracker.networkLoadingFailed(params.requestId, params.errorText);
        });
        this.#cdpTarget.cdpClient.on('Page.frameNavigated', (params) => {
            if (this.id !== params.frame.id) {
                return;
            }
            this.#navigationTracker.frameNavigated(params.frame.url + (params.frame.urlFragment ?? ''), params.frame.loaderId, 
            // `unreachableUrl` indicates if the navigation failed.
            params.frame.unreachableUrl);
            // At the point the page is initialized, all the nested iframes from the
            // previous page are detached and realms are destroyed.
            // Delete children from context.
            this.#deleteAllChildren();
            this.#documentChanged(params.frame.loaderId);
        });
        this.#cdpTarget.on("frameStartedNavigating" /* TargetEvents.FrameStartedNavigating */, (params) => {
            this.#logger?.(log_js_1.LogType.debugInfo, `Received ${"frameStartedNavigating" /* TargetEvents.FrameStartedNavigating */} event`, params);
            // The frame ID can be either a browsing context id, or not set in case of the frame
            // is the top-level in the current CDP target.
            const possibleFrameIds = [
                this.id,
                ...(this.cdpTarget.id === this.id ? [undefined] : []),
            ];
            if (!possibleFrameIds.includes(params.frameId)) {
                return;
            }
            this.#navigationTracker.frameStartedNavigating(params.url, params.loaderId);
        });
        this.#cdpTarget.cdpClient.on('Page.navigatedWithinDocument', (params) => {
            if (this.id !== params.frameId) {
                return;
            }
            this.#navigationTracker.navigatedWithinDocument(params.url, params.navigationType);
            if (params.navigationType === 'historyApi') {
                this.#eventManager.registerEvent({
                    type: 'event',
                    method: 'browsingContext.historyUpdated',
                    params: {
                        context: this.id,
                        url: this.#navigationTracker.url,
                    },
                }, this.id);
                return;
            }
        });
        this.#cdpTarget.cdpClient.on('Page.frameRequestedNavigation', (params) => {
            if (this.id !== params.frameId) {
                return;
            }
            this.#navigationTracker.frameRequestedNavigation(params.url);
        });
        this.#cdpTarget.cdpClient.on('Page.lifecycleEvent', (params) => {
            if (this.id !== params.frameId) {
                return;
            }
            if (params.name === 'init') {
                this.#documentChanged(params.loaderId);
                return;
            }
            if (params.name === 'commit') {
                this.#loaderId = params.loaderId;
                return;
            }
            // If mapper attached to the page late, it might miss init and
            // commit events. In that case, save the first loaderId for this
            // frameId.
            if (!this.#loaderId) {
                this.#loaderId = params.loaderId;
            }
            // Ignore event from not current navigation.
            if (params.loaderId !== this.#loaderId) {
                return;
            }
            switch (params.name) {
                case 'DOMContentLoaded':
                    if (!this.#navigationTracker.isInitialNavigation) {
                        // Do not emit for the initial navigation.
                        this.#eventManager.registerEvent({
                            type: 'event',
                            method: protocol_js_1.ChromiumBidi.BrowsingContext.EventNames.DomContentLoaded,
                            params: {
                                context: this.id,
                                navigation: this.#navigationTracker.currentNavigationId,
                                timestamp: (0, time_js_1.getTimestamp)(),
                                url: this.#navigationTracker.url,
                            },
                        }, this.id);
                    }
                    this.#lifecycle.DOMContentLoaded.resolve();
                    break;
                case 'load':
                    if (!this.#navigationTracker.isInitialNavigation) {
                        // Do not emit for the initial navigation.
                        this.#eventManager.registerEvent({
                            type: 'event',
                            method: protocol_js_1.ChromiumBidi.BrowsingContext.EventNames.Load,
                            params: {
                                context: this.id,
                                navigation: this.#navigationTracker.currentNavigationId,
                                timestamp: (0, time_js_1.getTimestamp)(),
                                url: this.#navigationTracker.url,
                            },
                        }, this.id);
                    }
                    // The initial navigation is finished.
                    this.#navigationTracker.loadPageEvent(params.loaderId);
                    this.#lifecycle.load.resolve();
                    break;
            }
        });
        this.#cdpTarget.cdpClient.on('Runtime.executionContextCreated', (params) => {
            const { auxData, name, uniqueId, id } = params.context;
            if (!auxData || auxData.frameId !== this.id) {
                return;
            }
            let origin;
            let sandbox;
            // Only these execution contexts are supported for now.
            switch (auxData.type) {
                case 'isolated':
                    sandbox = name;
                    // Sandbox should have the same origin as the context itself, but in CDP
                    // it has an empty one.
                    if (!this.#defaultRealmDeferred.isFinished) {
                        this.#logger?.(log_js_1.LogType.debugError, 'Unexpectedly, isolated realm created before the default one');
                    }
                    origin = this.#defaultRealmDeferred.isFinished
                        ? this.#defaultRealmDeferred.result.origin
                        : // This fallback is not expected to be ever reached.
                            '';
                    break;
                case 'default':
                    origin = serializeOrigin(params.context.origin);
                    break;
                default:
                    return;
            }
            const realm = new WindowRealm_js_1.WindowRealm(this.id, this.#browsingContextStorage, this.#cdpTarget.cdpClient, this.#eventManager, id, this.#logger, origin, uniqueId, this.#realmStorage, sandbox);
            if (auxData.isDefault) {
                this.#defaultRealmDeferred.resolve(realm);
                // Initialize ChannelProxy listeners for all the channels of all the
                // preload scripts related to this BrowsingContext.
                // TODO: extend for not default realms by the sandbox name.
                void Promise.all(this.#cdpTarget
                    .getChannels()
                    .map((channel) => channel.startListenerFromWindow(realm, this.#eventManager)));
            }
        });
        this.#cdpTarget.cdpClient.on('Runtime.executionContextDestroyed', (params) => {
            if (this.#defaultRealmDeferred.isFinished &&
                this.#defaultRealmDeferred.result.executionContextId ===
                    params.executionContextId) {
                this.#defaultRealmDeferred = new Deferred_js_1.Deferred();
            }
            this.#realmStorage.deleteRealms({
                cdpSessionId: this.#cdpTarget.cdpSessionId,
                executionContextId: params.executionContextId,
            });
        });
        this.#cdpTarget.cdpClient.on('Runtime.executionContextsCleared', () => {
            if (!this.#defaultRealmDeferred.isFinished) {
                this.#defaultRealmDeferred.reject(new protocol_js_1.UnknownErrorException('execution contexts cleared'));
            }
            this.#defaultRealmDeferred = new Deferred_js_1.Deferred();
            this.#realmStorage.deleteRealms({
                cdpSessionId: this.#cdpTarget.cdpSessionId,
            });
        });
        this.#cdpTarget.cdpClient.on('Page.javascriptDialogClosed', (params) => {
            const accepted = params.result;
            if (this.#lastUserPromptType === undefined) {
                this.#logger?.(log_js_1.LogType.debugError, 'Unexpectedly no opening prompt event before closing one');
            }
            this.#eventManager.registerEvent({
                type: 'event',
                method: protocol_js_1.ChromiumBidi.BrowsingContext.EventNames.UserPromptClosed,
                params: {
                    context: this.id,
                    accepted,
                    // `lastUserPromptType` should never be undefined here, so fallback to
                    // `UNKNOWN`. The fallback is required to prevent tests from hanging while
                    // waiting for the closing event. The cast is required, as the `UNKNOWN` value
                    // is not standard.
                    type: this.#lastUserPromptType ??
                        'UNKNOWN',
                    userText: accepted && params.userInput ? params.userInput : undefined,
                },
            }, this.id);
            this.#lastUserPromptType = undefined;
        });
        this.#cdpTarget.cdpClient.on('Page.javascriptDialogOpening', (params) => {
            const promptType = _a.#getPromptType(params.type);
            if (params.type === 'beforeunload') {
                this.#navigationTracker.beforeunload();
            }
            // Set the last prompt type to provide it in closing event.
            this.#lastUserPromptType = promptType;
            const promptHandler = this.#getPromptHandler(promptType);
            this.#eventManager.registerEvent({
                type: 'event',
                method: protocol_js_1.ChromiumBidi.BrowsingContext.EventNames.UserPromptOpened,
                params: {
                    context: this.id,
                    handler: promptHandler,
                    type: promptType,
                    message: params.message,
                    ...(params.type === 'prompt'
                        ? { defaultValue: params.defaultPrompt }
                        : {}),
                },
            }, this.id);
            switch (promptHandler) {
                // Based on `unhandledPromptBehavior`, check if the prompt should be handled
                // automatically (`accept`, `dismiss`) or wait for the user to do it.
                case "accept" /* Session.UserPromptHandlerType.Accept */:
                    void this.handleUserPrompt(true);
                    break;
                case "dismiss" /* Session.UserPromptHandlerType.Dismiss */:
                    void this.handleUserPrompt(false);
                    break;
                case "ignore" /* Session.UserPromptHandlerType.Ignore */:
                    break;
            }
        });
    }
    static #getPromptType(cdpType) {
        switch (cdpType) {
            case 'alert':
                return "alert" /* BrowsingContext.UserPromptType.Alert */;
            case 'beforeunload':
                return "beforeunload" /* BrowsingContext.UserPromptType.Beforeunload */;
            case 'confirm':
                return "confirm" /* BrowsingContext.UserPromptType.Confirm */;
            case 'prompt':
                return "prompt" /* BrowsingContext.UserPromptType.Prompt */;
        }
    }
    #getPromptHandler(promptType) {
        const defaultPromptHandler = "dismiss" /* Session.UserPromptHandlerType.Dismiss */;
        switch (promptType) {
            case "alert" /* BrowsingContext.UserPromptType.Alert */:
                return (this.#unhandledPromptBehavior?.alert ??
                    this.#unhandledPromptBehavior?.default ??
                    defaultPromptHandler);
            case "beforeunload" /* BrowsingContext.UserPromptType.Beforeunload */:
                return (this.#unhandledPromptBehavior?.beforeUnload ??
                    this.#unhandledPromptBehavior?.default ??
                    "accept" /* Session.UserPromptHandlerType.Accept */);
            case "confirm" /* BrowsingContext.UserPromptType.Confirm */:
                return (this.#unhandledPromptBehavior?.confirm ??
                    this.#unhandledPromptBehavior?.default ??
                    defaultPromptHandler);
            case "prompt" /* BrowsingContext.UserPromptType.Prompt */:
                return (this.#unhandledPromptBehavior?.prompt ??
                    this.#unhandledPromptBehavior?.default ??
                    defaultPromptHandler);
        }
    }
    #documentChanged(loaderId) {
        if (loaderId === undefined || this.#loaderId === loaderId) {
            return;
        }
        // Document changed.
        this.#resetLifecycleIfFinished();
        this.#loaderId = loaderId;
        // Delete all child iframes and notify about top level destruction.
        this.#deleteAllChildren(true);
    }
    #resetLifecycleIfFinished() {
        if (this.#lifecycle.DOMContentLoaded.isFinished) {
            this.#lifecycle.DOMContentLoaded = new Deferred_js_1.Deferred();
        }
        else {
            this.#logger?.(_a.LOGGER_PREFIX, 'Document changed (DOMContentLoaded)');
        }
        if (this.#lifecycle.load.isFinished) {
            this.#lifecycle.load = new Deferred_js_1.Deferred();
        }
        else {
            this.#logger?.(_a.LOGGER_PREFIX, 'Document changed (load)');
        }
    }
    #failLifecycleIfNotFinished() {
        if (!this.#lifecycle.DOMContentLoaded.isFinished) {
            this.#lifecycle.DOMContentLoaded.reject(new protocol_js_1.UnknownErrorException('navigation canceled'));
        }
        if (!this.#lifecycle.load.isFinished) {
            this.#lifecycle.load.reject(new protocol_js_1.UnknownErrorException('navigation canceled'));
        }
    }
    async navigate(url, wait) {
        try {
            new URL(url);
        }
        catch {
            throw new protocol_js_1.InvalidArgumentException(`Invalid URL: ${url}`);
        }
        const navigationState = this.#navigationTracker.createPendingNavigation(url);
        // Navigate and wait for the result. If the navigation fails, the error event is
        // emitted and the promise is rejected.
        const cdpNavigatePromise = (async () => {
            const cdpNavigateResult = await this.#cdpTarget.cdpClient.sendCommand('Page.navigate', {
                url,
                frameId: this.id,
            });
            if (cdpNavigateResult.errorText) {
                // If navigation failed, no pending navigation is left.
                this.#navigationTracker.failNavigation(navigationState, cdpNavigateResult.errorText);
                throw new protocol_js_1.UnknownErrorException(cdpNavigateResult.errorText);
            }
            this.#navigationTracker.navigationCommandFinished(navigationState, cdpNavigateResult.loaderId);
            this.#documentChanged(cdpNavigateResult.loaderId);
        })();
        // Wait for either the navigation is finished or canceled by another navigation.
        const result = await Promise.race([
            // No `loaderId` means same-document navigation.
            this.#waitNavigation(wait, cdpNavigatePromise, navigationState),
            // Throw an error if the navigation is canceled.
            navigationState.finished,
        ]);
        if (result instanceof NavigationTracker_js_1.NavigationResult) {
            if (
            // TODO: check after decision on the spec is done:
            //  https://github.com/w3c/webdriver-bidi/issues/799.
            result.eventName === "browsingContext.navigationAborted" /* NavigationEventName.NavigationAborted */ ||
                result.eventName === "browsingContext.navigationFailed" /* NavigationEventName.NavigationFailed */) {
                throw new protocol_js_1.UnknownErrorException(result.message ?? 'unknown exception');
            }
        }
        return {
            navigation: navigationState.navigationId,
            // Url can change due to redirects. Get the one from commandNavigation.
            url: navigationState.url,
        };
    }
    async #waitNavigation(wait, cdpCommandPromise, navigationState) {
        if (wait === "none" /* BrowsingContext.ReadinessState.None */) {
            return;
        }
        await cdpCommandPromise;
        if (navigationState.isFragmentNavigation === true) {
            // After the cdp command is finished, the `fragmentNavigation` should be already
            // settled. If it's the fragment navigation, wait for the `navigationStatus` to be
            // finished, which happens after the fragment navigation happened. No need to wait for
            // DOM events.
            await navigationState.finished;
            return;
        }
        if (wait === "interactive" /* BrowsingContext.ReadinessState.Interactive */) {
            await this.#lifecycle.DOMContentLoaded;
            return;
        }
        if (wait === "complete" /* BrowsingContext.ReadinessState.Complete */) {
            await this.#lifecycle.load;
            return;
        }
        throw new protocol_js_1.InvalidArgumentException(`Wait condition ${wait} is not supported`);
    }
    // TODO: support concurrent navigations analogous to `navigate`.
    async reload(ignoreCache, wait) {
        await this.targetUnblockedOrThrow();
        this.#resetLifecycleIfFinished();
        const navigationState = this.#navigationTracker.createPendingNavigation(this.#navigationTracker.url);
        const cdpReloadPromise = this.#cdpTarget.cdpClient.sendCommand('Page.reload', {
            ignoreCache,
        });
        // Wait for either the navigation is finished or canceled by another navigation.
        const result = await Promise.race([
            // No `loaderId` means same-document navigation.
            this.#waitNavigation(wait, cdpReloadPromise, navigationState),
            // Throw an error if the navigation is canceled.
            navigationState.finished,
        ]);
        if (result instanceof NavigationTracker_js_1.NavigationResult) {
            if (result.eventName === "browsingContext.navigationAborted" /* NavigationEventName.NavigationAborted */ ||
                result.eventName === "browsingContext.navigationFailed" /* NavigationEventName.NavigationFailed */) {
                throw new protocol_js_1.UnknownErrorException(result.message ?? 'unknown exception');
            }
        }
        return {
            navigation: navigationState.navigationId,
            // Url can change due to redirects. Get the one from commandNavigation.
            url: navigationState.url,
        };
    }
    async setViewport(viewport, devicePixelRatio) {
        if (viewport === null && devicePixelRatio === null) {
            await this.#cdpTarget.cdpClient.sendCommand('Emulation.clearDeviceMetricsOverride');
        }
        else {
            try {
                let appliedViewport;
                if (viewport === undefined) {
                    appliedViewport = this.#previousViewport;
                }
                else if (viewport === null) {
                    appliedViewport = {
                        width: 0,
                        height: 0,
                    };
                }
                else {
                    appliedViewport = viewport;
                }
                this.#previousViewport = appliedViewport;
                await this.#cdpTarget.cdpClient.sendCommand('Emulation.setDeviceMetricsOverride', {
                    width: this.#previousViewport.width,
                    height: this.#previousViewport.height,
                    deviceScaleFactor: devicePixelRatio ? devicePixelRatio : 0,
                    mobile: false,
                    dontSetVisibleSize: true,
                });
            }
            catch (err) {
                if (err.message.startsWith(
                // https://crsrc.org/c/content/browser/devtools/protocol/emulation_handler.cc;l=257;drc=2f6eee84cf98d4227e7c41718dd71b82f26d90ff
                'Width and height values must be positive')) {
                    throw new protocol_js_1.UnsupportedOperationException('Provided viewport dimensions are not supported');
                }
                throw err;
            }
        }
    }
    async handleUserPrompt(accept, userText) {
        await this.#cdpTarget.cdpClient.sendCommand('Page.handleJavaScriptDialog', {
            accept: accept ?? true,
            promptText: userText,
        });
    }
    async activate() {
        await this.#cdpTarget.cdpClient.sendCommand('Page.bringToFront');
    }
    async captureScreenshot(params) {
        if (!this.isTopLevelContext()) {
            throw new protocol_js_1.UnsupportedOperationException(`Non-top-level 'context' (${params.context}) is currently not supported`);
        }
        const formatParameters = getImageFormatParameters(params);
        let captureBeyondViewport = false;
        let script;
        params.origin ??= 'viewport';
        switch (params.origin) {
            case 'document': {
                script = String(() => {
                    const element = document.documentElement;
                    return {
                        x: 0,
                        y: 0,
                        width: element.scrollWidth,
                        height: element.scrollHeight,
                    };
                });
                captureBeyondViewport = true;
                break;
            }
            case 'viewport': {
                script = String(() => {
                    const viewport = window.visualViewport;
                    return {
                        x: viewport.pageLeft,
                        y: viewport.pageTop,
                        width: viewport.width,
                        height: viewport.height,
                    };
                });
                break;
            }
        }
        const realm = await this.getOrCreateSandbox(undefined);
        const originResult = await realm.callFunction(script, false);
        (0, assert_js_1.assert)(originResult.type === 'success');
        const origin = deserializeDOMRect(originResult.result);
        (0, assert_js_1.assert)(origin);
        let rect = origin;
        if (params.clip) {
            const clip = params.clip;
            if (params.origin === 'viewport' && clip.type === 'box') {
                // For viewport origin, the clip is relative to the viewport, while the CDP
                // screenshot is relative to the document. So correction for the viewport position
                // is required.
                clip.x += origin.x;
                clip.y += origin.y;
            }
            rect = getIntersectionRect(await this.#parseRect(clip), origin);
        }
        if (rect.width === 0 || rect.height === 0) {
            throw new protocol_js_1.UnableToCaptureScreenException(`Unable to capture screenshot with zero dimensions: width=${rect.width}, height=${rect.height}`);
        }
        return await this.#cdpTarget.cdpClient.sendCommand('Page.captureScreenshot', {
            clip: { ...rect, scale: 1.0 },
            ...formatParameters,
            captureBeyondViewport,
        });
    }
    async print(params) {
        if (!this.isTopLevelContext()) {
            throw new protocol_js_1.UnsupportedOperationException('Printing of non-top level contexts is not supported');
        }
        const cdpParams = {};
        if (params.background !== undefined) {
            cdpParams.printBackground = params.background;
        }
        if (params.margin?.bottom !== undefined) {
            cdpParams.marginBottom = (0, unitConversions_js_1.inchesFromCm)(params.margin.bottom);
        }
        if (params.margin?.left !== undefined) {
            cdpParams.marginLeft = (0, unitConversions_js_1.inchesFromCm)(params.margin.left);
        }
        if (params.margin?.right !== undefined) {
            cdpParams.marginRight = (0, unitConversions_js_1.inchesFromCm)(params.margin.right);
        }
        if (params.margin?.top !== undefined) {
            cdpParams.marginTop = (0, unitConversions_js_1.inchesFromCm)(params.margin.top);
        }
        if (params.orientation !== undefined) {
            cdpParams.landscape = params.orientation === 'landscape';
        }
        if (params.page?.height !== undefined) {
            cdpParams.paperHeight = (0, unitConversions_js_1.inchesFromCm)(params.page.height);
        }
        if (params.page?.width !== undefined) {
            cdpParams.paperWidth = (0, unitConversions_js_1.inchesFromCm)(params.page.width);
        }
        if (params.pageRanges !== undefined) {
            for (const range of params.pageRanges) {
                if (typeof range === 'number') {
                    continue;
                }
                const rangeParts = range.split('-');
                if (rangeParts.length < 1 || rangeParts.length > 2) {
                    throw new protocol_js_1.InvalidArgumentException(`Invalid page range: ${range} is not a valid integer range.`);
                }
                if (rangeParts.length === 1) {
                    void parseInteger(rangeParts[0] ?? '');
                    continue;
                }
                let lowerBound;
                let upperBound;
                const [rangeLowerPart = '', rangeUpperPart = ''] = rangeParts;
                if (rangeLowerPart === '') {
                    lowerBound = 1;
                }
                else {
                    lowerBound = parseInteger(rangeLowerPart);
                }
                if (rangeUpperPart === '') {
                    upperBound = Number.MAX_SAFE_INTEGER;
                }
                else {
                    upperBound = parseInteger(rangeUpperPart);
                }
                if (lowerBound > upperBound) {
                    throw new protocol_js_1.InvalidArgumentException(`Invalid page range: ${rangeLowerPart} > ${rangeUpperPart}`);
                }
            }
            cdpParams.pageRanges = params.pageRanges.join(',');
        }
        if (params.scale !== undefined) {
            cdpParams.scale = params.scale;
        }
        if (params.shrinkToFit !== undefined) {
            cdpParams.preferCSSPageSize = !params.shrinkToFit;
        }
        try {
            const result = await this.#cdpTarget.cdpClient.sendCommand('Page.printToPDF', cdpParams);
            return {
                data: result.data,
            };
        }
        catch (error) {
            // Effectively zero dimensions.
            if (error.message ===
                'invalid print parameters: content area is empty') {
                throw new protocol_js_1.UnsupportedOperationException(error.message);
            }
            throw error;
        }
    }
    /**
     * See
     * https://w3c.github.io/webdriver-bidi/#:~:text=If%20command%20parameters%20contains%20%22clip%22%3A
     */
    async #parseRect(clip) {
        switch (clip.type) {
            case 'box':
                return { x: clip.x, y: clip.y, width: clip.width, height: clip.height };
            case 'element': {
                // TODO: #1213: Use custom sandbox specifically for Chromium BiDi
                const sandbox = await this.getOrCreateSandbox(undefined);
                const result = await sandbox.callFunction(String((element) => {
                    return element instanceof Element;
                }), false, { type: 'undefined' }, [clip.element]);
                if (result.type === 'exception') {
                    throw new protocol_js_1.NoSuchElementException(`Element '${clip.element.sharedId}' was not found`);
                }
                (0, assert_js_1.assert)(result.result.type === 'boolean');
                if (!result.result.value) {
                    throw new protocol_js_1.NoSuchElementException(`Node '${clip.element.sharedId}' is not an Element`);
                }
                {
                    const result = await sandbox.callFunction(String((element) => {
                        const rect = element.getBoundingClientRect();
                        return {
                            x: rect.x,
                            y: rect.y,
                            height: rect.height,
                            width: rect.width,
                        };
                    }), false, { type: 'undefined' }, [clip.element]);
                    (0, assert_js_1.assert)(result.type === 'success');
                    const rect = deserializeDOMRect(result.result);
                    if (!rect) {
                        throw new protocol_js_1.UnableToCaptureScreenException(`Could not get bounding box for Element '${clip.element.sharedId}'`);
                    }
                    return rect;
                }
            }
        }
    }
    async close() {
        await this.#cdpTarget.cdpClient.sendCommand('Page.close');
    }
    async traverseHistory(delta) {
        if (delta === 0) {
            return;
        }
        const history = await this.#cdpTarget.cdpClient.sendCommand('Page.getNavigationHistory');
        const entry = history.entries[history.currentIndex + delta];
        if (!entry) {
            throw new protocol_js_1.NoSuchHistoryEntryException(`No history entry at delta ${delta}`);
        }
        await this.#cdpTarget.cdpClient.sendCommand('Page.navigateToHistoryEntry', {
            entryId: entry.id,
        });
    }
    async toggleModulesIfNeeded() {
        await Promise.all([
            this.#cdpTarget.toggleNetworkIfNeeded(),
            this.#cdpTarget.toggleDeviceAccessIfNeeded(),
        ]);
    }
    async locateNodes(params) {
        // TODO: create a dedicated sandbox instead of `#defaultRealm`.
        return await this.#locateNodesByLocator(await this.#defaultRealmDeferred, params.locator, params.startNodes ?? [], params.maxNodeCount, params.serializationOptions);
    }
    async #getLocatorDelegate(realm, locator, maxNodeCount, startNodes) {
        switch (locator.type) {
            case 'context':
                throw new Error('Unreachable');
            case 'css':
                return {
                    functionDeclaration: String((cssSelector, maxNodeCount, ...startNodes) => {
                        const locateNodesUsingCss = (element) => {
                            if (!(element instanceof HTMLElement ||
                                element instanceof Document ||
                                element instanceof DocumentFragment)) {
                                throw new Error('startNodes in css selector should be HTMLElement, Document or DocumentFragment');
                            }
                            return [...element.querySelectorAll(cssSelector)];
                        };
                        startNodes = startNodes.length > 0 ? startNodes : [document];
                        const returnedNodes = startNodes
                            .map((startNode) => 
                        // TODO: stop search early if `maxNodeCount` is reached.
                        locateNodesUsingCss(startNode))
                            .flat(1);
                        return maxNodeCount === 0
                            ? returnedNodes
                            : returnedNodes.slice(0, maxNodeCount);
                    }),
                    argumentsLocalValues: [
                        // `cssSelector`
                        { type: 'string', value: locator.value },
                        // `maxNodeCount` with `0` means no limit.
                        { type: 'number', value: maxNodeCount ?? 0 },
                        // `startNodes`
                        ...startNodes,
                    ],
                };
            case 'xpath':
                return {
                    functionDeclaration: String((xPathSelector, maxNodeCount, ...startNodes) => {
                        // https://w3c.github.io/webdriver-bidi/#locate-nodes-using-xpath
                        const evaluator = new XPathEvaluator();
                        const expression = evaluator.createExpression(xPathSelector);
                        const locateNodesUsingXpath = (element) => {
                            const xPathResult = expression.evaluate(element, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE);
                            const returnedNodes = [];
                            for (let i = 0; i < xPathResult.snapshotLength; i++) {
                                returnedNodes.push(xPathResult.snapshotItem(i));
                            }
                            return returnedNodes;
                        };
                        startNodes = startNodes.length > 0 ? startNodes : [document];
                        const returnedNodes = startNodes
                            .map((startNode) => 
                        // TODO: stop search early if `maxNodeCount` is reached.
                        locateNodesUsingXpath(startNode))
                            .flat(1);
                        return maxNodeCount === 0
                            ? returnedNodes
                            : returnedNodes.slice(0, maxNodeCount);
                    }),
                    argumentsLocalValues: [
                        // `xPathSelector`
                        { type: 'string', value: locator.value },
                        // `maxNodeCount` with `0` means no limit.
                        { type: 'number', value: maxNodeCount ?? 0 },
                        // `startNodes`
                        ...startNodes,
                    ],
                };
            case 'innerText':
                // https://w3c.github.io/webdriver-bidi/#locate-nodes-using-inner-text
                if (locator.value === '') {
                    throw new protocol_js_1.InvalidSelectorException('innerText locator cannot be empty');
                }
                return {
                    functionDeclaration: String((innerTextSelector, fullMatch, ignoreCase, maxNodeCount, maxDepth, ...startNodes) => {
                        const searchText = ignoreCase
                            ? innerTextSelector.toUpperCase()
                            : innerTextSelector;
                        const locateNodesUsingInnerText = (node, currentMaxDepth) => {
                            const returnedNodes = [];
                            if (node instanceof DocumentFragment ||
                                node instanceof Document) {
                                const children = [...node.children];
                                children.forEach((child) => 
                                // `currentMaxDepth` is not decremented intentionally according to
                                // https://github.com/w3c/webdriver-bidi/pull/713.
                                returnedNodes.push(...locateNodesUsingInnerText(child, currentMaxDepth)));
                                return returnedNodes;
                            }
                            if (!(node instanceof HTMLElement)) {
                                return [];
                            }
                            const element = node;
                            const nodeInnerText = ignoreCase
                                ? element.innerText?.toUpperCase()
                                : element.innerText;
                            if (!nodeInnerText.includes(searchText)) {
                                return [];
                            }
                            const childNodes = [];
                            for (const child of element.children) {
                                if (child instanceof HTMLElement) {
                                    childNodes.push(child);
                                }
                            }
                            if (childNodes.length === 0) {
                                if (fullMatch && nodeInnerText === searchText) {
                                    returnedNodes.push(element);
                                }
                                else {
                                    if (!fullMatch) {
                                        // Note: `nodeInnerText.includes(searchText)` is already checked
                                        returnedNodes.push(element);
                                    }
                                }
                            }
                            else {
                                const childNodeMatches = 
                                // Don't search deeper if `maxDepth` is reached.
                                currentMaxDepth <= 0
                                    ? []
                                    : childNodes
                                        .map((child) => locateNodesUsingInnerText(child, currentMaxDepth - 1))
                                        .flat(1);
                                if (childNodeMatches.length === 0) {
                                    // Note: `nodeInnerText.includes(searchText)` is already checked
                                    if (!fullMatch || nodeInnerText === searchText) {
                                        returnedNodes.push(element);
                                    }
                                }
                                else {
                                    returnedNodes.push(...childNodeMatches);
                                }
                            }
                            // TODO: stop search early if `maxNodeCount` is reached.
                            return returnedNodes;
                        };
                        // TODO: stop search early if `maxNodeCount` is reached.
                        startNodes = startNodes.length > 0 ? startNodes : [document];
                        const returnedNodes = startNodes
                            .map((startNode) => 
                        // TODO: stop search early if `maxNodeCount` is reached.
                        locateNodesUsingInnerText(startNode, maxDepth))
                            .flat(1);
                        return maxNodeCount === 0
                            ? returnedNodes
                            : returnedNodes.slice(0, maxNodeCount);
                    }),
                    argumentsLocalValues: [
                        // `innerTextSelector`
                        { type: 'string', value: locator.value },
                        // `fullMatch` with default `true`.
                        { type: 'boolean', value: locator.matchType !== 'partial' },
                        // `ignoreCase` with default `false`.
                        { type: 'boolean', value: locator.ignoreCase === true },
                        // `maxNodeCount` with `0` means no limit.
                        { type: 'number', value: maxNodeCount ?? 0 },
                        // `maxDepth` with default `1000` (same as default full serialization depth).
                        { type: 'number', value: locator.maxDepth ?? 1000 },
                        // `startNodes`
                        ...startNodes,
                    ],
                };
            case 'accessibility': {
                // https://w3c.github.io/webdriver-bidi/#locate-nodes-using-accessibility-attributes
                if (!locator.value.name && !locator.value.role) {
                    throw new protocol_js_1.InvalidSelectorException('Either name or role has to be specified');
                }
                // The next two commands cause a11y caches for the target to be
                // preserved. We probably do not need to disable them if the
                // client is using a11y features, but we could by calling
                // Accessibility.disable.
                await Promise.all([
                    this.#cdpTarget.cdpClient.sendCommand('Accessibility.enable'),
                    this.#cdpTarget.cdpClient.sendCommand('Accessibility.getRootAXNode'),
                ]);
                const bindings = await realm.evaluate(
                /* expression=*/ '({getAccessibleName, getAccessibleRole})', 
                /* awaitPromise=*/ false, "root" /* Script.ResultOwnership.Root */, 
                /* serializationOptions= */ undefined, 
                /* userActivation=*/ false, 
                /* includeCommandLineApi=*/ true);
                if (bindings.type !== 'success') {
                    throw new Error('Could not get bindings');
                }
                if (bindings.result.type !== 'object') {
                    throw new Error('Could not get bindings');
                }
                return {
                    functionDeclaration: String((name, role, bindings, maxNodeCount, ...startNodes) => {
                        const returnedNodes = [];
                        let aborted = false;
                        function collect(contextNodes, selector) {
                            if (aborted) {
                                return;
                            }
                            for (const contextNode of contextNodes) {
                                let match = true;
                                if (selector.role) {
                                    const role = bindings.getAccessibleRole(contextNode);
                                    if (selector.role !== role) {
                                        match = false;
                                    }
                                }
                                if (selector.name) {
                                    const name = bindings.getAccessibleName(contextNode);
                                    if (selector.name !== name) {
                                        match = false;
                                    }
                                }
                                if (match) {
                                    if (maxNodeCount !== 0 &&
                                        returnedNodes.length === maxNodeCount) {
                                        aborted = true;
                                        break;
                                    }
                                    returnedNodes.push(contextNode);
                                }
                                const childNodes = [];
                                for (const child of contextNode.children) {
                                    if (child instanceof HTMLElement) {
                                        childNodes.push(child);
                                    }
                                }
                                collect(childNodes, selector);
                            }
                        }
                        startNodes =
                            startNodes.length > 0
                                ? startNodes
                                : Array.from(document.documentElement.children).filter((c) => c instanceof HTMLElement);
                        collect(startNodes, {
                            role,
                            name,
                        });
                        return returnedNodes;
                    }),
                    argumentsLocalValues: [
                        // `name`
                        { type: 'string', value: locator.value.name || '' },
                        // `role`
                        { type: 'string', value: locator.value.role || '' },
                        // `bindings`.
                        { handle: bindings.result.handle },
                        // `maxNodeCount` with `0` means no limit.
                        { type: 'number', value: maxNodeCount ?? 0 },
                        // `startNodes`
                        ...startNodes,
                    ],
                };
            }
        }
    }
    async #locateNodesByLocator(realm, locator, startNodes, maxNodeCount, serializationOptions) {
        if (locator.type === 'context') {
            if (startNodes.length !== 0) {
                throw new protocol_js_1.InvalidArgumentException('Start nodes are not supported');
            }
            const contextId = locator.value.context;
            if (!contextId) {
                throw new protocol_js_1.InvalidSelectorException('Invalid context');
            }
            const context = this.#browsingContextStorage.getContext(contextId);
            const parent = context.parent;
            if (!parent) {
                throw new protocol_js_1.InvalidArgumentException('This context has no container');
            }
            try {
                const { backendNodeId } = await parent.#cdpTarget.cdpClient.sendCommand('DOM.getFrameOwner', {
                    frameId: contextId,
                });
                const { object } = await parent.#cdpTarget.cdpClient.sendCommand('DOM.resolveNode', {
                    backendNodeId,
                });
                const locatorResult = await realm.callFunction(`function () { return this; }`, false, { handle: object.objectId }, [], "none" /* Script.ResultOwnership.None */, serializationOptions);
                if (locatorResult.type === 'exception') {
                    throw new Error('Unknown exception');
                }
                return { nodes: [locatorResult.result] };
            }
            catch {
                throw new protocol_js_1.InvalidArgumentException('Context does not exist');
            }
        }
        const locatorDelegate = await this.#getLocatorDelegate(realm, locator, maxNodeCount, startNodes);
        serializationOptions = {
            ...serializationOptions,
            // The returned object is an array of nodes, so no need in deeper JS serialization.
            maxObjectDepth: 1,
        };
        const locatorResult = await realm.callFunction(locatorDelegate.functionDeclaration, false, { type: 'undefined' }, locatorDelegate.argumentsLocalValues, "none" /* Script.ResultOwnership.None */, serializationOptions);
        if (locatorResult.type !== 'success') {
            this.#logger?.(_a.LOGGER_PREFIX, 'Failed locateNodesByLocator', locatorResult);
            // Heuristic to detect invalid selector for different types of selectors.
            if (
            // CSS selector.
            locatorResult.exceptionDetails.text?.endsWith('is not a valid selector.') ||
                // XPath selector.
                locatorResult.exceptionDetails.text?.endsWith('is not a valid XPath expression.')) {
                throw new protocol_js_1.InvalidSelectorException(`Not valid selector ${typeof locator.value === 'string' ? locator.value : JSON.stringify(locator.value)}`);
            }
            // Heuristic to detect if the `startNode` is not an `HTMLElement` in css selector.
            if (locatorResult.exceptionDetails.text ===
                'Error: startNodes in css selector should be HTMLElement, Document or DocumentFragment') {
                throw new protocol_js_1.InvalidArgumentException('startNodes in css selector should be HTMLElement, Document or DocumentFragment');
            }
            throw new protocol_js_1.UnknownErrorException(`Unexpected error in selector script: ${locatorResult.exceptionDetails.text}`);
        }
        if (locatorResult.result.type !== 'array') {
            throw new protocol_js_1.UnknownErrorException(`Unexpected selector script result type: ${locatorResult.result.type}`);
        }
        // Check there are no non-node elements in the result.
        const nodes = locatorResult.result.value.map((value) => {
            if (value.type !== 'node') {
                throw new protocol_js_1.UnknownErrorException(`Unexpected selector script result element: ${value.type}`);
            }
            return value;
        });
        return { nodes };
    }
}
exports.BrowsingContextImpl = BrowsingContextImpl;
_a = BrowsingContextImpl;
function serializeOrigin(origin) {
    // https://html.spec.whatwg.org/multipage/origin.html#ascii-serialisation-of-an-origin
    if (['://', ''].includes(origin)) {
        origin = 'null';
    }
    return origin;
}
function getImageFormatParameters(params) {
    const { quality, type } = params.format ?? {
        type: 'image/png',
    };
    switch (type) {
        case 'image/png': {
            return { format: 'png' };
        }
        case 'image/jpeg': {
            return {
                format: 'jpeg',
                ...(quality === undefined ? {} : { quality: Math.round(quality * 100) }),
            };
        }
        case 'image/webp': {
            return {
                format: 'webp',
                ...(quality === undefined ? {} : { quality: Math.round(quality * 100) }),
            };
        }
    }
    throw new protocol_js_1.InvalidArgumentException(`Image format '${type}' is not a supported format`);
}
function deserializeDOMRect(result) {
    if (result.type !== 'object' || result.value === undefined) {
        return;
    }
    const x = result.value.find(([key]) => {
        return key === 'x';
    })?.[1];
    const y = result.value.find(([key]) => {
        return key === 'y';
    })?.[1];
    const height = result.value.find(([key]) => {
        return key === 'height';
    })?.[1];
    const width = result.value.find(([key]) => {
        return key === 'width';
    })?.[1];
    if (x?.type !== 'number' ||
        y?.type !== 'number' ||
        height?.type !== 'number' ||
        width?.type !== 'number') {
        return;
    }
    return {
        x: x.value,
        y: y.value,
        width: width.value,
        height: height.value,
    };
}
/** @see https://w3c.github.io/webdriver-bidi/#normalize-rect */
function normalizeRect(box) {
    return {
        ...(box.width < 0
            ? {
                x: box.x + box.width,
                width: -box.width,
            }
            : {
                x: box.x,
                width: box.width,
            }),
        ...(box.height < 0
            ? {
                y: box.y + box.height,
                height: -box.height,
            }
            : {
                y: box.y,
                height: box.height,
            }),
    };
}
/** @see https://w3c.github.io/webdriver-bidi/#rectangle-intersection */
function getIntersectionRect(first, second) {
    first = normalizeRect(first);
    second = normalizeRect(second);
    const x = Math.max(first.x, second.x);
    const y = Math.max(first.y, second.y);
    return {
        x,
        y,
        width: Math.max(Math.min(first.x + first.width, second.x + second.width) - x, 0),
        height: Math.max(Math.min(first.y + first.height, second.y + second.height) - y, 0),
    };
}
function parseInteger(value) {
    value = value.trim();
    if (!/^[0-9]+$/.test(value)) {
        throw new protocol_js_1.InvalidArgumentException(`Invalid integer: ${value}`);
    }
    return parseInt(value);
}
//# sourceMappingURL=BrowsingContextImpl.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/context/BrowsingContextProcessor.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BrowsingContextProcessor = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
class BrowsingContextProcessor {
    #browserCdpClient;
    #browsingContextStorage;
    #eventManager;
    constructor(browserCdpClient, browsingContextStorage, eventManager) {
        this.#browserCdpClient = browserCdpClient;
        this.#browsingContextStorage = browsingContextStorage;
        this.#eventManager = eventManager;
        this.#eventManager.addSubscribeHook(protocol_js_1.ChromiumBidi.BrowsingContext.EventNames.ContextCreated, this.#onContextCreatedSubscribeHook.bind(this));
    }
    getTree(params) {
        const resultContexts = params.root === undefined
            ? this.#browsingContextStorage.getTopLevelContexts()
            : [this.#browsingContextStorage.getContext(params.root)];
        return {
            contexts: resultContexts.map((c) => c.serializeToBidiValue(params.maxDepth ?? Number.MAX_VALUE)),
        };
    }
    async create(params) {
        let referenceContext;
        let userContext = 'default';
        if (params.referenceContext !== undefined) {
            referenceContext = this.#browsingContextStorage.getContext(params.referenceContext);
            if (!referenceContext.isTopLevelContext()) {
                throw new protocol_js_1.InvalidArgumentException(`referenceContext should be a top-level context`);
            }
            userContext = referenceContext.userContext;
        }
        if (params.userContext !== undefined) {
            userContext = params.userContext;
        }
        const existingContexts = this.#browsingContextStorage
            .getAllContexts()
            .filter((context) => context.userContext === userContext);
        let newWindow = false;
        switch (params.type) {
            case "tab" /* BrowsingContext.CreateType.Tab */:
                newWindow = false;
                break;
            case "window" /* BrowsingContext.CreateType.Window */:
                newWindow = true;
                break;
        }
        if (!existingContexts.length) {
            // If there are no contexts in the given user context, we need to set
            // newWindow to true as newWindow=false will be rejected.
            newWindow = true;
        }
        let result;
        try {
            result = await this.#browserCdpClient.sendCommand('Target.createTarget', {
                url: 'about:blank',
                newWindow,
                browserContextId: userContext === 'default' ? undefined : userContext,
                background: params.background === true,
            });
        }
        catch (err) {
            if (
            // See https://source.chromium.org/chromium/chromium/src/+/main:chrome/browser/devtools/protocol/target_handler.cc;l=90;drc=e80392ac11e48a691f4309964cab83a3a59e01c8
            err.message.startsWith('Failed to find browser context with id') ||
                // See https://source.chromium.org/chromium/chromium/src/+/main:headless/lib/browser/protocol/target_handler.cc;l=49;drc=e80392ac11e48a691f4309964cab83a3a59e01c8
                err.message === 'browserContextId') {
                throw new protocol_js_1.NoSuchUserContextException(`The context ${userContext} was not found`);
            }
            throw err;
        }
        // Wait for the new target to be attached and to be added to the browsing context
        // storage.
        const context = await this.#browsingContextStorage.waitForContext(result.targetId);
        // Wait for the new tab to be loaded to avoid race conditions in the
        // `browsingContext` events, when the `browsingContext.domContentLoaded` and
        // `browsingContext.load` events from the initial `about:blank` navigation
        // are emitted after the next navigation is started.
        // Details: https://github.com/web-platform-tests/wpt/issues/35846
        await context.lifecycleLoaded();
        return { context: context.id };
    }
    navigate(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        return context.navigate(params.url, params.wait ?? "none" /* BrowsingContext.ReadinessState.None */);
    }
    reload(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        return context.reload(params.ignoreCache ?? false, params.wait ?? "none" /* BrowsingContext.ReadinessState.None */);
    }
    async activate(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        if (!context.isTopLevelContext()) {
            throw new protocol_js_1.InvalidArgumentException('Activation is only supported on the top-level context');
        }
        await context.activate();
        return {};
    }
    async captureScreenshot(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        return await context.captureScreenshot(params);
    }
    async print(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        return await context.print(params);
    }
    async setViewport(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        if (!context.isTopLevelContext()) {
            throw new protocol_js_1.InvalidArgumentException('Emulating viewport is only supported on the top-level context');
        }
        await context.setViewport(params.viewport, params.devicePixelRatio);
        return {};
    }
    async traverseHistory(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        if (!context) {
            throw new protocol_js_1.InvalidArgumentException(`No browsing context with id ${params.context}`);
        }
        if (!context.isTopLevelContext()) {
            throw new protocol_js_1.InvalidArgumentException('Traversing history is only supported on the top-level context');
        }
        await context.traverseHistory(params.delta);
        return {};
    }
    async handleUserPrompt(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        try {
            await context.handleUserPrompt(params.accept, params.userText);
        }
        catch (error) {
            // Heuristically determine the error
            // https://source.chromium.org/chromium/chromium/src/+/main:content/browser/devtools/protocol/page_handler.cc;l=1085?q=%22No%20dialog%20is%20showing%22&ss=chromium
            if (error.message?.includes('No dialog is showing')) {
                throw new protocol_js_1.NoSuchAlertException('No dialog is showing');
            }
            throw error;
        }
        return {};
    }
    async close(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        if (!context.isTopLevelContext()) {
            throw new protocol_js_1.InvalidArgumentException(`Non top-level browsing context ${context.id} cannot be closed.`);
        }
        // Parent session of a page target session can be a `browser` or a `tab` session.
        const parentCdpClient = context.cdpTarget.parentCdpClient;
        try {
            const detachedFromTargetPromise = new Promise((resolve) => {
                const onContextDestroyed = (event) => {
                    if (event.targetId === params.context) {
                        parentCdpClient.off('Target.detachedFromTarget', onContextDestroyed);
                        resolve();
                    }
                };
                parentCdpClient.on('Target.detachedFromTarget', onContextDestroyed);
            });
            try {
                if (params.promptUnload) {
                    await context.close();
                }
                else {
                    await parentCdpClient.sendCommand('Target.closeTarget', {
                        targetId: params.context,
                    });
                }
            }
            catch (error) {
                // Swallow error that arise from the session being destroyed. Rely on the
                // `detachedFromTargetPromise` event to be resolved.
                if (!parentCdpClient.isCloseError(error)) {
                    throw error;
                }
            }
            // Sometimes CDP command finishes before `detachedFromTarget` event,
            // sometimes after. Wait for the CDP command to be finished, and then wait
            // for `detachedFromTarget` if it hasn't emitted.
            await detachedFromTargetPromise;
        }
        catch (error) {
            // Swallow error that arise from the page being destroyed
            // Example is navigating to faulty SSL certificate
            if (!(error.code === -32000 /* CdpErrorConstants.GENERIC_ERROR */ &&
                error.message === 'Not attached to an active page')) {
                throw error;
            }
        }
        return {};
    }
    async locateNodes(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        return await context.locateNodes(params);
    }
    #onContextCreatedSubscribeHook(contextId) {
        const context = this.#browsingContextStorage.getContext(contextId);
        const contextsToReport = [
            context,
            ...this.#browsingContextStorage.getContext(contextId).allChildren,
        ];
        contextsToReport.forEach((context) => {
            this.#eventManager.registerEvent({
                type: 'event',
                method: protocol_js_1.ChromiumBidi.BrowsingContext.EventNames.ContextCreated,
                params: context.serializeToBidiValue(),
            }, context.id);
        });
        return Promise.resolve();
    }
}
exports.BrowsingContextProcessor = BrowsingContextProcessor;
//# sourceMappingURL=BrowsingContextProcessor.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/context/BrowsingContextStorage.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2022 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BrowsingContextStorage = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const EventEmitter_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/EventEmitter.js");
/** Container class for browsing contexts. */
class BrowsingContextStorage {
    /** Map from context ID to context implementation. */
    #contexts = new Map();
    /** Event emitter for browsing context storage eventsis not expected to be exposed to
     * the outside world. */
    #eventEmitter = new EventEmitter_js_1.EventEmitter();
    /** Gets all top-level contexts, i.e. those with no parent. */
    getTopLevelContexts() {
        return this.getAllContexts().filter((context) => context.isTopLevelContext());
    }
    /** Gets all contexts. */
    getAllContexts() {
        return Array.from(this.#contexts.values());
    }
    /** Deletes the context with the given ID. */
    deleteContextById(id) {
        this.#contexts.delete(id);
    }
    /** Deletes the given context. */
    deleteContext(context) {
        this.#contexts.delete(context.id);
    }
    /** Tracks the given context. */
    addContext(context) {
        this.#contexts.set(context.id, context);
        this.#eventEmitter.emit("added" /* BrowsingContextStorageEvents.Added */, {
            browsingContext: context,
        });
    }
    /**
     * Waits for a context with the given ID to be added and returns it.
     */
    waitForContext(browsingContextId) {
        if (this.#contexts.has(browsingContextId)) {
            return Promise.resolve(this.getContext(browsingContextId));
        }
        return new Promise((resolve) => {
            const listener = (event) => {
                if (event.browsingContext.id === browsingContextId) {
                    this.#eventEmitter.off("added" /* BrowsingContextStorageEvents.Added */, listener);
                    resolve(event.browsingContext);
                }
            };
            this.#eventEmitter.on("added" /* BrowsingContextStorageEvents.Added */, listener);
        });
    }
    /** Returns true whether there is an existing context with the given ID. */
    hasContext(id) {
        return this.#contexts.has(id);
    }
    /** Gets the context with the given ID, if any. */
    findContext(id) {
        return this.#contexts.get(id);
    }
    /** Returns the top-level context ID of the given context, if any. */
    findTopLevelContextId(id) {
        if (id === null) {
            return null;
        }
        const maybeContext = this.findContext(id);
        if (!maybeContext) {
            return null;
        }
        const parentId = maybeContext.parentId ?? null;
        if (parentId === null) {
            return id;
        }
        return this.findTopLevelContextId(parentId);
    }
    findContextBySession(sessionId) {
        for (const context of this.#contexts.values()) {
            if (context.cdpTarget.cdpSessionId === sessionId) {
                return context;
            }
        }
        return;
    }
    /** Gets the context with the given ID, if any, otherwise throws. */
    getContext(id) {
        const result = this.findContext(id);
        if (result === undefined) {
            throw new protocol_js_1.NoSuchFrameException(`Context ${id} not found`);
        }
        return result;
    }
    verifyTopLevelContextsList(contexts) {
        const foundContexts = new Set();
        if (!contexts) {
            return foundContexts;
        }
        for (const contextId of contexts) {
            const context = this.getContext(contextId);
            if (context.isTopLevelContext()) {
                foundContexts.add(context);
            }
            else {
                throw new protocol_js_1.InvalidArgumentException(`Non top-level context '${contextId}' given.`);
            }
        }
        return foundContexts;
    }
}
exports.BrowsingContextStorage = BrowsingContextStorage;
//# sourceMappingURL=BrowsingContextStorage.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/context/NavigationTracker.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*
 *  Copyright 2024 Google LLC.
 *  Copyright (c) Microsoft Corporation.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NavigationTracker = exports.NavigationState = exports.NavigationResult = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const Deferred_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/Deferred.js");
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
const time_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/time.js");
const urlHelpers_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/urlHelpers.js");
const uuid_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/uuid.js");
class NavigationResult {
    eventName;
    message;
    constructor(eventName, message) {
        this.eventName = eventName;
        this.message = message;
    }
}
exports.NavigationResult = NavigationResult;
class NavigationState {
    navigationId = (0, uuid_js_1.uuidv4)();
    #browsingContextId;
    #started = false;
    #finished = new Deferred_js_1.Deferred();
    url;
    loaderId;
    #isInitial;
    #eventManager;
    #navigated = false;
    isFragmentNavigation;
    get finished() {
        return this.#finished;
    }
    constructor(url, browsingContextId, isInitial, eventManager) {
        this.#browsingContextId = browsingContextId;
        this.url = url;
        this.#isInitial = isInitial;
        this.#eventManager = eventManager;
    }
    navigationInfo() {
        return {
            context: this.#browsingContextId,
            navigation: this.navigationId,
            timestamp: (0, time_js_1.getTimestamp)(),
            url: this.url,
        };
    }
    start() {
        if (!this.#isInitial && !this.#started) {
            this.#eventManager.registerEvent({
                type: 'event',
                method: protocol_js_1.ChromiumBidi.BrowsingContext.EventNames.NavigationStarted,
                params: this.navigationInfo(),
            }, this.#browsingContextId);
        }
        this.#started = true;
    }
    #finish(navigationResult) {
        this.#started = true;
        if (!this.#isInitial &&
            !this.#finished.isFinished &&
            navigationResult.eventName !== "browsingContext.load" /* NavigationEventName.Load */) {
            this.#eventManager.registerEvent({
                type: 'event',
                method: navigationResult.eventName,
                params: this.navigationInfo(),
            }, this.#browsingContextId);
        }
        this.#finished.resolve(navigationResult);
    }
    frameNavigated() {
        this.#navigated = true;
    }
    fragmentNavigated() {
        this.#navigated = true;
        this.#finish(new NavigationResult("browsingContext.fragmentNavigated" /* NavigationEventName.FragmentNavigated */));
    }
    load() {
        this.#finish(new NavigationResult("browsingContext.load" /* NavigationEventName.Load */));
    }
    fail(message) {
        this.#finish(new NavigationResult(this.#navigated
            ? "browsingContext.navigationAborted" /* NavigationEventName.NavigationAborted */
            : "browsingContext.navigationFailed" /* NavigationEventName.NavigationFailed */, message));
    }
}
exports.NavigationState = NavigationState;
/**
 * Keeps track of navigations. Details: http://go/webdriver:bidi-navigation
 */
class NavigationTracker {
    #eventManager;
    #logger;
    #loaderIdToNavigationsMap = new Map();
    #browsingContextId;
    #currentNavigation;
    // When a new navigation is started via `BrowsingContext.navigate` with `wait` set to
    // `None`, the command result should have `navigation` value, but mapper does not have
    // it yet. This value will be set to `navigationId` after next .
    #pendingNavigation;
    // Flags if the initial navigation to `about:blank` is in progress.
    #isInitialNavigation = true;
    constructor(url, browsingContextId, eventManager, logger) {
        this.#browsingContextId = browsingContextId;
        this.#eventManager = eventManager;
        this.#logger = logger;
        this.#isInitialNavigation = true;
        this.#currentNavigation = new NavigationState(url, browsingContextId, (0, urlHelpers_js_1.urlMatchesAboutBlank)(url), this.#eventManager);
    }
    /**
     * Returns current started ongoing navigation. It can be either a started pending
     * navigation, or one is already navigated.
     */
    get currentNavigationId() {
        if (this.#pendingNavigation?.loaderId !== undefined) {
            return this.#pendingNavigation.navigationId;
        }
        return this.#currentNavigation.navigationId;
    }
    /**
     * Flags if the current navigation relates to the initial to `about:blank` navigation.
     */
    get isInitialNavigation() {
        return this.#isInitialNavigation;
    }
    /**
     * Url of the last navigated navigation.
     */
    get url() {
        return this.#currentNavigation.url;
    }
    /**
     * Creates a pending navigation e.g. when navigation command is called. Required to
     * provide navigation id before the actual navigation is started. It will be used when
     * navigation started. Can be aborted, failed, fragment navigated, or became a current
     * navigation.
     */
    createPendingNavigation(url, canBeInitialNavigation = false) {
        this.#logger?.(log_js_1.LogType.debug, 'createCommandNavigation');
        this.#isInitialNavigation =
            canBeInitialNavigation &&
                this.#isInitialNavigation &&
                (0, urlHelpers_js_1.urlMatchesAboutBlank)(url);
        this.#pendingNavigation?.fail('navigation canceled by concurrent navigation');
        const navigation = new NavigationState(url, this.#browsingContextId, this.#isInitialNavigation, this.#eventManager);
        this.#pendingNavigation = navigation;
        return navigation;
    }
    dispose() {
        this.#pendingNavigation?.fail('navigation canceled by context disposal');
        this.#currentNavigation.fail('navigation canceled by context disposal');
    }
    // Update the current url.
    onTargetInfoChanged(url) {
        this.#logger?.(log_js_1.LogType.debug, `onTargetInfoChanged ${url}`);
        this.#currentNavigation.url = url;
    }
    #getNavigationForFrameNavigated(url, loaderId) {
        if (this.#loaderIdToNavigationsMap.has(loaderId)) {
            return this.#loaderIdToNavigationsMap.get(loaderId);
        }
        if (this.#pendingNavigation !== undefined &&
            this.#pendingNavigation?.loaderId === undefined) {
            // This can be a pending navigation to `about:blank` created by a command. Use the
            // pending navigation in this case.
            return this.#pendingNavigation;
        }
        // Create a new pending navigation.
        return this.createPendingNavigation(url, true);
    }
    /**
     * @param {string} unreachableUrl indicated the navigation is actually failed.
     */
    frameNavigated(url, loaderId, unreachableUrl) {
        this.#logger?.(log_js_1.LogType.debug, `frameNavigated ${url}`);
        if (unreachableUrl !== undefined &&
            !this.#loaderIdToNavigationsMap.has(loaderId)) {
            // The navigation failed before started. Get or create pending navigation and fail
            // it.
            const navigation = this.#pendingNavigation ??
                this.createPendingNavigation(unreachableUrl, true);
            navigation.url = unreachableUrl;
            navigation.start();
            navigation.fail('the requested url is unreachable');
            return;
        }
        const navigation = this.#getNavigationForFrameNavigated(url, loaderId);
        navigation.frameNavigated();
        if (navigation !== this.#currentNavigation) {
            this.#currentNavigation.fail('navigation canceled by concurrent navigation');
        }
        navigation.url = url;
        navigation.loaderId = loaderId;
        this.#loaderIdToNavigationsMap.set(loaderId, navigation);
        navigation.start();
        this.#currentNavigation = navigation;
        if (this.#pendingNavigation === navigation) {
            this.#pendingNavigation = undefined;
        }
    }
    navigatedWithinDocument(url, navigationType) {
        this.#logger?.(log_js_1.LogType.debug, `navigatedWithinDocument ${url}, ${navigationType}`);
        // Current navigation URL should be updated.
        this.#currentNavigation.url = url;
        if (navigationType !== 'fragment') {
            // TODO: check for other navigation types, like `javascript`.
            return;
        }
        // There is no way to guaranteed match pending navigation with finished fragment
        // navigations. So assume any pending navigation without loader id is the fragment
        // one.
        const fragmentNavigation = this.#pendingNavigation !== undefined &&
            this.#pendingNavigation.loaderId === undefined
            ? this.#pendingNavigation
            : new NavigationState(url, this.#browsingContextId, false, this.#eventManager);
        // Finish ongoing navigation.
        fragmentNavigation.fragmentNavigated();
        if (fragmentNavigation === this.#pendingNavigation) {
            this.#pendingNavigation = undefined;
        }
    }
    frameRequestedNavigation(url) {
        this.#logger?.(log_js_1.LogType.debug, `Page.frameRequestedNavigation ${url}`);
        // The page is about to navigate to the url.
        this.createPendingNavigation(url, true);
    }
    /**
     * Required to mark navigation as fully complete.
     * TODO: navigation should be complete when it became the current one on
     * `Page.frameNavigated` or on navigating command finished with a new loader Id.
     */
    loadPageEvent(loaderId) {
        this.#logger?.(log_js_1.LogType.debug, 'loadPageEvent');
        // Even if it was an initial navigation, it is finished.
        this.#isInitialNavigation = false;
        this.#loaderIdToNavigationsMap.get(loaderId)?.load();
    }
    /**
     * Fail navigation due to navigation command failed.
     */
    failNavigation(navigation, errorText) {
        this.#logger?.(log_js_1.LogType.debug, 'failCommandNavigation');
        navigation.fail(errorText);
    }
    /**
     * Updates the navigation's `loaderId` and sets it as current one, if it is a
     * cross-document navigation.
     */
    navigationCommandFinished(navigation, loaderId) {
        this.#logger?.(log_js_1.LogType.debug, `finishCommandNavigation ${navigation.navigationId}, ${loaderId}`);
        if (loaderId !== undefined) {
            navigation.loaderId = loaderId;
            this.#loaderIdToNavigationsMap.set(loaderId, navigation);
        }
        navigation.isFragmentNavigation = loaderId === undefined;
        if (loaderId === undefined || this.#currentNavigation === navigation) {
            // If the command's navigation is same-document or is already the current one,
            // nothing to do.
            return;
        }
        this.#currentNavigation.fail('navigation canceled by concurrent navigation');
        navigation.start();
        this.#currentNavigation = navigation;
        if (this.#pendingNavigation === navigation) {
            this.#pendingNavigation = undefined;
        }
    }
    /**
     * Emulated event, tight to `Network.requestWillBeSent`.
     */
    frameStartedNavigating(url, loaderId) {
        this.#logger?.(log_js_1.LogType.debug, `frameStartedNavigating ${url}, ${loaderId}`);
        if (this.#loaderIdToNavigationsMap.has(loaderId)) {
            // The `frameStartedNavigating` is tight to the `Network.requestWillBeSent` event
            // which can be emitted several times, e.g. in case of redirection. Nothing to do in
            // such a case.
            return;
        }
        const pendingNavigation = this.#pendingNavigation ?? this.createPendingNavigation(url, true);
        pendingNavigation.url = url;
        pendingNavigation.start();
        pendingNavigation.loaderId = loaderId;
        this.#loaderIdToNavigationsMap.set(loaderId, pendingNavigation);
    }
    /**
     * In case of `beforeunload` handler, the pending navigation should be marked as started
     * for consistency, as the `browsingContext.navigationStarted` should be emitted before
     * user prompt.
     */
    beforeunload() {
        this.#logger?.(log_js_1.LogType.debug, `beforeunload`);
        if (this.#pendingNavigation === undefined) {
            this.#logger?.(log_js_1.LogType.debugError, `Unexpectedly no pending navigation on beforeunload`);
            return;
        }
        this.#pendingNavigation.start();
    }
    /**
     * If there is a navigation with the loaderId equals to the network request id, it means
     * that the navigation failed.
     */
    networkLoadingFailed(loaderId, errorText) {
        this.#loaderIdToNavigationsMap.get(loaderId)?.fail(errorText);
    }
}
exports.NavigationTracker = NavigationTracker;
//# sourceMappingURL=NavigationTracker.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/ActionDispatcher.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ActionDispatcher = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const assert_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/assert.js");
const graphemeTools_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/graphemeTools.js");
const InputSource_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/InputSource.js");
const keyUtils_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/keyUtils.js");
const USKeyboardLayout_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/USKeyboardLayout.js");
/** https://w3c.github.io/webdriver/#dfn-center-point */
const CALCULATE_IN_VIEW_CENTER_PT_DECL = ((i) => {
    const t = i.getClientRects()[0], e = Math.max(0, Math.min(t.x, t.x + t.width)), n = Math.min(window.innerWidth, Math.max(t.x, t.x + t.width)), h = Math.max(0, Math.min(t.y, t.y + t.height)), m = Math.min(window.innerHeight, Math.max(t.y, t.y + t.height));
    return [e + ((n - e) >> 1), h + ((m - h) >> 1)];
}).toString();
const IS_MAC_DECL = (() => {
    return navigator.platform.toLowerCase().includes('mac');
}).toString();
async function getElementCenter(context, element) {
    const sandbox = await context.getOrCreateSandbox(undefined);
    const result = await sandbox.callFunction(CALCULATE_IN_VIEW_CENTER_PT_DECL, false, { type: 'undefined' }, [element]);
    if (result.type === 'exception') {
        throw new protocol_js_1.NoSuchElementException(`Origin element ${element.sharedId} was not found`);
    }
    (0, assert_js_1.assert)(result.result.type === 'array');
    (0, assert_js_1.assert)(result.result.value?.[0]?.type === 'number');
    (0, assert_js_1.assert)(result.result.value?.[1]?.type === 'number');
    const { result: { value: [{ value: x }, { value: y }], }, } = result;
    return { x: x, y: y };
}
class ActionDispatcher {
    static isMacOS = async (context) => {
        const result = await (await context.getOrCreateSandbox(undefined)).callFunction(IS_MAC_DECL, false);
        (0, assert_js_1.assert)(result.type !== 'exception');
        (0, assert_js_1.assert)(result.result.type === 'boolean');
        return result.result.value;
    };
    #browsingContextStorage;
    #tickStart = 0;
    #tickDuration = 0;
    #inputState;
    #contextId;
    #isMacOS;
    constructor(inputState, browsingContextStorage, contextId, isMacOS) {
        this.#browsingContextStorage = browsingContextStorage;
        this.#inputState = inputState;
        this.#contextId = contextId;
        this.#isMacOS = isMacOS;
    }
    /**
     * The context can be disposed between action ticks, so need to get it each time.
     */
    get #context() {
        return this.#browsingContextStorage.getContext(this.#contextId);
    }
    async dispatchActions(optionsByTick) {
        await this.#inputState.queue.run(async () => {
            for (const options of optionsByTick) {
                await this.dispatchTickActions(options);
            }
        });
    }
    async dispatchTickActions(options) {
        this.#tickStart = performance.now();
        this.#tickDuration = 0;
        for (const { action } of options) {
            if ('duration' in action && action.duration !== undefined) {
                this.#tickDuration = Math.max(this.#tickDuration, action.duration);
            }
        }
        const promises = [
            new Promise((resolve) => setTimeout(resolve, this.#tickDuration)),
        ];
        for (const option of options) {
            // In theory we have to wait for each action to happen, but CDP is serial,
            // so as an optimization, we queue all CDP commands at once and await all
            // of them.
            promises.push(this.#dispatchAction(option));
        }
        await Promise.all(promises);
    }
    async #dispatchAction({ id, action }) {
        const source = this.#inputState.get(id);
        const keyState = this.#inputState.getGlobalKeyState();
        switch (action.type) {
            case 'keyDown': {
                // SAFETY: The source is validated before.
                await this.#dispatchKeyDownAction(source, action);
                this.#inputState.cancelList.push({
                    id,
                    action: {
                        ...action,
                        type: 'keyUp',
                    },
                });
                break;
            }
            case 'keyUp': {
                // SAFETY: The source is validated before.
                await this.#dispatchKeyUpAction(source, action);
                break;
            }
            case 'pause': {
                // TODO: Implement waiting on the input source.
                break;
            }
            case 'pointerDown': {
                // SAFETY: The source is validated before.
                await this.#dispatchPointerDownAction(source, keyState, action);
                this.#inputState.cancelList.push({
                    id,
                    action: {
                        ...action,
                        type: 'pointerUp',
                    },
                });
                break;
            }
            case 'pointerMove': {
                // SAFETY: The source is validated before.
                await this.#dispatchPointerMoveAction(source, keyState, action);
                break;
            }
            case 'pointerUp': {
                // SAFETY: The source is validated before.
                await this.#dispatchPointerUpAction(source, keyState, action);
                break;
            }
            case 'scroll': {
                // SAFETY: The source is validated before.
                await this.#dispatchScrollAction(source, keyState, action);
                break;
            }
        }
    }
    async #dispatchPointerDownAction(source, keyState, action) {
        const { button } = action;
        if (source.pressed.has(button)) {
            return;
        }
        source.pressed.add(button);
        const { x, y, subtype: pointerType } = source;
        const { width, height, pressure, twist, tangentialPressure } = action;
        const { tiltX, tiltY } = getTilt(action);
        // --- Platform-specific code begins here ---
        const { modifiers } = keyState;
        const { radiusX, radiusY } = getRadii(width ?? 1, height ?? 1);
        switch (pointerType) {
            case "mouse" /* Input.PointerType.Mouse */:
            case "pen" /* Input.PointerType.Pen */:
                // TODO: Implement width and height when available.
                await this.#context.cdpTarget.cdpClient.sendCommand('Input.dispatchMouseEvent', {
                    type: 'mousePressed',
                    x,
                    y,
                    modifiers,
                    button: getCdpButton(button),
                    buttons: source.buttons,
                    clickCount: source.setClickCount(button, new InputSource_js_1.PointerSource.ClickContext(x, y, performance.now())),
                    pointerType,
                    tangentialPressure,
                    tiltX,
                    tiltY,
                    twist,
                    force: pressure,
                });
                break;
            case "touch" /* Input.PointerType.Touch */:
                await this.#context.cdpTarget.cdpClient.sendCommand('Input.dispatchTouchEvent', {
                    type: 'touchStart',
                    touchPoints: [
                        {
                            x,
                            y,
                            radiusX,
                            radiusY,
                            tangentialPressure,
                            tiltX,
                            tiltY,
                            twist,
                            force: pressure,
                            id: source.pointerId,
                        },
                    ],
                    modifiers,
                });
                break;
        }
        source.radiusX = radiusX;
        source.radiusY = radiusY;
        source.force = pressure;
        // --- Platform-specific code ends here ---
    }
    #dispatchPointerUpAction(source, keyState, action) {
        const { button } = action;
        if (!source.pressed.has(button)) {
            return;
        }
        source.pressed.delete(button);
        const { x, y, force, radiusX, radiusY, subtype: pointerType } = source;
        // --- Platform-specific code begins here ---
        const { modifiers } = keyState;
        switch (pointerType) {
            case "mouse" /* Input.PointerType.Mouse */:
            case "pen" /* Input.PointerType.Pen */:
                // TODO: Implement width and height when available.
                return this.#context.cdpTarget.cdpClient.sendCommand('Input.dispatchMouseEvent', {
                    type: 'mouseReleased',
                    x,
                    y,
                    modifiers,
                    button: getCdpButton(button),
                    buttons: source.buttons,
                    clickCount: source.getClickCount(button),
                    pointerType,
                });
            case "touch" /* Input.PointerType.Touch */:
                return this.#context.cdpTarget.cdpClient.sendCommand('Input.dispatchTouchEvent', {
                    type: 'touchEnd',
                    touchPoints: [
                        {
                            x,
                            y,
                            id: source.pointerId,
                            force,
                            radiusX,
                            radiusY,
                        },
                    ],
                    modifiers,
                });
        }
        // --- Platform-specific code ends here ---
    }
    async #dispatchPointerMoveAction(source, keyState, action) {
        const { x: startX, y: startY, subtype: pointerType } = source;
        const { width, height, pressure, twist, tangentialPressure, x: offsetX, y: offsetY, origin = 'viewport', duration = this.#tickDuration, } = action;
        const { tiltX, tiltY } = getTilt(action);
        const { radiusX, radiusY } = getRadii(width ?? 1, height ?? 1);
        const { targetX, targetY } = await this.#getCoordinateFromOrigin(origin, offsetX, offsetY, startX, startY);
        if (targetX < 0 || targetY < 0) {
            throw new protocol_js_1.MoveTargetOutOfBoundsException(`Cannot move beyond viewport (x: ${targetX}, y: ${targetY})`);
        }
        let last;
        do {
            const ratio = duration > 0 ? (performance.now() - this.#tickStart) / duration : 1;
            last = ratio >= 1;
            let x;
            let y;
            if (last) {
                x = targetX;
                y = targetY;
            }
            else {
                x = Math.round(ratio * (targetX - startX) + startX);
                y = Math.round(ratio * (targetY - startY) + startY);
            }
            if (source.x !== x || source.y !== y) {
                // --- Platform-specific code begins here ---
                const { modifiers } = keyState;
                switch (pointerType) {
                    case "mouse" /* Input.PointerType.Mouse */:
                        // TODO: Implement width and height when available.
                        await this.#context.cdpTarget.cdpClient.sendCommand('Input.dispatchMouseEvent', {
                            type: 'mouseMoved',
                            x,
                            y,
                            modifiers,
                            clickCount: 0,
                            button: getCdpButton(source.pressed.values().next().value ?? 5),
                            buttons: source.buttons,
                            pointerType,
                            tangentialPressure,
                            tiltX,
                            tiltY,
                            twist,
                            force: pressure,
                        });
                        break;
                    case "pen" /* Input.PointerType.Pen */:
                        if (source.pressed.size !== 0) {
                            // Empty `source.pressed.size` means the pen is not detected by digitizer.
                            // Dispatch a mouse event for the pen only if either:
                            // 1. the pen is hovering over the digitizer (0);
                            // 2. the pen is in contact with the digitizer (1);
                            // 3. the pen has at least one button pressed (2, 4, etc).
                            // https://www.w3.org/TR/pointerevents/#the-buttons-property
                            // TODO: Implement width and height when available.
                            await this.#context.cdpTarget.cdpClient.sendCommand('Input.dispatchMouseEvent', {
                                type: 'mouseMoved',
                                x,
                                y,
                                modifiers,
                                clickCount: 0,
                                button: getCdpButton(source.pressed.values().next().value ?? 5),
                                buttons: source.buttons,
                                pointerType,
                                tangentialPressure,
                                tiltX,
                                tiltY,
                                twist,
                                force: pressure ?? 0.5,
                            });
                        }
                        break;
                    case "touch" /* Input.PointerType.Touch */:
                        if (source.pressed.size !== 0) {
                            await this.#context.cdpTarget.cdpClient.sendCommand('Input.dispatchTouchEvent', {
                                type: 'touchMove',
                                touchPoints: [
                                    {
                                        x,
                                        y,
                                        radiusX,
                                        radiusY,
                                        tangentialPressure,
                                        tiltX,
                                        tiltY,
                                        twist,
                                        force: pressure,
                                        id: source.pointerId,
                                    },
                                ],
                                modifiers,
                            });
                        }
                        break;
                }
                // --- Platform-specific code ends here ---
                source.x = x;
                source.y = y;
                source.radiusX = radiusX;
                source.radiusY = radiusY;
                source.force = pressure;
            }
        } while (!last);
    }
    async #getFrameOffset() {
        if (this.#context.id === this.#context.cdpTarget.id) {
            return { x: 0, y: 0 };
        }
        // https://github.com/w3c/webdriver/pull/1847 proposes dispatching events from
        // the top-level browsing context. This implementation dispatches it on the top-most
        // same-target frame, which is not top-level one in case of OOPiF.
        // TODO: switch to the top-level browsing context.
        const { backendNodeId } = await this.#context.cdpTarget.cdpClient.sendCommand('DOM.getFrameOwner', { frameId: this.#context.id });
        const { model: frameBoxModel } = await this.#context.cdpTarget.cdpClient.sendCommand('DOM.getBoxModel', {
            backendNodeId,
        });
        return { x: frameBoxModel.content[0], y: frameBoxModel.content[1] };
    }
    async #getCoordinateFromOrigin(origin, offsetX, offsetY, startX, startY) {
        let targetX;
        let targetY;
        const frameOffset = await this.#getFrameOffset();
        switch (origin) {
            case 'viewport':
                targetX = offsetX + frameOffset.x;
                targetY = offsetY + frameOffset.y;
                break;
            case 'pointer':
                targetX = startX + offsetX + frameOffset.x;
                targetY = startY + offsetY + frameOffset.y;
                break;
            default: {
                const { x: posX, y: posY } = await getElementCenter(this.#context, origin.element);
                // SAFETY: These can never be special numbers.
                targetX = posX + offsetX + frameOffset.x;
                targetY = posY + offsetY + frameOffset.y;
                break;
            }
        }
        return { targetX, targetY };
    }
    async #dispatchScrollAction(_source, keyState, action) {
        const { deltaX: targetDeltaX, deltaY: targetDeltaY, x: offsetX, y: offsetY, origin = 'viewport', duration = this.#tickDuration, } = action;
        if (origin === 'pointer') {
            throw new protocol_js_1.InvalidArgumentException('"pointer" origin is invalid for scrolling.');
        }
        const { targetX, targetY } = await this.#getCoordinateFromOrigin(origin, offsetX, offsetY, 0, 0);
        if (targetX < 0 || targetY < 0) {
            throw new protocol_js_1.MoveTargetOutOfBoundsException(`Cannot move beyond viewport (x: ${targetX}, y: ${targetY})`);
        }
        let currentDeltaX = 0;
        let currentDeltaY = 0;
        let last;
        do {
            const ratio = duration > 0 ? (performance.now() - this.#tickStart) / duration : 1;
            last = ratio >= 1;
            let deltaX;
            let deltaY;
            if (last) {
                deltaX = targetDeltaX - currentDeltaX;
                deltaY = targetDeltaY - currentDeltaY;
            }
            else {
                deltaX = Math.round(ratio * targetDeltaX - currentDeltaX);
                deltaY = Math.round(ratio * targetDeltaY - currentDeltaY);
            }
            if (deltaX !== 0 || deltaY !== 0) {
                // --- Platform-specific code begins here ---
                const { modifiers } = keyState;
                await this.#context.cdpTarget.cdpClient.sendCommand('Input.dispatchMouseEvent', {
                    type: 'mouseWheel',
                    deltaX,
                    deltaY,
                    x: targetX,
                    y: targetY,
                    modifiers,
                });
                // --- Platform-specific code ends here ---
                currentDeltaX += deltaX;
                currentDeltaY += deltaY;
            }
        } while (!last);
    }
    async #dispatchKeyDownAction(source, action) {
        const rawKey = action.value;
        if (!(0, graphemeTools_js_1.isSingleGrapheme)(rawKey)) {
            // https://w3c.github.io/webdriver/#dfn-process-a-key-action
            // WebDriver spec allows a grapheme to be used.
            throw new protocol_js_1.InvalidArgumentException(`Invalid key value: ${rawKey}`);
        }
        const isGrapheme = (0, graphemeTools_js_1.isSingleComplexGrapheme)(rawKey);
        const key = (0, keyUtils_js_1.getNormalizedKey)(rawKey);
        const repeat = source.pressed.has(key);
        const code = (0, keyUtils_js_1.getKeyCode)(rawKey);
        const location = (0, keyUtils_js_1.getKeyLocation)(rawKey);
        switch (key) {
            case 'Alt':
                source.alt = true;
                break;
            case 'Shift':
                source.shift = true;
                break;
            case 'Control':
                source.ctrl = true;
                break;
            case 'Meta':
                source.meta = true;
                break;
        }
        source.pressed.add(key);
        const { modifiers } = source;
        // --- Platform-specific code begins here ---
        // The spread is a little hack so JS gives us an array of unicode characters
        // to measure.
        const unmodifiedText = getKeyEventUnmodifiedText(key, source, isGrapheme);
        const text = getKeyEventText(code ?? '', source) ?? unmodifiedText;
        let command;
        // The following commands need to be declared because Chromium doesn't
        // handle them. See
        // https://source.chromium.org/chromium/chromium/src/+/refs/heads/main:third_party/blink/renderer/core/editing/editing_behavior.cc;l=169;drc=b8143cf1dfd24842890fcd831c4f5d909bef4fc4;bpv=0;bpt=1.
        if (this.#isMacOS && source.meta) {
            switch (code) {
                case 'KeyA':
                    command = 'SelectAll';
                    break;
                case 'KeyC':
                    command = 'Copy';
                    break;
                case 'KeyV':
                    command = source.shift ? 'PasteAndMatchStyle' : 'Paste';
                    break;
                case 'KeyX':
                    command = 'Cut';
                    break;
                case 'KeyZ':
                    command = source.shift ? 'Redo' : 'Undo';
                    break;
                default:
                // Intentionally empty.
            }
        }
        const promises = [
            this.#context.cdpTarget.cdpClient.sendCommand('Input.dispatchKeyEvent', {
                type: text ? 'keyDown' : 'rawKeyDown',
                windowsVirtualKeyCode: USKeyboardLayout_js_1.KeyToKeyCode[key],
                key,
                code,
                text,
                unmodifiedText,
                autoRepeat: repeat,
                isSystemKey: source.alt || undefined,
                location: location < 3 ? location : undefined,
                isKeypad: location === 3,
                modifiers,
                commands: command ? [command] : undefined,
            }),
        ];
        // Drag cancelling happens on escape.
        if (key === 'Escape') {
            if (!source.alt &&
                ((this.#isMacOS && !source.ctrl && !source.meta) || !this.#isMacOS)) {
                promises.push(this.#context.cdpTarget.cdpClient.sendCommand('Input.cancelDragging'));
            }
        }
        await Promise.all(promises);
        // --- Platform-specific code ends here ---
    }
    #dispatchKeyUpAction(source, action) {
        const rawKey = action.value;
        if (!(0, graphemeTools_js_1.isSingleGrapheme)(rawKey)) {
            // https://w3c.github.io/webdriver/#dfn-process-a-key-action
            // WebDriver spec allows a grapheme to be used.
            throw new protocol_js_1.InvalidArgumentException(`Invalid key value: ${rawKey}`);
        }
        const isGrapheme = (0, graphemeTools_js_1.isSingleComplexGrapheme)(rawKey);
        const key = (0, keyUtils_js_1.getNormalizedKey)(rawKey);
        if (!source.pressed.has(key)) {
            return;
        }
        const code = (0, keyUtils_js_1.getKeyCode)(rawKey);
        const location = (0, keyUtils_js_1.getKeyLocation)(rawKey);
        switch (key) {
            case 'Alt':
                source.alt = false;
                break;
            case 'Shift':
                source.shift = false;
                break;
            case 'Control':
                source.ctrl = false;
                break;
            case 'Meta':
                source.meta = false;
                break;
        }
        source.pressed.delete(key);
        const { modifiers } = source;
        // --- Platform-specific code begins here ---
        // The spread is a little hack so JS gives us an array of unicode characters
        // to measure.
        const unmodifiedText = getKeyEventUnmodifiedText(key, source, isGrapheme);
        const text = getKeyEventText(code ?? '', source) ?? unmodifiedText;
        return this.#context.cdpTarget.cdpClient.sendCommand('Input.dispatchKeyEvent', {
            type: 'keyUp',
            windowsVirtualKeyCode: USKeyboardLayout_js_1.KeyToKeyCode[key],
            key,
            code,
            text,
            unmodifiedText,
            location: location < 3 ? location : undefined,
            isSystemKey: source.alt || undefined,
            isKeypad: location === 3,
            modifiers,
        });
        // --- Platform-specific code ends here ---
    }
}
exports.ActionDispatcher = ActionDispatcher;
/**
 * Translates a non-grapheme key to either an `undefined` for a special keys, or a single
 * character modified by shift if needed.
 */
const getKeyEventUnmodifiedText = (key, source, isGrapheme) => {
    if (isGrapheme) {
        // Graphemes should be presented as text in the CDP command.
        return key;
    }
    if (key === 'Enter') {
        return '\r';
    }
    // If key is not a single character, it is a normalized key value, and should be
    // presented as key, not text in the CDP command.
    return [...key].length === 1
        ? source.shift
            ? key.toLocaleUpperCase('en-US')
            : key
        : undefined;
};
const getKeyEventText = (code, source) => {
    if (source.ctrl) {
        switch (code) {
            case 'Digit2':
                if (source.shift) {
                    return '\x00';
                }
                break;
            case 'KeyA':
                return '\x01';
            case 'KeyB':
                return '\x02';
            case 'KeyC':
                return '\x03';
            case 'KeyD':
                return '\x04';
            case 'KeyE':
                return '\x05';
            case 'KeyF':
                return '\x06';
            case 'KeyG':
                return '\x07';
            case 'KeyH':
                return '\x08';
            case 'KeyI':
                return '\x09';
            case 'KeyJ':
                return '\x0A';
            case 'KeyK':
                return '\x0B';
            case 'KeyL':
                return '\x0C';
            case 'KeyM':
                return '\x0D';
            case 'KeyN':
                return '\x0E';
            case 'KeyO':
                return '\x0F';
            case 'KeyP':
                return '\x10';
            case 'KeyQ':
                return '\x11';
            case 'KeyR':
                return '\x12';
            case 'KeyS':
                return '\x13';
            case 'KeyT':
                return '\x14';
            case 'KeyU':
                return '\x15';
            case 'KeyV':
                return '\x16';
            case 'KeyW':
                return '\x17';
            case 'KeyX':
                return '\x18';
            case 'KeyY':
                return '\x19';
            case 'KeyZ':
                return '\x1A';
            case 'BracketLeft':
                return '\x1B';
            case 'Backslash':
                return '\x1C';
            case 'BracketRight':
                return '\x1D';
            case 'Digit6':
                if (source.shift) {
                    return '\x1E';
                }
                break;
            case 'Minus':
                return '\x1F';
        }
        return '';
    }
    if (source.alt) {
        return '';
    }
    return;
};
function getCdpButton(button) {
    // https://www.w3.org/TR/pointerevents/#the-button-property
    switch (button) {
        case 0:
            return 'left';
        case 1:
            return 'middle';
        case 2:
            return 'right';
        case 3:
            return 'back';
        case 4:
            return 'forward';
        default:
            return 'none';
    }
}
function getTilt(action) {
    // https://w3c.github.io/pointerevents/#converting-between-tiltx-tilty-and-altitudeangle-azimuthangle
    const altitudeAngle = action.altitudeAngle ?? Math.PI / 2;
    const azimuthAngle = action.azimuthAngle ?? 0;
    let tiltXRadians = 0;
    let tiltYRadians = 0;
    if (altitudeAngle === 0) {
        // the pen is in the X-Y plane
        if (azimuthAngle === 0 || azimuthAngle === 2 * Math.PI) {
            // pen is on positive X axis
            tiltXRadians = Math.PI / 2;
        }
        if (azimuthAngle === Math.PI / 2) {
            // pen is on positive Y axis
            tiltYRadians = Math.PI / 2;
        }
        if (azimuthAngle === Math.PI) {
            // pen is on negative X axis
            tiltXRadians = -Math.PI / 2;
        }
        if (azimuthAngle === (3 * Math.PI) / 2) {
            // pen is on negative Y axis
            tiltYRadians = -Math.PI / 2;
        }
        if (azimuthAngle > 0 && azimuthAngle < Math.PI / 2) {
            tiltXRadians = Math.PI / 2;
            tiltYRadians = Math.PI / 2;
        }
        if (azimuthAngle > Math.PI / 2 && azimuthAngle < Math.PI) {
            tiltXRadians = -Math.PI / 2;
            tiltYRadians = Math.PI / 2;
        }
        if (azimuthAngle > Math.PI && azimuthAngle < (3 * Math.PI) / 2) {
            tiltXRadians = -Math.PI / 2;
            tiltYRadians = -Math.PI / 2;
        }
        if (azimuthAngle > (3 * Math.PI) / 2 && azimuthAngle < 2 * Math.PI) {
            tiltXRadians = Math.PI / 2;
            tiltYRadians = -Math.PI / 2;
        }
    }
    if (altitudeAngle !== 0) {
        const tanAlt = Math.tan(altitudeAngle);
        tiltXRadians = Math.atan(Math.cos(azimuthAngle) / tanAlt);
        tiltYRadians = Math.atan(Math.sin(azimuthAngle) / tanAlt);
    }
    const factor = 180 / Math.PI;
    return {
        tiltX: Math.round(tiltXRadians * factor),
        tiltY: Math.round(tiltYRadians * factor),
    };
}
function getRadii(width, height) {
    return {
        radiusX: width ? width / 2 : 0.5,
        radiusY: height ? height / 2 : 0.5,
    };
}
//# sourceMappingURL=ActionDispatcher.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/InputProcessor.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InputProcessor = void 0;
/*
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const assert_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/assert.js");
const ActionDispatcher_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/ActionDispatcher.js");
const InputStateManager_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/InputStateManager.js");
class InputProcessor {
    #browsingContextStorage;
    #inputStateManager = new InputStateManager_js_1.InputStateManager();
    constructor(browsingContextStorage) {
        this.#browsingContextStorage = browsingContextStorage;
    }
    async performActions(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        const inputState = this.#inputStateManager.get(context.top);
        const actionsByTick = this.#getActionsByTick(params, inputState);
        const dispatcher = new ActionDispatcher_js_1.ActionDispatcher(inputState, this.#browsingContextStorage, params.context, await ActionDispatcher_js_1.ActionDispatcher.isMacOS(context).catch(() => false));
        await dispatcher.dispatchActions(actionsByTick);
        return {};
    }
    async releaseActions(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        const topContext = context.top;
        const inputState = this.#inputStateManager.get(topContext);
        const dispatcher = new ActionDispatcher_js_1.ActionDispatcher(inputState, this.#browsingContextStorage, params.context, await ActionDispatcher_js_1.ActionDispatcher.isMacOS(context).catch(() => false));
        await dispatcher.dispatchTickActions(inputState.cancelList.reverse());
        this.#inputStateManager.delete(topContext);
        return {};
    }
    async setFiles(params) {
        const context = this.#browsingContextStorage.getContext(params.context);
        const realm = await context.getOrCreateSandbox(undefined);
        let result;
        try {
            result = await realm.callFunction(String(function getFiles(fileListLength) {
                if (!(this instanceof HTMLInputElement)) {
                    if (this instanceof Element) {
                        return 1 /* ErrorCode.Element */;
                    }
                    return 0 /* ErrorCode.Node */;
                }
                if (this.type !== 'file') {
                    return 2 /* ErrorCode.Type */;
                }
                if (this.disabled) {
                    return 3 /* ErrorCode.Disabled */;
                }
                if (fileListLength > 1 && !this.multiple) {
                    return 4 /* ErrorCode.Multiple */;
                }
                return;
            }), false, params.element, [{ type: 'number', value: params.files.length }]);
        }
        catch {
            throw new protocol_js_1.NoSuchNodeException(`Could not find element ${params.element.sharedId}`);
        }
        (0, assert_js_1.assert)(result.type === 'success');
        if (result.result.type === 'number') {
            switch (result.result.value) {
                case 0 /* ErrorCode.Node */: {
                    throw new protocol_js_1.NoSuchElementException(`Could not find element ${params.element.sharedId}`);
                }
                case 1 /* ErrorCode.Element */: {
                    throw new protocol_js_1.UnableToSetFileInputException(`Element ${params.element.sharedId} is not a input`);
                }
                case 2 /* ErrorCode.Type */: {
                    throw new protocol_js_1.UnableToSetFileInputException(`Input element ${params.element.sharedId} is not a file type`);
                }
                case 3 /* ErrorCode.Disabled */: {
                    throw new protocol_js_1.UnableToSetFileInputException(`Input element ${params.element.sharedId} is disabled`);
                }
                case 4 /* ErrorCode.Multiple */: {
                    throw new protocol_js_1.UnableToSetFileInputException(`Cannot set multiple files on a non-multiple input element`);
                }
            }
        }
        /**
         * The zero-length array is a special case, it seems that
         * DOM.setFileInputFiles does not actually update the files in that case, so
         * the solution is to eval the element value to a new FileList directly.
         */
        if (params.files.length === 0) {
            // XXX: These events should converted to trusted events. Perhaps do this
            // in `DOM.setFileInputFiles`?
            await realm.callFunction(String(function dispatchEvent() {
                if (this.files?.length === 0) {
                    this.dispatchEvent(new Event('cancel', {
                        bubbles: true,
                    }));
                    return;
                }
                this.files = new DataTransfer().files;
                // Dispatch events for this case because it should behave akin to a user action.
                this.dispatchEvent(new Event('input', { bubbles: true, composed: true }));
                this.dispatchEvent(new Event('change', { bubbles: true }));
            }), false, params.element);
            return {};
        }
        // Our goal here is to iterate over the input element files and get their
        // file paths.
        const paths = [];
        for (let i = 0; i < params.files.length; ++i) {
            const result = await realm.callFunction(String(function getFiles(index) {
                return this.files?.item(index);
            }), false, params.element, [{ type: 'number', value: 0 }], "root" /* Script.ResultOwnership.Root */);
            (0, assert_js_1.assert)(result.type === 'success');
            if (result.result.type !== 'object') {
                break;
            }
            const { handle } = result.result;
            (0, assert_js_1.assert)(handle !== undefined);
            const { path } = await realm.cdpClient.sendCommand('DOM.getFileInfo', {
                objectId: handle,
            });
            paths.push(path);
            // Cleanup the handle.
            void realm.disown(handle).catch(undefined);
        }
        paths.sort();
        // We create a new array so we preserve the order of the original files.
        const sortedFiles = [...params.files].sort();
        if (paths.length !== params.files.length ||
            sortedFiles.some((path, index) => {
                return paths[index] !== path;
            })) {
            const { objectId } = await realm.deserializeForCdp(params.element);
            // This cannot throw since this was just used in `callFunction` above.
            (0, assert_js_1.assert)(objectId !== undefined);
            await realm.cdpClient.sendCommand('DOM.setFileInputFiles', {
                files: params.files,
                objectId,
            });
        }
        else {
            // XXX: We should dispatch a trusted event.
            await realm.callFunction(String(function dispatchEvent() {
                this.dispatchEvent(new Event('cancel', {
                    bubbles: true,
                }));
            }), false, params.element);
        }
        return {};
    }
    #getActionsByTick(params, inputState) {
        const actionsByTick = [];
        for (const action of params.actions) {
            switch (action.type) {
                case "pointer" /* SourceType.Pointer */: {
                    action.parameters ??= { pointerType: "mouse" /* Input.PointerType.Mouse */ };
                    action.parameters.pointerType ??= "mouse" /* Input.PointerType.Mouse */;
                    const source = inputState.getOrCreate(action.id, "pointer" /* SourceType.Pointer */, action.parameters.pointerType);
                    if (source.subtype !== action.parameters.pointerType) {
                        throw new protocol_js_1.InvalidArgumentException(`Expected input source ${action.id} to be ${source.subtype}; got ${action.parameters.pointerType}.`);
                    }
                    break;
                }
                default:
                    inputState.getOrCreate(action.id, action.type);
            }
            const actions = action.actions.map((item) => ({
                id: action.id,
                action: item,
            }));
            for (let i = 0; i < actions.length; i++) {
                if (actionsByTick.length === i) {
                    actionsByTick.push([]);
                }
                actionsByTick[i].push(actions[i]);
            }
        }
        return actionsByTick;
    }
}
exports.InputProcessor = InputProcessor;
//# sourceMappingURL=InputProcessor.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/InputSource.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WheelSource = exports.PointerSource = exports.KeySource = exports.NoneSource = void 0;
class NoneSource {
    type = "none" /* SourceType.None */;
}
exports.NoneSource = NoneSource;
class KeySource {
    type = "key" /* SourceType.Key */;
    pressed = new Set();
    // This is a bitfield that matches the modifiers parameter of
    // https://chromedevtools.github.io/devtools-protocol/tot/Input/#method-dispatchKeyEvent
    #modifiers = 0;
    get modifiers() {
        return this.#modifiers;
    }
    get alt() {
        return (this.#modifiers & 1) === 1;
    }
    set alt(value) {
        this.#setModifier(value, 1);
    }
    get ctrl() {
        return (this.#modifiers & 2) === 2;
    }
    set ctrl(value) {
        this.#setModifier(value, 2);
    }
    get meta() {
        return (this.#modifiers & 4) === 4;
    }
    set meta(value) {
        this.#setModifier(value, 4);
    }
    get shift() {
        return (this.#modifiers & 8) === 8;
    }
    set shift(value) {
        this.#setModifier(value, 8);
    }
    #setModifier(value, bit) {
        if (value) {
            this.#modifiers |= bit;
        }
        else {
            this.#modifiers &= ~bit;
        }
    }
}
exports.KeySource = KeySource;
class PointerSource {
    type = "pointer" /* SourceType.Pointer */;
    subtype;
    pointerId;
    pressed = new Set();
    x = 0;
    y = 0;
    radiusX;
    radiusY;
    force;
    constructor(id, subtype) {
        this.pointerId = id;
        this.subtype = subtype;
    }
    // This is a bitfield that matches the buttons parameter of
    // https://chromedevtools.github.io/devtools-protocol/tot/Input/#method-dispatchMouseEvent
    get buttons() {
        let buttons = 0;
        for (const button of this.pressed) {
            switch (button) {
                case 0:
                    buttons |= 1;
                    break;
                case 1:
                    buttons |= 4;
                    break;
                case 2:
                    buttons |= 2;
                    break;
                case 3:
                    buttons |= 8;
                    break;
                case 4:
                    buttons |= 16;
                    break;
            }
        }
        return buttons;
    }
    // --- Platform-specific code starts here ---
    // Input.dispatchMouseEvent doesn't know the concept of double click, so we
    // need to create the logic, similar to how it's done for OSes:
    // https://source.chromium.org/chromium/chromium/src/+/refs/heads/main:ui/events/event.cc;l=479
    static ClickContext = class ClickContext {
        static #DOUBLE_CLICK_TIME_MS = 500;
        static #MAX_DOUBLE_CLICK_RADIUS = 2;
        count = 0;
        #x;
        #y;
        #time;
        constructor(x, y, time) {
            this.#x = x;
            this.#y = y;
            this.#time = time;
        }
        compare(context) {
            return (
            // The click needs to be within a certain amount of ms.
            context.#time - this.#time > ClickContext.#DOUBLE_CLICK_TIME_MS ||
                // The click needs to be within a certain square radius.
                Math.abs(context.#x - this.#x) >
                    ClickContext.#MAX_DOUBLE_CLICK_RADIUS ||
                Math.abs(context.#y - this.#y) > ClickContext.#MAX_DOUBLE_CLICK_RADIUS);
        }
    };
    #clickContexts = new Map();
    setClickCount(button, context) {
        let storedContext = this.#clickContexts.get(button);
        if (!storedContext || storedContext.compare(context)) {
            storedContext = context;
        }
        ++storedContext.count;
        this.#clickContexts.set(button, storedContext);
        return storedContext.count;
    }
    getClickCount(button) {
        return this.#clickContexts.get(button)?.count ?? 0;
    }
}
exports.PointerSource = PointerSource;
_a = PointerSource;
class WheelSource {
    type = "wheel" /* SourceType.Wheel */;
}
exports.WheelSource = WheelSource;
//# sourceMappingURL=InputSource.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/InputState.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InputState = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const Mutex_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/Mutex.js");
const InputSource_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/InputSource.js");
class InputState {
    cancelList = [];
    #sources = new Map();
    #mutex = new Mutex_js_1.Mutex();
    getOrCreate(id, type, subtype) {
        let source = this.#sources.get(id);
        if (!source) {
            switch (type) {
                case "none" /* SourceType.None */:
                    source = new InputSource_js_1.NoneSource();
                    break;
                case "key" /* SourceType.Key */:
                    source = new InputSource_js_1.KeySource();
                    break;
                case "pointer" /* SourceType.Pointer */: {
                    let pointerId = subtype === "mouse" /* Input.PointerType.Mouse */ ? 0 : 2;
                    const pointerIds = new Set();
                    for (const [, source] of this.#sources) {
                        if (source.type === "pointer" /* SourceType.Pointer */) {
                            pointerIds.add(source.pointerId);
                        }
                    }
                    while (pointerIds.has(pointerId)) {
                        ++pointerId;
                    }
                    source = new InputSource_js_1.PointerSource(pointerId, subtype);
                    break;
                }
                case "wheel" /* SourceType.Wheel */:
                    source = new InputSource_js_1.WheelSource();
                    break;
                default:
                    throw new protocol_js_1.InvalidArgumentException(`Expected "${"none" /* SourceType.None */}", "${"key" /* SourceType.Key */}", "${"pointer" /* SourceType.Pointer */}", or "${"wheel" /* SourceType.Wheel */}". Found unknown source type ${type}.`);
            }
            this.#sources.set(id, source);
            return source;
        }
        if (source.type !== type) {
            throw new protocol_js_1.InvalidArgumentException(`Input source type of ${id} is ${source.type}, but received ${type}.`);
        }
        return source;
    }
    get(id) {
        const source = this.#sources.get(id);
        if (!source) {
            throw new protocol_js_1.UnknownErrorException(`Internal error.`);
        }
        return source;
    }
    getGlobalKeyState() {
        const state = new InputSource_js_1.KeySource();
        for (const [, source] of this.#sources) {
            if (source.type !== "key" /* SourceType.Key */) {
                continue;
            }
            for (const pressed of source.pressed) {
                state.pressed.add(pressed);
            }
            state.alt ||= source.alt;
            state.ctrl ||= source.ctrl;
            state.meta ||= source.meta;
            state.shift ||= source.shift;
        }
        return state;
    }
    get queue() {
        return this.#mutex;
    }
}
exports.InputState = InputState;
//# sourceMappingURL=InputState.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/InputStateManager.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InputStateManager = void 0;
const assert_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/assert.js");
const InputState_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/InputState.js");
// We use a weak map here as specified here:
// https://www.w3.org/TR/webdriver/#dfn-browsing-context-input-state-map
class InputStateManager extends WeakMap {
    get(context) {
        (0, assert_js_1.assert)(context.isTopLevelContext());
        if (!this.has(context)) {
            this.set(context, new InputState_js_1.InputState());
        }
        return super.get(context);
    }
}
exports.InputStateManager = InputStateManager;
//# sourceMappingURL=InputStateManager.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/USKeyboardLayout.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KeyToKeyCode = void 0;
// TODO: Remove this once https://crrev.com/c/4548290 is stably in Chromium.
// `Input.dispatchKeyboardEvent` will automatically handle these conversions.
exports.KeyToKeyCode = {
    '0': 48,
    '1': 49,
    '2': 50,
    '3': 51,
    '4': 52,
    '5': 53,
    '6': 54,
    '7': 55,
    '8': 56,
    '9': 57,
    Abort: 3,
    Help: 6,
    Backspace: 8,
    Tab: 9,
    Numpad5: 12,
    NumpadEnter: 13,
    Enter: 13,
    '\\r': 13,
    '\\n': 13,
    ShiftLeft: 16,
    ShiftRight: 16,
    ControlLeft: 17,
    ControlRight: 17,
    AltLeft: 18,
    AltRight: 18,
    Pause: 19,
    CapsLock: 20,
    Escape: 27,
    Convert: 28,
    NonConvert: 29,
    Space: 32,
    Numpad9: 33,
    PageUp: 33,
    Numpad3: 34,
    PageDown: 34,
    End: 35,
    Numpad1: 35,
    Home: 36,
    Numpad7: 36,
    ArrowLeft: 37,
    Numpad4: 37,
    Numpad8: 38,
    ArrowUp: 38,
    ArrowRight: 39,
    Numpad6: 39,
    Numpad2: 40,
    ArrowDown: 40,
    Select: 41,
    Open: 43,
    PrintScreen: 44,
    Insert: 45,
    Numpad0: 45,
    Delete: 46,
    NumpadDecimal: 46,
    Digit0: 48,
    Digit1: 49,
    Digit2: 50,
    Digit3: 51,
    Digit4: 52,
    Digit5: 53,
    Digit6: 54,
    Digit7: 55,
    Digit8: 56,
    Digit9: 57,
    KeyA: 65,
    KeyB: 66,
    KeyC: 67,
    KeyD: 68,
    KeyE: 69,
    KeyF: 70,
    KeyG: 71,
    KeyH: 72,
    KeyI: 73,
    KeyJ: 74,
    KeyK: 75,
    KeyL: 76,
    KeyM: 77,
    KeyN: 78,
    KeyO: 79,
    KeyP: 80,
    KeyQ: 81,
    KeyR: 82,
    KeyS: 83,
    KeyT: 84,
    KeyU: 85,
    KeyV: 86,
    KeyW: 87,
    KeyX: 88,
    KeyY: 89,
    KeyZ: 90,
    MetaLeft: 91,
    MetaRight: 92,
    ContextMenu: 93,
    NumpadMultiply: 106,
    NumpadAdd: 107,
    NumpadSubtract: 109,
    NumpadDivide: 111,
    F1: 112,
    F2: 113,
    F3: 114,
    F4: 115,
    F5: 116,
    F6: 117,
    F7: 118,
    F8: 119,
    F9: 120,
    F10: 121,
    F11: 122,
    F12: 123,
    F13: 124,
    F14: 125,
    F15: 126,
    F16: 127,
    F17: 128,
    F18: 129,
    F19: 130,
    F20: 131,
    F21: 132,
    F22: 133,
    F23: 134,
    F24: 135,
    NumLock: 144,
    ScrollLock: 145,
    AudioVolumeMute: 173,
    AudioVolumeDown: 174,
    AudioVolumeUp: 175,
    MediaTrackNext: 176,
    MediaTrackPrevious: 177,
    MediaStop: 178,
    MediaPlayPause: 179,
    Semicolon: 186,
    Equal: 187,
    NumpadEqual: 187,
    Comma: 188,
    Minus: 189,
    Period: 190,
    Slash: 191,
    Backquote: 192,
    BracketLeft: 219,
    Backslash: 220,
    BracketRight: 221,
    Quote: 222,
    AltGraph: 225,
    Props: 247,
    Cancel: 3,
    Clear: 12,
    Shift: 16,
    Control: 17,
    Alt: 18,
    Accept: 30,
    ModeChange: 31,
    ' ': 32,
    Print: 42,
    Execute: 43,
    '\\u0000': 46,
    a: 65,
    b: 66,
    c: 67,
    d: 68,
    e: 69,
    f: 70,
    g: 71,
    h: 72,
    i: 73,
    j: 74,
    k: 75,
    l: 76,
    m: 77,
    n: 78,
    o: 79,
    p: 80,
    q: 81,
    r: 82,
    s: 83,
    t: 84,
    u: 85,
    v: 86,
    w: 87,
    x: 88,
    y: 89,
    z: 90,
    Meta: 91,
    '*': 106,
    '+': 107,
    '-': 109,
    '/': 111,
    ';': 186,
    '=': 187,
    ',': 188,
    '.': 190,
    '`': 192,
    '[': 219,
    '\\\\': 220,
    ']': 221,
    "'": 222,
    Attn: 246,
    CrSel: 247,
    ExSel: 248,
    EraseEof: 249,
    Play: 250,
    ZoomOut: 251,
    ')': 48,
    '!': 49,
    '@': 50,
    '#': 51,
    $: 52,
    '%': 53,
    '^': 54,
    '&': 55,
    '(': 57,
    A: 65,
    B: 66,
    C: 67,
    D: 68,
    E: 69,
    F: 70,
    G: 71,
    H: 72,
    I: 73,
    J: 74,
    K: 75,
    L: 76,
    M: 77,
    N: 78,
    O: 79,
    P: 80,
    Q: 81,
    R: 82,
    S: 83,
    T: 84,
    U: 85,
    V: 86,
    W: 87,
    X: 88,
    Y: 89,
    Z: 90,
    ':': 186,
    '<': 188,
    _: 189,
    '>': 190,
    '?': 191,
    '~': 192,
    '{': 219,
    '|': 220,
    '}': 221,
    '"': 222,
    Camera: 44,
    EndCall: 95,
    VolumeDown: 182,
    VolumeUp: 183,
};
//# sourceMappingURL=USKeyboardLayout.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/input/keyUtils.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getNormalizedKey = getNormalizedKey;
exports.getKeyCode = getKeyCode;
exports.getKeyLocation = getKeyLocation;
/**
 * Returns the normalized key value for a given key according to the table:
 * https://w3c.github.io/webdriver/#dfn-normalized-key-value
 */
function getNormalizedKey(value) {
    switch (value) {
        case '\uE000':
            return 'Unidentified';
        case '\uE001':
            return 'Cancel';
        case '\uE002':
            return 'Help';
        case '\uE003':
            return 'Backspace';
        case '\uE004':
            return 'Tab';
        case '\uE005':
            return 'Clear';
        // Specification declares the '\uE006' to be `Return`, but it is not supported by
        // Chrome, so fall back to `Enter`, which aligns with WPT.
        case '\uE006':
        case '\uE007':
            return 'Enter';
        case '\uE008':
            return 'Shift';
        case '\uE009':
            return 'Control';
        case '\uE00A':
            return 'Alt';
        case '\uE00B':
            return 'Pause';
        case '\uE00C':
            return 'Escape';
        case '\uE00D':
            return ' ';
        case '\uE00E':
            return 'PageUp';
        case '\uE00F':
            return 'PageDown';
        case '\uE010':
            return 'End';
        case '\uE011':
            return 'Home';
        case '\uE012':
            return 'ArrowLeft';
        case '\uE013':
            return 'ArrowUp';
        case '\uE014':
            return 'ArrowRight';
        case '\uE015':
            return 'ArrowDown';
        case '\uE016':
            return 'Insert';
        case '\uE017':
            return 'Delete';
        case '\uE018':
            return ';';
        case '\uE019':
            return '=';
        case '\uE01A':
            return '0';
        case '\uE01B':
            return '1';
        case '\uE01C':
            return '2';
        case '\uE01D':
            return '3';
        case '\uE01E':
            return '4';
        case '\uE01F':
            return '5';
        case '\uE020':
            return '6';
        case '\uE021':
            return '7';
        case '\uE022':
            return '8';
        case '\uE023':
            return '9';
        case '\uE024':
            return '*';
        case '\uE025':
            return '+';
        case '\uE026':
            return ',';
        case '\uE027':
            return '-';
        case '\uE028':
            return '.';
        case '\uE029':
            return '/';
        case '\uE031':
            return 'F1';
        case '\uE032':
            return 'F2';
        case '\uE033':
            return 'F3';
        case '\uE034':
            return 'F4';
        case '\uE035':
            return 'F5';
        case '\uE036':
            return 'F6';
        case '\uE037':
            return 'F7';
        case '\uE038':
            return 'F8';
        case '\uE039':
            return 'F9';
        case '\uE03A':
            return 'F10';
        case '\uE03B':
            return 'F11';
        case '\uE03C':
            return 'F12';
        case '\uE03D':
            return 'Meta';
        case '\uE040':
            return 'ZenkakuHankaku';
        case '\uE050':
            return 'Shift';
        case '\uE051':
            return 'Control';
        case '\uE052':
            return 'Alt';
        case '\uE053':
            return 'Meta';
        case '\uE054':
            return 'PageUp';
        case '\uE055':
            return 'PageDown';
        case '\uE056':
            return 'End';
        case '\uE057':
            return 'Home';
        case '\uE058':
            return 'ArrowLeft';
        case '\uE059':
            return 'ArrowUp';
        case '\uE05A':
            return 'ArrowRight';
        case '\uE05B':
            return 'ArrowDown';
        case '\uE05C':
            return 'Insert';
        case '\uE05D':
            return 'Delete';
        default:
            return value;
    }
}
/**
 * Returns the key code for a given key according to the table:
 * https://w3c.github.io/webdriver/#dfn-shifted-character
 */
function getKeyCode(key) {
    switch (key) {
        case '`':
        case '~':
            return 'Backquote';
        case '\\':
        case '|':
            return 'Backslash';
        case '\uE003':
            return 'Backspace';
        case '[':
        case '{':
            return 'BracketLeft';
        case ']':
        case '}':
            return 'BracketRight';
        case ',':
        case '<':
            return 'Comma';
        case '0':
        case ')':
            return 'Digit0';
        case '1':
        case '!':
            return 'Digit1';
        case '2':
        case '@':
            return 'Digit2';
        case '3':
        case '#':
            return 'Digit3';
        case '4':
        case '$':
            return 'Digit4';
        case '5':
        case '%':
            return 'Digit5';
        case '6':
        case '^':
            return 'Digit6';
        case '7':
        case '&':
            return 'Digit7';
        case '8':
        case '*':
            return 'Digit8';
        case '9':
        case '(':
            return 'Digit9';
        case '=':
        case '+':
            return 'Equal';
        // The spec declares the '<' to be `IntlBackslash` as well, but it is already covered
        // in the `Comma` above.
        case '>':
            return 'IntlBackslash';
        case 'a':
        case 'A':
            return 'KeyA';
        case 'b':
        case 'B':
            return 'KeyB';
        case 'c':
        case 'C':
            return 'KeyC';
        case 'd':
        case 'D':
            return 'KeyD';
        case 'e':
        case 'E':
            return 'KeyE';
        case 'f':
        case 'F':
            return 'KeyF';
        case 'g':
        case 'G':
            return 'KeyG';
        case 'h':
        case 'H':
            return 'KeyH';
        case 'i':
        case 'I':
            return 'KeyI';
        case 'j':
        case 'J':
            return 'KeyJ';
        case 'k':
        case 'K':
            return 'KeyK';
        case 'l':
        case 'L':
            return 'KeyL';
        case 'm':
        case 'M':
            return 'KeyM';
        case 'n':
        case 'N':
            return 'KeyN';
        case 'o':
        case 'O':
            return 'KeyO';
        case 'p':
        case 'P':
            return 'KeyP';
        case 'q':
        case 'Q':
            return 'KeyQ';
        case 'r':
        case 'R':
            return 'KeyR';
        case 's':
        case 'S':
            return 'KeyS';
        case 't':
        case 'T':
            return 'KeyT';
        case 'u':
        case 'U':
            return 'KeyU';
        case 'v':
        case 'V':
            return 'KeyV';
        case 'w':
        case 'W':
            return 'KeyW';
        case 'x':
        case 'X':
            return 'KeyX';
        case 'y':
        case 'Y':
            return 'KeyY';
        case 'z':
        case 'Z':
            return 'KeyZ';
        case '-':
        case '_':
            return 'Minus';
        case '.':
            return 'Period';
        case "'":
        case '"':
            return 'Quote';
        case ';':
        case ':':
            return 'Semicolon';
        case '/':
        case '?':
            return 'Slash';
        case '\uE00A':
            return 'AltLeft';
        case '\uE052':
            return 'AltRight';
        case '\uE009':
            return 'ControlLeft';
        case '\uE051':
            return 'ControlRight';
        case '\uE006':
            return 'Enter';
        case '\uE00B':
            return 'Pause';
        case '\uE03D':
            return 'MetaLeft';
        case '\uE053':
            return 'MetaRight';
        case '\uE008':
            return 'ShiftLeft';
        case '\uE050':
            return 'ShiftRight';
        case ' ':
        case '\uE00D':
            return 'Space';
        case '\uE004':
            return 'Tab';
        case '\uE017':
            return 'Delete';
        case '\uE010':
            return 'End';
        case '\uE002':
            return 'Help';
        case '\uE011':
            return 'Home';
        case '\uE016':
            return 'Insert';
        case '\uE00F':
            return 'PageDown';
        case '\uE00E':
            return 'PageUp';
        case '\uE015':
            return 'ArrowDown';
        case '\uE012':
            return 'ArrowLeft';
        case '\uE014':
            return 'ArrowRight';
        case '\uE013':
            return 'ArrowUp';
        case '\uE00C':
            return 'Escape';
        case '\uE031':
            return 'F1';
        case '\uE032':
            return 'F2';
        case '\uE033':
            return 'F3';
        case '\uE034':
            return 'F4';
        case '\uE035':
            return 'F5';
        case '\uE036':
            return 'F6';
        case '\uE037':
            return 'F7';
        case '\uE038':
            return 'F8';
        case '\uE039':
            return 'F9';
        case '\uE03A':
            return 'F10';
        case '\uE03B':
            return 'F11';
        case '\uE03C':
            return 'F12';
        case '\uE019':
            return 'NumpadEqual';
        case '\uE01A':
        case '\uE05C':
            return 'Numpad0';
        case '\uE01B':
        case '\uE056':
            return 'Numpad1';
        case '\uE01C':
        case '\uE05B':
            return 'Numpad2';
        case '\uE01D':
        case '\uE055':
            return 'Numpad3';
        case '\uE01E':
        case '\uE058':
            return 'Numpad4';
        case '\uE01F':
            return 'Numpad5';
        case '\uE020':
        case '\uE05A':
            return 'Numpad6';
        case '\uE021':
        case '\uE057':
            return 'Numpad7';
        case '\uE022':
        case '\uE059':
            return 'Numpad8';
        case '\uE023':
        case '\uE054':
            return 'Numpad9';
        case '\uE025':
            return 'NumpadAdd';
        case '\uE026':
            return 'NumpadComma';
        case '\uE028':
        case '\uE05D':
            return 'NumpadDecimal';
        case '\uE029':
            return 'NumpadDivide';
        case '\uE007':
            return 'NumpadEnter';
        case '\uE024':
            return 'NumpadMultiply';
        case '\uE027':
            return 'NumpadSubtract';
        default:
            return;
    }
}
/**
 * Returns the location of the key according to the table:
 * https://w3c.github.io/webdriver/#dfn-key-location
 */
function getKeyLocation(key) {
    switch (key) {
        case '\uE007':
        case '\uE008':
        case '\uE009':
        case '\uE00A':
        case '\uE03D':
            return 1;
        case '\uE019':
        case '\uE01A':
        case '\uE01B':
        case '\uE01C':
        case '\uE01D':
        case '\uE01E':
        case '\uE01F':
        case '\uE020':
        case '\uE021':
        case '\uE022':
        case '\uE023':
        case '\uE024':
        case '\uE025':
        case '\uE026':
        case '\uE027':
        case '\uE028':
        case '\uE029':
        case '\uE054':
        case '\uE055':
        case '\uE056':
        case '\uE057':
        case '\uE058':
        case '\uE059':
        case '\uE05A':
        case '\uE05B':
        case '\uE05C':
        case '\uE05D':
            return 3;
        case '\uE050':
        case '\uE051':
        case '\uE052':
        case '\uE053':
            return 2;
        default:
            return 0;
    }
}
//# sourceMappingURL=keyUtils.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/log/LogManager.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LogManager = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
const logHelper_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/log/logHelper.js");
/** Converts CDP StackTrace object to BiDi StackTrace object. */
function getBidiStackTrace(cdpStackTrace) {
    const stackFrames = cdpStackTrace?.callFrames.map((callFrame) => {
        return {
            columnNumber: callFrame.columnNumber,
            functionName: callFrame.functionName,
            lineNumber: callFrame.lineNumber,
            url: callFrame.url,
        };
    });
    return stackFrames ? { callFrames: stackFrames } : undefined;
}
function getLogLevel(consoleApiType) {
    if (["error" /* Log.Level.Error */, 'assert'].includes(consoleApiType)) {
        return "error" /* Log.Level.Error */;
    }
    if (["debug" /* Log.Level.Debug */, 'trace'].includes(consoleApiType)) {
        return "debug" /* Log.Level.Debug */;
    }
    if (["warn" /* Log.Level.Warn */, 'warning'].includes(consoleApiType)) {
        return "warn" /* Log.Level.Warn */;
    }
    return "info" /* Log.Level.Info */;
}
function getLogMethod(consoleApiType) {
    switch (consoleApiType) {
        case 'warning':
            return 'warn';
        case 'startGroup':
            return 'group';
        case 'startGroupCollapsed':
            return 'groupCollapsed';
        case 'endGroup':
            return 'groupEnd';
    }
    return consoleApiType;
}
class LogManager {
    #eventManager;
    #realmStorage;
    #cdpTarget;
    #logger;
    constructor(cdpTarget, realmStorage, eventManager, logger) {
        this.#cdpTarget = cdpTarget;
        this.#realmStorage = realmStorage;
        this.#eventManager = eventManager;
        this.#logger = logger;
    }
    static create(cdpTarget, realmStorage, eventManager, logger) {
        const logManager = new _a(cdpTarget, realmStorage, eventManager, logger);
        logManager.#initializeEntryAddedEventListener();
        return logManager;
    }
    /**
     * Heuristic serialization of CDP remote object. If possible, return the BiDi value
     * without deep serialization.
     */
    async #heuristicSerializeArg(arg, realm) {
        switch (arg.type) {
            // TODO: Implement regexp, array, object, map and set heuristics base on
            //  preview.
            case 'undefined':
                return { type: 'undefined' };
            case 'boolean':
                return { type: 'boolean', value: arg.value };
            case 'string':
                return { type: 'string', value: arg.value };
            case 'number':
                // The value can be either a number or a string like `Infinity` or `-0`.
                return { type: 'number', value: arg.unserializableValue ?? arg.value };
            case 'bigint':
                if (arg.unserializableValue !== undefined &&
                    arg.unserializableValue[arg.unserializableValue.length - 1] === 'n') {
                    return {
                        type: arg.type,
                        value: arg.unserializableValue.slice(0, -1),
                    };
                }
                // Unexpected bigint value, fall back to CDP deep serialization.
                break;
            case 'object':
                if (arg.subtype === 'null') {
                    return { type: 'null' };
                }
                // Fall back to CDP deep serialization.
                break;
            default:
                // Fall back to CDP deep serialization.
                break;
        }
        // Fall back to CDP deep serialization.
        return await realm.serializeCdpObject(arg, "none" /* Script.ResultOwnership.None */);
    }
    #initializeEntryAddedEventListener() {
        this.#cdpTarget.cdpClient.on('Runtime.consoleAPICalled', (params) => {
            // Try to find realm by `cdpSessionId` and `executionContextId`,
            // if provided.
            const realm = this.#realmStorage.findRealm({
                cdpSessionId: this.#cdpTarget.cdpSessionId,
                executionContextId: params.executionContextId,
            });
            if (realm === undefined) {
                // Ignore exceptions not attached to any realm.
                this.#logger?.(log_js_1.LogType.cdp, params);
                return;
            }
            const argsPromise = Promise.all(params.args.map((arg) => this.#heuristicSerializeArg(arg, realm)));
            for (const browsingContext of realm.associatedBrowsingContexts) {
                this.#eventManager.registerPromiseEvent(argsPromise.then((args) => ({
                    kind: 'success',
                    value: {
                        type: 'event',
                        method: protocol_js_1.ChromiumBidi.Log.EventNames.LogEntryAdded,
                        params: {
                            level: getLogLevel(params.type),
                            source: realm.source,
                            text: (0, logHelper_js_1.getRemoteValuesText)(args, true),
                            timestamp: Math.round(params.timestamp),
                            stackTrace: getBidiStackTrace(params.stackTrace),
                            type: 'console',
                            method: getLogMethod(params.type),
                            args,
                        },
                    },
                }), (error) => ({
                    kind: 'error',
                    error,
                })), browsingContext.id, protocol_js_1.ChromiumBidi.Log.EventNames.LogEntryAdded);
            }
        });
        this.#cdpTarget.cdpClient.on('Runtime.exceptionThrown', (params) => {
            // Try to find realm by `cdpSessionId` and `executionContextId`,
            // if provided.
            const realm = this.#realmStorage.findRealm({
                cdpSessionId: this.#cdpTarget.cdpSessionId,
                executionContextId: params.exceptionDetails.executionContextId,
            });
            if (realm === undefined) {
                // Ignore exceptions not attached to any realm.
                this.#logger?.(log_js_1.LogType.cdp, params);
                return;
            }
            for (const browsingContext of realm.associatedBrowsingContexts) {
                this.#eventManager.registerPromiseEvent(_a.#getExceptionText(params, realm).then((text) => ({
                    kind: 'success',
                    value: {
                        type: 'event',
                        method: protocol_js_1.ChromiumBidi.Log.EventNames.LogEntryAdded,
                        params: {
                            level: "error" /* Log.Level.Error */,
                            source: realm.source,
                            text,
                            timestamp: Math.round(params.timestamp),
                            stackTrace: getBidiStackTrace(params.exceptionDetails.stackTrace),
                            type: 'javascript',
                        },
                    },
                }), (error) => ({
                    kind: 'error',
                    error,
                })), browsingContext.id, protocol_js_1.ChromiumBidi.Log.EventNames.LogEntryAdded);
            }
        });
    }
    /**
     * Try the best to get the exception text.
     */
    static async #getExceptionText(params, realm) {
        if (!params.exceptionDetails.exception) {
            return params.exceptionDetails.text;
        }
        if (realm === undefined) {
            return JSON.stringify(params.exceptionDetails.exception);
        }
        return await realm.stringifyObject(params.exceptionDetails.exception);
    }
}
exports.LogManager = LogManager;
_a = LogManager;
//# sourceMappingURL=LogManager.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/log/logHelper.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2022 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.logMessageFormatter = logMessageFormatter;
exports.getRemoteValuesText = getRemoteValuesText;
const assert_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/assert.js");
const specifiers = ['%s', '%d', '%i', '%f', '%o', '%O', '%c'];
function isFormatSpecifier(str) {
    return specifiers.some((spec) => str.includes(spec));
}
/**
 * @param args input remote values to be format printed
 * @return parsed text of the remote values in specific format
 */
function logMessageFormatter(args) {
    let output = '';
    const argFormat = args[0].value.toString();
    const argValues = args.slice(1, undefined);
    const tokens = argFormat.split(new RegExp(specifiers.map((spec) => `(${spec})`).join('|'), 'g'));
    for (const token of tokens) {
        if (token === undefined || token === '') {
            continue;
        }
        if (isFormatSpecifier(token)) {
            const arg = argValues.shift();
            // raise an exception when less value is provided
            (0, assert_js_1.assert)(arg, `Less value is provided: "${getRemoteValuesText(args, false)}"`);
            if (token === '%s') {
                output += stringFromArg(arg);
            }
            else if (token === '%d' || token === '%i') {
                if (arg.type === 'bigint' ||
                    arg.type === 'number' ||
                    arg.type === 'string') {
                    output += parseInt(arg.value.toString(), 10);
                }
                else {
                    output += 'NaN';
                }
            }
            else if (token === '%f') {
                if (arg.type === 'bigint' ||
                    arg.type === 'number' ||
                    arg.type === 'string') {
                    output += parseFloat(arg.value.toString());
                }
                else {
                    output += 'NaN';
                }
            }
            else {
                // %o, %O, %c
                output += toJson(arg);
            }
        }
        else {
            output += token;
        }
    }
    // raise an exception when more value is provided
    if (argValues.length > 0) {
        throw new Error(`More value is provided: "${getRemoteValuesText(args, false)}"`);
    }
    return output;
}
/**
 * @param arg input remote value to be parsed
 * @return parsed text of the remote value
 *
 * input: {"type": "number", "value": 1}
 * output: 1
 *
 * input: {"type": "string", "value": "abc"}
 * output: "abc"
 *
 * input: {"type": "object",  "value": [["id", {"type": "number", "value": 1}]]}
 * output: '{"id": 1}'
 *
 * input: {"type": "object", "value": [["font-size", {"type": "string", "value": "20px"}]]}
 * output: '{"font-size": "20px"}'
 */
function toJson(arg) {
    // arg type validation
    if (arg.type !== 'array' &&
        arg.type !== 'bigint' &&
        arg.type !== 'date' &&
        arg.type !== 'number' &&
        arg.type !== 'object' &&
        arg.type !== 'string') {
        return stringFromArg(arg);
    }
    if (arg.type === 'bigint') {
        return `${arg.value.toString()}n`;
    }
    if (arg.type === 'number') {
        return arg.value.toString();
    }
    if (['date', 'string'].includes(arg.type)) {
        return JSON.stringify(arg.value);
    }
    if (arg.type === 'object') {
        return `{${arg.value
            .map((pair) => {
            return `${JSON.stringify(pair[0])}:${toJson(pair[1])}`;
        })
            .join(',')}}`;
    }
    if (arg.type === 'array') {
        return `[${arg.value?.map((val) => toJson(val)).join(',') ?? ''}]`;
    }
    // eslint-disable-next-line @typescript-eslint/no-base-to-string
    throw Error(`Invalid value type: ${arg}`);
}
function stringFromArg(arg) {
    if (!Object.hasOwn(arg, 'value')) {
        return arg.type;
    }
    switch (arg.type) {
        case 'string':
        case 'number':
        case 'boolean':
        case 'bigint':
            return String(arg.value);
        case 'regexp':
            return `/${arg.value.pattern}/${arg.value.flags ?? ''}`;
        case 'date':
            return new Date(arg.value).toString();
        case 'object':
            return `Object(${arg.value?.length ?? ''})`;
        case 'array':
            return `Array(${arg.value?.length ?? ''})`;
        case 'map':
            return `Map(${arg.value?.length})`;
        case 'set':
            return `Set(${arg.value?.length})`;
        default:
            return arg.type;
    }
}
function getRemoteValuesText(args, formatText) {
    const arg = args[0];
    if (!arg) {
        return '';
    }
    // if args[0] is a format specifier, format the args as output
    if (arg.type === 'string' &&
        isFormatSpecifier(arg.value.toString()) &&
        formatText) {
        return logMessageFormatter(args);
    }
    // if args[0] is not a format specifier, just join the args with \u0020 (unicode 'SPACE')
    return args
        .map((arg) => {
        return stringFromArg(arg);
    })
        .join('\u0020');
}
//# sourceMappingURL=logHelper.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/network/NetworkProcessor.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NetworkProcessor = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const NetworkUtils_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/network/NetworkUtils.js");
/** Dispatches Network module commands. */
class NetworkProcessor {
    #browsingContextStorage;
    #networkStorage;
    constructor(browsingContextStorage, networkStorage) {
        this.#browsingContextStorage = browsingContextStorage;
        this.#networkStorage = networkStorage;
    }
    async addIntercept(params) {
        this.#browsingContextStorage.verifyTopLevelContextsList(params.contexts);
        const urlPatterns = params.urlPatterns ?? [];
        const parsedUrlPatterns = NetworkProcessor.parseUrlPatterns(urlPatterns);
        const intercept = this.#networkStorage.addIntercept({
            urlPatterns: parsedUrlPatterns,
            phases: params.phases,
            contexts: params.contexts,
        });
        await Promise.all(this.#browsingContextStorage.getAllContexts().map((context) => {
            return context.cdpTarget.toggleNetwork();
        }));
        return {
            intercept,
        };
    }
    async continueRequest(params) {
        if (params.url !== undefined) {
            NetworkProcessor.parseUrlString(params.url);
        }
        if (params.method !== undefined) {
            if (!NetworkProcessor.isMethodValid(params.method)) {
                throw new protocol_js_1.InvalidArgumentException(`Method '${params.method}' is invalid.`);
            }
        }
        if (params.headers) {
            NetworkProcessor.validateHeaders(params.headers);
        }
        const request = this.#getBlockedRequestOrFail(params.request, [
            "beforeRequestSent" /* Network.InterceptPhase.BeforeRequestSent */,
        ]);
        try {
            await request.continueRequest(params);
        }
        catch (error) {
            throw NetworkProcessor.wrapInterceptionError(error);
        }
        return {};
    }
    async continueResponse(params) {
        if (params.headers) {
            NetworkProcessor.validateHeaders(params.headers);
        }
        const request = this.#getBlockedRequestOrFail(params.request, [
            "authRequired" /* Network.InterceptPhase.AuthRequired */,
            "responseStarted" /* Network.InterceptPhase.ResponseStarted */,
        ]);
        try {
            await request.continueResponse(params);
        }
        catch (error) {
            throw NetworkProcessor.wrapInterceptionError(error);
        }
        return {};
    }
    async continueWithAuth(params) {
        const networkId = params.request;
        const request = this.#getBlockedRequestOrFail(networkId, [
            "authRequired" /* Network.InterceptPhase.AuthRequired */,
        ]);
        await request.continueWithAuth(params);
        return {};
    }
    async failRequest({ request: networkId, }) {
        const request = this.#getRequestOrFail(networkId);
        if (request.interceptPhase === "authRequired" /* Network.InterceptPhase.AuthRequired */) {
            throw new protocol_js_1.InvalidArgumentException(`Request '${networkId}' in 'authRequired' phase cannot be failed`);
        }
        if (!request.interceptPhase) {
            throw new protocol_js_1.NoSuchRequestException(`No blocked request found for network id '${networkId}'`);
        }
        await request.failRequest('Failed');
        return {};
    }
    async provideResponse(params) {
        if (params.headers) {
            NetworkProcessor.validateHeaders(params.headers);
        }
        const request = this.#getBlockedRequestOrFail(params.request, [
            "beforeRequestSent" /* Network.InterceptPhase.BeforeRequestSent */,
            "responseStarted" /* Network.InterceptPhase.ResponseStarted */,
            "authRequired" /* Network.InterceptPhase.AuthRequired */,
        ]);
        try {
            await request.provideResponse(params);
        }
        catch (error) {
            throw NetworkProcessor.wrapInterceptionError(error);
        }
        return {};
    }
    async removeIntercept(params) {
        this.#networkStorage.removeIntercept(params.intercept);
        await Promise.all(this.#browsingContextStorage.getAllContexts().map((context) => {
            return context.cdpTarget.toggleNetwork();
        }));
        return {};
    }
    async setCacheBehavior(params) {
        const contexts = this.#browsingContextStorage.verifyTopLevelContextsList(params.contexts);
        // Change all targets
        if (contexts.size === 0) {
            this.#networkStorage.defaultCacheBehavior = params.cacheBehavior;
            await Promise.all(this.#browsingContextStorage.getAllContexts().map((context) => {
                return context.cdpTarget.toggleSetCacheDisabled();
            }));
            return {};
        }
        const cacheDisabled = params.cacheBehavior === 'bypass';
        await Promise.all([...contexts.values()].map((context) => {
            return context.cdpTarget.toggleSetCacheDisabled(cacheDisabled);
        }));
        return {};
    }
    #getRequestOrFail(id) {
        const request = this.#networkStorage.getRequestById(id);
        if (!request) {
            throw new protocol_js_1.NoSuchRequestException(`Network request with ID '${id}' doesn't exist`);
        }
        return request;
    }
    #getBlockedRequestOrFail(id, phases) {
        const request = this.#getRequestOrFail(id);
        if (!request.interceptPhase) {
            throw new protocol_js_1.NoSuchRequestException(`No blocked request found for network id '${id}'`);
        }
        if (request.interceptPhase && !phases.includes(request.interceptPhase)) {
            throw new protocol_js_1.InvalidArgumentException(`Blocked request for network id '${id}' is in '${request.interceptPhase}' phase`);
        }
        return request;
    }
    /**
     * Validate https://fetch.spec.whatwg.org/#header-value
     */
    static validateHeaders(headers) {
        for (const header of headers) {
            let headerValue;
            if (header.value.type === 'string') {
                headerValue = header.value.value;
            }
            else {
                headerValue = atob(header.value.value);
            }
            if (headerValue !== headerValue.trim() ||
                headerValue.includes('\n') ||
                headerValue.includes('\0')) {
                throw new protocol_js_1.InvalidArgumentException(`Header value '${headerValue}' is not acceptable value`);
            }
        }
    }
    static isMethodValid(method) {
        // https://httpwg.org/specs/rfc9110.html#method.overview
        return /^[!#$%&'*+\-.^_`|~a-zA-Z\d]+$/.test(method);
    }
    /**
     * Attempts to parse the given url.
     * Throws an InvalidArgumentException if the url is invalid.
     */
    static parseUrlString(url) {
        try {
            return new URL(url);
        }
        catch (error) {
            throw new protocol_js_1.InvalidArgumentException(`Invalid URL '${url}': ${error}`);
        }
    }
    static parseUrlPatterns(urlPatterns) {
        return urlPatterns.map((urlPattern) => {
            let patternUrl = '';
            let hasProtocol = true;
            let hasHostname = true;
            let hasPort = true;
            let hasPathname = true;
            let hasSearch = true;
            switch (urlPattern.type) {
                case 'string': {
                    patternUrl = unescapeURLPattern(urlPattern.pattern);
                    break;
                }
                case 'pattern': {
                    if (urlPattern.protocol === undefined) {
                        hasProtocol = false;
                        patternUrl += 'http';
                    }
                    else {
                        if (urlPattern.protocol === '') {
                            throw new protocol_js_1.InvalidArgumentException('URL pattern must specify a protocol');
                        }
                        urlPattern.protocol = unescapeURLPattern(urlPattern.protocol);
                        if (!urlPattern.protocol.match(/^[a-zA-Z+-.]+$/)) {
                            throw new protocol_js_1.InvalidArgumentException('Forbidden characters');
                        }
                        patternUrl += urlPattern.protocol;
                    }
                    const scheme = patternUrl.toLocaleLowerCase();
                    patternUrl += ':';
                    if ((0, NetworkUtils_js_1.isSpecialScheme)(scheme)) {
                        patternUrl += '//';
                    }
                    if (urlPattern.hostname === undefined) {
                        if (scheme !== 'file') {
                            patternUrl += 'placeholder';
                        }
                        hasHostname = false;
                    }
                    else {
                        if (urlPattern.hostname === '') {
                            throw new protocol_js_1.InvalidArgumentException('URL pattern must specify a hostname');
                        }
                        if (urlPattern.protocol === 'file') {
                            throw new protocol_js_1.InvalidArgumentException(`URL pattern protocol cannot be 'file'`);
                        }
                        urlPattern.hostname = unescapeURLPattern(urlPattern.hostname);
                        let insideBrackets = false;
                        for (const c of urlPattern.hostname) {
                            if (c === '/' || c === '?' || c === '#') {
                                throw new protocol_js_1.InvalidArgumentException(`'/', '?', '#' are forbidden in hostname`);
                            }
                            if (!insideBrackets && c === ':') {
                                throw new protocol_js_1.InvalidArgumentException(`':' is only allowed inside brackets in hostname`);
                            }
                            if (c === '[') {
                                insideBrackets = true;
                            }
                            if (c === ']') {
                                insideBrackets = false;
                            }
                        }
                        patternUrl += urlPattern.hostname;
                    }
                    if (urlPattern.port === undefined) {
                        hasPort = false;
                    }
                    else {
                        if (urlPattern.port === '') {
                            throw new protocol_js_1.InvalidArgumentException(`URL pattern must specify a port`);
                        }
                        urlPattern.port = unescapeURLPattern(urlPattern.port);
                        patternUrl += ':';
                        if (!urlPattern.port.match(/^\d+$/)) {
                            throw new protocol_js_1.InvalidArgumentException('Forbidden characters');
                        }
                        patternUrl += urlPattern.port;
                    }
                    if (urlPattern.pathname === undefined) {
                        hasPathname = false;
                    }
                    else {
                        urlPattern.pathname = unescapeURLPattern(urlPattern.pathname);
                        if (urlPattern.pathname[0] !== '/') {
                            patternUrl += '/';
                        }
                        if (urlPattern.pathname.includes('#') ||
                            urlPattern.pathname.includes('?')) {
                            throw new protocol_js_1.InvalidArgumentException('Forbidden characters');
                        }
                        patternUrl += urlPattern.pathname;
                    }
                    if (urlPattern.search === undefined) {
                        hasSearch = false;
                    }
                    else {
                        urlPattern.search = unescapeURLPattern(urlPattern.search);
                        if (urlPattern.search[0] !== '?') {
                            patternUrl += '?';
                        }
                        if (urlPattern.search.includes('#')) {
                            throw new protocol_js_1.InvalidArgumentException('Forbidden characters');
                        }
                        patternUrl += urlPattern.search;
                    }
                    break;
                }
            }
            const serializePort = (url) => {
                const defaultPorts = {
                    'ftp:': 21,
                    'file:': null,
                    'http:': 80,
                    'https:': 443,
                    'ws:': 80,
                    'wss:': 443,
                };
                if ((0, NetworkUtils_js_1.isSpecialScheme)(url.protocol) &&
                    defaultPorts[url.protocol] !== null &&
                    (!url.port || String(defaultPorts[url.protocol]) === url.port)) {
                    return '';
                }
                else if (url.port) {
                    return url.port;
                }
                return undefined;
            };
            try {
                const url = new URL(patternUrl);
                return {
                    protocol: hasProtocol ? url.protocol.replace(/:$/, '') : undefined,
                    hostname: hasHostname ? url.hostname : undefined,
                    port: hasPort ? serializePort(url) : undefined,
                    pathname: hasPathname && url.pathname ? url.pathname : undefined,
                    search: hasSearch ? url.search : undefined,
                };
            }
            catch (err) {
                throw new protocol_js_1.InvalidArgumentException(`${err.message} '${patternUrl}'`);
            }
        });
    }
    static wrapInterceptionError(error) {
        // https://source.chromium.org/chromium/chromium/src/+/main:content/browser/devtools/protocol/fetch_handler.cc;l=169
        if (error?.message.includes('Invalid header')) {
            return new protocol_js_1.InvalidArgumentException('Invalid header');
        }
        return error;
    }
}
exports.NetworkProcessor = NetworkProcessor;
/**
 * See https://w3c.github.io/webdriver-bidi/#unescape-url-pattern
 */
function unescapeURLPattern(pattern) {
    const forbidden = new Set(['(', ')', '*', '{', '}']);
    let result = '';
    let isEscaped = false;
    for (const c of pattern) {
        if (!isEscaped) {
            if (forbidden.has(c)) {
                throw new protocol_js_1.InvalidArgumentException('Forbidden characters');
            }
            if (c === '\\') {
                isEscaped = true;
                continue;
            }
        }
        result += c;
        isEscaped = false;
    }
    return result;
}
//# sourceMappingURL=NetworkProcessor.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/network/NetworkRequest.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NetworkRequest = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const assert_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/assert.js");
const DefaultMap_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/DefaultMap.js");
const Deferred_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/Deferred.js");
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
const NetworkUtils_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/network/NetworkUtils.js");
const REALM_REGEX = /(?<=realm=").*(?=")/;
/** Abstracts one individual network request. */
class NetworkRequest {
    static unknownParameter = 'UNKNOWN';
    /**
     * Each network request has an associated request id, which is a string
     * uniquely identifying that request.
     *
     * The identifier for a request resulting from a redirect matches that of the
     * request that initiated it.
     */
    #id;
    #fetchId;
    /**
     * Indicates the network intercept phase, if the request is currently blocked.
     * Undefined necessarily implies that the request is not blocked.
     */
    #interceptPhase;
    #servedFromCache = false;
    #redirectCount;
    #request = {};
    #requestOverrides;
    #responseOverrides;
    #response = {};
    #eventManager;
    #networkStorage;
    #cdpTarget;
    #logger;
    #emittedEvents = {
        [protocol_js_1.ChromiumBidi.Network.EventNames.AuthRequired]: false,
        [protocol_js_1.ChromiumBidi.Network.EventNames.BeforeRequestSent]: false,
        [protocol_js_1.ChromiumBidi.Network.EventNames.FetchError]: false,
        [protocol_js_1.ChromiumBidi.Network.EventNames.ResponseCompleted]: false,
        [protocol_js_1.ChromiumBidi.Network.EventNames.ResponseStarted]: false,
    };
    waitNextPhase = new Deferred_js_1.Deferred();
    constructor(id, eventManager, networkStorage, cdpTarget, redirectCount = 0, logger) {
        this.#id = id;
        this.#eventManager = eventManager;
        this.#networkStorage = networkStorage;
        this.#cdpTarget = cdpTarget;
        this.#redirectCount = redirectCount;
        this.#logger = logger;
    }
    get id() {
        return this.#id;
    }
    get fetchId() {
        return this.#fetchId;
    }
    /**
     * When blocked returns the phase for it
     */
    get interceptPhase() {
        return this.#interceptPhase;
    }
    get url() {
        const fragment = this.#request.info?.request.urlFragment ??
            this.#request.paused?.request.urlFragment ??
            '';
        const url = this.#response.paused?.request.url ??
            this.#requestOverrides?.url ??
            this.#response.info?.url ??
            this.#request.auth?.request.url ??
            this.#request.info?.request.url ??
            this.#request.paused?.request.url ??
            _a.unknownParameter;
        return `${url}${fragment}`;
    }
    get redirectCount() {
        return this.#redirectCount;
    }
    get cdpTarget() {
        return this.#cdpTarget;
    }
    get cdpClient() {
        return this.#cdpTarget.cdpClient;
    }
    isRedirecting() {
        return Boolean(this.#request.info);
    }
    #isDataUrl() {
        return this.url.startsWith('data:');
    }
    get #method() {
        return (this.#requestOverrides?.method ??
            this.#request.info?.request.method ??
            this.#request.paused?.request.method ??
            this.#request.auth?.request.method ??
            this.#response.paused?.request.method);
    }
    get #navigationId() {
        // Heuristic to determine if this is a navigation request, and if not return null.
        if (!this.#request.info ||
            !this.#request.info.loaderId ||
            // When we navigate all CDP network events have `loaderId`
            // CDP's `loaderId` and `requestId` match when
            // that request triggered the loading
            this.#request.info.loaderId !== this.#request.info.requestId) {
            return null;
        }
        // Get virtual navigation ID from the browsing context.
        return this.#networkStorage.getNavigationId(this.#context ?? undefined);
    }
    get #cookies() {
        let cookies = [];
        if (this.#request.extraInfo) {
            cookies = this.#request.extraInfo.associatedCookies
                .filter(({ blockedReasons }) => {
                return !Array.isArray(blockedReasons) || blockedReasons.length === 0;
            })
                .map(({ cookie }) => (0, NetworkUtils_js_1.cdpToBiDiCookie)(cookie));
        }
        return cookies;
    }
    get #bodySize() {
        let bodySize = 0;
        if (typeof this.#requestOverrides?.bodySize === 'number') {
            bodySize = this.#requestOverrides.bodySize;
        }
        else {
            bodySize = (0, NetworkUtils_js_1.bidiBodySizeFromCdpPostDataEntries)(this.#request.info?.request.postDataEntries ?? []);
        }
        return bodySize;
    }
    get #context() {
        return (this.#response.paused?.frameId ??
            this.#request.info?.frameId ??
            this.#request.paused?.frameId ??
            this.#request.auth?.frameId ??
            null);
    }
    /** Returns the HTTP status code associated with this request if any. */
    get #statusCode() {
        return (this.#responseOverrides?.statusCode ??
            this.#response.paused?.responseStatusCode ??
            this.#response.extraInfo?.statusCode ??
            this.#response.info?.status);
    }
    get #requestHeaders() {
        let headers = [];
        if (this.#requestOverrides?.headers) {
            const headerMap = new DefaultMap_js_1.DefaultMap(() => []);
            for (const header of this.#requestOverrides.headers) {
                headerMap.get(header.name).push(header.value.value);
            }
            for (const [name, value] of headerMap.entries()) {
                headers.push({
                    name,
                    value: {
                        type: 'string',
                        value: value.join('\n').trimEnd(),
                    },
                });
            }
        }
        else {
            headers = [
                ...(0, NetworkUtils_js_1.bidiNetworkHeadersFromCdpNetworkHeaders)(this.#request.info?.request.headers),
                ...(0, NetworkUtils_js_1.bidiNetworkHeadersFromCdpNetworkHeaders)(this.#request.extraInfo?.headers),
            ];
        }
        return headers;
    }
    get #authChallenges() {
        // TODO: get headers from Fetch.requestPaused
        if (!this.#response.info) {
            return;
        }
        if (!(this.#statusCode === 401 || this.#statusCode === 407)) {
            return undefined;
        }
        const headerName = this.#statusCode === 401 ? 'WWW-Authenticate' : 'Proxy-Authenticate';
        const authChallenges = [];
        for (const [header, value] of Object.entries(this.#response.info.headers)) {
            // TODO: Do a proper match based on https://httpwg.org/specs/rfc9110.html#credentials
            // Or verify this works
            if (header.localeCompare(headerName, undefined, { sensitivity: 'base' }) === 0) {
                authChallenges.push({
                    scheme: value.split(' ').at(0) ?? '',
                    realm: value.match(REALM_REGEX)?.at(0) ?? '',
                });
            }
        }
        return authChallenges;
    }
    get #timings() {
        // The timing in the CDP events are provided relative to the event's baseline.
        // However, the baseline can be different for different events, and the events have to
        // be normalized throughout resource events. Normalize events timestamps  by the
        // request.
        // TODO: Verify this is correct.
        const responseTimeOffset = (0, NetworkUtils_js_1.getTiming)((0, NetworkUtils_js_1.getTiming)(this.#response.info?.timing?.requestTime) -
            (0, NetworkUtils_js_1.getTiming)(this.#request.info?.timestamp));
        return {
            // TODO: Verify this is correct
            timeOrigin: Math.round((0, NetworkUtils_js_1.getTiming)(this.#request.info?.wallTime) * 1000),
            // Timing baseline.
            // TODO: Verify this is correct.
            requestTime: 0,
            // TODO: set if redirect detected.
            redirectStart: 0,
            // TODO: set if redirect detected.
            redirectEnd: 0,
            // TODO: Verify this is correct
            // https://source.chromium.org/chromium/chromium/src/+/main:net/base/load_timing_info.h;l=145
            fetchStart: (0, NetworkUtils_js_1.getTiming)(this.#response.info?.timing?.workerFetchStart, responseTimeOffset),
            // fetchStart: 0,
            dnsStart: (0, NetworkUtils_js_1.getTiming)(this.#response.info?.timing?.dnsStart, responseTimeOffset),
            dnsEnd: (0, NetworkUtils_js_1.getTiming)(this.#response.info?.timing?.dnsEnd, responseTimeOffset),
            connectStart: (0, NetworkUtils_js_1.getTiming)(this.#response.info?.timing?.connectStart, responseTimeOffset),
            connectEnd: (0, NetworkUtils_js_1.getTiming)(this.#response.info?.timing?.connectEnd, responseTimeOffset),
            tlsStart: (0, NetworkUtils_js_1.getTiming)(this.#response.info?.timing?.sslStart, responseTimeOffset),
            requestStart: (0, NetworkUtils_js_1.getTiming)(this.#response.info?.timing?.sendStart, responseTimeOffset),
            // https://source.chromium.org/chromium/chromium/src/+/main:net/base/load_timing_info.h;l=196
            responseStart: (0, NetworkUtils_js_1.getTiming)(this.#response.info?.timing?.receiveHeadersStart, responseTimeOffset),
            responseEnd: (0, NetworkUtils_js_1.getTiming)(this.#response.info?.timing?.receiveHeadersEnd, responseTimeOffset),
        };
    }
    #phaseChanged() {
        this.waitNextPhase.resolve();
        this.waitNextPhase = new Deferred_js_1.Deferred();
    }
    #interceptsInPhase(phase) {
        if (!this.#cdpTarget.isSubscribedTo(`network.${phase}`)) {
            return new Set();
        }
        return this.#networkStorage.getInterceptsForPhase(this, phase);
    }
    #isBlockedInPhase(phase) {
        return this.#interceptsInPhase(phase).size > 0;
    }
    handleRedirect(event) {
        // TODO: use event.redirectResponse;
        // Temporary workaround to emit ResponseCompleted event for redirects
        this.#response.hasExtraInfo = false;
        this.#response.info = event.redirectResponse;
        this.#emitEventsIfReady({
            wasRedirected: true,
        });
    }
    #emitEventsIfReady(options = {}) {
        const requestExtraInfoCompleted = 
        // Flush redirects
        options.wasRedirected ||
            options.hasFailed ||
            this.#isDataUrl() ||
            Boolean(this.#request.extraInfo) ||
            // Requests from cache don't have extra info
            this.#servedFromCache ||
            // Sometimes there is no extra info and the response
            // is the only place we can find out
            Boolean(this.#response.info && !this.#response.hasExtraInfo);
        const noInterceptionExpected = 
        // We can't intercept data urls from CDP
        this.#isDataUrl() ||
            // Cached requests never hit the network
            this.#servedFromCache;
        const requestInterceptionExpected = !noInterceptionExpected &&
            this.#isBlockedInPhase("beforeRequestSent" /* Network.InterceptPhase.BeforeRequestSent */);
        const requestInterceptionCompleted = !requestInterceptionExpected ||
            (requestInterceptionExpected && Boolean(this.#request.paused));
        if (Boolean(this.#request.info) &&
            (requestInterceptionExpected
                ? requestInterceptionCompleted
                : requestExtraInfoCompleted)) {
            this.#emitEvent(this.#getBeforeRequestEvent.bind(this));
        }
        const responseExtraInfoCompleted = Boolean(this.#response.extraInfo) ||
            // Response from cache don't have extra info
            this.#servedFromCache ||
            // Don't expect extra info if the flag is false
            Boolean(this.#response.info && !this.#response.hasExtraInfo);
        const responseInterceptionExpected = !noInterceptionExpected &&
            this.#isBlockedInPhase("responseStarted" /* Network.InterceptPhase.ResponseStarted */);
        if (this.#response.info ||
            (responseInterceptionExpected && Boolean(this.#response.paused))) {
            this.#emitEvent(this.#getResponseStartedEvent.bind(this));
        }
        const responseInterceptionCompleted = !responseInterceptionExpected ||
            (responseInterceptionExpected && Boolean(this.#response.paused));
        if (Boolean(this.#response.info) &&
            responseExtraInfoCompleted &&
            responseInterceptionCompleted) {
            this.#emitEvent(this.#getResponseReceivedEvent.bind(this));
            this.#networkStorage.deleteRequest(this.id);
        }
    }
    onRequestWillBeSentEvent(event) {
        this.#request.info = event;
        this.#emitEventsIfReady();
    }
    onRequestWillBeSentExtraInfoEvent(event) {
        this.#request.extraInfo = event;
        this.#emitEventsIfReady();
    }
    onResponseReceivedExtraInfoEvent(event) {
        if (event.statusCode >= 300 &&
            event.statusCode <= 399 &&
            this.#request.info &&
            event.headers['location'] === this.#request.info.request.url) {
            // We received the Response Extra info for the redirect
            // Too late so we need to skip it as it will
            // fire wrongly for the last one
            return;
        }
        this.#response.extraInfo = event;
        this.#emitEventsIfReady();
    }
    onResponseReceivedEvent(event) {
        this.#response.hasExtraInfo = event.hasExtraInfo;
        this.#response.info = event.response;
        this.#emitEventsIfReady();
    }
    onServedFromCache() {
        this.#servedFromCache = true;
        this.#emitEventsIfReady();
    }
    onLoadingFailedEvent(event) {
        this.#emitEventsIfReady({
            hasFailed: true,
        });
        this.#emitEvent(() => {
            return {
                method: protocol_js_1.ChromiumBidi.Network.EventNames.FetchError,
                params: {
                    ...this.#getBaseEventParams(),
                    errorText: event.errorText,
                },
            };
        });
    }
    /** @see https://chromedevtools.github.io/devtools-protocol/tot/Fetch/#method-failRequest */
    async failRequest(errorReason) {
        (0, assert_js_1.assert)(this.#fetchId, 'Network Interception not set-up.');
        await this.cdpClient.sendCommand('Fetch.failRequest', {
            requestId: this.#fetchId,
            errorReason,
        });
        this.#interceptPhase = undefined;
    }
    onRequestPaused(event) {
        this.#fetchId = event.requestId;
        // CDP https://chromedevtools.github.io/devtools-protocol/tot/Fetch/#event-requestPaused
        if (event.responseStatusCode || event.responseErrorReason) {
            this.#response.paused = event;
            if (this.#isBlockedInPhase("responseStarted" /* Network.InterceptPhase.ResponseStarted */) &&
                // CDP may emit multiple events for a single request
                !this.#emittedEvents[protocol_js_1.ChromiumBidi.Network.EventNames.ResponseStarted] &&
                // Continue all response that have not enabled Network domain
                this.#fetchId !== this.id) {
                this.#interceptPhase = "responseStarted" /* Network.InterceptPhase.ResponseStarted */;
            }
            else {
                void this.#continueResponse();
            }
        }
        else {
            this.#request.paused = event;
            if (this.#isBlockedInPhase("beforeRequestSent" /* Network.InterceptPhase.BeforeRequestSent */) &&
                // CDP may emit multiple events for a single request
                !this.#emittedEvents[protocol_js_1.ChromiumBidi.Network.EventNames.BeforeRequestSent] &&
                // Continue all requests that have not enabled Network domain
                this.#fetchId !== this.id) {
                this.#interceptPhase = "beforeRequestSent" /* Network.InterceptPhase.BeforeRequestSent */;
            }
            else {
                void this.#continueRequest();
            }
        }
        this.#emitEventsIfReady();
    }
    onAuthRequired(event) {
        this.#fetchId = event.requestId;
        this.#request.auth = event;
        if (this.#isBlockedInPhase("authRequired" /* Network.InterceptPhase.AuthRequired */) &&
            // Continue all auth requests that have not enabled Network domain
            this.#fetchId !== this.id) {
            this.#interceptPhase = "authRequired" /* Network.InterceptPhase.AuthRequired */;
        }
        else {
            void this.#continueWithAuth({
                response: 'Default',
            });
        }
        this.#emitEvent(() => {
            return {
                method: protocol_js_1.ChromiumBidi.Network.EventNames.AuthRequired,
                params: {
                    ...this.#getBaseEventParams("authRequired" /* Network.InterceptPhase.AuthRequired */),
                    response: this.#getResponseEventParams(),
                },
            };
        });
    }
    /** @see https://chromedevtools.github.io/devtools-protocol/tot/Fetch/#method-continueRequest */
    async continueRequest(overrides = {}) {
        const overrideHeaders = this.#getOverrideHeader(overrides.headers, overrides.cookies);
        const headers = (0, NetworkUtils_js_1.cdpFetchHeadersFromBidiNetworkHeaders)(overrideHeaders);
        const postData = getCdpBodyFromBiDiBytesValue(overrides.body);
        await this.#continueRequest({
            url: overrides.url,
            method: overrides.method,
            headers,
            postData,
        });
        this.#requestOverrides = {
            url: overrides.url,
            method: overrides.method,
            headers: overrides.headers,
            cookies: overrides.cookies,
            bodySize: getSizeFromBiDiBytesValue(overrides.body),
        };
    }
    async #continueRequest(overrides = {}) {
        (0, assert_js_1.assert)(this.#fetchId, 'Network Interception not set-up.');
        await this.cdpClient.sendCommand('Fetch.continueRequest', {
            requestId: this.#fetchId,
            url: overrides.url,
            method: overrides.method,
            headers: overrides.headers,
            postData: overrides.postData,
        });
        this.#interceptPhase = undefined;
    }
    /** @see https://chromedevtools.github.io/devtools-protocol/tot/Fetch/#method-continueResponse */
    async continueResponse(overrides = {}) {
        if (this.interceptPhase === "authRequired" /* Network.InterceptPhase.AuthRequired */) {
            if (overrides.credentials) {
                await Promise.all([
                    this.waitNextPhase,
                    await this.#continueWithAuth({
                        response: 'ProvideCredentials',
                        username: overrides.credentials.username,
                        password: overrides.credentials.password,
                    }),
                ]);
            }
            else {
                // We need to use `ProvideCredentials`
                // As `Default` may cancel the request
                return await this.#continueWithAuth({
                    response: 'ProvideCredentials',
                });
            }
        }
        if (this.#interceptPhase === "responseStarted" /* Network.InterceptPhase.ResponseStarted */) {
            const overrideHeaders = this.#getOverrideHeader(overrides.headers, overrides.cookies);
            const responseHeaders = (0, NetworkUtils_js_1.cdpFetchHeadersFromBidiNetworkHeaders)(overrideHeaders);
            await this.#continueResponse({
                responseCode: overrides.statusCode ?? this.#response.paused?.responseStatusCode,
                responsePhrase: overrides.reasonPhrase ?? this.#response.paused?.responseStatusText,
                responseHeaders: responseHeaders ?? this.#response.paused?.responseHeaders,
            });
            this.#responseOverrides = {
                statusCode: overrides.statusCode,
                headers: overrideHeaders,
            };
        }
    }
    async #continueResponse({ responseCode, responsePhrase, responseHeaders, } = {}) {
        (0, assert_js_1.assert)(this.#fetchId, 'Network Interception not set-up.');
        await this.cdpClient.sendCommand('Fetch.continueResponse', {
            requestId: this.#fetchId,
            responseCode,
            responsePhrase,
            responseHeaders,
        });
        this.#interceptPhase = undefined;
    }
    /** @see https://chromedevtools.github.io/devtools-protocol/tot/Fetch/#method-continueWithAuth */
    async continueWithAuth(authChallenge) {
        let username;
        let password;
        if (authChallenge.action === 'provideCredentials') {
            const { credentials } = authChallenge;
            username = credentials.username;
            password = credentials.password;
        }
        const response = (0, NetworkUtils_js_1.cdpAuthChallengeResponseFromBidiAuthContinueWithAuthAction)(authChallenge.action);
        await this.#continueWithAuth({
            response,
            username,
            password,
        });
    }
    /** @see https://chromedevtools.github.io/devtools-protocol/tot/Fetch/#method-provideResponse */
    async provideResponse(overrides) {
        (0, assert_js_1.assert)(this.#fetchId, 'Network Interception not set-up.');
        // We need to pass through if the request is already in
        // AuthRequired phase
        if (this.interceptPhase === "authRequired" /* Network.InterceptPhase.AuthRequired */) {
            // We need to use `ProvideCredentials`
            // As `Default` may cancel the request
            return await this.#continueWithAuth({
                response: 'ProvideCredentials',
            });
        }
        // If we don't modify the response
        // just continue the request
        if (!overrides.body && !overrides.headers) {
            return await this.#continueRequest();
        }
        const overrideHeaders = this.#getOverrideHeader(overrides.headers, overrides.cookies);
        const responseHeaders = (0, NetworkUtils_js_1.cdpFetchHeadersFromBidiNetworkHeaders)(overrideHeaders);
        const responseCode = overrides.statusCode ?? this.#statusCode ?? 200;
        await this.cdpClient.sendCommand('Fetch.fulfillRequest', {
            requestId: this.#fetchId,
            responseCode,
            responsePhrase: overrides.reasonPhrase,
            responseHeaders,
            body: getCdpBodyFromBiDiBytesValue(overrides.body),
        });
        this.#interceptPhase = undefined;
    }
    dispose() {
        this.waitNextPhase.reject(new Error('waitNextPhase disposed'));
    }
    async #continueWithAuth(authChallengeResponse) {
        (0, assert_js_1.assert)(this.#fetchId, 'Network Interception not set-up.');
        await this.cdpClient.sendCommand('Fetch.continueWithAuth', {
            requestId: this.#fetchId,
            authChallengeResponse,
        });
        this.#interceptPhase = undefined;
    }
    #emitEvent(getEvent) {
        let event;
        try {
            event = getEvent();
        }
        catch (error) {
            this.#logger?.(log_js_1.LogType.debugError, error);
            return;
        }
        if (this.#isIgnoredEvent() ||
            (this.#emittedEvents[event.method] &&
                // Special case this event can be emitted multiple times
                event.method !== protocol_js_1.ChromiumBidi.Network.EventNames.AuthRequired)) {
            return;
        }
        this.#phaseChanged();
        this.#emittedEvents[event.method] = true;
        if (this.#context) {
            this.#eventManager.registerEvent(Object.assign(event, {
                type: 'event',
            }), this.#context);
        }
        else {
            this.#eventManager.registerGlobalEvent(Object.assign(event, {
                type: 'event',
            }));
        }
    }
    #getBaseEventParams(phase) {
        const interceptProps = {
            isBlocked: false,
        };
        if (phase) {
            const blockedBy = this.#interceptsInPhase(phase);
            interceptProps.isBlocked = blockedBy.size > 0;
            if (interceptProps.isBlocked) {
                interceptProps.intercepts = [...blockedBy];
            }
        }
        return {
            context: this.#context,
            navigation: this.#navigationId,
            redirectCount: this.#redirectCount,
            request: this.#getRequestData(),
            // Timestamp should be in milliseconds, while CDP provides it in seconds.
            timestamp: Math.round((0, NetworkUtils_js_1.getTiming)(this.#request.info?.wallTime) * 1000),
            // Contains isBlocked and intercepts
            ...interceptProps,
        };
    }
    #getResponseEventParams() {
        // Chromium sends wrong extraInfo events for responses served from cache.
        // See https://github.com/puppeteer/puppeteer/issues/9965 and
        // https://crbug.com/1340398.
        if (this.#response.info?.fromDiskCache) {
            this.#response.extraInfo = undefined;
        }
        const headers = [
            ...(0, NetworkUtils_js_1.bidiNetworkHeadersFromCdpNetworkHeaders)(this.#response.info?.headers),
            ...(0, NetworkUtils_js_1.bidiNetworkHeadersFromCdpNetworkHeaders)(this.#response.extraInfo?.headers),
            // TODO: Verify how to dedupe these
            // ...bidiNetworkHeadersFromCdpNetworkHeadersEntries(
            //   this.#response.paused?.responseHeaders
            // ),
        ];
        const authChallenges = this.#authChallenges;
        const response = {
            url: this.url,
            protocol: this.#response.info?.protocol ?? '',
            status: this.#statusCode ?? -1, // TODO: Throw an exception or use some other status code?
            statusText: this.#response.info?.statusText ||
                this.#response.paused?.responseStatusText ||
                '',
            fromCache: this.#response.info?.fromDiskCache ||
                this.#response.info?.fromPrefetchCache ||
                this.#servedFromCache,
            headers: this.#responseOverrides?.headers ?? headers,
            mimeType: this.#response.info?.mimeType || '',
            bytesReceived: this.#response.info?.encodedDataLength || 0,
            headersSize: (0, NetworkUtils_js_1.computeHeadersSize)(headers),
            // TODO: consider removing from spec.
            bodySize: 0,
            content: {
                // TODO: consider removing from spec.
                size: 0,
            },
            ...(authChallenges ? { authChallenges } : {}),
        };
        return {
            ...response,
            'goog:securityDetails': this.#response.info?.securityDetails,
        };
    }
    #getRequestData() {
        const headers = this.#requestHeaders;
        const request = {
            request: this.#id,
            url: this.url,
            method: this.#method ?? _a.unknownParameter,
            headers,
            cookies: this.#cookies,
            headersSize: (0, NetworkUtils_js_1.computeHeadersSize)(headers),
            bodySize: this.#bodySize,
            // TODO: populate
            destination: this.#getDestination(),
            // TODO: populate
            initiatorType: this.#getInitiatorType(),
            timings: this.#timings,
        };
        return {
            ...request,
            'goog:postData': this.#request.info?.request?.postData,
            'goog:hasPostData': this.#request.info?.request?.hasPostData,
            'goog:resourceType': this.#request.info?.type,
            'goog:resourceInitiator': this.#request.info?.initiator,
        };
    }
    /**
     * Heuristic trying to guess the destination.
     * Specification: https://fetch.spec.whatwg.org/#concept-request-destination.
     * Specified values: "audio", "audioworklet", "document", "embed", "font", "frame",
     * "iframe", "image", "json", "manifest", "object", "paintworklet", "report", "script",
     * "serviceworker", "sharedworker", "style", "track", "video", "webidentity", "worker",
     * "xslt".
     */
    #getDestination() {
        switch (this.#request.info?.type) {
            case 'Script':
                return 'script';
            case 'Stylesheet':
                return 'style';
            case 'Image':
                return 'image';
            case 'Document':
                // If request to document is initiated by parser, assume it is expected to
                // arrive in an iframe. Otherwise, fallback to empty string.
                return this.#request.info?.initiator.type === 'parser' ? 'iframe' : '';
            default:
                return '';
        }
    }
    /**
     * Heuristic trying to guess the initiator type.
     * Specification: https://fetch.spec.whatwg.org/#request-initiator-type.
     * Specified values: "audio", "beacon", "body", "css", "early-hints", "embed", "fetch",
     * "font", "frame", "iframe", "image", "img", "input", "link", "object", "ping",
     * "script", "track", "video", "xmlhttprequest", "other".
     */
    #getInitiatorType() {
        if (this.#request.info?.initiator.type === 'parser') {
            switch (this.#request.info?.type) {
                case 'Document':
                    // The request to document is initiated by the parser. Assuming it's an iframe.
                    return 'iframe';
                case 'Font':
                    // If the document's url is not the parser's url, assume the resource is loaded
                    // from css. Otherwise, it's a `font` element.
                    return this.#request.info?.initiator?.url ===
                        this.#request.info?.documentURL
                        ? 'font'
                        : 'css';
                case 'Image':
                    // If the document's url is not the parser's url, assume the resource is loaded
                    // from css. Otherwise, it's a `img` element.
                    return this.#request.info?.initiator?.url ===
                        this.#request.info?.documentURL
                        ? 'img'
                        : 'css';
                case 'Script':
                    return 'script';
                case 'Stylesheet':
                    return 'link';
                default:
                    return null;
            }
        }
        if (this.#request?.info?.type === 'Fetch') {
            return 'fetch';
        }
        return null;
    }
    #getBeforeRequestEvent() {
        (0, assert_js_1.assert)(this.#request.info, 'RequestWillBeSentEvent is not set');
        return {
            method: protocol_js_1.ChromiumBidi.Network.EventNames.BeforeRequestSent,
            params: {
                ...this.#getBaseEventParams("beforeRequestSent" /* Network.InterceptPhase.BeforeRequestSent */),
                initiator: {
                    type: _a.#getInitiator(this.#request.info.initiator.type),
                    columnNumber: this.#request.info.initiator.columnNumber,
                    lineNumber: this.#request.info.initiator.lineNumber,
                    stackTrace: this.#request.info.initiator.stack,
                    request: this.#request.info.initiator.requestId,
                },
            },
        };
    }
    #getResponseStartedEvent() {
        return {
            method: protocol_js_1.ChromiumBidi.Network.EventNames.ResponseStarted,
            params: {
                ...this.#getBaseEventParams("responseStarted" /* Network.InterceptPhase.ResponseStarted */),
                response: this.#getResponseEventParams(),
            },
        };
    }
    #getResponseReceivedEvent() {
        return {
            method: protocol_js_1.ChromiumBidi.Network.EventNames.ResponseCompleted,
            params: {
                ...this.#getBaseEventParams(),
                response: this.#getResponseEventParams(),
            },
        };
    }
    #isIgnoredEvent() {
        const faviconUrl = '/favicon.ico';
        return (this.#request.paused?.request.url.endsWith(faviconUrl) ??
            this.#request.info?.request.url.endsWith(faviconUrl) ??
            false);
    }
    #getOverrideHeader(headers, cookies) {
        if (!headers && !cookies) {
            return undefined;
        }
        let overrideHeaders = headers;
        const cookieHeader = (0, NetworkUtils_js_1.networkHeaderFromCookieHeaders)(cookies);
        if (cookieHeader && !overrideHeaders) {
            overrideHeaders = this.#requestHeaders;
        }
        if (cookieHeader && overrideHeaders) {
            overrideHeaders.filter((header) => header.name.localeCompare('cookie', undefined, {
                sensitivity: 'base',
            }) !== 0);
            overrideHeaders.push(cookieHeader);
        }
        return overrideHeaders;
    }
    static #getInitiator(initiatorType) {
        switch (initiatorType) {
            case 'parser':
            case 'script':
            case 'preflight':
                return initiatorType;
            default:
                return 'other';
        }
    }
}
exports.NetworkRequest = NetworkRequest;
_a = NetworkRequest;
function getCdpBodyFromBiDiBytesValue(body) {
    let parsedBody;
    if (body?.type === 'string') {
        parsedBody = (0, NetworkUtils_js_1.stringToBase64)(body.value);
    }
    else if (body?.type === 'base64') {
        parsedBody = body.value;
    }
    return parsedBody;
}
function getSizeFromBiDiBytesValue(body) {
    if (body?.type === 'string') {
        return body.value.length;
    }
    else if (body?.type === 'base64') {
        return atob(body.value).length;
    }
    return 0;
}
//# sourceMappingURL=NetworkRequest.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/network/NetworkStorage.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NetworkStorage = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const uuid_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/uuid.js");
const NetworkRequest_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/network/NetworkRequest.js");
const NetworkUtils_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/network/NetworkUtils.js");
/** Stores network and intercept maps. */
class NetworkStorage {
    #browsingContextStorage;
    #eventManager;
    #logger;
    /**
     * A map from network request ID to Network Request objects.
     * Needed as long as information about requests comes from different events.
     */
    #requests = new Map();
    /** A map from intercept ID to track active network intercepts. */
    #intercepts = new Map();
    #defaultCacheBehavior = 'default';
    constructor(eventManager, browsingContextStorage, browserClient, logger) {
        this.#browsingContextStorage = browsingContextStorage;
        this.#eventManager = eventManager;
        browserClient.on('Target.detachedFromTarget', ({ sessionId }) => {
            this.disposeRequestMap(sessionId);
        });
        this.#logger = logger;
    }
    /**
     * Gets the network request with the given ID, if any.
     * Otherwise, creates a new network request with the given ID and cdp target.
     */
    #getOrCreateNetworkRequest(id, cdpTarget, redirectCount) {
        let request = this.getRequestById(id);
        if (request) {
            return request;
        }
        request = new NetworkRequest_js_1.NetworkRequest(id, this.#eventManager, this, cdpTarget, redirectCount, this.#logger);
        this.addRequest(request);
        return request;
    }
    onCdpTargetCreated(cdpTarget) {
        const cdpClient = cdpTarget.cdpClient;
        // TODO: Wrap into object
        const listeners = [
            [
                'Network.requestWillBeSent',
                (params) => {
                    const request = this.getRequestById(params.requestId);
                    if (request && request.isRedirecting()) {
                        request.handleRedirect(params);
                        this.deleteRequest(params.requestId);
                        this.#getOrCreateNetworkRequest(params.requestId, cdpTarget, request.redirectCount + 1).onRequestWillBeSentEvent(params);
                    }
                    else {
                        this.#getOrCreateNetworkRequest(params.requestId, cdpTarget).onRequestWillBeSentEvent(params);
                    }
                },
            ],
            [
                'Network.requestWillBeSentExtraInfo',
                (params) => {
                    this.#getOrCreateNetworkRequest(params.requestId, cdpTarget).onRequestWillBeSentExtraInfoEvent(params);
                },
            ],
            [
                'Network.responseReceived',
                (params) => {
                    this.#getOrCreateNetworkRequest(params.requestId, cdpTarget).onResponseReceivedEvent(params);
                },
            ],
            [
                'Network.responseReceivedExtraInfo',
                (params) => {
                    this.#getOrCreateNetworkRequest(params.requestId, cdpTarget).onResponseReceivedExtraInfoEvent(params);
                },
            ],
            [
                'Network.requestServedFromCache',
                (params) => {
                    this.#getOrCreateNetworkRequest(params.requestId, cdpTarget).onServedFromCache();
                },
            ],
            [
                'Network.loadingFailed',
                (params) => {
                    this.#getOrCreateNetworkRequest(params.requestId, cdpTarget).onLoadingFailedEvent(params);
                },
            ],
            [
                'Fetch.requestPaused',
                (event) => {
                    this.#getOrCreateNetworkRequest(
                    // CDP quirk if the Network domain is not present this is undefined
                    event.networkId ?? event.requestId, cdpTarget).onRequestPaused(event);
                },
            ],
            [
                'Fetch.authRequired',
                (event) => {
                    let request = this.getRequestByFetchId(event.requestId);
                    if (!request) {
                        request = this.#getOrCreateNetworkRequest(event.requestId, cdpTarget);
                    }
                    request.onAuthRequired(event);
                },
            ],
        ];
        for (const [event, listener] of listeners) {
            cdpClient.on(event, listener);
        }
    }
    getInterceptionStages(browsingContextId) {
        const stages = {
            request: false,
            response: false,
            auth: false,
        };
        for (const intercept of this.#intercepts.values()) {
            if (intercept.contexts &&
                !intercept.contexts.includes(browsingContextId)) {
                continue;
            }
            stages.request ||= intercept.phases.includes("beforeRequestSent" /* Network.InterceptPhase.BeforeRequestSent */);
            stages.response ||= intercept.phases.includes("responseStarted" /* Network.InterceptPhase.ResponseStarted */);
            stages.auth ||= intercept.phases.includes("authRequired" /* Network.InterceptPhase.AuthRequired */);
        }
        return stages;
    }
    getInterceptsForPhase(request, phase) {
        if (request.url === NetworkRequest_js_1.NetworkRequest.unknownParameter) {
            return new Set();
        }
        const intercepts = new Set();
        for (const [interceptId, intercept] of this.#intercepts.entries()) {
            if (!intercept.phases.includes(phase) ||
                (intercept.contexts &&
                    !intercept.contexts.includes(request.cdpTarget.topLevelId))) {
                continue;
            }
            if (intercept.urlPatterns.length === 0) {
                intercepts.add(interceptId);
                continue;
            }
            for (const pattern of intercept.urlPatterns) {
                if ((0, NetworkUtils_js_1.matchUrlPattern)(pattern, request.url)) {
                    intercepts.add(interceptId);
                    break;
                }
            }
        }
        return intercepts;
    }
    disposeRequestMap(sessionId) {
        for (const request of this.#requests.values()) {
            if (request.cdpClient.sessionId === sessionId) {
                this.#requests.delete(request.id);
                request.dispose();
            }
        }
    }
    /**
     * Adds the given entry to the intercept map.
     * URL patterns are assumed to be parsed.
     *
     * @return The intercept ID.
     */
    addIntercept(value) {
        const interceptId = (0, uuid_js_1.uuidv4)();
        this.#intercepts.set(interceptId, value);
        return interceptId;
    }
    /**
     * Removes the given intercept from the intercept map.
     * Throws NoSuchInterceptException if the intercept does not exist.
     */
    removeIntercept(intercept) {
        if (!this.#intercepts.has(intercept)) {
            throw new protocol_js_1.NoSuchInterceptException(`Intercept '${intercept}' does not exist.`);
        }
        this.#intercepts.delete(intercept);
    }
    getRequestsByTarget(target) {
        const requests = [];
        for (const request of this.#requests.values()) {
            if (request.cdpTarget === target) {
                requests.push(request);
            }
        }
        return requests;
    }
    getRequestById(id) {
        return this.#requests.get(id);
    }
    getRequestByFetchId(fetchId) {
        for (const request of this.#requests.values()) {
            if (request.fetchId === fetchId) {
                return request;
            }
        }
        return;
    }
    addRequest(request) {
        this.#requests.set(request.id, request);
    }
    deleteRequest(id) {
        this.#requests.delete(id);
    }
    /**
     * Gets the virtual navigation ID for the given navigable ID.
     */
    getNavigationId(contextId) {
        if (contextId === undefined) {
            return null;
        }
        return (this.#browsingContextStorage.findContext(contextId)?.navigationId ?? null);
    }
    set defaultCacheBehavior(behavior) {
        this.#defaultCacheBehavior = behavior;
    }
    get defaultCacheBehavior() {
        return this.#defaultCacheBehavior;
    }
}
exports.NetworkStorage = NetworkStorage;
//# sourceMappingURL=NetworkStorage.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/network/NetworkUtils.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.computeHeadersSize = computeHeadersSize;
exports.stringToBase64 = stringToBase64;
exports.bidiNetworkHeadersFromCdpNetworkHeaders = bidiNetworkHeadersFromCdpNetworkHeaders;
exports.bidiNetworkHeadersFromCdpNetworkHeadersEntries = bidiNetworkHeadersFromCdpNetworkHeadersEntries;
exports.cdpNetworkHeadersFromBidiNetworkHeaders = cdpNetworkHeadersFromBidiNetworkHeaders;
exports.bidiNetworkHeadersFromCdpFetchHeaders = bidiNetworkHeadersFromCdpFetchHeaders;
exports.cdpFetchHeadersFromBidiNetworkHeaders = cdpFetchHeadersFromBidiNetworkHeaders;
exports.networkHeaderFromCookieHeaders = networkHeaderFromCookieHeaders;
exports.cdpAuthChallengeResponseFromBidiAuthContinueWithAuthAction = cdpAuthChallengeResponseFromBidiAuthContinueWithAuthAction;
exports.cdpToBiDiCookie = cdpToBiDiCookie;
exports.deserializeByteValue = deserializeByteValue;
exports.bidiToCdpCookie = bidiToCdpCookie;
exports.sameSiteBiDiToCdp = sameSiteBiDiToCdp;
exports.isSpecialScheme = isSpecialScheme;
exports.matchUrlPattern = matchUrlPattern;
exports.bidiBodySizeFromCdpPostDataEntries = bidiBodySizeFromCdpPostDataEntries;
exports.getTiming = getTiming;
const ErrorResponse_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/ErrorResponse.js");
const base64_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/base64.js");
function computeHeadersSize(headers) {
    const requestHeaders = headers.reduce((acc, header) => {
        return `${acc}${header.name}: ${header.value.value}\r\n`;
    }, '');
    return new TextEncoder().encode(requestHeaders).length;
}
function stringToBase64(str) {
    return typedArrayToBase64(new TextEncoder().encode(str));
}
function typedArrayToBase64(typedArray) {
    // chunkSize should be less V8 limit on number of arguments!
    // https://github.com/v8/v8/blob/d3de848bea727518aee94dd2fd42ba0b62037a27/src/objects/code.h#L444
    const chunkSize = 65534;
    const chunks = [];
    for (let i = 0; i < typedArray.length; i += chunkSize) {
        const chunk = typedArray.subarray(i, i + chunkSize);
        chunks.push(String.fromCodePoint.apply(null, chunk));
    }
    const binaryString = chunks.join('');
    return btoa(binaryString);
}
/** Converts from CDP Network domain headers to BiDi network headers. */
function bidiNetworkHeadersFromCdpNetworkHeaders(headers) {
    if (!headers) {
        return [];
    }
    return Object.entries(headers).map(([name, value]) => ({
        name,
        value: {
            type: 'string',
            value,
        },
    }));
}
/** Converts from CDP Fetch domain headers to BiDi network headers. */
function bidiNetworkHeadersFromCdpNetworkHeadersEntries(headers) {
    if (!headers) {
        return [];
    }
    return headers.map(({ name, value }) => ({
        name,
        value: {
            type: 'string',
            value,
        },
    }));
}
/** Converts from Bidi network headers to CDP Network domain headers. */
function cdpNetworkHeadersFromBidiNetworkHeaders(headers) {
    if (headers === undefined) {
        return undefined;
    }
    return headers.reduce((result, header) => {
        // TODO: Distinguish between string and bytes?
        result[header.name] = header.value.value;
        return result;
    }, {});
}
/** Converts from CDP Fetch domain header entries to Bidi network headers. */
function bidiNetworkHeadersFromCdpFetchHeaders(headers) {
    if (!headers) {
        return [];
    }
    return headers.map(({ name, value }) => ({
        name,
        value: {
            type: 'string',
            value,
        },
    }));
}
/** Converts from Bidi network headers to CDP Fetch domain header entries. */
function cdpFetchHeadersFromBidiNetworkHeaders(headers) {
    if (headers === undefined) {
        return undefined;
    }
    return headers.map(({ name, value }) => ({
        name,
        value: value.value,
    }));
}
function networkHeaderFromCookieHeaders(headers) {
    if (headers === undefined) {
        return undefined;
    }
    const value = headers.reduce((acc, value, index) => {
        if (index > 0) {
            acc += ';';
        }
        const cookieValue = value.value.type === 'base64'
            ? btoa(value.value.value)
            : value.value.value;
        acc += `${value.name}=${cookieValue}`;
        return acc;
    }, '');
    return {
        name: 'Cookie',
        value: {
            type: 'string',
            value,
        },
    };
}
/** Converts from Bidi auth action to CDP auth challenge response. */
function cdpAuthChallengeResponseFromBidiAuthContinueWithAuthAction(action) {
    switch (action) {
        case 'default':
            return 'Default';
        case 'cancel':
            return 'CancelAuth';
        case 'provideCredentials':
            return 'ProvideCredentials';
    }
}
/**
 * Converts from CDP Network domain cookie to BiDi network cookie.
 * * https://chromedevtools.github.io/devtools-protocol/tot/Network/#type-Cookie
 * * https://w3c.github.io/webdriver-bidi/#type-network-Cookie
 */
function cdpToBiDiCookie(cookie) {
    const result = {
        name: cookie.name,
        value: { type: 'string', value: cookie.value },
        domain: cookie.domain,
        path: cookie.path,
        size: cookie.size,
        httpOnly: cookie.httpOnly,
        secure: cookie.secure,
        sameSite: cookie.sameSite === undefined
            ? "none" /* Network.SameSite.None */
            : sameSiteCdpToBiDi(cookie.sameSite),
        ...(cookie.expires >= 0 ? { expiry: cookie.expires } : undefined),
    };
    // Extending with CDP-specific properties with `goog:` prefix.
    result[`goog:session`] = cookie.session;
    result[`goog:priority`] = cookie.priority;
    result[`goog:sameParty`] = cookie.sameParty;
    result[`goog:sourceScheme`] = cookie.sourceScheme;
    result[`goog:sourcePort`] = cookie.sourcePort;
    if (cookie.partitionKey !== undefined) {
        result[`goog:partitionKey`] = cookie.partitionKey;
    }
    if (cookie.partitionKeyOpaque !== undefined) {
        result[`goog:partitionKeyOpaque`] = cookie.partitionKeyOpaque;
    }
    return result;
}
/**
 * Decodes a byte value to a string.
 * @param {Network.BytesValue} value
 * @return {string}
 */
function deserializeByteValue(value) {
    if (value.type === 'base64') {
        return (0, base64_js_1.base64ToString)(value.value);
    }
    return value.value;
}
/**
 * Converts from BiDi set network cookie params to CDP Network domain cookie.
 * * https://w3c.github.io/webdriver-bidi/#type-network-Cookie
 * * https://chromedevtools.github.io/devtools-protocol/tot/Network/#type-CookieParam
 */
function bidiToCdpCookie(params, partitionKey) {
    const deserializedValue = deserializeByteValue(params.cookie.value);
    const result = {
        name: params.cookie.name,
        value: deserializedValue,
        domain: params.cookie.domain,
        path: params.cookie.path ?? '/',
        secure: params.cookie.secure ?? false,
        httpOnly: params.cookie.httpOnly ?? false,
        ...(partitionKey.sourceOrigin !== undefined && {
            partitionKey: {
                hasCrossSiteAncestor: false,
                // CDP's `partitionKey.topLevelSite` is the BiDi's `partition.sourceOrigin`.
                topLevelSite: partitionKey.sourceOrigin,
            },
        }),
        ...(params.cookie.expiry !== undefined && {
            expires: params.cookie.expiry,
        }),
        ...(params.cookie.sameSite !== undefined && {
            sameSite: sameSiteBiDiToCdp(params.cookie.sameSite),
        }),
    };
    // Extending with CDP-specific properties with `goog:` prefix.
    if (params.cookie[`goog:url`] !== undefined) {
        result.url = params.cookie[`goog:url`];
    }
    if (params.cookie[`goog:priority`] !== undefined) {
        result.priority = params.cookie[`goog:priority`];
    }
    if (params.cookie[`goog:sameParty`] !== undefined) {
        result.sameParty = params.cookie[`goog:sameParty`];
    }
    if (params.cookie[`goog:sourceScheme`] !== undefined) {
        result.sourceScheme = params.cookie[`goog:sourceScheme`];
    }
    if (params.cookie[`goog:sourcePort`] !== undefined) {
        result.sourcePort = params.cookie[`goog:sourcePort`];
    }
    return result;
}
function sameSiteCdpToBiDi(sameSite) {
    switch (sameSite) {
        case 'Strict':
            return "strict" /* Network.SameSite.Strict */;
        case 'None':
            return "none" /* Network.SameSite.None */;
        case 'Lax':
            return "lax" /* Network.SameSite.Lax */;
        default:
            // Defaults to `Lax`:
            // https://web.dev/articles/samesite-cookies-explained#samesitelax_by_default
            return "lax" /* Network.SameSite.Lax */;
    }
}
function sameSiteBiDiToCdp(sameSite) {
    switch (sameSite) {
        case "strict" /* Network.SameSite.Strict */:
            return 'Strict';
        case "lax" /* Network.SameSite.Lax */:
            return 'Lax';
        case "none" /* Network.SameSite.None */:
            return 'None';
    }
    throw new ErrorResponse_js_1.InvalidArgumentException(`Unknown 'sameSite' value ${sameSite}`);
}
/**
 * Returns true if the given protocol is special.
 * Special protocols are those that have a default port.
 *
 * Example inputs: 'http', 'http:'
 *
 * @see https://url.spec.whatwg.org/#special-scheme
 */
function isSpecialScheme(protocol) {
    return ['ftp', 'file', 'http', 'https', 'ws', 'wss'].includes(protocol.replace(/:$/, ''));
}
function getScheme(url) {
    return url.protocol.replace(/:$/, '');
}
/** Matches the given URLPattern against the given URL. */
function matchUrlPattern(pattern, url) {
    // Roughly https://w3c.github.io/webdriver-bidi/#match-url-pattern
    // plus some differences based on the URL parsing methods.
    const parsedUrl = new URL(url);
    if (pattern.protocol !== undefined &&
        pattern.protocol !== getScheme(parsedUrl)) {
        return false;
    }
    if (pattern.hostname !== undefined &&
        pattern.hostname !== parsedUrl.hostname) {
        return false;
    }
    if (pattern.port !== undefined && pattern.port !== parsedUrl.port) {
        return false;
    }
    if (pattern.pathname !== undefined &&
        pattern.pathname !== parsedUrl.pathname) {
        return false;
    }
    if (pattern.search !== undefined && pattern.search !== parsedUrl.search) {
        return false;
    }
    return true;
}
function bidiBodySizeFromCdpPostDataEntries(entries) {
    let size = 0;
    for (const entry of entries) {
        size += atob(entry.bytes ?? '').length;
    }
    return size;
}
function getTiming(timing, offset = 0) {
    if (!timing) {
        return 0;
    }
    if (timing <= 0 || timing + offset <= 0) {
        return 0;
    }
    return timing + offset;
}
//# sourceMappingURL=NetworkUtils.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/permissions/PermissionsProcessor.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PermissionsProcessor = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
class PermissionsProcessor {
    #browserCdpClient;
    constructor(browserCdpClient) {
        this.#browserCdpClient = browserCdpClient;
    }
    async setPermissions(params) {
        try {
            const userContextId = params['goog:userContext'] ||
                params.userContext;
            await this.#browserCdpClient.sendCommand('Browser.setPermission', {
                origin: params.origin,
                browserContextId: userContextId && userContextId !== 'default'
                    ? userContextId
                    : undefined,
                permission: {
                    name: params.descriptor.name,
                },
                setting: params.state,
            });
        }
        catch (err) {
            if (err.message ===
                `Permission can't be granted to opaque origins.`) {
                // Return success if the origin is not valid (does not match any
                // existing origins).
                return {};
            }
            throw new protocol_js_1.InvalidArgumentException(err.message);
        }
        return {};
    }
}
exports.PermissionsProcessor = PermissionsProcessor;
//# sourceMappingURL=PermissionsProcessor.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/ChannelProxy.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChannelProxy = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
const uuid_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/uuid.js");
/**
 * Used to send messages from realm to BiDi user.
 */
class ChannelProxy {
    #properties;
    #id = (0, uuid_js_1.uuidv4)();
    #logger;
    constructor(channel, logger) {
        this.#properties = channel;
        this.#logger = logger;
    }
    /**
     * Creates a channel proxy in the given realm, initialises listener and
     * returns a handle to `sendMessage` delegate.
     */
    async init(realm, eventManager) {
        const channelHandle = await ChannelProxy.#createAndGetHandleInRealm(realm);
        const sendMessageHandle = await ChannelProxy.#createSendMessageHandle(realm, channelHandle);
        void this.#startListener(realm, channelHandle, eventManager);
        return sendMessageHandle;
    }
    /** Gets a ChannelProxy from window and returns its handle. */
    async startListenerFromWindow(realm, eventManager) {
        try {
            const channelHandle = await this.#getHandleFromWindow(realm);
            void this.#startListener(realm, channelHandle, eventManager);
        }
        catch (error) {
            this.#logger?.(log_js_1.LogType.debugError, error);
        }
    }
    /**
     * Evaluation string which creates a ChannelProxy object on the client side.
     */
    static #createChannelProxyEvalStr() {
        const functionStr = String(() => {
            const queue = [];
            let queueNonEmptyResolver = null;
            return {
                /**
                 * Gets a promise, which is resolved as soon as a message occurs
                 * in the queue.
                 */
                async getMessage() {
                    const onMessage = queue.length > 0
                        ? Promise.resolve()
                        : new Promise((resolve) => {
                            queueNonEmptyResolver = resolve;
                        });
                    await onMessage;
                    return queue.shift();
                },
                /**
                 * Adds a message to the queue.
                 * Resolves the pending promise if needed.
                 */
                sendMessage(message) {
                    queue.push(message);
                    if (queueNonEmptyResolver !== null) {
                        queueNonEmptyResolver();
                        queueNonEmptyResolver = null;
                    }
                },
            };
        });
        return `(${functionStr})()`;
    }
    /** Creates a ChannelProxy in the given realm. */
    static async #createAndGetHandleInRealm(realm) {
        const createChannelHandleResult = await realm.cdpClient.sendCommand('Runtime.evaluate', {
            expression: this.#createChannelProxyEvalStr(),
            contextId: realm.executionContextId,
            serializationOptions: {
                serialization: "idOnly" /* Protocol.Runtime.SerializationOptionsSerialization.IdOnly */,
            },
        });
        if (createChannelHandleResult.exceptionDetails ||
            createChannelHandleResult.result.objectId === undefined) {
            throw new Error(`Cannot create channel`);
        }
        return createChannelHandleResult.result.objectId;
    }
    /** Gets a handle to `sendMessage` delegate from the ChannelProxy handle. */
    static async #createSendMessageHandle(realm, channelHandle) {
        const sendMessageArgResult = await realm.cdpClient.sendCommand('Runtime.callFunctionOn', {
            functionDeclaration: String((channelHandle) => {
                return channelHandle.sendMessage;
            }),
            arguments: [{ objectId: channelHandle }],
            executionContextId: realm.executionContextId,
            serializationOptions: {
                serialization: "idOnly" /* Protocol.Runtime.SerializationOptionsSerialization.IdOnly */,
            },
        });
        // TODO: check for exceptionDetails.
        return sendMessageArgResult.result.objectId;
    }
    /** Starts listening for the channel events of the provided ChannelProxy. */
    async #startListener(realm, channelHandle, eventManager) {
        // noinspection InfiniteLoopJS
        for (;;) {
            try {
                const message = await realm.cdpClient.sendCommand('Runtime.callFunctionOn', {
                    functionDeclaration: String(async (channelHandle) => await channelHandle.getMessage()),
                    arguments: [
                        {
                            objectId: channelHandle,
                        },
                    ],
                    awaitPromise: true,
                    executionContextId: realm.executionContextId,
                    serializationOptions: {
                        serialization: "deep" /* Protocol.Runtime.SerializationOptionsSerialization.Deep */,
                        maxDepth: this.#properties.serializationOptions?.maxObjectDepth ??
                            undefined,
                    },
                });
                if (message.exceptionDetails) {
                    throw new Error('Runtime.callFunctionOn in ChannelProxy', {
                        cause: message.exceptionDetails,
                    });
                }
                for (const browsingContext of realm.associatedBrowsingContexts) {
                    eventManager.registerEvent({
                        type: 'event',
                        method: protocol_js_1.ChromiumBidi.Script.EventNames.Message,
                        params: {
                            channel: this.#properties.channel,
                            data: realm.cdpToBidiValue(message, this.#properties.ownership ?? "none" /* Script.ResultOwnership.None */),
                            source: realm.source,
                        },
                    }, browsingContext.id);
                }
            }
            catch (error) {
                // If an error is thrown, then the channel is permanently broken, so we
                // exit the loop.
                this.#logger?.(log_js_1.LogType.debugError, error);
                break;
            }
        }
    }
    /**
     * Returns a handle of ChannelProxy from window's property which was set there
     * by `getEvalInWindowStr`. If window property is not set yet, sets a promise
     * resolver to the window property, so that `getEvalInWindowStr` can resolve
     * the promise later on with the channel.
     * This is needed because `getEvalInWindowStr` can be called before or
     * after this method.
     */
    async #getHandleFromWindow(realm) {
        const channelHandleResult = await realm.cdpClient.sendCommand('Runtime.callFunctionOn', {
            functionDeclaration: String((id) => {
                const w = window;
                if (w[id] === undefined) {
                    // The channelProxy is not created yet. Create a promise, put the
                    // resolver to window property and return the promise.
                    // `getEvalInWindowStr` will resolve the promise later.
                    return new Promise((resolve) => (w[id] = resolve));
                }
                // The channelProxy is already created by `getEvalInWindowStr` and
                // is set into window property. Return it.
                const channelProxy = w[id];
                delete w[id];
                return channelProxy;
            }),
            arguments: [{ value: this.#id }],
            executionContextId: realm.executionContextId,
            awaitPromise: true,
            serializationOptions: {
                serialization: "idOnly" /* Protocol.Runtime.SerializationOptionsSerialization.IdOnly */,
            },
        });
        if (channelHandleResult.exceptionDetails !== undefined ||
            channelHandleResult.result.objectId === undefined) {
            throw new Error(`ChannelHandle not found in window["${this.#id}"]`);
        }
        return channelHandleResult.result.objectId;
    }
    /**
     * String to be evaluated to create a ProxyChannel and put it to window.
     * Returns the delegate `sendMessage`. Used to provide an argument for preload
     * script. Does the following:
     * 1. Creates a ChannelProxy.
     * 2. Puts the ChannelProxy to window['${this.#id}'] or resolves the promise
     *    by calling delegate stored in window['${this.#id}'].
     *    This is needed because `#getHandleFromWindow` can be called before or
     *    after this method.
     * 3. Returns the delegate `sendMessage` of the created ChannelProxy.
     */
    getEvalInWindowStr() {
        const delegate = String((id, channelProxy) => {
            const w = window;
            if (w[id] === undefined) {
                // `#getHandleFromWindow` is not initialized yet, and will get the
                // channelProxy later.
                w[id] = channelProxy;
            }
            else {
                // `#getHandleFromWindow` is already set a delegate to window property
                // and is waiting for it to be called with the channelProxy.
                w[id](channelProxy);
                delete w[id];
            }
            return channelProxy.sendMessage;
        });
        const channelProxyEval = ChannelProxy.#createChannelProxyEvalStr();
        return `(${delegate})('${this.#id}',${channelProxyEval})`;
    }
}
exports.ChannelProxy = ChannelProxy;
//# sourceMappingURL=ChannelProxy.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/PreloadScript.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreloadScript = void 0;
const uuid_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/uuid.js");
const ChannelProxy_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/ChannelProxy.js");
/**
 * BiDi IDs are generated by the server and are unique within contexts.
 *
 * CDP preload script IDs are generated by the client and are unique
 * within sessions.
 *
 * The mapping between BiDi and CDP preload script IDs is 1:many.
 * BiDi IDs are needed by the mapper to keep track of potential multiple CDP IDs
 * in the client.
 */
class PreloadScript {
    /** BiDi ID, an automatically generated UUID. */
    #id = (0, uuid_js_1.uuidv4)();
    /** CDP preload scripts. */
    #cdpPreloadScripts = [];
    /** The script itself, in a format expected by the spec i.e. a function. */
    #functionDeclaration;
    /** Targets, in which the preload script is initialized. */
    #targetIds = new Set();
    /** Channels to be added as arguments to functionDeclaration. */
    #channels;
    /** The script sandbox / world name. */
    #sandbox;
    /** The browsing contexts to execute the preload scripts in, if any. */
    #contexts;
    get id() {
        return this.#id;
    }
    get targetIds() {
        return this.#targetIds;
    }
    constructor(params, logger) {
        this.#channels =
            params.arguments?.map((a) => new ChannelProxy_js_1.ChannelProxy(a.value, logger)) ?? [];
        this.#functionDeclaration = params.functionDeclaration;
        this.#sandbox = params.sandbox;
        this.#contexts = params.contexts;
    }
    /** Channels of the preload script. */
    get channels() {
        return this.#channels;
    }
    /** Contexts of the preload script, if any */
    get contexts() {
        return this.#contexts;
    }
    /**
     * String to be evaluated. Wraps user-provided function so that the following
     * steps are run:
     * 1. Create channels.
     * 2. Store the created channels in window.
     * 3. Call the user-provided function with channels as arguments.
     */
    #getEvaluateString() {
        const channelsArgStr = `[${this.channels
            .map((c) => c.getEvalInWindowStr())
            .join(', ')}]`;
        return `(()=>{(${this.#functionDeclaration})(...${channelsArgStr})})()`;
    }
    /**
     * Adds the script to the given CDP targets by calling the
     * `Page.addScriptToEvaluateOnNewDocument` command.
     */
    async initInTargets(cdpTargets, runImmediately) {
        await Promise.all(Array.from(cdpTargets).map((cdpTarget) => this.initInTarget(cdpTarget, runImmediately)));
    }
    /**
     * Adds the script to the given CDP target by calling the
     * `Page.addScriptToEvaluateOnNewDocument` command.
     */
    async initInTarget(cdpTarget, runImmediately) {
        const addCdpPreloadScriptResult = await cdpTarget.cdpClient.sendCommand('Page.addScriptToEvaluateOnNewDocument', {
            source: this.#getEvaluateString(),
            worldName: this.#sandbox,
            runImmediately,
        });
        this.#cdpPreloadScripts.push({
            target: cdpTarget,
            preloadScriptId: addCdpPreloadScriptResult.identifier,
        });
        this.#targetIds.add(cdpTarget.id);
    }
    /**
     * Removes this script from all CDP targets.
     */
    async remove() {
        await Promise.all([
            this.#cdpPreloadScripts.map(async (cdpPreloadScript) => {
                const cdpTarget = cdpPreloadScript.target;
                const cdpPreloadScriptId = cdpPreloadScript.preloadScriptId;
                return await cdpTarget.cdpClient.sendCommand('Page.removeScriptToEvaluateOnNewDocument', {
                    identifier: cdpPreloadScriptId,
                });
            }),
        ]);
    }
    /** Removes the provided cdp target from the list of cdp preload scripts. */
    dispose(cdpTargetId) {
        this.#cdpPreloadScripts = this.#cdpPreloadScripts.filter((cdpPreloadScript) => cdpPreloadScript.target?.id !== cdpTargetId);
        this.#targetIds.delete(cdpTargetId);
    }
}
exports.PreloadScript = PreloadScript;
//# sourceMappingURL=PreloadScript.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/PreloadScriptStorage.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreloadScriptStorage = void 0;
/**
 * Container class for preload scripts.
 */
class PreloadScriptStorage {
    /** Tracks all BiDi preload scripts.  */
    #scripts = new Set();
    /**
     * Finds all entries that match the given filter (OR logic).
     */
    find(filter) {
        if (!filter) {
            return [...this.#scripts];
        }
        return [...this.#scripts].filter((script) => {
            if (filter.id !== undefined && filter.id === script.id) {
                return true;
            }
            if (filter.targetId !== undefined &&
                script.targetIds.has(filter.targetId)) {
                return true;
            }
            if (filter.global !== undefined &&
                // Global scripts have no contexts
                ((filter.global && script.contexts === undefined) ||
                    // Non global scripts always have contexts
                    (!filter.global && script.contexts !== undefined))) {
                return true;
            }
            return false;
        });
    }
    add(preloadScript) {
        this.#scripts.add(preloadScript);
    }
    /** Deletes all BiDi preload script entries that match the given filter. */
    remove(filter) {
        for (const preloadScript of this.find(filter)) {
            this.#scripts.delete(preloadScript);
        }
    }
}
exports.PreloadScriptStorage = PreloadScriptStorage;
//# sourceMappingURL=PreloadScriptStorage.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/Realm.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Realm = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
const uuid_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/uuid.js");
const ChannelProxy_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/ChannelProxy.js");
class Realm {
    #cdpClient;
    #eventManager;
    #executionContextId;
    #logger;
    #origin;
    #realmId;
    #realmStorage;
    constructor(cdpClient, eventManager, executionContextId, logger, origin, realmId, realmStorage) {
        this.#cdpClient = cdpClient;
        this.#eventManager = eventManager;
        this.#executionContextId = executionContextId;
        this.#logger = logger;
        this.#origin = origin;
        this.#realmId = realmId;
        this.#realmStorage = realmStorage;
        this.#realmStorage.addRealm(this);
    }
    cdpToBidiValue(cdpValue, resultOwnership) {
        const bidiValue = this.serializeForBiDi(cdpValue.result.deepSerializedValue, new Map());
        if (cdpValue.result.objectId) {
            const objectId = cdpValue.result.objectId;
            if (resultOwnership === "root" /* Script.ResultOwnership.Root */) {
                // Extend BiDi value with `handle` based on required `resultOwnership`
                // and  CDP response but not on the actual BiDi type.
                bidiValue.handle = objectId;
                // Remember all the handles sent to client.
                this.#realmStorage.knownHandlesToRealmMap.set(objectId, this.realmId);
            }
            else {
                // No need to await for the object to be released.
                void this.#releaseObject(objectId).catch((error) => this.#logger?.(log_js_1.LogType.debugError, error));
            }
        }
        return bidiValue;
    }
    /**
     * Relies on the CDP to implement proper BiDi serialization, except:
     * * CDP integer property `backendNodeId` is replaced with `sharedId` of
     * `{documentId}_element_{backendNodeId}`;
     * * CDP integer property `weakLocalObjectReference` is replaced with UUID `internalId`
     * using unique-per serialization `internalIdMap`.
     * * CDP type `platformobject` is replaced with `object`.
     * @param deepSerializedValue - CDP value to be converted to BiDi.
     * @param internalIdMap - Map from CDP integer `weakLocalObjectReference` to BiDi UUID
     * `internalId`.
     */
    serializeForBiDi(deepSerializedValue, internalIdMap) {
        if (Object.hasOwn(deepSerializedValue, 'weakLocalObjectReference')) {
            const weakLocalObjectReference = deepSerializedValue.weakLocalObjectReference;
            if (!internalIdMap.has(weakLocalObjectReference)) {
                internalIdMap.set(weakLocalObjectReference, (0, uuid_js_1.uuidv4)());
            }
            deepSerializedValue.internalId = internalIdMap.get(weakLocalObjectReference);
            delete deepSerializedValue['weakLocalObjectReference'];
        }
        if (deepSerializedValue.type === 'node' &&
            deepSerializedValue.value &&
            Object.hasOwn(deepSerializedValue.value, 'frameId')) {
            // `frameId` is not needed in BiDi as it is not yet specified.
            delete deepSerializedValue.value['frameId'];
        }
        // Platform object is a special case. It should have only `{type: object}`
        // without `value` field.
        if (deepSerializedValue.type === 'platformobject') {
            return { type: 'object' };
        }
        const bidiValue = deepSerializedValue.value;
        if (bidiValue === undefined) {
            return deepSerializedValue;
        }
        // Recursively update the nested values.
        if (['array', 'set', 'htmlcollection', 'nodelist'].includes(deepSerializedValue.type)) {
            for (const i in bidiValue) {
                bidiValue[i] = this.serializeForBiDi(bidiValue[i], internalIdMap);
            }
        }
        if (['object', 'map'].includes(deepSerializedValue.type)) {
            for (const i in bidiValue) {
                bidiValue[i] = [
                    this.serializeForBiDi(bidiValue[i][0], internalIdMap),
                    this.serializeForBiDi(bidiValue[i][1], internalIdMap),
                ];
            }
        }
        return deepSerializedValue;
    }
    get realmId() {
        return this.#realmId;
    }
    get executionContextId() {
        return this.#executionContextId;
    }
    get origin() {
        return this.#origin;
    }
    get source() {
        return {
            realm: this.realmId,
        };
    }
    get cdpClient() {
        return this.#cdpClient;
    }
    get baseInfo() {
        return {
            realm: this.realmId,
            origin: this.origin,
        };
    }
    async evaluate(expression, awaitPromise, resultOwnership = "none" /* Script.ResultOwnership.None */, serializationOptions = {}, userActivation = false, includeCommandLineApi = false) {
        const cdpEvaluateResult = await this.cdpClient.sendCommand('Runtime.evaluate', {
            contextId: this.executionContextId,
            expression,
            awaitPromise,
            serializationOptions: Realm.#getSerializationOptions("deep" /* Protocol.Runtime.SerializationOptionsSerialization.Deep */, serializationOptions),
            userGesture: userActivation,
            includeCommandLineAPI: includeCommandLineApi,
        });
        if (cdpEvaluateResult.exceptionDetails) {
            return await this.#getExceptionResult(cdpEvaluateResult.exceptionDetails, 0, resultOwnership);
        }
        return {
            realm: this.realmId,
            result: this.cdpToBidiValue(cdpEvaluateResult, resultOwnership),
            type: 'success',
        };
    }
    #registerEvent(event) {
        if (this.associatedBrowsingContexts.length === 0) {
            this.#eventManager.registerGlobalEvent(event);
        }
        else {
            for (const browsingContext of this.associatedBrowsingContexts) {
                this.#eventManager.registerEvent(event, browsingContext.id);
            }
        }
    }
    initialize() {
        this.#registerEvent({
            type: 'event',
            method: protocol_js_1.ChromiumBidi.Script.EventNames.RealmCreated,
            params: this.realmInfo,
        });
    }
    /**
     * Serializes a given CDP object into BiDi, keeping references in the
     * target's `globalThis`.
     */
    async serializeCdpObject(cdpRemoteObject, resultOwnership) {
        // TODO: if the object is a primitive, return it directly without CDP roundtrip.
        const argument = Realm.#cdpRemoteObjectToCallArgument(cdpRemoteObject);
        const cdpValue = await this.cdpClient.sendCommand('Runtime.callFunctionOn', {
            functionDeclaration: String((remoteObject) => remoteObject),
            awaitPromise: false,
            arguments: [argument],
            serializationOptions: {
                serialization: "deep" /* Protocol.Runtime.SerializationOptionsSerialization.Deep */,
            },
            executionContextId: this.executionContextId,
        });
        return this.cdpToBidiValue(cdpValue, resultOwnership);
    }
    static #cdpRemoteObjectToCallArgument(cdpRemoteObject) {
        if (cdpRemoteObject.objectId !== undefined) {
            return { objectId: cdpRemoteObject.objectId };
        }
        if (cdpRemoteObject.unserializableValue !== undefined) {
            return { unserializableValue: cdpRemoteObject.unserializableValue };
        }
        return { value: cdpRemoteObject.value };
    }
    /**
     * Gets the string representation of an object. This is equivalent to
     * calling `toString()` on the object value.
     */
    async stringifyObject(cdpRemoteObject) {
        const { result } = await this.cdpClient.sendCommand('Runtime.callFunctionOn', {
            functionDeclaration: String(
            // eslint-disable-next-line @typescript-eslint/no-base-to-string
            (remoteObject) => String(remoteObject)),
            awaitPromise: false,
            arguments: [cdpRemoteObject],
            returnByValue: true,
            executionContextId: this.executionContextId,
        });
        return result.value;
    }
    async #flattenKeyValuePairs(mappingLocalValue) {
        const keyValueArray = await Promise.all(mappingLocalValue.map(async ([key, value]) => {
            let keyArg;
            if (typeof key === 'string') {
                // Key is a string.
                keyArg = { value: key };
            }
            else {
                // Key is a serialized value.
                keyArg = await this.deserializeForCdp(key);
            }
            const valueArg = await this.deserializeForCdp(value);
            return [keyArg, valueArg];
        }));
        return keyValueArray.flat();
    }
    async #flattenValueList(listLocalValue) {
        return await Promise.all(listLocalValue.map((localValue) => this.deserializeForCdp(localValue)));
    }
    async #serializeCdpExceptionDetails(cdpExceptionDetails, lineOffset, resultOwnership) {
        const callFrames = cdpExceptionDetails.stackTrace?.callFrames.map((frame) => ({
            url: frame.url,
            functionName: frame.functionName,
            lineNumber: frame.lineNumber - lineOffset,
            columnNumber: frame.columnNumber,
        })) ?? [];
        // Exception should always be there.
        const exception = cdpExceptionDetails.exception;
        return {
            exception: await this.serializeCdpObject(exception, resultOwnership),
            columnNumber: cdpExceptionDetails.columnNumber,
            lineNumber: cdpExceptionDetails.lineNumber - lineOffset,
            stackTrace: {
                callFrames,
            },
            text: (await this.stringifyObject(exception)) || cdpExceptionDetails.text,
        };
    }
    async callFunction(functionDeclaration, awaitPromise, thisLocalValue = {
        type: 'undefined',
    }, argumentsLocalValues = [], resultOwnership = "none" /* Script.ResultOwnership.None */, serializationOptions = {}, userActivation = false) {
        const callFunctionAndSerializeScript = `(...args) => {
      function callFunction(f, args) {
        const deserializedThis = args.shift();
        const deserializedArgs = args;
        return f.apply(deserializedThis, deserializedArgs);
      }
      return callFunction((
        ${functionDeclaration}
      ), args);
    }`;
        const thisAndArgumentsList = [
            await this.deserializeForCdp(thisLocalValue),
            ...(await Promise.all(argumentsLocalValues.map(async (argumentLocalValue) => await this.deserializeForCdp(argumentLocalValue)))),
        ];
        let cdpCallFunctionResult;
        try {
            cdpCallFunctionResult = await this.cdpClient.sendCommand('Runtime.callFunctionOn', {
                functionDeclaration: callFunctionAndSerializeScript,
                awaitPromise,
                arguments: thisAndArgumentsList,
                serializationOptions: Realm.#getSerializationOptions("deep" /* Protocol.Runtime.SerializationOptionsSerialization.Deep */, serializationOptions),
                executionContextId: this.executionContextId,
                userGesture: userActivation,
            });
        }
        catch (error) {
            // Heuristic to determine if the problem is in the argument.
            // The check can be done on the `deserialization` step, but this approach
            // helps to save round-trips.
            if (error.code === -32000 /* CdpErrorConstants.GENERIC_ERROR */ &&
                [
                    'Could not find object with given id',
                    'Argument should belong to the same JavaScript world as target object',
                    'Invalid remote object id',
                ].includes(error.message)) {
                throw new protocol_js_1.NoSuchHandleException('Handle was not found.');
            }
            throw error;
        }
        if (cdpCallFunctionResult.exceptionDetails) {
            return await this.#getExceptionResult(cdpCallFunctionResult.exceptionDetails, 1, resultOwnership);
        }
        return {
            type: 'success',
            result: this.cdpToBidiValue(cdpCallFunctionResult, resultOwnership),
            realm: this.realmId,
        };
    }
    async deserializeForCdp(localValue) {
        if ('handle' in localValue && localValue.handle) {
            return { objectId: localValue.handle };
            // We tried to find a handle value but failed
            // This allows us to have exhaustive switch on `localValue.type`
        }
        else if ('handle' in localValue || 'sharedId' in localValue) {
            throw new protocol_js_1.NoSuchHandleException('Handle was not found.');
        }
        switch (localValue.type) {
            case 'undefined':
                return { unserializableValue: 'undefined' };
            case 'null':
                return { unserializableValue: 'null' };
            case 'string':
                return { value: localValue.value };
            case 'number':
                if (localValue.value === 'NaN') {
                    return { unserializableValue: 'NaN' };
                }
                else if (localValue.value === '-0') {
                    return { unserializableValue: '-0' };
                }
                else if (localValue.value === 'Infinity') {
                    return { unserializableValue: 'Infinity' };
                }
                else if (localValue.value === '-Infinity') {
                    return { unserializableValue: '-Infinity' };
                }
                return {
                    value: localValue.value,
                };
            case 'boolean':
                return { value: Boolean(localValue.value) };
            case 'bigint':
                return {
                    unserializableValue: `BigInt(${JSON.stringify(localValue.value)})`,
                };
            case 'date':
                return {
                    unserializableValue: `new Date(Date.parse(${JSON.stringify(localValue.value)}))`,
                };
            case 'regexp':
                return {
                    unserializableValue: `new RegExp(${JSON.stringify(localValue.value.pattern)}, ${JSON.stringify(localValue.value.flags)})`,
                };
            case 'map': {
                // TODO: If none of the nested keys and values has a remote
                // reference, serialize to `unserializableValue` without CDP roundtrip.
                const keyValueArray = await this.#flattenKeyValuePairs(localValue.value);
                const { result } = await this.cdpClient.sendCommand('Runtime.callFunctionOn', {
                    functionDeclaration: String((...args) => {
                        const result = new Map();
                        for (let i = 0; i < args.length; i += 2) {
                            result.set(args[i], args[i + 1]);
                        }
                        return result;
                    }),
                    awaitPromise: false,
                    arguments: keyValueArray,
                    returnByValue: false,
                    executionContextId: this.executionContextId,
                });
                // TODO(#375): Release `result.objectId` after using.
                return { objectId: result.objectId };
            }
            case 'object': {
                // TODO: If none of the nested keys and values has a remote
                // reference, serialize to `unserializableValue` without CDP roundtrip.
                const keyValueArray = await this.#flattenKeyValuePairs(localValue.value);
                const { result } = await this.cdpClient.sendCommand('Runtime.callFunctionOn', {
                    functionDeclaration: String((...args) => {
                        const result = {};
                        for (let i = 0; i < args.length; i += 2) {
                            // Key should be either `string`, `number`, or `symbol`.
                            const key = args[i];
                            result[key] = args[i + 1];
                        }
                        return result;
                    }),
                    awaitPromise: false,
                    arguments: keyValueArray,
                    returnByValue: false,
                    executionContextId: this.executionContextId,
                });
                // TODO(#375): Release `result.objectId` after using.
                return { objectId: result.objectId };
            }
            case 'array': {
                // TODO: If none of the nested items has a remote reference,
                // serialize to `unserializableValue` without CDP roundtrip.
                const args = await this.#flattenValueList(localValue.value);
                const { result } = await this.cdpClient.sendCommand('Runtime.callFunctionOn', {
                    functionDeclaration: String((...args) => args),
                    awaitPromise: false,
                    arguments: args,
                    returnByValue: false,
                    executionContextId: this.executionContextId,
                });
                // TODO(#375): Release `result.objectId` after using.
                return { objectId: result.objectId };
            }
            case 'set': {
                // TODO: if none of the nested items has a remote reference,
                // serialize to `unserializableValue` without CDP roundtrip.
                const args = await this.#flattenValueList(localValue.value);
                const { result } = await this.cdpClient.sendCommand('Runtime.callFunctionOn', {
                    functionDeclaration: String((...args) => new Set(args)),
                    awaitPromise: false,
                    arguments: args,
                    returnByValue: false,
                    executionContextId: this.executionContextId,
                });
                // TODO(#375): Release `result.objectId` after using.
                return { objectId: result.objectId };
            }
            case 'channel': {
                const channelProxy = new ChannelProxy_js_1.ChannelProxy(localValue.value, this.#logger);
                const channelProxySendMessageHandle = await channelProxy.init(this, this.#eventManager);
                return { objectId: channelProxySendMessageHandle };
            }
            // TODO(#375): Dispose of nested objects.
        }
        // Intentionally outside to handle unknown types
        throw new Error(`Value ${JSON.stringify(localValue)} is not deserializable.`);
    }
    async #getExceptionResult(exceptionDetails, lineOffset, resultOwnership) {
        return {
            exceptionDetails: await this.#serializeCdpExceptionDetails(exceptionDetails, lineOffset, resultOwnership),
            realm: this.realmId,
            type: 'exception',
        };
    }
    static #getSerializationOptions(serialization, serializationOptions) {
        return {
            serialization,
            additionalParameters: Realm.#getAdditionalSerializationParameters(serializationOptions),
            ...Realm.#getMaxObjectDepth(serializationOptions),
        };
    }
    static #getAdditionalSerializationParameters(serializationOptions) {
        const additionalParameters = {};
        if (serializationOptions.maxDomDepth !== undefined) {
            additionalParameters['maxNodeDepth'] =
                serializationOptions.maxDomDepth === null
                    ? 1000
                    : serializationOptions.maxDomDepth;
        }
        if (serializationOptions.includeShadowTree !== undefined) {
            additionalParameters['includeShadowTree'] =
                serializationOptions.includeShadowTree;
        }
        return additionalParameters;
    }
    static #getMaxObjectDepth(serializationOptions) {
        return serializationOptions.maxObjectDepth === undefined ||
            serializationOptions.maxObjectDepth === null
            ? {}
            : { maxDepth: serializationOptions.maxObjectDepth };
    }
    async #releaseObject(handle) {
        try {
            await this.cdpClient.sendCommand('Runtime.releaseObject', {
                objectId: handle,
            });
        }
        catch (error) {
            // Heuristic to determine if the problem is in the unknown handler.
            // Ignore the error if so.
            if (!(error.code === -32000 /* CdpErrorConstants.GENERIC_ERROR */ &&
                error.message === 'Invalid remote object id')) {
                throw error;
            }
        }
    }
    async disown(handle) {
        // Disowning an object from different realm does nothing.
        if (this.#realmStorage.knownHandlesToRealmMap.get(handle) !== this.realmId) {
            return;
        }
        await this.#releaseObject(handle);
        this.#realmStorage.knownHandlesToRealmMap.delete(handle);
    }
    dispose() {
        this.#registerEvent({
            type: 'event',
            method: protocol_js_1.ChromiumBidi.Script.EventNames.RealmDestroyed,
            params: {
                realm: this.realmId,
            },
        });
    }
}
exports.Realm = Realm;
//# sourceMappingURL=Realm.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/RealmStorage.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RealmStorage = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const WindowRealm_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/WindowRealm.js");
/** Container class for browsing realms. */
class RealmStorage {
    /** Tracks handles and their realms sent to the client. */
    #knownHandlesToRealmMap = new Map();
    /** Map from realm ID to Realm. */
    #realmMap = new Map();
    get knownHandlesToRealmMap() {
        return this.#knownHandlesToRealmMap;
    }
    addRealm(realm) {
        this.#realmMap.set(realm.realmId, realm);
    }
    /** Finds all realms that match the given filter. */
    findRealms(filter) {
        return Array.from(this.#realmMap.values()).filter((realm) => {
            if (filter.realmId !== undefined && filter.realmId !== realm.realmId) {
                return false;
            }
            if (filter.browsingContextId !== undefined &&
                !realm.associatedBrowsingContexts
                    .map((browsingContext) => browsingContext.id)
                    .includes(filter.browsingContextId)) {
                return false;
            }
            if (filter.sandbox !== undefined &&
                (!(realm instanceof WindowRealm_js_1.WindowRealm) || filter.sandbox !== realm.sandbox)) {
                return false;
            }
            if (filter.executionContextId !== undefined &&
                filter.executionContextId !== realm.executionContextId) {
                return false;
            }
            if (filter.origin !== undefined && filter.origin !== realm.origin) {
                return false;
            }
            if (filter.type !== undefined && filter.type !== realm.realmType) {
                return false;
            }
            if (filter.cdpSessionId !== undefined &&
                filter.cdpSessionId !== realm.cdpClient.sessionId) {
                return false;
            }
            return true;
        });
    }
    findRealm(filter) {
        const maybeRealms = this.findRealms(filter);
        if (maybeRealms.length !== 1) {
            return undefined;
        }
        return maybeRealms[0];
    }
    /** Gets the only realm that matches the given filter, if any, otherwise throws. */
    getRealm(filter) {
        const maybeRealm = this.findRealm(filter);
        if (maybeRealm === undefined) {
            throw new protocol_js_1.NoSuchFrameException(`Realm ${JSON.stringify(filter)} not found`);
        }
        return maybeRealm;
    }
    /** Deletes all realms that match the given filter. */
    deleteRealms(filter) {
        this.findRealms(filter).map((realm) => {
            realm.dispose();
            this.#realmMap.delete(realm.realmId);
            Array.from(this.knownHandlesToRealmMap.entries())
                .filter(([, r]) => r === realm.realmId)
                .map(([handle]) => this.knownHandlesToRealmMap.delete(handle));
        });
    }
}
exports.RealmStorage = RealmStorage;
//# sourceMappingURL=RealmStorage.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/ScriptProcessor.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ScriptProcessor = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const PreloadScript_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/PreloadScript.js");
class ScriptProcessor {
    #eventManager;
    #browsingContextStorage;
    #realmStorage;
    #preloadScriptStorage;
    #logger;
    constructor(eventManager, browsingContextStorage, realmStorage, preloadScriptStorage, logger) {
        this.#browsingContextStorage = browsingContextStorage;
        this.#realmStorage = realmStorage;
        this.#preloadScriptStorage = preloadScriptStorage;
        this.#logger = logger;
        this.#eventManager = eventManager;
        this.#eventManager.addSubscribeHook(protocol_js_1.ChromiumBidi.Script.EventNames.RealmCreated, this.#onRealmCreatedSubscribeHook.bind(this));
    }
    #onRealmCreatedSubscribeHook(contextId) {
        const context = this.#browsingContextStorage.getContext(contextId);
        const contextsToReport = [
            context,
            ...this.#browsingContextStorage.getContext(contextId).allChildren,
        ];
        const realms = new Set();
        for (const reportContext of contextsToReport) {
            const realmsForContext = this.#realmStorage.findRealms({
                browsingContextId: reportContext.id,
            });
            for (const realm of realmsForContext) {
                realms.add(realm);
            }
        }
        for (const realm of realms) {
            this.#eventManager.registerEvent({
                type: 'event',
                method: protocol_js_1.ChromiumBidi.Script.EventNames.RealmCreated,
                params: realm.realmInfo,
            }, context.id);
        }
        return Promise.resolve();
    }
    async addPreloadScript(params) {
        const contexts = this.#browsingContextStorage.verifyTopLevelContextsList(params.contexts);
        const preloadScript = new PreloadScript_js_1.PreloadScript(params, this.#logger);
        this.#preloadScriptStorage.add(preloadScript);
        const cdpTargets = contexts.size === 0
            ? new Set(this.#browsingContextStorage
                .getTopLevelContexts()
                .map((context) => context.cdpTarget))
            : new Set([...contexts.values()].map((context) => context.cdpTarget));
        await preloadScript.initInTargets(cdpTargets, false);
        return {
            script: preloadScript.id,
        };
    }
    async removePreloadScript(params) {
        const { script: id } = params;
        const scripts = this.#preloadScriptStorage.find({ id });
        if (scripts.length === 0) {
            throw new protocol_js_1.NoSuchScriptException(`No preload script with id '${id}'`);
        }
        await Promise.all(scripts.map((script) => script.remove()));
        this.#preloadScriptStorage.remove({ id });
        return {};
    }
    async callFunction(params) {
        const realm = await this.#getRealm(params.target);
        return await realm.callFunction(params.functionDeclaration, params.awaitPromise, params.this, params.arguments, params.resultOwnership, params.serializationOptions, params.userActivation);
    }
    async evaluate(params) {
        const realm = await this.#getRealm(params.target);
        return await realm.evaluate(params.expression, params.awaitPromise, params.resultOwnership, params.serializationOptions, params.userActivation);
    }
    async disown(params) {
        const realm = await this.#getRealm(params.target);
        await Promise.all(params.handles.map(async (handle) => await realm.disown(handle)));
        return {};
    }
    getRealms(params) {
        if (params.context !== undefined) {
            // Make sure the context is known.
            this.#browsingContextStorage.getContext(params.context);
        }
        const realms = this.#realmStorage
            .findRealms({
            browsingContextId: params.context,
            type: params.type,
        })
            .map((realm) => realm.realmInfo);
        return { realms };
    }
    async #getRealm(target) {
        if ('context' in target) {
            const context = this.#browsingContextStorage.getContext(target.context);
            return await context.getOrCreateSandbox(target.sandbox);
        }
        return this.#realmStorage.getRealm({
            realmId: target.realm,
        });
    }
}
exports.ScriptProcessor = ScriptProcessor;
//# sourceMappingURL=ScriptProcessor.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/SharedId.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getSharedId = getSharedId;
exports.parseSharedId = parseSharedId;
const SHARED_ID_DIVIDER = '_element_';
function getSharedId(frameId, documentId, backendNodeId) {
    return `f.${frameId}.d.${documentId}.e.${backendNodeId}`;
}
function parseLegacySharedId(sharedId) {
    const match = sharedId.match(new RegExp(`(.*)${SHARED_ID_DIVIDER}(.*)`));
    if (!match) {
        // SharedId is incorrectly formatted.
        return null;
    }
    const documentId = match[1];
    const elementId = match[2];
    if (documentId === undefined || elementId === undefined) {
        return null;
    }
    const backendNodeId = parseInt(elementId ?? '');
    if (isNaN(backendNodeId)) {
        return null;
    }
    return {
        documentId,
        backendNodeId,
    };
}
function parseSharedId(sharedId) {
    // TODO: remove legacy check once ChromeDriver provides sharedId in the new format.
    const legacyFormattedSharedId = parseLegacySharedId(sharedId);
    if (legacyFormattedSharedId !== null) {
        return { ...legacyFormattedSharedId, frameId: undefined };
    }
    const match = sharedId.match(/f\.(.*)\.d\.(.*)\.e\.([0-9]*)/);
    if (!match) {
        // SharedId is incorrectly formatted.
        return null;
    }
    const frameId = match[1];
    const documentId = match[2];
    const elementId = match[3];
    if (frameId === undefined ||
        documentId === undefined ||
        elementId === undefined) {
        return null;
    }
    const backendNodeId = parseInt(elementId ?? '');
    if (isNaN(backendNodeId)) {
        return null;
    }
    return {
        frameId,
        documentId,
        backendNodeId,
    };
}
//# sourceMappingURL=SharedId.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/WindowRealm.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WindowRealm = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const Realm_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/Realm.js");
const SharedId_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/SharedId.js");
class WindowRealm extends Realm_js_1.Realm {
    #browsingContextId;
    #browsingContextStorage;
    sandbox;
    constructor(browsingContextId, browsingContextStorage, cdpClient, eventManager, executionContextId, logger, origin, realmId, realmStorage, sandbox) {
        super(cdpClient, eventManager, executionContextId, logger, origin, realmId, realmStorage);
        this.#browsingContextId = browsingContextId;
        this.#browsingContextStorage = browsingContextStorage;
        this.sandbox = sandbox;
        this.initialize();
    }
    #getBrowsingContextId(navigableId) {
        const maybeBrowsingContext = this.#browsingContextStorage
            .getAllContexts()
            .find((context) => context.navigableId === navigableId);
        return maybeBrowsingContext?.id ?? 'UNKNOWN';
    }
    get browsingContext() {
        return this.#browsingContextStorage.getContext(this.#browsingContextId);
    }
    get associatedBrowsingContexts() {
        return [this.browsingContext];
    }
    get realmType() {
        return 'window';
    }
    get realmInfo() {
        return {
            ...this.baseInfo,
            type: this.realmType,
            context: this.#browsingContextId,
            sandbox: this.sandbox,
        };
    }
    get source() {
        return {
            realm: this.realmId,
            context: this.browsingContext.id,
        };
    }
    serializeForBiDi(deepSerializedValue, internalIdMap) {
        const bidiValue = deepSerializedValue.value;
        if (deepSerializedValue.type === 'node' && bidiValue !== undefined) {
            if (Object.hasOwn(bidiValue, 'backendNodeId')) {
                let navigableId = this.browsingContext.navigableId ?? 'UNKNOWN';
                if (Object.hasOwn(bidiValue, 'loaderId')) {
                    // `loaderId` should be always there after ~2024-03-05, when
                    // https://crrev.com/c/5116240 reaches stable.
                    // TODO: remove the check after the date.
                    navigableId = bidiValue.loaderId;
                    delete bidiValue['loaderId'];
                }
                deepSerializedValue.sharedId =
                    (0, SharedId_js_1.getSharedId)(this.#getBrowsingContextId(navigableId), navigableId, bidiValue.backendNodeId);
                delete bidiValue['backendNodeId'];
            }
            if (Object.hasOwn(bidiValue, 'children')) {
                for (const i in bidiValue.children) {
                    bidiValue.children[i] = this.serializeForBiDi(bidiValue.children[i], internalIdMap);
                }
            }
            if (Object.hasOwn(bidiValue, 'shadowRoot') &&
                bidiValue.shadowRoot !== null) {
                bidiValue.shadowRoot = this.serializeForBiDi(bidiValue.shadowRoot, internalIdMap);
            }
            // `namespaceURI` can be is either `null` or non-empty string.
            if (bidiValue.namespaceURI === '') {
                bidiValue.namespaceURI = null;
            }
        }
        return super.serializeForBiDi(deepSerializedValue, internalIdMap);
    }
    async deserializeForCdp(localValue) {
        if ('sharedId' in localValue && localValue.sharedId) {
            const parsedSharedId = (0, SharedId_js_1.parseSharedId)(localValue.sharedId);
            if (parsedSharedId === null) {
                throw new protocol_js_1.NoSuchNodeException(`SharedId "${localValue.sharedId}" was not found.`);
            }
            const { documentId, backendNodeId } = parsedSharedId;
            // TODO: add proper validation if the element is accessible from the current realm.
            if (this.browsingContext.navigableId !== documentId) {
                throw new protocol_js_1.NoSuchNodeException(`SharedId "${localValue.sharedId}" belongs to different document. Current document is ${this.browsingContext.navigableId}.`);
            }
            try {
                const { object } = await this.cdpClient.sendCommand('DOM.resolveNode', {
                    backendNodeId,
                    executionContextId: this.executionContextId,
                });
                // TODO(#375): Release `obj.object.objectId` after using.
                return { objectId: object.objectId };
            }
            catch (error) {
                // Heuristic to detect "no such node" exception. Based on the  specific
                // CDP implementation.
                if (error.code === -32000 /* CdpErrorConstants.GENERIC_ERROR */ &&
                    error.message === 'No node with given id found') {
                    throw new protocol_js_1.NoSuchNodeException(`SharedId "${localValue.sharedId}" was not found.`);
                }
                throw new protocol_js_1.UnknownErrorException(error.message, error.stack);
            }
        }
        return await super.deserializeForCdp(localValue);
    }
    async evaluate(expression, awaitPromise, resultOwnership, serializationOptions, userActivation, includeCommandLineApi) {
        await this.#browsingContextStorage
            .getContext(this.#browsingContextId)
            .targetUnblockedOrThrow();
        return await super.evaluate(expression, awaitPromise, resultOwnership, serializationOptions, userActivation, includeCommandLineApi);
    }
    async callFunction(functionDeclaration, awaitPromise, thisLocalValue, argumentsLocalValues, resultOwnership, serializationOptions, userActivation) {
        await this.#browsingContextStorage
            .getContext(this.#browsingContextId)
            .targetUnblockedOrThrow();
        return await super.callFunction(functionDeclaration, awaitPromise, thisLocalValue, argumentsLocalValues, resultOwnership, serializationOptions, userActivation);
    }
}
exports.WindowRealm = WindowRealm;
//# sourceMappingURL=WindowRealm.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/WorkerRealm.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkerRealm = void 0;
const Realm_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/script/Realm.js");
class WorkerRealm extends Realm_js_1.Realm {
    #realmType;
    #ownerRealms;
    constructor(cdpClient, eventManager, executionContextId, logger, origin, ownerRealms, realmId, realmStorage, realmType) {
        super(cdpClient, eventManager, executionContextId, logger, origin, realmId, realmStorage);
        this.#ownerRealms = ownerRealms;
        this.#realmType = realmType;
        this.initialize();
    }
    get associatedBrowsingContexts() {
        return this.#ownerRealms.flatMap((realm) => realm.associatedBrowsingContexts);
    }
    get realmType() {
        return this.#realmType;
    }
    get source() {
        return {
            realm: this.realmId,
            // This is a hack to make Puppeteer able to track workers.
            // TODO: remove after Puppeteer tracks workers by owners and use the base version.
            context: this.associatedBrowsingContexts[0]?.id,
        };
    }
    get realmInfo() {
        const owners = this.#ownerRealms.map((realm) => realm.realmId);
        const { realmType } = this;
        switch (realmType) {
            case 'dedicated-worker': {
                const owner = owners[0];
                if (owner === undefined || owners.length !== 1) {
                    throw new Error('Dedicated worker must have exactly one owner');
                }
                return {
                    ...this.baseInfo,
                    type: realmType,
                    owners: [owner],
                };
            }
            case 'service-worker':
            case 'shared-worker': {
                return {
                    ...this.baseInfo,
                    type: realmType,
                };
            }
        }
    }
}
exports.WorkerRealm = WorkerRealm;
//# sourceMappingURL=WorkerRealm.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/session/EventManager.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2022 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EventManager = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const Buffer_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/Buffer.js");
const DefaultMap_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/DefaultMap.js");
const EventEmitter_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/EventEmitter.js");
const IdWrapper_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/IdWrapper.js");
const OutgoingMessage_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/OutgoingMessage.js");
const events_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/session/events.js");
const SubscriptionManager_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/session/SubscriptionManager.js");
class EventWrapper {
    #idWrapper = new IdWrapper_js_1.IdWrapper();
    #contextId;
    #event;
    constructor(event, contextId) {
        this.#event = event;
        this.#contextId = contextId;
    }
    get id() {
        return this.#idWrapper.id;
    }
    get contextId() {
        return this.#contextId;
    }
    get event() {
        return this.#event;
    }
}
/**
 * Maps event name to a desired buffer length.
 */
const eventBufferLength = new Map([[protocol_js_1.ChromiumBidi.Log.EventNames.LogEntryAdded, 100]]);
class EventManager extends EventEmitter_js_1.EventEmitter {
    /**
     * Maps event name to a set of contexts where this event already happened.
     * Needed for getting buffered events from all the contexts in case of
     * subscripting to all contexts.
     */
    #eventToContextsMap = new DefaultMap_js_1.DefaultMap(() => new Set());
    /**
     * Maps `eventName` + `browsingContext` to buffer. Used to get buffered events
     * during subscription. Channel-agnostic.
     */
    #eventBuffers = new Map();
    /**
     * Maps `eventName` + `browsingContext` to  Map of json stringified channel to last id.
     * Used to avoid sending duplicated events when user
     * subscribes -> unsubscribes -> subscribes.
     */
    #lastMessageSent = new Map();
    #subscriptionManager;
    #browsingContextStorage;
    /**
     * Map of event name to hooks to be called when client is subscribed to the event.
     */
    #subscribeHooks;
    constructor(browsingContextStorage) {
        super();
        this.#browsingContextStorage = browsingContextStorage;
        this.#subscriptionManager = new SubscriptionManager_js_1.SubscriptionManager(browsingContextStorage);
        this.#subscribeHooks = new DefaultMap_js_1.DefaultMap(() => []);
    }
    get subscriptionManager() {
        return this.#subscriptionManager;
    }
    /**
     * Returns consistent key to be used to access value maps.
     */
    static #getMapKey(eventName, browsingContext) {
        return JSON.stringify({ eventName, browsingContext });
    }
    addSubscribeHook(event, hook) {
        this.#subscribeHooks.get(event).push(hook);
    }
    registerEvent(event, contextId) {
        this.registerPromiseEvent(Promise.resolve({
            kind: 'success',
            value: event,
        }), contextId, event.method);
    }
    registerGlobalEvent(event) {
        this.registerGlobalPromiseEvent(Promise.resolve({
            kind: 'success',
            value: event,
        }), event.method);
    }
    registerPromiseEvent(event, contextId, eventName) {
        const eventWrapper = new EventWrapper(event, contextId);
        const sortedChannels = this.#subscriptionManager.getChannelsSubscribedToEvent(eventName, contextId);
        this.#bufferEvent(eventWrapper, eventName);
        // Send events to channels in the subscription priority.
        for (const channel of sortedChannels) {
            this.emit("event" /* EventManagerEvents.Event */, {
                message: OutgoingMessage_js_1.OutgoingMessage.createFromPromise(event, channel),
                event: eventName,
            });
            this.#markEventSent(eventWrapper, channel, eventName);
        }
    }
    registerGlobalPromiseEvent(event, eventName) {
        const eventWrapper = new EventWrapper(event, null);
        const sortedChannels = this.#subscriptionManager.getChannelsSubscribedToEventGlobally(eventName);
        this.#bufferEvent(eventWrapper, eventName);
        // Send events to channels in the subscription priority.
        for (const channel of sortedChannels) {
            this.emit("event" /* EventManagerEvents.Event */, {
                message: OutgoingMessage_js_1.OutgoingMessage.createFromPromise(event, channel),
                event: eventName,
            });
            this.#markEventSent(eventWrapper, channel, eventName);
        }
    }
    async subscribe(eventNames, contextIds, channel) {
        for (const name of eventNames) {
            (0, events_js_1.assertSupportedEvent)(name);
        }
        // First check if all the contexts are known.
        for (const contextId of contextIds) {
            if (contextId !== null) {
                // Assert the context is known. Throw exception otherwise.
                this.#browsingContextStorage.getContext(contextId);
            }
        }
        const unrolledEventNames = new Set((0, SubscriptionManager_js_1.unrollEvents)(eventNames));
        const subscribeStepEvents = new Map();
        const subscriptionNavigableIds = new Set(contextIds.length
            ? contextIds.map((contextId) => {
                const id = this.#browsingContextStorage.findTopLevelContextId(contextId);
                if (!id) {
                    throw new protocol_js_1.InvalidArgumentException('Invalid context id');
                }
                return id;
            })
            : this.#browsingContextStorage.getTopLevelContexts().map((c) => c.id));
        for (const eventName of unrolledEventNames) {
            const subscribedNavigableIds = new Set(this.#browsingContextStorage
                .getTopLevelContexts()
                .map((c) => c.id)
                .filter((id) => {
                return this.#subscriptionManager.isSubscribedTo(eventName, id);
            }));
            subscribeStepEvents.set(eventName, (0, SubscriptionManager_js_1.difference)(subscriptionNavigableIds, subscribedNavigableIds));
        }
        const subscription = this.#subscriptionManager.subscribe(eventNames, contextIds, channel);
        for (const eventName of subscription.eventNames) {
            for (const contextId of subscriptionNavigableIds) {
                for (const eventWrapper of this.#getBufferedEvents(eventName, contextId, channel)) {
                    // The order of the events is important.
                    this.emit("event" /* EventManagerEvents.Event */, {
                        message: OutgoingMessage_js_1.OutgoingMessage.createFromPromise(eventWrapper.event, channel),
                        event: eventName,
                    });
                    this.#markEventSent(eventWrapper, channel, eventName);
                }
            }
        }
        for (const [eventName, contextIds] of subscribeStepEvents) {
            for (const contextId of contextIds) {
                this.#subscribeHooks.get(eventName).forEach((hook) => hook(contextId));
            }
        }
        await this.toggleModulesIfNeeded();
        return subscription.id;
    }
    async unsubscribe(eventNames, contextIds, channel) {
        for (const name of eventNames) {
            (0, events_js_1.assertSupportedEvent)(name);
        }
        this.#subscriptionManager.unsubscribe(eventNames, contextIds, channel);
        await this.toggleModulesIfNeeded();
    }
    async unsubscribeByIds(subscriptionIds) {
        this.#subscriptionManager.unsubscribeById(subscriptionIds);
        await this.toggleModulesIfNeeded();
    }
    async toggleModulesIfNeeded() {
        // TODO(1): Only update changed subscribers
        // TODO(2): Enable for Worker Targets
        await Promise.all(this.#browsingContextStorage.getAllContexts().map(async (context) => {
            return await context.toggleModulesIfNeeded();
        }));
    }
    clearBufferedEvents(contextId) {
        for (const eventName of eventBufferLength.keys()) {
            const bufferMapKey = _a.#getMapKey(eventName, contextId);
            this.#eventBuffers.delete(bufferMapKey);
        }
    }
    /**
     * If the event is buffer-able, put it in the buffer.
     */
    #bufferEvent(eventWrapper, eventName) {
        if (!eventBufferLength.has(eventName)) {
            // Do nothing if the event is no buffer-able.
            return;
        }
        const bufferMapKey = _a.#getMapKey(eventName, eventWrapper.contextId);
        if (!this.#eventBuffers.has(bufferMapKey)) {
            this.#eventBuffers.set(bufferMapKey, new Buffer_js_1.Buffer(eventBufferLength.get(eventName)));
        }
        this.#eventBuffers.get(bufferMapKey).add(eventWrapper);
        // Add the context to the list of contexts having `eventName` events.
        this.#eventToContextsMap.get(eventName).add(eventWrapper.contextId);
    }
    /**
     * If the event is buffer-able, mark it as sent to the given contextId and channel.
     */
    #markEventSent(eventWrapper, channel, eventName) {
        if (!eventBufferLength.has(eventName)) {
            // Do nothing if the event is no buffer-able.
            return;
        }
        const lastSentMapKey = _a.#getMapKey(eventName, eventWrapper.contextId);
        const lastId = Math.max(this.#lastMessageSent.get(lastSentMapKey)?.get(JSON.stringify(channel)) ??
            0, eventWrapper.id);
        const channelMap = this.#lastMessageSent.get(lastSentMapKey);
        if (channelMap) {
            channelMap.set(JSON.stringify(channel), lastId);
        }
        else {
            this.#lastMessageSent.set(lastSentMapKey, new Map([[JSON.stringify(channel), lastId]]));
        }
    }
    /**
     * Returns events which are buffered and not yet sent to the given channel events.
     */
    #getBufferedEvents(eventName, contextId, channel) {
        const bufferMapKey = _a.#getMapKey(eventName, contextId);
        const lastSentMessageId = this.#lastMessageSent.get(bufferMapKey)?.get(JSON.stringify(channel)) ??
            -Infinity;
        const result = this.#eventBuffers
            .get(bufferMapKey)
            ?.get()
            .filter((wrapper) => wrapper.id > lastSentMessageId) ?? [];
        if (contextId === null) {
            // For global subscriptions, events buffered in each context should be sent back.
            Array.from(this.#eventToContextsMap.get(eventName).keys())
                .filter((_contextId) => 
            // Events without context are already in the result.
            _contextId !== null &&
                // Events from deleted contexts should not be sent.
                this.#browsingContextStorage.hasContext(_contextId))
                .map((_contextId) => this.#getBufferedEvents(eventName, _contextId, channel))
                .forEach((events) => result.push(...events));
        }
        return result.sort((e1, e2) => e1.id - e2.id);
    }
}
exports.EventManager = EventManager;
_a = EventManager;
//# sourceMappingURL=EventManager.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/session/SessionProcessor.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SessionProcessor = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
class SessionProcessor {
    #eventManager;
    #browserCdpClient;
    #initConnection;
    #created = false;
    constructor(eventManager, browserCdpClient, initConnection) {
        this.#eventManager = eventManager;
        this.#browserCdpClient = browserCdpClient;
        this.#initConnection = initConnection;
    }
    status() {
        return { ready: false, message: 'already connected' };
    }
    #mergeCapabilities(capabilitiesRequest) {
        // Roughly following https://www.w3.org/TR/webdriver2/#dfn-capabilities-processing.
        // Validations should already be done by the parser.
        const mergedCapabilities = [];
        for (const first of capabilitiesRequest.firstMatch ?? [{}]) {
            const result = {
                ...capabilitiesRequest.alwaysMatch,
            };
            for (const key of Object.keys(first)) {
                if (result[key] !== undefined) {
                    throw new protocol_js_1.InvalidArgumentException(`Capability ${key} in firstMatch is already defined in alwaysMatch`);
                }
                result[key] = first[key];
            }
            mergedCapabilities.push(result);
        }
        const match = mergedCapabilities.find((c) => c.browserName === 'chrome') ??
            mergedCapabilities[0] ??
            {};
        match.unhandledPromptBehavior = this.#getUnhandledPromptBehavior(match.unhandledPromptBehavior);
        return match;
    }
    #getUnhandledPromptBehavior(capabilityValue) {
        if (capabilityValue === undefined) {
            return undefined;
        }
        if (typeof capabilityValue === 'object') {
            // Do not validate capabilities. Incorrect ones will be ignored by Mapper.
            return capabilityValue;
        }
        if (typeof capabilityValue !== 'string') {
            throw new protocol_js_1.InvalidArgumentException(`Unexpected 'unhandledPromptBehavior' type: ${typeof capabilityValue}`);
        }
        switch (capabilityValue) {
            case 'accept':
            case 'accept and notify':
                return { default: "accept" /* Session.UserPromptHandlerType.Accept */ };
            case 'dismiss':
            case 'dismiss and notify':
                return { default: "dismiss" /* Session.UserPromptHandlerType.Dismiss */ };
            case 'ignore':
                return { default: "ignore" /* Session.UserPromptHandlerType.Ignore */ };
            default:
                throw new protocol_js_1.InvalidArgumentException(`Unexpected 'unhandledPromptBehavior' value: ${capabilityValue}`);
        }
    }
    async new(params) {
        if (this.#created) {
            throw new Error('Session has been already created.');
        }
        this.#created = true;
        const matchedCapabitlites = this.#mergeCapabilities(params.capabilities);
        await this.#initConnection(matchedCapabitlites);
        const version = await this.#browserCdpClient.sendCommand('Browser.getVersion');
        return {
            sessionId: 'unknown',
            capabilities: {
                ...matchedCapabitlites,
                acceptInsecureCerts: matchedCapabitlites.acceptInsecureCerts ?? false,
                browserName: version.product,
                browserVersion: version.revision,
                platformName: '',
                setWindowRect: false,
                webSocketUrl: '',
                userAgent: version.userAgent,
            },
        };
    }
    async subscribe(params, channel = {}) {
        const subscription = await this.#eventManager.subscribe(params.events, params.contexts ?? [], channel);
        return {
            subscription,
        };
    }
    async unsubscribe(params, channel = {}) {
        if ('subscriptions' in params) {
            await this.#eventManager.unsubscribeByIds(params.subscriptions);
            return {};
        }
        await this.#eventManager.unsubscribe(params.events, params.contexts ?? [], channel);
        return {};
    }
}
exports.SessionProcessor = SessionProcessor;
//# sourceMappingURL=SessionProcessor.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/session/SubscriptionManager.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2022 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SubscriptionManager = void 0;
exports.cartesianProduct = cartesianProduct;
exports.unrollEvents = unrollEvents;
exports.difference = difference;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const uuid_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/uuid.js");
/**
 * Returns the cartesian product of the given arrays.
 *
 * Example:
 *   cartesian([1, 2], ['a', 'b']); => [[1, 'a'], [1, 'b'], [2, 'a'], [2, 'b']]
 */
function cartesianProduct(...a) {
    return a.reduce((a, b) => a.flatMap((d) => b.map((e) => [d, e].flat())));
}
/** Expands "AllEvents" events into atomic events. */
function unrollEvents(events) {
    const allEvents = new Set();
    function addEvents(events) {
        for (const event of events) {
            allEvents.add(event);
        }
    }
    for (const event of events) {
        switch (event) {
            case protocol_js_1.ChromiumBidi.BiDiModule.Bluetooth:
                addEvents(Object.values(protocol_js_1.ChromiumBidi.Bluetooth.EventNames));
                break;
            case protocol_js_1.ChromiumBidi.BiDiModule.BrowsingContext:
                addEvents(Object.values(protocol_js_1.ChromiumBidi.BrowsingContext.EventNames));
                break;
            case protocol_js_1.ChromiumBidi.BiDiModule.Log:
                addEvents(Object.values(protocol_js_1.ChromiumBidi.Log.EventNames));
                break;
            case protocol_js_1.ChromiumBidi.BiDiModule.Network:
                addEvents(Object.values(protocol_js_1.ChromiumBidi.Network.EventNames));
                break;
            case protocol_js_1.ChromiumBidi.BiDiModule.Script:
                addEvents(Object.values(protocol_js_1.ChromiumBidi.Script.EventNames));
                break;
            default:
                allEvents.add(event);
        }
    }
    return [...allEvents.values()];
}
class SubscriptionManager {
    #subscriptions = [];
    #knownSubscriptionIds = new Set();
    #browsingContextStorage;
    constructor(browsingContextStorage) {
        this.#browsingContextStorage = browsingContextStorage;
    }
    getChannelsSubscribedToEvent(eventName, contextId) {
        // Maps JSON stringified channel to a channel.
        // TODO: switch to `Set` of `goog:channel` once legacy `channel` is removed.
        const channels = new Map();
        for (const subscription of this.#subscriptions) {
            if (this.#isSubscribedTo(subscription, eventName, contextId)) {
                channels.set(JSON.stringify(subscription.channel), subscription.channel);
            }
        }
        return Array.from(channels.values());
    }
    getChannelsSubscribedToEventGlobally(eventName) {
        // Maps JSON stringified channel to a channel.
        // TODO: switch to `Set` of `goog:channel` once legacy `channel` is removed.
        const channels = new Map();
        for (const subscription of this.#subscriptions) {
            if (this.#isSubscribedTo(subscription, eventName)) {
                channels.set(JSON.stringify(subscription.channel), subscription.channel);
            }
        }
        return Array.from(channels.values());
    }
    #isSubscribedTo(subscription, moduleOrEvent, contextId) {
        let includesEvent = false;
        for (const eventName of subscription.eventNames) {
            // This also covers the `cdp` case where
            // we don't unroll the event names
            if (
            // Event explicitly subscribed
            eventName === moduleOrEvent ||
                // Event subscribed via module
                eventName === moduleOrEvent.split('.').at(0) ||
                // Event explicitly subscribed compared to module
                eventName.split('.').at(0) === moduleOrEvent) {
                includesEvent = true;
                break;
            }
        }
        if (!includesEvent) {
            return false;
        }
        // global subscription.
        if (subscription.topLevelTraversableIds.size === 0) {
            return true;
        }
        const topLevelContext = contextId
            ? this.#browsingContextStorage.findTopLevelContextId(contextId)
            : null;
        if (topLevelContext !== null &&
            subscription.topLevelTraversableIds.has(topLevelContext)) {
            return true;
        }
        return false;
    }
    isSubscribedTo(moduleOrEvent, contextId) {
        for (const subscription of this.#subscriptions) {
            if (this.#isSubscribedTo(subscription, moduleOrEvent, contextId)) {
                return true;
            }
        }
        return false;
    }
    /**
     * Subscribes to event in the given context and channel.
     * @param {EventNames} event
     * @param {BrowsingContext.BrowsingContext | null} contextId
     * @param {BidiPlusChannel} channel
     * @return {SubscriptionItem[]} List of
     * subscriptions. If the event is a whole module, it will return all the specific
     * events. If the contextId is null, it will return all the top-level contexts which were
     * not subscribed before the command.
     */
    subscribe(eventNames, contextIds, channel) {
        // All the subscriptions are handled on the top-level contexts.
        const subscription = {
            id: (0, uuid_js_1.uuidv4)(),
            eventNames: new Set(unrollEvents(eventNames)),
            topLevelTraversableIds: new Set(contextIds.map((contextId) => {
                const topLevelContext = this.#browsingContextStorage.findTopLevelContextId(contextId);
                if (!topLevelContext) {
                    throw new protocol_js_1.NoSuchFrameException(`Top-level navigable not found for context id ${contextId}`);
                }
                return topLevelContext;
            })),
            channel,
        };
        this.#subscriptions.push(subscription);
        this.#knownSubscriptionIds.add(subscription.id);
        return subscription;
    }
    /**
     * Unsubscribes atomically from all events in the given contexts and channel.
     *
     * This is a legacy spec branch to unsubscribe by attributes.
     */
    unsubscribe(inputEventNames, inputContextIds, channel) {
        const eventNames = new Set(unrollEvents(inputEventNames));
        for (const contextId of inputContextIds) {
            // Validation that contexts exist.
            this.#browsingContextStorage.getContext(contextId);
        }
        const topLevelTraversables = new Set(inputContextIds.map((contextId) => {
            const topLevelContext = this.#browsingContextStorage.findTopLevelContextId(contextId);
            if (!topLevelContext) {
                throw new protocol_js_1.NoSuchFrameException(`Top-level navigable not found for context id ${contextId}`);
            }
            return topLevelContext;
        }));
        const isGlobalUnsubscribe = topLevelTraversables.size === 0;
        const newSubscriptions = [];
        const eventsMatched = new Set();
        const contextsMatched = new Set();
        for (const subscription of this.#subscriptions) {
            // `channel` is undefined or an object with 1 field, so `JSON.stringify` is stable.
            if (JSON.stringify(subscription.channel) !== JSON.stringify(channel)) {
                newSubscriptions.push(subscription);
                continue;
            }
            // Skip subscriptions when none of the event names match.
            if (intersection(subscription.eventNames, eventNames).size === 0) {
                newSubscriptions.push(subscription);
                continue;
            }
            if (isGlobalUnsubscribe) {
                // Skip non-global subscriptions.
                if (subscription.topLevelTraversableIds.size !== 0) {
                    newSubscriptions.push(subscription);
                    continue;
                }
                const subscriptionEventNames = new Set(subscription.eventNames);
                for (const eventName of eventNames) {
                    if (subscriptionEventNames.has(eventName)) {
                        eventsMatched.add(eventName);
                        subscriptionEventNames.delete(eventName);
                    }
                }
                // If some events remain in the subscription, we keep it.
                if (subscriptionEventNames.size !== 0) {
                    newSubscriptions.push({
                        ...subscription,
                        eventNames: subscriptionEventNames,
                    });
                }
            }
            else {
                // Skip global subscriptions.
                if (subscription.topLevelTraversableIds.size === 0) {
                    newSubscriptions.push(subscription);
                    continue;
                }
                // Splitting context subscriptions.
                const eventMap = new Map();
                for (const eventName of subscription.eventNames) {
                    eventMap.set(eventName, new Set(subscription.topLevelTraversableIds));
                }
                for (const eventName of eventNames) {
                    const eventContextSet = eventMap.get(eventName);
                    if (!eventContextSet) {
                        continue;
                    }
                    for (const toRemoveId of topLevelTraversables) {
                        if (eventContextSet.has(toRemoveId)) {
                            contextsMatched.add(toRemoveId);
                            eventsMatched.add(eventName);
                            eventContextSet.delete(toRemoveId);
                        }
                    }
                    if (eventContextSet.size === 0) {
                        eventMap.delete(eventName);
                    }
                }
                for (const [eventName, remainingContextIds] of eventMap) {
                    const partialSubscription = {
                        id: subscription.id,
                        channel: subscription.channel,
                        eventNames: new Set([eventName]),
                        topLevelTraversableIds: remainingContextIds,
                    };
                    newSubscriptions.push(partialSubscription);
                }
            }
        }
        // If some events did not match, it is an invalid request.
        if (!equal(eventsMatched, eventNames)) {
            throw new protocol_js_1.InvalidArgumentException('No subscription found');
        }
        // If some contexts did not match, it is an invalid request.
        if (!isGlobalUnsubscribe && !equal(contextsMatched, topLevelTraversables)) {
            throw new protocol_js_1.InvalidArgumentException('No subscription found');
        }
        // Committing the new subscriptions.
        this.#subscriptions = newSubscriptions;
    }
    /**
     * Unsubscribes by subscriptionId.
     */
    unsubscribeById(subscriptionIds) {
        const subscriptionIdsSet = new Set(subscriptionIds);
        const unknownIds = difference(subscriptionIdsSet, this.#knownSubscriptionIds);
        if (unknownIds.size !== 0) {
            throw new protocol_js_1.InvalidArgumentException('No subscription found');
        }
        this.#subscriptions = this.#subscriptions.filter((subscription) => {
            return !subscriptionIdsSet.has(subscription.id);
        });
        this.#knownSubscriptionIds = difference(this.#knownSubscriptionIds, subscriptionIdsSet);
    }
}
exports.SubscriptionManager = SubscriptionManager;
/**
 * Replace with Set.prototype.intersection once Node 20 is dropped.
 */
function intersection(setA, setB) {
    const result = new Set();
    for (const a of setA) {
        if (setB.has(a)) {
            result.add(a);
        }
    }
    return result;
}
/**
 * Replace with Set.prototype.difference once Node 20 is dropped.
 */
function difference(setA, setB) {
    const result = new Set();
    for (const a of setA) {
        if (!setB.has(a)) {
            result.add(a);
        }
    }
    return result;
}
function equal(setA, setB) {
    if (setA.size !== setB.size) {
        return false;
    }
    for (const a of setA) {
        if (!setB.has(a)) {
            return false;
        }
    }
    return true;
}
//# sourceMappingURL=SubscriptionManager.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/session/events.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isCdpEvent = isCdpEvent;
exports.isDeprecatedCdpEvent = isDeprecatedCdpEvent;
exports.assertSupportedEvent = assertSupportedEvent;
/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
/**
 * Returns true if the given event is a CDP event.
 * @see https://chromedevtools.github.io/devtools-protocol/
 */
function isCdpEvent(name) {
    return (name.split('.').at(0)?.startsWith(protocol_js_1.ChromiumBidi.BiDiModule.Cdp) ?? false);
}
/**
 * Returns true if the given event is a deprecated CDP event.
 * @see https://chromedevtools.github.io/devtools-protocol/
 */
function isDeprecatedCdpEvent(name) {
    return (name.split('.').at(0)?.startsWith(protocol_js_1.ChromiumBidi.BiDiModule.DeprecatedCdp) ??
        false);
}
/**
 * Asserts that the given event is known to BiDi or BiDi+, or throws otherwise.
 */
function assertSupportedEvent(name) {
    if (!protocol_js_1.ChromiumBidi.EVENT_NAMES.has(name) &&
        !isCdpEvent(name) &&
        !isDeprecatedCdpEvent(name)) {
        throw new protocol_js_1.InvalidArgumentException(`Unknown event: ${name}`);
    }
}
//# sourceMappingURL=events.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/storage/StorageProcessor.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StorageProcessor = void 0;
const protocol_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js");
const assert_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/assert.js");
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
const NetworkProcessor_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/network/NetworkProcessor.js");
const NetworkUtils_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/bidiMapper/modules/network/NetworkUtils.js");
/**
 * Responsible for handling the `storage` module.
 */
class StorageProcessor {
    #browserCdpClient;
    #browsingContextStorage;
    #logger;
    constructor(browserCdpClient, browsingContextStorage, logger) {
        this.#browsingContextStorage = browsingContextStorage;
        this.#browserCdpClient = browserCdpClient;
        this.#logger = logger;
    }
    async deleteCookies(params) {
        const partitionKey = this.#expandStoragePartitionSpec(params.partition);
        let cdpResponse;
        try {
            cdpResponse = await this.#browserCdpClient.sendCommand('Storage.getCookies', {
                browserContextId: this.#getCdpBrowserContextId(partitionKey),
            });
        }
        catch (err) {
            if (this.#isNoSuchUserContextError(err)) {
                // If the user context is not found, special error is thrown.
                throw new protocol_js_1.NoSuchUserContextException(err.message);
            }
            throw err;
        }
        const cdpCookiesToDelete = cdpResponse.cookies
            .filter(
        // CDP's partition key is the source origin. If the request specifies the
        // `sourceOrigin` partition key, only cookies with the requested source origin
        // are returned.
        (c) => partitionKey.sourceOrigin === undefined ||
            c.partitionKey?.topLevelSite === partitionKey.sourceOrigin)
            .filter((cdpCookie) => {
            const bidiCookie = (0, NetworkUtils_js_1.cdpToBiDiCookie)(cdpCookie);
            return this.#matchCookie(bidiCookie, params.filter);
        })
            .map((cookie) => ({
            ...cookie,
            // Set expiry to pass date to delete the cookie.
            expires: 1,
        }));
        await this.#browserCdpClient.sendCommand('Storage.setCookies', {
            cookies: cdpCookiesToDelete,
            browserContextId: this.#getCdpBrowserContextId(partitionKey),
        });
        return {
            partitionKey,
        };
    }
    async getCookies(params) {
        const partitionKey = this.#expandStoragePartitionSpec(params.partition);
        let cdpResponse;
        try {
            cdpResponse = await this.#browserCdpClient.sendCommand('Storage.getCookies', {
                browserContextId: this.#getCdpBrowserContextId(partitionKey),
            });
        }
        catch (err) {
            if (this.#isNoSuchUserContextError(err)) {
                // If the user context is not found, special error is thrown.
                throw new protocol_js_1.NoSuchUserContextException(err.message);
            }
            throw err;
        }
        const filteredBiDiCookies = cdpResponse.cookies
            .filter(
        // CDP's partition key is the source origin. If the request specifies the
        // `sourceOrigin` partition key, only cookies with the requested source origin
        // are returned.
        (c) => partitionKey.sourceOrigin === undefined ||
            c.partitionKey?.topLevelSite === partitionKey.sourceOrigin)
            .map((c) => (0, NetworkUtils_js_1.cdpToBiDiCookie)(c))
            .filter((c) => this.#matchCookie(c, params.filter));
        return {
            cookies: filteredBiDiCookies,
            partitionKey,
        };
    }
    async setCookie(params) {
        const partitionKey = this.#expandStoragePartitionSpec(params.partition);
        const cdpCookie = (0, NetworkUtils_js_1.bidiToCdpCookie)(params, partitionKey);
        try {
            await this.#browserCdpClient.sendCommand('Storage.setCookies', {
                cookies: [cdpCookie],
                browserContextId: this.#getCdpBrowserContextId(partitionKey),
            });
        }
        catch (err) {
            if (this.#isNoSuchUserContextError(err)) {
                // If the user context is not found, special error is thrown.
                throw new protocol_js_1.NoSuchUserContextException(err.message);
            }
            this.#logger?.(log_js_1.LogType.debugError, err);
            throw new protocol_js_1.UnableToSetCookieException(err.toString());
        }
        return {
            partitionKey,
        };
    }
    #isNoSuchUserContextError(err) {
        // Heuristic to detect if the user context is not found.
        // See https://source.chromium.org/chromium/chromium/src/+/main:content/browser/devtools/protocol/browser_handler.cc;drc=a56154dd81e4679712422ac6eed2c9581cb51ab0;l=314
        return err.message?.startsWith('Failed to find browser context for id');
    }
    #getCdpBrowserContextId(partitionKey) {
        return partitionKey.userContext === 'default'
            ? undefined
            : partitionKey.userContext;
    }
    #expandStoragePartitionSpecByBrowsingContext(descriptor) {
        const browsingContextId = descriptor.context;
        const browsingContext = this.#browsingContextStorage.getContext(browsingContextId);
        // https://w3c.github.io/webdriver-bidi/#associated-storage-partition.
        // Each browsing context also has an associated storage partition, which is the
        // storage partition it uses to persist data. In Chromium it's a `BrowserContext`
        // which maps to BiDi `UserContext`.
        return {
            userContext: browsingContext.userContext,
        };
    }
    #expandStoragePartitionSpecByStorageKey(descriptor) {
        const unsupportedPartitionKeys = new Map();
        let sourceOrigin = descriptor.sourceOrigin;
        if (sourceOrigin !== undefined) {
            const url = NetworkProcessor_js_1.NetworkProcessor.parseUrlString(sourceOrigin);
            if (url.origin === 'null') {
                // Origin `null` is a special case for local pages.
                sourceOrigin = url.origin;
            }
            else {
                // Port is not supported in CDP Cookie's `partitionKey`, so it should be stripped
                // from the requested source origin.
                sourceOrigin = `${url.protocol}//${url.hostname}`;
            }
        }
        for (const [key, value] of Object.entries(descriptor)) {
            if (key !== undefined &&
                value !== undefined &&
                !['type', 'sourceOrigin', 'userContext'].includes(key)) {
                unsupportedPartitionKeys.set(key, value);
            }
        }
        if (unsupportedPartitionKeys.size > 0) {
            this.#logger?.(log_js_1.LogType.debugInfo, `Unsupported partition keys: ${JSON.stringify(Object.fromEntries(unsupportedPartitionKeys))}`);
        }
        // Set `userContext` to `default` if not provided, as it's required in Chromium.
        const userContext = descriptor.userContext ?? 'default';
        return {
            userContext,
            ...(sourceOrigin === undefined ? {} : { sourceOrigin }),
        };
    }
    #expandStoragePartitionSpec(partitionSpec) {
        if (partitionSpec === undefined) {
            // `userContext` is required in Chromium.
            return { userContext: 'default' };
        }
        if (partitionSpec.type === 'context') {
            return this.#expandStoragePartitionSpecByBrowsingContext(partitionSpec);
        }
        (0, assert_js_1.assert)(partitionSpec.type === 'storageKey', 'Unknown partition type');
        // Partition spec is a storage partition.
        // Let partition key be partition spec.
        return this.#expandStoragePartitionSpecByStorageKey(partitionSpec);
    }
    #matchCookie(cookie, filter) {
        if (filter === undefined) {
            return true;
        }
        return ((filter.domain === undefined || filter.domain === cookie.domain) &&
            (filter.name === undefined || filter.name === cookie.name) &&
            // `value` contains fields `type` and `value`.
            (filter.value === undefined ||
                (0, NetworkUtils_js_1.deserializeByteValue)(filter.value) ===
                    (0, NetworkUtils_js_1.deserializeByteValue)(cookie.value)) &&
            (filter.path === undefined || filter.path === cookie.path) &&
            (filter.size === undefined || filter.size === cookie.size) &&
            (filter.httpOnly === undefined || filter.httpOnly === cookie.httpOnly) &&
            (filter.secure === undefined || filter.secure === cookie.secure) &&
            (filter.sameSite === undefined || filter.sameSite === cookie.sameSite) &&
            (filter.expiry === undefined || filter.expiry === cookie.expiry));
    }
}
exports.StorageProcessor = StorageProcessor;
//# sourceMappingURL=StorageProcessor.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/cdp/CdpClient.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2021 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MapperCdpClient = exports.CloseError = void 0;
const EventEmitter_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/EventEmitter.js");
/** An error that will be thrown if/when the connection is closed. */
class CloseError extends Error {
}
exports.CloseError = CloseError;
/** Represents a high-level CDP connection to the browser. */
class MapperCdpClient extends EventEmitter_js_1.EventEmitter {
    #cdpConnection;
    #sessionId;
    constructor(cdpConnection, sessionId) {
        super();
        this.#cdpConnection = cdpConnection;
        this.#sessionId = sessionId;
    }
    get sessionId() {
        return this.#sessionId;
    }
    sendCommand(method, ...params) {
        return this.#cdpConnection.sendCommand(method, params[0], this.#sessionId);
    }
    isCloseError(error) {
        return error instanceof CloseError;
    }
}
exports.MapperCdpClient = MapperCdpClient;
//# sourceMappingURL=CdpClient.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/cdp/CdpConnection.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MapperCdpConnection = void 0;
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
const CdpClient_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/cdp/CdpClient.js");
/**
 * Represents a high-level CDP connection to the browser backend.
 *
 * Manages all CdpClients (each backed by a Session ID) instance for each active
 * CDP session.
 */
class MapperCdpConnection {
    static LOGGER_PREFIX_RECV = `${log_js_1.LogType.cdp}:RECV ◂`;
    static LOGGER_PREFIX_SEND = `${log_js_1.LogType.cdp}:SEND ▸`;
    #mainBrowserCdpClient;
    #transport;
    /** Map from session ID to CdpClient.
     * `undefined` points to the main browser session. */
    #sessionCdpClients = new Map();
    #commandCallbacks = new Map();
    #logger;
    #nextId = 0;
    constructor(transport, logger) {
        this.#transport = transport;
        this.#logger = logger;
        this.#transport.setOnMessage(this.#onMessage);
        // Create default Browser CDP Session.
        this.#mainBrowserCdpClient = this.#createCdpClient(undefined);
    }
    /** Closes the connection to the browser. */
    close() {
        this.#transport.close();
        for (const [, { reject, error }] of this.#commandCallbacks) {
            reject(error);
        }
        this.#commandCallbacks.clear();
        this.#sessionCdpClients.clear();
    }
    async createBrowserSession() {
        const { sessionId } = await this.#mainBrowserCdpClient.sendCommand('Target.attachToBrowserTarget');
        return this.#createCdpClient(sessionId);
    }
    /**
     * Gets a CdpClient instance attached to the given session ID,
     * or null if the session is not attached.
     */
    getCdpClient(sessionId) {
        const cdpClient = this.#sessionCdpClients.get(sessionId);
        if (!cdpClient) {
            throw new Error(`Unknown CDP session ID: ${sessionId}`);
        }
        return cdpClient;
    }
    sendCommand(method, params, sessionId) {
        return new Promise((resolve, reject) => {
            const id = this.#nextId++;
            this.#commandCallbacks.set(id, {
                sessionId,
                resolve,
                reject,
                error: new CdpClient_js_1.CloseError(`${method} ${JSON.stringify(params)} ${sessionId ?? ''} call rejected because the connection has been closed.`),
            });
            const cdpMessage = { id, method, params };
            if (sessionId) {
                cdpMessage.sessionId = sessionId;
            }
            void this.#transport
                .sendMessage(JSON.stringify(cdpMessage))
                ?.catch((error) => {
                this.#logger?.(log_js_1.LogType.debugError, error);
                this.#transport.close();
            });
            this.#logger?.(_a.LOGGER_PREFIX_SEND, cdpMessage);
        });
    }
    #onMessage = (json) => {
        const message = JSON.parse(json);
        this.#logger?.(_a.LOGGER_PREFIX_RECV, message);
        // Update client map if a session is attached
        // Listen for these events on every session.
        if (message.method === 'Target.attachedToTarget') {
            const { sessionId } = message.params;
            this.#createCdpClient(sessionId);
        }
        if (message.id !== undefined) {
            // Handle command response.
            const callbacks = this.#commandCallbacks.get(message.id);
            this.#commandCallbacks.delete(message.id);
            if (callbacks) {
                if (message.result) {
                    callbacks.resolve(message.result);
                }
                else if (message.error) {
                    callbacks.reject(message.error);
                }
            }
        }
        else if (message.method) {
            const client = this.#sessionCdpClients.get(message.sessionId ?? undefined);
            client?.emit(message.method, message.params || {});
            // Update client map if a session is detached
            // But emit on that session
            if (message.method === 'Target.detachedFromTarget') {
                const { sessionId } = message.params;
                const client = this.#sessionCdpClients.get(sessionId);
                if (client) {
                    this.#sessionCdpClients.delete(sessionId);
                    client.removeAllListeners();
                }
                // Reject all the pending commands for the detached session.
                for (const callback of this.#commandCallbacks.values()) {
                    if (callback.sessionId === sessionId) {
                        callback.reject(callback.error);
                    }
                }
            }
        }
    };
    /**
     * Creates a new CdpClient instance for the given session ID.
     * @param sessionId either a string, or undefined for the main browser session.
     * The main browser session is used only to create new browser sessions.
     * @private
     */
    #createCdpClient(sessionId) {
        const cdpClient = new CdpClient_js_1.MapperCdpClient(this, sessionId);
        this.#sessionCdpClients.set(sessionId, cdpClient);
        return cdpClient;
    }
}
exports.MapperCdpConnection = MapperCdpConnection;
_a = MapperCdpConnection;
//# sourceMappingURL=CdpConnection.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/ErrorResponse.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NoSuchWebExtensionException = exports.InvalidWebExtensionException = exports.UnderspecifiedStoragePartitionException = exports.UnableToSetFileInputException = exports.UnableToSetCookieException = exports.NoSuchStoragePartitionException = exports.UnsupportedOperationException = exports.UnableToCloseBrowserException = exports.UnableToCaptureScreenException = exports.UnknownErrorException = exports.UnknownCommandException = exports.SessionNotCreatedException = exports.NoSuchUserContextException = exports.NoSuchScriptException = exports.NoSuchRequestException = exports.NoSuchNodeException = exports.NoSuchInterceptException = exports.NoSuchHistoryEntryException = exports.NoSuchHandleException = exports.NoSuchFrameException = exports.NoSuchElementException = exports.NoSuchAlertException = exports.MoveTargetOutOfBoundsException = exports.InvalidSessionIdException = exports.InvalidSelectorException = exports.InvalidArgumentException = exports.Exception = void 0;
class Exception extends Error {
    error;
    message;
    stacktrace;
    constructor(error, message, stacktrace) {
        super();
        this.error = error;
        this.message = message;
        this.stacktrace = stacktrace;
    }
    toErrorResponse(commandId) {
        return {
            type: 'error',
            id: commandId,
            error: this.error,
            message: this.message,
            stacktrace: this.stacktrace,
        };
    }
}
exports.Exception = Exception;
class InvalidArgumentException extends Exception {
    constructor(message, stacktrace) {
        super("invalid argument" /* ErrorCode.InvalidArgument */, message, stacktrace);
    }
}
exports.InvalidArgumentException = InvalidArgumentException;
class InvalidSelectorException extends Exception {
    constructor(message, stacktrace) {
        super("invalid selector" /* ErrorCode.InvalidSelector */, message, stacktrace);
    }
}
exports.InvalidSelectorException = InvalidSelectorException;
class InvalidSessionIdException extends Exception {
    constructor(message, stacktrace) {
        super("invalid session id" /* ErrorCode.InvalidSessionId */, message, stacktrace);
    }
}
exports.InvalidSessionIdException = InvalidSessionIdException;
class MoveTargetOutOfBoundsException extends Exception {
    constructor(message, stacktrace) {
        super("move target out of bounds" /* ErrorCode.MoveTargetOutOfBounds */, message, stacktrace);
    }
}
exports.MoveTargetOutOfBoundsException = MoveTargetOutOfBoundsException;
class NoSuchAlertException extends Exception {
    constructor(message, stacktrace) {
        super("no such alert" /* ErrorCode.NoSuchAlert */, message, stacktrace);
    }
}
exports.NoSuchAlertException = NoSuchAlertException;
class NoSuchElementException extends Exception {
    constructor(message, stacktrace) {
        super("no such element" /* ErrorCode.NoSuchElement */, message, stacktrace);
    }
}
exports.NoSuchElementException = NoSuchElementException;
class NoSuchFrameException extends Exception {
    constructor(message, stacktrace) {
        super("no such frame" /* ErrorCode.NoSuchFrame */, message, stacktrace);
    }
}
exports.NoSuchFrameException = NoSuchFrameException;
class NoSuchHandleException extends Exception {
    constructor(message, stacktrace) {
        super("no such handle" /* ErrorCode.NoSuchHandle */, message, stacktrace);
    }
}
exports.NoSuchHandleException = NoSuchHandleException;
class NoSuchHistoryEntryException extends Exception {
    constructor(message, stacktrace) {
        super("no such history entry" /* ErrorCode.NoSuchHistoryEntry */, message, stacktrace);
    }
}
exports.NoSuchHistoryEntryException = NoSuchHistoryEntryException;
class NoSuchInterceptException extends Exception {
    constructor(message, stacktrace) {
        super("no such intercept" /* ErrorCode.NoSuchIntercept */, message, stacktrace);
    }
}
exports.NoSuchInterceptException = NoSuchInterceptException;
class NoSuchNodeException extends Exception {
    constructor(message, stacktrace) {
        super("no such node" /* ErrorCode.NoSuchNode */, message, stacktrace);
    }
}
exports.NoSuchNodeException = NoSuchNodeException;
class NoSuchRequestException extends Exception {
    constructor(message, stacktrace) {
        super("no such request" /* ErrorCode.NoSuchRequest */, message, stacktrace);
    }
}
exports.NoSuchRequestException = NoSuchRequestException;
class NoSuchScriptException extends Exception {
    constructor(message, stacktrace) {
        super("no such script" /* ErrorCode.NoSuchScript */, message, stacktrace);
    }
}
exports.NoSuchScriptException = NoSuchScriptException;
class NoSuchUserContextException extends Exception {
    constructor(message, stacktrace) {
        super("no such user context" /* ErrorCode.NoSuchUserContext */, message, stacktrace);
    }
}
exports.NoSuchUserContextException = NoSuchUserContextException;
class SessionNotCreatedException extends Exception {
    constructor(message, stacktrace) {
        super("session not created" /* ErrorCode.SessionNotCreated */, message, stacktrace);
    }
}
exports.SessionNotCreatedException = SessionNotCreatedException;
class UnknownCommandException extends Exception {
    constructor(message, stacktrace) {
        super("unknown command" /* ErrorCode.UnknownCommand */, message, stacktrace);
    }
}
exports.UnknownCommandException = UnknownCommandException;
class UnknownErrorException extends Exception {
    constructor(message, stacktrace = new Error().stack) {
        super("unknown error" /* ErrorCode.UnknownError */, message, stacktrace);
    }
}
exports.UnknownErrorException = UnknownErrorException;
class UnableToCaptureScreenException extends Exception {
    constructor(message, stacktrace) {
        super("unable to capture screen" /* ErrorCode.UnableToCaptureScreen */, message, stacktrace);
    }
}
exports.UnableToCaptureScreenException = UnableToCaptureScreenException;
class UnableToCloseBrowserException extends Exception {
    constructor(message, stacktrace) {
        super("unable to close browser" /* ErrorCode.UnableToCloseBrowser */, message, stacktrace);
    }
}
exports.UnableToCloseBrowserException = UnableToCloseBrowserException;
class UnsupportedOperationException extends Exception {
    constructor(message, stacktrace) {
        super("unsupported operation" /* ErrorCode.UnsupportedOperation */, message, stacktrace);
    }
}
exports.UnsupportedOperationException = UnsupportedOperationException;
class NoSuchStoragePartitionException extends Exception {
    constructor(message, stacktrace) {
        super("no such storage partition" /* ErrorCode.NoSuchStoragePartition */, message, stacktrace);
    }
}
exports.NoSuchStoragePartitionException = NoSuchStoragePartitionException;
class UnableToSetCookieException extends Exception {
    constructor(message, stacktrace) {
        super("unable to set cookie" /* ErrorCode.UnableToSetCookie */, message, stacktrace);
    }
}
exports.UnableToSetCookieException = UnableToSetCookieException;
class UnableToSetFileInputException extends Exception {
    constructor(message, stacktrace) {
        super("unable to set file input" /* ErrorCode.UnableToSetFileInput */, message, stacktrace);
    }
}
exports.UnableToSetFileInputException = UnableToSetFileInputException;
class UnderspecifiedStoragePartitionException extends Exception {
    constructor(message, stacktrace) {
        super("underspecified storage partition" /* ErrorCode.UnderspecifiedStoragePartition */, message, stacktrace);
    }
}
exports.UnderspecifiedStoragePartitionException = UnderspecifiedStoragePartitionException;
class InvalidWebExtensionException extends Exception {
    constructor(message, stacktrace) {
        super("invalid web extension" /* ErrorCode.InvalidWebExtension */, message, stacktrace);
    }
}
exports.InvalidWebExtensionException = InvalidWebExtensionException;
class NoSuchWebExtensionException extends Exception {
    constructor(message, stacktrace) {
        super("no such web extension" /* ErrorCode.NoSuchWebExtension */, message, stacktrace);
    }
}
exports.NoSuchWebExtensionException = NoSuchWebExtensionException;
//# sourceMappingURL=ErrorResponse.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/cdp.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=cdp.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/chromium-bidi.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EVENT_NAMES = exports.Bluetooth = exports.Network = exports.BrowsingContext = exports.Log = exports.Script = exports.BiDiModule = void 0;
// keep-sorted end
var BiDiModule;
(function (BiDiModule) {
    // keep-sorted start
    BiDiModule["Bluetooth"] = "bluetooth";
    BiDiModule["Browser"] = "browser";
    BiDiModule["BrowsingContext"] = "browsingContext";
    BiDiModule["Cdp"] = "goog:cdp";
    BiDiModule["DeprecatedCdp"] = "cdp";
    BiDiModule["Input"] = "input";
    BiDiModule["Log"] = "log";
    BiDiModule["Network"] = "network";
    BiDiModule["Script"] = "script";
    BiDiModule["Session"] = "session";
    // keep-sorted end
})(BiDiModule || (exports.BiDiModule = BiDiModule = {}));
var Script;
(function (Script) {
    let EventNames;
    (function (EventNames) {
        // keep-sorted start
        EventNames["Message"] = "script.message";
        EventNames["RealmCreated"] = "script.realmCreated";
        EventNames["RealmDestroyed"] = "script.realmDestroyed";
        // keep-sorted end
    })(EventNames = Script.EventNames || (Script.EventNames = {}));
})(Script || (exports.Script = Script = {}));
var Log;
(function (Log) {
    let EventNames;
    (function (EventNames) {
        EventNames["LogEntryAdded"] = "log.entryAdded";
    })(EventNames = Log.EventNames || (Log.EventNames = {}));
})(Log || (exports.Log = Log = {}));
var BrowsingContext;
(function (BrowsingContext) {
    let EventNames;
    (function (EventNames) {
        // keep-sorted start
        EventNames["ContextCreated"] = "browsingContext.contextCreated";
        EventNames["ContextDestroyed"] = "browsingContext.contextDestroyed";
        EventNames["DomContentLoaded"] = "browsingContext.domContentLoaded";
        EventNames["DownloadWillBegin"] = "browsingContext.downloadWillBegin";
        EventNames["FragmentNavigated"] = "browsingContext.fragmentNavigated";
        EventNames["HistoryUpdated"] = "browsingContext.historyUpdated";
        EventNames["Load"] = "browsingContext.load";
        EventNames["NavigationAborted"] = "browsingContext.navigationAborted";
        EventNames["NavigationFailed"] = "browsingContext.navigationFailed";
        EventNames["NavigationStarted"] = "browsingContext.navigationStarted";
        EventNames["UserPromptClosed"] = "browsingContext.userPromptClosed";
        EventNames["UserPromptOpened"] = "browsingContext.userPromptOpened";
        // keep-sorted end
    })(EventNames = BrowsingContext.EventNames || (BrowsingContext.EventNames = {}));
})(BrowsingContext || (exports.BrowsingContext = BrowsingContext = {}));
var Network;
(function (Network) {
    let EventNames;
    (function (EventNames) {
        // keep-sorted start
        EventNames["AuthRequired"] = "network.authRequired";
        EventNames["BeforeRequestSent"] = "network.beforeRequestSent";
        EventNames["FetchError"] = "network.fetchError";
        EventNames["ResponseCompleted"] = "network.responseCompleted";
        EventNames["ResponseStarted"] = "network.responseStarted";
        // keep-sorted end
    })(EventNames = Network.EventNames || (Network.EventNames = {}));
})(Network || (exports.Network = Network = {}));
var Bluetooth;
(function (Bluetooth) {
    let EventNames;
    (function (EventNames) {
        EventNames["RequestDevicePromptUpdated"] = "bluetooth.requestDevicePromptUpdated";
    })(EventNames = Bluetooth.EventNames || (Bluetooth.EventNames = {}));
})(Bluetooth || (exports.Bluetooth = Bluetooth = {}));
exports.EVENT_NAMES = new Set([
    // keep-sorted start
    ...Object.values(BiDiModule),
    ...Object.values(Bluetooth.EventNames),
    ...Object.values(BrowsingContext.EventNames),
    ...Object.values(Log.EventNames),
    ...Object.values(Network.EventNames),
    ...Object.values(Script.EventNames),
    // keep-sorted end
]);
//# sourceMappingURL=chromium-bidi.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/generated/webdriver-bidi-bluetooth.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=webdriver-bidi-bluetooth.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/generated/webdriver-bidi-permissions.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=webdriver-bidi-permissions.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/generated/webdriver-bidi.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=webdriver-bidi.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/protocol.js":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChromiumBidi = exports.Cdp = void 0;
/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
exports.Cdp = __importStar(__webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/cdp.js"));
exports.ChromiumBidi = __importStar(__webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/chromium-bidi.js"));
__exportStar(__webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/generated/webdriver-bidi.js"), exports);
__exportStar(__webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/ErrorResponse.js"), exports);
__exportStar(__webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/generated/webdriver-bidi-permissions.js"), exports);
__exportStar(__webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/protocol/generated/webdriver-bidi-bluetooth.js"), exports);
//# sourceMappingURL=protocol.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/Buffer.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2022 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Buffer = void 0;
/** Implements a FIFO buffer with a fixed size. */
class Buffer {
    #capacity;
    #entries = [];
    #onItemRemoved;
    /**
     * @param capacity The buffer capacity.
     * @param onItemRemoved Delegate called for each removed element.
     */
    constructor(capacity, onItemRemoved) {
        this.#capacity = capacity;
        this.#onItemRemoved = onItemRemoved;
    }
    get() {
        return this.#entries;
    }
    add(value) {
        this.#entries.push(value);
        while (this.#entries.length > this.#capacity) {
            const item = this.#entries.shift();
            if (item !== undefined) {
                this.#onItemRemoved?.(item);
            }
        }
    }
}
exports.Buffer = Buffer;
//# sourceMappingURL=Buffer.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/DefaultMap.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultMap = void 0;
/**
 * A subclass of Map whose functionality is almost the same as its parent
 * except for the fact that DefaultMap never returns undefined. It provides a
 * default value for keys that do not exist.
 */
class DefaultMap extends Map {
    /** The default value to return whenever a key is not present in the map. */
    #getDefaultValue;
    constructor(getDefaultValue, entries) {
        super(entries);
        this.#getDefaultValue = getDefaultValue;
    }
    get(key) {
        if (!this.has(key)) {
            this.set(key, this.#getDefaultValue(key));
        }
        return super.get(key);
    }
}
exports.DefaultMap = DefaultMap;
//# sourceMappingURL=DefaultMap.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/Deferred.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2022 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Deferred = void 0;
class Deferred {
    #isFinished = false;
    #promise;
    #result;
    #resolve;
    #reject;
    get isFinished() {
        return this.#isFinished;
    }
    get result() {
        if (!this.#isFinished) {
            throw new Error('Deferred is not finished yet');
        }
        return this.#result;
    }
    constructor() {
        this.#promise = new Promise((resolve, reject) => {
            this.#resolve = resolve;
            this.#reject = reject;
        });
        // Needed to avoid `Uncaught (in promise)`. The promises returned by `then`
        // and `catch` will be rejected anyway.
        this.#promise.catch((_error) => {
            // Intentionally empty.
        });
    }
    then(onFulfilled, onRejected) {
        return this.#promise.then(onFulfilled, onRejected);
    }
    catch(onRejected) {
        return this.#promise.catch(onRejected);
    }
    resolve(value) {
        this.#result = value;
        if (!this.#isFinished) {
            this.#isFinished = true;
            this.#resolve(value);
        }
    }
    reject(reason) {
        if (!this.#isFinished) {
            this.#isFinished = true;
            this.#reject(reason);
        }
    }
    finally(onFinally) {
        return this.#promise.finally(onFinally);
    }
    [Symbol.toStringTag] = 'Promise';
}
exports.Deferred = Deferred;
//# sourceMappingURL=Deferred.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/EventEmitter.js":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EventEmitter = void 0;
/**
 * Copyright 2022 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const mitt_1 = __importDefault(__webpack_require__("../../node_modules/.pnpm/mitt@3.0.1/node_modules/mitt/dist/mitt.mjs"));
class EventEmitter {
    #emitter = (0, mitt_1.default)();
    on(type, handler) {
        this.#emitter.on(type, handler);
        return this;
    }
    /**
     * Like `on` but the listener will only be fired once and then it will be removed.
     * @param event The event you'd like to listen to
     * @param handler The handler function to run when the event occurs
     * @return `this` to enable chaining method calls.
     */
    once(event, handler) {
        const onceHandler = (eventData) => {
            handler(eventData);
            this.off(event, onceHandler);
        };
        return this.on(event, onceHandler);
    }
    off(type, handler) {
        this.#emitter.off(type, handler);
        return this;
    }
    /**
     * Emits an event and call any associated listeners.
     *
     * @param event The event to emit.
     * @param eventData Any data to emit with the event.
     * @return `true` if there are any listeners, `false` otherwise.
     */
    emit(event, eventData) {
        this.#emitter.emit(event, eventData);
    }
    /**
     * Removes all listeners. If given an event argument, it will remove only
     * listeners for that event.
     * @param event - the event to remove listeners for.
     * @returns `this` to enable you to chain method calls.
     */
    removeAllListeners(event) {
        if (event) {
            this.#emitter.all.delete(event);
        }
        else {
            this.#emitter.all.clear();
        }
        return this;
    }
}
exports.EventEmitter = EventEmitter;
//# sourceMappingURL=EventEmitter.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/IdWrapper.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2022 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IdWrapper = void 0;
/**
 * Creates an object with a positive unique incrementing id.
 */
class IdWrapper {
    static #counter = 0;
    #id;
    constructor() {
        this.#id = ++IdWrapper.#counter;
    }
    get id() {
        return this.#id;
    }
}
exports.IdWrapper = IdWrapper;
//# sourceMappingURL=IdWrapper.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/Mutex.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 * Copyright 2022 The Chromium Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Mutex = void 0;
/**
 * Use Mutex class to coordinate local concurrent operations.
 * Once `acquire` promise resolves, you hold the lock and must
 * call `release` function returned by `acquire` to release the
 * lock. Failing to `release` the lock may lead to deadlocks.
 */
class Mutex {
    #locked = false;
    #acquirers = [];
    // This is FIFO.
    acquire() {
        const state = { resolved: false };
        if (this.#locked) {
            return new Promise((resolve) => {
                this.#acquirers.push(() => resolve(this.#release.bind(this, state)));
            });
        }
        this.#locked = true;
        return Promise.resolve(this.#release.bind(this, state));
    }
    #release(state) {
        if (state.resolved) {
            throw new Error('Cannot release more than once.');
        }
        state.resolved = true;
        const resolve = this.#acquirers.shift();
        if (!resolve) {
            this.#locked = false;
            return;
        }
        resolve();
    }
    async run(action) {
        const release = await this.acquire();
        try {
            // Note we need to await here because we want the await to release AFTER
            // that await happens. Returning action() will trigger the release
            // immediately which is counter to what we want.
            const result = await action();
            return result;
        }
        finally {
            release();
        }
    }
}
exports.Mutex = Mutex;
//# sourceMappingURL=Mutex.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/ProcessingQueue.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2022 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProcessingQueue = void 0;
const log_js_1 = __webpack_require__("../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js");
class ProcessingQueue {
    static LOGGER_PREFIX = `${log_js_1.LogType.debug}:queue`;
    #logger;
    #processor;
    #queue = [];
    // Flag to keep only 1 active processor.
    #isProcessing = false;
    constructor(processor, logger) {
        this.#processor = processor;
        this.#logger = logger;
    }
    add(entry, name) {
        this.#queue.push([entry, name]);
        // No need in waiting. Just initialize processor if needed.
        void this.#processIfNeeded();
    }
    async #processIfNeeded() {
        if (this.#isProcessing) {
            return;
        }
        this.#isProcessing = true;
        while (this.#queue.length > 0) {
            const arrayEntry = this.#queue.shift();
            if (!arrayEntry) {
                continue;
            }
            const [entryPromise, name] = arrayEntry;
            this.#logger?.(_a.LOGGER_PREFIX, 'Processing event:', name);
            await entryPromise
                .then((entry) => {
                if (entry.kind === 'error') {
                    this.#logger?.(log_js_1.LogType.debugError, 'Event threw before sending:', entry.error.message, entry.error.stack);
                    return;
                }
                return this.#processor(entry.value);
            })
                .catch((error) => {
                this.#logger?.(log_js_1.LogType.debugError, 'Event was not processed:', error?.message);
            });
        }
        this.#isProcessing = false;
    }
}
exports.ProcessingQueue = ProcessingQueue;
_a = ProcessingQueue;
//# sourceMappingURL=ProcessingQueue.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/assert.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.assert = assert;
/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function assert(predicate, message) {
    if (!predicate) {
        throw new Error(message ?? 'Internal assertion failed.');
    }
}
//# sourceMappingURL=assert.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/base64.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.base64ToString = base64ToString;
/**
 * Encodes a string to base64.
 *
 * Uses the native Web API if available, otherwise falls back to a NodeJS Buffer.
 * @param {string} base64Str
 * @return {string}
 */
function base64ToString(base64Str) {
    // Available only if run in a browser context.
    if ('atob' in globalThis) {
        return globalThis.atob(base64Str);
    }
    // Available only if run in a NodeJS context.
    return Buffer.from(base64Str, 'base64').toString('ascii');
}
//# sourceMappingURL=base64.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/graphemeTools.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isSingleComplexGrapheme = isSingleComplexGrapheme;
exports.isSingleGrapheme = isSingleGrapheme;
/**
 * Check if the given string is a single complex grapheme. A complex grapheme is one that
 * is made up of multiple characters.
 */
function isSingleComplexGrapheme(value) {
    return isSingleGrapheme(value) && value.length > 1;
}
/**
 * Check if the given string is a single grapheme.
 */
function isSingleGrapheme(value) {
    // Theoretically there can be some strings considered a grapheme in some locales, like
    // slovak "ch" digraph. Use english locale for consistency.
    // https://www.unicode.org/reports/tr29/#Grapheme_Cluster_Boundaries
    const segmenter = new Intl.Segmenter('en', { granularity: 'grapheme' });
    return [...segmenter.segment(value)].length === 1;
}
//# sourceMappingURL=graphemeTools.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/log.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2021 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LogType = void 0;
var LogType;
(function (LogType) {
    // keep-sorted start
    LogType["bidi"] = "bidi";
    LogType["cdp"] = "cdp";
    LogType["debug"] = "debug";
    LogType["debugError"] = "debug:error";
    LogType["debugInfo"] = "debug:info";
    LogType["debugWarn"] = "debug:warn";
    // keep-sorted end
})(LogType || (exports.LogType = LogType = {}));
//# sourceMappingURL=log.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/time.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getTimestamp = getTimestamp;
function getTimestamp() {
    // `timestamp` from the event is MonotonicTime, not real time, so
    // the best Mapper can do is to set the timestamp to the epoch time
    // of the event arrived.
    // https://chromedevtools.github.io/devtools-protocol/tot/Network/#type-MonotonicTime
    return new Date().getTime();
}
//# sourceMappingURL=time.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/unitConversions.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.inchesFromCm = inchesFromCm;
/** @return Given an input in cm, convert it to inches. */
function inchesFromCm(cm) {
    return cm / 2.54;
}
//# sourceMappingURL=unitConversions.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/urlHelpers.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*
 *  Copyright 2024 Google LLC.
 *  Copyright (c) Microsoft Corporation.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.urlMatchesAboutBlank = urlMatchesAboutBlank;
/**
 * A URL matches about:blank if its scheme is "about", its path contains a single string
 * "blank", its username and password are the empty string, and its host is null.
 * https://html.spec.whatwg.org/multipage/urls-and-fetching.html#matches-about:blank
 * @param {string} url
 * @return {boolean}
 */
function urlMatchesAboutBlank(url) {
    // An empty string is a special case, and considered to be about:blank.
    // https://html.spec.whatwg.org/multipage/nav-history-apis.html#window-open-steps
    if (url === '') {
        return true;
    }
    try {
        const parsedUrl = new URL(url);
        const schema = parsedUrl.protocol.replace(/:$/, '');
        return (schema.toLowerCase() === 'about' &&
            parsedUrl.pathname.toLowerCase() === 'blank' &&
            parsedUrl.username === '' &&
            parsedUrl.password === '' &&
            parsedUrl.host === '');
    }
    catch (err) {
        // Wrong URL considered do not match about:blank.
        if (err instanceof TypeError) {
            return false;
        }
        // Re-throw other unexpected errors.
        throw err;
    }
}
//# sourceMappingURL=urlHelpers.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/chromium-bidi@1.2.0_devtools-protocol@0.0.1402036/node_modules/chromium-bidi/lib/cjs/utils/uuid.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/**
 * Copyright 2023 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.uuidv4 = uuidv4;
function bytesToHex(bytes) {
    return bytes.reduce((str, byte) => str + byte.toString(16).padStart(2, '0'), '');
}
/**
 * Generates a random v4 UUID, as specified in RFC4122.
 *
 * Uses the native Web Crypto API if available, otherwise falls back to a
 * polyfill.
 *
 * Example: '9b1deb4d-3b7d-4bad-9bdd-2b0d7b3dcb6d'
 */
function uuidv4() {
    // Available only in secure contexts
    // https://developer.mozilla.org/en-US/docs/Web/API/Web_Crypto_API
    if ('crypto' in globalThis && 'randomUUID' in globalThis.crypto) {
        // Node with
        // https://nodejs.org/dist/latest-v20.x/docs/api/globals.html#crypto_1 or
        // secure browser context.
        return globalThis.crypto.randomUUID();
    }
    const randomValues = new Uint8Array(16);
    if ('crypto' in globalThis && 'getRandomValues' in globalThis.crypto) {
        // Node (>=18) with
        // https://nodejs.org/dist/latest-v20.x/docs/api/globals.html#crypto_1 or
        // browser.
        globalThis.crypto.getRandomValues(randomValues);
    }
    else {
        // Node (<=16) without
        // https://nodejs.org/dist/latest-v20.x/docs/api/globals.html#crypto_1.
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        (__webpack_require__("crypto").webcrypto).getRandomValues(randomValues);
    }
    // Set version (4) and variant (RFC4122) bits.
    randomValues[6] = (randomValues[6] & 0x0f) | 0x40;
    randomValues[8] = (randomValues[8] & 0x3f) | 0x80;
    return [
        bytesToHex(randomValues.subarray(0, 4)),
        bytesToHex(randomValues.subarray(4, 6)),
        bytesToHex(randomValues.subarray(6, 8)),
        bytesToHex(randomValues.subarray(8, 10)),
        bytesToHex(randomValues.subarray(10, 16)),
    ].join('-');
}
//# sourceMappingURL=uuid.js.map

/***/ }),

/***/ "../../node_modules/.pnpm/mitt@3.0.1/node_modules/mitt/dist/mitt.mjs":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(n){return{all:n=n||new Map,on:function(t,e){var i=n.get(t);i?i.push(e):n.set(t,[e])},off:function(t,e){var i=n.get(t);i&&(e?i.splice(i.indexOf(e)>>>0,1):n.set(t,[]))},emit:function(t,e){var i=n.get(t);i&&i.slice().map(function(n){n(e)}),(i=n.get("*"))&&i.slice().map(function(n){n(t,e)})}}}
//# sourceMappingURL=mitt.mjs.map


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/browsers.json":
/***/ ((module) => {

"use strict";
module.exports = /*#__PURE__*/JSON.parse('{"comment":"Do not edit this file, use utils/roll_browser.js","browsers":[{"name":"chromium","revision":"1191","installByDefault":true,"browserVersion":"141.0.7390.16"},{"name":"chromium-headless-shell","revision":"1191","installByDefault":true,"browserVersion":"141.0.7390.16"},{"name":"chromium-tip-of-tree","revision":"1369","installByDefault":false,"browserVersion":"142.0.7417.0"},{"name":"chromium-tip-of-tree-headless-shell","revision":"1369","installByDefault":false,"browserVersion":"142.0.7417.0"},{"name":"firefox","revision":"1492","installByDefault":true,"browserVersion":"142.0.1"},{"name":"firefox-beta","revision":"1487","installByDefault":false,"browserVersion":"143.0b10"},{"name":"webkit","revision":"2213","installByDefault":true,"revisionOverrides":{"debian11-x64":"2105","debian11-arm64":"2105","mac10.14":"1446","mac10.15":"1616","mac11":"1816","mac11-arm64":"1816","mac12":"2009","mac12-arm64":"2009","mac13":"2140","mac13-arm64":"2140","ubuntu20.04-x64":"2092","ubuntu20.04-arm64":"2092"},"browserVersion":"26.0"},{"name":"ffmpeg","revision":"1011","installByDefault":true,"revisionOverrides":{"mac12":"1010","mac12-arm64":"1010"}},{"name":"winldd","revision":"1007","installByDefault":false},{"name":"android","revision":"1001","installByDefault":false}]}');

/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/index.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const minimumMajorNodeVersion = 18;
const currentNodeVersion = process.versions.node;
const semver = currentNodeVersion.split('.');
const [major] = [+semver[0]];

if (major < minimumMajorNodeVersion) {
  console.error(
      'You are running Node.js ' +
      currentNodeVersion +
      '.\n' +
      `Playwright requires Node.js ${minimumMajorNodeVersion} or higher. \n` +
      'Please update your version of Node.js.'
  );
  process.exit(1);
}

module.exports = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/inprocess.js");


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/androidServerImpl.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var androidServerImpl_exports = {};
__export(androidServerImpl_exports, {
  AndroidServerLauncherImpl: () => AndroidServerLauncherImpl
});
module.exports = __toCommonJS(androidServerImpl_exports);
var import_playwrightServer = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/remote/playwrightServer.js");
var import_playwright = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/server/playwright.js");
var import_crypto = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/server/utils/crypto.js");
var import_utilsBundle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utilsBundle.js");
var import_progress = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/server/progress.js");
class AndroidServerLauncherImpl {
  async launchServer(options = {}) {
    const playwright = (0, import_playwright.createPlaywright)({ sdkLanguage: "javascript", isServer: true });
    const controller = new import_progress.ProgressController();
    let devices = await controller.run((progress) => playwright.android.devices(progress, {
      host: options.adbHost,
      port: options.adbPort,
      omitDriverInstall: options.omitDriverInstall
    }));
    if (devices.length === 0)
      throw new Error("No devices found");
    if (options.deviceSerialNumber) {
      devices = devices.filter((d) => d.serial === options.deviceSerialNumber);
      if (devices.length === 0)
        throw new Error(`No device with serial number '${options.deviceSerialNumber}' was found`);
    }
    if (devices.length > 1)
      throw new Error(`More than one device found. Please specify deviceSerialNumber`);
    const device = devices[0];
    const path = options.wsPath ? options.wsPath.startsWith("/") ? options.wsPath : `/${options.wsPath}` : `/${(0, import_crypto.createGuid)()}`;
    const server = new import_playwrightServer.PlaywrightServer({ mode: "launchServer", path, maxConnections: 1, preLaunchedAndroidDevice: device });
    const wsEndpoint = await server.listen(options.port, options.host);
    const browserServer = new import_utilsBundle.ws.EventEmitter();
    browserServer.wsEndpoint = () => wsEndpoint;
    browserServer.close = () => device.close();
    browserServer.kill = () => device.close();
    device.on("close", () => {
      server.close();
      browserServer.emit("close");
    });
    return browserServer;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/browserServerImpl.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var browserServerImpl_exports = {};
__export(browserServerImpl_exports, {
  BrowserServerLauncherImpl: () => BrowserServerLauncherImpl
});
module.exports = __toCommonJS(browserServerImpl_exports);
var import_playwrightServer = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/remote/playwrightServer.js");
var import_helper = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/server/helper.js");
var import_playwright = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/server/playwright.js");
var import_crypto = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/server/utils/crypto.js");
var import_debug = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/server/utils/debug.js");
var import_stackTrace = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/stackTrace.js");
var import_time = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/time.js");
var import_utilsBundle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utilsBundle.js");
var validatorPrimitives = __toESM(__webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/protocol/validatorPrimitives.js"));
var import_progress = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/server/progress.js");
class BrowserServerLauncherImpl {
  constructor(browserName) {
    this._browserName = browserName;
  }
  async launchServer(options = {}) {
    const playwright = (0, import_playwright.createPlaywright)({ sdkLanguage: "javascript", isServer: true });
    const metadata = { id: "", startTime: 0, endTime: 0, type: "Internal", method: "", params: {}, log: [], internal: true };
    const validatorContext = {
      tChannelImpl: (names, arg, path) => {
        throw new validatorPrimitives.ValidationError(`${path}: channels are not expected in launchServer`);
      },
      binary: "buffer",
      isUnderTest: import_debug.isUnderTest
    };
    let launchOptions = {
      ...options,
      ignoreDefaultArgs: Array.isArray(options.ignoreDefaultArgs) ? options.ignoreDefaultArgs : void 0,
      ignoreAllDefaultArgs: !!options.ignoreDefaultArgs && !Array.isArray(options.ignoreDefaultArgs),
      env: options.env ? envObjectToArray(options.env) : void 0,
      timeout: options.timeout ?? import_time.DEFAULT_PLAYWRIGHT_LAUNCH_TIMEOUT
    };
    let browser;
    try {
      const controller = new import_progress.ProgressController(metadata);
      browser = await controller.run(async (progress) => {
        if (options._userDataDir !== void 0) {
          const validator = validatorPrimitives.scheme["BrowserTypeLaunchPersistentContextParams"];
          launchOptions = validator({ ...launchOptions, userDataDir: options._userDataDir }, "", validatorContext);
          const context = await playwright[this._browserName].launchPersistentContext(progress, options._userDataDir, launchOptions);
          return context._browser;
        } else {
          const validator = validatorPrimitives.scheme["BrowserTypeLaunchParams"];
          launchOptions = validator(launchOptions, "", validatorContext);
          return await playwright[this._browserName].launch(progress, launchOptions, toProtocolLogger(options.logger));
        }
      });
    } catch (e) {
      const log = import_helper.helper.formatBrowserLogs(metadata.log);
      (0, import_stackTrace.rewriteErrorMessage)(e, `${e.message} Failed to launch browser.${log}`);
      throw e;
    }
    return this.launchServerOnExistingBrowser(browser, options);
  }
  async launchServerOnExistingBrowser(browser, options) {
    const path = options.wsPath ? options.wsPath.startsWith("/") ? options.wsPath : `/${options.wsPath}` : `/${(0, import_crypto.createGuid)()}`;
    const server = new import_playwrightServer.PlaywrightServer({ mode: options._sharedBrowser ? "launchServerShared" : "launchServer", path, maxConnections: Infinity, preLaunchedBrowser: browser, debugController: options._debugController });
    const wsEndpoint = await server.listen(options.port, options.host);
    const browserServer = new import_utilsBundle.ws.EventEmitter();
    browserServer.process = () => browser.options.browserProcess.process;
    browserServer.wsEndpoint = () => wsEndpoint;
    browserServer.close = () => browser.options.browserProcess.close();
    browserServer[Symbol.asyncDispose] = browserServer.close;
    browserServer.kill = () => browser.options.browserProcess.kill();
    browserServer._disconnectForTest = () => server.close();
    browserServer._userDataDirForTest = browser._userDataDirForTest;
    browser.options.browserProcess.onclose = (exitCode, signal) => {
      server.close();
      browserServer.emit("close", exitCode, signal);
    };
    return browserServer;
  }
}
function toProtocolLogger(logger) {
  return logger ? (direction, message) => {
    if (logger.isEnabled("protocol", "verbose"))
      logger.log("protocol", "verbose", (direction === "send" ? "SEND \u25BA " : "\u25C0 RECV ") + JSON.stringify(message), [], {});
  } : void 0;
}
function envObjectToArray(env) {
  const result = [];
  for (const name in env) {
    if (!Object.is(env[name], void 0))
      result.push({ name, value: String(env[name]) });
  }
  return result;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/accessibility.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var accessibility_exports = {};
__export(accessibility_exports, {
  Accessibility: () => Accessibility
});
module.exports = __toCommonJS(accessibility_exports);
function axNodeFromProtocol(axNode) {
  const result = {
    ...axNode,
    value: axNode.valueNumber !== void 0 ? axNode.valueNumber : axNode.valueString,
    checked: axNode.checked === "checked" ? true : axNode.checked === "unchecked" ? false : axNode.checked,
    pressed: axNode.pressed === "pressed" ? true : axNode.pressed === "released" ? false : axNode.pressed,
    children: axNode.children ? axNode.children.map(axNodeFromProtocol) : void 0
  };
  delete result.valueNumber;
  delete result.valueString;
  return result;
}
class Accessibility {
  constructor(channel) {
    this._channel = channel;
  }
  async snapshot(options = {}) {
    const root = options.root ? options.root._elementChannel : void 0;
    const result = await this._channel.accessibilitySnapshot({ interestingOnly: options.interestingOnly, root });
    return result.rootAXNode ? axNodeFromProtocol(result.rootAXNode) : null;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/android.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var android_exports = {};
__export(android_exports, {
  Android: () => Android,
  AndroidDevice: () => AndroidDevice,
  AndroidInput: () => AndroidInput,
  AndroidSocket: () => AndroidSocket,
  AndroidWebView: () => AndroidWebView
});
module.exports = __toCommonJS(android_exports);
var import_eventEmitter = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/eventEmitter.js");
var import_browserContext = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browserContext.js");
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_errors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js");
var import_events = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/events.js");
var import_waiter = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/waiter.js");
var import_timeoutSettings = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/timeoutSettings.js");
var import_rtti = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/rtti.js");
var import_time = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/time.js");
var import_timeoutRunner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/timeoutRunner.js");
var import_webSocket = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/webSocket.js");
class Android extends import_channelOwner.ChannelOwner {
  static from(android) {
    return android._object;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._timeoutSettings = new import_timeoutSettings.TimeoutSettings(this._platform);
  }
  setDefaultTimeout(timeout) {
    this._timeoutSettings.setDefaultTimeout(timeout);
  }
  async devices(options = {}) {
    const { devices } = await this._channel.devices(options);
    return devices.map((d) => AndroidDevice.from(d));
  }
  async launchServer(options = {}) {
    if (!this._serverLauncher)
      throw new Error("Launching server is not supported");
    return await this._serverLauncher.launchServer(options);
  }
  async connect(wsEndpoint, options = {}) {
    return await this._wrapApiCall(async () => {
      const deadline = options.timeout ? (0, import_time.monotonicTime)() + options.timeout : 0;
      const headers = { "x-playwright-browser": "android", ...options.headers };
      const connectParams = { wsEndpoint, headers, slowMo: options.slowMo, timeout: options.timeout || 0 };
      const connection = await (0, import_webSocket.connectOverWebSocket)(this._connection, connectParams);
      let device;
      connection.on("close", () => {
        device?._didClose();
      });
      const result = await (0, import_timeoutRunner.raceAgainstDeadline)(async () => {
        const playwright = await connection.initializePlaywright();
        if (!playwright._initializer.preConnectedAndroidDevice) {
          connection.close();
          throw new Error("Malformed endpoint. Did you use Android.launchServer method?");
        }
        device = AndroidDevice.from(playwright._initializer.preConnectedAndroidDevice);
        device._shouldCloseConnectionOnClose = true;
        device.on(import_events.Events.AndroidDevice.Close, () => connection.close());
        return device;
      }, deadline);
      if (!result.timedOut) {
        return result.result;
      } else {
        connection.close();
        throw new Error(`Timeout ${options.timeout}ms exceeded`);
      }
    });
  }
}
class AndroidDevice extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._webViews = /* @__PURE__ */ new Map();
    this._shouldCloseConnectionOnClose = false;
    this._android = parent;
    this.input = new AndroidInput(this);
    this._timeoutSettings = new import_timeoutSettings.TimeoutSettings(this._platform, parent._timeoutSettings);
    this._channel.on("webViewAdded", ({ webView }) => this._onWebViewAdded(webView));
    this._channel.on("webViewRemoved", ({ socketName }) => this._onWebViewRemoved(socketName));
    this._channel.on("close", () => this._didClose());
  }
  static from(androidDevice) {
    return androidDevice._object;
  }
  _onWebViewAdded(webView) {
    const view = new AndroidWebView(this, webView);
    this._webViews.set(webView.socketName, view);
    this.emit(import_events.Events.AndroidDevice.WebView, view);
  }
  _onWebViewRemoved(socketName) {
    const view = this._webViews.get(socketName);
    this._webViews.delete(socketName);
    if (view)
      view.emit(import_events.Events.AndroidWebView.Close);
  }
  setDefaultTimeout(timeout) {
    this._timeoutSettings.setDefaultTimeout(timeout);
  }
  serial() {
    return this._initializer.serial;
  }
  model() {
    return this._initializer.model;
  }
  webViews() {
    return [...this._webViews.values()];
  }
  async webView(selector, options) {
    const predicate = (v) => {
      if (selector.pkg)
        return v.pkg() === selector.pkg;
      if (selector.socketName)
        return v._socketName() === selector.socketName;
      return false;
    };
    const webView = [...this._webViews.values()].find(predicate);
    if (webView)
      return webView;
    return await this.waitForEvent("webview", { ...options, predicate });
  }
  async wait(selector, options = {}) {
    await this._channel.wait({ androidSelector: toSelectorChannel(selector), ...options, timeout: this._timeoutSettings.timeout(options) });
  }
  async fill(selector, text, options = {}) {
    await this._channel.fill({ androidSelector: toSelectorChannel(selector), text, ...options, timeout: this._timeoutSettings.timeout(options) });
  }
  async press(selector, key, options = {}) {
    await this.tap(selector, options);
    await this.input.press(key);
  }
  async tap(selector, options = {}) {
    await this._channel.tap({ androidSelector: toSelectorChannel(selector), ...options, timeout: this._timeoutSettings.timeout(options) });
  }
  async drag(selector, dest, options = {}) {
    await this._channel.drag({ androidSelector: toSelectorChannel(selector), dest, ...options, timeout: this._timeoutSettings.timeout(options) });
  }
  async fling(selector, direction, options = {}) {
    await this._channel.fling({ androidSelector: toSelectorChannel(selector), direction, ...options, timeout: this._timeoutSettings.timeout(options) });
  }
  async longTap(selector, options = {}) {
    await this._channel.longTap({ androidSelector: toSelectorChannel(selector), ...options, timeout: this._timeoutSettings.timeout(options) });
  }
  async pinchClose(selector, percent, options = {}) {
    await this._channel.pinchClose({ androidSelector: toSelectorChannel(selector), percent, ...options, timeout: this._timeoutSettings.timeout(options) });
  }
  async pinchOpen(selector, percent, options = {}) {
    await this._channel.pinchOpen({ androidSelector: toSelectorChannel(selector), percent, ...options, timeout: this._timeoutSettings.timeout(options) });
  }
  async scroll(selector, direction, percent, options = {}) {
    await this._channel.scroll({ androidSelector: toSelectorChannel(selector), direction, percent, ...options, timeout: this._timeoutSettings.timeout(options) });
  }
  async swipe(selector, direction, percent, options = {}) {
    await this._channel.swipe({ androidSelector: toSelectorChannel(selector), direction, percent, ...options, timeout: this._timeoutSettings.timeout(options) });
  }
  async info(selector) {
    return (await this._channel.info({ androidSelector: toSelectorChannel(selector) })).info;
  }
  async screenshot(options = {}) {
    const { binary } = await this._channel.screenshot();
    if (options.path)
      await this._platform.fs().promises.writeFile(options.path, binary);
    return binary;
  }
  async [Symbol.asyncDispose]() {
    await this.close();
  }
  async close() {
    try {
      if (this._shouldCloseConnectionOnClose)
        this._connection.close();
      else
        await this._channel.close();
    } catch (e) {
      if ((0, import_errors.isTargetClosedError)(e))
        return;
      throw e;
    }
  }
  _didClose() {
    this.emit(import_events.Events.AndroidDevice.Close, this);
  }
  async shell(command) {
    const { result } = await this._channel.shell({ command });
    return result;
  }
  async open(command) {
    return AndroidSocket.from((await this._channel.open({ command })).socket);
  }
  async installApk(file, options) {
    await this._channel.installApk({ file: await loadFile(this._platform, file), args: options && options.args });
  }
  async push(file, path, options) {
    await this._channel.push({ file: await loadFile(this._platform, file), path, mode: options ? options.mode : void 0 });
  }
  async launchBrowser(options = {}) {
    const contextOptions = await (0, import_browserContext.prepareBrowserContextParams)(this._platform, options);
    const result = await this._channel.launchBrowser(contextOptions);
    const context = import_browserContext.BrowserContext.from(result.context);
    const selectors = this._android._playwright.selectors;
    selectors._contextsForSelectors.add(context);
    context.once(import_events.Events.BrowserContext.Close, () => selectors._contextsForSelectors.delete(context));
    await context._initializeHarFromOptions(options.recordHar);
    return context;
  }
  async waitForEvent(event, optionsOrPredicate = {}) {
    return await this._wrapApiCall(async () => {
      const timeout = this._timeoutSettings.timeout(typeof optionsOrPredicate === "function" ? {} : optionsOrPredicate);
      const predicate = typeof optionsOrPredicate === "function" ? optionsOrPredicate : optionsOrPredicate.predicate;
      const waiter = import_waiter.Waiter.createForEvent(this, event);
      waiter.rejectOnTimeout(timeout, `Timeout ${timeout}ms exceeded while waiting for event "${event}"`);
      if (event !== import_events.Events.AndroidDevice.Close)
        waiter.rejectOnEvent(this, import_events.Events.AndroidDevice.Close, () => new import_errors.TargetClosedError());
      const result = await waiter.waitForEvent(this, event, predicate);
      waiter.dispose();
      return result;
    });
  }
}
class AndroidSocket extends import_channelOwner.ChannelOwner {
  static from(androidDevice) {
    return androidDevice._object;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._channel.on("data", ({ data }) => this.emit(import_events.Events.AndroidSocket.Data, data));
    this._channel.on("close", () => this.emit(import_events.Events.AndroidSocket.Close));
  }
  async write(data) {
    await this._channel.write({ data });
  }
  async close() {
    await this._channel.close();
  }
  async [Symbol.asyncDispose]() {
    await this.close();
  }
}
async function loadFile(platform, file) {
  if ((0, import_rtti.isString)(file))
    return await platform.fs().promises.readFile(file);
  return file;
}
class AndroidInput {
  constructor(device) {
    this._device = device;
  }
  async type(text) {
    await this._device._channel.inputType({ text });
  }
  async press(key) {
    await this._device._channel.inputPress({ key });
  }
  async tap(point) {
    await this._device._channel.inputTap({ point });
  }
  async swipe(from, segments, steps) {
    await this._device._channel.inputSwipe({ segments, steps });
  }
  async drag(from, to, steps) {
    await this._device._channel.inputDrag({ from, to, steps });
  }
}
function toSelectorChannel(selector) {
  const {
    checkable,
    checked,
    clazz,
    clickable,
    depth,
    desc,
    enabled,
    focusable,
    focused,
    hasChild,
    hasDescendant,
    longClickable,
    pkg,
    res,
    scrollable,
    selected,
    text
  } = selector;
  const toRegex = (value) => {
    if (value === void 0)
      return void 0;
    if ((0, import_rtti.isRegExp)(value))
      return value.source;
    return "^" + value.replace(/[|\\{}()[\]^$+*?.]/g, "\\$&").replace(/-/g, "\\x2d") + "$";
  };
  return {
    checkable,
    checked,
    clazz: toRegex(clazz),
    pkg: toRegex(pkg),
    desc: toRegex(desc),
    res: toRegex(res),
    text: toRegex(text),
    clickable,
    depth,
    enabled,
    focusable,
    focused,
    hasChild: hasChild ? { androidSelector: toSelectorChannel(hasChild.selector) } : void 0,
    hasDescendant: hasDescendant ? { androidSelector: toSelectorChannel(hasDescendant.selector), maxDepth: hasDescendant.maxDepth } : void 0,
    longClickable,
    scrollable,
    selected
  };
}
class AndroidWebView extends import_eventEmitter.EventEmitter {
  constructor(device, data) {
    super(device._platform);
    this._device = device;
    this._data = data;
  }
  pid() {
    return this._data.pid;
  }
  pkg() {
    return this._data.pkg;
  }
  _socketName() {
    return this._data.socketName;
  }
  async page() {
    if (!this._pagePromise)
      this._pagePromise = this._fetchPage();
    return await this._pagePromise;
  }
  async _fetchPage() {
    const { context } = await this._device._channel.connectToWebView({ socketName: this._data.socketName });
    return import_browserContext.BrowserContext.from(context).pages()[0];
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/artifact.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var artifact_exports = {};
__export(artifact_exports, {
  Artifact: () => Artifact
});
module.exports = __toCommonJS(artifact_exports);
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_stream = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/stream.js");
var import_fileUtils = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fileUtils.js");
class Artifact extends import_channelOwner.ChannelOwner {
  static from(channel) {
    return channel._object;
  }
  async pathAfterFinished() {
    if (this._connection.isRemote())
      throw new Error(`Path is not available when connecting remotely. Use saveAs() to save a local copy.`);
    return (await this._channel.pathAfterFinished()).value;
  }
  async saveAs(path) {
    if (!this._connection.isRemote()) {
      await this._channel.saveAs({ path });
      return;
    }
    const result = await this._channel.saveAsStream();
    const stream = import_stream.Stream.from(result.stream);
    await (0, import_fileUtils.mkdirIfNeeded)(this._platform, path);
    await new Promise((resolve, reject) => {
      stream.stream().pipe(this._platform.fs().createWriteStream(path)).on("finish", resolve).on("error", reject);
    });
  }
  async failure() {
    return (await this._channel.failure()).error || null;
  }
  async createReadStream() {
    const result = await this._channel.stream();
    const stream = import_stream.Stream.from(result.stream);
    return stream.stream();
  }
  async readIntoBuffer() {
    const stream = await this.createReadStream();
    return await new Promise((resolve, reject) => {
      const chunks = [];
      stream.on("data", (chunk) => {
        chunks.push(chunk);
      });
      stream.on("end", () => {
        resolve(Buffer.concat(chunks));
      });
      stream.on("error", reject);
    });
  }
  async cancel() {
    return await this._channel.cancel();
  }
  async delete() {
    return await this._channel.delete();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browser.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var browser_exports = {};
__export(browser_exports, {
  Browser: () => Browser
});
module.exports = __toCommonJS(browser_exports);
var import_artifact = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/artifact.js");
var import_browserContext = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browserContext.js");
var import_cdpSession = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/cdpSession.js");
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_errors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js");
var import_events = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/events.js");
var import_fileUtils = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fileUtils.js");
class Browser extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._contexts = /* @__PURE__ */ new Set();
    this._isConnected = true;
    this._shouldCloseConnectionOnClose = false;
    this._options = {};
    this._name = initializer.name;
    this._channel.on("context", ({ context }) => this._didCreateContext(import_browserContext.BrowserContext.from(context)));
    this._channel.on("close", () => this._didClose());
    this._closedPromise = new Promise((f) => this.once(import_events.Events.Browser.Disconnected, f));
  }
  static from(browser) {
    return browser._object;
  }
  browserType() {
    return this._browserType;
  }
  async newContext(options = {}) {
    return await this._innerNewContext(options, false);
  }
  async _newContextForReuse(options = {}) {
    return await this._innerNewContext(options, true);
  }
  async _disconnectFromReusedContext(reason) {
    const context = [...this._contexts].find((context2) => context2._forReuse);
    if (!context)
      return;
    await this._instrumentation.runBeforeCloseBrowserContext(context);
    for (const page of context.pages())
      page._onClose();
    context._onClose();
    await this._channel.disconnectFromReusedContext({ reason });
  }
  async _innerNewContext(options = {}, forReuse) {
    options = this._browserType._playwright.selectors._withSelectorOptions({
      ...this._browserType._playwright._defaultContextOptions,
      ...options
    });
    const contextOptions = await (0, import_browserContext.prepareBrowserContextParams)(this._platform, options);
    const response = forReuse ? await this._channel.newContextForReuse(contextOptions) : await this._channel.newContext(contextOptions);
    const context = import_browserContext.BrowserContext.from(response.context);
    if (forReuse)
      context._forReuse = true;
    if (options.logger)
      context._logger = options.logger;
    await context._initializeHarFromOptions(options.recordHar);
    await this._instrumentation.runAfterCreateBrowserContext(context);
    return context;
  }
  _connectToBrowserType(browserType, browserOptions, logger) {
    this._browserType = browserType;
    this._options = browserOptions;
    this._logger = logger;
    for (const context of this._contexts)
      this._setupBrowserContext(context);
  }
  _didCreateContext(context) {
    context._browser = this;
    this._contexts.add(context);
    if (this._browserType)
      this._setupBrowserContext(context);
  }
  _setupBrowserContext(context) {
    context._logger = this._logger;
    context.tracing._tracesDir = this._options.tracesDir;
    this._browserType._contexts.add(context);
    this._browserType._playwright.selectors._contextsForSelectors.add(context);
    context.setDefaultTimeout(this._browserType._playwright._defaultContextTimeout);
    context.setDefaultNavigationTimeout(this._browserType._playwright._defaultContextNavigationTimeout);
  }
  contexts() {
    return [...this._contexts];
  }
  version() {
    return this._initializer.version;
  }
  async newPage(options = {}) {
    return await this._wrapApiCall(async () => {
      const context = await this.newContext(options);
      const page = await context.newPage();
      page._ownedContext = context;
      context._ownerPage = page;
      return page;
    }, { title: "Create page" });
  }
  isConnected() {
    return this._isConnected;
  }
  async newBrowserCDPSession() {
    return import_cdpSession.CDPSession.from((await this._channel.newBrowserCDPSession()).session);
  }
  async _launchServer(options = {}) {
    const serverLauncher = this._browserType._serverLauncher;
    const browserImpl = this._connection.toImpl?.(this);
    if (!serverLauncher || !browserImpl)
      throw new Error("Launching server is not supported");
    return await serverLauncher.launchServerOnExistingBrowser(browserImpl, {
      _sharedBrowser: true,
      ...options
    });
  }
  async startTracing(page, options = {}) {
    this._path = options.path;
    await this._channel.startTracing({ ...options, page: page ? page._channel : void 0 });
  }
  async stopTracing() {
    const artifact = import_artifact.Artifact.from((await this._channel.stopTracing()).artifact);
    const buffer = await artifact.readIntoBuffer();
    await artifact.delete();
    if (this._path) {
      await (0, import_fileUtils.mkdirIfNeeded)(this._platform, this._path);
      await this._platform.fs().promises.writeFile(this._path, buffer);
      this._path = void 0;
    }
    return buffer;
  }
  async [Symbol.asyncDispose]() {
    await this.close();
  }
  async close(options = {}) {
    this._closeReason = options.reason;
    try {
      if (this._shouldCloseConnectionOnClose)
        this._connection.close();
      else
        await this._channel.close(options);
      await this._closedPromise;
    } catch (e) {
      if ((0, import_errors.isTargetClosedError)(e))
        return;
      throw e;
    }
  }
  _didClose() {
    this._isConnected = false;
    this.emit(import_events.Events.Browser.Disconnected, this);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browserContext.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var browserContext_exports = {};
__export(browserContext_exports, {
  BrowserContext: () => BrowserContext,
  prepareBrowserContextParams: () => prepareBrowserContextParams,
  toClientCertificatesProtocol: () => toClientCertificatesProtocol
});
module.exports = __toCommonJS(browserContext_exports);
var import_artifact = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/artifact.js");
var import_cdpSession = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/cdpSession.js");
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_clientHelper = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clientHelper.js");
var import_clock = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clock.js");
var import_consoleMessage = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/consoleMessage.js");
var import_dialog = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/dialog.js");
var import_errors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js");
var import_events = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/events.js");
var import_fetch = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fetch.js");
var import_frame = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/frame.js");
var import_harRouter = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/harRouter.js");
var network = __toESM(__webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/network.js"));
var import_page = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/page.js");
var import_tracing = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/tracing.js");
var import_waiter = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/waiter.js");
var import_webError = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/webError.js");
var import_worker = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/worker.js");
var import_timeoutSettings = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/timeoutSettings.js");
var import_fileUtils = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fileUtils.js");
var import_headers = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/headers.js");
var import_urlMatch = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/urlMatch.js");
var import_rtti = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/rtti.js");
var import_stackTrace = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/stackTrace.js");
class BrowserContext extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._pages = /* @__PURE__ */ new Set();
    this._routes = [];
    this._webSocketRoutes = [];
    // Browser is null for browser contexts created outside of normal browser, e.g. android or electron.
    this._browser = null;
    this._bindings = /* @__PURE__ */ new Map();
    this._forReuse = false;
    this._serviceWorkers = /* @__PURE__ */ new Set();
    this._harRecorders = /* @__PURE__ */ new Map();
    this._closingStatus = "none";
    this._harRouters = [];
    this._options = initializer.options;
    this._timeoutSettings = new import_timeoutSettings.TimeoutSettings(this._platform);
    this.tracing = import_tracing.Tracing.from(initializer.tracing);
    this.request = import_fetch.APIRequestContext.from(initializer.requestContext);
    this.request._timeoutSettings = this._timeoutSettings;
    this.clock = new import_clock.Clock(this);
    this._channel.on("bindingCall", ({ binding }) => this._onBinding(import_page.BindingCall.from(binding)));
    this._channel.on("close", () => this._onClose());
    this._channel.on("page", ({ page }) => this._onPage(import_page.Page.from(page)));
    this._channel.on("route", ({ route }) => this._onRoute(network.Route.from(route)));
    this._channel.on("webSocketRoute", ({ webSocketRoute }) => this._onWebSocketRoute(network.WebSocketRoute.from(webSocketRoute)));
    this._channel.on("serviceWorker", ({ worker }) => {
      const serviceWorker = import_worker.Worker.from(worker);
      serviceWorker._context = this;
      this._serviceWorkers.add(serviceWorker);
      this.emit(import_events.Events.BrowserContext.ServiceWorker, serviceWorker);
    });
    this._channel.on("console", (event) => {
      const consoleMessage = new import_consoleMessage.ConsoleMessage(this._platform, event, import_page.Page.fromNullable(event.page));
      this.emit(import_events.Events.BrowserContext.Console, consoleMessage);
      const page = consoleMessage.page();
      if (page)
        page.emit(import_events.Events.Page.Console, consoleMessage);
    });
    this._channel.on("pageError", ({ error, page }) => {
      const pageObject = import_page.Page.from(page);
      const parsedError = (0, import_errors.parseError)(error);
      this.emit(import_events.Events.BrowserContext.WebError, new import_webError.WebError(pageObject, parsedError));
      if (pageObject)
        pageObject.emit(import_events.Events.Page.PageError, parsedError);
    });
    this._channel.on("dialog", ({ dialog }) => {
      const dialogObject = import_dialog.Dialog.from(dialog);
      let hasListeners = this.emit(import_events.Events.BrowserContext.Dialog, dialogObject);
      const page = dialogObject.page();
      if (page)
        hasListeners = page.emit(import_events.Events.Page.Dialog, dialogObject) || hasListeners;
      if (!hasListeners) {
        if (dialogObject.type() === "beforeunload")
          dialog.accept({}).catch(() => {
          });
        else
          dialog.dismiss().catch(() => {
          });
      }
    });
    this._channel.on("request", ({ request, page }) => this._onRequest(network.Request.from(request), import_page.Page.fromNullable(page)));
    this._channel.on("requestFailed", ({ request, failureText, responseEndTiming, page }) => this._onRequestFailed(network.Request.from(request), responseEndTiming, failureText, import_page.Page.fromNullable(page)));
    this._channel.on("requestFinished", (params) => this._onRequestFinished(params));
    this._channel.on("response", ({ response, page }) => this._onResponse(network.Response.from(response), import_page.Page.fromNullable(page)));
    this._channel.on("recorderEvent", ({ event, data, page, code }) => {
      if (event === "actionAdded")
        this._onRecorderEventSink?.actionAdded?.(import_page.Page.from(page), data, code);
      else if (event === "actionUpdated")
        this._onRecorderEventSink?.actionUpdated?.(import_page.Page.from(page), data, code);
      else if (event === "signalAdded")
        this._onRecorderEventSink?.signalAdded?.(import_page.Page.from(page), data);
    });
    this._closedPromise = new Promise((f) => this.once(import_events.Events.BrowserContext.Close, f));
    this._setEventToSubscriptionMapping(/* @__PURE__ */ new Map([
      [import_events.Events.BrowserContext.Console, "console"],
      [import_events.Events.BrowserContext.Dialog, "dialog"],
      [import_events.Events.BrowserContext.Request, "request"],
      [import_events.Events.BrowserContext.Response, "response"],
      [import_events.Events.BrowserContext.RequestFinished, "requestFinished"],
      [import_events.Events.BrowserContext.RequestFailed, "requestFailed"]
    ]));
  }
  static from(context) {
    return context._object;
  }
  static fromNullable(context) {
    return context ? BrowserContext.from(context) : null;
  }
  async _initializeHarFromOptions(recordHar) {
    if (!recordHar)
      return;
    const defaultContent = recordHar.path.endsWith(".zip") ? "attach" : "embed";
    await this._recordIntoHAR(recordHar.path, null, {
      url: recordHar.urlFilter,
      updateContent: recordHar.content ?? (recordHar.omitContent ? "omit" : defaultContent),
      updateMode: recordHar.mode ?? "full"
    });
  }
  _onPage(page) {
    this._pages.add(page);
    this.emit(import_events.Events.BrowserContext.Page, page);
    if (page._opener && !page._opener.isClosed())
      page._opener.emit(import_events.Events.Page.Popup, page);
  }
  _onRequest(request, page) {
    this.emit(import_events.Events.BrowserContext.Request, request);
    if (page)
      page.emit(import_events.Events.Page.Request, request);
  }
  _onResponse(response, page) {
    this.emit(import_events.Events.BrowserContext.Response, response);
    if (page)
      page.emit(import_events.Events.Page.Response, response);
  }
  _onRequestFailed(request, responseEndTiming, failureText, page) {
    request._failureText = failureText || null;
    request._setResponseEndTiming(responseEndTiming);
    this.emit(import_events.Events.BrowserContext.RequestFailed, request);
    if (page)
      page.emit(import_events.Events.Page.RequestFailed, request);
  }
  _onRequestFinished(params) {
    const { responseEndTiming } = params;
    const request = network.Request.from(params.request);
    const response = network.Response.fromNullable(params.response);
    const page = import_page.Page.fromNullable(params.page);
    request._setResponseEndTiming(responseEndTiming);
    this.emit(import_events.Events.BrowserContext.RequestFinished, request);
    if (page)
      page.emit(import_events.Events.Page.RequestFinished, request);
    if (response)
      response._finishedPromise.resolve(null);
  }
  async _onRoute(route) {
    route._context = this;
    const page = route.request()._safePage();
    const routeHandlers = this._routes.slice();
    for (const routeHandler of routeHandlers) {
      if (page?._closeWasCalled || this._closingStatus !== "none")
        return;
      if (!routeHandler.matches(route.request().url()))
        continue;
      const index = this._routes.indexOf(routeHandler);
      if (index === -1)
        continue;
      if (routeHandler.willExpire())
        this._routes.splice(index, 1);
      const handled = await routeHandler.handle(route);
      if (!this._routes.length)
        this._updateInterceptionPatterns({ internal: true }).catch(() => {
        });
      if (handled)
        return;
    }
    await route._innerContinue(
      true
      /* isFallback */
    ).catch(() => {
    });
  }
  async _onWebSocketRoute(webSocketRoute) {
    const routeHandler = this._webSocketRoutes.find((route) => route.matches(webSocketRoute.url()));
    if (routeHandler)
      await routeHandler.handle(webSocketRoute);
    else
      webSocketRoute.connectToServer();
  }
  async _onBinding(bindingCall) {
    const func = this._bindings.get(bindingCall._initializer.name);
    if (!func)
      return;
    await bindingCall.call(func);
  }
  setDefaultNavigationTimeout(timeout) {
    this._timeoutSettings.setDefaultNavigationTimeout(timeout);
  }
  setDefaultTimeout(timeout) {
    this._timeoutSettings.setDefaultTimeout(timeout);
  }
  browser() {
    return this._browser;
  }
  pages() {
    return [...this._pages];
  }
  async newPage() {
    if (this._ownerPage)
      throw new Error("Please use browser.newContext()");
    return import_page.Page.from((await this._channel.newPage()).page);
  }
  async cookies(urls) {
    if (!urls)
      urls = [];
    if (urls && typeof urls === "string")
      urls = [urls];
    return (await this._channel.cookies({ urls })).cookies;
  }
  async addCookies(cookies) {
    await this._channel.addCookies({ cookies });
  }
  async clearCookies(options = {}) {
    await this._channel.clearCookies({
      name: (0, import_rtti.isString)(options.name) ? options.name : void 0,
      nameRegexSource: (0, import_rtti.isRegExp)(options.name) ? options.name.source : void 0,
      nameRegexFlags: (0, import_rtti.isRegExp)(options.name) ? options.name.flags : void 0,
      domain: (0, import_rtti.isString)(options.domain) ? options.domain : void 0,
      domainRegexSource: (0, import_rtti.isRegExp)(options.domain) ? options.domain.source : void 0,
      domainRegexFlags: (0, import_rtti.isRegExp)(options.domain) ? options.domain.flags : void 0,
      path: (0, import_rtti.isString)(options.path) ? options.path : void 0,
      pathRegexSource: (0, import_rtti.isRegExp)(options.path) ? options.path.source : void 0,
      pathRegexFlags: (0, import_rtti.isRegExp)(options.path) ? options.path.flags : void 0
    });
  }
  async grantPermissions(permissions, options) {
    await this._channel.grantPermissions({ permissions, ...options });
  }
  async clearPermissions() {
    await this._channel.clearPermissions();
  }
  async setGeolocation(geolocation) {
    await this._channel.setGeolocation({ geolocation: geolocation || void 0 });
  }
  async setExtraHTTPHeaders(headers) {
    network.validateHeaders(headers);
    await this._channel.setExtraHTTPHeaders({ headers: (0, import_headers.headersObjectToArray)(headers) });
  }
  async setOffline(offline) {
    await this._channel.setOffline({ offline });
  }
  async setHTTPCredentials(httpCredentials) {
    await this._channel.setHTTPCredentials({ httpCredentials: httpCredentials || void 0 });
  }
  async addInitScript(script, arg) {
    const source = await (0, import_clientHelper.evaluationScript)(this._platform, script, arg);
    await this._channel.addInitScript({ source });
  }
  async exposeBinding(name, callback, options = {}) {
    await this._channel.exposeBinding({ name, needsHandle: options.handle });
    this._bindings.set(name, callback);
  }
  async exposeFunction(name, callback) {
    await this._channel.exposeBinding({ name });
    const binding = (source, ...args) => callback(...args);
    this._bindings.set(name, binding);
  }
  async route(url, handler, options = {}) {
    this._routes.unshift(new network.RouteHandler(this._platform, this._options.baseURL, url, handler, options.times));
    await this._updateInterceptionPatterns({ title: "Route requests" });
  }
  async routeWebSocket(url, handler) {
    this._webSocketRoutes.unshift(new network.WebSocketRouteHandler(this._options.baseURL, url, handler));
    await this._updateWebSocketInterceptionPatterns({ title: "Route WebSockets" });
  }
  async _recordIntoHAR(har, page, options = {}) {
    const { harId } = await this._channel.harStart({
      page: page?._channel,
      options: {
        zip: har.endsWith(".zip"),
        content: options.updateContent ?? "attach",
        urlGlob: (0, import_rtti.isString)(options.url) ? options.url : void 0,
        urlRegexSource: (0, import_rtti.isRegExp)(options.url) ? options.url.source : void 0,
        urlRegexFlags: (0, import_rtti.isRegExp)(options.url) ? options.url.flags : void 0,
        mode: options.updateMode ?? "minimal"
      }
    });
    this._harRecorders.set(harId, { path: har, content: options.updateContent ?? "attach" });
  }
  async routeFromHAR(har, options = {}) {
    const localUtils = this._connection.localUtils();
    if (!localUtils)
      throw new Error("Route from har is not supported in thin clients");
    if (options.update) {
      await this._recordIntoHAR(har, null, options);
      return;
    }
    const harRouter = await import_harRouter.HarRouter.create(localUtils, har, options.notFound || "abort", { urlMatch: options.url });
    this._harRouters.push(harRouter);
    await harRouter.addContextRoute(this);
  }
  _disposeHarRouters() {
    this._harRouters.forEach((router) => router.dispose());
    this._harRouters = [];
  }
  async unrouteAll(options) {
    await this._unrouteInternal(this._routes, [], options?.behavior);
    this._disposeHarRouters();
  }
  async unroute(url, handler) {
    const removed = [];
    const remaining = [];
    for (const route of this._routes) {
      if ((0, import_urlMatch.urlMatchesEqual)(route.url, url) && (!handler || route.handler === handler))
        removed.push(route);
      else
        remaining.push(route);
    }
    await this._unrouteInternal(removed, remaining, "default");
  }
  async _unrouteInternal(removed, remaining, behavior) {
    this._routes = remaining;
    if (behavior && behavior !== "default") {
      const promises = removed.map((routeHandler) => routeHandler.stop(behavior));
      await Promise.all(promises);
    }
    await this._updateInterceptionPatterns({ title: "Unroute requests" });
  }
  async _updateInterceptionPatterns(options) {
    const patterns = network.RouteHandler.prepareInterceptionPatterns(this._routes);
    await this._wrapApiCall(() => this._channel.setNetworkInterceptionPatterns({ patterns }), options);
  }
  async _updateWebSocketInterceptionPatterns(options) {
    const patterns = network.WebSocketRouteHandler.prepareInterceptionPatterns(this._webSocketRoutes);
    await this._wrapApiCall(() => this._channel.setWebSocketInterceptionPatterns({ patterns }), options);
  }
  _effectiveCloseReason() {
    return this._closeReason || this._browser?._closeReason;
  }
  async waitForEvent(event, optionsOrPredicate = {}) {
    return await this._wrapApiCall(async () => {
      const timeout = this._timeoutSettings.timeout(typeof optionsOrPredicate === "function" ? {} : optionsOrPredicate);
      const predicate = typeof optionsOrPredicate === "function" ? optionsOrPredicate : optionsOrPredicate.predicate;
      const waiter = import_waiter.Waiter.createForEvent(this, event);
      waiter.rejectOnTimeout(timeout, `Timeout ${timeout}ms exceeded while waiting for event "${event}"`);
      if (event !== import_events.Events.BrowserContext.Close)
        waiter.rejectOnEvent(this, import_events.Events.BrowserContext.Close, () => new import_errors.TargetClosedError(this._effectiveCloseReason()));
      const result = await waiter.waitForEvent(this, event, predicate);
      waiter.dispose();
      return result;
    });
  }
  async storageState(options = {}) {
    const state = await this._channel.storageState({ indexedDB: options.indexedDB });
    if (options.path) {
      await (0, import_fileUtils.mkdirIfNeeded)(this._platform, options.path);
      await this._platform.fs().promises.writeFile(options.path, JSON.stringify(state, void 0, 2), "utf8");
    }
    return state;
  }
  backgroundPages() {
    return [];
  }
  serviceWorkers() {
    return [...this._serviceWorkers];
  }
  async newCDPSession(page) {
    if (!(page instanceof import_page.Page) && !(page instanceof import_frame.Frame))
      throw new Error("page: expected Page or Frame");
    const result = await this._channel.newCDPSession(page instanceof import_page.Page ? { page: page._channel } : { frame: page._channel });
    return import_cdpSession.CDPSession.from(result.session);
  }
  _onClose() {
    this._closingStatus = "closed";
    this._browser?._contexts.delete(this);
    this._browser?._browserType._contexts.delete(this);
    this._browser?._browserType._playwright.selectors._contextsForSelectors.delete(this);
    this._disposeHarRouters();
    this.tracing._resetStackCounter();
    this.emit(import_events.Events.BrowserContext.Close, this);
  }
  async [Symbol.asyncDispose]() {
    await this.close();
  }
  async close(options = {}) {
    if (this._closingStatus !== "none")
      return;
    this._closeReason = options.reason;
    this._closingStatus = "closing";
    await this.request.dispose(options);
    await this._instrumentation.runBeforeCloseBrowserContext(this);
    await this._wrapApiCall(async () => {
      for (const [harId, harParams] of this._harRecorders) {
        const har = await this._channel.harExport({ harId });
        const artifact = import_artifact.Artifact.from(har.artifact);
        const isCompressed = harParams.content === "attach" || harParams.path.endsWith(".zip");
        const needCompressed = harParams.path.endsWith(".zip");
        if (isCompressed && !needCompressed) {
          const localUtils = this._connection.localUtils();
          if (!localUtils)
            throw new Error("Uncompressed har is not supported in thin clients");
          await artifact.saveAs(harParams.path + ".tmp");
          await localUtils.harUnzip({ zipFile: harParams.path + ".tmp", harFile: harParams.path });
        } else {
          await artifact.saveAs(harParams.path);
        }
        await artifact.delete();
      }
    }, { internal: true });
    await this._channel.close(options);
    await this._closedPromise;
  }
  async _enableRecorder(params, eventSink) {
    if (eventSink)
      this._onRecorderEventSink = eventSink;
    await this._channel.enableRecorder(params);
  }
  async _disableRecorder() {
    this._onRecorderEventSink = void 0;
    await this._channel.disableRecorder();
  }
}
async function prepareStorageState(platform, storageState) {
  if (typeof storageState !== "string")
    return storageState;
  try {
    return JSON.parse(await platform.fs().promises.readFile(storageState, "utf8"));
  } catch (e) {
    (0, import_stackTrace.rewriteErrorMessage)(e, `Error reading storage state from ${storageState}:
` + e.message);
    throw e;
  }
}
async function prepareBrowserContextParams(platform, options) {
  if (options.videoSize && !options.videosPath)
    throw new Error(`"videoSize" option requires "videosPath" to be specified`);
  if (options.extraHTTPHeaders)
    network.validateHeaders(options.extraHTTPHeaders);
  const contextParams = {
    ...options,
    viewport: options.viewport === null ? void 0 : options.viewport,
    noDefaultViewport: options.viewport === null,
    extraHTTPHeaders: options.extraHTTPHeaders ? (0, import_headers.headersObjectToArray)(options.extraHTTPHeaders) : void 0,
    storageState: options.storageState ? await prepareStorageState(platform, options.storageState) : void 0,
    serviceWorkers: options.serviceWorkers,
    colorScheme: options.colorScheme === null ? "no-override" : options.colorScheme,
    reducedMotion: options.reducedMotion === null ? "no-override" : options.reducedMotion,
    forcedColors: options.forcedColors === null ? "no-override" : options.forcedColors,
    contrast: options.contrast === null ? "no-override" : options.contrast,
    acceptDownloads: toAcceptDownloadsProtocol(options.acceptDownloads),
    clientCertificates: await toClientCertificatesProtocol(platform, options.clientCertificates)
  };
  if (!contextParams.recordVideo && options.videosPath) {
    contextParams.recordVideo = {
      dir: options.videosPath,
      size: options.videoSize
    };
  }
  if (contextParams.recordVideo && contextParams.recordVideo.dir)
    contextParams.recordVideo.dir = platform.path().resolve(contextParams.recordVideo.dir);
  return contextParams;
}
function toAcceptDownloadsProtocol(acceptDownloads) {
  if (acceptDownloads === void 0)
    return void 0;
  if (acceptDownloads)
    return "accept";
  return "deny";
}
async function toClientCertificatesProtocol(platform, certs) {
  if (!certs)
    return void 0;
  const bufferizeContent = async (value, path) => {
    if (value)
      return value;
    if (path)
      return await platform.fs().promises.readFile(path);
  };
  return await Promise.all(certs.map(async (cert) => ({
    origin: cert.origin,
    cert: await bufferizeContent(cert.cert, cert.certPath),
    key: await bufferizeContent(cert.key, cert.keyPath),
    pfx: await bufferizeContent(cert.pfx, cert.pfxPath),
    passphrase: cert.passphrase
  })));
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browserType.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var browserType_exports = {};
__export(browserType_exports, {
  BrowserType: () => BrowserType
});
module.exports = __toCommonJS(browserType_exports);
var import_browser = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browser.js");
var import_browserContext = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browserContext.js");
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_clientHelper = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clientHelper.js");
var import_events = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/events.js");
var import_assert = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/assert.js");
var import_headers = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/headers.js");
var import_time = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/time.js");
var import_timeoutRunner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/timeoutRunner.js");
var import_webSocket = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/webSocket.js");
var import_timeoutSettings = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/timeoutSettings.js");
class BrowserType extends import_channelOwner.ChannelOwner {
  constructor() {
    super(...arguments);
    this._contexts = /* @__PURE__ */ new Set();
  }
  static from(browserType) {
    return browserType._object;
  }
  executablePath() {
    if (!this._initializer.executablePath)
      throw new Error("Browser is not supported on current platform");
    return this._initializer.executablePath;
  }
  name() {
    return this._initializer.name;
  }
  async launch(options = {}) {
    (0, import_assert.assert)(!options.userDataDir, "userDataDir option is not supported in `browserType.launch`. Use `browserType.launchPersistentContext` instead");
    (0, import_assert.assert)(!options.port, "Cannot specify a port without launching as a server.");
    const logger = options.logger || this._playwright._defaultLaunchOptions?.logger;
    options = { ...this._playwright._defaultLaunchOptions, ...options };
    const launchOptions = {
      ...options,
      ignoreDefaultArgs: Array.isArray(options.ignoreDefaultArgs) ? options.ignoreDefaultArgs : void 0,
      ignoreAllDefaultArgs: !!options.ignoreDefaultArgs && !Array.isArray(options.ignoreDefaultArgs),
      env: options.env ? (0, import_clientHelper.envObjectToArray)(options.env) : void 0,
      timeout: new import_timeoutSettings.TimeoutSettings(this._platform).launchTimeout(options)
    };
    return await this._wrapApiCall(async () => {
      const browser = import_browser.Browser.from((await this._channel.launch(launchOptions)).browser);
      browser._connectToBrowserType(this, options, logger);
      return browser;
    });
  }
  async launchServer(options = {}) {
    if (!this._serverLauncher)
      throw new Error("Launching server is not supported");
    options = { ...this._playwright._defaultLaunchOptions, ...options };
    return await this._serverLauncher.launchServer(options);
  }
  async launchPersistentContext(userDataDir, options = {}) {
    const logger = options.logger || this._playwright._defaultLaunchOptions?.logger;
    (0, import_assert.assert)(!options.port, "Cannot specify a port without launching as a server.");
    options = this._playwright.selectors._withSelectorOptions({
      ...this._playwright._defaultLaunchOptions,
      ...this._playwright._defaultContextOptions,
      ...options
    });
    const contextParams = await (0, import_browserContext.prepareBrowserContextParams)(this._platform, options);
    const persistentParams = {
      ...contextParams,
      ignoreDefaultArgs: Array.isArray(options.ignoreDefaultArgs) ? options.ignoreDefaultArgs : void 0,
      ignoreAllDefaultArgs: !!options.ignoreDefaultArgs && !Array.isArray(options.ignoreDefaultArgs),
      env: options.env ? (0, import_clientHelper.envObjectToArray)(options.env) : void 0,
      channel: options.channel,
      userDataDir: this._platform.path().isAbsolute(userDataDir) || !userDataDir ? userDataDir : this._platform.path().resolve(userDataDir),
      timeout: new import_timeoutSettings.TimeoutSettings(this._platform).launchTimeout(options)
    };
    const context = await this._wrapApiCall(async () => {
      const result = await this._channel.launchPersistentContext(persistentParams);
      const browser = import_browser.Browser.from(result.browser);
      browser._connectToBrowserType(this, options, logger);
      const context2 = import_browserContext.BrowserContext.from(result.context);
      await context2._initializeHarFromOptions(options.recordHar);
      return context2;
    });
    await this._instrumentation.runAfterCreateBrowserContext(context);
    return context;
  }
  async connect(optionsOrWsEndpoint, options) {
    if (typeof optionsOrWsEndpoint === "string")
      return await this._connect({ ...options, wsEndpoint: optionsOrWsEndpoint });
    (0, import_assert.assert)(optionsOrWsEndpoint.wsEndpoint, "options.wsEndpoint is required");
    return await this._connect(optionsOrWsEndpoint);
  }
  async _connect(params) {
    const logger = params.logger;
    return await this._wrapApiCall(async () => {
      const deadline = params.timeout ? (0, import_time.monotonicTime)() + params.timeout : 0;
      const headers = { "x-playwright-browser": this.name(), ...params.headers };
      const connectParams = {
        wsEndpoint: params.wsEndpoint,
        headers,
        exposeNetwork: params.exposeNetwork ?? params._exposeNetwork,
        slowMo: params.slowMo,
        timeout: params.timeout || 0
      };
      if (params.__testHookRedirectPortForwarding)
        connectParams.socksProxyRedirectPortForTest = params.__testHookRedirectPortForwarding;
      const connection = await (0, import_webSocket.connectOverWebSocket)(this._connection, connectParams);
      let browser;
      connection.on("close", () => {
        for (const context of browser?.contexts() || []) {
          for (const page of context.pages())
            page._onClose();
          context._onClose();
        }
        setTimeout(() => browser?._didClose(), 0);
      });
      const result = await (0, import_timeoutRunner.raceAgainstDeadline)(async () => {
        if (params.__testHookBeforeCreateBrowser)
          await params.__testHookBeforeCreateBrowser();
        const playwright = await connection.initializePlaywright();
        if (!playwright._initializer.preLaunchedBrowser) {
          connection.close();
          throw new Error("Malformed endpoint. Did you use BrowserType.launchServer method?");
        }
        playwright.selectors = this._playwright.selectors;
        browser = import_browser.Browser.from(playwright._initializer.preLaunchedBrowser);
        browser._connectToBrowserType(this, {}, logger);
        browser._shouldCloseConnectionOnClose = true;
        browser.on(import_events.Events.Browser.Disconnected, () => connection.close());
        return browser;
      }, deadline);
      if (!result.timedOut) {
        return result.result;
      } else {
        connection.close();
        throw new Error(`Timeout ${params.timeout}ms exceeded`);
      }
    });
  }
  async connectOverCDP(endpointURLOrOptions, options) {
    if (typeof endpointURLOrOptions === "string")
      return await this._connectOverCDP(endpointURLOrOptions, options);
    const endpointURL = "endpointURL" in endpointURLOrOptions ? endpointURLOrOptions.endpointURL : endpointURLOrOptions.wsEndpoint;
    (0, import_assert.assert)(endpointURL, "Cannot connect over CDP without wsEndpoint.");
    return await this.connectOverCDP(endpointURL, endpointURLOrOptions);
  }
  async _connectOverCDP(endpointURL, params = {}) {
    if (this.name() !== "chromium")
      throw new Error("Connecting over CDP is only supported in Chromium.");
    const headers = params.headers ? (0, import_headers.headersObjectToArray)(params.headers) : void 0;
    const result = await this._channel.connectOverCDP({
      endpointURL,
      headers,
      slowMo: params.slowMo,
      timeout: new import_timeoutSettings.TimeoutSettings(this._platform).timeout(params)
    });
    const browser = import_browser.Browser.from(result.browser);
    browser._connectToBrowserType(this, {}, params.logger);
    if (result.defaultContext)
      await this._instrumentation.runAfterCreateBrowserContext(import_browserContext.BrowserContext.from(result.defaultContext));
    return browser;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/cdpSession.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var cdpSession_exports = {};
__export(cdpSession_exports, {
  CDPSession: () => CDPSession
});
module.exports = __toCommonJS(cdpSession_exports);
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
class CDPSession extends import_channelOwner.ChannelOwner {
  static from(cdpSession) {
    return cdpSession._object;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._channel.on("event", ({ method, params }) => {
      this.emit(method, params);
    });
    this.on = super.on;
    this.addListener = super.addListener;
    this.off = super.removeListener;
    this.removeListener = super.removeListener;
    this.once = super.once;
  }
  async send(method, params) {
    const result = await this._channel.send({ method, params });
    return result.result;
  }
  async detach() {
    return await this._channel.detach();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var channelOwner_exports = {};
__export(channelOwner_exports, {
  ChannelOwner: () => ChannelOwner
});
module.exports = __toCommonJS(channelOwner_exports);
var import_eventEmitter = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/eventEmitter.js");
var import_validator = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/protocol/validator.js");
var import_protocolMetainfo = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/protocolMetainfo.js");
var import_clientStackTrace = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clientStackTrace.js");
var import_stackTrace = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/stackTrace.js");
class ChannelOwner extends import_eventEmitter.EventEmitter {
  constructor(parent, type, guid, initializer) {
    const connection = parent instanceof ChannelOwner ? parent._connection : parent;
    super(connection._platform);
    this._objects = /* @__PURE__ */ new Map();
    this._eventToSubscriptionMapping = /* @__PURE__ */ new Map();
    this._wasCollected = false;
    this.setMaxListeners(0);
    this._connection = connection;
    this._type = type;
    this._guid = guid;
    this._parent = parent instanceof ChannelOwner ? parent : void 0;
    this._instrumentation = this._connection._instrumentation;
    this._connection._objects.set(guid, this);
    if (this._parent) {
      this._parent._objects.set(guid, this);
      this._logger = this._parent._logger;
    }
    this._channel = this._createChannel(new import_eventEmitter.EventEmitter(connection._platform));
    this._initializer = initializer;
  }
  _setEventToSubscriptionMapping(mapping) {
    this._eventToSubscriptionMapping = mapping;
  }
  _updateSubscription(event, enabled) {
    const protocolEvent = this._eventToSubscriptionMapping.get(String(event));
    if (protocolEvent)
      this._channel.updateSubscription({ event: protocolEvent, enabled }).catch(() => {
      });
  }
  on(event, listener) {
    if (!this.listenerCount(event))
      this._updateSubscription(event, true);
    super.on(event, listener);
    return this;
  }
  addListener(event, listener) {
    if (!this.listenerCount(event))
      this._updateSubscription(event, true);
    super.addListener(event, listener);
    return this;
  }
  prependListener(event, listener) {
    if (!this.listenerCount(event))
      this._updateSubscription(event, true);
    super.prependListener(event, listener);
    return this;
  }
  off(event, listener) {
    super.off(event, listener);
    if (!this.listenerCount(event))
      this._updateSubscription(event, false);
    return this;
  }
  removeListener(event, listener) {
    super.removeListener(event, listener);
    if (!this.listenerCount(event))
      this._updateSubscription(event, false);
    return this;
  }
  _adopt(child) {
    child._parent._objects.delete(child._guid);
    this._objects.set(child._guid, child);
    child._parent = this;
  }
  _dispose(reason) {
    if (this._parent)
      this._parent._objects.delete(this._guid);
    this._connection._objects.delete(this._guid);
    this._wasCollected = reason === "gc";
    for (const object of [...this._objects.values()])
      object._dispose(reason);
    this._objects.clear();
  }
  _debugScopeState() {
    return {
      _guid: this._guid,
      objects: Array.from(this._objects.values()).map((o) => o._debugScopeState())
    };
  }
  _validatorToWireContext() {
    return {
      tChannelImpl: tChannelImplToWire,
      binary: this._connection.rawBuffers() ? "buffer" : "toBase64",
      isUnderTest: () => this._platform.isUnderTest()
    };
  }
  _createChannel(base) {
    const channel = new Proxy(base, {
      get: (obj, prop) => {
        if (typeof prop === "string") {
          const validator = (0, import_validator.maybeFindValidator)(this._type, prop, "Params");
          const { internal } = import_protocolMetainfo.methodMetainfo.get(this._type + "." + prop) || {};
          if (validator) {
            return async (params) => {
              return await this._wrapApiCall(async (apiZone) => {
                const validatedParams = validator(params, "", this._validatorToWireContext());
                if (!apiZone.internal && !apiZone.reported) {
                  apiZone.reported = true;
                  this._instrumentation.onApiCallBegin(apiZone, { type: this._type, method: prop, params });
                  logApiCall(this._platform, this._logger, `=> ${apiZone.apiName} started`);
                  return await this._connection.sendMessageToServer(this, prop, validatedParams, apiZone);
                }
                return await this._connection.sendMessageToServer(this, prop, validatedParams, { internal: true });
              }, { internal });
            };
          }
        }
        return obj[prop];
      }
    });
    channel._object = this;
    return channel;
  }
  async _wrapApiCall(func, options) {
    const logger = this._logger;
    const existingApiZone = this._platform.zones.current().data();
    if (existingApiZone)
      return await func(existingApiZone);
    const stackTrace = (0, import_clientStackTrace.captureLibraryStackTrace)(this._platform);
    const apiZone = { title: options?.title, apiName: stackTrace.apiName, frames: stackTrace.frames, internal: options?.internal ?? false, reported: false, userData: void 0, stepId: void 0 };
    try {
      const result = await this._platform.zones.current().push(apiZone).run(async () => await func(apiZone));
      if (!options?.internal) {
        logApiCall(this._platform, logger, `<= ${apiZone.apiName} succeeded`);
        this._instrumentation.onApiCallEnd(apiZone);
      }
      return result;
    } catch (e) {
      const innerError = (this._platform.showInternalStackFrames() || this._platform.isUnderTest()) && e.stack ? "\n<inner error>\n" + e.stack : "";
      if (apiZone.apiName && !apiZone.apiName.includes("<anonymous>"))
        e.message = apiZone.apiName + ": " + e.message;
      const stackFrames = "\n" + (0, import_stackTrace.stringifyStackFrames)(stackTrace.frames).join("\n") + innerError;
      if (stackFrames.trim())
        e.stack = e.message + stackFrames;
      else
        e.stack = "";
      if (!options?.internal) {
        apiZone.error = e;
        logApiCall(this._platform, logger, `<= ${apiZone.apiName} failed`);
        this._instrumentation.onApiCallEnd(apiZone);
      }
      throw e;
    }
  }
  toJSON() {
    return {
      _type: this._type,
      _guid: this._guid
    };
  }
}
function logApiCall(platform, logger, message) {
  if (logger && logger.isEnabled("api", "info"))
    logger.log("api", "info", message, [], { color: "cyan" });
  platform.log("api", message);
}
function tChannelImplToWire(names, arg, path, context) {
  if (arg._object instanceof ChannelOwner && (names === "*" || names.includes(arg._object._type)))
    return { guid: arg._object._guid };
  throw new import_validator.ValidationError(`${path}: expected channel ${names.toString()}`);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clientHelper.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var clientHelper_exports = {};
__export(clientHelper_exports, {
  addSourceUrlToScript: () => addSourceUrlToScript,
  envObjectToArray: () => envObjectToArray,
  evaluationScript: () => evaluationScript
});
module.exports = __toCommonJS(clientHelper_exports);
var import_rtti = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/rtti.js");
function envObjectToArray(env) {
  const result = [];
  for (const name in env) {
    if (!Object.is(env[name], void 0))
      result.push({ name, value: String(env[name]) });
  }
  return result;
}
async function evaluationScript(platform, fun, arg, addSourceUrl = true) {
  if (typeof fun === "function") {
    const source = fun.toString();
    const argString = Object.is(arg, void 0) ? "undefined" : JSON.stringify(arg);
    return `(${source})(${argString})`;
  }
  if (arg !== void 0)
    throw new Error("Cannot evaluate a string with arguments");
  if ((0, import_rtti.isString)(fun))
    return fun;
  if (fun.content !== void 0)
    return fun.content;
  if (fun.path !== void 0) {
    let source = await platform.fs().promises.readFile(fun.path, "utf8");
    if (addSourceUrl)
      source = addSourceUrlToScript(source, fun.path);
    return source;
  }
  throw new Error("Either path or content property must be present");
}
function addSourceUrlToScript(source, path) {
  return `${source}
//# sourceURL=${path.replace(/\n/g, "")}`;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clientInstrumentation.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var clientInstrumentation_exports = {};
__export(clientInstrumentation_exports, {
  createInstrumentation: () => createInstrumentation
});
module.exports = __toCommonJS(clientInstrumentation_exports);
function createInstrumentation() {
  const listeners = [];
  return new Proxy({}, {
    get: (obj, prop) => {
      if (typeof prop !== "string")
        return obj[prop];
      if (prop === "addListener")
        return (listener) => listeners.push(listener);
      if (prop === "removeListener")
        return (listener) => listeners.splice(listeners.indexOf(listener), 1);
      if (prop === "removeAllListeners")
        return () => listeners.splice(0, listeners.length);
      if (prop.startsWith("run")) {
        return async (...params) => {
          for (const listener of listeners)
            await listener[prop]?.(...params);
        };
      }
      if (prop.startsWith("on")) {
        return (...params) => {
          for (const listener of listeners)
            listener[prop]?.(...params);
        };
      }
      return obj[prop];
    }
  });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clientStackTrace.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var clientStackTrace_exports = {};
__export(clientStackTrace_exports, {
  captureLibraryStackTrace: () => captureLibraryStackTrace
});
module.exports = __toCommonJS(clientStackTrace_exports);
var import_stackTrace = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/stackTrace.js");
function captureLibraryStackTrace(platform) {
  const stack = (0, import_stackTrace.captureRawStack)();
  let parsedFrames = stack.map((line) => {
    const frame = (0, import_stackTrace.parseStackFrame)(line, platform.pathSeparator, platform.showInternalStackFrames());
    if (!frame || !frame.file)
      return null;
    const isPlaywrightLibrary = !!platform.coreDir && frame.file.startsWith(platform.coreDir);
    const parsed = {
      frame,
      frameText: line,
      isPlaywrightLibrary
    };
    return parsed;
  }).filter(Boolean);
  let apiName = "";
  for (let i = 0; i < parsedFrames.length - 1; i++) {
    const parsedFrame = parsedFrames[i];
    if (parsedFrame.isPlaywrightLibrary && !parsedFrames[i + 1].isPlaywrightLibrary) {
      apiName = apiName || normalizeAPIName(parsedFrame.frame.function);
      break;
    }
  }
  function normalizeAPIName(name) {
    if (!name)
      return "";
    const match = name.match(/(API|JS|CDP|[A-Z])(.*)/);
    if (!match)
      return name;
    return match[1].toLowerCase() + match[2];
  }
  const filterPrefixes = platform.boxedStackPrefixes();
  parsedFrames = parsedFrames.filter((f) => {
    if (filterPrefixes.some((prefix) => f.frame.file.startsWith(prefix)))
      return false;
    return true;
  });
  return {
    frames: parsedFrames.map((p) => p.frame),
    apiName
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clock.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var clock_exports = {};
__export(clock_exports, {
  Clock: () => Clock
});
module.exports = __toCommonJS(clock_exports);
class Clock {
  constructor(browserContext) {
    this._browserContext = browserContext;
  }
  async install(options = {}) {
    await this._browserContext._channel.clockInstall(options.time !== void 0 ? parseTime(options.time) : {});
  }
  async fastForward(ticks) {
    await this._browserContext._channel.clockFastForward(parseTicks(ticks));
  }
  async pauseAt(time) {
    await this._browserContext._channel.clockPauseAt(parseTime(time));
  }
  async resume() {
    await this._browserContext._channel.clockResume({});
  }
  async runFor(ticks) {
    await this._browserContext._channel.clockRunFor(parseTicks(ticks));
  }
  async setFixedTime(time) {
    await this._browserContext._channel.clockSetFixedTime(parseTime(time));
  }
  async setSystemTime(time) {
    await this._browserContext._channel.clockSetSystemTime(parseTime(time));
  }
}
function parseTime(time) {
  if (typeof time === "number")
    return { timeNumber: time };
  if (typeof time === "string")
    return { timeString: time };
  if (!isFinite(time.getTime()))
    throw new Error(`Invalid date: ${time}`);
  return { timeNumber: time.getTime() };
}
function parseTicks(ticks) {
  return {
    ticksNumber: typeof ticks === "number" ? ticks : void 0,
    ticksString: typeof ticks === "string" ? ticks : void 0
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/connection.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var connection_exports = {};
__export(connection_exports, {
  Connection: () => Connection
});
module.exports = __toCommonJS(connection_exports);
var import_eventEmitter = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/eventEmitter.js");
var import_android = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/android.js");
var import_artifact = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/artifact.js");
var import_browser = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browser.js");
var import_browserContext = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browserContext.js");
var import_browserType = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browserType.js");
var import_cdpSession = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/cdpSession.js");
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_clientInstrumentation = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clientInstrumentation.js");
var import_dialog = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/dialog.js");
var import_electron = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/electron.js");
var import_elementHandle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/elementHandle.js");
var import_errors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js");
var import_fetch = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fetch.js");
var import_frame = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/frame.js");
var import_jsHandle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/jsHandle.js");
var import_jsonPipe = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/jsonPipe.js");
var import_localUtils = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/localUtils.js");
var import_network = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/network.js");
var import_page = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/page.js");
var import_playwright = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/playwright.js");
var import_stream = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/stream.js");
var import_tracing = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/tracing.js");
var import_worker = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/worker.js");
var import_writableStream = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/writableStream.js");
var import_validator = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/protocol/validator.js");
var import_stackTrace = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/stackTrace.js");
class Root extends import_channelOwner.ChannelOwner {
  constructor(connection) {
    super(connection, "Root", "", {});
  }
  async initialize() {
    return import_playwright.Playwright.from((await this._channel.initialize({
      sdkLanguage: "javascript"
    })).playwright);
  }
}
class DummyChannelOwner extends import_channelOwner.ChannelOwner {
}
class Connection extends import_eventEmitter.EventEmitter {
  constructor(platform, localUtils, instrumentation, headers = []) {
    super(platform);
    this._objects = /* @__PURE__ */ new Map();
    this.onmessage = (message) => {
    };
    this._lastId = 0;
    this._callbacks = /* @__PURE__ */ new Map();
    this._isRemote = false;
    this._rawBuffers = false;
    this._tracingCount = 0;
    this._instrumentation = instrumentation || (0, import_clientInstrumentation.createInstrumentation)();
    this._localUtils = localUtils;
    this._rootObject = new Root(this);
    this.headers = headers;
  }
  markAsRemote() {
    this._isRemote = true;
  }
  isRemote() {
    return this._isRemote;
  }
  useRawBuffers() {
    this._rawBuffers = true;
  }
  rawBuffers() {
    return this._rawBuffers;
  }
  localUtils() {
    return this._localUtils;
  }
  async initializePlaywright() {
    return await this._rootObject.initialize();
  }
  getObjectWithKnownName(guid) {
    return this._objects.get(guid);
  }
  setIsTracing(isTracing) {
    if (isTracing)
      this._tracingCount++;
    else
      this._tracingCount--;
  }
  async sendMessageToServer(object, method, params, options) {
    if (this._closedError)
      throw this._closedError;
    if (object._wasCollected)
      throw new Error("The object has been collected to prevent unbounded heap growth.");
    const guid = object._guid;
    const type = object._type;
    const id = ++this._lastId;
    const message = { id, guid, method, params };
    if (this._platform.isLogEnabled("channel")) {
      this._platform.log("channel", "SEND> " + JSON.stringify(message));
    }
    const location = options.frames?.[0] ? { file: options.frames[0].file, line: options.frames[0].line, column: options.frames[0].column } : void 0;
    const metadata = { title: options.title, location, internal: options.internal, stepId: options.stepId };
    if (this._tracingCount && options.frames && type !== "LocalUtils")
      this._localUtils?.addStackToTracingNoReply({ callData: { stack: options.frames ?? [], id } }).catch(() => {
      });
    this._platform.zones.empty.run(() => this.onmessage({ ...message, metadata }));
    return await new Promise((resolve, reject) => this._callbacks.set(id, { resolve, reject, title: options.title, type, method }));
  }
  _validatorFromWireContext() {
    return {
      tChannelImpl: this._tChannelImplFromWire.bind(this),
      binary: this._rawBuffers ? "buffer" : "fromBase64",
      isUnderTest: () => this._platform.isUnderTest()
    };
  }
  dispatch(message) {
    if (this._closedError)
      return;
    const { id, guid, method, params, result, error, log } = message;
    if (id) {
      if (this._platform.isLogEnabled("channel"))
        this._platform.log("channel", "<RECV " + JSON.stringify(message));
      const callback = this._callbacks.get(id);
      if (!callback)
        throw new Error(`Cannot find command to respond: ${id}`);
      this._callbacks.delete(id);
      if (error && !result) {
        const parsedError = (0, import_errors.parseError)(error);
        (0, import_stackTrace.rewriteErrorMessage)(parsedError, parsedError.message + formatCallLog(this._platform, log));
        callback.reject(parsedError);
      } else {
        const validator2 = (0, import_validator.findValidator)(callback.type, callback.method, "Result");
        callback.resolve(validator2(result, "", this._validatorFromWireContext()));
      }
      return;
    }
    if (this._platform.isLogEnabled("channel"))
      this._platform.log("channel", "<EVENT " + JSON.stringify(message));
    if (method === "__create__") {
      this._createRemoteObject(guid, params.type, params.guid, params.initializer);
      return;
    }
    const object = this._objects.get(guid);
    if (!object)
      throw new Error(`Cannot find object to "${method}": ${guid}`);
    if (method === "__adopt__") {
      const child = this._objects.get(params.guid);
      if (!child)
        throw new Error(`Unknown new child: ${params.guid}`);
      object._adopt(child);
      return;
    }
    if (method === "__dispose__") {
      object._dispose(params.reason);
      return;
    }
    const validator = (0, import_validator.findValidator)(object._type, method, "Event");
    object._channel.emit(method, validator(params, "", this._validatorFromWireContext()));
  }
  close(cause) {
    if (this._closedError)
      return;
    this._closedError = new import_errors.TargetClosedError(cause);
    for (const callback of this._callbacks.values())
      callback.reject(this._closedError);
    this._callbacks.clear();
    this.emit("close");
  }
  _tChannelImplFromWire(names, arg, path, context) {
    if (arg && typeof arg === "object" && typeof arg.guid === "string") {
      const object = this._objects.get(arg.guid);
      if (!object)
        throw new Error(`Object with guid ${arg.guid} was not bound in the connection`);
      if (names !== "*" && !names.includes(object._type))
        throw new import_validator.ValidationError(`${path}: expected channel ${names.toString()}`);
      return object._channel;
    }
    throw new import_validator.ValidationError(`${path}: expected channel ${names.toString()}`);
  }
  _createRemoteObject(parentGuid, type, guid, initializer) {
    const parent = this._objects.get(parentGuid);
    if (!parent)
      throw new Error(`Cannot find parent object ${parentGuid} to create ${guid}`);
    let result;
    const validator = (0, import_validator.findValidator)(type, "", "Initializer");
    initializer = validator(initializer, "", this._validatorFromWireContext());
    switch (type) {
      case "Android":
        result = new import_android.Android(parent, type, guid, initializer);
        break;
      case "AndroidSocket":
        result = new import_android.AndroidSocket(parent, type, guid, initializer);
        break;
      case "AndroidDevice":
        result = new import_android.AndroidDevice(parent, type, guid, initializer);
        break;
      case "APIRequestContext":
        result = new import_fetch.APIRequestContext(parent, type, guid, initializer);
        break;
      case "Artifact":
        result = new import_artifact.Artifact(parent, type, guid, initializer);
        break;
      case "BindingCall":
        result = new import_page.BindingCall(parent, type, guid, initializer);
        break;
      case "Browser":
        result = new import_browser.Browser(parent, type, guid, initializer);
        break;
      case "BrowserContext":
        result = new import_browserContext.BrowserContext(parent, type, guid, initializer);
        break;
      case "BrowserType":
        result = new import_browserType.BrowserType(parent, type, guid, initializer);
        break;
      case "CDPSession":
        result = new import_cdpSession.CDPSession(parent, type, guid, initializer);
        break;
      case "Dialog":
        result = new import_dialog.Dialog(parent, type, guid, initializer);
        break;
      case "Electron":
        result = new import_electron.Electron(parent, type, guid, initializer);
        break;
      case "ElectronApplication":
        result = new import_electron.ElectronApplication(parent, type, guid, initializer);
        break;
      case "ElementHandle":
        result = new import_elementHandle.ElementHandle(parent, type, guid, initializer);
        break;
      case "Frame":
        result = new import_frame.Frame(parent, type, guid, initializer);
        break;
      case "JSHandle":
        result = new import_jsHandle.JSHandle(parent, type, guid, initializer);
        break;
      case "JsonPipe":
        result = new import_jsonPipe.JsonPipe(parent, type, guid, initializer);
        break;
      case "LocalUtils":
        result = new import_localUtils.LocalUtils(parent, type, guid, initializer);
        if (!this._localUtils)
          this._localUtils = result;
        break;
      case "Page":
        result = new import_page.Page(parent, type, guid, initializer);
        break;
      case "Playwright":
        result = new import_playwright.Playwright(parent, type, guid, initializer);
        break;
      case "Request":
        result = new import_network.Request(parent, type, guid, initializer);
        break;
      case "Response":
        result = new import_network.Response(parent, type, guid, initializer);
        break;
      case "Route":
        result = new import_network.Route(parent, type, guid, initializer);
        break;
      case "Stream":
        result = new import_stream.Stream(parent, type, guid, initializer);
        break;
      case "SocksSupport":
        result = new DummyChannelOwner(parent, type, guid, initializer);
        break;
      case "Tracing":
        result = new import_tracing.Tracing(parent, type, guid, initializer);
        break;
      case "WebSocket":
        result = new import_network.WebSocket(parent, type, guid, initializer);
        break;
      case "WebSocketRoute":
        result = new import_network.WebSocketRoute(parent, type, guid, initializer);
        break;
      case "Worker":
        result = new import_worker.Worker(parent, type, guid, initializer);
        break;
      case "WritableStream":
        result = new import_writableStream.WritableStream(parent, type, guid, initializer);
        break;
      default:
        throw new Error("Missing type " + type);
    }
    return result;
  }
}
function formatCallLog(platform, log) {
  if (!log || !log.some((l) => !!l))
    return "";
  return `
Call log:
${platform.colors.dim(log.join("\n"))}
`;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/consoleMessage.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var consoleMessage_exports = {};
__export(consoleMessage_exports, {
  ConsoleMessage: () => ConsoleMessage
});
module.exports = __toCommonJS(consoleMessage_exports);
var import_jsHandle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/jsHandle.js");
class ConsoleMessage {
  constructor(platform, event, page) {
    this._page = page;
    this._event = event;
    if (platform.inspectCustom)
      this[platform.inspectCustom] = () => this._inspect();
  }
  page() {
    return this._page;
  }
  type() {
    return this._event.type;
  }
  text() {
    return this._event.text;
  }
  args() {
    return this._event.args.map(import_jsHandle.JSHandle.from);
  }
  location() {
    return this._event.location;
  }
  _inspect() {
    return this.text();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/coverage.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var coverage_exports = {};
__export(coverage_exports, {
  Coverage: () => Coverage
});
module.exports = __toCommonJS(coverage_exports);
class Coverage {
  constructor(channel) {
    this._channel = channel;
  }
  async startJSCoverage(options = {}) {
    await this._channel.startJSCoverage(options);
  }
  async stopJSCoverage() {
    return (await this._channel.stopJSCoverage()).entries;
  }
  async startCSSCoverage(options = {}) {
    await this._channel.startCSSCoverage(options);
  }
  async stopCSSCoverage() {
    return (await this._channel.stopCSSCoverage()).entries;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/dialog.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var dialog_exports = {};
__export(dialog_exports, {
  Dialog: () => Dialog
});
module.exports = __toCommonJS(dialog_exports);
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_page = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/page.js");
class Dialog extends import_channelOwner.ChannelOwner {
  static from(dialog) {
    return dialog._object;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._page = import_page.Page.fromNullable(initializer.page);
  }
  page() {
    return this._page;
  }
  type() {
    return this._initializer.type;
  }
  message() {
    return this._initializer.message;
  }
  defaultValue() {
    return this._initializer.defaultValue;
  }
  async accept(promptText) {
    await this._channel.accept({ promptText });
  }
  async dismiss() {
    await this._channel.dismiss();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/download.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var download_exports = {};
__export(download_exports, {
  Download: () => Download
});
module.exports = __toCommonJS(download_exports);
class Download {
  constructor(page, url, suggestedFilename, artifact) {
    this._page = page;
    this._url = url;
    this._suggestedFilename = suggestedFilename;
    this._artifact = artifact;
  }
  page() {
    return this._page;
  }
  url() {
    return this._url;
  }
  suggestedFilename() {
    return this._suggestedFilename;
  }
  async path() {
    return await this._artifact.pathAfterFinished();
  }
  async saveAs(path) {
    return await this._artifact.saveAs(path);
  }
  async failure() {
    return await this._artifact.failure();
  }
  async createReadStream() {
    return await this._artifact.createReadStream();
  }
  async cancel() {
    return await this._artifact.cancel();
  }
  async delete() {
    return await this._artifact.delete();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/electron.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var electron_exports = {};
__export(electron_exports, {
  Electron: () => Electron,
  ElectronApplication: () => ElectronApplication
});
module.exports = __toCommonJS(electron_exports);
var import_browserContext = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browserContext.js");
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_clientHelper = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clientHelper.js");
var import_consoleMessage = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/consoleMessage.js");
var import_errors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js");
var import_events = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/events.js");
var import_jsHandle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/jsHandle.js");
var import_waiter = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/waiter.js");
var import_timeoutSettings = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/timeoutSettings.js");
class Electron extends import_channelOwner.ChannelOwner {
  static from(electron) {
    return electron._object;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
  }
  async launch(options = {}) {
    options = this._playwright.selectors._withSelectorOptions(options);
    const params = {
      ...await (0, import_browserContext.prepareBrowserContextParams)(this._platform, options),
      env: (0, import_clientHelper.envObjectToArray)(options.env ? options.env : this._platform.env),
      tracesDir: options.tracesDir,
      timeout: new import_timeoutSettings.TimeoutSettings(this._platform).launchTimeout(options)
    };
    const app = ElectronApplication.from((await this._channel.launch(params)).electronApplication);
    this._playwright.selectors._contextsForSelectors.add(app._context);
    app.once(import_events.Events.ElectronApplication.Close, () => this._playwright.selectors._contextsForSelectors.delete(app._context));
    await app._context._initializeHarFromOptions(options.recordHar);
    app._context.tracing._tracesDir = options.tracesDir;
    return app;
  }
}
class ElectronApplication extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._windows = /* @__PURE__ */ new Set();
    this._timeoutSettings = new import_timeoutSettings.TimeoutSettings(this._platform);
    this._context = import_browserContext.BrowserContext.from(initializer.context);
    for (const page of this._context._pages)
      this._onPage(page);
    this._context.on(import_events.Events.BrowserContext.Page, (page) => this._onPage(page));
    this._channel.on("close", () => {
      this.emit(import_events.Events.ElectronApplication.Close);
    });
    this._channel.on("console", (event) => this.emit(import_events.Events.ElectronApplication.Console, new import_consoleMessage.ConsoleMessage(this._platform, event, null)));
    this._setEventToSubscriptionMapping(/* @__PURE__ */ new Map([
      [import_events.Events.ElectronApplication.Console, "console"]
    ]));
  }
  static from(electronApplication) {
    return electronApplication._object;
  }
  process() {
    return this._connection.toImpl?.(this)?.process();
  }
  _onPage(page) {
    this._windows.add(page);
    this.emit(import_events.Events.ElectronApplication.Window, page);
    page.once(import_events.Events.Page.Close, () => this._windows.delete(page));
  }
  windows() {
    return [...this._windows];
  }
  async firstWindow(options) {
    if (this._windows.size)
      return this._windows.values().next().value;
    return await this.waitForEvent("window", options);
  }
  context() {
    return this._context;
  }
  async [Symbol.asyncDispose]() {
    await this.close();
  }
  async close() {
    try {
      await this._context.close();
    } catch (e) {
      if ((0, import_errors.isTargetClosedError)(e))
        return;
      throw e;
    }
  }
  async waitForEvent(event, optionsOrPredicate = {}) {
    return await this._wrapApiCall(async () => {
      const timeout = this._timeoutSettings.timeout(typeof optionsOrPredicate === "function" ? {} : optionsOrPredicate);
      const predicate = typeof optionsOrPredicate === "function" ? optionsOrPredicate : optionsOrPredicate.predicate;
      const waiter = import_waiter.Waiter.createForEvent(this, event);
      waiter.rejectOnTimeout(timeout, `Timeout ${timeout}ms exceeded while waiting for event "${event}"`);
      if (event !== import_events.Events.ElectronApplication.Close)
        waiter.rejectOnEvent(this, import_events.Events.ElectronApplication.Close, () => new import_errors.TargetClosedError());
      const result = await waiter.waitForEvent(this, event, predicate);
      waiter.dispose();
      return result;
    });
  }
  async browserWindow(page) {
    const result = await this._channel.browserWindow({ page: page._channel });
    return import_jsHandle.JSHandle.from(result.handle);
  }
  async evaluate(pageFunction, arg) {
    const result = await this._channel.evaluateExpression({ expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: (0, import_jsHandle.serializeArgument)(arg) });
    return (0, import_jsHandle.parseResult)(result.value);
  }
  async evaluateHandle(pageFunction, arg) {
    const result = await this._channel.evaluateExpressionHandle({ expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: (0, import_jsHandle.serializeArgument)(arg) });
    return import_jsHandle.JSHandle.from(result.handle);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/elementHandle.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var elementHandle_exports = {};
__export(elementHandle_exports, {
  ElementHandle: () => ElementHandle,
  convertInputFiles: () => convertInputFiles,
  convertSelectOptionValues: () => convertSelectOptionValues,
  determineScreenshotType: () => determineScreenshotType
});
module.exports = __toCommonJS(elementHandle_exports);
var import_frame = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/frame.js");
var import_jsHandle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/jsHandle.js");
var import_assert = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/assert.js");
var import_fileUtils = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fileUtils.js");
var import_rtti = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/rtti.js");
var import_writableStream = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/writableStream.js");
var import_mimeType = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/mimeType.js");
class ElementHandle extends import_jsHandle.JSHandle {
  static from(handle) {
    return handle._object;
  }
  static fromNullable(handle) {
    return handle ? ElementHandle.from(handle) : null;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._frame = parent;
    this._elementChannel = this._channel;
  }
  asElement() {
    return this;
  }
  async ownerFrame() {
    return import_frame.Frame.fromNullable((await this._elementChannel.ownerFrame()).frame);
  }
  async contentFrame() {
    return import_frame.Frame.fromNullable((await this._elementChannel.contentFrame()).frame);
  }
  async getAttribute(name) {
    const value = (await this._elementChannel.getAttribute({ name })).value;
    return value === void 0 ? null : value;
  }
  async inputValue() {
    return (await this._elementChannel.inputValue()).value;
  }
  async textContent() {
    const value = (await this._elementChannel.textContent()).value;
    return value === void 0 ? null : value;
  }
  async innerText() {
    return (await this._elementChannel.innerText()).value;
  }
  async innerHTML() {
    return (await this._elementChannel.innerHTML()).value;
  }
  async isChecked() {
    return (await this._elementChannel.isChecked()).value;
  }
  async isDisabled() {
    return (await this._elementChannel.isDisabled()).value;
  }
  async isEditable() {
    return (await this._elementChannel.isEditable()).value;
  }
  async isEnabled() {
    return (await this._elementChannel.isEnabled()).value;
  }
  async isHidden() {
    return (await this._elementChannel.isHidden()).value;
  }
  async isVisible() {
    return (await this._elementChannel.isVisible()).value;
  }
  async dispatchEvent(type, eventInit = {}) {
    await this._elementChannel.dispatchEvent({ type, eventInit: (0, import_jsHandle.serializeArgument)(eventInit) });
  }
  async scrollIntoViewIfNeeded(options = {}) {
    await this._elementChannel.scrollIntoViewIfNeeded({ ...options, timeout: this._frame._timeout(options) });
  }
  async hover(options = {}) {
    await this._elementChannel.hover({ ...options, timeout: this._frame._timeout(options) });
  }
  async click(options = {}) {
    return await this._elementChannel.click({ ...options, timeout: this._frame._timeout(options) });
  }
  async dblclick(options = {}) {
    return await this._elementChannel.dblclick({ ...options, timeout: this._frame._timeout(options) });
  }
  async tap(options = {}) {
    return await this._elementChannel.tap({ ...options, timeout: this._frame._timeout(options) });
  }
  async selectOption(values, options = {}) {
    const result = await this._elementChannel.selectOption({ ...convertSelectOptionValues(values), ...options, timeout: this._frame._timeout(options) });
    return result.values;
  }
  async fill(value, options = {}) {
    return await this._elementChannel.fill({ value, ...options, timeout: this._frame._timeout(options) });
  }
  async selectText(options = {}) {
    await this._elementChannel.selectText({ ...options, timeout: this._frame._timeout(options) });
  }
  async setInputFiles(files, options = {}) {
    const frame = await this.ownerFrame();
    if (!frame)
      throw new Error("Cannot set input files to detached element");
    const converted = await convertInputFiles(this._platform, files, frame.page().context());
    await this._elementChannel.setInputFiles({ ...converted, ...options, timeout: this._frame._timeout(options) });
  }
  async focus() {
    await this._elementChannel.focus();
  }
  async type(text, options = {}) {
    await this._elementChannel.type({ text, ...options, timeout: this._frame._timeout(options) });
  }
  async press(key, options = {}) {
    await this._elementChannel.press({ key, ...options, timeout: this._frame._timeout(options) });
  }
  async check(options = {}) {
    return await this._elementChannel.check({ ...options, timeout: this._frame._timeout(options) });
  }
  async uncheck(options = {}) {
    return await this._elementChannel.uncheck({ ...options, timeout: this._frame._timeout(options) });
  }
  async setChecked(checked, options) {
    if (checked)
      await this.check(options);
    else
      await this.uncheck(options);
  }
  async boundingBox() {
    const value = (await this._elementChannel.boundingBox()).value;
    return value === void 0 ? null : value;
  }
  async screenshot(options = {}) {
    const mask = options.mask;
    const copy = { ...options, mask: void 0, timeout: this._frame._timeout(options) };
    if (!copy.type)
      copy.type = determineScreenshotType(options);
    if (mask) {
      copy.mask = mask.map((locator) => ({
        frame: locator._frame._channel,
        selector: locator._selector
      }));
    }
    const result = await this._elementChannel.screenshot(copy);
    if (options.path) {
      await (0, import_fileUtils.mkdirIfNeeded)(this._platform, options.path);
      await this._platform.fs().promises.writeFile(options.path, result.binary);
    }
    return result.binary;
  }
  async $(selector) {
    return ElementHandle.fromNullable((await this._elementChannel.querySelector({ selector })).element);
  }
  async $$(selector) {
    const result = await this._elementChannel.querySelectorAll({ selector });
    return result.elements.map((h) => ElementHandle.from(h));
  }
  async $eval(selector, pageFunction, arg) {
    const result = await this._elementChannel.evalOnSelector({ selector, expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: (0, import_jsHandle.serializeArgument)(arg) });
    return (0, import_jsHandle.parseResult)(result.value);
  }
  async $$eval(selector, pageFunction, arg) {
    const result = await this._elementChannel.evalOnSelectorAll({ selector, expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: (0, import_jsHandle.serializeArgument)(arg) });
    return (0, import_jsHandle.parseResult)(result.value);
  }
  async waitForElementState(state, options = {}) {
    return await this._elementChannel.waitForElementState({ state, ...options, timeout: this._frame._timeout(options) });
  }
  async waitForSelector(selector, options = {}) {
    const result = await this._elementChannel.waitForSelector({ selector, ...options, timeout: this._frame._timeout(options) });
    return ElementHandle.fromNullable(result.element);
  }
}
function convertSelectOptionValues(values) {
  if (values === null)
    return {};
  if (!Array.isArray(values))
    values = [values];
  if (!values.length)
    return {};
  for (let i = 0; i < values.length; i++)
    (0, import_assert.assert)(values[i] !== null, `options[${i}]: expected object, got null`);
  if (values[0] instanceof ElementHandle)
    return { elements: values.map((v) => v._elementChannel) };
  if ((0, import_rtti.isString)(values[0]))
    return { options: values.map((valueOrLabel) => ({ valueOrLabel })) };
  return { options: values };
}
function filePayloadExceedsSizeLimit(payloads) {
  return payloads.reduce((size, item) => size + (item.buffer ? item.buffer.byteLength : 0), 0) >= import_fileUtils.fileUploadSizeLimit;
}
async function resolvePathsAndDirectoryForInputFiles(platform, items) {
  let localPaths;
  let localDirectory;
  for (const item of items) {
    const stat = await platform.fs().promises.stat(item);
    if (stat.isDirectory()) {
      if (localDirectory)
        throw new Error("Multiple directories are not supported");
      localDirectory = platform.path().resolve(item);
    } else {
      localPaths ??= [];
      localPaths.push(platform.path().resolve(item));
    }
  }
  if (localPaths?.length && localDirectory)
    throw new Error("File paths must be all files or a single directory");
  return [localPaths, localDirectory];
}
async function convertInputFiles(platform, files, context) {
  const items = Array.isArray(files) ? files.slice() : [files];
  if (items.some((item) => typeof item === "string")) {
    if (!items.every((item) => typeof item === "string"))
      throw new Error("File paths cannot be mixed with buffers");
    const [localPaths, localDirectory] = await resolvePathsAndDirectoryForInputFiles(platform, items);
    if (context._connection.isRemote()) {
      const files2 = localDirectory ? (await platform.fs().promises.readdir(localDirectory, { withFileTypes: true, recursive: true })).filter((f) => f.isFile()).map((f) => platform.path().join(f.path, f.name)) : localPaths;
      const { writableStreams, rootDir } = await context._wrapApiCall(async () => context._channel.createTempFiles({
        rootDirName: localDirectory ? platform.path().basename(localDirectory) : void 0,
        items: await Promise.all(files2.map(async (file) => {
          const lastModifiedMs = (await platform.fs().promises.stat(file)).mtimeMs;
          return {
            name: localDirectory ? platform.path().relative(localDirectory, file) : platform.path().basename(file),
            lastModifiedMs
          };
        }))
      }), { internal: true });
      for (let i = 0; i < files2.length; i++) {
        const writable = import_writableStream.WritableStream.from(writableStreams[i]);
        await platform.streamFile(files2[i], writable.stream());
      }
      return {
        directoryStream: rootDir,
        streams: localDirectory ? void 0 : writableStreams
      };
    }
    return {
      localPaths,
      localDirectory
    };
  }
  const payloads = items;
  if (filePayloadExceedsSizeLimit(payloads))
    throw new Error("Cannot set buffer larger than 50Mb, please write it to a file and pass its path instead.");
  return { payloads };
}
function determineScreenshotType(options) {
  if (options.path) {
    const mimeType = (0, import_mimeType.getMimeTypeForPath)(options.path);
    if (mimeType === "image/png")
      return "png";
    else if (mimeType === "image/jpeg")
      return "jpeg";
    throw new Error(`path: unsupported mime type "${mimeType}"`);
  }
  return options.type;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var errors_exports = {};
__export(errors_exports, {
  TargetClosedError: () => TargetClosedError,
  TimeoutError: () => TimeoutError,
  isTargetClosedError: () => isTargetClosedError,
  parseError: () => parseError,
  serializeError: () => serializeError
});
module.exports = __toCommonJS(errors_exports);
var import_serializers = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/protocol/serializers.js");
var import_rtti = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/rtti.js");
class TimeoutError extends Error {
  constructor(message) {
    super(message);
    this.name = "TimeoutError";
  }
}
class TargetClosedError extends Error {
  constructor(cause) {
    super(cause || "Target page, context or browser has been closed");
  }
}
function isTargetClosedError(error) {
  return error instanceof TargetClosedError;
}
function serializeError(e) {
  if ((0, import_rtti.isError)(e))
    return { error: { message: e.message, stack: e.stack, name: e.name } };
  return { value: (0, import_serializers.serializeValue)(e, (value) => ({ fallThrough: value })) };
}
function parseError(error) {
  if (!error.error) {
    if (error.value === void 0)
      throw new Error("Serialized error must have either an error or a value");
    return (0, import_serializers.parseSerializedValue)(error.value, void 0);
  }
  if (error.error.name === "TimeoutError") {
    const e2 = new TimeoutError(error.error.message);
    e2.stack = error.error.stack || "";
    return e2;
  }
  if (error.error.name === "TargetClosedError") {
    const e2 = new TargetClosedError(error.error.message);
    e2.stack = error.error.stack || "";
    return e2;
  }
  const e = new Error(error.error.message);
  e.stack = error.error.stack || "";
  e.name = error.error.name;
  return e;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/eventEmitter.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var eventEmitter_exports = {};
__export(eventEmitter_exports, {
  EventEmitter: () => EventEmitter
});
module.exports = __toCommonJS(eventEmitter_exports);
class EventEmitter {
  constructor(platform) {
    this._events = void 0;
    this._eventsCount = 0;
    this._maxListeners = void 0;
    this._pendingHandlers = /* @__PURE__ */ new Map();
    this._platform = platform;
    if (this._events === void 0 || this._events === Object.getPrototypeOf(this)._events) {
      this._events = /* @__PURE__ */ Object.create(null);
      this._eventsCount = 0;
    }
    this._maxListeners = this._maxListeners || void 0;
    this.on = this.addListener;
    this.off = this.removeListener;
  }
  setMaxListeners(n) {
    if (typeof n !== "number" || n < 0 || Number.isNaN(n))
      throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + n + ".");
    this._maxListeners = n;
    return this;
  }
  getMaxListeners() {
    return this._maxListeners === void 0 ? this._platform.defaultMaxListeners() : this._maxListeners;
  }
  emit(type, ...args) {
    const events = this._events;
    if (events === void 0)
      return false;
    const handler = events?.[type];
    if (handler === void 0)
      return false;
    if (typeof handler === "function") {
      this._callHandler(type, handler, args);
    } else {
      const len = handler.length;
      const listeners = handler.slice();
      for (let i = 0; i < len; ++i)
        this._callHandler(type, listeners[i], args);
    }
    return true;
  }
  _callHandler(type, handler, args) {
    const promise = Reflect.apply(handler, this, args);
    if (!(promise instanceof Promise))
      return;
    let set = this._pendingHandlers.get(type);
    if (!set) {
      set = /* @__PURE__ */ new Set();
      this._pendingHandlers.set(type, set);
    }
    set.add(promise);
    promise.catch((e) => {
      if (this._rejectionHandler)
        this._rejectionHandler(e);
      else
        throw e;
    }).finally(() => set.delete(promise));
  }
  addListener(type, listener) {
    return this._addListener(type, listener, false);
  }
  on(type, listener) {
    return this._addListener(type, listener, false);
  }
  _addListener(type, listener, prepend) {
    checkListener(listener);
    let events = this._events;
    let existing;
    if (events === void 0) {
      events = this._events = /* @__PURE__ */ Object.create(null);
      this._eventsCount = 0;
    } else {
      if (events.newListener !== void 0) {
        this.emit("newListener", type, unwrapListener(listener));
        events = this._events;
      }
      existing = events[type];
    }
    if (existing === void 0) {
      existing = events[type] = listener;
      ++this._eventsCount;
    } else {
      if (typeof existing === "function") {
        existing = events[type] = prepend ? [listener, existing] : [existing, listener];
      } else if (prepend) {
        existing.unshift(listener);
      } else {
        existing.push(listener);
      }
      const m = this.getMaxListeners();
      if (m > 0 && existing.length > m && !existing.warned) {
        existing.warned = true;
        const w = new Error("Possible EventEmitter memory leak detected. " + existing.length + " " + String(type) + " listeners added. Use emitter.setMaxListeners() to increase limit");
        w.name = "MaxListenersExceededWarning";
        w.emitter = this;
        w.type = type;
        w.count = existing.length;
        if (!this._platform.isUnderTest()) {
          console.warn(w);
        }
      }
    }
    return this;
  }
  prependListener(type, listener) {
    return this._addListener(type, listener, true);
  }
  once(type, listener) {
    checkListener(listener);
    this.on(type, new OnceWrapper(this, type, listener).wrapperFunction);
    return this;
  }
  prependOnceListener(type, listener) {
    checkListener(listener);
    this.prependListener(type, new OnceWrapper(this, type, listener).wrapperFunction);
    return this;
  }
  removeListener(type, listener) {
    checkListener(listener);
    const events = this._events;
    if (events === void 0)
      return this;
    const list = events[type];
    if (list === void 0)
      return this;
    if (list === listener || list.listener === listener) {
      if (--this._eventsCount === 0) {
        this._events = /* @__PURE__ */ Object.create(null);
      } else {
        delete events[type];
        if (events.removeListener)
          this.emit("removeListener", type, list.listener ?? listener);
      }
    } else if (typeof list !== "function") {
      let position = -1;
      let originalListener;
      for (let i = list.length - 1; i >= 0; i--) {
        if (list[i] === listener || wrappedListener(list[i]) === listener) {
          originalListener = wrappedListener(list[i]);
          position = i;
          break;
        }
      }
      if (position < 0)
        return this;
      if (position === 0)
        list.shift();
      else
        list.splice(position, 1);
      if (list.length === 1)
        events[type] = list[0];
      if (events.removeListener !== void 0)
        this.emit("removeListener", type, originalListener || listener);
    }
    return this;
  }
  off(type, listener) {
    return this.removeListener(type, listener);
  }
  removeAllListeners(type, options) {
    this._removeAllListeners(type);
    if (!options)
      return this;
    if (options.behavior === "wait") {
      const errors = [];
      this._rejectionHandler = (error) => errors.push(error);
      return this._waitFor(type).then(() => {
        if (errors.length)
          throw errors[0];
      });
    }
    if (options.behavior === "ignoreErrors")
      this._rejectionHandler = () => {
      };
    return Promise.resolve();
  }
  _removeAllListeners(type) {
    const events = this._events;
    if (!events)
      return;
    if (!events.removeListener) {
      if (type === void 0) {
        this._events = /* @__PURE__ */ Object.create(null);
        this._eventsCount = 0;
      } else if (events[type] !== void 0) {
        if (--this._eventsCount === 0)
          this._events = /* @__PURE__ */ Object.create(null);
        else
          delete events[type];
      }
      return;
    }
    if (type === void 0) {
      const keys = Object.keys(events);
      let key;
      for (let i = 0; i < keys.length; ++i) {
        key = keys[i];
        if (key === "removeListener")
          continue;
        this._removeAllListeners(key);
      }
      this._removeAllListeners("removeListener");
      this._events = /* @__PURE__ */ Object.create(null);
      this._eventsCount = 0;
      return;
    }
    const listeners = events[type];
    if (typeof listeners === "function") {
      this.removeListener(type, listeners);
    } else if (listeners !== void 0) {
      for (let i = listeners.length - 1; i >= 0; i--)
        this.removeListener(type, listeners[i]);
    }
  }
  listeners(type) {
    return this._listeners(this, type, true);
  }
  rawListeners(type) {
    return this._listeners(this, type, false);
  }
  listenerCount(type) {
    const events = this._events;
    if (events !== void 0) {
      const listener = events[type];
      if (typeof listener === "function")
        return 1;
      if (listener !== void 0)
        return listener.length;
    }
    return 0;
  }
  eventNames() {
    return this._eventsCount > 0 && this._events ? Reflect.ownKeys(this._events) : [];
  }
  async _waitFor(type) {
    let promises = [];
    if (type) {
      promises = [...this._pendingHandlers.get(type) || []];
    } else {
      promises = [];
      for (const [, pending] of this._pendingHandlers)
        promises.push(...pending);
    }
    await Promise.all(promises);
  }
  _listeners(target, type, unwrap) {
    const events = target._events;
    if (events === void 0)
      return [];
    const listener = events[type];
    if (listener === void 0)
      return [];
    if (typeof listener === "function")
      return unwrap ? [unwrapListener(listener)] : [listener];
    return unwrap ? unwrapListeners(listener) : listener.slice();
  }
}
function checkListener(listener) {
  if (typeof listener !== "function")
    throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
}
class OnceWrapper {
  constructor(eventEmitter, eventType, listener) {
    this._fired = false;
    this._eventEmitter = eventEmitter;
    this._eventType = eventType;
    this._listener = listener;
    this.wrapperFunction = this._handle.bind(this);
    this.wrapperFunction.listener = listener;
  }
  _handle(...args) {
    if (this._fired)
      return;
    this._fired = true;
    this._eventEmitter.removeListener(this._eventType, this.wrapperFunction);
    return this._listener.apply(this._eventEmitter, args);
  }
}
function unwrapListener(l) {
  return wrappedListener(l) ?? l;
}
function unwrapListeners(arr) {
  return arr.map((l) => wrappedListener(l) ?? l);
}
function wrappedListener(l) {
  return l.listener;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/events.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var events_exports = {};
__export(events_exports, {
  Events: () => Events
});
module.exports = __toCommonJS(events_exports);
const Events = {
  AndroidDevice: {
    WebView: "webview",
    Close: "close"
  },
  AndroidSocket: {
    Data: "data",
    Close: "close"
  },
  AndroidWebView: {
    Close: "close"
  },
  Browser: {
    Disconnected: "disconnected"
  },
  BrowserContext: {
    Console: "console",
    Close: "close",
    Dialog: "dialog",
    Page: "page",
    // Can't use just 'error' due to node.js special treatment of error events.
    // @see https://nodejs.org/api/events.html#events_error_events
    WebError: "weberror",
    BackgroundPage: "backgroundpage",
    // Deprecated in v1.56, never emitted anymore.
    ServiceWorker: "serviceworker",
    Request: "request",
    Response: "response",
    RequestFailed: "requestfailed",
    RequestFinished: "requestfinished"
  },
  BrowserServer: {
    Close: "close"
  },
  Page: {
    Close: "close",
    Crash: "crash",
    Console: "console",
    Dialog: "dialog",
    Download: "download",
    FileChooser: "filechooser",
    DOMContentLoaded: "domcontentloaded",
    // Can't use just 'error' due to node.js special treatment of error events.
    // @see https://nodejs.org/api/events.html#events_error_events
    PageError: "pageerror",
    Request: "request",
    Response: "response",
    RequestFailed: "requestfailed",
    RequestFinished: "requestfinished",
    FrameAttached: "frameattached",
    FrameDetached: "framedetached",
    FrameNavigated: "framenavigated",
    Load: "load",
    Popup: "popup",
    WebSocket: "websocket",
    Worker: "worker"
  },
  WebSocket: {
    Close: "close",
    Error: "socketerror",
    FrameReceived: "framereceived",
    FrameSent: "framesent"
  },
  Worker: {
    Close: "close",
    Console: "console"
  },
  ElectronApplication: {
    Close: "close",
    Console: "console",
    Window: "window"
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fetch.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var fetch_exports = {};
__export(fetch_exports, {
  APIRequest: () => APIRequest,
  APIRequestContext: () => APIRequestContext,
  APIResponse: () => APIResponse
});
module.exports = __toCommonJS(fetch_exports);
var import_browserContext = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browserContext.js");
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_errors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js");
var import_network = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/network.js");
var import_tracing = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/tracing.js");
var import_assert = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/assert.js");
var import_fileUtils = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fileUtils.js");
var import_headers = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/headers.js");
var import_rtti = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/rtti.js");
var import_timeoutSettings = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/timeoutSettings.js");
class APIRequest {
  constructor(playwright) {
    this._contexts = /* @__PURE__ */ new Set();
    this._playwright = playwright;
  }
  async newContext(options = {}) {
    options = {
      ...this._playwright._defaultContextOptions,
      ...options
    };
    const storageState = typeof options.storageState === "string" ? JSON.parse(await this._playwright._platform.fs().promises.readFile(options.storageState, "utf8")) : options.storageState;
    const context = APIRequestContext.from((await this._playwright._channel.newRequest({
      ...options,
      extraHTTPHeaders: options.extraHTTPHeaders ? (0, import_headers.headersObjectToArray)(options.extraHTTPHeaders) : void 0,
      storageState,
      tracesDir: this._playwright._defaultLaunchOptions?.tracesDir,
      // We do not expose tracesDir in the API, so do not allow options to accidentally override it.
      clientCertificates: await (0, import_browserContext.toClientCertificatesProtocol)(this._playwright._platform, options.clientCertificates)
    })).request);
    this._contexts.add(context);
    context._request = this;
    context._timeoutSettings.setDefaultTimeout(options.timeout ?? this._playwright._defaultContextTimeout);
    context._tracing._tracesDir = this._playwright._defaultLaunchOptions?.tracesDir;
    await context._instrumentation.runAfterCreateRequestContext(context);
    return context;
  }
}
class APIRequestContext extends import_channelOwner.ChannelOwner {
  static from(channel) {
    return channel._object;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._tracing = import_tracing.Tracing.from(initializer.tracing);
    this._timeoutSettings = new import_timeoutSettings.TimeoutSettings(this._platform);
  }
  async [Symbol.asyncDispose]() {
    await this.dispose();
  }
  async dispose(options = {}) {
    this._closeReason = options.reason;
    await this._instrumentation.runBeforeCloseRequestContext(this);
    try {
      await this._channel.dispose(options);
    } catch (e) {
      if ((0, import_errors.isTargetClosedError)(e))
        return;
      throw e;
    }
    this._tracing._resetStackCounter();
    this._request?._contexts.delete(this);
  }
  async delete(url, options) {
    return await this.fetch(url, {
      ...options,
      method: "DELETE"
    });
  }
  async head(url, options) {
    return await this.fetch(url, {
      ...options,
      method: "HEAD"
    });
  }
  async get(url, options) {
    return await this.fetch(url, {
      ...options,
      method: "GET"
    });
  }
  async patch(url, options) {
    return await this.fetch(url, {
      ...options,
      method: "PATCH"
    });
  }
  async post(url, options) {
    return await this.fetch(url, {
      ...options,
      method: "POST"
    });
  }
  async put(url, options) {
    return await this.fetch(url, {
      ...options,
      method: "PUT"
    });
  }
  async fetch(urlOrRequest, options = {}) {
    const url = (0, import_rtti.isString)(urlOrRequest) ? urlOrRequest : void 0;
    const request = (0, import_rtti.isString)(urlOrRequest) ? void 0 : urlOrRequest;
    return await this._innerFetch({ url, request, ...options });
  }
  async _innerFetch(options = {}) {
    return await this._wrapApiCall(async () => {
      if (this._closeReason)
        throw new import_errors.TargetClosedError(this._closeReason);
      (0, import_assert.assert)(options.request || typeof options.url === "string", "First argument must be either URL string or Request");
      (0, import_assert.assert)((options.data === void 0 ? 0 : 1) + (options.form === void 0 ? 0 : 1) + (options.multipart === void 0 ? 0 : 1) <= 1, `Only one of 'data', 'form' or 'multipart' can be specified`);
      (0, import_assert.assert)(options.maxRedirects === void 0 || options.maxRedirects >= 0, `'maxRedirects' must be greater than or equal to '0'`);
      (0, import_assert.assert)(options.maxRetries === void 0 || options.maxRetries >= 0, `'maxRetries' must be greater than or equal to '0'`);
      const url = options.url !== void 0 ? options.url : options.request.url();
      const method = options.method || options.request?.method();
      let encodedParams = void 0;
      if (typeof options.params === "string")
        encodedParams = options.params;
      else if (options.params instanceof URLSearchParams)
        encodedParams = options.params.toString();
      const headersObj = options.headers || options.request?.headers();
      const headers = headersObj ? (0, import_headers.headersObjectToArray)(headersObj) : void 0;
      let jsonData;
      let formData;
      let multipartData;
      let postDataBuffer;
      if (options.data !== void 0) {
        if ((0, import_rtti.isString)(options.data)) {
          if (isJsonContentType(headers))
            jsonData = isJsonParsable(options.data) ? options.data : JSON.stringify(options.data);
          else
            postDataBuffer = Buffer.from(options.data, "utf8");
        } else if (Buffer.isBuffer(options.data)) {
          postDataBuffer = options.data;
        } else if (typeof options.data === "object" || typeof options.data === "number" || typeof options.data === "boolean") {
          jsonData = JSON.stringify(options.data);
        } else {
          throw new Error(`Unexpected 'data' type`);
        }
      } else if (options.form) {
        if (globalThis.FormData && options.form instanceof FormData) {
          formData = [];
          for (const [name, value] of options.form.entries()) {
            if (typeof value !== "string")
              throw new Error(`Expected string for options.form["${name}"], found File. Please use options.multipart instead.`);
            formData.push({ name, value });
          }
        } else {
          formData = objectToArray(options.form);
        }
      } else if (options.multipart) {
        multipartData = [];
        if (globalThis.FormData && options.multipart instanceof FormData) {
          const form = options.multipart;
          for (const [name, value] of form.entries()) {
            if ((0, import_rtti.isString)(value)) {
              multipartData.push({ name, value });
            } else {
              const file = {
                name: value.name,
                mimeType: value.type,
                buffer: Buffer.from(await value.arrayBuffer())
              };
              multipartData.push({ name, file });
            }
          }
        } else {
          for (const [name, value] of Object.entries(options.multipart))
            multipartData.push(await toFormField(this._platform, name, value));
        }
      }
      if (postDataBuffer === void 0 && jsonData === void 0 && formData === void 0 && multipartData === void 0)
        postDataBuffer = options.request?.postDataBuffer() || void 0;
      const fixtures = {
        __testHookLookup: options.__testHookLookup
      };
      const result = await this._channel.fetch({
        url,
        params: typeof options.params === "object" ? objectToArray(options.params) : void 0,
        encodedParams,
        method,
        headers,
        postData: postDataBuffer,
        jsonData,
        formData,
        multipartData,
        timeout: this._timeoutSettings.timeout(options),
        failOnStatusCode: options.failOnStatusCode,
        ignoreHTTPSErrors: options.ignoreHTTPSErrors,
        maxRedirects: options.maxRedirects,
        maxRetries: options.maxRetries,
        ...fixtures
      });
      return new APIResponse(this, result.response);
    });
  }
  async storageState(options = {}) {
    const state = await this._channel.storageState({ indexedDB: options.indexedDB });
    if (options.path) {
      await (0, import_fileUtils.mkdirIfNeeded)(this._platform, options.path);
      await this._platform.fs().promises.writeFile(options.path, JSON.stringify(state, void 0, 2), "utf8");
    }
    return state;
  }
}
async function toFormField(platform, name, value) {
  const typeOfValue = typeof value;
  if (isFilePayload(value)) {
    const payload = value;
    if (!Buffer.isBuffer(payload.buffer))
      throw new Error(`Unexpected buffer type of 'data.${name}'`);
    return { name, file: filePayloadToJson(payload) };
  } else if (typeOfValue === "string" || typeOfValue === "number" || typeOfValue === "boolean") {
    return { name, value: String(value) };
  } else {
    return { name, file: await readStreamToJson(platform, value) };
  }
}
function isJsonParsable(value) {
  if (typeof value !== "string")
    return false;
  try {
    JSON.parse(value);
    return true;
  } catch (e) {
    if (e instanceof SyntaxError)
      return false;
    else
      throw e;
  }
}
class APIResponse {
  constructor(context, initializer) {
    this._request = context;
    this._initializer = initializer;
    this._headers = new import_network.RawHeaders(this._initializer.headers);
    if (context._platform.inspectCustom)
      this[context._platform.inspectCustom] = () => this._inspect();
  }
  ok() {
    return this._initializer.status >= 200 && this._initializer.status <= 299;
  }
  url() {
    return this._initializer.url;
  }
  status() {
    return this._initializer.status;
  }
  statusText() {
    return this._initializer.statusText;
  }
  headers() {
    return this._headers.headers();
  }
  headersArray() {
    return this._headers.headersArray();
  }
  async body() {
    return await this._request._wrapApiCall(async () => {
      try {
        const result = await this._request._channel.fetchResponseBody({ fetchUid: this._fetchUid() });
        if (result.binary === void 0)
          throw new Error("Response has been disposed");
        return result.binary;
      } catch (e) {
        if ((0, import_errors.isTargetClosedError)(e))
          throw new Error("Response has been disposed");
        throw e;
      }
    }, { internal: true });
  }
  async text() {
    const content = await this.body();
    return content.toString("utf8");
  }
  async json() {
    const content = await this.text();
    return JSON.parse(content);
  }
  async [Symbol.asyncDispose]() {
    await this.dispose();
  }
  async dispose() {
    await this._request._channel.disposeAPIResponse({ fetchUid: this._fetchUid() });
  }
  _inspect() {
    const headers = this.headersArray().map(({ name, value }) => `  ${name}: ${value}`);
    return `APIResponse: ${this.status()} ${this.statusText()}
${headers.join("\n")}`;
  }
  _fetchUid() {
    return this._initializer.fetchUid;
  }
  async _fetchLog() {
    const { log } = await this._request._channel.fetchLog({ fetchUid: this._fetchUid() });
    return log;
  }
}
function filePayloadToJson(payload) {
  return {
    name: payload.name,
    mimeType: payload.mimeType,
    buffer: payload.buffer
  };
}
async function readStreamToJson(platform, stream) {
  const buffer = await new Promise((resolve, reject) => {
    const chunks = [];
    stream.on("data", (chunk) => chunks.push(chunk));
    stream.on("end", () => resolve(Buffer.concat(chunks)));
    stream.on("error", (err) => reject(err));
  });
  const streamPath = Buffer.isBuffer(stream.path) ? stream.path.toString("utf8") : stream.path;
  return {
    name: platform.path().basename(streamPath),
    buffer
  };
}
function isJsonContentType(headers) {
  if (!headers)
    return false;
  for (const { name, value } of headers) {
    if (name.toLocaleLowerCase() === "content-type")
      return value === "application/json";
  }
  return false;
}
function objectToArray(map) {
  if (!map)
    return void 0;
  const result = [];
  for (const [name, value] of Object.entries(map)) {
    if (value !== void 0)
      result.push({ name, value: String(value) });
  }
  return result;
}
function isFilePayload(value) {
  return typeof value === "object" && value["name"] && value["mimeType"] && value["buffer"];
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fileChooser.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var fileChooser_exports = {};
__export(fileChooser_exports, {
  FileChooser: () => FileChooser
});
module.exports = __toCommonJS(fileChooser_exports);
class FileChooser {
  constructor(page, elementHandle, isMultiple) {
    this._page = page;
    this._elementHandle = elementHandle;
    this._isMultiple = isMultiple;
  }
  element() {
    return this._elementHandle;
  }
  isMultiple() {
    return this._isMultiple;
  }
  page() {
    return this._page;
  }
  async setFiles(files, options) {
    return await this._elementHandle.setInputFiles(files, options);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fileUtils.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var fileUtils_exports = {};
__export(fileUtils_exports, {
  fileUploadSizeLimit: () => fileUploadSizeLimit,
  mkdirIfNeeded: () => mkdirIfNeeded
});
module.exports = __toCommonJS(fileUtils_exports);
const fileUploadSizeLimit = 50 * 1024 * 1024;
async function mkdirIfNeeded(platform, filePath) {
  await platform.fs().promises.mkdir(platform.path().dirname(filePath), { recursive: true }).catch(() => {
  });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/frame.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var frame_exports = {};
__export(frame_exports, {
  Frame: () => Frame,
  verifyLoadState: () => verifyLoadState
});
module.exports = __toCommonJS(frame_exports);
var import_eventEmitter = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/eventEmitter.js");
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_clientHelper = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clientHelper.js");
var import_elementHandle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/elementHandle.js");
var import_events = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/events.js");
var import_jsHandle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/jsHandle.js");
var import_locator = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/locator.js");
var network = __toESM(__webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/network.js"));
var import_types = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/types.js");
var import_waiter = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/waiter.js");
var import_assert = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/assert.js");
var import_locatorUtils = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/locatorUtils.js");
var import_urlMatch = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/urlMatch.js");
var import_timeoutSettings = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/timeoutSettings.js");
class Frame extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._parentFrame = null;
    this._url = "";
    this._name = "";
    this._detached = false;
    this._childFrames = /* @__PURE__ */ new Set();
    this._eventEmitter = new import_eventEmitter.EventEmitter(parent._platform);
    this._eventEmitter.setMaxListeners(0);
    this._parentFrame = Frame.fromNullable(initializer.parentFrame);
    if (this._parentFrame)
      this._parentFrame._childFrames.add(this);
    this._name = initializer.name;
    this._url = initializer.url;
    this._loadStates = new Set(initializer.loadStates);
    this._channel.on("loadstate", (event) => {
      if (event.add) {
        this._loadStates.add(event.add);
        this._eventEmitter.emit("loadstate", event.add);
      }
      if (event.remove)
        this._loadStates.delete(event.remove);
      if (!this._parentFrame && event.add === "load" && this._page)
        this._page.emit(import_events.Events.Page.Load, this._page);
      if (!this._parentFrame && event.add === "domcontentloaded" && this._page)
        this._page.emit(import_events.Events.Page.DOMContentLoaded, this._page);
    });
    this._channel.on("navigated", (event) => {
      this._url = event.url;
      this._name = event.name;
      this._eventEmitter.emit("navigated", event);
      if (!event.error && this._page)
        this._page.emit(import_events.Events.Page.FrameNavigated, this);
    });
  }
  static from(frame) {
    return frame._object;
  }
  static fromNullable(frame) {
    return frame ? Frame.from(frame) : null;
  }
  page() {
    return this._page;
  }
  _timeout(options) {
    const timeoutSettings = this._page?._timeoutSettings || new import_timeoutSettings.TimeoutSettings(this._platform);
    return timeoutSettings.timeout(options || {});
  }
  _navigationTimeout(options) {
    const timeoutSettings = this._page?._timeoutSettings || new import_timeoutSettings.TimeoutSettings(this._platform);
    return timeoutSettings.navigationTimeout(options || {});
  }
  async goto(url, options = {}) {
    const waitUntil = verifyLoadState("waitUntil", options.waitUntil === void 0 ? "load" : options.waitUntil);
    return network.Response.fromNullable((await this._channel.goto({ url, ...options, waitUntil, timeout: this._navigationTimeout(options) })).response);
  }
  _setupNavigationWaiter(options) {
    const waiter = new import_waiter.Waiter(this._page, "");
    if (this._page.isClosed())
      waiter.rejectImmediately(this._page._closeErrorWithReason());
    waiter.rejectOnEvent(this._page, import_events.Events.Page.Close, () => this._page._closeErrorWithReason());
    waiter.rejectOnEvent(this._page, import_events.Events.Page.Crash, new Error("Navigation failed because page crashed!"));
    waiter.rejectOnEvent(this._page, import_events.Events.Page.FrameDetached, new Error("Navigating frame was detached!"), (frame) => frame === this);
    const timeout = this._page._timeoutSettings.navigationTimeout(options);
    waiter.rejectOnTimeout(timeout, `Timeout ${timeout}ms exceeded.`);
    return waiter;
  }
  async waitForNavigation(options = {}) {
    return await this._page._wrapApiCall(async () => {
      const waitUntil = verifyLoadState("waitUntil", options.waitUntil === void 0 ? "load" : options.waitUntil);
      const waiter = this._setupNavigationWaiter(options);
      const toUrl = typeof options.url === "string" ? ` to "${options.url}"` : "";
      waiter.log(`waiting for navigation${toUrl} until "${waitUntil}"`);
      const navigatedEvent = await waiter.waitForEvent(this._eventEmitter, "navigated", (event) => {
        if (event.error)
          return true;
        waiter.log(`  navigated to "${event.url}"`);
        return (0, import_urlMatch.urlMatches)(this._page?.context()._options.baseURL, event.url, options.url);
      });
      if (navigatedEvent.error) {
        const e = new Error(navigatedEvent.error);
        e.stack = "";
        await waiter.waitForPromise(Promise.reject(e));
      }
      if (!this._loadStates.has(waitUntil)) {
        await waiter.waitForEvent(this._eventEmitter, "loadstate", (s) => {
          waiter.log(`  "${s}" event fired`);
          return s === waitUntil;
        });
      }
      const request = navigatedEvent.newDocument ? network.Request.fromNullable(navigatedEvent.newDocument.request) : null;
      const response = request ? await waiter.waitForPromise(request._finalRequest()._internalResponse()) : null;
      waiter.dispose();
      return response;
    }, { title: "Wait for navigation" });
  }
  async waitForLoadState(state = "load", options = {}) {
    state = verifyLoadState("state", state);
    return await this._page._wrapApiCall(async () => {
      const waiter = this._setupNavigationWaiter(options);
      if (this._loadStates.has(state)) {
        waiter.log(`  not waiting, "${state}" event already fired`);
      } else {
        await waiter.waitForEvent(this._eventEmitter, "loadstate", (s) => {
          waiter.log(`  "${s}" event fired`);
          return s === state;
        });
      }
      waiter.dispose();
    }, { title: `Wait for load state "${state}"` });
  }
  async waitForURL(url, options = {}) {
    if ((0, import_urlMatch.urlMatches)(this._page?.context()._options.baseURL, this.url(), url))
      return await this.waitForLoadState(options.waitUntil, options);
    await this.waitForNavigation({ url, ...options });
  }
  async frameElement() {
    return import_elementHandle.ElementHandle.from((await this._channel.frameElement()).element);
  }
  async evaluateHandle(pageFunction, arg) {
    (0, import_jsHandle.assertMaxArguments)(arguments.length, 2);
    const result = await this._channel.evaluateExpressionHandle({ expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: (0, import_jsHandle.serializeArgument)(arg) });
    return import_jsHandle.JSHandle.from(result.handle);
  }
  async evaluate(pageFunction, arg) {
    (0, import_jsHandle.assertMaxArguments)(arguments.length, 2);
    const result = await this._channel.evaluateExpression({ expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: (0, import_jsHandle.serializeArgument)(arg) });
    return (0, import_jsHandle.parseResult)(result.value);
  }
  async _evaluateFunction(functionDeclaration) {
    const result = await this._channel.evaluateExpression({ expression: functionDeclaration, isFunction: true, arg: (0, import_jsHandle.serializeArgument)(void 0) });
    return (0, import_jsHandle.parseResult)(result.value);
  }
  async _evaluateExposeUtilityScript(pageFunction, arg) {
    (0, import_jsHandle.assertMaxArguments)(arguments.length, 2);
    const result = await this._channel.evaluateExpression({ expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: (0, import_jsHandle.serializeArgument)(arg) });
    return (0, import_jsHandle.parseResult)(result.value);
  }
  async $(selector, options) {
    const result = await this._channel.querySelector({ selector, ...options });
    return import_elementHandle.ElementHandle.fromNullable(result.element);
  }
  async waitForSelector(selector, options = {}) {
    if (options.visibility)
      throw new Error("options.visibility is not supported, did you mean options.state?");
    if (options.waitFor && options.waitFor !== "visible")
      throw new Error("options.waitFor is not supported, did you mean options.state?");
    const result = await this._channel.waitForSelector({ selector, ...options, timeout: this._timeout(options) });
    return import_elementHandle.ElementHandle.fromNullable(result.element);
  }
  async dispatchEvent(selector, type, eventInit, options = {}) {
    await this._channel.dispatchEvent({ selector, type, eventInit: (0, import_jsHandle.serializeArgument)(eventInit), ...options, timeout: this._timeout(options) });
  }
  async $eval(selector, pageFunction, arg) {
    (0, import_jsHandle.assertMaxArguments)(arguments.length, 3);
    const result = await this._channel.evalOnSelector({ selector, expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: (0, import_jsHandle.serializeArgument)(arg) });
    return (0, import_jsHandle.parseResult)(result.value);
  }
  async $$eval(selector, pageFunction, arg) {
    (0, import_jsHandle.assertMaxArguments)(arguments.length, 3);
    const result = await this._channel.evalOnSelectorAll({ selector, expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: (0, import_jsHandle.serializeArgument)(arg) });
    return (0, import_jsHandle.parseResult)(result.value);
  }
  async $$(selector) {
    const result = await this._channel.querySelectorAll({ selector });
    return result.elements.map((e) => import_elementHandle.ElementHandle.from(e));
  }
  async _queryCount(selector, options) {
    return (await this._channel.queryCount({ selector, ...options })).value;
  }
  async content() {
    return (await this._channel.content()).value;
  }
  async setContent(html, options = {}) {
    const waitUntil = verifyLoadState("waitUntil", options.waitUntil === void 0 ? "load" : options.waitUntil);
    await this._channel.setContent({ html, ...options, waitUntil, timeout: this._navigationTimeout(options) });
  }
  name() {
    return this._name || "";
  }
  url() {
    return this._url;
  }
  parentFrame() {
    return this._parentFrame;
  }
  childFrames() {
    return Array.from(this._childFrames);
  }
  isDetached() {
    return this._detached;
  }
  async addScriptTag(options = {}) {
    const copy = { ...options };
    if (copy.path) {
      copy.content = (await this._platform.fs().promises.readFile(copy.path)).toString();
      copy.content = (0, import_clientHelper.addSourceUrlToScript)(copy.content, copy.path);
    }
    return import_elementHandle.ElementHandle.from((await this._channel.addScriptTag({ ...copy })).element);
  }
  async addStyleTag(options = {}) {
    const copy = { ...options };
    if (copy.path) {
      copy.content = (await this._platform.fs().promises.readFile(copy.path)).toString();
      copy.content += "/*# sourceURL=" + copy.path.replace(/\n/g, "") + "*/";
    }
    return import_elementHandle.ElementHandle.from((await this._channel.addStyleTag({ ...copy })).element);
  }
  async click(selector, options = {}) {
    return await this._channel.click({ selector, ...options, timeout: this._timeout(options) });
  }
  async dblclick(selector, options = {}) {
    return await this._channel.dblclick({ selector, ...options, timeout: this._timeout(options) });
  }
  async dragAndDrop(source, target, options = {}) {
    return await this._channel.dragAndDrop({ source, target, ...options, timeout: this._timeout(options) });
  }
  async tap(selector, options = {}) {
    return await this._channel.tap({ selector, ...options, timeout: this._timeout(options) });
  }
  async fill(selector, value, options = {}) {
    return await this._channel.fill({ selector, value, ...options, timeout: this._timeout(options) });
  }
  async _highlight(selector) {
    return await this._channel.highlight({ selector });
  }
  locator(selector, options) {
    return new import_locator.Locator(this, selector, options);
  }
  getByTestId(testId) {
    return this.locator((0, import_locatorUtils.getByTestIdSelector)((0, import_locator.testIdAttributeName)(), testId));
  }
  getByAltText(text, options) {
    return this.locator((0, import_locatorUtils.getByAltTextSelector)(text, options));
  }
  getByLabel(text, options) {
    return this.locator((0, import_locatorUtils.getByLabelSelector)(text, options));
  }
  getByPlaceholder(text, options) {
    return this.locator((0, import_locatorUtils.getByPlaceholderSelector)(text, options));
  }
  getByText(text, options) {
    return this.locator((0, import_locatorUtils.getByTextSelector)(text, options));
  }
  getByTitle(text, options) {
    return this.locator((0, import_locatorUtils.getByTitleSelector)(text, options));
  }
  getByRole(role, options = {}) {
    return this.locator((0, import_locatorUtils.getByRoleSelector)(role, options));
  }
  frameLocator(selector) {
    return new import_locator.FrameLocator(this, selector);
  }
  async focus(selector, options = {}) {
    await this._channel.focus({ selector, ...options, timeout: this._timeout(options) });
  }
  async textContent(selector, options = {}) {
    const value = (await this._channel.textContent({ selector, ...options, timeout: this._timeout(options) })).value;
    return value === void 0 ? null : value;
  }
  async innerText(selector, options = {}) {
    return (await this._channel.innerText({ selector, ...options, timeout: this._timeout(options) })).value;
  }
  async innerHTML(selector, options = {}) {
    return (await this._channel.innerHTML({ selector, ...options, timeout: this._timeout(options) })).value;
  }
  async getAttribute(selector, name, options = {}) {
    const value = (await this._channel.getAttribute({ selector, name, ...options, timeout: this._timeout(options) })).value;
    return value === void 0 ? null : value;
  }
  async inputValue(selector, options = {}) {
    return (await this._channel.inputValue({ selector, ...options, timeout: this._timeout(options) })).value;
  }
  async isChecked(selector, options = {}) {
    return (await this._channel.isChecked({ selector, ...options, timeout: this._timeout(options) })).value;
  }
  async isDisabled(selector, options = {}) {
    return (await this._channel.isDisabled({ selector, ...options, timeout: this._timeout(options) })).value;
  }
  async isEditable(selector, options = {}) {
    return (await this._channel.isEditable({ selector, ...options, timeout: this._timeout(options) })).value;
  }
  async isEnabled(selector, options = {}) {
    return (await this._channel.isEnabled({ selector, ...options, timeout: this._timeout(options) })).value;
  }
  async isHidden(selector, options = {}) {
    return (await this._channel.isHidden({ selector, ...options })).value;
  }
  async isVisible(selector, options = {}) {
    return (await this._channel.isVisible({ selector, ...options })).value;
  }
  async hover(selector, options = {}) {
    await this._channel.hover({ selector, ...options, timeout: this._timeout(options) });
  }
  async selectOption(selector, values, options = {}) {
    return (await this._channel.selectOption({ selector, ...(0, import_elementHandle.convertSelectOptionValues)(values), ...options, timeout: this._timeout(options) })).values;
  }
  async setInputFiles(selector, files, options = {}) {
    const converted = await (0, import_elementHandle.convertInputFiles)(this._platform, files, this.page().context());
    await this._channel.setInputFiles({ selector, ...converted, ...options, timeout: this._timeout(options) });
  }
  async type(selector, text, options = {}) {
    await this._channel.type({ selector, text, ...options, timeout: this._timeout(options) });
  }
  async press(selector, key, options = {}) {
    await this._channel.press({ selector, key, ...options, timeout: this._timeout(options) });
  }
  async check(selector, options = {}) {
    await this._channel.check({ selector, ...options, timeout: this._timeout(options) });
  }
  async uncheck(selector, options = {}) {
    await this._channel.uncheck({ selector, ...options, timeout: this._timeout(options) });
  }
  async setChecked(selector, checked, options) {
    if (checked)
      await this.check(selector, options);
    else
      await this.uncheck(selector, options);
  }
  async waitForTimeout(timeout) {
    await this._channel.waitForTimeout({ waitTimeout: timeout });
  }
  async waitForFunction(pageFunction, arg, options = {}) {
    if (typeof options.polling === "string")
      (0, import_assert.assert)(options.polling === "raf", "Unknown polling option: " + options.polling);
    const result = await this._channel.waitForFunction({
      ...options,
      pollingInterval: options.polling === "raf" ? void 0 : options.polling,
      expression: String(pageFunction),
      isFunction: typeof pageFunction === "function",
      arg: (0, import_jsHandle.serializeArgument)(arg),
      timeout: this._timeout(options)
    });
    return import_jsHandle.JSHandle.from(result.handle);
  }
  async title() {
    return (await this._channel.title()).value;
  }
  async _expect(expression, options) {
    const params = { expression, ...options, isNot: !!options.isNot };
    params.expectedValue = (0, import_jsHandle.serializeArgument)(options.expectedValue);
    const result = await this._channel.expect(params);
    if (result.received !== void 0)
      result.received = (0, import_jsHandle.parseResult)(result.received);
    return result;
  }
}
function verifyLoadState(name, waitUntil) {
  if (waitUntil === "networkidle0")
    waitUntil = "networkidle";
  if (!import_types.kLifecycleEvents.has(waitUntil))
    throw new Error(`${name}: expected one of (load|domcontentloaded|networkidle|commit)`);
  return waitUntil;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/harRouter.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var harRouter_exports = {};
__export(harRouter_exports, {
  HarRouter: () => HarRouter
});
module.exports = __toCommonJS(harRouter_exports);
class HarRouter {
  static async create(localUtils, file, notFoundAction, options) {
    const { harId, error } = await localUtils.harOpen({ file });
    if (error)
      throw new Error(error);
    return new HarRouter(localUtils, harId, notFoundAction, options);
  }
  constructor(localUtils, harId, notFoundAction, options) {
    this._localUtils = localUtils;
    this._harId = harId;
    this._options = options;
    this._notFoundAction = notFoundAction;
  }
  async _handle(route) {
    const request = route.request();
    const response = await this._localUtils.harLookup({
      harId: this._harId,
      url: request.url(),
      method: request.method(),
      headers: await request.headersArray(),
      postData: request.postDataBuffer() || void 0,
      isNavigationRequest: request.isNavigationRequest()
    });
    if (response.action === "redirect") {
      route._platform.log("api", `HAR: ${route.request().url()} redirected to ${response.redirectURL}`);
      await route._redirectNavigationRequest(response.redirectURL);
      return;
    }
    if (response.action === "fulfill") {
      if (response.status === -1)
        return;
      await route.fulfill({
        status: response.status,
        headers: Object.fromEntries(response.headers.map((h) => [h.name, h.value])),
        body: response.body
      });
      return;
    }
    if (response.action === "error")
      route._platform.log("api", "HAR: " + response.message);
    if (this._notFoundAction === "abort") {
      await route.abort();
      return;
    }
    await route.fallback();
  }
  async addContextRoute(context) {
    await context.route(this._options.urlMatch || "**/*", (route) => this._handle(route));
  }
  async addPageRoute(page) {
    await page.route(this._options.urlMatch || "**/*", (route) => this._handle(route));
  }
  async [Symbol.asyncDispose]() {
    await this.dispose();
  }
  dispose() {
    this._localUtils.harClose({ harId: this._harId }).catch(() => {
    });
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/input.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var input_exports = {};
__export(input_exports, {
  Keyboard: () => Keyboard,
  Mouse: () => Mouse,
  Touchscreen: () => Touchscreen
});
module.exports = __toCommonJS(input_exports);
class Keyboard {
  constructor(page) {
    this._page = page;
  }
  async down(key) {
    await this._page._channel.keyboardDown({ key });
  }
  async up(key) {
    await this._page._channel.keyboardUp({ key });
  }
  async insertText(text) {
    await this._page._channel.keyboardInsertText({ text });
  }
  async type(text, options = {}) {
    await this._page._channel.keyboardType({ text, ...options });
  }
  async press(key, options = {}) {
    await this._page._channel.keyboardPress({ key, ...options });
  }
}
class Mouse {
  constructor(page) {
    this._page = page;
  }
  async move(x, y, options = {}) {
    await this._page._channel.mouseMove({ x, y, ...options });
  }
  async down(options = {}) {
    await this._page._channel.mouseDown({ ...options });
  }
  async up(options = {}) {
    await this._page._channel.mouseUp(options);
  }
  async click(x, y, options = {}) {
    await this._page._channel.mouseClick({ x, y, ...options });
  }
  async dblclick(x, y, options = {}) {
    await this._page._wrapApiCall(async () => {
      await this.click(x, y, { ...options, clickCount: 2 });
    }, { title: "Double click" });
  }
  async wheel(deltaX, deltaY) {
    await this._page._channel.mouseWheel({ deltaX, deltaY });
  }
}
class Touchscreen {
  constructor(page) {
    this._page = page;
  }
  async tap(x, y) {
    await this._page._channel.touchscreenTap({ x, y });
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/jsHandle.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var jsHandle_exports = {};
__export(jsHandle_exports, {
  JSHandle: () => JSHandle,
  assertMaxArguments: () => assertMaxArguments,
  parseResult: () => parseResult,
  serializeArgument: () => serializeArgument
});
module.exports = __toCommonJS(jsHandle_exports);
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_errors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js");
var import_serializers = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/protocol/serializers.js");
class JSHandle extends import_channelOwner.ChannelOwner {
  static from(handle) {
    return handle._object;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._preview = this._initializer.preview;
    this._channel.on("previewUpdated", ({ preview }) => this._preview = preview);
  }
  async evaluate(pageFunction, arg) {
    const result = await this._channel.evaluateExpression({ expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: serializeArgument(arg) });
    return parseResult(result.value);
  }
  async _evaluateFunction(functionDeclaration) {
    const result = await this._channel.evaluateExpression({ expression: functionDeclaration, isFunction: true, arg: serializeArgument(void 0) });
    return parseResult(result.value);
  }
  async evaluateHandle(pageFunction, arg) {
    const result = await this._channel.evaluateExpressionHandle({ expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: serializeArgument(arg) });
    return JSHandle.from(result.handle);
  }
  async getProperty(propertyName) {
    const result = await this._channel.getProperty({ name: propertyName });
    return JSHandle.from(result.handle);
  }
  async getProperties() {
    const map = /* @__PURE__ */ new Map();
    for (const { name, value } of (await this._channel.getPropertyList()).properties)
      map.set(name, JSHandle.from(value));
    return map;
  }
  async jsonValue() {
    return parseResult((await this._channel.jsonValue()).value);
  }
  asElement() {
    return null;
  }
  async [Symbol.asyncDispose]() {
    await this.dispose();
  }
  async dispose() {
    try {
      await this._channel.dispose();
    } catch (e) {
      if ((0, import_errors.isTargetClosedError)(e))
        return;
      throw e;
    }
  }
  toString() {
    return this._preview;
  }
}
function serializeArgument(arg) {
  const handles = [];
  const pushHandle = (channel) => {
    handles.push(channel);
    return handles.length - 1;
  };
  const value = (0, import_serializers.serializeValue)(arg, (value2) => {
    if (value2 instanceof JSHandle)
      return { h: pushHandle(value2._channel) };
    return { fallThrough: value2 };
  });
  return { value, handles };
}
function parseResult(value) {
  return (0, import_serializers.parseSerializedValue)(value, void 0);
}
function assertMaxArguments(count, max) {
  if (count > max)
    throw new Error("Too many arguments. If you need to pass more than 1 argument to the function wrap them in an object.");
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/jsonPipe.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var jsonPipe_exports = {};
__export(jsonPipe_exports, {
  JsonPipe: () => JsonPipe
});
module.exports = __toCommonJS(jsonPipe_exports);
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
class JsonPipe extends import_channelOwner.ChannelOwner {
  static from(jsonPipe) {
    return jsonPipe._object;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
  }
  channel() {
    return this._channel;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/localUtils.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var localUtils_exports = {};
__export(localUtils_exports, {
  LocalUtils: () => LocalUtils
});
module.exports = __toCommonJS(localUtils_exports);
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
class LocalUtils extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this.devices = {};
    for (const { name, descriptor } of initializer.deviceDescriptors)
      this.devices[name] = descriptor;
  }
  async zip(params) {
    return await this._channel.zip(params);
  }
  async harOpen(params) {
    return await this._channel.harOpen(params);
  }
  async harLookup(params) {
    return await this._channel.harLookup(params);
  }
  async harClose(params) {
    return await this._channel.harClose(params);
  }
  async harUnzip(params) {
    return await this._channel.harUnzip(params);
  }
  async tracingStarted(params) {
    return await this._channel.tracingStarted(params);
  }
  async traceDiscarded(params) {
    return await this._channel.traceDiscarded(params);
  }
  async addStackToTracingNoReply(params) {
    return await this._channel.addStackToTracingNoReply(params);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/locator.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var locator_exports = {};
__export(locator_exports, {
  FrameLocator: () => FrameLocator,
  Locator: () => Locator,
  setTestIdAttribute: () => setTestIdAttribute,
  testIdAttributeName: () => testIdAttributeName
});
module.exports = __toCommonJS(locator_exports);
var import_elementHandle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/elementHandle.js");
var import_locatorGenerators = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/locatorGenerators.js");
var import_locatorUtils = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/locatorUtils.js");
var import_stringUtils = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/stringUtils.js");
var import_rtti = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/rtti.js");
var import_time = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/time.js");
class Locator {
  constructor(frame, selector, options) {
    this._frame = frame;
    this._selector = selector;
    if (options?.hasText)
      this._selector += ` >> internal:has-text=${(0, import_stringUtils.escapeForTextSelector)(options.hasText, false)}`;
    if (options?.hasNotText)
      this._selector += ` >> internal:has-not-text=${(0, import_stringUtils.escapeForTextSelector)(options.hasNotText, false)}`;
    if (options?.has) {
      const locator = options.has;
      if (locator._frame !== frame)
        throw new Error(`Inner "has" locator must belong to the same frame.`);
      this._selector += ` >> internal:has=` + JSON.stringify(locator._selector);
    }
    if (options?.hasNot) {
      const locator = options.hasNot;
      if (locator._frame !== frame)
        throw new Error(`Inner "hasNot" locator must belong to the same frame.`);
      this._selector += ` >> internal:has-not=` + JSON.stringify(locator._selector);
    }
    if (options?.visible !== void 0)
      this._selector += ` >> visible=${options.visible ? "true" : "false"}`;
    if (this._frame._platform.inspectCustom)
      this[this._frame._platform.inspectCustom] = () => this._inspect();
  }
  async _withElement(task, options) {
    const timeout = this._frame._timeout({ timeout: options.timeout });
    const deadline = timeout ? (0, import_time.monotonicTime)() + timeout : 0;
    return await this._frame._wrapApiCall(async () => {
      const result = await this._frame._channel.waitForSelector({ selector: this._selector, strict: true, state: "attached", timeout });
      const handle = import_elementHandle.ElementHandle.fromNullable(result.element);
      if (!handle)
        throw new Error(`Could not resolve ${this._selector} to DOM Element`);
      try {
        return await task(handle, deadline ? deadline - (0, import_time.monotonicTime)() : 0);
      } finally {
        await handle.dispose();
      }
    }, { title: options.title, internal: options.internal });
  }
  _equals(locator) {
    return this._frame === locator._frame && this._selector === locator._selector;
  }
  page() {
    return this._frame.page();
  }
  async boundingBox(options) {
    return await this._withElement((h) => h.boundingBox(), { title: "Bounding box", timeout: options?.timeout });
  }
  async check(options = {}) {
    return await this._frame.check(this._selector, { strict: true, ...options });
  }
  async click(options = {}) {
    return await this._frame.click(this._selector, { strict: true, ...options });
  }
  async dblclick(options = {}) {
    await this._frame.dblclick(this._selector, { strict: true, ...options });
  }
  async dispatchEvent(type, eventInit = {}, options) {
    return await this._frame.dispatchEvent(this._selector, type, eventInit, { strict: true, ...options });
  }
  async dragTo(target, options = {}) {
    return await this._frame.dragAndDrop(this._selector, target._selector, {
      strict: true,
      ...options
    });
  }
  async evaluate(pageFunction, arg, options) {
    return await this._withElement((h) => h.evaluate(pageFunction, arg), { title: "Evaluate", timeout: options?.timeout });
  }
  async _evaluateFunction(functionDeclaration, options) {
    return await this._withElement((h) => h._evaluateFunction(functionDeclaration), { title: "Evaluate", timeout: options?.timeout });
  }
  async evaluateAll(pageFunction, arg) {
    return await this._frame.$$eval(this._selector, pageFunction, arg);
  }
  async evaluateHandle(pageFunction, arg, options) {
    return await this._withElement((h) => h.evaluateHandle(pageFunction, arg), { title: "Evaluate", timeout: options?.timeout });
  }
  async fill(value, options = {}) {
    return await this._frame.fill(this._selector, value, { strict: true, ...options });
  }
  async clear(options = {}) {
    await this._frame._wrapApiCall(() => this.fill("", options), { title: "Clear" });
  }
  async _highlight() {
    return await this._frame._highlight(this._selector);
  }
  async highlight() {
    return await this._frame._highlight(this._selector);
  }
  locator(selectorOrLocator, options) {
    if ((0, import_rtti.isString)(selectorOrLocator))
      return new Locator(this._frame, this._selector + " >> " + selectorOrLocator, options);
    if (selectorOrLocator._frame !== this._frame)
      throw new Error(`Locators must belong to the same frame.`);
    return new Locator(this._frame, this._selector + " >> internal:chain=" + JSON.stringify(selectorOrLocator._selector), options);
  }
  getByTestId(testId) {
    return this.locator((0, import_locatorUtils.getByTestIdSelector)(testIdAttributeName(), testId));
  }
  getByAltText(text, options) {
    return this.locator((0, import_locatorUtils.getByAltTextSelector)(text, options));
  }
  getByLabel(text, options) {
    return this.locator((0, import_locatorUtils.getByLabelSelector)(text, options));
  }
  getByPlaceholder(text, options) {
    return this.locator((0, import_locatorUtils.getByPlaceholderSelector)(text, options));
  }
  getByText(text, options) {
    return this.locator((0, import_locatorUtils.getByTextSelector)(text, options));
  }
  getByTitle(text, options) {
    return this.locator((0, import_locatorUtils.getByTitleSelector)(text, options));
  }
  getByRole(role, options = {}) {
    return this.locator((0, import_locatorUtils.getByRoleSelector)(role, options));
  }
  frameLocator(selector) {
    return new FrameLocator(this._frame, this._selector + " >> " + selector);
  }
  filter(options) {
    return new Locator(this._frame, this._selector, options);
  }
  async elementHandle(options) {
    return await this._frame.waitForSelector(this._selector, { strict: true, state: "attached", ...options });
  }
  async elementHandles() {
    return await this._frame.$$(this._selector);
  }
  contentFrame() {
    return new FrameLocator(this._frame, this._selector);
  }
  describe(description) {
    return new Locator(this._frame, this._selector + " >> internal:describe=" + JSON.stringify(description));
  }
  first() {
    return new Locator(this._frame, this._selector + " >> nth=0");
  }
  last() {
    return new Locator(this._frame, this._selector + ` >> nth=-1`);
  }
  nth(index) {
    return new Locator(this._frame, this._selector + ` >> nth=${index}`);
  }
  and(locator) {
    if (locator._frame !== this._frame)
      throw new Error(`Locators must belong to the same frame.`);
    return new Locator(this._frame, this._selector + ` >> internal:and=` + JSON.stringify(locator._selector));
  }
  or(locator) {
    if (locator._frame !== this._frame)
      throw new Error(`Locators must belong to the same frame.`);
    return new Locator(this._frame, this._selector + ` >> internal:or=` + JSON.stringify(locator._selector));
  }
  async focus(options) {
    return await this._frame.focus(this._selector, { strict: true, ...options });
  }
  async blur(options) {
    await this._frame._channel.blur({ selector: this._selector, strict: true, ...options, timeout: this._frame._timeout(options) });
  }
  // options are only here for testing
  async count(_options) {
    return await this._frame._queryCount(this._selector, _options);
  }
  async _resolveSelector() {
    return await this._frame._channel.resolveSelector({ selector: this._selector });
  }
  async getAttribute(name, options) {
    return await this._frame.getAttribute(this._selector, name, { strict: true, ...options });
  }
  async hover(options = {}) {
    return await this._frame.hover(this._selector, { strict: true, ...options });
  }
  async innerHTML(options) {
    return await this._frame.innerHTML(this._selector, { strict: true, ...options });
  }
  async innerText(options) {
    return await this._frame.innerText(this._selector, { strict: true, ...options });
  }
  async inputValue(options) {
    return await this._frame.inputValue(this._selector, { strict: true, ...options });
  }
  async isChecked(options) {
    return await this._frame.isChecked(this._selector, { strict: true, ...options });
  }
  async isDisabled(options) {
    return await this._frame.isDisabled(this._selector, { strict: true, ...options });
  }
  async isEditable(options) {
    return await this._frame.isEditable(this._selector, { strict: true, ...options });
  }
  async isEnabled(options) {
    return await this._frame.isEnabled(this._selector, { strict: true, ...options });
  }
  async isHidden(options) {
    return await this._frame.isHidden(this._selector, { strict: true, ...options });
  }
  async isVisible(options) {
    return await this._frame.isVisible(this._selector, { strict: true, ...options });
  }
  async press(key, options = {}) {
    return await this._frame.press(this._selector, key, { strict: true, ...options });
  }
  async screenshot(options = {}) {
    const mask = options.mask;
    return await this._withElement((h, timeout) => h.screenshot({ ...options, mask, timeout }), { title: "Screenshot", timeout: options.timeout });
  }
  async ariaSnapshot(options) {
    const result = await this._frame._channel.ariaSnapshot({ ...options, selector: this._selector, timeout: this._frame._timeout(options) });
    return result.snapshot;
  }
  async scrollIntoViewIfNeeded(options = {}) {
    return await this._withElement((h, timeout) => h.scrollIntoViewIfNeeded({ ...options, timeout }), { title: "Scroll into view", timeout: options.timeout });
  }
  async selectOption(values, options = {}) {
    return await this._frame.selectOption(this._selector, values, { strict: true, ...options });
  }
  async selectText(options = {}) {
    return await this._withElement((h, timeout) => h.selectText({ ...options, timeout }), { title: "Select text", timeout: options.timeout });
  }
  async setChecked(checked, options) {
    if (checked)
      await this.check(options);
    else
      await this.uncheck(options);
  }
  async setInputFiles(files, options = {}) {
    return await this._frame.setInputFiles(this._selector, files, { strict: true, ...options });
  }
  async tap(options = {}) {
    return await this._frame.tap(this._selector, { strict: true, ...options });
  }
  async textContent(options) {
    return await this._frame.textContent(this._selector, { strict: true, ...options });
  }
  async type(text, options = {}) {
    return await this._frame.type(this._selector, text, { strict: true, ...options });
  }
  async pressSequentially(text, options = {}) {
    return await this.type(text, options);
  }
  async uncheck(options = {}) {
    return await this._frame.uncheck(this._selector, { strict: true, ...options });
  }
  async all() {
    return new Array(await this.count()).fill(0).map((e, i) => this.nth(i));
  }
  async allInnerTexts() {
    return await this._frame.$$eval(this._selector, (ee) => ee.map((e) => e.innerText));
  }
  async allTextContents() {
    return await this._frame.$$eval(this._selector, (ee) => ee.map((e) => e.textContent || ""));
  }
  async waitFor(options) {
    await this._frame._channel.waitForSelector({ selector: this._selector, strict: true, omitReturnValue: true, ...options, timeout: this._frame._timeout(options) });
  }
  async _expect(expression, options) {
    return this._frame._expect(expression, {
      ...options,
      selector: this._selector
    });
  }
  _inspect() {
    return this.toString();
  }
  toString() {
    return (0, import_locatorGenerators.asLocator)("javascript", this._selector);
  }
}
class FrameLocator {
  constructor(frame, selector) {
    this._frame = frame;
    this._frameSelector = selector;
  }
  locator(selectorOrLocator, options) {
    if ((0, import_rtti.isString)(selectorOrLocator))
      return new Locator(this._frame, this._frameSelector + " >> internal:control=enter-frame >> " + selectorOrLocator, options);
    if (selectorOrLocator._frame !== this._frame)
      throw new Error(`Locators must belong to the same frame.`);
    return new Locator(this._frame, this._frameSelector + " >> internal:control=enter-frame >> " + selectorOrLocator._selector, options);
  }
  getByTestId(testId) {
    return this.locator((0, import_locatorUtils.getByTestIdSelector)(testIdAttributeName(), testId));
  }
  getByAltText(text, options) {
    return this.locator((0, import_locatorUtils.getByAltTextSelector)(text, options));
  }
  getByLabel(text, options) {
    return this.locator((0, import_locatorUtils.getByLabelSelector)(text, options));
  }
  getByPlaceholder(text, options) {
    return this.locator((0, import_locatorUtils.getByPlaceholderSelector)(text, options));
  }
  getByText(text, options) {
    return this.locator((0, import_locatorUtils.getByTextSelector)(text, options));
  }
  getByTitle(text, options) {
    return this.locator((0, import_locatorUtils.getByTitleSelector)(text, options));
  }
  getByRole(role, options = {}) {
    return this.locator((0, import_locatorUtils.getByRoleSelector)(role, options));
  }
  owner() {
    return new Locator(this._frame, this._frameSelector);
  }
  frameLocator(selector) {
    return new FrameLocator(this._frame, this._frameSelector + " >> internal:control=enter-frame >> " + selector);
  }
  first() {
    return new FrameLocator(this._frame, this._frameSelector + " >> nth=0");
  }
  last() {
    return new FrameLocator(this._frame, this._frameSelector + ` >> nth=-1`);
  }
  nth(index) {
    return new FrameLocator(this._frame, this._frameSelector + ` >> nth=${index}`);
  }
}
let _testIdAttributeName = "data-testid";
function testIdAttributeName() {
  return _testIdAttributeName;
}
function setTestIdAttribute(attributeName) {
  _testIdAttributeName = attributeName;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/network.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var network_exports = {};
__export(network_exports, {
  RawHeaders: () => RawHeaders,
  Request: () => Request,
  Response: () => Response,
  Route: () => Route,
  RouteHandler: () => RouteHandler,
  WebSocket: () => WebSocket,
  WebSocketRoute: () => WebSocketRoute,
  WebSocketRouteHandler: () => WebSocketRouteHandler,
  validateHeaders: () => validateHeaders
});
module.exports = __toCommonJS(network_exports);
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_errors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js");
var import_events = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/events.js");
var import_fetch = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fetch.js");
var import_frame = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/frame.js");
var import_waiter = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/waiter.js");
var import_worker = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/worker.js");
var import_assert = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/assert.js");
var import_headers = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/headers.js");
var import_urlMatch = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/urlMatch.js");
var import_manualPromise = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/manualPromise.js");
var import_multimap = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/multimap.js");
var import_rtti = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/rtti.js");
var import_stackTrace = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/stackTrace.js");
var import_mimeType = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/mimeType.js");
class Request extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._redirectedFrom = null;
    this._redirectedTo = null;
    this._failureText = null;
    this._fallbackOverrides = {};
    this._redirectedFrom = Request.fromNullable(initializer.redirectedFrom);
    if (this._redirectedFrom)
      this._redirectedFrom._redirectedTo = this;
    this._provisionalHeaders = new RawHeaders(initializer.headers);
    this._timing = {
      startTime: 0,
      domainLookupStart: -1,
      domainLookupEnd: -1,
      connectStart: -1,
      secureConnectionStart: -1,
      connectEnd: -1,
      requestStart: -1,
      responseStart: -1,
      responseEnd: -1
    };
  }
  static from(request) {
    return request._object;
  }
  static fromNullable(request) {
    return request ? Request.from(request) : null;
  }
  url() {
    return this._fallbackOverrides.url || this._initializer.url;
  }
  resourceType() {
    return this._initializer.resourceType;
  }
  method() {
    return this._fallbackOverrides.method || this._initializer.method;
  }
  postData() {
    return (this._fallbackOverrides.postDataBuffer || this._initializer.postData)?.toString("utf-8") || null;
  }
  postDataBuffer() {
    return this._fallbackOverrides.postDataBuffer || this._initializer.postData || null;
  }
  postDataJSON() {
    const postData = this.postData();
    if (!postData)
      return null;
    const contentType = this.headers()["content-type"];
    if (contentType?.includes("application/x-www-form-urlencoded")) {
      const entries = {};
      const parsed = new URLSearchParams(postData);
      for (const [k, v] of parsed.entries())
        entries[k] = v;
      return entries;
    }
    try {
      return JSON.parse(postData);
    } catch (e) {
      throw new Error("POST data is not a valid JSON object: " + postData);
    }
  }
  /**
   * @deprecated
   */
  headers() {
    if (this._fallbackOverrides.headers)
      return RawHeaders._fromHeadersObjectLossy(this._fallbackOverrides.headers).headers();
    return this._provisionalHeaders.headers();
  }
  async _actualHeaders() {
    if (this._fallbackOverrides.headers)
      return RawHeaders._fromHeadersObjectLossy(this._fallbackOverrides.headers);
    if (!this._actualHeadersPromise) {
      this._actualHeadersPromise = this._wrapApiCall(async () => {
        return new RawHeaders((await this._channel.rawRequestHeaders()).headers);
      }, { internal: true });
    }
    return await this._actualHeadersPromise;
  }
  async allHeaders() {
    return (await this._actualHeaders()).headers();
  }
  async headersArray() {
    return (await this._actualHeaders()).headersArray();
  }
  async headerValue(name) {
    return (await this._actualHeaders()).get(name);
  }
  async response() {
    return Response.fromNullable((await this._channel.response()).response);
  }
  async _internalResponse() {
    return Response.fromNullable((await this._channel.response()).response);
  }
  frame() {
    if (!this._initializer.frame) {
      (0, import_assert.assert)(this.serviceWorker());
      throw new Error("Service Worker requests do not have an associated frame.");
    }
    const frame = import_frame.Frame.from(this._initializer.frame);
    if (!frame._page) {
      throw new Error([
        "Frame for this navigation request is not available, because the request",
        "was issued before the frame is created. You can check whether the request",
        "is a navigation request by calling isNavigationRequest() method."
      ].join("\n"));
    }
    return frame;
  }
  _safePage() {
    return import_frame.Frame.fromNullable(this._initializer.frame)?._page || null;
  }
  serviceWorker() {
    return this._initializer.serviceWorker ? import_worker.Worker.from(this._initializer.serviceWorker) : null;
  }
  isNavigationRequest() {
    return this._initializer.isNavigationRequest;
  }
  redirectedFrom() {
    return this._redirectedFrom;
  }
  redirectedTo() {
    return this._redirectedTo;
  }
  failure() {
    if (this._failureText === null)
      return null;
    return {
      errorText: this._failureText
    };
  }
  timing() {
    return this._timing;
  }
  async sizes() {
    const response = await this.response();
    if (!response)
      throw new Error("Unable to fetch sizes for failed request");
    return (await response._channel.sizes()).sizes;
  }
  _setResponseEndTiming(responseEndTiming) {
    this._timing.responseEnd = responseEndTiming;
    if (this._timing.responseStart === -1)
      this._timing.responseStart = responseEndTiming;
  }
  _finalRequest() {
    return this._redirectedTo ? this._redirectedTo._finalRequest() : this;
  }
  _applyFallbackOverrides(overrides) {
    if (overrides.url)
      this._fallbackOverrides.url = overrides.url;
    if (overrides.method)
      this._fallbackOverrides.method = overrides.method;
    if (overrides.headers)
      this._fallbackOverrides.headers = overrides.headers;
    if ((0, import_rtti.isString)(overrides.postData))
      this._fallbackOverrides.postDataBuffer = Buffer.from(overrides.postData, "utf-8");
    else if (overrides.postData instanceof Buffer)
      this._fallbackOverrides.postDataBuffer = overrides.postData;
    else if (overrides.postData)
      this._fallbackOverrides.postDataBuffer = Buffer.from(JSON.stringify(overrides.postData), "utf-8");
  }
  _fallbackOverridesForContinue() {
    return this._fallbackOverrides;
  }
  _targetClosedScope() {
    return this.serviceWorker()?._closedScope || this._safePage()?._closedOrCrashedScope || new import_manualPromise.LongStandingScope();
  }
}
class Route extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._handlingPromise = null;
    this._didThrow = false;
  }
  static from(route) {
    return route._object;
  }
  request() {
    return Request.from(this._initializer.request);
  }
  async _raceWithTargetClose(promise) {
    return await this.request()._targetClosedScope().safeRace(promise);
  }
  async _startHandling() {
    this._handlingPromise = new import_manualPromise.ManualPromise();
    return await this._handlingPromise;
  }
  async fallback(options = {}) {
    this._checkNotHandled();
    this.request()._applyFallbackOverrides(options);
    this._reportHandled(false);
  }
  async abort(errorCode) {
    await this._handleRoute(async () => {
      await this._raceWithTargetClose(this._channel.abort({ errorCode }));
    });
  }
  async _redirectNavigationRequest(url) {
    await this._handleRoute(async () => {
      await this._raceWithTargetClose(this._channel.redirectNavigationRequest({ url }));
    });
  }
  async fetch(options = {}) {
    return await this._wrapApiCall(async () => {
      return await this._context.request._innerFetch({ request: this.request(), data: options.postData, ...options });
    });
  }
  async fulfill(options = {}) {
    await this._handleRoute(async () => {
      await this._innerFulfill(options);
    });
  }
  async _handleRoute(callback) {
    this._checkNotHandled();
    try {
      await callback();
      this._reportHandled(true);
    } catch (e) {
      this._didThrow = true;
      throw e;
    }
  }
  async _innerFulfill(options = {}) {
    let fetchResponseUid;
    let { status: statusOption, headers: headersOption, body } = options;
    if (options.json !== void 0) {
      (0, import_assert.assert)(options.body === void 0, "Can specify either body or json parameters");
      body = JSON.stringify(options.json);
    }
    if (options.response instanceof import_fetch.APIResponse) {
      statusOption ??= options.response.status();
      headersOption ??= options.response.headers();
      if (body === void 0 && options.path === void 0) {
        if (options.response._request._connection === this._connection)
          fetchResponseUid = options.response._fetchUid();
        else
          body = await options.response.body();
      }
    }
    let isBase64 = false;
    let length = 0;
    if (options.path) {
      const buffer = await this._platform.fs().promises.readFile(options.path);
      body = buffer.toString("base64");
      isBase64 = true;
      length = buffer.length;
    } else if ((0, import_rtti.isString)(body)) {
      isBase64 = false;
      length = Buffer.byteLength(body);
    } else if (body) {
      length = body.length;
      body = body.toString("base64");
      isBase64 = true;
    }
    const headers = {};
    for (const header of Object.keys(headersOption || {}))
      headers[header.toLowerCase()] = String(headersOption[header]);
    if (options.contentType)
      headers["content-type"] = String(options.contentType);
    else if (options.json)
      headers["content-type"] = "application/json";
    else if (options.path)
      headers["content-type"] = (0, import_mimeType.getMimeTypeForPath)(options.path) || "application/octet-stream";
    if (length && !("content-length" in headers))
      headers["content-length"] = String(length);
    await this._raceWithTargetClose(this._channel.fulfill({
      status: statusOption || 200,
      headers: (0, import_headers.headersObjectToArray)(headers),
      body,
      isBase64,
      fetchResponseUid
    }));
  }
  async continue(options = {}) {
    await this._handleRoute(async () => {
      this.request()._applyFallbackOverrides(options);
      await this._innerContinue(
        false
        /* isFallback */
      );
    });
  }
  _checkNotHandled() {
    if (!this._handlingPromise)
      throw new Error("Route is already handled!");
  }
  _reportHandled(done) {
    const chain = this._handlingPromise;
    this._handlingPromise = null;
    chain.resolve(done);
  }
  async _innerContinue(isFallback) {
    const options = this.request()._fallbackOverridesForContinue();
    return await this._raceWithTargetClose(this._channel.continue({
      url: options.url,
      method: options.method,
      headers: options.headers ? (0, import_headers.headersObjectToArray)(options.headers) : void 0,
      postData: options.postDataBuffer,
      isFallback
    }));
  }
}
class WebSocketRoute extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._connected = false;
    this._server = {
      onMessage: (handler) => {
        this._onServerMessage = handler;
      },
      onClose: (handler) => {
        this._onServerClose = handler;
      },
      connectToServer: () => {
        throw new Error(`connectToServer must be called on the page-side WebSocketRoute`);
      },
      url: () => {
        return this._initializer.url;
      },
      close: async (options = {}) => {
        await this._channel.closeServer({ ...options, wasClean: true }).catch(() => {
        });
      },
      send: (message) => {
        if ((0, import_rtti.isString)(message))
          this._channel.sendToServer({ message, isBase64: false }).catch(() => {
          });
        else
          this._channel.sendToServer({ message: message.toString("base64"), isBase64: true }).catch(() => {
          });
      },
      async [Symbol.asyncDispose]() {
        await this.close();
      }
    };
    this._channel.on("messageFromPage", ({ message, isBase64 }) => {
      if (this._onPageMessage)
        this._onPageMessage(isBase64 ? Buffer.from(message, "base64") : message);
      else if (this._connected)
        this._channel.sendToServer({ message, isBase64 }).catch(() => {
        });
    });
    this._channel.on("messageFromServer", ({ message, isBase64 }) => {
      if (this._onServerMessage)
        this._onServerMessage(isBase64 ? Buffer.from(message, "base64") : message);
      else
        this._channel.sendToPage({ message, isBase64 }).catch(() => {
        });
    });
    this._channel.on("closePage", ({ code, reason, wasClean }) => {
      if (this._onPageClose)
        this._onPageClose(code, reason);
      else
        this._channel.closeServer({ code, reason, wasClean }).catch(() => {
        });
    });
    this._channel.on("closeServer", ({ code, reason, wasClean }) => {
      if (this._onServerClose)
        this._onServerClose(code, reason);
      else
        this._channel.closePage({ code, reason, wasClean }).catch(() => {
        });
    });
  }
  static from(route) {
    return route._object;
  }
  url() {
    return this._initializer.url;
  }
  async close(options = {}) {
    await this._channel.closePage({ ...options, wasClean: true }).catch(() => {
    });
  }
  connectToServer() {
    if (this._connected)
      throw new Error("Already connected to the server");
    this._connected = true;
    this._channel.connect().catch(() => {
    });
    return this._server;
  }
  send(message) {
    if ((0, import_rtti.isString)(message))
      this._channel.sendToPage({ message, isBase64: false }).catch(() => {
      });
    else
      this._channel.sendToPage({ message: message.toString("base64"), isBase64: true }).catch(() => {
      });
  }
  onMessage(handler) {
    this._onPageMessage = handler;
  }
  onClose(handler) {
    this._onPageClose = handler;
  }
  async [Symbol.asyncDispose]() {
    await this.close();
  }
  async _afterHandle() {
    if (this._connected)
      return;
    await this._channel.ensureOpened().catch(() => {
    });
  }
}
class WebSocketRouteHandler {
  constructor(baseURL, url, handler) {
    this._baseURL = baseURL;
    this.url = url;
    this.handler = handler;
  }
  static prepareInterceptionPatterns(handlers) {
    const patterns = [];
    let all = false;
    for (const handler of handlers) {
      if ((0, import_rtti.isString)(handler.url))
        patterns.push({ glob: handler.url });
      else if ((0, import_rtti.isRegExp)(handler.url))
        patterns.push({ regexSource: handler.url.source, regexFlags: handler.url.flags });
      else
        all = true;
    }
    if (all)
      return [{ glob: "**/*" }];
    return patterns;
  }
  matches(wsURL) {
    return (0, import_urlMatch.urlMatches)(this._baseURL, wsURL, this.url, true);
  }
  async handle(webSocketRoute) {
    const handler = this.handler;
    await handler(webSocketRoute);
    await webSocketRoute._afterHandle();
  }
}
class Response extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._finishedPromise = new import_manualPromise.ManualPromise();
    this._provisionalHeaders = new RawHeaders(initializer.headers);
    this._request = Request.from(this._initializer.request);
    Object.assign(this._request._timing, this._initializer.timing);
  }
  static from(response) {
    return response._object;
  }
  static fromNullable(response) {
    return response ? Response.from(response) : null;
  }
  url() {
    return this._initializer.url;
  }
  ok() {
    return this._initializer.status === 0 || this._initializer.status >= 200 && this._initializer.status <= 299;
  }
  status() {
    return this._initializer.status;
  }
  statusText() {
    return this._initializer.statusText;
  }
  fromServiceWorker() {
    return this._initializer.fromServiceWorker;
  }
  /**
   * @deprecated
   */
  headers() {
    return this._provisionalHeaders.headers();
  }
  async _actualHeaders() {
    if (!this._actualHeadersPromise) {
      this._actualHeadersPromise = (async () => {
        return new RawHeaders((await this._channel.rawResponseHeaders()).headers);
      })();
    }
    return await this._actualHeadersPromise;
  }
  async allHeaders() {
    return (await this._actualHeaders()).headers();
  }
  async headersArray() {
    return (await this._actualHeaders()).headersArray().slice();
  }
  async headerValue(name) {
    return (await this._actualHeaders()).get(name);
  }
  async headerValues(name) {
    return (await this._actualHeaders()).getAll(name);
  }
  async finished() {
    return await this.request()._targetClosedScope().race(this._finishedPromise);
  }
  async body() {
    return (await this._channel.body()).binary;
  }
  async text() {
    const content = await this.body();
    return content.toString("utf8");
  }
  async json() {
    const content = await this.text();
    return JSON.parse(content);
  }
  request() {
    return this._request;
  }
  frame() {
    return this._request.frame();
  }
  async serverAddr() {
    return (await this._channel.serverAddr()).value || null;
  }
  async securityDetails() {
    return (await this._channel.securityDetails()).value || null;
  }
}
class WebSocket extends import_channelOwner.ChannelOwner {
  static from(webSocket) {
    return webSocket._object;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._isClosed = false;
    this._page = parent;
    this._channel.on("frameSent", (event) => {
      if (event.opcode === 1)
        this.emit(import_events.Events.WebSocket.FrameSent, { payload: event.data });
      else if (event.opcode === 2)
        this.emit(import_events.Events.WebSocket.FrameSent, { payload: Buffer.from(event.data, "base64") });
    });
    this._channel.on("frameReceived", (event) => {
      if (event.opcode === 1)
        this.emit(import_events.Events.WebSocket.FrameReceived, { payload: event.data });
      else if (event.opcode === 2)
        this.emit(import_events.Events.WebSocket.FrameReceived, { payload: Buffer.from(event.data, "base64") });
    });
    this._channel.on("socketError", ({ error }) => this.emit(import_events.Events.WebSocket.Error, error));
    this._channel.on("close", () => {
      this._isClosed = true;
      this.emit(import_events.Events.WebSocket.Close, this);
    });
  }
  url() {
    return this._initializer.url;
  }
  isClosed() {
    return this._isClosed;
  }
  async waitForEvent(event, optionsOrPredicate = {}) {
    return await this._wrapApiCall(async () => {
      const timeout = this._page._timeoutSettings.timeout(typeof optionsOrPredicate === "function" ? {} : optionsOrPredicate);
      const predicate = typeof optionsOrPredicate === "function" ? optionsOrPredicate : optionsOrPredicate.predicate;
      const waiter = import_waiter.Waiter.createForEvent(this, event);
      waiter.rejectOnTimeout(timeout, `Timeout ${timeout}ms exceeded while waiting for event "${event}"`);
      if (event !== import_events.Events.WebSocket.Error)
        waiter.rejectOnEvent(this, import_events.Events.WebSocket.Error, new Error("Socket error"));
      if (event !== import_events.Events.WebSocket.Close)
        waiter.rejectOnEvent(this, import_events.Events.WebSocket.Close, new Error("Socket closed"));
      waiter.rejectOnEvent(this._page, import_events.Events.Page.Close, () => this._page._closeErrorWithReason());
      const result = await waiter.waitForEvent(this, event, predicate);
      waiter.dispose();
      return result;
    });
  }
}
function validateHeaders(headers) {
  for (const key of Object.keys(headers)) {
    const value = headers[key];
    if (!Object.is(value, void 0) && !(0, import_rtti.isString)(value))
      throw new Error(`Expected value of header "${key}" to be String, but "${typeof value}" is found.`);
  }
}
class RouteHandler {
  constructor(platform, baseURL, url, handler, times = Number.MAX_SAFE_INTEGER) {
    this.handledCount = 0;
    this._ignoreException = false;
    this._activeInvocations = /* @__PURE__ */ new Set();
    this._baseURL = baseURL;
    this._times = times;
    this.url = url;
    this.handler = handler;
    this._savedZone = platform.zones.current().pop();
  }
  static prepareInterceptionPatterns(handlers) {
    const patterns = [];
    let all = false;
    for (const handler of handlers) {
      if ((0, import_rtti.isString)(handler.url))
        patterns.push({ glob: handler.url });
      else if ((0, import_rtti.isRegExp)(handler.url))
        patterns.push({ regexSource: handler.url.source, regexFlags: handler.url.flags });
      else
        all = true;
    }
    if (all)
      return [{ glob: "**/*" }];
    return patterns;
  }
  matches(requestURL) {
    return (0, import_urlMatch.urlMatches)(this._baseURL, requestURL, this.url);
  }
  async handle(route) {
    return await this._savedZone.run(async () => this._handleImpl(route));
  }
  async _handleImpl(route) {
    const handlerInvocation = { complete: new import_manualPromise.ManualPromise(), route };
    this._activeInvocations.add(handlerInvocation);
    try {
      return await this._handleInternal(route);
    } catch (e) {
      if (this._ignoreException)
        return false;
      if ((0, import_errors.isTargetClosedError)(e)) {
        (0, import_stackTrace.rewriteErrorMessage)(e, `"${e.message}" while running route callback.
Consider awaiting \`await page.unrouteAll({ behavior: 'ignoreErrors' })\`
before the end of the test to ignore remaining routes in flight.`);
      }
      throw e;
    } finally {
      handlerInvocation.complete.resolve();
      this._activeInvocations.delete(handlerInvocation);
    }
  }
  async stop(behavior) {
    if (behavior === "ignoreErrors") {
      this._ignoreException = true;
    } else {
      const promises = [];
      for (const activation of this._activeInvocations) {
        if (!activation.route._didThrow)
          promises.push(activation.complete);
      }
      await Promise.all(promises);
    }
  }
  async _handleInternal(route) {
    ++this.handledCount;
    const handledPromise = route._startHandling();
    const handler = this.handler;
    const [handled] = await Promise.all([
      handledPromise,
      handler(route, route.request())
    ]);
    return handled;
  }
  willExpire() {
    return this.handledCount + 1 >= this._times;
  }
}
class RawHeaders {
  constructor(headers) {
    this._headersMap = new import_multimap.MultiMap();
    this._headersArray = headers;
    for (const header of headers)
      this._headersMap.set(header.name.toLowerCase(), header.value);
  }
  static _fromHeadersObjectLossy(headers) {
    const headersArray = Object.entries(headers).map(([name, value]) => ({
      name,
      value
    })).filter((header) => header.value !== void 0);
    return new RawHeaders(headersArray);
  }
  get(name) {
    const values = this.getAll(name);
    if (!values || !values.length)
      return null;
    return values.join(name.toLowerCase() === "set-cookie" ? "\n" : ", ");
  }
  getAll(name) {
    return [...this._headersMap.get(name.toLowerCase())];
  }
  headers() {
    const result = {};
    for (const name of this._headersMap.keys())
      result[name] = this.get(name);
    return result;
  }
  headersArray() {
    return this._headersArray;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/page.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var page_exports = {};
__export(page_exports, {
  BindingCall: () => BindingCall,
  Page: () => Page
});
module.exports = __toCommonJS(page_exports);
var import_accessibility = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/accessibility.js");
var import_artifact = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/artifact.js");
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_clientHelper = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clientHelper.js");
var import_coverage = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/coverage.js");
var import_download = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/download.js");
var import_elementHandle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/elementHandle.js");
var import_errors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js");
var import_events = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/events.js");
var import_fileChooser = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fileChooser.js");
var import_frame = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/frame.js");
var import_harRouter = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/harRouter.js");
var import_input = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/input.js");
var import_jsHandle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/jsHandle.js");
var import_network = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/network.js");
var import_video = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/video.js");
var import_waiter = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/waiter.js");
var import_worker = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/worker.js");
var import_timeoutSettings = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/timeoutSettings.js");
var import_assert = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/assert.js");
var import_fileUtils = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fileUtils.js");
var import_headers = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/headers.js");
var import_stringUtils = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/stringUtils.js");
var import_urlMatch = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/urlMatch.js");
var import_manualPromise = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/manualPromise.js");
var import_rtti = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/rtti.js");
var import_consoleMessage = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/consoleMessage.js");
class Page extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._frames = /* @__PURE__ */ new Set();
    this._workers = /* @__PURE__ */ new Set();
    this._closed = false;
    this._closedOrCrashedScope = new import_manualPromise.LongStandingScope();
    this._routes = [];
    this._webSocketRoutes = [];
    this._bindings = /* @__PURE__ */ new Map();
    this._video = null;
    this._closeWasCalled = false;
    this._harRouters = [];
    this._locatorHandlers = /* @__PURE__ */ new Map();
    this._browserContext = parent;
    this._timeoutSettings = new import_timeoutSettings.TimeoutSettings(this._platform, this._browserContext._timeoutSettings);
    this.accessibility = new import_accessibility.Accessibility(this._channel);
    this.keyboard = new import_input.Keyboard(this);
    this.mouse = new import_input.Mouse(this);
    this.request = this._browserContext.request;
    this.touchscreen = new import_input.Touchscreen(this);
    this.clock = this._browserContext.clock;
    this._mainFrame = import_frame.Frame.from(initializer.mainFrame);
    this._mainFrame._page = this;
    this._frames.add(this._mainFrame);
    this._viewportSize = initializer.viewportSize;
    this._closed = initializer.isClosed;
    this._opener = Page.fromNullable(initializer.opener);
    this._channel.on("bindingCall", ({ binding }) => this._onBinding(BindingCall.from(binding)));
    this._channel.on("close", () => this._onClose());
    this._channel.on("crash", () => this._onCrash());
    this._channel.on("download", ({ url, suggestedFilename, artifact }) => {
      const artifactObject = import_artifact.Artifact.from(artifact);
      this.emit(import_events.Events.Page.Download, new import_download.Download(this, url, suggestedFilename, artifactObject));
    });
    this._channel.on("fileChooser", ({ element, isMultiple }) => this.emit(import_events.Events.Page.FileChooser, new import_fileChooser.FileChooser(this, import_elementHandle.ElementHandle.from(element), isMultiple)));
    this._channel.on("frameAttached", ({ frame }) => this._onFrameAttached(import_frame.Frame.from(frame)));
    this._channel.on("frameDetached", ({ frame }) => this._onFrameDetached(import_frame.Frame.from(frame)));
    this._channel.on("locatorHandlerTriggered", ({ uid }) => this._onLocatorHandlerTriggered(uid));
    this._channel.on("route", ({ route }) => this._onRoute(import_network.Route.from(route)));
    this._channel.on("webSocketRoute", ({ webSocketRoute }) => this._onWebSocketRoute(import_network.WebSocketRoute.from(webSocketRoute)));
    this._channel.on("video", ({ artifact }) => {
      const artifactObject = import_artifact.Artifact.from(artifact);
      this._forceVideo()._artifactReady(artifactObject);
    });
    this._channel.on("viewportSizeChanged", ({ viewportSize }) => this._viewportSize = viewportSize);
    this._channel.on("webSocket", ({ webSocket }) => this.emit(import_events.Events.Page.WebSocket, import_network.WebSocket.from(webSocket)));
    this._channel.on("worker", ({ worker }) => this._onWorker(import_worker.Worker.from(worker)));
    this.coverage = new import_coverage.Coverage(this._channel);
    this.once(import_events.Events.Page.Close, () => this._closedOrCrashedScope.close(this._closeErrorWithReason()));
    this.once(import_events.Events.Page.Crash, () => this._closedOrCrashedScope.close(new import_errors.TargetClosedError()));
    this._setEventToSubscriptionMapping(/* @__PURE__ */ new Map([
      [import_events.Events.Page.Console, "console"],
      [import_events.Events.Page.Dialog, "dialog"],
      [import_events.Events.Page.Request, "request"],
      [import_events.Events.Page.Response, "response"],
      [import_events.Events.Page.RequestFinished, "requestFinished"],
      [import_events.Events.Page.RequestFailed, "requestFailed"],
      [import_events.Events.Page.FileChooser, "fileChooser"]
    ]));
  }
  static from(page) {
    return page._object;
  }
  static fromNullable(page) {
    return page ? Page.from(page) : null;
  }
  _onFrameAttached(frame) {
    frame._page = this;
    this._frames.add(frame);
    if (frame._parentFrame)
      frame._parentFrame._childFrames.add(frame);
    this.emit(import_events.Events.Page.FrameAttached, frame);
  }
  _onFrameDetached(frame) {
    this._frames.delete(frame);
    frame._detached = true;
    if (frame._parentFrame)
      frame._parentFrame._childFrames.delete(frame);
    this.emit(import_events.Events.Page.FrameDetached, frame);
  }
  async _onRoute(route) {
    route._context = this.context();
    const routeHandlers = this._routes.slice();
    for (const routeHandler of routeHandlers) {
      if (this._closeWasCalled || this._browserContext._closingStatus !== "none")
        return;
      if (!routeHandler.matches(route.request().url()))
        continue;
      const index = this._routes.indexOf(routeHandler);
      if (index === -1)
        continue;
      if (routeHandler.willExpire())
        this._routes.splice(index, 1);
      const handled = await routeHandler.handle(route);
      if (!this._routes.length)
        this._updateInterceptionPatterns({ internal: true }).catch(() => {
        });
      if (handled)
        return;
    }
    await this._browserContext._onRoute(route);
  }
  async _onWebSocketRoute(webSocketRoute) {
    const routeHandler = this._webSocketRoutes.find((route) => route.matches(webSocketRoute.url()));
    if (routeHandler)
      await routeHandler.handle(webSocketRoute);
    else
      await this._browserContext._onWebSocketRoute(webSocketRoute);
  }
  async _onBinding(bindingCall) {
    const func = this._bindings.get(bindingCall._initializer.name);
    if (func) {
      await bindingCall.call(func);
      return;
    }
    await this._browserContext._onBinding(bindingCall);
  }
  _onWorker(worker) {
    this._workers.add(worker);
    worker._page = this;
    this.emit(import_events.Events.Page.Worker, worker);
  }
  _onClose() {
    this._closed = true;
    this._browserContext._pages.delete(this);
    this._disposeHarRouters();
    this.emit(import_events.Events.Page.Close, this);
  }
  _onCrash() {
    this.emit(import_events.Events.Page.Crash, this);
  }
  context() {
    return this._browserContext;
  }
  async opener() {
    if (!this._opener || this._opener.isClosed())
      return null;
    return this._opener;
  }
  mainFrame() {
    return this._mainFrame;
  }
  frame(frameSelector) {
    const name = (0, import_rtti.isString)(frameSelector) ? frameSelector : frameSelector.name;
    const url = (0, import_rtti.isObject)(frameSelector) ? frameSelector.url : void 0;
    (0, import_assert.assert)(name || url, "Either name or url matcher should be specified");
    return this.frames().find((f) => {
      if (name)
        return f.name() === name;
      return (0, import_urlMatch.urlMatches)(this._browserContext._options.baseURL, f.url(), url);
    }) || null;
  }
  frames() {
    return [...this._frames];
  }
  setDefaultNavigationTimeout(timeout) {
    this._timeoutSettings.setDefaultNavigationTimeout(timeout);
  }
  setDefaultTimeout(timeout) {
    this._timeoutSettings.setDefaultTimeout(timeout);
  }
  _forceVideo() {
    if (!this._video)
      this._video = new import_video.Video(this, this._connection);
    return this._video;
  }
  video() {
    if (!this._browserContext._options.recordVideo)
      return null;
    return this._forceVideo();
  }
  async $(selector, options) {
    return await this._mainFrame.$(selector, options);
  }
  async waitForSelector(selector, options) {
    return await this._mainFrame.waitForSelector(selector, options);
  }
  async dispatchEvent(selector, type, eventInit, options) {
    return await this._mainFrame.dispatchEvent(selector, type, eventInit, options);
  }
  async evaluateHandle(pageFunction, arg) {
    (0, import_jsHandle.assertMaxArguments)(arguments.length, 2);
    return await this._mainFrame.evaluateHandle(pageFunction, arg);
  }
  async $eval(selector, pageFunction, arg) {
    (0, import_jsHandle.assertMaxArguments)(arguments.length, 3);
    return await this._mainFrame.$eval(selector, pageFunction, arg);
  }
  async $$eval(selector, pageFunction, arg) {
    (0, import_jsHandle.assertMaxArguments)(arguments.length, 3);
    return await this._mainFrame.$$eval(selector, pageFunction, arg);
  }
  async $$(selector) {
    return await this._mainFrame.$$(selector);
  }
  async addScriptTag(options = {}) {
    return await this._mainFrame.addScriptTag(options);
  }
  async addStyleTag(options = {}) {
    return await this._mainFrame.addStyleTag(options);
  }
  async exposeFunction(name, callback) {
    await this._channel.exposeBinding({ name });
    const binding = (source, ...args) => callback(...args);
    this._bindings.set(name, binding);
  }
  async exposeBinding(name, callback, options = {}) {
    await this._channel.exposeBinding({ name, needsHandle: options.handle });
    this._bindings.set(name, callback);
  }
  async setExtraHTTPHeaders(headers) {
    (0, import_network.validateHeaders)(headers);
    await this._channel.setExtraHTTPHeaders({ headers: (0, import_headers.headersObjectToArray)(headers) });
  }
  url() {
    return this._mainFrame.url();
  }
  async content() {
    return await this._mainFrame.content();
  }
  async setContent(html, options) {
    return await this._mainFrame.setContent(html, options);
  }
  async goto(url, options) {
    return await this._mainFrame.goto(url, options);
  }
  async reload(options = {}) {
    const waitUntil = (0, import_frame.verifyLoadState)("waitUntil", options.waitUntil === void 0 ? "load" : options.waitUntil);
    return import_network.Response.fromNullable((await this._channel.reload({ ...options, waitUntil, timeout: this._timeoutSettings.navigationTimeout(options) })).response);
  }
  async addLocatorHandler(locator, handler, options = {}) {
    if (locator._frame !== this._mainFrame)
      throw new Error(`Locator must belong to the main frame of this page`);
    if (options.times === 0)
      return;
    const { uid } = await this._channel.registerLocatorHandler({ selector: locator._selector, noWaitAfter: options.noWaitAfter });
    this._locatorHandlers.set(uid, { locator, handler, times: options.times });
  }
  async _onLocatorHandlerTriggered(uid) {
    let remove = false;
    try {
      const handler = this._locatorHandlers.get(uid);
      if (handler && handler.times !== 0) {
        if (handler.times !== void 0)
          handler.times--;
        await handler.handler(handler.locator);
      }
      remove = handler?.times === 0;
    } finally {
      if (remove)
        this._locatorHandlers.delete(uid);
      this._channel.resolveLocatorHandlerNoReply({ uid, remove }).catch(() => {
      });
    }
  }
  async removeLocatorHandler(locator) {
    for (const [uid, data] of this._locatorHandlers) {
      if (data.locator._equals(locator)) {
        this._locatorHandlers.delete(uid);
        await this._channel.unregisterLocatorHandler({ uid }).catch(() => {
        });
      }
    }
  }
  async waitForLoadState(state, options) {
    return await this._mainFrame.waitForLoadState(state, options);
  }
  async waitForNavigation(options) {
    return await this._mainFrame.waitForNavigation(options);
  }
  async waitForURL(url, options) {
    return await this._mainFrame.waitForURL(url, options);
  }
  async waitForRequest(urlOrPredicate, options = {}) {
    const predicate = async (request) => {
      if ((0, import_rtti.isString)(urlOrPredicate) || (0, import_rtti.isRegExp)(urlOrPredicate))
        return (0, import_urlMatch.urlMatches)(this._browserContext._options.baseURL, request.url(), urlOrPredicate);
      return await urlOrPredicate(request);
    };
    const trimmedUrl = trimUrl(urlOrPredicate);
    const logLine = trimmedUrl ? `waiting for request ${trimmedUrl}` : void 0;
    return await this._waitForEvent(import_events.Events.Page.Request, { predicate, timeout: options.timeout }, logLine);
  }
  async waitForResponse(urlOrPredicate, options = {}) {
    const predicate = async (response) => {
      if ((0, import_rtti.isString)(urlOrPredicate) || (0, import_rtti.isRegExp)(urlOrPredicate))
        return (0, import_urlMatch.urlMatches)(this._browserContext._options.baseURL, response.url(), urlOrPredicate);
      return await urlOrPredicate(response);
    };
    const trimmedUrl = trimUrl(urlOrPredicate);
    const logLine = trimmedUrl ? `waiting for response ${trimmedUrl}` : void 0;
    return await this._waitForEvent(import_events.Events.Page.Response, { predicate, timeout: options.timeout }, logLine);
  }
  async waitForEvent(event, optionsOrPredicate = {}) {
    return await this._waitForEvent(event, optionsOrPredicate, `waiting for event "${event}"`);
  }
  _closeErrorWithReason() {
    return new import_errors.TargetClosedError(this._closeReason || this._browserContext._effectiveCloseReason());
  }
  async _waitForEvent(event, optionsOrPredicate, logLine) {
    return await this._wrapApiCall(async () => {
      const timeout = this._timeoutSettings.timeout(typeof optionsOrPredicate === "function" ? {} : optionsOrPredicate);
      const predicate = typeof optionsOrPredicate === "function" ? optionsOrPredicate : optionsOrPredicate.predicate;
      const waiter = import_waiter.Waiter.createForEvent(this, event);
      if (logLine)
        waiter.log(logLine);
      waiter.rejectOnTimeout(timeout, `Timeout ${timeout}ms exceeded while waiting for event "${event}"`);
      if (event !== import_events.Events.Page.Crash)
        waiter.rejectOnEvent(this, import_events.Events.Page.Crash, new Error("Page crashed"));
      if (event !== import_events.Events.Page.Close)
        waiter.rejectOnEvent(this, import_events.Events.Page.Close, () => this._closeErrorWithReason());
      const result = await waiter.waitForEvent(this, event, predicate);
      waiter.dispose();
      return result;
    });
  }
  async goBack(options = {}) {
    const waitUntil = (0, import_frame.verifyLoadState)("waitUntil", options.waitUntil === void 0 ? "load" : options.waitUntil);
    return import_network.Response.fromNullable((await this._channel.goBack({ ...options, waitUntil, timeout: this._timeoutSettings.navigationTimeout(options) })).response);
  }
  async goForward(options = {}) {
    const waitUntil = (0, import_frame.verifyLoadState)("waitUntil", options.waitUntil === void 0 ? "load" : options.waitUntil);
    return import_network.Response.fromNullable((await this._channel.goForward({ ...options, waitUntil, timeout: this._timeoutSettings.navigationTimeout(options) })).response);
  }
  async requestGC() {
    await this._channel.requestGC();
  }
  async emulateMedia(options = {}) {
    await this._channel.emulateMedia({
      media: options.media === null ? "no-override" : options.media,
      colorScheme: options.colorScheme === null ? "no-override" : options.colorScheme,
      reducedMotion: options.reducedMotion === null ? "no-override" : options.reducedMotion,
      forcedColors: options.forcedColors === null ? "no-override" : options.forcedColors,
      contrast: options.contrast === null ? "no-override" : options.contrast
    });
  }
  async setViewportSize(viewportSize) {
    this._viewportSize = viewportSize;
    await this._channel.setViewportSize({ viewportSize });
  }
  viewportSize() {
    return this._viewportSize || null;
  }
  async evaluate(pageFunction, arg) {
    (0, import_jsHandle.assertMaxArguments)(arguments.length, 2);
    return await this._mainFrame.evaluate(pageFunction, arg);
  }
  async _evaluateFunction(functionDeclaration) {
    return this._mainFrame._evaluateFunction(functionDeclaration);
  }
  async addInitScript(script, arg) {
    const source = await (0, import_clientHelper.evaluationScript)(this._platform, script, arg);
    await this._channel.addInitScript({ source });
  }
  async route(url, handler, options = {}) {
    this._routes.unshift(new import_network.RouteHandler(this._platform, this._browserContext._options.baseURL, url, handler, options.times));
    await this._updateInterceptionPatterns({ title: "Route requests" });
  }
  async routeFromHAR(har, options = {}) {
    const localUtils = this._connection.localUtils();
    if (!localUtils)
      throw new Error("Route from har is not supported in thin clients");
    if (options.update) {
      await this._browserContext._recordIntoHAR(har, this, options);
      return;
    }
    const harRouter = await import_harRouter.HarRouter.create(localUtils, har, options.notFound || "abort", { urlMatch: options.url });
    this._harRouters.push(harRouter);
    await harRouter.addPageRoute(this);
  }
  async routeWebSocket(url, handler) {
    this._webSocketRoutes.unshift(new import_network.WebSocketRouteHandler(this._browserContext._options.baseURL, url, handler));
    await this._updateWebSocketInterceptionPatterns({ title: "Route WebSockets" });
  }
  _disposeHarRouters() {
    this._harRouters.forEach((router) => router.dispose());
    this._harRouters = [];
  }
  async unrouteAll(options) {
    await this._unrouteInternal(this._routes, [], options?.behavior);
    this._disposeHarRouters();
  }
  async unroute(url, handler) {
    const removed = [];
    const remaining = [];
    for (const route of this._routes) {
      if ((0, import_urlMatch.urlMatchesEqual)(route.url, url) && (!handler || route.handler === handler))
        removed.push(route);
      else
        remaining.push(route);
    }
    await this._unrouteInternal(removed, remaining, "default");
  }
  async _unrouteInternal(removed, remaining, behavior) {
    this._routes = remaining;
    if (behavior && behavior !== "default") {
      const promises = removed.map((routeHandler) => routeHandler.stop(behavior));
      await Promise.all(promises);
    }
    await this._updateInterceptionPatterns({ title: "Unroute requests" });
  }
  async _updateInterceptionPatterns(options) {
    const patterns = import_network.RouteHandler.prepareInterceptionPatterns(this._routes);
    await this._wrapApiCall(() => this._channel.setNetworkInterceptionPatterns({ patterns }), options);
  }
  async _updateWebSocketInterceptionPatterns(options) {
    const patterns = import_network.WebSocketRouteHandler.prepareInterceptionPatterns(this._webSocketRoutes);
    await this._wrapApiCall(() => this._channel.setWebSocketInterceptionPatterns({ patterns }), options);
  }
  async screenshot(options = {}) {
    const mask = options.mask;
    const copy = { ...options, mask: void 0, timeout: this._timeoutSettings.timeout(options) };
    if (!copy.type)
      copy.type = (0, import_elementHandle.determineScreenshotType)(options);
    if (mask) {
      copy.mask = mask.map((locator) => ({
        frame: locator._frame._channel,
        selector: locator._selector
      }));
    }
    const result = await this._channel.screenshot(copy);
    if (options.path) {
      await (0, import_fileUtils.mkdirIfNeeded)(this._platform, options.path);
      await this._platform.fs().promises.writeFile(options.path, result.binary);
    }
    return result.binary;
  }
  async _expectScreenshot(options) {
    const mask = options?.mask ? options?.mask.map((locator2) => ({
      frame: locator2._frame._channel,
      selector: locator2._selector
    })) : void 0;
    const locator = options.locator ? {
      frame: options.locator._frame._channel,
      selector: options.locator._selector
    } : void 0;
    return await this._channel.expectScreenshot({
      ...options,
      isNot: !!options.isNot,
      locator,
      mask
    });
  }
  async title() {
    return await this._mainFrame.title();
  }
  async bringToFront() {
    await this._channel.bringToFront();
  }
  async [Symbol.asyncDispose]() {
    await this.close();
  }
  async close(options = {}) {
    this._closeReason = options.reason;
    this._closeWasCalled = true;
    try {
      if (this._ownedContext)
        await this._ownedContext.close();
      else
        await this._channel.close(options);
    } catch (e) {
      if ((0, import_errors.isTargetClosedError)(e) && !options.runBeforeUnload)
        return;
      throw e;
    }
  }
  isClosed() {
    return this._closed;
  }
  async click(selector, options) {
    return await this._mainFrame.click(selector, options);
  }
  async dragAndDrop(source, target, options) {
    return await this._mainFrame.dragAndDrop(source, target, options);
  }
  async dblclick(selector, options) {
    await this._mainFrame.dblclick(selector, options);
  }
  async tap(selector, options) {
    return await this._mainFrame.tap(selector, options);
  }
  async fill(selector, value, options) {
    return await this._mainFrame.fill(selector, value, options);
  }
  async consoleMessages() {
    const { messages } = await this._channel.consoleMessages();
    return messages.map((message) => new import_consoleMessage.ConsoleMessage(this._platform, message, this));
  }
  async pageErrors() {
    const { errors } = await this._channel.pageErrors();
    return errors.map((error) => (0, import_errors.parseError)(error));
  }
  locator(selector, options) {
    return this.mainFrame().locator(selector, options);
  }
  getByTestId(testId) {
    return this.mainFrame().getByTestId(testId);
  }
  getByAltText(text, options) {
    return this.mainFrame().getByAltText(text, options);
  }
  getByLabel(text, options) {
    return this.mainFrame().getByLabel(text, options);
  }
  getByPlaceholder(text, options) {
    return this.mainFrame().getByPlaceholder(text, options);
  }
  getByText(text, options) {
    return this.mainFrame().getByText(text, options);
  }
  getByTitle(text, options) {
    return this.mainFrame().getByTitle(text, options);
  }
  getByRole(role, options = {}) {
    return this.mainFrame().getByRole(role, options);
  }
  frameLocator(selector) {
    return this.mainFrame().frameLocator(selector);
  }
  async focus(selector, options) {
    return await this._mainFrame.focus(selector, options);
  }
  async textContent(selector, options) {
    return await this._mainFrame.textContent(selector, options);
  }
  async innerText(selector, options) {
    return await this._mainFrame.innerText(selector, options);
  }
  async innerHTML(selector, options) {
    return await this._mainFrame.innerHTML(selector, options);
  }
  async getAttribute(selector, name, options) {
    return await this._mainFrame.getAttribute(selector, name, options);
  }
  async inputValue(selector, options) {
    return await this._mainFrame.inputValue(selector, options);
  }
  async isChecked(selector, options) {
    return await this._mainFrame.isChecked(selector, options);
  }
  async isDisabled(selector, options) {
    return await this._mainFrame.isDisabled(selector, options);
  }
  async isEditable(selector, options) {
    return await this._mainFrame.isEditable(selector, options);
  }
  async isEnabled(selector, options) {
    return await this._mainFrame.isEnabled(selector, options);
  }
  async isHidden(selector, options) {
    return await this._mainFrame.isHidden(selector, options);
  }
  async isVisible(selector, options) {
    return await this._mainFrame.isVisible(selector, options);
  }
  async hover(selector, options) {
    return await this._mainFrame.hover(selector, options);
  }
  async selectOption(selector, values, options) {
    return await this._mainFrame.selectOption(selector, values, options);
  }
  async setInputFiles(selector, files, options) {
    return await this._mainFrame.setInputFiles(selector, files, options);
  }
  async type(selector, text, options) {
    return await this._mainFrame.type(selector, text, options);
  }
  async press(selector, key, options) {
    return await this._mainFrame.press(selector, key, options);
  }
  async check(selector, options) {
    return await this._mainFrame.check(selector, options);
  }
  async uncheck(selector, options) {
    return await this._mainFrame.uncheck(selector, options);
  }
  async setChecked(selector, checked, options) {
    return await this._mainFrame.setChecked(selector, checked, options);
  }
  async waitForTimeout(timeout) {
    return await this._mainFrame.waitForTimeout(timeout);
  }
  async waitForFunction(pageFunction, arg, options) {
    return await this._mainFrame.waitForFunction(pageFunction, arg, options);
  }
  async requests() {
    const { requests } = await this._channel.requests();
    return requests.map((request) => import_network.Request.from(request));
  }
  workers() {
    return [...this._workers];
  }
  async pause(_options) {
    if (this._platform.isJSDebuggerAttached())
      return;
    const defaultNavigationTimeout = this._browserContext._timeoutSettings.defaultNavigationTimeout();
    const defaultTimeout = this._browserContext._timeoutSettings.defaultTimeout();
    this._browserContext.setDefaultNavigationTimeout(0);
    this._browserContext.setDefaultTimeout(0);
    this._instrumentation?.onWillPause({ keepTestTimeout: !!_options?.__testHookKeepTestTimeout });
    await this._closedOrCrashedScope.safeRace(this.context()._channel.pause());
    this._browserContext.setDefaultNavigationTimeout(defaultNavigationTimeout);
    this._browserContext.setDefaultTimeout(defaultTimeout);
  }
  async pdf(options = {}) {
    const transportOptions = { ...options };
    if (transportOptions.margin)
      transportOptions.margin = { ...transportOptions.margin };
    if (typeof options.width === "number")
      transportOptions.width = options.width + "px";
    if (typeof options.height === "number")
      transportOptions.height = options.height + "px";
    for (const margin of ["top", "right", "bottom", "left"]) {
      const index = margin;
      if (options.margin && typeof options.margin[index] === "number")
        transportOptions.margin[index] = transportOptions.margin[index] + "px";
    }
    const result = await this._channel.pdf(transportOptions);
    if (options.path) {
      const platform = this._platform;
      await platform.fs().promises.mkdir(platform.path().dirname(options.path), { recursive: true });
      await platform.fs().promises.writeFile(options.path, result.pdf);
    }
    return result.pdf;
  }
  async _snapshotForAI(options = {}) {
    const result = await this._channel.snapshotForAI({ timeout: this._timeoutSettings.timeout(options) });
    return result.snapshot;
  }
}
class BindingCall extends import_channelOwner.ChannelOwner {
  static from(channel) {
    return channel._object;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
  }
  async call(func) {
    try {
      const frame = import_frame.Frame.from(this._initializer.frame);
      const source = {
        context: frame._page.context(),
        page: frame._page,
        frame
      };
      let result;
      if (this._initializer.handle)
        result = await func(source, import_jsHandle.JSHandle.from(this._initializer.handle));
      else
        result = await func(source, ...this._initializer.args.map(import_jsHandle.parseResult));
      this._channel.resolve({ result: (0, import_jsHandle.serializeArgument)(result) }).catch(() => {
      });
    } catch (e) {
      this._channel.reject({ error: (0, import_errors.serializeError)(e) }).catch(() => {
      });
    }
  }
}
function trimUrl(param) {
  if ((0, import_rtti.isRegExp)(param))
    return `/${(0, import_stringUtils.trimStringWithEllipsis)(param.source, 50)}/${param.flags}`;
  if ((0, import_rtti.isString)(param))
    return `"${(0, import_stringUtils.trimStringWithEllipsis)(param, 50)}"`;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/playwright.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var playwright_exports = {};
__export(playwright_exports, {
  Playwright: () => Playwright
});
module.exports = __toCommonJS(playwright_exports);
var import_android = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/android.js");
var import_browser = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browser.js");
var import_browserType = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/browserType.js");
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_electron = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/electron.js");
var import_errors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js");
var import_fetch = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/fetch.js");
var import_selectors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/selectors.js");
class Playwright extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this.request = new import_fetch.APIRequest(this);
    this.chromium = import_browserType.BrowserType.from(initializer.chromium);
    this.chromium._playwright = this;
    this.firefox = import_browserType.BrowserType.from(initializer.firefox);
    this.firefox._playwright = this;
    this.webkit = import_browserType.BrowserType.from(initializer.webkit);
    this.webkit._playwright = this;
    this._android = import_android.Android.from(initializer.android);
    this._android._playwright = this;
    this._electron = import_electron.Electron.from(initializer.electron);
    this._electron._playwright = this;
    this._bidiChromium = import_browserType.BrowserType.from(initializer._bidiChromium);
    this._bidiChromium._playwright = this;
    this._bidiFirefox = import_browserType.BrowserType.from(initializer._bidiFirefox);
    this._bidiFirefox._playwright = this;
    this.devices = this._connection.localUtils()?.devices ?? {};
    this.selectors = new import_selectors.Selectors(this._connection._platform);
    this.errors = { TimeoutError: import_errors.TimeoutError };
  }
  static from(channel) {
    return channel._object;
  }
  _browserTypes() {
    return [this.chromium, this.firefox, this.webkit, this._bidiChromium, this._bidiFirefox];
  }
  _preLaunchedBrowser() {
    const browser = import_browser.Browser.from(this._initializer.preLaunchedBrowser);
    browser._connectToBrowserType(this[browser._name], {}, void 0);
    return browser;
  }
  _allContexts() {
    return this._browserTypes().flatMap((type) => [...type._contexts]);
  }
  _allPages() {
    return this._allContexts().flatMap((context) => context.pages());
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/selectors.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var selectors_exports = {};
__export(selectors_exports, {
  Selectors: () => Selectors
});
module.exports = __toCommonJS(selectors_exports);
var import_clientHelper = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/clientHelper.js");
var import_locator = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/locator.js");
class Selectors {
  constructor(platform) {
    this._selectorEngines = [];
    this._contextsForSelectors = /* @__PURE__ */ new Set();
    this._platform = platform;
  }
  async register(name, script, options = {}) {
    if (this._selectorEngines.some((engine) => engine.name === name))
      throw new Error(`selectors.register: "${name}" selector engine has been already registered`);
    const source = await (0, import_clientHelper.evaluationScript)(this._platform, script, void 0, false);
    const selectorEngine = { ...options, name, source };
    for (const context of this._contextsForSelectors)
      await context._channel.registerSelectorEngine({ selectorEngine });
    this._selectorEngines.push(selectorEngine);
  }
  setTestIdAttribute(attributeName) {
    this._testIdAttributeName = attributeName;
    (0, import_locator.setTestIdAttribute)(attributeName);
    for (const context of this._contextsForSelectors)
      context._channel.setTestIdAttributeName({ testIdAttributeName: attributeName }).catch(() => {
      });
  }
  _withSelectorOptions(options) {
    return { ...options, selectorEngines: this._selectorEngines, testIdAttributeName: this._testIdAttributeName };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/stream.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var stream_exports = {};
__export(stream_exports, {
  Stream: () => Stream
});
module.exports = __toCommonJS(stream_exports);
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
class Stream extends import_channelOwner.ChannelOwner {
  static from(Stream2) {
    return Stream2._object;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
  }
  stream() {
    return this._platform.streamReadable(this._channel);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/timeoutSettings.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var timeoutSettings_exports = {};
__export(timeoutSettings_exports, {
  TimeoutSettings: () => TimeoutSettings
});
module.exports = __toCommonJS(timeoutSettings_exports);
var import_time = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/time.js");
class TimeoutSettings {
  constructor(platform, parent) {
    this._parent = parent;
    this._platform = platform;
  }
  setDefaultTimeout(timeout) {
    this._defaultTimeout = timeout;
  }
  setDefaultNavigationTimeout(timeout) {
    this._defaultNavigationTimeout = timeout;
  }
  defaultNavigationTimeout() {
    return this._defaultNavigationTimeout;
  }
  defaultTimeout() {
    return this._defaultTimeout;
  }
  navigationTimeout(options) {
    if (typeof options.timeout === "number")
      return options.timeout;
    if (this._defaultNavigationTimeout !== void 0)
      return this._defaultNavigationTimeout;
    if (this._platform.isDebugMode())
      return 0;
    if (this._defaultTimeout !== void 0)
      return this._defaultTimeout;
    if (this._parent)
      return this._parent.navigationTimeout(options);
    return import_time.DEFAULT_PLAYWRIGHT_TIMEOUT;
  }
  timeout(options) {
    if (typeof options.timeout === "number")
      return options.timeout;
    if (this._platform.isDebugMode())
      return 0;
    if (this._defaultTimeout !== void 0)
      return this._defaultTimeout;
    if (this._parent)
      return this._parent.timeout(options);
    return import_time.DEFAULT_PLAYWRIGHT_TIMEOUT;
  }
  launchTimeout(options) {
    if (typeof options.timeout === "number")
      return options.timeout;
    if (this._platform.isDebugMode())
      return 0;
    if (this._parent)
      return this._parent.launchTimeout(options);
    return import_time.DEFAULT_PLAYWRIGHT_LAUNCH_TIMEOUT;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/tracing.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var tracing_exports = {};
__export(tracing_exports, {
  Tracing: () => Tracing
});
module.exports = __toCommonJS(tracing_exports);
var import_artifact = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/artifact.js");
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
class Tracing extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    this._includeSources = false;
    this._isTracing = false;
  }
  static from(channel) {
    return channel._object;
  }
  async start(options = {}) {
    await this._wrapApiCall(async () => {
      this._includeSources = !!options.sources;
      await this._channel.tracingStart({
        name: options.name,
        snapshots: options.snapshots,
        screenshots: options.screenshots,
        live: options._live
      });
      const { traceName } = await this._channel.tracingStartChunk({ name: options.name, title: options.title });
      await this._startCollectingStacks(traceName);
    });
  }
  async startChunk(options = {}) {
    await this._wrapApiCall(async () => {
      const { traceName } = await this._channel.tracingStartChunk(options);
      await this._startCollectingStacks(traceName);
    });
  }
  async group(name, options = {}) {
    await this._channel.tracingGroup({ name, location: options.location });
  }
  async groupEnd() {
    await this._channel.tracingGroupEnd();
  }
  async _startCollectingStacks(traceName) {
    if (!this._isTracing) {
      this._isTracing = true;
      this._connection.setIsTracing(true);
    }
    const result = await this._connection.localUtils()?.tracingStarted({ tracesDir: this._tracesDir, traceName });
    this._stacksId = result?.stacksId;
  }
  async stopChunk(options = {}) {
    await this._wrapApiCall(async () => {
      await this._doStopChunk(options.path);
    });
  }
  async stop(options = {}) {
    await this._wrapApiCall(async () => {
      await this._doStopChunk(options.path);
      await this._channel.tracingStop();
    });
  }
  async _doStopChunk(filePath) {
    this._resetStackCounter();
    if (!filePath) {
      await this._channel.tracingStopChunk({ mode: "discard" });
      if (this._stacksId)
        await this._connection.localUtils().traceDiscarded({ stacksId: this._stacksId });
      return;
    }
    const localUtils = this._connection.localUtils();
    if (!localUtils)
      throw new Error("Cannot save trace in thin clients");
    const isLocal = !this._connection.isRemote();
    if (isLocal) {
      const result2 = await this._channel.tracingStopChunk({ mode: "entries" });
      await localUtils.zip({ zipFile: filePath, entries: result2.entries, mode: "write", stacksId: this._stacksId, includeSources: this._includeSources });
      return;
    }
    const result = await this._channel.tracingStopChunk({ mode: "archive" });
    if (!result.artifact) {
      if (this._stacksId)
        await localUtils.traceDiscarded({ stacksId: this._stacksId });
      return;
    }
    const artifact = import_artifact.Artifact.from(result.artifact);
    await artifact.saveAs(filePath);
    await artifact.delete();
    await localUtils.zip({ zipFile: filePath, entries: [], mode: "append", stacksId: this._stacksId, includeSources: this._includeSources });
  }
  _resetStackCounter() {
    if (this._isTracing) {
      this._isTracing = false;
      this._connection.setIsTracing(false);
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/types.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var types_exports = {};
__export(types_exports, {
  kLifecycleEvents: () => kLifecycleEvents
});
module.exports = __toCommonJS(types_exports);
const kLifecycleEvents = /* @__PURE__ */ new Set(["load", "domcontentloaded", "networkidle", "commit"]);
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/video.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var video_exports = {};
__export(video_exports, {
  Video: () => Video
});
module.exports = __toCommonJS(video_exports);
var import_manualPromise = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/manualPromise.js");
class Video {
  constructor(page, connection) {
    this._artifact = null;
    this._artifactReadyPromise = new import_manualPromise.ManualPromise();
    this._isRemote = false;
    this._isRemote = connection.isRemote();
    this._artifact = page._closedOrCrashedScope.safeRace(this._artifactReadyPromise);
  }
  _artifactReady(artifact) {
    this._artifactReadyPromise.resolve(artifact);
  }
  async path() {
    if (this._isRemote)
      throw new Error(`Path is not available when connecting remotely. Use saveAs() to save a local copy.`);
    const artifact = await this._artifact;
    if (!artifact)
      throw new Error("Page did not produce any video frames");
    return artifact._initializer.absolutePath;
  }
  async saveAs(path) {
    const artifact = await this._artifact;
    if (!artifact)
      throw new Error("Page did not produce any video frames");
    return await artifact.saveAs(path);
  }
  async delete() {
    const artifact = await this._artifact;
    if (artifact)
      await artifact.delete();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/waiter.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var waiter_exports = {};
__export(waiter_exports, {
  Waiter: () => Waiter
});
module.exports = __toCommonJS(waiter_exports);
var import_errors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js");
var import_stackTrace = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/stackTrace.js");
class Waiter {
  constructor(channelOwner, event) {
    this._failures = [];
    this._logs = [];
    this._waitId = channelOwner._platform.createGuid();
    this._channelOwner = channelOwner;
    this._savedZone = channelOwner._platform.zones.current().pop();
    this._channelOwner._channel.waitForEventInfo({ info: { waitId: this._waitId, phase: "before", event } }).catch(() => {
    });
    this._dispose = [
      () => this._channelOwner._wrapApiCall(async () => {
        await this._channelOwner._channel.waitForEventInfo({ info: { waitId: this._waitId, phase: "after", error: this._error } });
      }, { internal: true }).catch(() => {
      })
    ];
  }
  static createForEvent(channelOwner, event) {
    return new Waiter(channelOwner, event);
  }
  async waitForEvent(emitter, event, predicate) {
    const { promise, dispose } = waitForEvent(emitter, event, this._savedZone, predicate);
    return await this.waitForPromise(promise, dispose);
  }
  rejectOnEvent(emitter, event, error, predicate) {
    const { promise, dispose } = waitForEvent(emitter, event, this._savedZone, predicate);
    this._rejectOn(promise.then(() => {
      throw typeof error === "function" ? error() : error;
    }), dispose);
  }
  rejectOnTimeout(timeout, message) {
    if (!timeout)
      return;
    const { promise, dispose } = waitForTimeout(timeout);
    this._rejectOn(promise.then(() => {
      throw new import_errors.TimeoutError(message);
    }), dispose);
  }
  rejectImmediately(error) {
    this._immediateError = error;
  }
  dispose() {
    for (const dispose of this._dispose)
      dispose();
  }
  async waitForPromise(promise, dispose) {
    try {
      if (this._immediateError)
        throw this._immediateError;
      const result = await Promise.race([promise, ...this._failures]);
      if (dispose)
        dispose();
      return result;
    } catch (e) {
      if (dispose)
        dispose();
      this._error = e.message;
      this.dispose();
      (0, import_stackTrace.rewriteErrorMessage)(e, e.message + formatLogRecording(this._logs));
      throw e;
    }
  }
  log(s) {
    this._logs.push(s);
    this._channelOwner._wrapApiCall(async () => {
      await this._channelOwner._channel.waitForEventInfo({ info: { waitId: this._waitId, phase: "log", message: s } });
    }, { internal: true }).catch(() => {
    });
  }
  _rejectOn(promise, dispose) {
    this._failures.push(promise);
    if (dispose)
      this._dispose.push(dispose);
  }
}
function waitForEvent(emitter, event, savedZone, predicate) {
  let listener;
  const promise = new Promise((resolve, reject) => {
    listener = async (eventArg) => {
      await savedZone.run(async () => {
        try {
          if (predicate && !await predicate(eventArg))
            return;
          emitter.removeListener(event, listener);
          resolve(eventArg);
        } catch (e) {
          emitter.removeListener(event, listener);
          reject(e);
        }
      });
    };
    emitter.addListener(event, listener);
  });
  const dispose = () => emitter.removeListener(event, listener);
  return { promise, dispose };
}
function waitForTimeout(timeout) {
  let timeoutId;
  const promise = new Promise((resolve) => timeoutId = setTimeout(resolve, timeout));
  const dispose = () => clearTimeout(timeoutId);
  return { promise, dispose };
}
function formatLogRecording(log) {
  if (!log.length)
    return "";
  const header = ` logs `;
  const headerLength = 60;
  const leftLength = (headerLength - header.length) / 2;
  const rightLength = headerLength - header.length - leftLength;
  return `
${"=".repeat(leftLength)}${header}${"=".repeat(rightLength)}
${log.join("\n")}
${"=".repeat(headerLength)}`;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/webError.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var webError_exports = {};
__export(webError_exports, {
  WebError: () => WebError
});
module.exports = __toCommonJS(webError_exports);
class WebError {
  constructor(page, error) {
    this._page = page;
    this._error = error;
  }
  page() {
    return this._page;
  }
  error() {
    return this._error;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/webSocket.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var webSocket_exports = {};
__export(webSocket_exports, {
  connectOverWebSocket: () => connectOverWebSocket
});
module.exports = __toCommonJS(webSocket_exports);
var import_connection = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/connection.js");
async function connectOverWebSocket(parentConnection, params) {
  const localUtils = parentConnection.localUtils();
  const transport = localUtils ? new JsonPipeTransport(localUtils) : new WebSocketTransport();
  const connectHeaders = await transport.connect(params);
  const connection = new import_connection.Connection(parentConnection._platform, localUtils, parentConnection._instrumentation, connectHeaders);
  connection.markAsRemote();
  connection.on("close", () => transport.close());
  let closeError;
  const onTransportClosed = (reason) => {
    connection.close(reason || closeError);
  };
  transport.onClose((reason) => onTransportClosed(reason));
  connection.onmessage = (message) => transport.send(message).catch(() => onTransportClosed());
  transport.onMessage((message) => {
    try {
      connection.dispatch(message);
    } catch (e) {
      closeError = String(e);
      transport.close().catch(() => {
      });
    }
  });
  return connection;
}
class JsonPipeTransport {
  constructor(owner) {
    this._owner = owner;
  }
  async connect(params) {
    const { pipe, headers: connectHeaders } = await this._owner._channel.connect(params);
    this._pipe = pipe;
    return connectHeaders;
  }
  async send(message) {
    await this._pipe.send({ message });
  }
  onMessage(callback) {
    this._pipe.on("message", ({ message }) => callback(message));
  }
  onClose(callback) {
    this._pipe.on("closed", ({ reason }) => callback(reason));
  }
  async close() {
    await this._pipe.close().catch(() => {
    });
  }
}
class WebSocketTransport {
  async connect(params) {
    this._ws = new window.WebSocket(params.wsEndpoint);
    return [];
  }
  async send(message) {
    this._ws.send(JSON.stringify(message));
  }
  onMessage(callback) {
    this._ws.addEventListener("message", (event) => callback(JSON.parse(event.data)));
  }
  onClose(callback) {
    this._ws.addEventListener("close", () => callback());
  }
  async close() {
    this._ws.close();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/worker.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var worker_exports = {};
__export(worker_exports, {
  Worker: () => Worker
});
module.exports = __toCommonJS(worker_exports);
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
var import_consoleMessage = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/consoleMessage.js");
var import_errors = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/errors.js");
var import_events = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/events.js");
var import_jsHandle = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/jsHandle.js");
var import_manualPromise = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/utils/isomorphic/manualPromise.js");
class Worker extends import_channelOwner.ChannelOwner {
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
    // Set for service workers.
    this._closedScope = new import_manualPromise.LongStandingScope();
    this._channel.on("close", () => {
      if (this._page)
        this._page._workers.delete(this);
      if (this._context)
        this._context._serviceWorkers.delete(this);
      this.emit(import_events.Events.Worker.Close, this);
    });
    this._channel.on("console", (event) => {
      this.emit(import_events.Events.Worker.Console, new import_consoleMessage.ConsoleMessage(this._page?.context()._platform ?? this._context?._platform, event, null));
    });
    this.once(import_events.Events.Worker.Close, () => this._closedScope.close(this._page?._closeErrorWithReason() || new import_errors.TargetClosedError()));
    this._setEventToSubscriptionMapping(/* @__PURE__ */ new Map([
      [import_events.Events.Worker.Console, "console"]
    ]));
  }
  static from(worker) {
    return worker._object;
  }
  url() {
    return this._initializer.url;
  }
  async evaluate(pageFunction, arg) {
    (0, import_jsHandle.assertMaxArguments)(arguments.length, 2);
    const result = await this._channel.evaluateExpression({ expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: (0, import_jsHandle.serializeArgument)(arg) });
    return (0, import_jsHandle.parseResult)(result.value);
  }
  async evaluateHandle(pageFunction, arg) {
    (0, import_jsHandle.assertMaxArguments)(arguments.length, 2);
    const result = await this._channel.evaluateExpressionHandle({ expression: String(pageFunction), isFunction: typeof pageFunction === "function", arg: (0, import_jsHandle.serializeArgument)(arg) });
    return import_jsHandle.JSHandle.from(result.handle);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/writableStream.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var writableStream_exports = {};
__export(writableStream_exports, {
  WritableStream: () => WritableStream
});
module.exports = __toCommonJS(writableStream_exports);
var import_channelOwner = __webpack_require__("../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/client/channelOwner.js");
class WritableStream extends import_channelOwner.ChannelOwner {
  static from(Stream) {
    return Stream._object;
  }
  constructor(parent, type, guid, initializer) {
    super(parent, type, guid, initializer);
  }
  stream() {
    return this._platform.streamWritable(this._channel);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/generated/bindingsControllerSource.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var bindingsControllerSource_exports = {};
__export(bindingsControllerSource_exports, {
  source: () => source
});
module.exports = __toCommonJS(bindingsControllerSource_exports);
const source = '\nvar __commonJS = obj => {\n  let required = false;\n  let result;\n  return function __require() {\n    if (!required) {\n      required = true;\n      let fn;\n      for (const name in obj) { fn = obj[name]; break; }\n      const module = { exports: {} };\n      fn(module.exports, module);\n      result = module.exports;\n    }\n    return result;\n  }\n};\nvar __export = (target, all) => {for (var name in all) target[name] = all[name];};\nvar __toESM = mod => ({ ...mod, \'default\': mod });\nvar __toCommonJS = mod => ({ ...mod, __esModule: true });\n\n\n// packages/injected/src/bindingsController.ts\nvar bindingsController_exports = {};\n__export(bindingsController_exports, {\n  BindingsController: () => BindingsController\n});\nmodule.exports = __toCommonJS(bindingsController_exports);\n\n// packages/playwright-core/src/utils/isomorphic/utilityScriptSerializers.ts\nfunction isRegExp(obj) {\n  try {\n    return obj instanceof RegExp || Object.prototype.toString.call(obj) === "[object RegExp]";\n  } catch (error) {\n    return false;\n  }\n}\nfunction isDate(obj) {\n  try {\n    return obj instanceof Date || Object.prototype.toString.call(obj) === "[object Date]";\n  } catch (error) {\n    return false;\n  }\n}\nfunction isURL(obj) {\n  try {\n    return obj instanceof URL || Object.prototype.toString.call(obj) === "[object URL]";\n  } catch (error) {\n    return false;\n  }\n}\nfunction isError(obj) {\n  var _a;\n  try {\n    return obj instanceof Error || obj && ((_a = Object.getPrototypeOf(obj)) == null ? void 0 : _a.name) === "Error";\n  } catch (error) {\n    return false;\n  }\n}\nfunction isTypedArray(obj, constructor) {\n  try {\n    return obj instanceof constructor || Object.prototype.toString.call(obj) === `[object ${constructor.name}]`;\n  } catch (error) {\n    return false;\n  }\n}\nvar typedArrayConstructors = {\n  i8: Int8Array,\n  ui8: Uint8Array,\n  ui8c: Uint8ClampedArray,\n  i16: Int16Array,\n  ui16: Uint16Array,\n  i32: Int32Array,\n  ui32: Uint32Array,\n  // TODO: add Float16Array once it\'s in baseline\n  f32: Float32Array,\n  f64: Float64Array,\n  bi64: BigInt64Array,\n  bui64: BigUint64Array\n};\nfunction typedArrayToBase64(array) {\n  if ("toBase64" in array)\n    return array.toBase64();\n  const binary = Array.from(new Uint8Array(array.buffer, array.byteOffset, array.byteLength)).map((b) => String.fromCharCode(b)).join("");\n  return btoa(binary);\n}\nfunction serializeAsCallArgument(value, handleSerializer) {\n  return serialize(value, handleSerializer, { visited: /* @__PURE__ */ new Map(), lastId: 0 });\n}\nfunction serialize(value, handleSerializer, visitorInfo) {\n  if (value && typeof value === "object") {\n    if (typeof globalThis.Window === "function" && value instanceof globalThis.Window)\n      return "ref: <Window>";\n    if (typeof globalThis.Document === "function" && value instanceof globalThis.Document)\n      return "ref: <Document>";\n    if (typeof globalThis.Node === "function" && value instanceof globalThis.Node)\n      return "ref: <Node>";\n  }\n  return innerSerialize(value, handleSerializer, visitorInfo);\n}\nfunction innerSerialize(value, handleSerializer, visitorInfo) {\n  var _a;\n  const result = handleSerializer(value);\n  if ("fallThrough" in result)\n    value = result.fallThrough;\n  else\n    return result;\n  if (typeof value === "symbol")\n    return { v: "undefined" };\n  if (Object.is(value, void 0))\n    return { v: "undefined" };\n  if (Object.is(value, null))\n    return { v: "null" };\n  if (Object.is(value, NaN))\n    return { v: "NaN" };\n  if (Object.is(value, Infinity))\n    return { v: "Infinity" };\n  if (Object.is(value, -Infinity))\n    return { v: "-Infinity" };\n  if (Object.is(value, -0))\n    return { v: "-0" };\n  if (typeof value === "boolean")\n    return value;\n  if (typeof value === "number")\n    return value;\n  if (typeof value === "string")\n    return value;\n  if (typeof value === "bigint")\n    return { bi: value.toString() };\n  if (isError(value)) {\n    let stack;\n    if ((_a = value.stack) == null ? void 0 : _a.startsWith(value.name + ": " + value.message)) {\n      stack = value.stack;\n    } else {\n      stack = `${value.name}: ${value.message}\n${value.stack}`;\n    }\n    return { e: { n: value.name, m: value.message, s: stack } };\n  }\n  if (isDate(value))\n    return { d: value.toJSON() };\n  if (isURL(value))\n    return { u: value.toJSON() };\n  if (isRegExp(value))\n    return { r: { p: value.source, f: value.flags } };\n  for (const [k, ctor] of Object.entries(typedArrayConstructors)) {\n    if (isTypedArray(value, ctor))\n      return { ta: { b: typedArrayToBase64(value), k } };\n  }\n  const id = visitorInfo.visited.get(value);\n  if (id)\n    return { ref: id };\n  if (Array.isArray(value)) {\n    const a = [];\n    const id2 = ++visitorInfo.lastId;\n    visitorInfo.visited.set(value, id2);\n    for (let i = 0; i < value.length; ++i)\n      a.push(serialize(value[i], handleSerializer, visitorInfo));\n    return { a, id: id2 };\n  }\n  if (typeof value === "object") {\n    const o = [];\n    const id2 = ++visitorInfo.lastId;\n    visitorInfo.visited.set(value, id2);\n    for (const name of Object.keys(value)) {\n      let item;\n      try {\n        item = value[name];\n      } catch (e) {\n        continue;\n      }\n      if (name === "toJSON" && typeof item === "function")\n        o.push({ k: name, v: { o: [], id: 0 } });\n      else\n        o.push({ k: name, v: serialize(item, handleSerializer, visitorInfo) });\n    }\n    let jsonWrapper;\n    try {\n      if (o.length === 0 && value.toJSON && typeof value.toJSON === "function")\n        jsonWrapper = { value: value.toJSON() };\n    } catch (e) {\n    }\n    if (jsonWrapper)\n      return innerSerialize(jsonWrapper.value, handleSerializer, visitorInfo);\n    return { o, id: id2 };\n  }\n}\n\n// packages/injected/src/bindingsController.ts\nvar BindingsController = class {\n  constructor(global, globalBindingName) {\n    this._bindings = /* @__PURE__ */ new Map();\n    this._global = global;\n    this._globalBindingName = globalBindingName;\n  }\n  addBinding(bindingName, needsHandle) {\n    const data = {\n      callbacks: /* @__PURE__ */ new Map(),\n      lastSeq: 0,\n      handles: /* @__PURE__ */ new Map(),\n      removed: false\n    };\n    this._bindings.set(bindingName, data);\n    this._global[bindingName] = (...args) => {\n      if (data.removed)\n        throw new Error(`binding "${bindingName}" has been removed`);\n      if (needsHandle && args.slice(1).some((arg) => arg !== void 0))\n        throw new Error(`exposeBindingHandle supports a single argument, ${args.length} received`);\n      const seq = ++data.lastSeq;\n      const promise = new Promise((resolve, reject) => data.callbacks.set(seq, { resolve, reject }));\n      let payload;\n      if (needsHandle) {\n        data.handles.set(seq, args[0]);\n        payload = { name: bindingName, seq };\n      } else {\n        const serializedArgs = [];\n        for (let i = 0; i < args.length; i++) {\n          serializedArgs[i] = serializeAsCallArgument(args[i], (v) => {\n            return { fallThrough: v };\n          });\n        }\n        payload = { name: bindingName, seq, serializedArgs };\n      }\n      this._global[this._globalBindingName](JSON.stringify(payload));\n      return promise;\n    };\n  }\n  removeBinding(bindingName) {\n    const data = this._bindings.get(bindingName);\n    if (data)\n      data.removed = true;\n    this._bindings.delete(bindingName);\n    delete this._global[bindingName];\n  }\n  takeBindingHandle(arg) {\n    const handles = this._bindings.get(arg.name).handles;\n    const handle = handles.get(arg.seq);\n    handles.delete(arg.seq);\n    return handle;\n  }\n  deliverBindingResult(arg) {\n    const callbacks = this._bindings.get(arg.name).callbacks;\n    if ("error" in arg)\n      callbacks.get(arg.seq).reject(arg.error);\n    else\n      callbacks.get(arg.seq).resolve(arg.result);\n    callbacks.delete(arg.seq);\n  }\n};\n';
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/generated/clockSource.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var clockSource_exports = {};
__export(clockSource_exports, {
  source: () => source
});
module.exports = __toCommonJS(clockSource_exports);
const source = '\nvar __commonJS = obj => {\n  let required = false;\n  let result;\n  return function __require() {\n    if (!required) {\n      required = true;\n      let fn;\n      for (const name in obj) { fn = obj[name]; break; }\n      const module = { exports: {} };\n      fn(module.exports, module);\n      result = module.exports;\n    }\n    return result;\n  }\n};\nvar __export = (target, all) => {for (var name in all) target[name] = all[name];};\nvar __toESM = mod => ({ ...mod, \'default\': mod });\nvar __toCommonJS = mod => ({ ...mod, __esModule: true });\n\n\n// packages/injected/src/clock.ts\nvar clock_exports = {};\n__export(clock_exports, {\n  ClockController: () => ClockController,\n  createClock: () => createClock,\n  inject: () => inject,\n  install: () => install\n});\nmodule.exports = __toCommonJS(clock_exports);\nvar ClockController = class {\n  constructor(embedder) {\n    this._duringTick = false;\n    this._uniqueTimerId = idCounterStart;\n    this.disposables = [];\n    this._log = [];\n    this._timers = /* @__PURE__ */ new Map();\n    this._now = { time: asWallTime(0), isFixedTime: false, ticks: 0, origin: asWallTime(-1) };\n    this._embedder = embedder;\n  }\n  uninstall() {\n    this.disposables.forEach((dispose) => dispose());\n    this.disposables.length = 0;\n  }\n  now() {\n    this._replayLogOnce();\n    this._syncRealTime();\n    return this._now.time;\n  }\n  install(time) {\n    this._replayLogOnce();\n    this._innerSetTime(asWallTime(time));\n  }\n  setSystemTime(time) {\n    this._replayLogOnce();\n    this._innerSetTime(asWallTime(time));\n  }\n  setFixedTime(time) {\n    this._replayLogOnce();\n    this._innerSetFixedTime(asWallTime(time));\n  }\n  performanceNow() {\n    this._replayLogOnce();\n    this._syncRealTime();\n    return this._now.ticks;\n  }\n  _syncRealTime() {\n    if (!this._realTime)\n      return;\n    const now = this._embedder.performanceNow();\n    const sinceLastSync = now - this._realTime.lastSyncTicks;\n    if (sinceLastSync > 0) {\n      this._advanceNow(shiftTicks(this._now.ticks, sinceLastSync));\n      this._realTime.lastSyncTicks = now;\n    }\n  }\n  _innerSetTime(time) {\n    this._now.time = time;\n    this._now.isFixedTime = false;\n    if (this._now.origin < 0)\n      this._now.origin = this._now.time;\n  }\n  _innerSetFixedTime(time) {\n    this._innerSetTime(time);\n    this._now.isFixedTime = true;\n  }\n  _advanceNow(to) {\n    if (!this._now.isFixedTime)\n      this._now.time = asWallTime(this._now.time + to - this._now.ticks);\n    this._now.ticks = to;\n  }\n  async log(type, time, param) {\n    this._log.push({ type, time, param });\n  }\n  async runFor(ticks) {\n    this._replayLogOnce();\n    if (ticks < 0)\n      throw new TypeError("Negative ticks are not supported");\n    await this._runTo(shiftTicks(this._now.ticks, ticks));\n  }\n  async _runTo(to) {\n    to = Math.ceil(to);\n    if (this._now.ticks > to)\n      return;\n    let firstException;\n    while (true) {\n      const result = await this._callFirstTimer(to);\n      if (!result.timerFound)\n        break;\n      firstException = firstException || result.error;\n    }\n    this._advanceNow(to);\n    if (firstException)\n      throw firstException;\n  }\n  async pauseAt(time) {\n    this._replayLogOnce();\n    this._innerPause();\n    const toConsume = time - this._now.time;\n    await this._innerFastForwardTo(shiftTicks(this._now.ticks, toConsume));\n    return toConsume;\n  }\n  _innerPause() {\n    this._realTime = void 0;\n    this._updateRealTimeTimer();\n  }\n  resume() {\n    this._replayLogOnce();\n    this._innerResume();\n  }\n  _innerResume() {\n    const now = this._embedder.performanceNow();\n    this._realTime = { startTicks: now, lastSyncTicks: now };\n    this._updateRealTimeTimer();\n  }\n  _updateRealTimeTimer() {\n    var _a;\n    if (!this._realTime) {\n      (_a = this._currentRealTimeTimer) == null ? void 0 : _a.dispose();\n      this._currentRealTimeTimer = void 0;\n      return;\n    }\n    const firstTimer = this._firstTimer();\n    const callAt = Math.min(firstTimer ? firstTimer.callAt : this._now.ticks + maxTimeout, this._now.ticks + 100);\n    if (this._currentRealTimeTimer && this._currentRealTimeTimer.callAt < callAt)\n      return;\n    if (this._currentRealTimeTimer) {\n      this._currentRealTimeTimer.dispose();\n      this._currentRealTimeTimer = void 0;\n    }\n    this._currentRealTimeTimer = {\n      callAt,\n      dispose: this._embedder.setTimeout(() => {\n        this._currentRealTimeTimer = void 0;\n        this._syncRealTime();\n        void this._runTo(this._now.ticks).catch((e) => console.error(e)).then(() => this._updateRealTimeTimer());\n      }, callAt - this._now.ticks)\n    };\n  }\n  async fastForward(ticks) {\n    this._replayLogOnce();\n    await this._innerFastForwardTo(shiftTicks(this._now.ticks, ticks | 0));\n  }\n  async _innerFastForwardTo(to) {\n    if (to < this._now.ticks)\n      throw new Error("Cannot fast-forward to the past");\n    for (const timer of this._timers.values()) {\n      if (to > timer.callAt)\n        timer.callAt = to;\n    }\n    await this._runTo(to);\n  }\n  addTimer(options) {\n    this._replayLogOnce();\n    if (options.type === "AnimationFrame" /* AnimationFrame */ && !options.func)\n      throw new Error("Callback must be provided to requestAnimationFrame calls");\n    if (options.type === "IdleCallback" /* IdleCallback */ && !options.func)\n      throw new Error("Callback must be provided to requestIdleCallback calls");\n    if (["Timeout" /* Timeout */, "Interval" /* Interval */].includes(options.type) && !options.func && options.delay === void 0)\n      throw new Error("Callback must be provided to timer calls");\n    let delay = options.delay ? +options.delay : 0;\n    if (!Number.isFinite(delay))\n      delay = 0;\n    delay = delay > maxTimeout ? 1 : delay;\n    delay = Math.max(0, delay);\n    const timer = {\n      type: options.type,\n      func: options.func,\n      args: options.args || [],\n      delay,\n      callAt: shiftTicks(this._now.ticks, delay || (this._duringTick ? 1 : 0)),\n      createdAt: this._now.ticks,\n      id: this._uniqueTimerId++,\n      error: new Error()\n    };\n    this._timers.set(timer.id, timer);\n    if (this._realTime)\n      this._updateRealTimeTimer();\n    return timer.id;\n  }\n  countTimers() {\n    return this._timers.size;\n  }\n  _firstTimer(beforeTick) {\n    let firstTimer = null;\n    for (const timer of this._timers.values()) {\n      const isInRange = beforeTick === void 0 || timer.callAt <= beforeTick;\n      if (isInRange && (!firstTimer || compareTimers(firstTimer, timer) === 1))\n        firstTimer = timer;\n    }\n    return firstTimer;\n  }\n  _takeFirstTimer(beforeTick) {\n    const timer = this._firstTimer(beforeTick);\n    if (!timer)\n      return null;\n    this._advanceNow(timer.callAt);\n    if (timer.type === "Interval" /* Interval */)\n      timer.callAt = shiftTicks(timer.callAt, timer.delay);\n    else\n      this._timers.delete(timer.id);\n    return timer;\n  }\n  async _callFirstTimer(beforeTick) {\n    const timer = this._takeFirstTimer(beforeTick);\n    if (!timer)\n      return { timerFound: false };\n    this._duringTick = true;\n    try {\n      if (typeof timer.func !== "function") {\n        let error2;\n        try {\n          (() => {\n            globalThis.eval(timer.func);\n          })();\n        } catch (e) {\n          error2 = e;\n        }\n        await new Promise((f) => this._embedder.setTimeout(f));\n        return { timerFound: true, error: error2 };\n      }\n      let args = timer.args;\n      if (timer.type === "AnimationFrame" /* AnimationFrame */)\n        args = [this._now.ticks];\n      else if (timer.type === "IdleCallback" /* IdleCallback */)\n        args = [{ didTimeout: false, timeRemaining: () => 0 }];\n      let error;\n      try {\n        timer.func.apply(null, args);\n      } catch (e) {\n        error = e;\n      }\n      await new Promise((f) => this._embedder.setTimeout(f));\n      return { timerFound: true, error };\n    } finally {\n      this._duringTick = false;\n    }\n  }\n  getTimeToNextFrame() {\n    return 16 - this._now.ticks % 16;\n  }\n  clearTimer(timerId, type) {\n    this._replayLogOnce();\n    if (!timerId) {\n      return;\n    }\n    const id = Number(timerId);\n    if (Number.isNaN(id) || id < idCounterStart) {\n      const handlerName = getClearHandler(type);\n      new Error(`Clock: ${handlerName} was invoked to clear a native timer instead of one created by the clock library.`);\n    }\n    const timer = this._timers.get(id);\n    if (timer) {\n      if (timer.type === type || timer.type === "Timeout" && type === "Interval" || timer.type === "Interval" && type === "Timeout") {\n        this._timers.delete(id);\n      } else {\n        const clear = getClearHandler(type);\n        const schedule = getScheduleHandler(timer.type);\n        throw new Error(\n          `Cannot clear timer: timer created with ${schedule}() but cleared with ${clear}()`\n        );\n      }\n    }\n  }\n  _replayLogOnce() {\n    if (!this._log.length)\n      return;\n    let lastLogTime = -1;\n    let isPaused = false;\n    for (const { type, time, param } of this._log) {\n      if (!isPaused && lastLogTime !== -1)\n        this._advanceNow(shiftTicks(this._now.ticks, time - lastLogTime));\n      lastLogTime = time;\n      if (type === "install") {\n        this._innerSetTime(asWallTime(param));\n      } else if (type === "fastForward" || type === "runFor") {\n        this._advanceNow(shiftTicks(this._now.ticks, param));\n      } else if (type === "pauseAt") {\n        isPaused = true;\n        this._innerPause();\n        this._innerSetTime(asWallTime(param));\n      } else if (type === "resume") {\n        this._innerResume();\n        isPaused = false;\n      } else if (type === "setFixedTime") {\n        this._innerSetFixedTime(asWallTime(param));\n      } else if (type === "setSystemTime") {\n        this._innerSetTime(asWallTime(param));\n      }\n    }\n    if (!isPaused && lastLogTime > 0)\n      this._advanceNow(shiftTicks(this._now.ticks, this._embedder.dateNow() - lastLogTime));\n    this._log.length = 0;\n  }\n};\nfunction mirrorDateProperties(target, source) {\n  for (const prop in source) {\n    if (source.hasOwnProperty(prop))\n      target[prop] = source[prop];\n  }\n  target.toString = () => source.toString();\n  target.prototype = source.prototype;\n  target.parse = source.parse;\n  target.UTC = source.UTC;\n  target.prototype.toUTCString = source.prototype.toUTCString;\n  target.isFake = true;\n  return target;\n}\nfunction createDate(clock, NativeDate) {\n  function ClockDate(year, month, date, hour, minute, second, ms) {\n    if (!(this instanceof ClockDate))\n      return new NativeDate(clock.now()).toString();\n    switch (arguments.length) {\n      case 0:\n        return new NativeDate(clock.now());\n      case 1:\n        return new NativeDate(year);\n      case 2:\n        return new NativeDate(year, month);\n      case 3:\n        return new NativeDate(year, month, date);\n      case 4:\n        return new NativeDate(year, month, date, hour);\n      case 5:\n        return new NativeDate(year, month, date, hour, minute);\n      case 6:\n        return new NativeDate(\n          year,\n          month,\n          date,\n          hour,\n          minute,\n          second\n        );\n      default:\n        return new NativeDate(\n          year,\n          month,\n          date,\n          hour,\n          minute,\n          second,\n          ms\n        );\n    }\n  }\n  ClockDate.now = () => clock.now();\n  return mirrorDateProperties(ClockDate, NativeDate);\n}\nfunction createIntl(clock, NativeIntl) {\n  const ClockIntl = {};\n  for (const key of Object.getOwnPropertyNames(NativeIntl))\n    ClockIntl[key] = NativeIntl[key];\n  ClockIntl.DateTimeFormat = function(...args) {\n    const realFormatter = new NativeIntl.DateTimeFormat(...args);\n    const formatter = {\n      formatRange: realFormatter.formatRange.bind(realFormatter),\n      formatRangeToParts: realFormatter.formatRangeToParts.bind(realFormatter),\n      resolvedOptions: realFormatter.resolvedOptions.bind(realFormatter),\n      format: (date) => realFormatter.format(date || clock.now()),\n      formatToParts: (date) => realFormatter.formatToParts(date || clock.now())\n    };\n    return formatter;\n  };\n  ClockIntl.DateTimeFormat.prototype = Object.create(\n    NativeIntl.DateTimeFormat.prototype\n  );\n  ClockIntl.DateTimeFormat.supportedLocalesOf = NativeIntl.DateTimeFormat.supportedLocalesOf;\n  return ClockIntl;\n}\nfunction compareTimers(a, b) {\n  if (a.callAt < b.callAt)\n    return -1;\n  if (a.callAt > b.callAt)\n    return 1;\n  if (a.type === "Immediate" /* Immediate */ && b.type !== "Immediate" /* Immediate */)\n    return -1;\n  if (a.type !== "Immediate" /* Immediate */ && b.type === "Immediate" /* Immediate */)\n    return 1;\n  if (a.createdAt < b.createdAt)\n    return -1;\n  if (a.createdAt > b.createdAt)\n    return 1;\n  if (a.id < b.id)\n    return -1;\n  if (a.id > b.id)\n    return 1;\n}\nvar maxTimeout = Math.pow(2, 31) - 1;\nvar idCounterStart = 1e12;\nfunction platformOriginals(globalObject) {\n  const raw = {\n    setTimeout: globalObject.setTimeout,\n    clearTimeout: globalObject.clearTimeout,\n    setInterval: globalObject.setInterval,\n    clearInterval: globalObject.clearInterval,\n    requestAnimationFrame: globalObject.requestAnimationFrame ? globalObject.requestAnimationFrame : void 0,\n    cancelAnimationFrame: globalObject.cancelAnimationFrame ? globalObject.cancelAnimationFrame : void 0,\n    requestIdleCallback: globalObject.requestIdleCallback ? globalObject.requestIdleCallback : void 0,\n    cancelIdleCallback: globalObject.cancelIdleCallback ? globalObject.cancelIdleCallback : void 0,\n    Date: globalObject.Date,\n    performance: globalObject.performance,\n    Intl: globalObject.Intl\n  };\n  const bound = { ...raw };\n  for (const key of Object.keys(bound)) {\n    if (key !== "Date" && typeof bound[key] === "function")\n      bound[key] = bound[key].bind(globalObject);\n  }\n  return { raw, bound };\n}\nfunction getScheduleHandler(type) {\n  if (type === "IdleCallback" || type === "AnimationFrame")\n    return `request${type}`;\n  return `set${type}`;\n}\nfunction createApi(clock, originals) {\n  return {\n    setTimeout: (func, timeout, ...args) => {\n      const delay = timeout ? +timeout : timeout;\n      return clock.addTimer({\n        type: "Timeout" /* Timeout */,\n        func,\n        args,\n        delay\n      });\n    },\n    clearTimeout: (timerId) => {\n      if (timerId)\n        clock.clearTimer(timerId, "Timeout" /* Timeout */);\n    },\n    setInterval: (func, timeout, ...args) => {\n      const delay = timeout ? +timeout : timeout;\n      return clock.addTimer({\n        type: "Interval" /* Interval */,\n        func,\n        args,\n        delay\n      });\n    },\n    clearInterval: (timerId) => {\n      if (timerId)\n        return clock.clearTimer(timerId, "Interval" /* Interval */);\n    },\n    requestAnimationFrame: (callback) => {\n      return clock.addTimer({\n        type: "AnimationFrame" /* AnimationFrame */,\n        func: callback,\n        delay: clock.getTimeToNextFrame()\n      });\n    },\n    cancelAnimationFrame: (timerId) => {\n      if (timerId)\n        return clock.clearTimer(timerId, "AnimationFrame" /* AnimationFrame */);\n    },\n    requestIdleCallback: (callback, options) => {\n      let timeToNextIdlePeriod = 0;\n      if (clock.countTimers() > 0)\n        timeToNextIdlePeriod = 50;\n      return clock.addTimer({\n        type: "IdleCallback" /* IdleCallback */,\n        func: callback,\n        delay: (options == null ? void 0 : options.timeout) ? Math.min(options == null ? void 0 : options.timeout, timeToNextIdlePeriod) : timeToNextIdlePeriod\n      });\n    },\n    cancelIdleCallback: (timerId) => {\n      if (timerId)\n        return clock.clearTimer(timerId, "IdleCallback" /* IdleCallback */);\n    },\n    Intl: originals.Intl ? createIntl(clock, originals.Intl) : void 0,\n    Date: createDate(clock, originals.Date),\n    performance: originals.performance ? fakePerformance(clock, originals.performance) : void 0\n  };\n}\nfunction getClearHandler(type) {\n  if (type === "IdleCallback" || type === "AnimationFrame")\n    return `cancel${type}`;\n  return `clear${type}`;\n}\nfunction fakePerformance(clock, performance) {\n  const result = {\n    now: () => clock.performanceNow()\n  };\n  result.__defineGetter__("timeOrigin", () => clock._now.origin || 0);\n  for (const key of Object.keys(performance.__proto__)) {\n    if (key === "now" || key === "timeOrigin")\n      continue;\n    if (key === "getEntries" || key === "getEntriesByName" || key === "getEntriesByType")\n      result[key] = () => [];\n    else\n      result[key] = () => {\n      };\n  }\n  return result;\n}\nfunction createClock(globalObject) {\n  const originals = platformOriginals(globalObject);\n  const embedder = {\n    dateNow: () => originals.raw.Date.now(),\n    performanceNow: () => Math.ceil(originals.raw.performance.now()),\n    setTimeout: (task, timeout) => {\n      const timerId = originals.bound.setTimeout(task, timeout);\n      return () => originals.bound.clearTimeout(timerId);\n    },\n    setInterval: (task, delay) => {\n      const intervalId = originals.bound.setInterval(task, delay);\n      return () => originals.bound.clearInterval(intervalId);\n    }\n  };\n  const clock = new ClockController(embedder);\n  const api = createApi(clock, originals.bound);\n  return { clock, api, originals: originals.raw };\n}\nfunction install(globalObject, config = {}) {\n  var _a, _b;\n  if ((_a = globalObject.Date) == null ? void 0 : _a.isFake) {\n    throw new TypeError(`Can\'t install fake timers twice on the same global object.`);\n  }\n  const { clock, api, originals } = createClock(globalObject);\n  const toFake = ((_b = config.toFake) == null ? void 0 : _b.length) ? config.toFake : Object.keys(originals);\n  for (const method of toFake) {\n    if (method === "Date") {\n      globalObject.Date = mirrorDateProperties(api.Date, globalObject.Date);\n    } else if (method === "Intl") {\n      globalObject.Intl = api[method];\n    } else if (method === "performance") {\n      globalObject.performance = api[method];\n      const kEventTimeStamp = Symbol("playwrightEventTimeStamp");\n      Object.defineProperty(Event.prototype, "timeStamp", {\n        get() {\n          var _a2;\n          if (!this[kEventTimeStamp])\n            this[kEventTimeStamp] = (_a2 = api.performance) == null ? void 0 : _a2.now();\n          return this[kEventTimeStamp];\n        }\n      });\n    } else {\n      globalObject[method] = (...args) => {\n        return api[method].apply(api, args);\n      };\n    }\n    clock.disposables.push(() => {\n      globalObject[method] = originals[method];\n    });\n  }\n  return { clock, api, originals };\n}\nfunction inject(globalObject) {\n  const builtins = platformOriginals(globalObject).bound;\n  const { clock: controller } = install(globalObject);\n  controller.resume();\n  return {\n    controller,\n    builtins\n  };\n}\nfunction asWallTime(n) {\n  return n;\n}\nfunction shiftTicks(ticks, ms) {\n  return ticks + ms;\n}\n';
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ "../../node_modules/.pnpm/playwright-core@1.56.0-alpha-1758750661000/node_modules/playwright-core/lib/generated/injectedScriptSource.js":
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var injectedScriptSource_exports = {};
__export(injectedScriptSource_exports, {
  source: () => source
});
module.exports = __toCommonJS(injectedScriptSource_exports);
const source = '\nvar __commonJS = obj => {\n  let required = false;\n  let result;\n  return function __require() {\n    if (!required) {\n      required = true;\n      let fn;\n      for (const name in obj) { fn = obj[name]; break; }\n      const module = { exports: {} };\n      fn(module.exports, module);\n      result = module.exports;\n    }\n    return result;\n  }\n};\nvar __export = (target, all) => {for (var name in all) target[name] = all[name];};\nvar __toESM = mod => ({ ...mod, \'default\': mod });\nvar __toCommonJS = mod => ({ ...mod, __esModule: true });\n\n\n// packages/injected/src/injectedScript.ts\nvar injectedScript_exports = {};\n__export(injectedScript_exports, {\n  InjectedScript: () => InjectedScript\n});\nmodule.exports = __toCommonJS(injectedScript_exports);\n\n// packages/playwright-core/src/utils/isomorphic/ariaSnapshot.ts\nfunction parseAriaSnapshot(yaml, text, options = {}) {\n  var _a;\n  const lineCounter = new yaml.LineCounter();\n  const parseOptions = {\n    keepSourceTokens: true,\n    lineCounter,\n    ...options\n  };\n  const yamlDoc = yaml.parseDocument(text, parseOptions);\n  const errors = [];\n  const convertRange = (range) => {\n    return [lineCounter.linePos(range[0]), lineCounter.linePos(range[1])];\n  };\n  const addError = (error) => {\n    errors.push({\n      message: error.message,\n      range: [lineCounter.linePos(error.pos[0]), lineCounter.linePos(error.pos[1])]\n    });\n  };\n  const convertSeq = (container, seq) => {\n    for (const item of seq.items) {\n      const itemIsString = item instanceof yaml.Scalar && typeof item.value === "string";\n      if (itemIsString) {\n        const childNode = KeyParser.parse(item, parseOptions, errors);\n        if (childNode) {\n          container.children = container.children || [];\n          container.children.push(childNode);\n        }\n        continue;\n      }\n      const itemIsMap = item instanceof yaml.YAMLMap;\n      if (itemIsMap) {\n        convertMap(container, item);\n        continue;\n      }\n      errors.push({\n        message: "Sequence items should be strings or maps",\n        range: convertRange(item.range || seq.range)\n      });\n    }\n  };\n  const convertMap = (container, map) => {\n    var _a2;\n    for (const entry of map.items) {\n      container.children = container.children || [];\n      const keyIsString = entry.key instanceof yaml.Scalar && typeof entry.key.value === "string";\n      if (!keyIsString) {\n        errors.push({\n          message: "Only string keys are supported",\n          range: convertRange(entry.key.range || map.range)\n        });\n        continue;\n      }\n      const key = entry.key;\n      const value = entry.value;\n      if (key.value === "text") {\n        const valueIsString = value instanceof yaml.Scalar && typeof value.value === "string";\n        if (!valueIsString) {\n          errors.push({\n            message: "Text value should be a string",\n            range: convertRange(entry.value.range || map.range)\n          });\n          continue;\n        }\n        container.children.push({\n          kind: "text",\n          text: textValue(value.value)\n        });\n        continue;\n      }\n      if (key.value === "/children") {\n        const valueIsString = value instanceof yaml.Scalar && typeof value.value === "string";\n        if (!valueIsString || value.value !== "contain" && value.value !== "equal" && value.value !== "deep-equal") {\n          errors.push({\n            message: \'Strict value should be "contain", "equal" or "deep-equal"\',\n            range: convertRange(entry.value.range || map.range)\n          });\n          continue;\n        }\n        container.containerMode = value.value;\n        continue;\n      }\n      if (key.value.startsWith("/")) {\n        const valueIsString = value instanceof yaml.Scalar && typeof value.value === "string";\n        if (!valueIsString) {\n          errors.push({\n            message: "Property value should be a string",\n            range: convertRange(entry.value.range || map.range)\n          });\n          continue;\n        }\n        container.props = (_a2 = container.props) != null ? _a2 : {};\n        container.props[key.value.slice(1)] = textValue(value.value);\n        continue;\n      }\n      const childNode = KeyParser.parse(key, parseOptions, errors);\n      if (!childNode)\n        continue;\n      const valueIsScalar = value instanceof yaml.Scalar;\n      if (valueIsScalar) {\n        const type = typeof value.value;\n        if (type !== "string" && type !== "number" && type !== "boolean") {\n          errors.push({\n            message: "Node value should be a string or a sequence",\n            range: convertRange(entry.value.range || map.range)\n          });\n          continue;\n        }\n        container.children.push({\n          ...childNode,\n          children: [{\n            kind: "text",\n            text: textValue(String(value.value))\n          }]\n        });\n        continue;\n      }\n      const valueIsSequence = value instanceof yaml.YAMLSeq;\n      if (valueIsSequence) {\n        container.children.push(childNode);\n        convertSeq(childNode, value);\n        continue;\n      }\n      errors.push({\n        message: "Map values should be strings or sequences",\n        range: convertRange(entry.value.range || map.range)\n      });\n    }\n  };\n  const fragment = { kind: "role", role: "fragment" };\n  yamlDoc.errors.forEach(addError);\n  if (errors.length)\n    return { errors, fragment };\n  if (!(yamlDoc.contents instanceof yaml.YAMLSeq)) {\n    errors.push({\n      message: \'Aria snapshot must be a YAML sequence, elements starting with " -"\',\n      range: yamlDoc.contents ? convertRange(yamlDoc.contents.range) : [{ line: 0, col: 0 }, { line: 0, col: 0 }]\n    });\n  }\n  if (errors.length)\n    return { errors, fragment };\n  convertSeq(fragment, yamlDoc.contents);\n  if (errors.length)\n    return { errors, fragment: emptyFragment };\n  if (((_a = fragment.children) == null ? void 0 : _a.length) === 1 && (!fragment.containerMode || fragment.containerMode === "contain"))\n    return { fragment: fragment.children[0], errors: [] };\n  return { fragment, errors: [] };\n}\nvar emptyFragment = { kind: "role", role: "fragment" };\nfunction normalizeWhitespace(text) {\n  return text.replace(/[\\u200b\\u00ad]/g, "").replace(/[\\r\\n\\s\\t]+/g, " ").trim();\n}\nfunction textValue(value) {\n  return {\n    raw: value,\n    normalized: normalizeWhitespace(value)\n  };\n}\nvar KeyParser = class _KeyParser {\n  static parse(text, options, errors) {\n    try {\n      return new _KeyParser(text.value)._parse();\n    } catch (e) {\n      if (e instanceof ParserError) {\n        const message = options.prettyErrors === false ? e.message : e.message + ":\\n\\n" + text.value + "\\n" + " ".repeat(e.pos) + "^\\n";\n        errors.push({\n          message,\n          range: [options.lineCounter.linePos(text.range[0]), options.lineCounter.linePos(text.range[0] + e.pos)]\n        });\n        return null;\n      }\n      throw e;\n    }\n  }\n  constructor(input) {\n    this._input = input;\n    this._pos = 0;\n    this._length = input.length;\n  }\n  _peek() {\n    return this._input[this._pos] || "";\n  }\n  _next() {\n    if (this._pos < this._length)\n      return this._input[this._pos++];\n    return null;\n  }\n  _eof() {\n    return this._pos >= this._length;\n  }\n  _isWhitespace() {\n    return !this._eof() && /\\s/.test(this._peek());\n  }\n  _skipWhitespace() {\n    while (this._isWhitespace())\n      this._pos++;\n  }\n  _readIdentifier(type) {\n    if (this._eof())\n      this._throwError(`Unexpected end of input when expecting ${type}`);\n    const start = this._pos;\n    while (!this._eof() && /[a-zA-Z]/.test(this._peek()))\n      this._pos++;\n    return this._input.slice(start, this._pos);\n  }\n  _readString() {\n    let result = "";\n    let escaped = false;\n    while (!this._eof()) {\n      const ch = this._next();\n      if (escaped) {\n        result += ch;\n        escaped = false;\n      } else if (ch === "\\\\") {\n        escaped = true;\n      } else if (ch === \'"\') {\n        return result;\n      } else {\n        result += ch;\n      }\n    }\n    this._throwError("Unterminated string");\n  }\n  _throwError(message, offset = 0) {\n    throw new ParserError(message, offset || this._pos);\n  }\n  _readRegex() {\n    let result = "";\n    let escaped = false;\n    let insideClass = false;\n    while (!this._eof()) {\n      const ch = this._next();\n      if (escaped) {\n        result += ch;\n        escaped = false;\n      } else if (ch === "\\\\") {\n        escaped = true;\n        result += ch;\n      } else if (ch === "/" && !insideClass) {\n        return { pattern: result };\n      } else if (ch === "[") {\n        insideClass = true;\n        result += ch;\n      } else if (ch === "]" && insideClass) {\n        result += ch;\n        insideClass = false;\n      } else {\n        result += ch;\n      }\n    }\n    this._throwError("Unterminated regex");\n  }\n  _readStringOrRegex() {\n    const ch = this._peek();\n    if (ch === \'"\') {\n      this._next();\n      return normalizeWhitespace(this._readString());\n    }\n    if (ch === "/") {\n      this._next();\n      return this._readRegex();\n    }\n    return null;\n  }\n  _readAttributes(result) {\n    let errorPos = this._pos;\n    while (true) {\n      this._skipWhitespace();\n      if (this._peek() === "[") {\n        this._next();\n        this._skipWhitespace();\n        errorPos = this._pos;\n        const flagName = this._readIdentifier("attribute");\n        this._skipWhitespace();\n        let flagValue = "";\n        if (this._peek() === "=") {\n          this._next();\n          this._skipWhitespace();\n          errorPos = this._pos;\n          while (this._peek() !== "]" && !this._isWhitespace() && !this._eof())\n            flagValue += this._next();\n        }\n        this._skipWhitespace();\n        if (this._peek() !== "]")\n          this._throwError("Expected ]");\n        this._next();\n        this._applyAttribute(result, flagName, flagValue || "true", errorPos);\n      } else {\n        break;\n      }\n    }\n  }\n  _parse() {\n    this._skipWhitespace();\n    const role = this._readIdentifier("role");\n    this._skipWhitespace();\n    const name = this._readStringOrRegex() || "";\n    const result = { kind: "role", role, name };\n    this._readAttributes(result);\n    this._skipWhitespace();\n    if (!this._eof())\n      this._throwError("Unexpected input");\n    return result;\n  }\n  _applyAttribute(node, key, value, errorPos) {\n    if (key === "checked") {\n      this._assert(value === "true" || value === "false" || value === "mixed", \'Value of "checked" attribute must be a boolean or "mixed"\', errorPos);\n      node.checked = value === "true" ? true : value === "false" ? false : "mixed";\n      return;\n    }\n    if (key === "disabled") {\n      this._assert(value === "true" || value === "false", \'Value of "disabled" attribute must be a boolean\', errorPos);\n      node.disabled = value === "true";\n      return;\n    }\n    if (key === "expanded") {\n      this._assert(value === "true" || value === "false", \'Value of "expanded" attribute must be a boolean\', errorPos);\n      node.expanded = value === "true";\n      return;\n    }\n    if (key === "active") {\n      this._assert(value === "true" || value === "false", \'Value of "active" attribute must be a boolean\', errorPos);\n      node.active = value === "true";\n      return;\n    }\n    if (key === "level") {\n      this._assert(!isNaN(Number(value)), \'Value of "level" attribute must be a number\', errorPos);\n      node.level = Number(value);\n      return;\n    }\n    if (key === "pressed") {\n      this._assert(value === "true" || value === "false" || value === "mixed", \'Value of "pressed" attribute must be a boolean or "mixed"\', errorPos);\n      node.pressed = value === "true" ? true : value === "false" ? false : "mixed";\n      return;\n    }\n    if (key === "selected") {\n      this._assert(value === "true" || value === "false", \'Value of "selected" attribute must be a boolean\', errorPos);\n      node.selected = value === "true";\n      return;\n    }\n    this._assert(false, `Unsupported attribute [${key}]`, errorPos);\n  }\n  _assert(value, message, valuePos) {\n    if (!value)\n      this._throwError(message || "Assertion error", valuePos);\n  }\n};\nvar ParserError = class extends Error {\n  constructor(message, pos) {\n    super(message);\n    this.pos = pos;\n  }\n};\n\n// packages/playwright-core/src/utils/isomorphic/cssTokenizer.ts\nvar between = function(num, first, last) {\n  return num >= first && num <= last;\n};\nfunction digit(code) {\n  return between(code, 48, 57);\n}\nfunction hexdigit(code) {\n  return digit(code) || between(code, 65, 70) || between(code, 97, 102);\n}\nfunction uppercaseletter(code) {\n  return between(code, 65, 90);\n}\nfunction lowercaseletter(code) {\n  return between(code, 97, 122);\n}\nfunction letter(code) {\n  return uppercaseletter(code) || lowercaseletter(code);\n}\nfunction nonascii(code) {\n  return code >= 128;\n}\nfunction namestartchar(code) {\n  return letter(code) || nonascii(code) || code === 95;\n}\nfunction namechar(code) {\n  return namestartchar(code) || digit(code) || code === 45;\n}\nfunction nonprintable(code) {\n  return between(code, 0, 8) || code === 11 || between(code, 14, 31) || code === 127;\n}\nfunction newline(code) {\n  return code === 10;\n}\nfunction whitespace(code) {\n  return newline(code) || code === 9 || code === 32;\n}\nvar maximumallowedcodepoint = 1114111;\nvar InvalidCharacterError = class extends Error {\n  constructor(message) {\n    super(message);\n    this.name = "InvalidCharacterError";\n  }\n};\nfunction preprocess(str) {\n  const codepoints = [];\n  for (let i = 0; i < str.length; i++) {\n    let code = str.charCodeAt(i);\n    if (code === 13 && str.charCodeAt(i + 1) === 10) {\n      code = 10;\n      i++;\n    }\n    if (code === 13 || code === 12)\n      code = 10;\n    if (code === 0)\n      code = 65533;\n    if (between(code, 55296, 56319) && between(str.charCodeAt(i + 1), 56320, 57343)) {\n      const lead = code - 55296;\n      const trail = str.charCodeAt(i + 1) - 56320;\n      code = Math.pow(2, 16) + lead * Math.pow(2, 10) + trail;\n      i++;\n    }\n    codepoints.push(code);\n  }\n  return codepoints;\n}\nfunction stringFromCode(code) {\n  if (code <= 65535)\n    return String.fromCharCode(code);\n  code -= Math.pow(2, 16);\n  const lead = Math.floor(code / Math.pow(2, 10)) + 55296;\n  const trail = code % Math.pow(2, 10) + 56320;\n  return String.fromCharCode(lead) + String.fromCharCode(trail);\n}\nfunction tokenize(str1) {\n  const str = preprocess(str1);\n  let i = -1;\n  const tokens = [];\n  let code;\n  let line = 0;\n  let column = 0;\n  let lastLineLength = 0;\n  const incrLineno = function() {\n    line += 1;\n    lastLineLength = column;\n    column = 0;\n  };\n  const locStart = { line, column };\n  const codepoint = function(i2) {\n    if (i2 >= str.length)\n      return -1;\n    return str[i2];\n  };\n  const next = function(num) {\n    if (num === void 0)\n      num = 1;\n    if (num > 3)\n      throw "Spec Error: no more than three codepoints of lookahead.";\n    return codepoint(i + num);\n  };\n  const consume = function(num) {\n    if (num === void 0)\n      num = 1;\n    i += num;\n    code = codepoint(i);\n    if (newline(code))\n      incrLineno();\n    else\n      column += num;\n    return true;\n  };\n  const reconsume = function() {\n    i -= 1;\n    if (newline(code)) {\n      line -= 1;\n      column = lastLineLength;\n    } else {\n      column -= 1;\n    }\n    locStart.line = line;\n    locStart.column = column;\n    return true;\n  };\n  const eof = function(codepoint2) {\n    if (codepoint2 === void 0)\n      codepoint2 = code;\n    return codepoint2 === -1;\n  };\n  const donothing = function() {\n  };\n  const parseerror = function() {\n  };\n  const consumeAToken = function() {\n    consumeComments();\n    consume();\n    if (whitespace(code)) {\n      while (whitespace(next()))\n        consume();\n      return new WhitespaceToken();\n    } else if (code === 34) {\n      return consumeAStringToken();\n    } else if (code === 35) {\n      if (namechar(next()) || areAValidEscape(next(1), next(2))) {\n        const token = new HashToken("");\n        if (wouldStartAnIdentifier(next(1), next(2), next(3)))\n          token.type = "id";\n        token.value = consumeAName();\n        return token;\n      } else {\n        return new DelimToken(code);\n      }\n    } else if (code === 36) {\n      if (next() === 61) {\n        consume();\n        return new SuffixMatchToken();\n      } else {\n        return new DelimToken(code);\n      }\n    } else if (code === 39) {\n      return consumeAStringToken();\n    } else if (code === 40) {\n      return new OpenParenToken();\n    } else if (code === 41) {\n      return new CloseParenToken();\n    } else if (code === 42) {\n      if (next() === 61) {\n        consume();\n        return new SubstringMatchToken();\n      } else {\n        return new DelimToken(code);\n      }\n    } else if (code === 43) {\n      if (startsWithANumber()) {\n        reconsume();\n        return consumeANumericToken();\n      } else {\n        return new DelimToken(code);\n      }\n    } else if (code === 44) {\n      return new CommaToken();\n    } else if (code === 45) {\n      if (startsWithANumber()) {\n        reconsume();\n        return consumeANumericToken();\n      } else if (next(1) === 45 && next(2) === 62) {\n        consume(2);\n        return new CDCToken();\n      } else if (startsWithAnIdentifier()) {\n        reconsume();\n        return consumeAnIdentlikeToken();\n      } else {\n        return new DelimToken(code);\n      }\n    } else if (code === 46) {\n      if (startsWithANumber()) {\n        reconsume();\n        return consumeANumericToken();\n      } else {\n        return new DelimToken(code);\n      }\n    } else if (code === 58) {\n      return new ColonToken();\n    } else if (code === 59) {\n      return new SemicolonToken();\n    } else if (code === 60) {\n      if (next(1) === 33 && next(2) === 45 && next(3) === 45) {\n        consume(3);\n        return new CDOToken();\n      } else {\n        return new DelimToken(code);\n      }\n    } else if (code === 64) {\n      if (wouldStartAnIdentifier(next(1), next(2), next(3)))\n        return new AtKeywordToken(consumeAName());\n      else\n        return new DelimToken(code);\n    } else if (code === 91) {\n      return new OpenSquareToken();\n    } else if (code === 92) {\n      if (startsWithAValidEscape()) {\n        reconsume();\n        return consumeAnIdentlikeToken();\n      } else {\n        parseerror();\n        return new DelimToken(code);\n      }\n    } else if (code === 93) {\n      return new CloseSquareToken();\n    } else if (code === 94) {\n      if (next() === 61) {\n        consume();\n        return new PrefixMatchToken();\n      } else {\n        return new DelimToken(code);\n      }\n    } else if (code === 123) {\n      return new OpenCurlyToken();\n    } else if (code === 124) {\n      if (next() === 61) {\n        consume();\n        return new DashMatchToken();\n      } else if (next() === 124) {\n        consume();\n        return new ColumnToken();\n      } else {\n        return new DelimToken(code);\n      }\n    } else if (code === 125) {\n      return new CloseCurlyToken();\n    } else if (code === 126) {\n      if (next() === 61) {\n        consume();\n        return new IncludeMatchToken();\n      } else {\n        return new DelimToken(code);\n      }\n    } else if (digit(code)) {\n      reconsume();\n      return consumeANumericToken();\n    } else if (namestartchar(code)) {\n      reconsume();\n      return consumeAnIdentlikeToken();\n    } else if (eof()) {\n      return new EOFToken();\n    } else {\n      return new DelimToken(code);\n    }\n  };\n  const consumeComments = function() {\n    while (next(1) === 47 && next(2) === 42) {\n      consume(2);\n      while (true) {\n        consume();\n        if (code === 42 && next() === 47) {\n          consume();\n          break;\n        } else if (eof()) {\n          parseerror();\n          return;\n        }\n      }\n    }\n  };\n  const consumeANumericToken = function() {\n    const num = consumeANumber();\n    if (wouldStartAnIdentifier(next(1), next(2), next(3))) {\n      const token = new DimensionToken();\n      token.value = num.value;\n      token.repr = num.repr;\n      token.type = num.type;\n      token.unit = consumeAName();\n      return token;\n    } else if (next() === 37) {\n      consume();\n      const token = new PercentageToken();\n      token.value = num.value;\n      token.repr = num.repr;\n      return token;\n    } else {\n      const token = new NumberToken();\n      token.value = num.value;\n      token.repr = num.repr;\n      token.type = num.type;\n      return token;\n    }\n  };\n  const consumeAnIdentlikeToken = function() {\n    const str2 = consumeAName();\n    if (str2.toLowerCase() === "url" && next() === 40) {\n      consume();\n      while (whitespace(next(1)) && whitespace(next(2)))\n        consume();\n      if (next() === 34 || next() === 39)\n        return new FunctionToken(str2);\n      else if (whitespace(next()) && (next(2) === 34 || next(2) === 39))\n        return new FunctionToken(str2);\n      else\n        return consumeAURLToken();\n    } else if (next() === 40) {\n      consume();\n      return new FunctionToken(str2);\n    } else {\n      return new IdentToken(str2);\n    }\n  };\n  const consumeAStringToken = function(endingCodePoint) {\n    if (endingCodePoint === void 0)\n      endingCodePoint = code;\n    let string = "";\n    while (consume()) {\n      if (code === endingCodePoint || eof()) {\n        return new StringToken(string);\n      } else if (newline(code)) {\n        parseerror();\n        reconsume();\n        return new BadStringToken();\n      } else if (code === 92) {\n        if (eof(next()))\n          donothing();\n        else if (newline(next()))\n          consume();\n        else\n          string += stringFromCode(consumeEscape());\n      } else {\n        string += stringFromCode(code);\n      }\n    }\n    throw new Error("Internal error");\n  };\n  const consumeAURLToken = function() {\n    const token = new URLToken("");\n    while (whitespace(next()))\n      consume();\n    if (eof(next()))\n      return token;\n    while (consume()) {\n      if (code === 41 || eof()) {\n        return token;\n      } else if (whitespace(code)) {\n        while (whitespace(next()))\n          consume();\n        if (next() === 41 || eof(next())) {\n          consume();\n          return token;\n        } else {\n          consumeTheRemnantsOfABadURL();\n          return new BadURLToken();\n        }\n      } else if (code === 34 || code === 39 || code === 40 || nonprintable(code)) {\n        parseerror();\n        consumeTheRemnantsOfABadURL();\n        return new BadURLToken();\n      } else if (code === 92) {\n        if (startsWithAValidEscape()) {\n          token.value += stringFromCode(consumeEscape());\n        } else {\n          parseerror();\n          consumeTheRemnantsOfABadURL();\n          return new BadURLToken();\n        }\n      } else {\n        token.value += stringFromCode(code);\n      }\n    }\n    throw new Error("Internal error");\n  };\n  const consumeEscape = function() {\n    consume();\n    if (hexdigit(code)) {\n      const digits = [code];\n      for (let total = 0; total < 5; total++) {\n        if (hexdigit(next())) {\n          consume();\n          digits.push(code);\n        } else {\n          break;\n        }\n      }\n      if (whitespace(next()))\n        consume();\n      let value = parseInt(digits.map(function(x) {\n        return String.fromCharCode(x);\n      }).join(""), 16);\n      if (value > maximumallowedcodepoint)\n        value = 65533;\n      return value;\n    } else if (eof()) {\n      return 65533;\n    } else {\n      return code;\n    }\n  };\n  const areAValidEscape = function(c1, c2) {\n    if (c1 !== 92)\n      return false;\n    if (newline(c2))\n      return false;\n    return true;\n  };\n  const startsWithAValidEscape = function() {\n    return areAValidEscape(code, next());\n  };\n  const wouldStartAnIdentifier = function(c1, c2, c3) {\n    if (c1 === 45)\n      return namestartchar(c2) || c2 === 45 || areAValidEscape(c2, c3);\n    else if (namestartchar(c1))\n      return true;\n    else if (c1 === 92)\n      return areAValidEscape(c1, c2);\n    else\n      return false;\n  };\n  const startsWithAnIdentifier = function() {\n    return wouldStartAnIdentifier(code, next(1), next(2));\n  };\n  const wouldStartANumber = function(c1, c2, c3) {\n    if (c1 === 43 || c1 === 45) {\n      if (digit(c2))\n        return true;\n      if (c2 === 46 && digit(c3))\n        return true;\n      return false;\n    } else if (c1 === 46) {\n      if (digit(c2))\n        return true;\n      return false;\n    } else if (digit(c1)) {\n      return true;\n    } else {\n      return false;\n    }\n  };\n  const startsWithANumber = function() {\n    return wouldStartANumber(code, next(1), next(2));\n  };\n  const consumeAName = function() {\n    let result = "";\n    while (consume()) {\n      if (namechar(code)) {\n        result += stringFromCode(code);\n      } else if (startsWithAValidEscape()) {\n        result += stringFromCode(consumeEscape());\n      } else {\n        reconsume();\n        return result;\n      }\n    }\n    throw new Error("Internal parse error");\n  };\n  const consumeANumber = function() {\n    let repr = "";\n    let type = "integer";\n    if (next() === 43 || next() === 45) {\n      consume();\n      repr += stringFromCode(code);\n    }\n    while (digit(next())) {\n      consume();\n      repr += stringFromCode(code);\n    }\n    if (next(1) === 46 && digit(next(2))) {\n      consume();\n      repr += stringFromCode(code);\n      consume();\n      repr += stringFromCode(code);\n      type = "number";\n      while (digit(next())) {\n        consume();\n        repr += stringFromCode(code);\n      }\n    }\n    const c1 = next(1), c2 = next(2), c3 = next(3);\n    if ((c1 === 69 || c1 === 101) && digit(c2)) {\n      consume();\n      repr += stringFromCode(code);\n      consume();\n      repr += stringFromCode(code);\n      type = "number";\n      while (digit(next())) {\n        consume();\n        repr += stringFromCode(code);\n      }\n    } else if ((c1 === 69 || c1 === 101) && (c2 === 43 || c2 === 45) && digit(c3)) {\n      consume();\n      repr += stringFromCode(code);\n      consume();\n      repr += stringFromCode(code);\n      consume();\n      repr += stringFromCode(code);\n      type = "number";\n      while (digit(next())) {\n        consume();\n        repr += stringFromCode(code);\n      }\n    }\n    const value = convertAStringToANumber(repr);\n    return { type, value, repr };\n  };\n  const convertAStringToANumber = function(string) {\n    return +string;\n  };\n  const consumeTheRemnantsOfABadURL = function() {\n    while (consume()) {\n      if (code === 41 || eof()) {\n        return;\n      } else if (startsWithAValidEscape()) {\n        consumeEscape();\n        donothing();\n      } else {\n        donothing();\n      }\n    }\n  };\n  let iterationCount = 0;\n  while (!eof(next())) {\n    tokens.push(consumeAToken());\n    iterationCount++;\n    if (iterationCount > str.length * 2)\n      throw new Error("I\'m infinite-looping!");\n  }\n  return tokens;\n}\nvar CSSParserToken = class {\n  constructor() {\n    this.tokenType = "";\n  }\n  toJSON() {\n    return { token: this.tokenType };\n  }\n  toString() {\n    return this.tokenType;\n  }\n  toSource() {\n    return "" + this;\n  }\n};\nvar BadStringToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = "BADSTRING";\n  }\n};\nvar BadURLToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = "BADURL";\n  }\n};\nvar WhitespaceToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = "WHITESPACE";\n  }\n  toString() {\n    return "WS";\n  }\n  toSource() {\n    return " ";\n  }\n};\nvar CDOToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = "CDO";\n  }\n  toSource() {\n    return "<!--";\n  }\n};\nvar CDCToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = "CDC";\n  }\n  toSource() {\n    return "-->";\n  }\n};\nvar ColonToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = ":";\n  }\n};\nvar SemicolonToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = ";";\n  }\n};\nvar CommaToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = ",";\n  }\n};\nvar GroupingToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.value = "";\n    this.mirror = "";\n  }\n};\nvar OpenCurlyToken = class extends GroupingToken {\n  constructor() {\n    super();\n    this.tokenType = "{";\n    this.value = "{";\n    this.mirror = "}";\n  }\n};\nvar CloseCurlyToken = class extends GroupingToken {\n  constructor() {\n    super();\n    this.tokenType = "}";\n    this.value = "}";\n    this.mirror = "{";\n  }\n};\nvar OpenSquareToken = class extends GroupingToken {\n  constructor() {\n    super();\n    this.tokenType = "[";\n    this.value = "[";\n    this.mirror = "]";\n  }\n};\nvar CloseSquareToken = class extends GroupingToken {\n  constructor() {\n    super();\n    this.tokenType = "]";\n    this.value = "]";\n    this.mirror = "[";\n  }\n};\nvar OpenParenToken = class extends GroupingToken {\n  constructor() {\n    super();\n    this.tokenType = "(";\n    this.value = "(";\n    this.mirror = ")";\n  }\n};\nvar CloseParenToken = class extends GroupingToken {\n  constructor() {\n    super();\n    this.tokenType = ")";\n    this.value = ")";\n    this.mirror = "(";\n  }\n};\nvar IncludeMatchToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = "~=";\n  }\n};\nvar DashMatchToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = "|=";\n  }\n};\nvar PrefixMatchToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = "^=";\n  }\n};\nvar SuffixMatchToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = "$=";\n  }\n};\nvar SubstringMatchToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = "*=";\n  }\n};\nvar ColumnToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = "||";\n  }\n};\nvar EOFToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.tokenType = "EOF";\n  }\n  toSource() {\n    return "";\n  }\n};\nvar DelimToken = class extends CSSParserToken {\n  constructor(code) {\n    super();\n    this.tokenType = "DELIM";\n    this.value = "";\n    this.value = stringFromCode(code);\n  }\n  toString() {\n    return "DELIM(" + this.value + ")";\n  }\n  toJSON() {\n    const json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n    json.value = this.value;\n    return json;\n  }\n  toSource() {\n    if (this.value === "\\\\")\n      return "\\\\\\n";\n    else\n      return this.value;\n  }\n};\nvar StringValuedToken = class extends CSSParserToken {\n  constructor() {\n    super(...arguments);\n    this.value = "";\n  }\n  ASCIIMatch(str) {\n    return this.value.toLowerCase() === str.toLowerCase();\n  }\n  toJSON() {\n    const json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n    json.value = this.value;\n    return json;\n  }\n};\nvar IdentToken = class extends StringValuedToken {\n  constructor(val) {\n    super();\n    this.tokenType = "IDENT";\n    this.value = val;\n  }\n  toString() {\n    return "IDENT(" + this.value + ")";\n  }\n  toSource() {\n    return escapeIdent(this.value);\n  }\n};\nvar FunctionToken = class extends StringValuedToken {\n  constructor(val) {\n    super();\n    this.tokenType = "FUNCTION";\n    this.value = val;\n    this.mirror = ")";\n  }\n  toString() {\n    return "FUNCTION(" + this.value + ")";\n  }\n  toSource() {\n    return escapeIdent(this.value) + "(";\n  }\n};\nvar AtKeywordToken = class extends StringValuedToken {\n  constructor(val) {\n    super();\n    this.tokenType = "AT-KEYWORD";\n    this.value = val;\n  }\n  toString() {\n    return "AT(" + this.value + ")";\n  }\n  toSource() {\n    return "@" + escapeIdent(this.value);\n  }\n};\nvar HashToken = class extends StringValuedToken {\n  constructor(val) {\n    super();\n    this.tokenType = "HASH";\n    this.value = val;\n    this.type = "unrestricted";\n  }\n  toString() {\n    return "HASH(" + this.value + ")";\n  }\n  toJSON() {\n    const json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n    json.value = this.value;\n    json.type = this.type;\n    return json;\n  }\n  toSource() {\n    if (this.type === "id")\n      return "#" + escapeIdent(this.value);\n    else\n      return "#" + escapeHash(this.value);\n  }\n};\nvar StringToken = class extends StringValuedToken {\n  constructor(val) {\n    super();\n    this.tokenType = "STRING";\n    this.value = val;\n  }\n  toString() {\n    return \'"\' + escapeString(this.value) + \'"\';\n  }\n};\nvar URLToken = class extends StringValuedToken {\n  constructor(val) {\n    super();\n    this.tokenType = "URL";\n    this.value = val;\n  }\n  toString() {\n    return "URL(" + this.value + ")";\n  }\n  toSource() {\n    return \'url("\' + escapeString(this.value) + \'")\';\n  }\n};\nvar NumberToken = class extends CSSParserToken {\n  constructor() {\n    super();\n    this.tokenType = "NUMBER";\n    this.type = "integer";\n    this.repr = "";\n  }\n  toString() {\n    if (this.type === "integer")\n      return "INT(" + this.value + ")";\n    return "NUMBER(" + this.value + ")";\n  }\n  toJSON() {\n    const json = super.toJSON();\n    json.value = this.value;\n    json.type = this.type;\n    json.repr = this.repr;\n    return json;\n  }\n  toSource() {\n    return this.repr;\n  }\n};\nvar PercentageToken = class extends CSSParserToken {\n  constructor() {\n    super();\n    this.tokenType = "PERCENTAGE";\n    this.repr = "";\n  }\n  toString() {\n    return "PERCENTAGE(" + this.value + ")";\n  }\n  toJSON() {\n    const json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n    json.value = this.value;\n    json.repr = this.repr;\n    return json;\n  }\n  toSource() {\n    return this.repr + "%";\n  }\n};\nvar DimensionToken = class extends CSSParserToken {\n  constructor() {\n    super();\n    this.tokenType = "DIMENSION";\n    this.type = "integer";\n    this.repr = "";\n    this.unit = "";\n  }\n  toString() {\n    return "DIM(" + this.value + "," + this.unit + ")";\n  }\n  toJSON() {\n    const json = this.constructor.prototype.constructor.prototype.toJSON.call(this);\n    json.value = this.value;\n    json.type = this.type;\n    json.repr = this.repr;\n    json.unit = this.unit;\n    return json;\n  }\n  toSource() {\n    const source = this.repr;\n    let unit = escapeIdent(this.unit);\n    if (unit[0].toLowerCase() === "e" && (unit[1] === "-" || between(unit.charCodeAt(1), 48, 57))) {\n      unit = "\\\\65 " + unit.slice(1, unit.length);\n    }\n    return source + unit;\n  }\n};\nfunction escapeIdent(string) {\n  string = "" + string;\n  let result = "";\n  const firstcode = string.charCodeAt(0);\n  for (let i = 0; i < string.length; i++) {\n    const code = string.charCodeAt(i);\n    if (code === 0)\n      throw new InvalidCharacterError("Invalid character: the input contains U+0000.");\n    if (between(code, 1, 31) || code === 127 || i === 0 && between(code, 48, 57) || i === 1 && between(code, 48, 57) && firstcode === 45)\n      result += "\\\\" + code.toString(16) + " ";\n    else if (code >= 128 || code === 45 || code === 95 || between(code, 48, 57) || between(code, 65, 90) || between(code, 97, 122))\n      result += string[i];\n    else\n      result += "\\\\" + string[i];\n  }\n  return result;\n}\nfunction escapeHash(string) {\n  string = "" + string;\n  let result = "";\n  for (let i = 0; i < string.length; i++) {\n    const code = string.charCodeAt(i);\n    if (code === 0)\n      throw new InvalidCharacterError("Invalid character: the input contains U+0000.");\n    if (code >= 128 || code === 45 || code === 95 || between(code, 48, 57) || between(code, 65, 90) || between(code, 97, 122))\n      result += string[i];\n    else\n      result += "\\\\" + code.toString(16) + " ";\n  }\n  return result;\n}\nfunction escapeString(string) {\n  string = "" + string;\n  let result = "";\n  for (let i = 0; i < string.length; i++) {\n    const code = string.charCodeAt(i);\n    if (code === 0)\n      throw new InvalidCharacterError("Invalid character: the input contains U+0000.");\n    if (between(code, 1, 31) || code === 127)\n      result += "\\\\" + code.toString(16) + " ";\n    else if (code === 34 || code === 92)\n      result += "\\\\" + string[i];\n    else\n      result += string[i];\n  }\n  return result;\n}\n\n// packages/playwright-core/src/utils/isomorphic/cssParser.ts\nvar InvalidSelectorError = class extends Error {\n};\nfunction parseCSS(selector, customNames) {\n  let tokens;\n  try {\n    tokens = tokenize(selector);\n    if (!(tokens[tokens.length - 1] instanceof EOFToken))\n      tokens.push(new EOFToken());\n  } catch (e) {\n    const newMessage = e.message + ` while parsing css selector "${selector}". Did you mean to CSS.escape it?`;\n    const index = (e.stack || "").indexOf(e.message);\n    if (index !== -1)\n      e.stack = e.stack.substring(0, index) + newMessage + e.stack.substring(index + e.message.length);\n    e.message = newMessage;\n    throw e;\n  }\n  const unsupportedToken = tokens.find((token) => {\n    return token instanceof AtKeywordToken || token instanceof BadStringToken || token instanceof BadURLToken || token instanceof ColumnToken || token instanceof CDOToken || token instanceof CDCToken || token instanceof SemicolonToken || // TODO: Consider using these for something, e.g. to escape complex strings.\n    // For example :xpath{ (//div/bar[@attr="foo"])[2]/baz }\n    // Or this way :xpath( {complex-xpath-goes-here("hello")} )\n    token instanceof OpenCurlyToken || token instanceof CloseCurlyToken || // TODO: Consider treating these as strings?\n    token instanceof URLToken || token instanceof PercentageToken;\n  });\n  if (unsupportedToken)\n    throw new InvalidSelectorError(`Unsupported token "${unsupportedToken.toSource()}" while parsing css selector "${selector}". Did you mean to CSS.escape it?`);\n  let pos = 0;\n  const names = /* @__PURE__ */ new Set();\n  function unexpected() {\n    return new InvalidSelectorError(`Unexpected token "${tokens[pos].toSource()}" while parsing css selector "${selector}". Did you mean to CSS.escape it?`);\n  }\n  function skipWhitespace() {\n    while (tokens[pos] instanceof WhitespaceToken)\n      pos++;\n  }\n  function isIdent(p = pos) {\n    return tokens[p] instanceof IdentToken;\n  }\n  function isString(p = pos) {\n    return tokens[p] instanceof StringToken;\n  }\n  function isNumber(p = pos) {\n    return tokens[p] instanceof NumberToken;\n  }\n  function isComma(p = pos) {\n    return tokens[p] instanceof CommaToken;\n  }\n  function isOpenParen(p = pos) {\n    return tokens[p] instanceof OpenParenToken;\n  }\n  function isCloseParen(p = pos) {\n    return tokens[p] instanceof CloseParenToken;\n  }\n  function isFunction(p = pos) {\n    return tokens[p] instanceof FunctionToken;\n  }\n  function isStar(p = pos) {\n    return tokens[p] instanceof DelimToken && tokens[p].value === "*";\n  }\n  function isEOF(p = pos) {\n    return tokens[p] instanceof EOFToken;\n  }\n  function isClauseCombinator(p = pos) {\n    return tokens[p] instanceof DelimToken && [">", "+", "~"].includes(tokens[p].value);\n  }\n  function isSelectorClauseEnd(p = pos) {\n    return isComma(p) || isCloseParen(p) || isEOF(p) || isClauseCombinator(p) || tokens[p] instanceof WhitespaceToken;\n  }\n  function consumeFunctionArguments() {\n    const result2 = [consumeArgument()];\n    while (true) {\n      skipWhitespace();\n      if (!isComma())\n        break;\n      pos++;\n      result2.push(consumeArgument());\n    }\n    return result2;\n  }\n  function consumeArgument() {\n    skipWhitespace();\n    if (isNumber())\n      return tokens[pos++].value;\n    if (isString())\n      return tokens[pos++].value;\n    return consumeComplexSelector();\n  }\n  function consumeComplexSelector() {\n    const result2 = { simples: [] };\n    skipWhitespace();\n    if (isClauseCombinator()) {\n      result2.simples.push({ selector: { functions: [{ name: "scope", args: [] }] }, combinator: "" });\n    } else {\n      result2.simples.push({ selector: consumeSimpleSelector(), combinator: "" });\n    }\n    while (true) {\n      skipWhitespace();\n      if (isClauseCombinator()) {\n        result2.simples[result2.simples.length - 1].combinator = tokens[pos++].value;\n        skipWhitespace();\n      } else if (isSelectorClauseEnd()) {\n        break;\n      }\n      result2.simples.push({ combinator: "", selector: consumeSimpleSelector() });\n    }\n    return result2;\n  }\n  function consumeSimpleSelector() {\n    let rawCSSString = "";\n    const functions = [];\n    while (!isSelectorClauseEnd()) {\n      if (isIdent() || isStar()) {\n        rawCSSString += tokens[pos++].toSource();\n      } else if (tokens[pos] instanceof HashToken) {\n        rawCSSString += tokens[pos++].toSource();\n      } else if (tokens[pos] instanceof DelimToken && tokens[pos].value === ".") {\n        pos++;\n        if (isIdent())\n          rawCSSString += "." + tokens[pos++].toSource();\n        else\n          throw unexpected();\n      } else if (tokens[pos] instanceof ColonToken) {\n        pos++;\n        if (isIdent()) {\n          if (!customNames.has(tokens[pos].value.toLowerCase())) {\n            rawCSSString += ":" + tokens[pos++].toSource();\n          } else {\n            const name = tokens[pos++].value.toLowerCase();\n            functions.push({ name, args: [] });\n            names.add(name);\n          }\n        } else if (isFunction()) {\n          const name = tokens[pos++].value.toLowerCase();\n          if (!customNames.has(name)) {\n            rawCSSString += `:${name}(${consumeBuiltinFunctionArguments()})`;\n          } else {\n            functions.push({ name, args: consumeFunctionArguments() });\n            names.add(name);\n          }\n          skipWhitespace();\n          if (!isCloseParen())\n            throw unexpected();\n          pos++;\n        } else {\n          throw unexpected();\n        }\n      } else if (tokens[pos] instanceof OpenSquareToken) {\n        rawCSSString += "[";\n        pos++;\n        while (!(tokens[pos] instanceof CloseSquareToken) && !isEOF())\n          rawCSSString += tokens[pos++].toSource();\n        if (!(tokens[pos] instanceof CloseSquareToken))\n          throw unexpected();\n        rawCSSString += "]";\n        pos++;\n      } else {\n        throw unexpected();\n      }\n    }\n    if (!rawCSSString && !functions.length)\n      throw unexpected();\n    return { css: rawCSSString || void 0, functions };\n  }\n  function consumeBuiltinFunctionArguments() {\n    let s = "";\n    let balance = 1;\n    while (!isEOF()) {\n      if (isOpenParen() || isFunction())\n        balance++;\n      if (isCloseParen())\n        balance--;\n      if (!balance)\n        break;\n      s += tokens[pos++].toSource();\n    }\n    return s;\n  }\n  const result = consumeFunctionArguments();\n  if (!isEOF())\n    throw unexpected();\n  if (result.some((arg) => typeof arg !== "object" || !("simples" in arg)))\n    throw new InvalidSelectorError(`Error while parsing css selector "${selector}". Did you mean to CSS.escape it?`);\n  return { selector: result, names: Array.from(names) };\n}\n\n// packages/playwright-core/src/utils/isomorphic/selectorParser.ts\nvar kNestedSelectorNames = /* @__PURE__ */ new Set(["internal:has", "internal:has-not", "internal:and", "internal:or", "internal:chain", "left-of", "right-of", "above", "below", "near"]);\nvar kNestedSelectorNamesWithDistance = /* @__PURE__ */ new Set(["left-of", "right-of", "above", "below", "near"]);\nvar customCSSNames = /* @__PURE__ */ new Set(["not", "is", "where", "has", "scope", "light", "visible", "text", "text-matches", "text-is", "has-text", "above", "below", "right-of", "left-of", "near", "nth-match"]);\nfunction parseSelector(selector) {\n  const parsedStrings = parseSelectorString(selector);\n  const parts = [];\n  for (const part of parsedStrings.parts) {\n    if (part.name === "css" || part.name === "css:light") {\n      if (part.name === "css:light")\n        part.body = ":light(" + part.body + ")";\n      const parsedCSS = parseCSS(part.body, customCSSNames);\n      parts.push({\n        name: "css",\n        body: parsedCSS.selector,\n        source: part.body\n      });\n      continue;\n    }\n    if (kNestedSelectorNames.has(part.name)) {\n      let innerSelector;\n      let distance;\n      try {\n        const unescaped = JSON.parse("[" + part.body + "]");\n        if (!Array.isArray(unescaped) || unescaped.length < 1 || unescaped.length > 2 || typeof unescaped[0] !== "string")\n          throw new InvalidSelectorError(`Malformed selector: ${part.name}=` + part.body);\n        innerSelector = unescaped[0];\n        if (unescaped.length === 2) {\n          if (typeof unescaped[1] !== "number" || !kNestedSelectorNamesWithDistance.has(part.name))\n            throw new InvalidSelectorError(`Malformed selector: ${part.name}=` + part.body);\n          distance = unescaped[1];\n        }\n      } catch (e) {\n        throw new InvalidSelectorError(`Malformed selector: ${part.name}=` + part.body);\n      }\n      const nested = { name: part.name, source: part.body, body: { parsed: parseSelector(innerSelector), distance } };\n      const lastFrame = [...nested.body.parsed.parts].reverse().find((part2) => part2.name === "internal:control" && part2.body === "enter-frame");\n      const lastFrameIndex = lastFrame ? nested.body.parsed.parts.indexOf(lastFrame) : -1;\n      if (lastFrameIndex !== -1 && selectorPartsEqual(nested.body.parsed.parts.slice(0, lastFrameIndex + 1), parts.slice(0, lastFrameIndex + 1)))\n        nested.body.parsed.parts.splice(0, lastFrameIndex + 1);\n      parts.push(nested);\n      continue;\n    }\n    parts.push({ ...part, source: part.body });\n  }\n  if (kNestedSelectorNames.has(parts[0].name))\n    throw new InvalidSelectorError(`"${parts[0].name}" selector cannot be first`);\n  return {\n    capture: parsedStrings.capture,\n    parts\n  };\n}\nfunction selectorPartsEqual(list1, list2) {\n  return stringifySelector({ parts: list1 }) === stringifySelector({ parts: list2 });\n}\nfunction stringifySelector(selector, forceEngineName) {\n  if (typeof selector === "string")\n    return selector;\n  return selector.parts.map((p, i) => {\n    let includeEngine = true;\n    if (!forceEngineName && i !== selector.capture) {\n      if (p.name === "css")\n        includeEngine = false;\n      else if (p.name === "xpath" && p.source.startsWith("//") || p.source.startsWith(".."))\n        includeEngine = false;\n    }\n    const prefix = includeEngine ? p.name + "=" : "";\n    return `${i === selector.capture ? "*" : ""}${prefix}${p.source}`;\n  }).join(" >> ");\n}\nfunction visitAllSelectorParts(selector, visitor) {\n  const visit = (selector2, nested) => {\n    for (const part of selector2.parts) {\n      visitor(part, nested);\n      if (kNestedSelectorNames.has(part.name))\n        visit(part.body.parsed, true);\n    }\n  };\n  visit(selector, false);\n}\nfunction parseSelectorString(selector) {\n  let index = 0;\n  let quote;\n  let start = 0;\n  const result = { parts: [] };\n  const append = () => {\n    const part = selector.substring(start, index).trim();\n    const eqIndex = part.indexOf("=");\n    let name;\n    let body;\n    if (eqIndex !== -1 && part.substring(0, eqIndex).trim().match(/^[a-zA-Z_0-9-+:*]+$/)) {\n      name = part.substring(0, eqIndex).trim();\n      body = part.substring(eqIndex + 1);\n    } else if (part.length > 1 && part[0] === \'"\' && part[part.length - 1] === \'"\') {\n      name = "text";\n      body = part;\n    } else if (part.length > 1 && part[0] === "\'" && part[part.length - 1] === "\'") {\n      name = "text";\n      body = part;\n    } else if (/^\\(*\\/\\//.test(part) || part.startsWith("..")) {\n      name = "xpath";\n      body = part;\n    } else {\n      name = "css";\n      body = part;\n    }\n    let capture = false;\n    if (name[0] === "*") {\n      capture = true;\n      name = name.substring(1);\n    }\n    result.parts.push({ name, body });\n    if (capture) {\n      if (result.capture !== void 0)\n        throw new InvalidSelectorError(`Only one of the selectors can capture using * modifier`);\n      result.capture = result.parts.length - 1;\n    }\n  };\n  if (!selector.includes(">>")) {\n    index = selector.length;\n    append();\n    return result;\n  }\n  const shouldIgnoreTextSelectorQuote = () => {\n    const prefix = selector.substring(start, index);\n    const match = prefix.match(/^\\s*text\\s*=(.*)$/);\n    return !!match && !!match[1];\n  };\n  while (index < selector.length) {\n    const c = selector[index];\n    if (c === "\\\\" && index + 1 < selector.length) {\n      index += 2;\n    } else if (c === quote) {\n      quote = void 0;\n      index++;\n    } else if (!quote && (c === \'"\' || c === "\'" || c === "`") && !shouldIgnoreTextSelectorQuote()) {\n      quote = c;\n      index++;\n    } else if (!quote && c === ">" && selector[index + 1] === ">") {\n      append();\n      index += 2;\n      start = index;\n    } else {\n      index++;\n    }\n  }\n  append();\n  return result;\n}\nfunction parseAttributeSelector(selector, allowUnquotedStrings) {\n  let wp = 0;\n  let EOL = selector.length === 0;\n  const next = () => selector[wp] || "";\n  const eat1 = () => {\n    const result2 = next();\n    ++wp;\n    EOL = wp >= selector.length;\n    return result2;\n  };\n  const syntaxError = (stage) => {\n    if (EOL)\n      throw new InvalidSelectorError(`Unexpected end of selector while parsing selector \\`${selector}\\``);\n    throw new InvalidSelectorError(`Error while parsing selector \\`${selector}\\` - unexpected symbol "${next()}" at position ${wp}` + (stage ? " during " + stage : ""));\n  };\n  function skipSpaces() {\n    while (!EOL && /\\s/.test(next()))\n      eat1();\n  }\n  function isCSSNameChar(char) {\n    return char >= "\\x80" || char >= "0" && char <= "9" || char >= "A" && char <= "Z" || char >= "a" && char <= "z" || char >= "0" && char <= "9" || char === "_" || char === "-";\n  }\n  function readIdentifier() {\n    let result2 = "";\n    skipSpaces();\n    while (!EOL && isCSSNameChar(next()))\n      result2 += eat1();\n    return result2;\n  }\n  function readQuotedString(quote) {\n    let result2 = eat1();\n    if (result2 !== quote)\n      syntaxError("parsing quoted string");\n    while (!EOL && next() !== quote) {\n      if (next() === "\\\\")\n        eat1();\n      result2 += eat1();\n    }\n    if (next() !== quote)\n      syntaxError("parsing quoted string");\n    result2 += eat1();\n    return result2;\n  }\n  function readRegularExpression() {\n    if (eat1() !== "/")\n      syntaxError("parsing regular expression");\n    let source = "";\n    let inClass = false;\n    while (!EOL) {\n      if (next() === "\\\\") {\n        source += eat1();\n        if (EOL)\n          syntaxError("parsing regular expression");\n      } else if (inClass && next() === "]") {\n        inClass = false;\n      } else if (!inClass && next() === "[") {\n        inClass = true;\n      } else if (!inClass && next() === "/") {\n        break;\n      }\n      source += eat1();\n    }\n    if (eat1() !== "/")\n      syntaxError("parsing regular expression");\n    let flags = "";\n    while (!EOL && next().match(/[dgimsuy]/))\n      flags += eat1();\n    try {\n      return new RegExp(source, flags);\n    } catch (e) {\n      throw new InvalidSelectorError(`Error while parsing selector \\`${selector}\\`: ${e.message}`);\n    }\n  }\n  function readAttributeToken() {\n    let token = "";\n    skipSpaces();\n    if (next() === `\'` || next() === `"`)\n      token = readQuotedString(next()).slice(1, -1);\n    else\n      token = readIdentifier();\n    if (!token)\n      syntaxError("parsing property path");\n    return token;\n  }\n  function readOperator() {\n    skipSpaces();\n    let op = "";\n    if (!EOL)\n      op += eat1();\n    if (!EOL && op !== "=")\n      op += eat1();\n    if (!["=", "*=", "^=", "$=", "|=", "~="].includes(op))\n      syntaxError("parsing operator");\n    return op;\n  }\n  function readAttribute() {\n    eat1();\n    const jsonPath = [];\n    jsonPath.push(readAttributeToken());\n    skipSpaces();\n    while (next() === ".") {\n      eat1();\n      jsonPath.push(readAttributeToken());\n      skipSpaces();\n    }\n    if (next() === "]") {\n      eat1();\n      return { name: jsonPath.join("."), jsonPath, op: "<truthy>", value: null, caseSensitive: false };\n    }\n    const operator = readOperator();\n    let value = void 0;\n    let caseSensitive = true;\n    skipSpaces();\n    if (next() === "/") {\n      if (operator !== "=")\n        throw new InvalidSelectorError(`Error while parsing selector \\`${selector}\\` - cannot use ${operator} in attribute with regular expression`);\n      value = readRegularExpression();\n    } else if (next() === `\'` || next() === `"`) {\n      value = readQuotedString(next()).slice(1, -1);\n      skipSpaces();\n      if (next() === "i" || next() === "I") {\n        caseSensitive = false;\n        eat1();\n      } else if (next() === "s" || next() === "S") {\n        caseSensitive = true;\n        eat1();\n      }\n    } else {\n      value = "";\n      while (!EOL && (isCSSNameChar(next()) || next() === "+" || next() === "."))\n        value += eat1();\n      if (value === "true") {\n        value = true;\n      } else if (value === "false") {\n        value = false;\n      } else {\n        if (!allowUnquotedStrings) {\n          value = +value;\n          if (Number.isNaN(value))\n            syntaxError("parsing attribute value");\n        }\n      }\n    }\n    skipSpaces();\n    if (next() !== "]")\n      syntaxError("parsing attribute value");\n    eat1();\n    if (operator !== "=" && typeof value !== "string")\n      throw new InvalidSelectorError(`Error while parsing selector \\`${selector}\\` - cannot use ${operator} in attribute with non-string matching value - ${value}`);\n    return { name: jsonPath.join("."), jsonPath, op: operator, value, caseSensitive };\n  }\n  const result = {\n    name: "",\n    attributes: []\n  };\n  result.name = readIdentifier();\n  skipSpaces();\n  while (next() === "[") {\n    result.attributes.push(readAttribute());\n    skipSpaces();\n  }\n  if (!EOL)\n    syntaxError(void 0);\n  if (!result.name && !result.attributes.length)\n    throw new InvalidSelectorError(`Error while parsing selector \\`${selector}\\` - selector cannot be empty`);\n  return result;\n}\n\n// packages/playwright-core/src/utils/isomorphic/stringUtils.ts\nfunction escapeWithQuotes(text, char = "\'") {\n  const stringified = JSON.stringify(text);\n  const escapedText = stringified.substring(1, stringified.length - 1).replace(/\\\\"/g, \'"\');\n  if (char === "\'")\n    return char + escapedText.replace(/[\']/g, "\\\\\'") + char;\n  if (char === \'"\')\n    return char + escapedText.replace(/["]/g, \'\\\\"\') + char;\n  if (char === "`")\n    return char + escapedText.replace(/[`]/g, "\\\\`") + char;\n  throw new Error("Invalid escape char");\n}\nfunction toTitleCase(name) {\n  return name.charAt(0).toUpperCase() + name.substring(1);\n}\nfunction toSnakeCase(name) {\n  return name.replace(/([a-z0-9])([A-Z])/g, "$1_$2").replace(/([A-Z])([A-Z][a-z])/g, "$1_$2").toLowerCase();\n}\nfunction quoteCSSAttributeValue(text) {\n  return `"${text.replace(/["\\\\]/g, (char) => "\\\\" + char)}"`;\n}\nvar normalizedWhitespaceCache;\nfunction cacheNormalizedWhitespaces() {\n  normalizedWhitespaceCache = /* @__PURE__ */ new Map();\n}\nfunction normalizeWhiteSpace(text) {\n  let result = normalizedWhitespaceCache == null ? void 0 : normalizedWhitespaceCache.get(text);\n  if (result === void 0) {\n    result = text.replace(/[\\u200b\\u00ad]/g, "").trim().replace(/\\s+/g, " ");\n    normalizedWhitespaceCache == null ? void 0 : normalizedWhitespaceCache.set(text, result);\n  }\n  return result;\n}\nfunction normalizeEscapedRegexQuotes(source) {\n  return source.replace(/(^|[^\\\\])(\\\\\\\\)*\\\\([\'"`])/g, "$1$2$3");\n}\nfunction escapeRegexForSelector(re) {\n  if (re.unicode || re.unicodeSets)\n    return String(re);\n  return String(re).replace(/(^|[^\\\\])(\\\\\\\\)*(["\'`])/g, "$1$2\\\\$3").replace(/>>/g, "\\\\>\\\\>");\n}\nfunction escapeForTextSelector(text, exact) {\n  if (typeof text !== "string")\n    return escapeRegexForSelector(text);\n  return `${JSON.stringify(text)}${exact ? "s" : "i"}`;\n}\nfunction escapeForAttributeSelector(value, exact) {\n  if (typeof value !== "string")\n    return escapeRegexForSelector(value);\n  return `"${value.replace(/\\\\/g, "\\\\\\\\").replace(/["]/g, \'\\\\"\')}"${exact ? "s" : "i"}`;\n}\nfunction trimString(input, cap, suffix = "") {\n  if (input.length <= cap)\n    return input;\n  const chars = [...input];\n  if (chars.length > cap)\n    return chars.slice(0, cap - suffix.length).join("") + suffix;\n  return chars.join("");\n}\nfunction trimStringWithEllipsis(input, cap) {\n  return trimString(input, cap, "\\u2026");\n}\nfunction escapeRegExp(s) {\n  return s.replace(/[.*+?^${}()|[\\]\\\\]/g, "\\\\$&");\n}\nfunction longestCommonSubstring(s1, s2) {\n  const n = s1.length;\n  const m = s2.length;\n  let maxLen = 0;\n  let endingIndex = 0;\n  const dp = Array(n + 1).fill(null).map(() => Array(m + 1).fill(0));\n  for (let i = 1; i <= n; i++) {\n    for (let j = 1; j <= m; j++) {\n      if (s1[i - 1] === s2[j - 1]) {\n        dp[i][j] = dp[i - 1][j - 1] + 1;\n        if (dp[i][j] > maxLen) {\n          maxLen = dp[i][j];\n          endingIndex = i;\n        }\n      }\n    }\n  }\n  return s1.slice(endingIndex - maxLen, endingIndex);\n}\n\n// packages/playwright-core/src/utils/isomorphic/locatorGenerators.ts\nfunction asLocator(lang, selector, isFrameLocator = false) {\n  return asLocators(lang, selector, isFrameLocator, 1)[0];\n}\nfunction asLocators(lang, selector, isFrameLocator = false, maxOutputSize = 20, preferredQuote) {\n  try {\n    return innerAsLocators(new generators[lang](preferredQuote), parseSelector(selector), isFrameLocator, maxOutputSize);\n  } catch (e) {\n    return [selector];\n  }\n}\nfunction innerAsLocators(factory, parsed, isFrameLocator = false, maxOutputSize = 20) {\n  const parts = [...parsed.parts];\n  const tokens = [];\n  let nextBase = isFrameLocator ? "frame-locator" : "page";\n  for (let index = 0; index < parts.length; index++) {\n    const part = parts[index];\n    const base = nextBase;\n    nextBase = "locator";\n    if (part.name === "internal:describe")\n      continue;\n    if (part.name === "nth") {\n      if (part.body === "0")\n        tokens.push([factory.generateLocator(base, "first", ""), factory.generateLocator(base, "nth", "0")]);\n      else if (part.body === "-1")\n        tokens.push([factory.generateLocator(base, "last", ""), factory.generateLocator(base, "nth", "-1")]);\n      else\n        tokens.push([factory.generateLocator(base, "nth", part.body)]);\n      continue;\n    }\n    if (part.name === "visible") {\n      tokens.push([factory.generateLocator(base, "visible", part.body), factory.generateLocator(base, "default", `visible=${part.body}`)]);\n      continue;\n    }\n    if (part.name === "internal:text") {\n      const { exact, text } = detectExact(part.body);\n      tokens.push([factory.generateLocator(base, "text", text, { exact })]);\n      continue;\n    }\n    if (part.name === "internal:has-text") {\n      const { exact, text } = detectExact(part.body);\n      if (!exact) {\n        tokens.push([factory.generateLocator(base, "has-text", text, { exact })]);\n        continue;\n      }\n    }\n    if (part.name === "internal:has-not-text") {\n      const { exact, text } = detectExact(part.body);\n      if (!exact) {\n        tokens.push([factory.generateLocator(base, "has-not-text", text, { exact })]);\n        continue;\n      }\n    }\n    if (part.name === "internal:has") {\n      const inners = innerAsLocators(factory, part.body.parsed, false, maxOutputSize);\n      tokens.push(inners.map((inner) => factory.generateLocator(base, "has", inner)));\n      continue;\n    }\n    if (part.name === "internal:has-not") {\n      const inners = innerAsLocators(factory, part.body.parsed, false, maxOutputSize);\n      tokens.push(inners.map((inner) => factory.generateLocator(base, "hasNot", inner)));\n      continue;\n    }\n    if (part.name === "internal:and") {\n      const inners = innerAsLocators(factory, part.body.parsed, false, maxOutputSize);\n      tokens.push(inners.map((inner) => factory.generateLocator(base, "and", inner)));\n      continue;\n    }\n    if (part.name === "internal:or") {\n      const inners = innerAsLocators(factory, part.body.parsed, false, maxOutputSize);\n      tokens.push(inners.map((inner) => factory.generateLocator(base, "or", inner)));\n      continue;\n    }\n    if (part.name === "internal:chain") {\n      const inners = innerAsLocators(factory, part.body.parsed, false, maxOutputSize);\n      tokens.push(inners.map((inner) => factory.generateLocator(base, "chain", inner)));\n      continue;\n    }\n    if (part.name === "internal:label") {\n      const { exact, text } = detectExact(part.body);\n      tokens.push([factory.generateLocator(base, "label", text, { exact })]);\n      continue;\n    }\n    if (part.name === "internal:role") {\n      const attrSelector = parseAttributeSelector(part.body, true);\n      const options = { attrs: [] };\n      for (const attr of attrSelector.attributes) {\n        if (attr.name === "name") {\n          options.exact = attr.caseSensitive;\n          options.name = attr.value;\n        } else {\n          if (attr.name === "level" && typeof attr.value === "string")\n            attr.value = +attr.value;\n          options.attrs.push({ name: attr.name === "include-hidden" ? "includeHidden" : attr.name, value: attr.value });\n        }\n      }\n      tokens.push([factory.generateLocator(base, "role", attrSelector.name, options)]);\n      continue;\n    }\n    if (part.name === "internal:testid") {\n      const attrSelector = parseAttributeSelector(part.body, true);\n      const { value } = attrSelector.attributes[0];\n      tokens.push([factory.generateLocator(base, "test-id", value)]);\n      continue;\n    }\n    if (part.name === "internal:attr") {\n      const attrSelector = parseAttributeSelector(part.body, true);\n      const { name, value, caseSensitive } = attrSelector.attributes[0];\n      const text = value;\n      const exact = !!caseSensitive;\n      if (name === "placeholder") {\n        tokens.push([factory.generateLocator(base, "placeholder", text, { exact })]);\n        continue;\n      }\n      if (name === "alt") {\n        tokens.push([factory.generateLocator(base, "alt", text, { exact })]);\n        continue;\n      }\n      if (name === "title") {\n        tokens.push([factory.generateLocator(base, "title", text, { exact })]);\n        continue;\n      }\n    }\n    if (part.name === "internal:control" && part.body === "enter-frame") {\n      const lastTokens = tokens[tokens.length - 1];\n      const lastPart = parts[index - 1];\n      const transformed = lastTokens.map((token) => factory.chainLocators([token, factory.generateLocator(base, "frame", "")]));\n      if (["xpath", "css"].includes(lastPart.name)) {\n        transformed.push(\n          factory.generateLocator(base, "frame-locator", stringifySelector({ parts: [lastPart] })),\n          factory.generateLocator(base, "frame-locator", stringifySelector({ parts: [lastPart] }, true))\n        );\n      }\n      lastTokens.splice(0, lastTokens.length, ...transformed);\n      nextBase = "frame-locator";\n      continue;\n    }\n    const nextPart = parts[index + 1];\n    const selectorPart = stringifySelector({ parts: [part] });\n    const locatorPart = factory.generateLocator(base, "default", selectorPart);\n    if (nextPart && ["internal:has-text", "internal:has-not-text"].includes(nextPart.name)) {\n      const { exact, text } = detectExact(nextPart.body);\n      if (!exact) {\n        const nextLocatorPart = factory.generateLocator("locator", nextPart.name === "internal:has-text" ? "has-text" : "has-not-text", text, { exact });\n        const options = {};\n        if (nextPart.name === "internal:has-text")\n          options.hasText = text;\n        else\n          options.hasNotText = text;\n        const combinedPart = factory.generateLocator(base, "default", selectorPart, options);\n        tokens.push([factory.chainLocators([locatorPart, nextLocatorPart]), combinedPart]);\n        index++;\n        continue;\n      }\n    }\n    let locatorPartWithEngine;\n    if (["xpath", "css"].includes(part.name)) {\n      const selectorPart2 = stringifySelector(\n        { parts: [part] },\n        /* forceEngineName */\n        true\n      );\n      locatorPartWithEngine = factory.generateLocator(base, "default", selectorPart2);\n    }\n    tokens.push([locatorPart, locatorPartWithEngine].filter(Boolean));\n  }\n  return combineTokens(factory, tokens, maxOutputSize);\n}\nfunction combineTokens(factory, tokens, maxOutputSize) {\n  const currentTokens = tokens.map(() => "");\n  const result = [];\n  const visit = (index) => {\n    if (index === tokens.length) {\n      result.push(factory.chainLocators(currentTokens));\n      return result.length < maxOutputSize;\n    }\n    for (const taken of tokens[index]) {\n      currentTokens[index] = taken;\n      if (!visit(index + 1))\n        return false;\n    }\n    return true;\n  };\n  visit(0);\n  return result;\n}\nfunction detectExact(text) {\n  let exact = false;\n  const match = text.match(/^\\/(.*)\\/([igm]*)$/);\n  if (match)\n    return { text: new RegExp(match[1], match[2]) };\n  if (text.endsWith(\'"\')) {\n    text = JSON.parse(text);\n    exact = true;\n  } else if (text.endsWith(\'"s\')) {\n    text = JSON.parse(text.substring(0, text.length - 1));\n    exact = true;\n  } else if (text.endsWith(\'"i\')) {\n    text = JSON.parse(text.substring(0, text.length - 1));\n    exact = false;\n  }\n  return { exact, text };\n}\nvar JavaScriptLocatorFactory = class {\n  constructor(preferredQuote) {\n    this.preferredQuote = preferredQuote;\n  }\n  generateLocator(base, kind, body, options = {}) {\n    switch (kind) {\n      case "default":\n        if (options.hasText !== void 0)\n          return `locator(${this.quote(body)}, { hasText: ${this.toHasText(options.hasText)} })`;\n        if (options.hasNotText !== void 0)\n          return `locator(${this.quote(body)}, { hasNotText: ${this.toHasText(options.hasNotText)} })`;\n        return `locator(${this.quote(body)})`;\n      case "frame-locator":\n        return `frameLocator(${this.quote(body)})`;\n      case "frame":\n        return `contentFrame()`;\n      case "nth":\n        return `nth(${body})`;\n      case "first":\n        return `first()`;\n      case "last":\n        return `last()`;\n      case "visible":\n        return `filter({ visible: ${body === "true" ? "true" : "false"} })`;\n      case "role":\n        const attrs = [];\n        if (isRegExp(options.name)) {\n          attrs.push(`name: ${this.regexToSourceString(options.name)}`);\n        } else if (typeof options.name === "string") {\n          attrs.push(`name: ${this.quote(options.name)}`);\n          if (options.exact)\n            attrs.push(`exact: true`);\n        }\n        for (const { name, value } of options.attrs)\n          attrs.push(`${name}: ${typeof value === "string" ? this.quote(value) : value}`);\n        const attrString = attrs.length ? `, { ${attrs.join(", ")} }` : "";\n        return `getByRole(${this.quote(body)}${attrString})`;\n      case "has-text":\n        return `filter({ hasText: ${this.toHasText(body)} })`;\n      case "has-not-text":\n        return `filter({ hasNotText: ${this.toHasText(body)} })`;\n      case "has":\n        return `filter({ has: ${body} })`;\n      case "hasNot":\n        return `filter({ hasNot: ${body} })`;\n      case "and":\n        return `and(${body})`;\n      case "or":\n        return `or(${body})`;\n      case "chain":\n        return `locator(${body})`;\n      case "test-id":\n        return `getByTestId(${this.toTestIdValue(body)})`;\n      case "text":\n        return this.toCallWithExact("getByText", body, !!options.exact);\n      case "alt":\n        return this.toCallWithExact("getByAltText", body, !!options.exact);\n      case "placeholder":\n        return this.toCallWithExact("getByPlaceholder", body, !!options.exact);\n      case "label":\n        return this.toCallWithExact("getByLabel", body, !!options.exact);\n      case "title":\n        return this.toCallWithExact("getByTitle", body, !!options.exact);\n      default:\n        throw new Error("Unknown selector kind " + kind);\n    }\n  }\n  chainLocators(locators) {\n    return locators.join(".");\n  }\n  regexToSourceString(re) {\n    return normalizeEscapedRegexQuotes(String(re));\n  }\n  toCallWithExact(method, body, exact) {\n    if (isRegExp(body))\n      return `${method}(${this.regexToSourceString(body)})`;\n    return exact ? `${method}(${this.quote(body)}, { exact: true })` : `${method}(${this.quote(body)})`;\n  }\n  toHasText(body) {\n    if (isRegExp(body))\n      return this.regexToSourceString(body);\n    return this.quote(body);\n  }\n  toTestIdValue(value) {\n    if (isRegExp(value))\n      return this.regexToSourceString(value);\n    return this.quote(value);\n  }\n  quote(text) {\n    var _a;\n    return escapeWithQuotes(text, (_a = this.preferredQuote) != null ? _a : "\'");\n  }\n};\nvar PythonLocatorFactory = class {\n  generateLocator(base, kind, body, options = {}) {\n    switch (kind) {\n      case "default":\n        if (options.hasText !== void 0)\n          return `locator(${this.quote(body)}, has_text=${this.toHasText(options.hasText)})`;\n        if (options.hasNotText !== void 0)\n          return `locator(${this.quote(body)}, has_not_text=${this.toHasText(options.hasNotText)})`;\n        return `locator(${this.quote(body)})`;\n      case "frame-locator":\n        return `frame_locator(${this.quote(body)})`;\n      case "frame":\n        return `content_frame`;\n      case "nth":\n        return `nth(${body})`;\n      case "first":\n        return `first`;\n      case "last":\n        return `last`;\n      case "visible":\n        return `filter(visible=${body === "true" ? "True" : "False"})`;\n      case "role":\n        const attrs = [];\n        if (isRegExp(options.name)) {\n          attrs.push(`name=${this.regexToString(options.name)}`);\n        } else if (typeof options.name === "string") {\n          attrs.push(`name=${this.quote(options.name)}`);\n          if (options.exact)\n            attrs.push(`exact=True`);\n        }\n        for (const { name, value } of options.attrs) {\n          let valueString = typeof value === "string" ? this.quote(value) : value;\n          if (typeof value === "boolean")\n            valueString = value ? "True" : "False";\n          attrs.push(`${toSnakeCase(name)}=${valueString}`);\n        }\n        const attrString = attrs.length ? `, ${attrs.join(", ")}` : "";\n        return `get_by_role(${this.quote(body)}${attrString})`;\n      case "has-text":\n        return `filter(has_text=${this.toHasText(body)})`;\n      case "has-not-text":\n        return `filter(has_not_text=${this.toHasText(body)})`;\n      case "has":\n        return `filter(has=${body})`;\n      case "hasNot":\n        return `filter(has_not=${body})`;\n      case "and":\n        return `and_(${body})`;\n      case "or":\n        return `or_(${body})`;\n      case "chain":\n        return `locator(${body})`;\n      case "test-id":\n        return `get_by_test_id(${this.toTestIdValue(body)})`;\n      case "text":\n        return this.toCallWithExact("get_by_text", body, !!options.exact);\n      case "alt":\n        return this.toCallWithExact("get_by_alt_text", body, !!options.exact);\n      case "placeholder":\n        return this.toCallWithExact("get_by_placeholder", body, !!options.exact);\n      case "label":\n        return this.toCallWithExact("get_by_label", body, !!options.exact);\n      case "title":\n        return this.toCallWithExact("get_by_title", body, !!options.exact);\n      default:\n        throw new Error("Unknown selector kind " + kind);\n    }\n  }\n  chainLocators(locators) {\n    return locators.join(".");\n  }\n  regexToString(body) {\n    const suffix = body.flags.includes("i") ? ", re.IGNORECASE" : "";\n    return `re.compile(r"${normalizeEscapedRegexQuotes(body.source).replace(/\\\\\\//, "/").replace(/"/g, \'\\\\"\')}"${suffix})`;\n  }\n  toCallWithExact(method, body, exact) {\n    if (isRegExp(body))\n      return `${method}(${this.regexToString(body)})`;\n    if (exact)\n      return `${method}(${this.quote(body)}, exact=True)`;\n    return `${method}(${this.quote(body)})`;\n  }\n  toHasText(body) {\n    if (isRegExp(body))\n      return this.regexToString(body);\n    return `${this.quote(body)}`;\n  }\n  toTestIdValue(value) {\n    if (isRegExp(value))\n      return this.regexToString(value);\n    return this.quote(value);\n  }\n  quote(text) {\n    return escapeWithQuotes(text, \'"\');\n  }\n};\nvar JavaLocatorFactory = class {\n  generateLocator(base, kind, body, options = {}) {\n    let clazz;\n    switch (base) {\n      case "page":\n        clazz = "Page";\n        break;\n      case "frame-locator":\n        clazz = "FrameLocator";\n        break;\n      case "locator":\n        clazz = "Locator";\n        break;\n    }\n    switch (kind) {\n      case "default":\n        if (options.hasText !== void 0)\n          return `locator(${this.quote(body)}, new ${clazz}.LocatorOptions().setHasText(${this.toHasText(options.hasText)}))`;\n        if (options.hasNotText !== void 0)\n          return `locator(${this.quote(body)}, new ${clazz}.LocatorOptions().setHasNotText(${this.toHasText(options.hasNotText)}))`;\n        return `locator(${this.quote(body)})`;\n      case "frame-locator":\n        return `frameLocator(${this.quote(body)})`;\n      case "frame":\n        return `contentFrame()`;\n      case "nth":\n        return `nth(${body})`;\n      case "first":\n        return `first()`;\n      case "last":\n        return `last()`;\n      case "visible":\n        return `filter(new ${clazz}.FilterOptions().setVisible(${body === "true" ? "true" : "false"}))`;\n      case "role":\n        const attrs = [];\n        if (isRegExp(options.name)) {\n          attrs.push(`.setName(${this.regexToString(options.name)})`);\n        } else if (typeof options.name === "string") {\n          attrs.push(`.setName(${this.quote(options.name)})`);\n          if (options.exact)\n            attrs.push(`.setExact(true)`);\n        }\n        for (const { name, value } of options.attrs)\n          attrs.push(`.set${toTitleCase(name)}(${typeof value === "string" ? this.quote(value) : value})`);\n        const attrString = attrs.length ? `, new ${clazz}.GetByRoleOptions()${attrs.join("")}` : "";\n        return `getByRole(AriaRole.${toSnakeCase(body).toUpperCase()}${attrString})`;\n      case "has-text":\n        return `filter(new ${clazz}.FilterOptions().setHasText(${this.toHasText(body)}))`;\n      case "has-not-text":\n        return `filter(new ${clazz}.FilterOptions().setHasNotText(${this.toHasText(body)}))`;\n      case "has":\n        return `filter(new ${clazz}.FilterOptions().setHas(${body}))`;\n      case "hasNot":\n        return `filter(new ${clazz}.FilterOptions().setHasNot(${body}))`;\n      case "and":\n        return `and(${body})`;\n      case "or":\n        return `or(${body})`;\n      case "chain":\n        return `locator(${body})`;\n      case "test-id":\n        return `getByTestId(${this.toTestIdValue(body)})`;\n      case "text":\n        return this.toCallWithExact(clazz, "getByText", body, !!options.exact);\n      case "alt":\n        return this.toCallWithExact(clazz, "getByAltText", body, !!options.exact);\n      case "placeholder":\n        return this.toCallWithExact(clazz, "getByPlaceholder", body, !!options.exact);\n      case "label":\n        return this.toCallWithExact(clazz, "getByLabel", body, !!options.exact);\n      case "title":\n        return this.toCallWithExact(clazz, "getByTitle", body, !!options.exact);\n      default:\n        throw new Error("Unknown selector kind " + kind);\n    }\n  }\n  chainLocators(locators) {\n    return locators.join(".");\n  }\n  regexToString(body) {\n    const suffix = body.flags.includes("i") ? ", Pattern.CASE_INSENSITIVE" : "";\n    return `Pattern.compile(${this.quote(normalizeEscapedRegexQuotes(body.source))}${suffix})`;\n  }\n  toCallWithExact(clazz, method, body, exact) {\n    if (isRegExp(body))\n      return `${method}(${this.regexToString(body)})`;\n    if (exact)\n      return `${method}(${this.quote(body)}, new ${clazz}.${toTitleCase(method)}Options().setExact(true))`;\n    return `${method}(${this.quote(body)})`;\n  }\n  toHasText(body) {\n    if (isRegExp(body))\n      return this.regexToString(body);\n    return this.quote(body);\n  }\n  toTestIdValue(value) {\n    if (isRegExp(value))\n      return this.regexToString(value);\n    return this.quote(value);\n  }\n  quote(text) {\n    return escapeWithQuotes(text, \'"\');\n  }\n};\nvar CSharpLocatorFactory = class {\n  generateLocator(base, kind, body, options = {}) {\n    switch (kind) {\n      case "default":\n        if (options.hasText !== void 0)\n          return `Locator(${this.quote(body)}, new() { ${this.toHasText(options.hasText)} })`;\n        if (options.hasNotText !== void 0)\n          return `Locator(${this.quote(body)}, new() { ${this.toHasNotText(options.hasNotText)} })`;\n        return `Locator(${this.quote(body)})`;\n      case "frame-locator":\n        return `FrameLocator(${this.quote(body)})`;\n      case "frame":\n        return `ContentFrame`;\n      case "nth":\n        return `Nth(${body})`;\n      case "first":\n        return `First`;\n      case "last":\n        return `Last`;\n      case "visible":\n        return `Filter(new() { Visible = ${body === "true" ? "true" : "false"} })`;\n      case "role":\n        const attrs = [];\n        if (isRegExp(options.name)) {\n          attrs.push(`NameRegex = ${this.regexToString(options.name)}`);\n        } else if (typeof options.name === "string") {\n          attrs.push(`Name = ${this.quote(options.name)}`);\n          if (options.exact)\n            attrs.push(`Exact = true`);\n        }\n        for (const { name, value } of options.attrs)\n          attrs.push(`${toTitleCase(name)} = ${typeof value === "string" ? this.quote(value) : value}`);\n        const attrString = attrs.length ? `, new() { ${attrs.join(", ")} }` : "";\n        return `GetByRole(AriaRole.${toTitleCase(body)}${attrString})`;\n      case "has-text":\n        return `Filter(new() { ${this.toHasText(body)} })`;\n      case "has-not-text":\n        return `Filter(new() { ${this.toHasNotText(body)} })`;\n      case "has":\n        return `Filter(new() { Has = ${body} })`;\n      case "hasNot":\n        return `Filter(new() { HasNot = ${body} })`;\n      case "and":\n        return `And(${body})`;\n      case "or":\n        return `Or(${body})`;\n      case "chain":\n        return `Locator(${body})`;\n      case "test-id":\n        return `GetByTestId(${this.toTestIdValue(body)})`;\n      case "text":\n        return this.toCallWithExact("GetByText", body, !!options.exact);\n      case "alt":\n        return this.toCallWithExact("GetByAltText", body, !!options.exact);\n      case "placeholder":\n        return this.toCallWithExact("GetByPlaceholder", body, !!options.exact);\n      case "label":\n        return this.toCallWithExact("GetByLabel", body, !!options.exact);\n      case "title":\n        return this.toCallWithExact("GetByTitle", body, !!options.exact);\n      default:\n        throw new Error("Unknown selector kind " + kind);\n    }\n  }\n  chainLocators(locators) {\n    return locators.join(".");\n  }\n  regexToString(body) {\n    const suffix = body.flags.includes("i") ? ", RegexOptions.IgnoreCase" : "";\n    return `new Regex(${this.quote(normalizeEscapedRegexQuotes(body.source))}${suffix})`;\n  }\n  toCallWithExact(method, body, exact) {\n    if (isRegExp(body))\n      return `${method}(${this.regexToString(body)})`;\n    if (exact)\n      return `${method}(${this.quote(body)}, new() { Exact = true })`;\n    return `${method}(${this.quote(body)})`;\n  }\n  toHasText(body) {\n    if (isRegExp(body))\n      return `HasTextRegex = ${this.regexToString(body)}`;\n    return `HasText = ${this.quote(body)}`;\n  }\n  toTestIdValue(value) {\n    if (isRegExp(value))\n      return this.regexToString(value);\n    return this.quote(value);\n  }\n  toHasNotText(body) {\n    if (isRegExp(body))\n      return `HasNotTextRegex = ${this.regexToString(body)}`;\n    return `HasNotText = ${this.quote(body)}`;\n  }\n  quote(text) {\n    return escapeWithQuotes(text, \'"\');\n  }\n};\nvar JsonlLocatorFactory = class {\n  generateLocator(base, kind, body, options = {}) {\n    return JSON.stringify({\n      kind,\n      body,\n      options\n    });\n  }\n  chainLocators(locators) {\n    const objects = locators.map((l) => JSON.parse(l));\n    for (let i = 0; i < objects.length - 1; ++i)\n      objects[i].next = objects[i + 1];\n    return JSON.stringify(objects[0]);\n  }\n};\nvar generators = {\n  javascript: JavaScriptLocatorFactory,\n  python: PythonLocatorFactory,\n  java: JavaLocatorFactory,\n  csharp: CSharpLocatorFactory,\n  jsonl: JsonlLocatorFactory\n};\nfunction isRegExp(obj) {\n  return obj instanceof RegExp;\n}\n\n// packages/injected/src/domUtils.ts\nvar globalOptions = {};\nfunction setGlobalOptions(options) {\n  globalOptions = options;\n}\nfunction isInsideScope(scope, element) {\n  while (element) {\n    if (scope.contains(element))\n      return true;\n    element = enclosingShadowHost(element);\n  }\n  return false;\n}\nfunction parentElementOrShadowHost(element) {\n  if (element.parentElement)\n    return element.parentElement;\n  if (!element.parentNode)\n    return;\n  if (element.parentNode.nodeType === 11 && element.parentNode.host)\n    return element.parentNode.host;\n}\nfunction enclosingShadowRootOrDocument(element) {\n  let node = element;\n  while (node.parentNode)\n    node = node.parentNode;\n  if (node.nodeType === 11 || node.nodeType === 9)\n    return node;\n}\nfunction enclosingShadowHost(element) {\n  while (element.parentElement)\n    element = element.parentElement;\n  return parentElementOrShadowHost(element);\n}\nfunction closestCrossShadow(element, css, scope) {\n  while (element) {\n    const closest = element.closest(css);\n    if (scope && closest !== scope && (closest == null ? void 0 : closest.contains(scope)))\n      return;\n    if (closest)\n      return closest;\n    element = enclosingShadowHost(element);\n  }\n}\nfunction getElementComputedStyle(element, pseudo) {\n  const cache = pseudo === "::before" ? cacheStyleBefore : pseudo === "::after" ? cacheStyleAfter : cacheStyle;\n  if (cache && cache.has(element))\n    return cache.get(element);\n  const style = element.ownerDocument && element.ownerDocument.defaultView ? element.ownerDocument.defaultView.getComputedStyle(element, pseudo) : void 0;\n  cache == null ? void 0 : cache.set(element, style);\n  return style;\n}\nfunction isElementStyleVisibilityVisible(element, style) {\n  style = style != null ? style : getElementComputedStyle(element);\n  if (!style)\n    return true;\n  if (Element.prototype.checkVisibility && globalOptions.browserNameForWorkarounds !== "webkit") {\n    if (!element.checkVisibility())\n      return false;\n  } else {\n    const detailsOrSummary = element.closest("details,summary");\n    if (detailsOrSummary !== element && (detailsOrSummary == null ? void 0 : detailsOrSummary.nodeName) === "DETAILS" && !detailsOrSummary.open)\n      return false;\n  }\n  if (style.visibility !== "visible")\n    return false;\n  return true;\n}\nfunction computeBox(element) {\n  const style = getElementComputedStyle(element);\n  if (!style)\n    return { visible: true, inline: false };\n  if (style.display === "contents") {\n    for (let child = element.firstChild; child; child = child.nextSibling) {\n      if (child.nodeType === 1 && isElementVisible(child))\n        return { visible: true, inline: false, style };\n      if (child.nodeType === 3 && isVisibleTextNode(child))\n        return { visible: true, inline: true, style };\n    }\n    return { visible: false, inline: false, style };\n  }\n  if (!isElementStyleVisibilityVisible(element, style))\n    return { style, visible: false, inline: false };\n  const rect = element.getBoundingClientRect();\n  return { rect, style, visible: rect.width > 0 && rect.height > 0, inline: style.display === "inline" };\n}\nfunction isElementVisible(element) {\n  return computeBox(element).visible;\n}\nfunction isVisibleTextNode(node) {\n  const range = node.ownerDocument.createRange();\n  range.selectNode(node);\n  const rect = range.getBoundingClientRect();\n  return rect.width > 0 && rect.height > 0;\n}\nfunction elementSafeTagName(element) {\n  const tagName = element.tagName;\n  if (typeof tagName === "string")\n    return tagName.toUpperCase();\n  if (element instanceof HTMLFormElement)\n    return "FORM";\n  return element.tagName.toUpperCase();\n}\nvar cacheStyle;\nvar cacheStyleBefore;\nvar cacheStyleAfter;\nvar cachesCounter = 0;\nfunction beginDOMCaches() {\n  ++cachesCounter;\n  cacheStyle != null ? cacheStyle : cacheStyle = /* @__PURE__ */ new Map();\n  cacheStyleBefore != null ? cacheStyleBefore : cacheStyleBefore = /* @__PURE__ */ new Map();\n  cacheStyleAfter != null ? cacheStyleAfter : cacheStyleAfter = /* @__PURE__ */ new Map();\n}\nfunction endDOMCaches() {\n  if (!--cachesCounter) {\n    cacheStyle = void 0;\n    cacheStyleBefore = void 0;\n    cacheStyleAfter = void 0;\n  }\n}\n\n// packages/injected/src/roleUtils.ts\nfunction hasExplicitAccessibleName(e) {\n  return e.hasAttribute("aria-label") || e.hasAttribute("aria-labelledby");\n}\nvar kAncestorPreventingLandmark = "article:not([role]), aside:not([role]), main:not([role]), nav:not([role]), section:not([role]), [role=article], [role=complementary], [role=main], [role=navigation], [role=region]";\nvar kGlobalAriaAttributes = [\n  ["aria-atomic", void 0],\n  ["aria-busy", void 0],\n  ["aria-controls", void 0],\n  ["aria-current", void 0],\n  ["aria-describedby", void 0],\n  ["aria-details", void 0],\n  // Global use deprecated in ARIA 1.2\n  // [\'aria-disabled\', undefined],\n  ["aria-dropeffect", void 0],\n  // Global use deprecated in ARIA 1.2\n  // [\'aria-errormessage\', undefined],\n  ["aria-flowto", void 0],\n  ["aria-grabbed", void 0],\n  // Global use deprecated in ARIA 1.2\n  // [\'aria-haspopup\', undefined],\n  ["aria-hidden", void 0],\n  // Global use deprecated in ARIA 1.2\n  // [\'aria-invalid\', undefined],\n  ["aria-keyshortcuts", void 0],\n  ["aria-label", ["caption", "code", "deletion", "emphasis", "generic", "insertion", "paragraph", "presentation", "strong", "subscript", "superscript"]],\n  ["aria-labelledby", ["caption", "code", "deletion", "emphasis", "generic", "insertion", "paragraph", "presentation", "strong", "subscript", "superscript"]],\n  ["aria-live", void 0],\n  ["aria-owns", void 0],\n  ["aria-relevant", void 0],\n  ["aria-roledescription", ["generic"]]\n];\nfunction hasGlobalAriaAttribute(element, forRole) {\n  return kGlobalAriaAttributes.some(([attr, prohibited]) => {\n    return !(prohibited == null ? void 0 : prohibited.includes(forRole || "")) && element.hasAttribute(attr);\n  });\n}\nfunction hasTabIndex(element) {\n  return !Number.isNaN(Number(String(element.getAttribute("tabindex"))));\n}\nfunction isFocusable(element) {\n  return !isNativelyDisabled(element) && (isNativelyFocusable(element) || hasTabIndex(element));\n}\nfunction isNativelyFocusable(element) {\n  const tagName = elementSafeTagName(element);\n  if (["BUTTON", "DETAILS", "SELECT", "TEXTAREA"].includes(tagName))\n    return true;\n  if (tagName === "A" || tagName === "AREA")\n    return element.hasAttribute("href");\n  if (tagName === "INPUT")\n    return !element.hidden;\n  return false;\n}\nvar kImplicitRoleByTagName = {\n  "A": (e) => {\n    return e.hasAttribute("href") ? "link" : null;\n  },\n  "AREA": (e) => {\n    return e.hasAttribute("href") ? "link" : null;\n  },\n  "ARTICLE": () => "article",\n  "ASIDE": () => "complementary",\n  "BLOCKQUOTE": () => "blockquote",\n  "BUTTON": () => "button",\n  "CAPTION": () => "caption",\n  "CODE": () => "code",\n  "DATALIST": () => "listbox",\n  "DD": () => "definition",\n  "DEL": () => "deletion",\n  "DETAILS": () => "group",\n  "DFN": () => "term",\n  "DIALOG": () => "dialog",\n  "DT": () => "term",\n  "EM": () => "emphasis",\n  "FIELDSET": () => "group",\n  "FIGURE": () => "figure",\n  "FOOTER": (e) => closestCrossShadow(e, kAncestorPreventingLandmark) ? null : "contentinfo",\n  "FORM": (e) => hasExplicitAccessibleName(e) ? "form" : null,\n  "H1": () => "heading",\n  "H2": () => "heading",\n  "H3": () => "heading",\n  "H4": () => "heading",\n  "H5": () => "heading",\n  "H6": () => "heading",\n  "HEADER": (e) => closestCrossShadow(e, kAncestorPreventingLandmark) ? null : "banner",\n  "HR": () => "separator",\n  "HTML": () => "document",\n  "IMG": (e) => e.getAttribute("alt") === "" && !e.getAttribute("title") && !hasGlobalAriaAttribute(e) && !hasTabIndex(e) ? "presentation" : "img",\n  "INPUT": (e) => {\n    const type = e.type.toLowerCase();\n    if (type === "search")\n      return e.hasAttribute("list") ? "combobox" : "searchbox";\n    if (["email", "tel", "text", "url", ""].includes(type)) {\n      const list = getIdRefs(e, e.getAttribute("list"))[0];\n      return list && elementSafeTagName(list) === "DATALIST" ? "combobox" : "textbox";\n    }\n    if (type === "hidden")\n      return null;\n    if (type === "file")\n      return "button";\n    return inputTypeToRole[type] || "textbox";\n  },\n  "INS": () => "insertion",\n  "LI": () => "listitem",\n  "MAIN": () => "main",\n  "MARK": () => "mark",\n  "MATH": () => "math",\n  "MENU": () => "list",\n  "METER": () => "meter",\n  "NAV": () => "navigation",\n  "OL": () => "list",\n  "OPTGROUP": () => "group",\n  "OPTION": () => "option",\n  "OUTPUT": () => "status",\n  "P": () => "paragraph",\n  "PROGRESS": () => "progressbar",\n  "SEARCH": () => "search",\n  "SECTION": (e) => hasExplicitAccessibleName(e) ? "region" : null,\n  "SELECT": (e) => e.hasAttribute("multiple") || e.size > 1 ? "listbox" : "combobox",\n  "STRONG": () => "strong",\n  "SUB": () => "subscript",\n  "SUP": () => "superscript",\n  // For <svg> we default to Chrome behavior:\n  // - Chrome reports \'img\'.\n  // - Firefox reports \'diagram\' that is not in official ARIA spec yet.\n  // - Safari reports \'no role\', but still computes accessible name.\n  "SVG": () => "img",\n  "TABLE": () => "table",\n  "TBODY": () => "rowgroup",\n  "TD": (e) => {\n    const table = closestCrossShadow(e, "table");\n    const role = table ? getExplicitAriaRole(table) : "";\n    return role === "grid" || role === "treegrid" ? "gridcell" : "cell";\n  },\n  "TEXTAREA": () => "textbox",\n  "TFOOT": () => "rowgroup",\n  "TH": (e) => {\n    if (e.getAttribute("scope") === "col")\n      return "columnheader";\n    if (e.getAttribute("scope") === "row")\n      return "rowheader";\n    const table = closestCrossShadow(e, "table");\n    const role = table ? getExplicitAriaRole(table) : "";\n    return role === "grid" || role === "treegrid" ? "gridcell" : "cell";\n  },\n  "THEAD": () => "rowgroup",\n  "TIME": () => "time",\n  "TR": () => "row",\n  "UL": () => "list"\n};\nvar kPresentationInheritanceParents = {\n  "DD": ["DL", "DIV"],\n  "DIV": ["DL"],\n  "DT": ["DL", "DIV"],\n  "LI": ["OL", "UL"],\n  "TBODY": ["TABLE"],\n  "TD": ["TR"],\n  "TFOOT": ["TABLE"],\n  "TH": ["TR"],\n  "THEAD": ["TABLE"],\n  "TR": ["THEAD", "TBODY", "TFOOT", "TABLE"]\n};\nfunction getImplicitAriaRole(element) {\n  var _a;\n  const implicitRole = ((_a = kImplicitRoleByTagName[elementSafeTagName(element)]) == null ? void 0 : _a.call(kImplicitRoleByTagName, element)) || "";\n  if (!implicitRole)\n    return null;\n  let ancestor = element;\n  while (ancestor) {\n    const parent = parentElementOrShadowHost(ancestor);\n    const parents = kPresentationInheritanceParents[elementSafeTagName(ancestor)];\n    if (!parents || !parent || !parents.includes(elementSafeTagName(parent)))\n      break;\n    const parentExplicitRole = getExplicitAriaRole(parent);\n    if ((parentExplicitRole === "none" || parentExplicitRole === "presentation") && !hasPresentationConflictResolution(parent, parentExplicitRole))\n      return parentExplicitRole;\n    ancestor = parent;\n  }\n  return implicitRole;\n}\nvar validRoles = [\n  "alert",\n  "alertdialog",\n  "application",\n  "article",\n  "banner",\n  "blockquote",\n  "button",\n  "caption",\n  "cell",\n  "checkbox",\n  "code",\n  "columnheader",\n  "combobox",\n  "complementary",\n  "contentinfo",\n  "definition",\n  "deletion",\n  "dialog",\n  "directory",\n  "document",\n  "emphasis",\n  "feed",\n  "figure",\n  "form",\n  "generic",\n  "grid",\n  "gridcell",\n  "group",\n  "heading",\n  "img",\n  "insertion",\n  "link",\n  "list",\n  "listbox",\n  "listitem",\n  "log",\n  "main",\n  "mark",\n  "marquee",\n  "math",\n  "meter",\n  "menu",\n  "menubar",\n  "menuitem",\n  "menuitemcheckbox",\n  "menuitemradio",\n  "navigation",\n  "none",\n  "note",\n  "option",\n  "paragraph",\n  "presentation",\n  "progressbar",\n  "radio",\n  "radiogroup",\n  "region",\n  "row",\n  "rowgroup",\n  "rowheader",\n  "scrollbar",\n  "search",\n  "searchbox",\n  "separator",\n  "slider",\n  "spinbutton",\n  "status",\n  "strong",\n  "subscript",\n  "superscript",\n  "switch",\n  "tab",\n  "table",\n  "tablist",\n  "tabpanel",\n  "term",\n  "textbox",\n  "time",\n  "timer",\n  "toolbar",\n  "tooltip",\n  "tree",\n  "treegrid",\n  "treeitem"\n];\nfunction getExplicitAriaRole(element) {\n  const roles = (element.getAttribute("role") || "").split(" ").map((role) => role.trim());\n  return roles.find((role) => validRoles.includes(role)) || null;\n}\nfunction hasPresentationConflictResolution(element, role) {\n  return hasGlobalAriaAttribute(element, role) || isFocusable(element);\n}\nfunction getAriaRole(element) {\n  const explicitRole = getExplicitAriaRole(element);\n  if (!explicitRole)\n    return getImplicitAriaRole(element);\n  if (explicitRole === "none" || explicitRole === "presentation") {\n    const implicitRole = getImplicitAriaRole(element);\n    if (hasPresentationConflictResolution(element, implicitRole))\n      return implicitRole;\n  }\n  return explicitRole;\n}\nfunction getAriaBoolean(attr) {\n  return attr === null ? void 0 : attr.toLowerCase() === "true";\n}\nfunction isElementIgnoredForAria(element) {\n  return ["STYLE", "SCRIPT", "NOSCRIPT", "TEMPLATE"].includes(elementSafeTagName(element));\n}\nfunction isElementHiddenForAria(element) {\n  if (isElementIgnoredForAria(element))\n    return true;\n  const style = getElementComputedStyle(element);\n  const isSlot = element.nodeName === "SLOT";\n  if ((style == null ? void 0 : style.display) === "contents" && !isSlot) {\n    for (let child = element.firstChild; child; child = child.nextSibling) {\n      if (child.nodeType === 1 && !isElementHiddenForAria(child))\n        return false;\n      if (child.nodeType === 3 && isVisibleTextNode(child))\n        return false;\n    }\n    return true;\n  }\n  const isOptionInsideSelect = element.nodeName === "OPTION" && !!element.closest("select");\n  if (!isOptionInsideSelect && !isSlot && !isElementStyleVisibilityVisible(element, style))\n    return true;\n  return belongsToDisplayNoneOrAriaHiddenOrNonSlotted(element);\n}\nfunction belongsToDisplayNoneOrAriaHiddenOrNonSlotted(element) {\n  let hidden = cacheIsHidden == null ? void 0 : cacheIsHidden.get(element);\n  if (hidden === void 0) {\n    hidden = false;\n    if (element.parentElement && element.parentElement.shadowRoot && !element.assignedSlot)\n      hidden = true;\n    if (!hidden) {\n      const style = getElementComputedStyle(element);\n      hidden = !style || style.display === "none" || getAriaBoolean(element.getAttribute("aria-hidden")) === true;\n    }\n    if (!hidden) {\n      const parent = parentElementOrShadowHost(element);\n      if (parent)\n        hidden = belongsToDisplayNoneOrAriaHiddenOrNonSlotted(parent);\n    }\n    cacheIsHidden == null ? void 0 : cacheIsHidden.set(element, hidden);\n  }\n  return hidden;\n}\nfunction getIdRefs(element, ref) {\n  if (!ref)\n    return [];\n  const root = enclosingShadowRootOrDocument(element);\n  if (!root)\n    return [];\n  try {\n    const ids = ref.split(" ").filter((id) => !!id);\n    const result = [];\n    for (const id of ids) {\n      const firstElement = root.querySelector("#" + CSS.escape(id));\n      if (firstElement && !result.includes(firstElement))\n        result.push(firstElement);\n    }\n    return result;\n  } catch (e) {\n    return [];\n  }\n}\nfunction trimFlatString(s) {\n  return s.trim();\n}\nfunction asFlatString(s) {\n  return s.split("\\xA0").map((chunk) => chunk.replace(/\\r\\n/g, "\\n").replace(/[\\u200b\\u00ad]/g, "").replace(/\\s\\s*/g, " ")).join("\\xA0").trim();\n}\nfunction queryInAriaOwned(element, selector) {\n  const result = [...element.querySelectorAll(selector)];\n  for (const owned of getIdRefs(element, element.getAttribute("aria-owns"))) {\n    if (owned.matches(selector))\n      result.push(owned);\n    result.push(...owned.querySelectorAll(selector));\n  }\n  return result;\n}\nfunction getCSSContent(element, pseudo) {\n  const cache = pseudo === "::before" ? cachePseudoContentBefore : pseudo === "::after" ? cachePseudoContentAfter : cachePseudoContent;\n  if (cache == null ? void 0 : cache.has(element))\n    return cache == null ? void 0 : cache.get(element);\n  const style = getElementComputedStyle(element, pseudo);\n  let content;\n  if (style) {\n    const contentValue = style.content;\n    if (contentValue && contentValue !== "none" && contentValue !== "normal") {\n      if (style.display !== "none" && style.visibility !== "hidden") {\n        content = parseCSSContentPropertyAsString(element, contentValue, !!pseudo);\n      }\n    }\n  }\n  if (pseudo && content !== void 0) {\n    const display = (style == null ? void 0 : style.display) || "inline";\n    if (display !== "inline")\n      content = " " + content + " ";\n  }\n  if (cache)\n    cache.set(element, content);\n  return content;\n}\nfunction parseCSSContentPropertyAsString(element, content, isPseudo) {\n  if (!content || content === "none" || content === "normal") {\n    return;\n  }\n  try {\n    let tokens = tokenize(content).filter((token) => !(token instanceof WhitespaceToken));\n    const delimIndex = tokens.findIndex((token) => token instanceof DelimToken && token.value === "/");\n    if (delimIndex !== -1) {\n      tokens = tokens.slice(delimIndex + 1);\n    } else if (!isPseudo) {\n      return;\n    }\n    const accumulated = [];\n    let index = 0;\n    while (index < tokens.length) {\n      if (tokens[index] instanceof StringToken) {\n        accumulated.push(tokens[index].value);\n        index++;\n      } else if (index + 2 < tokens.length && tokens[index] instanceof FunctionToken && tokens[index].value === "attr" && tokens[index + 1] instanceof IdentToken && tokens[index + 2] instanceof CloseParenToken) {\n        const attrName = tokens[index + 1].value;\n        accumulated.push(element.getAttribute(attrName) || "");\n        index += 3;\n      } else {\n        return;\n      }\n    }\n    return accumulated.join("");\n  } catch {\n  }\n}\nfunction getAriaLabelledByElements(element) {\n  const ref = element.getAttribute("aria-labelledby");\n  if (ref === null)\n    return null;\n  const refs = getIdRefs(element, ref);\n  return refs.length ? refs : null;\n}\nfunction allowsNameFromContent(role, targetDescendant) {\n  const alwaysAllowsNameFromContent = ["button", "cell", "checkbox", "columnheader", "gridcell", "heading", "link", "menuitem", "menuitemcheckbox", "menuitemradio", "option", "radio", "row", "rowheader", "switch", "tab", "tooltip", "treeitem"].includes(role);\n  const descendantAllowsNameFromContent = targetDescendant && ["", "caption", "code", "contentinfo", "definition", "deletion", "emphasis", "insertion", "list", "listitem", "mark", "none", "paragraph", "presentation", "region", "row", "rowgroup", "section", "strong", "subscript", "superscript", "table", "term", "time"].includes(role);\n  return alwaysAllowsNameFromContent || descendantAllowsNameFromContent;\n}\nfunction getElementAccessibleName(element, includeHidden) {\n  const cache = includeHidden ? cacheAccessibleNameHidden : cacheAccessibleName;\n  let accessibleName = cache == null ? void 0 : cache.get(element);\n  if (accessibleName === void 0) {\n    accessibleName = "";\n    const elementProhibitsNaming = ["caption", "code", "definition", "deletion", "emphasis", "generic", "insertion", "mark", "paragraph", "presentation", "strong", "subscript", "suggestion", "superscript", "term", "time"].includes(getAriaRole(element) || "");\n    if (!elementProhibitsNaming) {\n      accessibleName = asFlatString(getTextAlternativeInternal(element, {\n        includeHidden,\n        visitedElements: /* @__PURE__ */ new Set(),\n        embeddedInTargetElement: "self"\n      }));\n    }\n    cache == null ? void 0 : cache.set(element, accessibleName);\n  }\n  return accessibleName;\n}\nfunction getElementAccessibleDescription(element, includeHidden) {\n  const cache = includeHidden ? cacheAccessibleDescriptionHidden : cacheAccessibleDescription;\n  let accessibleDescription = cache == null ? void 0 : cache.get(element);\n  if (accessibleDescription === void 0) {\n    accessibleDescription = "";\n    if (element.hasAttribute("aria-describedby")) {\n      const describedBy = getIdRefs(element, element.getAttribute("aria-describedby"));\n      accessibleDescription = asFlatString(describedBy.map((ref) => getTextAlternativeInternal(ref, {\n        includeHidden,\n        visitedElements: /* @__PURE__ */ new Set(),\n        embeddedInDescribedBy: { element: ref, hidden: isElementHiddenForAria(ref) }\n      })).join(" "));\n    } else if (element.hasAttribute("aria-description")) {\n      accessibleDescription = asFlatString(element.getAttribute("aria-description") || "");\n    } else {\n      accessibleDescription = asFlatString(element.getAttribute("title") || "");\n    }\n    cache == null ? void 0 : cache.set(element, accessibleDescription);\n  }\n  return accessibleDescription;\n}\nfunction getAriaInvalid(element) {\n  const ariaInvalid = element.getAttribute("aria-invalid");\n  if (!ariaInvalid || ariaInvalid.trim() === "" || ariaInvalid.toLocaleLowerCase() === "false")\n    return "false";\n  if (ariaInvalid === "true" || ariaInvalid === "grammar" || ariaInvalid === "spelling")\n    return ariaInvalid;\n  return "true";\n}\nfunction getValidityInvalid(element) {\n  if ("validity" in element) {\n    const validity = element.validity;\n    return (validity == null ? void 0 : validity.valid) === false;\n  }\n  return false;\n}\nfunction getElementAccessibleErrorMessage(element) {\n  const cache = cacheAccessibleErrorMessage;\n  let accessibleErrorMessage = cacheAccessibleErrorMessage == null ? void 0 : cacheAccessibleErrorMessage.get(element);\n  if (accessibleErrorMessage === void 0) {\n    accessibleErrorMessage = "";\n    const isAriaInvalid = getAriaInvalid(element) !== "false";\n    const isValidityInvalid = getValidityInvalid(element);\n    if (isAriaInvalid || isValidityInvalid) {\n      const errorMessageId = element.getAttribute("aria-errormessage");\n      const errorMessages = getIdRefs(element, errorMessageId);\n      const parts = errorMessages.map((errorMessage) => asFlatString(\n        getTextAlternativeInternal(errorMessage, {\n          visitedElements: /* @__PURE__ */ new Set(),\n          embeddedInDescribedBy: { element: errorMessage, hidden: isElementHiddenForAria(errorMessage) }\n        })\n      ));\n      accessibleErrorMessage = parts.join(" ").trim();\n    }\n    cache == null ? void 0 : cache.set(element, accessibleErrorMessage);\n  }\n  return accessibleErrorMessage;\n}\nfunction getTextAlternativeInternal(element, options) {\n  var _a, _b, _c, _d;\n  if (options.visitedElements.has(element))\n    return "";\n  const childOptions = {\n    ...options,\n    embeddedInTargetElement: options.embeddedInTargetElement === "self" ? "descendant" : options.embeddedInTargetElement\n  };\n  if (!options.includeHidden) {\n    const isEmbeddedInHiddenReferenceTraversal = !!((_a = options.embeddedInLabelledBy) == null ? void 0 : _a.hidden) || !!((_b = options.embeddedInDescribedBy) == null ? void 0 : _b.hidden) || !!((_c = options.embeddedInNativeTextAlternative) == null ? void 0 : _c.hidden) || !!((_d = options.embeddedInLabel) == null ? void 0 : _d.hidden);\n    if (isElementIgnoredForAria(element) || !isEmbeddedInHiddenReferenceTraversal && isElementHiddenForAria(element)) {\n      options.visitedElements.add(element);\n      return "";\n    }\n  }\n  const labelledBy = getAriaLabelledByElements(element);\n  if (!options.embeddedInLabelledBy) {\n    const accessibleName = (labelledBy || []).map((ref) => getTextAlternativeInternal(ref, {\n      ...options,\n      embeddedInLabelledBy: { element: ref, hidden: isElementHiddenForAria(ref) },\n      embeddedInDescribedBy: void 0,\n      embeddedInTargetElement: void 0,\n      embeddedInLabel: void 0,\n      embeddedInNativeTextAlternative: void 0\n    })).join(" ");\n    if (accessibleName)\n      return accessibleName;\n  }\n  const role = getAriaRole(element) || "";\n  const tagName = elementSafeTagName(element);\n  if (!!options.embeddedInLabel || !!options.embeddedInLabelledBy || options.embeddedInTargetElement === "descendant") {\n    const isOwnLabel = [...element.labels || []].includes(element);\n    const isOwnLabelledBy = (labelledBy || []).includes(element);\n    if (!isOwnLabel && !isOwnLabelledBy) {\n      if (role === "textbox") {\n        options.visitedElements.add(element);\n        if (tagName === "INPUT" || tagName === "TEXTAREA")\n          return element.value;\n        return element.textContent || "";\n      }\n      if (["combobox", "listbox"].includes(role)) {\n        options.visitedElements.add(element);\n        let selectedOptions;\n        if (tagName === "SELECT") {\n          selectedOptions = [...element.selectedOptions];\n          if (!selectedOptions.length && element.options.length)\n            selectedOptions.push(element.options[0]);\n        } else {\n          const listbox = role === "combobox" ? queryInAriaOwned(element, "*").find((e) => getAriaRole(e) === "listbox") : element;\n          selectedOptions = listbox ? queryInAriaOwned(listbox, \'[aria-selected="true"]\').filter((e) => getAriaRole(e) === "option") : [];\n        }\n        if (!selectedOptions.length && tagName === "INPUT") {\n          return element.value;\n        }\n        return selectedOptions.map((option) => getTextAlternativeInternal(option, childOptions)).join(" ");\n      }\n      if (["progressbar", "scrollbar", "slider", "spinbutton", "meter"].includes(role)) {\n        options.visitedElements.add(element);\n        if (element.hasAttribute("aria-valuetext"))\n          return element.getAttribute("aria-valuetext") || "";\n        if (element.hasAttribute("aria-valuenow"))\n          return element.getAttribute("aria-valuenow") || "";\n        return element.getAttribute("value") || "";\n      }\n      if (["menu"].includes(role)) {\n        options.visitedElements.add(element);\n        return "";\n      }\n    }\n  }\n  const ariaLabel = element.getAttribute("aria-label") || "";\n  if (trimFlatString(ariaLabel)) {\n    options.visitedElements.add(element);\n    return ariaLabel;\n  }\n  if (!["presentation", "none"].includes(role)) {\n    if (tagName === "INPUT" && ["button", "submit", "reset"].includes(element.type)) {\n      options.visitedElements.add(element);\n      const value = element.value || "";\n      if (trimFlatString(value))\n        return value;\n      if (element.type === "submit")\n        return "Submit";\n      if (element.type === "reset")\n        return "Reset";\n      const title = element.getAttribute("title") || "";\n      return title;\n    }\n    if (tagName === "INPUT" && element.type === "file") {\n      options.visitedElements.add(element);\n      const labels = element.labels || [];\n      if (labels.length && !options.embeddedInLabelledBy)\n        return getAccessibleNameFromAssociatedLabels(labels, options);\n      return "Choose File";\n    }\n    if (tagName === "INPUT" && element.type === "image") {\n      options.visitedElements.add(element);\n      const labels = element.labels || [];\n      if (labels.length && !options.embeddedInLabelledBy)\n        return getAccessibleNameFromAssociatedLabels(labels, options);\n      const alt = element.getAttribute("alt") || "";\n      if (trimFlatString(alt))\n        return alt;\n      const title = element.getAttribute("title") || "";\n      if (trimFlatString(title))\n        return title;\n      return "Submit";\n    }\n    if (!labelledBy && tagName === "BUTTON") {\n      options.visitedElements.add(element);\n      const labels = element.labels || [];\n      if (labels.length)\n        return getAccessibleNameFromAssociatedLabels(labels, options);\n    }\n    if (!labelledBy && tagName === "OUTPUT") {\n      options.visitedElements.add(element);\n      const labels = element.labels || [];\n      if (labels.length)\n        return getAccessibleNameFromAssociatedLabels(labels, options);\n      return element.getAttribute("title") || "";\n    }\n    if (!labelledBy && (tagName === "TEXTAREA" || tagName === "SELECT" || tagName === "INPUT")) {\n      options.visitedElements.add(element);\n      const labels = element.labels || [];\n      if (labels.length)\n        return getAccessibleNameFromAssociatedLabels(labels, options);\n      const usePlaceholder = tagName === "INPUT" && ["text", "password", "search", "tel", "email", "url"].includes(element.type) || tagName === "TEXTAREA";\n      const placeholder = element.getAttribute("placeholder") || "";\n      const title = element.getAttribute("title") || "";\n      if (!usePlaceholder || title)\n        return title;\n      return placeholder;\n    }\n    if (!labelledBy && tagName === "FIELDSET") {\n      options.visitedElements.add(element);\n      for (let child = element.firstElementChild; child; child = child.nextElementSibling) {\n        if (elementSafeTagName(child) === "LEGEND") {\n          return getTextAlternativeInternal(child, {\n            ...childOptions,\n            embeddedInNativeTextAlternative: { element: child, hidden: isElementHiddenForAria(child) }\n          });\n        }\n      }\n      const title = element.getAttribute("title") || "";\n      return title;\n    }\n    if (!labelledBy && tagName === "FIGURE") {\n      options.visitedElements.add(element);\n      for (let child = element.firstElementChild; child; child = child.nextElementSibling) {\n        if (elementSafeTagName(child) === "FIGCAPTION") {\n          return getTextAlternativeInternal(child, {\n            ...childOptions,\n            embeddedInNativeTextAlternative: { element: child, hidden: isElementHiddenForAria(child) }\n          });\n        }\n      }\n      const title = element.getAttribute("title") || "";\n      return title;\n    }\n    if (tagName === "IMG") {\n      options.visitedElements.add(element);\n      const alt = element.getAttribute("alt") || "";\n      if (trimFlatString(alt))\n        return alt;\n      const title = element.getAttribute("title") || "";\n      return title;\n    }\n    if (tagName === "TABLE") {\n      options.visitedElements.add(element);\n      for (let child = element.firstElementChild; child; child = child.nextElementSibling) {\n        if (elementSafeTagName(child) === "CAPTION") {\n          return getTextAlternativeInternal(child, {\n            ...childOptions,\n            embeddedInNativeTextAlternative: { element: child, hidden: isElementHiddenForAria(child) }\n          });\n        }\n      }\n      const summary = element.getAttribute("summary") || "";\n      if (summary)\n        return summary;\n    }\n    if (tagName === "AREA") {\n      options.visitedElements.add(element);\n      const alt = element.getAttribute("alt") || "";\n      if (trimFlatString(alt))\n        return alt;\n      const title = element.getAttribute("title") || "";\n      return title;\n    }\n    if (tagName === "SVG" || element.ownerSVGElement) {\n      options.visitedElements.add(element);\n      for (let child = element.firstElementChild; child; child = child.nextElementSibling) {\n        if (elementSafeTagName(child) === "TITLE" && child.ownerSVGElement) {\n          return getTextAlternativeInternal(child, {\n            ...childOptions,\n            embeddedInLabelledBy: { element: child, hidden: isElementHiddenForAria(child) }\n          });\n        }\n      }\n    }\n    if (element.ownerSVGElement && tagName === "A") {\n      const title = element.getAttribute("xlink:title") || "";\n      if (trimFlatString(title)) {\n        options.visitedElements.add(element);\n        return title;\n      }\n    }\n  }\n  const shouldNameFromContentForSummary = tagName === "SUMMARY" && !["presentation", "none"].includes(role);\n  if (allowsNameFromContent(role, options.embeddedInTargetElement === "descendant") || shouldNameFromContentForSummary || !!options.embeddedInLabelledBy || !!options.embeddedInDescribedBy || !!options.embeddedInLabel || !!options.embeddedInNativeTextAlternative) {\n    options.visitedElements.add(element);\n    const accessibleName = innerAccumulatedElementText(element, childOptions);\n    const maybeTrimmedAccessibleName = options.embeddedInTargetElement === "self" ? trimFlatString(accessibleName) : accessibleName;\n    if (maybeTrimmedAccessibleName)\n      return accessibleName;\n  }\n  if (!["presentation", "none"].includes(role) || tagName === "IFRAME") {\n    options.visitedElements.add(element);\n    const title = element.getAttribute("title") || "";\n    if (trimFlatString(title))\n      return title;\n  }\n  options.visitedElements.add(element);\n  return "";\n}\nfunction innerAccumulatedElementText(element, options) {\n  const tokens = [];\n  const visit = (node, skipSlotted) => {\n    var _a;\n    if (skipSlotted && node.assignedSlot)\n      return;\n    if (node.nodeType === 1) {\n      const display = ((_a = getElementComputedStyle(node)) == null ? void 0 : _a.display) || "inline";\n      let token = getTextAlternativeInternal(node, options);\n      if (display !== "inline" || node.nodeName === "BR")\n        token = " " + token + " ";\n      tokens.push(token);\n    } else if (node.nodeType === 3) {\n      tokens.push(node.textContent || "");\n    }\n  };\n  tokens.push(getCSSContent(element, "::before") || "");\n  const content = getCSSContent(element);\n  if (content !== void 0) {\n    tokens.push(content);\n  } else {\n    const assignedNodes = element.nodeName === "SLOT" ? element.assignedNodes() : [];\n    if (assignedNodes.length) {\n      for (const child of assignedNodes)\n        visit(child, false);\n    } else {\n      for (let child = element.firstChild; child; child = child.nextSibling)\n        visit(child, true);\n      if (element.shadowRoot) {\n        for (let child = element.shadowRoot.firstChild; child; child = child.nextSibling)\n          visit(child, true);\n      }\n      for (const owned of getIdRefs(element, element.getAttribute("aria-owns")))\n        visit(owned, true);\n    }\n  }\n  tokens.push(getCSSContent(element, "::after") || "");\n  return tokens.join("");\n}\nvar kAriaSelectedRoles = ["gridcell", "option", "row", "tab", "rowheader", "columnheader", "treeitem"];\nfunction getAriaSelected(element) {\n  if (elementSafeTagName(element) === "OPTION")\n    return element.selected;\n  if (kAriaSelectedRoles.includes(getAriaRole(element) || ""))\n    return getAriaBoolean(element.getAttribute("aria-selected")) === true;\n  return false;\n}\nvar kAriaCheckedRoles = ["checkbox", "menuitemcheckbox", "option", "radio", "switch", "menuitemradio", "treeitem"];\nfunction getAriaChecked(element) {\n  const result = getChecked(element, true);\n  return result === "error" ? false : result;\n}\nfunction getCheckedAllowMixed(element) {\n  return getChecked(element, true);\n}\nfunction getCheckedWithoutMixed(element) {\n  const result = getChecked(element, false);\n  return result;\n}\nfunction getChecked(element, allowMixed) {\n  const tagName = elementSafeTagName(element);\n  if (allowMixed && tagName === "INPUT" && element.indeterminate)\n    return "mixed";\n  if (tagName === "INPUT" && ["checkbox", "radio"].includes(element.type))\n    return element.checked;\n  if (kAriaCheckedRoles.includes(getAriaRole(element) || "")) {\n    const checked = element.getAttribute("aria-checked");\n    if (checked === "true")\n      return true;\n    if (allowMixed && checked === "mixed")\n      return "mixed";\n    return false;\n  }\n  return "error";\n}\nvar kAriaReadonlyRoles = ["checkbox", "combobox", "grid", "gridcell", "listbox", "radiogroup", "slider", "spinbutton", "textbox", "columnheader", "rowheader", "searchbox", "switch", "treegrid"];\nfunction getReadonly(element) {\n  const tagName = elementSafeTagName(element);\n  if (["INPUT", "TEXTAREA", "SELECT"].includes(tagName))\n    return element.hasAttribute("readonly");\n  if (kAriaReadonlyRoles.includes(getAriaRole(element) || ""))\n    return element.getAttribute("aria-readonly") === "true";\n  if (element.isContentEditable)\n    return false;\n  return "error";\n}\nvar kAriaPressedRoles = ["button"];\nfunction getAriaPressed(element) {\n  if (kAriaPressedRoles.includes(getAriaRole(element) || "")) {\n    const pressed = element.getAttribute("aria-pressed");\n    if (pressed === "true")\n      return true;\n    if (pressed === "mixed")\n      return "mixed";\n  }\n  return false;\n}\nvar kAriaExpandedRoles = ["application", "button", "checkbox", "combobox", "gridcell", "link", "listbox", "menuitem", "row", "rowheader", "tab", "treeitem", "columnheader", "menuitemcheckbox", "menuitemradio", "rowheader", "switch"];\nfunction getAriaExpanded(element) {\n  if (elementSafeTagName(element) === "DETAILS")\n    return element.open;\n  if (kAriaExpandedRoles.includes(getAriaRole(element) || "")) {\n    const expanded = element.getAttribute("aria-expanded");\n    if (expanded === null)\n      return void 0;\n    if (expanded === "true")\n      return true;\n    return false;\n  }\n  return void 0;\n}\nvar kAriaLevelRoles = ["heading", "listitem", "row", "treeitem"];\nfunction getAriaLevel(element) {\n  const native = { "H1": 1, "H2": 2, "H3": 3, "H4": 4, "H5": 5, "H6": 6 }[elementSafeTagName(element)];\n  if (native)\n    return native;\n  if (kAriaLevelRoles.includes(getAriaRole(element) || "")) {\n    const attr = element.getAttribute("aria-level");\n    const value = attr === null ? Number.NaN : Number(attr);\n    if (Number.isInteger(value) && value >= 1)\n      return value;\n  }\n  return 0;\n}\nvar kAriaDisabledRoles = ["application", "button", "composite", "gridcell", "group", "input", "link", "menuitem", "scrollbar", "separator", "tab", "checkbox", "columnheader", "combobox", "grid", "listbox", "menu", "menubar", "menuitemcheckbox", "menuitemradio", "option", "radio", "radiogroup", "row", "rowheader", "searchbox", "select", "slider", "spinbutton", "switch", "tablist", "textbox", "toolbar", "tree", "treegrid", "treeitem"];\nfunction getAriaDisabled(element) {\n  return isNativelyDisabled(element) || hasExplicitAriaDisabled(element);\n}\nfunction isNativelyDisabled(element) {\n  const isNativeFormControl = ["BUTTON", "INPUT", "SELECT", "TEXTAREA", "OPTION", "OPTGROUP"].includes(elementSafeTagName(element));\n  return isNativeFormControl && (element.hasAttribute("disabled") || belongsToDisabledOptGroup(element) || belongsToDisabledFieldSet(element));\n}\nfunction belongsToDisabledOptGroup(element) {\n  return elementSafeTagName(element) === "OPTION" && !!element.closest("OPTGROUP[DISABLED]");\n}\nfunction belongsToDisabledFieldSet(element) {\n  const fieldSetElement = element == null ? void 0 : element.closest("FIELDSET[DISABLED]");\n  if (!fieldSetElement)\n    return false;\n  const legendElement = fieldSetElement.querySelector(":scope > LEGEND");\n  return !legendElement || !legendElement.contains(element);\n}\nfunction hasExplicitAriaDisabled(element, isAncestor = false) {\n  if (!element)\n    return false;\n  if (isAncestor || kAriaDisabledRoles.includes(getAriaRole(element) || "")) {\n    const attribute = (element.getAttribute("aria-disabled") || "").toLowerCase();\n    if (attribute === "true")\n      return true;\n    if (attribute === "false")\n      return false;\n    return hasExplicitAriaDisabled(parentElementOrShadowHost(element), true);\n  }\n  return false;\n}\nfunction getAccessibleNameFromAssociatedLabels(labels, options) {\n  return [...labels].map((label) => getTextAlternativeInternal(label, {\n    ...options,\n    embeddedInLabel: { element: label, hidden: isElementHiddenForAria(label) },\n    embeddedInNativeTextAlternative: void 0,\n    embeddedInLabelledBy: void 0,\n    embeddedInDescribedBy: void 0,\n    embeddedInTargetElement: void 0\n  })).filter((accessibleName) => !!accessibleName).join(" ");\n}\nfunction receivesPointerEvents(element) {\n  const cache = cachePointerEvents;\n  let e = element;\n  let result;\n  const parents = [];\n  for (; e; e = parentElementOrShadowHost(e)) {\n    const cached = cache.get(e);\n    if (cached !== void 0) {\n      result = cached;\n      break;\n    }\n    parents.push(e);\n    const style = getElementComputedStyle(e);\n    if (!style) {\n      result = true;\n      break;\n    }\n    const value = style.pointerEvents;\n    if (value) {\n      result = value !== "none";\n      break;\n    }\n  }\n  if (result === void 0)\n    result = true;\n  for (const parent of parents)\n    cache.set(parent, result);\n  return result;\n}\nvar cacheAccessibleName;\nvar cacheAccessibleNameHidden;\nvar cacheAccessibleDescription;\nvar cacheAccessibleDescriptionHidden;\nvar cacheAccessibleErrorMessage;\nvar cacheIsHidden;\nvar cachePseudoContent;\nvar cachePseudoContentBefore;\nvar cachePseudoContentAfter;\nvar cachePointerEvents;\nvar cachesCounter2 = 0;\nfunction beginAriaCaches() {\n  beginDOMCaches();\n  ++cachesCounter2;\n  cacheAccessibleName != null ? cacheAccessibleName : cacheAccessibleName = /* @__PURE__ */ new Map();\n  cacheAccessibleNameHidden != null ? cacheAccessibleNameHidden : cacheAccessibleNameHidden = /* @__PURE__ */ new Map();\n  cacheAccessibleDescription != null ? cacheAccessibleDescription : cacheAccessibleDescription = /* @__PURE__ */ new Map();\n  cacheAccessibleDescriptionHidden != null ? cacheAccessibleDescriptionHidden : cacheAccessibleDescriptionHidden = /* @__PURE__ */ new Map();\n  cacheAccessibleErrorMessage != null ? cacheAccessibleErrorMessage : cacheAccessibleErrorMessage = /* @__PURE__ */ new Map();\n  cacheIsHidden != null ? cacheIsHidden : cacheIsHidden = /* @__PURE__ */ new Map();\n  cachePseudoContent != null ? cachePseudoContent : cachePseudoContent = /* @__PURE__ */ new Map();\n  cachePseudoContentBefore != null ? cachePseudoContentBefore : cachePseudoContentBefore = /* @__PURE__ */ new Map();\n  cachePseudoContentAfter != null ? cachePseudoContentAfter : cachePseudoContentAfter = /* @__PURE__ */ new Map();\n  cachePointerEvents != null ? cachePointerEvents : cachePointerEvents = /* @__PURE__ */ new Map();\n}\nfunction endAriaCaches() {\n  if (!--cachesCounter2) {\n    cacheAccessibleName = void 0;\n    cacheAccessibleNameHidden = void 0;\n    cacheAccessibleDescription = void 0;\n    cacheAccessibleDescriptionHidden = void 0;\n    cacheAccessibleErrorMessage = void 0;\n    cacheIsHidden = void 0;\n    cachePseudoContent = void 0;\n    cachePseudoContentBefore = void 0;\n    cachePseudoContentAfter = void 0;\n    cachePointerEvents = void 0;\n  }\n  endDOMCaches();\n}\nvar inputTypeToRole = {\n  "button": "button",\n  "checkbox": "checkbox",\n  "image": "button",\n  "number": "spinbutton",\n  "radio": "radio",\n  "range": "slider",\n  "reset": "button",\n  "submit": "button"\n};\n\n// packages/injected/src/yaml.ts\nfunction yamlEscapeKeyIfNeeded(str) {\n  if (!yamlStringNeedsQuotes(str))\n    return str;\n  return `\'` + str.replace(/\'/g, `\'\'`) + `\'`;\n}\nfunction yamlEscapeValueIfNeeded(str) {\n  if (!yamlStringNeedsQuotes(str))\n    return str;\n  return \'"\' + str.replace(/[\\\\"\\x00-\\x1f\\x7f-\\x9f]/g, (c) => {\n    switch (c) {\n      case "\\\\":\n        return "\\\\\\\\";\n      case \'"\':\n        return \'\\\\"\';\n      case "\\b":\n        return "\\\\b";\n      case "\\f":\n        return "\\\\f";\n      case "\\n":\n        return "\\\\n";\n      case "\\r":\n        return "\\\\r";\n      case "	":\n        return "\\\\t";\n      default:\n        const code = c.charCodeAt(0);\n        return "\\\\x" + code.toString(16).padStart(2, "0");\n    }\n  }) + \'"\';\n}\nfunction yamlStringNeedsQuotes(str) {\n  if (str.length === 0)\n    return true;\n  if (/^\\s|\\s$/.test(str))\n    return true;\n  if (/[\\x00-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f-\\x9f]/.test(str))\n    return true;\n  if (/^-/.test(str))\n    return true;\n  if (/[\\n:](\\s|$)/.test(str))\n    return true;\n  if (/\\s#/.test(str))\n    return true;\n  if (/[\\n\\r]/.test(str))\n    return true;\n  if (/^[&*\\],?!>|@"\'#%]/.test(str))\n    return true;\n  if (/[{}`]/.test(str))\n    return true;\n  if (/^\\[/.test(str))\n    return true;\n  if (!isNaN(Number(str)) || ["y", "n", "yes", "no", "true", "false", "on", "off", "null"].includes(str.toLowerCase()))\n    return true;\n  return false;\n}\n\n// packages/injected/src/ariaSnapshot.ts\nvar lastRef = 0;\nfunction toInternalOptions(options) {\n  if (options.mode === "ai") {\n    return {\n      visibility: "ariaOrVisible",\n      refs: "interactable",\n      refPrefix: options.refPrefix,\n      includeGenericRole: true,\n      renderActive: true,\n      renderCursorPointer: true\n    };\n  }\n  if (options.mode === "autoexpect") {\n    return { visibility: "ariaAndVisible", refs: "none" };\n  }\n  if (options.mode === "codegen") {\n    return { visibility: "aria", refs: "none", renderStringsAsRegex: true };\n  }\n  return { visibility: "aria", refs: "none" };\n}\nfunction generateAriaTree(rootElement, publicOptions) {\n  const options = toInternalOptions(publicOptions);\n  const visited = /* @__PURE__ */ new Set();\n  const snapshot = {\n    root: { role: "fragment", name: "", children: [], element: rootElement, props: {}, box: computeBox(rootElement), receivesPointerEvents: true },\n    elements: /* @__PURE__ */ new Map(),\n    refs: /* @__PURE__ */ new Map()\n  };\n  const visit = (ariaNode, node, parentElementVisible) => {\n    if (visited.has(node))\n      return;\n    visited.add(node);\n    if (node.nodeType === Node.TEXT_NODE && node.nodeValue) {\n      if (!parentElementVisible)\n        return;\n      const text = node.nodeValue;\n      if (ariaNode.role !== "textbox" && text)\n        ariaNode.children.push(node.nodeValue || "");\n      return;\n    }\n    if (node.nodeType !== Node.ELEMENT_NODE)\n      return;\n    const element = node;\n    const isElementVisibleForAria = !isElementHiddenForAria(element);\n    let visible = isElementVisibleForAria;\n    if (options.visibility === "ariaOrVisible")\n      visible = isElementVisibleForAria || isElementVisible(element);\n    if (options.visibility === "ariaAndVisible")\n      visible = isElementVisibleForAria && isElementVisible(element);\n    if (options.visibility === "aria" && !visible)\n      return;\n    const ariaChildren = [];\n    if (element.hasAttribute("aria-owns")) {\n      const ids = element.getAttribute("aria-owns").split(/\\s+/);\n      for (const id of ids) {\n        const ownedElement = rootElement.ownerDocument.getElementById(id);\n        if (ownedElement)\n          ariaChildren.push(ownedElement);\n      }\n    }\n    const childAriaNode = visible ? toAriaNode(element, options) : null;\n    if (childAriaNode) {\n      if (childAriaNode.ref) {\n        snapshot.elements.set(childAriaNode.ref, element);\n        snapshot.refs.set(element, childAriaNode.ref);\n      }\n      ariaNode.children.push(childAriaNode);\n    }\n    processElement(childAriaNode || ariaNode, element, ariaChildren, visible);\n  };\n  function processElement(ariaNode, element, ariaChildren, parentElementVisible) {\n    var _a;\n    const display = ((_a = getElementComputedStyle(element)) == null ? void 0 : _a.display) || "inline";\n    const treatAsBlock = display !== "inline" || element.nodeName === "BR" ? " " : "";\n    if (treatAsBlock)\n      ariaNode.children.push(treatAsBlock);\n    ariaNode.children.push(getCSSContent(element, "::before") || "");\n    const assignedNodes = element.nodeName === "SLOT" ? element.assignedNodes() : [];\n    if (assignedNodes.length) {\n      for (const child of assignedNodes)\n        visit(ariaNode, child, parentElementVisible);\n    } else {\n      for (let child = element.firstChild; child; child = child.nextSibling) {\n        if (!child.assignedSlot)\n          visit(ariaNode, child, parentElementVisible);\n      }\n      if (element.shadowRoot) {\n        for (let child = element.shadowRoot.firstChild; child; child = child.nextSibling)\n          visit(ariaNode, child, parentElementVisible);\n      }\n    }\n    for (const child of ariaChildren)\n      visit(ariaNode, child, parentElementVisible);\n    ariaNode.children.push(getCSSContent(element, "::after") || "");\n    if (treatAsBlock)\n      ariaNode.children.push(treatAsBlock);\n    if (ariaNode.children.length === 1 && ariaNode.name === ariaNode.children[0])\n      ariaNode.children = [];\n    if (ariaNode.role === "link" && element.hasAttribute("href")) {\n      const href = element.getAttribute("href");\n      ariaNode.props["url"] = href;\n    }\n    if (ariaNode.role === "textbox" && element.hasAttribute("placeholder") && element.getAttribute("placeholder") !== ariaNode.name) {\n      const placeholder = element.getAttribute("placeholder");\n      ariaNode.props["placeholder"] = placeholder;\n    }\n  }\n  beginAriaCaches();\n  try {\n    visit(snapshot.root, rootElement, true);\n  } finally {\n    endAriaCaches();\n  }\n  normalizeStringChildren(snapshot.root);\n  normalizeGenericRoles(snapshot.root);\n  return snapshot;\n}\nfunction computeAriaRef(ariaNode, options) {\n  var _a;\n  if (options.refs === "none")\n    return;\n  if (options.refs === "interactable" && (!ariaNode.box.visible || !ariaNode.receivesPointerEvents))\n    return;\n  let ariaRef;\n  ariaRef = ariaNode.element._ariaRef;\n  if (!ariaRef || ariaRef.role !== ariaNode.role || ariaRef.name !== ariaNode.name) {\n    ariaRef = { role: ariaNode.role, name: ariaNode.name, ref: ((_a = options.refPrefix) != null ? _a : "") + "e" + ++lastRef };\n    ariaNode.element._ariaRef = ariaRef;\n  }\n  ariaNode.ref = ariaRef.ref;\n}\nfunction toAriaNode(element, options) {\n  var _a;\n  const active = element.ownerDocument.activeElement === element;\n  if (element.nodeName === "IFRAME") {\n    const ariaNode = {\n      role: "iframe",\n      name: "",\n      children: [],\n      props: {},\n      element,\n      box: computeBox(element),\n      receivesPointerEvents: true,\n      active\n    };\n    computeAriaRef(ariaNode, options);\n    return ariaNode;\n  }\n  const defaultRole = options.includeGenericRole ? "generic" : null;\n  const role = (_a = getAriaRole(element)) != null ? _a : defaultRole;\n  if (!role || role === "presentation" || role === "none")\n    return null;\n  const name = normalizeWhiteSpace(getElementAccessibleName(element, false) || "");\n  const receivesPointerEvents2 = receivesPointerEvents(element);\n  const box = computeBox(element);\n  if (role === "generic" && box.inline && element.childNodes.length === 1 && element.childNodes[0].nodeType === Node.TEXT_NODE)\n    return null;\n  const result = {\n    role,\n    name,\n    children: [],\n    props: {},\n    element,\n    box,\n    receivesPointerEvents: receivesPointerEvents2,\n    active\n  };\n  computeAriaRef(result, options);\n  if (kAriaCheckedRoles.includes(role))\n    result.checked = getAriaChecked(element);\n  if (kAriaDisabledRoles.includes(role))\n    result.disabled = getAriaDisabled(element);\n  if (kAriaExpandedRoles.includes(role))\n    result.expanded = getAriaExpanded(element);\n  if (kAriaLevelRoles.includes(role))\n    result.level = getAriaLevel(element);\n  if (kAriaPressedRoles.includes(role))\n    result.pressed = getAriaPressed(element);\n  if (kAriaSelectedRoles.includes(role))\n    result.selected = getAriaSelected(element);\n  if (element instanceof HTMLInputElement || element instanceof HTMLTextAreaElement) {\n    if (element.type !== "checkbox" && element.type !== "radio" && element.type !== "file")\n      result.children = [element.value];\n  }\n  return result;\n}\nfunction normalizeGenericRoles(node) {\n  const normalizeChildren = (node2) => {\n    const result = [];\n    for (const child of node2.children || []) {\n      if (typeof child === "string") {\n        result.push(child);\n        continue;\n      }\n      const normalized = normalizeChildren(child);\n      result.push(...normalized);\n    }\n    const removeSelf = node2.role === "generic" && !node2.name && result.length <= 1 && result.every((c) => typeof c !== "string" && !!c.ref);\n    if (removeSelf)\n      return result;\n    node2.children = result;\n    return [node2];\n  };\n  normalizeChildren(node);\n}\nfunction normalizeStringChildren(rootA11yNode) {\n  const flushChildren = (buffer, normalizedChildren) => {\n    if (!buffer.length)\n      return;\n    const text = normalizeWhiteSpace(buffer.join(""));\n    if (text)\n      normalizedChildren.push(text);\n    buffer.length = 0;\n  };\n  const visit = (ariaNode) => {\n    const normalizedChildren = [];\n    const buffer = [];\n    for (const child of ariaNode.children || []) {\n      if (typeof child === "string") {\n        buffer.push(child);\n      } else {\n        flushChildren(buffer, normalizedChildren);\n        visit(child);\n        normalizedChildren.push(child);\n      }\n    }\n    flushChildren(buffer, normalizedChildren);\n    ariaNode.children = normalizedChildren.length ? normalizedChildren : [];\n    if (ariaNode.children.length === 1 && ariaNode.children[0] === ariaNode.name)\n      ariaNode.children = [];\n  };\n  visit(rootA11yNode);\n}\nfunction matchesStringOrRegex(text, template) {\n  if (!template)\n    return true;\n  if (!text)\n    return false;\n  if (typeof template === "string")\n    return text === template;\n  return !!text.match(new RegExp(template.pattern));\n}\nfunction matchesTextValue(text, template) {\n  if (!(template == null ? void 0 : template.normalized))\n    return true;\n  if (!text)\n    return false;\n  if (text === template.normalized)\n    return true;\n  if (text === template.raw)\n    return true;\n  const regex = cachedRegex(template);\n  if (regex)\n    return !!text.match(regex);\n  return false;\n}\nvar cachedRegexSymbol = Symbol("cachedRegex");\nfunction cachedRegex(template) {\n  if (template[cachedRegexSymbol] !== void 0)\n    return template[cachedRegexSymbol];\n  const { raw } = template;\n  const canBeRegex = raw.startsWith("/") && raw.endsWith("/") && raw.length > 1;\n  let regex;\n  try {\n    regex = canBeRegex ? new RegExp(raw.slice(1, -1)) : null;\n  } catch (e) {\n    regex = null;\n  }\n  template[cachedRegexSymbol] = regex;\n  return regex;\n}\nfunction matchesExpectAriaTemplate(rootElement, template) {\n  const snapshot = generateAriaTree(rootElement, { mode: "expect" });\n  const matches = matchesNodeDeep(snapshot.root, template, false, false);\n  return {\n    matches,\n    received: {\n      raw: renderAriaTree(snapshot, { mode: "expect" }),\n      regex: renderAriaTree(snapshot, { mode: "codegen" })\n    }\n  };\n}\nfunction getAllElementsMatchingExpectAriaTemplate(rootElement, template) {\n  const root = generateAriaTree(rootElement, { mode: "expect" }).root;\n  const matches = matchesNodeDeep(root, template, true, false);\n  return matches.map((n) => n.element);\n}\nfunction matchesNode(node, template, isDeepEqual) {\n  var _a;\n  if (typeof node === "string" && template.kind === "text")\n    return matchesTextValue(node, template.text);\n  if (node === null || typeof node !== "object" || template.kind !== "role")\n    return false;\n  if (template.role !== "fragment" && template.role !== node.role)\n    return false;\n  if (template.checked !== void 0 && template.checked !== node.checked)\n    return false;\n  if (template.disabled !== void 0 && template.disabled !== node.disabled)\n    return false;\n  if (template.expanded !== void 0 && template.expanded !== node.expanded)\n    return false;\n  if (template.level !== void 0 && template.level !== node.level)\n    return false;\n  if (template.pressed !== void 0 && template.pressed !== node.pressed)\n    return false;\n  if (template.selected !== void 0 && template.selected !== node.selected)\n    return false;\n  if (!matchesStringOrRegex(node.name, template.name))\n    return false;\n  if (!matchesTextValue(node.props.url, (_a = template.props) == null ? void 0 : _a.url))\n    return false;\n  if (template.containerMode === "contain")\n    return containsList(node.children || [], template.children || []);\n  if (template.containerMode === "equal")\n    return listEqual(node.children || [], template.children || [], false);\n  if (template.containerMode === "deep-equal" || isDeepEqual)\n    return listEqual(node.children || [], template.children || [], true);\n  return containsList(node.children || [], template.children || []);\n}\nfunction listEqual(children, template, isDeepEqual) {\n  if (template.length !== children.length)\n    return false;\n  for (let i = 0; i < template.length; ++i) {\n    if (!matchesNode(children[i], template[i], isDeepEqual))\n      return false;\n  }\n  return true;\n}\nfunction containsList(children, template) {\n  if (template.length > children.length)\n    return false;\n  const cc = children.slice();\n  const tt = template.slice();\n  for (const t of tt) {\n    let c = cc.shift();\n    while (c) {\n      if (matchesNode(c, t, false))\n        break;\n      c = cc.shift();\n    }\n    if (!c)\n      return false;\n  }\n  return true;\n}\nfunction matchesNodeDeep(root, template, collectAll, isDeepEqual) {\n  const results = [];\n  const visit = (node, parent) => {\n    if (matchesNode(node, template, isDeepEqual)) {\n      const result = typeof node === "string" ? parent : node;\n      if (result)\n        results.push(result);\n      return !collectAll;\n    }\n    if (typeof node === "string")\n      return false;\n    for (const child of node.children || []) {\n      if (visit(child, node))\n        return true;\n    }\n    return false;\n  };\n  visit(root, null);\n  return results;\n}\nfunction renderAriaTree(ariaSnapshot, publicOptions) {\n  const options = toInternalOptions(publicOptions);\n  const lines = [];\n  const includeText = options.renderStringsAsRegex ? textContributesInfo : () => true;\n  const renderString = options.renderStringsAsRegex ? convertToBestGuessRegex : (str) => str;\n  const visit = (ariaNode2, parentAriaNode, indent, renderCursorPointer) => {\n    if (typeof ariaNode2 === "string") {\n      if (parentAriaNode && !includeText(parentAriaNode, ariaNode2))\n        return;\n      const text = yamlEscapeValueIfNeeded(renderString(ariaNode2));\n      if (text)\n        lines.push(indent + "- text: " + text);\n      return;\n    }\n    let key = ariaNode2.role;\n    if (ariaNode2.name && ariaNode2.name.length <= 900) {\n      const name = renderString(ariaNode2.name);\n      if (name) {\n        const stringifiedName = name.startsWith("/") && name.endsWith("/") ? name : JSON.stringify(name);\n        key += " " + stringifiedName;\n      }\n    }\n    if (ariaNode2.checked === "mixed")\n      key += ` [checked=mixed]`;\n    if (ariaNode2.checked === true)\n      key += ` [checked]`;\n    if (ariaNode2.disabled)\n      key += ` [disabled]`;\n    if (ariaNode2.expanded)\n      key += ` [expanded]`;\n    if (ariaNode2.active && options.renderActive)\n      key += ` [active]`;\n    if (ariaNode2.level)\n      key += ` [level=${ariaNode2.level}]`;\n    if (ariaNode2.pressed === "mixed")\n      key += ` [pressed=mixed]`;\n    if (ariaNode2.pressed === true)\n      key += ` [pressed]`;\n    if (ariaNode2.selected === true)\n      key += ` [selected]`;\n    let inCursorPointer = false;\n    if (ariaNode2.ref) {\n      key += ` [ref=${ariaNode2.ref}]`;\n      if (renderCursorPointer && hasPointerCursor(ariaNode2)) {\n        inCursorPointer = true;\n        key += " [cursor=pointer]";\n      }\n    }\n    const escapedKey = indent + "- " + yamlEscapeKeyIfNeeded(key);\n    const hasProps = !!Object.keys(ariaNode2.props).length;\n    if (!ariaNode2.children.length && !hasProps) {\n      lines.push(escapedKey);\n    } else if (ariaNode2.children.length === 1 && typeof ariaNode2.children[0] === "string" && !hasProps) {\n      const text = includeText(ariaNode2, ariaNode2.children[0]) ? renderString(ariaNode2.children[0]) : null;\n      if (text)\n        lines.push(escapedKey + ": " + yamlEscapeValueIfNeeded(text));\n      else\n        lines.push(escapedKey);\n    } else {\n      lines.push(escapedKey + ":");\n      for (const [name, value] of Object.entries(ariaNode2.props))\n        lines.push(indent + "  - /" + name + ": " + yamlEscapeValueIfNeeded(value));\n      for (const child of ariaNode2.children || [])\n        visit(child, ariaNode2, indent + "  ", renderCursorPointer && !inCursorPointer);\n    }\n  };\n  const ariaNode = ariaSnapshot.root;\n  if (ariaNode.role === "fragment") {\n    for (const child of ariaNode.children || [])\n      visit(child, ariaNode, "", !!options.renderCursorPointer);\n  } else {\n    visit(ariaNode, null, "", !!options.renderCursorPointer);\n  }\n  return lines.join("\\n");\n}\nfunction convertToBestGuessRegex(text) {\n  const dynamicContent = [\n    // 2mb\n    { regex: /\\b[\\d,.]+[bkmBKM]+\\b/, replacement: "[\\\\d,.]+[bkmBKM]+" },\n    // 2ms, 20s\n    { regex: /\\b\\d+[hmsp]+\\b/, replacement: "\\\\d+[hmsp]+" },\n    { regex: /\\b[\\d,.]+[hmsp]+\\b/, replacement: "[\\\\d,.]+[hmsp]+" },\n    // Do not replace single digits with regex by default.\n    // 2+ digits: [Issue 22, 22.3, 2.33, 2,333]\n    { regex: /\\b\\d+,\\d+\\b/, replacement: "\\\\d+,\\\\d+" },\n    { regex: /\\b\\d+\\.\\d{2,}\\b/, replacement: "\\\\d+\\\\.\\\\d+" },\n    { regex: /\\b\\d{2,}\\.\\d+\\b/, replacement: "\\\\d+\\\\.\\\\d+" },\n    { regex: /\\b\\d{2,}\\b/, replacement: "\\\\d+" }\n  ];\n  let pattern = "";\n  let lastIndex = 0;\n  const combinedRegex = new RegExp(dynamicContent.map((r) => "(" + r.regex.source + ")").join("|"), "g");\n  text.replace(combinedRegex, (match, ...args) => {\n    const offset = args[args.length - 2];\n    const groups = args.slice(0, -2);\n    pattern += escapeRegExp(text.slice(lastIndex, offset));\n    for (let i = 0; i < groups.length; i++) {\n      if (groups[i]) {\n        const { replacement } = dynamicContent[i];\n        pattern += replacement;\n        break;\n      }\n    }\n    lastIndex = offset + match.length;\n    return match;\n  });\n  if (!pattern)\n    return text;\n  pattern += escapeRegExp(text.slice(lastIndex));\n  return String(new RegExp(pattern));\n}\nfunction textContributesInfo(node, text) {\n  if (!text.length)\n    return false;\n  if (!node.name)\n    return true;\n  if (node.name.length > text.length)\n    return false;\n  const substr = text.length <= 200 && node.name.length <= 200 ? longestCommonSubstring(text, node.name) : "";\n  let filtered = text;\n  while (substr && filtered.includes(substr))\n    filtered = filtered.replace(substr, "");\n  return filtered.trim().length / text.length > 0.1;\n}\nfunction hasPointerCursor(ariaNode) {\n  var _a;\n  return ((_a = ariaNode.box.style) == null ? void 0 : _a.cursor) === "pointer";\n}\n\n// packages/injected/src/highlight.css?inline\nvar highlight_default = ":host{font-size:13px;font-family:system-ui,Ubuntu,Droid Sans,sans-serif;color:#333}svg{position:absolute;height:0}x-pw-tooltip{backdrop-filter:blur(5px);background-color:#fff;border-radius:6px;box-shadow:0 .5rem 1.2rem #0000004d;display:none;font-size:12.8px;font-weight:400;left:0;line-height:1.5;max-width:600px;position:absolute;top:0;padding:0;flex-direction:column;overflow:hidden}x-pw-tooltip-line{display:flex;max-width:600px;padding:6px;user-select:none;cursor:pointer}x-pw-tooltip-footer{display:flex;max-width:600px;padding:6px;user-select:none;color:#777}x-pw-dialog{background-color:#fff;pointer-events:auto;border-radius:6px;box-shadow:0 .5rem 1.2rem #0000004d;display:flex;flex-direction:column;position:absolute;z-index:10;font-size:13px}x-pw-dialog:not(.autosize){width:400px;height:150px}x-pw-dialog-body{display:flex;flex-direction:column;flex:auto}x-pw-dialog-body label{margin:5px 8px;display:flex;flex-direction:row;align-items:center}x-pw-highlight{position:absolute;top:0;left:0;width:0;height:0}x-pw-action-point{position:absolute;width:20px;height:20px;background:red;border-radius:10px;margin:-10px 0 0 -10px;z-index:2}x-pw-separator{height:1px;margin:6px 9px;background:#949494e5}x-pw-tool-gripper{height:28px;width:24px;margin:2px 0;cursor:grab}x-pw-tool-gripper:active{cursor:grabbing}x-pw-tool-gripper>x-div{width:16px;height:16px;margin:6px 4px;clip-path:url(#icon-gripper);background-color:#555}x-pw-tools-list>label{display:flex;align-items:center;margin:0 10px;user-select:none}x-pw-tools-list{display:flex;width:100%;border-bottom:1px solid #dddddd}x-pw-tool-item{pointer-events:auto;height:28px;width:28px;border-radius:3px}x-pw-tool-item:not(.disabled){cursor:pointer}x-pw-tool-item:not(.disabled):hover{background-color:#dbdbdb}x-pw-tool-item.toggled{background-color:#8acae480}x-pw-tool-item.toggled:not(.disabled):hover{background-color:#8acae4c4}x-pw-tool-item>x-div{width:16px;height:16px;margin:6px;background-color:#3a3a3a}x-pw-tool-item.disabled>x-div{background-color:#61616180;cursor:default}x-pw-tool-item.record.toggled{background-color:transparent}x-pw-tool-item.record.toggled:not(.disabled):hover{background-color:#dbdbdb}x-pw-tool-item.record.toggled>x-div{background-color:#a1260d}x-pw-tool-item.record.disabled.toggled>x-div{opacity:.8}x-pw-tool-item.accept>x-div{background-color:#388a34}x-pw-tool-item.record>x-div{clip-path:url(#icon-circle-large-filled)}x-pw-tool-item.record.toggled>x-div{clip-path:url(#icon-stop-circle)}x-pw-tool-item.pick-locator>x-div{clip-path:url(#icon-inspect)}x-pw-tool-item.text>x-div{clip-path:url(#icon-whole-word)}x-pw-tool-item.visibility>x-div{clip-path:url(#icon-eye)}x-pw-tool-item.value>x-div{clip-path:url(#icon-symbol-constant)}x-pw-tool-item.snapshot>x-div{clip-path:url(#icon-gist)}x-pw-tool-item