"use strict";
exports.id = 9786;
exports.ids = [9786];
exports.modules = {

/***/ "../hooks-exec/dist/index.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  WL: () => (/* reexport */ CliHooksExecutor),
  gY: () => (/* reexport */ HooksConfigLoader),
  ae: () => (/* reexport */ ListableHooksResourceAccessor),
  IF: () => (/* reexport */ NodeFileReader),
  HG: () => (/* reexport */ StaticHooksConfigLease)
});

// UNUSED EXPORTS: HooksResourceAccessor, NoopHooksConfigLease, ShellExecutorWithHooks, ShellStreamExecutorWithHooks, WriteExecutorWithHooks

// EXTERNAL MODULE: ../context/dist/index.js + 4 modules
var dist = __webpack_require__("../context/dist/index.js");
;// ../hooks/dist/validators/base.js
// Base validator utilities and types
// Basic type validators
const isString = (value) => typeof value === "string";
const isObject = (value) => value !== null && typeof value === "object" && !Array.isArray(value);
// Utility function to create validation results
const createValidationResult = (isValid, errors = []) => ({
    isValid,
    errors,
});

;// ../hooks/dist/validators/baseHookResponse.js

const validateBaseHookResponse = (value) => {
    const errors = [];
    if (!isObject(value)) {
        errors.push("Expected an object");
        return createValidationResult(false, errors);
    }
    return createValidationResult(true);
};

;// ../hooks/dist/validators/afterAgentResponseResponse.js

const validateAfterAgentResponseResponse = (value) => {
    // First validate base response
    const baseValidation = validateBaseHookResponse(value);
    if (!baseValidation.isValid) {
        return baseValidation;
    }
    // No additional fields for now
    return baseValidation;
};

;// ../hooks/dist/validators/afterAgentThoughtResponse.js

const validateAfterAgentThoughtResponse = (value) => {
    const baseValidation = validateBaseHookResponse(value);
    if (!baseValidation.isValid) {
        return baseValidation;
    }
    return baseValidation;
};

;// ../hooks/dist/validators/afterEditFileResponse.js

const validateAfterEditFileResponse = (value) => {
    // First validate base response
    const baseValidation = validateBaseHookResponse(value);
    if (!baseValidation.isValid) {
        return baseValidation;
    }
    // AfterEditFileResponse currently has no additional fields beyond BaseHookResponse
    // This validator can be extended in the future if additional fields are added
    return baseValidation;
};

;// ../hooks/dist/validators/afterMCPExecutionResponse.js

const validateAfterMCPExecutionResponse = (value) => {
    const base = validateBaseHookResponse(value);
    if (!base.isValid) {
        return base;
    }
    return base;
};

;// ../hooks/dist/validators/afterShellExecutionResponse.js

const validateAfterShellExecutionResponse = (value) => {
    const base = validateBaseHookResponse(value);
    if (!base.isValid) {
        return base;
    }
    return base;
};

;// ../hooks/dist/validators/afterTabFileEditResponse.js

const validateAfterTabFileEditResponse = (value) => {
    return validateBaseHookResponse(value);
};

;// ../hooks/dist/validators/beforeCommandExecutionHookResponse.js


const validateBeforeCommandExecutionHookResponse = (value) => {
    const errors = [];
    // First validate base response
    const baseValidation = validateBaseHookResponse(value);
    if (!baseValidation.isValid) {
        return baseValidation;
    }
    // Validate permission field
    if (value.permission !== undefined) {
        const validPermissions = ["allow", "deny", "ask"];
        if (!validPermissions.includes(value.permission)) {
            errors.push(`Invalid permission value. Expected one of: ${validPermissions.join(", ")}, or undefined`);
        }
    }
    // Validate optional reason fields (snake_case)
    if (value.user_message !== undefined &&
        typeof value.user_message !== "string") {
        errors.push("Invalid user_message value. Expected a string if provided");
    }
    if (value.agent_message !== undefined &&
        typeof value.agent_message !== "string") {
        errors.push("Invalid agent_message value. Expected a string if provided");
    }
    return createValidationResult(errors.length === 0, errors);
};

;// ../hooks/dist/validators/beforePromptSubmitResponse.js


const validateBeforePromptSubmitResponse = (value) => {
    // First validate base response
    const baseValidation = validateBaseHookResponse(value);
    if (!baseValidation.isValid) {
        return baseValidation;
    }
    const errors = [];
    // Validate continue field if present
    if (value.continue !== undefined && typeof value.continue !== "boolean") {
        errors.push("continue must be a boolean if provided");
    }
    // Validate user_message field if present
    if (value.user_message !== undefined &&
        typeof value.user_message !== "string") {
        errors.push("user_message must be a string if provided");
    }
    return createValidationResult(errors.length === 0, errors);
};

;// ../hooks/dist/validators/beforeReadFileResponse.js


const validateBeforeReadFileResponse = (value) => {
    const errors = [];
    // First validate base response
    const baseValidation = validateBaseHookResponse(value);
    if (!baseValidation.isValid) {
        return baseValidation;
    }
    // Validate permission field
    if (value.permission !== undefined) {
        const validPermissions = ["allow", "deny"];
        if (!validPermissions.includes(value.permission)) {
            errors.push(`Invalid permission value. Expected one of: ${validPermissions.join(", ")}, or undefined`);
        }
    }
    return createValidationResult(errors.length === 0, errors);
};

;// ../hooks/dist/validators/beforeTabFileReadResponse.js


const validateBeforeTabFileReadResponse = (value) => {
    const errors = [];
    // First validate base response
    const baseValidation = validateBaseHookResponse(value);
    if (!baseValidation.isValid) {
        return baseValidation;
    }
    // Validate permission field
    if (value.permission !== undefined) {
        const validPermissions = ["allow", "deny"];
        if (!validPermissions.includes(value.permission)) {
            errors.push(`Invalid permission value. Expected one of: ${validPermissions.join(", ")}, or undefined`);
        }
    }
    return createValidationResult(errors.length === 0, errors);
};

;// ../hooks/dist/validators/stopResponse.js


const validateStopResponse = (value) => {
    // First validate base response
    const baseValidation = validateBaseHookResponse(value);
    if (!baseValidation.isValid) {
        return baseValidation;
    }
    const errors = [];
    // Validate optional followup_message
    if (value.followup_message !== undefined &&
        typeof value.followup_message !== "string") {
        errors.push("followup_message must be a string if provided");
    }
    return createValidationResult(errors.length === 0, errors);
};

;// ../hooks/dist/types.js











const HookStep = {
    beforeShellExecution: "beforeShellExecution",
    beforeMCPExecution: "beforeMCPExecution",
    afterShellExecution: "afterShellExecution",
    afterMCPExecution: "afterMCPExecution",
    beforeReadFile: "beforeReadFile",
    afterFileEdit: "afterFileEdit",
    beforeTabFileRead: "beforeTabFileRead",
    afterTabFileEdit: "afterTabFileEdit",
    stop: "stop",
    beforeSubmitPrompt: "beforeSubmitPrompt",
    afterAgentResponse: "afterAgentResponse",
    afterAgentThought: "afterAgentThought",
};
/**
 * Map hook step to response validator
 */
const HookResponseValidatorMap = {
    [HookStep.beforeShellExecution]: validateBeforeCommandExecutionHookResponse,
    [HookStep.beforeMCPExecution]: validateBeforeCommandExecutionHookResponse,
    [HookStep.afterShellExecution]: validateAfterShellExecutionResponse,
    [HookStep.afterMCPExecution]: validateAfterMCPExecutionResponse,
    [HookStep.beforeReadFile]: validateBeforeReadFileResponse,
    [HookStep.afterFileEdit]: validateAfterEditFileResponse,
    [HookStep.beforeTabFileRead]: validateBeforeTabFileReadResponse,
    [HookStep.afterTabFileEdit]: validateAfterTabFileEditResponse,
    [HookStep.beforeSubmitPrompt]: validateBeforePromptSubmitResponse,
    [HookStep.stop]: validateStopResponse,
    [HookStep.afterAgentResponse]: validateAfterAgentResponseResponse,
    [HookStep.afterAgentThought]: validateAfterAgentThoughtResponse,
};
/**
 * Validate and parse hook response
 */
const validateAndParseHookResponse = (hookStep, response) => {
    const validator = HookResponseValidatorMap[hookStep];
    const validation = validator(response);
    if (validation.isValid) {
        return { success: true, data: response };
    }
    else {
        return { success: false, errors: validation.errors };
    }
};

;// ../hooks/dist/validators/hooksConfig.js


const validateHookScript = (value) => {
    const errors = [];
    if (!isObject(value)) {
        errors.push("Hook script must be an object with a command property");
        return createValidationResult(false, errors);
    }
    // Validate HookScript object
    if (!isString(value.command)) {
        errors.push("Hook script command must be a string");
    }
    return createValidationResult(errors.length === 0, errors);
};
const validateHookScriptArray = (value, hookName) => {
    const errors = [];
    if (!Array.isArray(value)) {
        errors.push(`${hookName} must be an array of hook scripts`);
        return createValidationResult(false, errors);
    }
    for (let i = 0; i < value.length; i++) {
        const scriptValidation = validateHookScript(value[i]);
        if (!scriptValidation.isValid) {
            errors.push(`${hookName}[${i}]: ${scriptValidation.errors.join(", ")}`);
        }
    }
    return createValidationResult(errors.length === 0, errors);
};
const validateHooksConfig = (value) => {
    const errors = [];
    if (!isObject(value)) {
        errors.push("Hooks config must be an object");
        return createValidationResult(false, errors);
    }
    // Validate version field
    if (typeof value.version !== "number") {
        errors.push("Config version must be a number");
    }
    else if (!Number.isInteger(value.version) || value.version < 1) {
        errors.push("Config version must be a positive integer");
    }
    // Validate hooks field
    if (!isObject(value.hooks)) {
        errors.push("Config hooks must be an object");
        return createValidationResult(false, errors);
    }
    // Validate each hook type - automatically derived from HookStep to ensure they stay in sync
    const validHookTypes = Object.values(HookStep);
    const hooks = value.hooks;
    for (const [hookName, hookValue] of Object.entries(hooks)) {
        if (!validHookTypes.includes(hookName)) {
            errors.push(`Unknown hook type: ${hookName}. Valid types are: ${validHookTypes.join(", ")}`);
            continue;
        }
        if (hookValue !== undefined) {
            const arrayValidation = validateHookScriptArray(hookValue, hookName);
            if (!arrayValidation.isValid) {
                errors.push(...arrayValidation.errors);
            }
        }
    }
    return createValidationResult(errors.length === 0, errors);
};

;// ../hooks/dist/index.js



;// ../hooks-exec/dist/cli-hooks-executor.js
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __asyncValues = (undefined && undefined.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};


/**
 * CLI implementation of HookExecutor that executes shell scripts.
 *
 * This executor:
 * - Loads hooks configuration from multiple sources (user, project, enterprise)
 * - Executes hook scripts using TerminalExecutor
 * - Passes request data via stdin as JSON
 * - Parses and validates hook responses
 * - Handles timeouts and errors
 */
class CliHooksExecutor {
    constructor(config, workspacePath, globalContext, shellExecutor) {
        this.config = config;
        this.workspacePath = workspacePath;
        this.globalContext = globalContext;
        this.shellExecutor = shellExecutor;
    }
    executeHookForStep(step, request) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            // Add global context fields to the request
            const fullRequest = Object.assign(Object.assign({}, request), { hook_event_name: step, cursor_version: this.globalContext.cursor_version, workspace_roots: [this.workspacePath], user_email: this.globalContext.user_email });
            // If we've run a stop loop 5 times, don't allow it to loop anymore
            if (step === "stop") {
                const stopReq = fullRequest;
                const loopCount = stopReq.loop_count;
                if (typeof loopCount === "number" && loopCount >= 5) {
                    return {};
                }
            }
            // Collect scripts from all configs with their source context
            // Priority order: project > user
            const scriptsToExecute = [];
            // Add project scripts (highest priority)
            if ((_a = this.config.projectHooks) === null || _a === void 0 ? void 0 : _a.hooks[step]) {
                const projectScripts = this.config.projectHooks.hooks[step];
                if (projectScripts) {
                    for (const script of projectScripts) {
                        // Project hooks run in the workspace root
                        scriptsToExecute.push({
                            script,
                            cwd: this.workspacePath,
                            source: "project",
                        });
                    }
                }
            }
            // Add user scripts (lowest priority)
            if ((_b = this.config.userHooks) === null || _b === void 0 ? void 0 : _b.hooks[step]) {
                const userScripts = this.config.userHooks.hooks[step];
                if (userScripts) {
                    for (const script of userScripts) {
                        // User hooks run in the workspace directory
                        scriptsToExecute.push({
                            script,
                            cwd: this.workspacePath,
                            source: "user",
                        });
                    }
                }
            }
            if (scriptsToExecute.length === 0) {
                return undefined;
            }
            // Execute scripts in order until one returns a valid response
            for (let i = 0; i < scriptsToExecute.length; i++) {
                const { script, cwd, source } = scriptsToExecute[i];
                try {
                    const result = yield this.executeScript({
                        script,
                        cwd,
                        request: fullRequest,
                    });
                    // Parse the response
                    const trimmedStdout = result.stdout.trim();
                    if (!trimmedStdout) {
                        // No output, continue to next script
                        continue;
                    }
                    try {
                        const rawResponse = JSON.parse(trimmedStdout);
                        // Validate the response using the validator
                        const validationResult = validateAndParseHookResponse(step, rawResponse);
                        if (validationResult.success) {
                            return validationResult.data;
                        }
                        else {
                            // Validation failed, continue to next script
                            console.error(`[hooks] Response validation failed for ${source} hook ${i + 1}:`, validationResult.errors);
                        }
                    }
                    catch (parseError) {
                        // JSON parse error, continue to next script
                        console.error(`[hooks] Failed to parse JSON response from ${source} hook ${i + 1}:`, parseError);
                    }
                }
                catch (error) {
                    // Script execution error, continue to next script
                    console.error(`[hooks] Failed to execute ${source} hook ${i + 1}:`, error);
                }
            }
            // No valid response from any script
            return undefined;
        });
    }
    /**
     * Execute a single hook script.
     */
    executeScript(options) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a, e_1, _b, _c;
            const { script, cwd, request, timeout = 30000 } = options;
            const startTime = Date.now();
            const jsonPayload = JSON.stringify(request);
            // Create an AbortController for timeout
            const abortController = new AbortController();
            const timeoutHandle = setTimeout(() => {
                abortController.abort();
            }, timeout);
            try {
                // Build a command that pipes JSON to the hook script
                // Use a heredoc to avoid any escaping issues
                const isWindows = "darwin" === "win32";
                let command;
                if (isWindows) {
                    // On Windows with PowerShell, use a here-string
                    // Escape single quotes in the JSON by doubling them
                    const escapedJson = jsonPayload.replace(/'/g, "''");
                    command = `@'\n${escapedJson}\n'@ | ${script.command}`;
                }
                else {
                    // On Unix, use a heredoc
                    command = `${script.command} <<'CURSOR_HOOK_EOF'\n${jsonPayload}\nCURSOR_HOOK_EOF`;
                }
                // Execute the command using the shell executor
                const ctx = (0,dist/* createContext */.q6)();
                let stdout = "";
                let stderr = "";
                let exitCode = null;
                try {
                    for (var _d = true, _e = __asyncValues(this.shellExecutor.execute(ctx, command, {
                        workingDirectory: cwd,
                        signal: abortController.signal,
                        sandboxPolicy: { type: "insecure_none" },
                    })), _f; _f = yield _e.next(), _a = _f.done, !_a; _d = true) {
                        _c = _f.value;
                        _d = false;
                        const event = _c;
                        switch (event.type) {
                            case "stdout":
                                stdout += event.data;
                                break;
                            case "stderr":
                                stderr += event.data;
                                break;
                            case "exit":
                                exitCode = event.code;
                                break;
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (!_d && !_a && (_b = _e.return)) yield _b.call(_e);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                clearTimeout(timeoutHandle);
                const duration = Date.now() - startTime;
                return {
                    stdout,
                    stderr,
                    exitCode,
                    duration,
                };
            }
            catch (error) {
                clearTimeout(timeoutHandle);
                const _duration = Date.now() - startTime;
                if (abortController.signal.aborted) {
                    throw new Error(`Hook script timed out after ${timeout}ms`);
                }
                throw error;
            }
        });
    }
}

;// ../hooks-exec/dist/config-loader.js
var config_loader_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class HooksConfigLoader {
    constructor(fileReader, paths) {
        this.fileReader = fileReader;
        this.paths = paths;
    }
    load() {
        return config_loader_awaiter(this, arguments, void 0, function* (options = {}) {
            const { loadProjectHooks = true } = options;
            const result = {
                errors: [],
            };
            if (this.paths.userConfigPath) {
                try {
                    const exists = yield this.fileReader.exists(this.paths.userConfigPath);
                    if (exists) {
                        const content = yield this.fileReader.readFile(this.paths.userConfigPath);
                        if (content) {
                            const { config, error } = this.parseAndValidate(content, "user");
                            if (config) {
                                result.userHooks = config;
                            }
                            else if (error) {
                                result.errors.push({
                                    source: "user",
                                    message: `User hooks.json at ${this.paths.userConfigPath}: ${error}`,
                                });
                            }
                        }
                    }
                }
                catch (error) {
                    result.errors.push({
                        source: "user",
                        message: `Error accessing user config file: ${String(error)}`,
                    });
                }
            }
            if (loadProjectHooks && this.paths.projectConfigPath) {
                try {
                    const exists = yield this.fileReader.exists(this.paths.projectConfigPath);
                    if (exists) {
                        const content = yield this.fileReader.readFile(this.paths.projectConfigPath);
                        if (content) {
                            const { config, error } = this.parseAndValidate(content, "project");
                            if (config) {
                                result.projectHooks = config;
                            }
                            else if (error) {
                                result.errors.push({
                                    source: "project",
                                    message: `Project hooks.json at ${this.paths.projectConfigPath}: ${error}`,
                                });
                            }
                        }
                    }
                }
                catch (error) {
                    result.errors.push({
                        source: "project",
                        message: `Error accessing project config file: ${String(error)}`,
                    });
                }
            }
            return result;
        });
    }
    parseAndValidate(configText, source) {
        try {
            const config = this.parseJSONC(configText);
            const validation = validateHooksConfig(config);
            if (!validation.isValid) {
                const message = `Invalid ${source} config: ${validation.errors.join("; ")}`;
                return { error: message };
            }
            const hasHooks = !!(config === null || config === void 0 ? void 0 : config.hooks);
            if (!hasHooks) {
                const message = `Invalid ${source} config: missing 'hooks' property`;
                return { error: message };
            }
            return { config: config };
        }
        catch (parseError) {
            const message = `Failed to parse ${source} config JSON: ${String(parseError)}`;
            return { error: message };
        }
    }
    parseJSONC(text) {
        const singleLineCommentRegex = /\/\/.*$/gm;
        let cleaned = text.replace(singleLineCommentRegex, "");
        const multiLineCommentRegex = /\/\*[\s\S]*?\*\//g;
        cleaned = cleaned.replace(multiLineCommentRegex, "");
        return JSON.parse(cleaned);
    }
    static getConfiguredSteps(config) {
        var _a, _b;
        const steps = new Set();
        if ((_a = config.projectHooks) === null || _a === void 0 ? void 0 : _a.hooks) {
            for (const step of Object.keys(config.projectHooks.hooks)) {
                steps.add(step);
            }
        }
        if ((_b = config.userHooks) === null || _b === void 0 ? void 0 : _b.hooks) {
            for (const step of Object.keys(config.userHooks.hooks)) {
                steps.add(step);
            }
        }
        return steps;
    }
}

;// ../hooks-exec/dist/config-tracker.js

/**
 * Implementation of HooksConfigLease that provides access to a loaded configuration.
 */
class StaticHooksConfigLease {
    constructor(config) {
        this.config = config;
        this.configuredSteps = HooksConfigLoader.getConfiguredSteps(config);
    }
    getConfig() {
        return this.config;
    }
    hasHookForStep(step) {
        return this.configuredSteps.has(step);
    }
    getConfiguredSteps() {
        return new Set(this.configuredSteps);
    }
}
/**
 * No-op implementation of HooksConfigLease for when no hooks are configured.
 */
class NoopHooksConfigLease {
    getConfig() {
        return { errors: [] };
    }
    hasHookForStep(_step) {
        return false;
    }
    getConfiguredSteps() {
        return new Set();
    }
}

// EXTERNAL MODULE: external "node:fs/promises"
var promises_ = __webpack_require__("node:fs/promises");
;// ../hooks-exec/dist/node-file-reader.js
var node_file_reader_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

/**
 * Node.js implementation of FileReader using fs.promises.
 *
 * This implementation reads files from the local filesystem using Node.js APIs.
 */
class NodeFileReader {
    /**
     * Read a file and return its contents as a string.
     * Returns undefined if the file doesn't exist.
     */
    readFile(path) {
        return node_file_reader_awaiter(this, void 0, void 0, function* () {
            try {
                const content = yield promises_.readFile(path, "utf-8");
                return content;
            }
            catch (error) {
                // Return undefined if file doesn't exist
                if ((error === null || error === void 0 ? void 0 : error.code) === "ENOENT") {
                    return undefined;
                }
                // Re-throw other errors
                throw error;
            }
        });
    }
    /**
     * Check if a file exists at the given path.
     */
    exists(path) {
        return node_file_reader_awaiter(this, void 0, void 0, function* () {
            try {
                yield promises_.access(path);
                return true;
            }
            catch (_a) {
                return false;
            }
        });
    }
}

// EXTERNAL MODULE: ../agent-exec/dist/index.js + 17 modules
var agent_exec_dist = __webpack_require__("../agent-exec/dist/index.js");
// EXTERNAL MODULE: external "node:perf_hooks"
var external_node_perf_hooks_ = __webpack_require__("node:perf_hooks");
// EXTERNAL MODULE: ../proto/dist/generated/agent/v1/shell_exec_pb.js
var shell_exec_pb = __webpack_require__("../proto/dist/generated/agent/v1/shell_exec_pb.js");
;// ../hooks-exec/dist/shell.js
var shell_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const roundDurationMs = (value) => Math.round(value * 1000) / 1000;
/**
 * Wraps a ShellExecutor to apply hooks before and after shell command execution.
 */
class shell_ShellExecutorWithHooks {
    constructor(innerExecutor, hookExecutor, baseHookRequestExtractor) {
        this.innerExecutor = innerExecutor;
        this.hookExecutor = hookExecutor;
        this.baseHookRequestExtractor = baseHookRequestExtractor;
    }
    execute(ctx, args, options) {
        return shell_awaiter(this, void 0, void 0, function* () {
            // Execute beforeShellExecution hook
            const baseHookRequest = this.baseHookRequestExtractor(ctx);
            const beforeHookRequest = Object.assign(Object.assign({}, baseHookRequest), { command: args.command, cwd: args.workingDirectory || process.cwd() });
            const beforeHookResponse = yield this.hookExecutor.executeHookForStep(HookStep.beforeShellExecution, beforeHookRequest);
            // Check if the hook blocked execution
            if ((beforeHookResponse === null || beforeHookResponse === void 0 ? void 0 : beforeHookResponse.permission) === "deny") {
                // Return a rejected result
                return new shell_exec_pb/* ShellResult */.W4({
                    result: {
                        case: "rejected",
                        value: new shell_exec_pb/* ShellRejected */.pZ({
                            command: args.command,
                            workingDirectory: args.workingDirectory || process.cwd(),
                            reason: beforeHookResponse.user_message || "Command blocked by hook",
                        }),
                    },
                });
            }
            // Execute the actual command
            const executionStartTimeMs = external_node_perf_hooks_.performance.now();
            const result = yield this.innerExecutor.execute(ctx, args, options);
            const executionDurationMs = roundDurationMs(external_node_perf_hooks_.performance.now() - executionStartTimeMs);
            // Execute afterShellExecution hook
            let output = "";
            if (result.result.case === "success") {
                output = result.result.value.stdout + result.result.value.stderr;
            }
            else if (result.result.case === "failure") {
                output = result.result.value.stdout + result.result.value.stderr;
            }
            const afterHookRequest = Object.assign(Object.assign({}, baseHookRequest), { command: args.command, output, duration: executionDurationMs });
            yield this.hookExecutor.executeHookForStep(HookStep.afterShellExecution, afterHookRequest);
            return result;
        });
    }
}

;// ../hooks-exec/dist/shell-stream.js
var __await = (undefined && undefined.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var shell_stream_asyncValues = (undefined && undefined.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __asyncGenerator = (undefined && undefined.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};



const shell_stream_roundDurationMs = (value) => Math.round(value * 1000) / 1000;
/**
 * Wraps a ShellStreamExecutor to apply hooks before and after shell command execution.
 */
class shell_stream_ShellStreamExecutorWithHooks {
    constructor(innerExecutor, hookExecutor, baseHookRequestExtractor) {
        this.innerExecutor = innerExecutor;
        this.hookExecutor = hookExecutor;
        this.baseHookRequestExtractor = baseHookRequestExtractor;
    }
    execute(ctx, args, options) {
        return __asyncGenerator(this, arguments, function* execute_1() {
            var _a, e_1, _b, _c;
            // Execute beforeShellExecution hook
            const baseHookRequest = this.baseHookRequestExtractor(ctx);
            const beforeHookRequest = Object.assign(Object.assign({}, baseHookRequest), { command: args.command, cwd: args.workingDirectory || process.cwd() });
            const beforeHookResponse = yield __await(this.hookExecutor.executeHookForStep(HookStep.beforeShellExecution, beforeHookRequest));
            // Check if the hook blocked execution
            if ((beforeHookResponse === null || beforeHookResponse === void 0 ? void 0 : beforeHookResponse.permission) === "deny") {
                // Yield a rejected result
                yield yield __await(new shell_exec_pb/* ShellStream */.FI({
                    event: {
                        case: "rejected",
                        value: new shell_exec_pb/* ShellRejected */.pZ({
                            command: args.command,
                            workingDirectory: args.workingDirectory || process.cwd(),
                            reason: beforeHookResponse.user_message || "Command blocked by hook",
                        }),
                    },
                }));
                return yield __await(void 0);
            }
            // Execute the actual command and collect output
            const executionStartTimeMs = external_node_perf_hooks_.performance.now();
            let output = "";
            try {
                for (var _d = true, _e = shell_stream_asyncValues(this.innerExecutor.execute(ctx, args, options)), _f; _f = yield __await(_e.next()), _a = _f.done, !_a; _d = true) {
                    _c = _f.value;
                    _d = false;
                    const stream = _c;
                    // Collect output for the after hook
                    if (stream.event.case === "stdout") {
                        output += stream.event.value.data;
                    }
                    else if (stream.event.case === "stderr") {
                        output += stream.event.value.data;
                    }
                    yield yield __await(stream);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = _e.return)) yield __await(_b.call(_e));
                }
                finally { if (e_1) throw e_1.error; }
            }
            // Execute afterShellExecution hook
            const executionDurationMs = shell_stream_roundDurationMs(external_node_perf_hooks_.performance.now() - executionStartTimeMs);
            const afterHookRequest = Object.assign(Object.assign({}, baseHookRequest), { command: args.command, output, duration: executionDurationMs });
            yield __await(this.hookExecutor.executeHookForStep(HookStep.afterShellExecution, afterHookRequest));
        });
    }
}

// EXTERNAL MODULE: ../local-exec/dist/index.js + 53 modules
var local_exec_dist = __webpack_require__("../local-exec/dist/index.js");
// EXTERNAL MODULE: ../proto/dist/generated/agent/v1/write_exec_pb.js
var write_exec_pb = __webpack_require__("../proto/dist/generated/agent/v1/write_exec_pb.js");
;// ../hooks-exec/dist/write.js
var write_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



/**
 * Wraps a WriteExecutor to apply hooks after file write operations.
 */
class write_WriteExecutorWithHooks {
    constructor(innerExecutor, hookExecutor, baseHookRequestExtractor) {
        this.innerExecutor = innerExecutor;
        this.hookExecutor = hookExecutor;
        this.baseHookRequestExtractor = baseHookRequestExtractor;
    }
    execute(ctx, args, options) {
        return write_awaiter(this, void 0, void 0, function* () {
            // Execute the actual write operation
            const result = yield this.innerExecutor.execute(ctx, args, options);
            // Only execute afterFileEdit hook if the write was successful
            if (result.result.case === "success") {
                const baseHookRequest = this.baseHookRequestExtractor(ctx);
                const afterHookRequest = Object.assign(Object.assign({}, baseHookRequest), { file_path: args.path, edits: [
                        {
                            old_string: "", // For a full file write, we don't have the old string
                            new_string: args.fileText,
                        },
                    ] });
                const afterHookResponse = yield this.hookExecutor.executeHookForStep(HookStep.afterFileEdit, afterHookRequest);
                // After the hook executes, read the file again to get the updated content if requested
                // Hooks might have changed the file, so we need to return the current state
                if (args.returnFileContentAfterWrite && afterHookResponse !== undefined) {
                    const resolvedPath = result.result.value.path;
                    try {
                        const fileContentAfterHook = yield (0,local_exec_dist.readText)(resolvedPath);
                        const updatedLines = (0,local_exec_dist.countLines)(fileContentAfterHook);
                        const updatedSize = Buffer.byteLength(fileContentAfterHook, "utf8");
                        // Update the result with the new file content and metadata
                        return new write_exec_pb/* WriteResult */.v3({
                            result: {
                                case: "success",
                                value: new write_exec_pb/* WriteSuccess */.j6(Object.assign(Object.assign({}, result.result.value), { fileContentAfterWrite: fileContentAfterHook, linesCreated: updatedLines, fileSize: updatedSize })),
                            },
                        });
                    }
                    catch (_error) {
                        // If reading fails after the hook, return the original result
                        // This maintains the original behavior in case of errors
                        return result;
                    }
                }
            }
            return result;
        });
    }
}

;// ../hooks-exec/dist/resource-accessor.js




/**
 * A ResourceAccessor that wraps another ResourceAccessor and applies hooks
 * to shell, shellstream, and write operations.
 *
 * This acts as middleware, intercepting resource access and wrapping the
 * executors with hook-aware versions.
 */
class HooksResourceAccessor {
    constructor(innerAccessor, hookExecutor, baseHookRequestExtractor) {
        this.innerAccessor = innerAccessor;
        this.hookExecutor = hookExecutor;
        this.baseHookRequestExtractor = baseHookRequestExtractor;
    }
    get(resource) {
        const innerImpl = this.innerAccessor.get(resource);
        // Wrap shell executor with hooks
        if (resource.symbol === shellExecutorResource.symbol) {
            return new ShellExecutorWithHooks(innerImpl, this.hookExecutor, this.baseHookRequestExtractor);
        }
        // Wrap shell stream executor with hooks
        if (resource.symbol === shellStreamExecutorResource.symbol) {
            return new ShellStreamExecutorWithHooks(innerImpl, this.hookExecutor, this.baseHookRequestExtractor);
        }
        // Wrap write executor with hooks
        if (resource.symbol === writeExecutorResource.symbol) {
            return new WriteExecutorWithHooks(innerImpl, this.hookExecutor, this.baseHookRequestExtractor);
        }
        // For all other resources, return the inner implementation as-is
        return innerImpl;
    }
}
/**
 * A ListableResourceAccessor that wraps another ListableResourceAccessor and applies hooks
 * to shell, shellstream, and write operations.
 *
 * This acts as middleware, intercepting resource access and wrapping the
 * executors with hook-aware versions, while also providing the ability to
 * enumerate all resources.
 */
class ListableHooksResourceAccessor {
    constructor(innerAccessor, hookExecutor, baseHookRequestExtractor) {
        this.innerAccessor = innerAccessor;
        this.hookExecutor = hookExecutor;
        this.baseHookRequestExtractor = baseHookRequestExtractor;
    }
    get(resource) {
        const innerImpl = this.innerAccessor.get(resource);
        // Wrap shell executor with hooks
        if (resource.symbol === agent_exec_dist/* shellExecutorResource */.qk.symbol) {
            return new shell_ShellExecutorWithHooks(innerImpl, this.hookExecutor, this.baseHookRequestExtractor);
        }
        // Wrap shell stream executor with hooks
        if (resource.symbol === agent_exec_dist/* shellStreamExecutorResource */.wv.symbol) {
            return new shell_stream_ShellStreamExecutorWithHooks(innerImpl, this.hookExecutor, this.baseHookRequestExtractor);
        }
        // Wrap write executor with hooks
        if (resource.symbol === agent_exec_dist/* writeExecutorResource */.Ln.symbol) {
            return new write_WriteExecutorWithHooks(innerImpl, this.hookExecutor, this.baseHookRequestExtractor);
        }
        // For all other resources, return the inner implementation as-is
        return innerImpl;
    }
    *entries() {
        // Iterate through all entries from the inner accessor
        for (const [resource, implementation] of this.innerAccessor.entries()) {
            // Wrap the implementation if it's one of the hooked resources
            if (resource.symbol === agent_exec_dist/* shellExecutorResource */.qk.symbol) {
                yield [
                    resource,
                    new shell_ShellExecutorWithHooks(implementation, this.hookExecutor, this.baseHookRequestExtractor),
                ];
            }
            else if (resource.symbol === agent_exec_dist/* shellStreamExecutorResource */.wv.symbol) {
                yield [
                    resource,
                    new shell_stream_ShellStreamExecutorWithHooks(implementation, this.hookExecutor, this.baseHookRequestExtractor),
                ];
            }
            else if (resource.symbol === agent_exec_dist/* writeExecutorResource */.Ln.symbol) {
                yield [
                    resource,
                    new write_WriteExecutorWithHooks(implementation, this.hookExecutor, this.baseHookRequestExtractor),
                ];
            }
            else {
                // For all other resources, yield the inner implementation as-is
                yield [resource, implementation];
            }
        }
    }
}

;// ../hooks-exec/dist/index.js










/***/ })

};
;