"use strict";
exports.id = 769;
exports.ids = [769];
exports.modules = {

/***/ "./src/commands/login.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleLogin: () => (/* binding */ handleLogin)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../cursor-config/dist/index.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_proto_aiserver_v1_dashboard_pb_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../proto/dist/generated/aiserver/v1/dashboard_pb.js");
/* harmony import */ var _components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/login-ui.tsx");
/* harmony import */ var _privacy_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/privacy.ts");
/* harmony import */ var _utils_open_browser_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/utils/open-browser.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_2__, _components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_2__, _components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







function handleLogin(credentialManager, configProvider, dashboardClient) {
    return __awaiter(this, void 0, void 0, function* () {
        // Render the status component
        const { rerender } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_2__/* .render */ .XX)((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "starting" }));
        try {
            const loginManager = new _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_1__/* .LoginManager */ .Pl();
            const { metadata, loginUrl } = loginManager.startLogin();
            if ((0,_utils_open_browser_js__WEBPACK_IMPORTED_MODULE_6__/* .isLikelyToOpenBrowser */ .g)(loginUrl)) {
                rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "in-progress", message: `Waiting for browser authentication...\nIf your browser didn't open, use this link:\n${loginUrl}` }));
                try {
                    yield (0,_utils_open_browser_js__WEBPACK_IMPORTED_MODULE_6__/* .openBrowser */ .p)(loginUrl);
                }
                catch (_a) {
                    // ignore, likely in ssh session
                }
            }
            else {
                rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "in-progress", message: `Waiting for browser authentication...\nOpen a browser and navigate to this link: ${loginUrl}` }));
            }
            const authResult = yield loginManager.waitForResult(metadata);
            if (authResult === null || authResult === void 0 ? void 0 : authResult.accessToken) {
                try {
                    yield credentialManager.setAuthentication(authResult.accessToken, authResult.refreshToken);
                    // Reset privacy cache like we do in logout
                    yield configProvider.transform((c) => (Object.assign(Object.assign({}, c), { privacyCache: undefined })));
                    // Pre-emptively refresh privacy cache in background, does not block.
                    (0,_privacy_js__WEBPACK_IMPORTED_MODULE_5__/* .maybeRefreshPrivacyCacheInBackground */ .H)({
                        credentialManager,
                        baseUrl: "https://api2.cursor.sh", // fine since it doesn't write to cache on failure, and it will try with the correct endpoint next time they do something
                        configProvider,
                    });
                    // Check if user has @anysphere.co email and auto-configure staging channel
                    let userEmail;
                    let stagingChannelConfigured = false;
                    if (dashboardClient) {
                        try {
                            const response = yield dashboardClient.getMe(new _anysphere_proto_aiserver_v1_dashboard_pb_js__WEBPACK_IMPORTED_MODULE_3__/* .GetMeRequest */ .Ewt({}));
                            userEmail = response.email;
                            // Auto-configure staging channel for @anysphere.co users
                            // Opt-in devs on all channels except 'lab', 'static', and 'prod-stable-internal'
                            const currentChannel = configProvider.get().channel;
                            if ((userEmail === null || userEmail === void 0 ? void 0 : userEmail.endsWith("@anysphere.co")) &&
                                currentChannel !== "lab" &&
                                currentChannel !== "static" &&
                                currentChannel !== "prod-stable-internal") {
                                yield configProvider.transform((c) => (Object.assign(Object.assign({}, c), { channel: "staging" })));
                                stagingChannelConfigured = true;
                            }
                        }
                        catch (_b) {
                            // Ignore errors getting user info - don't block login success
                        }
                    }
                    rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "success", message: `Authentication tokens stored securely.${stagingChannelConfigured ? " cursor-agent automatically configured to use staging channel." : ""}`, userInfo: userEmail ? { email: userEmail } : undefined }));
                }
                catch (_c) {
                    const message = `Failed to store authentication tokens.\nAccess token: ${authResult.accessToken}`;
                    rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "error", message: message }));
                }
            }
            else {
                rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "error", message: "Login failed or timed out." }));
                process.exit(1);
            }
        }
        catch (error) {
            rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "error", message: `Login error: ${error}` }));
            process.exit(1);
        }
        process.exit(0);
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/login-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: () => (/* binding */ LogoutStatus),
/* harmony export */   a: () => (/* binding */ LoginStatus)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const LoginStatus = ({ status, message, userInfo, loginUrl }) => {
    const getStatusContent = () => {
        switch (status) {
            case "starting":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Starting login process..." }) }));
            case "in-progress":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", gap: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Authenticating with Cursor..." }) }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: message }), loginUrl && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", wrap: "no-wrap", children: loginUrl }))] }));
            case "success":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "green", children: "\u2713 " }), (userInfo === null || userInfo === void 0 ? void 0 : userInfo.email) ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: ["Logged in as ", userInfo.email] })) : (userInfo === null || userInfo === void 0 ? void 0 : userInfo.userId) ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: ["Logged in as user id ", userInfo.userId] })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Login successful!" }))] }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: message })] }));
            case "error":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: message }) }));
        }
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", padding: 1, children: getStatusContent() }));
};
const LogoutStatus = ({ status, message }) => {
    const getStatusContent = () => {
        switch (status) {
            case "starting":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Preparing to log out..." }) }));
            case "in-progress":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Logging out..." }) }));
            case "success":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "green", children: "\u2713 Logout successful" }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: message })] }));
            case "error":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: "\u2717 Logout failed" }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: message })] }));
        }
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", padding: 1, children: getStatusContent() }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/utils/open-browser.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   g: () => (/* binding */ isLikelyToOpenBrowser),
/* harmony export */   p: () => (/* binding */ openBrowser)
/* harmony export */ });
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:child_process");
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_child_process__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _anysphere_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../utils/dist/index.js");
/* harmony import */ var _terminal_theme_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/utils/terminal-theme.ts");



function isLikelyToOpenBrowser(url) {
    if (process.env.NO_OPEN_BROWSER) {
        return false;
    }
    const runningInSsh = (0,_terminal_theme_js__WEBPACK_IMPORTED_MODULE_2__/* .isLikelySshSession */ .lf)();
    if (runningInSsh) {
        return false;
    }
    // Validate that the URL is a web link (http:// or https://)
    if (!isValidWebUrl(url)) {
        return false;
    }
    try {
        getBrowserInvocation(url);
        return true;
    }
    catch (_a) {
        return false;
    }
}
function getBrowserInvocation(url) {
    const platform = "darwin";
    let file;
    let urlArgs;
    if (platform === "darwin") {
        file = "open";
        urlArgs = [url];
    }
    else if (platform === "win32") {
        file = "powershell.exe";
        const psUrl = url.replace(/'/g, "''");
        urlArgs = [
            "-NoProfile",
            "-NonInteractive",
            "-WindowStyle",
            "Hidden",
            "-Command",
            `Start-Process '${psUrl}'`,
        ];
    }
    else {
        file = "xdg-open";
        urlArgs = [url];
    }
    const { cmd, args } = (0,_anysphere_utils__WEBPACK_IMPORTED_MODULE_1__/* .findActualExecutable */ .Ef)(file, urlArgs);
    if (cmd === file) {
        throw new Error("Can't find a way to open browser");
    }
    return { cmd, args };
}
function openBrowser(url) {
    // Validate that the URL is a web link (http:// or https://)
    if (!isValidWebUrl(url)) {
        return Promise.reject(new Error(`Invalid URL: Only web links (http:// and https://) are supported. Received: ${url}`));
    }
    if (process.env.NO_OPEN_BROWSER) {
        return Promise.reject(new Error("Browser opening disabled"));
    }
    const runningInSsh = (0,_terminal_theme_js__WEBPACK_IMPORTED_MODULE_2__/* .isLikelySshSession */ .lf)();
    if (runningInSsh) {
        return Promise.reject(new Error(`Cannot open browser in SSH session`));
    }
    return new Promise((resolve, reject) => {
        const { cmd, args } = getBrowserInvocation(url);
        const child = (0,node_child_process__WEBPACK_IMPORTED_MODULE_0__.spawn)(cmd, args, { stdio: "ignore", windowsHide: true });
        child.once("error", err => {
            reject(new Error(`Failed to open browser: ${err.message}`));
        });
        // NB: We don't care when this process exits, only that it started
        // relatively successfully. xdg-open will block sometimes and that's Bad
        child.once("spawn", () => resolve());
    });
}
/**
 * Validates that a URL is a valid web link (http:// or https://).
 * This prevents opening potentially dangerous protocols like file://, javascript:, etc.
 */
function isValidWebUrl(url) {
    try {
        const parsed = new URL(url);
        return parsed.protocol === "http:" || parsed.protocol === "https:";
    }
    catch (_a) {
        // If URL parsing fails, it's not a valid URL
        return false;
    }
}


/***/ }),

/***/ "./src/utils/terminal-theme.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _J: () => (/* binding */ detectTerminalIsLight),
/* harmony export */   jf: () => (/* binding */ resetTerminalThemeCache),
/* harmony export */   lf: () => (/* binding */ isLikelySshSession)
/* harmony export */ });
/* unused harmony exports disableTerminalThemeDetection, parseColorFgbgBackgroundRgb, computeLuma, detectTerminalBackgroundRgb */
/*
  Terminal theme detection using OSC 11 query.
  Based on xterm dynamic colors: query default background.
  Many terminals reply with: ESC ] 11;rgb:RRRR/GGGG/BBBB BEL|ST
*/
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
const cached = {
    rgb: undefined,
};
// Global kill-switch to avoid emitting OSC 11 queries in environments that
// visibly echo terminal responses (e.g., certain integrated terminals).
let detectionDisabled = false;
function disableTerminalThemeDetection() {
    detectionDisabled = true;
    // Ensure any waiting callers resolve quickly without side effects
    cached.rgb = null;
    cached.pending = undefined;
}
function resetTerminalThemeCache() {
    cached.rgb = undefined;
    cached.pending = undefined;
}
/**
 * Parse COLORFGBG environment variable to approximate background RGB.
 * Common formats: "fg;bg" or "fg;bg;..." where the last value is background.
 * Values are typically ANSI color indexes (0-15). This is a heuristic.
 */
function parseColorFgbgBackgroundRgb(env = process.env) {
    var _a;
    const value = env.COLORFGBG;
    if (!value)
        return null;
    const parts = value
        .split(";")
        .map(p => p.trim())
        .filter(Boolean);
    if (parts.length === 0)
        return null;
    const bgIndexStr = (_a = parts[parts.length - 1]) !== null && _a !== void 0 ? _a : "";
    const bgIndex = Number.parseInt(bgIndexStr, 10);
    if (!Number.isFinite(bgIndex))
        return null;
    // Map 0-15 ANSI colors to approximate sRGB values
    // 0: black, 7: light gray, 8: dark gray, 15: white, etc.
    const ansi16 = [
        { r: 0, g: 0, b: 0 }, // 0 black
        { r: 205, g: 0, b: 0 }, // 1 red
        { r: 0, g: 205, b: 0 }, // 2 green
        { r: 205, g: 205, b: 0 }, // 3 yellow
        { r: 0, g: 0, b: 238 }, // 4 blue
        { r: 205, g: 0, b: 205 }, // 5 magenta
        { r: 0, g: 205, b: 205 }, // 6 cyan
        { r: 229, g: 229, b: 229 }, // 7 light gray
        { r: 127, g: 127, b: 127 }, // 8 dark gray
        { r: 255, g: 0, b: 0 }, // 9 bright red
        { r: 0, g: 255, b: 0 }, // 10 bright green
        { r: 255, g: 255, b: 0 }, // 11 bright yellow
        { r: 92, g: 92, b: 255 }, // 12 bright blue
        { r: 255, g: 0, b: 255 }, // 13 bright magenta
        { r: 0, g: 255, b: 255 }, // 14 bright cyan
        { r: 255, g: 255, b: 255 }, // 15 white
    ];
    if (bgIndex >= 0 && bgIndex < ansi16.length) {
        return ansi16[bgIndex];
    }
    return null;
}
function to8bit(hex) {
    // 1-4 hex digits per channel possible; scale to 0-255
    const v = parseInt(hex, 16);
    const bits = hex.length * 4; // 4..16
    if (bits <= 8)
        return v & 0xff;
    // downscale 16->8 by >> 8
    return (v >> (bits - 8)) & 0xff;
}
function computeLuma(rgb) {
    const r = rgb.r / 255;
    const g = rgb.g / 255;
    const b = rgb.b / 255;
    // Rec. 709 luma
    return 0.2126 * r + 0.7152 * g + 0.0722 * b;
}
function detectTerminalBackgroundRgb(stdin_1, stdout_1) {
    return __awaiter(this, arguments, void 0, function* (stdin, stdout, timeoutMs = 60) {
        var _a;
        if (detectionDisabled)
            return null;
        if (cached.rgb !== undefined)
            return (_a = cached.rgb) !== null && _a !== void 0 ? _a : null;
        if (cached.pending)
            return cached.pending;
        cached.pending = new Promise(resolve => {
            if (!stdin.isTTY || !stdout.isTTY) {
                cached.rgb = null;
                resolve(null);
                return;
            }
            // Do not change raw mode; respect the host app's raw-mode management
            let buf = "";
            const onData = (chunk) => {
                buf += chunk.toString("utf8");
                // Parse OSC 11 response; examples:
                // \x1b]11;rgb:ffff/ffff/ffff\x07
                // \x1b]11;rgba:ffff/ffff/ffff/ffff\x07
                const m = /\x1b\]11;(?:rgba?):([0-9a-fA-F]{1,4})\/([0-9a-fA-F]{1,4})\/([0-9a-fA-F]{1,4})(?:\/[0-9a-fA-F]{1,4})?(?:\x07|\x1b\\)/i.exec(buf);
                if (m) {
                    stdin.off("data", onData);
                    const r = to8bit(m[1]);
                    const g = to8bit(m[2]);
                    const b = to8bit(m[3]);
                    const rgb = { r, g, b };
                    cached.rgb = rgb;
                    resolve(rgb);
                }
            };
            const cleanup = () => {
                stdin.off("data", onData);
            };
            stdin.on("data", onData);
            // Send OSC 11 query with BEL and ST terminators (maximize compat)
            try {
                const osc11Bel = "\x1b]11;?\x07";
                // Write only BEL-terminated variant to avoid stray visible characters
                stdout.write(osc11Bel);
            }
            catch (_a) { }
            setTimeout(() => {
                var _a;
                cleanup();
                if (cached.rgb === undefined) {
                    // Try environment-based fallback if OSC 11 is unavailable
                    const envRgb = parseColorFgbgBackgroundRgb();
                    cached.rgb = envRgb !== null && envRgb !== void 0 ? envRgb : null;
                }
                resolve((_a = cached.rgb) !== null && _a !== void 0 ? _a : null);
            }, timeoutMs);
        });
        const res = yield cached.pending;
        return res;
    });
}
function detectTerminalIsLight(stdin, stdout, timeoutMs) {
    return __awaiter(this, void 0, void 0, function* () {
        const rgb = yield detectTerminalBackgroundRgb(stdin, stdout, timeoutMs);
        if (!rgb) {
            // As a secondary fallback, attempt to infer from COLORFGBG
            const envRgb = parseColorFgbgBackgroundRgb();
            if (!envRgb)
                return null;
            const lumaEnv = computeLuma(envRgb);
            return lumaEnv > 0.6;
        }
        const luma = computeLuma(rgb);
        return luma > 0.6;
    });
}
const TRUTHY_VALUES = new Set(["1", "true", "yes", "y", "on"]);
const FALSY_VALUES = new Set(["0", "false", "no", "n", "off"]);
const OVERRIDE_ENV_VARS = [
    "CURSOR_AGENT_CLI_ASSUME_SSH",
    "CURSOR_AGENT_ASSUME_SSH",
    "CURSOR_CLI_ASSUME_SSH",
    "CURSOR_ASSUME_SSH",
    "CURSOR_AGENT_CLI_FORCE_SSH",
    "CURSOR_AGENT_FORCE_SSH",
    "CURSOR_CLI_FORCE_SSH",
    "CURSOR_FORCE_SSH",
];
const DIRECT_SSH_ENV_VARS = [
    "SSH_CONNECTION",
    "SSH_CLIENT",
    "SSH_TTY",
    "SSH2_CLIENT",
    "SSH2_TTY",
];
const MOSH_ENV_VARS = [
    "MOSH_CLIENT",
    "MOSH_SERVER",
    "MOSH_TTY",
    "MOSH_IP",
    "MOSH_PORT",
    "MOSH_PRESERVE_PROMPT",
];
const REMOTE_HINT_ENV_VARS = [
    "VSCODE_SSH_HOST",
    "VSCODE_SSH_SERVER",
];
const REMOTE_VALUE_MATCHERS = [
    { key: "VSCODE_IPC_HOOK_CLI", regex: /ssh/i },
    { key: "TERM", regex: /mosh/i },
];
function parseBooleanEnv(value) {
    if (value == null) {
        return undefined;
    }
    const normalized = value.trim().toLowerCase();
    if (TRUTHY_VALUES.has(normalized)) {
        return true;
    }
    if (FALSY_VALUES.has(normalized)) {
        return false;
    }
    return undefined;
}
function resolveOverride(env) {
    for (const key of OVERRIDE_ENV_VARS) {
        const parsed = parseBooleanEnv(env[key]);
        if (parsed !== undefined) {
            return parsed;
        }
    }
    return undefined;
}
function hasIndicator(env, keys) {
    return keys.some((key) => {
        const value = env[key];
        return value != null && value !== "";
    });
}
function matchesIndicatorRegex(env, matchers) {
    return matchers.some((matcher) => {
        const value = env[matcher.key];
        return typeof value === "string" && matcher.regex.test(value);
    });
}
/**
 * Best-effort detection of whether the current process is running inside an SSH
 * or SSH-like (e.g. mosh) remote session. Can be overridden via CURSOR_*_SSH env vars.
 */
function isLikelySshSession(env = process.env) {
    const override = resolveOverride(env);
    if (override !== undefined) {
        return override;
    }
    if (hasIndicator(env, DIRECT_SSH_ENV_VARS)) {
        return true;
    }
    if (hasIndicator(env, MOSH_ENV_VARS)) {
        return true;
    }
    if (hasIndicator(env, REMOTE_HINT_ENV_VARS)) {
        return true;
    }
    if (matchesIndicatorRegex(env, REMOTE_VALUE_MATCHERS)) {
        return true;
    }
    return false;
}


/***/ })

};
;