"use strict";
exports.id = 3686;
exports.ids = [3686];
exports.modules = {

/***/ "../ink/build/colorize.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var chalk__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/chalk@5.6.0/node_modules/chalk/source/index.js");

const rgbRegex = /^rgb\(\s?(\d+),\s?(\d+),\s?(\d+)\s?\)$/;
const ansiRegex = /^ansi256\(\s?(\d+)\s?\)$/;
const isNamedColor = (color) => {
    return color in chalk__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay;
};
const colorize = (str, color, type) => {
    if (!color) {
        return str;
    }
    if (isNamedColor(color)) {
        if (type === 'foreground') {
            return chalk__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay[color](str);
        }
        const methodName = `bg${color[0].toUpperCase() + color.slice(1)}`;
        return chalk__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay[methodName](str);
    }
    if (color.startsWith('#')) {
        return type === 'foreground'
            ? chalk__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.hex(color)(str)
            : chalk__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.bgHex(color)(str);
    }
    if (color.startsWith('ansi256')) {
        const matches = ansiRegex.exec(color);
        if (!matches) {
            return str;
        }
        const value = Number(matches[1]);
        return type === 'foreground'
            ? chalk__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.ansi256(value)(str)
            : chalk__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.bgAnsi256(value)(str);
    }
    if (color.startsWith('rgb')) {
        const matches = rgbRegex.exec(color);
        if (!matches) {
            return str;
        }
        const firstValue = Number(matches[1]);
        const secondValue = Number(matches[2]);
        const thirdValue = Number(matches[3]);
        return type === 'foreground'
            ? chalk__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.rgb(firstValue, secondValue, thirdValue)(str)
            : chalk__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.bgRgb(firstValue, secondValue, thirdValue)(str);
    }
    return str;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (colorize);
//# sourceMappingURL=colorize.js.map

/***/ }),

/***/ "../ink/build/components/AccessibilityContext.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: () => (/* binding */ accessibilityContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");

const accessibilityContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({
    isScreenReaderEnabled: false,
});
//# sourceMappingURL=AccessibilityContext.js.map

/***/ }),

/***/ "../ink/build/components/App.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ App)
});

// EXTERNAL MODULE: external "node:events"
var external_node_events_ = __webpack_require__("node:events");
// EXTERNAL MODULE: external "node:process"
var external_node_process_ = __webpack_require__("node:process");
// EXTERNAL MODULE: ../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js
var react = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
// EXTERNAL MODULE: ../../node_modules/.pnpm/cli-cursor@4.0.0/node_modules/cli-cursor/index.js + 1 modules
var cli_cursor = __webpack_require__("../../node_modules/.pnpm/cli-cursor@4.0.0/node_modules/cli-cursor/index.js");
// EXTERNAL MODULE: ../ink/build/components/AppContext.js
var AppContext = __webpack_require__("../ink/build/components/AppContext.js");
// EXTERNAL MODULE: ../ink/build/components/StdinContext.js
var StdinContext = __webpack_require__("../ink/build/components/StdinContext.js");
// EXTERNAL MODULE: ../ink/build/components/StdoutContext.js
var StdoutContext = __webpack_require__("../ink/build/components/StdoutContext.js");
// EXTERNAL MODULE: ../ink/build/components/StderrContext.js
var StderrContext = __webpack_require__("../ink/build/components/StderrContext.js");
// EXTERNAL MODULE: ../ink/build/components/FocusContext.js
var FocusContext = __webpack_require__("../ink/build/components/FocusContext.js");
// EXTERNAL MODULE: external "node:fs"
var external_node_fs_ = __webpack_require__("node:fs");
// EXTERNAL MODULE: ../../node_modules/.pnpm/stack-utils@2.0.6/node_modules/stack-utils/index.js
var stack_utils = __webpack_require__("../../node_modules/.pnpm/stack-utils@2.0.6/node_modules/stack-utils/index.js");
// EXTERNAL MODULE: ../../node_modules/.pnpm/code-excerpt@4.0.0/node_modules/code-excerpt/dist/index.js + 1 modules
var dist = __webpack_require__("../../node_modules/.pnpm/code-excerpt@4.0.0/node_modules/code-excerpt/dist/index.js");
// EXTERNAL MODULE: ../ink/build/components/Box.js
var Box = __webpack_require__("../ink/build/components/Box.js");
// EXTERNAL MODULE: ../ink/build/components/Text.js
var Text = __webpack_require__("../ink/build/components/Text.js");
;// ../ink/build/components/ErrorOverview.js







// Error's source file is reported as file:///home/user/file.js
// This function removes the file://[cwd] part
const cleanupPath = (path) => {
    return path?.replace(`file://${(0,external_node_process_.cwd)()}/`, '');
};
const stackUtils = new stack_utils({
    cwd: (0,external_node_process_.cwd)(),
    internals: stack_utils.nodeInternals(),
});
function ErrorOverview({ error }) {
    const stack = error.stack ? error.stack.split('\n').slice(1) : undefined;
    const origin = stack ? stackUtils.parseLine(stack[0]) : undefined;
    const filePath = cleanupPath(origin?.file);
    let excerpt;
    let lineWidth = 0;
    if (filePath && origin?.line && external_node_fs_.existsSync(filePath)) {
        const sourceCode = external_node_fs_.readFileSync(filePath, 'utf8');
        excerpt = (0,dist/* default */.A)(sourceCode, origin.line);
        if (excerpt) {
            for (const { line } of excerpt) {
                lineWidth = Math.max(lineWidth, String(line).length);
            }
        }
    }
    return (react.createElement(Box/* default */.A, { flexDirection: "column", padding: 1 },
        react.createElement(Box/* default */.A, null,
            react.createElement(Text/* default */.A, { backgroundColor: "red", color: "white" },
                ' ',
                "ERROR",
                ' '),
            react.createElement(Text/* default */.A, null,
                " ",
                error.message)),
        origin && filePath && (react.createElement(Box/* default */.A, { marginTop: 1 },
            react.createElement(Text/* default */.A, { dimColor: true },
                filePath,
                ":",
                origin.line,
                ":",
                origin.column))),
        origin && excerpt && (react.createElement(Box/* default */.A, { marginTop: 1, flexDirection: "column" }, excerpt.map(({ line, value }) => (react.createElement(Box/* default */.A, { key: line },
            react.createElement(Box/* default */.A, { width: lineWidth + 1 },
                react.createElement(Text/* default */.A, { dimColor: line !== origin.line, backgroundColor: line === origin.line ? 'red' : undefined, color: line === origin.line ? 'white' : undefined, "aria-label": line === origin.line
                        ? `Line ${line}, error`
                        : `Line ${line}` },
                    String(line).padStart(lineWidth, ' '),
                    ":")),
            react.createElement(Text/* default */.A, { key: line, backgroundColor: line === origin.line ? 'red' : undefined, color: line === origin.line ? 'white' : undefined }, ' ' + value)))))),
        error.stack && (react.createElement(Box/* default */.A, { marginTop: 1, flexDirection: "column" }, error.stack
            .split('\n')
            .slice(1)
            .map(line => {
            const parsedLine = stackUtils.parseLine(line);
            // If the line from the stack cannot be parsed, we print out the unparsed line.
            if (!parsedLine) {
                return (react.createElement(Box/* default */.A, { key: line },
                    react.createElement(Text/* default */.A, { dimColor: true }, "- "),
                    react.createElement(Text/* default */.A, { dimColor: true, bold: true },
                        line,
                        "\\t",
                        ' ')));
            }
            return (react.createElement(Box/* default */.A, { key: line },
                react.createElement(Text/* default */.A, { dimColor: true }, "- "),
                react.createElement(Text/* default */.A, { dimColor: true, bold: true }, parsedLine.function),
                react.createElement(Text/* default */.A, { dimColor: true, color: "gray", "aria-label": `at ${cleanupPath(parsedLine.file) ?? ''} line ${parsedLine.line} column ${parsedLine.column}` },
                    ' ',
                    "(",
                    cleanupPath(parsedLine.file) ?? '',
                    ":",
                    parsedLine.line,
                    ":",
                    parsedLine.column,
                    ")")));
        })))));
}
//# sourceMappingURL=ErrorOverview.js.map
;// ../ink/build/components/App.js










const tab = '\t';
const shiftTab = '\u001B[Z';
const App_escape = '\u001B';
// Root component for all Ink apps
// It renders stdin and stdout contexts, so that children can access them if needed
// It also handles Ctrl+C exiting and cursor visibility
class App extends react.PureComponent {
    static displayName = 'InternalApp';
    static getDerivedStateFromError(error) {
        return { error };
    }
    state = {
        isFocusEnabled: true,
        activeFocusId: undefined,
        focusables: [],
        error: undefined,
    };
    // Count how many components enabled raw mode to avoid disabling
    // raw mode until all components don't need it anymore
    rawModeEnabledCount = 0;
    // eslint-disable-next-line @typescript-eslint/naming-convention
    internal_eventEmitter = new external_node_events_.EventEmitter();
    // Determines if TTY is supported on the provided stdin
    isRawModeSupported() {
        return this.props.stdin.isTTY;
    }
    render() {
        return (react.createElement(AppContext/* default */.A.Provider
        // eslint-disable-next-line react/jsx-no-constructed-context-values
        , { 
            // eslint-disable-next-line react/jsx-no-constructed-context-values
            value: {
                exit: this.handleExit,
            } },
            react.createElement(StdinContext/* default */.A.Provider
            // eslint-disable-next-line react/jsx-no-constructed-context-values
            , { 
                // eslint-disable-next-line react/jsx-no-constructed-context-values
                value: {
                    stdin: this.props.stdin,
                    setRawMode: this.handleSetRawMode,
                    isRawModeSupported: this.isRawModeSupported(),
                    // eslint-disable-next-line @typescript-eslint/naming-convention
                    internal_exitOnCtrlC: this.props.exitOnCtrlC,
                    // eslint-disable-next-line @typescript-eslint/naming-convention
                    internal_eventEmitter: this.internal_eventEmitter,
                } },
                react.createElement(StdoutContext/* default */.A.Provider
                // eslint-disable-next-line react/jsx-no-constructed-context-values
                , { 
                    // eslint-disable-next-line react/jsx-no-constructed-context-values
                    value: {
                        stdout: this.props.stdout,
                        write: this.props.writeToStdout,
                    } },
                    react.createElement(StderrContext/* default */.A.Provider
                    // eslint-disable-next-line react/jsx-no-constructed-context-values
                    , { 
                        // eslint-disable-next-line react/jsx-no-constructed-context-values
                        value: {
                            stderr: this.props.stderr,
                            write: this.props.writeToStderr,
                        } },
                        react.createElement(FocusContext/* default */.A.Provider
                        // eslint-disable-next-line react/jsx-no-constructed-context-values
                        , { 
                            // eslint-disable-next-line react/jsx-no-constructed-context-values
                            value: {
                                activeId: this.state.activeFocusId,
                                add: this.addFocusable,
                                remove: this.removeFocusable,
                                activate: this.activateFocusable,
                                deactivate: this.deactivateFocusable,
                                enableFocus: this.enableFocus,
                                disableFocus: this.disableFocus,
                                focusNext: this.focusNext,
                                focusPrevious: this.focusPrevious,
                                focus: this.focus,
                            } }, this.state.error ? (react.createElement(ErrorOverview, { error: this.state.error })) : (this.props.children)))))));
    }
    componentDidMount() {
        cli_cursor/* default */.A.hide(this.props.stdout);
    }
    componentWillUnmount() {
        cli_cursor/* default */.A.show(this.props.stdout);
        // ignore calling setRawMode on an handle stdin it cannot be called
        if (this.isRawModeSupported()) {
            this.handleSetRawMode(false);
        }
    }
    componentDidCatch(error) {
        this.handleExit(error);
    }
    handleSetRawMode = (isEnabled) => {
        const { stdin } = this.props;
        if (!this.isRawModeSupported()) {
            if (stdin === external_node_process_.stdin) {
                throw new Error('Raw mode is not supported on the current process.stdin, which Ink uses as input stream by default.\nRead about how to prevent this error on https://github.com/vadimdemedes/ink/#israwmodesupported');
            }
            else {
                throw new Error('Raw mode is not supported on the stdin provided to Ink.\nRead about how to prevent this error on https://github.com/vadimdemedes/ink/#israwmodesupported');
            }
        }
        stdin.setEncoding('utf8');
        if (isEnabled) {
            // Ensure raw mode is enabled only once
            if (this.rawModeEnabledCount === 0) {
                stdin.ref();
                stdin.setRawMode(true);
                stdin.addListener('readable', this.handleReadable);
            }
            this.rawModeEnabledCount++;
            return;
        }
        // Disable raw mode only when no components left that are using it
        if (--this.rawModeEnabledCount === 0) {
            stdin.setRawMode(false);
            stdin.removeListener('readable', this.handleReadable);
            stdin.unref();
        }
    };
    handleReadable = () => {
        let chunk;
        // eslint-disable-next-line @typescript-eslint/ban-types
        while ((chunk = this.props.stdin.read()) !== null) {
            this.handleInput(chunk);
            this.internal_eventEmitter.emit('input', chunk);
        }
    };
    handleInput = (input) => {
        // Exit on Ctrl+C
        // eslint-disable-next-line unicorn/no-hex-escape
        if (input === '\x03' && this.props.exitOnCtrlC) {
            this.handleExit();
        }
        // Reset focus when there's an active focused component on Esc
        if (input === App_escape && this.state.activeFocusId) {
            this.setState({
                activeFocusId: undefined,
            });
        }
        if (this.state.isFocusEnabled && this.state.focusables.length > 0) {
            if (input === tab) {
                this.focusNext();
            }
            if (input === shiftTab) {
                this.focusPrevious();
            }
        }
    };
    handleExit = (error) => {
        if (this.isRawModeSupported()) {
            this.handleSetRawMode(false);
        }
        this.props.onExit(error);
    };
    enableFocus = () => {
        this.setState({
            isFocusEnabled: true,
        });
    };
    disableFocus = () => {
        this.setState({
            isFocusEnabled: false,
        });
    };
    focus = (id) => {
        this.setState(previousState => {
            const hasFocusableId = previousState.focusables.some(focusable => focusable?.id === id);
            if (!hasFocusableId) {
                return previousState;
            }
            return { activeFocusId: id };
        });
    };
    focusNext = () => {
        this.setState(previousState => {
            const firstFocusableId = previousState.focusables.find(focusable => focusable.isActive)?.id;
            const nextFocusableId = this.findNextFocusable(previousState);
            return {
                activeFocusId: nextFocusableId ?? firstFocusableId,
            };
        });
    };
    focusPrevious = () => {
        this.setState(previousState => {
            const lastFocusableId = previousState.focusables.findLast(focusable => focusable.isActive)?.id;
            const previousFocusableId = this.findPreviousFocusable(previousState);
            return {
                activeFocusId: previousFocusableId ?? lastFocusableId,
            };
        });
    };
    addFocusable = (id, { autoFocus }) => {
        this.setState(previousState => {
            let nextFocusId = previousState.activeFocusId;
            if (!nextFocusId && autoFocus) {
                nextFocusId = id;
            }
            return {
                activeFocusId: nextFocusId,
                focusables: [
                    ...previousState.focusables,
                    {
                        id,
                        isActive: true,
                    },
                ],
            };
        });
    };
    removeFocusable = (id) => {
        this.setState(previousState => ({
            activeFocusId: previousState.activeFocusId === id
                ? undefined
                : previousState.activeFocusId,
            focusables: previousState.focusables.filter(focusable => {
                return focusable.id !== id;
            }),
        }));
    };
    activateFocusable = (id) => {
        this.setState(previousState => ({
            focusables: previousState.focusables.map(focusable => {
                if (focusable.id !== id) {
                    return focusable;
                }
                return {
                    id,
                    isActive: true,
                };
            }),
        }));
    };
    deactivateFocusable = (id) => {
        this.setState(previousState => ({
            activeFocusId: previousState.activeFocusId === id
                ? undefined
                : previousState.activeFocusId,
            focusables: previousState.focusables.map(focusable => {
                if (focusable.id !== id) {
                    return focusable;
                }
                return {
                    id,
                    isActive: false,
                };
            }),
        }));
    };
    findNextFocusable = (state) => {
        const activeIndex = state.focusables.findIndex(focusable => {
            return focusable.id === state.activeFocusId;
        });
        for (let index = activeIndex + 1; index < state.focusables.length; index++) {
            const focusable = state.focusables[index];
            if (focusable?.isActive) {
                return focusable.id;
            }
        }
        return undefined;
    };
    findPreviousFocusable = (state) => {
        const activeIndex = state.focusables.findIndex(focusable => {
            return focusable.id === state.activeFocusId;
        });
        for (let index = activeIndex - 1; index >= 0; index--) {
            const focusable = state.focusables[index];
            if (focusable?.isActive) {
                return focusable.id;
            }
        }
        return undefined;
    };
}
//# sourceMappingURL=App.js.map

/***/ }),

/***/ "../ink/build/components/AppContext.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");

/**
 * `AppContext` is a React context, which exposes a method to manually exit the app (unmount).
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
const AppContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({
    exit() { },
});
AppContext.displayName = 'InternalAppContext';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AppContext);
//# sourceMappingURL=AppContext.js.map

/***/ }),

/***/ "../ink/build/components/BackgroundContext.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   U: () => (/* binding */ backgroundContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");

const backgroundContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(undefined);
//# sourceMappingURL=BackgroundContext.js.map

/***/ }),

/***/ "../ink/build/components/Box.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _AccessibilityContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/components/AccessibilityContext.js");
/* harmony import */ var _BackgroundContext_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../ink/build/components/BackgroundContext.js");



/**
 * `<Box>` is an essential Ink component to build your layout. It's like `<div style="display: flex">` in the browser.
 */
const Box = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({ children, backgroundColor, 'aria-label': ariaLabel, 'aria-hidden': ariaHidden, 'aria-role': role, 'aria-state': ariaState, ...style }, ref) => {
    const { isScreenReaderEnabled } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_AccessibilityContext_js__WEBPACK_IMPORTED_MODULE_1__/* .accessibilityContext */ .E);
    const label = ariaLabel ? react__WEBPACK_IMPORTED_MODULE_0__.createElement("ink-text", null, ariaLabel) : undefined;
    if (isScreenReaderEnabled && ariaHidden) {
        return null;
    }
    const boxElement = (react__WEBPACK_IMPORTED_MODULE_0__.createElement("ink-box", { ref: ref, style: {
            flexWrap: 'nowrap',
            flexDirection: 'row',
            flexGrow: 0,
            flexShrink: 1,
            ...style,
            backgroundColor,
            overflowX: style.overflowX ?? style.overflow ?? 'visible',
            overflowY: style.overflowY ?? style.overflow ?? 'visible',
        }, internal_accessibility: {
            role,
            state: ariaState,
        } }, isScreenReaderEnabled && label ? label : children));
    // If this Box has a background color, provide it to children via context
    if (backgroundColor) {
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BackgroundContext_js__WEBPACK_IMPORTED_MODULE_2__/* .backgroundContext */ .U.Provider, { value: backgroundColor }, boxElement));
    }
    return boxElement;
});
Box.displayName = 'Box';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Box);
//# sourceMappingURL=Box.js.map

/***/ }),

/***/ "../ink/build/components/FocusContext.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");

// eslint-disable-next-line @typescript-eslint/naming-convention
const FocusContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({
    activeId: undefined,
    add() { },
    remove() { },
    activate() { },
    deactivate() { },
    enableFocus() { },
    disableFocus() { },
    focusNext() { },
    focusPrevious() { },
    focus() { },
});
FocusContext.displayName = 'InternalFocusContext';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FocusContext);
//# sourceMappingURL=FocusContext.js.map

/***/ }),

/***/ "../ink/build/components/Newline.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export default */
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");

/**
 * Adds one or more newline (\n) characters. Must be used within <Text> components.
 */
function Newline({ count = 1 }) {
    return React.createElement("ink-text", null, '\n'.repeat(count));
}
//# sourceMappingURL=Newline.js.map

/***/ }),

/***/ "../ink/build/components/Spacer.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export default */
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/components/Box.js");


/**
 * A flexible space that expands along the major axis of its containing layout.
 * It's useful as a shortcut for filling all the available spaces between elements.
 */
function Spacer() {
    return React.createElement(Box, { flexGrow: 1 });
}
//# sourceMappingURL=Spacer.js.map

/***/ }),

/***/ "../ink/build/components/Static.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (/* binding */ Static)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");

/**
 * `<Static>` component permanently renders its output above everything else.
 * It's useful for displaying activity like completed tasks or logs - things that
 * are not changing after they're rendered (hence the name "Static").
 *
 * It's preferred to use `<Static>` for use cases like these, when you can't know
 * or control the amount of items that need to be rendered.
 *
 * For example, [Tap](https://github.com/tapjs/node-tap) uses `<Static>` to display
 * a list of completed tests. [Gatsby](https://github.com/gatsbyjs/gatsby) uses it
 * to display a list of generated pages, while still displaying a live progress bar.
 */
function Static(props) {
    const { items, children: render, style: customStyle } = props;
    const [index, setIndex] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
    const itemsToRender = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
        return items.slice(index);
    }, [items, index]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect)(() => {
        setIndex(items.length);
    }, [items.length]);
    const children = itemsToRender.map((item, itemIndex) => {
        return render(item, index + itemIndex);
    });
    const style = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({
        position: 'absolute',
        flexDirection: 'column',
        ...customStyle,
    }), [customStyle]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("ink-box", { internal_static: true, style: style }, children));
}
//# sourceMappingURL=Static.js.map

/***/ }),

/***/ "../ink/build/components/StderrContext.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var node_process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:process");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");


/**
 * `StderrContext` is a React context, which exposes stderr stream.
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
const StderrContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({
    stderr: node_process__WEBPACK_IMPORTED_MODULE_0__.stderr,
    write() { },
});
StderrContext.displayName = 'InternalStderrContext';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StderrContext);
//# sourceMappingURL=StderrContext.js.map

/***/ }),

/***/ "../ink/build/components/StdinContext.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var node_events__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:events");
/* harmony import */ var node_process__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:process");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");



/**
 * `StdinContext` is a React context, which exposes input stream.
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
const StdinContext = (0,react__WEBPACK_IMPORTED_MODULE_2__.createContext)({
    stdin: node_process__WEBPACK_IMPORTED_MODULE_1__.stdin,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    internal_eventEmitter: new node_events__WEBPACK_IMPORTED_MODULE_0__.EventEmitter(),
    setRawMode() { },
    isRawModeSupported: false,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    internal_exitOnCtrlC: true,
});
StdinContext.displayName = 'InternalStdinContext';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StdinContext);
//# sourceMappingURL=StdinContext.js.map

/***/ }),

/***/ "../ink/build/components/StdoutContext.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var node_process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:process");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");


/**
 * `StdoutContext` is a React context, which exposes stdout stream, where Ink renders your app.
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
const StdoutContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({
    stdout: node_process__WEBPACK_IMPORTED_MODULE_0__.stdout,
    write() { },
});
StdoutContext.displayName = 'InternalStdoutContext';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StdoutContext);
//# sourceMappingURL=StdoutContext.js.map

/***/ }),

/***/ "../ink/build/components/Text.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (/* binding */ Text)
/* harmony export */ });
/* harmony import */ var chalk__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../node_modules/.pnpm/chalk@5.6.0/node_modules/chalk/source/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _colorize_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../ink/build/colorize.js");
/* harmony import */ var _AccessibilityContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/components/AccessibilityContext.js");
/* harmony import */ var _BackgroundContext_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../ink/build/components/BackgroundContext.js");





/**
 * This component can display text, and change its style to make it colorful, bold, underline, italic or strikethrough.
 */
function Text({ color, backgroundColor, dimColor = false, bold = false, italic = false, underline = false, strikethrough = false, inverse = false, wrap = 'wrap', children, 'aria-label': ariaLabel, 'aria-hidden': ariaHidden = false, }) {
    const { isScreenReaderEnabled } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_AccessibilityContext_js__WEBPACK_IMPORTED_MODULE_1__/* .accessibilityContext */ .E);
    const inheritedBackgroundColor = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_BackgroundContext_js__WEBPACK_IMPORTED_MODULE_2__/* .backgroundContext */ .U);
    const childrenOrAriaLabel = isScreenReaderEnabled && ariaLabel ? ariaLabel : children;
    if (childrenOrAriaLabel === undefined || childrenOrAriaLabel === null) {
        return null;
    }
    const transform = (children) => {
        if (dimColor) {
            children = chalk__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Ay.dim(children);
        }
        if (color) {
            children = (0,_colorize_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)(children, color, 'foreground');
        }
        // Use explicit backgroundColor if provided, otherwise use inherited from parent Box
        const effectiveBackgroundColor = backgroundColor ?? inheritedBackgroundColor;
        if (effectiveBackgroundColor) {
            children = (0,_colorize_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)(children, effectiveBackgroundColor, 'background');
        }
        if (bold) {
            children = chalk__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Ay.bold(children);
        }
        if (italic) {
            children = chalk__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Ay.italic(children);
        }
        if (underline) {
            children = chalk__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Ay.underline(children);
        }
        if (strikethrough) {
            children = chalk__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Ay.strikethrough(children);
        }
        if (inverse) {
            children = chalk__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Ay.inverse(children);
        }
        return children;
    };
    if (isScreenReaderEnabled && ariaHidden) {
        return null;
    }
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("ink-text", { style: { flexGrow: 0, flexShrink: 1, flexDirection: 'row', textWrap: wrap }, internal_transform: transform }, isScreenReaderEnabled && ariaLabel ? ariaLabel : children));
}
//# sourceMappingURL=Text.js.map

/***/ }),

/***/ "../ink/build/components/Transform.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export default */
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _AccessibilityContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/components/AccessibilityContext.js");


/**
 * Transform a string representation of React components before they are written to output.
 * For example, you might want to apply a gradient to text, add a clickable link or create some text effects.
 * These use cases can't accept React nodes as input, they are expecting a string.
 * That's what <Transform> component does, it gives you an output string of its child components and lets you transform it in any way.
 */
function Transform({ children, transform, accessibilityLabel, }) {
    const { isScreenReaderEnabled } = useContext(accessibilityContext);
    if (children === undefined || children === null) {
        return null;
    }
    return (React.createElement("ink-text", { style: { flexGrow: 0, flexShrink: 1, flexDirection: 'row' }, internal_transform: transform }, isScreenReaderEnabled && accessibilityLabel
        ? accessibilityLabel
        : children));
}
//# sourceMappingURL=Transform.js.map

/***/ }),

/***/ "../ink/build/dom.js":
/***/ ((__webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(__webpack_module__, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Bq: () => (/* binding */ setAttribute),
/* harmony export */   Mq: () => (/* binding */ createTextNode),
/* harmony export */   RM: () => (/* binding */ createNode),
/* harmony export */   V6: () => (/* binding */ appendChildNode),
/* harmony export */   V8: () => (/* binding */ removeChildNode),
/* harmony export */   bC: () => (/* binding */ insertBeforeNode),
/* harmony export */   eC: () => (/* binding */ setStyle),
/* harmony export */   x6: () => (/* binding */ setTextNodeValue)
/* harmony export */ });
/* harmony import */ var yoga_layout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/yoga-layout@3.2.1/node_modules/yoga-layout/dist/src/index.js");
/* harmony import */ var _measure_text_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/measure-text.js");
/* harmony import */ var _wrap_text_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../ink/build/wrap-text.js");
/* harmony import */ var _squash_text_nodes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../ink/build/squash-text-nodes.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([yoga_layout__WEBPACK_IMPORTED_MODULE_0__]);
yoga_layout__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const createNode = (nodeName) => {
    const node = {
        nodeName,
        style: {},
        attributes: {},
        childNodes: [],
        parentNode: undefined,
        yogaNode: nodeName === 'ink-virtual-text' ? undefined : yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.Node.create(),
        // eslint-disable-next-line @typescript-eslint/naming-convention
        internal_accessibility: {},
    };
    if (nodeName === 'ink-text') {
        node.yogaNode?.setMeasureFunc(measureTextNode.bind(null, node));
    }
    return node;
};
const appendChildNode = (node, childNode) => {
    if (childNode.parentNode) {
        removeChildNode(childNode.parentNode, childNode);
    }
    childNode.parentNode = node;
    node.childNodes.push(childNode);
    if (childNode.yogaNode) {
        node.yogaNode?.insertChild(childNode.yogaNode, node.yogaNode.getChildCount());
    }
    if (node.nodeName === 'ink-text' || node.nodeName === 'ink-virtual-text') {
        markNodeAsDirty(node);
    }
};
const insertBeforeNode = (node, newChildNode, beforeChildNode) => {
    if (newChildNode.parentNode) {
        removeChildNode(newChildNode.parentNode, newChildNode);
    }
    newChildNode.parentNode = node;
    const index = node.childNodes.indexOf(beforeChildNode);
    if (index >= 0) {
        node.childNodes.splice(index, 0, newChildNode);
        if (newChildNode.yogaNode) {
            node.yogaNode?.insertChild(newChildNode.yogaNode, index);
        }
        return;
    }
    node.childNodes.push(newChildNode);
    if (newChildNode.yogaNode) {
        node.yogaNode?.insertChild(newChildNode.yogaNode, node.yogaNode.getChildCount());
    }
    if (node.nodeName === 'ink-text' || node.nodeName === 'ink-virtual-text') {
        markNodeAsDirty(node);
    }
};
const removeChildNode = (node, removeNode) => {
    if (removeNode.yogaNode) {
        removeNode.parentNode?.yogaNode?.removeChild(removeNode.yogaNode);
    }
    removeNode.parentNode = undefined;
    const index = node.childNodes.indexOf(removeNode);
    if (index >= 0) {
        node.childNodes.splice(index, 1);
    }
    if (node.nodeName === 'ink-text' || node.nodeName === 'ink-virtual-text') {
        markNodeAsDirty(node);
    }
};
const setAttribute = (node, key, value) => {
    if (key === 'internal_accessibility') {
        node.internal_accessibility = value;
        return;
    }
    node.attributes[key] = value;
};
const setStyle = (node, style) => {
    node.style = style;
};
const createTextNode = (text) => {
    const node = {
        nodeName: '#text',
        nodeValue: text,
        yogaNode: undefined,
        parentNode: undefined,
        style: {},
    };
    setTextNodeValue(node, text);
    return node;
};
const measureTextNode = function (node, width) {
    const text = node.nodeName === '#text' ? node.nodeValue : (0,_squash_text_nodes_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)(node);
    const dimensions = (0,_measure_text_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)(text);
    const textWrap = node.style?.textWrap ?? 'wrap';
    // If no-wrap is specified, return dimensions as-is
    if (textWrap === 'no-wrap') {
        return dimensions;
    }
    // Text fits into container, no need to wrap
    if (dimensions.width <= width) {
        return dimensions;
    }
    // This is happening when <Box> is shrinking child nodes and Yoga asks
    // if we can fit this text node in a <1px space, so we just tell Yoga "no"
    if (dimensions.width >= 1 && width > 0 && width < 1) {
        return dimensions;
    }
    const wrappedText = (0,_wrap_text_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A)(text, width, textWrap);
    return (0,_measure_text_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)(wrappedText);
};
const findClosestYogaNode = (node) => {
    if (!node?.parentNode) {
        return undefined;
    }
    return node.yogaNode ?? findClosestYogaNode(node.parentNode);
};
const markNodeAsDirty = (node) => {
    // Mark closest Yoga node as dirty to measure text dimensions again
    const yogaNode = findClosestYogaNode(node);
    yogaNode?.markDirty();
};
const setTextNodeValue = (node, text) => {
    if (typeof text !== 'string') {
        text = String(text);
    }
    node.nodeValue = text;
    markNodeAsDirty(node);
};
//# sourceMappingURL=dom.js.map
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "../ink/build/get-max-width.js":
/***/ ((__webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(__webpack_module__, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var yoga_layout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/yoga-layout@3.2.1/node_modules/yoga-layout/dist/src/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([yoga_layout__WEBPACK_IMPORTED_MODULE_0__]);
yoga_layout__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const getMaxWidth = (yogaNode) => {
    return (yogaNode.getComputedWidth() -
        yogaNode.getComputedPadding(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_LEFT) -
        yogaNode.getComputedPadding(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_RIGHT) -
        yogaNode.getComputedBorder(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_LEFT) -
        yogaNode.getComputedBorder(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_RIGHT));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (getMaxWidth);
//# sourceMappingURL=get-max-width.js.map
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "../ink/build/hooks/use-app.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _components_AppContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/components/AppContext.js");


/**
 * `useApp` is a React hook, which exposes a method to manually exit the app (unmount).
 */
const useApp = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_components_AppContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useApp);
//# sourceMappingURL=use-app.js.map

/***/ }),

/***/ "../ink/build/hooks/use-focus-manager.js":
/***/ ((__unused_webpack___webpack_module__, __unused_webpack___webpack_exports__, __webpack_require__) => {

/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _components_FocusContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/components/FocusContext.js");


/**
 * This hook exposes methods to enable or disable focus management for all
 * components or manually switch focus to next or previous components.
 */
const useFocusManager = () => {
    const focusContext = useContext(FocusContext);
    return {
        enableFocus: focusContext.enableFocus,
        disableFocus: focusContext.disableFocus,
        focusNext: focusContext.focusNext,
        focusPrevious: focusContext.focusPrevious,
        focus: focusContext.focus,
    };
};
/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = ((/* unused pure expression or super */ null && (useFocusManager)));
//# sourceMappingURL=use-focus-manager.js.map

/***/ }),

/***/ "../ink/build/hooks/use-focus.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _components_FocusContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/components/FocusContext.js");
/* harmony import */ var _use_stdin_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../ink/build/hooks/use-stdin.js");



/**
 * Component that uses `useFocus` hook becomes "focusable" to Ink,
 * so when user presses <kbd>Tab</kbd>, Ink will switch focus to this component.
 * If there are multiple components that execute `useFocus` hook, focus will be
 * given to them in the order that these components are rendered in.
 * This hook returns an object with `isFocused` boolean property, which
 * determines if this component is focused or not.
 */
const useFocus = ({ isActive = true, autoFocus = false, id: customId, } = {}) => {
    const { isRawModeSupported, setRawMode } = (0,_use_stdin_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A)();
    const { activeId, add, remove, activate, deactivate, focus } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_components_FocusContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
    const id = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
        return customId ?? Math.random().toString().slice(2, 7);
    }, [customId]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        add(id, { autoFocus });
        return () => {
            remove(id);
        };
    }, [id, autoFocus]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (isActive) {
            activate(id);
        }
        else {
            deactivate(id);
        }
    }, [isActive, id]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (!isRawModeSupported || !isActive) {
            return;
        }
        setRawMode(true);
        return () => {
            setRawMode(false);
        };
    }, [isActive]);
    return {
        isFocused: Boolean(id) && activeId === id,
        focus,
    };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useFocus);
//# sourceMappingURL=use-focus.js.map

/***/ }),

/***/ "../ink/build/hooks/use-input.js":
/***/ ((__webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(__webpack_module__, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _parse_keypress_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/parse-keypress.js");
/* harmony import */ var _reconciler_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../ink/build/reconciler.js");
/* harmony import */ var _use_stdin_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../ink/build/hooks/use-stdin.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_reconciler_js__WEBPACK_IMPORTED_MODULE_2__]);
_reconciler_js__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




/**
 * This hook is used for handling user input.
 * It's a more convenient alternative to using `StdinContext` and listening to `data` events.
 * The callback you pass to `useInput` is called for each character when user enters any input.
 * However, if user pastes text and it's more than one character, the callback will be called only once and the whole string will be passed as `input`.
 *
 * ```
 * import {useInput} from 'ink';
 *
 * const UserInput = () => {
 *   useInput((input, key) => {
 *     if (input === 'q') {
 *       // Exit program
 *     }
 *
 *     if (key.leftArrow) {
 *       // Left arrow key pressed
 *     }
 *   });
 *
 *   return …
 * };
 * ```
 */
const useInput = (inputHandler, options = {}) => {
    // eslint-disable-next-line @typescript-eslint/naming-convention
    const { stdin, setRawMode, internal_exitOnCtrlC, internal_eventEmitter } = (0,_use_stdin_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)();
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (options.isActive === false) {
            return;
        }
        setRawMode(true);
        return () => {
            setRawMode(false);
        };
    }, [options.isActive, setRawMode]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (options.isActive === false) {
            return;
        }
        const handleData = (data) => {
            const keypress = (0,_parse_keypress_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)(data);
            const key = {
                upArrow: keypress.name === 'up',
                downArrow: keypress.name === 'down',
                leftArrow: keypress.name === 'left',
                rightArrow: keypress.name === 'right',
                pageDown: keypress.name === 'pagedown',
                pageUp: keypress.name === 'pageup',
                return: keypress.name === 'return',
                escape: keypress.name === 'escape',
                ctrl: keypress.ctrl,
                shift: keypress.shift,
                tab: keypress.name === 'tab',
                backspace: keypress.name === 'backspace',
                delete: keypress.name === 'delete',
                // `parseKeypress` parses \u001B\u001B[A (meta + up arrow) as meta = false
                // but with option = true, so we need to take this into account here
                // to avoid breaking changes in Ink.
                // TODO(vadimdemedes): consider removing this in the next major version.
                meta: keypress.meta || keypress.name === 'escape' || keypress.option,
            };
            let input = keypress.ctrl ? keypress.name : keypress.sequence;
            if (_parse_keypress_js__WEBPACK_IMPORTED_MODULE_1__/* .nonAlphanumericKeys */ .f.includes(keypress.name)) {
                input = '';
            }
            // Strip meta if it's still remaining after `parseKeypress`
            // TODO(vadimdemedes): remove this in the next major version.
            if (input.startsWith('\u001B')) {
                input = input.slice(1);
            }
            if (input.length === 1 &&
                typeof input[0] === 'string' &&
                /[A-Z]/.test(input[0])) {
                key.shift = true;
            }
            // If app is not supposed to exit on Ctrl+C, then let input listener handle it
            if (!(input === 'c' && key.ctrl) || !internal_exitOnCtrlC) {
                // @ts-expect-error TypeScript types for `batchedUpdates` require an argument, but React's codebase doesn't provide it and it works without it as expected.
                _reconciler_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A.batchedUpdates(() => {
                    inputHandler(input, key);
                });
            }
        };
        internal_eventEmitter?.on('input', handleData);
        return () => {
            internal_eventEmitter?.removeListener('input', handleData);
        };
    }, [options.isActive, stdin, internal_exitOnCtrlC, inputHandler]);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useInput);
//# sourceMappingURL=use-input.js.map
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "../ink/build/hooks/use-is-screen-reader-enabled.js":
/***/ ((__unused_webpack___webpack_module__, __unused_webpack___webpack_exports__, __webpack_require__) => {

/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _components_AccessibilityContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/components/AccessibilityContext.js");


/**
 * Returns whether screen reader is enabled. This is useful when you want to
 * render a different output for screen readers.
 */
const useIsScreenReaderEnabled = () => {
    const { isScreenReaderEnabled } = useContext(accessibilityContext);
    return isScreenReaderEnabled;
};
/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = ((/* unused pure expression or super */ null && (useIsScreenReaderEnabled)));
//# sourceMappingURL=use-is-screen-reader-enabled.js.map

/***/ }),

/***/ "../ink/build/hooks/use-stderr.js":
/***/ ((__unused_webpack___webpack_module__, __unused_webpack___webpack_exports__, __webpack_require__) => {

/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _components_StderrContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/components/StderrContext.js");


/**
 * `useStderr` is a React hook, which exposes stderr stream.
 */
const useStderr = () => useContext(StderrContext);
/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = ((/* unused pure expression or super */ null && (useStderr)));
//# sourceMappingURL=use-stderr.js.map

/***/ }),

/***/ "../ink/build/hooks/use-stdin.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _components_StdinContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/components/StdinContext.js");


/**
 * `useStdin` is a React hook, which exposes stdin stream.
 */
const useStdin = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_components_StdinContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStdin);
//# sourceMappingURL=use-stdin.js.map

/***/ }),

/***/ "../ink/build/hooks/use-stdout.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _components_StdoutContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/components/StdoutContext.js");


/**
 * `useStdout` is a React hook, which exposes stdout stream.
 */
const useStdout = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_components_StdoutContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStdout);
//# sourceMappingURL=use-stdout.js.map

/***/ }),

/***/ "../ink/build/index.js":
/***/ ((__webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(__webpack_module__, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EY: () => (/* reexport safe */ _components_Text_js__WEBPACK_IMPORTED_MODULE_2__.A),
/* harmony export */   Ge: () => (/* reexport safe */ _hooks_use_input_js__WEBPACK_IMPORTED_MODULE_7__.A),
/* harmony export */   XX: () => (/* reexport safe */ _render_js__WEBPACK_IMPORTED_MODULE_0__.A),
/* harmony export */   az: () => (/* reexport safe */ _components_Box_js__WEBPACK_IMPORTED_MODULE_1__.A),
/* harmony export */   iQ: () => (/* reexport safe */ _hooks_use_focus_js__WEBPACK_IMPORTED_MODULE_12__.A),
/* harmony export */   jC: () => (/* reexport safe */ _components_Static_js__WEBPACK_IMPORTED_MODULE_3__.A),
/* harmony export */   mT: () => (/* reexport safe */ _hooks_use_stdin_js__WEBPACK_IMPORTED_MODULE_9__.A),
/* harmony export */   nm: () => (/* reexport safe */ _hooks_use_app_js__WEBPACK_IMPORTED_MODULE_8__.A),
/* harmony export */   t$: () => (/* reexport safe */ _hooks_use_stdout_js__WEBPACK_IMPORTED_MODULE_10__.A)
/* harmony export */ });
/* harmony import */ var _render_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../ink/build/render.js");
/* harmony import */ var _components_Box_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/components/Box.js");
/* harmony import */ var _components_Text_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../ink/build/components/Text.js");
/* harmony import */ var _components_Static_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../ink/build/components/Static.js");
/* harmony import */ var _components_Transform_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../ink/build/components/Transform.js");
/* harmony import */ var _components_Newline_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../ink/build/components/Newline.js");
/* harmony import */ var _components_Spacer_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../ink/build/components/Spacer.js");
/* harmony import */ var _hooks_use_input_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../ink/build/hooks/use-input.js");
/* harmony import */ var _hooks_use_app_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../ink/build/hooks/use-app.js");
/* harmony import */ var _hooks_use_stdin_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../ink/build/hooks/use-stdin.js");
/* harmony import */ var _hooks_use_stdout_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("../ink/build/hooks/use-stdout.js");
/* harmony import */ var _hooks_use_stderr_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("../ink/build/hooks/use-stderr.js");
/* harmony import */ var _hooks_use_focus_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("../ink/build/hooks/use-focus.js");
/* harmony import */ var _hooks_use_focus_manager_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("../ink/build/hooks/use-focus-manager.js");
/* harmony import */ var _hooks_use_is_screen_reader_enabled_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("../ink/build/hooks/use-is-screen-reader-enabled.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_render_js__WEBPACK_IMPORTED_MODULE_0__, _hooks_use_input_js__WEBPACK_IMPORTED_MODULE_7__]);
([_render_js__WEBPACK_IMPORTED_MODULE_0__, _hooks_use_input_js__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
















//# sourceMappingURL=index.js.map
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "../ink/build/ink.js":
/***/ ((__webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(__webpack_module__, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (/* binding */ Ink)
/* harmony export */ });
/* harmony import */ var ansi_escapes__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__("../../node_modules/.pnpm/ansi-escapes@7.0.0/node_modules/ansi-escapes/base.js");
/* harmony import */ var auto_bind__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("../../node_modules/.pnpm/auto-bind@5.0.1/node_modules/auto-bind/index.js");
/* harmony import */ var es_toolkit_compat__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("../../node_modules/.pnpm/es-toolkit@1.39.10/node_modules/es-toolkit/dist/compat/function/throttle.mjs");
/* harmony import */ var is_in_ci__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("../../node_modules/.pnpm/is-in-ci@2.0.0/node_modules/is-in-ci/index.js");
/* harmony import */ var node_process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:process");
/* harmony import */ var patch_console__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/patch-console@2.0.0/node_modules/patch-console/dist/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var react_reconciler_constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../node_modules/.pnpm/react-reconciler@0.32.0_react@19.1.0/node_modules/react-reconciler/constants.js");
/* harmony import */ var signal_exit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../node_modules/.pnpm/signal-exit@3.0.7/node_modules/signal-exit/index.js");
/* harmony import */ var wrap_ansi__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../node_modules/.pnpm/wrap-ansi@9.0.0/node_modules/wrap-ansi/index.js");
/* harmony import */ var yoga_layout__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../node_modules/.pnpm/yoga-layout@3.2.1/node_modules/yoga-layout/dist/src/index.js");
/* harmony import */ var _components_AccessibilityContext_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../ink/build/components/AccessibilityContext.js");
/* harmony import */ var _components_App_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../ink/build/components/App.js");
/* harmony import */ var _dom_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../ink/build/dom.js");
/* harmony import */ var _instances_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("../ink/build/instances.js");
/* harmony import */ var _log_update_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("../ink/build/log-update.js");
/* harmony import */ var _reconciler_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("../ink/build/reconciler.js");
/* harmony import */ var _renderer_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("../ink/build/renderer.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([yoga_layout__WEBPACK_IMPORTED_MODULE_6__, _dom_js__WEBPACK_IMPORTED_MODULE_9__, _reconciler_js__WEBPACK_IMPORTED_MODULE_12__, _renderer_js__WEBPACK_IMPORTED_MODULE_13__]);
([yoga_layout__WEBPACK_IMPORTED_MODULE_6__, _dom_js__WEBPACK_IMPORTED_MODULE_9__, _reconciler_js__WEBPACK_IMPORTED_MODULE_12__, _renderer_js__WEBPACK_IMPORTED_MODULE_13__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);


















const noop = () => { };
class Ink {
    options;
    log;
    throttledLog;
    isScreenReaderEnabled;
    // Ignore last render after unmounting a tree to prevent empty output before exit
    isUnmounted;
    lastOutput;
    lastOutputHeight;
    container;
    rootNode;
    // This variable is used only in debug mode to store full static output
    // so that it's rerendered every time, not just new static parts, like in non-debug mode
    fullStaticOutput;
    exitPromise;
    restoreConsole;
    unsubscribeResize;
    constructor(options) {
        (0,auto_bind__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .A)(this);
        this.options = options;
        this.rootNode = _dom_js__WEBPACK_IMPORTED_MODULE_9__/* .createNode */ .RM('ink-root');
        this.rootNode.onComputeLayout = this.calculateLayout;
        this.isScreenReaderEnabled =
            options.isScreenReaderEnabled ??
                node_process__WEBPACK_IMPORTED_MODULE_0__.env['INK_SCREEN_READER'] === 'true';
        const unthrottled = options.debug || this.isScreenReaderEnabled;
        this.rootNode.onRender = unthrottled
            ? this.onRender
            : (0,es_toolkit_compat__WEBPACK_IMPORTED_MODULE_15__/* .throttle */ .n)(this.onRender, 32, {
                leading: true,
                trailing: true,
            });
        this.rootNode.onImmediateRender = this.onRender;
        this.log = _log_update_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A.create(options.stdout);
        this.throttledLog = unthrottled
            ? this.log
            : (0,es_toolkit_compat__WEBPACK_IMPORTED_MODULE_15__/* .throttle */ .n)(this.log, undefined, {
                leading: true,
                trailing: true,
            });
        // Ignore last render after unmounting a tree to prevent empty output before exit
        this.isUnmounted = false;
        // Store last output to only rerender when needed
        this.lastOutput = '';
        this.lastOutputHeight = 0;
        // This variable is used only in debug mode to store full static output
        // so that it's rerendered every time, not just new static parts, like in non-debug mode
        this.fullStaticOutput = '';
        // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment
        this.container = _reconciler_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A.createContainer(this.rootNode, react_reconciler_constants_js__WEBPACK_IMPORTED_MODULE_3__.LegacyRoot, null, false, null, 'id', () => { }, () => { }, 
        // @ts-expect-error the types for `react-reconciler` are not up to date with the library.
        // See https://github.com/facebook/react/blob/c0464aedb16b1c970d717651bba8d1c66c578729/packages/react-reconciler/src/ReactFiberReconciler.js#L236-L259
        () => { }, () => { }, null);
        // Unmount when process exits
        this.unsubscribeExit = signal_exit__WEBPACK_IMPORTED_MODULE_4__(this.unmount, { alwaysLast: false });
        if (node_process__WEBPACK_IMPORTED_MODULE_0__.env['DEV'] === 'true') {
            _reconciler_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A.injectIntoDevTools({
                bundleType: 0,
                // Reporting React DOM's version, not Ink's
                // See https://github.com/facebook/react/issues/16666#issuecomment-532639905
                version: '16.13.1',
                rendererPackageName: 'ink',
            });
        }
        if (options.patchConsole) {
            this.patchConsole();
        }
        if (!is_in_ci__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .A) {
            options.stdout.on('resize', this.resized);
            this.unsubscribeResize = () => {
                options.stdout.off('resize', this.resized);
            };
        }
    }
    resized = () => {
        this.calculateLayout();
        this.onRender();
    };
    resolveExitPromise = () => { };
    rejectExitPromise = () => { };
    unsubscribeExit = () => { };
    calculateLayout = () => {
        // The 'columns' property can be undefined or 0 when not using a TTY.
        // In that case we fall back to 80.
        const terminalWidth = this.options.stdout.columns || 80;
        this.rootNode.yogaNode.setWidth(terminalWidth);
        this.rootNode.yogaNode.calculateLayout(undefined, undefined, yoga_layout__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Ay.DIRECTION_LTR);
    };
    onRender = () => {
        if (this.isUnmounted) {
            return;
        }
        const { output, outputHeight, staticOutput } = (0,_renderer_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A)(this.rootNode, this.isScreenReaderEnabled);
        // If <Static> output isn't empty, it means new children have been added to it
        const hasStaticOutput = staticOutput && staticOutput !== '\n';
        if (this.options.debug) {
            if (hasStaticOutput) {
                this.fullStaticOutput += staticOutput;
            }
            this.options.stdout.write(this.fullStaticOutput + output);
            return;
        }
        if (is_in_ci__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .A) {
            if (hasStaticOutput) {
                this.options.stdout.write(staticOutput);
            }
            this.lastOutput = output;
            this.lastOutputHeight = outputHeight;
            return;
        }
        if (this.isScreenReaderEnabled) {
            if (hasStaticOutput) {
                // We need to erase the main output before writing new static output
                const erase = this.lastOutputHeight > 0
                    ? ansi_escapes__WEBPACK_IMPORTED_MODULE_17__/* .eraseLines */ ._W(this.lastOutputHeight)
                    : '';
                this.options.stdout.write(erase + staticOutput);
                // After erasing, the last output is gone, so we should reset its height
                this.lastOutputHeight = 0;
            }
            if (output === this.lastOutput && !hasStaticOutput) {
                return;
            }
            const terminalWidth = this.options.stdout.columns || 80;
            const wrappedOutput = (0,wrap_ansi__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A)(output, terminalWidth, {
                trim: false,
                hard: true,
            });
            // If we haven't erased yet, do it now.
            if (hasStaticOutput) {
                this.options.stdout.write(wrappedOutput);
            }
            else {
                const erase = this.lastOutputHeight > 0
                    ? ansi_escapes__WEBPACK_IMPORTED_MODULE_17__/* .eraseLines */ ._W(this.lastOutputHeight)
                    : '';
                this.options.stdout.write(erase + wrappedOutput);
            }
            this.lastOutput = output;
            this.lastOutputHeight =
                wrappedOutput === '' ? 0 : wrappedOutput.split('\n').length;
            return;
        }
        if (hasStaticOutput) {
            this.fullStaticOutput += staticOutput;
        }
        if (hasStaticOutput || output !== this.lastOutput) {
            this.throttledLog(this.fullStaticOutput + output);
        }
        this.lastOutput = output;
        this.lastOutputHeight = outputHeight;
    };
    render(node) {
        const tree = (react__WEBPACK_IMPORTED_MODULE_2__.createElement(_components_AccessibilityContext_js__WEBPACK_IMPORTED_MODULE_7__/* .accessibilityContext */ .E.Provider, { value: { isScreenReaderEnabled: this.isScreenReaderEnabled } },
            react__WEBPACK_IMPORTED_MODULE_2__.createElement(_components_App_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A, { stdin: this.options.stdin, stdout: this.options.stdout, stderr: this.options.stderr, writeToStdout: this.writeToStdout, writeToStderr: this.writeToStderr, exitOnCtrlC: this.options.exitOnCtrlC, onExit: this.unmount }, node)));
        // @ts-expect-error the types for `react-reconciler` are not up to date with the library.
        // eslint-disable-next-line @typescript-eslint/no-unsafe-call
        _reconciler_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A.updateContainerSync(tree, this.container, null, noop);
        // @ts-expect-error the types for `react-reconciler` are not up to date with the library.
        // eslint-disable-next-line @typescript-eslint/no-unsafe-call
        _reconciler_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A.flushSyncWork();
    }
    writeToStdout(data) {
        if (this.isUnmounted) {
            return;
        }
        if (this.options.debug) {
            this.options.stdout.write(data + this.fullStaticOutput + this.lastOutput);
            return;
        }
        if (is_in_ci__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .A) {
            this.options.stdout.write(data);
            return;
        }
        this.log.clear();
        this.options.stdout.write(data);
        this.log(this.lastOutput);
    }
    writeToStderr(data) {
        if (this.isUnmounted) {
            return;
        }
        if (this.options.debug) {
            this.options.stderr.write(data);
            this.options.stdout.write(this.fullStaticOutput + this.lastOutput);
            return;
        }
        if (is_in_ci__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .A) {
            this.options.stderr.write(data);
            return;
        }
        this.log.clear();
        this.options.stderr.write(data);
        this.log(this.lastOutput);
    }
    // eslint-disable-next-line @typescript-eslint/ban-types
    unmount(error) {
        if (this.isUnmounted) {
            return;
        }
        this.calculateLayout();
        this.onRender();
        this.unsubscribeExit();
        if (typeof this.restoreConsole === 'function') {
            this.restoreConsole();
        }
        if (typeof this.unsubscribeResize === 'function') {
            this.unsubscribeResize();
        }
        // CIs don't handle erasing ansi escapes well, so it's better to
        // only render last frame of non-static output
        if (is_in_ci__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .A) {
            this.options.stdout.write(this.lastOutput + '\n');
        }
        else if (!this.options.debug) {
            this.log.done();
        }
        this.isUnmounted = true;
        // @ts-expect-error the types for `react-reconciler` are not up to date with the library.
        // eslint-disable-next-line @typescript-eslint/no-unsafe-call
        _reconciler_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A.updateContainerSync(null, this.container, null, noop);
        // @ts-expect-error the types for `react-reconciler` are not up to date with the library.
        // eslint-disable-next-line @typescript-eslint/no-unsafe-call
        _reconciler_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A.flushSyncWork();
        _instances_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A.delete(this.options.stdout);
        if (error instanceof Error) {
            this.rejectExitPromise(error);
        }
        else {
            this.resolveExitPromise();
        }
    }
    async waitUntilExit() {
        this.exitPromise ||= new Promise((resolve, reject) => {
            this.resolveExitPromise = resolve;
            this.rejectExitPromise = reject;
        });
        return this.exitPromise;
    }
    clear() {
        if (!is_in_ci__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .A && !this.options.debug) {
            this.log.clear();
        }
    }
    patchConsole() {
        if (this.options.debug) {
            return;
        }
        this.restoreConsole = (0,patch_console__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)((stream, data) => {
            if (stream === 'stdout') {
                this.writeToStdout(data);
            }
            if (stream === 'stderr') {
                const isReactMessage = data.startsWith('The above error occurred');
                if (!isReactMessage) {
                    this.writeToStderr(data);
                }
            }
        });
    }
}
//# sourceMappingURL=ink.js.map
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "../ink/build/instances.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// Store all instances of Ink (instance.js) to ensure that consecutive render() calls
// use the same instance of Ink and don't create a new one
//
// This map has to be stored in a separate file, because render.js creates instances,
// but instance.js should delete itself from the map on unmount
const instances = new WeakMap();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (instances);
//# sourceMappingURL=instances.js.map

/***/ }),

/***/ "../ink/build/log-update.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ansi_escapes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/ansi-escapes@7.0.0/node_modules/ansi-escapes/base.js");
/* harmony import */ var cli_cursor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/cli-cursor@4.0.0/node_modules/cli-cursor/index.js");


const create = (stream, { showCursor = false } = {}) => {
    let previousOutput = '';
    let hasHiddenCursor = false;
    const render = (str) => {
        if (!showCursor && !hasHiddenCursor) {
            cli_cursor__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.hide();
            hasHiddenCursor = true;
        }
        const output = str + '\n';
        if (output === previousOutput) {
            return;
        }
        const newLines = output.split('\n');
        const oldLines = previousOutput.split('\n');
        // Find the first line that differs
        let firstDifferentLine = -1;
        const minLength = Math.min(newLines.length, oldLines.length);
        for (let i = 0; i < minLength; i++) {
            if (newLines[i] !== oldLines[i]) {
                firstDifferentLine = i;
                break;
            }
        }
        // If all compared lines are the same but counts differ
        if (firstDifferentLine === -1 && newLines.length !== oldLines.length) {
            firstDifferentLine = minLength;
        }
        // If everything is identical, nothing to do
        if (firstDifferentLine === -1) {
            previousOutput = output;
            return;
        }
        const linesToErase = oldLines.length - firstDifferentLine;
        let outputToWrite = '';
        if (linesToErase > process.stdout.rows) {
            outputToWrite += ansi_escapes__WEBPACK_IMPORTED_MODULE_1__/* .clearTerminal */ .Ik;
            outputToWrite += newLines.join('\n');
        }
        else {
            if (linesToErase > 0) {
                outputToWrite += ansi_escapes__WEBPACK_IMPORTED_MODULE_1__/* .eraseLines */ ._W(linesToErase);
            }
            outputToWrite += newLines.slice(firstDifferentLine).join('\n');
        }
        stream.write(outputToWrite);
        previousOutput = output;
    };
    render.clear = () => {
        stream.write(ansi_escapes__WEBPACK_IMPORTED_MODULE_1__/* .eraseLines */ ._W(previousOutput.split('\n').length));
        previousOutput = '';
    };
    render.done = () => {
        previousOutput = '';
        if (!showCursor) {
            cli_cursor__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A.show();
            hasHiddenCursor = false;
        }
    };
    return render;
};
const logUpdate = { create };
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (logUpdate);
//# sourceMappingURL=log-update.js.map

/***/ }),

/***/ "../ink/build/measure-text.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var widest_line__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/widest-line@5.0.0/node_modules/widest-line/index.js");

const cache = new Map();
const measureText = (text) => {
    if (text.length === 0) {
        return {
            width: 0,
            height: 0,
        };
    }
    const cachedDimensions = cache.get(text);
    if (cachedDimensions) {
        return cachedDimensions;
    }
    const width = (0,widest_line__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)(text);
    const height = text.split('\n').length;
    const dimensions = { width, height };
    cache.set(text, dimensions);
    return dimensions;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (measureText);
//# sourceMappingURL=measure-text.js.map

/***/ }),

/***/ "../ink/build/output.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (/* binding */ Output)
/* harmony export */ });
/* harmony import */ var slice_ansi__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/slice-ansi@7.1.0/node_modules/slice-ansi/index.js");
/* harmony import */ var string_width__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../node_modules/.pnpm/string-width@8.1.0/node_modules/string-width/index.js");
/* harmony import */ var widest_line__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/widest-line@5.0.0/node_modules/widest-line/index.js");
/* harmony import */ var _alcalzone_ansi_tokenize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/@alcalzone+ansi-tokenize@0.2.0/node_modules/@alcalzone/ansi-tokenize/build/index.js");




class Output {
    width;
    height;
    operations = [];
    constructor(options) {
        const { width, height } = options;
        this.width = width;
        this.height = height;
    }
    write(x, y, text, options) {
        const { transformers } = options;
        if (!text) {
            return;
        }
        this.operations.push({
            type: 'write',
            x,
            y,
            text,
            transformers,
        });
    }
    clip(clip) {
        this.operations.push({
            type: 'clip',
            clip,
        });
    }
    unclip() {
        this.operations.push({
            type: 'unclip',
        });
    }
    get() {
        // Initialize output array with a specific set of rows, so that margin/padding at the bottom is preserved
        const output = [];
        for (let y = 0; y < this.height; y++) {
            const row = [];
            for (let x = 0; x < this.width; x++) {
                row.push({
                    type: 'char',
                    value: ' ',
                    fullWidth: false,
                    styles: [],
                });
            }
            output.push(row);
        }
        const clips = [];
        for (const operation of this.operations) {
            if (operation.type === 'clip') {
                clips.push(operation.clip);
            }
            if (operation.type === 'unclip') {
                clips.pop();
            }
            if (operation.type === 'write') {
                const { text, transformers } = operation;
                let { x, y } = operation;
                let lines = text.split('\n');
                const clip = clips.at(-1);
                if (clip) {
                    const clipHorizontally = typeof clip?.x1 === 'number' && typeof clip?.x2 === 'number';
                    const clipVertically = typeof clip?.y1 === 'number' && typeof clip?.y2 === 'number';
                    // If text is positioned outside of clipping area altogether,
                    // skip to the next operation to avoid unnecessary calculations
                    if (clipHorizontally) {
                        const width = (0,widest_line__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A)(text);
                        if (x + width < clip.x1 || x > clip.x2) {
                            continue;
                        }
                    }
                    if (clipVertically) {
                        const height = lines.length;
                        if (y + height < clip.y1 || y > clip.y2) {
                            continue;
                        }
                    }
                    if (clipHorizontally) {
                        lines = lines.map(line => {
                            const from = x < clip.x1 ? clip.x1 - x : 0;
                            const width = (0,string_width__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)(line);
                            const to = x + width > clip.x2 ? clip.x2 - x : width;
                            return (0,slice_ansi__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)(line, from, to);
                        });
                        if (x < clip.x1) {
                            x = clip.x1;
                        }
                    }
                    if (clipVertically) {
                        const from = y < clip.y1 ? clip.y1 - y : 0;
                        const height = lines.length;
                        const to = y + height > clip.y2 ? clip.y2 - y : height;
                        lines = lines.slice(from, to);
                        if (y < clip.y1) {
                            y = clip.y1;
                        }
                    }
                }
                let offsetY = 0;
                for (let [index, line] of lines.entries()) {
                    const currentLine = output[y + offsetY];
                    // Line can be missing if `text` is taller than height of pre-initialized `this.output`
                    if (!currentLine) {
                        continue;
                    }
                    for (const transformer of transformers) {
                        line = transformer(line, index);
                    }
                    const characters = (0,_alcalzone_ansi_tokenize__WEBPACK_IMPORTED_MODULE_1__/* .styledCharsFromTokens */ .P1)((0,_alcalzone_ansi_tokenize__WEBPACK_IMPORTED_MODULE_1__/* .tokenize */ .qw)(line));
                    let offsetX = x;
                    for (const character of characters) {
                        currentLine[offsetX] = character;
                        // Determine printed width using string-width to align with measurement
                        const characterWidth = Math.max(1, (0,string_width__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)(character.value));
                        // For multi-column characters, clear following cells to avoid stray spaces/artifacts
                        if (characterWidth > 1) {
                            for (let index = 1; index < characterWidth; index++) {
                                currentLine[offsetX + index] = {
                                    type: 'char',
                                    value: '',
                                    fullWidth: false,
                                    styles: character.styles,
                                };
                            }
                        }
                        offsetX += characterWidth;
                    }
                    offsetY++;
                }
            }
        }
        const generatedOutput = output
            .map(line => {
            // See https://github.com/vadimdemedes/ink/pull/564#issuecomment-1637022742
            const lineWithoutEmptyItems = line.filter(item => item !== undefined);
            return (0,_alcalzone_ansi_tokenize__WEBPACK_IMPORTED_MODULE_1__/* .styledCharsToString */ .b2)(lineWithoutEmptyItems).trimEnd();
        })
            .join('\n');
        return {
            output: generatedOutput,
            height: output.length,
        };
    }
}
//# sourceMappingURL=output.js.map

/***/ }),

/***/ "../ink/build/parse-keypress.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   f: () => (/* binding */ nonAlphanumericKeys)
/* harmony export */ });
/* harmony import */ var node_buffer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:buffer");
// Copied from https://github.com/enquirer/enquirer/blob/36785f3399a41cd61e9d28d1eb9c2fcd73d69b4c/lib/keypress.js

const metaKeyCodeRe = /^(?:\x1b)([a-zA-Z0-9])$/;
const fnKeyRe = /^(?:\x1b+)(O|N|\[|\[\[)(?:(\d+)(?:;(\d+))?([~^$])|(?:1;)?(\d+)?([a-zA-Z]))/;
const keyName = {
    /* xterm/gnome ESC O letter */
    OP: 'f1',
    OQ: 'f2',
    OR: 'f3',
    OS: 'f4',
    /* xterm/rxvt ESC [ number ~ */
    '[11~': 'f1',
    '[12~': 'f2',
    '[13~': 'f3',
    '[14~': 'f4',
    /* from Cygwin and used in libuv */
    '[[A': 'f1',
    '[[B': 'f2',
    '[[C': 'f3',
    '[[D': 'f4',
    '[[E': 'f5',
    /* common */
    '[15~': 'f5',
    '[17~': 'f6',
    '[18~': 'f7',
    '[19~': 'f8',
    '[20~': 'f9',
    '[21~': 'f10',
    '[23~': 'f11',
    '[24~': 'f12',
    /* xterm ESC [ letter */
    '[A': 'up',
    '[B': 'down',
    '[C': 'right',
    '[D': 'left',
    '[E': 'clear',
    '[F': 'end',
    '[H': 'home',
    /* xterm/gnome ESC O letter */
    OA: 'up',
    OB: 'down',
    OC: 'right',
    OD: 'left',
    OE: 'clear',
    OF: 'end',
    OH: 'home',
    /* xterm/rxvt ESC [ number ~ */
    '[1~': 'home',
    '[2~': 'insert',
    '[3~': 'delete',
    '[4~': 'end',
    '[5~': 'pageup',
    '[6~': 'pagedown',
    /* putty */
    '[[5~': 'pageup',
    '[[6~': 'pagedown',
    /* rxvt */
    '[7~': 'home',
    '[8~': 'end',
    /* rxvt keys with modifiers */
    '[a': 'up',
    '[b': 'down',
    '[c': 'right',
    '[d': 'left',
    '[e': 'clear',
    '[2$': 'insert',
    '[3$': 'delete',
    '[5$': 'pageup',
    '[6$': 'pagedown',
    '[7$': 'home',
    '[8$': 'end',
    Oa: 'up',
    Ob: 'down',
    Oc: 'right',
    Od: 'left',
    Oe: 'clear',
    '[2^': 'insert',
    '[3^': 'delete',
    '[5^': 'pageup',
    '[6^': 'pagedown',
    '[7^': 'home',
    '[8^': 'end',
    /* misc. */
    '[Z': 'tab',
};
const nonAlphanumericKeys = [...Object.values(keyName), 'backspace'];
const isShiftKey = (code) => {
    return [
        '[a',
        '[b',
        '[c',
        '[d',
        '[e',
        '[2$',
        '[3$',
        '[5$',
        '[6$',
        '[7$',
        '[8$',
        '[Z',
    ].includes(code);
};
const isCtrlKey = (code) => {
    return [
        'Oa',
        'Ob',
        'Oc',
        'Od',
        'Oe',
        '[2^',
        '[3^',
        '[5^',
        '[6^',
        '[7^',
        '[8^',
    ].includes(code);
};
const parseKeypress = (s = '') => {
    let parts;
    if (node_buffer__WEBPACK_IMPORTED_MODULE_0__.Buffer.isBuffer(s)) {
        if (s[0] > 127 && s[1] === undefined) {
            s[0] -= 128;
            s = '\x1b' + String(s);
        }
        else {
            s = String(s);
        }
    }
    else if (s !== undefined && typeof s !== 'string') {
        s = String(s);
    }
    else if (!s) {
        s = '';
    }
    const key = {
        name: '',
        ctrl: false,
        meta: false,
        shift: false,
        option: false,
        sequence: s,
        raw: s,
    };
    key.sequence = key.sequence || s || key.name;
    if (s === '\r') {
        // carriage return
        key.raw = undefined;
        key.name = 'return';
    }
    else if (s === '\n') {
        // enter, should have been called linefeed
        key.name = 'enter';
    }
    else if (s === '\t') {
        // tab
        key.name = 'tab';
    }
    else if (s === '\b' || s === '\x1b\b') {
        // backspace or ctrl+h
        key.name = 'backspace';
        key.meta = s.charAt(0) === '\x1b';
    }
    else if (s === '\x7f' || s === '\x1b\x7f') {
        // TODO(vadimdemedes): `enquirer` detects delete key as backspace, but I had to split them up to avoid breaking changes in Ink. Merge them back together in the next major version.
        // delete
        key.name = 'delete';
        key.meta = s.charAt(0) === '\x1b';
    }
    else if (s === '\x1b' || s === '\x1b\x1b') {
        // escape key
        key.name = 'escape';
        key.meta = s.length === 2;
    }
    else if (s === ' ' || s === '\x1b ') {
        key.name = 'space';
        key.meta = s.length === 2;
    }
    else if (s.length === 1 && s <= '\x1a') {
        // ctrl+letter
        key.name = String.fromCharCode(s.charCodeAt(0) + 'a'.charCodeAt(0) - 1);
        key.ctrl = true;
    }
    else if (s.length === 1 && s >= '0' && s <= '9') {
        // number
        key.name = 'number';
    }
    else if (s.length === 1 && s >= 'a' && s <= 'z') {
        // lowercase letter
        key.name = s;
    }
    else if (s.length === 1 && s >= 'A' && s <= 'Z') {
        // shift+letter
        key.name = s.toLowerCase();
        key.shift = true;
    }
    else if ((parts = metaKeyCodeRe.exec(s))) {
        // meta+character key
        key.meta = true;
        key.shift = /^[A-Z]$/.test(parts[1]);
    }
    else if ((parts = fnKeyRe.exec(s))) {
        const segs = [...s];
        if (segs[0] === '\u001b' && segs[1] === '\u001b') {
            key.option = true;
        }
        // ansi escape sequence
        // reassemble the key code leaving out leading \x1b's,
        // the modifier key bitflag and any meaningless "1;" sequence
        const code = [parts[1], parts[2], parts[4], parts[6]]
            .filter(Boolean)
            .join('');
        const modifier = (parts[3] || parts[5] || 1) - 1;
        // Parse the key modifier
        key.ctrl = !!(modifier & 4);
        key.meta = !!(modifier & 10);
        key.shift = !!(modifier & 1);
        key.code = code;
        key.name = keyName[code];
        key.shift = isShiftKey(code) || key.shift;
        key.ctrl = isCtrlKey(code) || key.ctrl;
    }
    return key;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (parseKeypress);
//# sourceMappingURL=parse-keypress.js.map

/***/ }),

/***/ "../ink/build/reconciler.js":
/***/ ((__webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(__webpack_module__, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var node_process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:process");
/* harmony import */ var react_reconciler__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/react-reconciler@0.32.0_react@19.1.0/node_modules/react-reconciler/index.js");
/* harmony import */ var react_reconciler_constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react-reconciler@0.32.0_react@19.1.0/node_modules/react-reconciler/constants.js");
/* harmony import */ var yoga_layout__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../node_modules/.pnpm/yoga-layout@3.2.1/node_modules/yoga-layout/dist/src/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
/* harmony import */ var _dom_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../ink/build/dom.js");
/* harmony import */ var _styles_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../ink/build/styles.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([yoga_layout__WEBPACK_IMPORTED_MODULE_3__, _dom_js__WEBPACK_IMPORTED_MODULE_5__, _styles_js__WEBPACK_IMPORTED_MODULE_6__]);
([yoga_layout__WEBPACK_IMPORTED_MODULE_3__, _dom_js__WEBPACK_IMPORTED_MODULE_5__, _styles_js__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







// We need to conditionally perform devtools connection to avoid
// accidentally breaking other third-party code.
// See https://github.com/vadimdemedes/ink/issues/384
if (node_process__WEBPACK_IMPORTED_MODULE_0__.env['DEV'] === 'true') {
    try {
        await Promise.all(/* import() */[__webpack_require__.e(3448), __webpack_require__.e(5357)]).then(__webpack_require__.bind(__webpack_require__, "../ink/build/devtools.js"));
    }
    catch (error) {
        if (error.code === 'ERR_MODULE_NOT_FOUND') {
            console.warn(`
The environment variable DEV is set to true, so Ink tried to import \`react-devtools-core\`,
but this failed as it was not installed. Debugging with React Devtools requires it.

To install use this command:

$ npm install --save-dev react-devtools-core
				`.trim() + '\n');
        }
        else {
            // eslint-disable-next-line @typescript-eslint/only-throw-error
            throw error;
        }
    }
}
const diff = (before, after) => {
    if (before === after) {
        return;
    }
    if (!before) {
        return after;
    }
    const changed = {};
    let isChanged = false;
    for (const key of Object.keys(before)) {
        const isDeleted = after ? !Object.hasOwn(after, key) : true;
        if (isDeleted) {
            changed[key] = undefined;
            isChanged = true;
        }
    }
    if (after) {
        for (const key of Object.keys(after)) {
            if (after[key] !== before[key]) {
                changed[key] = after[key];
                isChanged = true;
            }
        }
    }
    return isChanged ? changed : undefined;
};
const cleanupYogaNode = (node) => {
    node?.unsetMeasureFunc();
    node?.freeRecursive();
};
let currentUpdatePriority = react_reconciler_constants_js__WEBPACK_IMPORTED_MODULE_2__.NoEventPriority;
let currentRootNode;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (react_reconciler__WEBPACK_IMPORTED_MODULE_1__({
    getRootHostContext: () => ({
        isInsideText: false,
    }),
    prepareForCommit: () => null,
    preparePortalMount: () => null,
    clearContainer: () => false,
    resetAfterCommit(rootNode) {
        if (typeof rootNode.onComputeLayout === 'function') {
            rootNode.onComputeLayout();
        }
        // Since renders are throttled at the instance level and <Static> component children
        // are rendered only once and then get deleted, we need an escape hatch to
        // trigger an immediate render to ensure <Static> children are written to output before they get erased
        if (rootNode.isStaticDirty) {
            rootNode.isStaticDirty = false;
            if (typeof rootNode.onImmediateRender === 'function') {
                rootNode.onImmediateRender();
            }
            return;
        }
        if (typeof rootNode.onRender === 'function') {
            rootNode.onRender();
        }
    },
    getChildHostContext(parentHostContext, type) {
        const previousIsInsideText = parentHostContext.isInsideText;
        const isInsideText = type === 'ink-text' || type === 'ink-virtual-text';
        if (previousIsInsideText === isInsideText) {
            return parentHostContext;
        }
        return { isInsideText };
    },
    shouldSetTextContent: () => false,
    createInstance(originalType, newProps, rootNode, hostContext) {
        if (hostContext.isInsideText && originalType === 'ink-box') {
            throw new Error(`<Box> can’t be nested inside <Text> component`);
        }
        const type = originalType === 'ink-text' && hostContext.isInsideText
            ? 'ink-virtual-text'
            : originalType;
        const node = (0,_dom_js__WEBPACK_IMPORTED_MODULE_5__/* .createNode */ .RM)(type);
        for (const [key, value] of Object.entries(newProps)) {
            if (key === 'children') {
                continue;
            }
            if (key === 'style') {
                (0,_dom_js__WEBPACK_IMPORTED_MODULE_5__/* .setStyle */ .eC)(node, value);
                if (node.yogaNode) {
                    (0,_styles_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A)(node.yogaNode, value);
                }
                continue;
            }
            if (key === 'internal_transform') {
                node.internal_transform = value;
                continue;
            }
            if (key === 'internal_static') {
                currentRootNode = rootNode;
                node.internal_static = true;
                rootNode.isStaticDirty = true;
                // Save reference to <Static> node to skip traversal of entire
                // node tree to find it
                rootNode.staticNode = node;
                continue;
            }
            (0,_dom_js__WEBPACK_IMPORTED_MODULE_5__/* .setAttribute */ .Bq)(node, key, value);
        }
        return node;
    },
    createTextInstance(text, _root, hostContext) {
        if (!hostContext.isInsideText) {
            throw new Error(`Text string "${text}" must be rendered inside <Text> component`);
        }
        return (0,_dom_js__WEBPACK_IMPORTED_MODULE_5__/* .createTextNode */ .Mq)(text);
    },
    resetTextContent() { },
    hideTextInstance(node) {
        (0,_dom_js__WEBPACK_IMPORTED_MODULE_5__/* .setTextNodeValue */ .x6)(node, '');
    },
    unhideTextInstance(node, text) {
        (0,_dom_js__WEBPACK_IMPORTED_MODULE_5__/* .setTextNodeValue */ .x6)(node, text);
    },
    getPublicInstance: instance => instance,
    hideInstance(node) {
        node.yogaNode?.setDisplay(yoga_layout__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Ay.DISPLAY_NONE);
    },
    unhideInstance(node) {
        node.yogaNode?.setDisplay(yoga_layout__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Ay.DISPLAY_FLEX);
    },
    appendInitialChild: _dom_js__WEBPACK_IMPORTED_MODULE_5__/* .appendChildNode */ .V6,
    appendChild: _dom_js__WEBPACK_IMPORTED_MODULE_5__/* .appendChildNode */ .V6,
    insertBefore: _dom_js__WEBPACK_IMPORTED_MODULE_5__/* .insertBeforeNode */ .bC,
    finalizeInitialChildren() {
        return false;
    },
    isPrimaryRenderer: true,
    supportsMutation: true,
    supportsPersistence: false,
    supportsHydration: false,
    scheduleTimeout: setTimeout,
    cancelTimeout: clearTimeout,
    noTimeout: -1,
    beforeActiveInstanceBlur() { },
    afterActiveInstanceBlur() { },
    detachDeletedInstance() { },
    getInstanceFromNode: () => null,
    prepareScopeUpdate() { },
    getInstanceFromScope: () => null,
    appendChildToContainer: _dom_js__WEBPACK_IMPORTED_MODULE_5__/* .appendChildNode */ .V6,
    insertInContainerBefore: _dom_js__WEBPACK_IMPORTED_MODULE_5__/* .insertBeforeNode */ .bC,
    removeChildFromContainer(node, removeNode) {
        (0,_dom_js__WEBPACK_IMPORTED_MODULE_5__/* .removeChildNode */ .V8)(node, removeNode);
        cleanupYogaNode(removeNode.yogaNode);
    },
    commitUpdate(node, _type, oldProps, newProps) {
        if (currentRootNode && node.internal_static) {
            currentRootNode.isStaticDirty = true;
        }
        const props = diff(oldProps, newProps);
        const style = diff(oldProps['style'], newProps['style']);
        if (!props && !style) {
            return;
        }
        if (props) {
            for (const [key, value] of Object.entries(props)) {
                if (key === 'style') {
                    (0,_dom_js__WEBPACK_IMPORTED_MODULE_5__/* .setStyle */ .eC)(node, value);
                    continue;
                }
                if (key === 'internal_transform') {
                    node.internal_transform = value;
                    continue;
                }
                if (key === 'internal_static') {
                    node.internal_static = true;
                    continue;
                }
                (0,_dom_js__WEBPACK_IMPORTED_MODULE_5__/* .setAttribute */ .Bq)(node, key, value);
            }
        }
        if (style && node.yogaNode) {
            (0,_styles_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A)(node.yogaNode, style);
        }
    },
    commitTextUpdate(node, _oldText, newText) {
        (0,_dom_js__WEBPACK_IMPORTED_MODULE_5__/* .setTextNodeValue */ .x6)(node, newText);
    },
    removeChild(node, removeNode) {
        (0,_dom_js__WEBPACK_IMPORTED_MODULE_5__/* .removeChildNode */ .V8)(node, removeNode);
        cleanupYogaNode(removeNode.yogaNode);
    },
    setCurrentUpdatePriority(newPriority) {
        currentUpdatePriority = newPriority;
    },
    getCurrentUpdatePriority: () => currentUpdatePriority,
    resolveUpdatePriority() {
        if (currentUpdatePriority !== react_reconciler_constants_js__WEBPACK_IMPORTED_MODULE_2__.NoEventPriority) {
            return currentUpdatePriority;
        }
        return react_reconciler_constants_js__WEBPACK_IMPORTED_MODULE_2__.DefaultEventPriority;
    },
    maySuspendCommit() {
        return false;
    },
    // eslint-disable-next-line @typescript-eslint/naming-convention
    NotPendingTransition: undefined,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    HostTransitionContext: (0,react__WEBPACK_IMPORTED_MODULE_4__.createContext)(null),
    resetFormInstance() { },
    requestPostPaintCallback() { },
    shouldAttemptEagerTransition() {
        return false;
    },
    trackSchedulerEvent() { },
    resolveEventType() {
        return null;
    },
    resolveEventTimeStamp() {
        return -1.1;
    },
    preloadInstance() {
        return true;
    },
    startSuspendingCommit() { },
    suspendInstance() { },
    waitForCommitToBeReady() {
        return null;
    },
}));
//# sourceMappingURL=reconciler.js.map
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } }, 1);

/***/ }),

/***/ "../ink/build/render-background.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _colorize_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../ink/build/colorize.js");

const renderBackground = (x, y, node, output) => {
    if (!node.style.backgroundColor) {
        return;
    }
    const width = node.yogaNode.getComputedWidth();
    const height = node.yogaNode.getComputedHeight();
    // Calculate the actual content area considering borders
    const leftBorderWidth = node.style.borderStyle && node.style.borderLeft !== false ? 1 : 0;
    const rightBorderWidth = node.style.borderStyle && node.style.borderRight !== false ? 1 : 0;
    const topBorderHeight = node.style.borderStyle && node.style.borderTop !== false ? 1 : 0;
    const bottomBorderHeight = node.style.borderStyle && node.style.borderBottom !== false ? 1 : 0;
    const contentWidth = width - leftBorderWidth - rightBorderWidth;
    const contentHeight = height - topBorderHeight - bottomBorderHeight;
    if (!(contentWidth > 0 && contentHeight > 0)) {
        return;
    }
    // Create background fill for each row
    const backgroundLine = (0,_colorize_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)(' '.repeat(contentWidth), node.style.backgroundColor, 'background');
    for (let row = 0; row < contentHeight; row++) {
        output.write(x + leftBorderWidth, y + topBorderHeight + row, backgroundLine, { transformers: [] });
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (renderBackground);
//# sourceMappingURL=render-background.js.map

/***/ }),

/***/ "../ink/build/render-border.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var cli_boxes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/cli-boxes@3.0.0/node_modules/cli-boxes/index.js");
/* harmony import */ var chalk__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/chalk@5.6.0/node_modules/chalk/source/index.js");
/* harmony import */ var _colorize_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/colorize.js");



const renderBorder = (x, y, node, output) => {
    if (node.style.borderStyle) {
        const width = node.yogaNode.getComputedWidth();
        const height = node.yogaNode.getComputedHeight();
        const box = typeof node.style.borderStyle === 'string'
            ? cli_boxes__WEBPACK_IMPORTED_MODULE_0__[node.style.borderStyle]
            : node.style.borderStyle;
        const topBorderColor = node.style.borderTopColor ?? node.style.borderColor;
        const bottomBorderColor = node.style.borderBottomColor ?? node.style.borderColor;
        const leftBorderColor = node.style.borderLeftColor ?? node.style.borderColor;
        const rightBorderColor = node.style.borderRightColor ?? node.style.borderColor;
        const dimTopBorderColor = node.style.borderTopDimColor ?? node.style.borderDimColor;
        const dimBottomBorderColor = node.style.borderBottomDimColor ?? node.style.borderDimColor;
        const dimLeftBorderColor = node.style.borderLeftDimColor ?? node.style.borderDimColor;
        const dimRightBorderColor = node.style.borderRightDimColor ?? node.style.borderDimColor;
        const showTopBorder = node.style.borderTop !== false;
        const showBottomBorder = node.style.borderBottom !== false;
        const showLeftBorder = node.style.borderLeft !== false;
        const showRightBorder = node.style.borderRight !== false;
        const contentWidth = width - (showLeftBorder ? 1 : 0) - (showRightBorder ? 1 : 0);
        let topBorder = showTopBorder
            ? (0,_colorize_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)((showLeftBorder ? box.topLeft : '') +
                box.top.repeat(contentWidth) +
                (showRightBorder ? box.topRight : ''), topBorderColor, 'foreground')
            : undefined;
        if (showTopBorder && dimTopBorderColor) {
            topBorder = chalk__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Ay.dim(topBorder);
        }
        let verticalBorderHeight = height;
        if (showTopBorder) {
            verticalBorderHeight -= 1;
        }
        if (showBottomBorder) {
            verticalBorderHeight -= 1;
        }
        let leftBorder = ((0,_colorize_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)(box.left, leftBorderColor, 'foreground') + '\n').repeat(verticalBorderHeight);
        if (dimLeftBorderColor) {
            leftBorder = chalk__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Ay.dim(leftBorder);
        }
        let rightBorder = ((0,_colorize_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)(box.right, rightBorderColor, 'foreground') + '\n').repeat(verticalBorderHeight);
        if (dimRightBorderColor) {
            rightBorder = chalk__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Ay.dim(rightBorder);
        }
        let bottomBorder = showBottomBorder
            ? (0,_colorize_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)((showLeftBorder ? box.bottomLeft : '') +
                box.bottom.repeat(contentWidth) +
                (showRightBorder ? box.bottomRight : ''), bottomBorderColor, 'foreground')
            : undefined;
        if (showBottomBorder && dimBottomBorderColor) {
            bottomBorder = chalk__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Ay.dim(bottomBorder);
        }
        const offsetY = showTopBorder ? 1 : 0;
        if (topBorder) {
            output.write(x, y, topBorder, { transformers: [] });
        }
        if (showLeftBorder) {
            output.write(x, y + offsetY, leftBorder, { transformers: [] });
        }
        if (showRightBorder) {
            output.write(x + width - 1, y + offsetY, rightBorder, {
                transformers: [],
            });
        }
        if (bottomBorder) {
            output.write(x, y + height - 1, bottomBorder, { transformers: [] });
        }
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (renderBorder);
//# sourceMappingURL=render-border.js.map

/***/ }),

/***/ "../ink/build/render-node-to-output.js":
/***/ ((__webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(__webpack_module__, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   K: () => (/* binding */ renderNodeToScreenReaderOutput)
/* harmony export */ });
/* harmony import */ var widest_line__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../node_modules/.pnpm/widest-line@5.0.0/node_modules/widest-line/index.js");
/* harmony import */ var indent_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../node_modules/.pnpm/indent-string@5.0.0/node_modules/indent-string/index.js");
/* harmony import */ var yoga_layout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/yoga-layout@3.2.1/node_modules/yoga-layout/dist/src/index.js");
/* harmony import */ var _wrap_text_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/wrap-text.js");
/* harmony import */ var _get_max_width_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../ink/build/get-max-width.js");
/* harmony import */ var _squash_text_nodes_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../ink/build/squash-text-nodes.js");
/* harmony import */ var _render_border_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../ink/build/render-border.js");
/* harmony import */ var _render_background_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../ink/build/render-background.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([yoga_layout__WEBPACK_IMPORTED_MODULE_0__, _get_max_width_js__WEBPACK_IMPORTED_MODULE_2__]);
([yoga_layout__WEBPACK_IMPORTED_MODULE_0__, _get_max_width_js__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








// If parent container is `<Box>`, text nodes will be treated as separate nodes in
// the tree and will have their own coordinates in the layout.
// To ensure text nodes are aligned correctly, take X and Y of the first text node
// and use it as offset for the rest of the nodes
// Only first node is taken into account, because other text nodes can't have margin or padding,
// so their coordinates will be relative to the first node anyway
const applyPaddingToText = (node, text) => {
    const yogaNode = node.childNodes[0]?.yogaNode;
    if (yogaNode) {
        const offsetX = yogaNode.getComputedLeft();
        const offsetY = yogaNode.getComputedTop();
        text = '\n'.repeat(offsetY) + (0,indent_string__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)(text, offsetX);
    }
    return text;
};
const renderNodeToScreenReaderOutput = (node, options = {}) => {
    if (options.skipStaticElements && node.internal_static) {
        return '';
    }
    if (node.yogaNode?.getDisplay() === yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.DISPLAY_NONE) {
        return '';
    }
    let output = '';
    if (node.nodeName === 'ink-text') {
        output = (0,_squash_text_nodes_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A)(node);
    }
    else if (node.nodeName === 'ink-box' || node.nodeName === 'ink-root') {
        const separator = node.style.flexDirection === 'row' ||
            node.style.flexDirection === 'row-reverse'
            ? ' '
            : '\n';
        const childNodes = node.style.flexDirection === 'row-reverse' ||
            node.style.flexDirection === 'column-reverse'
            ? [...node.childNodes].reverse()
            : [...node.childNodes];
        output = childNodes
            .map(childNode => {
            const screenReaderOutput = renderNodeToScreenReaderOutput(childNode, {
                parentRole: node.internal_accessibility?.role,
                skipStaticElements: options.skipStaticElements,
            });
            // When a text node contains multiple lines, it's still a single text node.
            // We need to split it into lines and then join them with the separator.
            return screenReaderOutput.split('\n').join(separator);
        })
            .filter(Boolean)
            .join(separator);
    }
    if (node.internal_accessibility) {
        const { role, state } = node.internal_accessibility;
        if (state) {
            const stateKeys = Object.keys(state);
            const stateDescription = stateKeys.filter(key => state[key]).join(', ');
            if (stateDescription) {
                output = `(${stateDescription}) ${output}`;
            }
        }
        if (role && role !== options.parentRole) {
            output = `${role}: ${output}`;
        }
    }
    return output;
};
// After nodes are laid out, render each to output object, which later gets rendered to terminal
const renderNodeToOutput = (node, output, options) => {
    const { offsetX = 0, offsetY = 0, transformers = [], skipStaticElements, } = options;
    if (skipStaticElements && node.internal_static) {
        return;
    }
    const { yogaNode } = node;
    if (yogaNode) {
        if (yogaNode.getDisplay() === yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.DISPLAY_NONE) {
            return;
        }
        // Left and top positions in Yoga are relative to their parent node
        const x = offsetX + yogaNode.getComputedLeft();
        const y = offsetY + yogaNode.getComputedTop();
        // Transformers are functions that transform final text output of each component
        // See Output class for logic that applies transformers
        let newTransformers = transformers;
        if (typeof node.internal_transform === 'function') {
            newTransformers = [node.internal_transform, ...transformers];
        }
        if (node.nodeName === 'ink-text') {
            let text = (0,_squash_text_nodes_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A)(node);
            if (text.length > 0) {
                const textWrap = node.style.textWrap ?? 'wrap';
                // Skip wrapping if no-wrap is specified
                if (textWrap !== 'no-wrap') {
                    const currentWidth = (0,widest_line__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A)(text);
                    const maxWidth = (0,_get_max_width_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A)(yogaNode);
                    if (currentWidth > maxWidth) {
                        text = (0,_wrap_text_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)(text, maxWidth, textWrap);
                    }
                }
                text = applyPaddingToText(node, text);
                output.write(x, y, text, { transformers: newTransformers });
            }
            return;
        }
        let clipped = false;
        if (node.nodeName === 'ink-box') {
            (0,_render_background_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A)(x, y, node, output);
            (0,_render_border_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)(x, y, node, output);
            const clipHorizontally = node.style.overflowX === 'hidden' || node.style.overflow === 'hidden';
            const clipVertically = node.style.overflowY === 'hidden' || node.style.overflow === 'hidden';
            if (clipHorizontally || clipVertically) {
                const x1 = clipHorizontally
                    ? x + yogaNode.getComputedBorder(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_LEFT)
                    : undefined;
                const x2 = clipHorizontally
                    ? x +
                        yogaNode.getComputedWidth() -
                        yogaNode.getComputedBorder(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_RIGHT)
                    : undefined;
                const y1 = clipVertically
                    ? y + yogaNode.getComputedBorder(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_TOP)
                    : undefined;
                const y2 = clipVertically
                    ? y +
                        yogaNode.getComputedHeight() -
                        yogaNode.getComputedBorder(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_BOTTOM)
                    : undefined;
                output.clip({ x1, x2, y1, y2 });
                clipped = true;
            }
        }
        if (node.nodeName === 'ink-root' || node.nodeName === 'ink-box') {
            for (const childNode of node.childNodes) {
                renderNodeToOutput(childNode, output, {
                    offsetX: x,
                    offsetY: y,
                    transformers: newTransformers,
                    skipStaticElements,
                });
            }
            if (clipped) {
                output.unclip();
            }
        }
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (renderNodeToOutput);
//# sourceMappingURL=render-node-to-output.js.map
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "../ink/build/render.js":
/***/ ((__webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(__webpack_module__, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var node_stream__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:stream");
/* harmony import */ var node_process__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("node:process");
/* harmony import */ var _ink_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../ink/build/ink.js");
/* harmony import */ var _instances_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../ink/build/instances.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_ink_js__WEBPACK_IMPORTED_MODULE_2__]);
_ink_js__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




/**
 * Mount a component and render the output.
 */
const render = (node, options) => {
    const inkOptions = {
        stdout: node_process__WEBPACK_IMPORTED_MODULE_1__.stdout,
        stdin: node_process__WEBPACK_IMPORTED_MODULE_1__.stdin,
        stderr: node_process__WEBPACK_IMPORTED_MODULE_1__.stderr,
        debug: false,
        exitOnCtrlC: true,
        patchConsole: true,
        ...getOptions(options),
    };
    const instance = getInstance(inkOptions.stdout, () => new _ink_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A(inkOptions));
    instance.render(node);
    return {
        rerender: instance.render,
        unmount() {
            instance.unmount();
        },
        waitUntilExit: instance.waitUntilExit,
        cleanup: () => _instances_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.delete(inkOptions.stdout),
        clear: instance.clear,
    };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (render);
const getOptions = (stdout = {}) => {
    if (stdout instanceof node_stream__WEBPACK_IMPORTED_MODULE_0__.Stream) {
        return {
            stdout,
            stdin: node_process__WEBPACK_IMPORTED_MODULE_1__.stdin,
        };
    }
    return stdout;
};
const getInstance = (stdout, createInstance) => {
    let instance = _instances_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.get(stdout);
    if (!instance) {
        instance = createInstance();
        _instances_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A.set(stdout, instance);
    }
    return instance;
};
//# sourceMappingURL=render.js.map
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "../ink/build/renderer.js":
/***/ ((__webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(__webpack_module__, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _render_node_to_output_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../ink/build/render-node-to-output.js");
/* harmony import */ var _output_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/output.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_render_node_to_output_js__WEBPACK_IMPORTED_MODULE_0__]);
_render_node_to_output_js__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const renderer = (node, isScreenReaderEnabled) => {
    if (node.yogaNode) {
        if (isScreenReaderEnabled) {
            const output = (0,_render_node_to_output_js__WEBPACK_IMPORTED_MODULE_0__/* .renderNodeToScreenReaderOutput */ .K)(node, {
                skipStaticElements: true,
            });
            const outputHeight = output === '' ? 0 : output.split('\n').length;
            let staticOutput = '';
            if (node.staticNode) {
                staticOutput = (0,_render_node_to_output_js__WEBPACK_IMPORTED_MODULE_0__/* .renderNodeToScreenReaderOutput */ .K)(node.staticNode, {
                    skipStaticElements: false,
                });
            }
            return {
                output,
                outputHeight,
                staticOutput: staticOutput ? `${staticOutput}\n` : '',
            };
        }
        const output = new _output_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A({
            width: node.yogaNode.getComputedWidth(),
            height: node.yogaNode.getComputedHeight(),
        });
        (0,_render_node_to_output_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)(node, output, {
            skipStaticElements: true,
        });
        let staticOutput;
        if (node.staticNode?.yogaNode) {
            staticOutput = new _output_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A({
                width: node.staticNode.yogaNode.getComputedWidth(),
                height: node.staticNode.yogaNode.getComputedHeight(),
            });
            (0,_render_node_to_output_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)(node.staticNode, staticOutput, {
                skipStaticElements: false,
            });
        }
        const { output: generatedOutput, height: outputHeight } = output.get();
        return {
            output: generatedOutput,
            outputHeight,
            // Newline at the end is needed, because static output doesn't have one, so
            // interactive output will override last line of static output
            staticOutput: staticOutput ? `${staticOutput.get().output}\n` : '',
        };
    }
    return {
        output: '',
        outputHeight: 0,
        staticOutput: '',
    };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (renderer);
//# sourceMappingURL=renderer.js.map
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "../ink/build/squash-text-nodes.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// Squashing text nodes allows to combine multiple text nodes into one and write
// to `Output` instance only once. For example, <Text>hello{' '}world</Text>
// is actually 3 text nodes, which would result 3 writes to `Output`.
//
// Also, this is necessary for libraries like ink-link (https://github.com/sindresorhus/ink-link),
// which need to wrap all children at once, instead of wrapping 3 text nodes separately.
const squashTextNodes = (node) => {
    let text = '';
    for (let index = 0; index < node.childNodes.length; index++) {
        const childNode = node.childNodes[index];
        if (childNode === undefined) {
            continue;
        }
        let nodeText = '';
        if (childNode.nodeName === '#text') {
            nodeText = childNode.nodeValue;
        }
        else {
            if (childNode.nodeName === 'ink-text' ||
                childNode.nodeName === 'ink-virtual-text') {
                nodeText = squashTextNodes(childNode);
            }
            // Since these text nodes are being concatenated, `Output` instance won't be able to
            // apply children transform, so we have to do it manually here for each text node
            if (nodeText.length > 0 &&
                typeof childNode.internal_transform === 'function') {
                nodeText = childNode.internal_transform(nodeText, index);
            }
        }
        text += nodeText;
    }
    return text;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (squashTextNodes);
//# sourceMappingURL=squash-text-nodes.js.map

/***/ }),

/***/ "../ink/build/styles.js":
/***/ ((__webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(__webpack_module__, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var yoga_layout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/yoga-layout@3.2.1/node_modules/yoga-layout/dist/src/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([yoga_layout__WEBPACK_IMPORTED_MODULE_0__]);
yoga_layout__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

const applyPositionStyles = (node, style) => {
    if ('position' in style) {
        node.setPositionType(style.position === 'absolute'
            ? yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.POSITION_TYPE_ABSOLUTE
            : yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.POSITION_TYPE_RELATIVE);
    }
};
const applyMarginStyles = (node, style) => {
    if ('margin' in style) {
        node.setMargin(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_ALL, style.margin ?? 0);
    }
    if ('marginX' in style) {
        node.setMargin(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_HORIZONTAL, style.marginX ?? 0);
    }
    if ('marginY' in style) {
        node.setMargin(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_VERTICAL, style.marginY ?? 0);
    }
    if ('marginLeft' in style) {
        node.setMargin(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_START, style.marginLeft || 0);
    }
    if ('marginRight' in style) {
        node.setMargin(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_END, style.marginRight || 0);
    }
    if ('marginTop' in style) {
        node.setMargin(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_TOP, style.marginTop || 0);
    }
    if ('marginBottom' in style) {
        node.setMargin(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_BOTTOM, style.marginBottom || 0);
    }
};
const applyPaddingStyles = (node, style) => {
    if ('padding' in style) {
        node.setPadding(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_ALL, style.padding ?? 0);
    }
    if ('paddingX' in style) {
        node.setPadding(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_HORIZONTAL, style.paddingX ?? 0);
    }
    if ('paddingY' in style) {
        node.setPadding(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_VERTICAL, style.paddingY ?? 0);
    }
    if ('paddingLeft' in style) {
        node.setPadding(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_LEFT, style.paddingLeft || 0);
    }
    if ('paddingRight' in style) {
        node.setPadding(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_RIGHT, style.paddingRight || 0);
    }
    if ('paddingTop' in style) {
        node.setPadding(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_TOP, style.paddingTop || 0);
    }
    if ('paddingBottom' in style) {
        node.setPadding(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_BOTTOM, style.paddingBottom || 0);
    }
};
const applyFlexStyles = (node, style) => {
    if ('flexGrow' in style) {
        node.setFlexGrow(style.flexGrow ?? 0);
    }
    if ('flexShrink' in style) {
        node.setFlexShrink(typeof style.flexShrink === 'number' ? style.flexShrink : 1);
    }
    if ('flexWrap' in style) {
        if (style.flexWrap === 'nowrap') {
            node.setFlexWrap(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.WRAP_NO_WRAP);
        }
        if (style.flexWrap === 'wrap') {
            node.setFlexWrap(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.WRAP_WRAP);
        }
        if (style.flexWrap === 'wrap-reverse') {
            node.setFlexWrap(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.WRAP_WRAP_REVERSE);
        }
    }
    if ('flexDirection' in style) {
        if (style.flexDirection === 'row') {
            node.setFlexDirection(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.FLEX_DIRECTION_ROW);
        }
        if (style.flexDirection === 'row-reverse') {
            node.setFlexDirection(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.FLEX_DIRECTION_ROW_REVERSE);
        }
        if (style.flexDirection === 'column') {
            node.setFlexDirection(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.FLEX_DIRECTION_COLUMN);
        }
        if (style.flexDirection === 'column-reverse') {
            node.setFlexDirection(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.FLEX_DIRECTION_COLUMN_REVERSE);
        }
    }
    if ('flexBasis' in style) {
        if (typeof style.flexBasis === 'number') {
            node.setFlexBasis(style.flexBasis);
        }
        else if (typeof style.flexBasis === 'string') {
            node.setFlexBasisPercent(Number.parseInt(style.flexBasis, 10));
        }
        else {
            // This should be replaced with node.setFlexBasisAuto() when new Yoga release is out
            node.setFlexBasis(Number.NaN);
        }
    }
    if ('alignItems' in style) {
        if (style.alignItems === 'stretch' || !style.alignItems) {
            node.setAlignItems(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.ALIGN_STRETCH);
        }
        if (style.alignItems === 'flex-start') {
            node.setAlignItems(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.ALIGN_FLEX_START);
        }
        if (style.alignItems === 'center') {
            node.setAlignItems(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.ALIGN_CENTER);
        }
        if (style.alignItems === 'flex-end') {
            node.setAlignItems(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.ALIGN_FLEX_END);
        }
    }
    if ('alignSelf' in style) {
        if (style.alignSelf === 'auto' || !style.alignSelf) {
            node.setAlignSelf(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.ALIGN_AUTO);
        }
        if (style.alignSelf === 'flex-start') {
            node.setAlignSelf(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.ALIGN_FLEX_START);
        }
        if (style.alignSelf === 'center') {
            node.setAlignSelf(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.ALIGN_CENTER);
        }
        if (style.alignSelf === 'flex-end') {
            node.setAlignSelf(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.ALIGN_FLEX_END);
        }
    }
    if ('justifyContent' in style) {
        if (style.justifyContent === 'flex-start' || !style.justifyContent) {
            node.setJustifyContent(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.JUSTIFY_FLEX_START);
        }
        if (style.justifyContent === 'center') {
            node.setJustifyContent(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.JUSTIFY_CENTER);
        }
        if (style.justifyContent === 'flex-end') {
            node.setJustifyContent(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.JUSTIFY_FLEX_END);
        }
        if (style.justifyContent === 'space-between') {
            node.setJustifyContent(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.JUSTIFY_SPACE_BETWEEN);
        }
        if (style.justifyContent === 'space-around') {
            node.setJustifyContent(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.JUSTIFY_SPACE_AROUND);
        }
        if (style.justifyContent === 'space-evenly') {
            node.setJustifyContent(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.JUSTIFY_SPACE_EVENLY);
        }
    }
};
const applyDimensionStyles = (node, style) => {
    if ('width' in style) {
        if (typeof style.width === 'number') {
            node.setWidth(style.width);
        }
        else if (typeof style.width === 'string') {
            node.setWidthPercent(Number.parseInt(style.width, 10));
        }
        else {
            node.setWidthAuto();
        }
    }
    if ('height' in style) {
        if (typeof style.height === 'number') {
            node.setHeight(style.height);
        }
        else if (typeof style.height === 'string') {
            node.setHeightPercent(Number.parseInt(style.height, 10));
        }
        else {
            node.setHeightAuto();
        }
    }
    if ('minWidth' in style) {
        if (typeof style.minWidth === 'string') {
            node.setMinWidthPercent(Number.parseInt(style.minWidth, 10));
        }
        else {
            node.setMinWidth(style.minWidth ?? 0);
        }
    }
    if ('minHeight' in style) {
        if (typeof style.minHeight === 'string') {
            node.setMinHeightPercent(Number.parseInt(style.minHeight, 10));
        }
        else {
            node.setMinHeight(style.minHeight ?? 0);
        }
    }
};
const applyDisplayStyles = (node, style) => {
    if ('display' in style) {
        node.setDisplay(style.display === 'flex' ? yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.DISPLAY_FLEX : yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.DISPLAY_NONE);
    }
};
const applyBorderStyles = (node, style) => {
    if ('borderStyle' in style) {
        const borderWidth = style.borderStyle ? 1 : 0;
        if (style.borderTop !== false) {
            node.setBorder(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_TOP, borderWidth);
        }
        if (style.borderBottom !== false) {
            node.setBorder(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_BOTTOM, borderWidth);
        }
        if (style.borderLeft !== false) {
            node.setBorder(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_LEFT, borderWidth);
        }
        if (style.borderRight !== false) {
            node.setBorder(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.EDGE_RIGHT, borderWidth);
        }
    }
};
const applyGapStyles = (node, style) => {
    if ('gap' in style) {
        node.setGap(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.GUTTER_ALL, style.gap ?? 0);
    }
    if ('columnGap' in style) {
        node.setGap(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.GUTTER_COLUMN, style.columnGap ?? 0);
    }
    if ('rowGap' in style) {
        node.setGap(yoga_layout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Ay.GUTTER_ROW, style.rowGap ?? 0);
    }
};
const styles = (node, style = {}) => {
    applyPositionStyles(node, style);
    applyMarginStyles(node, style);
    applyPaddingStyles(node, style);
    applyFlexStyles(node, style);
    applyDimensionStyles(node, style);
    applyDisplayStyles(node, style);
    applyBorderStyles(node, style);
    applyGapStyles(node, style);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (styles);
//# sourceMappingURL=styles.js.map
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "../ink/build/wrap-text.js":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var wrap_ansi__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/wrap-ansi@9.0.0/node_modules/wrap-ansi/index.js");
/* harmony import */ var cli_truncate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../node_modules/.pnpm/cli-truncate@4.0.0/node_modules/cli-truncate/index.js");


const cache = {};
const wrapText = (text, maxWidth, wrapType) => {
    const cacheKey = text + String(maxWidth) + String(wrapType);
    const cachedText = cache[cacheKey];
    if (cachedText) {
        return cachedText;
    }
    let wrappedText = text;
    if (wrapType === 'no-wrap') {
        // Return text as-is, letting the terminal handle wrapping
        wrappedText = text;
    }
    else if (wrapType === 'wrap') {
        wrappedText = (0,wrap_ansi__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)(text, maxWidth, {
            trim: false,
            hard: true,
        });
    }
    else if (wrapType.startsWith('truncate')) {
        let position = 'end';
        if (wrapType === 'truncate-middle') {
            position = 'middle';
        }
        if (wrapType === 'truncate-start') {
            position = 'start';
        }
        wrappedText = (0,cli_truncate__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)(text, maxWidth, { position });
    }
    cache[cacheKey] = wrappedText;
    return wrappedText;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (wrapText);
//# sourceMappingURL=wrap-text.js.map

/***/ })

};
;