"use strict";
exports.id = 769;
exports.ids = [769];
exports.modules = {

/***/ "./src/commands/login.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleLogin: () => (/* binding */ handleLogin)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../cursor-config/dist/index.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var _anysphere_proto_aiserver_v1_dashboard_pb_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../proto/dist/generated/aiserver/v1/dashboard_pb.js");
/* harmony import */ var _components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/components/login-ui.tsx");
/* harmony import */ var _privacy_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/privacy.ts");
/* harmony import */ var _utils_open_browser_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("./src/utils/open-browser.ts");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_2__, _components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__]);
([_anysphere_ink__WEBPACK_IMPORTED_MODULE_2__, _components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







function handleLogin(credentialManager, configProvider, dashboardClient) {
    return __awaiter(this, void 0, void 0, function* () {
        // Render the status component
        const { rerender } = (0,_anysphere_ink__WEBPACK_IMPORTED_MODULE_2__/* .render */ .XX)((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "starting" }));
        try {
            const loginManager = new _anysphere_cursor_config__WEBPACK_IMPORTED_MODULE_1__/* .LoginManager */ .Pl();
            const { metadata, loginUrl } = loginManager.startLogin();
            if ((0,_utils_open_browser_js__WEBPACK_IMPORTED_MODULE_6__/* .isLikelyToOpenBrowser */ .g)(loginUrl)) {
                rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "in-progress", message: `Waiting for browser authentication...\nIf your browser didn't open, use this link:\n${loginUrl}` }));
                try {
                    yield (0,_utils_open_browser_js__WEBPACK_IMPORTED_MODULE_6__/* .openBrowser */ .p)(loginUrl);
                }
                catch (_a) {
                    // ignore, likely in ssh session
                }
            }
            else {
                rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "in-progress", message: `Waiting for browser authentication...\nOpen a browser and navigate to this link: ${loginUrl}` }));
            }
            const authResult = yield loginManager.waitForResult(metadata);
            if (authResult && authResult.accessToken) {
                try {
                    yield credentialManager.setAuthentication(authResult.accessToken, authResult.refreshToken);
                    // Reset privacy cache like we do in logout
                    yield configProvider.transform((c) => (Object.assign(Object.assign({}, c), { privacyCache: undefined })));
                    // Pre-emptively refresh privacy cache in background, does not block.
                    (0,_privacy_js__WEBPACK_IMPORTED_MODULE_5__/* .maybeRefreshPrivacyCacheInBackground */ .H)({
                        credentialManager,
                        baseUrl: "https://api2.cursor.sh", // fine since it doesn't write to cache on failure, and it will try with the correct endpoint next time they do something
                        configProvider,
                    });
                    // Check if user has @anysphere.co email and auto-configure staging channel
                    let userEmail;
                    let stagingChannelConfigured = false;
                    if (dashboardClient) {
                        try {
                            const response = yield dashboardClient.getMe(new _anysphere_proto_aiserver_v1_dashboard_pb_js__WEBPACK_IMPORTED_MODULE_3__/* .GetMeRequest */ .Ewt({}));
                            userEmail = response.email;
                            // Auto-configure staging channel for @anysphere.co users
                            // Opt-in devs on all channels except 'lab', 'static', and 'prod-stable-internal'
                            const currentChannel = configProvider.get().channel;
                            if ((userEmail === null || userEmail === void 0 ? void 0 : userEmail.endsWith("@anysphere.co")) &&
                                currentChannel !== "lab" &&
                                currentChannel !== "static" &&
                                currentChannel !== "prod-stable-internal") {
                                yield configProvider.transform((c) => (Object.assign(Object.assign({}, c), { channel: "staging" })));
                                stagingChannelConfigured = true;
                            }
                        }
                        catch (_b) {
                            // Ignore errors getting user info - don't block login success
                        }
                    }
                    rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "success", message: `Authentication tokens stored securely.${stagingChannelConfigured ? " cursor-agent automatically configured to use staging channel." : ""}`, userInfo: userEmail ? { email: userEmail } : undefined }));
                }
                catch (_c) {
                    const message = `Failed to store authentication tokens.\nAccess token: ${authResult.accessToken}`;
                    rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "error", message: message }));
                }
            }
            else {
                rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "error", message: "Login failed or timed out." }));
                process.exit(1);
            }
        }
        catch (error) {
            rerender((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_login_ui_js__WEBPACK_IMPORTED_MODULE_4__/* .LoginStatus */ .a, { status: "error", message: `Login error: ${error}` }));
            process.exit(1);
        }
        process.exit(0);
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/components/login-ui.tsx":
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: () => (/* binding */ LogoutStatus),
/* harmony export */   a: () => (/* binding */ LoginStatus)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/jsx-runtime.js");
/* harmony import */ var _anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../ink/build/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../node_modules/.pnpm/react@19.1.0/node_modules/react/index.js");
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__]);
_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const LoginStatus = ({ status, message, userInfo, loginUrl }) => {
    const getStatusContent = () => {
        switch (status) {
            case "starting":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Starting login process..." }) }));
            case "in-progress":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", gap: 1, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Authenticating with Cursor..." }) }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: message }), loginUrl && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "gray", wrap: "no-wrap", children: loginUrl }))] }));
            case "success":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "green", children: "\u2713 " }), (userInfo === null || userInfo === void 0 ? void 0 : userInfo.email) ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: ["Logged in as ", userInfo.email] })) : (userInfo === null || userInfo === void 0 ? void 0 : userInfo.userId) ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: ["Logged in as user id ", userInfo.userId] })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Login successful!" }))] }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: message })] }));
            case "error":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: message }) }));
        }
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", padding: 1, children: getStatusContent() }));
};
const LogoutStatus = ({ status, message }) => {
    const getStatusContent = () => {
        switch (status) {
            case "starting":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Preparing to log out..." }) }));
            case "in-progress":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: "Logging out..." }) }));
            case "success":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "green", children: "\u2713 Logout successful" }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { children: message })] }));
            case "error":
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: "\u2717 Logout failed" }), message && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Text */ .EY, { color: "red", children: message })] }));
        }
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_anysphere_ink__WEBPACK_IMPORTED_MODULE_1__/* .Box */ .az, { flexDirection: "column", padding: 1, children: getStatusContent() }));
};

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ "./src/utils/open-browser.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   g: () => (/* binding */ isLikelyToOpenBrowser),
/* harmony export */   p: () => (/* binding */ openBrowser)
/* harmony export */ });
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("node:child_process");
/* harmony import */ var node_child_process__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_child_process__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _anysphere_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../utils/dist/index.js");


function isLikelyToOpenBrowser(url) {
    if (process.env.NO_OPEN_BROWSER) {
        return false;
    }
    if (process.env.SSH_TTY) {
        return false;
    }
    // Validate that the URL is a web link (http:// or https://)
    if (!isValidWebUrl(url)) {
        return false;
    }
    try {
        getBrowserInvocation(url);
        return true;
    }
    catch (_a) {
        return false;
    }
}
function getBrowserInvocation(url) {
    const platform = "darwin";
    let file;
    let urlArgs;
    if (platform === "darwin") {
        file = "open";
        urlArgs = [url];
    }
    else if (platform === "win32") {
        file = "powershell.exe";
        const psUrl = url.replace(/'/g, "''");
        urlArgs = [
            "-NoProfile",
            "-NonInteractive",
            "-WindowStyle",
            "Hidden",
            "-Command",
            `Start-Process '${psUrl}'`,
        ];
    }
    else {
        file = "xdg-open";
        urlArgs = [url];
    }
    const { cmd, args } = (0,_anysphere_utils__WEBPACK_IMPORTED_MODULE_1__/* .findActualExecutable */ .Ef)(file, urlArgs);
    if (cmd === file) {
        throw new Error("Can't find a way to open browser");
    }
    return { cmd, args };
}
function openBrowser(url) {
    // Validate that the URL is a web link (http:// or https://)
    if (!isValidWebUrl(url)) {
        return Promise.reject(new Error(`Invalid URL: Only web links (http:// and https://) are supported. Received: ${url}`));
    }
    if (process.env.NO_OPEN_BROWSER) {
        return Promise.reject(new Error("Browser opening disabled"));
    }
    if (process.env.SSH_TTY) {
        return Promise.reject(new Error(`Cannot open browser in SSH session`));
    }
    return new Promise((resolve, reject) => {
        const { cmd, args } = getBrowserInvocation(url);
        const child = (0,node_child_process__WEBPACK_IMPORTED_MODULE_0__.spawn)(cmd, args, { stdio: "ignore", windowsHide: true });
        child.once("error", err => {
            reject(new Error(`Failed to open browser: ${err.message}`));
        });
        // NB: We don't care when this process exits, only that it started
        // relatively successfully. xdg-open will block sometimes and that's Bad
        child.once("spawn", () => resolve());
    });
}
/**
 * Validates that a URL is a valid web link (http:// or https://).
 * This prevents opening potentially dangerous protocols like file://, javascript:, etc.
 */
function isValidWebUrl(url) {
    try {
        const parsed = new URL(url);
        return parsed.protocol === "http:" || parsed.protocol === "https:";
    }
    catch (_a) {
        // If URL parsing fails, it's not a valid URL
        return false;
    }
}


/***/ })

};
;