import"./index-0xg83y2p.js";function t(e){if(e==="zsh")process.stdout.write(`
export PATH="$HOME/.local/bin:$PATH"

if [[ -z "$CURSOR_RECORD_SESSION" ]]; then
  export CURSOR_RECORD_SESSION=1

  exec ~/.local/bin/cursor-agent record
fi

if [[ "$VSCODE_PROFILE_INITIALIZED" = "1" ]] && command -v cursor >/dev/null 2>&1; then
  source $(cursor --locate-shell-integration-path zsh)
fi

# Only execute cursor agent integration if we're in a TTY
if [[ -t 0 ]]; then

# Cursor Agent Terminal Capture Hooks using custom OSC 9999
# These hooks send custom OSC sequences that won't conflict with other tools

# Function to send custom OSC sequence
_cursor_agent_osc() {
  printf "\\\\033]9999;%s\\\\007" "$1"
}

# Hook: Before executing a command
_cursor_agent_preexec() {
  # Send the full command line
  _cursor_agent_osc "preexec;$1"
}

# Hook: After command execution, before prompt
_cursor_agent_precmd() {
  local last_exit_code=$?
  # Send exit code first
  _cursor_agent_osc "precmd;$last_exit_code"
  # Then send prompt signal
  _cursor_agent_osc "prompt"
}

# Register hooks
autoload -Uz add-zsh-hook
add-zsh-hook preexec _cursor_agent_preexec
add-zsh-hook precmd _cursor_agent_precmd

# Create a new chat session at the start of each shell session
if [[ -z "$CURSOR_AGENT_CHAT_ID" ]]; then
  export CURSOR_AGENT_CHAT_ID=$(cursor-agent create-chat)
fi

# Agent alias for quick access to cursor-agent with resume
agent() {
  AGENT_CLI_LOAD_HISTORY=false AGENT_CLI_HIDE_HEADER=true AGENT_CLI_HIDE_BANNER=true cursor-agent --resume $CURSOR_AGENT_CHAT_ID "$@" <"$TTY" >"$TTY" 2>&1
}


please-fix() {
  if [[ ! -f "$CURSOR_AGENT_COMPLETED_PATH" ]]; then
    echo "Error: No command history available, did you run a command?"
    return 1
  fi
  local completed
  completed=$(<$CURSOR_AGENT_COMPLETED_PATH)
  local command exit_code output
  command=$(head -n 1 $CURSOR_AGENT_COMPLETED_PATH)
  exit_code=$(tail -n 1 $CURSOR_AGENT_COMPLETED_PATH)
  # Get all lines except first and last as output
  output=$(sed '1d;$d' $CURSOR_AGENT_COMPLETED_PATH)

	print ""

  # Output is wrapped in triple backticks for formatting
  AGENT_CLI_LOAD_HISTORY=false AGENT_CLI_HIDE_PROMPT_BAR=true AGENT_CLI_EXIT_ON_COMPLETION=true AGENT_CLI_HIDE_USER_MESSAGES=true AGENT_CLI_HIDE_HEADER=true AGENT_CLI_HIDE_BANNER=true cursor-agent --resume $CURSOR_AGENT_CHAT_ID --model auto "$(printf "I just ran the command: \\"%s\\", which exited with code %s. The output was:\\n\\n%s\\n\\nPlease help me fix it." "$command" "$exit_code" "$output")"
}

# Track if last command failed for please-fix suggestion
_last_command_failed=0
_command_was_executed=0

# Hook to track command failures (combined with cursor agent hook)
_cursor_fix_precmd() {
  local last_exit_code=$?
  if [[ $last_exit_code -ne 0 && -n "$CURSOR_AGENT_COMPLETED_PATH" && $_command_was_executed -eq 1 ]]; then
    _last_command_failed=1
    echo "\\x1b[90m\uD83D\uDCA1 Command failed with exit code $last_exit_code. Press Enter to fix.\\x1b[0m"
  else
    _last_command_failed=0
  fi
  _command_was_executed=0
}

# Hook to handle empty commands
_cursor_fix_preexec() {
  _last_command_failed=0
  _command_was_executed=1
}

# Register please-fix hooks
autoload -Uz add-zsh-hook
add-zsh-hook precmd _cursor_fix_precmd
add-zsh-hook preexec _cursor_fix_preexec

## ---- Agent command streaming mode (Cursor Agent) ----

# Preserve the original Enter handler
zle -A accept-line .orig-accept-line

# Mode: 0 = normal zsh, 1 = send buffer as prompt to cursor-agent
zsh_agent_mode=0

toggle-agent-mode() {
  (( zsh_agent_mode ^= 1 ))
  zle -M "Agent mode: $([ $zsh_agent_mode -eq 1 ] && echo on || echo off)"
}
zle -N toggle-agent-mode

# Tab wrapper: at the beginning of the current line, toggle; otherwise perform normal completion
tab-toggle-or-complete() {
  # Beginning-of-line if nothing to the left or previous char is a newline (supports multiline buffers)
  if [[ -z $LBUFFER || \${LBUFFER[-1]} == $'\\n' ]]; then
    toggle-agent-mode
  else
    zle expand-or-complete
  fi
}
zle -N tab-toggle-or-complete
# Bind only in insert keymaps to avoid interfering with menu selection keymap
bindkey -M emacs '^I' tab-toggle-or-complete
bindkey -M viins '^I' tab-toggle-or-complete

# Combined Enter dispatcher: handles please-fix, agent mode, and normal accept-line
please-fix-or-accept-line() {
  # First check if we should handle please-fix on empty input
  if [[ -z "$BUFFER" && $_last_command_failed -eq 1 ]]; then
    BUFFER="please-fix"
    _last_command_failed=0
    zle .orig-accept-line
    return
  fi

  # Then check if we're in agent mode
  if (( zsh_agent_mode )); then
    local prompt_text
    prompt_text="$BUFFER"
    if [[ -z $prompt_text ]]; then
      zle .orig-accept-line
      return
    fi

    # Keep original input in history
    print -s -- "$prompt_text"

    # Clear editing line and leave ZLE display before streaming
    zle -I

    print ""

    # Ensure we start on a fresh line, stream directly to the TTY so it persists
    { AGENT_CLI_LOAD_HISTORY=false AGENT_CLI_HIDE_PROMPT_BAR=true AGENT_CLI_EXIT_ON_COMPLETION=true AGENT_CLI_HIDE_USER_MESSAGES=true AGENT_CLI_HIDE_HEADER=true AGENT_CLI_HIDE_BANNER=true cursor-agent --model auto --resume $CURSOR_AGENT_CHAT_ID "$prompt_text" <"$TTY" >"$TTY" 2>&1; }
    local agent_st=$?

    # Move the cursor up by one row
    print -n "\\x1b[1A"

    # Redraw a clean prompt
    CURSOR=0
    BUFFER=""
    zle -R -c
    zle reset-prompt
    return $agent_st
  else
    # Normal accept-line behavior
    zle .orig-accept-line
  fi
}

# Create the widget and bind it
zle -N please-fix-or-accept-line

# Bind Enter key to the integrated handler
bindkey '^M' please-fix-or-accept-line

fi # End TTY check
`);else throw new Error(`Unsupported shell: ${e}`)}export{t as handleShellIntegration};
