import"./index-ezqehx55.js";import{createServer as C}from"http";import{tmpdir as E}from"os";import{mkdtempSync as k,appendFileSync as N,writeFileSync as j,readFileSync as B}from"fs";import{join as x}from"path";import{EventEmitter as M}from"events";var w=`<!DOCTYPE html>
<html>
<head>
<meta charset='utf-8'/>
<title>Cursor Agent Debug</title>
<style>
  html,body { height:100%; }
  body { font-family: monospace; background:#111; color:#eee; margin:0; padding:0; overflow-y:scroll; }
  /* Global scrollbar styling */
  html { scrollbar-color:#333 #111; scrollbar-width:thin; }
  ::-webkit-scrollbar { width:10px; background:#111; }
  ::-webkit-scrollbar-track { background:#111; }
  ::-webkit-scrollbar-thumb { background:#333; border-radius:4px; }
  ::-webkit-scrollbar-thumb:hover { background:#444; }
  #log { font-size:12px; line-height:1.35; padding:12px; font-family: SFMono-Regular,Consolas,'Liberation Mono',Menlo,monospace; white-space:pre-wrap; }
  header { background:#222; padding:6px 12px; font-size:13px; color:#9cf; border-bottom:1px solid #333; display:flex; gap:12px; align-items:center; position:sticky; top:0; z-index:10; }
  button, select { background:#333; color:#eee; border:1px solid #444; padding:4px 8px; cursor:pointer; font-size:12px; }
  button:hover, select:hover { background:#444; }
  .status { font-size:11px; color:#888; margin-left:8px; }
  #log .row { font-size:12px; line-height:1.3; white-space:normal; border-left:3px solid #222; padding:4px 6px 6px 6px; margin:0 0 6px 0; background:#121212; }
  #log .row.collapsed { border-color:#333; }
  #log .row .meta { color:#666; display:flex; gap:6px; align-items:center; }
  #log .row .t { color:#666; }
  #log .row .lvl { font-weight:600; padding:0 2px; border-radius:2px; }
  #log .row .lvl-info { color:#9cf; }
  #log .row .lvl-warn { color:#f8d66b; }
  #log .row .lvl-error { color:#ff6b6b; }
  #log .row .lvl-debug { color:#888; }
  #log .row pre.json { margin:4px 0 0 0; padding:4px 6px; background:#1c1c1c; border:1px solid #262626; overflow:auto; }
  #log .row.collapsed pre.json { display:none; }
  #log .row .single-line { display:none; }
  #log .row.collapsed .single-line { display:inline; color:#bbb; }
  #log .hint { display:none; }
</style>
</head>
<body>
<header>
  <div>Cursor Agent Debug Session</div>
  <div class='status' id='status'>connecting…</div>
  <div style='flex:1'></div>
  <button onclick='window.download()'>Download</button>
  <button onclick='window.clearLog()'>Clear (view)</button>
</header>
<div id='log'></div>
<script>(function(){'use strict';var logEl=document.getElementById('log');var statusEl=document.getElementById('status');var headerEl=document.querySelector('header');var controls=document.createElement('div');controls.style.display='flex';controls.style.gap='8px';controls.style.alignItems='center';var modeBtn=document.createElement('button');modeBtn.textContent='Raw';var levelSel=document.createElement('select');['ALL','INFO','WARN','ERROR','DEBUG'].forEach(function(l){var o=document.createElement('option');o.value=l;o.textContent=l;levelSel.appendChild(o);});controls.appendChild(modeBtn);controls.appendChild(levelSel);if(headerEl&&headerEl.children.length>=2){headerEl.insertBefore(controls,headerEl.children[headerEl.children.length-2]);}var prettyMode=true;var levelFilter='ALL';var lines=[];function atBottom(){return(window.innerHeight+window.scrollY)>=(document.body.offsetHeight-4);}function classify(raw){var pl={raw:raw,obj:undefined,ts:undefined,level:undefined,msg:undefined};var o;try{o=JSON.parse(raw);if(o&&typeof o==='object'&&o.data!==undefined&&(o.event||o.level)){pl.obj=o.data;pl.level=String(o.level||'').toUpperCase();pl.msg=o.event||'';pl.ts=new Date().toISOString();}else{pl.obj=o;pl.level=String(o.logLevelName||o.level||'').toUpperCase();pl.ts=o.date||o.time||o.timestamp||o.ts;if(!pl.ts){var m=raw.match(/\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3,}Z/);if(m)pl.ts=m[0];}if(Array.isArray(o.argumentsArray)&&o.argumentsArray.length){pl.msg=o.argumentsArray.map(function(a){if(typeof a==='string')return a;try{return JSON.stringify(a);}catch{return String(a);}}).join(' ');}else if(o.event){pl.msg=o.event;}}}catch{var m2=raw.match(/^\\[(\\d{4}-\\d{2}-\\d{2}T[^\\]]+)\\]\\s*(.*)$/);if(m2){pl.ts=m2[1];pl.msg=m2[2];}}if(!pl.msg)pl.msg=raw;return pl;}function oneLineJSON(obj){try{return JSON.stringify(obj);}catch(e){return String(obj);}}function render(){if(!prettyMode){logEl.textContent=lines.map(function(l){return l.raw;}).join('\\n');return;}logEl.innerHTML='';for(var i=0;i<lines.length;i++){var pl=lines[i];if(levelFilter!=='ALL'&&(pl.level||'')!==levelFilter)continue;var row=document.createElement('div');row.className='row';var meta=document.createElement('div');meta.className='meta';var t=document.createElement('span');t.className='t';t.textContent=pl.ts?pl.ts.replace(/Z$/,''):'';var lvl=document.createElement('span');lvl.className='lvl '+(pl.level?('lvl-'+pl.level.toLowerCase()):'lvl-unknown');lvl.textContent=pl.level||'';var hint=document.createElement('span');hint.className='hint';hint.textContent='(click to collapse)';meta.appendChild(t);meta.appendChild(document.createTextNode(' '));meta.appendChild(lvl);row.appendChild(meta);if(pl.obj){if(pl.msg){meta.appendChild(document.createTextNode(' '));var msgSpan=document.createElement('span');msgSpan.textContent=pl.msg;msgSpan.style.color='#bbb';meta.appendChild(msgSpan);}var pre=document.createElement('pre');pre.className='json';pre.textContent=JSON.stringify(pl.obj,null,2);var single=document.createElement('span');single.className='single-line';single.textContent=oneLineJSON(pl.obj);row.appendChild(pre);row.appendChild(single);}else{var msg=document.createElement('span');msg.className='msg';msg.textContent=pl.msg||pl.raw;row.appendChild(msg);}logEl.appendChild(row);} }function add(rawLine){var stick=atBottom();lines.push(classify(rawLine));render();if(stick)window.scrollTo(0,document.body.scrollHeight);}modeBtn.onclick=function(){prettyMode=!prettyMode;modeBtn.textContent=prettyMode?'Raw':'Pretty';render();};levelSel.onchange=function(){levelFilter=levelSel.value;render();};async function fetchFull(){try{var r=await fetch('log',{cache:'no-store'});if(r.ok){var txt=await r.text();lines.length=0;txt.split(/\\r?\\n/).filter(Boolean).forEach(function(l){lines.push(classify(l));});render();window.scrollTo(0,document.body.scrollHeight);}}catch(e){add('[fetchFull error] '+(e&&e.message?e.message:String(e)));}}fetchFull();var evt=new EventSource('events');evt.onopen=function(){if(statusEl)statusEl.textContent='live';};evt.onmessage=function(e){try{var line=JSON.parse(e.data);add(typeof line==='string'?line.trimEnd():line);}catch{add(e.data);}};evt.onerror=function(){if(statusEl)statusEl.textContent='error (retrying)';};window.download=function(){window.open('log','_blank');};window.clearLog=function(){lines.length=0;render();};})();</script>
</body>
</html>`;var e=null,g=new M;function L(o){return w}async function R(){if(e)return e;let o=x(E(),"cursor-agent-debug-"),c=k(o),r=x(c,"session.log"),i=process.env.CURSOR_AGENT_DEBUG_PORT,d=i?Number(i):43111,b=50;j(r,"--- Cursor Agent Debug Session "+new Date().toISOString()+` ---
`);let a=C((t,n)=>{try{if(!t.url){n.statusCode=404,n.end();return}if(t.url==="/"||t.url.startsWith("/index")){n.setHeader("Content-Type","text/html; charset=utf-8"),n.end(L(u()));return}if(t.url==="/log"){try{n.setHeader("Content-Type","text/plain; charset=utf-8"),n.end(B(r,"utf8"))}catch(l){n.statusCode=500,n.end(String(l))}return}if(t.url==="/events"){n.writeHead(200,{"Content-Type":"text/event-stream","Cache-Control":"no-cache",Connection:"keep-alive","Access-Control-Allow-Origin":"*"});let l=(s)=>{n.write("data: "+JSON.stringify(s)+`

`)};g.on("line",l),t.on("close",()=>g.off("line",l));return}n.statusCode=404,n.end("Not found")}catch(l){n.statusCode=500,n.end(String(l))}});function u(){let t=a.address();if(t&&typeof t==="object"&&"port"in t)return`http://127.0.0.1:${t.port}`;return"http://127.0.0.1:0"}let f=(t)=>{try{N(r,t.endsWith(`
`)?t:t+`
`,"utf8"),g.emit("line",t)}catch{}},y=(...t)=>{let n=t.map((l)=>{if(typeof l==="string")return l;try{return JSON.stringify(l)}catch{return String(l)}}).join(" ");f(`[${new Date().toISOString()}] ${n}`)},p=0,h=!1,v=await new Promise((t)=>{let n=(l)=>{a.once("error",(s)=>{if(s.code==="EADDRINUSE"&&p<b)p++,n(d+p);else h=!0,a.removeAllListeners("listening"),a.listen(0,"127.0.0.1"),a.once("listening",()=>t(a.address().port))}),a.once("listening",()=>{t(a.address().port)}),a.listen(l,"127.0.0.1")};n(d)});e={enabled:!0,directory:c,logFile:r,serverPort:v,get serverUrl(){return u()},append:f,log:y,stop:async()=>{return new Promise((t)=>a.close(()=>t()))}},e.append(JSON.stringify({event:"debug-session-start",port:v,basePort:d,attempts:p+1,ephemeralFallback:h,directory:c,logFile:r,pid:process.pid,startTime:new Date().toISOString()}));let m=()=>{if(e){try{a.close()}catch{}e=null}};return process.once("exit",m),process.once("SIGINT",m),process.once("SIGTERM",m),e}function G(){return!!e}function Y(){return e}function Z(...o){if(e)e.log(...o)}function $(...o){if(e){let c=o.map((i)=>{if(typeof i==="string")return i;try{return JSON.stringify(i)}catch{return String(i)}}).join(" "),r=new Error().stack?.split(`
`).slice(1).join(`
`)||"No stack trace available";e.append(`[${new Date().toISOString()}] ${c}
Stack trace:
${r}`)}}function S(o){if(e)e.append(o)}function U(o,c,r="DEBUG"){if(!e)return;let i={event:o,level:r,data:c};try{e.append(JSON.stringify(i))}catch(d){e.append(`[${new Date().toISOString()}] ${o} ${String(d)}`)}}export{S as pushDebugLogLine,G as isDebugEnabled,R as initDebug,Y as getDebugSession,$ as debugTrace,U as debugLogJSON,Z as debugLog};
export{R as wt,G as xt,Y as yt,Z as zt,$ as At,U as Bt};
